/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.jsonbeans;

import java.util.regex.Pattern;

public enum OutputType {
    json,
    javascript,
    minimal;

    private static Pattern javascriptPattern;
    private static Pattern minimalValuePattern;
    private static Pattern minimalNamePattern;

    public String quoteValue(Object object) {
        if (object == null || object instanceof Number || object instanceof Boolean) {
            return String.valueOf(object);
        }
        String string = String.valueOf(object).replace("\\", "\\\\");
        if (this == minimal && !string.equals("true") && !string.equals("false") && !string.equals("null") && minimalValuePattern.matcher(string).matches()) {
            return string;
        }
        return '\"' + string.replace("\"", "\\\"") + '\"';
    }

    public String quoteName(String string) {
        string = string.replace("\\", "\\\\");
        switch (this) {
            case minimal: {
                if (minimalNamePattern.matcher(string).matches()) {
                    return string;
                }
                return '\"' + string.replace("\"", "\\\"") + '\"';
            }
            case javascript: {
                if (javascriptPattern.matcher(string).matches()) {
                    return string;
                }
                return '\"' + string.replace("\"", "\\\"") + '\"';
            }
        }
        return '\"' + string.replace("\"", "\\\"") + '\"';
    }

    static {
        javascriptPattern = Pattern.compile("[a-zA-Z_$][a-zA-Z_$0-9]*");
        minimalValuePattern = Pattern.compile("[a-zA-Z_$][^:}\\], ]*");
        minimalNamePattern = Pattern.compile("[a-zA-Z0-9_$][^:}\\], ]*");
    }
}

