/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.jsonbeans;

import com.esotericsoftware.jsonbeans.Json;
import com.esotericsoftware.jsonbeans.JsonValue;
import java.util.ArrayList;

public class Test {
    public static void main(String[] stringArray) throws Exception {
        Person person = new Person();
        person.setName("Nate");
        person.setAge(31);
        ArrayList<PhoneNumber> arrayList = new ArrayList<PhoneNumber>();
        arrayList.add(new PhoneNumber("Home", "206-555-1234"));
        arrayList.add(new PhoneNumber("Work", "425-555-4321"));
        person.setNumbers(arrayList);
        Json json = new Json();
        json.setSerializer(PhoneNumber.class, new Json.Serializer<PhoneNumber>(){

            @Override
            public void write(Json json, PhoneNumber phoneNumber, Class clazz) {
                json.writeObjectStart();
                json.writeValue(phoneNumber.name, phoneNumber.number);
                json.writeObjectEnd();
            }

            @Override
            public PhoneNumber read(Json json, JsonValue jsonValue, Class clazz) {
                PhoneNumber phoneNumber = new PhoneNumber();
                phoneNumber.name = jsonValue.child().name();
                phoneNumber.number = jsonValue.child().asString();
                return phoneNumber;
            }
        });
        json.setElementType(Person.class, "numbers", PhoneNumber.class);
        String string = json.prettyPrint(person);
        System.out.println(string);
        Person person2 = json.fromJson(Person.class, string);
    }

    public static class PhoneNumber {
        public String name;
        public String number;

        public PhoneNumber() {
        }

        public PhoneNumber(String string, String string2) {
            this.name = string;
            this.number = string2;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String string) {
            this.number = string;
        }
    }

    public static class Person {
        public String name;
        public int age;
        public ArrayList numbers;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int n) {
            this.age = n;
        }

        public ArrayList<PhoneNumber> getNumbers() {
            return this.numbers;
        }

        public void setNumbers(ArrayList<PhoneNumber> arrayList) {
            this.numbers = arrayList;
        }
    }
}

