/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;

public class DefaultArraySerializers {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectArraySerializer
    extends Serializer<Object[]> {
        private boolean elementsAreSameType;
        private boolean elementsCanBeNull = true;

        public ObjectArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Object[] objectArray) {
            if (objectArray == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(objectArray.length + 1, true);
            Class<?> clazz = objectArray.getClass().getComponentType();
            if (this.elementsAreSameType || Modifier.isFinal(clazz.getModifiers())) {
                Serializer serializer = kryo.getSerializer(clazz);
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    if (this.elementsCanBeNull) {
                        kryo.writeObjectOrNull(output, objectArray[i], serializer);
                        continue;
                    }
                    kryo.writeObject(output, objectArray[i], serializer);
                }
            } else {
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    kryo.writeClassAndObject(output, objectArray[i]);
                }
            }
        }

        @Override
        public Object[] read(Kryo kryo, Input input, Class<Object[]> clazz) {
            int n = input.readInt(true);
            if (n == 0) {
                return null;
            }
            Object[] objectArray = (Object[])Array.newInstance(clazz.getComponentType(), n - 1);
            kryo.reference(objectArray);
            Class<?> clazz2 = objectArray.getClass().getComponentType();
            if (this.elementsAreSameType || Modifier.isFinal(clazz2.getModifiers())) {
                Serializer serializer = kryo.getSerializer(clazz2);
                int n2 = objectArray.length;
                for (int i = 0; i < n2; ++i) {
                    objectArray[i] = this.elementsCanBeNull ? kryo.readObjectOrNull(input, clazz2, serializer) : kryo.readObject(input, clazz2, serializer);
                }
            } else {
                int n3 = objectArray.length;
                for (int i = 0; i < n3; ++i) {
                    objectArray[i] = kryo.readClassAndObject(input);
                }
            }
            return objectArray;
        }

        @Override
        public Object[] copy(Kryo kryo, Object[] objectArray) {
            Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), objectArray.length);
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
            return objectArray2;
        }

        public void setElementsCanBeNull(boolean bl) {
            this.elementsCanBeNull = bl;
        }

        public void setElementsAreSameType(boolean bl) {
            this.elementsAreSameType = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringArraySerializer
    extends Serializer<String[]> {
        public StringArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, String[] stringArray) {
            if (stringArray == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(stringArray.length + 1, true);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                output.writeString(stringArray[i]);
            }
        }

        @Override
        public String[] read(Kryo kryo, Input input, Class<String[]> clazz) {
            int n = input.readInt(true);
            if (n == 0) {
                return null;
            }
            String[] stringArray = new String[--n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = input.readString();
            }
            return stringArray;
        }

        @Override
        public String[] copy(Kryo kryo, String[] stringArray) {
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
            return stringArray2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BooleanArraySerializer
    extends Serializer<boolean[]> {
        public BooleanArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, boolean[] blArray) {
            if (blArray == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(blArray.length + 1, true);
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                output.writeBoolean(blArray[i]);
            }
        }

        @Override
        public boolean[] read(Kryo kryo, Input input, Class<boolean[]> clazz) {
            int n = input.readInt(true);
            if (n == 0) {
                return null;
            }
            boolean[] blArray = new boolean[--n];
            for (int i = 0; i < n; ++i) {
                blArray[i] = input.readBoolean();
            }
            return blArray;
        }

        @Override
        public boolean[] copy(Kryo kryo, boolean[] blArray) {
            boolean[] blArray2 = new boolean[blArray.length];
            System.arraycopy(blArray, 0, blArray2, 0, blArray2.length);
            return blArray2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleArraySerializer
    extends Serializer<double[]> {
        public DoubleArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, double[] dArray) {
            if (dArray == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(dArray.length + 1, true);
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                output.writeDouble(dArray[i]);
            }
        }

        @Override
        public double[] read(Kryo kryo, Input input, Class<double[]> clazz) {
            int n = input.readInt(true);
            if (n == 0) {
                return null;
            }
            double[] dArray = new double[--n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = input.readDouble();
            }
            return dArray;
        }

        @Override
        public double[] copy(Kryo kryo, double[] dArray) {
            double[] dArray2 = new double[dArray.length];
            System.arraycopy(dArray, 0, dArray2, 0, dArray2.length);
            return dArray2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CharArraySerializer
    extends Serializer<char[]> {
        public CharArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, char[] cArray) {
            if (cArray == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(cArray.length + 1, true);
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                output.writeChar(cArray[i]);
            }
        }

        @Override
        public char[] read(Kryo kryo, Input input, Class<char[]> clazz) {
            int n = input.readInt(true);
            if (n == 0) {
                return null;
            }
            char[] cArray = new char[--n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = input.readChar();
            }
            return cArray;
        }

        @Override
        public char[] copy(Kryo kryo, char[] cArray) {
            char[] cArray2 = new char[cArray.length];
            System.arraycopy(cArray, 0, cArray2, 0, cArray2.length);
            return cArray2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShortArraySerializer
    extends Serializer<short[]> {
        public ShortArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, short[] sArray) {
            if (sArray == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(sArray.length + 1, true);
            int n = sArray.length;
            for (int i = 0; i < n; ++i) {
                output.writeShort(sArray[i]);
            }
        }

        @Override
        public short[] read(Kryo kryo, Input input, Class<short[]> clazz) {
            int n = input.readInt(true);
            if (n == 0) {
                return null;
            }
            short[] sArray = new short[--n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = input.readShort();
            }
            return sArray;
        }

        @Override
        public short[] copy(Kryo kryo, short[] sArray) {
            short[] sArray2 = new short[sArray.length];
            System.arraycopy(sArray, 0, sArray2, 0, sArray2.length);
            return sArray2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongArraySerializer
    extends Serializer<long[]> {
        public LongArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, long[] lArray) {
            if (lArray == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(lArray.length + 1, true);
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                output.writeLong(lArray[i], false);
            }
        }

        @Override
        public long[] read(Kryo kryo, Input input, Class<long[]> clazz) {
            int n = input.readInt(true);
            if (n == 0) {
                return null;
            }
            long[] lArray = new long[--n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = input.readLong(false);
            }
            return lArray;
        }

        @Override
        public long[] copy(Kryo kryo, long[] lArray) {
            long[] lArray2 = new long[lArray.length];
            System.arraycopy(lArray, 0, lArray2, 0, lArray2.length);
            return lArray2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FloatArraySerializer
    extends Serializer<float[]> {
        public FloatArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, float[] fArray) {
            if (fArray == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(fArray.length + 1, true);
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                output.writeFloat(fArray[i]);
            }
        }

        @Override
        public float[] read(Kryo kryo, Input input, Class<float[]> clazz) {
            int n = input.readInt(true);
            if (n == 0) {
                return null;
            }
            float[] fArray = new float[--n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = input.readFloat();
            }
            return fArray;
        }

        @Override
        public float[] copy(Kryo kryo, float[] fArray) {
            float[] fArray2 = new float[fArray.length];
            System.arraycopy(fArray, 0, fArray2, 0, fArray2.length);
            return fArray2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntArraySerializer
    extends Serializer<int[]> {
        public IntArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, int[] nArray) {
            if (nArray == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(nArray.length + 1, true);
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                output.writeInt(nArray[i], false);
            }
        }

        @Override
        public int[] read(Kryo kryo, Input input, Class<int[]> clazz) {
            int n = input.readInt(true);
            if (n == 0) {
                return null;
            }
            int[] nArray = new int[--n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = input.readInt(false);
            }
            return nArray;
        }

        @Override
        public int[] copy(Kryo kryo, int[] nArray) {
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
            return nArray2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteArraySerializer
    extends Serializer<byte[]> {
        public ByteArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, byte[] byArray) {
            if (byArray == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(byArray.length + 1, true);
            output.writeBytes(byArray);
        }

        @Override
        public byte[] read(Kryo kryo, Input input, Class<byte[]> clazz) {
            int n = input.readInt(true);
            if (n == 0) {
                return null;
            }
            return input.readBytes(n - 1);
        }

        @Override
        public byte[] copy(Kryo kryo, byte[] byArray) {
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            return byArray2;
        }
    }
}

