/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.ByteBufferInputStream;
import com.esotericsoftware.kryo.io.ByteBufferOutputStream;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.Serialization;
import java.nio.ByteBuffer;

public class KryoSerialization
implements Serialization {
    private final Kryo kryo;
    private final Input input;
    private final Output output;
    private final ByteBufferInputStream byteBufferInputStream = new ByteBufferInputStream();
    private final ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream();

    public KryoSerialization() {
        this(new Kryo());
        this.kryo.setReferences(false);
        this.kryo.setRegistrationRequired(true);
    }

    public KryoSerialization(Kryo kryo) {
        this.kryo = kryo;
        kryo.register(FrameworkMessage.RegisterTCP.class);
        kryo.register(FrameworkMessage.RegisterUDP.class);
        kryo.register(FrameworkMessage.KeepAlive.class);
        kryo.register(FrameworkMessage.DiscoverHost.class);
        kryo.register(FrameworkMessage.Ping.class);
        this.input = new Input(this.byteBufferInputStream, 512);
        this.output = new Output(this.byteBufferOutputStream, 512);
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    @Override
    public synchronized void write(Connection connection, ByteBuffer byteBuffer, Object object) {
        this.byteBufferOutputStream.setByteBuffer(byteBuffer);
        this.kryo.getContext().put("connection", connection);
        this.kryo.writeClassAndObject(this.output, object);
        this.output.flush();
    }

    @Override
    public synchronized Object read(Connection connection, ByteBuffer byteBuffer) {
        this.byteBufferInputStream.setByteBuffer(byteBuffer);
        this.input.setInputStream(this.byteBufferInputStream);
        this.kryo.getContext().put("connection", connection);
        return this.kryo.readClassAndObject(this.input);
    }

    @Override
    public void writeLength(ByteBuffer byteBuffer, int n) {
        byteBuffer.putInt(n);
    }

    @Override
    public int readLength(ByteBuffer byteBuffer) {
        return byteBuffer.getInt();
    }

    @Override
    public int getLengthLength() {
        return 4;
    }
}

