/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet;

import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.KryoNetException;
import com.esotericsoftware.kryonet.Serialization;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

class TcpConnection {
    private static final int IPTOS_LOWDELAY = 16;
    SocketChannel socketChannel;
    int keepAliveMillis = 8000;
    final ByteBuffer readBuffer;
    final ByteBuffer writeBuffer;
    boolean bufferPositionFix;
    int timeoutMillis = 12000;
    float idleThreshold = 0.1f;
    final Serialization serialization;
    private SelectionKey selectionKey;
    private volatile long lastWriteTime;
    private volatile long lastReadTime;
    private int currentObjectLength;
    private final Object writeLock = new Object();

    public TcpConnection(Serialization serialization, int n, int n2) {
        this.serialization = serialization;
        this.writeBuffer = ByteBuffer.allocate(n);
        this.readBuffer = ByteBuffer.allocate(n2);
        this.readBuffer.flip();
    }

    public SelectionKey accept(Selector selector, SocketChannel socketChannel) throws IOException {
        this.writeBuffer.clear();
        this.readBuffer.clear();
        this.readBuffer.flip();
        this.currentObjectLength = 0;
        try {
            this.socketChannel = socketChannel;
            socketChannel.configureBlocking(false);
            Socket socket = socketChannel.socket();
            socket.setTcpNoDelay(true);
            this.selectionKey = socketChannel.register(selector, 1);
            this.lastReadTime = this.lastWriteTime = System.currentTimeMillis();
            return this.selectionKey;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    public void connect(Selector selector, SocketAddress socketAddress, int n) throws IOException {
        this.close();
        this.writeBuffer.clear();
        this.readBuffer.clear();
        this.readBuffer.flip();
        this.currentObjectLength = 0;
        try {
            SocketChannel socketChannel = selector.provider().openSocketChannel();
            Socket socket = socketChannel.socket();
            socket.setTcpNoDelay(true);
            socket.connect(socketAddress, n);
            socketChannel.configureBlocking(false);
            this.socketChannel = socketChannel;
            this.selectionKey = socketChannel.register(selector, 1);
            this.selectionKey.attach(this);
            this.lastReadTime = this.lastWriteTime = System.currentTimeMillis();
        }
        catch (IOException iOException) {
            this.close();
            IOException iOException2 = new IOException("Unable to connect to: " + socketAddress);
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    public Object readObject(Connection connection) throws IOException {
        Object object;
        int n;
        int n2;
        SocketChannel socketChannel = this.socketChannel;
        if (socketChannel == null) {
            throw new SocketException("Connection is closed.");
        }
        if (this.currentObjectLength == 0) {
            n2 = this.serialization.getLengthLength();
            if (this.readBuffer.remaining() < n2) {
                this.readBuffer.compact();
                n = socketChannel.read(this.readBuffer);
                this.readBuffer.flip();
                if (n == -1) {
                    throw new SocketException("Connection is closed.");
                }
                this.lastReadTime = System.currentTimeMillis();
                if (this.readBuffer.remaining() < n2) {
                    return null;
                }
            }
            this.currentObjectLength = this.serialization.readLength(this.readBuffer);
            if (this.currentObjectLength <= 0) {
                throw new KryoNetException("Invalid object length: " + this.currentObjectLength);
            }
            if (this.currentObjectLength > this.readBuffer.capacity()) {
                throw new KryoNetException("Unable to read object larger than read buffer: " + this.currentObjectLength);
            }
        }
        n2 = this.currentObjectLength;
        if (this.readBuffer.remaining() < n2) {
            this.readBuffer.compact();
            n = socketChannel.read(this.readBuffer);
            this.readBuffer.flip();
            if (n == -1) {
                throw new SocketException("Connection is closed.");
            }
            this.lastReadTime = System.currentTimeMillis();
            if (this.readBuffer.remaining() < n2) {
                return null;
            }
        }
        this.currentObjectLength = 0;
        n = this.readBuffer.position();
        int n3 = this.readBuffer.limit();
        this.readBuffer.limit(n + n2);
        try {
            object = this.serialization.read(connection, this.readBuffer);
        }
        catch (Exception exception) {
            throw new KryoNetException("Error during deserialization.", exception);
        }
        this.readBuffer.limit(n3);
        if (this.readBuffer.position() - n != n2) {
            throw new KryoNetException("Incorrect number of bytes (" + (n + n2 - this.readBuffer.position()) + " remaining) used to deserialize object: " + object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOperation() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.writeToSocket()) {
                this.selectionKey.interestOps(1);
            }
            this.lastWriteTime = System.currentTimeMillis();
        }
    }

    private boolean writeToSocket() throws IOException {
        SocketChannel socketChannel = this.socketChannel;
        if (socketChannel == null) {
            throw new SocketException("Connection is closed.");
        }
        ByteBuffer byteBuffer = this.writeBuffer;
        byteBuffer.flip();
        while (byteBuffer.hasRemaining()) {
            if (this.bufferPositionFix) {
                byteBuffer.compact();
                byteBuffer.flip();
            }
            if (socketChannel.write(byteBuffer) != 0) continue;
        }
        byteBuffer.compact();
        return byteBuffer.position() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(Connection connection, Object object) throws IOException {
        SocketChannel socketChannel = this.socketChannel;
        if (socketChannel == null) {
            throw new SocketException("Connection is closed.");
        }
        Object object2 = this.writeLock;
        synchronized (object2) {
            int n = this.writeBuffer.position();
            int n2 = this.serialization.getLengthLength();
            this.writeBuffer.position(this.writeBuffer.position() + n2);
            try {
                this.serialization.write(connection, this.writeBuffer, object);
            }
            catch (KryoNetException kryoNetException) {
                throw new KryoNetException("Error serializing object of type: " + object.getClass().getName(), kryoNetException);
            }
            int n3 = this.writeBuffer.position();
            this.writeBuffer.position(n);
            this.serialization.writeLength(this.writeBuffer, n3 - n2 - n);
            this.writeBuffer.position(n3);
            if (n == 0 && !this.writeToSocket()) {
                this.selectionKey.interestOps(5);
            } else {
                this.selectionKey.selector().wakeup();
            }
            this.lastWriteTime = System.currentTimeMillis();
            return n3 - n;
        }
    }

    public void close() {
        try {
            if (this.socketChannel != null) {
                this.socketChannel.close();
                this.socketChannel = null;
                if (this.selectionKey != null) {
                    this.selectionKey.selector().wakeup();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean needsKeepAlive(long l) {
        return this.socketChannel != null && this.keepAliveMillis > 0 && l - this.lastWriteTime > (long)this.keepAliveMillis;
    }

    public boolean isTimedOut(long l) {
        return this.socketChannel != null && this.timeoutMillis > 0 && l - this.lastReadTime > (long)this.timeoutMillis;
    }
}

