/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet.rmi;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.util.IntMap;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.kryonet.rmi.RemoteObject;
import com.esotericsoftware.kryonet.rmi.TimeoutException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ObjectSpace {
    private static final byte kReturnValMask = -128;
    private static final byte kReturnExMask = 64;
    private static final Object instancesLock = new Object();
    static ObjectSpace[] instances = new ObjectSpace[0];
    private static final HashMap<Class, CachedMethod[]> methodCache = new HashMap();
    final IntMap idToObject = new IntMap();
    Connection[] connections = new Connection[0];
    final Object connectionsLock = new Object();
    Executor executor;
    private final Listener invokeListener = new Listener(){

        @Override
        public void received(final Connection connection, Object object) {
            if (!(object instanceof InvokeMethod)) {
                return;
            }
            if (ObjectSpace.this.connections != null) {
                int n;
                int n2 = ObjectSpace.this.connections.length;
                for (n = 0; n < n2 && connection != ObjectSpace.this.connections[n]; ++n) {
                }
                if (n == n2) {
                    return;
                }
            }
            final InvokeMethod invokeMethod = (InvokeMethod)object;
            final Object v = ObjectSpace.this.idToObject.get(invokeMethod.objectID);
            if (v == null) {
                return;
            }
            if (ObjectSpace.this.executor == null) {
                ObjectSpace.this.invoke(connection, v, invokeMethod);
            } else {
                ObjectSpace.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ObjectSpace.this.invoke(connection, v, invokeMethod);
                    }
                });
            }
        }

        @Override
        public void disconnected(Connection connection) {
            ObjectSpace.this.removeConnection(connection);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSpace() {
        Object object = instancesLock;
        synchronized (object) {
            ObjectSpace[] objectSpaceArray = instances;
            ObjectSpace[] objectSpaceArray2 = new ObjectSpace[objectSpaceArray.length + 1];
            objectSpaceArray2[0] = this;
            System.arraycopy(objectSpaceArray, 0, objectSpaceArray2, 1, objectSpaceArray.length);
            instances = objectSpaceArray2;
        }
    }

    public ObjectSpace(Connection connection) {
        this();
        this.addConnection(connection);
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void register(int n, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        this.idToObject.put(n, object);
    }

    public void remove(int n) {
        Object v = this.idToObject.remove(n);
    }

    public void remove(Object object) {
        if (!this.idToObject.containsValue(object, true)) {
            return;
        }
        int n = this.idToObject.findKey(object, true, -1);
        this.idToObject.remove(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Connection[] connectionArray = this.connections;
        for (int i = 0; i < connectionArray.length; ++i) {
            connectionArray[i].removeListener(this.invokeListener);
        }
        Object object = instancesLock;
        synchronized (object) {
            ArrayList<ObjectSpace> arrayList = new ArrayList<ObjectSpace>(Arrays.asList(instances));
            arrayList.remove(this);
            instances = arrayList.toArray(new ObjectSpace[arrayList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null.");
        }
        Object object = this.connectionsLock;
        synchronized (object) {
            Connection[] connectionArray = new Connection[this.connections.length + 1];
            connectionArray[0] = connection;
            System.arraycopy(this.connections, 0, connectionArray, 1, this.connections.length);
            this.connections = connectionArray;
        }
        connection.addListener(this.invokeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null.");
        }
        connection.removeListener(this.invokeListener);
        Object object = this.connectionsLock;
        synchronized (object) {
            ArrayList<Connection> arrayList = new ArrayList<Connection>(Arrays.asList(this.connections));
            arrayList.remove(connection);
            this.connections = arrayList.toArray(new Connection[arrayList.size()]);
        }
    }

    protected void invoke(Connection connection, Object object, InvokeMethod invokeMethod) {
        byte by = invokeMethod.responseID;
        boolean bl = (by & 0xFFFFFF80) == -128;
        boolean bl2 = (by & 0x40) == 64;
        Object object2 = null;
        Method method = invokeMethod.method;
        try {
            object2 = method.invoke(object, invokeMethod.args);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (bl2) {
                object2 = invocationTargetException.getCause();
            }
            throw new RuntimeException("Error invoking method: " + method.getDeclaringClass().getName() + "." + method.getName(), invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error invoking method: " + method.getDeclaringClass().getName() + "." + method.getName(), exception);
        }
        if (by == 0) {
            return;
        }
        InvokeMethodResult invokeMethodResult = new InvokeMethodResult();
        invokeMethodResult.objectID = invokeMethod.objectID;
        invokeMethodResult.responseID = by;
        invokeMethodResult.result = !bl && !invokeMethod.method.getReturnType().isPrimitive() ? null : object2;
        int n = connection.sendTCP(invokeMethodResult);
    }

    public static <T> T getRemoteObject(Connection connection, int n, Class<T> clazz) {
        return (T)ObjectSpace.getRemoteObject(connection, n, new Class[]{clazz});
    }

    public static RemoteObject getRemoteObject(Connection connection, int n, Class ... classArray) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null.");
        }
        if (classArray == null) {
            throw new IllegalArgumentException("ifaces cannot be null.");
        }
        Class[] classArray2 = new Class[classArray.length + 1];
        classArray2[0] = RemoteObject.class;
        System.arraycopy(classArray, 0, classArray2, 1, classArray.length);
        return (RemoteObject)Proxy.newProxyInstance(ObjectSpace.class.getClassLoader(), classArray2, (InvocationHandler)new RemoteInvocationHandler(connection, n));
    }

    static CachedMethod[] getMethods(Kryo kryo, Class clazz) {
        Object object;
        int n;
        CachedMethod[] cachedMethodArray = methodCache.get(clazz);
        if (cachedMethodArray != null) {
            return cachedMethodArray;
        }
        ArrayList arrayList = new ArrayList();
        for (Class clazz2 = clazz; clazz2 != null && clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            Collections.addAll(arrayList, clazz2.getDeclaredMethods());
        }
        PriorityQueue<Method> priorityQueue = new PriorityQueue<Method>(Math.max(1, arrayList.size()), new Comparator<Method>(){

            @Override
            public int compare(Method method, Method method2) {
                Class<?>[] classArray;
                int n = method.getName().compareTo(method2.getName());
                if (n != 0) {
                    return n;
                }
                Class<?>[] classArray2 = method.getParameterTypes();
                if (classArray2.length > (classArray = method2.getParameterTypes()).length) {
                    return 1;
                }
                if (classArray2.length < classArray.length) {
                    return -1;
                }
                for (int i = 0; i < classArray2.length; ++i) {
                    n = classArray2[i].getName().compareTo(classArray[i].getName());
                    if (n == 0) continue;
                    return n;
                }
                throw new RuntimeException("Two methods with same signature!");
            }
        });
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = (Method)arrayList.get(n);
            int n3 = ((Method)object).getModifiers();
            if (Modifier.isStatic(n3) || Modifier.isPrivate(n3) || ((Method)object).isSynthetic()) continue;
            priorityQueue.add((Method)object);
        }
        n = priorityQueue.size();
        cachedMethodArray = new CachedMethod[n];
        for (n2 = 0; n2 < n; ++n2) {
            object = new CachedMethod();
            ((CachedMethod)object).method = priorityQueue.poll();
            Class<?>[] classArray = ((CachedMethod)object).method.getParameterTypes();
            ((CachedMethod)object).serializers = new Serializer[classArray.length];
            int n4 = classArray.length;
            for (int i = 0; i < n4; ++i) {
                if (!kryo.isFinal(classArray[i])) continue;
                ((CachedMethod)object).serializers[i] = kryo.getSerializer(classArray[i]);
            }
            cachedMethodArray[n2] = object;
        }
        methodCache.put(clazz, cachedMethodArray);
        return cachedMethodArray;
    }

    static Object getRegisteredObject(Connection connection, int n) {
        for (ObjectSpace objectSpace : instances) {
            Connection[] connectionArray = objectSpace.connections;
            for (int i = 0; i < connectionArray.length; ++i) {
                Object v;
                if (connectionArray[i] != connection || (v = objectSpace.idToObject.get(n)) == null) continue;
                return v;
            }
        }
        return null;
    }

    public static void registerClasses(Kryo kryo) {
        kryo.register(Object[].class);
        kryo.register(InvokeMethod.class);
        FieldSerializer fieldSerializer = (FieldSerializer)kryo.register(InvokeMethodResult.class).getSerializer();
        fieldSerializer.getField("objectID").setClass(Integer.TYPE, new Serializer<Integer>(){

            @Override
            public void write(Kryo kryo, Output output, Integer n) {
                output.writeInt(n, true);
            }

            @Override
            public Integer read(Kryo kryo, Input input, Class<Integer> clazz) {
                return input.readInt(true);
            }
        });
        kryo.register(InvocationHandler.class, new Serializer(){

            public void write(Kryo kryo, Output output, Object object) {
                RemoteInvocationHandler remoteInvocationHandler = (RemoteInvocationHandler)Proxy.getInvocationHandler(object);
                output.writeInt(remoteInvocationHandler.objectID, true);
            }

            public Object read(Kryo kryo, Input input, Class clazz) {
                int n = input.readInt(true);
                Connection connection = (Connection)kryo.getContext().get("connection");
                Object object = ObjectSpace.getRegisteredObject(connection, n);
                return object;
            }
        });
    }

    static class CachedMethod {
        Method method;
        Serializer[] serializers;

        CachedMethod() {
        }
    }

    public static class InvokeMethodResult
    implements FrameworkMessage {
        public int objectID;
        public byte responseID;
        public Object result;
    }

    public static class InvokeMethod
    implements FrameworkMessage,
    KryoSerializable {
        public int objectID;
        public Method method;
        public Object[] args;
        public byte responseID;

        @Override
        public void write(Kryo kryo, Output output) {
            int n;
            output.writeInt(this.objectID, true);
            int n2 = kryo.getRegistration(this.method.getDeclaringClass()).getId();
            output.writeInt(n2, true);
            CachedMethod[] cachedMethodArray = ObjectSpace.getMethods(kryo, this.method.getDeclaringClass());
            CachedMethod cachedMethod = null;
            int n3 = cachedMethodArray.length;
            for (n = 0; n < n3; ++n) {
                cachedMethod = cachedMethodArray[n];
                if (!cachedMethod.method.equals(this.method)) continue;
                output.writeByte(n);
                break;
            }
            n3 = cachedMethod.serializers.length;
            for (n = 0; n < n3; ++n) {
                Serializer serializer = cachedMethod.serializers[n];
                if (serializer != null) {
                    kryo.writeObjectOrNull(output, this.args[n], serializer);
                    continue;
                }
                kryo.writeClassAndObject(output, this.args[n]);
            }
            output.writeByte(this.responseID);
        }

        @Override
        public void read(Kryo kryo, Input input) {
            CachedMethod cachedMethod;
            this.objectID = input.readInt(true);
            int n = input.readInt(true);
            Class clazz = kryo.getRegistration(n).getType();
            byte by = input.readByte();
            try {
                cachedMethod = ObjectSpace.getMethods(kryo, clazz)[by];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new KryoException("Invalid method index " + by + " for class: " + clazz.getName());
            }
            this.method = cachedMethod.method;
            this.args = new Object[cachedMethod.serializers.length];
            int n2 = this.args.length;
            for (int i = 0; i < n2; ++i) {
                Serializer serializer = cachedMethod.serializers[i];
                this.args[i] = serializer != null ? kryo.readObjectOrNull(input, this.method.getParameterTypes()[i], serializer) : kryo.readClassAndObject(input);
            }
            this.responseID = input.readByte();
        }
    }

    private static class RemoteInvocationHandler
    implements InvocationHandler {
        private final Connection connection;
        final int objectID;
        private int timeoutMillis = 3000;
        private boolean nonBlocking = false;
        private boolean transmitReturnValue = true;
        private boolean transmitExceptions = true;
        private Byte lastResponseID;
        private byte nextResponseNum = 1;
        private Listener responseListener;
        final ReentrantLock lock = new ReentrantLock();
        final Condition responseCondition = this.lock.newCondition();
        final ConcurrentHashMap<Byte, InvokeMethodResult> responseTable = new ConcurrentHashMap();

        public RemoteInvocationHandler(Connection connection, final int n) {
            this.connection = connection;
            this.objectID = n;
            this.responseListener = new Listener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void received(Connection connection, Object object) {
                    if (!(object instanceof InvokeMethodResult)) {
                        return;
                    }
                    InvokeMethodResult invokeMethodResult = (InvokeMethodResult)object;
                    if (invokeMethodResult.objectID != n) {
                        return;
                    }
                    RemoteInvocationHandler.this.responseTable.put(invokeMethodResult.responseID, invokeMethodResult);
                    RemoteInvocationHandler.this.lock.lock();
                    try {
                        RemoteInvocationHandler.this.responseCondition.signalAll();
                    }
                    finally {
                        RemoteInvocationHandler.this.lock.unlock();
                    }
                }

                @Override
                public void disconnected(Connection connection) {
                    RemoteInvocationHandler.this.close();
                }
            };
            connection.addListener(this.responseListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Exception {
            int n;
            Class<?> clazz;
            boolean bl;
            if (method.getDeclaringClass() == RemoteObject.class) {
                String string = method.getName();
                if (string.equals("close")) {
                    this.close();
                    return null;
                }
                if (string.equals("setResponseTimeout")) {
                    this.timeoutMillis = (Integer)objectArray[0];
                    return null;
                }
                if (string.equals("setNonBlocking")) {
                    this.nonBlocking = (Boolean)objectArray[0];
                    return null;
                }
                if (string.equals("setTransmitReturnValue")) {
                    this.transmitReturnValue = (Boolean)objectArray[0];
                    return null;
                }
                if (string.equals("setTransmitExceptions")) {
                    this.transmitExceptions = (Boolean)objectArray[0];
                    return null;
                }
                if (string.equals("waitForLastResponse")) {
                    if (this.lastResponseID == null) {
                        throw new IllegalStateException("There is no last response to wait for.");
                    }
                    return this.waitForResponse(this.lastResponseID);
                }
                if (string.equals("getLastResponseID")) {
                    if (this.lastResponseID == null) {
                        throw new IllegalStateException("There is no last response ID.");
                    }
                    return this.lastResponseID;
                }
                if (string.equals("waitForResponse")) {
                    if (!this.transmitReturnValue && !this.transmitExceptions && this.nonBlocking) {
                        throw new IllegalStateException("This RemoteObject is currently set to ignore all responses.");
                    }
                    return this.waitForResponse((Byte)objectArray[0]);
                }
                if (string.equals("getConnection")) {
                    return this.connection;
                }
                throw new RuntimeException("Invocation handler could not find RemoteObject method. Check ObjectSpace.java");
            }
            if (method.getDeclaringClass() == Object.class) {
                if (method.getName().equals("toString")) {
                    return "<proxy>";
                }
                try {
                    return method.invoke(object, objectArray);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            InvokeMethod invokeMethod = new InvokeMethod();
            invokeMethod.objectID = this.objectID;
            invokeMethod.method = method;
            invokeMethod.args = objectArray;
            boolean bl2 = bl = this.transmitReturnValue || this.transmitExceptions || !this.nonBlocking;
            if (bl) {
                clazz = this;
                synchronized (clazz) {
                    byte by = this.nextResponseNum;
                    this.nextResponseNum = (byte)(by + 1);
                    n = by;
                    if (this.nextResponseNum == 64) {
                        this.nextResponseNum = 1;
                    }
                }
                if (this.transmitReturnValue) {
                    n = (byte)(n | 0xFFFFFF80);
                }
                if (this.transmitExceptions) {
                    n = (byte)(n | 0x40);
                }
                invokeMethod.responseID = (byte)n;
            } else {
                invokeMethod.responseID = 0;
            }
            n = this.connection.sendTCP(invokeMethod);
            if (invokeMethod.responseID != 0) {
                this.lastResponseID = invokeMethod.responseID;
            }
            if (this.nonBlocking) {
                clazz = method.getReturnType();
                if (clazz.isPrimitive()) {
                    if (clazz == Integer.TYPE) {
                        return 0;
                    }
                    if (clazz == Boolean.TYPE) {
                        return Boolean.FALSE;
                    }
                    if (clazz == Float.TYPE) {
                        return Float.valueOf(0.0f);
                    }
                    if (clazz == Character.TYPE) {
                        return Character.valueOf('\u0000');
                    }
                    if (clazz == Long.TYPE) {
                        return 0L;
                    }
                    if (clazz == Short.TYPE) {
                        return (short)0;
                    }
                    if (clazz == Byte.TYPE) {
                        return (byte)0;
                    }
                    if (clazz == Double.TYPE) {
                        return 0.0;
                    }
                }
                return null;
            }
            try {
                clazz = this.waitForResponse(invokeMethod.responseID);
                if (clazz != null && clazz instanceof Exception) {
                    throw (Exception)((Object)clazz);
                }
                return clazz;
            }
            catch (TimeoutException timeoutException) {
                throw new TimeoutException("Response timed out: " + method.getDeclaringClass().getName() + "." + method.getName());
            }
        }

        private Object waitForResponse(byte by) {
            if (this.connection.getEndPoint().getUpdateThread() == Thread.currentThread()) {
                throw new IllegalStateException("Cannot wait for an RMI response on the connection's update thread.");
            }
            long l = System.currentTimeMillis() + (long)this.timeoutMillis;
            while (true) {
                long l2 = l - System.currentTimeMillis();
                if (this.responseTable.containsKey(by)) {
                    InvokeMethodResult invokeMethodResult = this.responseTable.get(by);
                    this.responseTable.remove(by);
                    this.lastResponseID = null;
                    return invokeMethodResult.result;
                }
                if (l2 <= 0L) {
                    throw new TimeoutException("Response timed out.");
                }
                this.lock.lock();
                try {
                    this.responseCondition.await(l2, TimeUnit.MILLISECONDS);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(interruptedException);
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
        }

        void close() {
            this.connection.removeListener(this.responseListener);
        }
    }
}

