(ns clj-mail.search
  (:import [javax.mail Flags Flags$Flag]
           [javax.mail.search OrTerm AndTerm SubjectTerm FlagTerm ComparisonTerm ReceivedDateTerm]
           [java.util Date]
           [java.text SimpleDateFormat])
  (:refer-clojure :exclude [or and]))

(defn or
  ([terms] (OrTerm. (to-array terms)))
  ([t1 t2] (OrTerm. t1 t2)))

(defn and
  ([terms] (AndTerm. (to-array terms)))
  ([t1 t2] (AndTerm. t1 t2)))

(defn subject [subject]
  (SubjectTerm. subject))

(def SEEN (FlagTerm. (Flags. Flags$Flag/SEEN) true))
(def UNSEEN (FlagTerm. (Flags. Flags$Flag/SEEN) false))

(defmulti received-since class)

(defmethod received-since String [date]
  (ReceivedDateTerm. ComparisonTerm/GE (.parse (SimpleDateFormat. "y-M-d H:m:s") date)))

(defmethod received-since Date [date]
  (ReceivedDateTerm. ComparisonTerm/GE date))
