/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.DistanceInput;
import org.jbox2d.collision.DistanceOutput;
import org.jbox2d.collision.shapes.ChainShape;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public class Distance {
    public static final int MAX_ITERS = 20;
    public static int GJK_CALLS = 0;
    public static int GJK_ITERS = 0;
    public static int GJK_MAX_ITERS = 20;
    private Simplex simplex = new Simplex();
    private int[] saveA = new int[3];
    private int[] saveB = new int[3];
    private Vec2 closestPoint = new Vec2();
    private Vec2 d = new Vec2();
    private Vec2 temp = new Vec2();
    private Vec2 normal = new Vec2();

    public final void distance(DistanceOutput output, SimplexCache cache, DistanceInput input) {
        double distanceSqr1;
        ++GJK_CALLS;
        DistanceProxy proxyA = input.proxyA;
        DistanceProxy proxyB = input.proxyB;
        Transform transformA = input.transformA;
        Transform transformB = input.transformB;
        this.simplex.readCache(cache, proxyA, transformA, proxyB, transformB);
        SimplexVertex[] vertices = this.simplex.vertices;
        int saveCount = 0;
        this.simplex.getClosestPoint(this.closestPoint);
        double distanceSqr2 = distanceSqr1 = this.closestPoint.lengthSquared();
        int iter = 0;
        while (iter < 20) {
            saveCount = this.simplex.m_count;
            for (int i = 0; i < saveCount; ++i) {
                this.saveA[i] = vertices[i].indexA;
                this.saveB[i] = vertices[i].indexB;
            }
            switch (this.simplex.m_count) {
                case 1: {
                    break;
                }
                case 2: {
                    this.simplex.solve2();
                    break;
                }
                case 3: {
                    this.simplex.solve3();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (this.simplex.m_count == 3) break;
            this.simplex.getClosestPoint(this.closestPoint);
            distanceSqr2 = this.closestPoint.lengthSquared();
            if (distanceSqr2 >= distanceSqr1) {
                // empty if block
            }
            distanceSqr1 = distanceSqr2;
            this.simplex.getSearchDirection(this.d);
            if (this.d.lengthSquared() < 1.4210854715202004E-14) break;
            SimplexVertex vertex = vertices[this.simplex.m_count];
            Rot.mulTransUnsafe(transformA.q, this.d.negateLocal(), this.temp);
            vertex.indexA = proxyA.getSupport(this.temp);
            Transform.mulToOutUnsafe(transformA, proxyA.getVertex(vertex.indexA), vertex.wA);
            Rot.mulTransUnsafe(transformB.q, this.d.negateLocal(), this.temp);
            vertex.indexB = proxyB.getSupport(this.temp);
            Transform.mulToOutUnsafe(transformB, proxyB.getVertex(vertex.indexB), vertex.wB);
            vertex.w.set(vertex.wB).subLocal(vertex.wA);
            ++iter;
            ++GJK_ITERS;
            boolean duplicate = false;
            for (int i = 0; i < saveCount; ++i) {
                if (vertex.indexA != this.saveA[i] || vertex.indexB != this.saveB[i]) continue;
                duplicate = true;
                break;
            }
            if (duplicate) break;
            ++this.simplex.m_count;
        }
        GJK_MAX_ITERS = MathUtils.max(GJK_MAX_ITERS, iter);
        this.simplex.getWitnessPoints(output.pointA, output.pointB);
        output.distance = MathUtils.distance(output.pointA, output.pointB);
        output.iterations = iter;
        this.simplex.writeCache(cache);
        if (input.useRadii) {
            double rA = proxyA.m_radius;
            double rB = proxyB.m_radius;
            if (output.distance > rA + rB && output.distance > 1.1920928955078125E-7) {
                output.distance -= rA + rB;
                this.normal.set(output.pointB).subLocal(output.pointA);
                this.normal.normalize();
                this.temp.set(this.normal).mulLocal(rA);
                output.pointA.addLocal(this.temp);
                this.temp.set(this.normal).mulLocal(rB);
                output.pointB.subLocal(this.temp);
            } else {
                output.pointA.addLocal(output.pointB).mulLocal(0.5);
                output.pointB.set(output.pointA);
                output.distance = 0.0;
            }
        }
    }

    public static class DistanceProxy {
        public final Vec2[] m_vertices = new Vec2[Settings.maxPolygonVertices];
        public int m_count;
        public double m_radius;
        public final Vec2[] m_buffer;

        public DistanceProxy() {
            for (int i = 0; i < this.m_vertices.length; ++i) {
                this.m_vertices[i] = new Vec2();
            }
            this.m_buffer = new Vec2[2];
            this.m_count = 0;
            this.m_radius = 0.0;
        }

        public final void set(Shape shape, int index) {
            switch (shape.getType()) {
                case CIRCLE: {
                    CircleShape circle = (CircleShape)shape;
                    this.m_vertices[0].set(circle.m_p);
                    this.m_count = 1;
                    this.m_radius = circle.m_radius;
                    break;
                }
                case POLYGON: {
                    PolygonShape poly = (PolygonShape)shape;
                    this.m_count = poly.m_count;
                    this.m_radius = poly.m_radius;
                    for (int i = 0; i < this.m_count; ++i) {
                        this.m_vertices[i].set(poly.m_vertices[i]);
                    }
                    break;
                }
                case CHAIN: {
                    ChainShape chain = (ChainShape)shape;
                    assert (0 <= index && index < chain.m_count);
                    this.m_buffer[0] = chain.m_vertices[index];
                    this.m_buffer[1] = index + 1 < chain.m_count ? chain.m_vertices[index + 1] : chain.m_vertices[0];
                    this.m_vertices[0].set(this.m_buffer[0]);
                    this.m_vertices[1].set(this.m_buffer[1]);
                    this.m_count = 2;
                    this.m_radius = chain.m_radius;
                    break;
                }
                case EDGE: {
                    EdgeShape edge = (EdgeShape)shape;
                    this.m_vertices[0].set(edge.m_vertex1);
                    this.m_vertices[1].set(edge.m_vertex2);
                    this.m_count = 2;
                    this.m_radius = edge.m_radius;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        public final int getSupport(Vec2 d) {
            int bestIndex = 0;
            double bestValue = Vec2.dot(this.m_vertices[0], d);
            for (int i = 1; i < this.m_count; ++i) {
                double value = Vec2.dot(this.m_vertices[i], d);
                if (!(value > bestValue)) continue;
                bestIndex = i;
                bestValue = value;
            }
            return bestIndex;
        }

        public final Vec2 getSupportVertex(Vec2 d) {
            int bestIndex = 0;
            double bestValue = Vec2.dot(this.m_vertices[0], d);
            for (int i = 1; i < this.m_count; ++i) {
                double value = Vec2.dot(this.m_vertices[i], d);
                if (!(value > bestValue)) continue;
                bestIndex = i;
                bestValue = value;
            }
            return this.m_vertices[bestIndex];
        }

        public final int getVertexCount() {
            return this.m_count;
        }

        public final Vec2 getVertex(int index) {
            assert (0 <= index && index < this.m_count);
            return this.m_vertices[index];
        }
    }

    private class Simplex {
        public final SimplexVertex m_v1;
        public final SimplexVertex m_v2;
        public final SimplexVertex m_v3;
        public final SimplexVertex[] vertices;
        public int m_count;
        private final Vec2 e12;
        private final Vec2 case2;
        private final Vec2 case22;
        private final Vec2 case3;
        private final Vec2 case33;
        private final Vec2 e13;
        private final Vec2 e23;
        private final Vec2 w1;
        private final Vec2 w2;
        private final Vec2 w3;

        private Simplex() {
            this.m_v1 = new SimplexVertex();
            this.m_v2 = new SimplexVertex();
            this.m_v3 = new SimplexVertex();
            this.vertices = new SimplexVertex[]{this.m_v1, this.m_v2, this.m_v3};
            this.e12 = new Vec2();
            this.case2 = new Vec2();
            this.case22 = new Vec2();
            this.case3 = new Vec2();
            this.case33 = new Vec2();
            this.e13 = new Vec2();
            this.e23 = new Vec2();
            this.w1 = new Vec2();
            this.w2 = new Vec2();
            this.w3 = new Vec2();
        }

        public void readCache(SimplexCache cache, DistanceProxy proxyA, Transform transformA, DistanceProxy proxyB, Transform transformB) {
            assert (cache.count <= 3);
            this.m_count = cache.count;
            for (int i = 0; i < this.m_count; ++i) {
                SimplexVertex v = this.vertices[i];
                v.indexA = cache.indexA[i];
                v.indexB = cache.indexB[i];
                Vec2 wALocal = proxyA.getVertex(v.indexA);
                Vec2 wBLocal = proxyB.getVertex(v.indexB);
                Transform.mulToOutUnsafe(transformA, wALocal, v.wA);
                Transform.mulToOutUnsafe(transformB, wBLocal, v.wB);
                v.w.set(v.wB).subLocal(v.wA);
                v.a = 0.0;
            }
            if (this.m_count > 1) {
                double metric1 = cache.metric;
                double metric2 = this.getMetric();
                if (metric2 < 0.5 * metric1 || 2.0 * metric1 < metric2 || metric2 < 1.1920928955078125E-7) {
                    this.m_count = 0;
                }
            }
            if (this.m_count == 0) {
                SimplexVertex v = this.vertices[0];
                v.indexA = 0;
                v.indexB = 0;
                Vec2 wALocal = proxyA.getVertex(0);
                Vec2 wBLocal = proxyB.getVertex(0);
                Transform.mulToOutUnsafe(transformA, wALocal, v.wA);
                Transform.mulToOutUnsafe(transformB, wBLocal, v.wB);
                v.w.set(v.wB).subLocal(v.wA);
                this.m_count = 1;
            }
        }

        public void writeCache(SimplexCache cache) {
            cache.metric = this.getMetric();
            cache.count = this.m_count;
            for (int i = 0; i < this.m_count; ++i) {
                cache.indexA[i] = this.vertices[i].indexA;
                cache.indexB[i] = this.vertices[i].indexB;
            }
        }

        public final void getSearchDirection(Vec2 out) {
            switch (this.m_count) {
                case 1: {
                    out.set(this.m_v1.w).negateLocal();
                    return;
                }
                case 2: {
                    this.e12.set(this.m_v2.w).subLocal(this.m_v1.w);
                    out.set(this.m_v1.w).negateLocal();
                    double sgn = Vec2.cross(this.e12, out);
                    if (sgn > 0.0) {
                        Vec2.crossToOutUnsafe(1.0, this.e12, out);
                        return;
                    }
                    Vec2.crossToOutUnsafe(this.e12, 1.0, out);
                    return;
                }
            }
            assert (false);
            out.setZero();
        }

        public void getClosestPoint(Vec2 out) {
            switch (this.m_count) {
                case 0: {
                    assert (false);
                    out.setZero();
                    return;
                }
                case 1: {
                    out.set(this.m_v1.w);
                    return;
                }
                case 2: {
                    this.case22.set(this.m_v2.w).mulLocal(this.m_v2.a);
                    this.case2.set(this.m_v1.w).mulLocal(this.m_v1.a).addLocal(this.case22);
                    out.set(this.case2);
                    return;
                }
                case 3: {
                    out.setZero();
                    return;
                }
            }
            assert (false);
            out.setZero();
        }

        public void getWitnessPoints(Vec2 pA, Vec2 pB) {
            switch (this.m_count) {
                case 0: {
                    assert (false);
                    break;
                }
                case 1: {
                    pA.set(this.m_v1.wA);
                    pB.set(this.m_v1.wB);
                    break;
                }
                case 2: {
                    this.case2.set(this.m_v1.wA).mulLocal(this.m_v1.a);
                    pA.set(this.m_v2.wA).mulLocal(this.m_v2.a).addLocal(this.case2);
                    this.case2.set(this.m_v1.wB).mulLocal(this.m_v1.a);
                    pB.set(this.m_v2.wB).mulLocal(this.m_v2.a).addLocal(this.case2);
                    break;
                }
                case 3: {
                    pA.set(this.m_v1.wA).mulLocal(this.m_v1.a);
                    this.case3.set(this.m_v2.wA).mulLocal(this.m_v2.a);
                    this.case33.set(this.m_v3.wA).mulLocal(this.m_v3.a);
                    pA.addLocal(this.case3).addLocal(this.case33);
                    pB.set(pA);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        public double getMetric() {
            switch (this.m_count) {
                case 0: {
                    assert (false);
                    return 0.0;
                }
                case 1: {
                    return 0.0;
                }
                case 2: {
                    return MathUtils.distance(this.m_v1.w, this.m_v2.w);
                }
                case 3: {
                    this.case3.set(this.m_v2.w).subLocal(this.m_v1.w);
                    this.case33.set(this.m_v3.w).subLocal(this.m_v1.w);
                    return Vec2.cross(this.case3, this.case33);
                }
            }
            assert (false);
            return 0.0;
        }

        public void solve2() {
            Vec2 w1 = this.m_v1.w;
            Vec2 w2 = this.m_v2.w;
            this.e12.set(w2).subLocal(w1);
            double d12_2 = -Vec2.dot(w1, this.e12);
            if (d12_2 <= 0.0) {
                this.m_v1.a = 1.0;
                this.m_count = 1;
                return;
            }
            double d12_1 = Vec2.dot(w2, this.e12);
            if (d12_1 <= 0.0) {
                this.m_v2.a = 1.0;
                this.m_count = 1;
                this.m_v1.set(this.m_v2);
                return;
            }
            double inv_d12 = 1.0 / (d12_1 + d12_2);
            this.m_v1.a = d12_1 * inv_d12;
            this.m_v2.a = d12_2 * inv_d12;
            this.m_count = 2;
        }

        public void solve3() {
            double w3e23;
            double w3e13;
            double w2e12;
            this.w1.set(this.m_v1.w);
            this.w2.set(this.m_v2.w);
            this.w3.set(this.m_v3.w);
            this.e12.set(this.w2).subLocal(this.w1);
            double w1e12 = Vec2.dot(this.w1, this.e12);
            double d12_1 = w2e12 = Vec2.dot(this.w2, this.e12);
            double d12_2 = -w1e12;
            this.e13.set(this.w3).subLocal(this.w1);
            double w1e13 = Vec2.dot(this.w1, this.e13);
            double d13_1 = w3e13 = Vec2.dot(this.w3, this.e13);
            double d13_2 = -w1e13;
            this.e23.set(this.w3).subLocal(this.w2);
            double w2e23 = Vec2.dot(this.w2, this.e23);
            double d23_1 = w3e23 = Vec2.dot(this.w3, this.e23);
            double d23_2 = -w2e23;
            double n123 = Vec2.cross(this.e12, this.e13);
            double d123_1 = n123 * Vec2.cross(this.w2, this.w3);
            double d123_2 = n123 * Vec2.cross(this.w3, this.w1);
            double d123_3 = n123 * Vec2.cross(this.w1, this.w2);
            if (d12_2 <= 0.0 && d13_2 <= 0.0) {
                this.m_v1.a = 1.0;
                this.m_count = 1;
                return;
            }
            if (d12_1 > 0.0 && d12_2 > 0.0 && d123_3 <= 0.0) {
                double inv_d12 = 1.0 / (d12_1 + d12_2);
                this.m_v1.a = d12_1 * inv_d12;
                this.m_v2.a = d12_2 * inv_d12;
                this.m_count = 2;
                return;
            }
            if (d13_1 > 0.0 && d13_2 > 0.0 && d123_2 <= 0.0) {
                double inv_d13 = 1.0 / (d13_1 + d13_2);
                this.m_v1.a = d13_1 * inv_d13;
                this.m_v3.a = d13_2 * inv_d13;
                this.m_count = 2;
                this.m_v2.set(this.m_v3);
                return;
            }
            if (d12_1 <= 0.0 && d23_2 <= 0.0) {
                this.m_v2.a = 1.0;
                this.m_count = 1;
                this.m_v1.set(this.m_v2);
                return;
            }
            if (d13_1 <= 0.0 && d23_1 <= 0.0) {
                this.m_v3.a = 1.0;
                this.m_count = 1;
                this.m_v1.set(this.m_v3);
                return;
            }
            if (d23_1 > 0.0 && d23_2 > 0.0 && d123_1 <= 0.0) {
                double inv_d23 = 1.0 / (d23_1 + d23_2);
                this.m_v2.a = d23_1 * inv_d23;
                this.m_v3.a = d23_2 * inv_d23;
                this.m_count = 2;
                this.m_v1.set(this.m_v3);
                return;
            }
            double inv_d123 = 1.0 / (d123_1 + d123_2 + d123_3);
            this.m_v1.a = d123_1 * inv_d123;
            this.m_v2.a = d123_2 * inv_d123;
            this.m_v3.a = d123_3 * inv_d123;
            this.m_count = 3;
        }
    }

    public static class SimplexCache {
        public double metric = 0.0;
        public int count = 0;
        public final int[] indexA = new int[3];
        public final int[] indexB = new int[3];

        public SimplexCache() {
            this.indexA[0] = Integer.MAX_VALUE;
            this.indexA[1] = Integer.MAX_VALUE;
            this.indexA[2] = Integer.MAX_VALUE;
            this.indexB[0] = Integer.MAX_VALUE;
            this.indexB[1] = Integer.MAX_VALUE;
            this.indexB[2] = Integer.MAX_VALUE;
        }

        public void set(SimplexCache sc) {
            System.arraycopy(sc.indexA, 0, this.indexA, 0, this.indexA.length);
            System.arraycopy(sc.indexB, 0, this.indexB, 0, this.indexB.length);
            this.metric = sc.metric;
            this.count = sc.count;
        }
    }

    private class SimplexVertex {
        public final Vec2 wA = new Vec2();
        public final Vec2 wB = new Vec2();
        public final Vec2 w = new Vec2();
        public double a;
        public int indexA;
        public int indexB;

        private SimplexVertex() {
        }

        public void set(SimplexVertex sv) {
            this.wA.set(sv.wA);
            this.wB.set(sv.wB);
            this.w.set(sv.w);
            this.a = sv.a;
            this.indexA = sv.indexA;
            this.indexB = sv.indexB;
        }
    }
}

