/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import java.lang.reflect.Array;

public class BufferUtils {
    public static <T> T[] reallocateBuffer(Class<T> klass, T[] oldBuffer, int oldCapacity, int newCapacity) {
        assert (newCapacity > oldCapacity);
        Object[] newBuffer = (Object[])Array.newInstance(klass, newCapacity);
        if (oldBuffer != null) {
            System.arraycopy(oldBuffer, 0, newBuffer, 0, oldCapacity);
        }
        for (int i = oldCapacity; i < newCapacity; ++i) {
            try {
                newBuffer[i] = klass.newInstance();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return newBuffer;
    }

    public static int[] reallocateBuffer(int[] oldBuffer, int oldCapacity, int newCapacity) {
        assert (newCapacity > oldCapacity);
        int[] newBuffer = new int[newCapacity];
        if (oldBuffer != null) {
            System.arraycopy(oldBuffer, 0, newBuffer, 0, oldCapacity);
        }
        return newBuffer;
    }

    public static double[] reallocateBuffer(double[] oldBuffer, int oldCapacity, int newCapacity) {
        assert (newCapacity > oldCapacity);
        double[] newBuffer = new double[newCapacity];
        if (oldBuffer != null) {
            System.arraycopy(oldBuffer, 0, newBuffer, 0, oldCapacity);
        }
        return newBuffer;
    }

    public static <T> T[] reallocateBuffer(Class<T> klass, T[] buffer, int userSuppliedCapacity, int oldCapacity, int newCapacity, boolean deferred) {
        assert (newCapacity > oldCapacity);
        assert (userSuppliedCapacity == 0 || newCapacity <= userSuppliedCapacity);
        if (!(deferred && buffer == null || userSuppliedCapacity != 0)) {
            buffer = BufferUtils.reallocateBuffer(klass, buffer, oldCapacity, newCapacity);
        }
        return buffer;
    }

    public static int[] reallocateBuffer(int[] buffer, int userSuppliedCapacity, int oldCapacity, int newCapacity, boolean deferred) {
        assert (newCapacity > oldCapacity);
        assert (userSuppliedCapacity == 0 || newCapacity <= userSuppliedCapacity);
        if (!(deferred && buffer == null || userSuppliedCapacity != 0)) {
            buffer = BufferUtils.reallocateBuffer(buffer, oldCapacity, newCapacity);
        }
        return buffer;
    }

    public static double[] reallocateBuffer(double[] buffer, int userSuppliedCapacity, int oldCapacity, int newCapacity, boolean deferred) {
        assert (newCapacity > oldCapacity);
        assert (userSuppliedCapacity == 0 || newCapacity <= userSuppliedCapacity);
        if (!(deferred && buffer == null || userSuppliedCapacity != 0)) {
            buffer = BufferUtils.reallocateBuffer(buffer, oldCapacity, newCapacity);
        }
        return buffer;
    }

    public static <T> void rotate(T[] ray, int first, int new_first, int last) {
        int next = new_first;
        while (next != first) {
            T temp = ray[first];
            ray[first] = ray[next];
            ray[next] = temp;
            ++first;
            if (++next == last) {
                next = new_first;
                continue;
            }
            if (first != new_first) continue;
            new_first = next;
        }
    }

    public static void rotate(int[] ray, int first, int new_first, int last) {
        int next = new_first;
        while (next != first) {
            int temp = ray[first];
            ray[first] = ray[next];
            ray[next] = temp;
            ++first;
            if (++next == last) {
                next = new_first;
                continue;
            }
            if (first != new_first) continue;
            new_first = next;
        }
    }

    public static void rotate(double[] ray, int first, int new_first, int last) {
        int next = new_first;
        while (next != first) {
            double temp = ray[first];
            ray[first] = ray[next];
            ray[next] = temp;
            ++first;
            if (++next == last) {
                next = new_first;
                continue;
            }
            if (first != new_first) continue;
            new_first = next;
        }
    }
}

