/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import java.util.Random;
import org.jbox2d.common.PlatformMathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;

public class MathUtils
extends PlatformMathUtils {
    public static final double PI = Math.PI;
    public static final double TWOPI = Math.PI * 2;
    public static final double INV_PI = 0.3183098861837907;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double QUARTER_PI = 0.7853981633974483;
    public static final double THREE_HALVES_PI = 4.71238898038469;
    public static final double DEG2RAD = Math.PI / 180;
    public static final double RAD2DEG = 57.29577951308232;
    public static final double[] sinLUT = new double[Settings.SINCOS_LUT_LENGTH];

    public static final double sin(double x) {
        if (Settings.SINCOS_LUT_ENABLED) {
            return MathUtils.sinLUT(x);
        }
        return StrictMath.sin(x);
    }

    public static final double sinLUT(double x) {
        if ((x %= Math.PI * 2) < 0.0) {
            x += Math.PI * 2;
        }
        if (Settings.SINCOS_LUT_LERP) {
            int index = (int)(x /= (double)1.1E-4f);
            if (index != 0) {
                x %= (double)index;
            }
            if (index == Settings.SINCOS_LUT_LENGTH - 1) {
                return (1.0 - x) * sinLUT[index] + x * sinLUT[0];
            }
            return (1.0 - x) * sinLUT[index] + x * sinLUT[index + 1];
        }
        return sinLUT[MathUtils.round(x / (double)1.1E-4f) % Settings.SINCOS_LUT_LENGTH];
    }

    public static final double cos(double x) {
        if (Settings.SINCOS_LUT_ENABLED) {
            return MathUtils.sinLUT(1.5707963267948966 - x);
        }
        return StrictMath.cos(x);
    }

    public static final double abs(double x) {
        if (Settings.FAST_ABS) {
            return x > 0.0 ? x : -x;
        }
        return StrictMath.abs(x);
    }

    public static final double fastAbs(double x) {
        return x > 0.0 ? x : -x;
    }

    public static final int abs(int x) {
        int y = x >> 31;
        return (x ^ y) - y;
    }

    public static final int floor(double x) {
        if (Settings.FAST_FLOOR) {
            return MathUtils.fastFloor(x);
        }
        return (int)StrictMath.floor(x);
    }

    public static final int fastFloor(double x) {
        int y = (int)x;
        if (x < (double)y) {
            return y - 1;
        }
        return y;
    }

    public static final int ceil(double x) {
        if (Settings.FAST_CEIL) {
            return MathUtils.fastCeil(x);
        }
        return (int)StrictMath.ceil(x);
    }

    public static final int fastCeil(double x) {
        int y = (int)x;
        if (x > (double)y) {
            return y + 1;
        }
        return y;
    }

    public static final int round(double x) {
        if (Settings.FAST_ROUND) {
            return MathUtils.floor(x + 0.5);
        }
        return (int)StrictMath.round(x);
    }

    public static final int ceilPowerOf2(int x) {
        int pow2;
        for (pow2 = 1; pow2 < x; pow2 <<= 1) {
        }
        return pow2;
    }

    public static final double max(double a, double b) {
        return a > b ? a : b;
    }

    public static final int max(int a, int b) {
        return a > b ? a : b;
    }

    public static final double min(double a, double b) {
        return a < b ? a : b;
    }

    public static final int min(int a, int b) {
        return a < b ? a : b;
    }

    public static final double map(double val, double fromMin, double fromMax, double toMin, double toMax) {
        double mult = (val - fromMin) / (fromMax - fromMin);
        double res = toMin + mult * (toMax - toMin);
        return res;
    }

    public static final double clamp(double a, double low, double high) {
        return MathUtils.max(low, MathUtils.min(a, high));
    }

    public static final Vec2 clamp(Vec2 a, Vec2 low, Vec2 high) {
        Vec2 min = new Vec2();
        min.x = a.x < high.x ? a.x : high.x;
        min.y = a.y < high.y ? a.y : high.y;
        min.x = low.x > min.x ? low.x : min.x;
        min.y = low.y > min.y ? low.y : min.y;
        return min;
    }

    public static final void clampToOut(Vec2 a, Vec2 low, Vec2 high, Vec2 dest) {
        dest.x = a.x < high.x ? a.x : high.x;
        dest.y = a.y < high.y ? a.y : high.y;
        dest.x = low.x > dest.x ? low.x : dest.x;
        dest.y = low.y > dest.y ? low.y : dest.y;
    }

    public static final int nextPowerOfTwo(int x) {
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    public static final boolean isPowerOfTwo(int x) {
        return x > 0 && (x & x - 1) == 0;
    }

    public static final double pow(double a, double b) {
        if (Settings.FAST_POW) {
            return MathUtils.fastPow(a, b);
        }
        return StrictMath.pow(a, b);
    }

    public static final double atan2(double y, double x) {
        if (Settings.FAST_ATAN2) {
            return MathUtils.fastAtan2(y, x);
        }
        return StrictMath.atan2(y, x);
    }

    public static final double fastAtan2(double y, double x) {
        double atan;
        if (x == 0.0) {
            if (y > 0.0) {
                return 1.5707963267948966;
            }
            if (y == 0.0) {
                return 0.0;
            }
            return -1.5707963267948966;
        }
        double z = y / x;
        if (MathUtils.abs(z) < 1.0) {
            atan = z / (1.0 + (double)0.28f * z * z);
            if (x < 0.0) {
                if (y < 0.0) {
                    return atan - Math.PI;
                }
                return atan + Math.PI;
            }
        } else {
            atan = 1.5707963267948966 - z / (z * z + (double)0.28f);
            if (y < 0.0) {
                return atan - Math.PI;
            }
        }
        return atan;
    }

    public static final double reduceAngle(double theta) {
        if (MathUtils.abs(theta %= Math.PI * 2) > Math.PI) {
            theta -= Math.PI * 2;
        }
        if (MathUtils.abs(theta) > 1.5707963267948966) {
            theta = Math.PI - theta;
        }
        return theta;
    }

    public static final double randomDouble(double argLow, double argHigh) {
        return Math.random() * (argHigh - argLow) + argLow;
    }

    public static final double randomDouble(Random r, double argLow, double argHigh) {
        return r.nextDouble() * (argHigh - argLow) + argLow;
    }

    public static final double sqrt(double x) {
        return StrictMath.sqrt(x);
    }

    public static final double distanceSquared(Vec2 v1, Vec2 v2) {
        double dx = v1.x - v2.x;
        double dy = v1.y - v2.y;
        return dx * dx + dy * dy;
    }

    public static final double distance(Vec2 v1, Vec2 v2) {
        return MathUtils.sqrt(MathUtils.distanceSquared(v1, v2));
    }

    static {
        for (int i = 0; i < Settings.SINCOS_LUT_LENGTH; ++i) {
            MathUtils.sinLUT[i] = Math.sin((double)i * (double)1.1E-4f);
        }
    }
}

