/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.Mat33;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.Vec3;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.SolverData;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.LimitState;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.pooling.IWorldPool;

public class RevoluteJoint
extends Joint {
    protected final Vec2 m_localAnchorA = new Vec2();
    protected final Vec2 m_localAnchorB = new Vec2();
    private final Vec3 m_impulse = new Vec3();
    private double m_motorImpulse;
    private boolean m_enableMotor;
    private double m_maxMotorTorque;
    private double m_motorSpeed;
    private boolean m_enableLimit;
    protected double m_referenceAngle;
    private double m_lowerAngle;
    private double m_upperAngle;
    private int m_indexA;
    private int m_indexB;
    private final Vec2 m_rA = new Vec2();
    private final Vec2 m_rB = new Vec2();
    private final Vec2 m_localCenterA = new Vec2();
    private final Vec2 m_localCenterB = new Vec2();
    private double m_invMassA;
    private double m_invMassB;
    private double m_invIA;
    private double m_invIB;
    private final Mat33 m_mass = new Mat33();
    private double m_motorMass;
    private LimitState m_limitState;

    protected RevoluteJoint(IWorldPool argWorld, RevoluteJointDef def) {
        super(argWorld, def);
        this.m_localAnchorA.set(def.localAnchorA);
        this.m_localAnchorB.set(def.localAnchorB);
        this.m_referenceAngle = def.referenceAngle;
        this.m_motorImpulse = 0.0;
        this.m_lowerAngle = def.lowerAngle;
        this.m_upperAngle = def.upperAngle;
        this.m_maxMotorTorque = def.maxMotorTorque;
        this.m_motorSpeed = def.motorSpeed;
        this.m_enableLimit = def.enableLimit;
        this.m_enableMotor = def.enableMotor;
        this.m_limitState = LimitState.INACTIVE;
    }

    @Override
    public void initVelocityConstraints(SolverData data) {
        this.m_indexA = this.m_bodyA.m_islandIndex;
        this.m_indexB = this.m_bodyB.m_islandIndex;
        this.m_localCenterA.set(this.m_bodyA.m_sweep.localCenter);
        this.m_localCenterB.set(this.m_bodyB.m_sweep.localCenter);
        this.m_invMassA = this.m_bodyA.m_invMass;
        this.m_invMassB = this.m_bodyB.m_invMass;
        this.m_invIA = this.m_bodyA.m_invI;
        this.m_invIB = this.m_bodyB.m_invI;
        double aA = data.positions[this.m_indexA].a;
        Vec2 vA = data.velocities[this.m_indexA].v;
        double wA = data.velocities[this.m_indexA].w;
        double aB = data.positions[this.m_indexB].a;
        Vec2 vB = data.velocities[this.m_indexB].v;
        double wB = data.velocities[this.m_indexB].w;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 temp = this.pool.popVec2();
        qA.set(aA);
        qB.set(aB);
        Rot.mulToOutUnsafe(qA, temp.set(this.m_localAnchorA).subLocal(this.m_localCenterA), this.m_rA);
        Rot.mulToOutUnsafe(qB, temp.set(this.m_localAnchorB).subLocal(this.m_localCenterB), this.m_rB);
        double mA = this.m_invMassA;
        double mB = this.m_invMassB;
        double iA = this.m_invIA;
        double iB = this.m_invIB;
        boolean fixedRotation = iA + iB == 0.0;
        this.m_mass.ex.x = mA + mB + this.m_rA.y * this.m_rA.y * iA + this.m_rB.y * this.m_rB.y * iB;
        this.m_mass.ey.x = -this.m_rA.y * this.m_rA.x * iA - this.m_rB.y * this.m_rB.x * iB;
        this.m_mass.ez.x = -this.m_rA.y * iA - this.m_rB.y * iB;
        this.m_mass.ex.y = this.m_mass.ey.x;
        this.m_mass.ey.y = mA + mB + this.m_rA.x * this.m_rA.x * iA + this.m_rB.x * this.m_rB.x * iB;
        this.m_mass.ez.y = this.m_rA.x * iA + this.m_rB.x * iB;
        this.m_mass.ex.z = this.m_mass.ez.x;
        this.m_mass.ey.z = this.m_mass.ez.y;
        this.m_mass.ez.z = iA + iB;
        this.m_motorMass = iA + iB;
        if (this.m_motorMass > 0.0) {
            this.m_motorMass = 1.0 / this.m_motorMass;
        }
        if (!this.m_enableMotor || fixedRotation) {
            this.m_motorImpulse = 0.0;
        }
        if (this.m_enableLimit && !fixedRotation) {
            double jointAngle = aB - aA - this.m_referenceAngle;
            if (MathUtils.abs(this.m_upperAngle - this.m_lowerAngle) < 2.0 * Settings.angularSlop) {
                this.m_limitState = LimitState.EQUAL;
            } else if (jointAngle <= this.m_lowerAngle) {
                if (this.m_limitState != LimitState.AT_LOWER) {
                    this.m_impulse.z = 0.0;
                }
                this.m_limitState = LimitState.AT_LOWER;
            } else if (jointAngle >= this.m_upperAngle) {
                if (this.m_limitState != LimitState.AT_UPPER) {
                    this.m_impulse.z = 0.0;
                }
                this.m_limitState = LimitState.AT_UPPER;
            } else {
                this.m_limitState = LimitState.INACTIVE;
                this.m_impulse.z = 0.0;
            }
        } else {
            this.m_limitState = LimitState.INACTIVE;
        }
        if (data.step.warmStarting) {
            Vec2 P = this.pool.popVec2();
            this.m_impulse.x *= data.step.dtRatio;
            this.m_impulse.y *= data.step.dtRatio;
            this.m_motorImpulse *= data.step.dtRatio;
            P.x = this.m_impulse.x;
            P.y = this.m_impulse.y;
            vA.x -= mA * P.x;
            vA.y -= mA * P.y;
            wA -= iA * (Vec2.cross(this.m_rA, P) + this.m_motorImpulse + this.m_impulse.z);
            vB.x += mB * P.x;
            vB.y += mB * P.y;
            wB += iB * (Vec2.cross(this.m_rB, P) + this.m_motorImpulse + this.m_impulse.z);
            this.pool.pushVec2(1);
        } else {
            this.m_impulse.setZero();
            this.m_motorImpulse = 0.0;
        }
        data.velocities[this.m_indexA].w = wA;
        data.velocities[this.m_indexB].w = wB;
        this.pool.pushVec2(1);
        this.pool.pushRot(2);
    }

    @Override
    public void solveVelocityConstraints(SolverData data) {
        boolean fixedRotation;
        Vec2 vA = data.velocities[this.m_indexA].v;
        double wA = data.velocities[this.m_indexA].w;
        Vec2 vB = data.velocities[this.m_indexB].v;
        double wB = data.velocities[this.m_indexB].w;
        double mA = this.m_invMassA;
        double mB = this.m_invMassB;
        double iA = this.m_invIA;
        double iB = this.m_invIB;
        boolean bl = fixedRotation = iA + iB == 0.0;
        if (this.m_enableMotor && this.m_limitState != LimitState.EQUAL && !fixedRotation) {
            double Cdot = wB - wA - this.m_motorSpeed;
            double impulse = -this.m_motorMass * Cdot;
            double oldImpulse = this.m_motorImpulse;
            double maxImpulse = data.step.dt * this.m_maxMotorTorque;
            this.m_motorImpulse = MathUtils.clamp(this.m_motorImpulse + impulse, -maxImpulse, maxImpulse);
            impulse = this.m_motorImpulse - oldImpulse;
            wA -= iA * impulse;
            wB += iB * impulse;
        }
        Vec2 temp = this.pool.popVec2();
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE && !fixedRotation) {
            double newImpulse;
            Vec2 Cdot1 = this.pool.popVec2();
            Vec3 Cdot = this.pool.popVec3();
            Vec2.crossToOutUnsafe(wA, this.m_rA, temp);
            Vec2.crossToOutUnsafe(wB, this.m_rB, Cdot1);
            Cdot1.addLocal(vB).subLocal(vA).subLocal(temp);
            double Cdot2 = wB - wA;
            Cdot.set(Cdot1.x, Cdot1.y, Cdot2);
            Vec3 impulse = this.pool.popVec3();
            this.m_mass.solve33ToOut(Cdot, impulse);
            impulse.negateLocal();
            if (this.m_limitState == LimitState.EQUAL) {
                this.m_impulse.addLocal(impulse);
            } else if (this.m_limitState == LimitState.AT_LOWER) {
                newImpulse = this.m_impulse.z + impulse.z;
                if (newImpulse < 0.0) {
                    Vec2 rhs = this.pool.popVec2();
                    rhs.set(this.m_mass.ez.x, this.m_mass.ez.y).mulLocal(this.m_impulse.z).subLocal(Cdot1);
                    this.m_mass.solve22ToOut(rhs, temp);
                    impulse.x = temp.x;
                    impulse.y = temp.y;
                    impulse.z = -this.m_impulse.z;
                    this.m_impulse.x += temp.x;
                    this.m_impulse.y += temp.y;
                    this.m_impulse.z = 0.0;
                    this.pool.pushVec2(1);
                } else {
                    this.m_impulse.addLocal(impulse);
                }
            } else if (this.m_limitState == LimitState.AT_UPPER) {
                newImpulse = this.m_impulse.z + impulse.z;
                if (newImpulse > 0.0) {
                    Vec2 rhs = this.pool.popVec2();
                    rhs.set(this.m_mass.ez.x, this.m_mass.ez.y).mulLocal(this.m_impulse.z).subLocal(Cdot1);
                    this.m_mass.solve22ToOut(rhs, temp);
                    impulse.x = temp.x;
                    impulse.y = temp.y;
                    impulse.z = -this.m_impulse.z;
                    this.m_impulse.x += temp.x;
                    this.m_impulse.y += temp.y;
                    this.m_impulse.z = 0.0;
                    this.pool.pushVec2(1);
                } else {
                    this.m_impulse.addLocal(impulse);
                }
            }
            Vec2 P = this.pool.popVec2();
            P.set(impulse.x, impulse.y);
            vA.x -= mA * P.x;
            vA.y -= mA * P.y;
            wA -= iA * (Vec2.cross(this.m_rA, P) + impulse.z);
            vB.x += mB * P.x;
            vB.y += mB * P.y;
            wB += iB * (Vec2.cross(this.m_rB, P) + impulse.z);
            this.pool.pushVec2(2);
            this.pool.pushVec3(2);
        } else {
            Vec2 Cdot = this.pool.popVec2();
            Vec2 impulse = this.pool.popVec2();
            Vec2.crossToOutUnsafe(wA, this.m_rA, temp);
            Vec2.crossToOutUnsafe(wB, this.m_rB, Cdot);
            Cdot.addLocal(vB).subLocal(vA).subLocal(temp);
            this.m_mass.solve22ToOut(Cdot.negateLocal(), impulse);
            this.m_impulse.x += impulse.x;
            this.m_impulse.y += impulse.y;
            vA.x -= mA * impulse.x;
            vA.y -= mA * impulse.y;
            wA -= iA * Vec2.cross(this.m_rA, impulse);
            vB.x += mB * impulse.x;
            vB.y += mB * impulse.y;
            wB += iB * Vec2.cross(this.m_rB, impulse);
            this.pool.pushVec2(2);
        }
        data.velocities[this.m_indexA].w = wA;
        data.velocities[this.m_indexB].w = wB;
        this.pool.pushVec2(1);
    }

    @Override
    public boolean solvePositionConstraints(SolverData data) {
        boolean fixedRotation;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 cA = data.positions[this.m_indexA].c;
        double aA = data.positions[this.m_indexA].a;
        Vec2 cB = data.positions[this.m_indexB].c;
        double aB = data.positions[this.m_indexB].a;
        qA.set(aA);
        qB.set(aB);
        double angularError = 0.0;
        double positionError = 0.0;
        boolean bl = fixedRotation = this.m_invIA + this.m_invIB == 0.0;
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE && !fixedRotation) {
            double C;
            double angle = aB - aA - this.m_referenceAngle;
            double limitImpulse = 0.0;
            if (this.m_limitState == LimitState.EQUAL) {
                C = MathUtils.clamp(angle - this.m_lowerAngle, -Settings.maxAngularCorrection, Settings.maxAngularCorrection);
                limitImpulse = -this.m_motorMass * C;
                angularError = MathUtils.abs(C);
            } else if (this.m_limitState == LimitState.AT_LOWER) {
                C = angle - this.m_lowerAngle;
                angularError = -C;
                C = MathUtils.clamp(C + Settings.angularSlop, -Settings.maxAngularCorrection, 0.0);
                limitImpulse = -this.m_motorMass * C;
            } else if (this.m_limitState == LimitState.AT_UPPER) {
                angularError = C = angle - this.m_upperAngle;
                C = MathUtils.clamp(C - Settings.angularSlop, 0.0, Settings.maxAngularCorrection);
                limitImpulse = -this.m_motorMass * C;
            }
            aA -= this.m_invIA * limitImpulse;
            aB += this.m_invIB * limitImpulse;
        }
        qA.set(aA);
        qB.set(aB);
        Vec2 rA = this.pool.popVec2();
        Vec2 rB = this.pool.popVec2();
        Vec2 C = this.pool.popVec2();
        Vec2 impulse = this.pool.popVec2();
        Rot.mulToOutUnsafe(qA, C.set(this.m_localAnchorA).subLocal(this.m_localCenterA), rA);
        Rot.mulToOutUnsafe(qB, C.set(this.m_localAnchorB).subLocal(this.m_localCenterB), rB);
        C.set(cB).addLocal(rB).subLocal(cA).subLocal(rA);
        positionError = C.length();
        double mA = this.m_invMassA;
        double mB = this.m_invMassB;
        double iA = this.m_invIA;
        double iB = this.m_invIB;
        Mat22 K = this.pool.popMat22();
        K.ex.x = mA + mB + iA * rA.y * rA.y + iB * rB.y * rB.y;
        K.ey.x = K.ex.y = -iA * rA.x * rA.y - iB * rB.x * rB.y;
        K.ey.y = mA + mB + iA * rA.x * rA.x + iB * rB.x * rB.x;
        K.solveToOut(C, impulse);
        impulse.negateLocal();
        cA.x -= mA * impulse.x;
        cA.y -= mA * impulse.y;
        cB.x += mB * impulse.x;
        cB.y += mB * impulse.y;
        this.pool.pushVec2(4);
        this.pool.pushMat22(1);
        data.positions[this.m_indexA].a = aA -= iA * Vec2.cross(rA, impulse);
        data.positions[this.m_indexB].a = aB += iB * Vec2.cross(rB, impulse);
        this.pool.pushRot(2);
        return positionError <= Settings.linearSlop && angularError <= Settings.angularSlop;
    }

    public Vec2 getLocalAnchorA() {
        return this.m_localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.m_localAnchorB;
    }

    public double getReferenceAngle() {
        return this.m_referenceAngle;
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, argOut);
    }

    @Override
    public void getReactionForce(double inv_dt, Vec2 argOut) {
        argOut.set(this.m_impulse.x, this.m_impulse.y).mulLocal(inv_dt);
    }

    @Override
    public double getReactionTorque(double inv_dt) {
        return inv_dt * this.m_impulse.z;
    }

    public double getJointAngle() {
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        return b2.m_sweep.a - b1.m_sweep.a - this.m_referenceAngle;
    }

    public double getJointSpeed() {
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        return b2.m_angularVelocity - b1.m_angularVelocity;
    }

    public boolean isMotorEnabled() {
        return this.m_enableMotor;
    }

    public void enableMotor(boolean flag) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_enableMotor = flag;
    }

    public double getMotorTorque(double inv_dt) {
        return this.m_motorImpulse * inv_dt;
    }

    public void setMotorSpeed(double speed) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_motorSpeed = speed;
    }

    public void setMaxMotorTorque(double torque) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_maxMotorTorque = torque;
    }

    public double getMotorSpeed() {
        return this.m_motorSpeed;
    }

    public double getMaxMotorTorque() {
        return this.m_maxMotorTorque;
    }

    public boolean isLimitEnabled() {
        return this.m_enableLimit;
    }

    public void enableLimit(boolean flag) {
        if (flag != this.m_enableLimit) {
            this.m_bodyA.setAwake(true);
            this.m_bodyB.setAwake(true);
            this.m_enableLimit = flag;
            this.m_impulse.z = 0.0;
        }
    }

    public double getLowerLimit() {
        return this.m_lowerAngle;
    }

    public double getUpperLimit() {
        return this.m_upperAngle;
    }

    public void setLimits(double lower, double upper) {
        assert (lower <= upper);
        if (lower != this.m_lowerAngle || upper != this.m_upperAngle) {
            this.m_bodyA.setAwake(true);
            this.m_bodyB.setAwake(true);
            this.m_impulse.z = 0.0;
            this.m_lowerAngle = lower;
            this.m_upperAngle = upper;
        }
    }
}

