/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.SolverData;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.WheelJointDef;
import org.jbox2d.pooling.IWorldPool;

public class WheelJoint
extends Joint {
    private double m_frequencyHz;
    private double m_dampingRatio;
    private final Vec2 m_localAnchorA = new Vec2();
    private final Vec2 m_localAnchorB = new Vec2();
    private final Vec2 m_localXAxisA = new Vec2();
    private final Vec2 m_localYAxisA = new Vec2();
    private double m_impulse;
    private double m_motorImpulse;
    private double m_springImpulse;
    private double m_maxMotorTorque;
    private double m_motorSpeed;
    private boolean m_enableMotor;
    private int m_indexA;
    private int m_indexB;
    private final Vec2 m_localCenterA = new Vec2();
    private final Vec2 m_localCenterB = new Vec2();
    private double m_invMassA;
    private double m_invMassB;
    private double m_invIA;
    private double m_invIB;
    private final Vec2 m_ax = new Vec2();
    private final Vec2 m_ay = new Vec2();
    private double m_sAx;
    private double m_sBx;
    private double m_sAy;
    private double m_sBy;
    private double m_mass;
    private double m_motorMass;
    private double m_springMass;
    private double m_bias;
    private double m_gamma;
    private final Vec2 rA = new Vec2();
    private final Vec2 rB = new Vec2();
    private final Vec2 d = new Vec2();

    protected WheelJoint(IWorldPool argPool, WheelJointDef def) {
        super(argPool, def);
        this.m_localAnchorA.set(def.localAnchorA);
        this.m_localAnchorB.set(def.localAnchorB);
        this.m_localXAxisA.set(def.localAxisA);
        Vec2.crossToOutUnsafe(1.0, this.m_localXAxisA, this.m_localYAxisA);
        this.m_motorMass = 0.0;
        this.m_motorImpulse = 0.0;
        this.m_maxMotorTorque = def.maxMotorTorque;
        this.m_motorSpeed = def.motorSpeed;
        this.m_enableMotor = def.enableMotor;
        this.m_frequencyHz = def.frequencyHz;
        this.m_dampingRatio = def.dampingRatio;
    }

    public Vec2 getLocalAnchorA() {
        return this.m_localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.m_localAnchorB;
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, argOut);
    }

    @Override
    public void getReactionForce(double inv_dt, Vec2 argOut) {
        Vec2 temp = this.pool.popVec2();
        temp.set(this.m_ay).mulLocal(this.m_impulse);
        argOut.set(this.m_ax).mulLocal(this.m_springImpulse).addLocal(temp).mulLocal(inv_dt);
        this.pool.pushVec2(1);
    }

    @Override
    public double getReactionTorque(double inv_dt) {
        return inv_dt * this.m_motorImpulse;
    }

    public double getJointTranslation() {
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        Vec2 p1 = this.pool.popVec2();
        Vec2 p2 = this.pool.popVec2();
        Vec2 axis = this.pool.popVec2();
        b1.getWorldPointToOut(this.m_localAnchorA, p1);
        b2.getWorldPointToOut(this.m_localAnchorA, p2);
        p2.subLocal(p1);
        b1.getWorldVectorToOut(this.m_localXAxisA, axis);
        double translation = Vec2.dot(p2, axis);
        this.pool.pushVec2(3);
        return translation;
    }

    public Vec2 getLocalAxisA() {
        return this.m_localXAxisA;
    }

    public double getJointSpeed() {
        return this.m_bodyA.m_angularVelocity - this.m_bodyB.m_angularVelocity;
    }

    public boolean isMotorEnabled() {
        return this.m_enableMotor;
    }

    public void enableMotor(boolean flag) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_enableMotor = flag;
    }

    public void setMotorSpeed(double speed) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_motorSpeed = speed;
    }

    public double getMotorSpeed() {
        return this.m_motorSpeed;
    }

    public double getMaxMotorTorque() {
        return this.m_maxMotorTorque;
    }

    public void setMaxMotorTorque(double torque) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_maxMotorTorque = torque;
    }

    public double getMotorTorque(double inv_dt) {
        return this.m_motorImpulse * inv_dt;
    }

    public void setSpringFrequencyHz(double hz) {
        this.m_frequencyHz = hz;
    }

    public double getSpringFrequencyHz() {
        return this.m_frequencyHz;
    }

    public void setSpringDampingRatio(double ratio) {
        this.m_dampingRatio = ratio;
    }

    public double getSpringDampingRatio() {
        return this.m_dampingRatio;
    }

    @Override
    public void initVelocityConstraints(SolverData data) {
        this.m_indexA = this.m_bodyA.m_islandIndex;
        this.m_indexB = this.m_bodyB.m_islandIndex;
        this.m_localCenterA.set(this.m_bodyA.m_sweep.localCenter);
        this.m_localCenterB.set(this.m_bodyB.m_sweep.localCenter);
        this.m_invMassA = this.m_bodyA.m_invMass;
        this.m_invMassB = this.m_bodyB.m_invMass;
        this.m_invIA = this.m_bodyA.m_invI;
        this.m_invIB = this.m_bodyB.m_invI;
        double mA = this.m_invMassA;
        double mB = this.m_invMassB;
        double iA = this.m_invIA;
        double iB = this.m_invIB;
        Vec2 cA = data.positions[this.m_indexA].c;
        double aA = data.positions[this.m_indexA].a;
        Vec2 vA = data.velocities[this.m_indexA].v;
        double wA = data.velocities[this.m_indexA].w;
        Vec2 cB = data.positions[this.m_indexB].c;
        double aB = data.positions[this.m_indexB].a;
        Vec2 vB = data.velocities[this.m_indexB].v;
        double wB = data.velocities[this.m_indexB].w;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 temp = this.pool.popVec2();
        qA.set(aA);
        qB.set(aB);
        Rot.mulToOutUnsafe(qA, temp.set(this.m_localAnchorA).subLocal(this.m_localCenterA), this.rA);
        Rot.mulToOutUnsafe(qB, temp.set(this.m_localAnchorB).subLocal(this.m_localCenterB), this.rB);
        this.d.set(cB).addLocal(this.rB).subLocal(cA).subLocal(this.rA);
        Rot.mulToOut(qA, this.m_localYAxisA, this.m_ay);
        this.m_sAy = Vec2.cross(temp.set(this.d).addLocal(this.rA), this.m_ay);
        this.m_sBy = Vec2.cross(this.rB, this.m_ay);
        this.m_mass = mA + mB + iA * this.m_sAy * this.m_sAy + iB * this.m_sBy * this.m_sBy;
        if (this.m_mass > 0.0) {
            this.m_mass = 1.0 / this.m_mass;
        }
        this.m_springMass = 0.0;
        this.m_bias = 0.0;
        this.m_gamma = 0.0;
        if (this.m_frequencyHz > 0.0) {
            Rot.mulToOut(qA, this.m_localXAxisA, this.m_ax);
            this.m_sAx = Vec2.cross(temp.set(this.d).addLocal(this.rA), this.m_ax);
            this.m_sBx = Vec2.cross(this.rB, this.m_ax);
            double invMass = mA + mB + iA * this.m_sAx * this.m_sAx + iB * this.m_sBx * this.m_sBx;
            if (invMass > 0.0) {
                this.m_springMass = 1.0 / invMass;
                double C = Vec2.dot(this.d, this.m_ax);
                double omega = Math.PI * 2 * this.m_frequencyHz;
                double d = 2.0 * this.m_springMass * this.m_dampingRatio * omega;
                double k = this.m_springMass * omega * omega;
                double h = data.step.dt;
                this.m_gamma = h * (d + h * k);
                if (this.m_gamma > 0.0) {
                    this.m_gamma = 1.0 / this.m_gamma;
                }
                this.m_bias = C * h * k * this.m_gamma;
                this.m_springMass = invMass + this.m_gamma;
                if (this.m_springMass > 0.0) {
                    this.m_springMass = 1.0 / this.m_springMass;
                }
            }
        } else {
            this.m_springImpulse = 0.0;
        }
        if (this.m_enableMotor) {
            this.m_motorMass = iA + iB;
            if (this.m_motorMass > 0.0) {
                this.m_motorMass = 1.0 / this.m_motorMass;
            }
        } else {
            this.m_motorMass = 0.0;
            this.m_motorImpulse = 0.0;
        }
        if (data.step.warmStarting) {
            Vec2 P = this.pool.popVec2();
            this.m_impulse *= data.step.dtRatio;
            this.m_springImpulse *= data.step.dtRatio;
            this.m_motorImpulse *= data.step.dtRatio;
            P.x = this.m_impulse * this.m_ay.x + this.m_springImpulse * this.m_ax.x;
            P.y = this.m_impulse * this.m_ay.y + this.m_springImpulse * this.m_ax.y;
            double LA = this.m_impulse * this.m_sAy + this.m_springImpulse * this.m_sAx + this.m_motorImpulse;
            double LB = this.m_impulse * this.m_sBy + this.m_springImpulse * this.m_sBx + this.m_motorImpulse;
            vA.x -= this.m_invMassA * P.x;
            vA.y -= this.m_invMassA * P.y;
            wA -= this.m_invIA * LA;
            vB.x += this.m_invMassB * P.x;
            vB.y += this.m_invMassB * P.y;
            wB += this.m_invIB * LB;
            this.pool.pushVec2(1);
        } else {
            this.m_impulse = 0.0;
            this.m_springImpulse = 0.0;
            this.m_motorImpulse = 0.0;
        }
        this.pool.pushRot(2);
        this.pool.pushVec2(1);
        data.velocities[this.m_indexA].w = wA;
        data.velocities[this.m_indexB].w = wB;
    }

    @Override
    public void solveVelocityConstraints(SolverData data) {
        double mA = this.m_invMassA;
        double mB = this.m_invMassB;
        double iA = this.m_invIA;
        double iB = this.m_invIB;
        Vec2 vA = data.velocities[this.m_indexA].v;
        double wA = data.velocities[this.m_indexA].w;
        Vec2 vB = data.velocities[this.m_indexB].v;
        double wB = data.velocities[this.m_indexB].w;
        Vec2 temp = this.pool.popVec2();
        Vec2 P = this.pool.popVec2();
        double Cdot = Vec2.dot(this.m_ax, temp.set(vB).subLocal(vA)) + this.m_sBx * wB - this.m_sAx * wA;
        double impulse = -this.m_springMass * (Cdot + this.m_bias + this.m_gamma * this.m_springImpulse);
        this.m_springImpulse += impulse;
        P.x = impulse * this.m_ax.x;
        P.y = impulse * this.m_ax.y;
        double LA = impulse * this.m_sAx;
        double LB = impulse * this.m_sBx;
        vA.x -= mA * P.x;
        vA.y -= mA * P.y;
        vB.x += mB * P.x;
        vB.y += mB * P.y;
        Cdot = (wB += iB * LB) - (wA -= iA * LA) - this.m_motorSpeed;
        impulse = -this.m_motorMass * Cdot;
        double oldImpulse = this.m_motorImpulse;
        double maxImpulse = data.step.dt * this.m_maxMotorTorque;
        this.m_motorImpulse = MathUtils.clamp(this.m_motorImpulse + impulse, -maxImpulse, maxImpulse);
        impulse = this.m_motorImpulse - oldImpulse;
        Cdot = Vec2.dot(this.m_ay, temp.set(vB).subLocal(vA)) + this.m_sBy * (wB += iB * impulse) - this.m_sAy * (wA -= iA * impulse);
        impulse = -this.m_mass * Cdot;
        this.m_impulse += impulse;
        P.x = impulse * this.m_ay.x;
        P.y = impulse * this.m_ay.y;
        LA = impulse * this.m_sAy;
        LB = impulse * this.m_sBy;
        vA.x -= mA * P.x;
        vA.y -= mA * P.y;
        vB.x += mB * P.x;
        vB.y += mB * P.y;
        this.pool.pushVec2(2);
        data.velocities[this.m_indexA].w = wA -= iA * LA;
        data.velocities[this.m_indexB].w = wB += iB * LB;
    }

    @Override
    public boolean solvePositionConstraints(SolverData data) {
        Vec2 cA = data.positions[this.m_indexA].c;
        double aA = data.positions[this.m_indexA].a;
        Vec2 cB = data.positions[this.m_indexB].c;
        double aB = data.positions[this.m_indexB].a;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 temp = this.pool.popVec2();
        qA.set(aA);
        qB.set(aB);
        Rot.mulToOut(qA, temp.set(this.m_localAnchorA).subLocal(this.m_localCenterA), this.rA);
        Rot.mulToOut(qB, temp.set(this.m_localAnchorB).subLocal(this.m_localCenterB), this.rB);
        this.d.set(cB).subLocal(cA).addLocal(this.rB).subLocal(this.rA);
        Vec2 ay = this.pool.popVec2();
        Rot.mulToOut(qA, this.m_localYAxisA, ay);
        double sAy = Vec2.cross(temp.set(this.d).addLocal(this.rA), ay);
        double sBy = Vec2.cross(this.rB, ay);
        double C = Vec2.dot(this.d, ay);
        double k = this.m_invMassA + this.m_invMassB + this.m_invIA * this.m_sAy * this.m_sAy + this.m_invIB * this.m_sBy * this.m_sBy;
        double impulse = k != 0.0 ? -C / k : 0.0;
        Vec2 P = this.pool.popVec2();
        P.x = impulse * ay.x;
        P.y = impulse * ay.y;
        double LA = impulse * sAy;
        double LB = impulse * sBy;
        cA.x -= this.m_invMassA * P.x;
        cA.y -= this.m_invMassA * P.y;
        cB.x += this.m_invMassB * P.x;
        cB.y += this.m_invMassB * P.y;
        this.pool.pushVec2(3);
        this.pool.pushRot(2);
        data.positions[this.m_indexA].a = aA -= this.m_invIA * LA;
        data.positions[this.m_indexB].a = aB += this.m_invIB * LB;
        return MathUtils.abs(C) <= Settings.linearSlop;
    }
}

