/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.particle;

import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.particle.ParticleSystem;

public class ParticleGroup {
    ParticleSystem m_system;
    int m_firstIndex = 0;
    int m_lastIndex = 0;
    int m_groupFlags = 0;
    double m_strength = 1.0;
    ParticleGroup m_prev;
    ParticleGroup m_next;
    int m_timestamp = -1;
    double m_mass = 0.0;
    double m_inertia = 0.0;
    final Vec2 m_center = new Vec2();
    final Vec2 m_linearVelocity = new Vec2();
    double m_angularVelocity = 0.0;
    final Transform m_transform = new Transform();
    boolean m_destroyAutomatically;
    boolean m_toBeDestroyed;
    boolean m_toBeSplit;
    Object m_userData;

    public ParticleGroup() {
        this.m_transform.setIdentity();
        this.m_destroyAutomatically = true;
        this.m_toBeDestroyed = false;
        this.m_toBeSplit = false;
    }

    public ParticleGroup getNext() {
        return this.m_next;
    }

    public int getParticleCount() {
        return this.m_lastIndex - this.m_firstIndex;
    }

    public int getBufferIndex() {
        return this.m_firstIndex;
    }

    public int getGroupFlags() {
        return this.m_groupFlags;
    }

    public void setGroupFlags(int flags) {
        this.m_groupFlags = flags;
    }

    public double getMass() {
        this.updateStatistics();
        return this.m_mass;
    }

    public double getInertia() {
        this.updateStatistics();
        return this.m_inertia;
    }

    public Vec2 getCenter() {
        this.updateStatistics();
        return this.m_center;
    }

    public Vec2 getLinearVelocity() {
        this.updateStatistics();
        return this.m_linearVelocity;
    }

    public double getAngularVelocity() {
        this.updateStatistics();
        return this.m_angularVelocity;
    }

    public Transform getTransform() {
        return this.m_transform;
    }

    public Vec2 getPosition() {
        return this.m_transform.p;
    }

    public double getAngle() {
        return this.m_transform.q.getAngle();
    }

    public Object getUserData() {
        return this.m_userData;
    }

    public void setUserData(Object data) {
        this.m_userData = data;
    }

    public void updateStatistics() {
        if (this.m_timestamp != this.m_system.m_timestamp) {
            Vec2 vel;
            Vec2 pos;
            int i;
            double m = this.m_system.getParticleMass();
            this.m_mass = 0.0;
            this.m_center.setZero();
            this.m_linearVelocity.setZero();
            for (i = this.m_firstIndex; i < this.m_lastIndex; ++i) {
                this.m_mass += m;
                pos = ((Vec2[])this.m_system.m_positionBuffer.data)[i];
                this.m_center.x += m * pos.x;
                this.m_center.y += m * pos.y;
                vel = ((Vec2[])this.m_system.m_velocityBuffer.data)[i];
                this.m_linearVelocity.x += m * vel.x;
                this.m_linearVelocity.y += m * vel.y;
            }
            if (this.m_mass > 0.0) {
                this.m_center.x *= 1.0 / this.m_mass;
                this.m_center.y *= 1.0 / this.m_mass;
                this.m_linearVelocity.x *= 1.0 / this.m_mass;
                this.m_linearVelocity.y *= 1.0 / this.m_mass;
            }
            this.m_inertia = 0.0;
            this.m_angularVelocity = 0.0;
            for (i = this.m_firstIndex; i < this.m_lastIndex; ++i) {
                pos = ((Vec2[])this.m_system.m_positionBuffer.data)[i];
                vel = ((Vec2[])this.m_system.m_velocityBuffer.data)[i];
                double px = pos.x - this.m_center.x;
                double py = pos.y - this.m_center.y;
                double vx = vel.x - this.m_linearVelocity.x;
                double vy = vel.y - this.m_linearVelocity.y;
                this.m_inertia += m * (px * px + py * py);
                this.m_angularVelocity += m * (px * vy - py * vx);
            }
            if (this.m_inertia > 0.0) {
                this.m_angularVelocity *= 1.0 / this.m_inertia;
            }
            this.m_timestamp = this.m_system.m_timestamp;
        }
    }
}

