/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.particle;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.jbox2d.callbacks.ParticleDestructionListener;
import org.jbox2d.callbacks.ParticleQueryCallback;
import org.jbox2d.callbacks.ParticleRaycastCallback;
import org.jbox2d.callbacks.QueryCallback;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.BufferUtils;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.World;
import org.jbox2d.particle.ParticleBodyContact;
import org.jbox2d.particle.ParticleColor;
import org.jbox2d.particle.ParticleContact;
import org.jbox2d.particle.ParticleDef;
import org.jbox2d.particle.ParticleGroup;
import org.jbox2d.particle.ParticleGroupDef;
import org.jbox2d.particle.VoronoiDiagram;

public class ParticleSystem {
    private static final int k_pairFlags = 8;
    private static final int k_triadFlags = 16;
    private static final int k_noPressureFlags = 64;
    static final int xTruncBits = 12;
    static final int yTruncBits = 12;
    static final int tagBits = 31;
    static final long yOffset = 2048L;
    static final int yShift = 19;
    static final int xShift = 7;
    static final long xScale = 128L;
    static final long xOffset = 262144L;
    static final int xMask = 4095;
    static final int yMask = 4095;
    int m_timestamp;
    int m_allParticleFlags;
    int m_allGroupFlags;
    double m_density;
    double m_inverseDensity;
    double m_gravityScale;
    double m_particleDiameter;
    double m_inverseDiameter;
    double m_squaredDiameter;
    int m_count;
    int m_internalAllocatedCapacity;
    int m_maxCount;
    ParticleBufferInt m_flagsBuffer;
    ParticleBuffer<Vec2> m_positionBuffer;
    ParticleBuffer<Vec2> m_velocityBuffer;
    double[] m_accumulationBuffer;
    Vec2[] m_accumulation2Buffer;
    double[] m_depthBuffer;
    public ParticleBuffer<ParticleColor> m_colorBuffer;
    ParticleGroup[] m_groupBuffer;
    ParticleBuffer<Object> m_userDataBuffer;
    int m_proxyCount;
    int m_proxyCapacity;
    Proxy[] m_proxyBuffer;
    public int m_contactCount;
    int m_contactCapacity;
    public ParticleContact[] m_contactBuffer;
    public int m_bodyContactCount;
    int m_bodyContactCapacity;
    public ParticleBodyContact[] m_bodyContactBuffer;
    int m_pairCount;
    int m_pairCapacity;
    Pair[] m_pairBuffer;
    int m_triadCount;
    int m_triadCapacity;
    Triad[] m_triadBuffer;
    int m_groupCount;
    ParticleGroup m_groupList;
    double m_pressureStrength;
    double m_dampingStrength;
    double m_elasticStrength;
    double m_springStrength;
    double m_viscousStrength;
    double m_surfaceTensionStrengthA;
    double m_surfaceTensionStrengthB;
    double m_powderStrength;
    double m_ejectionStrength;
    double m_colorMixingStrength;
    World m_world;
    private final AABB temp = new AABB();
    private final DestroyParticlesInShapeCallback dpcallback = new DestroyParticlesInShapeCallback();
    private final AABB temp2 = new AABB();
    private final Vec2 tempVec = new Vec2();
    private final Transform tempTransform = new Transform();
    private final Transform tempTransform2 = new Transform();
    private CreateParticleGroupCallback createParticleGroupCallback = new CreateParticleGroupCallback();
    private final ParticleDef tempParticleDef = new ParticleDef();
    private final UpdateBodyContactsCallback ubccallback = new UpdateBodyContactsCallback();
    private SolveCollisionCallback sccallback = new SolveCollisionCallback();
    private final Vec2 tempVec2 = new Vec2();
    private final Rot tempRot = new Rot();
    private final Transform tempXf = new Transform();
    private final Transform tempXf2 = new Transform();
    private final NewIndices newIndices = new NewIndices();

    static long computeTag(double x, double y) {
        return ((long)(y + 2048.0) << 19) + ((long)(128.0 * x) + 262144L);
    }

    static long computeRelativeTag(long tag, int x, int y) {
        return tag + (long)(y << 19) + (long)(x << 7);
    }

    static int limitCapacity(int capacity, int maxCount) {
        return maxCount != 0 && capacity > maxCount ? maxCount : capacity;
    }

    public ParticleSystem(World world) {
        this.m_world = world;
        this.m_timestamp = 0;
        this.m_allParticleFlags = 0;
        this.m_allGroupFlags = 0;
        this.m_density = 1.0;
        this.m_inverseDensity = 1.0;
        this.m_gravityScale = 1.0;
        this.m_particleDiameter = 1.0;
        this.m_inverseDiameter = 1.0;
        this.m_squaredDiameter = 1.0;
        this.m_count = 0;
        this.m_internalAllocatedCapacity = 0;
        this.m_maxCount = 0;
        this.m_proxyCount = 0;
        this.m_proxyCapacity = 0;
        this.m_contactCount = 0;
        this.m_contactCapacity = 0;
        this.m_bodyContactCount = 0;
        this.m_bodyContactCapacity = 0;
        this.m_pairCount = 0;
        this.m_pairCapacity = 0;
        this.m_triadCount = 0;
        this.m_triadCapacity = 0;
        this.m_groupCount = 0;
        this.m_pressureStrength = 0.05f;
        this.m_dampingStrength = 1.0;
        this.m_elasticStrength = 0.25;
        this.m_springStrength = 0.25;
        this.m_viscousStrength = 0.25;
        this.m_surfaceTensionStrengthA = 0.1f;
        this.m_surfaceTensionStrengthB = 0.2f;
        this.m_powderStrength = 0.5;
        this.m_ejectionStrength = 0.5;
        this.m_colorMixingStrength = 0.5;
        this.m_flagsBuffer = new ParticleBufferInt();
        this.m_positionBuffer = new ParticleBuffer<Vec2>(Vec2.class);
        this.m_velocityBuffer = new ParticleBuffer<Vec2>(Vec2.class);
        this.m_colorBuffer = new ParticleBuffer<ParticleColor>(ParticleColor.class);
        this.m_userDataBuffer = new ParticleBuffer<Object>(Object.class);
    }

    public int createParticle(ParticleDef def) {
        if (this.m_count >= this.m_internalAllocatedCapacity) {
            int capacity = this.m_count != 0 ? 2 * this.m_count : 256;
            capacity = ParticleSystem.limitCapacity(capacity, this.m_maxCount);
            capacity = ParticleSystem.limitCapacity(capacity, this.m_flagsBuffer.userSuppliedCapacity);
            capacity = ParticleSystem.limitCapacity(capacity, this.m_positionBuffer.userSuppliedCapacity);
            capacity = ParticleSystem.limitCapacity(capacity, this.m_velocityBuffer.userSuppliedCapacity);
            capacity = ParticleSystem.limitCapacity(capacity, this.m_colorBuffer.userSuppliedCapacity);
            if (this.m_internalAllocatedCapacity < (capacity = ParticleSystem.limitCapacity(capacity, this.m_userDataBuffer.userSuppliedCapacity))) {
                this.m_flagsBuffer.data = ParticleSystem.reallocateBuffer(this.m_flagsBuffer, this.m_internalAllocatedCapacity, capacity, false);
                this.m_positionBuffer.data = ParticleSystem.reallocateBuffer(this.m_positionBuffer, this.m_internalAllocatedCapacity, capacity, false);
                this.m_velocityBuffer.data = ParticleSystem.reallocateBuffer(this.m_velocityBuffer, this.m_internalAllocatedCapacity, capacity, false);
                this.m_accumulationBuffer = BufferUtils.reallocateBuffer(this.m_accumulationBuffer, 0, this.m_internalAllocatedCapacity, capacity, false);
                this.m_accumulation2Buffer = BufferUtils.reallocateBuffer(Vec2.class, this.m_accumulation2Buffer, 0, this.m_internalAllocatedCapacity, capacity, true);
                this.m_depthBuffer = BufferUtils.reallocateBuffer(this.m_depthBuffer, 0, this.m_internalAllocatedCapacity, capacity, true);
                this.m_colorBuffer.data = ParticleSystem.reallocateBuffer(this.m_colorBuffer, this.m_internalAllocatedCapacity, capacity, true);
                this.m_groupBuffer = BufferUtils.reallocateBuffer(ParticleGroup.class, this.m_groupBuffer, 0, this.m_internalAllocatedCapacity, capacity, false);
                this.m_userDataBuffer.data = ParticleSystem.reallocateBuffer(this.m_userDataBuffer, this.m_internalAllocatedCapacity, capacity, true);
                this.m_internalAllocatedCapacity = capacity;
            }
        }
        if (this.m_count >= this.m_internalAllocatedCapacity) {
            return -1;
        }
        int index = this.m_count++;
        this.m_flagsBuffer.data[index] = def.flags;
        ((Vec2[])this.m_positionBuffer.data)[index].set(def.position);
        ((Vec2[])this.m_velocityBuffer.data)[index].set(def.velocity);
        this.m_groupBuffer[index] = null;
        if (this.m_depthBuffer != null) {
            this.m_depthBuffer[index] = 0.0;
        }
        if (this.m_colorBuffer.data != null || def.color != null) {
            this.m_colorBuffer.data = this.requestParticleBuffer(this.m_colorBuffer.dataClass, (ParticleColor[])this.m_colorBuffer.data);
            ((ParticleColor[])this.m_colorBuffer.data)[index].set(def.color);
        }
        if (this.m_userDataBuffer.data != null || def.userData != null) {
            this.m_userDataBuffer.data = this.requestParticleBuffer(this.m_userDataBuffer.dataClass, this.m_userDataBuffer.data);
            this.m_userDataBuffer.data[index] = def.userData;
        }
        if (this.m_proxyCount >= this.m_proxyCapacity) {
            int oldCapacity = this.m_proxyCapacity;
            int newCapacity = this.m_proxyCount != 0 ? 2 * this.m_proxyCount : 256;
            this.m_proxyBuffer = BufferUtils.reallocateBuffer(Proxy.class, this.m_proxyBuffer, oldCapacity, newCapacity);
            this.m_proxyCapacity = newCapacity;
        }
        ++this.m_proxyCount;
        this.m_proxyBuffer[this.m_proxyCount].index = index;
        return index;
    }

    public void destroyParticle(int index, boolean callDestructionListener) {
        int flags = 2;
        if (callDestructionListener) {
            flags |= 0x200;
        }
        int n = index;
        this.m_flagsBuffer.data[n] = this.m_flagsBuffer.data[n] | flags;
    }

    public int destroyParticlesInShape(Shape shape, Transform xf, boolean callDestructionListener) {
        this.dpcallback.init(this, shape, xf, callDestructionListener);
        shape.computeAABB(this.temp, xf, 0);
        this.m_world.queryAABB(this.dpcallback, this.temp);
        return this.dpcallback.destroyed;
    }

    public void destroyParticlesInGroup(ParticleGroup group, boolean callDestructionListener) {
        for (int i = group.m_firstIndex; i < group.m_lastIndex; ++i) {
            this.destroyParticle(i, callDestructionListener);
        }
    }

    public ParticleGroup createParticleGroup(ParticleGroupDef groupDef) {
        double stride = this.getParticleStride();
        Transform identity = this.tempTransform;
        identity.setIdentity();
        Transform transform = this.tempTransform2;
        transform.setIdentity();
        int firstIndex = this.m_count;
        if (groupDef.shape != null) {
            ParticleDef particleDef = this.tempParticleDef;
            particleDef.flags = groupDef.flags;
            particleDef.color = groupDef.color;
            particleDef.userData = groupDef.userData;
            Shape shape = groupDef.shape;
            transform.set(groupDef.position, groupDef.angle);
            AABB aabb = this.temp;
            int childCount = shape.getChildCount();
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                if (childIndex == 0) {
                    shape.computeAABB(aabb, identity, childIndex);
                    continue;
                }
                AABB childAABB = this.temp2;
                shape.computeAABB(childAABB, identity, childIndex);
                aabb.combine(childAABB);
            }
            double upperBoundY = aabb.upperBound.y;
            double upperBoundX = aabb.upperBound.x;
            for (double y = (double)MathUtils.floor(aabb.lowerBound.y / stride) * stride; y < upperBoundY; y += stride) {
                for (double x = (double)MathUtils.floor(aabb.lowerBound.x / stride) * stride; x < upperBoundX; x += stride) {
                    Vec2 p = this.tempVec;
                    p.x = x;
                    p.y = y;
                    if (!shape.testPoint(identity, p)) continue;
                    Transform.mulToOut(transform, p, p);
                    particleDef.position.x = p.x;
                    particleDef.position.y = p.y;
                    p.subLocal(groupDef.position);
                    Vec2.crossToOutUnsafe(groupDef.angularVelocity, p, particleDef.velocity);
                    particleDef.velocity.addLocal(groupDef.linearVelocity);
                    this.createParticle(particleDef);
                }
            }
        }
        int lastIndex = this.m_count;
        ParticleGroup group = new ParticleGroup();
        group.m_system = this;
        group.m_firstIndex = firstIndex;
        group.m_lastIndex = lastIndex;
        group.m_groupFlags = groupDef.groupFlags;
        group.m_strength = groupDef.strength;
        group.m_userData = groupDef.userData;
        group.m_transform.set(transform);
        group.m_destroyAutomatically = groupDef.destroyAutomatically;
        group.m_prev = null;
        group.m_next = this.m_groupList;
        if (this.m_groupList != null) {
            this.m_groupList.m_prev = group;
        }
        this.m_groupList = group;
        ++this.m_groupCount;
        for (int i = firstIndex; i < lastIndex; ++i) {
            this.m_groupBuffer[i] = group;
        }
        this.updateContacts(true);
        if ((groupDef.flags & 8) != 0) {
            for (int k = 0; k < this.m_contactCount; ++k) {
                ParticleContact contact = this.m_contactBuffer[k];
                int a = contact.indexA;
                int b = contact.indexB;
                if (a > b) {
                    int temp = a;
                    a = b;
                    b = temp;
                }
                if (firstIndex > a || b >= lastIndex) continue;
                if (this.m_pairCount >= this.m_pairCapacity) {
                    int oldCapacity = this.m_pairCapacity;
                    int newCapacity = this.m_pairCount != 0 ? 2 * this.m_pairCount : 256;
                    this.m_pairBuffer = BufferUtils.reallocateBuffer(Pair.class, this.m_pairBuffer, oldCapacity, newCapacity);
                    this.m_pairCapacity = newCapacity;
                }
                Pair pair = this.m_pairBuffer[this.m_pairCount];
                pair.indexA = a;
                pair.indexB = b;
                pair.flags = contact.flags;
                pair.strength = groupDef.strength;
                pair.distance = MathUtils.distance(((Vec2[])this.m_positionBuffer.data)[a], ((Vec2[])this.m_positionBuffer.data)[b]);
                ++this.m_pairCount;
            }
        }
        if ((groupDef.flags & 0x10) != 0) {
            VoronoiDiagram diagram = new VoronoiDiagram(lastIndex - firstIndex);
            for (int i = firstIndex; i < lastIndex; ++i) {
                diagram.addGenerator(((Vec2[])this.m_positionBuffer.data)[i], i);
            }
            diagram.generate(stride / 2.0);
            this.createParticleGroupCallback.system = this;
            this.createParticleGroupCallback.def = groupDef;
            this.createParticleGroupCallback.firstIndex = firstIndex;
            diagram.getNodes(this.createParticleGroupCallback);
        }
        if ((groupDef.groupFlags & 1) != 0) {
            this.computeDepthForGroup(group);
        }
        return group;
    }

    public void joinParticleGroups(ParticleGroup groupA, ParticleGroup groupB) {
        int groupFlags;
        assert (groupA != groupB);
        this.RotateBuffer(groupB.m_firstIndex, groupB.m_lastIndex, this.m_count);
        assert (groupB.m_lastIndex == this.m_count);
        this.RotateBuffer(groupA.m_firstIndex, groupA.m_lastIndex, groupB.m_firstIndex);
        assert (groupA.m_lastIndex == groupB.m_firstIndex);
        int particleFlags = 0;
        for (int i = groupA.m_firstIndex; i < groupB.m_lastIndex; ++i) {
            particleFlags |= this.m_flagsBuffer.data[i];
        }
        this.updateContacts(true);
        if ((particleFlags & 8) != 0) {
            for (int k = 0; k < this.m_contactCount; ++k) {
                ParticleContact contact = this.m_contactBuffer[k];
                int a = contact.indexA;
                int b = contact.indexB;
                if (a > b) {
                    int temp = a;
                    a = b;
                    b = temp;
                }
                if (groupA.m_firstIndex > a || a >= groupA.m_lastIndex || groupB.m_firstIndex > b || b >= groupB.m_lastIndex) continue;
                if (this.m_pairCount >= this.m_pairCapacity) {
                    int oldCapacity = this.m_pairCapacity;
                    int newCapacity = this.m_pairCount != 0 ? 2 * this.m_pairCount : 256;
                    this.m_pairBuffer = BufferUtils.reallocateBuffer(Pair.class, this.m_pairBuffer, oldCapacity, newCapacity);
                    this.m_pairCapacity = newCapacity;
                }
                Pair pair = this.m_pairBuffer[this.m_pairCount];
                pair.indexA = a;
                pair.indexB = b;
                pair.flags = contact.flags;
                pair.strength = MathUtils.min(groupA.m_strength, groupB.m_strength);
                pair.distance = MathUtils.distance(((Vec2[])this.m_positionBuffer.data)[a], ((Vec2[])this.m_positionBuffer.data)[b]);
                ++this.m_pairCount;
            }
        }
        if ((particleFlags & 0x10) != 0) {
            VoronoiDiagram diagram = new VoronoiDiagram(groupB.m_lastIndex - groupA.m_firstIndex);
            for (int i = groupA.m_firstIndex; i < groupB.m_lastIndex; ++i) {
                if ((this.m_flagsBuffer.data[i] & 2) != 0) continue;
                diagram.addGenerator(((Vec2[])this.m_positionBuffer.data)[i], i);
            }
            diagram.generate(this.getParticleStride() / 2.0);
            JoinParticleGroupsCallback callback = new JoinParticleGroupsCallback();
            callback.system = this;
            callback.groupA = groupA;
            callback.groupB = groupB;
            diagram.getNodes(callback);
        }
        for (int i = groupB.m_firstIndex; i < groupB.m_lastIndex; ++i) {
            this.m_groupBuffer[i] = groupA;
        }
        groupA.m_groupFlags = groupFlags = groupA.m_groupFlags | groupB.m_groupFlags;
        groupA.m_lastIndex = groupB.m_lastIndex;
        groupB.m_firstIndex = groupB.m_lastIndex;
        this.destroyParticleGroup(groupB);
        if ((groupFlags & 1) != 0) {
            this.computeDepthForGroup(groupA);
        }
    }

    void destroyParticleGroup(ParticleGroup group) {
        assert (this.m_groupCount > 0);
        assert (group != null);
        if (this.m_world.getParticleDestructionListener() != null) {
            this.m_world.getParticleDestructionListener().sayGoodbye(group);
        }
        for (int i = group.m_firstIndex; i < group.m_lastIndex; ++i) {
            this.m_groupBuffer[i] = null;
        }
        if (group.m_prev != null) {
            group.m_prev.m_next = group.m_next;
        }
        if (group.m_next != null) {
            group.m_next.m_prev = group.m_prev;
        }
        if (group == this.m_groupList) {
            this.m_groupList = group.m_next;
        }
        --this.m_groupCount;
    }

    public void computeDepthForGroup(ParticleGroup group) {
        int i;
        for (i = group.m_firstIndex; i < group.m_lastIndex; ++i) {
            this.m_accumulationBuffer[i] = 0.0;
        }
        for (int k = 0; k < this.m_contactCount; ++k) {
            ParticleContact contact = this.m_contactBuffer[k];
            int a = contact.indexA;
            int b = contact.indexB;
            if (a < group.m_firstIndex || a >= group.m_lastIndex || b < group.m_firstIndex || b >= group.m_lastIndex) continue;
            double w = contact.weight;
            int n = a;
            this.m_accumulationBuffer[n] = this.m_accumulationBuffer[n] + w;
            int n2 = b;
            this.m_accumulationBuffer[n2] = this.m_accumulationBuffer[n2] + w;
        }
        this.m_depthBuffer = this.requestParticleBuffer(this.m_depthBuffer);
        for (i = group.m_firstIndex; i < group.m_lastIndex; ++i) {
            double w = this.m_accumulationBuffer[i];
            this.m_depthBuffer[i] = w < (double)0.8f ? 0.0 : Double.MAX_VALUE;
        }
        int interationCount = group.getParticleCount();
        for (int t = 0; t < interationCount; ++t) {
            boolean updated = false;
            for (int k = 0; k < this.m_contactCount; ++k) {
                ParticleContact contact = this.m_contactBuffer[k];
                int a = contact.indexA;
                int b = contact.indexB;
                if (a < group.m_firstIndex || a >= group.m_lastIndex || b < group.m_firstIndex || b >= group.m_lastIndex) continue;
                double r = 1.0 - contact.weight;
                double ap0 = this.m_depthBuffer[a];
                double bp0 = this.m_depthBuffer[b];
                double ap1 = bp0 + r;
                double bp1 = ap0 + r;
                if (ap0 > ap1) {
                    this.m_depthBuffer[a] = ap1;
                    updated = true;
                }
                if (!(bp0 > bp1)) continue;
                this.m_depthBuffer[b] = bp1;
                updated = true;
            }
            if (!updated) break;
        }
        for (int i2 = group.m_firstIndex; i2 < group.m_lastIndex; ++i2) {
            double p = this.m_depthBuffer[i2];
            if (p < Double.MAX_VALUE) {
                int n = i2;
                this.m_depthBuffer[n] = this.m_depthBuffer[n] * this.m_particleDiameter;
                continue;
            }
            this.m_depthBuffer[i2] = 0.0;
        }
    }

    public void addContact(int a, int b) {
        assert (a != b);
        Vec2 pa = ((Vec2[])this.m_positionBuffer.data)[a];
        Vec2 pb = ((Vec2[])this.m_positionBuffer.data)[b];
        double dx = pb.x - pa.x;
        double dy = pb.y - pa.y;
        double d2 = dx * dx + dy * dy;
        if (d2 < this.m_squaredDiameter) {
            if (this.m_contactCount >= this.m_contactCapacity) {
                int oldCapacity = this.m_contactCapacity;
                int newCapacity = this.m_contactCount != 0 ? 2 * this.m_contactCount : 256;
                this.m_contactBuffer = BufferUtils.reallocateBuffer(ParticleContact.class, this.m_contactBuffer, oldCapacity, newCapacity);
                this.m_contactCapacity = newCapacity;
            }
            double invD = d2 != 0.0 ? MathUtils.sqrt(1.0 / d2) : Double.MAX_VALUE;
            ParticleContact contact = this.m_contactBuffer[this.m_contactCount];
            contact.indexA = a;
            contact.indexB = b;
            contact.flags = this.m_flagsBuffer.data[a] | this.m_flagsBuffer.data[b];
            contact.weight = 1.0 - d2 * invD * this.m_inverseDiameter;
            contact.normal.x = invD * dx;
            contact.normal.y = invD * dy;
            ++this.m_contactCount;
        }
    }

    public void updateContacts(boolean exceptZombie) {
        for (int p = 0; p < this.m_proxyCount; ++p) {
            Proxy proxy = this.m_proxyBuffer[p];
            int i = proxy.index;
            Vec2 pos = ((Vec2[])this.m_positionBuffer.data)[i];
            proxy.tag = ParticleSystem.computeTag(this.m_inverseDiameter * pos.x, this.m_inverseDiameter * pos.y);
        }
        Arrays.sort(this.m_proxyBuffer, 0, this.m_proxyCount);
        this.m_contactCount = 0;
        int c_index = 0;
        block1: for (int i = 0; i < this.m_proxyCount; ++i) {
            Proxy a = this.m_proxyBuffer[i];
            long rightTag = ParticleSystem.computeRelativeTag(a.tag, 1, 0);
            for (int j = i + 1; j < this.m_proxyCount; ++j) {
                Proxy b = this.m_proxyBuffer[j];
                if (rightTag < b.tag) break;
                this.addContact(a.index, b.index);
            }
            long bottomLeftTag = ParticleSystem.computeRelativeTag(a.tag, -1, 1);
            while (c_index < this.m_proxyCount) {
                Proxy c = this.m_proxyBuffer[c_index];
                if (bottomLeftTag <= c.tag) break;
                ++c_index;
            }
            long bottomRightTag = ParticleSystem.computeRelativeTag(a.tag, 1, 1);
            for (int b_index = c_index; b_index < this.m_proxyCount; ++b_index) {
                Proxy b = this.m_proxyBuffer[b_index];
                if (bottomRightTag < b.tag) continue block1;
                this.addContact(a.index, b.index);
            }
        }
        if (exceptZombie) {
            int j = this.m_contactCount;
            for (int i = 0; i < j; ++i) {
                if ((this.m_contactBuffer[i].flags & 2) == 0) continue;
                ParticleContact temp = this.m_contactBuffer[--j];
                this.m_contactBuffer[j] = this.m_contactBuffer[i];
                this.m_contactBuffer[i] = temp;
                --i;
            }
            this.m_contactCount = j;
        }
    }

    public void updateBodyContacts() {
        AABB aabb = this.temp;
        aabb.lowerBound.x = Double.MAX_VALUE;
        aabb.lowerBound.y = Double.MAX_VALUE;
        aabb.upperBound.x = -1.7976931348623157E308;
        aabb.upperBound.y = -1.7976931348623157E308;
        for (int i = 0; i < this.m_count; ++i) {
            Vec2 p = ((Vec2[])this.m_positionBuffer.data)[i];
            Vec2.minToOut(aabb.lowerBound, p, aabb.lowerBound);
            Vec2.maxToOut(aabb.upperBound, p, aabb.upperBound);
        }
        aabb.lowerBound.x -= this.m_particleDiameter;
        aabb.lowerBound.y -= this.m_particleDiameter;
        aabb.upperBound.x += this.m_particleDiameter;
        aabb.upperBound.y += this.m_particleDiameter;
        this.m_bodyContactCount = 0;
        this.ubccallback.system = this;
        this.m_world.queryAABB(this.ubccallback, aabb);
    }

    public void solveCollision(TimeStep step) {
        AABB aabb = this.temp;
        Vec2 lowerBound = aabb.lowerBound;
        Vec2 upperBound = aabb.upperBound;
        lowerBound.x = Double.MAX_VALUE;
        lowerBound.y = Double.MAX_VALUE;
        upperBound.x = -1.7976931348623157E308;
        upperBound.y = -1.7976931348623157E308;
        for (int i = 0; i < this.m_count; ++i) {
            Vec2 v = ((Vec2[])this.m_velocityBuffer.data)[i];
            Vec2 p1 = ((Vec2[])this.m_positionBuffer.data)[i];
            double p1x = p1.x;
            double p1y = p1.y;
            double p2x = p1x + step.dt * v.x;
            double p2y = p1y + step.dt * v.y;
            double bx = p1x < p2x ? p1x : p2x;
            double by = p1y < p2y ? p1y : p2y;
            lowerBound.x = lowerBound.x < bx ? lowerBound.x : bx;
            lowerBound.y = lowerBound.y < by ? lowerBound.y : by;
            double b1x = p1x > p2x ? p1x : p2x;
            double b1y = p1y > p2y ? p1y : p2y;
            upperBound.x = upperBound.x > b1x ? upperBound.x : b1x;
            upperBound.y = upperBound.y > b1y ? upperBound.y : b1y;
        }
        this.sccallback.step = step;
        this.sccallback.system = this;
        this.m_world.queryAABB(this.sccallback, aabb);
    }

    public void solve(TimeStep step) {
        int i;
        ++this.m_timestamp;
        if (this.m_count == 0) {
            return;
        }
        this.m_allParticleFlags = 0;
        for (int i2 = 0; i2 < this.m_count; ++i2) {
            this.m_allParticleFlags |= this.m_flagsBuffer.data[i2];
        }
        if ((this.m_allParticleFlags & 2) != 0) {
            this.solveZombie();
        }
        if (this.m_count == 0) {
            return;
        }
        this.m_allGroupFlags = 0;
        for (ParticleGroup group = this.m_groupList; group != null; group = group.getNext()) {
            this.m_allGroupFlags |= group.m_groupFlags;
        }
        double gravityx = step.dt * this.m_gravityScale * this.m_world.getGravity().x;
        double gravityy = step.dt * this.m_gravityScale * this.m_world.getGravity().y;
        double criticalVelocytySquared = this.getCriticalVelocitySquared(step);
        for (i = 0; i < this.m_count; ++i) {
            Vec2 v = ((Vec2[])this.m_velocityBuffer.data)[i];
            v.x += gravityx;
            v.y += gravityy;
            double v2 = v.x * v.x + v.y * v.y;
            if (!(v2 > criticalVelocytySquared)) continue;
            double a = v2 == 0.0 ? Double.MAX_VALUE : MathUtils.sqrt(criticalVelocytySquared / v2);
            v.x *= a;
            v.y *= a;
        }
        this.solveCollision(step);
        if ((this.m_allGroupFlags & 2) != 0) {
            this.solveRigid(step);
        }
        if ((this.m_allParticleFlags & 4) != 0) {
            this.solveWall(step);
        }
        for (i = 0; i < this.m_count; ++i) {
            Vec2 pos = ((Vec2[])this.m_positionBuffer.data)[i];
            Vec2 vel = ((Vec2[])this.m_velocityBuffer.data)[i];
            pos.x += step.dt * vel.x;
            pos.y += step.dt * vel.y;
        }
        this.updateBodyContacts();
        this.updateContacts(false);
        if ((this.m_allParticleFlags & 0x20) != 0) {
            this.solveViscous(step);
        }
        if ((this.m_allParticleFlags & 0x40) != 0) {
            this.solvePowder(step);
        }
        if ((this.m_allParticleFlags & 0x80) != 0) {
            this.solveTensile(step);
        }
        if ((this.m_allParticleFlags & 0x10) != 0) {
            this.solveElastic(step);
        }
        if ((this.m_allParticleFlags & 8) != 0) {
            this.solveSpring(step);
        }
        if ((this.m_allGroupFlags & 1) != 0) {
            this.solveSolid(step);
        }
        if ((this.m_allParticleFlags & 0x100) != 0) {
            this.solveColorMixing(step);
        }
        this.solvePressure(step);
        this.solveDamping(step);
    }

    void solvePressure(TimeStep step) {
        double w;
        int a;
        int k;
        int a2;
        Object contact;
        int k2;
        int i;
        for (i = 0; i < this.m_count; ++i) {
            this.m_accumulationBuffer[i] = 0.0;
        }
        for (k2 = 0; k2 < this.m_bodyContactCount; ++k2) {
            contact = this.m_bodyContactBuffer[k2];
            a2 = ((ParticleBodyContact)contact).index;
            double w2 = ((ParticleBodyContact)contact).weight;
            int n = a2;
            this.m_accumulationBuffer[n] = this.m_accumulationBuffer[n] + w2;
        }
        for (k2 = 0; k2 < this.m_contactCount; ++k2) {
            contact = this.m_contactBuffer[k2];
            a2 = ((ParticleContact)contact).indexA;
            int b = ((ParticleContact)contact).indexB;
            double w3 = ((ParticleContact)contact).weight;
            int n = a2;
            this.m_accumulationBuffer[n] = this.m_accumulationBuffer[n] + w3;
            int n2 = b;
            this.m_accumulationBuffer[n2] = this.m_accumulationBuffer[n2] + w3;
        }
        if ((this.m_allParticleFlags & 0x40) != 0) {
            for (i = 0; i < this.m_count; ++i) {
                if ((this.m_flagsBuffer.data[i] & 0x40) == 0) continue;
                this.m_accumulationBuffer[i] = 0.0;
            }
        }
        double pressurePerWeight = this.m_pressureStrength * this.getCriticalPressure(step);
        for (int i2 = 0; i2 < this.m_count; ++i2) {
            double h;
            double w4 = this.m_accumulationBuffer[i2];
            this.m_accumulationBuffer[i2] = h = pressurePerWeight * MathUtils.max(0.0, MathUtils.min(w4, 5.0) - 1.0);
        }
        double velocityPerPressure = step.dt / (this.m_density * this.m_particleDiameter);
        for (k = 0; k < this.m_bodyContactCount; ++k) {
            ParticleBodyContact contact2 = this.m_bodyContactBuffer[k];
            a = contact2.index;
            Body b = contact2.body;
            w = contact2.weight;
            double m = contact2.mass;
            Vec2 n = contact2.normal;
            Vec2 p = ((Vec2[])this.m_positionBuffer.data)[a];
            double h = this.m_accumulationBuffer[a] + pressurePerWeight * w;
            Vec2 f = this.tempVec;
            double coef = velocityPerPressure * w * m * h;
            f.x = coef * n.x;
            f.y = coef * n.y;
            Vec2 velData = ((Vec2[])this.m_velocityBuffer.data)[a];
            double particleInvMass = this.getParticleInvMass();
            velData.x -= particleInvMass * f.x;
            velData.y -= particleInvMass * f.y;
            b.applyLinearImpulse(f, p, true);
        }
        for (k = 0; k < this.m_contactCount; ++k) {
            ParticleContact contact3 = this.m_contactBuffer[k];
            a = contact3.indexA;
            int b = contact3.indexB;
            w = contact3.weight;
            Vec2 n = contact3.normal;
            double h = this.m_accumulationBuffer[a] + this.m_accumulationBuffer[b];
            double fx = velocityPerPressure * w * h * n.x;
            double fy = velocityPerPressure * w * h * n.y;
            Vec2 velDataA = ((Vec2[])this.m_velocityBuffer.data)[a];
            Vec2 velDataB = ((Vec2[])this.m_velocityBuffer.data)[b];
            velDataA.x -= fx;
            velDataA.y -= fy;
            velDataB.x += fx;
            velDataB.y += fy;
        }
    }

    void solveDamping(TimeStep step) {
        double w;
        int a;
        Object contact;
        int k;
        double damping = this.m_dampingStrength;
        for (k = 0; k < this.m_bodyContactCount; ++k) {
            contact = this.m_bodyContactBuffer[k];
            a = ((ParticleBodyContact)contact).index;
            Body b = ((ParticleBodyContact)contact).body;
            w = ((ParticleBodyContact)contact).weight;
            double m = ((ParticleBodyContact)contact).mass;
            Vec2 n = ((ParticleBodyContact)contact).normal;
            Vec2 p = ((Vec2[])this.m_positionBuffer.data)[a];
            double tempX = p.x - b.m_sweep.c.x;
            double tempY = p.y - b.m_sweep.c.y;
            Vec2 velA = ((Vec2[])this.m_velocityBuffer.data)[a];
            double vx = -b.m_angularVelocity * tempY + b.m_linearVelocity.x - velA.x;
            double vy = b.m_angularVelocity * tempX + b.m_linearVelocity.y - velA.y;
            double vn = vx * n.x + vy * n.y;
            if (!(vn < 0.0)) continue;
            Vec2 f = this.tempVec;
            f.x = damping * w * m * vn * n.x;
            f.y = damping * w * m * vn * n.y;
            double invMass = this.getParticleInvMass();
            velA.x += invMass * f.x;
            velA.y += invMass * f.y;
            f.x = -f.x;
            f.y = -f.y;
            b.applyLinearImpulse(f, p, true);
        }
        for (k = 0; k < this.m_contactCount; ++k) {
            contact = this.m_contactBuffer[k];
            a = ((ParticleContact)contact).indexA;
            int b = ((ParticleContact)contact).indexB;
            w = ((ParticleContact)contact).weight;
            Vec2 n = ((ParticleContact)contact).normal;
            Vec2 velA = ((Vec2[])this.m_velocityBuffer.data)[a];
            Vec2 velB = ((Vec2[])this.m_velocityBuffer.data)[b];
            double vx = velB.x - velA.x;
            double vy = velB.y - velA.y;
            double vn = vx * n.x + vy * n.y;
            if (!(vn < 0.0)) continue;
            double fx = damping * w * vn * n.x;
            double fy = damping * w * vn * n.y;
            velA.x += fx;
            velA.y += fy;
            velB.x -= fx;
            velB.y -= fy;
        }
    }

    public void solveWall(TimeStep step) {
        for (int i = 0; i < this.m_count; ++i) {
            if ((this.m_flagsBuffer.data[i] & 4) == 0) continue;
            Vec2 r = ((Vec2[])this.m_velocityBuffer.data)[i];
            r.x = 0.0;
            r.y = 0.0;
        }
    }

    void solveRigid(TimeStep step) {
        for (ParticleGroup group = this.m_groupList; group != null; group = group.getNext()) {
            if ((group.m_groupFlags & 2) == 0) continue;
            group.updateStatistics();
            Vec2 temp = this.tempVec;
            Vec2 cross = this.tempVec2;
            Rot rotation = this.tempRot;
            rotation.set(step.dt * group.m_angularVelocity);
            Rot.mulToOutUnsafe(rotation, group.m_center, cross);
            temp.set(group.m_linearVelocity).mulLocal(step.dt).addLocal(group.m_center).subLocal(cross);
            this.tempXf.p.set(temp);
            this.tempXf.q.set(rotation);
            Transform.mulToOut(this.tempXf, group.m_transform, group.m_transform);
            Transform velocityTransform = this.tempXf2;
            velocityTransform.p.x = step.inv_dt * this.tempXf.p.x;
            velocityTransform.p.y = step.inv_dt * this.tempXf.p.y;
            velocityTransform.q.s = step.inv_dt * this.tempXf.q.s;
            velocityTransform.q.c = step.inv_dt * (this.tempXf.q.c - 1.0);
            for (int i = group.m_firstIndex; i < group.m_lastIndex; ++i) {
                Transform.mulToOutUnsafe(velocityTransform, ((Vec2[])this.m_positionBuffer.data)[i], ((Vec2[])this.m_velocityBuffer.data)[i]);
            }
        }
    }

    void solveElastic(TimeStep step) {
        double elasticStrength = step.inv_dt * this.m_elasticStrength;
        for (int k = 0; k < this.m_triadCount; ++k) {
            double rc;
            Triad triad = this.m_triadBuffer[k];
            if ((triad.flags & 0x10) == 0) continue;
            int a = triad.indexA;
            int b = triad.indexB;
            int c = triad.indexC;
            Vec2 oa = triad.pa;
            Vec2 ob = triad.pb;
            Vec2 oc = triad.pc;
            Vec2 pa = ((Vec2[])this.m_positionBuffer.data)[a];
            Vec2 pb = ((Vec2[])this.m_positionBuffer.data)[b];
            Vec2 pc = ((Vec2[])this.m_positionBuffer.data)[c];
            double px = 0.3333333432674408 * (pa.x + pb.x + pc.x);
            double py = 0.3333333432674408 * (pa.y + pb.y + pc.y);
            double rs = Vec2.cross(oa, pa) + Vec2.cross(ob, pb) + Vec2.cross(oc, pc);
            double r2 = rs * rs + (rc = Vec2.dot(oa, pa) + Vec2.dot(ob, pb) + Vec2.dot(oc, pc)) * rc;
            double invR = r2 == 0.0 ? Double.MAX_VALUE : MathUtils.sqrt(1.0 / r2);
            double strength = elasticStrength * triad.strength;
            double roax = (rc *= invR) * oa.x - (rs *= invR) * oa.y;
            double roay = rs * oa.x + rc * oa.y;
            double robx = rc * ob.x - rs * ob.y;
            double roby = rs * ob.x + rc * ob.y;
            double rocx = rc * oc.x - rs * oc.y;
            double rocy = rs * oc.x + rc * oc.y;
            Vec2 va = ((Vec2[])this.m_velocityBuffer.data)[a];
            Vec2 vb = ((Vec2[])this.m_velocityBuffer.data)[b];
            Vec2 vc = ((Vec2[])this.m_velocityBuffer.data)[c];
            va.x += strength * (roax - (pa.x - px));
            va.y += strength * (roay - (pa.y - py));
            vb.x += strength * (robx - (pb.x - px));
            vb.y += strength * (roby - (pb.y - py));
            vc.x += strength * (rocx - (pc.x - px));
            vc.y += strength * (rocy - (pc.y - py));
        }
    }

    void solveSpring(TimeStep step) {
        double springStrength = step.inv_dt * this.m_springStrength;
        for (int k = 0; k < this.m_pairCount; ++k) {
            Pair pair = this.m_pairBuffer[k];
            if ((pair.flags & 8) == 0) continue;
            int a = pair.indexA;
            int b = pair.indexB;
            Vec2 pa = ((Vec2[])this.m_positionBuffer.data)[a];
            Vec2 pb = ((Vec2[])this.m_positionBuffer.data)[b];
            double dx = pb.x - pa.x;
            double dy = pb.y - pa.y;
            double r0 = pair.distance;
            double r1 = MathUtils.sqrt(dx * dx + dy * dy);
            if (r1 == 0.0) {
                r1 = Double.MAX_VALUE;
            }
            double strength = springStrength * pair.strength;
            double fx = strength * (r0 - r1) / r1 * dx;
            double fy = strength * (r0 - r1) / r1 * dy;
            Vec2 va = ((Vec2[])this.m_velocityBuffer.data)[a];
            Vec2 vb = ((Vec2[])this.m_velocityBuffer.data)[b];
            va.x -= fx;
            va.y -= fy;
            vb.x += fx;
            vb.y += fy;
        }
    }

    void solveTensile(TimeStep step) {
        this.m_accumulation2Buffer = this.requestParticleBuffer(Vec2.class, this.m_accumulation2Buffer);
        for (int i = 0; i < this.m_count; ++i) {
            this.m_accumulationBuffer[i] = 0.0;
            this.m_accumulation2Buffer[i].setZero();
        }
        for (int k = 0; k < this.m_contactCount; ++k) {
            ParticleContact contact = this.m_contactBuffer[k];
            if ((contact.flags & 0x80) == 0) continue;
            int a = contact.indexA;
            int b = contact.indexB;
            double w = contact.weight;
            Vec2 n = contact.normal;
            int n2 = a;
            this.m_accumulationBuffer[n2] = this.m_accumulationBuffer[n2] + w;
            int n3 = b;
            this.m_accumulationBuffer[n3] = this.m_accumulationBuffer[n3] + w;
            Vec2 a2A = this.m_accumulation2Buffer[a];
            Vec2 a2B = this.m_accumulation2Buffer[b];
            double inter = (1.0 - w) * w;
            a2A.x -= inter * n.x;
            a2A.y -= inter * n.y;
            a2B.x += inter * n.x;
            a2B.y += inter * n.y;
        }
        double strengthA = this.m_surfaceTensionStrengthA * this.getCriticalVelocity(step);
        double strengthB = this.m_surfaceTensionStrengthB * this.getCriticalVelocity(step);
        for (int k = 0; k < this.m_contactCount; ++k) {
            ParticleContact contact = this.m_contactBuffer[k];
            if ((contact.flags & 0x80) == 0) continue;
            int a = contact.indexA;
            int b = contact.indexB;
            double w = contact.weight;
            Vec2 n = contact.normal;
            Vec2 a2A = this.m_accumulation2Buffer[a];
            Vec2 a2B = this.m_accumulation2Buffer[b];
            double h = this.m_accumulationBuffer[a] + this.m_accumulationBuffer[b];
            double sx = a2B.x - a2A.x;
            double sy = a2B.y - a2A.y;
            double fn = (strengthA * (h - 2.0) + strengthB * (sx * n.x + sy * n.y)) * w;
            double fx = fn * n.x;
            double fy = fn * n.y;
            Vec2 va = ((Vec2[])this.m_velocityBuffer.data)[a];
            Vec2 vb = ((Vec2[])this.m_velocityBuffer.data)[b];
            va.x -= fx;
            va.y -= fy;
            vb.x += fx;
            vb.y += fy;
        }
    }

    void solveViscous(TimeStep step) {
        double w;
        int a;
        Object contact;
        int k;
        double viscousStrength = this.m_viscousStrength;
        for (k = 0; k < this.m_bodyContactCount; ++k) {
            contact = this.m_bodyContactBuffer[k];
            a = ((ParticleBodyContact)contact).index;
            if ((this.m_flagsBuffer.data[a] & 0x20) == 0) continue;
            Body b = ((ParticleBodyContact)contact).body;
            w = ((ParticleBodyContact)contact).weight;
            double m = ((ParticleBodyContact)contact).mass;
            Vec2 p = ((Vec2[])this.m_positionBuffer.data)[a];
            Vec2 va = ((Vec2[])this.m_velocityBuffer.data)[a];
            double tempX = p.x - b.m_sweep.c.x;
            double tempY = p.y - b.m_sweep.c.y;
            double vx = -b.m_angularVelocity * tempY + b.m_linearVelocity.x - va.x;
            double vy = b.m_angularVelocity * tempX + b.m_linearVelocity.y - va.y;
            Vec2 f = this.tempVec;
            double pInvMass = this.getParticleInvMass();
            f.x = viscousStrength * m * w * vx;
            f.y = viscousStrength * m * w * vy;
            va.x += pInvMass * f.x;
            va.y += pInvMass * f.y;
            f.x = -f.x;
            f.y = -f.y;
            b.applyLinearImpulse(f, p, true);
        }
        for (k = 0; k < this.m_contactCount; ++k) {
            contact = this.m_contactBuffer[k];
            if ((((ParticleContact)contact).flags & 0x20) == 0) continue;
            a = ((ParticleContact)contact).indexA;
            int b = ((ParticleContact)contact).indexB;
            w = ((ParticleContact)contact).weight;
            Vec2 va = ((Vec2[])this.m_velocityBuffer.data)[a];
            Vec2 vb = ((Vec2[])this.m_velocityBuffer.data)[b];
            double vx = vb.x - va.x;
            double vy = vb.y - va.y;
            double fx = viscousStrength * w * vx;
            double fy = viscousStrength * w * vy;
            va.x += fx;
            va.y += fy;
            vb.x -= fx;
            vb.y -= fy;
        }
    }

    void solvePowder(TimeStep step) {
        Object contact;
        int k;
        double powderStrength = this.m_powderStrength * this.getCriticalVelocity(step);
        double minWeight = 0.25;
        for (k = 0; k < this.m_bodyContactCount; ++k) {
            double w;
            contact = this.m_bodyContactBuffer[k];
            int a = ((ParticleBodyContact)contact).index;
            if ((this.m_flagsBuffer.data[a] & 0x40) == 0 || !((w = ((ParticleBodyContact)contact).weight) > minWeight)) continue;
            Body b = ((ParticleBodyContact)contact).body;
            double m = ((ParticleBodyContact)contact).mass;
            Vec2 p = ((Vec2[])this.m_positionBuffer.data)[a];
            Vec2 n = ((ParticleBodyContact)contact).normal;
            Vec2 f = this.tempVec;
            Vec2 va = ((Vec2[])this.m_velocityBuffer.data)[a];
            double inter = powderStrength * m * (w - minWeight);
            double pInvMass = this.getParticleInvMass();
            f.x = inter * n.x;
            f.y = inter * n.y;
            va.x -= pInvMass * f.x;
            va.y -= pInvMass * f.y;
            b.applyLinearImpulse(f, p, true);
        }
        for (k = 0; k < this.m_contactCount; ++k) {
            double w;
            contact = this.m_contactBuffer[k];
            if ((((ParticleContact)contact).flags & 0x40) == 0 || !((w = ((ParticleContact)contact).weight) > minWeight)) continue;
            int a = ((ParticleContact)contact).indexA;
            int b = ((ParticleContact)contact).indexB;
            Vec2 n = ((ParticleContact)contact).normal;
            Vec2 va = ((Vec2[])this.m_velocityBuffer.data)[a];
            Vec2 vb = ((Vec2[])this.m_velocityBuffer.data)[b];
            double inter = powderStrength * (w - minWeight);
            double fx = inter * n.x;
            double fy = inter * n.y;
            va.x -= fx;
            va.y -= fy;
            vb.x += fx;
            vb.y += fy;
        }
    }

    void solveSolid(TimeStep step) {
        this.m_depthBuffer = this.requestParticleBuffer(this.m_depthBuffer);
        double ejectionStrength = step.inv_dt * this.m_ejectionStrength;
        for (int k = 0; k < this.m_contactCount; ++k) {
            ParticleContact contact = this.m_contactBuffer[k];
            int a = contact.indexA;
            int b = contact.indexB;
            if (this.m_groupBuffer[a] == this.m_groupBuffer[b]) continue;
            double w = contact.weight;
            Vec2 n = contact.normal;
            double h = this.m_depthBuffer[a] + this.m_depthBuffer[b];
            Vec2 va = ((Vec2[])this.m_velocityBuffer.data)[a];
            Vec2 vb = ((Vec2[])this.m_velocityBuffer.data)[b];
            double inter = ejectionStrength * h * w;
            double fx = inter * n.x;
            double fy = inter * n.y;
            va.x -= fx;
            va.y -= fy;
            vb.x += fx;
            vb.y += fy;
        }
    }

    void solveColorMixing(TimeStep step) {
        this.m_colorBuffer.data = this.requestParticleBuffer(ParticleColor.class, (ParticleColor[])this.m_colorBuffer.data);
        int colorMixing256 = (int)(256.0 * this.m_colorMixingStrength);
        for (int k = 0; k < this.m_contactCount; ++k) {
            ParticleContact contact = this.m_contactBuffer[k];
            int a = contact.indexA;
            int b = contact.indexB;
            if ((this.m_flagsBuffer.data[a] & this.m_flagsBuffer.data[b] & 0x100) == 0) continue;
            ParticleColor colorA = ((ParticleColor[])this.m_colorBuffer.data)[a];
            ParticleColor colorB = ((ParticleColor[])this.m_colorBuffer.data)[b];
            int dr = colorMixing256 * ((colorB.r & 0xFF) - (colorA.r & 0xFF)) >> 8;
            int dg = colorMixing256 * ((colorB.g & 0xFF) - (colorA.g & 0xFF)) >> 8;
            int db = colorMixing256 * ((colorB.b & 0xFF) - (colorA.b & 0xFF)) >> 8;
            int da = colorMixing256 * ((colorB.a & 0xFF) - (colorA.a & 0xFF)) >> 8;
            colorA.r = (byte)(colorA.r + dr);
            colorA.g = (byte)(colorA.g + dg);
            colorA.b = (byte)(colorA.b + db);
            colorA.a = (byte)(colorA.a + da);
            colorB.r = (byte)(colorB.r - dr);
            colorB.g = (byte)(colorB.g - dg);
            colorB.b = (byte)(colorB.b - db);
            colorB.a = (byte)(colorB.a - da);
        }
    }

    void solveZombie() {
        ParticleGroup group;
        Object contact;
        int k;
        Object temp;
        int i;
        int newCount = 0;
        int[] newIndices = new int[this.m_count];
        for (int i2 = 0; i2 < this.m_count; ++i2) {
            int flags = this.m_flagsBuffer.data[i2];
            if ((flags & 2) != 0) {
                ParticleDestructionListener destructionListener = this.m_world.getParticleDestructionListener();
                if ((flags & 0x200) != 0 && destructionListener != null) {
                    destructionListener.sayGoodbye(i2);
                }
                newIndices[i2] = -1;
                continue;
            }
            newIndices[i2] = newCount;
            if (i2 != newCount) {
                this.m_flagsBuffer.data[newCount] = this.m_flagsBuffer.data[i2];
                ((Vec2[])this.m_positionBuffer.data)[newCount].set(((Vec2[])this.m_positionBuffer.data)[i2]);
                ((Vec2[])this.m_velocityBuffer.data)[newCount].set(((Vec2[])this.m_velocityBuffer.data)[i2]);
                this.m_groupBuffer[newCount] = this.m_groupBuffer[i2];
                if (this.m_depthBuffer != null) {
                    this.m_depthBuffer[newCount] = this.m_depthBuffer[i2];
                }
                if (this.m_colorBuffer.data != null) {
                    ((ParticleColor[])this.m_colorBuffer.data)[newCount].set(((ParticleColor[])this.m_colorBuffer.data)[i2]);
                }
                if (this.m_userDataBuffer.data != null) {
                    this.m_userDataBuffer.data[newCount] = this.m_userDataBuffer.data[i2];
                }
            }
            ++newCount;
        }
        for (int k2 = 0; k2 < this.m_proxyCount; ++k2) {
            Proxy proxy = this.m_proxyBuffer[k2];
            proxy.index = newIndices[proxy.index];
        }
        int j = this.m_proxyCount;
        for (i = 0; i < j; ++i) {
            if (!Test.IsProxyInvalid(this.m_proxyBuffer[i])) continue;
            temp = this.m_proxyBuffer[--j];
            this.m_proxyBuffer[j] = this.m_proxyBuffer[i];
            this.m_proxyBuffer[i] = temp;
            --i;
        }
        this.m_proxyCount = j;
        for (k = 0; k < this.m_contactCount; ++k) {
            contact = this.m_contactBuffer[k];
            ((ParticleContact)contact).indexA = newIndices[((ParticleContact)contact).indexA];
            ((ParticleContact)contact).indexB = newIndices[((ParticleContact)contact).indexB];
        }
        j = this.m_contactCount;
        for (i = 0; i < j; ++i) {
            if (!Test.IsContactInvalid(this.m_contactBuffer[i])) continue;
            temp = this.m_contactBuffer[--j];
            this.m_contactBuffer[j] = this.m_contactBuffer[i];
            this.m_contactBuffer[i] = temp;
            --i;
        }
        this.m_contactCount = j;
        for (k = 0; k < this.m_bodyContactCount; ++k) {
            contact = this.m_bodyContactBuffer[k];
            ((ParticleBodyContact)contact).index = newIndices[((ParticleBodyContact)contact).index];
        }
        j = this.m_bodyContactCount;
        for (i = 0; i < j; ++i) {
            if (!Test.IsBodyContactInvalid(this.m_bodyContactBuffer[i])) continue;
            temp = this.m_bodyContactBuffer[--j];
            this.m_bodyContactBuffer[j] = this.m_bodyContactBuffer[i];
            this.m_bodyContactBuffer[i] = temp;
            --i;
        }
        this.m_bodyContactCount = j;
        for (k = 0; k < this.m_pairCount; ++k) {
            Pair pair = this.m_pairBuffer[k];
            pair.indexA = newIndices[pair.indexA];
            pair.indexB = newIndices[pair.indexB];
        }
        j = this.m_pairCount;
        for (i = 0; i < j; ++i) {
            if (!Test.IsPairInvalid(this.m_pairBuffer[i])) continue;
            temp = this.m_pairBuffer[--j];
            this.m_pairBuffer[j] = this.m_pairBuffer[i];
            this.m_pairBuffer[i] = temp;
            --i;
        }
        this.m_pairCount = j;
        for (k = 0; k < this.m_triadCount; ++k) {
            Triad triad = this.m_triadBuffer[k];
            triad.indexA = newIndices[triad.indexA];
            triad.indexB = newIndices[triad.indexB];
            triad.indexC = newIndices[triad.indexC];
        }
        j = this.m_triadCount;
        for (i = 0; i < j; ++i) {
            if (!Test.IsTriadInvalid(this.m_triadBuffer[i])) continue;
            temp = this.m_triadBuffer[--j];
            this.m_triadBuffer[j] = this.m_triadBuffer[i];
            this.m_triadBuffer[i] = temp;
            --i;
        }
        this.m_triadCount = j;
        for (group = this.m_groupList; group != null; group = group.getNext()) {
            int firstIndex = newCount;
            int lastIndex = 0;
            boolean modified = false;
            for (int i3 = group.m_firstIndex; i3 < group.m_lastIndex; ++i3) {
                j = newIndices[i3];
                if (j >= 0) {
                    firstIndex = MathUtils.min(firstIndex, j);
                    lastIndex = MathUtils.max(lastIndex, j + 1);
                    continue;
                }
                modified = true;
            }
            if (firstIndex < lastIndex) {
                group.m_firstIndex = firstIndex;
                group.m_lastIndex = lastIndex;
                if (!modified || (group.m_groupFlags & 2) == 0) continue;
                group.m_toBeSplit = true;
                continue;
            }
            group.m_firstIndex = 0;
            group.m_lastIndex = 0;
            if (!group.m_destroyAutomatically) continue;
            group.m_toBeDestroyed = true;
        }
        this.m_count = newCount;
        group = this.m_groupList;
        while (group != null) {
            ParticleGroup next = group.getNext();
            if (group.m_toBeDestroyed) {
                this.destroyParticleGroup(group);
            } else if (group.m_toBeSplit) {
                // empty if block
            }
            group = next;
        }
    }

    void RotateBuffer(int start, int mid, int end) {
        Object contact;
        int k;
        if (start == mid || mid == end) {
            return;
        }
        this.newIndices.start = start;
        this.newIndices.mid = mid;
        this.newIndices.end = end;
        BufferUtils.rotate(this.m_flagsBuffer.data, start, mid, end);
        BufferUtils.rotate((Vec2[])this.m_positionBuffer.data, start, mid, end);
        BufferUtils.rotate((Vec2[])this.m_velocityBuffer.data, start, mid, end);
        BufferUtils.rotate(this.m_groupBuffer, start, mid, end);
        if (this.m_depthBuffer != null) {
            BufferUtils.rotate(this.m_depthBuffer, start, mid, end);
        }
        if (this.m_colorBuffer.data != null) {
            BufferUtils.rotate((ParticleColor[])this.m_colorBuffer.data, start, mid, end);
        }
        if (this.m_userDataBuffer.data != null) {
            BufferUtils.rotate(this.m_userDataBuffer.data, start, mid, end);
        }
        for (k = 0; k < this.m_proxyCount; ++k) {
            Proxy proxy = this.m_proxyBuffer[k];
            proxy.index = this.newIndices.getIndex(proxy.index);
        }
        for (k = 0; k < this.m_contactCount; ++k) {
            contact = this.m_contactBuffer[k];
            ((ParticleContact)contact).indexA = this.newIndices.getIndex(((ParticleContact)contact).indexA);
            ((ParticleContact)contact).indexB = this.newIndices.getIndex(((ParticleContact)contact).indexB);
        }
        for (k = 0; k < this.m_bodyContactCount; ++k) {
            contact = this.m_bodyContactBuffer[k];
            ((ParticleBodyContact)contact).index = this.newIndices.getIndex(((ParticleBodyContact)contact).index);
        }
        for (k = 0; k < this.m_pairCount; ++k) {
            Pair pair = this.m_pairBuffer[k];
            pair.indexA = this.newIndices.getIndex(pair.indexA);
            pair.indexB = this.newIndices.getIndex(pair.indexB);
        }
        for (k = 0; k < this.m_triadCount; ++k) {
            Triad triad = this.m_triadBuffer[k];
            triad.indexA = this.newIndices.getIndex(triad.indexA);
            triad.indexB = this.newIndices.getIndex(triad.indexB);
            triad.indexC = this.newIndices.getIndex(triad.indexC);
        }
        for (ParticleGroup group = this.m_groupList; group != null; group = group.getNext()) {
            group.m_firstIndex = this.newIndices.getIndex(group.m_firstIndex);
            group.m_lastIndex = this.newIndices.getIndex(group.m_lastIndex - 1) + 1;
        }
    }

    public void setParticleRadius(double radius) {
        this.m_particleDiameter = 2.0 * radius;
        this.m_squaredDiameter = this.m_particleDiameter * this.m_particleDiameter;
        this.m_inverseDiameter = 1.0 / this.m_particleDiameter;
    }

    public void setParticleDensity(double density) {
        this.m_density = density;
        this.m_inverseDensity = 1.0 / this.m_density;
    }

    public double getParticleDensity() {
        return this.m_density;
    }

    public void setParticleGravityScale(double gravityScale) {
        this.m_gravityScale = gravityScale;
    }

    public double getParticleGravityScale() {
        return this.m_gravityScale;
    }

    public void setParticleDamping(double damping) {
        this.m_dampingStrength = damping;
    }

    public double getParticleDamping() {
        return this.m_dampingStrength;
    }

    public double getParticleRadius() {
        return this.m_particleDiameter / 2.0;
    }

    double getCriticalVelocity(TimeStep step) {
        return this.m_particleDiameter * step.inv_dt;
    }

    double getCriticalVelocitySquared(TimeStep step) {
        double velocity = this.getCriticalVelocity(step);
        return velocity * velocity;
    }

    double getCriticalPressure(TimeStep step) {
        return this.m_density * this.getCriticalVelocitySquared(step);
    }

    double getParticleStride() {
        return 0.75 * this.m_particleDiameter;
    }

    double getParticleMass() {
        double stride = this.getParticleStride();
        return this.m_density * stride * stride;
    }

    double getParticleInvMass() {
        return (double)1.777777f * this.m_inverseDensity * this.m_inverseDiameter * this.m_inverseDiameter;
    }

    public int[] getParticleFlagsBuffer() {
        return this.m_flagsBuffer.data;
    }

    public Vec2[] getParticlePositionBuffer() {
        return (Vec2[])this.m_positionBuffer.data;
    }

    public Vec2[] getParticleVelocityBuffer() {
        return (Vec2[])this.m_velocityBuffer.data;
    }

    public ParticleColor[] getParticleColorBuffer() {
        this.m_colorBuffer.data = this.requestParticleBuffer(ParticleColor.class, (ParticleColor[])this.m_colorBuffer.data);
        return (ParticleColor[])this.m_colorBuffer.data;
    }

    public Object[] getParticleUserDataBuffer() {
        this.m_userDataBuffer.data = this.requestParticleBuffer(Object.class, this.m_userDataBuffer.data);
        return this.m_userDataBuffer.data;
    }

    public int getParticleMaxCount() {
        return this.m_maxCount;
    }

    public void setParticleMaxCount(int count) {
        assert (this.m_count <= count);
        this.m_maxCount = count;
    }

    void setParticleBuffer(ParticleBufferInt buffer, int[] newData, int newCapacity) {
        assert (newData != null && newCapacity != 0 || newData == null && newCapacity == 0);
        if (buffer.userSuppliedCapacity != 0) {
            // empty if block
        }
        buffer.data = newData;
        buffer.userSuppliedCapacity = newCapacity;
    }

    <T> void setParticleBuffer(ParticleBuffer<T> buffer, T[] newData, int newCapacity) {
        assert (newData != null && newCapacity != 0 || newData == null && newCapacity == 0);
        if (buffer.userSuppliedCapacity != 0) {
            // empty if block
        }
        buffer.data = newData;
        buffer.userSuppliedCapacity = newCapacity;
    }

    public void setParticleFlagsBuffer(int[] buffer, int capacity) {
        this.setParticleBuffer(this.m_flagsBuffer, buffer, capacity);
    }

    public void setParticlePositionBuffer(Vec2[] buffer, int capacity) {
        this.setParticleBuffer(this.m_positionBuffer, buffer, capacity);
    }

    public void setParticleVelocityBuffer(Vec2[] buffer, int capacity) {
        this.setParticleBuffer(this.m_velocityBuffer, buffer, capacity);
    }

    public void setParticleColorBuffer(ParticleColor[] buffer, int capacity) {
        this.setParticleBuffer(this.m_colorBuffer, buffer, capacity);
    }

    public ParticleGroup[] getParticleGroupBuffer() {
        return this.m_groupBuffer;
    }

    public int getParticleGroupCount() {
        return this.m_groupCount;
    }

    public ParticleGroup[] getParticleGroupList() {
        return this.m_groupBuffer;
    }

    public int getParticleCount() {
        return this.m_count;
    }

    public void setParticleUserDataBuffer(Object[] buffer, int capacity) {
        this.setParticleBuffer(this.m_userDataBuffer, buffer, capacity);
    }

    private static final int lowerBound(Proxy[] ray, int length, long tag) {
        int left = 0;
        while (length > 0) {
            int step = length / 2;
            int curr = left + step;
            if (ray[curr].tag < tag) {
                left = curr + 1;
                length -= step + 1;
                continue;
            }
            length = step;
        }
        return left;
    }

    private static final int upperBound(Proxy[] ray, int length, long tag) {
        int left = 0;
        while (length > 0) {
            int step = length / 2;
            int curr = left + step;
            if (ray[curr].tag <= tag) {
                left = curr + 1;
                length -= step + 1;
                continue;
            }
            length = step;
        }
        return left;
    }

    public void queryAABB(ParticleQueryCallback callback, AABB aabb) {
        if (this.m_proxyCount == 0) {
            return;
        }
        double lowerBoundX = aabb.lowerBound.x;
        double lowerBoundY = aabb.lowerBound.y;
        double upperBoundX = aabb.upperBound.x;
        double upperBoundY = aabb.upperBound.y;
        int firstProxy = ParticleSystem.lowerBound(this.m_proxyBuffer, this.m_proxyCount, ParticleSystem.computeTag(this.m_inverseDiameter * lowerBoundX, this.m_inverseDiameter * lowerBoundY));
        int lastProxy = ParticleSystem.upperBound(this.m_proxyBuffer, this.m_proxyCount, ParticleSystem.computeTag(this.m_inverseDiameter * upperBoundX, this.m_inverseDiameter * upperBoundY));
        for (int proxy = firstProxy; proxy < lastProxy; ++proxy) {
            int i = this.m_proxyBuffer[proxy].index;
            Vec2 p = ((Vec2[])this.m_positionBuffer.data)[i];
            if (lowerBoundX < p.x && p.x < upperBoundX && lowerBoundY < p.y && p.y < upperBoundY && !callback.reportParticle(i)) break;
        }
    }

    public void raycast(ParticleRaycastCallback callback, Vec2 point1, Vec2 point2) {
        if (this.m_proxyCount == 0) {
            return;
        }
        int firstProxy = ParticleSystem.lowerBound(this.m_proxyBuffer, this.m_proxyCount, ParticleSystem.computeTag(this.m_inverseDiameter * MathUtils.min(point1.x, point2.x) - 1.0, this.m_inverseDiameter * MathUtils.min(point1.y, point2.y) - 1.0));
        int lastProxy = ParticleSystem.upperBound(this.m_proxyBuffer, this.m_proxyCount, ParticleSystem.computeTag(this.m_inverseDiameter * MathUtils.max(point1.x, point2.x) + 1.0, this.m_inverseDiameter * MathUtils.max(point1.y, point2.y) + 1.0));
        double fraction = 1.0;
        double vx = point2.x - point1.x;
        double vy = point2.y - point1.y;
        double v2 = vx * vx + vy * vy;
        if (v2 == 0.0) {
            v2 = Double.MAX_VALUE;
        }
        for (int proxy = firstProxy; proxy < lastProxy; ++proxy) {
            double sqrtDeterminant;
            double t;
            int i = this.m_proxyBuffer[proxy].index;
            Vec2 posI = ((Vec2[])this.m_positionBuffer.data)[i];
            double px = point1.x - posI.x;
            double py = point1.y - posI.y;
            double pv = px * vx + py * vy;
            double p2 = px * px + py * py;
            double determinant = pv * pv - v2 * (p2 - this.m_squaredDiameter);
            if (!(determinant >= 0.0) || (t = (-pv - (sqrtDeterminant = MathUtils.sqrt(determinant))) / v2) > fraction || t < 0.0 && ((t = (-pv + sqrtDeterminant) / v2) < 0.0 || t > fraction)) continue;
            Vec2 n = this.tempVec;
            this.tempVec.x = px + t * vx;
            this.tempVec.y = py + t * vy;
            n.normalize();
            Vec2 point = this.tempVec2;
            point.x = point1.x + t * vx;
            point.y = point1.y + t * vy;
            double f = callback.reportParticle(i, point, n, t);
            fraction = MathUtils.min(fraction, f);
            if (fraction <= 0.0) break;
        }
    }

    public double computeParticleCollisionEnergy() {
        double sum_v2 = 0.0;
        for (int k = 0; k < this.m_contactCount; ++k) {
            ParticleContact contact = this.m_contactBuffer[k];
            int a = contact.indexA;
            int b = contact.indexB;
            Vec2 n = contact.normal;
            Vec2 va = ((Vec2[])this.m_velocityBuffer.data)[a];
            Vec2 vb = ((Vec2[])this.m_velocityBuffer.data)[b];
            double vx = vb.x - va.x;
            double vy = vb.y - va.y;
            double vn = vx * n.x + vy * n.y;
            if (!(vn < 0.0)) continue;
            sum_v2 += vn * vn;
        }
        return 0.5 * this.getParticleMass() * sum_v2;
    }

    static <T> T[] reallocateBuffer(ParticleBuffer<T> buffer, int oldCapacity, int newCapacity, boolean deferred) {
        assert (newCapacity > oldCapacity);
        return BufferUtils.reallocateBuffer(buffer.dataClass, buffer.data, buffer.userSuppliedCapacity, oldCapacity, newCapacity, deferred);
    }

    static int[] reallocateBuffer(ParticleBufferInt buffer, int oldCapacity, int newCapacity, boolean deferred) {
        assert (newCapacity > oldCapacity);
        return BufferUtils.reallocateBuffer(buffer.data, buffer.userSuppliedCapacity, oldCapacity, newCapacity, deferred);
    }

    <T> T[] requestParticleBuffer(Class<T> klass, T[] buffer) {
        if (buffer == null) {
            buffer = (Object[])Array.newInstance(klass, this.m_internalAllocatedCapacity);
            for (int i = 0; i < this.m_internalAllocatedCapacity; ++i) {
                try {
                    buffer[i] = klass.newInstance();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return buffer;
    }

    double[] requestParticleBuffer(double[] buffer) {
        if (buffer == null) {
            buffer = new double[this.m_internalAllocatedCapacity];
        }
        return buffer;
    }

    static class Test {
        Test() {
        }

        static boolean IsProxyInvalid(Proxy proxy) {
            return proxy.index < 0;
        }

        static boolean IsContactInvalid(ParticleContact contact) {
            return contact.indexA < 0 || contact.indexB < 0;
        }

        static boolean IsBodyContactInvalid(ParticleBodyContact contact) {
            return contact.index < 0;
        }

        static boolean IsPairInvalid(Pair pair) {
            return pair.indexA < 0 || pair.indexB < 0;
        }

        static boolean IsTriadInvalid(Triad triad) {
            return triad.indexA < 0 || triad.indexB < 0 || triad.indexC < 0;
        }
    }

    static class SolveCollisionCallback
    implements QueryCallback {
        ParticleSystem system;
        TimeStep step;
        private final RayCastInput input = new RayCastInput();
        private final RayCastOutput output = new RayCastOutput();
        private final Vec2 tempVec = new Vec2();
        private final Vec2 tempVec2 = new Vec2();

        SolveCollisionCallback() {
        }

        @Override
        public boolean reportFixture(Fixture fixture) {
            if (fixture.isSensor()) {
                return true;
            }
            Shape shape = fixture.getShape();
            Body body = fixture.getBody();
            int childCount = shape.getChildCount();
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                AABB aabb = fixture.getAABB(childIndex);
                double aabblowerBoundx = aabb.lowerBound.x - this.system.m_particleDiameter;
                double aabblowerBoundy = aabb.lowerBound.y - this.system.m_particleDiameter;
                double aabbupperBoundx = aabb.upperBound.x + this.system.m_particleDiameter;
                double aabbupperBoundy = aabb.upperBound.y + this.system.m_particleDiameter;
                int firstProxy = ParticleSystem.lowerBound(this.system.m_proxyBuffer, this.system.m_proxyCount, ParticleSystem.computeTag(this.system.m_inverseDiameter * aabblowerBoundx, this.system.m_inverseDiameter * aabblowerBoundy));
                int lastProxy = ParticleSystem.upperBound(this.system.m_proxyBuffer, this.system.m_proxyCount, ParticleSystem.computeTag(this.system.m_inverseDiameter * aabbupperBoundx, this.system.m_inverseDiameter * aabbupperBoundy));
                for (int proxy = firstProxy; proxy != lastProxy; ++proxy) {
                    int a = this.system.m_proxyBuffer[proxy].index;
                    Vec2 ap = ((Vec2[])this.system.m_positionBuffer.data)[a];
                    if (!(aabblowerBoundx <= ap.x) || !(ap.x <= aabbupperBoundx) || !(aabblowerBoundy <= ap.y) || !(ap.y <= aabbupperBoundy)) continue;
                    Vec2 av = ((Vec2[])this.system.m_velocityBuffer.data)[a];
                    Vec2 temp = this.tempVec;
                    Transform.mulTransToOutUnsafe(body.m_xf0, ap, temp);
                    Transform.mulToOutUnsafe(body.m_xf, temp, this.input.p1);
                    this.input.p2.x = ap.x + this.step.dt * av.x;
                    this.input.p2.y = ap.y + this.step.dt * av.y;
                    this.input.maxFraction = 1.0;
                    if (!fixture.raycast(this.output, this.input, childIndex)) continue;
                    Vec2 p = this.tempVec;
                    p.x = (1.0 - this.output.fraction) * this.input.p1.x + this.output.fraction * this.input.p2.x + Settings.linearSlop * this.output.normal.x;
                    p.y = (1.0 - this.output.fraction) * this.input.p1.y + this.output.fraction * this.input.p2.y + Settings.linearSlop * this.output.normal.y;
                    double vx = this.step.inv_dt * (p.x - ap.x);
                    double vy = this.step.inv_dt * (p.y - ap.y);
                    av.x = vx;
                    av.y = vy;
                    double particleMass = this.system.getParticleMass();
                    double ax = particleMass * (av.x - vx);
                    double ay = particleMass * (av.y - vy);
                    Vec2 b = this.output.normal;
                    double fdn = ax * b.x + ay * b.y;
                    Vec2 f = this.tempVec2;
                    f.x = fdn * b.x;
                    f.y = fdn * b.y;
                    body.applyLinearImpulse(f, p, true);
                }
            }
            return true;
        }
    }

    static class UpdateBodyContactsCallback
    implements QueryCallback {
        ParticleSystem system;
        private final Vec2 tempVec = new Vec2();

        UpdateBodyContactsCallback() {
        }

        @Override
        public boolean reportFixture(Fixture fixture) {
            if (fixture.isSensor()) {
                return true;
            }
            Shape shape = fixture.getShape();
            Body b = fixture.getBody();
            Vec2 bp = b.getWorldCenter();
            double bm = b.getMass();
            double bI = b.getInertia() - bm * b.getLocalCenter().lengthSquared();
            double invBm = bm > 0.0 ? 1.0 / bm : 0.0;
            double invBI = bI > 0.0 ? 1.0 / bI : 0.0;
            int childCount = shape.getChildCount();
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                AABB aabb = fixture.getAABB(childIndex);
                double aabblowerBoundx = aabb.lowerBound.x - this.system.m_particleDiameter;
                double aabblowerBoundy = aabb.lowerBound.y - this.system.m_particleDiameter;
                double aabbupperBoundx = aabb.upperBound.x + this.system.m_particleDiameter;
                double aabbupperBoundy = aabb.upperBound.y + this.system.m_particleDiameter;
                int firstProxy = ParticleSystem.lowerBound(this.system.m_proxyBuffer, this.system.m_proxyCount, ParticleSystem.computeTag(this.system.m_inverseDiameter * aabblowerBoundx, this.system.m_inverseDiameter * aabblowerBoundy));
                int lastProxy = ParticleSystem.upperBound(this.system.m_proxyBuffer, this.system.m_proxyCount, ParticleSystem.computeTag(this.system.m_inverseDiameter * aabbupperBoundx, this.system.m_inverseDiameter * aabbupperBoundy));
                for (int proxy = firstProxy; proxy != lastProxy; ++proxy) {
                    Vec2 n;
                    double d;
                    int a = this.system.m_proxyBuffer[proxy].index;
                    Vec2 ap = ((Vec2[])this.system.m_positionBuffer.data)[a];
                    if (!(aabblowerBoundx <= ap.x) || !(ap.x <= aabbupperBoundx) || !(aabblowerBoundy <= ap.y) || !(ap.y <= aabbupperBoundy) || !((d = fixture.computeDistance(ap, childIndex, n = this.tempVec)) < this.system.m_particleDiameter)) continue;
                    double invAm = (this.system.m_flagsBuffer.data[a] & 4) != 0 ? 0.0 : this.system.getParticleInvMass();
                    double rpx = ap.x - bp.x;
                    double rpy = ap.y - bp.y;
                    double rpn = rpx * n.y - rpy * n.x;
                    if (this.system.m_bodyContactCount >= this.system.m_bodyContactCapacity) {
                        int oldCapacity = this.system.m_bodyContactCapacity;
                        int newCapacity = this.system.m_bodyContactCount != 0 ? 2 * this.system.m_bodyContactCount : 256;
                        this.system.m_bodyContactBuffer = BufferUtils.reallocateBuffer(ParticleBodyContact.class, this.system.m_bodyContactBuffer, oldCapacity, newCapacity);
                        this.system.m_bodyContactCapacity = newCapacity;
                    }
                    ParticleBodyContact contact = this.system.m_bodyContactBuffer[this.system.m_bodyContactCount];
                    contact.index = a;
                    contact.body = b;
                    contact.weight = 1.0 - d * this.system.m_inverseDiameter;
                    contact.normal.x = -n.x;
                    contact.normal.y = -n.y;
                    contact.mass = 1.0 / (invAm + invBm + invBI * rpn * rpn);
                    ++this.system.m_bodyContactCount;
                }
            }
            return true;
        }
    }

    static class DestroyParticlesInShapeCallback
    implements ParticleQueryCallback {
        ParticleSystem system;
        Shape shape;
        Transform xf;
        boolean callDestructionListener;
        int destroyed;

        public void init(ParticleSystem system, Shape shape, Transform xf, boolean callDestructionListener) {
            this.system = system;
            this.shape = shape;
            this.xf = xf;
            this.destroyed = 0;
            this.callDestructionListener = callDestructionListener;
        }

        @Override
        public boolean reportParticle(int index) {
            assert (index >= 0 && index < this.system.m_count);
            if (this.shape.testPoint(this.xf, ((Vec2[])this.system.m_positionBuffer.data)[index])) {
                this.system.destroyParticle(index, this.callDestructionListener);
                ++this.destroyed;
            }
            return true;
        }
    }

    static class JoinParticleGroupsCallback
    implements VoronoiDiagram.VoronoiDiagramCallback {
        ParticleSystem system;
        ParticleGroup groupA;
        ParticleGroup groupB;

        JoinParticleGroupsCallback() {
        }

        @Override
        public void callback(int a, int b, int c) {
            int cf;
            int bf;
            int af;
            int countA = (a < this.groupB.m_firstIndex ? 1 : 0) + (b < this.groupB.m_firstIndex ? 1 : 0) + (c < this.groupB.m_firstIndex ? 1 : 0);
            if (countA > 0 && countA < 3 && ((af = this.system.m_flagsBuffer.data[a]) & (bf = this.system.m_flagsBuffer.data[b]) & (cf = this.system.m_flagsBuffer.data[c]) & 0x10) != 0) {
                Vec2 pa = ((Vec2[])this.system.m_positionBuffer.data)[a];
                Vec2 pb = ((Vec2[])this.system.m_positionBuffer.data)[b];
                Vec2 pc = ((Vec2[])this.system.m_positionBuffer.data)[c];
                double dabx = pa.x - pb.x;
                double daby = pa.y - pb.y;
                double dbcx = pb.x - pc.x;
                double dbcy = pb.y - pc.y;
                double dcax = pc.x - pa.x;
                double dcay = pc.y - pa.y;
                double maxDistanceSquared = 4.0 * this.system.m_squaredDiameter;
                if (dabx * dabx + daby * daby < maxDistanceSquared && dbcx * dbcx + dbcy * dbcy < maxDistanceSquared && dcax * dcax + dcay * dcay < maxDistanceSquared) {
                    if (this.system.m_triadCount >= this.system.m_triadCapacity) {
                        int oldCapacity = this.system.m_triadCapacity;
                        int newCapacity = this.system.m_triadCount != 0 ? 2 * this.system.m_triadCount : 256;
                        this.system.m_triadBuffer = BufferUtils.reallocateBuffer(Triad.class, this.system.m_triadBuffer, oldCapacity, newCapacity);
                        this.system.m_triadCapacity = newCapacity;
                    }
                    Triad triad = this.system.m_triadBuffer[this.system.m_triadCount];
                    triad.indexA = a;
                    triad.indexB = b;
                    triad.indexC = c;
                    triad.flags = af | bf | cf;
                    triad.strength = MathUtils.min(this.groupA.m_strength, this.groupB.m_strength);
                    double midPointx = 0.3333333333333333 * (pa.x + pb.x + pc.x);
                    double midPointy = 0.3333333333333333 * (pa.y + pb.y + pc.y);
                    triad.pa.x = pa.x - midPointx;
                    triad.pa.y = pa.y - midPointy;
                    triad.pb.x = pb.x - midPointx;
                    triad.pb.y = pb.y - midPointy;
                    triad.pc.x = pc.x - midPointx;
                    triad.pc.y = pc.y - midPointy;
                    triad.ka = -(dcax * dabx + dcay * daby);
                    triad.kb = -(dabx * dbcx + daby * dbcy);
                    triad.kc = -(dbcx * dcax + dbcy * dcay);
                    triad.s = Vec2.cross(pa, pb) + Vec2.cross(pb, pc) + Vec2.cross(pc, pa);
                    ++this.system.m_triadCount;
                }
            }
        }
    }

    static class CreateParticleGroupCallback
    implements VoronoiDiagram.VoronoiDiagramCallback {
        ParticleSystem system;
        ParticleGroupDef def;
        int firstIndex;

        CreateParticleGroupCallback() {
        }

        @Override
        public void callback(int a, int b, int c) {
            Vec2 pa = ((Vec2[])this.system.m_positionBuffer.data)[a];
            Vec2 pb = ((Vec2[])this.system.m_positionBuffer.data)[b];
            Vec2 pc = ((Vec2[])this.system.m_positionBuffer.data)[c];
            double dabx = pa.x - pb.x;
            double daby = pa.y - pb.y;
            double dbcx = pb.x - pc.x;
            double dbcy = pb.y - pc.y;
            double dcax = pc.x - pa.x;
            double dcay = pc.y - pa.y;
            double maxDistanceSquared = 4.0 * this.system.m_squaredDiameter;
            if (dabx * dabx + daby * daby < maxDistanceSquared && dbcx * dbcx + dbcy * dbcy < maxDistanceSquared && dcax * dcax + dcay * dcay < maxDistanceSquared) {
                if (this.system.m_triadCount >= this.system.m_triadCapacity) {
                    int oldCapacity = this.system.m_triadCapacity;
                    int newCapacity = this.system.m_triadCount != 0 ? 2 * this.system.m_triadCount : 256;
                    this.system.m_triadBuffer = BufferUtils.reallocateBuffer(Triad.class, this.system.m_triadBuffer, oldCapacity, newCapacity);
                    this.system.m_triadCapacity = newCapacity;
                }
                Triad triad = this.system.m_triadBuffer[this.system.m_triadCount];
                triad.indexA = a;
                triad.indexB = b;
                triad.indexC = c;
                triad.flags = this.system.m_flagsBuffer.data[a] | this.system.m_flagsBuffer.data[b] | this.system.m_flagsBuffer.data[c];
                triad.strength = this.def.strength;
                double midPointx = 0.3333333333333333 * (pa.x + pb.x + pc.x);
                double midPointy = 0.3333333333333333 * (pa.y + pb.y + pc.y);
                triad.pa.x = pa.x - midPointx;
                triad.pa.y = pa.y - midPointy;
                triad.pb.x = pb.x - midPointx;
                triad.pb.y = pb.y - midPointy;
                triad.pc.x = pc.x - midPointx;
                triad.pc.y = pc.y - midPointy;
                triad.ka = -(dcax * dabx + dcay * daby);
                triad.kb = -(dabx * dbcx + daby * dbcy);
                triad.kc = -(dbcx * dcax + dbcy * dcay);
                triad.s = Vec2.cross(pa, pb) + Vec2.cross(pb, pc) + Vec2.cross(pc, pa);
                ++this.system.m_triadCount;
            }
        }
    }

    public static class Triad {
        int indexA;
        int indexB;
        int indexC;
        int flags;
        double strength;
        final Vec2 pa = new Vec2();
        final Vec2 pb = new Vec2();
        final Vec2 pc = new Vec2();
        double ka;
        double kb;
        double kc;
        double s;
    }

    public static class Pair {
        int indexA;
        int indexB;
        int flags;
        double strength;
        double distance;
    }

    public static class Proxy
    implements Comparable<Proxy> {
        int index;
        long tag;

        @Override
        public int compareTo(Proxy o) {
            return this.tag - o.tag < 0L ? -1 : (o.tag == this.tag ? 0 : 1);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Proxy other = (Proxy)obj;
            return this.tag == other.tag;
        }
    }

    static class ParticleBufferInt {
        int[] data;
        int userSuppliedCapacity;

        ParticleBufferInt() {
        }
    }

    public static class ParticleBuffer<T> {
        public T[] data;
        final Class<T> dataClass;
        int userSuppliedCapacity;

        public ParticleBuffer(Class<T> dataClass) {
            this.dataClass = dataClass;
        }
    }

    private static class NewIndices {
        int start;
        int mid;
        int end;

        private NewIndices() {
        }

        final int getIndex(int i) {
            if (i < this.start) {
                return i;
            }
            if (i < this.mid) {
                return i + this.end - this.mid;
            }
            if (i < this.end) {
                return i + this.start - this.mid;
            }
            return i;
        }
    }
}

