/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework.jogl;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.util.awt.TextRenderer;
import java.awt.Font;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.IViewportTransform;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.particle.ParticleColor;
import org.jbox2d.testbed.framework.jogl.JoglPanel;

public class JoglDebugDraw
extends DebugDraw {
    private final JoglPanel panel;
    private final TextRenderer text;
    private static final int NUM_CIRCLE_POINTS = 13;
    private final double[] mat = new double[16];
    private final Vec2 zero = new Vec2();
    private final Vec2 temp = new Vec2();
    private final Vec2 temp2 = new Vec2();

    public JoglDebugDraw(JoglPanel panel) {
        this.panel = panel;
        this.text = new TextRenderer(new Font("Courier New", 0, 12));
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[2] = 0.0;
        this.mat[6] = 0.0;
        this.mat[10] = 1.0;
        this.mat[14] = 0.0;
        this.mat[3] = 0.0;
        this.mat[7] = 0.0;
        this.mat[11] = 0.0;
        this.mat[15] = 1.0;
    }

    public void setViewportTransform(IViewportTransform viewportTransform) {
        viewportTransform.setYFlip(false);
        super.setViewportTransform(viewportTransform);
    }

    public void transformViewport(GL2 gl, Vec2 center) {
        Vec2 e = this.viewportTransform.getExtents();
        Vec2 vc = this.viewportTransform.getCenter();
        Mat22 vt = this.viewportTransform.getMat22Representation();
        int f = this.viewportTransform.isYFlip() ? -1 : 1;
        this.mat[0] = vt.ex.x;
        this.mat[4] = vt.ey.x;
        this.mat[12] = e.x;
        this.mat[1] = (double)f * vt.ex.y;
        this.mat[5] = (double)f * vt.ey.y;
        this.mat[13] = e.y;
        gl.glMultMatrixd(this.mat, 0);
        gl.glTranslated(center.x - vc.x, center.y - vc.y, 0.0);
    }

    public void drawPoint(Vec2 argPoint, double argRadiusOnScreen, Color3f argColor) {
        Vec2 vec = this.getWorldToScreen(argPoint);
        GL2 gl = this.panel.getGL().getGL2();
        gl.glPointSize((float)argRadiusOnScreen);
        gl.glBegin(0);
        gl.glVertex2d(vec.x, vec.y);
        gl.glEnd();
    }

    public void drawPolygon(Vec2[] vertices, int vertexCount, Color3f color) {
        GL2 gl = this.panel.getGL().getGL2();
        gl.glPushMatrix();
        this.transformViewport(gl, this.zero);
        gl.glBegin(2);
        gl.glColor4d(color.x, color.y, color.z, 1.0);
        for (int i = 0; i < vertexCount; ++i) {
            Vec2 v = vertices[i];
            gl.glVertex2d(v.x, v.y);
        }
        gl.glEnd();
        gl.glPopMatrix();
    }

    public void drawSolidPolygon(Vec2[] vertices, int vertexCount, Color3f color) {
        Vec2 v;
        int i;
        GL2 gl = this.panel.getGL().getGL2();
        gl.glPushMatrix();
        this.transformViewport(gl, this.zero);
        gl.glBegin(6);
        gl.glColor4d(color.x, color.y, color.z, (double)0.4f);
        for (i = 0; i < vertexCount; ++i) {
            v = vertices[i];
            gl.glVertex2d(v.x, v.y);
        }
        gl.glEnd();
        gl.glBegin(2);
        gl.glColor4d(color.x, color.y, color.z, 1.0);
        for (i = 0; i < vertexCount; ++i) {
            v = vertices[i];
            gl.glVertex2d(v.x, v.y);
        }
        gl.glEnd();
        gl.glPopMatrix();
    }

    public void drawCircle(Vec2 center, double radius, Color3f color) {
        GL2 gl = this.panel.getGL().getGL2();
        gl.glPushMatrix();
        this.transformViewport(gl, this.zero);
        double theta = 0.483321946706122;
        double c = MathUtils.cos((double)theta);
        double s = MathUtils.sin((double)theta);
        double x = radius;
        double y = 0.0;
        double cx = center.x;
        double cy = center.y;
        gl.glBegin(2);
        gl.glColor4d(color.x, color.y, color.z, 1.0);
        for (int i = 0; i < 13; ++i) {
            gl.glVertex3d(x + cx, y + cy, 0.0);
            double temp = x;
            x = c * x - s * y;
            y = s * temp + c * y;
        }
        gl.glEnd();
        gl.glPopMatrix();
    }

    public void drawCircle(Vec2 center, double radius, Vec2 axis, Color3f color) {
        GL2 gl = this.panel.getGL().getGL2();
        gl.glPushMatrix();
        this.transformViewport(gl, this.zero);
        double theta = 0.483321946706122;
        double c = MathUtils.cos((double)theta);
        double s = MathUtils.sin((double)theta);
        double x = radius;
        double y = 0.0;
        double cx = center.x;
        double cy = center.y;
        gl.glBegin(2);
        gl.glColor4d(color.x, color.y, color.z, 1.0);
        for (int i = 0; i < 13; ++i) {
            gl.glVertex3d(x + cx, y + cy, 0.0);
            double temp = x;
            x = c * x - s * y;
            y = s * temp + c * y;
        }
        gl.glEnd();
        gl.glBegin(1);
        gl.glVertex3d(cx, cy, 0.0);
        gl.glVertex3d(cx + axis.x * radius, cy + axis.y * radius, 0.0);
        gl.glEnd();
        gl.glPopMatrix();
    }

    public void drawSolidCircle(Vec2 center, double radius, Vec2 axis, Color3f color) {
        double temp;
        int i;
        GL2 gl = this.panel.getGL().getGL2();
        gl.glPushMatrix();
        this.transformViewport(gl, this.zero);
        double theta = 0.483321946706122;
        double c = MathUtils.cos((double)theta);
        double s = MathUtils.sin((double)theta);
        double x = radius;
        double y = 0.0;
        double cx = center.x;
        double cy = center.y;
        gl.glBegin(6);
        gl.glColor4d(color.x, color.y, color.z, (double)0.4f);
        for (i = 0; i < 13; ++i) {
            gl.glVertex3d(x + cx, y + cy, 0.0);
            temp = x;
            x = c * x - s * y;
            y = s * temp + c * y;
        }
        gl.glEnd();
        gl.glBegin(2);
        gl.glColor4d(color.x, color.y, color.z, 1.0);
        for (i = 0; i < 13; ++i) {
            gl.glVertex3d(x + cx, y + cy, 0.0);
            temp = x;
            x = c * x - s * y;
            y = s * temp + c * y;
        }
        gl.glEnd();
        gl.glBegin(1);
        gl.glVertex3d(cx, cy, 0.0);
        gl.glVertex3d(cx + axis.x * radius, cy + axis.y * radius, 0.0);
        gl.glEnd();
        gl.glPopMatrix();
    }

    public void drawSegment(Vec2 p1, Vec2 p2, Color3f color) {
        GL2 gl = this.panel.getGL().getGL2();
        gl.glPushMatrix();
        this.transformViewport(gl, this.zero);
        gl.glBegin(1);
        gl.glColor3d(color.x, color.y, color.z);
        gl.glVertex3d(p1.x, p1.y, 0.0);
        gl.glVertex3d(p2.x, p2.y, 0.0);
        gl.glEnd();
        gl.glPopMatrix();
    }

    public void drawParticles(Vec2[] centers, double radius, ParticleColor[] colors, int count) {
        GL2 gl = this.panel.getGL().getGL2();
        gl.glPushMatrix();
        this.transformViewport(gl, this.zero);
        double theta = 0.483321946706122;
        double c = MathUtils.cos((double)theta);
        double s = MathUtils.sin((double)theta);
        double x = radius;
        double y = 0.0;
        for (int i = 0; i < count; ++i) {
            Vec2 center = centers[i];
            double cx = center.x;
            double cy = center.y;
            gl.glBegin(6);
            if (colors == null) {
                gl.glColor4d(1.0, 1.0, 1.0, (double)0.4f);
            } else {
                ParticleColor color = colors[i];
                gl.glColor4b(color.r, color.g, color.b, color.a);
            }
            for (int j = 0; j < 13; ++j) {
                gl.glVertex3d(x + cx, y + cy, 0.0);
                double temp = x;
                x = c * x - s * y;
                y = s * temp + c * y;
            }
            gl.glEnd();
        }
        gl.glPopMatrix();
    }

    public void drawParticlesWireframe(Vec2[] centers, double radius, ParticleColor[] colors, int count) {
        GL2 gl = this.panel.getGL().getGL2();
        gl.glPushMatrix();
        this.transformViewport(gl, this.zero);
        double theta = 0.483321946706122;
        double c = MathUtils.cos((double)theta);
        double s = MathUtils.sin((double)theta);
        double x = radius;
        double y = 0.0;
        for (int i = 0; i < count; ++i) {
            Vec2 center = centers[i];
            double cx = center.x;
            double cy = center.y;
            gl.glBegin(2);
            if (colors == null) {
                gl.glColor4d(1.0, 1.0, 1.0, 1.0);
            } else {
                ParticleColor color = colors[i];
                gl.glColor4b(color.r, color.g, color.b, (byte)127);
            }
            for (int j = 0; j < 13; ++j) {
                gl.glVertex3d(x + cx, y + cy, 0.0);
                double temp = x;
                x = c * x - s * y;
                y = s * temp + c * y;
            }
            gl.glEnd();
        }
        gl.glPopMatrix();
    }

    public void drawTransform(Transform xf) {
        GL2 gl = this.panel.getGL().getGL2();
        this.getWorldToScreenToOut(xf.p, this.temp);
        this.temp2.setZero();
        double k_axisScale = 0.4f;
        gl.glBegin(1);
        gl.glColor3d(1.0, 0.0, 0.0);
        this.temp2.x = xf.p.x + k_axisScale * xf.q.c;
        this.temp2.y = xf.p.y + k_axisScale * xf.q.s;
        this.getWorldToScreenToOut(this.temp2, this.temp2);
        gl.glVertex2d(this.temp.x, this.temp.y);
        gl.glVertex2d(this.temp2.x, this.temp2.y);
        gl.glColor3d(0.0, 1.0, 0.0);
        this.temp2.x = xf.p.x + -k_axisScale * xf.q.s;
        this.temp2.y = xf.p.y + k_axisScale * xf.q.c;
        this.getWorldToScreenToOut(this.temp2, this.temp2);
        gl.glVertex2d(this.temp.x, this.temp.y);
        gl.glVertex2d(this.temp2.x, this.temp2.y);
        gl.glEnd();
    }

    public void drawString(double x, double y, String s, Color3f color) {
        this.text.beginRendering(this.panel.getWidth(), this.panel.getHeight());
        this.text.setColor((float)color.x, (float)color.y, (float)color.z, 1.0f);
        this.text.draw(s, (int)x, this.panel.getHeight() - (int)y);
        this.text.endRendering();
    }
}

