(ns publicize.core
  (:require
    [cemerick.pomegranate.aether :as aether]
    [clojure.java.io :as io]))

(defn publicize [{:keys [lib version username password jar-file pom-file]}]
  (aether/deploy
    :coordinates [lib version]
    :jar-file    jar-file
    :pom-file    pom-file
    :repository  {"clojars"
                  {:url "https://repo.clojars.org"
                   :username (or username (System/getenv "CLOJARS_USERNAME"))
                   :password (or password (System/getenv "CLOJARS_PASSWORD"))}}))

