;;
;; Author José Albert Cruz Almaguer <jalbertcruz@gmail.com>
;; Copyright 2015 by José Albert Cruz Almaguer.
;;
;; This program is licensed to you under the terms of version 3 of the
;; GNU Affero General Public License. This program is distributed WITHOUT
;; ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF NON-INFRINGEMENT,
;; MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Please refer to the
;; AGPL (http://www.gnu.org/licenses/agpl-3.0.txt) for more details.
;;

(ns tools.fl.fa.da
  (:require [clojure.set :as cset])
  (:require [clojure.core.match :refer [match]])
  )

(def dfa)

(defn set-dfa [param]
  (def dfa param)
  )

(defn recognize [string]
  (let [
         str- (atom string)

         next-symbol #(if (seq @str-)
                        (let [res (first @str-)]
                          (swap! str- rest)
                          res)
                        'eot)

         move #((:transitions dfa) % 'error)
         ]

    (loop [c (next-symbol) s (:initial-state dfa)]
      (if (and (not= c 'eot) (not= s 'error))
        (let [cn (next-symbol)]
          (recur cn (move [s c])))
        (contains? (:final-states dfa) s)
        ))))