(ns fastbeans.core
  (:require
    [fastbeans.netty :as server]
    [clj-pid.core :as pid]
    [simplelog.core :as log]
    [clojure.java.io :as io])
  (:use simplelog.use)
  (:gen-class)
  (:import [java.io PushbackReader]))

(defn- read-clojure [filename]
  (with-open [r (io/reader filename)]
    (read (PushbackReader. r))))

(def global-conf (read-clojure "config.clj"))

(defn start!
  []
  (let [port (:fastbeans-port global-conf)]
    (info "Starting Fastbeans RPC server on port" port)
    (server/start port)))

(defn -main
  [& args]
;  (log/silence! :debug)
  (start!)
  (pid/initialize! (:pid-file global-conf))
  nil)
