(ns fastbeans.utils
  (:use simplelog.use)
  (:require
    [clojure.java.io :as io])
  (:import
    [java.io File]))

(defmacro dofuture
  [f-str & body]
  `(do
     (future
       (try
         (benchmark ~f-str
           (info "Background call" ~f-str)
           ~@body)
         (catch Exception e#
           (error "Failed on background call" ~(str *ns* "/" f-str))
           (print-exception e#))))
     :bg:spawned))

(defn join-paths
  [& paths]
  (reduce #(.getPath (File. %1 %2)) paths))

(defn file-exists?
  [path]
  (let [f (io/as-file path)]
    (.exists f)))

(defn touch
  [path]
  (org.apache.commons.io.FileUtils/touch (io/as-file path)))
