(ns subversion.wc
  (:use
    fastbeans.utils
    simplelog.use
    subversion.internals)
  (:require
    [subversion-clj.core :as core]
    [subversion-clj.local :as local]
    [subversion-clj.wc :as wc]))

(callfn current-revision
  [wc-path]
  (when (file-exists? wc-path)
    (let [mgr (wc/client-manager)
          status (wc/status mgr wc-path)
          revision (.getRevision status)]
      (when revision
        (.getNumber revision)))))

(callfn initialize
  [wc-path revision ignore-externals?]
  (when-not (file-exists? wc-path)
    (let [revision (as-int (or revision (core/youngest repo)))] 
      (wc/checkout (client-manager repo-cred) (repo-cred "url") wc-path revision true ignore-externals?))))

(callfn update
  [wc-path revision ignore-externals?]
  (let [revision (as-int (or revision (core/youngest repo)))]
    (wc/switch (client-manager repo-cred) (repo-cred "url") wc-path revision true ignore-externals?)))
