(ns subversion-clj.commit
  (:require
    [subversion-clj.core :as core])
  (:use
    subversion-clj.utils)
  (:import
    [org.tmatesoft.svn.core SVNURL SVNException SVNProperties]
    [org.tmatesoft.svn.core.auth ISVNAuthenticationManager]
    [org.tmatesoft.svn.core.wc SVNCopyClient SVNWCUtil SVNCopySource ISVNOptions SVNRevision SVNClientManager]))


(defn delete-url
  "Given a repository url string and a commit message string,
  run svn delete on the url. Return a SVNCommitInfo object"
  ([repo-url commit-message]
    (delete-url core/*client-manager* repo-url commit-message))
  ([^SVNClientManager client ^String repo-url ^String commit-message]
    (let [cli (.getCommitClient client)]
      (.doDelete cli (into-array SVNURL [(core/svn-url repo-url)]) commit-message))))
