(ns lightninggrader.base64
  (:refer-clojure :exclude [name parents])
  (:require [clojure.java.io :as io])
  (:import [org.apache.commons.codec.binary Base64]
           [java.io ByteArrayOutputStream]))

(defn is-base64?
  "Checks the string and ensures all characters are in the base64 charset"
  [s]
  (Base64/isBase64 s))

(defn- write-to-file-and-return-bytes-count [b f]
  (with-open [out (io/output-stream f)]
    (.write out b))
      (count b))

(defn- get-file-bytes [f]
  (with-open [out (ByteArrayOutputStream.)]
    (clojure.java.io/copy (io/input-stream f) out)
    (.toByteArray out)))

(defprotocol B64
  (encode-to-string [this])
  (encode-to-bytes [this])
  (encode-to-file [this file])
  (decode-to-string [this])
  (decode-to-bytes [this])
  (decode-to-file [this file]))

(extend-type java.lang.String
  B64
  (encode-to-string ([this] (Base64/encodeBase64String (.getBytes this))))
  (encode-to-bytes ([this] (.getBytes (encode-to-string this))))
  (encode-to-file [this file]
    (write-to-file-and-return-bytes-count (encode-to-bytes this) file))
  (decode-to-bytes ([this] (Base64/decodeBase64 this)))
  (decode-to-string ([this] (String. (decode-to-bytes this))))
  (decode-to-file [this file]
    (write-to-file-and-return-bytes-count (decode-to-bytes this) file)))

(extend-protocol B64
  (Class/forName "[B")
  (encode-to-string [this] (Base64/encodeBase64String this))
  (encode-to-bytes [this] (.getBytes (encode-to-string this)))
  (encode-to-file [this file]
    (write-to-file-and-return-bytes-count (encode-to-bytes this) file))
  (decode-to-bytes [this] (Base64/decodeBase64 this))
  (decode-to-string [this] (String. (decode-to-bytes this)))
  (decode-to-file [this file]
    (write-to-file-and-return-bytes-count (decode-to-bytes this) file)))

(extend-type java.io.File
  B64
  (encode-to-string ([this]
    (encode-to-string (get-file-bytes this))))
  (encode-to-bytes ([this]
    (encode-to-bytes (get-file-bytes this))))
  (encode-to-file ([this file]
    (encode-to-file (get-file-bytes this) file)))
  (decode-to-string ([this]
    (decode-to-string (get-file-bytes this))))
  (decode-to-bytes ([this]
    (decode-to-bytes (get-file-bytes this))))
  (decode-to-file ([this file]
    (decode-to-file (get-file-bytes this) file))))

