(ns leiningen.new.limonada
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "limonada"))

(defn limonada
  "A web application using Limonada"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' limonada project.")
    (->files data
             ["src/{{sanitized}}/foo.clj" (render "foo.clj" data)])))
