/*
 * Decompiled with CFR 0.152.
 */
package lindenlab.llsd;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import lindenlab.llsd.LLSD;
import lindenlab.llsd.LLSDException;
import lindenlab.llsd.LLSDUndefined;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LLSDParser {
    private final DateFormat iso9601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final DocumentBuilder documentBuilder;

    public LLSDParser() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.documentBuilder = factory.newDocumentBuilder();
    }

    private List<Node> extractElements(NodeList nodes) {
        ArrayList<Node> trimmedNodes = new ArrayList<Node>();
        block3: for (int nodeIdx = 0; nodeIdx < nodes.getLength(); ++nodeIdx) {
            Node node = nodes.item(nodeIdx);
            switch (node.getNodeType()) {
                case 1: {
                    trimmedNodes.add(node);
                    continue block3;
                }
            }
        }
        return trimmedNodes;
    }

    public LLSD parse(InputStream xmlFile) throws IOException, LLSDException, SAXException {
        Document document = this.documentBuilder.parse(xmlFile);
        Element llsdNode = document.getDocumentElement();
        if (null == llsdNode) {
            throw new LLSDException("Outer-most tag for LLSD missing.");
        }
        if (!llsdNode.getNodeName().equalsIgnoreCase("llsd")) {
            throw new LLSDException("Outer-most tag for LLSD is \"" + llsdNode.getNodeName() + "\" instead of \"llsd\".");
        }
        List<Node> childNodesTrimmed = this.extractElements(llsdNode.getChildNodes());
        if (childNodesTrimmed.size() == 0) {
            return new LLSD(null);
        }
        if (childNodesTrimmed.size() > 1) {
            throw new LLSDException("Expected only one subelement for element <llsd>.");
        }
        Object llsdContents = this.parseNode(childNodesTrimmed.get(0));
        return new LLSD(llsdContents);
    }

    private List<Object> parseArray(NodeList nodeList) throws LLSDException {
        ArrayList<Object> value = new ArrayList<Object>();
        for (int nodeIdx = 0; nodeIdx < nodeList.getLength(); ++nodeIdx) {
            Node node = nodeList.item(nodeIdx);
            if (node.getNodeType() != 1) continue;
            value.add(this.parseNode(node));
        }
        return value;
    }

    private Boolean parseBoolean(String elementContents) throws LLSDException {
        if (elementContents.equals("1") || elementContents.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Date parseDate(String elementContents) throws LLSDException {
        Date value;
        if (elementContents.length() == 0) {
            return new Date(0L);
        }
        try {
            value = this.iso9601Format.parse(elementContents);
        }
        catch (ParseException e) {
            throw new LLSDException("Unable to parse LLSD date value, received \"" + elementContents + "\".", e);
        }
        return value;
    }

    private Integer parseInteger(String elementContents) throws LLSDException {
        Integer value;
        if (elementContents.length() == 0) {
            return 0;
        }
        try {
            value = new Integer(elementContents);
        }
        catch (NumberFormatException e) {
            throw new LLSDException("Unable to parse LLSD integer value, received \"" + elementContents + "\".", e);
        }
        return value;
    }

    private Map<String, Object> parseMap(NodeList nodeList) throws LLSDException {
        List<Node> trimmedNodes = this.extractElements(nodeList);
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        if (trimmedNodes.size() % 2 != 0) {
            throw new LLSDException("Unable to parse LLSD map as it has odd number of nodes: " + nodeList.toString());
        }
        for (int nodeIdx = 0; nodeIdx < trimmedNodes.size(); nodeIdx += 2) {
            Node keyNode = trimmedNodes.get(nodeIdx);
            Node valueNode = trimmedNodes.get(nodeIdx + 1);
            String key = null;
            NodeList keyChildren = keyNode.getChildNodes();
            block4: for (int keyNodeIdx = 0; keyNodeIdx < keyChildren.getLength(); ++keyNodeIdx) {
                Node textNode = keyChildren.item(keyNodeIdx);
                switch (textNode.getNodeType()) {
                    case 3: {
                        key = textNode.getNodeValue();
                        continue block4;
                    }
                    default: {
                        throw new LLSDException("Unexpected node \"" + textNode.getNodeName() + "\" found while parsing key for map.");
                    }
                }
            }
            Object value = this.parseNode(valueNode);
            assert (null != value);
            valueMap.put(key, value);
        }
        return valueMap;
    }

    private Object parseNode(Node node) throws LLSDException {
        boolean isUndefined = false;
        String nodeName = node.getNodeName().toLowerCase();
        NodeList childNodes = node.getChildNodes();
        if (nodeName.equals("array")) {
            return this.parseArray(childNodes);
        }
        if (nodeName.equals("binary")) {
            throw new LLSDException("\"binary\" node type not implemented because it's a stupid idea that breaks how XML works. In specific, XML has a character set, binary data does not, and mixing the two is a recipe for disaster. Linden Labs should have used base 64 encode if they absolutely must, or attached binary content using a MIME multipart type.");
        }
        if (nodeName.equals("map")) {
            return this.parseMap(childNodes);
        }
        StringBuilder nodeText = new StringBuilder();
        block4: for (int nodeIdx = 0; nodeIdx < childNodes.getLength(); ++nodeIdx) {
            Node childNode = childNodes.item(nodeIdx);
            switch (childNode.getNodeType()) {
                case 3: {
                    nodeText.append(childNode.getNodeValue());
                    continue block4;
                }
                case 1: {
                    if (!childNode.getNodeName().equals("undef")) continue block4;
                    isUndefined = true;
                    continue block4;
                }
            }
        }
        if (nodeName.equals("undef")) {
            return "";
        }
        if (nodeName.equals("boolean")) {
            return isUndefined ? LLSDUndefined.BOOLEAN : this.parseBoolean(nodeText.toString());
        }
        if (nodeName.equals("date")) {
            return isUndefined ? LLSDUndefined.DATE : this.parseDate(nodeText.toString());
        }
        if (nodeName.equals("integer")) {
            return isUndefined ? LLSDUndefined.INTEGER : this.parseInteger(nodeText.toString());
        }
        if (nodeName.equals("real")) {
            return isUndefined ? LLSDUndefined.REAL : this.parseReal(nodeText.toString());
        }
        if (nodeName.equals("string")) {
            return isUndefined ? LLSDUndefined.STRING : this.parseString(nodeText.toString());
        }
        if (nodeName.equals("uri")) {
            return isUndefined ? LLSDUndefined.URI : this.parseURI(nodeText.toString());
        }
        if (nodeName.equals("uuid")) {
            return isUndefined ? LLSDUndefined.UUID : this.parseUUID(nodeText.toString());
        }
        throw new LLSDException("Encountered unexpected node \"" + node.getNodeName() + "\".");
    }

    private Double parseReal(String elementContents) throws LLSDException {
        Double value;
        if (elementContents.length() == 0) {
            return 0.0;
        }
        if (elementContents.equals("nan")) {
            return Double.NaN;
        }
        try {
            value = new Double(elementContents);
        }
        catch (NumberFormatException e) {
            throw new LLSDException("Unable to parse LLSD real value, received \"" + elementContents + "\".", e);
        }
        return value;
    }

    private String parseString(String elementContents) throws LLSDException {
        return elementContents;
    }

    private URI parseURI(String elementContents) throws LLSDException {
        URI value;
        try {
            value = new URI(elementContents);
        }
        catch (URISyntaxException e) {
            throw new LLSDException("Unable to parse LLSD URI value, received \"" + elementContents + "\".", e);
        }
        return value;
    }

    private UUID parseUUID(String elementContents) throws LLSDException {
        UUID value;
        if (elementContents.length() == 0) {
            return new UUID(0L, 0L);
        }
        try {
            value = UUID.fromString(elementContents);
        }
        catch (IllegalArgumentException e) {
            throw new LLSDException("Unable to parse LLSD UUID value, received \"" + elementContents + "\".", e);
        }
        return value;
    }
}

