(ns duck-repled.tree-sitter
  (:require ["path" :as path]
            [promesa.core :as p]))

;; TODO: How do I do this in pure Java?
(def ts-path (path/join js/__dirname "tree-sitter"))
(defonce Parser (js/require ts-path))
(defonce initialized
  (.init Parser #js {:locateFile #(path/join js/__dirname "tree-sitter.wasm")}))

(def done
  (p/do!
   initialized
   (p/let [my-path js/__dirname
           ruby (.. Parser -Language (load (path/join my-path "ruby.wasm")))]
     (def ruby-language ruby)
     (def parser (new Parser))
     (.setLanguage parser ruby-language)
     (def body-query (.query ruby "
(method  (body_statement) @body)
(singleton_method  (body_statement) @body)"))
     (def ^js parent-query (.query ruby "
(module) @parent (class) @parent
(method) @method (singleton_method) @singleton"))
     (def ^js method-name-query (.query ruby (str "(method name: (_) @name) @method "
                                                  "(singleton_method name: (_) @name) @method")))
     (def any-query (.query ruby "(_) @any"))
     (def identifier-query (.query ruby "(call) @call (identifier) @identifier"))
     (def call-query (.query ruby "(call) @call"))
     (def ctx-query (.query ruby "
(identifier) @identifier
(constant) @identifier
(instance_variable) @identifier
(class_variable) @identifier
(call (argument_list) @arglist)

\".\" @sep
\"::\" @sep
\":\" @sep
\"[\" @sep
\"]\" @sep
\"(\" @sep
\")\" @sep
\"{\" @sep
\"}\" @sep
")))))

(defn parse [text] (.parse parser text))

(defn root [^js parsed] (.-rootNode parsed))

(defn captures [^js node, ^js query, start, end]
  (.captures query node (clj->js start) (clj->js end)))
