(ns orbit.meta-helper
  (:require-macros [orbit.meta-helper :as self])
  (:require [clojure.string :as str]))

(def serializer-as-fn
  (-> "orbit/serializer.cljc"
      (self/contents-for-fn "to-ebn")
      (str/replace #"orbit\.meta-helper/to-ebn" "to-ebn")
      (str/replace #"__.*?\b" "__")))

(def exceptions
  (str "#?("
       " :bb java.lang.Throwable"
       " :clj java.lang.Throwable"
       " :cljs :default"
       " :cljr System.Exception"
       " :clje _"
       ")"))

(defn wrapped-command [command column]
  (str "("
       "  (clojure.core/fn []"
       "    (clojure.core/let [to-ebn " serializer-as-fn "]"
       "      (try (clojure.core/symbol (to-ebn {:result (do\n"
       (apply str (repeat column " ")) command "\n)}))"
       "        (catch " exceptions " e"
       "          (clojure.core/symbol (to-ebn {:error e}))"
       "        )"
       "      )"
       "    )"
       "  )"
       ")"))
