## clj-docker-client

[![License: GPL v3](https://img.shields.io/badge/license-GPL%20v3-blue.svg)](http://www.gnu.org/licenses/gpl-3.0)
[![Clojars Project](https://img.shields.io/clojars/v/lispyclouds/clj-docker-client.svg)](https://clojars.org/lispyclouds/clj-docker-client)

``` clojure
[lispyclouds/clj-docker-client "0.1.0"]
```

An idiomatic Clojure Docker client based on the excellent JVM [client](https://github.com/spotify/docker-client) by Spotify.

This is a work in progress and aims to be fully compliant and up to date with the Docker API changes. 

### Usage

```clojure
(require '[docker])
```

#### Creating a connection to the Local Docker daemon
```clojure
(def connection (docker/connect))
```

#### Pulling the `busybox:musl` image
```clojure
(docker/pull connection "busybox:musl")
```

#### Building an image from a Dockerfile
```clojure
(def connection (docker/connect))
```
