(ns corax.error-reporter
  (:require [cheshire.core :as json]
            [corax.log :as log]
            [raven-clj.core :as raven])
  (:import [com.fasterxml.jackson.core JsonGenerationException]))

(defn report
  [event dsn logger]
  (try
    (let [response (raven/capture dsn event)]
      (if (= (:status response) 200)
        (let [id (-> response :body (json/parse-string true) :id)]
          (log/ok logger id event))
        (log/failure logger response event)))
    (catch NullPointerException e
      (log/invalid-dsn logger dsn event))
    (catch JsonGenerationException e
      (log/non-serializable-event logger e event))
    (catch Throwable e
      (log/error logger e event))))
