(ns leiningen.new.little-jack
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "little-jack"))

(defn little-jack
  "expand this leiningen template"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' little-jack project.")
    (main/info "Your project name is:" name)
    (->files data
             ["LICENSE" (render "LICENSE" data)]
             ["README.md" (render "README.md" data)]
             ["project.clj" (render "project.clj" data)]
             ["src/{{sanitized}}/core.cljs" (render "src/core.cljs" data)])))
