(ns clj-ftp-client.utils
  (:require [clj-ftp-client.core :refer [ls]]))

(defn wait-until
  "Keep watching current ftp directory.
Pass when `pred' is true.
`pred' take a argument a result of `ls'."
  [pred & {:keys [interval-ms]
           :or {interval-ms 5000}}]
  (loop []
    (when-not (pred (set (ls)))
      (Thread/sleep interval-ms)
      (recur))))
