// Compiled by ClojureScript 1.9.521 {}
goog.provide('konserve.memory');
goog.require('cljs.core');
goog.require('konserve.protocols');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {konserve.protocols.PEDNAsyncKeyValueStore}
 * @implements {konserve.protocols.PBinaryAsyncKeyValueStore}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
konserve.memory.MemAsyncKeyValueStore = (function (state,read_handlers,write_handlers,locks,__meta,__extmap,__hash){
this.state = state;
this.read_handlers = read_handlers;
this.write_handlers = write_handlers;
this.locks = locks;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__10094__auto__,k__10095__auto__){
var self__ = this;
var this__10094__auto____$1 = this;
return this__10094__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__10095__auto__,null);
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__10096__auto__,k84954,else__10097__auto__){
var self__ = this;
var this__10096__auto____$1 = this;
var G__84956 = (((k84954 instanceof cljs.core.Keyword))?k84954.fqn:null);
switch (G__84956) {
case "state":
return self__.state;

break;
case "read-handlers":
return self__.read_handlers;

break;
case "write-handlers":
return self__.write_handlers;

break;
case "locks":
return self__.locks;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k84954,else__10097__auto__);

}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__10108__auto__,writer__10109__auto__,opts__10110__auto__){
var self__ = this;
var this__10108__auto____$1 = this;
var pr_pair__10111__auto__ = ((function (this__10108__auto____$1){
return (function (keyval__10112__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,cljs.core.pr_writer,""," ","",opts__10110__auto__,keyval__10112__auto__);
});})(this__10108__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,pr_pair__10111__auto__,"#konserve.memory.MemAsyncKeyValueStore{",", ","}",opts__10110__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),self__.read_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),self__.write_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"locks","locks",1560476518),self__.locks],null))], null),self__.__extmap));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__84953){
var self__ = this;
var G__84953__$1 = this;
return (new cljs.core.RecordIter((0),G__84953__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),new cljs.core.Keyword(null,"locks","locks",1560476518)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__10092__auto__){
var self__ = this;
var this__10092__auto____$1 = this;
return self__.__meta;
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__10088__auto__){
var self__ = this;
var this__10088__auto____$1 = this;
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,self__.__hash));
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$ = cljs.core.PROTOCOL_SENTINEL;

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_exists_QMARK_$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__,this$__$1){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__,this$__$1){
return (function (state_84964){
var state_val_84965 = (state_84964[(1)]);
if((state_val_84965 === (1))){
var inst_84957 = cljs.core.deref.call(null,self__.state);
var inst_84958 = inst_84957.call(null,key);
var state_84964__$1 = state_84964;
if(cljs.core.truth_(inst_84958)){
var statearr_84966_85050 = state_84964__$1;
(statearr_84966_85050[(1)] = (2));

} else {
var statearr_84967_85051 = state_84964__$1;
(statearr_84967_85051[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84965 === (2))){
var state_84964__$1 = state_84964;
var statearr_84968_85052 = state_84964__$1;
(statearr_84968_85052[(2)] = true);

(statearr_84968_85052[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84965 === (3))){
var state_84964__$1 = state_84964;
var statearr_84969_85053 = state_84964__$1;
(statearr_84969_85053[(2)] = false);

(statearr_84969_85053[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84965 === (4))){
var inst_84962 = (state_84964[(2)]);
var state_84964__$1 = state_84964;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_84964__$1,inst_84962);
} else {
return null;
}
}
}
}
});})(c__38457__auto__,this$__$1))
;
return ((function (switch__38343__auto__,c__38457__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38344__auto__ = null;
var konserve$memory$state_machine__38344__auto____0 = (function (){
var statearr_84973 = [null,null,null,null,null,null,null];
(statearr_84973[(0)] = konserve$memory$state_machine__38344__auto__);

(statearr_84973[(1)] = (1));

return statearr_84973;
});
var konserve$memory$state_machine__38344__auto____1 = (function (state_84964){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_84964);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e84974){if((e84974 instanceof Object)){
var ex__38347__auto__ = e84974;
var statearr_84975_85054 = state_84964;
(statearr_84975_85054[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_84964);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e84974;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__85055 = state_84964;
state_84964 = G__85055;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
konserve$memory$state_machine__38344__auto__ = function(state_84964){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38344__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38344__auto____1.call(this,state_84964);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38344__auto____0;
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38344__auto____1;
return konserve$memory$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__,this$__$1))
})();
var state__38459__auto__ = (function (){var statearr_84976 = f__38458__auto__.call(null);
(statearr_84976[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_84976;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__,this$__$1))
);

return c__38457__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_get_in$arity$2 = (function (this$,key_vec){
var self__ = this;
var this$__$1 = this;
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__,this$__$1){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__,this$__$1){
return (function (state_84980){
var state_val_84981 = (state_84980[(1)]);
if((state_val_84981 === (1))){
var inst_84977 = cljs.core.deref.call(null,self__.state);
var inst_84978 = cljs.core.get_in.call(null,inst_84977,key_vec);
var state_84980__$1 = state_84980;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_84980__$1,inst_84978);
} else {
return null;
}
});})(c__38457__auto__,this$__$1))
;
return ((function (switch__38343__auto__,c__38457__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38344__auto__ = null;
var konserve$memory$state_machine__38344__auto____0 = (function (){
var statearr_84985 = [null,null,null,null,null,null,null];
(statearr_84985[(0)] = konserve$memory$state_machine__38344__auto__);

(statearr_84985[(1)] = (1));

return statearr_84985;
});
var konserve$memory$state_machine__38344__auto____1 = (function (state_84980){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_84980);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e84986){if((e84986 instanceof Object)){
var ex__38347__auto__ = e84986;
var statearr_84987_85056 = state_84980;
(statearr_84987_85056[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_84980);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e84986;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__85057 = state_84980;
state_84980 = G__85057;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
konserve$memory$state_machine__38344__auto__ = function(state_84980){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38344__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38344__auto____1.call(this,state_84980);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38344__auto____0;
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38344__auto____1;
return konserve$memory$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__,this$__$1))
})();
var state__38459__auto__ = (function (){var statearr_84988 = f__38458__auto__.call(null);
(statearr_84988[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_84988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__,this$__$1))
);

return c__38457__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_update_in$arity$3 = (function (this$,key_vec,up_fn){
var self__ = this;
var this$__$1 = this;
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__,this$__$1){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__,this$__$1){
return (function (state_84997){
var state_val_84998 = (state_84997[(1)]);
if((state_val_84998 === (1))){
var inst_84989 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84990 = cljs.core.deref.call(null,self__.state);
var inst_84991 = cljs.core.get_in.call(null,inst_84990,key_vec);
var inst_84992 = cljs.core.swap_BANG_.call(null,self__.state,cljs.core.update_in,key_vec,up_fn);
var inst_84993 = cljs.core.get_in.call(null,inst_84992,key_vec);
var inst_84994 = [inst_84991,inst_84993];
var inst_84995 = (new cljs.core.PersistentVector(null,2,(5),inst_84989,inst_84994,null));
var state_84997__$1 = state_84997;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_84997__$1,inst_84995);
} else {
return null;
}
});})(c__38457__auto__,this$__$1))
;
return ((function (switch__38343__auto__,c__38457__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38344__auto__ = null;
var konserve$memory$state_machine__38344__auto____0 = (function (){
var statearr_85002 = [null,null,null,null,null,null,null];
(statearr_85002[(0)] = konserve$memory$state_machine__38344__auto__);

(statearr_85002[(1)] = (1));

return statearr_85002;
});
var konserve$memory$state_machine__38344__auto____1 = (function (state_84997){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_84997);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e85003){if((e85003 instanceof Object)){
var ex__38347__auto__ = e85003;
var statearr_85004_85058 = state_84997;
(statearr_85004_85058[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_84997);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e85003;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__85059 = state_84997;
state_84997 = G__85059;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
konserve$memory$state_machine__38344__auto__ = function(state_84997){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38344__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38344__auto____1.call(this,state_84997);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38344__auto____0;
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38344__auto____1;
return konserve$memory$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__,this$__$1))
})();
var state__38459__auto__ = (function (){var statearr_85005 = f__38458__auto__.call(null);
(statearr_85005[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_85005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__,this$__$1))
);

return c__38457__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_assoc_in$arity$3 = (function (this$,key_vec,val){
var self__ = this;
var this$__$1 = this;
return this$__$1.konserve$protocols$PEDNAsyncKeyValueStore$_update_in$arity$3(null,key_vec,((function (this$__$1){
return (function (_){
return val;
});})(this$__$1))
);
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_dissoc$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__,this$__$1){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__,this$__$1){
return (function (state_85008){
var state_val_85009 = (state_85008[(1)]);
if((state_val_85009 === (1))){
var inst_85006 = cljs.core.swap_BANG_.call(null,self__.state,cljs.core.dissoc,key);
var state_85008__$1 = (function (){var statearr_85010 = state_85008;
(statearr_85010[(7)] = inst_85006);

return statearr_85010;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_85008__$1,null);
} else {
return null;
}
});})(c__38457__auto__,this$__$1))
;
return ((function (switch__38343__auto__,c__38457__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38344__auto__ = null;
var konserve$memory$state_machine__38344__auto____0 = (function (){
var statearr_85014 = [null,null,null,null,null,null,null,null];
(statearr_85014[(0)] = konserve$memory$state_machine__38344__auto__);

(statearr_85014[(1)] = (1));

return statearr_85014;
});
var konserve$memory$state_machine__38344__auto____1 = (function (state_85008){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_85008);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e85015){if((e85015 instanceof Object)){
var ex__38347__auto__ = e85015;
var statearr_85016_85060 = state_85008;
(statearr_85016_85060[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_85008);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e85015;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__85061 = state_85008;
state_85008 = G__85061;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
konserve$memory$state_machine__38344__auto__ = function(state_85008){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38344__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38344__auto____1.call(this,state_85008);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38344__auto____0;
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38344__auto____1;
return konserve$memory$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__,this$__$1))
})();
var state__38459__auto__ = (function (){var statearr_85017 = f__38458__auto__.call(null);
(statearr_85017[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_85017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__,this$__$1))
);

return c__38457__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__10098__auto__){
var self__ = this;
var this__10098__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PBinaryAsyncKeyValueStore$ = cljs.core.PROTOCOL_SENTINEL;

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PBinaryAsyncKeyValueStore$_bget$arity$3 = (function (this$,key,locked_cb){
var self__ = this;
var this$__$1 = this;
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__,this$__$1){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__,this$__$1){
return (function (state_85022){
var state_val_85023 = (state_85022[(1)]);
if((state_val_85023 === (1))){
var inst_85018 = cljs.core.deref.call(null,self__.state);
var inst_85019 = cljs.core.get.call(null,inst_85018,key);
var inst_85020 = locked_cb.call(null,inst_85019);
var state_85022__$1 = state_85022;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_85022__$1,inst_85020);
} else {
return null;
}
});})(c__38457__auto__,this$__$1))
;
return ((function (switch__38343__auto__,c__38457__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38344__auto__ = null;
var konserve$memory$state_machine__38344__auto____0 = (function (){
var statearr_85027 = [null,null,null,null,null,null,null];
(statearr_85027[(0)] = konserve$memory$state_machine__38344__auto__);

(statearr_85027[(1)] = (1));

return statearr_85027;
});
var konserve$memory$state_machine__38344__auto____1 = (function (state_85022){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_85022);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e85028){if((e85028 instanceof Object)){
var ex__38347__auto__ = e85028;
var statearr_85029_85062 = state_85022;
(statearr_85029_85062[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_85022);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e85028;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__85063 = state_85022;
state_85022 = G__85063;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
konserve$memory$state_machine__38344__auto__ = function(state_85022){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38344__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38344__auto____1.call(this,state_85022);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38344__auto____0;
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38344__auto____1;
return konserve$memory$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__,this$__$1))
})();
var state__38459__auto__ = (function (){var statearr_85030 = f__38458__auto__.call(null);
(statearr_85030[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_85030;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__,this$__$1))
);

return c__38457__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PBinaryAsyncKeyValueStore$_bassoc$arity$3 = (function (this$,key,input){
var self__ = this;
var this$__$1 = this;
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__,this$__$1){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__,this$__$1){
return (function (state_85036){
var state_val_85037 = (state_85036[(1)]);
if((state_val_85037 === (1))){
var inst_85031 = [new cljs.core.Keyword(null,"input-stream","input-stream",-179909472),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_85032 = [input,new cljs.core.Keyword(null,"unknown","unknown",-935977881)];
var inst_85033 = cljs.core.PersistentHashMap.fromArrays(inst_85031,inst_85032);
var inst_85034 = cljs.core.swap_BANG_.call(null,self__.state,cljs.core.assoc,key,inst_85033);
var state_85036__$1 = (function (){var statearr_85038 = state_85036;
(statearr_85038[(7)] = inst_85034);

return statearr_85038;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_85036__$1,null);
} else {
return null;
}
});})(c__38457__auto__,this$__$1))
;
return ((function (switch__38343__auto__,c__38457__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38344__auto__ = null;
var konserve$memory$state_machine__38344__auto____0 = (function (){
var statearr_85042 = [null,null,null,null,null,null,null,null];
(statearr_85042[(0)] = konserve$memory$state_machine__38344__auto__);

(statearr_85042[(1)] = (1));

return statearr_85042;
});
var konserve$memory$state_machine__38344__auto____1 = (function (state_85036){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_85036);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e85043){if((e85043 instanceof Object)){
var ex__38347__auto__ = e85043;
var statearr_85044_85064 = state_85036;
(statearr_85044_85064[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_85036);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e85043;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__85065 = state_85036;
state_85036 = G__85065;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
konserve$memory$state_machine__38344__auto__ = function(state_85036){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38344__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38344__auto____1.call(this,state_85036);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38344__auto____0;
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38344__auto____1;
return konserve$memory$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__,this$__$1))
})();
var state__38459__auto__ = (function (){var statearr_85045 = f__38458__auto__.call(null);
(statearr_85045[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_85045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__,this$__$1))
);

return c__38457__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__10089__auto__){
var self__ = this;
var this__10089__auto____$1 = this;
var h__9861__auto__ = self__.__hash;
if(!((h__9861__auto__ == null))){
return h__9861__auto__;
} else {
var h__9861__auto____$1 = cljs.core.hash_imap.call(null,this__10089__auto____$1);
self__.__hash = h__9861__auto____$1;

return h__9861__auto____$1;
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__10090__auto__,other__10091__auto__){
var self__ = this;
var this__10090__auto____$1 = this;
if(cljs.core.truth_((function (){var and__9407__auto__ = other__10091__auto__;
if(cljs.core.truth_(and__9407__auto__)){
return ((this__10090__auto____$1.constructor === other__10091__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__10090__auto____$1,other__10091__auto__));
} else {
return and__9407__auto__;
}
})())){
return true;
} else {
return false;
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__10103__auto__,k__10104__auto__){
var self__ = this;
var this__10103__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"locks","locks",1560476518),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),null,new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),null], null), null),k__10104__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__10103__auto____$1),self__.__meta),k__10104__auto__);
} else {
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__10104__auto__)),null));
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__10101__auto__,k__10102__auto__,G__84953){
var self__ = this;
var this__10101__auto____$1 = this;
var pred__85046 = cljs.core.keyword_identical_QMARK_;
var expr__85047 = k__10102__auto__;
if(cljs.core.truth_(pred__85046.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__85047))){
return (new konserve.memory.MemAsyncKeyValueStore(G__84953,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__85046.call(null,new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),expr__85047))){
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,G__84953,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__85046.call(null,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),expr__85047))){
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,G__84953,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__85046.call(null,new cljs.core.Keyword(null,"locks","locks",1560476518),expr__85047))){
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,G__84953,self__.__meta,self__.__extmap,null));
} else {
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__10102__auto__,G__84953),null));
}
}
}
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__10106__auto__){
var self__ = this;
var this__10106__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),self__.read_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),self__.write_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"locks","locks",1560476518),self__.locks],null))], null),self__.__extmap));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__10093__auto__,G__84953){
var self__ = this;
var this__10093__auto____$1 = this;
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,G__84953,self__.__extmap,self__.__hash));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__10099__auto__,entry__10100__auto__){
var self__ = this;
var this__10099__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__10100__auto__)){
return this__10099__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__10100__auto__,(0)),cljs.core._nth.call(null,entry__10100__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__10099__auto____$1,entry__10100__auto__);
}
});

konserve.memory.MemAsyncKeyValueStore.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"read-handlers","read-handlers",-544976454,null),new cljs.core.Symbol(null,"write-handlers","write-handlers",-456757384,null),new cljs.core.Symbol(null,"locks","locks",-1093959251,null)], null);
});

konserve.memory.MemAsyncKeyValueStore.cljs$lang$type = true;

konserve.memory.MemAsyncKeyValueStore.cljs$lang$ctorPrSeq = (function (this__10130__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"konserve.memory/MemAsyncKeyValueStore");
});

konserve.memory.MemAsyncKeyValueStore.cljs$lang$ctorPrWriter = (function (this__10130__auto__,writer__10131__auto__){
return cljs.core._write.call(null,writer__10131__auto__,"konserve.memory/MemAsyncKeyValueStore");
});

konserve.memory.__GT_MemAsyncKeyValueStore = (function konserve$memory$__GT_MemAsyncKeyValueStore(state,read_handlers,write_handlers,locks){
return (new konserve.memory.MemAsyncKeyValueStore(state,read_handlers,write_handlers,locks,null,null,null));
});

konserve.memory.map__GT_MemAsyncKeyValueStore = (function konserve$memory$map__GT_MemAsyncKeyValueStore(G__84955){
return (new konserve.memory.MemAsyncKeyValueStore(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__84955),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315).cljs$core$IFn$_invoke$arity$1(G__84955),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911).cljs$core$IFn$_invoke$arity$1(G__84955),new cljs.core.Keyword(null,"locks","locks",1560476518).cljs$core$IFn$_invoke$arity$1(G__84955),null,cljs.core.dissoc.call(null,G__84955,new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),new cljs.core.Keyword(null,"locks","locks",1560476518)),null));
});

/**
 * Create in memory store. Binaries are not properly locked yet and
 *   the read and write-handlers are dummy ones for compatibility.
 */
konserve.memory.new_mem_store = (function konserve$memory$new_mem_store(var_args){
var args85066 = [];
var len__10640__auto___85089 = arguments.length;
var i__10641__auto___85090 = (0);
while(true){
if((i__10641__auto___85090 < len__10640__auto___85089)){
args85066.push((arguments[i__10641__auto___85090]));

var G__85091 = (i__10641__auto___85090 + (1));
i__10641__auto___85090 = G__85091;
continue;
} else {
}
break;
}

var G__85068 = args85066.length;
switch (G__85068) {
case 0:
return konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args85066.length)].join('')));

}
});

konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$0 = (function (){
return konserve.memory.new_mem_store.call(null,cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
});

konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$1 = (function (init_atom){
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__){
return (function (state_85080){
var state_val_85081 = (state_85080[(1)]);
if((state_val_85081 === (1))){
var inst_85069 = [new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),new cljs.core.Keyword(null,"locks","locks",1560476518)];
var inst_85070 = cljs.core.PersistentHashMap.EMPTY;
var inst_85071 = cljs.core.atom.call(null,inst_85070);
var inst_85072 = cljs.core.PersistentHashMap.EMPTY;
var inst_85073 = cljs.core.atom.call(null,inst_85072);
var inst_85074 = cljs.core.PersistentHashMap.EMPTY;
var inst_85075 = cljs.core.atom.call(null,inst_85074);
var inst_85076 = [init_atom,inst_85071,inst_85073,inst_85075];
var inst_85077 = cljs.core.PersistentHashMap.fromArrays(inst_85069,inst_85076);
var inst_85078 = konserve.memory.map__GT_MemAsyncKeyValueStore.call(null,inst_85077);
var state_85080__$1 = state_85080;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_85080__$1,inst_85078);
} else {
return null;
}
});})(c__38457__auto__))
;
return ((function (switch__38343__auto__,c__38457__auto__){
return (function() {
var konserve$memory$state_machine__38344__auto__ = null;
var konserve$memory$state_machine__38344__auto____0 = (function (){
var statearr_85085 = [null,null,null,null,null,null,null];
(statearr_85085[(0)] = konserve$memory$state_machine__38344__auto__);

(statearr_85085[(1)] = (1));

return statearr_85085;
});
var konserve$memory$state_machine__38344__auto____1 = (function (state_85080){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_85080);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e85086){if((e85086 instanceof Object)){
var ex__38347__auto__ = e85086;
var statearr_85087_85093 = state_85080;
(statearr_85087_85093[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_85080);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e85086;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__85094 = state_85080;
state_85080 = G__85094;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
konserve$memory$state_machine__38344__auto__ = function(state_85080){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38344__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38344__auto____1.call(this,state_85080);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38344__auto____0;
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38344__auto____1;
return konserve$memory$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__))
})();
var state__38459__auto__ = (function (){var statearr_85088 = f__38458__auto__.call(null);
(statearr_85088[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_85088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__))
);

return c__38457__auto__;
});

konserve.memory.new_mem_store.cljs$lang$maxFixedArity = 1;


//# sourceMappingURL=memory.js.map