// Compiled by ClojureScript 1.9.521 {}
goog.provide('superv.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
superv.async.cljs_env_QMARK_ = (function superv$async$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});

/**
 * @interface
 */
superv.async.PSupervisor = function(){};

superv.async._error = (function superv$async$_error(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_error$arity$1 == null)))){
return this$.superv$async$PSupervisor$_error$arity$1(this$);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._error[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$);
} else {
var m__10138__auto____$1 = (superv.async._error["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-error",this$);
}
}
}
});

superv.async._abort = (function superv$async$_abort(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_abort$arity$1 == null)))){
return this$.superv$async$PSupervisor$_abort$arity$1(this$);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._abort[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$);
} else {
var m__10138__auto____$1 = (superv.async._abort["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-abort",this$);
}
}
}
});

superv.async._register_go = (function superv$async$_register_go(this$,body){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_register_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_register_go$arity$2(this$,body);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._register_go[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,body);
} else {
var m__10138__auto____$1 = (superv.async._register_go["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,body);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-register-go",this$);
}
}
}
});

superv.async._unregister_go = (function superv$async$_unregister_go(this$,id){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_unregister_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_unregister_go$arity$2(this$,id);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._unregister_go[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,id);
} else {
var m__10138__auto____$1 = (superv.async._unregister_go["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-unregister-go",this$);
}
}
}
});

superv.async._track_exception = (function superv$async$_track_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_track_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_track_exception$arity$2(this$,e);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._track_exception[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,e);
} else {
var m__10138__auto____$1 = (superv.async._track_exception["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-track-exception",this$);
}
}
}
});

superv.async._free_exception = (function superv$async$_free_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_free_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_free_exception$arity$2(this$,e);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._free_exception[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,e);
} else {
var m__10138__auto____$1 = (superv.async._free_exception["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-free-exception",this$);
}
}
}
});

superv.async.now = (function superv$async$now(){
return (new Date());
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {superv.async.PSupervisor}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
superv.async.TrackingSupervisor = (function (error,abort,registered,pending_exceptions,__meta,__extmap,__hash){
this.error = error;
this.abort = abort;
this.registered = registered;
this.pending_exceptions = pending_exceptions;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__10094__auto__,k__10095__auto__){
var self__ = this;
var this__10094__auto____$1 = this;
return this__10094__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__10095__auto__,null);
});

superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__10096__auto__,k78911,else__10097__auto__){
var self__ = this;
var this__10096__auto____$1 = this;
var G__78913 = (((k78911 instanceof cljs.core.Keyword))?k78911.fqn:null);
switch (G__78913) {
case "error":
return self__.error;

break;
case "abort":
return self__.abort;

break;
case "registered":
return self__.registered;

break;
case "pending-exceptions":
return self__.pending_exceptions;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k78911,else__10097__auto__);

}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__10108__auto__,writer__10109__auto__,opts__10110__auto__){
var self__ = this;
var this__10108__auto____$1 = this;
var pr_pair__10111__auto__ = ((function (this__10108__auto____$1){
return (function (keyval__10112__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,cljs.core.pr_writer,""," ","",opts__10110__auto__,keyval__10112__auto__);
});})(this__10108__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,pr_pair__10111__auto__,"#superv.async.TrackingSupervisor{",", ","}",opts__10110__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__78910){
var self__ = this;
var G__78910__$1 = this;
return (new cljs.core.RecordIter((0),G__78910__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__10092__auto__){
var self__ = this;
var this__10092__auto____$1 = this;
return self__.__meta;
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__10088__auto__){
var self__ = this;
var this__10088__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__10098__auto__){
var self__ = this;
var this__10098__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__10089__auto__){
var self__ = this;
var this__10089__auto____$1 = this;
var h__9861__auto__ = self__.__hash;
if(!((h__9861__auto__ == null))){
return h__9861__auto__;
} else {
var h__9861__auto____$1 = cljs.core.hash_imap.call(null,this__10089__auto____$1);
self__.__hash = h__9861__auto____$1;

return h__9861__auto____$1;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__10090__auto__,other__10091__auto__){
var self__ = this;
var this__10090__auto____$1 = this;
if(cljs.core.truth_((function (){var and__9407__auto__ = other__10091__auto__;
if(cljs.core.truth_(and__9407__auto__)){
return ((this__10090__auto____$1.constructor === other__10091__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__10090__auto____$1,other__10091__auto__));
} else {
return and__9407__auto__;
}
})())){
return true;
} else {
return false;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__10103__auto__,k__10104__auto__){
var self__ = this;
var this__10103__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),null,new cljs.core.Keyword(null,"abort","abort",521193198),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"registered","registered",-388600037),null], null), null),k__10104__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__10103__auto____$1),self__.__meta),k__10104__auto__);
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__10104__auto__)),null));
}
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_error$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.error;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.abort;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_register_go$arity$2 = (function (this$,body){
var self__ = this;
var this$__$1 = this;
var id = cljs.core.random_uuid.call(null);
cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.assoc,id,body);

return id;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_unregister_go$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.dissoc,id);
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_track_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.assoc,e,superv.async.now.call(null));
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_free_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.dissoc,e);
});

superv.async.TrackingSupervisor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__10101__auto__,k__10102__auto__,G__78910){
var self__ = this;
var this__10101__auto____$1 = this;
var pred__78914 = cljs.core.keyword_identical_QMARK_;
var expr__78915 = k__10102__auto__;
if(cljs.core.truth_(pred__78914.call(null,new cljs.core.Keyword(null,"error","error",-978969032),expr__78915))){
return (new superv.async.TrackingSupervisor(G__78910,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__78914.call(null,new cljs.core.Keyword(null,"abort","abort",521193198),expr__78915))){
return (new superv.async.TrackingSupervisor(self__.error,G__78910,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__78914.call(null,new cljs.core.Keyword(null,"registered","registered",-388600037),expr__78915))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,G__78910,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__78914.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),expr__78915))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,G__78910,self__.__meta,self__.__extmap,null));
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__10102__auto__,G__78910),null));
}
}
}
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__10106__auto__){
var self__ = this;
var this__10106__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__10093__auto__,G__78910){
var self__ = this;
var this__10093__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,G__78910,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__10099__auto__,entry__10100__auto__){
var self__ = this;
var this__10099__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__10100__auto__)){
return this__10099__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__10100__auto__,(0)),cljs.core._nth.call(null,entry__10100__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__10099__auto____$1,entry__10100__auto__);
}
});

superv.async.TrackingSupervisor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.Symbol(null,"abort","abort",-2133242571,null),new cljs.core.Symbol(null,"registered","registered",1251931490,null),new cljs.core.Symbol(null,"pending-exceptions","pending-exceptions",-247748567,null)], null);
});

superv.async.TrackingSupervisor.cljs$lang$type = true;

superv.async.TrackingSupervisor.cljs$lang$ctorPrSeq = (function (this__10130__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"superv.async/TrackingSupervisor");
});

superv.async.TrackingSupervisor.cljs$lang$ctorPrWriter = (function (this__10130__auto__,writer__10131__auto__){
return cljs.core._write.call(null,writer__10131__auto__,"superv.async/TrackingSupervisor");
});

superv.async.__GT_TrackingSupervisor = (function superv$async$__GT_TrackingSupervisor(error,abort,registered,pending_exceptions){
return (new superv.async.TrackingSupervisor(error,abort,registered,pending_exceptions,null,null,null));
});

superv.async.map__GT_TrackingSupervisor = (function superv$async$map__GT_TrackingSupervisor(G__78912){
return (new superv.async.TrackingSupervisor(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(G__78912),new cljs.core.Keyword(null,"abort","abort",521193198).cljs$core$IFn$_invoke$arity$1(G__78912),new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(G__78912),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(G__78912),null,cljs.core.dissoc.call(null,G__78912,new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)),null));
});

cljs.core.enable_console_print_BANG_.call(null);
/**
 * A simple supervisor which deals with errors through callbacks. You need to
 *   close its abort channel manually if you want the context to stop. It is
 *   supposed to be used at a boundary to an unsupervised system. If you want
 *   strong supervision, use the restarting-supervisor instead.
 */
superv.async.simple_supervisor = (function superv$async$simple_supervisor(var_args){
var args__10647__auto__ = [];
var len__10640__auto___78942 = arguments.length;
var i__10641__auto___78943 = (0);
while(true){
if((i__10641__auto___78943 < len__10640__auto___78942)){
args__10647__auto__.push((arguments[i__10641__auto___78943]));

var G__78944 = (i__10641__auto___78943 + (1));
i__10641__auto___78943 = G__78944;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((0) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((0)),(0),null)):null);
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(argseq__10648__auto__);
});

superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (p__78919){
var map__78920 = p__78919;
var map__78920__$1 = ((((!((map__78920 == null)))?((((map__78920.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__78920.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__78920):map__78920);
var stale_timeout = cljs.core.get.call(null,map__78920__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((10) * (1000)));
var error_fn = cljs.core.get.call(null,map__78920__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),((function (map__78920,map__78920__$1,stale_timeout){
return (function (e){
return cljs.core.println.call(null,"Supervisor:",e,e.stack);
});})(map__78920,map__78920__$1,stale_timeout))
);
var pending_fn = cljs.core.get.call(null,map__78920__$1,new cljs.core.Keyword(null,"pending-fn","pending-fn",1734381755));
var s = superv.async.map__GT_TrackingSupervisor.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"abort","abort",521193198),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"registered","registered",-388600037),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null));
var err_ch = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(s);
cljs.core.async.take_BANG_.call(null,err_ch,((function (s,err_ch,map__78920,map__78920__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$loop_fn(e){
error_fn.call(null,e);

return cljs.core.async.take_BANG_.call(null,err_ch,superv$async$loop_fn);
});})(s,err_ch,map__78920,map__78920__$1,stale_timeout,error_fn,pending_fn))
);

((function (s,err_ch,map__78920,map__78920__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$pending(_){
var vec__78932 = cljs.core.filter.call(null,((function (s,err_ch,map__78920,map__78920__$1,stale_timeout,error_fn,pending_fn){
return (function (p__78938){
var vec__78939 = p__78938;
var k = cljs.core.nth.call(null,vec__78939,(0),null);
var v = cljs.core.nth.call(null,vec__78939,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout) > v.getTime());
});})(s,err_ch,map__78920,map__78920__$1,stale_timeout,error_fn,pending_fn))
,cljs.core.deref.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s)));
var vec__78935 = cljs.core.nth.call(null,vec__78932,(0),null);
var e = cljs.core.nth.call(null,vec__78935,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__78935,(1),null);
if(cljs.core.truth_(e)){
error_fn.call(null,e);

superv.async._free_exception.call(null,s,e);
} else {
}

return cljs.core.async.take_BANG_.call(null,cljs.core.async.timeout.call(null,stale_timeout),superv$async$pending);
});})(s,err_ch,map__78920,map__78920__$1,stale_timeout,error_fn,pending_fn))
.call(null,null);

return s;
});

superv.async.simple_supervisor.cljs$lang$maxFixedArity = (0);

superv.async.simple_supervisor.cljs$lang$applyTo = (function (seq78918){
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq78918));
});

superv.async.S = superv.async.simple_supervisor.call(null);
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
superv.async.throw_if_exception = (function superv$async$throw_if_exception(S,x){
if((x instanceof Error)){
superv.async._free_exception.call(null,S,x);

throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),(function (){var or__9419__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
superv.async.superv_init = (function superv$async$superv_init(){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [superv.async._error,superv.async._abort,superv.async._register_go,superv.async._unregister_go,superv.async._track_exception,superv.async._free_exception,superv.async.throw_if_exception], null);
});
goog.exportSymbol('superv.async.superv_init', superv.async.superv_init);
superv.async.superv_init.call(null);
superv.async.supervisor_QMARK_ = (function superv$async$supervisor_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.superv$async$PSupervisor$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
}
});
superv.async.check_supervisor = (function superv$async$check_supervisor(x){
if(cljs.core.truth_(superv.async.supervisor_QMARK_.call(null,x))){
return null;
} else {
throw cljs.core.ex_info.call(null,"First argument is not a supervisor.",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"argument","argument",1183001841),x], null));
}
});
/**
 * Here until http://dev.clojure.org/jira/browse/ASYNC-74 is resolved.
 */
superv.async.chan_QMARK_ = (function superv$async$chan_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$ReadPort$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
}
});
/**
 * Same as core.async/take!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.take_QMARK_ = (function superv$async$take_QMARK_(var_args){
var args78962 = [];
var len__10640__auto___78965 = arguments.length;
var i__10641__auto___78966 = (0);
while(true){
if((i__10641__auto___78966 < len__10640__auto___78965)){
args78962.push((arguments[i__10641__auto___78966]));

var G__78967 = (i__10641__auto___78966 + (1));
i__10641__auto___78966 = G__78967;
continue;
} else {
}
break;
}

var G__78964 = args78962.length;
switch (G__78964) {
case 3:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78962.length)].join('')));

}
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,fn1){
return superv.async.take_QMARK_.call(null,S,port,fn1,true);
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,fn1,on_caller_QMARK_){
return cljs.core.async.take_BANG_.call(null,port,(function (v){
if((v instanceof Error)){
superv.async._free_exception.call(null,S,v);
} else {
}

return fn1.call(null,v);
}),on_caller_QMARK_);
});

superv.async.take_QMARK_.cljs$lang$maxFixedArity = 4;

/**
 * Same as core.async/put!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.put_QMARK_ = (function superv$async$put_QMARK_(var_args){
var args78969 = [];
var len__10640__auto___78972 = arguments.length;
var i__10641__auto___78973 = (0);
while(true){
if((i__10641__auto___78973 < len__10640__auto___78972)){
args78969.push((arguments[i__10641__auto___78973]));

var G__78974 = (i__10641__auto___78973 + (1));
i__10641__auto___78973 = G__78974;
continue;
} else {
}
break;
}

var G__78971 = args78969.length;
switch (G__78971) {
case 3:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78969.length)].join('')));

}
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,val){
return superv.async.put_QMARK_.call(null,S,port,val,(function superv$async$noop(_){
return null;
}));
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,val,fn1){
return superv.async.put_QMARK_.call(null,S,port,val,fn1,true);
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5 = (function (S,port,val,fn1,on_caller_QMARK_){
return cljs.core.async.put_BANG_.call(null,port,val,(function (ret){
if(((val instanceof Error)) && (!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,val)),new cljs.core.Keyword(null,"aborted","aborted",1775972619))))){
superv.async._track_exception.call(null,S,val);
} else {
}

return fn1.call(null,ret);
}),on_caller_QMARK_);
});

superv.async.put_QMARK_.cljs$lang$maxFixedArity = 5;

/**
 * Takes objects from in-ch, asynchrously applies function f> (function should
 *   return a channel), takes the result from the returned channel and if it's
 *   truthy, puts it in the out-ch. Returns the closed out-ch. Closes the
 *   returned channel when the input channel has been completely consumed and all
 *   objects have been processed.
 *   If out-ch is not provided, an unbuffered one will be used.
 */
superv.async.pmap_GT__GT_ = (function superv$async$pmap_GT__GT_(var_args){
var args78987 = [];
var len__10640__auto___79190 = arguments.length;
var i__10641__auto___79191 = (0);
while(true){
if((i__10641__auto___79191 < len__10640__auto___79190)){
args78987.push((arguments[i__10641__auto___79191]));

var G__79192 = (i__10641__auto___79191 + (1));
i__10641__auto___79191 = G__79192;
continue;
} else {
}
break;
}

var G__78989 = args78987.length;
switch (G__78989) {
case 4:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78987.length)].join('')));

}
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4 = (function (S,f_GT_,parallelism,in_ch){
return superv.async.pmap_GT__GT_.call(null,S,f_GT_,parallelism,cljs.core.async.chan.call(null),in_ch);
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5 = (function (S,f_GT_,parallelism,out_ch,in_ch){
if(cljs.core.fn_QMARK_.call(null,f_GT_)){
} else {
throw (new Error("Assert failed: (fn? f>)"));
}

if((cljs.core.integer_QMARK_.call(null,parallelism)) && ((parallelism > (0)))){
} else {
throw (new Error("Assert failed: (and (integer? parallelism) (pos? parallelism))"));
}

if((in_ch instanceof cljs.core.async.impl.protocols.ReadPort)){
} else {
throw (new Error("Assert failed: (instance? ReadPort in-ch)"));
}

var threads = cljs.core.atom.call(null,parallelism);
var n__10440__auto___79194 = parallelism;
var __79195 = (0);
while(true){
if((__79195 < n__10440__auto___79194)){
var c__23767__auto___79196 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___79197 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"result","result",-1239343558,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)))], null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null)))))),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"zero?","zero?",325758897,null),cljs.core.list(new cljs.core.Symbol(null,"swap!","swap!",-655677516,null),new cljs.core.Symbol(null,"threads","threads",-77267207,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))));
var c__38457__auto___79198 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__79195,c__38457__auto___79198,c__23767__auto___79196,id__23768__auto___79197,n__10440__auto___79194,threads){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (__79195,c__38457__auto___79198,c__23767__auto___79196,id__23768__auto___79197,n__10440__auto___79194,threads){
return (function (state_79124){
var state_val_79125 = (state_79124[(1)]);
if((state_val_79125 === (7))){
var inst_78993 = (state_79124[(7)]);
var inst_79001 = (state_79124[(2)]);
var state_79124__$1 = (function (){var statearr_79126 = state_79124;
(statearr_79126[(8)] = inst_79001);

return statearr_79126;
})();
var statearr_79127_79199 = state_79124__$1;
(statearr_79127_79199[(2)] = inst_78993);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79124__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (20))){
var inst_79108 = (state_79124[(2)]);
var state_79124__$1 = state_79124;
var statearr_79128_79200 = state_79124__$1;
(statearr_79128_79200[(2)] = inst_79108);

(statearr_79128_79200[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (27))){
var inst_79070 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79071 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79072 = cljs.core.PersistentHashMap.fromArrays(inst_79070,inst_79071);
var inst_79073 = cljs.core.ex_info.call(null,"Aborted operations",inst_79072);
var state_79124__$1 = state_79124;
var statearr_79129_79201 = state_79124__$1;
(statearr_79129_79201[(2)] = inst_79073);

(statearr_79129_79201[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (1))){
var state_79124__$1 = state_79124;
var statearr_79130_79202 = state_79124__$1;
(statearr_79130_79202[(2)] = null);

(statearr_79130_79202[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (24))){
var inst_79052 = (state_79124[(2)]);
var inst_79053 = superv.async.throw_if_exception.call(null,S,inst_79052);
var inst_79054 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_79124__$1 = (function (){var statearr_79131 = state_79124;
(statearr_79131[(9)] = inst_79053);

return statearr_79131;
})();
var statearr_79132_79203 = state_79124__$1;
(statearr_79132_79203[(2)] = inst_79054);

(statearr_79132_79203[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (39))){
var state_79124__$1 = state_79124;
var statearr_79133_79204 = state_79124__$1;
(statearr_79133_79204[(2)] = null);

(statearr_79133_79204[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (4))){
var inst_78993 = (state_79124[(7)]);
var inst_78993__$1 = (state_79124[(2)]);
var inst_78994 = cljs.core.ex_data.call(null,inst_78993__$1);
var inst_78995 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_78994);
var inst_78996 = cljs.core._EQ_.call(null,inst_78995,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_79124__$1 = (function (){var statearr_79134 = state_79124;
(statearr_79134[(7)] = inst_78993__$1);

return statearr_79134;
})();
if(inst_78996){
var statearr_79135_79205 = state_79124__$1;
(statearr_79135_79205[(1)] = (5));

} else {
var statearr_79136_79206 = state_79124__$1;
(statearr_79136_79206[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (15))){
var inst_79026 = (state_79124[(10)]);
var inst_79028 = (inst_79026 instanceof Error);
var state_79124__$1 = state_79124;
if(cljs.core.truth_(inst_79028)){
var statearr_79137_79207 = state_79124__$1;
(statearr_79137_79207[(1)] = (18));

} else {
var statearr_79138_79208 = state_79124__$1;
(statearr_79138_79208[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (21))){
var inst_79033 = (state_79124[(11)]);
var inst_79039 = (state_79124[(2)]);
var inst_79040 = cljs.core.nth.call(null,inst_79039,(0),null);
var inst_79041 = cljs.core.nth.call(null,inst_79039,(1),null);
var inst_79042 = cljs.core._EQ_.call(null,inst_79041,inst_79033);
var state_79124__$1 = (function (){var statearr_79139 = state_79124;
(statearr_79139[(12)] = inst_79040);

return statearr_79139;
})();
if(inst_79042){
var statearr_79140_79209 = state_79124__$1;
(statearr_79140_79209[(1)] = (22));

} else {
var statearr_79141_79210 = state_79124__$1;
(statearr_79141_79210[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (31))){
var state_79124__$1 = state_79124;
var statearr_79142_79211 = state_79124__$1;
(statearr_79142_79211[(2)] = null);

(statearr_79142_79211[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (32))){
var inst_79105 = (state_79124[(2)]);
var state_79124__$1 = (function (){var statearr_79143 = state_79124;
(statearr_79143[(13)] = inst_79105);

return statearr_79143;
})();
var statearr_79144_79212 = state_79124__$1;
(statearr_79144_79212[(2)] = null);

(statearr_79144_79212[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (40))){
var inst_79120 = (state_79124[(2)]);
var state_79124__$1 = state_79124;
var statearr_79145_79213 = state_79124__$1;
(statearr_79145_79213[(2)] = inst_79120);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79124__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (33))){
var inst_79082 = (state_79124[(14)]);
var inst_79088 = (state_79124[(2)]);
var inst_79089 = cljs.core.nth.call(null,inst_79088,(0),null);
var inst_79090 = cljs.core.nth.call(null,inst_79088,(1),null);
var inst_79091 = cljs.core._EQ_.call(null,inst_79090,inst_79082);
var state_79124__$1 = (function (){var statearr_79146 = state_79124;
(statearr_79146[(15)] = inst_79089);

return statearr_79146;
})();
if(inst_79091){
var statearr_79147_79214 = state_79124__$1;
(statearr_79147_79214[(1)] = (34));

} else {
var statearr_79148_79215 = state_79124__$1;
(statearr_79148_79215[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (13))){
var inst_79015 = (state_79124[(16)]);
var state_79124__$1 = state_79124;
var statearr_79149_79216 = state_79124__$1;
(statearr_79149_79216[(2)] = inst_79015);

(statearr_79149_79216[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (22))){
var inst_79044 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79045 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79046 = cljs.core.PersistentHashMap.fromArrays(inst_79044,inst_79045);
var inst_79047 = cljs.core.ex_info.call(null,"Aborted operations",inst_79046);
var state_79124__$1 = state_79124;
var statearr_79150_79217 = state_79124__$1;
(statearr_79150_79217[(2)] = inst_79047);

(statearr_79150_79217[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (36))){
var inst_79101 = (state_79124[(2)]);
var inst_79102 = superv.async.throw_if_exception.call(null,S,inst_79101);
var state_79124__$1 = state_79124;
var statearr_79151_79218 = state_79124__$1;
(statearr_79151_79218[(2)] = inst_79102);

(statearr_79151_79218[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (29))){
var inst_79077 = (state_79124[(17)]);
var inst_79076 = (state_79124[(2)]);
var inst_79077__$1 = superv.async.throw_if_exception.call(null,S,inst_79076);
var state_79124__$1 = (function (){var statearr_79152 = state_79124;
(statearr_79152[(17)] = inst_79077__$1);

return statearr_79152;
})();
if(cljs.core.truth_(inst_79077__$1)){
var statearr_79153_79219 = state_79124__$1;
(statearr_79153_79219[(1)] = (30));

} else {
var statearr_79154_79220 = state_79124__$1;
(statearr_79154_79220[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (6))){
var inst_78993 = (state_79124[(7)]);
var inst_78999 = superv.async._track_exception.call(null,S,inst_78993);
var state_79124__$1 = state_79124;
var statearr_79155_79221 = state_79124__$1;
(statearr_79155_79221[(2)] = inst_78999);

(statearr_79155_79221[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (28))){
var inst_79066 = (state_79124[(18)]);
var state_79124__$1 = state_79124;
var statearr_79156_79222 = state_79124__$1;
(statearr_79156_79222[(2)] = inst_79066);

(statearr_79156_79222[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (25))){
var inst_79050 = (state_79124[(2)]);
var state_79124__$1 = state_79124;
var statearr_79157_79223 = state_79124__$1;
(statearr_79157_79223[(2)] = inst_79050);

(statearr_79157_79223[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (34))){
var inst_79093 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79094 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79095 = cljs.core.PersistentHashMap.fromArrays(inst_79093,inst_79094);
var inst_79096 = cljs.core.ex_info.call(null,"Aborted operations",inst_79095);
var state_79124__$1 = state_79124;
var statearr_79158_79224 = state_79124__$1;
(statearr_79158_79224[(2)] = inst_79096);

(statearr_79158_79224[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (17))){
var inst_79111 = (state_79124[(2)]);
var state_79124__$1 = state_79124;
var statearr_79159_79225 = state_79124__$1;
(statearr_79159_79225[(2)] = inst_79111);

(statearr_79159_79225[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (3))){
var inst_78990 = (state_79124[(2)]);
var inst_78991 = superv.async._unregister_go.call(null,S,id__23768__auto___79197);
var state_79124__$1 = (function (){var statearr_79160 = state_79124;
(statearr_79160[(19)] = inst_78990);

(statearr_79160[(20)] = inst_78991);

return statearr_79160;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79124__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (12))){
var inst_79019 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79020 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79021 = cljs.core.PersistentHashMap.fromArrays(inst_79019,inst_79020);
var inst_79022 = cljs.core.ex_info.call(null,"Aborted operations",inst_79021);
var state_79124__$1 = state_79124;
var statearr_79161_79226 = state_79124__$1;
(statearr_79161_79226[(2)] = inst_79022);

(statearr_79161_79226[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (2))){
var inst_79122 = (state_79124[(2)]);
var state_79124__$1 = state_79124;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79124__$1,inst_79122);
} else {
if((state_val_79125 === (23))){
var inst_79026 = (state_79124[(10)]);
var state_79124__$1 = state_79124;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79124__$1,(25),out_ch,inst_79026);
} else {
if((state_val_79125 === (35))){
var inst_79077 = (state_79124[(17)]);
var state_79124__$1 = state_79124;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79124__$1,(37),out_ch,inst_79077);
} else {
if((state_val_79125 === (19))){
var inst_79026 = (state_79124[(10)]);
var inst_79059 = (state_79124[(21)]);
var inst_79059__$1 = superv.async._abort.call(null,S);
var inst_79060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79061 = f_GT_.call(null,inst_79026);
var inst_79062 = [inst_79059__$1,inst_79061];
var inst_79063 = (new cljs.core.PersistentVector(null,2,(5),inst_79060,inst_79062,null));
var state_79124__$1 = (function (){var statearr_79162 = state_79124;
(statearr_79162[(21)] = inst_79059__$1);

return statearr_79162;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79124__$1,(26),inst_79063,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_79125 === (11))){
var inst_79009 = (state_79124[(22)]);
var inst_79014 = (state_79124[(2)]);
var inst_79015 = cljs.core.nth.call(null,inst_79014,(0),null);
var inst_79016 = cljs.core.nth.call(null,inst_79014,(1),null);
var inst_79017 = cljs.core._EQ_.call(null,inst_79016,inst_79009);
var state_79124__$1 = (function (){var statearr_79163 = state_79124;
(statearr_79163[(16)] = inst_79015);

return statearr_79163;
})();
if(inst_79017){
var statearr_79164_79227 = state_79124__$1;
(statearr_79164_79227[(1)] = (12));

} else {
var statearr_79165_79228 = state_79124__$1;
(statearr_79165_79228[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (9))){
var inst_79009 = (state_79124[(22)]);
var inst_79009__$1 = superv.async._abort.call(null,S);
var inst_79010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79011 = [inst_79009__$1,in_ch];
var inst_79012 = (new cljs.core.PersistentVector(null,2,(5),inst_79010,inst_79011,null));
var state_79124__$1 = (function (){var statearr_79166 = state_79124;
(statearr_79166[(22)] = inst_79009__$1);

return statearr_79166;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79124__$1,(11),inst_79012,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_79125 === (5))){
var state_79124__$1 = state_79124;
var statearr_79167_79229 = state_79124__$1;
(statearr_79167_79229[(2)] = null);

(statearr_79167_79229[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (14))){
var inst_79026 = (state_79124[(10)]);
var inst_79025 = (state_79124[(2)]);
var inst_79026__$1 = superv.async.throw_if_exception.call(null,S,inst_79025);
var state_79124__$1 = (function (){var statearr_79168 = state_79124;
(statearr_79168[(10)] = inst_79026__$1);

return statearr_79168;
})();
if(cljs.core.truth_(inst_79026__$1)){
var statearr_79169_79230 = state_79124__$1;
(statearr_79169_79230[(1)] = (15));

} else {
var statearr_79170_79231 = state_79124__$1;
(statearr_79170_79231[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (26))){
var inst_79059 = (state_79124[(21)]);
var inst_79065 = (state_79124[(2)]);
var inst_79066 = cljs.core.nth.call(null,inst_79065,(0),null);
var inst_79067 = cljs.core.nth.call(null,inst_79065,(1),null);
var inst_79068 = cljs.core._EQ_.call(null,inst_79067,inst_79059);
var state_79124__$1 = (function (){var statearr_79171 = state_79124;
(statearr_79171[(18)] = inst_79066);

return statearr_79171;
})();
if(inst_79068){
var statearr_79172_79232 = state_79124__$1;
(statearr_79172_79232[(1)] = (27));

} else {
var statearr_79173_79233 = state_79124__$1;
(statearr_79173_79233[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (16))){
var state_79124__$1 = state_79124;
var statearr_79174_79234 = state_79124__$1;
(statearr_79174_79234[(2)] = null);

(statearr_79174_79234[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (38))){
var inst_79117 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_79124__$1 = state_79124;
var statearr_79175_79235 = state_79124__$1;
(statearr_79175_79235[(2)] = inst_79117);

(statearr_79175_79235[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (30))){
var inst_79082 = (state_79124[(14)]);
var inst_79082__$1 = superv.async._abort.call(null,S);
var inst_79083 = cljs.core.async.timeout.call(null,(0));
var inst_79084 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79085 = [inst_79082__$1,inst_79083];
var inst_79086 = (new cljs.core.PersistentVector(null,2,(5),inst_79084,inst_79085,null));
var state_79124__$1 = (function (){var statearr_79176 = state_79124;
(statearr_79176[(14)] = inst_79082__$1);

return statearr_79176;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79124__$1,(33),inst_79086,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_79125 === (10))){
var inst_79113 = (state_79124[(2)]);
var inst_79114 = cljs.core.swap_BANG_.call(null,threads,cljs.core.dec);
var inst_79115 = (inst_79114 === (0));
var state_79124__$1 = (function (){var statearr_79177 = state_79124;
(statearr_79177[(23)] = inst_79113);

return statearr_79177;
})();
if(cljs.core.truth_(inst_79115)){
var statearr_79178_79236 = state_79124__$1;
(statearr_79178_79236[(1)] = (38));

} else {
var statearr_79179_79237 = state_79124__$1;
(statearr_79179_79237[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (18))){
var inst_79033 = (state_79124[(11)]);
var inst_79033__$1 = superv.async._abort.call(null,S);
var inst_79034 = cljs.core.async.timeout.call(null,(0));
var inst_79035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79036 = [inst_79033__$1,inst_79034];
var inst_79037 = (new cljs.core.PersistentVector(null,2,(5),inst_79035,inst_79036,null));
var state_79124__$1 = (function (){var statearr_79180 = state_79124;
(statearr_79180[(11)] = inst_79033__$1);

return statearr_79180;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79124__$1,(21),inst_79037,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_79125 === (37))){
var inst_79099 = (state_79124[(2)]);
var state_79124__$1 = state_79124;
var statearr_79181_79238 = state_79124__$1;
(statearr_79181_79238[(2)] = inst_79099);

(statearr_79181_79238[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79125 === (8))){
var ___$1 = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_79124,(4),Error,(3),(2));
var state_79124__$1 = state_79124;
var statearr_79182_79239 = state_79124__$1;
(statearr_79182_79239[(2)] = null);

(statearr_79182_79239[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(__79195,c__38457__auto___79198,c__23767__auto___79196,id__23768__auto___79197,n__10440__auto___79194,threads))
;
return ((function (__79195,switch__38343__auto__,c__38457__auto___79198,c__23767__auto___79196,id__23768__auto___79197,n__10440__auto___79194,threads){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_79186 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79186[(0)] = superv$async$state_machine__38344__auto__);

(statearr_79186[(1)] = (1));

return statearr_79186;
});
var superv$async$state_machine__38344__auto____1 = (function (state_79124){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_79124);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e79187){if((e79187 instanceof Object)){
var ex__38347__auto__ = e79187;
var statearr_79188_79240 = state_79124;
(statearr_79188_79240[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79124);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79187;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79241 = state_79124;
state_79124 = G__79241;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_79124){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_79124);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(__79195,switch__38343__auto__,c__38457__auto___79198,c__23767__auto___79196,id__23768__auto___79197,n__10440__auto___79194,threads))
})();
var state__38459__auto__ = (function (){var statearr_79189 = f__38458__auto__.call(null);
(statearr_79189[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___79198);

return statearr_79189;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(__79195,c__38457__auto___79198,c__23767__auto___79196,id__23768__auto___79197,n__10440__auto___79194,threads))
);


var G__79242 = (__79195 + (1));
__79195 = G__79242;
continue;
} else {
}
break;
}

return out_ch;
});

superv.async.pmap_GT__GT_.cljs$lang$maxFixedArity = 5;

/**
 * Similiar to dorun. Simply takes messages from channels but does nothing with
 *   them. Returns channel that will close when all messages have been consumed.
 */
superv.async.engulf = (function superv$async$engulf(var_args){
var args__10647__auto__ = [];
var len__10640__auto___79323 = arguments.length;
var i__10641__auto___79324 = (0);
while(true){
if((i__10641__auto___79324 < len__10640__auto___79323)){
args__10647__auto__.push((arguments[i__10641__auto___79324]));

var G__79325 = (i__10641__auto___79324 + (1));
i__10641__auto___79324 = G__79325;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var ch = cljs.core.async.merge.call(null,cs);
var c__23767__auto__ = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto__ = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null))))));
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__,c__23767__auto__,id__23768__auto__,ch){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__,c__23767__auto__,id__23768__auto__,ch){
return (function (state_79292){
var state_val_79293 = (state_79292[(1)]);
if((state_val_79293 === (7))){
var inst_79248 = (state_79292[(7)]);
var inst_79256 = (state_79292[(2)]);
var state_79292__$1 = (function (){var statearr_79294 = state_79292;
(statearr_79294[(8)] = inst_79256);

return statearr_79294;
})();
var statearr_79295_79326 = state_79292__$1;
(statearr_79295_79326[(2)] = inst_79248);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79292__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79293 === (1))){
var state_79292__$1 = state_79292;
var statearr_79296_79327 = state_79292__$1;
(statearr_79296_79327[(2)] = null);

(statearr_79296_79327[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79293 === (4))){
var inst_79248 = (state_79292[(7)]);
var inst_79248__$1 = (state_79292[(2)]);
var inst_79249 = cljs.core.ex_data.call(null,inst_79248__$1);
var inst_79250 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_79249);
var inst_79251 = cljs.core._EQ_.call(null,inst_79250,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_79292__$1 = (function (){var statearr_79297 = state_79292;
(statearr_79297[(7)] = inst_79248__$1);

return statearr_79297;
})();
if(inst_79251){
var statearr_79298_79328 = state_79292__$1;
(statearr_79298_79328[(1)] = (5));

} else {
var statearr_79299_79329 = state_79292__$1;
(statearr_79299_79329[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79293 === (15))){
var state_79292__$1 = state_79292;
var statearr_79300_79330 = state_79292__$1;
(statearr_79300_79330[(2)] = null);

(statearr_79300_79330[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79293 === (13))){
var inst_79270 = (state_79292[(9)]);
var state_79292__$1 = state_79292;
var statearr_79301_79331 = state_79292__$1;
(statearr_79301_79331[(2)] = inst_79270);

(statearr_79301_79331[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79293 === (6))){
var inst_79248 = (state_79292[(7)]);
var inst_79254 = superv.async._track_exception.call(null,S,inst_79248);
var state_79292__$1 = state_79292;
var statearr_79302_79332 = state_79292__$1;
(statearr_79302_79332[(2)] = inst_79254);

(statearr_79302_79332[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79293 === (17))){
var inst_79286 = (state_79292[(2)]);
var state_79292__$1 = state_79292;
var statearr_79303_79333 = state_79292__$1;
(statearr_79303_79333[(2)] = inst_79286);

(statearr_79303_79333[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79293 === (3))){
var inst_79245 = (state_79292[(2)]);
var inst_79246 = superv.async._unregister_go.call(null,S,id__23768__auto__);
var state_79292__$1 = (function (){var statearr_79304 = state_79292;
(statearr_79304[(10)] = inst_79246);

(statearr_79304[(11)] = inst_79245);

return statearr_79304;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79292__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79293 === (12))){
var inst_79274 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79275 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79276 = cljs.core.PersistentHashMap.fromArrays(inst_79274,inst_79275);
var inst_79277 = cljs.core.ex_info.call(null,"Aborted operations",inst_79276);
var state_79292__$1 = state_79292;
var statearr_79305_79334 = state_79292__$1;
(statearr_79305_79334[(2)] = inst_79277);

(statearr_79305_79334[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79293 === (2))){
var inst_79290 = (state_79292[(2)]);
var state_79292__$1 = state_79292;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79292__$1,inst_79290);
} else {
if((state_val_79293 === (11))){
var inst_79264 = (state_79292[(12)]);
var inst_79269 = (state_79292[(2)]);
var inst_79270 = cljs.core.nth.call(null,inst_79269,(0),null);
var inst_79271 = cljs.core.nth.call(null,inst_79269,(1),null);
var inst_79272 = cljs.core._EQ_.call(null,inst_79271,inst_79264);
var state_79292__$1 = (function (){var statearr_79306 = state_79292;
(statearr_79306[(9)] = inst_79270);

return statearr_79306;
})();
if(inst_79272){
var statearr_79307_79335 = state_79292__$1;
(statearr_79307_79335[(1)] = (12));

} else {
var statearr_79308_79336 = state_79292__$1;
(statearr_79308_79336[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79293 === (9))){
var inst_79264 = (state_79292[(12)]);
var inst_79264__$1 = superv.async._abort.call(null,S);
var inst_79265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79266 = [inst_79264__$1,ch];
var inst_79267 = (new cljs.core.PersistentVector(null,2,(5),inst_79265,inst_79266,null));
var state_79292__$1 = (function (){var statearr_79309 = state_79292;
(statearr_79309[(12)] = inst_79264__$1);

return statearr_79309;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79292__$1,(11),inst_79267,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_79293 === (5))){
var state_79292__$1 = state_79292;
var statearr_79310_79337 = state_79292__$1;
(statearr_79310_79337[(2)] = null);

(statearr_79310_79337[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79293 === (14))){
var inst_79280 = (state_79292[(2)]);
var inst_79281 = superv.async.throw_if_exception.call(null,S,inst_79280);
var state_79292__$1 = state_79292;
if(cljs.core.truth_(inst_79281)){
var statearr_79311_79338 = state_79292__$1;
(statearr_79311_79338[(1)] = (15));

} else {
var statearr_79312_79339 = state_79292__$1;
(statearr_79312_79339[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79293 === (16))){
var state_79292__$1 = state_79292;
var statearr_79313_79340 = state_79292__$1;
(statearr_79313_79340[(2)] = null);

(statearr_79313_79340[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79293 === (10))){
var inst_79288 = (state_79292[(2)]);
var state_79292__$1 = state_79292;
var statearr_79314_79341 = state_79292__$1;
(statearr_79314_79341[(2)] = inst_79288);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79292__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79293 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_79292,(4),Error,(3),(2));
var state_79292__$1 = state_79292;
var statearr_79315_79342 = state_79292__$1;
(statearr_79315_79342[(2)] = null);

(statearr_79315_79342[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto__,c__23767__auto__,id__23768__auto__,ch))
;
return ((function (switch__38343__auto__,c__38457__auto__,c__23767__auto__,id__23768__auto__,ch){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_79319 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79319[(0)] = superv$async$state_machine__38344__auto__);

(statearr_79319[(1)] = (1));

return statearr_79319;
});
var superv$async$state_machine__38344__auto____1 = (function (state_79292){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_79292);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e79320){if((e79320 instanceof Object)){
var ex__38347__auto__ = e79320;
var statearr_79321_79343 = state_79292;
(statearr_79321_79343[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79292);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79320;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79344 = state_79292;
state_79292 = G__79344;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_79292){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_79292);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__,c__23767__auto__,id__23768__auto__,ch))
})();
var state__38459__auto__ = (function (){var statearr_79322 = f__38458__auto__.call(null);
(statearr_79322[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_79322;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__,c__23767__auto__,id__23768__auto__,ch))
);

return c__38457__auto__;
});

superv.async.engulf.cljs$lang$maxFixedArity = (1);

superv.async.engulf.cljs$lang$applyTo = (function (seq79243){
var G__79244 = cljs.core.first.call(null,seq79243);
var seq79243__$1 = cljs.core.next.call(null,seq79243);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic(G__79244,seq79243__$1);
});

/**
 * Performs a reduce on objects from ch with the function f> (which
 *   should return a channel). Returns a channel with the resulting
 *   value.
 */
superv.async.reduce_GT_ = (function superv$async$reduce_GT_(S,f_GT_,acc,ch){
var result = cljs.core.async.chan.call(null);
var c__23767__auto___79711 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___79712 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"->>","->>",-1874332161,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null)),new cljs.core.Symbol(null,"recur","recur",1202958259,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null)))))));
var c__38457__auto___79713 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___79713,c__23767__auto___79711,id__23768__auto___79712,result){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___79713,c__23767__auto___79711,id__23768__auto___79712,result){
return (function (state_79653){
var state_val_79654 = (state_79653[(1)]);
if((state_val_79654 === (7))){
var inst_79531 = (state_79653[(7)]);
var inst_79539 = (state_79653[(2)]);
var state_79653__$1 = (function (){var statearr_79655 = state_79653;
(statearr_79655[(8)] = inst_79539);

return statearr_79655;
})();
var statearr_79656_79714 = state_79653__$1;
(statearr_79656_79714[(2)] = inst_79531);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79653__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (20))){
var inst_79619 = (state_79653[(2)]);
var state_79653__$1 = state_79653;
var statearr_79657_79715 = state_79653__$1;
(statearr_79657_79715[(2)] = inst_79619);

(statearr_79657_79715[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (27))){
var inst_79609 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79610 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79611 = cljs.core.PersistentHashMap.fromArrays(inst_79609,inst_79610);
var inst_79612 = cljs.core.ex_info.call(null,"Aborted operations",inst_79611);
var state_79653__$1 = state_79653;
var statearr_79658_79716 = state_79653__$1;
(statearr_79658_79716[(2)] = inst_79612);

(statearr_79658_79716[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (1))){
var state_79653__$1 = state_79653;
var statearr_79659_79717 = state_79653__$1;
(statearr_79659_79717[(2)] = null);

(statearr_79659_79717[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (24))){
var inst_79591 = (state_79653[(2)]);
var inst_79592 = superv.async.throw_if_exception.call(null,S,inst_79591);
var inst_79593 = cljs.core.async.close_BANG_.call(null,result);
var state_79653__$1 = (function (){var statearr_79660 = state_79653;
(statearr_79660[(9)] = inst_79592);

return statearr_79660;
})();
var statearr_79661_79718 = state_79653__$1;
(statearr_79661_79718[(2)] = inst_79593);

(statearr_79661_79718[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (4))){
var inst_79531 = (state_79653[(7)]);
var inst_79531__$1 = (state_79653[(2)]);
var inst_79532 = cljs.core.ex_data.call(null,inst_79531__$1);
var inst_79533 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_79532);
var inst_79534 = cljs.core._EQ_.call(null,inst_79533,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_79653__$1 = (function (){var statearr_79662 = state_79653;
(statearr_79662[(7)] = inst_79531__$1);

return statearr_79662;
})();
if(inst_79534){
var statearr_79663_79719 = state_79653__$1;
(statearr_79663_79719[(1)] = (5));

} else {
var statearr_79664_79720 = state_79653__$1;
(statearr_79664_79720[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (15))){
var inst_79565 = (state_79653[(10)]);
var inst_79567 = (inst_79565 instanceof Error);
var state_79653__$1 = state_79653;
if(cljs.core.truth_(inst_79567)){
var statearr_79665_79721 = state_79653__$1;
(statearr_79665_79721[(1)] = (18));

} else {
var statearr_79666_79722 = state_79653__$1;
(statearr_79666_79722[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (21))){
var inst_79572 = (state_79653[(11)]);
var inst_79578 = (state_79653[(2)]);
var inst_79579 = cljs.core.nth.call(null,inst_79578,(0),null);
var inst_79580 = cljs.core.nth.call(null,inst_79578,(1),null);
var inst_79581 = cljs.core._EQ_.call(null,inst_79580,inst_79572);
var state_79653__$1 = (function (){var statearr_79667 = state_79653;
(statearr_79667[(12)] = inst_79579);

return statearr_79667;
})();
if(inst_79581){
var statearr_79668_79723 = state_79653__$1;
(statearr_79668_79723[(1)] = (22));

} else {
var statearr_79669_79724 = state_79653__$1;
(statearr_79669_79724[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (31))){
var inst_79635 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79636 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79637 = cljs.core.PersistentHashMap.fromArrays(inst_79635,inst_79636);
var inst_79638 = cljs.core.ex_info.call(null,"Aborted operations",inst_79637);
var state_79653__$1 = state_79653;
var statearr_79670_79725 = state_79653__$1;
(statearr_79670_79725[(2)] = inst_79638);

(statearr_79670_79725[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (32))){
var inst_79543 = (state_79653[(13)]);
var state_79653__$1 = state_79653;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79653__$1,(34),result,inst_79543);
} else {
if((state_val_79654 === (33))){
var inst_79643 = (state_79653[(2)]);
var inst_79644 = superv.async.throw_if_exception.call(null,S,inst_79643);
var inst_79645 = cljs.core.async.close_BANG_.call(null,result);
var state_79653__$1 = (function (){var statearr_79671 = state_79653;
(statearr_79671[(14)] = inst_79644);

return statearr_79671;
})();
var statearr_79672_79726 = state_79653__$1;
(statearr_79672_79726[(2)] = inst_79645);

(statearr_79672_79726[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (13))){
var inst_79554 = (state_79653[(15)]);
var state_79653__$1 = state_79653;
var statearr_79673_79727 = state_79653__$1;
(statearr_79673_79727[(2)] = inst_79554);

(statearr_79673_79727[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (22))){
var inst_79583 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79584 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79585 = cljs.core.PersistentHashMap.fromArrays(inst_79583,inst_79584);
var inst_79586 = cljs.core.ex_info.call(null,"Aborted operations",inst_79585);
var state_79653__$1 = state_79653;
var statearr_79674_79728 = state_79653__$1;
(statearr_79674_79728[(2)] = inst_79586);

(statearr_79674_79728[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (29))){
var inst_79615 = (state_79653[(2)]);
var inst_79616 = superv.async.throw_if_exception.call(null,S,inst_79615);
var inst_79543 = inst_79616;
var state_79653__$1 = (function (){var statearr_79675 = state_79653;
(statearr_79675[(13)] = inst_79543);

return statearr_79675;
})();
var statearr_79676_79729 = state_79653__$1;
(statearr_79676_79729[(2)] = null);

(statearr_79676_79729[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (6))){
var inst_79531 = (state_79653[(7)]);
var inst_79537 = superv.async._track_exception.call(null,S,inst_79531);
var state_79653__$1 = state_79653;
var statearr_79677_79730 = state_79653__$1;
(statearr_79677_79730[(2)] = inst_79537);

(statearr_79677_79730[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (28))){
var inst_79605 = (state_79653[(16)]);
var state_79653__$1 = state_79653;
var statearr_79678_79731 = state_79653__$1;
(statearr_79678_79731[(2)] = inst_79605);

(statearr_79678_79731[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (25))){
var inst_79589 = (state_79653[(2)]);
var state_79653__$1 = state_79653;
var statearr_79679_79732 = state_79653__$1;
(statearr_79679_79732[(2)] = inst_79589);

(statearr_79679_79732[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (34))){
var inst_79641 = (state_79653[(2)]);
var state_79653__$1 = state_79653;
var statearr_79680_79733 = state_79653__$1;
(statearr_79680_79733[(2)] = inst_79641);

(statearr_79680_79733[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (17))){
var inst_79647 = (state_79653[(2)]);
var state_79653__$1 = state_79653;
var statearr_79681_79734 = state_79653__$1;
(statearr_79681_79734[(2)] = inst_79647);

(statearr_79681_79734[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (3))){
var inst_79528 = (state_79653[(2)]);
var inst_79529 = superv.async._unregister_go.call(null,S,id__23768__auto___79712);
var state_79653__$1 = (function (){var statearr_79682 = state_79653;
(statearr_79682[(17)] = inst_79528);

(statearr_79682[(18)] = inst_79529);

return statearr_79682;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79653__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (12))){
var inst_79558 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79559 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79560 = cljs.core.PersistentHashMap.fromArrays(inst_79558,inst_79559);
var inst_79561 = cljs.core.ex_info.call(null,"Aborted operations",inst_79560);
var state_79653__$1 = state_79653;
var statearr_79683_79735 = state_79653__$1;
(statearr_79683_79735[(2)] = inst_79561);

(statearr_79683_79735[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (2))){
var inst_79651 = (state_79653[(2)]);
var state_79653__$1 = state_79653;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79653__$1,inst_79651);
} else {
if((state_val_79654 === (23))){
var inst_79565 = (state_79653[(10)]);
var state_79653__$1 = state_79653;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79653__$1,(25),result,inst_79565);
} else {
if((state_val_79654 === (19))){
var inst_79565 = (state_79653[(10)]);
var inst_79598 = (state_79653[(19)]);
var inst_79543 = (state_79653[(13)]);
var inst_79598__$1 = superv.async._abort.call(null,S);
var inst_79599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79600 = f_GT_.call(null,inst_79543,inst_79565);
var inst_79601 = [inst_79598__$1,inst_79600];
var inst_79602 = (new cljs.core.PersistentVector(null,2,(5),inst_79599,inst_79601,null));
var state_79653__$1 = (function (){var statearr_79684 = state_79653;
(statearr_79684[(19)] = inst_79598__$1);

return statearr_79684;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79653__$1,(26),inst_79602,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_79654 === (11))){
var inst_79548 = (state_79653[(20)]);
var inst_79553 = (state_79653[(2)]);
var inst_79554 = cljs.core.nth.call(null,inst_79553,(0),null);
var inst_79555 = cljs.core.nth.call(null,inst_79553,(1),null);
var inst_79556 = cljs.core._EQ_.call(null,inst_79555,inst_79548);
var state_79653__$1 = (function (){var statearr_79685 = state_79653;
(statearr_79685[(15)] = inst_79554);

return statearr_79685;
})();
if(inst_79556){
var statearr_79686_79736 = state_79653__$1;
(statearr_79686_79736[(1)] = (12));

} else {
var statearr_79687_79737 = state_79653__$1;
(statearr_79687_79737[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (9))){
var inst_79548 = (state_79653[(20)]);
var inst_79548__$1 = superv.async._abort.call(null,S);
var inst_79549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79550 = [inst_79548__$1,ch];
var inst_79551 = (new cljs.core.PersistentVector(null,2,(5),inst_79549,inst_79550,null));
var state_79653__$1 = (function (){var statearr_79688 = state_79653;
(statearr_79688[(20)] = inst_79548__$1);

return statearr_79688;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79653__$1,(11),inst_79551,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_79654 === (5))){
var state_79653__$1 = state_79653;
var statearr_79689_79738 = state_79653__$1;
(statearr_79689_79738[(2)] = null);

(statearr_79689_79738[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (14))){
var inst_79565 = (state_79653[(10)]);
var inst_79564 = (state_79653[(2)]);
var inst_79565__$1 = superv.async.throw_if_exception.call(null,S,inst_79564);
var state_79653__$1 = (function (){var statearr_79690 = state_79653;
(statearr_79690[(10)] = inst_79565__$1);

return statearr_79690;
})();
if(cljs.core.truth_(inst_79565__$1)){
var statearr_79691_79739 = state_79653__$1;
(statearr_79691_79739[(1)] = (15));

} else {
var statearr_79692_79740 = state_79653__$1;
(statearr_79692_79740[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (26))){
var inst_79598 = (state_79653[(19)]);
var inst_79604 = (state_79653[(2)]);
var inst_79605 = cljs.core.nth.call(null,inst_79604,(0),null);
var inst_79606 = cljs.core.nth.call(null,inst_79604,(1),null);
var inst_79607 = cljs.core._EQ_.call(null,inst_79606,inst_79598);
var state_79653__$1 = (function (){var statearr_79693 = state_79653;
(statearr_79693[(16)] = inst_79605);

return statearr_79693;
})();
if(inst_79607){
var statearr_79694_79741 = state_79653__$1;
(statearr_79694_79741[(1)] = (27));

} else {
var statearr_79695_79742 = state_79653__$1;
(statearr_79695_79742[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (16))){
var inst_79624 = (state_79653[(21)]);
var inst_79624__$1 = superv.async._abort.call(null,S);
var inst_79625 = cljs.core.async.timeout.call(null,(0));
var inst_79626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79627 = [inst_79624__$1,inst_79625];
var inst_79628 = (new cljs.core.PersistentVector(null,2,(5),inst_79626,inst_79627,null));
var state_79653__$1 = (function (){var statearr_79696 = state_79653;
(statearr_79696[(21)] = inst_79624__$1);

return statearr_79696;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79653__$1,(30),inst_79628,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_79654 === (30))){
var inst_79624 = (state_79653[(21)]);
var inst_79630 = (state_79653[(2)]);
var inst_79631 = cljs.core.nth.call(null,inst_79630,(0),null);
var inst_79632 = cljs.core.nth.call(null,inst_79630,(1),null);
var inst_79633 = cljs.core._EQ_.call(null,inst_79632,inst_79624);
var state_79653__$1 = (function (){var statearr_79697 = state_79653;
(statearr_79697[(22)] = inst_79631);

return statearr_79697;
})();
if(inst_79633){
var statearr_79698_79743 = state_79653__$1;
(statearr_79698_79743[(1)] = (31));

} else {
var statearr_79699_79744 = state_79653__$1;
(statearr_79699_79744[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (10))){
var inst_79649 = (state_79653[(2)]);
var state_79653__$1 = state_79653;
var statearr_79700_79745 = state_79653__$1;
(statearr_79700_79745[(2)] = inst_79649);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79653__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79654 === (18))){
var inst_79572 = (state_79653[(11)]);
var inst_79572__$1 = superv.async._abort.call(null,S);
var inst_79573 = cljs.core.async.timeout.call(null,(0));
var inst_79574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79575 = [inst_79572__$1,inst_79573];
var inst_79576 = (new cljs.core.PersistentVector(null,2,(5),inst_79574,inst_79575,null));
var state_79653__$1 = (function (){var statearr_79701 = state_79653;
(statearr_79701[(11)] = inst_79572__$1);

return statearr_79701;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79653__$1,(21),inst_79576,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_79654 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_79653,(4),Error,(3),(2));
var inst_79543 = acc;
var state_79653__$1 = (function (){var statearr_79702 = state_79653;
(statearr_79702[(13)] = inst_79543);

return statearr_79702;
})();
var statearr_79703_79746 = state_79653__$1;
(statearr_79703_79746[(2)] = null);

(statearr_79703_79746[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___79713,c__23767__auto___79711,id__23768__auto___79712,result))
;
return ((function (switch__38343__auto__,c__38457__auto___79713,c__23767__auto___79711,id__23768__auto___79712,result){
return (function() {
var superv$async$reduce_GT__$_state_machine__38344__auto__ = null;
var superv$async$reduce_GT__$_state_machine__38344__auto____0 = (function (){
var statearr_79707 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79707[(0)] = superv$async$reduce_GT__$_state_machine__38344__auto__);

(statearr_79707[(1)] = (1));

return statearr_79707;
});
var superv$async$reduce_GT__$_state_machine__38344__auto____1 = (function (state_79653){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_79653);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e79708){if((e79708 instanceof Object)){
var ex__38347__auto__ = e79708;
var statearr_79709_79747 = state_79653;
(statearr_79709_79747[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79653);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79708;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79748 = state_79653;
state_79653 = G__79748;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$reduce_GT__$_state_machine__38344__auto__ = function(state_79653){
switch(arguments.length){
case 0:
return superv$async$reduce_GT__$_state_machine__38344__auto____0.call(this);
case 1:
return superv$async$reduce_GT__$_state_machine__38344__auto____1.call(this,state_79653);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$reduce_GT__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$reduce_GT__$_state_machine__38344__auto____0;
superv$async$reduce_GT__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$reduce_GT__$_state_machine__38344__auto____1;
return superv$async$reduce_GT__$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___79713,c__23767__auto___79711,id__23768__auto___79712,result))
})();
var state__38459__auto__ = (function (){var statearr_79710 = f__38458__auto__.call(null);
(statearr_79710[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___79713);

return statearr_79710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___79713,c__23767__auto___79711,id__23768__auto___79712,result))
);


return result;
});
/**
 * Concatenates two or more channels. First takes all values from first channel
 *   and supplies to output channel, then takes all values from second channel and
 *   so on. Similiar to core.async/merge but maintains the order of values.
 */
superv.async.concat_GT__GT_ = (function superv$async$concat_GT__GT_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___79878 = arguments.length;
var i__10641__auto___79879 = (0);
while(true){
if((i__10641__auto___79879 < len__10640__auto___79878)){
args__10647__auto__.push((arguments[i__10641__auto___79879]));

var G__79880 = (i__10641__auto___79879 + (1));
i__10641__auto___79879 = G__79880;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var out = cljs.core.async.chan.call(null);
var c__23767__auto___79881 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___79882 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"c","c",-122660552,null),cljs.core.list(new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"c","c",-122660552,null))], null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"v","v",1661996586,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.list(new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null))))));
var c__38457__auto___79883 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___79883,c__23767__auto___79881,id__23768__auto___79882,out){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___79883,c__23767__auto___79881,id__23768__auto___79882,out){
return (function (state_79831){
var state_val_79832 = (state_79831[(1)]);
if((state_val_79832 === (7))){
var inst_79754 = (state_79831[(7)]);
var inst_79762 = (state_79831[(2)]);
var state_79831__$1 = (function (){var statearr_79834 = state_79831;
(statearr_79834[(8)] = inst_79762);

return statearr_79834;
})();
var statearr_79835_79884 = state_79831__$1;
(statearr_79835_79884[(2)] = inst_79754);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79831__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (20))){
var inst_79821 = (state_79831[(2)]);
var state_79831__$1 = state_79831;
var statearr_79836_79885 = state_79831__$1;
(statearr_79836_79885[(2)] = inst_79821);

(statearr_79836_79885[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (1))){
var state_79831__$1 = state_79831;
var statearr_79837_79886 = state_79831__$1;
(statearr_79837_79886[(2)] = null);

(statearr_79837_79886[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (24))){
var inst_79766 = (state_79831[(9)]);
var inst_79814 = (state_79831[(2)]);
var inst_79815 = superv.async.throw_if_exception.call(null,S,inst_79814);
var tmp79833 = inst_79766;
var inst_79766__$1 = tmp79833;
var state_79831__$1 = (function (){var statearr_79838 = state_79831;
(statearr_79838[(9)] = inst_79766__$1);

(statearr_79838[(10)] = inst_79815);

return statearr_79838;
})();
var statearr_79839_79887 = state_79831__$1;
(statearr_79839_79887[(2)] = null);

(statearr_79839_79887[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (4))){
var inst_79754 = (state_79831[(7)]);
var inst_79754__$1 = (state_79831[(2)]);
var inst_79755 = cljs.core.ex_data.call(null,inst_79754__$1);
var inst_79756 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_79755);
var inst_79757 = cljs.core._EQ_.call(null,inst_79756,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_79831__$1 = (function (){var statearr_79840 = state_79831;
(statearr_79840[(7)] = inst_79754__$1);

return statearr_79840;
})();
if(inst_79757){
var statearr_79841_79888 = state_79831__$1;
(statearr_79841_79888[(1)] = (5));

} else {
var statearr_79842_79889 = state_79831__$1;
(statearr_79842_79889[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (15))){
var inst_79783 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79784 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79785 = cljs.core.PersistentHashMap.fromArrays(inst_79783,inst_79784);
var inst_79786 = cljs.core.ex_info.call(null,"Aborted operations",inst_79785);
var state_79831__$1 = state_79831;
var statearr_79843_79890 = state_79831__$1;
(statearr_79843_79890[(2)] = inst_79786);

(statearr_79843_79890[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (21))){
var inst_79795 = (state_79831[(11)]);
var inst_79801 = (state_79831[(2)]);
var inst_79802 = cljs.core.nth.call(null,inst_79801,(0),null);
var inst_79803 = cljs.core.nth.call(null,inst_79801,(1),null);
var inst_79804 = cljs.core._EQ_.call(null,inst_79803,inst_79795);
var state_79831__$1 = (function (){var statearr_79844 = state_79831;
(statearr_79844[(12)] = inst_79802);

return statearr_79844;
})();
if(inst_79804){
var statearr_79845_79891 = state_79831__$1;
(statearr_79845_79891[(1)] = (22));

} else {
var statearr_79846_79892 = state_79831__$1;
(statearr_79846_79892[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (13))){
var inst_79825 = (state_79831[(2)]);
var state_79831__$1 = state_79831;
var statearr_79847_79893 = state_79831__$1;
(statearr_79847_79893[(2)] = inst_79825);

(statearr_79847_79893[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (22))){
var inst_79806 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79807 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79808 = cljs.core.PersistentHashMap.fromArrays(inst_79806,inst_79807);
var inst_79809 = cljs.core.ex_info.call(null,"Aborted operations",inst_79808);
var state_79831__$1 = state_79831;
var statearr_79848_79894 = state_79831__$1;
(statearr_79848_79894[(2)] = inst_79809);

(statearr_79848_79894[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (6))){
var inst_79754 = (state_79831[(7)]);
var inst_79760 = superv.async._track_exception.call(null,S,inst_79754);
var state_79831__$1 = state_79831;
var statearr_79849_79895 = state_79831__$1;
(statearr_79849_79895[(2)] = inst_79760);

(statearr_79849_79895[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (25))){
var inst_79812 = (state_79831[(2)]);
var state_79831__$1 = state_79831;
var statearr_79850_79896 = state_79831__$1;
(statearr_79850_79896[(2)] = inst_79812);

(statearr_79850_79896[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (17))){
var inst_79790 = (state_79831[(13)]);
var inst_79789 = (state_79831[(2)]);
var inst_79790__$1 = superv.async.throw_if_exception.call(null,S,inst_79789);
var state_79831__$1 = (function (){var statearr_79851 = state_79831;
(statearr_79851[(13)] = inst_79790__$1);

return statearr_79851;
})();
if(cljs.core.truth_(inst_79790__$1)){
var statearr_79852_79897 = state_79831__$1;
(statearr_79852_79897[(1)] = (18));

} else {
var statearr_79853_79898 = state_79831__$1;
(statearr_79853_79898[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (3))){
var inst_79751 = (state_79831[(2)]);
var inst_79752 = superv.async._unregister_go.call(null,S,id__23768__auto___79882);
var state_79831__$1 = (function (){var statearr_79854 = state_79831;
(statearr_79854[(14)] = inst_79752);

(statearr_79854[(15)] = inst_79751);

return statearr_79854;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79831__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (12))){
var inst_79823 = cljs.core.async.close_BANG_.call(null,out);
var state_79831__$1 = state_79831;
var statearr_79855_79899 = state_79831__$1;
(statearr_79855_79899[(2)] = inst_79823);

(statearr_79855_79899[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (2))){
var inst_79829 = (state_79831[(2)]);
var state_79831__$1 = state_79831;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79831__$1,inst_79829);
} else {
if((state_val_79832 === (23))){
var inst_79790 = (state_79831[(13)]);
var state_79831__$1 = state_79831;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79831__$1,(25),out,inst_79790);
} else {
if((state_val_79832 === (19))){
var inst_79766 = (state_79831[(9)]);
var inst_79818 = cljs.core.rest.call(null,inst_79766);
var inst_79766__$1 = inst_79818;
var state_79831__$1 = (function (){var statearr_79856 = state_79831;
(statearr_79856[(9)] = inst_79766__$1);

return statearr_79856;
})();
var statearr_79857_79900 = state_79831__$1;
(statearr_79857_79900[(2)] = null);

(statearr_79857_79900[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (11))){
var inst_79773 = (state_79831[(16)]);
var inst_79768 = (state_79831[(17)]);
var inst_79773__$1 = superv.async._abort.call(null,S);
var inst_79774 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79775 = [inst_79773__$1,inst_79768];
var inst_79776 = (new cljs.core.PersistentVector(null,2,(5),inst_79774,inst_79775,null));
var state_79831__$1 = (function (){var statearr_79858 = state_79831;
(statearr_79858[(16)] = inst_79773__$1);

return statearr_79858;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79831__$1,(14),inst_79776,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_79832 === (9))){
var inst_79766 = (state_79831[(9)]);
var inst_79768 = (state_79831[(17)]);
var inst_79768__$1 = cljs.core.first.call(null,inst_79766);
var state_79831__$1 = (function (){var statearr_79859 = state_79831;
(statearr_79859[(17)] = inst_79768__$1);

return statearr_79859;
})();
if(cljs.core.truth_(inst_79768__$1)){
var statearr_79860_79901 = state_79831__$1;
(statearr_79860_79901[(1)] = (11));

} else {
var statearr_79861_79902 = state_79831__$1;
(statearr_79861_79902[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (5))){
var state_79831__$1 = state_79831;
var statearr_79862_79903 = state_79831__$1;
(statearr_79862_79903[(2)] = null);

(statearr_79862_79903[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (14))){
var inst_79773 = (state_79831[(16)]);
var inst_79778 = (state_79831[(2)]);
var inst_79779 = cljs.core.nth.call(null,inst_79778,(0),null);
var inst_79780 = cljs.core.nth.call(null,inst_79778,(1),null);
var inst_79781 = cljs.core._EQ_.call(null,inst_79780,inst_79773);
var state_79831__$1 = (function (){var statearr_79863 = state_79831;
(statearr_79863[(18)] = inst_79779);

return statearr_79863;
})();
if(inst_79781){
var statearr_79864_79904 = state_79831__$1;
(statearr_79864_79904[(1)] = (15));

} else {
var statearr_79865_79905 = state_79831__$1;
(statearr_79865_79905[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (16))){
var inst_79779 = (state_79831[(18)]);
var state_79831__$1 = state_79831;
var statearr_79866_79906 = state_79831__$1;
(statearr_79866_79906[(2)] = inst_79779);

(statearr_79866_79906[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (10))){
var inst_79827 = (state_79831[(2)]);
var state_79831__$1 = state_79831;
var statearr_79867_79907 = state_79831__$1;
(statearr_79867_79907[(2)] = inst_79827);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79831__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79832 === (18))){
var inst_79795 = (state_79831[(11)]);
var inst_79795__$1 = superv.async._abort.call(null,S);
var inst_79796 = cljs.core.async.timeout.call(null,(0));
var inst_79797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79798 = [inst_79795__$1,inst_79796];
var inst_79799 = (new cljs.core.PersistentVector(null,2,(5),inst_79797,inst_79798,null));
var state_79831__$1 = (function (){var statearr_79868 = state_79831;
(statearr_79868[(11)] = inst_79795__$1);

return statearr_79868;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79831__$1,(21),inst_79799,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_79832 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_79831,(4),Error,(3),(2));
var inst_79766 = cs;
var state_79831__$1 = (function (){var statearr_79869 = state_79831;
(statearr_79869[(9)] = inst_79766);

return statearr_79869;
})();
var statearr_79870_79908 = state_79831__$1;
(statearr_79870_79908[(2)] = null);

(statearr_79870_79908[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___79883,c__23767__auto___79881,id__23768__auto___79882,out))
;
return ((function (switch__38343__auto__,c__38457__auto___79883,c__23767__auto___79881,id__23768__auto___79882,out){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_79874 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79874[(0)] = superv$async$state_machine__38344__auto__);

(statearr_79874[(1)] = (1));

return statearr_79874;
});
var superv$async$state_machine__38344__auto____1 = (function (state_79831){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_79831);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e79875){if((e79875 instanceof Object)){
var ex__38347__auto__ = e79875;
var statearr_79876_79909 = state_79831;
(statearr_79876_79909[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79831);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79875;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79910 = state_79831;
state_79831 = G__79910;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_79831){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_79831);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___79883,c__23767__auto___79881,id__23768__auto___79882,out))
})();
var state__38459__auto__ = (function (){var statearr_79877 = f__38458__auto__.call(null);
(statearr_79877[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___79883);

return statearr_79877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___79883,c__23767__auto___79881,id__23768__auto___79882,out))
);


return out;
});

superv.async.concat_GT__GT_.cljs$lang$maxFixedArity = (1);

superv.async.concat_GT__GT_.cljs$lang$applyTo = (function (seq79749){
var G__79750 = cljs.core.first.call(null,seq79749);
var seq79749__$1 = cljs.core.next.call(null,seq79749);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__79750,seq79749__$1);
});

superv.async.partition_all_GT__GT_ = (function superv$async$partition_all_GT__GT_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___80128 = arguments.length;
var i__10641__auto___80129 = (0);
while(true){
if((i__10641__auto___80129 < len__10640__auto___80128)){
args__10647__auto__.push((arguments[i__10641__auto___80129]));

var G__80130 = (i__10641__auto___80129 + (1));
i__10641__auto___80129 = G__80130;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((3) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((3)),(0),null)):null);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10648__auto__);
});

superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,n,in_ch,p__79915){
var map__79916 = p__79915;
var map__79916__$1 = ((((!((map__79916 == null)))?((((map__79916.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__79916.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__79916):map__79916);
var out_ch = cljs.core.get.call(null,map__79916__$1,new cljs.core.Keyword(null,"out-ch","out-ch",-189045854));

new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(n > (0))], null)], null);

var out_ch__$1 = (function (){var or__9419__auto__ = out_ch;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})();
var c__23767__auto___80131 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___80132 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"batch","batch",977610327,null),cljs.core.PersistentVector.EMPTY], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null),cljs.core.list(new cljs.core.Symbol(null,"conj","conj",-1127293942,null),new cljs.core.Symbol(null,"batch","batch",977610327,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.PersistentVector.EMPTY)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"not-empty","not-empty",2029453590,null),new cljs.core.Symbol(null,"batch","batch",977610327,null)),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"batch","batch",977610327,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))))));
var c__38457__auto___80133 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___80133,c__23767__auto___80131,id__23768__auto___80132,out_ch__$1,map__79916,map__79916__$1,out_ch){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___80133,c__23767__auto___80131,id__23768__auto___80132,out_ch__$1,map__79916,map__79916__$1,out_ch){
return (function (state_80060){
var state_val_80061 = (state_80060[(1)]);
if((state_val_80061 === (7))){
var inst_79921 = (state_80060[(7)]);
var inst_79929 = (state_80060[(2)]);
var state_80060__$1 = (function (){var statearr_80062 = state_80060;
(statearr_80062[(8)] = inst_79929);

return statearr_80062;
})();
var statearr_80063_80134 = state_80060__$1;
(statearr_80063_80134[(2)] = inst_79921);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80060__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (20))){
var inst_80021 = (state_80060[(2)]);
var state_80060__$1 = state_80060;
var statearr_80064_80135 = state_80060__$1;
(statearr_80064_80135[(2)] = inst_80021);

(statearr_80064_80135[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (27))){
var inst_79986 = (state_80060[(9)]);
var inst_79934 = inst_79986;
var state_80060__$1 = (function (){var statearr_80065 = state_80060;
(statearr_80065[(10)] = inst_79934);

return statearr_80065;
})();
var statearr_80066_80136 = state_80060__$1;
(statearr_80066_80136[(2)] = null);

(statearr_80066_80136[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (1))){
var state_80060__$1 = state_80060;
var statearr_80067_80137 = state_80060__$1;
(statearr_80067_80137[(2)] = null);

(statearr_80067_80137[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (24))){
var inst_79982 = (state_80060[(2)]);
var inst_79983 = superv.async.throw_if_exception.call(null,S,inst_79982);
var inst_79984 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_80060__$1 = (function (){var statearr_80068 = state_80060;
(statearr_80068[(11)] = inst_79983);

return statearr_80068;
})();
var statearr_80069_80138 = state_80060__$1;
(statearr_80069_80138[(2)] = inst_79984);

(statearr_80069_80138[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (39))){
var inst_79934 = (state_80060[(10)]);
var state_80060__$1 = state_80060;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_80060__$1,(41),out_ch__$1,inst_79934);
} else {
if((state_val_80061 === (4))){
var inst_79921 = (state_80060[(7)]);
var inst_79921__$1 = (state_80060[(2)]);
var inst_79922 = cljs.core.ex_data.call(null,inst_79921__$1);
var inst_79923 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_79922);
var inst_79924 = cljs.core._EQ_.call(null,inst_79923,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_80060__$1 = (function (){var statearr_80070 = state_80060;
(statearr_80070[(7)] = inst_79921__$1);

return statearr_80070;
})();
if(inst_79924){
var statearr_80071_80139 = state_80060__$1;
(statearr_80071_80139[(1)] = (5));

} else {
var statearr_80072_80140 = state_80060__$1;
(statearr_80072_80140[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (15))){
var inst_79956 = (state_80060[(12)]);
var inst_79958 = (inst_79956 instanceof Error);
var state_80060__$1 = state_80060;
if(cljs.core.truth_(inst_79958)){
var statearr_80073_80141 = state_80060__$1;
(statearr_80073_80141[(1)] = (18));

} else {
var statearr_80074_80142 = state_80060__$1;
(statearr_80074_80142[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (21))){
var inst_79963 = (state_80060[(13)]);
var inst_79969 = (state_80060[(2)]);
var inst_79970 = cljs.core.nth.call(null,inst_79969,(0),null);
var inst_79971 = cljs.core.nth.call(null,inst_79969,(1),null);
var inst_79972 = cljs.core._EQ_.call(null,inst_79971,inst_79963);
var state_80060__$1 = (function (){var statearr_80075 = state_80060;
(statearr_80075[(14)] = inst_79970);

return statearr_80075;
})();
if(inst_79972){
var statearr_80076_80143 = state_80060__$1;
(statearr_80076_80143[(1)] = (22));

} else {
var statearr_80077_80144 = state_80060__$1;
(statearr_80077_80144[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (31))){
var inst_79986 = (state_80060[(9)]);
var state_80060__$1 = state_80060;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_80060__$1,(33),out_ch__$1,inst_79986);
} else {
if((state_val_80061 === (32))){
var inst_80012 = (state_80060[(2)]);
var inst_80013 = superv.async.throw_if_exception.call(null,S,inst_80012);
var inst_80014 = cljs.core.PersistentVector.EMPTY;
var inst_79934 = inst_80014;
var state_80060__$1 = (function (){var statearr_80078 = state_80060;
(statearr_80078[(10)] = inst_79934);

(statearr_80078[(15)] = inst_80013);

return statearr_80078;
})();
var statearr_80079_80145 = state_80060__$1;
(statearr_80079_80145[(2)] = null);

(statearr_80079_80145[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (40))){
var inst_80047 = (state_80060[(2)]);
var inst_80048 = superv.async.throw_if_exception.call(null,S,inst_80047);
var state_80060__$1 = state_80060;
var statearr_80080_80146 = state_80060__$1;
(statearr_80080_80146[(2)] = inst_80048);

(statearr_80080_80146[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (33))){
var inst_80010 = (state_80060[(2)]);
var state_80060__$1 = state_80060;
var statearr_80081_80147 = state_80060__$1;
(statearr_80081_80147[(2)] = inst_80010);

(statearr_80081_80147[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (13))){
var inst_79945 = (state_80060[(16)]);
var state_80060__$1 = state_80060;
var statearr_80082_80148 = state_80060__$1;
(statearr_80082_80148[(2)] = inst_79945);

(statearr_80082_80148[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (22))){
var inst_79974 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79975 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79976 = cljs.core.PersistentHashMap.fromArrays(inst_79974,inst_79975);
var inst_79977 = cljs.core.ex_info.call(null,"Aborted operations",inst_79976);
var state_80060__$1 = state_80060;
var statearr_80083_80149 = state_80060__$1;
(statearr_80083_80149[(2)] = inst_79977);

(statearr_80083_80149[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (36))){
var inst_80051 = (state_80060[(2)]);
var inst_80052 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_80060__$1 = (function (){var statearr_80084 = state_80060;
(statearr_80084[(17)] = inst_80051);

return statearr_80084;
})();
var statearr_80085_80150 = state_80060__$1;
(statearr_80085_80150[(2)] = inst_80052);

(statearr_80085_80150[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (41))){
var inst_80045 = (state_80060[(2)]);
var state_80060__$1 = state_80060;
var statearr_80086_80151 = state_80060__$1;
(statearr_80086_80151[(2)] = inst_80045);

(statearr_80086_80151[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (29))){
var inst_79993 = (state_80060[(18)]);
var inst_79999 = (state_80060[(2)]);
var inst_80000 = cljs.core.nth.call(null,inst_79999,(0),null);
var inst_80001 = cljs.core.nth.call(null,inst_79999,(1),null);
var inst_80002 = cljs.core._EQ_.call(null,inst_80001,inst_79993);
var state_80060__$1 = (function (){var statearr_80087 = state_80060;
(statearr_80087[(19)] = inst_80000);

return statearr_80087;
})();
if(inst_80002){
var statearr_80088_80152 = state_80060__$1;
(statearr_80088_80152[(1)] = (30));

} else {
var statearr_80089_80153 = state_80060__$1;
(statearr_80089_80153[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (6))){
var inst_79921 = (state_80060[(7)]);
var inst_79927 = superv.async._track_exception.call(null,S,inst_79921);
var state_80060__$1 = state_80060;
var statearr_80090_80154 = state_80060__$1;
(statearr_80090_80154[(2)] = inst_79927);

(statearr_80090_80154[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (28))){
var inst_80019 = (state_80060[(2)]);
var state_80060__$1 = state_80060;
var statearr_80091_80155 = state_80060__$1;
(statearr_80091_80155[(2)] = inst_80019);

(statearr_80091_80155[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (25))){
var inst_79980 = (state_80060[(2)]);
var state_80060__$1 = state_80060;
var statearr_80092_80156 = state_80060__$1;
(statearr_80092_80156[(2)] = inst_79980);

(statearr_80092_80156[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (34))){
var inst_80028 = (state_80060[(20)]);
var inst_80028__$1 = superv.async._abort.call(null,S);
var inst_80029 = cljs.core.async.timeout.call(null,(0));
var inst_80030 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80031 = [inst_80028__$1,inst_80029];
var inst_80032 = (new cljs.core.PersistentVector(null,2,(5),inst_80030,inst_80031,null));
var state_80060__$1 = (function (){var statearr_80093 = state_80060;
(statearr_80093[(20)] = inst_80028__$1);

return statearr_80093;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_80060__$1,(37),inst_80032,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_80061 === (17))){
var inst_80054 = (state_80060[(2)]);
var state_80060__$1 = state_80060;
var statearr_80094_80157 = state_80060__$1;
(statearr_80094_80157[(2)] = inst_80054);

(statearr_80094_80157[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (3))){
var inst_79918 = (state_80060[(2)]);
var inst_79919 = superv.async._unregister_go.call(null,S,id__23768__auto___80132);
var state_80060__$1 = (function (){var statearr_80095 = state_80060;
(statearr_80095[(21)] = inst_79918);

(statearr_80095[(22)] = inst_79919);

return statearr_80095;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80060__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (12))){
var inst_79949 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79950 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79951 = cljs.core.PersistentHashMap.fromArrays(inst_79949,inst_79950);
var inst_79952 = cljs.core.ex_info.call(null,"Aborted operations",inst_79951);
var state_80060__$1 = state_80060;
var statearr_80096_80158 = state_80060__$1;
(statearr_80096_80158[(2)] = inst_79952);

(statearr_80096_80158[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (2))){
var inst_80058 = (state_80060[(2)]);
var state_80060__$1 = state_80060;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80060__$1,inst_80058);
} else {
if((state_val_80061 === (23))){
var inst_79956 = (state_80060[(12)]);
var state_80060__$1 = state_80060;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_80060__$1,(25),out_ch__$1,inst_79956);
} else {
if((state_val_80061 === (35))){
var state_80060__$1 = state_80060;
var statearr_80097_80159 = state_80060__$1;
(statearr_80097_80159[(2)] = null);

(statearr_80097_80159[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (19))){
var inst_79934 = (state_80060[(10)]);
var inst_79956 = (state_80060[(12)]);
var inst_79986 = (state_80060[(9)]);
var inst_79986__$1 = cljs.core.conj.call(null,inst_79934,inst_79956);
var inst_79987 = cljs.core.count.call(null,inst_79986__$1);
var inst_79988 = cljs.core._EQ_.call(null,n,inst_79987);
var state_80060__$1 = (function (){var statearr_80098 = state_80060;
(statearr_80098[(9)] = inst_79986__$1);

return statearr_80098;
})();
if(inst_79988){
var statearr_80099_80160 = state_80060__$1;
(statearr_80099_80160[(1)] = (26));

} else {
var statearr_80100_80161 = state_80060__$1;
(statearr_80100_80161[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (11))){
var inst_79939 = (state_80060[(23)]);
var inst_79944 = (state_80060[(2)]);
var inst_79945 = cljs.core.nth.call(null,inst_79944,(0),null);
var inst_79946 = cljs.core.nth.call(null,inst_79944,(1),null);
var inst_79947 = cljs.core._EQ_.call(null,inst_79946,inst_79939);
var state_80060__$1 = (function (){var statearr_80101 = state_80060;
(statearr_80101[(16)] = inst_79945);

return statearr_80101;
})();
if(inst_79947){
var statearr_80102_80162 = state_80060__$1;
(statearr_80102_80162[(1)] = (12));

} else {
var statearr_80103_80163 = state_80060__$1;
(statearr_80103_80163[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (9))){
var inst_79939 = (state_80060[(23)]);
var inst_79939__$1 = superv.async._abort.call(null,S);
var inst_79940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79941 = [inst_79939__$1,in_ch];
var inst_79942 = (new cljs.core.PersistentVector(null,2,(5),inst_79940,inst_79941,null));
var state_80060__$1 = (function (){var statearr_80104 = state_80060;
(statearr_80104[(23)] = inst_79939__$1);

return statearr_80104;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_80060__$1,(11),inst_79942,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_80061 === (5))){
var state_80060__$1 = state_80060;
var statearr_80105_80164 = state_80060__$1;
(statearr_80105_80164[(2)] = null);

(statearr_80105_80164[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (14))){
var inst_79956 = (state_80060[(12)]);
var inst_79955 = (state_80060[(2)]);
var inst_79956__$1 = superv.async.throw_if_exception.call(null,S,inst_79955);
var state_80060__$1 = (function (){var statearr_80106 = state_80060;
(statearr_80106[(12)] = inst_79956__$1);

return statearr_80106;
})();
if(cljs.core.truth_(inst_79956__$1)){
var statearr_80107_80165 = state_80060__$1;
(statearr_80107_80165[(1)] = (15));

} else {
var statearr_80108_80166 = state_80060__$1;
(statearr_80108_80166[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (26))){
var inst_79993 = (state_80060[(18)]);
var inst_79993__$1 = superv.async._abort.call(null,S);
var inst_79994 = cljs.core.async.timeout.call(null,(0));
var inst_79995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79996 = [inst_79993__$1,inst_79994];
var inst_79997 = (new cljs.core.PersistentVector(null,2,(5),inst_79995,inst_79996,null));
var state_80060__$1 = (function (){var statearr_80109 = state_80060;
(statearr_80109[(18)] = inst_79993__$1);

return statearr_80109;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_80060__$1,(29),inst_79997,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_80061 === (16))){
var inst_79934 = (state_80060[(10)]);
var inst_80023 = cljs.core.not_empty.call(null,inst_79934);
var state_80060__$1 = state_80060;
if(cljs.core.truth_(inst_80023)){
var statearr_80110_80167 = state_80060__$1;
(statearr_80110_80167[(1)] = (34));

} else {
var statearr_80111_80168 = state_80060__$1;
(statearr_80111_80168[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (38))){
var inst_80039 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_80040 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_80041 = cljs.core.PersistentHashMap.fromArrays(inst_80039,inst_80040);
var inst_80042 = cljs.core.ex_info.call(null,"Aborted operations",inst_80041);
var state_80060__$1 = state_80060;
var statearr_80112_80169 = state_80060__$1;
(statearr_80112_80169[(2)] = inst_80042);

(statearr_80112_80169[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (30))){
var inst_80004 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_80005 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_80006 = cljs.core.PersistentHashMap.fromArrays(inst_80004,inst_80005);
var inst_80007 = cljs.core.ex_info.call(null,"Aborted operations",inst_80006);
var state_80060__$1 = state_80060;
var statearr_80113_80170 = state_80060__$1;
(statearr_80113_80170[(2)] = inst_80007);

(statearr_80113_80170[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (10))){
var inst_80056 = (state_80060[(2)]);
var state_80060__$1 = state_80060;
var statearr_80114_80171 = state_80060__$1;
(statearr_80114_80171[(2)] = inst_80056);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80060__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (18))){
var inst_79963 = (state_80060[(13)]);
var inst_79963__$1 = superv.async._abort.call(null,S);
var inst_79964 = cljs.core.async.timeout.call(null,(0));
var inst_79965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79966 = [inst_79963__$1,inst_79964];
var inst_79967 = (new cljs.core.PersistentVector(null,2,(5),inst_79965,inst_79966,null));
var state_80060__$1 = (function (){var statearr_80115 = state_80060;
(statearr_80115[(13)] = inst_79963__$1);

return statearr_80115;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_80060__$1,(21),inst_79967,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_80061 === (37))){
var inst_80028 = (state_80060[(20)]);
var inst_80034 = (state_80060[(2)]);
var inst_80035 = cljs.core.nth.call(null,inst_80034,(0),null);
var inst_80036 = cljs.core.nth.call(null,inst_80034,(1),null);
var inst_80037 = cljs.core._EQ_.call(null,inst_80036,inst_80028);
var state_80060__$1 = (function (){var statearr_80116 = state_80060;
(statearr_80116[(24)] = inst_80035);

return statearr_80116;
})();
if(inst_80037){
var statearr_80117_80172 = state_80060__$1;
(statearr_80117_80172[(1)] = (38));

} else {
var statearr_80118_80173 = state_80060__$1;
(statearr_80118_80173[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_80060,(4),Error,(3),(2));
var inst_79933 = cljs.core.PersistentVector.EMPTY;
var inst_79934 = inst_79933;
var state_80060__$1 = (function (){var statearr_80119 = state_80060;
(statearr_80119[(10)] = inst_79934);

return statearr_80119;
})();
var statearr_80120_80174 = state_80060__$1;
(statearr_80120_80174[(2)] = null);

(statearr_80120_80174[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___80133,c__23767__auto___80131,id__23768__auto___80132,out_ch__$1,map__79916,map__79916__$1,out_ch))
;
return ((function (switch__38343__auto__,c__38457__auto___80133,c__23767__auto___80131,id__23768__auto___80132,out_ch__$1,map__79916,map__79916__$1,out_ch){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_80124 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80124[(0)] = superv$async$state_machine__38344__auto__);

(statearr_80124[(1)] = (1));

return statearr_80124;
});
var superv$async$state_machine__38344__auto____1 = (function (state_80060){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_80060);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e80125){if((e80125 instanceof Object)){
var ex__38347__auto__ = e80125;
var statearr_80126_80175 = state_80060;
(statearr_80126_80175[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80060);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80125;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80176 = state_80060;
state_80060 = G__80176;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_80060){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_80060);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___80133,c__23767__auto___80131,id__23768__auto___80132,out_ch__$1,map__79916,map__79916__$1,out_ch))
})();
var state__38459__auto__ = (function (){var statearr_80127 = f__38458__auto__.call(null);
(statearr_80127[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___80133);

return statearr_80127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___80133,c__23767__auto___80131,id__23768__auto___80132,out_ch__$1,map__79916,map__79916__$1,out_ch))
);


return out_ch__$1;
});

superv.async.partition_all_GT__GT_.cljs$lang$maxFixedArity = (3);

superv.async.partition_all_GT__GT_.cljs$lang$applyTo = (function (seq79911){
var G__79912 = cljs.core.first.call(null,seq79911);
var seq79911__$1 = cljs.core.next.call(null,seq79911);
var G__79913 = cljs.core.first.call(null,seq79911__$1);
var seq79911__$2 = cljs.core.next.call(null,seq79911__$1);
var G__79914 = cljs.core.first.call(null,seq79911__$2);
var seq79911__$3 = cljs.core.next.call(null,seq79911__$2);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__79912,G__79913,G__79914,seq79911__$3);
});

/**
 * Counts items in a channel. Returns a channel with the item count.
 */
superv.async.count_GT_ = (function superv$async$count_GT_(S,ch){
return cljs.core.async.reduce.call(null,(function (acc,obj){
if((obj instanceof Error)){
return superv.async.put_QMARK_.call(null,S,superv.async._error.call(null,S),obj);
} else {
return (acc + (1));
}
}),(0),ch);
});
/**
 * Debounces channel. Forwards first item from input channel to output
 *   immediately. After that one item every interval ms (if any). If there are more
 *   items in between, they are dropped.
 */
superv.async.debounce_GT__GT_ = (function superv$async$debounce_GT__GT_(S,ch,interval){
var out = cljs.core.async.chan.call(null);
var c__23767__auto___80495 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___80496 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),null], null),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol("async","timeout","async/timeout",1951904349,null),new cljs.core.Symbol(null,"interval","interval",-945940352,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null)),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-val","new-val",902372928,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null),cljs.core.list(new cljs.core.Symbol(null,"alts?","alts?",1625745590,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null)], null))], null),cljs.core.list(new cljs.core.Symbol(null,"condp","condp",1054325175,null),new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)))))))));
var c__38457__auto___80497 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___80497,c__23767__auto___80495,id__23768__auto___80496,out){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___80497,c__23767__auto___80495,id__23768__auto___80496,out){
return (function (state_80441){
var state_val_80442 = (state_80441[(1)]);
if((state_val_80442 === (7))){
var inst_80339 = (state_80441[(7)]);
var inst_80347 = (state_80441[(2)]);
var state_80441__$1 = (function (){var statearr_80443 = state_80441;
(statearr_80443[(8)] = inst_80347);

return statearr_80443;
})();
var statearr_80444_80498 = state_80441__$1;
(statearr_80444_80498[(2)] = inst_80339);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80441__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (20))){
var inst_80435 = (state_80441[(2)]);
var state_80441__$1 = state_80441;
var statearr_80445_80499 = state_80441__$1;
(statearr_80445_80499[(2)] = inst_80435);

(statearr_80445_80499[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (27))){
var inst_80419 = (state_80441[(2)]);
var inst_80420 = superv.async.throw_if_exception.call(null,S,inst_80419);
var inst_80351 = null;
var state_80441__$1 = (function (){var statearr_80446 = state_80441;
(statearr_80446[(9)] = inst_80351);

(statearr_80446[(10)] = inst_80420);

return statearr_80446;
})();
var statearr_80447_80500 = state_80441__$1;
(statearr_80447_80500[(2)] = null);

(statearr_80447_80500[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (1))){
var state_80441__$1 = state_80441;
var statearr_80448_80501 = state_80441__$1;
(statearr_80448_80501[(2)] = null);

(statearr_80448_80501[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (24))){
var inst_80400 = (state_80441[(11)]);
var inst_80406 = (state_80441[(2)]);
var inst_80407 = cljs.core.nth.call(null,inst_80406,(0),null);
var inst_80408 = cljs.core.nth.call(null,inst_80406,(1),null);
var inst_80409 = cljs.core._EQ_.call(null,inst_80408,inst_80400);
var state_80441__$1 = (function (){var statearr_80449 = state_80441;
(statearr_80449[(12)] = inst_80407);

return statearr_80449;
})();
if(inst_80409){
var statearr_80450_80502 = state_80441__$1;
(statearr_80450_80502[(1)] = (25));

} else {
var statearr_80451_80503 = state_80441__$1;
(statearr_80451_80503[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (4))){
var inst_80339 = (state_80441[(7)]);
var inst_80339__$1 = (state_80441[(2)]);
var inst_80340 = cljs.core.ex_data.call(null,inst_80339__$1);
var inst_80341 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_80340);
var inst_80342 = cljs.core._EQ_.call(null,inst_80341,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_80441__$1 = (function (){var statearr_80452 = state_80441;
(statearr_80452[(7)] = inst_80339__$1);

return statearr_80452;
})();
if(inst_80342){
var statearr_80453_80504 = state_80441__$1;
(statearr_80453_80504[(1)] = (5));

} else {
var statearr_80454_80505 = state_80441__$1;
(statearr_80454_80505[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (15))){
var inst_80368 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_80369 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_80370 = cljs.core.PersistentHashMap.fromArrays(inst_80368,inst_80369);
var inst_80371 = cljs.core.ex_info.call(null,"Aborted operations",inst_80370);
var state_80441__$1 = state_80441;
var statearr_80455_80506 = state_80441__$1;
(statearr_80455_80506[(2)] = inst_80371);

(statearr_80455_80506[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (21))){
var inst_80400 = (state_80441[(11)]);
var inst_80400__$1 = superv.async._abort.call(null,S);
var inst_80401 = cljs.core.async.timeout.call(null,(0));
var inst_80402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80403 = [inst_80400__$1,inst_80401];
var inst_80404 = (new cljs.core.PersistentVector(null,2,(5),inst_80402,inst_80403,null));
var state_80441__$1 = (function (){var statearr_80456 = state_80441;
(statearr_80456[(11)] = inst_80400__$1);

return statearr_80456;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_80441__$1,(24),inst_80404,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_80442 === (31))){
var inst_80431 = (state_80441[(2)]);
var state_80441__$1 = state_80441;
var statearr_80457_80507 = state_80441__$1;
(statearr_80457_80507[(2)] = inst_80431);

(statearr_80457_80507[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (13))){
var inst_80377 = (state_80441[(13)]);
var inst_80377__$1 = (state_80441[(2)]);
var inst_80378 = cljs.core.async.timeout.call(null,interval);
var inst_80379 = (inst_80377__$1 == null);
var state_80441__$1 = (function (){var statearr_80458 = state_80441;
(statearr_80458[(14)] = inst_80378);

(statearr_80458[(13)] = inst_80377__$1);

return statearr_80458;
})();
if(cljs.core.truth_(inst_80379)){
var statearr_80459_80508 = state_80441__$1;
(statearr_80459_80508[(1)] = (18));

} else {
var statearr_80460_80509 = state_80441__$1;
(statearr_80460_80509[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (22))){
var inst_80391 = (state_80441[(15)]);
var inst_80423 = cljs.core._EQ_.call(null,inst_80391,inst_80391);
var state_80441__$1 = state_80441;
if(inst_80423){
var statearr_80461_80510 = state_80441__$1;
(statearr_80461_80510[(1)] = (29));

} else {
var statearr_80462_80511 = state_80441__$1;
(statearr_80462_80511[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (29))){
var inst_80390 = (state_80441[(16)]);
var inst_80351 = inst_80390;
var state_80441__$1 = (function (){var statearr_80463 = state_80441;
(statearr_80463[(9)] = inst_80351);

return statearr_80463;
})();
var statearr_80464_80512 = state_80441__$1;
(statearr_80464_80512[(2)] = null);

(statearr_80464_80512[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (6))){
var inst_80339 = (state_80441[(7)]);
var inst_80345 = superv.async._track_exception.call(null,S,inst_80339);
var state_80441__$1 = state_80441;
var statearr_80465_80513 = state_80441__$1;
(statearr_80465_80513[(2)] = inst_80345);

(statearr_80465_80513[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (28))){
var inst_80417 = (state_80441[(2)]);
var state_80441__$1 = state_80441;
var statearr_80466_80514 = state_80441__$1;
(statearr_80466_80514[(2)] = inst_80417);

(statearr_80466_80514[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (25))){
var inst_80411 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_80412 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_80413 = cljs.core.PersistentHashMap.fromArrays(inst_80411,inst_80412);
var inst_80414 = cljs.core.ex_info.call(null,"Aborted operations",inst_80413);
var state_80441__$1 = state_80441;
var statearr_80467_80515 = state_80441__$1;
(statearr_80467_80515[(2)] = inst_80414);

(statearr_80467_80515[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (17))){
var inst_80374 = (state_80441[(2)]);
var inst_80375 = superv.async.throw_if_exception.call(null,S,inst_80374);
var state_80441__$1 = state_80441;
var statearr_80468_80516 = state_80441__$1;
(statearr_80468_80516[(2)] = inst_80375);

(statearr_80468_80516[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (3))){
var inst_80336 = (state_80441[(2)]);
var inst_80337 = superv.async._unregister_go.call(null,S,id__23768__auto___80496);
var state_80441__$1 = (function (){var statearr_80469 = state_80441;
(statearr_80469[(17)] = inst_80336);

(statearr_80469[(18)] = inst_80337);

return statearr_80469;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80441__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (12))){
var inst_80358 = (state_80441[(19)]);
var inst_80358__$1 = superv.async._abort.call(null,S);
var inst_80359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80360 = [inst_80358__$1,ch];
var inst_80361 = (new cljs.core.PersistentVector(null,2,(5),inst_80359,inst_80360,null));
var state_80441__$1 = (function (){var statearr_80470 = state_80441;
(statearr_80470[(19)] = inst_80358__$1);

return statearr_80470;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_80441__$1,(14),inst_80361,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_80442 === (2))){
var inst_80439 = (state_80441[(2)]);
var state_80441__$1 = state_80441;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80441__$1,inst_80439);
} else {
if((state_val_80442 === (23))){
var inst_80433 = (state_80441[(2)]);
var state_80441__$1 = state_80441;
var statearr_80471_80517 = state_80441__$1;
(statearr_80471_80517[(2)] = inst_80433);

(statearr_80471_80517[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (19))){
var inst_80378 = (state_80441[(14)]);
var inst_80391 = (state_80441[(15)]);
var inst_80386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80387 = [ch,inst_80378];
var inst_80388 = (new cljs.core.PersistentVector(null,2,(5),inst_80386,inst_80387,null));
var inst_80389 = superv.async.alts_QMARK_.call(null,S,inst_80388);
var inst_80390 = cljs.core.nth.call(null,inst_80389,(0),null);
var inst_80391__$1 = cljs.core.nth.call(null,inst_80389,(1),null);
var inst_80395 = cljs.core._EQ_.call(null,inst_80378,inst_80391__$1);
var state_80441__$1 = (function (){var statearr_80472 = state_80441;
(statearr_80472[(16)] = inst_80390);

(statearr_80472[(15)] = inst_80391__$1);

return statearr_80472;
})();
if(inst_80395){
var statearr_80473_80518 = state_80441__$1;
(statearr_80473_80518[(1)] = (21));

} else {
var statearr_80474_80519 = state_80441__$1;
(statearr_80474_80519[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (11))){
var inst_80351 = (state_80441[(9)]);
var state_80441__$1 = state_80441;
var statearr_80475_80520 = state_80441__$1;
(statearr_80475_80520[(2)] = inst_80351);

(statearr_80475_80520[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (9))){
var inst_80351 = (state_80441[(9)]);
var state_80441__$1 = state_80441;
if(cljs.core.truth_(inst_80351)){
var statearr_80476_80521 = state_80441__$1;
(statearr_80476_80521[(1)] = (11));

} else {
var statearr_80477_80522 = state_80441__$1;
(statearr_80477_80522[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (5))){
var state_80441__$1 = state_80441;
var statearr_80478_80523 = state_80441__$1;
(statearr_80478_80523[(2)] = null);

(statearr_80478_80523[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (14))){
var inst_80358 = (state_80441[(19)]);
var inst_80363 = (state_80441[(2)]);
var inst_80364 = cljs.core.nth.call(null,inst_80363,(0),null);
var inst_80365 = cljs.core.nth.call(null,inst_80363,(1),null);
var inst_80366 = cljs.core._EQ_.call(null,inst_80365,inst_80358);
var state_80441__$1 = (function (){var statearr_80479 = state_80441;
(statearr_80479[(20)] = inst_80364);

return statearr_80479;
})();
if(inst_80366){
var statearr_80480_80524 = state_80441__$1;
(statearr_80480_80524[(1)] = (15));

} else {
var statearr_80481_80525 = state_80441__$1;
(statearr_80481_80525[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (26))){
var inst_80377 = (state_80441[(13)]);
var state_80441__$1 = state_80441;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_80441__$1,(28),out,inst_80377);
} else {
if((state_val_80442 === (16))){
var inst_80364 = (state_80441[(20)]);
var state_80441__$1 = state_80441;
var statearr_80482_80526 = state_80441__$1;
(statearr_80482_80526[(2)] = inst_80364);

(statearr_80482_80526[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (30))){
var inst_80391 = (state_80441[(15)]);
var inst_80427 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_80391)].join('');
var inst_80428 = (new Error(inst_80427));
var inst_80429 = (function(){throw inst_80428})();
var state_80441__$1 = state_80441;
var statearr_80483_80527 = state_80441__$1;
(statearr_80483_80527[(2)] = inst_80429);

(statearr_80483_80527[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (10))){
var inst_80437 = (state_80441[(2)]);
var state_80441__$1 = state_80441;
var statearr_80484_80528 = state_80441__$1;
(statearr_80484_80528[(2)] = inst_80437);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80441__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (18))){
var inst_80381 = cljs.core.async.close_BANG_.call(null,out);
var state_80441__$1 = state_80441;
var statearr_80485_80529 = state_80441__$1;
(statearr_80485_80529[(2)] = inst_80381);

(statearr_80485_80529[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80442 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_80441,(4),Error,(3),(2));
var inst_80351 = null;
var state_80441__$1 = (function (){var statearr_80486 = state_80441;
(statearr_80486[(9)] = inst_80351);

return statearr_80486;
})();
var statearr_80487_80530 = state_80441__$1;
(statearr_80487_80530[(2)] = null);

(statearr_80487_80530[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___80497,c__23767__auto___80495,id__23768__auto___80496,out))
;
return ((function (switch__38343__auto__,c__38457__auto___80497,c__23767__auto___80495,id__23768__auto___80496,out){
return (function() {
var superv$async$debounce_GT__GT__$_state_machine__38344__auto__ = null;
var superv$async$debounce_GT__GT__$_state_machine__38344__auto____0 = (function (){
var statearr_80491 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80491[(0)] = superv$async$debounce_GT__GT__$_state_machine__38344__auto__);

(statearr_80491[(1)] = (1));

return statearr_80491;
});
var superv$async$debounce_GT__GT__$_state_machine__38344__auto____1 = (function (state_80441){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_80441);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e80492){if((e80492 instanceof Object)){
var ex__38347__auto__ = e80492;
var statearr_80493_80531 = state_80441;
(statearr_80493_80531[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80441);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80492;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80532 = state_80441;
state_80441 = G__80532;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$debounce_GT__GT__$_state_machine__38344__auto__ = function(state_80441){
switch(arguments.length){
case 0:
return superv$async$debounce_GT__GT__$_state_machine__38344__auto____0.call(this);
case 1:
return superv$async$debounce_GT__GT__$_state_machine__38344__auto____1.call(this,state_80441);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$debounce_GT__GT__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$debounce_GT__GT__$_state_machine__38344__auto____0;
superv$async$debounce_GT__GT__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$debounce_GT__GT__$_state_machine__38344__auto____1;
return superv$async$debounce_GT__GT__$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___80497,c__23767__auto___80495,id__23768__auto___80496,out))
})();
var state__38459__auto__ = (function (){var statearr_80494 = f__38458__auto__.call(null);
(statearr_80494[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___80497);

return statearr_80494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___80497,c__23767__auto___80495,id__23768__auto___80496,out))
);


return out;
});
/**
 * Safely managed tap. The channel is closed on abortion and all
 *   pending puts are flushed.
 */
superv.async.tap = (function superv$async$tap(var_args){
var args80533 = [];
var len__10640__auto___80671 = arguments.length;
var i__10641__auto___80672 = (0);
while(true){
if((i__10641__auto___80672 < len__10640__auto___80671)){
args80533.push((arguments[i__10641__auto___80672]));

var G__80673 = (i__10641__auto___80672 + (1));
i__10641__auto___80672 = G__80673;
continue;
} else {
}
break;
}

var G__80535 = args80533.length;
switch (G__80535) {
case 3:
return superv.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.tap.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args80533.length)].join('')));

}
});

superv.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (S,mult,ch){
return superv.async.tap.call(null,S,mult,ch,false);
});

superv.async.tap.cljs$core$IFn$_invoke$arity$4 = (function (S,mult,ch,close_QMARK_){
var c__23767__auto___80675 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___80676 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__38457__auto___80677 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___80677,c__23767__auto___80675,id__23768__auto___80676){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___80677,c__23767__auto___80675,id__23768__auto___80676){
return (function (state_80614){
var state_val_80615 = (state_80614[(1)]);
if((state_val_80615 === (7))){
var inst_80539 = (state_80614[(7)]);
var inst_80547 = (state_80614[(2)]);
var state_80614__$1 = (function (){var statearr_80616 = state_80614;
(statearr_80616[(8)] = inst_80547);

return statearr_80616;
})();
var statearr_80617_80678 = state_80614__$1;
(statearr_80617_80678[(2)] = inst_80539);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80614__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80615 === (1))){
var state_80614__$1 = state_80614;
var statearr_80618_80679 = state_80614__$1;
(statearr_80618_80679[(2)] = null);

(statearr_80618_80679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80615 === (4))){
var inst_80539 = (state_80614[(7)]);
var inst_80539__$1 = (state_80614[(2)]);
var inst_80540 = cljs.core.ex_data.call(null,inst_80539__$1);
var inst_80541 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_80540);
var inst_80542 = cljs.core._EQ_.call(null,inst_80541,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_80614__$1 = (function (){var statearr_80619 = state_80614;
(statearr_80619[(7)] = inst_80539__$1);

return statearr_80619;
})();
if(inst_80542){
var statearr_80620_80680 = state_80614__$1;
(statearr_80620_80680[(1)] = (5));

} else {
var statearr_80621_80681 = state_80614__$1;
(statearr_80621_80681[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80615 === (15))){
var inst_80563 = (state_80614[(2)]);
var state_80614__$1 = state_80614;
var statearr_80622_80682 = state_80614__$1;
(statearr_80622_80682[(2)] = inst_80563);

(statearr_80622_80682[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80615 === (13))){
var state_80614__$1 = state_80614;
var statearr_80623_80683 = state_80614__$1;
(statearr_80623_80683[(2)] = null);

(statearr_80623_80683[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80615 === (6))){
var inst_80539 = (state_80614[(7)]);
var inst_80545 = superv.async._track_exception.call(null,S,inst_80539);
var state_80614__$1 = state_80614;
var statearr_80624_80684 = state_80614__$1;
(statearr_80624_80684[(2)] = inst_80545);

(statearr_80624_80684[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80615 === (3))){
var inst_80536 = (state_80614[(2)]);
var inst_80537 = superv.async._unregister_go.call(null,S,id__23768__auto___80676);
var state_80614__$1 = (function (){var statearr_80625 = state_80614;
(statearr_80625[(9)] = inst_80536);

(statearr_80625[(10)] = inst_80537);

return statearr_80625;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80614__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80615 === (12))){
var inst_80558 = (state_80614[(2)]);
var state_80614__$1 = state_80614;
if(cljs.core.truth_(inst_80558)){
var statearr_80626_80685 = state_80614__$1;
(statearr_80626_80685[(1)] = (13));

} else {
var statearr_80627_80686 = state_80614__$1;
(statearr_80627_80686[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80615 === (2))){
var inst_80612 = (state_80614[(2)]);
var state_80614__$1 = state_80614;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80614__$1,inst_80612);
} else {
if((state_val_80615 === (11))){
var inst_80555 = (state_80614[(11)]);
var inst_80565 = (state_80614[(2)]);
var inst_80566 = null;
var inst_80567 = superv.async._register_go.call(null,inst_80565,inst_80566);
var inst_80608 = cljs.core.async.chan.call(null,(1));
var inst_80609 = (function (){var c__23767__auto____$1 = inst_80555;
var id__23768__auto____$1 = inst_80567;
var c__38457__auto____$1 = inst_80608;
return ((function (c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_80555,inst_80565,inst_80566,inst_80567,inst_80608,state_val_80615,c__38457__auto___80677,c__23767__auto___80675,id__23768__auto___80676){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_80555,inst_80565,inst_80566,inst_80567,inst_80608,state_val_80615,c__38457__auto___80677,c__23767__auto___80675,id__23768__auto___80676){
return (function (state_80606){
var state_val_80607 = (state_80606[(1)]);
if((state_val_80607 === (7))){
var state_80606__$1 = state_80606;
var statearr_80628_80687 = state_80606__$1;
(statearr_80628_80687[(2)] = null);

(statearr_80628_80687[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80607 === (20))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_80606,(10),Error,(3),(2));
var state_80606__$1 = state_80606;
var statearr_80629_80688 = state_80606__$1;
(statearr_80629_80688[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80606__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80607 === (1))){
var state_80606__$1 = state_80606;
var statearr_80630_80689 = state_80606__$1;
(statearr_80630_80689[(2)] = null);

(statearr_80630_80689[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80607 === (4))){
var state_80606__$1 = state_80606;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80606__$1,(6),ch);
} else {
if((state_val_80607 === (15))){
var inst_80581 = (state_80606[(7)]);
var inst_80596 = (state_80606[(2)]);
var inst_80597 = superv.async._track_exception.call(null,inst_80596,inst_80581);
var state_80606__$1 = state_80606;
var statearr_80631_80690 = state_80606__$1;
(statearr_80631_80690[(2)] = inst_80597);

(statearr_80631_80690[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80607 === (13))){
var inst_80581 = (state_80606[(7)]);
var inst_80599 = (state_80606[(2)]);
var state_80606__$1 = (function (){var statearr_80632 = state_80606;
(statearr_80632[(8)] = inst_80599);

return statearr_80632;
})();
var statearr_80633_80691 = state_80606__$1;
(statearr_80633_80691[(2)] = inst_80581);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80606__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80607 === (6))){
var inst_80571 = (state_80606[(2)]);
var state_80606__$1 = state_80606;
if(cljs.core.truth_(inst_80571)){
var statearr_80634_80692 = state_80606__$1;
(statearr_80634_80692[(1)] = (7));

} else {
var statearr_80635_80693 = state_80606__$1;
(statearr_80635_80693[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80607 === (17))){
var state_80606__$1 = state_80606;
var statearr_80636_80694 = state_80606__$1;
(statearr_80636_80694[(2)] = null);

(statearr_80636_80694[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80607 === (3))){
var inst_80568 = (state_80606[(2)]);
var state_80606__$1 = (function (){var statearr_80637 = state_80606;
(statearr_80637[(9)] = inst_80568);

return statearr_80637;
})();
var statearr_80638_80695 = state_80606__$1;
(statearr_80638_80695[(2)] = null);

(statearr_80638_80695[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80607 === (12))){
var state_80606__$1 = state_80606;
var statearr_80639_80696 = state_80606__$1;
(statearr_80639_80696[(2)] = null);

(statearr_80639_80696[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80607 === (2))){
var inst_80604 = (state_80606[(2)]);
var state_80606__$1 = state_80606;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80606__$1,inst_80604);
} else {
if((state_val_80607 === (19))){
var inst_80594 = (state_80606[(2)]);
var state_80606__$1 = state_80606;
var statearr_80640_80697 = state_80606__$1;
(statearr_80640_80697[(2)] = inst_80594);

(statearr_80640_80697[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80607 === (11))){
var state_80606__$1 = state_80606;
var statearr_80641_80698 = state_80606__$1;
(statearr_80641_80698[(2)] = null);

(statearr_80641_80698[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80607 === (9))){
var inst_80576 = (state_80606[(2)]);
var state_80606__$1 = state_80606;
var statearr_80642_80699 = state_80606__$1;
(statearr_80642_80699[(2)] = inst_80576);

(statearr_80642_80699[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80607 === (5))){
var inst_80578 = (state_80606[(2)]);
var inst_80579 = superv.async._unregister_go.call(null,inst_80578,id__23768__auto____$1);
var state_80606__$1 = (function (){var statearr_80643 = state_80606;
(statearr_80643[(10)] = inst_80579);

return statearr_80643;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80606__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80607 === (14))){
var state_80606__$1 = state_80606;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80606__$1,(16),ch);
} else {
if((state_val_80607 === (16))){
var inst_80589 = (state_80606[(2)]);
var state_80606__$1 = state_80606;
if(cljs.core.truth_(inst_80589)){
var statearr_80644_80700 = state_80606__$1;
(statearr_80644_80700[(1)] = (17));

} else {
var statearr_80645_80701 = state_80606__$1;
(statearr_80645_80701[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80607 === (10))){
var inst_80581 = (state_80606[(7)]);
var inst_80581__$1 = (state_80606[(2)]);
var inst_80582 = cljs.core.ex_data.call(null,inst_80581__$1);
var inst_80583 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_80582);
var inst_80584 = cljs.core._EQ_.call(null,inst_80583,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_80606__$1 = (function (){var statearr_80646 = state_80606;
(statearr_80646[(7)] = inst_80581__$1);

return statearr_80646;
})();
if(inst_80584){
var statearr_80647_80702 = state_80606__$1;
(statearr_80647_80702[(1)] = (11));

} else {
var statearr_80648_80703 = state_80606__$1;
(statearr_80648_80703[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80607 === (18))){
var state_80606__$1 = state_80606;
var statearr_80649_80704 = state_80606__$1;
(statearr_80649_80704[(2)] = null);

(statearr_80649_80704[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80607 === (8))){
var state_80606__$1 = state_80606;
var statearr_80650_80705 = state_80606__$1;
(statearr_80650_80705[(2)] = null);

(statearr_80650_80705[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_80555,inst_80565,inst_80566,inst_80567,inst_80608,state_val_80615,c__38457__auto___80677,c__23767__auto___80675,id__23768__auto___80676))
;
return ((function (switch__38343__auto__,c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_80555,inst_80565,inst_80566,inst_80567,inst_80608,state_val_80615,c__38457__auto___80677,c__23767__auto___80675,id__23768__auto___80676){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_80654 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_80654[(0)] = superv$async$state_machine__38344__auto__);

(statearr_80654[(1)] = (1));

return statearr_80654;
});
var superv$async$state_machine__38344__auto____1 = (function (state_80606){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_80606);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e80655){if((e80655 instanceof Object)){
var ex__38347__auto__ = e80655;
var statearr_80656_80706 = state_80606;
(statearr_80656_80706[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80606);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80655;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80707 = state_80606;
state_80606 = G__80707;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_80606){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_80606);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_80555,inst_80565,inst_80566,inst_80567,inst_80608,state_val_80615,c__38457__auto___80677,c__23767__auto___80675,id__23768__auto___80676))
})();
var state__38459__auto__ = (function (){var statearr_80657 = f__38458__auto__.call(null);
(statearr_80657[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto____$1);

return statearr_80657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});
;})(c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_80555,inst_80565,inst_80566,inst_80567,inst_80608,state_val_80615,c__38457__auto___80677,c__23767__auto___80675,id__23768__auto___80676))
})();
var inst_80610 = cljs.core.async.impl.dispatch.run.call(null,inst_80609);
var state_80614__$1 = (function (){var statearr_80658 = state_80614;
(statearr_80658[(12)] = inst_80610);

return statearr_80658;
})();
var statearr_80659_80708 = state_80614__$1;
(statearr_80659_80708[(2)] = inst_80608);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80614__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80615 === (9))){
var inst_80553 = (state_80614[(2)]);
var inst_80554 = cljs.core.async.close_BANG_.call(null,ch);
var inst_80555 = superv.async.check_supervisor.call(null,superv.async.S);
var state_80614__$1 = (function (){var statearr_80660 = state_80614;
(statearr_80660[(13)] = inst_80553);

(statearr_80660[(11)] = inst_80555);

(statearr_80660[(14)] = inst_80554);

return statearr_80660;
})();
var statearr_80661_80709 = state_80614__$1;
(statearr_80661_80709[(2)] = null);

(statearr_80661_80709[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80615 === (5))){
var state_80614__$1 = state_80614;
var statearr_80662_80710 = state_80614__$1;
(statearr_80662_80710[(2)] = null);

(statearr_80662_80710[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80615 === (14))){
var state_80614__$1 = state_80614;
var statearr_80663_80711 = state_80614__$1;
(statearr_80663_80711[(2)] = null);

(statearr_80663_80711[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80615 === (10))){
var state_80614__$1 = state_80614;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80614__$1,(12),ch);
} else {
if((state_val_80615 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_80614,(4),Error,(3),(2));
var inst_80551 = superv.async._abort.call(null,S);
var state_80614__$1 = state_80614;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80614__$1,(9),inst_80551);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___80677,c__23767__auto___80675,id__23768__auto___80676))
;
return ((function (switch__38343__auto__,c__38457__auto___80677,c__23767__auto___80675,id__23768__auto___80676){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_80667 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80667[(0)] = superv$async$state_machine__38344__auto__);

(statearr_80667[(1)] = (1));

return statearr_80667;
});
var superv$async$state_machine__38344__auto____1 = (function (state_80614){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_80614);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e80668){if((e80668 instanceof Object)){
var ex__38347__auto__ = e80668;
var statearr_80669_80712 = state_80614;
(statearr_80669_80712[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80614);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80668;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80713 = state_80614;
state_80614 = G__80713;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_80614){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_80614);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___80677,c__23767__auto___80675,id__23768__auto___80676))
})();
var state__38459__auto__ = (function (){var statearr_80670 = f__38458__auto__.call(null);
(statearr_80670[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___80677);

return statearr_80670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___80677,c__23767__auto___80675,id__23768__auto___80676))
);


return cljs.core.async.tap.call(null,mult,ch,close_QMARK_);
});

superv.async.tap.cljs$lang$maxFixedArity = 4;

/**
 * Safely managed subscription. The channel is closed on abortion and
 *   all pending puts are flushed.
 */
superv.async.sub = (function superv$async$sub(var_args){
var args80714 = [];
var len__10640__auto___80818 = arguments.length;
var i__10641__auto___80819 = (0);
while(true){
if((i__10641__auto___80819 < len__10640__auto___80818)){
args80714.push((arguments[i__10641__auto___80819]));

var G__80820 = (i__10641__auto___80819 + (1));
i__10641__auto___80819 = G__80820;
continue;
} else {
}
break;
}

var G__80716 = args80714.length;
switch (G__80716) {
case 4:
return superv.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.sub.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args80714.length)].join('')));

}
});

superv.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (S,p,topic,ch){
return superv.async.sub.call(null,S,p,topic,ch,false);
});

superv.async.sub.cljs$core$IFn$_invoke$arity$5 = (function (S,p,topic,ch,close_QMARK_){
var c__23767__auto___80822 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___80823 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__38457__auto___80824 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___80824,c__23767__auto___80822,id__23768__auto___80823){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___80824,c__23767__auto___80822,id__23768__auto___80823){
return (function (state_80775){
var state_val_80776 = (state_80775[(1)]);
if((state_val_80776 === (1))){
var state_80775__$1 = state_80775;
var statearr_80777_80825 = state_80775__$1;
(statearr_80777_80825[(2)] = null);

(statearr_80777_80825[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80776 === (2))){
var inst_80773 = (state_80775[(2)]);
var state_80775__$1 = state_80775;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80775__$1,inst_80773);
} else {
if((state_val_80776 === (3))){
var inst_80717 = (state_80775[(2)]);
var inst_80718 = superv.async._unregister_go.call(null,S,id__23768__auto___80823);
var state_80775__$1 = (function (){var statearr_80778 = state_80775;
(statearr_80778[(7)] = inst_80718);

(statearr_80778[(8)] = inst_80717);

return statearr_80778;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80775__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80776 === (4))){
var inst_80720 = (state_80775[(9)]);
var inst_80720__$1 = (state_80775[(2)]);
var inst_80721 = cljs.core.ex_data.call(null,inst_80720__$1);
var inst_80722 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_80721);
var inst_80723 = cljs.core._EQ_.call(null,inst_80722,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_80775__$1 = (function (){var statearr_80779 = state_80775;
(statearr_80779[(9)] = inst_80720__$1);

return statearr_80779;
})();
if(inst_80723){
var statearr_80780_80826 = state_80775__$1;
(statearr_80780_80826[(1)] = (5));

} else {
var statearr_80781_80827 = state_80775__$1;
(statearr_80781_80827[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80776 === (5))){
var state_80775__$1 = state_80775;
var statearr_80782_80828 = state_80775__$1;
(statearr_80782_80828[(2)] = null);

(statearr_80782_80828[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80776 === (6))){
var inst_80720 = (state_80775[(9)]);
var inst_80726 = superv.async._track_exception.call(null,S,inst_80720);
var state_80775__$1 = state_80775;
var statearr_80783_80829 = state_80775__$1;
(statearr_80783_80829[(2)] = inst_80726);

(statearr_80783_80829[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80776 === (7))){
var inst_80720 = (state_80775[(9)]);
var inst_80728 = (state_80775[(2)]);
var state_80775__$1 = (function (){var statearr_80784 = state_80775;
(statearr_80784[(10)] = inst_80728);

return statearr_80784;
})();
var statearr_80785_80830 = state_80775__$1;
(statearr_80785_80830[(2)] = inst_80720);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80775__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80776 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_80775,(4),Error,(3),(2));
var inst_80732 = superv.async._abort.call(null,S);
var state_80775__$1 = state_80775;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80775__$1,(9),inst_80732);
} else {
if((state_val_80776 === (9))){
var inst_80734 = (state_80775[(2)]);
var inst_80735 = cljs.core.async.close_BANG_.call(null,ch);
var inst_80736 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_80737 = cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))));
var inst_80738 = superv.async._register_go.call(null,S,inst_80737);
var inst_80769 = cljs.core.async.chan.call(null,(1));
var inst_80770 = (function (){var c__23767__auto____$1 = inst_80736;
var id__23768__auto____$1 = inst_80738;
var c__38457__auto____$1 = inst_80769;
return ((function (c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_80734,inst_80735,inst_80736,inst_80737,inst_80738,inst_80769,state_val_80776,c__38457__auto___80824,c__23767__auto___80822,id__23768__auto___80823){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_80734,inst_80735,inst_80736,inst_80737,inst_80738,inst_80769,state_val_80776,c__38457__auto___80824,c__23767__auto___80822,id__23768__auto___80823){
return (function (state_80767){
var state_val_80768 = (state_80767[(1)]);
if((state_val_80768 === (7))){
var inst_80742 = (state_80767[(7)]);
var inst_80750 = (state_80767[(2)]);
var state_80767__$1 = (function (){var statearr_80786 = state_80767;
(statearr_80786[(8)] = inst_80750);

return statearr_80786;
})();
var statearr_80787_80831 = state_80767__$1;
(statearr_80787_80831[(2)] = inst_80742);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80767__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80768 === (1))){
var state_80767__$1 = state_80767;
var statearr_80788_80832 = state_80767__$1;
(statearr_80788_80832[(2)] = null);

(statearr_80788_80832[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80768 === (4))){
var inst_80742 = (state_80767[(7)]);
var inst_80742__$1 = (state_80767[(2)]);
var inst_80743 = cljs.core.ex_data.call(null,inst_80742__$1);
var inst_80744 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_80743);
var inst_80745 = cljs.core._EQ_.call(null,inst_80744,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_80767__$1 = (function (){var statearr_80789 = state_80767;
(statearr_80789[(7)] = inst_80742__$1);

return statearr_80789;
})();
if(inst_80745){
var statearr_80790_80833 = state_80767__$1;
(statearr_80790_80833[(1)] = (5));

} else {
var statearr_80791_80834 = state_80767__$1;
(statearr_80791_80834[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80768 === (13))){
var state_80767__$1 = state_80767;
var statearr_80792_80835 = state_80767__$1;
(statearr_80792_80835[(2)] = null);

(statearr_80792_80835[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80768 === (6))){
var inst_80742 = (state_80767[(7)]);
var inst_80748 = superv.async._track_exception.call(null,S,inst_80742);
var state_80767__$1 = state_80767;
var statearr_80793_80836 = state_80767__$1;
(statearr_80793_80836[(2)] = inst_80748);

(statearr_80793_80836[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80768 === (3))){
var inst_80739 = (state_80767[(2)]);
var inst_80740 = superv.async._unregister_go.call(null,S,id__23768__auto____$1);
var state_80767__$1 = (function (){var statearr_80794 = state_80767;
(statearr_80794[(9)] = inst_80740);

(statearr_80794[(10)] = inst_80739);

return statearr_80794;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80767__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80768 === (12))){
var state_80767__$1 = state_80767;
var statearr_80795_80837 = state_80767__$1;
(statearr_80795_80837[(2)] = null);

(statearr_80795_80837[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80768 === (2))){
var inst_80765 = (state_80767[(2)]);
var state_80767__$1 = state_80767;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80767__$1,inst_80765);
} else {
if((state_val_80768 === (11))){
var inst_80756 = (state_80767[(2)]);
var state_80767__$1 = state_80767;
if(cljs.core.truth_(inst_80756)){
var statearr_80796_80838 = state_80767__$1;
(statearr_80796_80838[(1)] = (12));

} else {
var statearr_80797_80839 = state_80767__$1;
(statearr_80797_80839[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80768 === (9))){
var state_80767__$1 = state_80767;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80767__$1,(11),ch);
} else {
if((state_val_80768 === (5))){
var state_80767__$1 = state_80767;
var statearr_80798_80840 = state_80767__$1;
(statearr_80798_80840[(2)] = null);

(statearr_80798_80840[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80768 === (14))){
var inst_80761 = (state_80767[(2)]);
var state_80767__$1 = state_80767;
var statearr_80799_80841 = state_80767__$1;
(statearr_80799_80841[(2)] = inst_80761);

(statearr_80799_80841[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80768 === (10))){
var inst_80763 = (state_80767[(2)]);
var state_80767__$1 = state_80767;
var statearr_80800_80842 = state_80767__$1;
(statearr_80800_80842[(2)] = inst_80763);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80767__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80768 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_80767,(4),Error,(3),(2));
var state_80767__$1 = state_80767;
var statearr_80801_80843 = state_80767__$1;
(statearr_80801_80843[(2)] = null);

(statearr_80801_80843[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_80734,inst_80735,inst_80736,inst_80737,inst_80738,inst_80769,state_val_80776,c__38457__auto___80824,c__23767__auto___80822,id__23768__auto___80823))
;
return ((function (switch__38343__auto__,c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_80734,inst_80735,inst_80736,inst_80737,inst_80738,inst_80769,state_val_80776,c__38457__auto___80824,c__23767__auto___80822,id__23768__auto___80823){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_80805 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_80805[(0)] = superv$async$state_machine__38344__auto__);

(statearr_80805[(1)] = (1));

return statearr_80805;
});
var superv$async$state_machine__38344__auto____1 = (function (state_80767){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_80767);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e80806){if((e80806 instanceof Object)){
var ex__38347__auto__ = e80806;
var statearr_80807_80844 = state_80767;
(statearr_80807_80844[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80767);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80806;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80845 = state_80767;
state_80767 = G__80845;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_80767){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_80767);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_80734,inst_80735,inst_80736,inst_80737,inst_80738,inst_80769,state_val_80776,c__38457__auto___80824,c__23767__auto___80822,id__23768__auto___80823))
})();
var state__38459__auto__ = (function (){var statearr_80808 = f__38458__auto__.call(null);
(statearr_80808[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto____$1);

return statearr_80808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});
;})(c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_80734,inst_80735,inst_80736,inst_80737,inst_80738,inst_80769,state_val_80776,c__38457__auto___80824,c__23767__auto___80822,id__23768__auto___80823))
})();
var inst_80771 = cljs.core.async.impl.dispatch.run.call(null,inst_80770);
var state_80775__$1 = (function (){var statearr_80809 = state_80775;
(statearr_80809[(11)] = inst_80771);

(statearr_80809[(12)] = inst_80735);

(statearr_80809[(13)] = inst_80734);

return statearr_80809;
})();
var statearr_80810_80846 = state_80775__$1;
(statearr_80810_80846[(2)] = inst_80769);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80775__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___80824,c__23767__auto___80822,id__23768__auto___80823))
;
return ((function (switch__38343__auto__,c__38457__auto___80824,c__23767__auto___80822,id__23768__auto___80823){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_80814 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80814[(0)] = superv$async$state_machine__38344__auto__);

(statearr_80814[(1)] = (1));

return statearr_80814;
});
var superv$async$state_machine__38344__auto____1 = (function (state_80775){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_80775);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e80815){if((e80815 instanceof Object)){
var ex__38347__auto__ = e80815;
var statearr_80816_80847 = state_80775;
(statearr_80816_80847[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80775);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80815;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80848 = state_80775;
state_80775 = G__80848;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_80775){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_80775);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___80824,c__23767__auto___80822,id__23768__auto___80823))
})();
var state__38459__auto__ = (function (){var statearr_80817 = f__38458__auto__.call(null);
(statearr_80817[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___80824);

return statearr_80817;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___80824,c__23767__auto___80822,id__23768__auto___80823))
);


return cljs.core.async.sub.call(null,p,topic,ch,close_QMARK_);
});

superv.async.sub.cljs$lang$maxFixedArity = 5;

/**
 * Creates a supervised channel for transducer xform. Exceptions
 *   immediatly propagate to the supervisor.
 */
superv.async.chan_super = (function superv$async$chan_super(S,buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,(function (e){
return cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(S),e);
}));
});
/**
 * Starts a subsystem with supervised go-routines initialized by start-fn.
 *   Restarts the system on error for retries times with a potential delay in
 *   milliseconds, an optional error-fn predicate determining the retry and a
 *   optional filter by exception type. You can optionally pass a supervisor to
 *   form a supervision tree. Whenever this passed supervisor aborts the context,
 *   this supervisor will close as well. You still need to block on the result of
 *   this supervisor if you want a clean synchronized shutdown. The concept is
 *   similar to http://learnyousomeerlang.com/supervisors
 * 
 *   All blocking channel ops in the subroutines (supervised context) are
 *   aborted with an exception on error to force total termination. The
 *   supervisor waits until all supervised go-routines are finished and
 *   have freed resources before restarting.
 * 
 *   If exceptions are not taken from go-try channels (by error), they become stale
 *   after the stale-timeout and trigger a restart or are propagated to the parent
 *   supervisor (if available) and the return value.
 * 
 *   Note: The signature and behaviour of this function might still change.
 */
superv.async.restarting_supervisor = (function superv$async$restarting_supervisor(var_args){
var args__10647__auto__ = [];
var len__10640__auto___81156 = arguments.length;
var i__10641__auto___81157 = (0);
while(true){
if((i__10641__auto___81157 < len__10640__auto___81156)){
args__10647__auto__.push((arguments[i__10641__auto___81157]));

var G__81158 = (i__10641__auto___81157 + (1));
i__10641__auto___81157 = G__81158;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (start_fn,p__80863){
var map__80864 = p__80863;
var map__80864__$1 = ((((!((map__80864 == null)))?((((map__80864.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__80864.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__80864):map__80864);
var retries = cljs.core.get.call(null,map__80864__$1,new cljs.core.Keyword(null,"retries","retries",1888092808),Infinity);
var delay = cljs.core.get.call(null,map__80864__$1,new cljs.core.Keyword(null,"delay","delay",-574225219),(0));
var error_fn = cljs.core.get.call(null,map__80864__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),null);
var exception = cljs.core.get.call(null,map__80864__$1,new cljs.core.Keyword(null,"exception","exception",-335277064),Error);
var stale_timeout = cljs.core.get.call(null,map__80864__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((60) * (1000)));
var log_fn = cljs.core.get.call(null,map__80864__$1,new cljs.core.Keyword(null,"log-fn","log-fn",-2003241282),((function (map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout){
return (function (level,msg){
return cljs.core.println.call(null,level,msg);
});})(map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout))
);
var supervisor = cljs.core.get.call(null,map__80864__$1,new cljs.core.Keyword(null,"supervisor","supervisor",-134060208));
var retries__$1 = (function (){var or__9419__auto__ = retries;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return Infinity;
}
})();
var out_ch = cljs.core.async.chan.call(null);
var c__38457__auto___81159 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_81055){
var state_val_81056 = (state_81055[(1)]);
if((state_val_81056 === (7))){
var inst_80870 = (state_81055[(7)]);
var inst_80998 = (state_81055[(2)]);
var inst_80999 = cljs.core.nth.call(null,inst_80998,(0),null);
var inst_81000 = cljs.core.nth.call(null,inst_80998,(1),null);
var inst_81001 = cljs.core._EQ_.call(null,inst_81000,inst_80870);
var inst_81002 = !(inst_81001);
var state_81055__$1 = (function (){var statearr_81057 = state_81055;
(statearr_81057[(8)] = inst_80999);

return statearr_81057;
})();
if(inst_81002){
var statearr_81058_81160 = state_81055__$1;
(statearr_81058_81160[(1)] = (8));

} else {
var statearr_81059_81161 = state_81055__$1;
(statearr_81059_81161[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81056 === (20))){
var inst_80999 = (state_81055[(8)]);
var inst_81030 = (state_81055[(2)]);
var inst_81031 = cljs.core.async.put_BANG_.call(null,out_ch,inst_80999);
var inst_81032 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_81055__$1 = (function (){var statearr_81060 = state_81055;
(statearr_81060[(9)] = inst_81030);

(statearr_81060[(10)] = inst_81031);

return statearr_81060;
})();
var statearr_81061_81162 = state_81055__$1;
(statearr_81061_81162[(2)] = inst_81032);

(statearr_81061_81162[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81056 === (1))){
var inst_80866 = retries__$1;
var state_81055__$1 = (function (){var statearr_81062 = state_81055;
(statearr_81062[(11)] = inst_80866);

return statearr_81062;
})();
var statearr_81063_81163 = state_81055__$1;
(statearr_81063_81163[(2)] = null);

(statearr_81063_81163[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81056 === (4))){
var inst_80878 = (state_81055[(12)]);
var inst_80869 = (state_81055[(13)]);
var inst_80868 = (state_81055[(14)]);
var inst_80866 = (state_81055[(11)]);
var inst_80879 = (state_81055[(15)]);
var inst_80870 = (state_81055[(7)]);
var inst_80881 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_80882 = cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"supervisor","supervisor",1506471319,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ab-ch","ab-ch",-698106711,null)));
var inst_80883 = superv.async._register_go.call(null,supervisor,inst_80882);
var inst_80908 = cljs.core.async.chan.call(null,(1));
var inst_80909 = (function (){var stale_timeout__$1 = (1000);
var c__23767__auto__ = inst_80881;
var id__23768__auto__ = inst_80883;
var err_ch = inst_80868;
var ab_ch = inst_80869;
var res_ch = inst_80879;
var close_ch = inst_80870;
var retries__$2 = inst_80866;
var s = inst_80878;
var c__38457__auto____$1 = inst_80908;
return ((function (stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80881,inst_80882,inst_80883,inst_80908,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80881,inst_80882,inst_80883,inst_80908,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_80906){
var state_val_80907 = (state_80906[(1)]);
if((state_val_80907 === (1))){
var state_80906__$1 = state_80906;
var statearr_81064_81164 = state_80906__$1;
(statearr_81064_81164[(2)] = null);

(statearr_81064_81164[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80907 === (2))){
var inst_80904 = (state_80906[(2)]);
var state_80906__$1 = state_80906;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80906__$1,inst_80904);
} else {
if((state_val_80907 === (3))){
var inst_80884 = (state_80906[(2)]);
var inst_80885 = superv.async._unregister_go.call(null,supervisor,id__23768__auto__);
var state_80906__$1 = (function (){var statearr_81065 = state_80906;
(statearr_81065[(7)] = inst_80885);

(statearr_81065[(8)] = inst_80884);

return statearr_81065;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80906__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80907 === (4))){
var inst_80887 = (state_80906[(9)]);
var inst_80887__$1 = (state_80906[(2)]);
var inst_80888 = cljs.core.ex_data.call(null,inst_80887__$1);
var inst_80889 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_80888);
var inst_80890 = cljs.core._EQ_.call(null,inst_80889,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_80906__$1 = (function (){var statearr_81066 = state_80906;
(statearr_81066[(9)] = inst_80887__$1);

return statearr_81066;
})();
if(inst_80890){
var statearr_81067_81165 = state_80906__$1;
(statearr_81067_81165[(1)] = (5));

} else {
var statearr_81068_81166 = state_80906__$1;
(statearr_81068_81166[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80907 === (5))){
var state_80906__$1 = state_80906;
var statearr_81069_81167 = state_80906__$1;
(statearr_81069_81167[(2)] = null);

(statearr_81069_81167[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80907 === (6))){
var inst_80887 = (state_80906[(9)]);
var inst_80893 = superv.async._track_exception.call(null,supervisor,inst_80887);
var state_80906__$1 = state_80906;
var statearr_81070_81168 = state_80906__$1;
(statearr_81070_81168[(2)] = inst_80893);

(statearr_81070_81168[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80907 === (7))){
var inst_80887 = (state_80906[(9)]);
var inst_80895 = (state_80906[(2)]);
var state_80906__$1 = (function (){var statearr_81071 = state_80906;
(statearr_81071[(10)] = inst_80895);

return statearr_81071;
})();
var statearr_81072_81169 = state_80906__$1;
(statearr_81072_81169[(2)] = inst_80887);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80906__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80907 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_80906,(4),Error,(3),(2));
var inst_80899 = superv.async._abort.call(null,supervisor);
var state_80906__$1 = state_80906;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80906__$1,(9),inst_80899);
} else {
if((state_val_80907 === (9))){
var inst_80901 = (state_80906[(2)]);
var inst_80902 = cljs.core.async.close_BANG_.call(null,ab_ch);
var state_80906__$1 = (function (){var statearr_81073 = state_80906;
(statearr_81073[(11)] = inst_80901);

return statearr_81073;
})();
var statearr_81074_81170 = state_80906__$1;
(statearr_81074_81170[(2)] = inst_80902);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80906__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80881,inst_80882,inst_80883,inst_80908,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__38343__auto__,stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80881,inst_80882,inst_80883,inst_80908,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_81078 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81078[(0)] = superv$async$state_machine__38344__auto__);

(statearr_81078[(1)] = (1));

return statearr_81078;
});
var superv$async$state_machine__38344__auto____1 = (function (state_80906){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_80906);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e81079){if((e81079 instanceof Object)){
var ex__38347__auto__ = e81079;
var statearr_81080_81171 = state_80906;
(statearr_81080_81171[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80906);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81079;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81172 = state_80906;
state_80906 = G__81172;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_80906){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_80906);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80881,inst_80882,inst_80883,inst_80908,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__38459__auto__ = (function (){var statearr_81081 = f__38458__auto__.call(null);
(statearr_81081[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto____$1);

return statearr_81081;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});
;})(stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80881,inst_80882,inst_80883,inst_80908,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_80910 = cljs.core.async.impl.dispatch.run.call(null,inst_80909);
var state_81055__$1 = (function (){var statearr_81082 = state_81055;
(statearr_81082[(16)] = inst_80910);

return statearr_81082;
})();
var statearr_81083_81173 = state_81055__$1;
(statearr_81083_81173[(2)] = inst_80908);

(statearr_81083_81173[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81056 === (15))){
var inst_80999 = (state_81055[(8)]);
var inst_81021 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81022 = [new cljs.core.Keyword(null,"passing-error","passing-error",-1357712542),inst_80999];
var inst_81023 = cljs.core.PersistentHashMap.fromArrays(inst_81021,inst_81022);
var inst_81024 = log_fn.call(null,new cljs.core.Keyword(null,"error","error",-978969032),inst_81023);
var state_81055__$1 = (function (){var statearr_81084 = state_81055;
(statearr_81084[(17)] = inst_81024);

return statearr_81084;
})();
if(cljs.core.truth_(supervisor)){
var statearr_81085_81174 = state_81055__$1;
(statearr_81085_81174[(1)] = (18));

} else {
var statearr_81086_81175 = state_81055__$1;
(statearr_81086_81175[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81056 === (21))){
var inst_80999 = (state_81055[(8)]);
var inst_80866 = (state_81055[(11)]);
var inst_81036 = (state_81055[(2)]);
var inst_81037 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"further-retries","further-retries",1297645153)];
var inst_81038 = [new cljs.core.Keyword(null,"retry","retry",-614012896),inst_80999,inst_80866];
var inst_81039 = cljs.core.PersistentHashMap.fromArrays(inst_81037,inst_81038);
var inst_81040 = log_fn.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),inst_81039);
var inst_81041 = (inst_80866 - (1));
var inst_80866__$1 = inst_81041;
var state_81055__$1 = (function (){var statearr_81087 = state_81055;
(statearr_81087[(11)] = inst_80866__$1);

(statearr_81087[(18)] = inst_81040);

(statearr_81087[(19)] = inst_81036);

return statearr_81087;
})();
var statearr_81088_81176 = state_81055__$1;
(statearr_81088_81176[(2)] = null);

(statearr_81088_81176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81056 === (13))){
var inst_80999 = (state_81055[(8)]);
var inst_81013 = error_fn.call(null,inst_80999);
var state_81055__$1 = state_81055;
var statearr_81089_81177 = state_81055__$1;
(statearr_81089_81177[(2)] = inst_81013);

(statearr_81089_81177[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81056 === (22))){
var inst_81047 = (state_81055[(2)]);
var inst_81048 = cljs.core.async.put_BANG_.call(null,out_ch,inst_81047);
var inst_81049 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_81055__$1 = (function (){var statearr_81090 = state_81055;
(statearr_81090[(20)] = inst_81048);

return statearr_81090;
})();
var statearr_81091_81178 = state_81055__$1;
(statearr_81091_81178[(2)] = inst_81049);

(statearr_81091_81178[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81056 === (6))){
var inst_80878 = (state_81055[(12)]);
var inst_80869 = (state_81055[(13)]);
var inst_80868 = (state_81055[(14)]);
var inst_80866 = (state_81055[(11)]);
var inst_80879 = (state_81055[(15)]);
var inst_80870 = (state_81055[(7)]);
var inst_80913 = (state_81055[(2)]);
var inst_80960 = cljs.core.async.chan.call(null,(1));
var inst_80961 = (function (){var retries__$2 = inst_80866;
var err_ch = inst_80868;
var ab_ch = inst_80869;
var close_ch = inst_80870;
var s = inst_80878;
var res_ch = inst_80879;
var stale_timeout__$1 = (1000);
var c__38457__auto____$1 = inst_80960;
return ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80913,inst_80960,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80913,inst_80960,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_80958){
var state_val_80959 = (state_80958[(1)]);
if((state_val_80959 === (7))){
var inst_80933 = (state_80958[(7)]);
var inst_80920 = (state_80958[(2)]);
var inst_80928 = (function (){return ((function (inst_80933,inst_80920,state_val_80959,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80913,inst_80960,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (p__80927){
var vec__81092 = p__80927;
var k = cljs.core.nth.call(null,vec__81092,(0),null);
var v = cljs.core.nth.call(null,vec__81092,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout__$1) > v.getTime());
});
;})(inst_80933,inst_80920,state_val_80959,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80913,inst_80960,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_80929 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_80930 = cljs.core.deref.call(null,inst_80929);
var inst_80931 = cljs.core.filter.call(null,inst_80928,inst_80930);
var inst_80932 = cljs.core.nth.call(null,inst_80931,(0),null);
var inst_80933__$1 = cljs.core.nth.call(null,inst_80932,(0),null);
var inst_80934 = cljs.core.nth.call(null,inst_80932,(1),null);
var state_80958__$1 = (function (){var statearr_81095 = state_80958;
(statearr_81095[(7)] = inst_80933__$1);

(statearr_81095[(8)] = inst_80934);

(statearr_81095[(9)] = inst_80920);

return statearr_81095;
})();
if(cljs.core.truth_(inst_80933__$1)){
var statearr_81096_81179 = state_80958__$1;
(statearr_81096_81179[(1)] = (8));

} else {
var statearr_81097_81180 = state_80958__$1;
(statearr_81097_81180[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80959 === (1))){
var state_80958__$1 = state_80958;
var statearr_81098_81181 = state_80958__$1;
(statearr_81098_81181[(2)] = null);

(statearr_81098_81181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80959 === (4))){
var state_80958__$1 = state_80958;
var statearr_81099_81182 = state_80958__$1;
(statearr_81099_81182[(2)] = null);

(statearr_81099_81182[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80959 === (13))){
var inst_80933 = (state_80958[(7)]);
var inst_80946 = (state_80958[(2)]);
var inst_80947 = superv.async._free_exception.call(null,s,inst_80933);
var inst_80948 = cljs.core.async.put_BANG_.call(null,err_ch,inst_80933);
var state_80958__$1 = (function (){var statearr_81100 = state_80958;
(statearr_81100[(10)] = inst_80947);

(statearr_81100[(11)] = inst_80946);

return statearr_81100;
})();
var statearr_81101_81183 = state_80958__$1;
(statearr_81101_81183[(2)] = inst_80948);

(statearr_81101_81183[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80959 === (6))){
var inst_80954 = (state_80958[(2)]);
var state_80958__$1 = state_80958;
var statearr_81102_81184 = state_80958__$1;
(statearr_81102_81184[(2)] = inst_80954);

(statearr_81102_81184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80959 === (3))){
var inst_80956 = (state_80958[(2)]);
var state_80958__$1 = state_80958;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80958__$1,inst_80956);
} else {
if((state_val_80959 === (12))){
var inst_80933 = (state_80958[(7)]);
var inst_80941 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_80942 = [new cljs.core.Keyword(null,"stale-error-in-supervisor","stale-error-in-supervisor",-123257662),inst_80933];
var inst_80943 = cljs.core.PersistentHashMap.fromArrays(inst_80941,inst_80942);
var inst_80944 = log_fn.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_80943);
var state_80958__$1 = state_80958;
var statearr_81103_81185 = state_80958__$1;
(statearr_81103_81185[(2)] = inst_80944);

(statearr_81103_81185[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80959 === (2))){
var inst_80915 = cljs.core.async.poll_BANG_.call(null,ab_ch);
var state_80958__$1 = state_80958;
if(cljs.core.truth_(inst_80915)){
var statearr_81104_81186 = state_80958__$1;
(statearr_81104_81186[(1)] = (4));

} else {
var statearr_81105_81187 = state_80958__$1;
(statearr_81105_81187[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80959 === (11))){
var state_80958__$1 = state_80958;
var statearr_81106_81188 = state_80958__$1;
(statearr_81106_81188[(2)] = null);

(statearr_81106_81188[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80959 === (9))){
var state_80958__$1 = state_80958;
var statearr_81107_81189 = state_80958__$1;
(statearr_81107_81189[(2)] = null);

(statearr_81107_81189[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80959 === (5))){
var inst_80918 = cljs.core.async.timeout.call(null,stale_timeout__$1);
var state_80958__$1 = state_80958;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80958__$1,(7),inst_80918);
} else {
if((state_val_80959 === (10))){
var inst_80952 = (state_80958[(2)]);
var state_80958__$1 = state_80958;
var statearr_81108_81190 = state_80958__$1;
(statearr_81108_81190[(2)] = inst_80952);

(statearr_81108_81190[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80959 === (8))){
var inst_80933 = (state_80958[(7)]);
var inst_80936 = cljs.core.ex_data.call(null,inst_80933);
var inst_80937 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_80936);
var inst_80938 = cljs.core._EQ_.call(null,inst_80937,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_80958__$1 = state_80958;
if(inst_80938){
var statearr_81109_81191 = state_80958__$1;
(statearr_81109_81191[(1)] = (11));

} else {
var statearr_81110_81192 = state_80958__$1;
(statearr_81110_81192[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80913,inst_80960,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__38343__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80913,inst_80960,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_81114 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81114[(0)] = superv$async$state_machine__38344__auto__);

(statearr_81114[(1)] = (1));

return statearr_81114;
});
var superv$async$state_machine__38344__auto____1 = (function (state_80958){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_80958);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e81115){if((e81115 instanceof Object)){
var ex__38347__auto__ = e81115;
var statearr_81116_81193 = state_80958;
(statearr_81116_81193[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80958);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81115;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81194 = state_80958;
state_80958 = G__81194;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_80958){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_80958);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80913,inst_80960,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__38459__auto__ = (function (){var statearr_81117 = f__38458__auto__.call(null);
(statearr_81117[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto____$1);

return statearr_81117;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});
;})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80913,inst_80960,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_80962 = cljs.core.async.impl.dispatch.run.call(null,inst_80961);
var inst_80988 = cljs.core.async.chan.call(null,(1));
var inst_80989 = (function (){var retries__$2 = inst_80866;
var err_ch = inst_80868;
var ab_ch = inst_80869;
var close_ch = inst_80870;
var s = inst_80878;
var res_ch = inst_80879;
var stale_timeout__$1 = (1000);
var c__38457__auto____$1 = inst_80988;
return ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80913,inst_80960,inst_80961,inst_80962,inst_80988,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80913,inst_80960,inst_80961,inst_80962,inst_80988,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_80986){
var state_val_80987 = (state_80986[(1)]);
if((state_val_80987 === (1))){
var inst_80963 = (0);
var state_80986__$1 = (function (){var statearr_81118 = state_80986;
(statearr_81118[(7)] = inst_80963);

return statearr_81118;
})();
var statearr_81119_81195 = state_80986__$1;
(statearr_81119_81195[(2)] = null);

(statearr_81119_81195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80987 === (2))){
var inst_80965 = new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(s);
var inst_80966 = cljs.core.deref.call(null,inst_80965);
var inst_80967 = cljs.core.empty_QMARK_.call(null,inst_80966);
var inst_80968 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_80969 = cljs.core.deref.call(null,inst_80968);
var inst_80970 = cljs.core.empty_QMARK_.call(null,inst_80969);
var inst_80971 = (inst_80967) && (inst_80970);
var inst_80972 = cljs.core.not.call(null,inst_80971);
var state_80986__$1 = state_80986;
if(inst_80972){
var statearr_81120_81196 = state_80986__$1;
(statearr_81120_81196[(1)] = (4));

} else {
var statearr_81121_81197 = state_80986__$1;
(statearr_81121_81197[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80987 === (3))){
var inst_80984 = (state_80986[(2)]);
var state_80986__$1 = state_80986;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80986__$1,inst_80984);
} else {
if((state_val_80987 === (4))){
var inst_80974 = cljs.core.async.timeout.call(null,(100));
var state_80986__$1 = state_80986;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80986__$1,(7),inst_80974);
} else {
if((state_val_80987 === (5))){
var inst_80980 = cljs.core.async.close_BANG_.call(null,close_ch);
var state_80986__$1 = state_80986;
var statearr_81122_81198 = state_80986__$1;
(statearr_81122_81198[(2)] = inst_80980);

(statearr_81122_81198[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80987 === (6))){
var inst_80982 = (state_80986[(2)]);
var state_80986__$1 = state_80986;
var statearr_81123_81199 = state_80986__$1;
(statearr_81123_81199[(2)] = inst_80982);

(statearr_81123_81199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80987 === (7))){
var inst_80963 = (state_80986[(7)]);
var inst_80976 = (state_80986[(2)]);
var inst_80977 = (inst_80963 + (1));
var inst_80963__$1 = inst_80977;
var state_80986__$1 = (function (){var statearr_81124 = state_80986;
(statearr_81124[(8)] = inst_80976);

(statearr_81124[(7)] = inst_80963__$1);

return statearr_81124;
})();
var statearr_81125_81200 = state_80986__$1;
(statearr_81125_81200[(2)] = null);

(statearr_81125_81200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80913,inst_80960,inst_80961,inst_80962,inst_80988,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__38343__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80913,inst_80960,inst_80961,inst_80962,inst_80988,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_81129 = [null,null,null,null,null,null,null,null,null];
(statearr_81129[(0)] = superv$async$state_machine__38344__auto__);

(statearr_81129[(1)] = (1));

return statearr_81129;
});
var superv$async$state_machine__38344__auto____1 = (function (state_80986){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_80986);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e81130){if((e81130 instanceof Object)){
var ex__38347__auto__ = e81130;
var statearr_81131_81201 = state_80986;
(statearr_81131_81201[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80986);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81130;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81202 = state_80986;
state_80986 = G__81202;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_80986){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_80986);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80913,inst_80960,inst_80961,inst_80962,inst_80988,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__38459__auto__ = (function (){var statearr_81132 = f__38458__auto__.call(null);
(statearr_81132[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto____$1);

return statearr_81132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});
;})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_80878,inst_80869,inst_80868,inst_80866,inst_80879,inst_80870,inst_80913,inst_80960,inst_80961,inst_80962,inst_80988,state_val_81056,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_80990 = cljs.core.async.impl.dispatch.run.call(null,inst_80989);
var inst_80994 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80995 = [inst_80868,inst_80870];
var inst_80996 = (new cljs.core.PersistentVector(null,2,(5),inst_80994,inst_80995,null));
var state_81055__$1 = (function (){var statearr_81133 = state_81055;
(statearr_81133[(21)] = inst_80913);

(statearr_81133[(22)] = inst_80962);

(statearr_81133[(23)] = inst_80990);

return statearr_81133;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_81055__$1,(7),inst_80996,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_81056 === (17))){
var inst_81044 = (state_81055[(2)]);
var state_81055__$1 = state_81055;
var statearr_81134_81203 = state_81055__$1;
(statearr_81134_81203[(2)] = inst_81044);

(statearr_81134_81203[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81056 === (3))){
var inst_81053 = (state_81055[(2)]);
var state_81055__$1 = state_81055;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81055__$1,inst_81053);
} else {
if((state_val_81056 === (12))){
var inst_81010 = (state_81055[(24)]);
var state_81055__$1 = state_81055;
var statearr_81135_81204 = state_81055__$1;
(statearr_81135_81204[(2)] = inst_81010);

(statearr_81135_81204[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81056 === (2))){
var inst_80878 = (state_81055[(12)]);
var inst_80869 = (state_81055[(13)]);
var inst_80868 = (state_81055[(14)]);
var inst_80868__$1 = cljs.core.async.chan.call(null);
var inst_80869__$1 = cljs.core.async.chan.call(null);
var inst_80870 = cljs.core.async.chan.call(null);
var inst_80871 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),new cljs.core.Keyword(null,"restarting","restarting",760677572)];
var inst_80872 = cljs.core.PersistentHashMap.EMPTY;
var inst_80873 = cljs.core.atom.call(null,inst_80872);
var inst_80874 = cljs.core.PersistentHashMap.EMPTY;
var inst_80875 = cljs.core.atom.call(null,inst_80874);
var inst_80876 = [inst_80868__$1,inst_80869__$1,inst_80873,inst_80875,true];
var inst_80877 = cljs.core.PersistentHashMap.fromArrays(inst_80871,inst_80876);
var inst_80878__$1 = superv.async.map__GT_TrackingSupervisor.call(null,inst_80877);
var inst_80879 = start_fn.call(null,inst_80878__$1);
var state_81055__$1 = (function (){var statearr_81136 = state_81055;
(statearr_81136[(12)] = inst_80878__$1);

(statearr_81136[(13)] = inst_80869__$1);

(statearr_81136[(14)] = inst_80868__$1);

(statearr_81136[(15)] = inst_80879);

(statearr_81136[(7)] = inst_80870);

return statearr_81136;
})();
if(cljs.core.truth_(supervisor)){
var statearr_81137_81205 = state_81055__$1;
(statearr_81137_81205[(1)] = (4));

} else {
var statearr_81138_81206 = state_81055__$1;
(statearr_81138_81206[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81056 === (19))){
var state_81055__$1 = state_81055;
var statearr_81139_81207 = state_81055__$1;
(statearr_81139_81207[(2)] = null);

(statearr_81139_81207[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81056 === (11))){
var inst_80999 = (state_81055[(8)]);
var inst_81010 = (state_81055[(24)]);
var inst_81007 = (state_81055[(2)]);
var inst_81008 = (inst_80999 instanceof exception);
var inst_81009 = cljs.core.not.call(null,inst_81008);
var inst_81010__$1 = cljs.core.not.call(null,error_fn);
var state_81055__$1 = (function (){var statearr_81140 = state_81055;
(statearr_81140[(25)] = inst_81009);

(statearr_81140[(24)] = inst_81010__$1);

(statearr_81140[(26)] = inst_81007);

return statearr_81140;
})();
if(inst_81010__$1){
var statearr_81141_81208 = state_81055__$1;
(statearr_81141_81208[(1)] = (12));

} else {
var statearr_81142_81209 = state_81055__$1;
(statearr_81142_81209[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81056 === (9))){
var inst_80879 = (state_81055[(15)]);
var state_81055__$1 = state_81055;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81055__$1,(22),inst_80879);
} else {
if((state_val_81056 === (5))){
var state_81055__$1 = state_81055;
var statearr_81143_81210 = state_81055__$1;
(statearr_81143_81210[(2)] = null);

(statearr_81143_81210[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81056 === (14))){
var inst_81009 = (state_81055[(25)]);
var inst_80866 = (state_81055[(11)]);
var inst_81015 = (state_81055[(2)]);
var inst_81016 = cljs.core.not.call(null,inst_81015);
var inst_81017 = (inst_80866 > (0));
var inst_81018 = cljs.core.not.call(null,inst_81017);
var inst_81019 = (inst_81009) || (inst_81016) || (inst_81018);
var state_81055__$1 = state_81055;
if(cljs.core.truth_(inst_81019)){
var statearr_81144_81211 = state_81055__$1;
(statearr_81144_81211[(1)] = (15));

} else {
var statearr_81145_81212 = state_81055__$1;
(statearr_81145_81212[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81056 === (16))){
var inst_81034 = cljs.core.async.timeout.call(null,delay);
var state_81055__$1 = state_81055;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81055__$1,(21),inst_81034);
} else {
if((state_val_81056 === (10))){
var inst_81051 = (state_81055[(2)]);
var state_81055__$1 = state_81055;
var statearr_81146_81213 = state_81055__$1;
(statearr_81146_81213[(2)] = inst_81051);

(statearr_81146_81213[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81056 === (18))){
var inst_80999 = (state_81055[(8)]);
var inst_81026 = superv.async._error.call(null,supervisor);
var inst_81027 = cljs.core.async.put_BANG_.call(null,inst_81026,inst_80999);
var state_81055__$1 = state_81055;
var statearr_81147_81214 = state_81055__$1;
(statearr_81147_81214[(2)] = inst_81027);

(statearr_81147_81214[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81056 === (8))){
var inst_80869 = (state_81055[(13)]);
var inst_80868 = (state_81055[(14)]);
var inst_80870 = (state_81055[(7)]);
var inst_81004 = cljs.core.async.close_BANG_.call(null,inst_80868);
var inst_81005 = cljs.core.async.close_BANG_.call(null,inst_80869);
var state_81055__$1 = (function (){var statearr_81148 = state_81055;
(statearr_81148[(27)] = inst_81004);

(statearr_81148[(28)] = inst_81005);

return statearr_81148;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81055__$1,(11),inst_80870);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__38343__auto__,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_81152 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81152[(0)] = superv$async$state_machine__38344__auto__);

(statearr_81152[(1)] = (1));

return statearr_81152;
});
var superv$async$state_machine__38344__auto____1 = (function (state_81055){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_81055);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e81153){if((e81153 instanceof Object)){
var ex__38347__auto__ = e81153;
var statearr_81154_81215 = state_81055;
(statearr_81154_81215[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81055);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81153;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81216 = state_81055;
state_81055 = G__81216;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_81055){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_81055);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__38459__auto__ = (function (){var statearr_81155 = f__38458__auto__.call(null);
(statearr_81155[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___81159);

return statearr_81155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___81159,retries__$1,out_ch,map__80864,map__80864__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
);


return out_ch;
});

superv.async.restarting_supervisor.cljs$lang$maxFixedArity = (1);

superv.async.restarting_supervisor.cljs$lang$applyTo = (function (seq80861){
var G__80862 = cljs.core.first.call(null,seq80861);
var seq80861__$1 = cljs.core.next.call(null,seq80861);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic(G__80862,seq80861__$1);
});


//# sourceMappingURL=async.js.map