// Compiled by ClojureScript 1.9.521 {}
goog.provide('hasch.benc');
goog.require('cljs.core');

/**
 * @interface
 */
hasch.benc.PHashCoercion = function(){};

hasch.benc._coerce = (function hasch$benc$_coerce(this$,md_create_fn,write_handlers){
if((!((this$ == null))) && (!((this$.hasch$benc$PHashCoercion$_coerce$arity$3 == null)))){
return this$.hasch$benc$PHashCoercion$_coerce$arity$3(this$,md_create_fn,write_handlers);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (hasch.benc._coerce[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,md_create_fn,write_handlers);
} else {
var m__10138__auto____$1 = (hasch.benc._coerce["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,md_create_fn,write_handlers);
} else {
throw cljs.core.missing_protocol.call(null,"PHashCoercion.-coerce",this$);
}
}
}
});

hasch.benc.magics = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"binary","binary",-1802232288),new cljs.core.Keyword(null,"inst","inst",645962501),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Keyword(null,"symbol","symbol",-1038572696),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"vector","vector",1902966158),new cljs.core.Keyword(null,"keyword","keyword",811389747),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"literal","literal",1664775605),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"seq","seq",-1817803783),new cljs.core.Keyword(null,"set","set",304602554),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"map","map",1371690461)],[(13),(6),(2),(4),(3),(9),(5),(0),(12),(7),(8),(11),(1),(10)]);
hasch.benc.split_size = (1024);
hasch.benc.max_entropy_byte_count = (32);
hasch.benc.byte_array = (function hasch$benc$byte_array(len){
return cljs.core.into_array.call(null,cljs.core.repeat.call(null,len,(0)));
});
hasch.benc.digest = (function hasch$benc$digest(bytes_or_seq_of_bytes,md_create_fn){
var md = md_create_fn.call(null);
if(cljs.core.seq_QMARK_.call(null,bytes_or_seq_of_bytes)){
var seq__64201_64205 = cljs.core.seq.call(null,bytes_or_seq_of_bytes);
var chunk__64202_64206 = null;
var count__64203_64207 = (0);
var i__64204_64208 = (0);
while(true){
if((i__64204_64208 < count__64203_64207)){
var bs_64209 = cljs.core._nth.call(null,chunk__64202_64206,i__64204_64208);
md.update(bs_64209);

var G__64210 = seq__64201_64205;
var G__64211 = chunk__64202_64206;
var G__64212 = count__64203_64207;
var G__64213 = (i__64204_64208 + (1));
seq__64201_64205 = G__64210;
chunk__64202_64206 = G__64211;
count__64203_64207 = G__64212;
i__64204_64208 = G__64213;
continue;
} else {
var temp__6738__auto___64214 = cljs.core.seq.call(null,seq__64201_64205);
if(temp__6738__auto___64214){
var seq__64201_64215__$1 = temp__6738__auto___64214;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__64201_64215__$1)){
var c__10330__auto___64216 = cljs.core.chunk_first.call(null,seq__64201_64215__$1);
var G__64217 = cljs.core.chunk_rest.call(null,seq__64201_64215__$1);
var G__64218 = c__10330__auto___64216;
var G__64219 = cljs.core.count.call(null,c__10330__auto___64216);
var G__64220 = (0);
seq__64201_64205 = G__64217;
chunk__64202_64206 = G__64218;
count__64203_64207 = G__64219;
i__64204_64208 = G__64220;
continue;
} else {
var bs_64221 = cljs.core.first.call(null,seq__64201_64215__$1);
md.update(bs_64221);

var G__64222 = cljs.core.next.call(null,seq__64201_64215__$1);
var G__64223 = null;
var G__64224 = (0);
var G__64225 = (0);
seq__64201_64205 = G__64222;
chunk__64202_64206 = G__64223;
count__64203_64207 = G__64224;
i__64204_64208 = G__64225;
continue;
}
} else {
}
}
break;
}
} else {
md.update(bytes_or_seq_of_bytes);
}

return md.digest();
});
hasch.benc.coerce_seq = (function hasch$benc$coerce_seq(seq,md_create_fn,write_handlers){
var seq_md = md_create_fn.call(null);
var s_64232 = seq;
while(true){
var vec__64229_64233 = s_64232;
var seq__64230_64234 = cljs.core.seq.call(null,vec__64229_64233);
var first__64231_64235 = cljs.core.first.call(null,seq__64230_64234);
var seq__64230_64236__$1 = cljs.core.next.call(null,seq__64230_64234);
var f_64237 = first__64231_64235;
var r_64238 = seq__64230_64236__$1;
seq_md.update(hasch.benc._coerce.call(null,f_64237,md_create_fn,write_handlers));

if(cljs.core.empty_QMARK_.call(null,r_64238)){
} else {
var G__64239 = cljs.core.rest.call(null,s_64232);
s_64232 = G__64239;
continue;
}
break;
}

return seq_md.digest();
});
/**
 * Commutatively coerces elements of collection, seq entries must already be crypto hashes
 *   to avoid collisions in XOR. Takes at maximum 32 bytes into account.
 */
hasch.benc.xor_hashes = (function hasch$benc$xor_hashes(seq){
var len = (function (){var x__9764__auto__ = cljs.core.count.call(null,cljs.core.first.call(null,seq));
var y__9765__auto__ = hasch.benc.max_entropy_byte_count;
return ((x__9764__auto__ < y__9765__auto__) ? x__9764__auto__ : y__9765__auto__);
})();
return cljs.core.reduce.call(null,((function (len){
return (function (acc,elem){
var i_64240 = (0);
while(true){
if((i_64240 < len)){
(acc[i_64240] = ((acc[i_64240]) ^ (elem[i_64240])));

var G__64241 = (i_64240 + (1));
i_64240 = G__64241;
continue;
} else {
}
break;
}

return acc;
});})(len))
,hasch.benc.byte_array.call(null,len),seq);
});
hasch.benc.encode_safe = (function hasch$benc$encode_safe(a,md_create_fn){
if((cljs.core.count.call(null,a) < hasch.benc.split_size)){
var len = cljs.core.long$.call(null,a.length);
var ea = hasch.benc.byte_array.call(null,len);
var i_64242 = (0);
while(true){
if(cljs.core._EQ_.call(null,i_64242,len)){
} else {
var e_64243 = (a[i_64242]);
if(((e_64243 > (0))) && ((e_64243 < (30)))){
(ea[i_64242] = (1));
} else {
}

var G__64244 = (i_64242 + (1));
i_64242 = G__64244;
continue;
}
break;
}

return a.concat(ea);
} else {
return hasch.benc.digest.call(null,a,md_create_fn);
}
});

//# sourceMappingURL=benc.js.map