// Compiled by ClojureScript 1.9.521 {}
goog.provide('reagent.dom');
goog.require('cljs.core');
goog.require('cljsjs.react.dom');
goog.require('reagent.impl.util');
goog.require('reagent.impl.template');
goog.require('reagent.impl.batching');
goog.require('reagent.ratom');
goog.require('reagent.debug');
goog.require('reagent.interop');
if(typeof reagent.dom.imported !== 'undefined'){
} else {
reagent.dom.imported = null;
}
reagent.dom.module = (function reagent$dom$module(){
if(!((reagent.dom.imported == null))){
return reagent.dom.imported;
} else {
if(typeof ReactDOM !== 'undefined'){
return reagent.dom.imported = ReactDOM;
} else {
if(typeof require !== 'undefined'){
var or__9419__auto__ = reagent.dom.imported = require("react-dom");
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
throw (new Error("require('react-dom') failed"));
}
} else {
throw (new Error("js/ReactDOM is missing"));

}
}
}
});
if(typeof reagent.dom.roots !== 'undefined'){
} else {
reagent.dom.roots = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.dissoc,container);

return (reagent.dom.module.call(null)["unmountComponentAtNode"])(container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR_55742 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = true;

try{return (reagent.dom.module.call(null)["render"])(comp.call(null),container,((function (_STAR_always_update_STAR_55742){
return (function (){
var _STAR_always_update_STAR_55743 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = false;

try{cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.assoc,container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [comp,container], null));

reagent.impl.batching.flush_after_render.call(null);

if(!((callback == null))){
return callback.call(null);
} else {
return null;
}
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_55743;
}});})(_STAR_always_update_STAR_55742))
);
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_55742;
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp.call(null,comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element. The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var args55744 = [];
var len__10640__auto___55747 = arguments.length;
var i__10641__auto___55748 = (0);
while(true){
if((i__10641__auto___55748 < len__10640__auto___55747)){
args55744.push((arguments[i__10641__auto___55748]));

var G__55749 = (i__10641__auto___55748 + (1));
i__10641__auto___55748 = G__55749;
continue;
} else {
}
break;
}

var G__55746 = args55744.length;
switch (G__55746) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args55744.length)].join('')));

}
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.call(null,comp,container,null);
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback){
reagent.ratom.flush_BANG_.call(null);

var f = (function (){
return reagent.impl.template.as_element.call(null,((cljs.core.fn_QMARK_.call(null,comp))?comp.call(null):comp));
});
return reagent.dom.render_comp.call(null,f,container,callback);
});

reagent.dom.render.cljs$lang$maxFixedArity = 3;

reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp.call(null,container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return (reagent.dom.module.call(null)["findDOMNode"])(this$);
});
reagent.impl.template.find_dom_node = reagent.dom.dom_node;
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
reagent.ratom.flush_BANG_.call(null);

var seq__55755_55759 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,reagent.dom.roots)));
var chunk__55756_55760 = null;
var count__55757_55761 = (0);
var i__55758_55762 = (0);
while(true){
if((i__55758_55762 < count__55757_55761)){
var v_55763 = cljs.core._nth.call(null,chunk__55756_55760,i__55758_55762);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_55763);

var G__55764 = seq__55755_55759;
var G__55765 = chunk__55756_55760;
var G__55766 = count__55757_55761;
var G__55767 = (i__55758_55762 + (1));
seq__55755_55759 = G__55764;
chunk__55756_55760 = G__55765;
count__55757_55761 = G__55766;
i__55758_55762 = G__55767;
continue;
} else {
var temp__6738__auto___55768 = cljs.core.seq.call(null,seq__55755_55759);
if(temp__6738__auto___55768){
var seq__55755_55769__$1 = temp__6738__auto___55768;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__55755_55769__$1)){
var c__10330__auto___55770 = cljs.core.chunk_first.call(null,seq__55755_55769__$1);
var G__55771 = cljs.core.chunk_rest.call(null,seq__55755_55769__$1);
var G__55772 = c__10330__auto___55770;
var G__55773 = cljs.core.count.call(null,c__10330__auto___55770);
var G__55774 = (0);
seq__55755_55759 = G__55771;
chunk__55756_55760 = G__55772;
count__55757_55761 = G__55773;
i__55758_55762 = G__55774;
continue;
} else {
var v_55775 = cljs.core.first.call(null,seq__55755_55769__$1);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_55775);

var G__55776 = cljs.core.next.call(null,seq__55755_55769__$1);
var G__55777 = null;
var G__55778 = (0);
var G__55779 = (0);
seq__55755_55759 = G__55776;
chunk__55756_55760 = G__55777;
count__55757_55761 = G__55778;
i__55758_55762 = G__55779;
continue;
}
} else {
}
}
break;
}

return "Updated";
});

//# sourceMappingURL=dom.js.map