// Compiled by ClojureScript 1.9.521 {}
goog.provide('superv.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
superv.async.cljs_env_QMARK_ = (function superv$async$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});

/**
 * @interface
 */
superv.async.PSupervisor = function(){};

superv.async._error = (function superv$async$_error(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_error$arity$1 == null)))){
return this$.superv$async$PSupervisor$_error$arity$1(this$);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._error[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$);
} else {
var m__10138__auto____$1 = (superv.async._error["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-error",this$);
}
}
}
});

superv.async._abort = (function superv$async$_abort(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_abort$arity$1 == null)))){
return this$.superv$async$PSupervisor$_abort$arity$1(this$);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._abort[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$);
} else {
var m__10138__auto____$1 = (superv.async._abort["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-abort",this$);
}
}
}
});

superv.async._register_go = (function superv$async$_register_go(this$,body){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_register_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_register_go$arity$2(this$,body);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._register_go[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,body);
} else {
var m__10138__auto____$1 = (superv.async._register_go["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,body);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-register-go",this$);
}
}
}
});

superv.async._unregister_go = (function superv$async$_unregister_go(this$,id){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_unregister_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_unregister_go$arity$2(this$,id);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._unregister_go[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,id);
} else {
var m__10138__auto____$1 = (superv.async._unregister_go["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-unregister-go",this$);
}
}
}
});

superv.async._track_exception = (function superv$async$_track_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_track_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_track_exception$arity$2(this$,e);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._track_exception[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,e);
} else {
var m__10138__auto____$1 = (superv.async._track_exception["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-track-exception",this$);
}
}
}
});

superv.async._free_exception = (function superv$async$_free_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_free_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_free_exception$arity$2(this$,e);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._free_exception[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,e);
} else {
var m__10138__auto____$1 = (superv.async._free_exception["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-free-exception",this$);
}
}
}
});

superv.async.now = (function superv$async$now(){
return (new Date());
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {superv.async.PSupervisor}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
superv.async.TrackingSupervisor = (function (error,abort,registered,pending_exceptions,__meta,__extmap,__hash){
this.error = error;
this.abort = abort;
this.registered = registered;
this.pending_exceptions = pending_exceptions;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__10094__auto__,k__10095__auto__){
var self__ = this;
var this__10094__auto____$1 = this;
return this__10094__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__10095__auto__,null);
});

superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__10096__auto__,k60717,else__10097__auto__){
var self__ = this;
var this__10096__auto____$1 = this;
var G__60719 = (((k60717 instanceof cljs.core.Keyword))?k60717.fqn:null);
switch (G__60719) {
case "error":
return self__.error;

break;
case "abort":
return self__.abort;

break;
case "registered":
return self__.registered;

break;
case "pending-exceptions":
return self__.pending_exceptions;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k60717,else__10097__auto__);

}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__10108__auto__,writer__10109__auto__,opts__10110__auto__){
var self__ = this;
var this__10108__auto____$1 = this;
var pr_pair__10111__auto__ = ((function (this__10108__auto____$1){
return (function (keyval__10112__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,cljs.core.pr_writer,""," ","",opts__10110__auto__,keyval__10112__auto__);
});})(this__10108__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,pr_pair__10111__auto__,"#superv.async.TrackingSupervisor{",", ","}",opts__10110__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__60716){
var self__ = this;
var G__60716__$1 = this;
return (new cljs.core.RecordIter((0),G__60716__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__10092__auto__){
var self__ = this;
var this__10092__auto____$1 = this;
return self__.__meta;
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__10088__auto__){
var self__ = this;
var this__10088__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__10098__auto__){
var self__ = this;
var this__10098__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__10089__auto__){
var self__ = this;
var this__10089__auto____$1 = this;
var h__9861__auto__ = self__.__hash;
if(!((h__9861__auto__ == null))){
return h__9861__auto__;
} else {
var h__9861__auto____$1 = cljs.core.hash_imap.call(null,this__10089__auto____$1);
self__.__hash = h__9861__auto____$1;

return h__9861__auto____$1;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__10090__auto__,other__10091__auto__){
var self__ = this;
var this__10090__auto____$1 = this;
if(cljs.core.truth_((function (){var and__9407__auto__ = other__10091__auto__;
if(cljs.core.truth_(and__9407__auto__)){
return ((this__10090__auto____$1.constructor === other__10091__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__10090__auto____$1,other__10091__auto__));
} else {
return and__9407__auto__;
}
})())){
return true;
} else {
return false;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__10103__auto__,k__10104__auto__){
var self__ = this;
var this__10103__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),null,new cljs.core.Keyword(null,"abort","abort",521193198),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"registered","registered",-388600037),null], null), null),k__10104__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__10103__auto____$1),self__.__meta),k__10104__auto__);
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__10104__auto__)),null));
}
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_error$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.error;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.abort;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_register_go$arity$2 = (function (this$,body){
var self__ = this;
var this$__$1 = this;
var id = cljs.core.random_uuid.call(null);
cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.assoc,id,body);

return id;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_unregister_go$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.dissoc,id);
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_track_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.assoc,e,superv.async.now.call(null));
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_free_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.dissoc,e);
});

superv.async.TrackingSupervisor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__10101__auto__,k__10102__auto__,G__60716){
var self__ = this;
var this__10101__auto____$1 = this;
var pred__60720 = cljs.core.keyword_identical_QMARK_;
var expr__60721 = k__10102__auto__;
if(cljs.core.truth_(pred__60720.call(null,new cljs.core.Keyword(null,"error","error",-978969032),expr__60721))){
return (new superv.async.TrackingSupervisor(G__60716,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__60720.call(null,new cljs.core.Keyword(null,"abort","abort",521193198),expr__60721))){
return (new superv.async.TrackingSupervisor(self__.error,G__60716,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__60720.call(null,new cljs.core.Keyword(null,"registered","registered",-388600037),expr__60721))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,G__60716,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__60720.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),expr__60721))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,G__60716,self__.__meta,self__.__extmap,null));
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__10102__auto__,G__60716),null));
}
}
}
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__10106__auto__){
var self__ = this;
var this__10106__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__10093__auto__,G__60716){
var self__ = this;
var this__10093__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,G__60716,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__10099__auto__,entry__10100__auto__){
var self__ = this;
var this__10099__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__10100__auto__)){
return this__10099__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__10100__auto__,(0)),cljs.core._nth.call(null,entry__10100__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__10099__auto____$1,entry__10100__auto__);
}
});

superv.async.TrackingSupervisor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.Symbol(null,"abort","abort",-2133242571,null),new cljs.core.Symbol(null,"registered","registered",1251931490,null),new cljs.core.Symbol(null,"pending-exceptions","pending-exceptions",-247748567,null)], null);
});

superv.async.TrackingSupervisor.cljs$lang$type = true;

superv.async.TrackingSupervisor.cljs$lang$ctorPrSeq = (function (this__10130__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"superv.async/TrackingSupervisor");
});

superv.async.TrackingSupervisor.cljs$lang$ctorPrWriter = (function (this__10130__auto__,writer__10131__auto__){
return cljs.core._write.call(null,writer__10131__auto__,"superv.async/TrackingSupervisor");
});

superv.async.__GT_TrackingSupervisor = (function superv$async$__GT_TrackingSupervisor(error,abort,registered,pending_exceptions){
return (new superv.async.TrackingSupervisor(error,abort,registered,pending_exceptions,null,null,null));
});

superv.async.map__GT_TrackingSupervisor = (function superv$async$map__GT_TrackingSupervisor(G__60718){
return (new superv.async.TrackingSupervisor(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(G__60718),new cljs.core.Keyword(null,"abort","abort",521193198).cljs$core$IFn$_invoke$arity$1(G__60718),new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(G__60718),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(G__60718),null,cljs.core.dissoc.call(null,G__60718,new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)),null));
});

cljs.core.enable_console_print_BANG_.call(null);
/**
 * A simple supervisor which deals with errors through callbacks. You need to
 *   close its abort channel manually if you want the context to stop. It is
 *   supposed to be used at a boundary to an unsupervised system. If you want
 *   strong supervision, use the restarting-supervisor instead.
 */
superv.async.simple_supervisor = (function superv$async$simple_supervisor(var_args){
var args__10647__auto__ = [];
var len__10640__auto___60748 = arguments.length;
var i__10641__auto___60749 = (0);
while(true){
if((i__10641__auto___60749 < len__10640__auto___60748)){
args__10647__auto__.push((arguments[i__10641__auto___60749]));

var G__60750 = (i__10641__auto___60749 + (1));
i__10641__auto___60749 = G__60750;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((0) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((0)),(0),null)):null);
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(argseq__10648__auto__);
});

superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (p__60725){
var map__60726 = p__60725;
var map__60726__$1 = ((((!((map__60726 == null)))?((((map__60726.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__60726.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__60726):map__60726);
var stale_timeout = cljs.core.get.call(null,map__60726__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((10) * (1000)));
var error_fn = cljs.core.get.call(null,map__60726__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),((function (map__60726,map__60726__$1,stale_timeout){
return (function (e){
return cljs.core.println.call(null,"Supervisor:",e,e.stack);
});})(map__60726,map__60726__$1,stale_timeout))
);
var pending_fn = cljs.core.get.call(null,map__60726__$1,new cljs.core.Keyword(null,"pending-fn","pending-fn",1734381755));
var s = superv.async.map__GT_TrackingSupervisor.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"abort","abort",521193198),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"registered","registered",-388600037),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null));
var err_ch = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(s);
cljs.core.async.take_BANG_.call(null,err_ch,((function (s,err_ch,map__60726,map__60726__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$loop_fn(e){
error_fn.call(null,e);

return cljs.core.async.take_BANG_.call(null,err_ch,superv$async$loop_fn);
});})(s,err_ch,map__60726,map__60726__$1,stale_timeout,error_fn,pending_fn))
);

((function (s,err_ch,map__60726,map__60726__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$pending(_){
var vec__60738 = cljs.core.filter.call(null,((function (s,err_ch,map__60726,map__60726__$1,stale_timeout,error_fn,pending_fn){
return (function (p__60744){
var vec__60745 = p__60744;
var k = cljs.core.nth.call(null,vec__60745,(0),null);
var v = cljs.core.nth.call(null,vec__60745,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout) > v.getTime());
});})(s,err_ch,map__60726,map__60726__$1,stale_timeout,error_fn,pending_fn))
,cljs.core.deref.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s)));
var vec__60741 = cljs.core.nth.call(null,vec__60738,(0),null);
var e = cljs.core.nth.call(null,vec__60741,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__60741,(1),null);
if(cljs.core.truth_(e)){
error_fn.call(null,e);

superv.async._free_exception.call(null,s,e);
} else {
}

return cljs.core.async.take_BANG_.call(null,cljs.core.async.timeout.call(null,stale_timeout),superv$async$pending);
});})(s,err_ch,map__60726,map__60726__$1,stale_timeout,error_fn,pending_fn))
.call(null,null);

return s;
});

superv.async.simple_supervisor.cljs$lang$maxFixedArity = (0);

superv.async.simple_supervisor.cljs$lang$applyTo = (function (seq60724){
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq60724));
});

superv.async.S = superv.async.simple_supervisor.call(null);
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
superv.async.throw_if_exception = (function superv$async$throw_if_exception(S,x){
if((x instanceof Error)){
superv.async._free_exception.call(null,S,x);

throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),(function (){var or__9419__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
superv.async.superv_init = (function superv$async$superv_init(){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [superv.async._error,superv.async._abort,superv.async._register_go,superv.async._unregister_go,superv.async._track_exception,superv.async._free_exception,superv.async.throw_if_exception], null);
});
goog.exportSymbol('superv.async.superv_init', superv.async.superv_init);
superv.async.superv_init.call(null);
superv.async.supervisor_QMARK_ = (function superv$async$supervisor_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.superv$async$PSupervisor$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
}
});
superv.async.check_supervisor = (function superv$async$check_supervisor(x){
if(cljs.core.truth_(superv.async.supervisor_QMARK_.call(null,x))){
return null;
} else {
throw cljs.core.ex_info.call(null,"First argument is not a supervisor.",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"argument","argument",1183001841),x], null));
}
});
/**
 * Here until http://dev.clojure.org/jira/browse/ASYNC-74 is resolved.
 */
superv.async.chan_QMARK_ = (function superv$async$chan_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$ReadPort$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
}
});
/**
 * Same as core.async/take!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.take_QMARK_ = (function superv$async$take_QMARK_(var_args){
var args60768 = [];
var len__10640__auto___60771 = arguments.length;
var i__10641__auto___60772 = (0);
while(true){
if((i__10641__auto___60772 < len__10640__auto___60771)){
args60768.push((arguments[i__10641__auto___60772]));

var G__60773 = (i__10641__auto___60772 + (1));
i__10641__auto___60772 = G__60773;
continue;
} else {
}
break;
}

var G__60770 = args60768.length;
switch (G__60770) {
case 3:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60768.length)].join('')));

}
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,fn1){
return superv.async.take_QMARK_.call(null,S,port,fn1,true);
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,fn1,on_caller_QMARK_){
return cljs.core.async.take_BANG_.call(null,port,(function (v){
if((v instanceof Error)){
superv.async._free_exception.call(null,S,v);
} else {
}

return fn1.call(null,v);
}),on_caller_QMARK_);
});

superv.async.take_QMARK_.cljs$lang$maxFixedArity = 4;

/**
 * Same as core.async/put!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.put_QMARK_ = (function superv$async$put_QMARK_(var_args){
var args60775 = [];
var len__10640__auto___60778 = arguments.length;
var i__10641__auto___60779 = (0);
while(true){
if((i__10641__auto___60779 < len__10640__auto___60778)){
args60775.push((arguments[i__10641__auto___60779]));

var G__60780 = (i__10641__auto___60779 + (1));
i__10641__auto___60779 = G__60780;
continue;
} else {
}
break;
}

var G__60777 = args60775.length;
switch (G__60777) {
case 3:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60775.length)].join('')));

}
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,val){
return superv.async.put_QMARK_.call(null,S,port,val,(function superv$async$noop(_){
return null;
}));
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,val,fn1){
return superv.async.put_QMARK_.call(null,S,port,val,fn1,true);
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5 = (function (S,port,val,fn1,on_caller_QMARK_){
return cljs.core.async.put_BANG_.call(null,port,val,(function (ret){
if(((val instanceof Error)) && (!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,val)),new cljs.core.Keyword(null,"aborted","aborted",1775972619))))){
superv.async._track_exception.call(null,S,val);
} else {
}

return fn1.call(null,ret);
}),on_caller_QMARK_);
});

superv.async.put_QMARK_.cljs$lang$maxFixedArity = 5;

/**
 * Takes objects from in-ch, asynchrously applies function f> (function should
 *   return a channel), takes the result from the returned channel and if it's
 *   truthy, puts it in the out-ch. Returns the closed out-ch. Closes the
 *   returned channel when the input channel has been completely consumed and all
 *   objects have been processed.
 *   If out-ch is not provided, an unbuffered one will be used.
 */
superv.async.pmap_GT__GT_ = (function superv$async$pmap_GT__GT_(var_args){
var args60793 = [];
var len__10640__auto___60996 = arguments.length;
var i__10641__auto___60997 = (0);
while(true){
if((i__10641__auto___60997 < len__10640__auto___60996)){
args60793.push((arguments[i__10641__auto___60997]));

var G__60998 = (i__10641__auto___60997 + (1));
i__10641__auto___60997 = G__60998;
continue;
} else {
}
break;
}

var G__60795 = args60793.length;
switch (G__60795) {
case 4:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60793.length)].join('')));

}
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4 = (function (S,f_GT_,parallelism,in_ch){
return superv.async.pmap_GT__GT_.call(null,S,f_GT_,parallelism,cljs.core.async.chan.call(null),in_ch);
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5 = (function (S,f_GT_,parallelism,out_ch,in_ch){
if(cljs.core.fn_QMARK_.call(null,f_GT_)){
} else {
throw (new Error("Assert failed: (fn? f>)"));
}

if((cljs.core.integer_QMARK_.call(null,parallelism)) && ((parallelism > (0)))){
} else {
throw (new Error("Assert failed: (and (integer? parallelism) (pos? parallelism))"));
}

if((in_ch instanceof cljs.core.async.impl.protocols.ReadPort)){
} else {
throw (new Error("Assert failed: (instance? ReadPort in-ch)"));
}

var threads = cljs.core.atom.call(null,parallelism);
var n__10440__auto___61000 = parallelism;
var __61001 = (0);
while(true){
if((__61001 < n__10440__auto___61000)){
var c__23767__auto___61002 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___61003 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"result","result",-1239343558,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)))], null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null)))))),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"zero?","zero?",325758897,null),cljs.core.list(new cljs.core.Symbol(null,"swap!","swap!",-655677516,null),new cljs.core.Symbol(null,"threads","threads",-77267207,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))));
var c__38457__auto___61004 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__61001,c__38457__auto___61004,c__23767__auto___61002,id__23768__auto___61003,n__10440__auto___61000,threads){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (__61001,c__38457__auto___61004,c__23767__auto___61002,id__23768__auto___61003,n__10440__auto___61000,threads){
return (function (state_60930){
var state_val_60931 = (state_60930[(1)]);
if((state_val_60931 === (7))){
var inst_60799 = (state_60930[(7)]);
var inst_60807 = (state_60930[(2)]);
var state_60930__$1 = (function (){var statearr_60932 = state_60930;
(statearr_60932[(8)] = inst_60807);

return statearr_60932;
})();
var statearr_60933_61005 = state_60930__$1;
(statearr_60933_61005[(2)] = inst_60799);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60930__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (20))){
var inst_60914 = (state_60930[(2)]);
var state_60930__$1 = state_60930;
var statearr_60934_61006 = state_60930__$1;
(statearr_60934_61006[(2)] = inst_60914);

(statearr_60934_61006[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (27))){
var inst_60876 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_60877 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_60878 = cljs.core.PersistentHashMap.fromArrays(inst_60876,inst_60877);
var inst_60879 = cljs.core.ex_info.call(null,"Aborted operations",inst_60878);
var state_60930__$1 = state_60930;
var statearr_60935_61007 = state_60930__$1;
(statearr_60935_61007[(2)] = inst_60879);

(statearr_60935_61007[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (1))){
var state_60930__$1 = state_60930;
var statearr_60936_61008 = state_60930__$1;
(statearr_60936_61008[(2)] = null);

(statearr_60936_61008[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (24))){
var inst_60858 = (state_60930[(2)]);
var inst_60859 = superv.async.throw_if_exception.call(null,S,inst_60858);
var inst_60860 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_60930__$1 = (function (){var statearr_60937 = state_60930;
(statearr_60937[(9)] = inst_60859);

return statearr_60937;
})();
var statearr_60938_61009 = state_60930__$1;
(statearr_60938_61009[(2)] = inst_60860);

(statearr_60938_61009[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (39))){
var state_60930__$1 = state_60930;
var statearr_60939_61010 = state_60930__$1;
(statearr_60939_61010[(2)] = null);

(statearr_60939_61010[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (4))){
var inst_60799 = (state_60930[(7)]);
var inst_60799__$1 = (state_60930[(2)]);
var inst_60800 = cljs.core.ex_data.call(null,inst_60799__$1);
var inst_60801 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_60800);
var inst_60802 = cljs.core._EQ_.call(null,inst_60801,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_60930__$1 = (function (){var statearr_60940 = state_60930;
(statearr_60940[(7)] = inst_60799__$1);

return statearr_60940;
})();
if(inst_60802){
var statearr_60941_61011 = state_60930__$1;
(statearr_60941_61011[(1)] = (5));

} else {
var statearr_60942_61012 = state_60930__$1;
(statearr_60942_61012[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (15))){
var inst_60832 = (state_60930[(10)]);
var inst_60834 = (inst_60832 instanceof Error);
var state_60930__$1 = state_60930;
if(cljs.core.truth_(inst_60834)){
var statearr_60943_61013 = state_60930__$1;
(statearr_60943_61013[(1)] = (18));

} else {
var statearr_60944_61014 = state_60930__$1;
(statearr_60944_61014[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (21))){
var inst_60839 = (state_60930[(11)]);
var inst_60845 = (state_60930[(2)]);
var inst_60846 = cljs.core.nth.call(null,inst_60845,(0),null);
var inst_60847 = cljs.core.nth.call(null,inst_60845,(1),null);
var inst_60848 = cljs.core._EQ_.call(null,inst_60847,inst_60839);
var state_60930__$1 = (function (){var statearr_60945 = state_60930;
(statearr_60945[(12)] = inst_60846);

return statearr_60945;
})();
if(inst_60848){
var statearr_60946_61015 = state_60930__$1;
(statearr_60946_61015[(1)] = (22));

} else {
var statearr_60947_61016 = state_60930__$1;
(statearr_60947_61016[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (31))){
var state_60930__$1 = state_60930;
var statearr_60948_61017 = state_60930__$1;
(statearr_60948_61017[(2)] = null);

(statearr_60948_61017[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (32))){
var inst_60911 = (state_60930[(2)]);
var state_60930__$1 = (function (){var statearr_60949 = state_60930;
(statearr_60949[(13)] = inst_60911);

return statearr_60949;
})();
var statearr_60950_61018 = state_60930__$1;
(statearr_60950_61018[(2)] = null);

(statearr_60950_61018[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (40))){
var inst_60926 = (state_60930[(2)]);
var state_60930__$1 = state_60930;
var statearr_60951_61019 = state_60930__$1;
(statearr_60951_61019[(2)] = inst_60926);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60930__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (33))){
var inst_60888 = (state_60930[(14)]);
var inst_60894 = (state_60930[(2)]);
var inst_60895 = cljs.core.nth.call(null,inst_60894,(0),null);
var inst_60896 = cljs.core.nth.call(null,inst_60894,(1),null);
var inst_60897 = cljs.core._EQ_.call(null,inst_60896,inst_60888);
var state_60930__$1 = (function (){var statearr_60952 = state_60930;
(statearr_60952[(15)] = inst_60895);

return statearr_60952;
})();
if(inst_60897){
var statearr_60953_61020 = state_60930__$1;
(statearr_60953_61020[(1)] = (34));

} else {
var statearr_60954_61021 = state_60930__$1;
(statearr_60954_61021[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (13))){
var inst_60821 = (state_60930[(16)]);
var state_60930__$1 = state_60930;
var statearr_60955_61022 = state_60930__$1;
(statearr_60955_61022[(2)] = inst_60821);

(statearr_60955_61022[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (22))){
var inst_60850 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_60851 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_60852 = cljs.core.PersistentHashMap.fromArrays(inst_60850,inst_60851);
var inst_60853 = cljs.core.ex_info.call(null,"Aborted operations",inst_60852);
var state_60930__$1 = state_60930;
var statearr_60956_61023 = state_60930__$1;
(statearr_60956_61023[(2)] = inst_60853);

(statearr_60956_61023[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (36))){
var inst_60907 = (state_60930[(2)]);
var inst_60908 = superv.async.throw_if_exception.call(null,S,inst_60907);
var state_60930__$1 = state_60930;
var statearr_60957_61024 = state_60930__$1;
(statearr_60957_61024[(2)] = inst_60908);

(statearr_60957_61024[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (29))){
var inst_60883 = (state_60930[(17)]);
var inst_60882 = (state_60930[(2)]);
var inst_60883__$1 = superv.async.throw_if_exception.call(null,S,inst_60882);
var state_60930__$1 = (function (){var statearr_60958 = state_60930;
(statearr_60958[(17)] = inst_60883__$1);

return statearr_60958;
})();
if(cljs.core.truth_(inst_60883__$1)){
var statearr_60959_61025 = state_60930__$1;
(statearr_60959_61025[(1)] = (30));

} else {
var statearr_60960_61026 = state_60930__$1;
(statearr_60960_61026[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (6))){
var inst_60799 = (state_60930[(7)]);
var inst_60805 = superv.async._track_exception.call(null,S,inst_60799);
var state_60930__$1 = state_60930;
var statearr_60961_61027 = state_60930__$1;
(statearr_60961_61027[(2)] = inst_60805);

(statearr_60961_61027[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (28))){
var inst_60872 = (state_60930[(18)]);
var state_60930__$1 = state_60930;
var statearr_60962_61028 = state_60930__$1;
(statearr_60962_61028[(2)] = inst_60872);

(statearr_60962_61028[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (25))){
var inst_60856 = (state_60930[(2)]);
var state_60930__$1 = state_60930;
var statearr_60963_61029 = state_60930__$1;
(statearr_60963_61029[(2)] = inst_60856);

(statearr_60963_61029[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (34))){
var inst_60899 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_60900 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_60901 = cljs.core.PersistentHashMap.fromArrays(inst_60899,inst_60900);
var inst_60902 = cljs.core.ex_info.call(null,"Aborted operations",inst_60901);
var state_60930__$1 = state_60930;
var statearr_60964_61030 = state_60930__$1;
(statearr_60964_61030[(2)] = inst_60902);

(statearr_60964_61030[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (17))){
var inst_60917 = (state_60930[(2)]);
var state_60930__$1 = state_60930;
var statearr_60965_61031 = state_60930__$1;
(statearr_60965_61031[(2)] = inst_60917);

(statearr_60965_61031[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (3))){
var inst_60796 = (state_60930[(2)]);
var inst_60797 = superv.async._unregister_go.call(null,S,id__23768__auto___61003);
var state_60930__$1 = (function (){var statearr_60966 = state_60930;
(statearr_60966[(19)] = inst_60797);

(statearr_60966[(20)] = inst_60796);

return statearr_60966;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60930__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (12))){
var inst_60825 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_60826 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_60827 = cljs.core.PersistentHashMap.fromArrays(inst_60825,inst_60826);
var inst_60828 = cljs.core.ex_info.call(null,"Aborted operations",inst_60827);
var state_60930__$1 = state_60930;
var statearr_60967_61032 = state_60930__$1;
(statearr_60967_61032[(2)] = inst_60828);

(statearr_60967_61032[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (2))){
var inst_60928 = (state_60930[(2)]);
var state_60930__$1 = state_60930;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60930__$1,inst_60928);
} else {
if((state_val_60931 === (23))){
var inst_60832 = (state_60930[(10)]);
var state_60930__$1 = state_60930;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60930__$1,(25),out_ch,inst_60832);
} else {
if((state_val_60931 === (35))){
var inst_60883 = (state_60930[(17)]);
var state_60930__$1 = state_60930;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60930__$1,(37),out_ch,inst_60883);
} else {
if((state_val_60931 === (19))){
var inst_60832 = (state_60930[(10)]);
var inst_60865 = (state_60930[(21)]);
var inst_60865__$1 = superv.async._abort.call(null,S);
var inst_60866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60867 = f_GT_.call(null,inst_60832);
var inst_60868 = [inst_60865__$1,inst_60867];
var inst_60869 = (new cljs.core.PersistentVector(null,2,(5),inst_60866,inst_60868,null));
var state_60930__$1 = (function (){var statearr_60968 = state_60930;
(statearr_60968[(21)] = inst_60865__$1);

return statearr_60968;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_60930__$1,(26),inst_60869,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_60931 === (11))){
var inst_60815 = (state_60930[(22)]);
var inst_60820 = (state_60930[(2)]);
var inst_60821 = cljs.core.nth.call(null,inst_60820,(0),null);
var inst_60822 = cljs.core.nth.call(null,inst_60820,(1),null);
var inst_60823 = cljs.core._EQ_.call(null,inst_60822,inst_60815);
var state_60930__$1 = (function (){var statearr_60969 = state_60930;
(statearr_60969[(16)] = inst_60821);

return statearr_60969;
})();
if(inst_60823){
var statearr_60970_61033 = state_60930__$1;
(statearr_60970_61033[(1)] = (12));

} else {
var statearr_60971_61034 = state_60930__$1;
(statearr_60971_61034[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (9))){
var inst_60815 = (state_60930[(22)]);
var inst_60815__$1 = superv.async._abort.call(null,S);
var inst_60816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60817 = [inst_60815__$1,in_ch];
var inst_60818 = (new cljs.core.PersistentVector(null,2,(5),inst_60816,inst_60817,null));
var state_60930__$1 = (function (){var statearr_60972 = state_60930;
(statearr_60972[(22)] = inst_60815__$1);

return statearr_60972;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_60930__$1,(11),inst_60818,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_60931 === (5))){
var state_60930__$1 = state_60930;
var statearr_60973_61035 = state_60930__$1;
(statearr_60973_61035[(2)] = null);

(statearr_60973_61035[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (14))){
var inst_60832 = (state_60930[(10)]);
var inst_60831 = (state_60930[(2)]);
var inst_60832__$1 = superv.async.throw_if_exception.call(null,S,inst_60831);
var state_60930__$1 = (function (){var statearr_60974 = state_60930;
(statearr_60974[(10)] = inst_60832__$1);

return statearr_60974;
})();
if(cljs.core.truth_(inst_60832__$1)){
var statearr_60975_61036 = state_60930__$1;
(statearr_60975_61036[(1)] = (15));

} else {
var statearr_60976_61037 = state_60930__$1;
(statearr_60976_61037[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (26))){
var inst_60865 = (state_60930[(21)]);
var inst_60871 = (state_60930[(2)]);
var inst_60872 = cljs.core.nth.call(null,inst_60871,(0),null);
var inst_60873 = cljs.core.nth.call(null,inst_60871,(1),null);
var inst_60874 = cljs.core._EQ_.call(null,inst_60873,inst_60865);
var state_60930__$1 = (function (){var statearr_60977 = state_60930;
(statearr_60977[(18)] = inst_60872);

return statearr_60977;
})();
if(inst_60874){
var statearr_60978_61038 = state_60930__$1;
(statearr_60978_61038[(1)] = (27));

} else {
var statearr_60979_61039 = state_60930__$1;
(statearr_60979_61039[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (16))){
var state_60930__$1 = state_60930;
var statearr_60980_61040 = state_60930__$1;
(statearr_60980_61040[(2)] = null);

(statearr_60980_61040[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (38))){
var inst_60923 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_60930__$1 = state_60930;
var statearr_60981_61041 = state_60930__$1;
(statearr_60981_61041[(2)] = inst_60923);

(statearr_60981_61041[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (30))){
var inst_60888 = (state_60930[(14)]);
var inst_60888__$1 = superv.async._abort.call(null,S);
var inst_60889 = cljs.core.async.timeout.call(null,(0));
var inst_60890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60891 = [inst_60888__$1,inst_60889];
var inst_60892 = (new cljs.core.PersistentVector(null,2,(5),inst_60890,inst_60891,null));
var state_60930__$1 = (function (){var statearr_60982 = state_60930;
(statearr_60982[(14)] = inst_60888__$1);

return statearr_60982;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_60930__$1,(33),inst_60892,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_60931 === (10))){
var inst_60919 = (state_60930[(2)]);
var inst_60920 = cljs.core.swap_BANG_.call(null,threads,cljs.core.dec);
var inst_60921 = (inst_60920 === (0));
var state_60930__$1 = (function (){var statearr_60983 = state_60930;
(statearr_60983[(23)] = inst_60919);

return statearr_60983;
})();
if(cljs.core.truth_(inst_60921)){
var statearr_60984_61042 = state_60930__$1;
(statearr_60984_61042[(1)] = (38));

} else {
var statearr_60985_61043 = state_60930__$1;
(statearr_60985_61043[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (18))){
var inst_60839 = (state_60930[(11)]);
var inst_60839__$1 = superv.async._abort.call(null,S);
var inst_60840 = cljs.core.async.timeout.call(null,(0));
var inst_60841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60842 = [inst_60839__$1,inst_60840];
var inst_60843 = (new cljs.core.PersistentVector(null,2,(5),inst_60841,inst_60842,null));
var state_60930__$1 = (function (){var statearr_60986 = state_60930;
(statearr_60986[(11)] = inst_60839__$1);

return statearr_60986;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_60930__$1,(21),inst_60843,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_60931 === (37))){
var inst_60905 = (state_60930[(2)]);
var state_60930__$1 = state_60930;
var statearr_60987_61044 = state_60930__$1;
(statearr_60987_61044[(2)] = inst_60905);

(statearr_60987_61044[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60931 === (8))){
var ___$1 = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_60930,(4),Error,(3),(2));
var state_60930__$1 = state_60930;
var statearr_60988_61045 = state_60930__$1;
(statearr_60988_61045[(2)] = null);

(statearr_60988_61045[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(__61001,c__38457__auto___61004,c__23767__auto___61002,id__23768__auto___61003,n__10440__auto___61000,threads))
;
return ((function (__61001,switch__38343__auto__,c__38457__auto___61004,c__23767__auto___61002,id__23768__auto___61003,n__10440__auto___61000,threads){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_60992 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60992[(0)] = superv$async$state_machine__38344__auto__);

(statearr_60992[(1)] = (1));

return statearr_60992;
});
var superv$async$state_machine__38344__auto____1 = (function (state_60930){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_60930);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e60993){if((e60993 instanceof Object)){
var ex__38347__auto__ = e60993;
var statearr_60994_61046 = state_60930;
(statearr_60994_61046[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60930);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60993;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61047 = state_60930;
state_60930 = G__61047;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_60930){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_60930);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(__61001,switch__38343__auto__,c__38457__auto___61004,c__23767__auto___61002,id__23768__auto___61003,n__10440__auto___61000,threads))
})();
var state__38459__auto__ = (function (){var statearr_60995 = f__38458__auto__.call(null);
(statearr_60995[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___61004);

return statearr_60995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(__61001,c__38457__auto___61004,c__23767__auto___61002,id__23768__auto___61003,n__10440__auto___61000,threads))
);


var G__61048 = (__61001 + (1));
__61001 = G__61048;
continue;
} else {
}
break;
}

return out_ch;
});

superv.async.pmap_GT__GT_.cljs$lang$maxFixedArity = 5;

/**
 * Similiar to dorun. Simply takes messages from channels but does nothing with
 *   them. Returns channel that will close when all messages have been consumed.
 */
superv.async.engulf = (function superv$async$engulf(var_args){
var args__10647__auto__ = [];
var len__10640__auto___61129 = arguments.length;
var i__10641__auto___61130 = (0);
while(true){
if((i__10641__auto___61130 < len__10640__auto___61129)){
args__10647__auto__.push((arguments[i__10641__auto___61130]));

var G__61131 = (i__10641__auto___61130 + (1));
i__10641__auto___61130 = G__61131;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var ch = cljs.core.async.merge.call(null,cs);
var c__23767__auto__ = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto__ = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null))))));
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__,c__23767__auto__,id__23768__auto__,ch){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__,c__23767__auto__,id__23768__auto__,ch){
return (function (state_61098){
var state_val_61099 = (state_61098[(1)]);
if((state_val_61099 === (7))){
var inst_61054 = (state_61098[(7)]);
var inst_61062 = (state_61098[(2)]);
var state_61098__$1 = (function (){var statearr_61100 = state_61098;
(statearr_61100[(8)] = inst_61062);

return statearr_61100;
})();
var statearr_61101_61132 = state_61098__$1;
(statearr_61101_61132[(2)] = inst_61054);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61098__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61099 === (1))){
var state_61098__$1 = state_61098;
var statearr_61102_61133 = state_61098__$1;
(statearr_61102_61133[(2)] = null);

(statearr_61102_61133[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61099 === (4))){
var inst_61054 = (state_61098[(7)]);
var inst_61054__$1 = (state_61098[(2)]);
var inst_61055 = cljs.core.ex_data.call(null,inst_61054__$1);
var inst_61056 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_61055);
var inst_61057 = cljs.core._EQ_.call(null,inst_61056,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_61098__$1 = (function (){var statearr_61103 = state_61098;
(statearr_61103[(7)] = inst_61054__$1);

return statearr_61103;
})();
if(inst_61057){
var statearr_61104_61134 = state_61098__$1;
(statearr_61104_61134[(1)] = (5));

} else {
var statearr_61105_61135 = state_61098__$1;
(statearr_61105_61135[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61099 === (15))){
var state_61098__$1 = state_61098;
var statearr_61106_61136 = state_61098__$1;
(statearr_61106_61136[(2)] = null);

(statearr_61106_61136[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61099 === (13))){
var inst_61076 = (state_61098[(9)]);
var state_61098__$1 = state_61098;
var statearr_61107_61137 = state_61098__$1;
(statearr_61107_61137[(2)] = inst_61076);

(statearr_61107_61137[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61099 === (6))){
var inst_61054 = (state_61098[(7)]);
var inst_61060 = superv.async._track_exception.call(null,S,inst_61054);
var state_61098__$1 = state_61098;
var statearr_61108_61138 = state_61098__$1;
(statearr_61108_61138[(2)] = inst_61060);

(statearr_61108_61138[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61099 === (17))){
var inst_61092 = (state_61098[(2)]);
var state_61098__$1 = state_61098;
var statearr_61109_61139 = state_61098__$1;
(statearr_61109_61139[(2)] = inst_61092);

(statearr_61109_61139[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61099 === (3))){
var inst_61051 = (state_61098[(2)]);
var inst_61052 = superv.async._unregister_go.call(null,S,id__23768__auto__);
var state_61098__$1 = (function (){var statearr_61110 = state_61098;
(statearr_61110[(10)] = inst_61052);

(statearr_61110[(11)] = inst_61051);

return statearr_61110;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61098__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61099 === (12))){
var inst_61080 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61081 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61082 = cljs.core.PersistentHashMap.fromArrays(inst_61080,inst_61081);
var inst_61083 = cljs.core.ex_info.call(null,"Aborted operations",inst_61082);
var state_61098__$1 = state_61098;
var statearr_61111_61140 = state_61098__$1;
(statearr_61111_61140[(2)] = inst_61083);

(statearr_61111_61140[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61099 === (2))){
var inst_61096 = (state_61098[(2)]);
var state_61098__$1 = state_61098;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61098__$1,inst_61096);
} else {
if((state_val_61099 === (11))){
var inst_61070 = (state_61098[(12)]);
var inst_61075 = (state_61098[(2)]);
var inst_61076 = cljs.core.nth.call(null,inst_61075,(0),null);
var inst_61077 = cljs.core.nth.call(null,inst_61075,(1),null);
var inst_61078 = cljs.core._EQ_.call(null,inst_61077,inst_61070);
var state_61098__$1 = (function (){var statearr_61112 = state_61098;
(statearr_61112[(9)] = inst_61076);

return statearr_61112;
})();
if(inst_61078){
var statearr_61113_61141 = state_61098__$1;
(statearr_61113_61141[(1)] = (12));

} else {
var statearr_61114_61142 = state_61098__$1;
(statearr_61114_61142[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61099 === (9))){
var inst_61070 = (state_61098[(12)]);
var inst_61070__$1 = superv.async._abort.call(null,S);
var inst_61071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61072 = [inst_61070__$1,ch];
var inst_61073 = (new cljs.core.PersistentVector(null,2,(5),inst_61071,inst_61072,null));
var state_61098__$1 = (function (){var statearr_61115 = state_61098;
(statearr_61115[(12)] = inst_61070__$1);

return statearr_61115;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61098__$1,(11),inst_61073,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_61099 === (5))){
var state_61098__$1 = state_61098;
var statearr_61116_61143 = state_61098__$1;
(statearr_61116_61143[(2)] = null);

(statearr_61116_61143[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61099 === (14))){
var inst_61086 = (state_61098[(2)]);
var inst_61087 = superv.async.throw_if_exception.call(null,S,inst_61086);
var state_61098__$1 = state_61098;
if(cljs.core.truth_(inst_61087)){
var statearr_61117_61144 = state_61098__$1;
(statearr_61117_61144[(1)] = (15));

} else {
var statearr_61118_61145 = state_61098__$1;
(statearr_61118_61145[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61099 === (16))){
var state_61098__$1 = state_61098;
var statearr_61119_61146 = state_61098__$1;
(statearr_61119_61146[(2)] = null);

(statearr_61119_61146[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61099 === (10))){
var inst_61094 = (state_61098[(2)]);
var state_61098__$1 = state_61098;
var statearr_61120_61147 = state_61098__$1;
(statearr_61120_61147[(2)] = inst_61094);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61098__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61099 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_61098,(4),Error,(3),(2));
var state_61098__$1 = state_61098;
var statearr_61121_61148 = state_61098__$1;
(statearr_61121_61148[(2)] = null);

(statearr_61121_61148[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto__,c__23767__auto__,id__23768__auto__,ch))
;
return ((function (switch__38343__auto__,c__38457__auto__,c__23767__auto__,id__23768__auto__,ch){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_61125 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61125[(0)] = superv$async$state_machine__38344__auto__);

(statearr_61125[(1)] = (1));

return statearr_61125;
});
var superv$async$state_machine__38344__auto____1 = (function (state_61098){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_61098);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e61126){if((e61126 instanceof Object)){
var ex__38347__auto__ = e61126;
var statearr_61127_61149 = state_61098;
(statearr_61127_61149[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61098);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e61126;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61150 = state_61098;
state_61098 = G__61150;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_61098){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_61098);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__,c__23767__auto__,id__23768__auto__,ch))
})();
var state__38459__auto__ = (function (){var statearr_61128 = f__38458__auto__.call(null);
(statearr_61128[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_61128;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__,c__23767__auto__,id__23768__auto__,ch))
);

return c__38457__auto__;
});

superv.async.engulf.cljs$lang$maxFixedArity = (1);

superv.async.engulf.cljs$lang$applyTo = (function (seq61049){
var G__61050 = cljs.core.first.call(null,seq61049);
var seq61049__$1 = cljs.core.next.call(null,seq61049);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic(G__61050,seq61049__$1);
});

/**
 * Performs a reduce on objects from ch with the function f> (which
 *   should return a channel). Returns a channel with the resulting
 *   value.
 */
superv.async.reduce_GT_ = (function superv$async$reduce_GT_(S,f_GT_,acc,ch){
var result = cljs.core.async.chan.call(null);
var c__23767__auto___61517 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___61518 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"->>","->>",-1874332161,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null)),new cljs.core.Symbol(null,"recur","recur",1202958259,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null)))))));
var c__38457__auto___61519 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___61519,c__23767__auto___61517,id__23768__auto___61518,result){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___61519,c__23767__auto___61517,id__23768__auto___61518,result){
return (function (state_61459){
var state_val_61460 = (state_61459[(1)]);
if((state_val_61460 === (7))){
var inst_61337 = (state_61459[(7)]);
var inst_61345 = (state_61459[(2)]);
var state_61459__$1 = (function (){var statearr_61461 = state_61459;
(statearr_61461[(8)] = inst_61345);

return statearr_61461;
})();
var statearr_61462_61520 = state_61459__$1;
(statearr_61462_61520[(2)] = inst_61337);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61459__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (20))){
var inst_61425 = (state_61459[(2)]);
var state_61459__$1 = state_61459;
var statearr_61463_61521 = state_61459__$1;
(statearr_61463_61521[(2)] = inst_61425);

(statearr_61463_61521[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (27))){
var inst_61415 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61416 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61417 = cljs.core.PersistentHashMap.fromArrays(inst_61415,inst_61416);
var inst_61418 = cljs.core.ex_info.call(null,"Aborted operations",inst_61417);
var state_61459__$1 = state_61459;
var statearr_61464_61522 = state_61459__$1;
(statearr_61464_61522[(2)] = inst_61418);

(statearr_61464_61522[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (1))){
var state_61459__$1 = state_61459;
var statearr_61465_61523 = state_61459__$1;
(statearr_61465_61523[(2)] = null);

(statearr_61465_61523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (24))){
var inst_61397 = (state_61459[(2)]);
var inst_61398 = superv.async.throw_if_exception.call(null,S,inst_61397);
var inst_61399 = cljs.core.async.close_BANG_.call(null,result);
var state_61459__$1 = (function (){var statearr_61466 = state_61459;
(statearr_61466[(9)] = inst_61398);

return statearr_61466;
})();
var statearr_61467_61524 = state_61459__$1;
(statearr_61467_61524[(2)] = inst_61399);

(statearr_61467_61524[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (4))){
var inst_61337 = (state_61459[(7)]);
var inst_61337__$1 = (state_61459[(2)]);
var inst_61338 = cljs.core.ex_data.call(null,inst_61337__$1);
var inst_61339 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_61338);
var inst_61340 = cljs.core._EQ_.call(null,inst_61339,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_61459__$1 = (function (){var statearr_61468 = state_61459;
(statearr_61468[(7)] = inst_61337__$1);

return statearr_61468;
})();
if(inst_61340){
var statearr_61469_61525 = state_61459__$1;
(statearr_61469_61525[(1)] = (5));

} else {
var statearr_61470_61526 = state_61459__$1;
(statearr_61470_61526[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (15))){
var inst_61371 = (state_61459[(10)]);
var inst_61373 = (inst_61371 instanceof Error);
var state_61459__$1 = state_61459;
if(cljs.core.truth_(inst_61373)){
var statearr_61471_61527 = state_61459__$1;
(statearr_61471_61527[(1)] = (18));

} else {
var statearr_61472_61528 = state_61459__$1;
(statearr_61472_61528[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (21))){
var inst_61378 = (state_61459[(11)]);
var inst_61384 = (state_61459[(2)]);
var inst_61385 = cljs.core.nth.call(null,inst_61384,(0),null);
var inst_61386 = cljs.core.nth.call(null,inst_61384,(1),null);
var inst_61387 = cljs.core._EQ_.call(null,inst_61386,inst_61378);
var state_61459__$1 = (function (){var statearr_61473 = state_61459;
(statearr_61473[(12)] = inst_61385);

return statearr_61473;
})();
if(inst_61387){
var statearr_61474_61529 = state_61459__$1;
(statearr_61474_61529[(1)] = (22));

} else {
var statearr_61475_61530 = state_61459__$1;
(statearr_61475_61530[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (31))){
var inst_61441 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61442 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61443 = cljs.core.PersistentHashMap.fromArrays(inst_61441,inst_61442);
var inst_61444 = cljs.core.ex_info.call(null,"Aborted operations",inst_61443);
var state_61459__$1 = state_61459;
var statearr_61476_61531 = state_61459__$1;
(statearr_61476_61531[(2)] = inst_61444);

(statearr_61476_61531[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (32))){
var inst_61349 = (state_61459[(13)]);
var state_61459__$1 = state_61459;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_61459__$1,(34),result,inst_61349);
} else {
if((state_val_61460 === (33))){
var inst_61449 = (state_61459[(2)]);
var inst_61450 = superv.async.throw_if_exception.call(null,S,inst_61449);
var inst_61451 = cljs.core.async.close_BANG_.call(null,result);
var state_61459__$1 = (function (){var statearr_61477 = state_61459;
(statearr_61477[(14)] = inst_61450);

return statearr_61477;
})();
var statearr_61478_61532 = state_61459__$1;
(statearr_61478_61532[(2)] = inst_61451);

(statearr_61478_61532[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (13))){
var inst_61360 = (state_61459[(15)]);
var state_61459__$1 = state_61459;
var statearr_61479_61533 = state_61459__$1;
(statearr_61479_61533[(2)] = inst_61360);

(statearr_61479_61533[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (22))){
var inst_61389 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61390 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61391 = cljs.core.PersistentHashMap.fromArrays(inst_61389,inst_61390);
var inst_61392 = cljs.core.ex_info.call(null,"Aborted operations",inst_61391);
var state_61459__$1 = state_61459;
var statearr_61480_61534 = state_61459__$1;
(statearr_61480_61534[(2)] = inst_61392);

(statearr_61480_61534[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (29))){
var inst_61421 = (state_61459[(2)]);
var inst_61422 = superv.async.throw_if_exception.call(null,S,inst_61421);
var inst_61349 = inst_61422;
var state_61459__$1 = (function (){var statearr_61481 = state_61459;
(statearr_61481[(13)] = inst_61349);

return statearr_61481;
})();
var statearr_61482_61535 = state_61459__$1;
(statearr_61482_61535[(2)] = null);

(statearr_61482_61535[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (6))){
var inst_61337 = (state_61459[(7)]);
var inst_61343 = superv.async._track_exception.call(null,S,inst_61337);
var state_61459__$1 = state_61459;
var statearr_61483_61536 = state_61459__$1;
(statearr_61483_61536[(2)] = inst_61343);

(statearr_61483_61536[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (28))){
var inst_61411 = (state_61459[(16)]);
var state_61459__$1 = state_61459;
var statearr_61484_61537 = state_61459__$1;
(statearr_61484_61537[(2)] = inst_61411);

(statearr_61484_61537[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (25))){
var inst_61395 = (state_61459[(2)]);
var state_61459__$1 = state_61459;
var statearr_61485_61538 = state_61459__$1;
(statearr_61485_61538[(2)] = inst_61395);

(statearr_61485_61538[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (34))){
var inst_61447 = (state_61459[(2)]);
var state_61459__$1 = state_61459;
var statearr_61486_61539 = state_61459__$1;
(statearr_61486_61539[(2)] = inst_61447);

(statearr_61486_61539[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (17))){
var inst_61453 = (state_61459[(2)]);
var state_61459__$1 = state_61459;
var statearr_61487_61540 = state_61459__$1;
(statearr_61487_61540[(2)] = inst_61453);

(statearr_61487_61540[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (3))){
var inst_61334 = (state_61459[(2)]);
var inst_61335 = superv.async._unregister_go.call(null,S,id__23768__auto___61518);
var state_61459__$1 = (function (){var statearr_61488 = state_61459;
(statearr_61488[(17)] = inst_61335);

(statearr_61488[(18)] = inst_61334);

return statearr_61488;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61459__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (12))){
var inst_61364 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61365 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61366 = cljs.core.PersistentHashMap.fromArrays(inst_61364,inst_61365);
var inst_61367 = cljs.core.ex_info.call(null,"Aborted operations",inst_61366);
var state_61459__$1 = state_61459;
var statearr_61489_61541 = state_61459__$1;
(statearr_61489_61541[(2)] = inst_61367);

(statearr_61489_61541[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (2))){
var inst_61457 = (state_61459[(2)]);
var state_61459__$1 = state_61459;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61459__$1,inst_61457);
} else {
if((state_val_61460 === (23))){
var inst_61371 = (state_61459[(10)]);
var state_61459__$1 = state_61459;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_61459__$1,(25),result,inst_61371);
} else {
if((state_val_61460 === (19))){
var inst_61349 = (state_61459[(13)]);
var inst_61404 = (state_61459[(19)]);
var inst_61371 = (state_61459[(10)]);
var inst_61404__$1 = superv.async._abort.call(null,S);
var inst_61405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61406 = f_GT_.call(null,inst_61349,inst_61371);
var inst_61407 = [inst_61404__$1,inst_61406];
var inst_61408 = (new cljs.core.PersistentVector(null,2,(5),inst_61405,inst_61407,null));
var state_61459__$1 = (function (){var statearr_61490 = state_61459;
(statearr_61490[(19)] = inst_61404__$1);

return statearr_61490;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61459__$1,(26),inst_61408,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_61460 === (11))){
var inst_61354 = (state_61459[(20)]);
var inst_61359 = (state_61459[(2)]);
var inst_61360 = cljs.core.nth.call(null,inst_61359,(0),null);
var inst_61361 = cljs.core.nth.call(null,inst_61359,(1),null);
var inst_61362 = cljs.core._EQ_.call(null,inst_61361,inst_61354);
var state_61459__$1 = (function (){var statearr_61491 = state_61459;
(statearr_61491[(15)] = inst_61360);

return statearr_61491;
})();
if(inst_61362){
var statearr_61492_61542 = state_61459__$1;
(statearr_61492_61542[(1)] = (12));

} else {
var statearr_61493_61543 = state_61459__$1;
(statearr_61493_61543[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (9))){
var inst_61354 = (state_61459[(20)]);
var inst_61354__$1 = superv.async._abort.call(null,S);
var inst_61355 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61356 = [inst_61354__$1,ch];
var inst_61357 = (new cljs.core.PersistentVector(null,2,(5),inst_61355,inst_61356,null));
var state_61459__$1 = (function (){var statearr_61494 = state_61459;
(statearr_61494[(20)] = inst_61354__$1);

return statearr_61494;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61459__$1,(11),inst_61357,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_61460 === (5))){
var state_61459__$1 = state_61459;
var statearr_61495_61544 = state_61459__$1;
(statearr_61495_61544[(2)] = null);

(statearr_61495_61544[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (14))){
var inst_61371 = (state_61459[(10)]);
var inst_61370 = (state_61459[(2)]);
var inst_61371__$1 = superv.async.throw_if_exception.call(null,S,inst_61370);
var state_61459__$1 = (function (){var statearr_61496 = state_61459;
(statearr_61496[(10)] = inst_61371__$1);

return statearr_61496;
})();
if(cljs.core.truth_(inst_61371__$1)){
var statearr_61497_61545 = state_61459__$1;
(statearr_61497_61545[(1)] = (15));

} else {
var statearr_61498_61546 = state_61459__$1;
(statearr_61498_61546[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (26))){
var inst_61404 = (state_61459[(19)]);
var inst_61410 = (state_61459[(2)]);
var inst_61411 = cljs.core.nth.call(null,inst_61410,(0),null);
var inst_61412 = cljs.core.nth.call(null,inst_61410,(1),null);
var inst_61413 = cljs.core._EQ_.call(null,inst_61412,inst_61404);
var state_61459__$1 = (function (){var statearr_61499 = state_61459;
(statearr_61499[(16)] = inst_61411);

return statearr_61499;
})();
if(inst_61413){
var statearr_61500_61547 = state_61459__$1;
(statearr_61500_61547[(1)] = (27));

} else {
var statearr_61501_61548 = state_61459__$1;
(statearr_61501_61548[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (16))){
var inst_61430 = (state_61459[(21)]);
var inst_61430__$1 = superv.async._abort.call(null,S);
var inst_61431 = cljs.core.async.timeout.call(null,(0));
var inst_61432 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61433 = [inst_61430__$1,inst_61431];
var inst_61434 = (new cljs.core.PersistentVector(null,2,(5),inst_61432,inst_61433,null));
var state_61459__$1 = (function (){var statearr_61502 = state_61459;
(statearr_61502[(21)] = inst_61430__$1);

return statearr_61502;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61459__$1,(30),inst_61434,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_61460 === (30))){
var inst_61430 = (state_61459[(21)]);
var inst_61436 = (state_61459[(2)]);
var inst_61437 = cljs.core.nth.call(null,inst_61436,(0),null);
var inst_61438 = cljs.core.nth.call(null,inst_61436,(1),null);
var inst_61439 = cljs.core._EQ_.call(null,inst_61438,inst_61430);
var state_61459__$1 = (function (){var statearr_61503 = state_61459;
(statearr_61503[(22)] = inst_61437);

return statearr_61503;
})();
if(inst_61439){
var statearr_61504_61549 = state_61459__$1;
(statearr_61504_61549[(1)] = (31));

} else {
var statearr_61505_61550 = state_61459__$1;
(statearr_61505_61550[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (10))){
var inst_61455 = (state_61459[(2)]);
var state_61459__$1 = state_61459;
var statearr_61506_61551 = state_61459__$1;
(statearr_61506_61551[(2)] = inst_61455);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61459__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61460 === (18))){
var inst_61378 = (state_61459[(11)]);
var inst_61378__$1 = superv.async._abort.call(null,S);
var inst_61379 = cljs.core.async.timeout.call(null,(0));
var inst_61380 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61381 = [inst_61378__$1,inst_61379];
var inst_61382 = (new cljs.core.PersistentVector(null,2,(5),inst_61380,inst_61381,null));
var state_61459__$1 = (function (){var statearr_61507 = state_61459;
(statearr_61507[(11)] = inst_61378__$1);

return statearr_61507;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61459__$1,(21),inst_61382,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_61460 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_61459,(4),Error,(3),(2));
var inst_61349 = acc;
var state_61459__$1 = (function (){var statearr_61508 = state_61459;
(statearr_61508[(13)] = inst_61349);

return statearr_61508;
})();
var statearr_61509_61552 = state_61459__$1;
(statearr_61509_61552[(2)] = null);

(statearr_61509_61552[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___61519,c__23767__auto___61517,id__23768__auto___61518,result))
;
return ((function (switch__38343__auto__,c__38457__auto___61519,c__23767__auto___61517,id__23768__auto___61518,result){
return (function() {
var superv$async$reduce_GT__$_state_machine__38344__auto__ = null;
var superv$async$reduce_GT__$_state_machine__38344__auto____0 = (function (){
var statearr_61513 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61513[(0)] = superv$async$reduce_GT__$_state_machine__38344__auto__);

(statearr_61513[(1)] = (1));

return statearr_61513;
});
var superv$async$reduce_GT__$_state_machine__38344__auto____1 = (function (state_61459){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_61459);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e61514){if((e61514 instanceof Object)){
var ex__38347__auto__ = e61514;
var statearr_61515_61553 = state_61459;
(statearr_61515_61553[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61459);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e61514;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61554 = state_61459;
state_61459 = G__61554;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$reduce_GT__$_state_machine__38344__auto__ = function(state_61459){
switch(arguments.length){
case 0:
return superv$async$reduce_GT__$_state_machine__38344__auto____0.call(this);
case 1:
return superv$async$reduce_GT__$_state_machine__38344__auto____1.call(this,state_61459);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$reduce_GT__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$reduce_GT__$_state_machine__38344__auto____0;
superv$async$reduce_GT__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$reduce_GT__$_state_machine__38344__auto____1;
return superv$async$reduce_GT__$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___61519,c__23767__auto___61517,id__23768__auto___61518,result))
})();
var state__38459__auto__ = (function (){var statearr_61516 = f__38458__auto__.call(null);
(statearr_61516[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___61519);

return statearr_61516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___61519,c__23767__auto___61517,id__23768__auto___61518,result))
);


return result;
});
/**
 * Concatenates two or more channels. First takes all values from first channel
 *   and supplies to output channel, then takes all values from second channel and
 *   so on. Similiar to core.async/merge but maintains the order of values.
 */
superv.async.concat_GT__GT_ = (function superv$async$concat_GT__GT_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___61684 = arguments.length;
var i__10641__auto___61685 = (0);
while(true){
if((i__10641__auto___61685 < len__10640__auto___61684)){
args__10647__auto__.push((arguments[i__10641__auto___61685]));

var G__61686 = (i__10641__auto___61685 + (1));
i__10641__auto___61685 = G__61686;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var out = cljs.core.async.chan.call(null);
var c__23767__auto___61687 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___61688 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"c","c",-122660552,null),cljs.core.list(new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"c","c",-122660552,null))], null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"v","v",1661996586,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.list(new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null))))));
var c__38457__auto___61689 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___61689,c__23767__auto___61687,id__23768__auto___61688,out){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___61689,c__23767__auto___61687,id__23768__auto___61688,out){
return (function (state_61637){
var state_val_61638 = (state_61637[(1)]);
if((state_val_61638 === (7))){
var inst_61560 = (state_61637[(7)]);
var inst_61568 = (state_61637[(2)]);
var state_61637__$1 = (function (){var statearr_61640 = state_61637;
(statearr_61640[(8)] = inst_61568);

return statearr_61640;
})();
var statearr_61641_61690 = state_61637__$1;
(statearr_61641_61690[(2)] = inst_61560);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61637__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (20))){
var inst_61627 = (state_61637[(2)]);
var state_61637__$1 = state_61637;
var statearr_61642_61691 = state_61637__$1;
(statearr_61642_61691[(2)] = inst_61627);

(statearr_61642_61691[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (1))){
var state_61637__$1 = state_61637;
var statearr_61643_61692 = state_61637__$1;
(statearr_61643_61692[(2)] = null);

(statearr_61643_61692[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (24))){
var inst_61572 = (state_61637[(9)]);
var inst_61620 = (state_61637[(2)]);
var inst_61621 = superv.async.throw_if_exception.call(null,S,inst_61620);
var tmp61639 = inst_61572;
var inst_61572__$1 = tmp61639;
var state_61637__$1 = (function (){var statearr_61644 = state_61637;
(statearr_61644[(9)] = inst_61572__$1);

(statearr_61644[(10)] = inst_61621);

return statearr_61644;
})();
var statearr_61645_61693 = state_61637__$1;
(statearr_61645_61693[(2)] = null);

(statearr_61645_61693[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (4))){
var inst_61560 = (state_61637[(7)]);
var inst_61560__$1 = (state_61637[(2)]);
var inst_61561 = cljs.core.ex_data.call(null,inst_61560__$1);
var inst_61562 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_61561);
var inst_61563 = cljs.core._EQ_.call(null,inst_61562,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_61637__$1 = (function (){var statearr_61646 = state_61637;
(statearr_61646[(7)] = inst_61560__$1);

return statearr_61646;
})();
if(inst_61563){
var statearr_61647_61694 = state_61637__$1;
(statearr_61647_61694[(1)] = (5));

} else {
var statearr_61648_61695 = state_61637__$1;
(statearr_61648_61695[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (15))){
var inst_61589 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61590 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61591 = cljs.core.PersistentHashMap.fromArrays(inst_61589,inst_61590);
var inst_61592 = cljs.core.ex_info.call(null,"Aborted operations",inst_61591);
var state_61637__$1 = state_61637;
var statearr_61649_61696 = state_61637__$1;
(statearr_61649_61696[(2)] = inst_61592);

(statearr_61649_61696[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (21))){
var inst_61601 = (state_61637[(11)]);
var inst_61607 = (state_61637[(2)]);
var inst_61608 = cljs.core.nth.call(null,inst_61607,(0),null);
var inst_61609 = cljs.core.nth.call(null,inst_61607,(1),null);
var inst_61610 = cljs.core._EQ_.call(null,inst_61609,inst_61601);
var state_61637__$1 = (function (){var statearr_61650 = state_61637;
(statearr_61650[(12)] = inst_61608);

return statearr_61650;
})();
if(inst_61610){
var statearr_61651_61697 = state_61637__$1;
(statearr_61651_61697[(1)] = (22));

} else {
var statearr_61652_61698 = state_61637__$1;
(statearr_61652_61698[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (13))){
var inst_61631 = (state_61637[(2)]);
var state_61637__$1 = state_61637;
var statearr_61653_61699 = state_61637__$1;
(statearr_61653_61699[(2)] = inst_61631);

(statearr_61653_61699[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (22))){
var inst_61612 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61613 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61614 = cljs.core.PersistentHashMap.fromArrays(inst_61612,inst_61613);
var inst_61615 = cljs.core.ex_info.call(null,"Aborted operations",inst_61614);
var state_61637__$1 = state_61637;
var statearr_61654_61700 = state_61637__$1;
(statearr_61654_61700[(2)] = inst_61615);

(statearr_61654_61700[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (6))){
var inst_61560 = (state_61637[(7)]);
var inst_61566 = superv.async._track_exception.call(null,S,inst_61560);
var state_61637__$1 = state_61637;
var statearr_61655_61701 = state_61637__$1;
(statearr_61655_61701[(2)] = inst_61566);

(statearr_61655_61701[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (25))){
var inst_61618 = (state_61637[(2)]);
var state_61637__$1 = state_61637;
var statearr_61656_61702 = state_61637__$1;
(statearr_61656_61702[(2)] = inst_61618);

(statearr_61656_61702[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (17))){
var inst_61596 = (state_61637[(13)]);
var inst_61595 = (state_61637[(2)]);
var inst_61596__$1 = superv.async.throw_if_exception.call(null,S,inst_61595);
var state_61637__$1 = (function (){var statearr_61657 = state_61637;
(statearr_61657[(13)] = inst_61596__$1);

return statearr_61657;
})();
if(cljs.core.truth_(inst_61596__$1)){
var statearr_61658_61703 = state_61637__$1;
(statearr_61658_61703[(1)] = (18));

} else {
var statearr_61659_61704 = state_61637__$1;
(statearr_61659_61704[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (3))){
var inst_61557 = (state_61637[(2)]);
var inst_61558 = superv.async._unregister_go.call(null,S,id__23768__auto___61688);
var state_61637__$1 = (function (){var statearr_61660 = state_61637;
(statearr_61660[(14)] = inst_61558);

(statearr_61660[(15)] = inst_61557);

return statearr_61660;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61637__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (12))){
var inst_61629 = cljs.core.async.close_BANG_.call(null,out);
var state_61637__$1 = state_61637;
var statearr_61661_61705 = state_61637__$1;
(statearr_61661_61705[(2)] = inst_61629);

(statearr_61661_61705[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (2))){
var inst_61635 = (state_61637[(2)]);
var state_61637__$1 = state_61637;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61637__$1,inst_61635);
} else {
if((state_val_61638 === (23))){
var inst_61596 = (state_61637[(13)]);
var state_61637__$1 = state_61637;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_61637__$1,(25),out,inst_61596);
} else {
if((state_val_61638 === (19))){
var inst_61572 = (state_61637[(9)]);
var inst_61624 = cljs.core.rest.call(null,inst_61572);
var inst_61572__$1 = inst_61624;
var state_61637__$1 = (function (){var statearr_61662 = state_61637;
(statearr_61662[(9)] = inst_61572__$1);

return statearr_61662;
})();
var statearr_61663_61706 = state_61637__$1;
(statearr_61663_61706[(2)] = null);

(statearr_61663_61706[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (11))){
var inst_61574 = (state_61637[(16)]);
var inst_61579 = (state_61637[(17)]);
var inst_61579__$1 = superv.async._abort.call(null,S);
var inst_61580 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61581 = [inst_61579__$1,inst_61574];
var inst_61582 = (new cljs.core.PersistentVector(null,2,(5),inst_61580,inst_61581,null));
var state_61637__$1 = (function (){var statearr_61664 = state_61637;
(statearr_61664[(17)] = inst_61579__$1);

return statearr_61664;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61637__$1,(14),inst_61582,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_61638 === (9))){
var inst_61574 = (state_61637[(16)]);
var inst_61572 = (state_61637[(9)]);
var inst_61574__$1 = cljs.core.first.call(null,inst_61572);
var state_61637__$1 = (function (){var statearr_61665 = state_61637;
(statearr_61665[(16)] = inst_61574__$1);

return statearr_61665;
})();
if(cljs.core.truth_(inst_61574__$1)){
var statearr_61666_61707 = state_61637__$1;
(statearr_61666_61707[(1)] = (11));

} else {
var statearr_61667_61708 = state_61637__$1;
(statearr_61667_61708[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (5))){
var state_61637__$1 = state_61637;
var statearr_61668_61709 = state_61637__$1;
(statearr_61668_61709[(2)] = null);

(statearr_61668_61709[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (14))){
var inst_61579 = (state_61637[(17)]);
var inst_61584 = (state_61637[(2)]);
var inst_61585 = cljs.core.nth.call(null,inst_61584,(0),null);
var inst_61586 = cljs.core.nth.call(null,inst_61584,(1),null);
var inst_61587 = cljs.core._EQ_.call(null,inst_61586,inst_61579);
var state_61637__$1 = (function (){var statearr_61669 = state_61637;
(statearr_61669[(18)] = inst_61585);

return statearr_61669;
})();
if(inst_61587){
var statearr_61670_61710 = state_61637__$1;
(statearr_61670_61710[(1)] = (15));

} else {
var statearr_61671_61711 = state_61637__$1;
(statearr_61671_61711[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (16))){
var inst_61585 = (state_61637[(18)]);
var state_61637__$1 = state_61637;
var statearr_61672_61712 = state_61637__$1;
(statearr_61672_61712[(2)] = inst_61585);

(statearr_61672_61712[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (10))){
var inst_61633 = (state_61637[(2)]);
var state_61637__$1 = state_61637;
var statearr_61673_61713 = state_61637__$1;
(statearr_61673_61713[(2)] = inst_61633);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61637__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61638 === (18))){
var inst_61601 = (state_61637[(11)]);
var inst_61601__$1 = superv.async._abort.call(null,S);
var inst_61602 = cljs.core.async.timeout.call(null,(0));
var inst_61603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61604 = [inst_61601__$1,inst_61602];
var inst_61605 = (new cljs.core.PersistentVector(null,2,(5),inst_61603,inst_61604,null));
var state_61637__$1 = (function (){var statearr_61674 = state_61637;
(statearr_61674[(11)] = inst_61601__$1);

return statearr_61674;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61637__$1,(21),inst_61605,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_61638 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_61637,(4),Error,(3),(2));
var inst_61572 = cs;
var state_61637__$1 = (function (){var statearr_61675 = state_61637;
(statearr_61675[(9)] = inst_61572);

return statearr_61675;
})();
var statearr_61676_61714 = state_61637__$1;
(statearr_61676_61714[(2)] = null);

(statearr_61676_61714[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___61689,c__23767__auto___61687,id__23768__auto___61688,out))
;
return ((function (switch__38343__auto__,c__38457__auto___61689,c__23767__auto___61687,id__23768__auto___61688,out){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_61680 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61680[(0)] = superv$async$state_machine__38344__auto__);

(statearr_61680[(1)] = (1));

return statearr_61680;
});
var superv$async$state_machine__38344__auto____1 = (function (state_61637){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_61637);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e61681){if((e61681 instanceof Object)){
var ex__38347__auto__ = e61681;
var statearr_61682_61715 = state_61637;
(statearr_61682_61715[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61637);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e61681;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61716 = state_61637;
state_61637 = G__61716;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_61637){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_61637);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___61689,c__23767__auto___61687,id__23768__auto___61688,out))
})();
var state__38459__auto__ = (function (){var statearr_61683 = f__38458__auto__.call(null);
(statearr_61683[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___61689);

return statearr_61683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___61689,c__23767__auto___61687,id__23768__auto___61688,out))
);


return out;
});

superv.async.concat_GT__GT_.cljs$lang$maxFixedArity = (1);

superv.async.concat_GT__GT_.cljs$lang$applyTo = (function (seq61555){
var G__61556 = cljs.core.first.call(null,seq61555);
var seq61555__$1 = cljs.core.next.call(null,seq61555);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__61556,seq61555__$1);
});

superv.async.partition_all_GT__GT_ = (function superv$async$partition_all_GT__GT_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___61934 = arguments.length;
var i__10641__auto___61935 = (0);
while(true){
if((i__10641__auto___61935 < len__10640__auto___61934)){
args__10647__auto__.push((arguments[i__10641__auto___61935]));

var G__61936 = (i__10641__auto___61935 + (1));
i__10641__auto___61935 = G__61936;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((3) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((3)),(0),null)):null);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10648__auto__);
});

superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,n,in_ch,p__61721){
var map__61722 = p__61721;
var map__61722__$1 = ((((!((map__61722 == null)))?((((map__61722.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__61722.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__61722):map__61722);
var out_ch = cljs.core.get.call(null,map__61722__$1,new cljs.core.Keyword(null,"out-ch","out-ch",-189045854));

new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(n > (0))], null)], null);

var out_ch__$1 = (function (){var or__9419__auto__ = out_ch;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})();
var c__23767__auto___61937 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___61938 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"batch","batch",977610327,null),cljs.core.PersistentVector.EMPTY], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null),cljs.core.list(new cljs.core.Symbol(null,"conj","conj",-1127293942,null),new cljs.core.Symbol(null,"batch","batch",977610327,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.PersistentVector.EMPTY)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"not-empty","not-empty",2029453590,null),new cljs.core.Symbol(null,"batch","batch",977610327,null)),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"batch","batch",977610327,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))))));
var c__38457__auto___61939 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___61939,c__23767__auto___61937,id__23768__auto___61938,out_ch__$1,map__61722,map__61722__$1,out_ch){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___61939,c__23767__auto___61937,id__23768__auto___61938,out_ch__$1,map__61722,map__61722__$1,out_ch){
return (function (state_61866){
var state_val_61867 = (state_61866[(1)]);
if((state_val_61867 === (7))){
var inst_61727 = (state_61866[(7)]);
var inst_61735 = (state_61866[(2)]);
var state_61866__$1 = (function (){var statearr_61868 = state_61866;
(statearr_61868[(8)] = inst_61735);

return statearr_61868;
})();
var statearr_61869_61940 = state_61866__$1;
(statearr_61869_61940[(2)] = inst_61727);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61866__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (20))){
var inst_61827 = (state_61866[(2)]);
var state_61866__$1 = state_61866;
var statearr_61870_61941 = state_61866__$1;
(statearr_61870_61941[(2)] = inst_61827);

(statearr_61870_61941[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (27))){
var inst_61792 = (state_61866[(9)]);
var inst_61740 = inst_61792;
var state_61866__$1 = (function (){var statearr_61871 = state_61866;
(statearr_61871[(10)] = inst_61740);

return statearr_61871;
})();
var statearr_61872_61942 = state_61866__$1;
(statearr_61872_61942[(2)] = null);

(statearr_61872_61942[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (1))){
var state_61866__$1 = state_61866;
var statearr_61873_61943 = state_61866__$1;
(statearr_61873_61943[(2)] = null);

(statearr_61873_61943[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (24))){
var inst_61788 = (state_61866[(2)]);
var inst_61789 = superv.async.throw_if_exception.call(null,S,inst_61788);
var inst_61790 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_61866__$1 = (function (){var statearr_61874 = state_61866;
(statearr_61874[(11)] = inst_61789);

return statearr_61874;
})();
var statearr_61875_61944 = state_61866__$1;
(statearr_61875_61944[(2)] = inst_61790);

(statearr_61875_61944[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (39))){
var inst_61740 = (state_61866[(10)]);
var state_61866__$1 = state_61866;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_61866__$1,(41),out_ch__$1,inst_61740);
} else {
if((state_val_61867 === (4))){
var inst_61727 = (state_61866[(7)]);
var inst_61727__$1 = (state_61866[(2)]);
var inst_61728 = cljs.core.ex_data.call(null,inst_61727__$1);
var inst_61729 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_61728);
var inst_61730 = cljs.core._EQ_.call(null,inst_61729,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_61866__$1 = (function (){var statearr_61876 = state_61866;
(statearr_61876[(7)] = inst_61727__$1);

return statearr_61876;
})();
if(inst_61730){
var statearr_61877_61945 = state_61866__$1;
(statearr_61877_61945[(1)] = (5));

} else {
var statearr_61878_61946 = state_61866__$1;
(statearr_61878_61946[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (15))){
var inst_61762 = (state_61866[(12)]);
var inst_61764 = (inst_61762 instanceof Error);
var state_61866__$1 = state_61866;
if(cljs.core.truth_(inst_61764)){
var statearr_61879_61947 = state_61866__$1;
(statearr_61879_61947[(1)] = (18));

} else {
var statearr_61880_61948 = state_61866__$1;
(statearr_61880_61948[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (21))){
var inst_61769 = (state_61866[(13)]);
var inst_61775 = (state_61866[(2)]);
var inst_61776 = cljs.core.nth.call(null,inst_61775,(0),null);
var inst_61777 = cljs.core.nth.call(null,inst_61775,(1),null);
var inst_61778 = cljs.core._EQ_.call(null,inst_61777,inst_61769);
var state_61866__$1 = (function (){var statearr_61881 = state_61866;
(statearr_61881[(14)] = inst_61776);

return statearr_61881;
})();
if(inst_61778){
var statearr_61882_61949 = state_61866__$1;
(statearr_61882_61949[(1)] = (22));

} else {
var statearr_61883_61950 = state_61866__$1;
(statearr_61883_61950[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (31))){
var inst_61792 = (state_61866[(9)]);
var state_61866__$1 = state_61866;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_61866__$1,(33),out_ch__$1,inst_61792);
} else {
if((state_val_61867 === (32))){
var inst_61818 = (state_61866[(2)]);
var inst_61819 = superv.async.throw_if_exception.call(null,S,inst_61818);
var inst_61820 = cljs.core.PersistentVector.EMPTY;
var inst_61740 = inst_61820;
var state_61866__$1 = (function (){var statearr_61884 = state_61866;
(statearr_61884[(10)] = inst_61740);

(statearr_61884[(15)] = inst_61819);

return statearr_61884;
})();
var statearr_61885_61951 = state_61866__$1;
(statearr_61885_61951[(2)] = null);

(statearr_61885_61951[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (40))){
var inst_61853 = (state_61866[(2)]);
var inst_61854 = superv.async.throw_if_exception.call(null,S,inst_61853);
var state_61866__$1 = state_61866;
var statearr_61886_61952 = state_61866__$1;
(statearr_61886_61952[(2)] = inst_61854);

(statearr_61886_61952[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (33))){
var inst_61816 = (state_61866[(2)]);
var state_61866__$1 = state_61866;
var statearr_61887_61953 = state_61866__$1;
(statearr_61887_61953[(2)] = inst_61816);

(statearr_61887_61953[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (13))){
var inst_61751 = (state_61866[(16)]);
var state_61866__$1 = state_61866;
var statearr_61888_61954 = state_61866__$1;
(statearr_61888_61954[(2)] = inst_61751);

(statearr_61888_61954[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (22))){
var inst_61780 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61781 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61782 = cljs.core.PersistentHashMap.fromArrays(inst_61780,inst_61781);
var inst_61783 = cljs.core.ex_info.call(null,"Aborted operations",inst_61782);
var state_61866__$1 = state_61866;
var statearr_61889_61955 = state_61866__$1;
(statearr_61889_61955[(2)] = inst_61783);

(statearr_61889_61955[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (36))){
var inst_61857 = (state_61866[(2)]);
var inst_61858 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_61866__$1 = (function (){var statearr_61890 = state_61866;
(statearr_61890[(17)] = inst_61857);

return statearr_61890;
})();
var statearr_61891_61956 = state_61866__$1;
(statearr_61891_61956[(2)] = inst_61858);

(statearr_61891_61956[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (41))){
var inst_61851 = (state_61866[(2)]);
var state_61866__$1 = state_61866;
var statearr_61892_61957 = state_61866__$1;
(statearr_61892_61957[(2)] = inst_61851);

(statearr_61892_61957[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (29))){
var inst_61799 = (state_61866[(18)]);
var inst_61805 = (state_61866[(2)]);
var inst_61806 = cljs.core.nth.call(null,inst_61805,(0),null);
var inst_61807 = cljs.core.nth.call(null,inst_61805,(1),null);
var inst_61808 = cljs.core._EQ_.call(null,inst_61807,inst_61799);
var state_61866__$1 = (function (){var statearr_61893 = state_61866;
(statearr_61893[(19)] = inst_61806);

return statearr_61893;
})();
if(inst_61808){
var statearr_61894_61958 = state_61866__$1;
(statearr_61894_61958[(1)] = (30));

} else {
var statearr_61895_61959 = state_61866__$1;
(statearr_61895_61959[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (6))){
var inst_61727 = (state_61866[(7)]);
var inst_61733 = superv.async._track_exception.call(null,S,inst_61727);
var state_61866__$1 = state_61866;
var statearr_61896_61960 = state_61866__$1;
(statearr_61896_61960[(2)] = inst_61733);

(statearr_61896_61960[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (28))){
var inst_61825 = (state_61866[(2)]);
var state_61866__$1 = state_61866;
var statearr_61897_61961 = state_61866__$1;
(statearr_61897_61961[(2)] = inst_61825);

(statearr_61897_61961[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (25))){
var inst_61786 = (state_61866[(2)]);
var state_61866__$1 = state_61866;
var statearr_61898_61962 = state_61866__$1;
(statearr_61898_61962[(2)] = inst_61786);

(statearr_61898_61962[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (34))){
var inst_61834 = (state_61866[(20)]);
var inst_61834__$1 = superv.async._abort.call(null,S);
var inst_61835 = cljs.core.async.timeout.call(null,(0));
var inst_61836 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61837 = [inst_61834__$1,inst_61835];
var inst_61838 = (new cljs.core.PersistentVector(null,2,(5),inst_61836,inst_61837,null));
var state_61866__$1 = (function (){var statearr_61899 = state_61866;
(statearr_61899[(20)] = inst_61834__$1);

return statearr_61899;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61866__$1,(37),inst_61838,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_61867 === (17))){
var inst_61860 = (state_61866[(2)]);
var state_61866__$1 = state_61866;
var statearr_61900_61963 = state_61866__$1;
(statearr_61900_61963[(2)] = inst_61860);

(statearr_61900_61963[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (3))){
var inst_61724 = (state_61866[(2)]);
var inst_61725 = superv.async._unregister_go.call(null,S,id__23768__auto___61938);
var state_61866__$1 = (function (){var statearr_61901 = state_61866;
(statearr_61901[(21)] = inst_61724);

(statearr_61901[(22)] = inst_61725);

return statearr_61901;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61866__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (12))){
var inst_61755 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61756 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61757 = cljs.core.PersistentHashMap.fromArrays(inst_61755,inst_61756);
var inst_61758 = cljs.core.ex_info.call(null,"Aborted operations",inst_61757);
var state_61866__$1 = state_61866;
var statearr_61902_61964 = state_61866__$1;
(statearr_61902_61964[(2)] = inst_61758);

(statearr_61902_61964[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (2))){
var inst_61864 = (state_61866[(2)]);
var state_61866__$1 = state_61866;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61866__$1,inst_61864);
} else {
if((state_val_61867 === (23))){
var inst_61762 = (state_61866[(12)]);
var state_61866__$1 = state_61866;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_61866__$1,(25),out_ch__$1,inst_61762);
} else {
if((state_val_61867 === (35))){
var state_61866__$1 = state_61866;
var statearr_61903_61965 = state_61866__$1;
(statearr_61903_61965[(2)] = null);

(statearr_61903_61965[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (19))){
var inst_61792 = (state_61866[(9)]);
var inst_61740 = (state_61866[(10)]);
var inst_61762 = (state_61866[(12)]);
var inst_61792__$1 = cljs.core.conj.call(null,inst_61740,inst_61762);
var inst_61793 = cljs.core.count.call(null,inst_61792__$1);
var inst_61794 = cljs.core._EQ_.call(null,n,inst_61793);
var state_61866__$1 = (function (){var statearr_61904 = state_61866;
(statearr_61904[(9)] = inst_61792__$1);

return statearr_61904;
})();
if(inst_61794){
var statearr_61905_61966 = state_61866__$1;
(statearr_61905_61966[(1)] = (26));

} else {
var statearr_61906_61967 = state_61866__$1;
(statearr_61906_61967[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (11))){
var inst_61745 = (state_61866[(23)]);
var inst_61750 = (state_61866[(2)]);
var inst_61751 = cljs.core.nth.call(null,inst_61750,(0),null);
var inst_61752 = cljs.core.nth.call(null,inst_61750,(1),null);
var inst_61753 = cljs.core._EQ_.call(null,inst_61752,inst_61745);
var state_61866__$1 = (function (){var statearr_61907 = state_61866;
(statearr_61907[(16)] = inst_61751);

return statearr_61907;
})();
if(inst_61753){
var statearr_61908_61968 = state_61866__$1;
(statearr_61908_61968[(1)] = (12));

} else {
var statearr_61909_61969 = state_61866__$1;
(statearr_61909_61969[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (9))){
var inst_61745 = (state_61866[(23)]);
var inst_61745__$1 = superv.async._abort.call(null,S);
var inst_61746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61747 = [inst_61745__$1,in_ch];
var inst_61748 = (new cljs.core.PersistentVector(null,2,(5),inst_61746,inst_61747,null));
var state_61866__$1 = (function (){var statearr_61910 = state_61866;
(statearr_61910[(23)] = inst_61745__$1);

return statearr_61910;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61866__$1,(11),inst_61748,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_61867 === (5))){
var state_61866__$1 = state_61866;
var statearr_61911_61970 = state_61866__$1;
(statearr_61911_61970[(2)] = null);

(statearr_61911_61970[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (14))){
var inst_61762 = (state_61866[(12)]);
var inst_61761 = (state_61866[(2)]);
var inst_61762__$1 = superv.async.throw_if_exception.call(null,S,inst_61761);
var state_61866__$1 = (function (){var statearr_61912 = state_61866;
(statearr_61912[(12)] = inst_61762__$1);

return statearr_61912;
})();
if(cljs.core.truth_(inst_61762__$1)){
var statearr_61913_61971 = state_61866__$1;
(statearr_61913_61971[(1)] = (15));

} else {
var statearr_61914_61972 = state_61866__$1;
(statearr_61914_61972[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (26))){
var inst_61799 = (state_61866[(18)]);
var inst_61799__$1 = superv.async._abort.call(null,S);
var inst_61800 = cljs.core.async.timeout.call(null,(0));
var inst_61801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61802 = [inst_61799__$1,inst_61800];
var inst_61803 = (new cljs.core.PersistentVector(null,2,(5),inst_61801,inst_61802,null));
var state_61866__$1 = (function (){var statearr_61915 = state_61866;
(statearr_61915[(18)] = inst_61799__$1);

return statearr_61915;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61866__$1,(29),inst_61803,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_61867 === (16))){
var inst_61740 = (state_61866[(10)]);
var inst_61829 = cljs.core.not_empty.call(null,inst_61740);
var state_61866__$1 = state_61866;
if(cljs.core.truth_(inst_61829)){
var statearr_61916_61973 = state_61866__$1;
(statearr_61916_61973[(1)] = (34));

} else {
var statearr_61917_61974 = state_61866__$1;
(statearr_61917_61974[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (38))){
var inst_61845 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61846 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61847 = cljs.core.PersistentHashMap.fromArrays(inst_61845,inst_61846);
var inst_61848 = cljs.core.ex_info.call(null,"Aborted operations",inst_61847);
var state_61866__$1 = state_61866;
var statearr_61918_61975 = state_61866__$1;
(statearr_61918_61975[(2)] = inst_61848);

(statearr_61918_61975[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (30))){
var inst_61810 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61811 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61812 = cljs.core.PersistentHashMap.fromArrays(inst_61810,inst_61811);
var inst_61813 = cljs.core.ex_info.call(null,"Aborted operations",inst_61812);
var state_61866__$1 = state_61866;
var statearr_61919_61976 = state_61866__$1;
(statearr_61919_61976[(2)] = inst_61813);

(statearr_61919_61976[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (10))){
var inst_61862 = (state_61866[(2)]);
var state_61866__$1 = state_61866;
var statearr_61920_61977 = state_61866__$1;
(statearr_61920_61977[(2)] = inst_61862);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61866__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (18))){
var inst_61769 = (state_61866[(13)]);
var inst_61769__$1 = superv.async._abort.call(null,S);
var inst_61770 = cljs.core.async.timeout.call(null,(0));
var inst_61771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61772 = [inst_61769__$1,inst_61770];
var inst_61773 = (new cljs.core.PersistentVector(null,2,(5),inst_61771,inst_61772,null));
var state_61866__$1 = (function (){var statearr_61921 = state_61866;
(statearr_61921[(13)] = inst_61769__$1);

return statearr_61921;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61866__$1,(21),inst_61773,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_61867 === (37))){
var inst_61834 = (state_61866[(20)]);
var inst_61840 = (state_61866[(2)]);
var inst_61841 = cljs.core.nth.call(null,inst_61840,(0),null);
var inst_61842 = cljs.core.nth.call(null,inst_61840,(1),null);
var inst_61843 = cljs.core._EQ_.call(null,inst_61842,inst_61834);
var state_61866__$1 = (function (){var statearr_61922 = state_61866;
(statearr_61922[(24)] = inst_61841);

return statearr_61922;
})();
if(inst_61843){
var statearr_61923_61978 = state_61866__$1;
(statearr_61923_61978[(1)] = (38));

} else {
var statearr_61924_61979 = state_61866__$1;
(statearr_61924_61979[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61867 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_61866,(4),Error,(3),(2));
var inst_61739 = cljs.core.PersistentVector.EMPTY;
var inst_61740 = inst_61739;
var state_61866__$1 = (function (){var statearr_61925 = state_61866;
(statearr_61925[(10)] = inst_61740);

return statearr_61925;
})();
var statearr_61926_61980 = state_61866__$1;
(statearr_61926_61980[(2)] = null);

(statearr_61926_61980[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___61939,c__23767__auto___61937,id__23768__auto___61938,out_ch__$1,map__61722,map__61722__$1,out_ch))
;
return ((function (switch__38343__auto__,c__38457__auto___61939,c__23767__auto___61937,id__23768__auto___61938,out_ch__$1,map__61722,map__61722__$1,out_ch){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_61930 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61930[(0)] = superv$async$state_machine__38344__auto__);

(statearr_61930[(1)] = (1));

return statearr_61930;
});
var superv$async$state_machine__38344__auto____1 = (function (state_61866){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_61866);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e61931){if((e61931 instanceof Object)){
var ex__38347__auto__ = e61931;
var statearr_61932_61981 = state_61866;
(statearr_61932_61981[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61866);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e61931;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61982 = state_61866;
state_61866 = G__61982;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_61866){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_61866);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___61939,c__23767__auto___61937,id__23768__auto___61938,out_ch__$1,map__61722,map__61722__$1,out_ch))
})();
var state__38459__auto__ = (function (){var statearr_61933 = f__38458__auto__.call(null);
(statearr_61933[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___61939);

return statearr_61933;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___61939,c__23767__auto___61937,id__23768__auto___61938,out_ch__$1,map__61722,map__61722__$1,out_ch))
);


return out_ch__$1;
});

superv.async.partition_all_GT__GT_.cljs$lang$maxFixedArity = (3);

superv.async.partition_all_GT__GT_.cljs$lang$applyTo = (function (seq61717){
var G__61718 = cljs.core.first.call(null,seq61717);
var seq61717__$1 = cljs.core.next.call(null,seq61717);
var G__61719 = cljs.core.first.call(null,seq61717__$1);
var seq61717__$2 = cljs.core.next.call(null,seq61717__$1);
var G__61720 = cljs.core.first.call(null,seq61717__$2);
var seq61717__$3 = cljs.core.next.call(null,seq61717__$2);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__61718,G__61719,G__61720,seq61717__$3);
});

/**
 * Counts items in a channel. Returns a channel with the item count.
 */
superv.async.count_GT_ = (function superv$async$count_GT_(S,ch){
return cljs.core.async.reduce.call(null,(function (acc,obj){
if((obj instanceof Error)){
return superv.async.put_QMARK_.call(null,S,superv.async._error.call(null,S),obj);
} else {
return (acc + (1));
}
}),(0),ch);
});
/**
 * Debounces channel. Forwards first item from input channel to output
 *   immediately. After that one item every interval ms (if any). If there are more
 *   items in between, they are dropped.
 */
superv.async.debounce_GT__GT_ = (function superv$async$debounce_GT__GT_(S,ch,interval){
var out = cljs.core.async.chan.call(null);
var c__23767__auto___62301 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___62302 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),null], null),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol("async","timeout","async/timeout",1951904349,null),new cljs.core.Symbol(null,"interval","interval",-945940352,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null)),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-val","new-val",902372928,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null),cljs.core.list(new cljs.core.Symbol(null,"alts?","alts?",1625745590,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null)], null))], null),cljs.core.list(new cljs.core.Symbol(null,"condp","condp",1054325175,null),new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)))))))));
var c__38457__auto___62303 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___62303,c__23767__auto___62301,id__23768__auto___62302,out){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___62303,c__23767__auto___62301,id__23768__auto___62302,out){
return (function (state_62247){
var state_val_62248 = (state_62247[(1)]);
if((state_val_62248 === (7))){
var inst_62145 = (state_62247[(7)]);
var inst_62153 = (state_62247[(2)]);
var state_62247__$1 = (function (){var statearr_62249 = state_62247;
(statearr_62249[(8)] = inst_62153);

return statearr_62249;
})();
var statearr_62250_62304 = state_62247__$1;
(statearr_62250_62304[(2)] = inst_62145);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62247__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (20))){
var inst_62241 = (state_62247[(2)]);
var state_62247__$1 = state_62247;
var statearr_62251_62305 = state_62247__$1;
(statearr_62251_62305[(2)] = inst_62241);

(statearr_62251_62305[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (27))){
var inst_62225 = (state_62247[(2)]);
var inst_62226 = superv.async.throw_if_exception.call(null,S,inst_62225);
var inst_62157 = null;
var state_62247__$1 = (function (){var statearr_62252 = state_62247;
(statearr_62252[(9)] = inst_62157);

(statearr_62252[(10)] = inst_62226);

return statearr_62252;
})();
var statearr_62253_62306 = state_62247__$1;
(statearr_62253_62306[(2)] = null);

(statearr_62253_62306[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (1))){
var state_62247__$1 = state_62247;
var statearr_62254_62307 = state_62247__$1;
(statearr_62254_62307[(2)] = null);

(statearr_62254_62307[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (24))){
var inst_62206 = (state_62247[(11)]);
var inst_62212 = (state_62247[(2)]);
var inst_62213 = cljs.core.nth.call(null,inst_62212,(0),null);
var inst_62214 = cljs.core.nth.call(null,inst_62212,(1),null);
var inst_62215 = cljs.core._EQ_.call(null,inst_62214,inst_62206);
var state_62247__$1 = (function (){var statearr_62255 = state_62247;
(statearr_62255[(12)] = inst_62213);

return statearr_62255;
})();
if(inst_62215){
var statearr_62256_62308 = state_62247__$1;
(statearr_62256_62308[(1)] = (25));

} else {
var statearr_62257_62309 = state_62247__$1;
(statearr_62257_62309[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (4))){
var inst_62145 = (state_62247[(7)]);
var inst_62145__$1 = (state_62247[(2)]);
var inst_62146 = cljs.core.ex_data.call(null,inst_62145__$1);
var inst_62147 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_62146);
var inst_62148 = cljs.core._EQ_.call(null,inst_62147,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_62247__$1 = (function (){var statearr_62258 = state_62247;
(statearr_62258[(7)] = inst_62145__$1);

return statearr_62258;
})();
if(inst_62148){
var statearr_62259_62310 = state_62247__$1;
(statearr_62259_62310[(1)] = (5));

} else {
var statearr_62260_62311 = state_62247__$1;
(statearr_62260_62311[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (15))){
var inst_62174 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_62175 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_62176 = cljs.core.PersistentHashMap.fromArrays(inst_62174,inst_62175);
var inst_62177 = cljs.core.ex_info.call(null,"Aborted operations",inst_62176);
var state_62247__$1 = state_62247;
var statearr_62261_62312 = state_62247__$1;
(statearr_62261_62312[(2)] = inst_62177);

(statearr_62261_62312[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (21))){
var inst_62206 = (state_62247[(11)]);
var inst_62206__$1 = superv.async._abort.call(null,S);
var inst_62207 = cljs.core.async.timeout.call(null,(0));
var inst_62208 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62209 = [inst_62206__$1,inst_62207];
var inst_62210 = (new cljs.core.PersistentVector(null,2,(5),inst_62208,inst_62209,null));
var state_62247__$1 = (function (){var statearr_62262 = state_62247;
(statearr_62262[(11)] = inst_62206__$1);

return statearr_62262;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_62247__$1,(24),inst_62210,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_62248 === (31))){
var inst_62237 = (state_62247[(2)]);
var state_62247__$1 = state_62247;
var statearr_62263_62313 = state_62247__$1;
(statearr_62263_62313[(2)] = inst_62237);

(statearr_62263_62313[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (13))){
var inst_62183 = (state_62247[(13)]);
var inst_62183__$1 = (state_62247[(2)]);
var inst_62184 = cljs.core.async.timeout.call(null,interval);
var inst_62185 = (inst_62183__$1 == null);
var state_62247__$1 = (function (){var statearr_62264 = state_62247;
(statearr_62264[(13)] = inst_62183__$1);

(statearr_62264[(14)] = inst_62184);

return statearr_62264;
})();
if(cljs.core.truth_(inst_62185)){
var statearr_62265_62314 = state_62247__$1;
(statearr_62265_62314[(1)] = (18));

} else {
var statearr_62266_62315 = state_62247__$1;
(statearr_62266_62315[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (22))){
var inst_62197 = (state_62247[(15)]);
var inst_62229 = cljs.core._EQ_.call(null,inst_62197,inst_62197);
var state_62247__$1 = state_62247;
if(inst_62229){
var statearr_62267_62316 = state_62247__$1;
(statearr_62267_62316[(1)] = (29));

} else {
var statearr_62268_62317 = state_62247__$1;
(statearr_62268_62317[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (29))){
var inst_62196 = (state_62247[(16)]);
var inst_62157 = inst_62196;
var state_62247__$1 = (function (){var statearr_62269 = state_62247;
(statearr_62269[(9)] = inst_62157);

return statearr_62269;
})();
var statearr_62270_62318 = state_62247__$1;
(statearr_62270_62318[(2)] = null);

(statearr_62270_62318[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (6))){
var inst_62145 = (state_62247[(7)]);
var inst_62151 = superv.async._track_exception.call(null,S,inst_62145);
var state_62247__$1 = state_62247;
var statearr_62271_62319 = state_62247__$1;
(statearr_62271_62319[(2)] = inst_62151);

(statearr_62271_62319[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (28))){
var inst_62223 = (state_62247[(2)]);
var state_62247__$1 = state_62247;
var statearr_62272_62320 = state_62247__$1;
(statearr_62272_62320[(2)] = inst_62223);

(statearr_62272_62320[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (25))){
var inst_62217 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_62218 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_62219 = cljs.core.PersistentHashMap.fromArrays(inst_62217,inst_62218);
var inst_62220 = cljs.core.ex_info.call(null,"Aborted operations",inst_62219);
var state_62247__$1 = state_62247;
var statearr_62273_62321 = state_62247__$1;
(statearr_62273_62321[(2)] = inst_62220);

(statearr_62273_62321[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (17))){
var inst_62180 = (state_62247[(2)]);
var inst_62181 = superv.async.throw_if_exception.call(null,S,inst_62180);
var state_62247__$1 = state_62247;
var statearr_62274_62322 = state_62247__$1;
(statearr_62274_62322[(2)] = inst_62181);

(statearr_62274_62322[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (3))){
var inst_62142 = (state_62247[(2)]);
var inst_62143 = superv.async._unregister_go.call(null,S,id__23768__auto___62302);
var state_62247__$1 = (function (){var statearr_62275 = state_62247;
(statearr_62275[(17)] = inst_62142);

(statearr_62275[(18)] = inst_62143);

return statearr_62275;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62247__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (12))){
var inst_62164 = (state_62247[(19)]);
var inst_62164__$1 = superv.async._abort.call(null,S);
var inst_62165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62166 = [inst_62164__$1,ch];
var inst_62167 = (new cljs.core.PersistentVector(null,2,(5),inst_62165,inst_62166,null));
var state_62247__$1 = (function (){var statearr_62276 = state_62247;
(statearr_62276[(19)] = inst_62164__$1);

return statearr_62276;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_62247__$1,(14),inst_62167,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_62248 === (2))){
var inst_62245 = (state_62247[(2)]);
var state_62247__$1 = state_62247;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62247__$1,inst_62245);
} else {
if((state_val_62248 === (23))){
var inst_62239 = (state_62247[(2)]);
var state_62247__$1 = state_62247;
var statearr_62277_62323 = state_62247__$1;
(statearr_62277_62323[(2)] = inst_62239);

(statearr_62277_62323[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (19))){
var inst_62197 = (state_62247[(15)]);
var inst_62184 = (state_62247[(14)]);
var inst_62192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62193 = [ch,inst_62184];
var inst_62194 = (new cljs.core.PersistentVector(null,2,(5),inst_62192,inst_62193,null));
var inst_62195 = superv.async.alts_QMARK_.call(null,S,inst_62194);
var inst_62196 = cljs.core.nth.call(null,inst_62195,(0),null);
var inst_62197__$1 = cljs.core.nth.call(null,inst_62195,(1),null);
var inst_62201 = cljs.core._EQ_.call(null,inst_62184,inst_62197__$1);
var state_62247__$1 = (function (){var statearr_62278 = state_62247;
(statearr_62278[(15)] = inst_62197__$1);

(statearr_62278[(16)] = inst_62196);

return statearr_62278;
})();
if(inst_62201){
var statearr_62279_62324 = state_62247__$1;
(statearr_62279_62324[(1)] = (21));

} else {
var statearr_62280_62325 = state_62247__$1;
(statearr_62280_62325[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (11))){
var inst_62157 = (state_62247[(9)]);
var state_62247__$1 = state_62247;
var statearr_62281_62326 = state_62247__$1;
(statearr_62281_62326[(2)] = inst_62157);

(statearr_62281_62326[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (9))){
var inst_62157 = (state_62247[(9)]);
var state_62247__$1 = state_62247;
if(cljs.core.truth_(inst_62157)){
var statearr_62282_62327 = state_62247__$1;
(statearr_62282_62327[(1)] = (11));

} else {
var statearr_62283_62328 = state_62247__$1;
(statearr_62283_62328[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (5))){
var state_62247__$1 = state_62247;
var statearr_62284_62329 = state_62247__$1;
(statearr_62284_62329[(2)] = null);

(statearr_62284_62329[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (14))){
var inst_62164 = (state_62247[(19)]);
var inst_62169 = (state_62247[(2)]);
var inst_62170 = cljs.core.nth.call(null,inst_62169,(0),null);
var inst_62171 = cljs.core.nth.call(null,inst_62169,(1),null);
var inst_62172 = cljs.core._EQ_.call(null,inst_62171,inst_62164);
var state_62247__$1 = (function (){var statearr_62285 = state_62247;
(statearr_62285[(20)] = inst_62170);

return statearr_62285;
})();
if(inst_62172){
var statearr_62286_62330 = state_62247__$1;
(statearr_62286_62330[(1)] = (15));

} else {
var statearr_62287_62331 = state_62247__$1;
(statearr_62287_62331[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (26))){
var inst_62183 = (state_62247[(13)]);
var state_62247__$1 = state_62247;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_62247__$1,(28),out,inst_62183);
} else {
if((state_val_62248 === (16))){
var inst_62170 = (state_62247[(20)]);
var state_62247__$1 = state_62247;
var statearr_62288_62332 = state_62247__$1;
(statearr_62288_62332[(2)] = inst_62170);

(statearr_62288_62332[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (30))){
var inst_62197 = (state_62247[(15)]);
var inst_62233 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62197)].join('');
var inst_62234 = (new Error(inst_62233));
var inst_62235 = (function(){throw inst_62234})();
var state_62247__$1 = state_62247;
var statearr_62289_62333 = state_62247__$1;
(statearr_62289_62333[(2)] = inst_62235);

(statearr_62289_62333[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (10))){
var inst_62243 = (state_62247[(2)]);
var state_62247__$1 = state_62247;
var statearr_62290_62334 = state_62247__$1;
(statearr_62290_62334[(2)] = inst_62243);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62247__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (18))){
var inst_62187 = cljs.core.async.close_BANG_.call(null,out);
var state_62247__$1 = state_62247;
var statearr_62291_62335 = state_62247__$1;
(statearr_62291_62335[(2)] = inst_62187);

(statearr_62291_62335[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62248 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_62247,(4),Error,(3),(2));
var inst_62157 = null;
var state_62247__$1 = (function (){var statearr_62292 = state_62247;
(statearr_62292[(9)] = inst_62157);

return statearr_62292;
})();
var statearr_62293_62336 = state_62247__$1;
(statearr_62293_62336[(2)] = null);

(statearr_62293_62336[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___62303,c__23767__auto___62301,id__23768__auto___62302,out))
;
return ((function (switch__38343__auto__,c__38457__auto___62303,c__23767__auto___62301,id__23768__auto___62302,out){
return (function() {
var superv$async$debounce_GT__GT__$_state_machine__38344__auto__ = null;
var superv$async$debounce_GT__GT__$_state_machine__38344__auto____0 = (function (){
var statearr_62297 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62297[(0)] = superv$async$debounce_GT__GT__$_state_machine__38344__auto__);

(statearr_62297[(1)] = (1));

return statearr_62297;
});
var superv$async$debounce_GT__GT__$_state_machine__38344__auto____1 = (function (state_62247){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_62247);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e62298){if((e62298 instanceof Object)){
var ex__38347__auto__ = e62298;
var statearr_62299_62337 = state_62247;
(statearr_62299_62337[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62247);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62298;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62338 = state_62247;
state_62247 = G__62338;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$debounce_GT__GT__$_state_machine__38344__auto__ = function(state_62247){
switch(arguments.length){
case 0:
return superv$async$debounce_GT__GT__$_state_machine__38344__auto____0.call(this);
case 1:
return superv$async$debounce_GT__GT__$_state_machine__38344__auto____1.call(this,state_62247);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$debounce_GT__GT__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$debounce_GT__GT__$_state_machine__38344__auto____0;
superv$async$debounce_GT__GT__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$debounce_GT__GT__$_state_machine__38344__auto____1;
return superv$async$debounce_GT__GT__$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___62303,c__23767__auto___62301,id__23768__auto___62302,out))
})();
var state__38459__auto__ = (function (){var statearr_62300 = f__38458__auto__.call(null);
(statearr_62300[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___62303);

return statearr_62300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___62303,c__23767__auto___62301,id__23768__auto___62302,out))
);


return out;
});
/**
 * Safely managed tap. The channel is closed on abortion and all
 *   pending puts are flushed.
 */
superv.async.tap = (function superv$async$tap(var_args){
var args62339 = [];
var len__10640__auto___62477 = arguments.length;
var i__10641__auto___62478 = (0);
while(true){
if((i__10641__auto___62478 < len__10640__auto___62477)){
args62339.push((arguments[i__10641__auto___62478]));

var G__62479 = (i__10641__auto___62478 + (1));
i__10641__auto___62478 = G__62479;
continue;
} else {
}
break;
}

var G__62341 = args62339.length;
switch (G__62341) {
case 3:
return superv.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.tap.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args62339.length)].join('')));

}
});

superv.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (S,mult,ch){
return superv.async.tap.call(null,S,mult,ch,false);
});

superv.async.tap.cljs$core$IFn$_invoke$arity$4 = (function (S,mult,ch,close_QMARK_){
var c__23767__auto___62481 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___62482 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__38457__auto___62483 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___62483,c__23767__auto___62481,id__23768__auto___62482){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___62483,c__23767__auto___62481,id__23768__auto___62482){
return (function (state_62420){
var state_val_62421 = (state_62420[(1)]);
if((state_val_62421 === (7))){
var inst_62345 = (state_62420[(7)]);
var inst_62353 = (state_62420[(2)]);
var state_62420__$1 = (function (){var statearr_62422 = state_62420;
(statearr_62422[(8)] = inst_62353);

return statearr_62422;
})();
var statearr_62423_62484 = state_62420__$1;
(statearr_62423_62484[(2)] = inst_62345);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62420__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (1))){
var state_62420__$1 = state_62420;
var statearr_62424_62485 = state_62420__$1;
(statearr_62424_62485[(2)] = null);

(statearr_62424_62485[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (4))){
var inst_62345 = (state_62420[(7)]);
var inst_62345__$1 = (state_62420[(2)]);
var inst_62346 = cljs.core.ex_data.call(null,inst_62345__$1);
var inst_62347 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_62346);
var inst_62348 = cljs.core._EQ_.call(null,inst_62347,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_62420__$1 = (function (){var statearr_62425 = state_62420;
(statearr_62425[(7)] = inst_62345__$1);

return statearr_62425;
})();
if(inst_62348){
var statearr_62426_62486 = state_62420__$1;
(statearr_62426_62486[(1)] = (5));

} else {
var statearr_62427_62487 = state_62420__$1;
(statearr_62427_62487[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (15))){
var inst_62369 = (state_62420[(2)]);
var state_62420__$1 = state_62420;
var statearr_62428_62488 = state_62420__$1;
(statearr_62428_62488[(2)] = inst_62369);

(statearr_62428_62488[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (13))){
var state_62420__$1 = state_62420;
var statearr_62429_62489 = state_62420__$1;
(statearr_62429_62489[(2)] = null);

(statearr_62429_62489[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (6))){
var inst_62345 = (state_62420[(7)]);
var inst_62351 = superv.async._track_exception.call(null,S,inst_62345);
var state_62420__$1 = state_62420;
var statearr_62430_62490 = state_62420__$1;
(statearr_62430_62490[(2)] = inst_62351);

(statearr_62430_62490[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (3))){
var inst_62342 = (state_62420[(2)]);
var inst_62343 = superv.async._unregister_go.call(null,S,id__23768__auto___62482);
var state_62420__$1 = (function (){var statearr_62431 = state_62420;
(statearr_62431[(9)] = inst_62343);

(statearr_62431[(10)] = inst_62342);

return statearr_62431;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62420__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (12))){
var inst_62364 = (state_62420[(2)]);
var state_62420__$1 = state_62420;
if(cljs.core.truth_(inst_62364)){
var statearr_62432_62491 = state_62420__$1;
(statearr_62432_62491[(1)] = (13));

} else {
var statearr_62433_62492 = state_62420__$1;
(statearr_62433_62492[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (2))){
var inst_62418 = (state_62420[(2)]);
var state_62420__$1 = state_62420;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62420__$1,inst_62418);
} else {
if((state_val_62421 === (11))){
var inst_62361 = (state_62420[(11)]);
var inst_62371 = (state_62420[(2)]);
var inst_62372 = null;
var inst_62373 = superv.async._register_go.call(null,inst_62371,inst_62372);
var inst_62414 = cljs.core.async.chan.call(null,(1));
var inst_62415 = (function (){var c__23767__auto____$1 = inst_62361;
var id__23768__auto____$1 = inst_62373;
var c__38457__auto____$1 = inst_62414;
return ((function (c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_62361,inst_62371,inst_62372,inst_62373,inst_62414,state_val_62421,c__38457__auto___62483,c__23767__auto___62481,id__23768__auto___62482){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_62361,inst_62371,inst_62372,inst_62373,inst_62414,state_val_62421,c__38457__auto___62483,c__23767__auto___62481,id__23768__auto___62482){
return (function (state_62412){
var state_val_62413 = (state_62412[(1)]);
if((state_val_62413 === (7))){
var state_62412__$1 = state_62412;
var statearr_62434_62493 = state_62412__$1;
(statearr_62434_62493[(2)] = null);

(statearr_62434_62493[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (20))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_62412,(10),Error,(3),(2));
var state_62412__$1 = state_62412;
var statearr_62435_62494 = state_62412__$1;
(statearr_62435_62494[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62412__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (1))){
var state_62412__$1 = state_62412;
var statearr_62436_62495 = state_62412__$1;
(statearr_62436_62495[(2)] = null);

(statearr_62436_62495[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (4))){
var state_62412__$1 = state_62412;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62412__$1,(6),ch);
} else {
if((state_val_62413 === (15))){
var inst_62387 = (state_62412[(7)]);
var inst_62402 = (state_62412[(2)]);
var inst_62403 = superv.async._track_exception.call(null,inst_62402,inst_62387);
var state_62412__$1 = state_62412;
var statearr_62437_62496 = state_62412__$1;
(statearr_62437_62496[(2)] = inst_62403);

(statearr_62437_62496[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (13))){
var inst_62387 = (state_62412[(7)]);
var inst_62405 = (state_62412[(2)]);
var state_62412__$1 = (function (){var statearr_62438 = state_62412;
(statearr_62438[(8)] = inst_62405);

return statearr_62438;
})();
var statearr_62439_62497 = state_62412__$1;
(statearr_62439_62497[(2)] = inst_62387);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62412__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (6))){
var inst_62377 = (state_62412[(2)]);
var state_62412__$1 = state_62412;
if(cljs.core.truth_(inst_62377)){
var statearr_62440_62498 = state_62412__$1;
(statearr_62440_62498[(1)] = (7));

} else {
var statearr_62441_62499 = state_62412__$1;
(statearr_62441_62499[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (17))){
var state_62412__$1 = state_62412;
var statearr_62442_62500 = state_62412__$1;
(statearr_62442_62500[(2)] = null);

(statearr_62442_62500[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (3))){
var inst_62374 = (state_62412[(2)]);
var state_62412__$1 = (function (){var statearr_62443 = state_62412;
(statearr_62443[(9)] = inst_62374);

return statearr_62443;
})();
var statearr_62444_62501 = state_62412__$1;
(statearr_62444_62501[(2)] = null);

(statearr_62444_62501[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (12))){
var state_62412__$1 = state_62412;
var statearr_62445_62502 = state_62412__$1;
(statearr_62445_62502[(2)] = null);

(statearr_62445_62502[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (2))){
var inst_62410 = (state_62412[(2)]);
var state_62412__$1 = state_62412;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62412__$1,inst_62410);
} else {
if((state_val_62413 === (19))){
var inst_62400 = (state_62412[(2)]);
var state_62412__$1 = state_62412;
var statearr_62446_62503 = state_62412__$1;
(statearr_62446_62503[(2)] = inst_62400);

(statearr_62446_62503[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (11))){
var state_62412__$1 = state_62412;
var statearr_62447_62504 = state_62412__$1;
(statearr_62447_62504[(2)] = null);

(statearr_62447_62504[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (9))){
var inst_62382 = (state_62412[(2)]);
var state_62412__$1 = state_62412;
var statearr_62448_62505 = state_62412__$1;
(statearr_62448_62505[(2)] = inst_62382);

(statearr_62448_62505[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (5))){
var inst_62384 = (state_62412[(2)]);
var inst_62385 = superv.async._unregister_go.call(null,inst_62384,id__23768__auto____$1);
var state_62412__$1 = (function (){var statearr_62449 = state_62412;
(statearr_62449[(10)] = inst_62385);

return statearr_62449;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62412__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (14))){
var state_62412__$1 = state_62412;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62412__$1,(16),ch);
} else {
if((state_val_62413 === (16))){
var inst_62395 = (state_62412[(2)]);
var state_62412__$1 = state_62412;
if(cljs.core.truth_(inst_62395)){
var statearr_62450_62506 = state_62412__$1;
(statearr_62450_62506[(1)] = (17));

} else {
var statearr_62451_62507 = state_62412__$1;
(statearr_62451_62507[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (10))){
var inst_62387 = (state_62412[(7)]);
var inst_62387__$1 = (state_62412[(2)]);
var inst_62388 = cljs.core.ex_data.call(null,inst_62387__$1);
var inst_62389 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_62388);
var inst_62390 = cljs.core._EQ_.call(null,inst_62389,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_62412__$1 = (function (){var statearr_62452 = state_62412;
(statearr_62452[(7)] = inst_62387__$1);

return statearr_62452;
})();
if(inst_62390){
var statearr_62453_62508 = state_62412__$1;
(statearr_62453_62508[(1)] = (11));

} else {
var statearr_62454_62509 = state_62412__$1;
(statearr_62454_62509[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (18))){
var state_62412__$1 = state_62412;
var statearr_62455_62510 = state_62412__$1;
(statearr_62455_62510[(2)] = null);

(statearr_62455_62510[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (8))){
var state_62412__$1 = state_62412;
var statearr_62456_62511 = state_62412__$1;
(statearr_62456_62511[(2)] = null);

(statearr_62456_62511[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_62361,inst_62371,inst_62372,inst_62373,inst_62414,state_val_62421,c__38457__auto___62483,c__23767__auto___62481,id__23768__auto___62482))
;
return ((function (switch__38343__auto__,c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_62361,inst_62371,inst_62372,inst_62373,inst_62414,state_val_62421,c__38457__auto___62483,c__23767__auto___62481,id__23768__auto___62482){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_62460 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_62460[(0)] = superv$async$state_machine__38344__auto__);

(statearr_62460[(1)] = (1));

return statearr_62460;
});
var superv$async$state_machine__38344__auto____1 = (function (state_62412){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_62412);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e62461){if((e62461 instanceof Object)){
var ex__38347__auto__ = e62461;
var statearr_62462_62512 = state_62412;
(statearr_62462_62512[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62412);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62461;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62513 = state_62412;
state_62412 = G__62513;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_62412){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_62412);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_62361,inst_62371,inst_62372,inst_62373,inst_62414,state_val_62421,c__38457__auto___62483,c__23767__auto___62481,id__23768__auto___62482))
})();
var state__38459__auto__ = (function (){var statearr_62463 = f__38458__auto__.call(null);
(statearr_62463[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto____$1);

return statearr_62463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});
;})(c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_62361,inst_62371,inst_62372,inst_62373,inst_62414,state_val_62421,c__38457__auto___62483,c__23767__auto___62481,id__23768__auto___62482))
})();
var inst_62416 = cljs.core.async.impl.dispatch.run.call(null,inst_62415);
var state_62420__$1 = (function (){var statearr_62464 = state_62420;
(statearr_62464[(12)] = inst_62416);

return statearr_62464;
})();
var statearr_62465_62514 = state_62420__$1;
(statearr_62465_62514[(2)] = inst_62414);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62420__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (9))){
var inst_62359 = (state_62420[(2)]);
var inst_62360 = cljs.core.async.close_BANG_.call(null,ch);
var inst_62361 = superv.async.check_supervisor.call(null,superv.async.S);
var state_62420__$1 = (function (){var statearr_62466 = state_62420;
(statearr_62466[(13)] = inst_62360);

(statearr_62466[(11)] = inst_62361);

(statearr_62466[(14)] = inst_62359);

return statearr_62466;
})();
var statearr_62467_62515 = state_62420__$1;
(statearr_62467_62515[(2)] = null);

(statearr_62467_62515[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (5))){
var state_62420__$1 = state_62420;
var statearr_62468_62516 = state_62420__$1;
(statearr_62468_62516[(2)] = null);

(statearr_62468_62516[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (14))){
var state_62420__$1 = state_62420;
var statearr_62469_62517 = state_62420__$1;
(statearr_62469_62517[(2)] = null);

(statearr_62469_62517[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (10))){
var state_62420__$1 = state_62420;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62420__$1,(12),ch);
} else {
if((state_val_62421 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_62420,(4),Error,(3),(2));
var inst_62357 = superv.async._abort.call(null,S);
var state_62420__$1 = state_62420;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62420__$1,(9),inst_62357);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___62483,c__23767__auto___62481,id__23768__auto___62482))
;
return ((function (switch__38343__auto__,c__38457__auto___62483,c__23767__auto___62481,id__23768__auto___62482){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_62473 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62473[(0)] = superv$async$state_machine__38344__auto__);

(statearr_62473[(1)] = (1));

return statearr_62473;
});
var superv$async$state_machine__38344__auto____1 = (function (state_62420){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_62420);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e62474){if((e62474 instanceof Object)){
var ex__38347__auto__ = e62474;
var statearr_62475_62518 = state_62420;
(statearr_62475_62518[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62420);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62474;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62519 = state_62420;
state_62420 = G__62519;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_62420){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_62420);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___62483,c__23767__auto___62481,id__23768__auto___62482))
})();
var state__38459__auto__ = (function (){var statearr_62476 = f__38458__auto__.call(null);
(statearr_62476[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___62483);

return statearr_62476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___62483,c__23767__auto___62481,id__23768__auto___62482))
);


return cljs.core.async.tap.call(null,mult,ch,close_QMARK_);
});

superv.async.tap.cljs$lang$maxFixedArity = 4;

/**
 * Safely managed subscription. The channel is closed on abortion and
 *   all pending puts are flushed.
 */
superv.async.sub = (function superv$async$sub(var_args){
var args62520 = [];
var len__10640__auto___62624 = arguments.length;
var i__10641__auto___62625 = (0);
while(true){
if((i__10641__auto___62625 < len__10640__auto___62624)){
args62520.push((arguments[i__10641__auto___62625]));

var G__62626 = (i__10641__auto___62625 + (1));
i__10641__auto___62625 = G__62626;
continue;
} else {
}
break;
}

var G__62522 = args62520.length;
switch (G__62522) {
case 4:
return superv.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.sub.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args62520.length)].join('')));

}
});

superv.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (S,p,topic,ch){
return superv.async.sub.call(null,S,p,topic,ch,false);
});

superv.async.sub.cljs$core$IFn$_invoke$arity$5 = (function (S,p,topic,ch,close_QMARK_){
var c__23767__auto___62628 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___62629 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__38457__auto___62630 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___62630,c__23767__auto___62628,id__23768__auto___62629){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___62630,c__23767__auto___62628,id__23768__auto___62629){
return (function (state_62581){
var state_val_62582 = (state_62581[(1)]);
if((state_val_62582 === (1))){
var state_62581__$1 = state_62581;
var statearr_62583_62631 = state_62581__$1;
(statearr_62583_62631[(2)] = null);

(statearr_62583_62631[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62582 === (2))){
var inst_62579 = (state_62581[(2)]);
var state_62581__$1 = state_62581;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62581__$1,inst_62579);
} else {
if((state_val_62582 === (3))){
var inst_62523 = (state_62581[(2)]);
var inst_62524 = superv.async._unregister_go.call(null,S,id__23768__auto___62629);
var state_62581__$1 = (function (){var statearr_62584 = state_62581;
(statearr_62584[(7)] = inst_62523);

(statearr_62584[(8)] = inst_62524);

return statearr_62584;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62581__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62582 === (4))){
var inst_62526 = (state_62581[(9)]);
var inst_62526__$1 = (state_62581[(2)]);
var inst_62527 = cljs.core.ex_data.call(null,inst_62526__$1);
var inst_62528 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_62527);
var inst_62529 = cljs.core._EQ_.call(null,inst_62528,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_62581__$1 = (function (){var statearr_62585 = state_62581;
(statearr_62585[(9)] = inst_62526__$1);

return statearr_62585;
})();
if(inst_62529){
var statearr_62586_62632 = state_62581__$1;
(statearr_62586_62632[(1)] = (5));

} else {
var statearr_62587_62633 = state_62581__$1;
(statearr_62587_62633[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62582 === (5))){
var state_62581__$1 = state_62581;
var statearr_62588_62634 = state_62581__$1;
(statearr_62588_62634[(2)] = null);

(statearr_62588_62634[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62582 === (6))){
var inst_62526 = (state_62581[(9)]);
var inst_62532 = superv.async._track_exception.call(null,S,inst_62526);
var state_62581__$1 = state_62581;
var statearr_62589_62635 = state_62581__$1;
(statearr_62589_62635[(2)] = inst_62532);

(statearr_62589_62635[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62582 === (7))){
var inst_62526 = (state_62581[(9)]);
var inst_62534 = (state_62581[(2)]);
var state_62581__$1 = (function (){var statearr_62590 = state_62581;
(statearr_62590[(10)] = inst_62534);

return statearr_62590;
})();
var statearr_62591_62636 = state_62581__$1;
(statearr_62591_62636[(2)] = inst_62526);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62581__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62582 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_62581,(4),Error,(3),(2));
var inst_62538 = superv.async._abort.call(null,S);
var state_62581__$1 = state_62581;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62581__$1,(9),inst_62538);
} else {
if((state_val_62582 === (9))){
var inst_62540 = (state_62581[(2)]);
var inst_62541 = cljs.core.async.close_BANG_.call(null,ch);
var inst_62542 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_62543 = cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))));
var inst_62544 = superv.async._register_go.call(null,S,inst_62543);
var inst_62575 = cljs.core.async.chan.call(null,(1));
var inst_62576 = (function (){var c__23767__auto____$1 = inst_62542;
var id__23768__auto____$1 = inst_62544;
var c__38457__auto____$1 = inst_62575;
return ((function (c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_62540,inst_62541,inst_62542,inst_62543,inst_62544,inst_62575,state_val_62582,c__38457__auto___62630,c__23767__auto___62628,id__23768__auto___62629){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_62540,inst_62541,inst_62542,inst_62543,inst_62544,inst_62575,state_val_62582,c__38457__auto___62630,c__23767__auto___62628,id__23768__auto___62629){
return (function (state_62573){
var state_val_62574 = (state_62573[(1)]);
if((state_val_62574 === (7))){
var inst_62548 = (state_62573[(7)]);
var inst_62556 = (state_62573[(2)]);
var state_62573__$1 = (function (){var statearr_62592 = state_62573;
(statearr_62592[(8)] = inst_62556);

return statearr_62592;
})();
var statearr_62593_62637 = state_62573__$1;
(statearr_62593_62637[(2)] = inst_62548);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62573__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62574 === (1))){
var state_62573__$1 = state_62573;
var statearr_62594_62638 = state_62573__$1;
(statearr_62594_62638[(2)] = null);

(statearr_62594_62638[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62574 === (4))){
var inst_62548 = (state_62573[(7)]);
var inst_62548__$1 = (state_62573[(2)]);
var inst_62549 = cljs.core.ex_data.call(null,inst_62548__$1);
var inst_62550 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_62549);
var inst_62551 = cljs.core._EQ_.call(null,inst_62550,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_62573__$1 = (function (){var statearr_62595 = state_62573;
(statearr_62595[(7)] = inst_62548__$1);

return statearr_62595;
})();
if(inst_62551){
var statearr_62596_62639 = state_62573__$1;
(statearr_62596_62639[(1)] = (5));

} else {
var statearr_62597_62640 = state_62573__$1;
(statearr_62597_62640[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62574 === (13))){
var state_62573__$1 = state_62573;
var statearr_62598_62641 = state_62573__$1;
(statearr_62598_62641[(2)] = null);

(statearr_62598_62641[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62574 === (6))){
var inst_62548 = (state_62573[(7)]);
var inst_62554 = superv.async._track_exception.call(null,S,inst_62548);
var state_62573__$1 = state_62573;
var statearr_62599_62642 = state_62573__$1;
(statearr_62599_62642[(2)] = inst_62554);

(statearr_62599_62642[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62574 === (3))){
var inst_62545 = (state_62573[(2)]);
var inst_62546 = superv.async._unregister_go.call(null,S,id__23768__auto____$1);
var state_62573__$1 = (function (){var statearr_62600 = state_62573;
(statearr_62600[(9)] = inst_62546);

(statearr_62600[(10)] = inst_62545);

return statearr_62600;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62573__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62574 === (12))){
var state_62573__$1 = state_62573;
var statearr_62601_62643 = state_62573__$1;
(statearr_62601_62643[(2)] = null);

(statearr_62601_62643[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62574 === (2))){
var inst_62571 = (state_62573[(2)]);
var state_62573__$1 = state_62573;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62573__$1,inst_62571);
} else {
if((state_val_62574 === (11))){
var inst_62562 = (state_62573[(2)]);
var state_62573__$1 = state_62573;
if(cljs.core.truth_(inst_62562)){
var statearr_62602_62644 = state_62573__$1;
(statearr_62602_62644[(1)] = (12));

} else {
var statearr_62603_62645 = state_62573__$1;
(statearr_62603_62645[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62574 === (9))){
var state_62573__$1 = state_62573;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62573__$1,(11),ch);
} else {
if((state_val_62574 === (5))){
var state_62573__$1 = state_62573;
var statearr_62604_62646 = state_62573__$1;
(statearr_62604_62646[(2)] = null);

(statearr_62604_62646[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62574 === (14))){
var inst_62567 = (state_62573[(2)]);
var state_62573__$1 = state_62573;
var statearr_62605_62647 = state_62573__$1;
(statearr_62605_62647[(2)] = inst_62567);

(statearr_62605_62647[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62574 === (10))){
var inst_62569 = (state_62573[(2)]);
var state_62573__$1 = state_62573;
var statearr_62606_62648 = state_62573__$1;
(statearr_62606_62648[(2)] = inst_62569);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62573__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62574 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_62573,(4),Error,(3),(2));
var state_62573__$1 = state_62573;
var statearr_62607_62649 = state_62573__$1;
(statearr_62607_62649[(2)] = null);

(statearr_62607_62649[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_62540,inst_62541,inst_62542,inst_62543,inst_62544,inst_62575,state_val_62582,c__38457__auto___62630,c__23767__auto___62628,id__23768__auto___62629))
;
return ((function (switch__38343__auto__,c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_62540,inst_62541,inst_62542,inst_62543,inst_62544,inst_62575,state_val_62582,c__38457__auto___62630,c__23767__auto___62628,id__23768__auto___62629){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_62611 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_62611[(0)] = superv$async$state_machine__38344__auto__);

(statearr_62611[(1)] = (1));

return statearr_62611;
});
var superv$async$state_machine__38344__auto____1 = (function (state_62573){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_62573);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e62612){if((e62612 instanceof Object)){
var ex__38347__auto__ = e62612;
var statearr_62613_62650 = state_62573;
(statearr_62613_62650[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62573);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62612;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62651 = state_62573;
state_62573 = G__62651;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_62573){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_62573);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_62540,inst_62541,inst_62542,inst_62543,inst_62544,inst_62575,state_val_62582,c__38457__auto___62630,c__23767__auto___62628,id__23768__auto___62629))
})();
var state__38459__auto__ = (function (){var statearr_62614 = f__38458__auto__.call(null);
(statearr_62614[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto____$1);

return statearr_62614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});
;})(c__23767__auto____$1,id__23768__auto____$1,c__38457__auto____$1,inst_62540,inst_62541,inst_62542,inst_62543,inst_62544,inst_62575,state_val_62582,c__38457__auto___62630,c__23767__auto___62628,id__23768__auto___62629))
})();
var inst_62577 = cljs.core.async.impl.dispatch.run.call(null,inst_62576);
var state_62581__$1 = (function (){var statearr_62615 = state_62581;
(statearr_62615[(11)] = inst_62577);

(statearr_62615[(12)] = inst_62541);

(statearr_62615[(13)] = inst_62540);

return statearr_62615;
})();
var statearr_62616_62652 = state_62581__$1;
(statearr_62616_62652[(2)] = inst_62575);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62581__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___62630,c__23767__auto___62628,id__23768__auto___62629))
;
return ((function (switch__38343__auto__,c__38457__auto___62630,c__23767__auto___62628,id__23768__auto___62629){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_62620 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62620[(0)] = superv$async$state_machine__38344__auto__);

(statearr_62620[(1)] = (1));

return statearr_62620;
});
var superv$async$state_machine__38344__auto____1 = (function (state_62581){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_62581);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e62621){if((e62621 instanceof Object)){
var ex__38347__auto__ = e62621;
var statearr_62622_62653 = state_62581;
(statearr_62622_62653[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62581);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62621;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62654 = state_62581;
state_62581 = G__62654;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_62581){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_62581);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___62630,c__23767__auto___62628,id__23768__auto___62629))
})();
var state__38459__auto__ = (function (){var statearr_62623 = f__38458__auto__.call(null);
(statearr_62623[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___62630);

return statearr_62623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___62630,c__23767__auto___62628,id__23768__auto___62629))
);


return cljs.core.async.sub.call(null,p,topic,ch,close_QMARK_);
});

superv.async.sub.cljs$lang$maxFixedArity = 5;

/**
 * Creates a supervised channel for transducer xform. Exceptions
 *   immediatly propagate to the supervisor.
 */
superv.async.chan_super = (function superv$async$chan_super(S,buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,(function (e){
return cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(S),e);
}));
});
/**
 * Starts a subsystem with supervised go-routines initialized by start-fn.
 *   Restarts the system on error for retries times with a potential delay in
 *   milliseconds, an optional error-fn predicate determining the retry and a
 *   optional filter by exception type. You can optionally pass a supervisor to
 *   form a supervision tree. Whenever this passed supervisor aborts the context,
 *   this supervisor will close as well. You still need to block on the result of
 *   this supervisor if you want a clean synchronized shutdown. The concept is
 *   similar to http://learnyousomeerlang.com/supervisors
 * 
 *   All blocking channel ops in the subroutines (supervised context) are
 *   aborted with an exception on error to force total termination. The
 *   supervisor waits until all supervised go-routines are finished and
 *   have freed resources before restarting.
 * 
 *   If exceptions are not taken from go-try channels (by error), they become stale
 *   after the stale-timeout and trigger a restart or are propagated to the parent
 *   supervisor (if available) and the return value.
 * 
 *   Note: The signature and behaviour of this function might still change.
 */
superv.async.restarting_supervisor = (function superv$async$restarting_supervisor(var_args){
var args__10647__auto__ = [];
var len__10640__auto___62962 = arguments.length;
var i__10641__auto___62963 = (0);
while(true){
if((i__10641__auto___62963 < len__10640__auto___62962)){
args__10647__auto__.push((arguments[i__10641__auto___62963]));

var G__62964 = (i__10641__auto___62963 + (1));
i__10641__auto___62963 = G__62964;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (start_fn,p__62669){
var map__62670 = p__62669;
var map__62670__$1 = ((((!((map__62670 == null)))?((((map__62670.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62670.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62670):map__62670);
var retries = cljs.core.get.call(null,map__62670__$1,new cljs.core.Keyword(null,"retries","retries",1888092808),Infinity);
var delay = cljs.core.get.call(null,map__62670__$1,new cljs.core.Keyword(null,"delay","delay",-574225219),(0));
var error_fn = cljs.core.get.call(null,map__62670__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),null);
var exception = cljs.core.get.call(null,map__62670__$1,new cljs.core.Keyword(null,"exception","exception",-335277064),Error);
var stale_timeout = cljs.core.get.call(null,map__62670__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((60) * (1000)));
var log_fn = cljs.core.get.call(null,map__62670__$1,new cljs.core.Keyword(null,"log-fn","log-fn",-2003241282),((function (map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout){
return (function (level,msg){
return cljs.core.println.call(null,level,msg);
});})(map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout))
);
var supervisor = cljs.core.get.call(null,map__62670__$1,new cljs.core.Keyword(null,"supervisor","supervisor",-134060208));
var retries__$1 = (function (){var or__9419__auto__ = retries;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return Infinity;
}
})();
var out_ch = cljs.core.async.chan.call(null);
var c__38457__auto___62965 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_62861){
var state_val_62862 = (state_62861[(1)]);
if((state_val_62862 === (7))){
var inst_62676 = (state_62861[(7)]);
var inst_62804 = (state_62861[(2)]);
var inst_62805 = cljs.core.nth.call(null,inst_62804,(0),null);
var inst_62806 = cljs.core.nth.call(null,inst_62804,(1),null);
var inst_62807 = cljs.core._EQ_.call(null,inst_62806,inst_62676);
var inst_62808 = !(inst_62807);
var state_62861__$1 = (function (){var statearr_62863 = state_62861;
(statearr_62863[(8)] = inst_62805);

return statearr_62863;
})();
if(inst_62808){
var statearr_62864_62966 = state_62861__$1;
(statearr_62864_62966[(1)] = (8));

} else {
var statearr_62865_62967 = state_62861__$1;
(statearr_62865_62967[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62862 === (20))){
var inst_62805 = (state_62861[(8)]);
var inst_62836 = (state_62861[(2)]);
var inst_62837 = cljs.core.async.put_BANG_.call(null,out_ch,inst_62805);
var inst_62838 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_62861__$1 = (function (){var statearr_62866 = state_62861;
(statearr_62866[(9)] = inst_62837);

(statearr_62866[(10)] = inst_62836);

return statearr_62866;
})();
var statearr_62867_62968 = state_62861__$1;
(statearr_62867_62968[(2)] = inst_62838);

(statearr_62867_62968[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62862 === (1))){
var inst_62672 = retries__$1;
var state_62861__$1 = (function (){var statearr_62868 = state_62861;
(statearr_62868[(11)] = inst_62672);

return statearr_62868;
})();
var statearr_62869_62969 = state_62861__$1;
(statearr_62869_62969[(2)] = null);

(statearr_62869_62969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62862 === (4))){
var inst_62684 = (state_62861[(12)]);
var inst_62674 = (state_62861[(13)]);
var inst_62675 = (state_62861[(14)]);
var inst_62676 = (state_62861[(7)]);
var inst_62672 = (state_62861[(11)]);
var inst_62685 = (state_62861[(15)]);
var inst_62687 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_62688 = cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"supervisor","supervisor",1506471319,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ab-ch","ab-ch",-698106711,null)));
var inst_62689 = superv.async._register_go.call(null,supervisor,inst_62688);
var inst_62714 = cljs.core.async.chan.call(null,(1));
var inst_62715 = (function (){var stale_timeout__$1 = (1000);
var c__23767__auto__ = inst_62687;
var id__23768__auto__ = inst_62689;
var err_ch = inst_62674;
var ab_ch = inst_62675;
var res_ch = inst_62685;
var close_ch = inst_62676;
var retries__$2 = inst_62672;
var s = inst_62684;
var c__38457__auto____$1 = inst_62714;
return ((function (stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62687,inst_62688,inst_62689,inst_62714,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62687,inst_62688,inst_62689,inst_62714,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_62712){
var state_val_62713 = (state_62712[(1)]);
if((state_val_62713 === (1))){
var state_62712__$1 = state_62712;
var statearr_62870_62970 = state_62712__$1;
(statearr_62870_62970[(2)] = null);

(statearr_62870_62970[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62713 === (2))){
var inst_62710 = (state_62712[(2)]);
var state_62712__$1 = state_62712;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62712__$1,inst_62710);
} else {
if((state_val_62713 === (3))){
var inst_62690 = (state_62712[(2)]);
var inst_62691 = superv.async._unregister_go.call(null,supervisor,id__23768__auto__);
var state_62712__$1 = (function (){var statearr_62871 = state_62712;
(statearr_62871[(7)] = inst_62691);

(statearr_62871[(8)] = inst_62690);

return statearr_62871;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62712__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62713 === (4))){
var inst_62693 = (state_62712[(9)]);
var inst_62693__$1 = (state_62712[(2)]);
var inst_62694 = cljs.core.ex_data.call(null,inst_62693__$1);
var inst_62695 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_62694);
var inst_62696 = cljs.core._EQ_.call(null,inst_62695,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_62712__$1 = (function (){var statearr_62872 = state_62712;
(statearr_62872[(9)] = inst_62693__$1);

return statearr_62872;
})();
if(inst_62696){
var statearr_62873_62971 = state_62712__$1;
(statearr_62873_62971[(1)] = (5));

} else {
var statearr_62874_62972 = state_62712__$1;
(statearr_62874_62972[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62713 === (5))){
var state_62712__$1 = state_62712;
var statearr_62875_62973 = state_62712__$1;
(statearr_62875_62973[(2)] = null);

(statearr_62875_62973[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62713 === (6))){
var inst_62693 = (state_62712[(9)]);
var inst_62699 = superv.async._track_exception.call(null,supervisor,inst_62693);
var state_62712__$1 = state_62712;
var statearr_62876_62974 = state_62712__$1;
(statearr_62876_62974[(2)] = inst_62699);

(statearr_62876_62974[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62713 === (7))){
var inst_62693 = (state_62712[(9)]);
var inst_62701 = (state_62712[(2)]);
var state_62712__$1 = (function (){var statearr_62877 = state_62712;
(statearr_62877[(10)] = inst_62701);

return statearr_62877;
})();
var statearr_62878_62975 = state_62712__$1;
(statearr_62878_62975[(2)] = inst_62693);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62712__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62713 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_62712,(4),Error,(3),(2));
var inst_62705 = superv.async._abort.call(null,supervisor);
var state_62712__$1 = state_62712;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62712__$1,(9),inst_62705);
} else {
if((state_val_62713 === (9))){
var inst_62707 = (state_62712[(2)]);
var inst_62708 = cljs.core.async.close_BANG_.call(null,ab_ch);
var state_62712__$1 = (function (){var statearr_62879 = state_62712;
(statearr_62879[(11)] = inst_62707);

return statearr_62879;
})();
var statearr_62880_62976 = state_62712__$1;
(statearr_62880_62976[(2)] = inst_62708);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62712__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62687,inst_62688,inst_62689,inst_62714,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__38343__auto__,stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62687,inst_62688,inst_62689,inst_62714,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_62884 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62884[(0)] = superv$async$state_machine__38344__auto__);

(statearr_62884[(1)] = (1));

return statearr_62884;
});
var superv$async$state_machine__38344__auto____1 = (function (state_62712){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_62712);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e62885){if((e62885 instanceof Object)){
var ex__38347__auto__ = e62885;
var statearr_62886_62977 = state_62712;
(statearr_62886_62977[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62712);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62885;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62978 = state_62712;
state_62712 = G__62978;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_62712){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_62712);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62687,inst_62688,inst_62689,inst_62714,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__38459__auto__ = (function (){var statearr_62887 = f__38458__auto__.call(null);
(statearr_62887[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto____$1);

return statearr_62887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});
;})(stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62687,inst_62688,inst_62689,inst_62714,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_62716 = cljs.core.async.impl.dispatch.run.call(null,inst_62715);
var state_62861__$1 = (function (){var statearr_62888 = state_62861;
(statearr_62888[(16)] = inst_62716);

return statearr_62888;
})();
var statearr_62889_62979 = state_62861__$1;
(statearr_62889_62979[(2)] = inst_62714);

(statearr_62889_62979[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62862 === (15))){
var inst_62805 = (state_62861[(8)]);
var inst_62827 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62828 = [new cljs.core.Keyword(null,"passing-error","passing-error",-1357712542),inst_62805];
var inst_62829 = cljs.core.PersistentHashMap.fromArrays(inst_62827,inst_62828);
var inst_62830 = log_fn.call(null,new cljs.core.Keyword(null,"error","error",-978969032),inst_62829);
var state_62861__$1 = (function (){var statearr_62890 = state_62861;
(statearr_62890[(17)] = inst_62830);

return statearr_62890;
})();
if(cljs.core.truth_(supervisor)){
var statearr_62891_62980 = state_62861__$1;
(statearr_62891_62980[(1)] = (18));

} else {
var statearr_62892_62981 = state_62861__$1;
(statearr_62892_62981[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62862 === (21))){
var inst_62805 = (state_62861[(8)]);
var inst_62672 = (state_62861[(11)]);
var inst_62842 = (state_62861[(2)]);
var inst_62843 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"further-retries","further-retries",1297645153)];
var inst_62844 = [new cljs.core.Keyword(null,"retry","retry",-614012896),inst_62805,inst_62672];
var inst_62845 = cljs.core.PersistentHashMap.fromArrays(inst_62843,inst_62844);
var inst_62846 = log_fn.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),inst_62845);
var inst_62847 = (inst_62672 - (1));
var inst_62672__$1 = inst_62847;
var state_62861__$1 = (function (){var statearr_62893 = state_62861;
(statearr_62893[(18)] = inst_62846);

(statearr_62893[(19)] = inst_62842);

(statearr_62893[(11)] = inst_62672__$1);

return statearr_62893;
})();
var statearr_62894_62982 = state_62861__$1;
(statearr_62894_62982[(2)] = null);

(statearr_62894_62982[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62862 === (13))){
var inst_62805 = (state_62861[(8)]);
var inst_62819 = error_fn.call(null,inst_62805);
var state_62861__$1 = state_62861;
var statearr_62895_62983 = state_62861__$1;
(statearr_62895_62983[(2)] = inst_62819);

(statearr_62895_62983[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62862 === (22))){
var inst_62853 = (state_62861[(2)]);
var inst_62854 = cljs.core.async.put_BANG_.call(null,out_ch,inst_62853);
var inst_62855 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_62861__$1 = (function (){var statearr_62896 = state_62861;
(statearr_62896[(20)] = inst_62854);

return statearr_62896;
})();
var statearr_62897_62984 = state_62861__$1;
(statearr_62897_62984[(2)] = inst_62855);

(statearr_62897_62984[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62862 === (6))){
var inst_62684 = (state_62861[(12)]);
var inst_62674 = (state_62861[(13)]);
var inst_62675 = (state_62861[(14)]);
var inst_62676 = (state_62861[(7)]);
var inst_62672 = (state_62861[(11)]);
var inst_62685 = (state_62861[(15)]);
var inst_62719 = (state_62861[(2)]);
var inst_62766 = cljs.core.async.chan.call(null,(1));
var inst_62767 = (function (){var retries__$2 = inst_62672;
var err_ch = inst_62674;
var ab_ch = inst_62675;
var close_ch = inst_62676;
var s = inst_62684;
var res_ch = inst_62685;
var stale_timeout__$1 = (1000);
var c__38457__auto____$1 = inst_62766;
return ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62719,inst_62766,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62719,inst_62766,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_62764){
var state_val_62765 = (state_62764[(1)]);
if((state_val_62765 === (7))){
var inst_62739 = (state_62764[(7)]);
var inst_62726 = (state_62764[(2)]);
var inst_62734 = (function (){return ((function (inst_62739,inst_62726,state_val_62765,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62719,inst_62766,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (p__62733){
var vec__62898 = p__62733;
var k = cljs.core.nth.call(null,vec__62898,(0),null);
var v = cljs.core.nth.call(null,vec__62898,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout__$1) > v.getTime());
});
;})(inst_62739,inst_62726,state_val_62765,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62719,inst_62766,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_62735 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_62736 = cljs.core.deref.call(null,inst_62735);
var inst_62737 = cljs.core.filter.call(null,inst_62734,inst_62736);
var inst_62738 = cljs.core.nth.call(null,inst_62737,(0),null);
var inst_62739__$1 = cljs.core.nth.call(null,inst_62738,(0),null);
var inst_62740 = cljs.core.nth.call(null,inst_62738,(1),null);
var state_62764__$1 = (function (){var statearr_62901 = state_62764;
(statearr_62901[(8)] = inst_62726);

(statearr_62901[(7)] = inst_62739__$1);

(statearr_62901[(9)] = inst_62740);

return statearr_62901;
})();
if(cljs.core.truth_(inst_62739__$1)){
var statearr_62902_62985 = state_62764__$1;
(statearr_62902_62985[(1)] = (8));

} else {
var statearr_62903_62986 = state_62764__$1;
(statearr_62903_62986[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62765 === (1))){
var state_62764__$1 = state_62764;
var statearr_62904_62987 = state_62764__$1;
(statearr_62904_62987[(2)] = null);

(statearr_62904_62987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62765 === (4))){
var state_62764__$1 = state_62764;
var statearr_62905_62988 = state_62764__$1;
(statearr_62905_62988[(2)] = null);

(statearr_62905_62988[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62765 === (13))){
var inst_62739 = (state_62764[(7)]);
var inst_62752 = (state_62764[(2)]);
var inst_62753 = superv.async._free_exception.call(null,s,inst_62739);
var inst_62754 = cljs.core.async.put_BANG_.call(null,err_ch,inst_62739);
var state_62764__$1 = (function (){var statearr_62906 = state_62764;
(statearr_62906[(10)] = inst_62753);

(statearr_62906[(11)] = inst_62752);

return statearr_62906;
})();
var statearr_62907_62989 = state_62764__$1;
(statearr_62907_62989[(2)] = inst_62754);

(statearr_62907_62989[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62765 === (6))){
var inst_62760 = (state_62764[(2)]);
var state_62764__$1 = state_62764;
var statearr_62908_62990 = state_62764__$1;
(statearr_62908_62990[(2)] = inst_62760);

(statearr_62908_62990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62765 === (3))){
var inst_62762 = (state_62764[(2)]);
var state_62764__$1 = state_62764;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62764__$1,inst_62762);
} else {
if((state_val_62765 === (12))){
var inst_62739 = (state_62764[(7)]);
var inst_62747 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62748 = [new cljs.core.Keyword(null,"stale-error-in-supervisor","stale-error-in-supervisor",-123257662),inst_62739];
var inst_62749 = cljs.core.PersistentHashMap.fromArrays(inst_62747,inst_62748);
var inst_62750 = log_fn.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_62749);
var state_62764__$1 = state_62764;
var statearr_62909_62991 = state_62764__$1;
(statearr_62909_62991[(2)] = inst_62750);

(statearr_62909_62991[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62765 === (2))){
var inst_62721 = cljs.core.async.poll_BANG_.call(null,ab_ch);
var state_62764__$1 = state_62764;
if(cljs.core.truth_(inst_62721)){
var statearr_62910_62992 = state_62764__$1;
(statearr_62910_62992[(1)] = (4));

} else {
var statearr_62911_62993 = state_62764__$1;
(statearr_62911_62993[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62765 === (11))){
var state_62764__$1 = state_62764;
var statearr_62912_62994 = state_62764__$1;
(statearr_62912_62994[(2)] = null);

(statearr_62912_62994[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62765 === (9))){
var state_62764__$1 = state_62764;
var statearr_62913_62995 = state_62764__$1;
(statearr_62913_62995[(2)] = null);

(statearr_62913_62995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62765 === (5))){
var inst_62724 = cljs.core.async.timeout.call(null,stale_timeout__$1);
var state_62764__$1 = state_62764;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62764__$1,(7),inst_62724);
} else {
if((state_val_62765 === (10))){
var inst_62758 = (state_62764[(2)]);
var state_62764__$1 = state_62764;
var statearr_62914_62996 = state_62764__$1;
(statearr_62914_62996[(2)] = inst_62758);

(statearr_62914_62996[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62765 === (8))){
var inst_62739 = (state_62764[(7)]);
var inst_62742 = cljs.core.ex_data.call(null,inst_62739);
var inst_62743 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_62742);
var inst_62744 = cljs.core._EQ_.call(null,inst_62743,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_62764__$1 = state_62764;
if(inst_62744){
var statearr_62915_62997 = state_62764__$1;
(statearr_62915_62997[(1)] = (11));

} else {
var statearr_62916_62998 = state_62764__$1;
(statearr_62916_62998[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62719,inst_62766,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__38343__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62719,inst_62766,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_62920 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62920[(0)] = superv$async$state_machine__38344__auto__);

(statearr_62920[(1)] = (1));

return statearr_62920;
});
var superv$async$state_machine__38344__auto____1 = (function (state_62764){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_62764);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e62921){if((e62921 instanceof Object)){
var ex__38347__auto__ = e62921;
var statearr_62922_62999 = state_62764;
(statearr_62922_62999[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62764);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62921;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63000 = state_62764;
state_62764 = G__63000;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_62764){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_62764);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62719,inst_62766,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__38459__auto__ = (function (){var statearr_62923 = f__38458__auto__.call(null);
(statearr_62923[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto____$1);

return statearr_62923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});
;})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62719,inst_62766,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_62768 = cljs.core.async.impl.dispatch.run.call(null,inst_62767);
var inst_62794 = cljs.core.async.chan.call(null,(1));
var inst_62795 = (function (){var retries__$2 = inst_62672;
var err_ch = inst_62674;
var ab_ch = inst_62675;
var close_ch = inst_62676;
var s = inst_62684;
var res_ch = inst_62685;
var stale_timeout__$1 = (1000);
var c__38457__auto____$1 = inst_62794;
return ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62719,inst_62766,inst_62767,inst_62768,inst_62794,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62719,inst_62766,inst_62767,inst_62768,inst_62794,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_62792){
var state_val_62793 = (state_62792[(1)]);
if((state_val_62793 === (1))){
var inst_62769 = (0);
var state_62792__$1 = (function (){var statearr_62924 = state_62792;
(statearr_62924[(7)] = inst_62769);

return statearr_62924;
})();
var statearr_62925_63001 = state_62792__$1;
(statearr_62925_63001[(2)] = null);

(statearr_62925_63001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62793 === (2))){
var inst_62771 = new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(s);
var inst_62772 = cljs.core.deref.call(null,inst_62771);
var inst_62773 = cljs.core.empty_QMARK_.call(null,inst_62772);
var inst_62774 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_62775 = cljs.core.deref.call(null,inst_62774);
var inst_62776 = cljs.core.empty_QMARK_.call(null,inst_62775);
var inst_62777 = (inst_62773) && (inst_62776);
var inst_62778 = cljs.core.not.call(null,inst_62777);
var state_62792__$1 = state_62792;
if(inst_62778){
var statearr_62926_63002 = state_62792__$1;
(statearr_62926_63002[(1)] = (4));

} else {
var statearr_62927_63003 = state_62792__$1;
(statearr_62927_63003[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62793 === (3))){
var inst_62790 = (state_62792[(2)]);
var state_62792__$1 = state_62792;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62792__$1,inst_62790);
} else {
if((state_val_62793 === (4))){
var inst_62780 = cljs.core.async.timeout.call(null,(100));
var state_62792__$1 = state_62792;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62792__$1,(7),inst_62780);
} else {
if((state_val_62793 === (5))){
var inst_62786 = cljs.core.async.close_BANG_.call(null,close_ch);
var state_62792__$1 = state_62792;
var statearr_62928_63004 = state_62792__$1;
(statearr_62928_63004[(2)] = inst_62786);

(statearr_62928_63004[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62793 === (6))){
var inst_62788 = (state_62792[(2)]);
var state_62792__$1 = state_62792;
var statearr_62929_63005 = state_62792__$1;
(statearr_62929_63005[(2)] = inst_62788);

(statearr_62929_63005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62793 === (7))){
var inst_62769 = (state_62792[(7)]);
var inst_62782 = (state_62792[(2)]);
var inst_62783 = (inst_62769 + (1));
var inst_62769__$1 = inst_62783;
var state_62792__$1 = (function (){var statearr_62930 = state_62792;
(statearr_62930[(7)] = inst_62769__$1);

(statearr_62930[(8)] = inst_62782);

return statearr_62930;
})();
var statearr_62931_63006 = state_62792__$1;
(statearr_62931_63006[(2)] = null);

(statearr_62931_63006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62719,inst_62766,inst_62767,inst_62768,inst_62794,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__38343__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62719,inst_62766,inst_62767,inst_62768,inst_62794,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_62935 = [null,null,null,null,null,null,null,null,null];
(statearr_62935[(0)] = superv$async$state_machine__38344__auto__);

(statearr_62935[(1)] = (1));

return statearr_62935;
});
var superv$async$state_machine__38344__auto____1 = (function (state_62792){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_62792);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e62936){if((e62936 instanceof Object)){
var ex__38347__auto__ = e62936;
var statearr_62937_63007 = state_62792;
(statearr_62937_63007[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62792);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62936;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63008 = state_62792;
state_62792 = G__63008;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_62792){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_62792);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62719,inst_62766,inst_62767,inst_62768,inst_62794,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__38459__auto__ = (function (){var statearr_62938 = f__38458__auto__.call(null);
(statearr_62938[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto____$1);

return statearr_62938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});
;})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38457__auto____$1,inst_62684,inst_62674,inst_62675,inst_62676,inst_62672,inst_62685,inst_62719,inst_62766,inst_62767,inst_62768,inst_62794,state_val_62862,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_62796 = cljs.core.async.impl.dispatch.run.call(null,inst_62795);
var inst_62800 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62801 = [inst_62674,inst_62676];
var inst_62802 = (new cljs.core.PersistentVector(null,2,(5),inst_62800,inst_62801,null));
var state_62861__$1 = (function (){var statearr_62939 = state_62861;
(statearr_62939[(21)] = inst_62796);

(statearr_62939[(22)] = inst_62768);

(statearr_62939[(23)] = inst_62719);

return statearr_62939;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_62861__$1,(7),inst_62802,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_62862 === (17))){
var inst_62850 = (state_62861[(2)]);
var state_62861__$1 = state_62861;
var statearr_62940_63009 = state_62861__$1;
(statearr_62940_63009[(2)] = inst_62850);

(statearr_62940_63009[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62862 === (3))){
var inst_62859 = (state_62861[(2)]);
var state_62861__$1 = state_62861;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62861__$1,inst_62859);
} else {
if((state_val_62862 === (12))){
var inst_62816 = (state_62861[(24)]);
var state_62861__$1 = state_62861;
var statearr_62941_63010 = state_62861__$1;
(statearr_62941_63010[(2)] = inst_62816);

(statearr_62941_63010[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62862 === (2))){
var inst_62684 = (state_62861[(12)]);
var inst_62674 = (state_62861[(13)]);
var inst_62675 = (state_62861[(14)]);
var inst_62674__$1 = cljs.core.async.chan.call(null);
var inst_62675__$1 = cljs.core.async.chan.call(null);
var inst_62676 = cljs.core.async.chan.call(null);
var inst_62677 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),new cljs.core.Keyword(null,"restarting","restarting",760677572)];
var inst_62678 = cljs.core.PersistentHashMap.EMPTY;
var inst_62679 = cljs.core.atom.call(null,inst_62678);
var inst_62680 = cljs.core.PersistentHashMap.EMPTY;
var inst_62681 = cljs.core.atom.call(null,inst_62680);
var inst_62682 = [inst_62674__$1,inst_62675__$1,inst_62679,inst_62681,true];
var inst_62683 = cljs.core.PersistentHashMap.fromArrays(inst_62677,inst_62682);
var inst_62684__$1 = superv.async.map__GT_TrackingSupervisor.call(null,inst_62683);
var inst_62685 = start_fn.call(null,inst_62684__$1);
var state_62861__$1 = (function (){var statearr_62942 = state_62861;
(statearr_62942[(12)] = inst_62684__$1);

(statearr_62942[(13)] = inst_62674__$1);

(statearr_62942[(14)] = inst_62675__$1);

(statearr_62942[(7)] = inst_62676);

(statearr_62942[(15)] = inst_62685);

return statearr_62942;
})();
if(cljs.core.truth_(supervisor)){
var statearr_62943_63011 = state_62861__$1;
(statearr_62943_63011[(1)] = (4));

} else {
var statearr_62944_63012 = state_62861__$1;
(statearr_62944_63012[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62862 === (19))){
var state_62861__$1 = state_62861;
var statearr_62945_63013 = state_62861__$1;
(statearr_62945_63013[(2)] = null);

(statearr_62945_63013[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62862 === (11))){
var inst_62805 = (state_62861[(8)]);
var inst_62816 = (state_62861[(24)]);
var inst_62813 = (state_62861[(2)]);
var inst_62814 = (inst_62805 instanceof exception);
var inst_62815 = cljs.core.not.call(null,inst_62814);
var inst_62816__$1 = cljs.core.not.call(null,error_fn);
var state_62861__$1 = (function (){var statearr_62946 = state_62861;
(statearr_62946[(25)] = inst_62813);

(statearr_62946[(24)] = inst_62816__$1);

(statearr_62946[(26)] = inst_62815);

return statearr_62946;
})();
if(inst_62816__$1){
var statearr_62947_63014 = state_62861__$1;
(statearr_62947_63014[(1)] = (12));

} else {
var statearr_62948_63015 = state_62861__$1;
(statearr_62948_63015[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62862 === (9))){
var inst_62685 = (state_62861[(15)]);
var state_62861__$1 = state_62861;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62861__$1,(22),inst_62685);
} else {
if((state_val_62862 === (5))){
var state_62861__$1 = state_62861;
var statearr_62949_63016 = state_62861__$1;
(statearr_62949_63016[(2)] = null);

(statearr_62949_63016[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62862 === (14))){
var inst_62815 = (state_62861[(26)]);
var inst_62672 = (state_62861[(11)]);
var inst_62821 = (state_62861[(2)]);
var inst_62822 = cljs.core.not.call(null,inst_62821);
var inst_62823 = (inst_62672 > (0));
var inst_62824 = cljs.core.not.call(null,inst_62823);
var inst_62825 = (inst_62815) || (inst_62822) || (inst_62824);
var state_62861__$1 = state_62861;
if(cljs.core.truth_(inst_62825)){
var statearr_62950_63017 = state_62861__$1;
(statearr_62950_63017[(1)] = (15));

} else {
var statearr_62951_63018 = state_62861__$1;
(statearr_62951_63018[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62862 === (16))){
var inst_62840 = cljs.core.async.timeout.call(null,delay);
var state_62861__$1 = state_62861;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62861__$1,(21),inst_62840);
} else {
if((state_val_62862 === (10))){
var inst_62857 = (state_62861[(2)]);
var state_62861__$1 = state_62861;
var statearr_62952_63019 = state_62861__$1;
(statearr_62952_63019[(2)] = inst_62857);

(statearr_62952_63019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62862 === (18))){
var inst_62805 = (state_62861[(8)]);
var inst_62832 = superv.async._error.call(null,supervisor);
var inst_62833 = cljs.core.async.put_BANG_.call(null,inst_62832,inst_62805);
var state_62861__$1 = state_62861;
var statearr_62953_63020 = state_62861__$1;
(statearr_62953_63020[(2)] = inst_62833);

(statearr_62953_63020[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62862 === (8))){
var inst_62674 = (state_62861[(13)]);
var inst_62675 = (state_62861[(14)]);
var inst_62676 = (state_62861[(7)]);
var inst_62810 = cljs.core.async.close_BANG_.call(null,inst_62674);
var inst_62811 = cljs.core.async.close_BANG_.call(null,inst_62675);
var state_62861__$1 = (function (){var statearr_62954 = state_62861;
(statearr_62954[(27)] = inst_62810);

(statearr_62954[(28)] = inst_62811);

return statearr_62954;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62861__$1,(11),inst_62676);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__38343__auto__,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__38344__auto__ = null;
var superv$async$state_machine__38344__auto____0 = (function (){
var statearr_62958 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62958[(0)] = superv$async$state_machine__38344__auto__);

(statearr_62958[(1)] = (1));

return statearr_62958;
});
var superv$async$state_machine__38344__auto____1 = (function (state_62861){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_62861);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e62959){if((e62959 instanceof Object)){
var ex__38347__auto__ = e62959;
var statearr_62960_63021 = state_62861;
(statearr_62960_63021[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62861);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62959;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63022 = state_62861;
state_62861 = G__63022;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
superv$async$state_machine__38344__auto__ = function(state_62861){
switch(arguments.length){
case 0:
return superv$async$state_machine__38344__auto____0.call(this);
case 1:
return superv$async$state_machine__38344__auto____1.call(this,state_62861);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38344__auto____0;
superv$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38344__auto____1;
return superv$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__38459__auto__ = (function (){var statearr_62961 = f__38458__auto__.call(null);
(statearr_62961[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___62965);

return statearr_62961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___62965,retries__$1,out_ch,map__62670,map__62670__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
);


return out_ch;
});

superv.async.restarting_supervisor.cljs$lang$maxFixedArity = (1);

superv.async.restarting_supervisor.cljs$lang$applyTo = (function (seq62667){
var G__62668 = cljs.core.first.call(null,seq62667);
var seq62667__$1 = cljs.core.next.call(null,seq62667);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic(G__62668,seq62667__$1);
});


//# sourceMappingURL=async.js.map