// Compiled by ClojureScript 1.9.521 {}
goog.provide('hasch.benc');
goog.require('cljs.core');

/**
 * @interface
 */
hasch.benc.PHashCoercion = function(){};

hasch.benc._coerce = (function hasch$benc$_coerce(this$,md_create_fn,write_handlers){
if((!((this$ == null))) && (!((this$.hasch$benc$PHashCoercion$_coerce$arity$3 == null)))){
return this$.hasch$benc$PHashCoercion$_coerce$arity$3(this$,md_create_fn,write_handlers);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (hasch.benc._coerce[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,md_create_fn,write_handlers);
} else {
var m__10138__auto____$1 = (hasch.benc._coerce["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,md_create_fn,write_handlers);
} else {
throw cljs.core.missing_protocol.call(null,"PHashCoercion.-coerce",this$);
}
}
}
});

hasch.benc.magics = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"binary","binary",-1802232288),new cljs.core.Keyword(null,"inst","inst",645962501),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Keyword(null,"symbol","symbol",-1038572696),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"vector","vector",1902966158),new cljs.core.Keyword(null,"keyword","keyword",811389747),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"literal","literal",1664775605),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"seq","seq",-1817803783),new cljs.core.Keyword(null,"set","set",304602554),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"map","map",1371690461)],[(13),(6),(2),(4),(3),(9),(5),(0),(12),(7),(8),(11),(1),(10)]);
hasch.benc.split_size = (1024);
hasch.benc.max_entropy_byte_count = (32);
hasch.benc.byte_array = (function hasch$benc$byte_array(len){
return cljs.core.into_array.call(null,cljs.core.repeat.call(null,len,(0)));
});
hasch.benc.digest = (function hasch$benc$digest(bytes_or_seq_of_bytes,md_create_fn){
var md = md_create_fn.call(null);
if(cljs.core.seq_QMARK_.call(null,bytes_or_seq_of_bytes)){
var seq__83135_83139 = cljs.core.seq.call(null,bytes_or_seq_of_bytes);
var chunk__83136_83140 = null;
var count__83137_83141 = (0);
var i__83138_83142 = (0);
while(true){
if((i__83138_83142 < count__83137_83141)){
var bs_83143 = cljs.core._nth.call(null,chunk__83136_83140,i__83138_83142);
md.update(bs_83143);

var G__83144 = seq__83135_83139;
var G__83145 = chunk__83136_83140;
var G__83146 = count__83137_83141;
var G__83147 = (i__83138_83142 + (1));
seq__83135_83139 = G__83144;
chunk__83136_83140 = G__83145;
count__83137_83141 = G__83146;
i__83138_83142 = G__83147;
continue;
} else {
var temp__6738__auto___83148 = cljs.core.seq.call(null,seq__83135_83139);
if(temp__6738__auto___83148){
var seq__83135_83149__$1 = temp__6738__auto___83148;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__83135_83149__$1)){
var c__10330__auto___83150 = cljs.core.chunk_first.call(null,seq__83135_83149__$1);
var G__83151 = cljs.core.chunk_rest.call(null,seq__83135_83149__$1);
var G__83152 = c__10330__auto___83150;
var G__83153 = cljs.core.count.call(null,c__10330__auto___83150);
var G__83154 = (0);
seq__83135_83139 = G__83151;
chunk__83136_83140 = G__83152;
count__83137_83141 = G__83153;
i__83138_83142 = G__83154;
continue;
} else {
var bs_83155 = cljs.core.first.call(null,seq__83135_83149__$1);
md.update(bs_83155);

var G__83156 = cljs.core.next.call(null,seq__83135_83149__$1);
var G__83157 = null;
var G__83158 = (0);
var G__83159 = (0);
seq__83135_83139 = G__83156;
chunk__83136_83140 = G__83157;
count__83137_83141 = G__83158;
i__83138_83142 = G__83159;
continue;
}
} else {
}
}
break;
}
} else {
md.update(bytes_or_seq_of_bytes);
}

return md.digest();
});
hasch.benc.coerce_seq = (function hasch$benc$coerce_seq(seq,md_create_fn,write_handlers){
var seq_md = md_create_fn.call(null);
var s_83166 = seq;
while(true){
var vec__83163_83167 = s_83166;
var seq__83164_83168 = cljs.core.seq.call(null,vec__83163_83167);
var first__83165_83169 = cljs.core.first.call(null,seq__83164_83168);
var seq__83164_83170__$1 = cljs.core.next.call(null,seq__83164_83168);
var f_83171 = first__83165_83169;
var r_83172 = seq__83164_83170__$1;
seq_md.update(hasch.benc._coerce.call(null,f_83171,md_create_fn,write_handlers));

if(cljs.core.empty_QMARK_.call(null,r_83172)){
} else {
var G__83173 = cljs.core.rest.call(null,s_83166);
s_83166 = G__83173;
continue;
}
break;
}

return seq_md.digest();
});
/**
 * Commutatively coerces elements of collection, seq entries must already be crypto hashes
 *   to avoid collisions in XOR. Takes at maximum 32 bytes into account.
 */
hasch.benc.xor_hashes = (function hasch$benc$xor_hashes(seq){
var len = (function (){var x__9764__auto__ = cljs.core.count.call(null,cljs.core.first.call(null,seq));
var y__9765__auto__ = hasch.benc.max_entropy_byte_count;
return ((x__9764__auto__ < y__9765__auto__) ? x__9764__auto__ : y__9765__auto__);
})();
return cljs.core.reduce.call(null,((function (len){
return (function (acc,elem){
var i_83174 = (0);
while(true){
if((i_83174 < len)){
(acc[i_83174] = ((acc[i_83174]) ^ (elem[i_83174])));

var G__83175 = (i_83174 + (1));
i_83174 = G__83175;
continue;
} else {
}
break;
}

return acc;
});})(len))
,hasch.benc.byte_array.call(null,len),seq);
});
hasch.benc.encode_safe = (function hasch$benc$encode_safe(a,md_create_fn){
if((cljs.core.count.call(null,a) < hasch.benc.split_size)){
var len = cljs.core.long$.call(null,a.length);
var ea = hasch.benc.byte_array.call(null,len);
var i_83176 = (0);
while(true){
if(cljs.core._EQ_.call(null,i_83176,len)){
} else {
var e_83177 = (a[i_83176]);
if(((e_83177 > (0))) && ((e_83177 < (30)))){
(ea[i_83176] = (1));
} else {
}

var G__83178 = (i_83176 + (1));
i_83176 = G__83178;
continue;
}
break;
}

return a.concat(ea);
} else {
return hasch.benc.digest.call(null,a,md_create_fn);
}
});

//# sourceMappingURL=benc.js.map