// Compiled by ClojureScript 1.9.521 {}
goog.provide('hasch.core');
goog.require('cljs.core');
goog.require('hasch.benc');
goog.require('hasch.platform');
hasch.core.uuid4 = hasch.platform.uuid4;
hasch.core.uuid5 = hasch.platform.uuid5;
hasch.core.hash__GT_str = hasch.platform.hash__GT_str;
/**
 * Hash an edn value with SHA-512 by default or a compatible hash function of choice.
 */
hasch.core.edn_hash = (function hasch$core$edn_hash(var_args){
var args83223 = [];
var len__10640__auto___83226 = arguments.length;
var i__10641__auto___83227 = (0);
while(true){
if((i__10641__auto___83227 < len__10640__auto___83226)){
args83223.push((arguments[i__10641__auto___83227]));

var G__83228 = (i__10641__auto___83227 + (1));
i__10641__auto___83227 = G__83228;
continue;
} else {
}
break;
}

var G__83225 = args83223.length;
switch (G__83225) {
case 1:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args83223.length)].join('')));

}
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1 = (function (val){
return hasch.core.edn_hash.call(null,val,cljs.core.PersistentArrayMap.EMPTY);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2 = (function (val,write_handlers){
return hasch.core.edn_hash.call(null,val,hasch.platform.sha512_message_digest,write_handlers);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3 = (function (val,md_create_fn,write_handlers){
return cljs.core.map.call(null,(function (p1__83222_SHARP_){
if((p1__83222_SHARP_ < (0))){
return (p1__83222_SHARP_ + (256));
} else {
return p1__83222_SHARP_;
}
}),hasch.benc.digest.call(null,hasch.benc._coerce.call(null,val,md_create_fn,(function (){var or__9419__auto__ = write_handlers;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})()),md_create_fn));
});

hasch.core.edn_hash.cljs$lang$maxFixedArity = 3;

/**
 * Creates random UUID-4 without argument or UUID-5 for the argument value.
 * 
 *   Optionally an incognito-style write-handlers map can be supplied,
 *   which describes record serialization in terms of Clojure data
 *   structures.
 */
hasch.core.uuid = (function hasch$core$uuid(var_args){
var args83230 = [];
var len__10640__auto___83238 = arguments.length;
var i__10641__auto___83239 = (0);
while(true){
if((i__10641__auto___83239 < len__10640__auto___83238)){
args83230.push((arguments[i__10641__auto___83239]));

var G__83240 = (i__10641__auto___83239 + (1));
i__10641__auto___83239 = G__83240;
continue;
} else {
}
break;
}

var G__83234 = args83230.length;
switch (G__83234) {
case 0:
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__10663__auto__ = (new cljs.core.IndexedSeq(args83230.slice((1)),(0),null));
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10663__auto__);

}
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$0 = (function (){
return hasch.core.uuid4.call(null);
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic = (function (val,p__83235){
var map__83236 = p__83235;
var map__83236__$1 = ((((!((map__83236 == null)))?((((map__83236.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83236.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83236):map__83236);
var write_handlers = cljs.core.get.call(null,map__83236__$1,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911));
return hasch.core.uuid5.call(null,hasch.core.edn_hash.call(null,val,write_handlers));
});

hasch.core.uuid.cljs$lang$applyTo = (function (seq83231){
var G__83232 = cljs.core.first.call(null,seq83231);
var seq83231__$1 = cljs.core.next.call(null,seq83231);
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic(G__83232,seq83231__$1);
});

hasch.core.uuid.cljs$lang$maxFixedArity = (1);


//# sourceMappingURL=core.js.map