// Compiled by ClojureScript 1.9.521 {}
goog.provide('superv.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
superv.async.cljs_env_QMARK_ = (function superv$async$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});

/**
 * @interface
 */
superv.async.PSupervisor = function(){};

superv.async._error = (function superv$async$_error(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_error$arity$1 == null)))){
return this$.superv$async$PSupervisor$_error$arity$1(this$);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._error[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$);
} else {
var m__10138__auto____$1 = (superv.async._error["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-error",this$);
}
}
}
});

superv.async._abort = (function superv$async$_abort(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_abort$arity$1 == null)))){
return this$.superv$async$PSupervisor$_abort$arity$1(this$);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._abort[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$);
} else {
var m__10138__auto____$1 = (superv.async._abort["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-abort",this$);
}
}
}
});

superv.async._register_go = (function superv$async$_register_go(this$,body){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_register_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_register_go$arity$2(this$,body);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._register_go[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,body);
} else {
var m__10138__auto____$1 = (superv.async._register_go["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,body);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-register-go",this$);
}
}
}
});

superv.async._unregister_go = (function superv$async$_unregister_go(this$,id){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_unregister_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_unregister_go$arity$2(this$,id);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._unregister_go[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,id);
} else {
var m__10138__auto____$1 = (superv.async._unregister_go["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-unregister-go",this$);
}
}
}
});

superv.async._track_exception = (function superv$async$_track_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_track_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_track_exception$arity$2(this$,e);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._track_exception[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,e);
} else {
var m__10138__auto____$1 = (superv.async._track_exception["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-track-exception",this$);
}
}
}
});

superv.async._free_exception = (function superv$async$_free_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_free_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_free_exception$arity$2(this$,e);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._free_exception[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,e);
} else {
var m__10138__auto____$1 = (superv.async._free_exception["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-free-exception",this$);
}
}
}
});

superv.async.now = (function superv$async$now(){
return (new Date());
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {superv.async.PSupervisor}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
superv.async.TrackingSupervisor = (function (error,abort,registered,pending_exceptions,__meta,__extmap,__hash){
this.error = error;
this.abort = abort;
this.registered = registered;
this.pending_exceptions = pending_exceptions;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__10094__auto__,k__10095__auto__){
var self__ = this;
var this__10094__auto____$1 = this;
return this__10094__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__10095__auto__,null);
});

superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__10096__auto__,k79071,else__10097__auto__){
var self__ = this;
var this__10096__auto____$1 = this;
var G__79073 = (((k79071 instanceof cljs.core.Keyword))?k79071.fqn:null);
switch (G__79073) {
case "error":
return self__.error;

break;
case "abort":
return self__.abort;

break;
case "registered":
return self__.registered;

break;
case "pending-exceptions":
return self__.pending_exceptions;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k79071,else__10097__auto__);

}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__10108__auto__,writer__10109__auto__,opts__10110__auto__){
var self__ = this;
var this__10108__auto____$1 = this;
var pr_pair__10111__auto__ = ((function (this__10108__auto____$1){
return (function (keyval__10112__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,cljs.core.pr_writer,""," ","",opts__10110__auto__,keyval__10112__auto__);
});})(this__10108__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,pr_pair__10111__auto__,"#superv.async.TrackingSupervisor{",", ","}",opts__10110__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__79070){
var self__ = this;
var G__79070__$1 = this;
return (new cljs.core.RecordIter((0),G__79070__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__10092__auto__){
var self__ = this;
var this__10092__auto____$1 = this;
return self__.__meta;
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__10088__auto__){
var self__ = this;
var this__10088__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__10098__auto__){
var self__ = this;
var this__10098__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__10089__auto__){
var self__ = this;
var this__10089__auto____$1 = this;
var h__9861__auto__ = self__.__hash;
if(!((h__9861__auto__ == null))){
return h__9861__auto__;
} else {
var h__9861__auto____$1 = cljs.core.hash_imap.call(null,this__10089__auto____$1);
self__.__hash = h__9861__auto____$1;

return h__9861__auto____$1;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__10090__auto__,other__10091__auto__){
var self__ = this;
var this__10090__auto____$1 = this;
if(cljs.core.truth_((function (){var and__9407__auto__ = other__10091__auto__;
if(cljs.core.truth_(and__9407__auto__)){
return ((this__10090__auto____$1.constructor === other__10091__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__10090__auto____$1,other__10091__auto__));
} else {
return and__9407__auto__;
}
})())){
return true;
} else {
return false;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__10103__auto__,k__10104__auto__){
var self__ = this;
var this__10103__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),null,new cljs.core.Keyword(null,"abort","abort",521193198),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"registered","registered",-388600037),null], null), null),k__10104__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__10103__auto____$1),self__.__meta),k__10104__auto__);
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__10104__auto__)),null));
}
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_error$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.error;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.abort;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_register_go$arity$2 = (function (this$,body){
var self__ = this;
var this$__$1 = this;
var id = cljs.core.random_uuid.call(null);
cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.assoc,id,body);

return id;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_unregister_go$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.dissoc,id);
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_track_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.assoc,e,superv.async.now.call(null));
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_free_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.dissoc,e);
});

superv.async.TrackingSupervisor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__10101__auto__,k__10102__auto__,G__79070){
var self__ = this;
var this__10101__auto____$1 = this;
var pred__79074 = cljs.core.keyword_identical_QMARK_;
var expr__79075 = k__10102__auto__;
if(cljs.core.truth_(pred__79074.call(null,new cljs.core.Keyword(null,"error","error",-978969032),expr__79075))){
return (new superv.async.TrackingSupervisor(G__79070,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79074.call(null,new cljs.core.Keyword(null,"abort","abort",521193198),expr__79075))){
return (new superv.async.TrackingSupervisor(self__.error,G__79070,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79074.call(null,new cljs.core.Keyword(null,"registered","registered",-388600037),expr__79075))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,G__79070,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79074.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),expr__79075))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,G__79070,self__.__meta,self__.__extmap,null));
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__10102__auto__,G__79070),null));
}
}
}
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__10106__auto__){
var self__ = this;
var this__10106__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__10093__auto__,G__79070){
var self__ = this;
var this__10093__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,G__79070,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__10099__auto__,entry__10100__auto__){
var self__ = this;
var this__10099__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__10100__auto__)){
return this__10099__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__10100__auto__,(0)),cljs.core._nth.call(null,entry__10100__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__10099__auto____$1,entry__10100__auto__);
}
});

superv.async.TrackingSupervisor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.Symbol(null,"abort","abort",-2133242571,null),new cljs.core.Symbol(null,"registered","registered",1251931490,null),new cljs.core.Symbol(null,"pending-exceptions","pending-exceptions",-247748567,null)], null);
});

superv.async.TrackingSupervisor.cljs$lang$type = true;

superv.async.TrackingSupervisor.cljs$lang$ctorPrSeq = (function (this__10130__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"superv.async/TrackingSupervisor");
});

superv.async.TrackingSupervisor.cljs$lang$ctorPrWriter = (function (this__10130__auto__,writer__10131__auto__){
return cljs.core._write.call(null,writer__10131__auto__,"superv.async/TrackingSupervisor");
});

superv.async.__GT_TrackingSupervisor = (function superv$async$__GT_TrackingSupervisor(error,abort,registered,pending_exceptions){
return (new superv.async.TrackingSupervisor(error,abort,registered,pending_exceptions,null,null,null));
});

superv.async.map__GT_TrackingSupervisor = (function superv$async$map__GT_TrackingSupervisor(G__79072){
return (new superv.async.TrackingSupervisor(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(G__79072),new cljs.core.Keyword(null,"abort","abort",521193198).cljs$core$IFn$_invoke$arity$1(G__79072),new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(G__79072),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(G__79072),null,cljs.core.dissoc.call(null,G__79072,new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)),null));
});

cljs.core.enable_console_print_BANG_.call(null);
/**
 * A simple supervisor which deals with errors through callbacks. You need to
 *   close its abort channel manually if you want the context to stop. It is
 *   supposed to be used at a boundary to an unsupervised system. If you want
 *   strong supervision, use the restarting-supervisor instead.
 */
superv.async.simple_supervisor = (function superv$async$simple_supervisor(var_args){
var args__10647__auto__ = [];
var len__10640__auto___79102 = arguments.length;
var i__10641__auto___79103 = (0);
while(true){
if((i__10641__auto___79103 < len__10640__auto___79102)){
args__10647__auto__.push((arguments[i__10641__auto___79103]));

var G__79104 = (i__10641__auto___79103 + (1));
i__10641__auto___79103 = G__79104;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((0) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((0)),(0),null)):null);
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(argseq__10648__auto__);
});

superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (p__79079){
var map__79080 = p__79079;
var map__79080__$1 = ((((!((map__79080 == null)))?((((map__79080.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__79080.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__79080):map__79080);
var stale_timeout = cljs.core.get.call(null,map__79080__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((10) * (1000)));
var error_fn = cljs.core.get.call(null,map__79080__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),((function (map__79080,map__79080__$1,stale_timeout){
return (function (e){
return cljs.core.println.call(null,"Supervisor:",e,e.stack);
});})(map__79080,map__79080__$1,stale_timeout))
);
var pending_fn = cljs.core.get.call(null,map__79080__$1,new cljs.core.Keyword(null,"pending-fn","pending-fn",1734381755));
var s = superv.async.map__GT_TrackingSupervisor.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"abort","abort",521193198),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"registered","registered",-388600037),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null));
var err_ch = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(s);
cljs.core.async.take_BANG_.call(null,err_ch,((function (s,err_ch,map__79080,map__79080__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$loop_fn(e){
error_fn.call(null,e);

return cljs.core.async.take_BANG_.call(null,err_ch,superv$async$loop_fn);
});})(s,err_ch,map__79080,map__79080__$1,stale_timeout,error_fn,pending_fn))
);

((function (s,err_ch,map__79080,map__79080__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$pending(_){
var vec__79092 = cljs.core.filter.call(null,((function (s,err_ch,map__79080,map__79080__$1,stale_timeout,error_fn,pending_fn){
return (function (p__79098){
var vec__79099 = p__79098;
var k = cljs.core.nth.call(null,vec__79099,(0),null);
var v = cljs.core.nth.call(null,vec__79099,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout) > v.getTime());
});})(s,err_ch,map__79080,map__79080__$1,stale_timeout,error_fn,pending_fn))
,cljs.core.deref.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s)));
var vec__79095 = cljs.core.nth.call(null,vec__79092,(0),null);
var e = cljs.core.nth.call(null,vec__79095,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__79095,(1),null);
if(cljs.core.truth_(e)){
error_fn.call(null,e);

superv.async._free_exception.call(null,s,e);
} else {
}

return cljs.core.async.take_BANG_.call(null,cljs.core.async.timeout.call(null,stale_timeout),superv$async$pending);
});})(s,err_ch,map__79080,map__79080__$1,stale_timeout,error_fn,pending_fn))
.call(null,null);

return s;
});

superv.async.simple_supervisor.cljs$lang$maxFixedArity = (0);

superv.async.simple_supervisor.cljs$lang$applyTo = (function (seq79078){
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq79078));
});

superv.async.S = superv.async.simple_supervisor.call(null);
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
superv.async.throw_if_exception = (function superv$async$throw_if_exception(S,x){
if((x instanceof Error)){
superv.async._free_exception.call(null,S,x);

throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),(function (){var or__9419__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
superv.async.superv_init = (function superv$async$superv_init(){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [superv.async._error,superv.async._abort,superv.async._register_go,superv.async._unregister_go,superv.async._track_exception,superv.async._free_exception,superv.async.throw_if_exception], null);
});
goog.exportSymbol('superv.async.superv_init', superv.async.superv_init);
superv.async.superv_init.call(null);
superv.async.supervisor_QMARK_ = (function superv$async$supervisor_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.superv$async$PSupervisor$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
}
});
superv.async.check_supervisor = (function superv$async$check_supervisor(x){
if(cljs.core.truth_(superv.async.supervisor_QMARK_.call(null,x))){
return null;
} else {
throw cljs.core.ex_info.call(null,"First argument is not a supervisor.",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"argument","argument",1183001841),x], null));
}
});
/**
 * Here until http://dev.clojure.org/jira/browse/ASYNC-74 is resolved.
 */
superv.async.chan_QMARK_ = (function superv$async$chan_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$ReadPort$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
}
});
/**
 * Same as core.async/take!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.take_QMARK_ = (function superv$async$take_QMARK_(var_args){
var args79122 = [];
var len__10640__auto___79125 = arguments.length;
var i__10641__auto___79126 = (0);
while(true){
if((i__10641__auto___79126 < len__10640__auto___79125)){
args79122.push((arguments[i__10641__auto___79126]));

var G__79127 = (i__10641__auto___79126 + (1));
i__10641__auto___79126 = G__79127;
continue;
} else {
}
break;
}

var G__79124 = args79122.length;
switch (G__79124) {
case 3:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args79122.length)].join('')));

}
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,fn1){
return superv.async.take_QMARK_.call(null,S,port,fn1,true);
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,fn1,on_caller_QMARK_){
return cljs.core.async.take_BANG_.call(null,port,(function (v){
if((v instanceof Error)){
superv.async._free_exception.call(null,S,v);
} else {
}

return fn1.call(null,v);
}),on_caller_QMARK_);
});

superv.async.take_QMARK_.cljs$lang$maxFixedArity = 4;

/**
 * Same as core.async/put!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.put_QMARK_ = (function superv$async$put_QMARK_(var_args){
var args79129 = [];
var len__10640__auto___79132 = arguments.length;
var i__10641__auto___79133 = (0);
while(true){
if((i__10641__auto___79133 < len__10640__auto___79132)){
args79129.push((arguments[i__10641__auto___79133]));

var G__79134 = (i__10641__auto___79133 + (1));
i__10641__auto___79133 = G__79134;
continue;
} else {
}
break;
}

var G__79131 = args79129.length;
switch (G__79131) {
case 3:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args79129.length)].join('')));

}
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,val){
return superv.async.put_QMARK_.call(null,S,port,val,(function superv$async$noop(_){
return null;
}));
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,val,fn1){
return superv.async.put_QMARK_.call(null,S,port,val,fn1,true);
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5 = (function (S,port,val,fn1,on_caller_QMARK_){
return cljs.core.async.put_BANG_.call(null,port,val,(function (ret){
if(((val instanceof Error)) && (!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,val)),new cljs.core.Keyword(null,"aborted","aborted",1775972619))))){
superv.async._track_exception.call(null,S,val);
} else {
}

return fn1.call(null,ret);
}),on_caller_QMARK_);
});

superv.async.put_QMARK_.cljs$lang$maxFixedArity = 5;

/**
 * Takes objects from in-ch, asynchrously applies function f> (function should
 *   return a channel), takes the result from the returned channel and if it's
 *   truthy, puts it in the out-ch. Returns the closed out-ch. Closes the
 *   returned channel when the input channel has been completely consumed and all
 *   objects have been processed.
 *   If out-ch is not provided, an unbuffered one will be used.
 */
superv.async.pmap_GT__GT_ = (function superv$async$pmap_GT__GT_(var_args){
var args79147 = [];
var len__10640__auto___79350 = arguments.length;
var i__10641__auto___79351 = (0);
while(true){
if((i__10641__auto___79351 < len__10640__auto___79350)){
args79147.push((arguments[i__10641__auto___79351]));

var G__79352 = (i__10641__auto___79351 + (1));
i__10641__auto___79351 = G__79352;
continue;
} else {
}
break;
}

var G__79149 = args79147.length;
switch (G__79149) {
case 4:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args79147.length)].join('')));

}
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4 = (function (S,f_GT_,parallelism,in_ch){
return superv.async.pmap_GT__GT_.call(null,S,f_GT_,parallelism,cljs.core.async.chan.call(null),in_ch);
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5 = (function (S,f_GT_,parallelism,out_ch,in_ch){
if(cljs.core.fn_QMARK_.call(null,f_GT_)){
} else {
throw (new Error("Assert failed: (fn? f>)"));
}

if((cljs.core.integer_QMARK_.call(null,parallelism)) && ((parallelism > (0)))){
} else {
throw (new Error("Assert failed: (and (integer? parallelism) (pos? parallelism))"));
}

if((in_ch instanceof cljs.core.async.impl.protocols.ReadPort)){
} else {
throw (new Error("Assert failed: (instance? ReadPort in-ch)"));
}

var threads = cljs.core.atom.call(null,parallelism);
var n__10440__auto___79354 = parallelism;
var __79355 = (0);
while(true){
if((__79355 < n__10440__auto___79354)){
var c__23767__auto___79356 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___79357 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"result","result",-1239343558,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)))], null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null)))))),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"zero?","zero?",325758897,null),cljs.core.list(new cljs.core.Symbol(null,"swap!","swap!",-655677516,null),new cljs.core.Symbol(null,"threads","threads",-77267207,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))));
var c__38309__auto___79358 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__79355,c__38309__auto___79358,c__23767__auto___79356,id__23768__auto___79357,n__10440__auto___79354,threads){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (__79355,c__38309__auto___79358,c__23767__auto___79356,id__23768__auto___79357,n__10440__auto___79354,threads){
return (function (state_79284){
var state_val_79285 = (state_79284[(1)]);
if((state_val_79285 === (7))){
var inst_79153 = (state_79284[(7)]);
var inst_79161 = (state_79284[(2)]);
var state_79284__$1 = (function (){var statearr_79286 = state_79284;
(statearr_79286[(8)] = inst_79161);

return statearr_79286;
})();
var statearr_79287_79359 = state_79284__$1;
(statearr_79287_79359[(2)] = inst_79153);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79284__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (20))){
var inst_79268 = (state_79284[(2)]);
var state_79284__$1 = state_79284;
var statearr_79288_79360 = state_79284__$1;
(statearr_79288_79360[(2)] = inst_79268);

(statearr_79288_79360[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (27))){
var inst_79230 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79231 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79232 = cljs.core.PersistentHashMap.fromArrays(inst_79230,inst_79231);
var inst_79233 = cljs.core.ex_info.call(null,"Aborted operations",inst_79232);
var state_79284__$1 = state_79284;
var statearr_79289_79361 = state_79284__$1;
(statearr_79289_79361[(2)] = inst_79233);

(statearr_79289_79361[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (1))){
var state_79284__$1 = state_79284;
var statearr_79290_79362 = state_79284__$1;
(statearr_79290_79362[(2)] = null);

(statearr_79290_79362[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (24))){
var inst_79212 = (state_79284[(2)]);
var inst_79213 = superv.async.throw_if_exception.call(null,S,inst_79212);
var inst_79214 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_79284__$1 = (function (){var statearr_79291 = state_79284;
(statearr_79291[(9)] = inst_79213);

return statearr_79291;
})();
var statearr_79292_79363 = state_79284__$1;
(statearr_79292_79363[(2)] = inst_79214);

(statearr_79292_79363[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (39))){
var state_79284__$1 = state_79284;
var statearr_79293_79364 = state_79284__$1;
(statearr_79293_79364[(2)] = null);

(statearr_79293_79364[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (4))){
var inst_79153 = (state_79284[(7)]);
var inst_79153__$1 = (state_79284[(2)]);
var inst_79154 = cljs.core.ex_data.call(null,inst_79153__$1);
var inst_79155 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_79154);
var inst_79156 = cljs.core._EQ_.call(null,inst_79155,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_79284__$1 = (function (){var statearr_79294 = state_79284;
(statearr_79294[(7)] = inst_79153__$1);

return statearr_79294;
})();
if(inst_79156){
var statearr_79295_79365 = state_79284__$1;
(statearr_79295_79365[(1)] = (5));

} else {
var statearr_79296_79366 = state_79284__$1;
(statearr_79296_79366[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (15))){
var inst_79186 = (state_79284[(10)]);
var inst_79188 = (inst_79186 instanceof Error);
var state_79284__$1 = state_79284;
if(cljs.core.truth_(inst_79188)){
var statearr_79297_79367 = state_79284__$1;
(statearr_79297_79367[(1)] = (18));

} else {
var statearr_79298_79368 = state_79284__$1;
(statearr_79298_79368[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (21))){
var inst_79193 = (state_79284[(11)]);
var inst_79199 = (state_79284[(2)]);
var inst_79200 = cljs.core.nth.call(null,inst_79199,(0),null);
var inst_79201 = cljs.core.nth.call(null,inst_79199,(1),null);
var inst_79202 = cljs.core._EQ_.call(null,inst_79201,inst_79193);
var state_79284__$1 = (function (){var statearr_79299 = state_79284;
(statearr_79299[(12)] = inst_79200);

return statearr_79299;
})();
if(inst_79202){
var statearr_79300_79369 = state_79284__$1;
(statearr_79300_79369[(1)] = (22));

} else {
var statearr_79301_79370 = state_79284__$1;
(statearr_79301_79370[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (31))){
var state_79284__$1 = state_79284;
var statearr_79302_79371 = state_79284__$1;
(statearr_79302_79371[(2)] = null);

(statearr_79302_79371[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (32))){
var inst_79265 = (state_79284[(2)]);
var state_79284__$1 = (function (){var statearr_79303 = state_79284;
(statearr_79303[(13)] = inst_79265);

return statearr_79303;
})();
var statearr_79304_79372 = state_79284__$1;
(statearr_79304_79372[(2)] = null);

(statearr_79304_79372[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (40))){
var inst_79280 = (state_79284[(2)]);
var state_79284__$1 = state_79284;
var statearr_79305_79373 = state_79284__$1;
(statearr_79305_79373[(2)] = inst_79280);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79284__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (33))){
var inst_79242 = (state_79284[(14)]);
var inst_79248 = (state_79284[(2)]);
var inst_79249 = cljs.core.nth.call(null,inst_79248,(0),null);
var inst_79250 = cljs.core.nth.call(null,inst_79248,(1),null);
var inst_79251 = cljs.core._EQ_.call(null,inst_79250,inst_79242);
var state_79284__$1 = (function (){var statearr_79306 = state_79284;
(statearr_79306[(15)] = inst_79249);

return statearr_79306;
})();
if(inst_79251){
var statearr_79307_79374 = state_79284__$1;
(statearr_79307_79374[(1)] = (34));

} else {
var statearr_79308_79375 = state_79284__$1;
(statearr_79308_79375[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (13))){
var inst_79175 = (state_79284[(16)]);
var state_79284__$1 = state_79284;
var statearr_79309_79376 = state_79284__$1;
(statearr_79309_79376[(2)] = inst_79175);

(statearr_79309_79376[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (22))){
var inst_79204 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79205 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79206 = cljs.core.PersistentHashMap.fromArrays(inst_79204,inst_79205);
var inst_79207 = cljs.core.ex_info.call(null,"Aborted operations",inst_79206);
var state_79284__$1 = state_79284;
var statearr_79310_79377 = state_79284__$1;
(statearr_79310_79377[(2)] = inst_79207);

(statearr_79310_79377[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (36))){
var inst_79261 = (state_79284[(2)]);
var inst_79262 = superv.async.throw_if_exception.call(null,S,inst_79261);
var state_79284__$1 = state_79284;
var statearr_79311_79378 = state_79284__$1;
(statearr_79311_79378[(2)] = inst_79262);

(statearr_79311_79378[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (29))){
var inst_79237 = (state_79284[(17)]);
var inst_79236 = (state_79284[(2)]);
var inst_79237__$1 = superv.async.throw_if_exception.call(null,S,inst_79236);
var state_79284__$1 = (function (){var statearr_79312 = state_79284;
(statearr_79312[(17)] = inst_79237__$1);

return statearr_79312;
})();
if(cljs.core.truth_(inst_79237__$1)){
var statearr_79313_79379 = state_79284__$1;
(statearr_79313_79379[(1)] = (30));

} else {
var statearr_79314_79380 = state_79284__$1;
(statearr_79314_79380[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (6))){
var inst_79153 = (state_79284[(7)]);
var inst_79159 = superv.async._track_exception.call(null,S,inst_79153);
var state_79284__$1 = state_79284;
var statearr_79315_79381 = state_79284__$1;
(statearr_79315_79381[(2)] = inst_79159);

(statearr_79315_79381[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (28))){
var inst_79226 = (state_79284[(18)]);
var state_79284__$1 = state_79284;
var statearr_79316_79382 = state_79284__$1;
(statearr_79316_79382[(2)] = inst_79226);

(statearr_79316_79382[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (25))){
var inst_79210 = (state_79284[(2)]);
var state_79284__$1 = state_79284;
var statearr_79317_79383 = state_79284__$1;
(statearr_79317_79383[(2)] = inst_79210);

(statearr_79317_79383[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (34))){
var inst_79253 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79254 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79255 = cljs.core.PersistentHashMap.fromArrays(inst_79253,inst_79254);
var inst_79256 = cljs.core.ex_info.call(null,"Aborted operations",inst_79255);
var state_79284__$1 = state_79284;
var statearr_79318_79384 = state_79284__$1;
(statearr_79318_79384[(2)] = inst_79256);

(statearr_79318_79384[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (17))){
var inst_79271 = (state_79284[(2)]);
var state_79284__$1 = state_79284;
var statearr_79319_79385 = state_79284__$1;
(statearr_79319_79385[(2)] = inst_79271);

(statearr_79319_79385[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (3))){
var inst_79150 = (state_79284[(2)]);
var inst_79151 = superv.async._unregister_go.call(null,S,id__23768__auto___79357);
var state_79284__$1 = (function (){var statearr_79320 = state_79284;
(statearr_79320[(19)] = inst_79150);

(statearr_79320[(20)] = inst_79151);

return statearr_79320;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79284__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (12))){
var inst_79179 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79180 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79181 = cljs.core.PersistentHashMap.fromArrays(inst_79179,inst_79180);
var inst_79182 = cljs.core.ex_info.call(null,"Aborted operations",inst_79181);
var state_79284__$1 = state_79284;
var statearr_79321_79386 = state_79284__$1;
(statearr_79321_79386[(2)] = inst_79182);

(statearr_79321_79386[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (2))){
var inst_79282 = (state_79284[(2)]);
var state_79284__$1 = state_79284;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79284__$1,inst_79282);
} else {
if((state_val_79285 === (23))){
var inst_79186 = (state_79284[(10)]);
var state_79284__$1 = state_79284;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79284__$1,(25),out_ch,inst_79186);
} else {
if((state_val_79285 === (35))){
var inst_79237 = (state_79284[(17)]);
var state_79284__$1 = state_79284;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79284__$1,(37),out_ch,inst_79237);
} else {
if((state_val_79285 === (19))){
var inst_79219 = (state_79284[(21)]);
var inst_79186 = (state_79284[(10)]);
var inst_79219__$1 = superv.async._abort.call(null,S);
var inst_79220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79221 = f_GT_.call(null,inst_79186);
var inst_79222 = [inst_79219__$1,inst_79221];
var inst_79223 = (new cljs.core.PersistentVector(null,2,(5),inst_79220,inst_79222,null));
var state_79284__$1 = (function (){var statearr_79322 = state_79284;
(statearr_79322[(21)] = inst_79219__$1);

return statearr_79322;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79284__$1,(26),inst_79223,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_79285 === (11))){
var inst_79169 = (state_79284[(22)]);
var inst_79174 = (state_79284[(2)]);
var inst_79175 = cljs.core.nth.call(null,inst_79174,(0),null);
var inst_79176 = cljs.core.nth.call(null,inst_79174,(1),null);
var inst_79177 = cljs.core._EQ_.call(null,inst_79176,inst_79169);
var state_79284__$1 = (function (){var statearr_79323 = state_79284;
(statearr_79323[(16)] = inst_79175);

return statearr_79323;
})();
if(inst_79177){
var statearr_79324_79387 = state_79284__$1;
(statearr_79324_79387[(1)] = (12));

} else {
var statearr_79325_79388 = state_79284__$1;
(statearr_79325_79388[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (9))){
var inst_79169 = (state_79284[(22)]);
var inst_79169__$1 = superv.async._abort.call(null,S);
var inst_79170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79171 = [inst_79169__$1,in_ch];
var inst_79172 = (new cljs.core.PersistentVector(null,2,(5),inst_79170,inst_79171,null));
var state_79284__$1 = (function (){var statearr_79326 = state_79284;
(statearr_79326[(22)] = inst_79169__$1);

return statearr_79326;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79284__$1,(11),inst_79172,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_79285 === (5))){
var state_79284__$1 = state_79284;
var statearr_79327_79389 = state_79284__$1;
(statearr_79327_79389[(2)] = null);

(statearr_79327_79389[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (14))){
var inst_79186 = (state_79284[(10)]);
var inst_79185 = (state_79284[(2)]);
var inst_79186__$1 = superv.async.throw_if_exception.call(null,S,inst_79185);
var state_79284__$1 = (function (){var statearr_79328 = state_79284;
(statearr_79328[(10)] = inst_79186__$1);

return statearr_79328;
})();
if(cljs.core.truth_(inst_79186__$1)){
var statearr_79329_79390 = state_79284__$1;
(statearr_79329_79390[(1)] = (15));

} else {
var statearr_79330_79391 = state_79284__$1;
(statearr_79330_79391[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (26))){
var inst_79219 = (state_79284[(21)]);
var inst_79225 = (state_79284[(2)]);
var inst_79226 = cljs.core.nth.call(null,inst_79225,(0),null);
var inst_79227 = cljs.core.nth.call(null,inst_79225,(1),null);
var inst_79228 = cljs.core._EQ_.call(null,inst_79227,inst_79219);
var state_79284__$1 = (function (){var statearr_79331 = state_79284;
(statearr_79331[(18)] = inst_79226);

return statearr_79331;
})();
if(inst_79228){
var statearr_79332_79392 = state_79284__$1;
(statearr_79332_79392[(1)] = (27));

} else {
var statearr_79333_79393 = state_79284__$1;
(statearr_79333_79393[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (16))){
var state_79284__$1 = state_79284;
var statearr_79334_79394 = state_79284__$1;
(statearr_79334_79394[(2)] = null);

(statearr_79334_79394[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (38))){
var inst_79277 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_79284__$1 = state_79284;
var statearr_79335_79395 = state_79284__$1;
(statearr_79335_79395[(2)] = inst_79277);

(statearr_79335_79395[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (30))){
var inst_79242 = (state_79284[(14)]);
var inst_79242__$1 = superv.async._abort.call(null,S);
var inst_79243 = cljs.core.async.timeout.call(null,(0));
var inst_79244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79245 = [inst_79242__$1,inst_79243];
var inst_79246 = (new cljs.core.PersistentVector(null,2,(5),inst_79244,inst_79245,null));
var state_79284__$1 = (function (){var statearr_79336 = state_79284;
(statearr_79336[(14)] = inst_79242__$1);

return statearr_79336;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79284__$1,(33),inst_79246,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_79285 === (10))){
var inst_79273 = (state_79284[(2)]);
var inst_79274 = cljs.core.swap_BANG_.call(null,threads,cljs.core.dec);
var inst_79275 = (inst_79274 === (0));
var state_79284__$1 = (function (){var statearr_79337 = state_79284;
(statearr_79337[(23)] = inst_79273);

return statearr_79337;
})();
if(cljs.core.truth_(inst_79275)){
var statearr_79338_79396 = state_79284__$1;
(statearr_79338_79396[(1)] = (38));

} else {
var statearr_79339_79397 = state_79284__$1;
(statearr_79339_79397[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (18))){
var inst_79193 = (state_79284[(11)]);
var inst_79193__$1 = superv.async._abort.call(null,S);
var inst_79194 = cljs.core.async.timeout.call(null,(0));
var inst_79195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79196 = [inst_79193__$1,inst_79194];
var inst_79197 = (new cljs.core.PersistentVector(null,2,(5),inst_79195,inst_79196,null));
var state_79284__$1 = (function (){var statearr_79340 = state_79284;
(statearr_79340[(11)] = inst_79193__$1);

return statearr_79340;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79284__$1,(21),inst_79197,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_79285 === (37))){
var inst_79259 = (state_79284[(2)]);
var state_79284__$1 = state_79284;
var statearr_79341_79398 = state_79284__$1;
(statearr_79341_79398[(2)] = inst_79259);

(statearr_79341_79398[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79285 === (8))){
var ___$1 = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_79284,(4),Error,(3),(2));
var state_79284__$1 = state_79284;
var statearr_79342_79399 = state_79284__$1;
(statearr_79342_79399[(2)] = null);

(statearr_79342_79399[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(__79355,c__38309__auto___79358,c__23767__auto___79356,id__23768__auto___79357,n__10440__auto___79354,threads))
;
return ((function (__79355,switch__38195__auto__,c__38309__auto___79358,c__23767__auto___79356,id__23768__auto___79357,n__10440__auto___79354,threads){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_79346 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79346[(0)] = superv$async$state_machine__38196__auto__);

(statearr_79346[(1)] = (1));

return statearr_79346;
});
var superv$async$state_machine__38196__auto____1 = (function (state_79284){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_79284);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e79347){if((e79347 instanceof Object)){
var ex__38199__auto__ = e79347;
var statearr_79348_79400 = state_79284;
(statearr_79348_79400[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79284);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79347;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79401 = state_79284;
state_79284 = G__79401;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_79284){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_79284);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(__79355,switch__38195__auto__,c__38309__auto___79358,c__23767__auto___79356,id__23768__auto___79357,n__10440__auto___79354,threads))
})();
var state__38311__auto__ = (function (){var statearr_79349 = f__38310__auto__.call(null);
(statearr_79349[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___79358);

return statearr_79349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(__79355,c__38309__auto___79358,c__23767__auto___79356,id__23768__auto___79357,n__10440__auto___79354,threads))
);


var G__79402 = (__79355 + (1));
__79355 = G__79402;
continue;
} else {
}
break;
}

return out_ch;
});

superv.async.pmap_GT__GT_.cljs$lang$maxFixedArity = 5;

/**
 * Similiar to dorun. Simply takes messages from channels but does nothing with
 *   them. Returns channel that will close when all messages have been consumed.
 */
superv.async.engulf = (function superv$async$engulf(var_args){
var args__10647__auto__ = [];
var len__10640__auto___79483 = arguments.length;
var i__10641__auto___79484 = (0);
while(true){
if((i__10641__auto___79484 < len__10640__auto___79483)){
args__10647__auto__.push((arguments[i__10641__auto___79484]));

var G__79485 = (i__10641__auto___79484 + (1));
i__10641__auto___79484 = G__79485;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var ch = cljs.core.async.merge.call(null,cs);
var c__23767__auto__ = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto__ = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null))))));
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__,c__23767__auto__,id__23768__auto__,ch){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__,c__23767__auto__,id__23768__auto__,ch){
return (function (state_79452){
var state_val_79453 = (state_79452[(1)]);
if((state_val_79453 === (7))){
var inst_79408 = (state_79452[(7)]);
var inst_79416 = (state_79452[(2)]);
var state_79452__$1 = (function (){var statearr_79454 = state_79452;
(statearr_79454[(8)] = inst_79416);

return statearr_79454;
})();
var statearr_79455_79486 = state_79452__$1;
(statearr_79455_79486[(2)] = inst_79408);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79452__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79453 === (1))){
var state_79452__$1 = state_79452;
var statearr_79456_79487 = state_79452__$1;
(statearr_79456_79487[(2)] = null);

(statearr_79456_79487[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79453 === (4))){
var inst_79408 = (state_79452[(7)]);
var inst_79408__$1 = (state_79452[(2)]);
var inst_79409 = cljs.core.ex_data.call(null,inst_79408__$1);
var inst_79410 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_79409);
var inst_79411 = cljs.core._EQ_.call(null,inst_79410,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_79452__$1 = (function (){var statearr_79457 = state_79452;
(statearr_79457[(7)] = inst_79408__$1);

return statearr_79457;
})();
if(inst_79411){
var statearr_79458_79488 = state_79452__$1;
(statearr_79458_79488[(1)] = (5));

} else {
var statearr_79459_79489 = state_79452__$1;
(statearr_79459_79489[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79453 === (15))){
var state_79452__$1 = state_79452;
var statearr_79460_79490 = state_79452__$1;
(statearr_79460_79490[(2)] = null);

(statearr_79460_79490[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79453 === (13))){
var inst_79430 = (state_79452[(9)]);
var state_79452__$1 = state_79452;
var statearr_79461_79491 = state_79452__$1;
(statearr_79461_79491[(2)] = inst_79430);

(statearr_79461_79491[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79453 === (6))){
var inst_79408 = (state_79452[(7)]);
var inst_79414 = superv.async._track_exception.call(null,S,inst_79408);
var state_79452__$1 = state_79452;
var statearr_79462_79492 = state_79452__$1;
(statearr_79462_79492[(2)] = inst_79414);

(statearr_79462_79492[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79453 === (17))){
var inst_79446 = (state_79452[(2)]);
var state_79452__$1 = state_79452;
var statearr_79463_79493 = state_79452__$1;
(statearr_79463_79493[(2)] = inst_79446);

(statearr_79463_79493[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79453 === (3))){
var inst_79405 = (state_79452[(2)]);
var inst_79406 = superv.async._unregister_go.call(null,S,id__23768__auto__);
var state_79452__$1 = (function (){var statearr_79464 = state_79452;
(statearr_79464[(10)] = inst_79405);

(statearr_79464[(11)] = inst_79406);

return statearr_79464;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79452__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79453 === (12))){
var inst_79434 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79435 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79436 = cljs.core.PersistentHashMap.fromArrays(inst_79434,inst_79435);
var inst_79437 = cljs.core.ex_info.call(null,"Aborted operations",inst_79436);
var state_79452__$1 = state_79452;
var statearr_79465_79494 = state_79452__$1;
(statearr_79465_79494[(2)] = inst_79437);

(statearr_79465_79494[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79453 === (2))){
var inst_79450 = (state_79452[(2)]);
var state_79452__$1 = state_79452;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79452__$1,inst_79450);
} else {
if((state_val_79453 === (11))){
var inst_79424 = (state_79452[(12)]);
var inst_79429 = (state_79452[(2)]);
var inst_79430 = cljs.core.nth.call(null,inst_79429,(0),null);
var inst_79431 = cljs.core.nth.call(null,inst_79429,(1),null);
var inst_79432 = cljs.core._EQ_.call(null,inst_79431,inst_79424);
var state_79452__$1 = (function (){var statearr_79466 = state_79452;
(statearr_79466[(9)] = inst_79430);

return statearr_79466;
})();
if(inst_79432){
var statearr_79467_79495 = state_79452__$1;
(statearr_79467_79495[(1)] = (12));

} else {
var statearr_79468_79496 = state_79452__$1;
(statearr_79468_79496[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79453 === (9))){
var inst_79424 = (state_79452[(12)]);
var inst_79424__$1 = superv.async._abort.call(null,S);
var inst_79425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79426 = [inst_79424__$1,ch];
var inst_79427 = (new cljs.core.PersistentVector(null,2,(5),inst_79425,inst_79426,null));
var state_79452__$1 = (function (){var statearr_79469 = state_79452;
(statearr_79469[(12)] = inst_79424__$1);

return statearr_79469;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79452__$1,(11),inst_79427,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_79453 === (5))){
var state_79452__$1 = state_79452;
var statearr_79470_79497 = state_79452__$1;
(statearr_79470_79497[(2)] = null);

(statearr_79470_79497[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79453 === (14))){
var inst_79440 = (state_79452[(2)]);
var inst_79441 = superv.async.throw_if_exception.call(null,S,inst_79440);
var state_79452__$1 = state_79452;
if(cljs.core.truth_(inst_79441)){
var statearr_79471_79498 = state_79452__$1;
(statearr_79471_79498[(1)] = (15));

} else {
var statearr_79472_79499 = state_79452__$1;
(statearr_79472_79499[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79453 === (16))){
var state_79452__$1 = state_79452;
var statearr_79473_79500 = state_79452__$1;
(statearr_79473_79500[(2)] = null);

(statearr_79473_79500[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79453 === (10))){
var inst_79448 = (state_79452[(2)]);
var state_79452__$1 = state_79452;
var statearr_79474_79501 = state_79452__$1;
(statearr_79474_79501[(2)] = inst_79448);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79452__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79453 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_79452,(4),Error,(3),(2));
var state_79452__$1 = state_79452;
var statearr_79475_79502 = state_79452__$1;
(statearr_79475_79502[(2)] = null);

(statearr_79475_79502[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto__,c__23767__auto__,id__23768__auto__,ch))
;
return ((function (switch__38195__auto__,c__38309__auto__,c__23767__auto__,id__23768__auto__,ch){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_79479 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79479[(0)] = superv$async$state_machine__38196__auto__);

(statearr_79479[(1)] = (1));

return statearr_79479;
});
var superv$async$state_machine__38196__auto____1 = (function (state_79452){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_79452);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e79480){if((e79480 instanceof Object)){
var ex__38199__auto__ = e79480;
var statearr_79481_79503 = state_79452;
(statearr_79481_79503[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79452);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79480;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79504 = state_79452;
state_79452 = G__79504;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_79452){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_79452);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__,c__23767__auto__,id__23768__auto__,ch))
})();
var state__38311__auto__ = (function (){var statearr_79482 = f__38310__auto__.call(null);
(statearr_79482[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_79482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__,c__23767__auto__,id__23768__auto__,ch))
);

return c__38309__auto__;
});

superv.async.engulf.cljs$lang$maxFixedArity = (1);

superv.async.engulf.cljs$lang$applyTo = (function (seq79403){
var G__79404 = cljs.core.first.call(null,seq79403);
var seq79403__$1 = cljs.core.next.call(null,seq79403);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic(G__79404,seq79403__$1);
});

/**
 * Performs a reduce on objects from ch with the function f> (which
 *   should return a channel). Returns a channel with the resulting
 *   value.
 */
superv.async.reduce_GT_ = (function superv$async$reduce_GT_(S,f_GT_,acc,ch){
var result = cljs.core.async.chan.call(null);
var c__23767__auto___79871 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___79872 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"->>","->>",-1874332161,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null)),new cljs.core.Symbol(null,"recur","recur",1202958259,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null)))))));
var c__38309__auto___79873 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___79873,c__23767__auto___79871,id__23768__auto___79872,result){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___79873,c__23767__auto___79871,id__23768__auto___79872,result){
return (function (state_79813){
var state_val_79814 = (state_79813[(1)]);
if((state_val_79814 === (7))){
var inst_79691 = (state_79813[(7)]);
var inst_79699 = (state_79813[(2)]);
var state_79813__$1 = (function (){var statearr_79815 = state_79813;
(statearr_79815[(8)] = inst_79699);

return statearr_79815;
})();
var statearr_79816_79874 = state_79813__$1;
(statearr_79816_79874[(2)] = inst_79691);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79813__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (20))){
var inst_79779 = (state_79813[(2)]);
var state_79813__$1 = state_79813;
var statearr_79817_79875 = state_79813__$1;
(statearr_79817_79875[(2)] = inst_79779);

(statearr_79817_79875[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (27))){
var inst_79769 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79770 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79771 = cljs.core.PersistentHashMap.fromArrays(inst_79769,inst_79770);
var inst_79772 = cljs.core.ex_info.call(null,"Aborted operations",inst_79771);
var state_79813__$1 = state_79813;
var statearr_79818_79876 = state_79813__$1;
(statearr_79818_79876[(2)] = inst_79772);

(statearr_79818_79876[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (1))){
var state_79813__$1 = state_79813;
var statearr_79819_79877 = state_79813__$1;
(statearr_79819_79877[(2)] = null);

(statearr_79819_79877[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (24))){
var inst_79751 = (state_79813[(2)]);
var inst_79752 = superv.async.throw_if_exception.call(null,S,inst_79751);
var inst_79753 = cljs.core.async.close_BANG_.call(null,result);
var state_79813__$1 = (function (){var statearr_79820 = state_79813;
(statearr_79820[(9)] = inst_79752);

return statearr_79820;
})();
var statearr_79821_79878 = state_79813__$1;
(statearr_79821_79878[(2)] = inst_79753);

(statearr_79821_79878[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (4))){
var inst_79691 = (state_79813[(7)]);
var inst_79691__$1 = (state_79813[(2)]);
var inst_79692 = cljs.core.ex_data.call(null,inst_79691__$1);
var inst_79693 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_79692);
var inst_79694 = cljs.core._EQ_.call(null,inst_79693,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_79813__$1 = (function (){var statearr_79822 = state_79813;
(statearr_79822[(7)] = inst_79691__$1);

return statearr_79822;
})();
if(inst_79694){
var statearr_79823_79879 = state_79813__$1;
(statearr_79823_79879[(1)] = (5));

} else {
var statearr_79824_79880 = state_79813__$1;
(statearr_79824_79880[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (15))){
var inst_79725 = (state_79813[(10)]);
var inst_79727 = (inst_79725 instanceof Error);
var state_79813__$1 = state_79813;
if(cljs.core.truth_(inst_79727)){
var statearr_79825_79881 = state_79813__$1;
(statearr_79825_79881[(1)] = (18));

} else {
var statearr_79826_79882 = state_79813__$1;
(statearr_79826_79882[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (21))){
var inst_79732 = (state_79813[(11)]);
var inst_79738 = (state_79813[(2)]);
var inst_79739 = cljs.core.nth.call(null,inst_79738,(0),null);
var inst_79740 = cljs.core.nth.call(null,inst_79738,(1),null);
var inst_79741 = cljs.core._EQ_.call(null,inst_79740,inst_79732);
var state_79813__$1 = (function (){var statearr_79827 = state_79813;
(statearr_79827[(12)] = inst_79739);

return statearr_79827;
})();
if(inst_79741){
var statearr_79828_79883 = state_79813__$1;
(statearr_79828_79883[(1)] = (22));

} else {
var statearr_79829_79884 = state_79813__$1;
(statearr_79829_79884[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (31))){
var inst_79795 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79796 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79797 = cljs.core.PersistentHashMap.fromArrays(inst_79795,inst_79796);
var inst_79798 = cljs.core.ex_info.call(null,"Aborted operations",inst_79797);
var state_79813__$1 = state_79813;
var statearr_79830_79885 = state_79813__$1;
(statearr_79830_79885[(2)] = inst_79798);

(statearr_79830_79885[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (32))){
var inst_79703 = (state_79813[(13)]);
var state_79813__$1 = state_79813;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79813__$1,(34),result,inst_79703);
} else {
if((state_val_79814 === (33))){
var inst_79803 = (state_79813[(2)]);
var inst_79804 = superv.async.throw_if_exception.call(null,S,inst_79803);
var inst_79805 = cljs.core.async.close_BANG_.call(null,result);
var state_79813__$1 = (function (){var statearr_79831 = state_79813;
(statearr_79831[(14)] = inst_79804);

return statearr_79831;
})();
var statearr_79832_79886 = state_79813__$1;
(statearr_79832_79886[(2)] = inst_79805);

(statearr_79832_79886[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (13))){
var inst_79714 = (state_79813[(15)]);
var state_79813__$1 = state_79813;
var statearr_79833_79887 = state_79813__$1;
(statearr_79833_79887[(2)] = inst_79714);

(statearr_79833_79887[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (22))){
var inst_79743 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79744 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79745 = cljs.core.PersistentHashMap.fromArrays(inst_79743,inst_79744);
var inst_79746 = cljs.core.ex_info.call(null,"Aborted operations",inst_79745);
var state_79813__$1 = state_79813;
var statearr_79834_79888 = state_79813__$1;
(statearr_79834_79888[(2)] = inst_79746);

(statearr_79834_79888[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (29))){
var inst_79775 = (state_79813[(2)]);
var inst_79776 = superv.async.throw_if_exception.call(null,S,inst_79775);
var inst_79703 = inst_79776;
var state_79813__$1 = (function (){var statearr_79835 = state_79813;
(statearr_79835[(13)] = inst_79703);

return statearr_79835;
})();
var statearr_79836_79889 = state_79813__$1;
(statearr_79836_79889[(2)] = null);

(statearr_79836_79889[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (6))){
var inst_79691 = (state_79813[(7)]);
var inst_79697 = superv.async._track_exception.call(null,S,inst_79691);
var state_79813__$1 = state_79813;
var statearr_79837_79890 = state_79813__$1;
(statearr_79837_79890[(2)] = inst_79697);

(statearr_79837_79890[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (28))){
var inst_79765 = (state_79813[(16)]);
var state_79813__$1 = state_79813;
var statearr_79838_79891 = state_79813__$1;
(statearr_79838_79891[(2)] = inst_79765);

(statearr_79838_79891[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (25))){
var inst_79749 = (state_79813[(2)]);
var state_79813__$1 = state_79813;
var statearr_79839_79892 = state_79813__$1;
(statearr_79839_79892[(2)] = inst_79749);

(statearr_79839_79892[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (34))){
var inst_79801 = (state_79813[(2)]);
var state_79813__$1 = state_79813;
var statearr_79840_79893 = state_79813__$1;
(statearr_79840_79893[(2)] = inst_79801);

(statearr_79840_79893[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (17))){
var inst_79807 = (state_79813[(2)]);
var state_79813__$1 = state_79813;
var statearr_79841_79894 = state_79813__$1;
(statearr_79841_79894[(2)] = inst_79807);

(statearr_79841_79894[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (3))){
var inst_79688 = (state_79813[(2)]);
var inst_79689 = superv.async._unregister_go.call(null,S,id__23768__auto___79872);
var state_79813__$1 = (function (){var statearr_79842 = state_79813;
(statearr_79842[(17)] = inst_79689);

(statearr_79842[(18)] = inst_79688);

return statearr_79842;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79813__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (12))){
var inst_79718 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79719 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79720 = cljs.core.PersistentHashMap.fromArrays(inst_79718,inst_79719);
var inst_79721 = cljs.core.ex_info.call(null,"Aborted operations",inst_79720);
var state_79813__$1 = state_79813;
var statearr_79843_79895 = state_79813__$1;
(statearr_79843_79895[(2)] = inst_79721);

(statearr_79843_79895[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (2))){
var inst_79811 = (state_79813[(2)]);
var state_79813__$1 = state_79813;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79813__$1,inst_79811);
} else {
if((state_val_79814 === (23))){
var inst_79725 = (state_79813[(10)]);
var state_79813__$1 = state_79813;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79813__$1,(25),result,inst_79725);
} else {
if((state_val_79814 === (19))){
var inst_79725 = (state_79813[(10)]);
var inst_79758 = (state_79813[(19)]);
var inst_79703 = (state_79813[(13)]);
var inst_79758__$1 = superv.async._abort.call(null,S);
var inst_79759 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79760 = f_GT_.call(null,inst_79703,inst_79725);
var inst_79761 = [inst_79758__$1,inst_79760];
var inst_79762 = (new cljs.core.PersistentVector(null,2,(5),inst_79759,inst_79761,null));
var state_79813__$1 = (function (){var statearr_79844 = state_79813;
(statearr_79844[(19)] = inst_79758__$1);

return statearr_79844;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79813__$1,(26),inst_79762,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_79814 === (11))){
var inst_79708 = (state_79813[(20)]);
var inst_79713 = (state_79813[(2)]);
var inst_79714 = cljs.core.nth.call(null,inst_79713,(0),null);
var inst_79715 = cljs.core.nth.call(null,inst_79713,(1),null);
var inst_79716 = cljs.core._EQ_.call(null,inst_79715,inst_79708);
var state_79813__$1 = (function (){var statearr_79845 = state_79813;
(statearr_79845[(15)] = inst_79714);

return statearr_79845;
})();
if(inst_79716){
var statearr_79846_79896 = state_79813__$1;
(statearr_79846_79896[(1)] = (12));

} else {
var statearr_79847_79897 = state_79813__$1;
(statearr_79847_79897[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (9))){
var inst_79708 = (state_79813[(20)]);
var inst_79708__$1 = superv.async._abort.call(null,S);
var inst_79709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79710 = [inst_79708__$1,ch];
var inst_79711 = (new cljs.core.PersistentVector(null,2,(5),inst_79709,inst_79710,null));
var state_79813__$1 = (function (){var statearr_79848 = state_79813;
(statearr_79848[(20)] = inst_79708__$1);

return statearr_79848;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79813__$1,(11),inst_79711,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_79814 === (5))){
var state_79813__$1 = state_79813;
var statearr_79849_79898 = state_79813__$1;
(statearr_79849_79898[(2)] = null);

(statearr_79849_79898[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (14))){
var inst_79725 = (state_79813[(10)]);
var inst_79724 = (state_79813[(2)]);
var inst_79725__$1 = superv.async.throw_if_exception.call(null,S,inst_79724);
var state_79813__$1 = (function (){var statearr_79850 = state_79813;
(statearr_79850[(10)] = inst_79725__$1);

return statearr_79850;
})();
if(cljs.core.truth_(inst_79725__$1)){
var statearr_79851_79899 = state_79813__$1;
(statearr_79851_79899[(1)] = (15));

} else {
var statearr_79852_79900 = state_79813__$1;
(statearr_79852_79900[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (26))){
var inst_79758 = (state_79813[(19)]);
var inst_79764 = (state_79813[(2)]);
var inst_79765 = cljs.core.nth.call(null,inst_79764,(0),null);
var inst_79766 = cljs.core.nth.call(null,inst_79764,(1),null);
var inst_79767 = cljs.core._EQ_.call(null,inst_79766,inst_79758);
var state_79813__$1 = (function (){var statearr_79853 = state_79813;
(statearr_79853[(16)] = inst_79765);

return statearr_79853;
})();
if(inst_79767){
var statearr_79854_79901 = state_79813__$1;
(statearr_79854_79901[(1)] = (27));

} else {
var statearr_79855_79902 = state_79813__$1;
(statearr_79855_79902[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (16))){
var inst_79784 = (state_79813[(21)]);
var inst_79784__$1 = superv.async._abort.call(null,S);
var inst_79785 = cljs.core.async.timeout.call(null,(0));
var inst_79786 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79787 = [inst_79784__$1,inst_79785];
var inst_79788 = (new cljs.core.PersistentVector(null,2,(5),inst_79786,inst_79787,null));
var state_79813__$1 = (function (){var statearr_79856 = state_79813;
(statearr_79856[(21)] = inst_79784__$1);

return statearr_79856;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79813__$1,(30),inst_79788,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_79814 === (30))){
var inst_79784 = (state_79813[(21)]);
var inst_79790 = (state_79813[(2)]);
var inst_79791 = cljs.core.nth.call(null,inst_79790,(0),null);
var inst_79792 = cljs.core.nth.call(null,inst_79790,(1),null);
var inst_79793 = cljs.core._EQ_.call(null,inst_79792,inst_79784);
var state_79813__$1 = (function (){var statearr_79857 = state_79813;
(statearr_79857[(22)] = inst_79791);

return statearr_79857;
})();
if(inst_79793){
var statearr_79858_79903 = state_79813__$1;
(statearr_79858_79903[(1)] = (31));

} else {
var statearr_79859_79904 = state_79813__$1;
(statearr_79859_79904[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (10))){
var inst_79809 = (state_79813[(2)]);
var state_79813__$1 = state_79813;
var statearr_79860_79905 = state_79813__$1;
(statearr_79860_79905[(2)] = inst_79809);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79813__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79814 === (18))){
var inst_79732 = (state_79813[(11)]);
var inst_79732__$1 = superv.async._abort.call(null,S);
var inst_79733 = cljs.core.async.timeout.call(null,(0));
var inst_79734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79735 = [inst_79732__$1,inst_79733];
var inst_79736 = (new cljs.core.PersistentVector(null,2,(5),inst_79734,inst_79735,null));
var state_79813__$1 = (function (){var statearr_79861 = state_79813;
(statearr_79861[(11)] = inst_79732__$1);

return statearr_79861;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79813__$1,(21),inst_79736,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_79814 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_79813,(4),Error,(3),(2));
var inst_79703 = acc;
var state_79813__$1 = (function (){var statearr_79862 = state_79813;
(statearr_79862[(13)] = inst_79703);

return statearr_79862;
})();
var statearr_79863_79906 = state_79813__$1;
(statearr_79863_79906[(2)] = null);

(statearr_79863_79906[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___79873,c__23767__auto___79871,id__23768__auto___79872,result))
;
return ((function (switch__38195__auto__,c__38309__auto___79873,c__23767__auto___79871,id__23768__auto___79872,result){
return (function() {
var superv$async$reduce_GT__$_state_machine__38196__auto__ = null;
var superv$async$reduce_GT__$_state_machine__38196__auto____0 = (function (){
var statearr_79867 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79867[(0)] = superv$async$reduce_GT__$_state_machine__38196__auto__);

(statearr_79867[(1)] = (1));

return statearr_79867;
});
var superv$async$reduce_GT__$_state_machine__38196__auto____1 = (function (state_79813){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_79813);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e79868){if((e79868 instanceof Object)){
var ex__38199__auto__ = e79868;
var statearr_79869_79907 = state_79813;
(statearr_79869_79907[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79813);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79868;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79908 = state_79813;
state_79813 = G__79908;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$reduce_GT__$_state_machine__38196__auto__ = function(state_79813){
switch(arguments.length){
case 0:
return superv$async$reduce_GT__$_state_machine__38196__auto____0.call(this);
case 1:
return superv$async$reduce_GT__$_state_machine__38196__auto____1.call(this,state_79813);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$reduce_GT__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$reduce_GT__$_state_machine__38196__auto____0;
superv$async$reduce_GT__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$reduce_GT__$_state_machine__38196__auto____1;
return superv$async$reduce_GT__$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___79873,c__23767__auto___79871,id__23768__auto___79872,result))
})();
var state__38311__auto__ = (function (){var statearr_79870 = f__38310__auto__.call(null);
(statearr_79870[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___79873);

return statearr_79870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___79873,c__23767__auto___79871,id__23768__auto___79872,result))
);


return result;
});
/**
 * Concatenates two or more channels. First takes all values from first channel
 *   and supplies to output channel, then takes all values from second channel and
 *   so on. Similiar to core.async/merge but maintains the order of values.
 */
superv.async.concat_GT__GT_ = (function superv$async$concat_GT__GT_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___80038 = arguments.length;
var i__10641__auto___80039 = (0);
while(true){
if((i__10641__auto___80039 < len__10640__auto___80038)){
args__10647__auto__.push((arguments[i__10641__auto___80039]));

var G__80040 = (i__10641__auto___80039 + (1));
i__10641__auto___80039 = G__80040;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var out = cljs.core.async.chan.call(null);
var c__23767__auto___80041 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___80042 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"c","c",-122660552,null),cljs.core.list(new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"c","c",-122660552,null))], null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"v","v",1661996586,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.list(new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null))))));
var c__38309__auto___80043 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___80043,c__23767__auto___80041,id__23768__auto___80042,out){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___80043,c__23767__auto___80041,id__23768__auto___80042,out){
return (function (state_79991){
var state_val_79992 = (state_79991[(1)]);
if((state_val_79992 === (7))){
var inst_79914 = (state_79991[(7)]);
var inst_79922 = (state_79991[(2)]);
var state_79991__$1 = (function (){var statearr_79994 = state_79991;
(statearr_79994[(8)] = inst_79922);

return statearr_79994;
})();
var statearr_79995_80044 = state_79991__$1;
(statearr_79995_80044[(2)] = inst_79914);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79991__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (20))){
var inst_79981 = (state_79991[(2)]);
var state_79991__$1 = state_79991;
var statearr_79996_80045 = state_79991__$1;
(statearr_79996_80045[(2)] = inst_79981);

(statearr_79996_80045[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (1))){
var state_79991__$1 = state_79991;
var statearr_79997_80046 = state_79991__$1;
(statearr_79997_80046[(2)] = null);

(statearr_79997_80046[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (24))){
var inst_79926 = (state_79991[(9)]);
var inst_79974 = (state_79991[(2)]);
var inst_79975 = superv.async.throw_if_exception.call(null,S,inst_79974);
var tmp79993 = inst_79926;
var inst_79926__$1 = tmp79993;
var state_79991__$1 = (function (){var statearr_79998 = state_79991;
(statearr_79998[(9)] = inst_79926__$1);

(statearr_79998[(10)] = inst_79975);

return statearr_79998;
})();
var statearr_79999_80047 = state_79991__$1;
(statearr_79999_80047[(2)] = null);

(statearr_79999_80047[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (4))){
var inst_79914 = (state_79991[(7)]);
var inst_79914__$1 = (state_79991[(2)]);
var inst_79915 = cljs.core.ex_data.call(null,inst_79914__$1);
var inst_79916 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_79915);
var inst_79917 = cljs.core._EQ_.call(null,inst_79916,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_79991__$1 = (function (){var statearr_80000 = state_79991;
(statearr_80000[(7)] = inst_79914__$1);

return statearr_80000;
})();
if(inst_79917){
var statearr_80001_80048 = state_79991__$1;
(statearr_80001_80048[(1)] = (5));

} else {
var statearr_80002_80049 = state_79991__$1;
(statearr_80002_80049[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (15))){
var inst_79943 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79944 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79945 = cljs.core.PersistentHashMap.fromArrays(inst_79943,inst_79944);
var inst_79946 = cljs.core.ex_info.call(null,"Aborted operations",inst_79945);
var state_79991__$1 = state_79991;
var statearr_80003_80050 = state_79991__$1;
(statearr_80003_80050[(2)] = inst_79946);

(statearr_80003_80050[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (21))){
var inst_79955 = (state_79991[(11)]);
var inst_79961 = (state_79991[(2)]);
var inst_79962 = cljs.core.nth.call(null,inst_79961,(0),null);
var inst_79963 = cljs.core.nth.call(null,inst_79961,(1),null);
var inst_79964 = cljs.core._EQ_.call(null,inst_79963,inst_79955);
var state_79991__$1 = (function (){var statearr_80004 = state_79991;
(statearr_80004[(12)] = inst_79962);

return statearr_80004;
})();
if(inst_79964){
var statearr_80005_80051 = state_79991__$1;
(statearr_80005_80051[(1)] = (22));

} else {
var statearr_80006_80052 = state_79991__$1;
(statearr_80006_80052[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (13))){
var inst_79985 = (state_79991[(2)]);
var state_79991__$1 = state_79991;
var statearr_80007_80053 = state_79991__$1;
(statearr_80007_80053[(2)] = inst_79985);

(statearr_80007_80053[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (22))){
var inst_79966 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_79967 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_79968 = cljs.core.PersistentHashMap.fromArrays(inst_79966,inst_79967);
var inst_79969 = cljs.core.ex_info.call(null,"Aborted operations",inst_79968);
var state_79991__$1 = state_79991;
var statearr_80008_80054 = state_79991__$1;
(statearr_80008_80054[(2)] = inst_79969);

(statearr_80008_80054[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (6))){
var inst_79914 = (state_79991[(7)]);
var inst_79920 = superv.async._track_exception.call(null,S,inst_79914);
var state_79991__$1 = state_79991;
var statearr_80009_80055 = state_79991__$1;
(statearr_80009_80055[(2)] = inst_79920);

(statearr_80009_80055[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (25))){
var inst_79972 = (state_79991[(2)]);
var state_79991__$1 = state_79991;
var statearr_80010_80056 = state_79991__$1;
(statearr_80010_80056[(2)] = inst_79972);

(statearr_80010_80056[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (17))){
var inst_79950 = (state_79991[(13)]);
var inst_79949 = (state_79991[(2)]);
var inst_79950__$1 = superv.async.throw_if_exception.call(null,S,inst_79949);
var state_79991__$1 = (function (){var statearr_80011 = state_79991;
(statearr_80011[(13)] = inst_79950__$1);

return statearr_80011;
})();
if(cljs.core.truth_(inst_79950__$1)){
var statearr_80012_80057 = state_79991__$1;
(statearr_80012_80057[(1)] = (18));

} else {
var statearr_80013_80058 = state_79991__$1;
(statearr_80013_80058[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (3))){
var inst_79911 = (state_79991[(2)]);
var inst_79912 = superv.async._unregister_go.call(null,S,id__23768__auto___80042);
var state_79991__$1 = (function (){var statearr_80014 = state_79991;
(statearr_80014[(14)] = inst_79911);

(statearr_80014[(15)] = inst_79912);

return statearr_80014;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79991__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (12))){
var inst_79983 = cljs.core.async.close_BANG_.call(null,out);
var state_79991__$1 = state_79991;
var statearr_80015_80059 = state_79991__$1;
(statearr_80015_80059[(2)] = inst_79983);

(statearr_80015_80059[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (2))){
var inst_79989 = (state_79991[(2)]);
var state_79991__$1 = state_79991;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79991__$1,inst_79989);
} else {
if((state_val_79992 === (23))){
var inst_79950 = (state_79991[(13)]);
var state_79991__$1 = state_79991;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79991__$1,(25),out,inst_79950);
} else {
if((state_val_79992 === (19))){
var inst_79926 = (state_79991[(9)]);
var inst_79978 = cljs.core.rest.call(null,inst_79926);
var inst_79926__$1 = inst_79978;
var state_79991__$1 = (function (){var statearr_80016 = state_79991;
(statearr_80016[(9)] = inst_79926__$1);

return statearr_80016;
})();
var statearr_80017_80060 = state_79991__$1;
(statearr_80017_80060[(2)] = null);

(statearr_80017_80060[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (11))){
var inst_79928 = (state_79991[(16)]);
var inst_79933 = (state_79991[(17)]);
var inst_79933__$1 = superv.async._abort.call(null,S);
var inst_79934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79935 = [inst_79933__$1,inst_79928];
var inst_79936 = (new cljs.core.PersistentVector(null,2,(5),inst_79934,inst_79935,null));
var state_79991__$1 = (function (){var statearr_80018 = state_79991;
(statearr_80018[(17)] = inst_79933__$1);

return statearr_80018;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79991__$1,(14),inst_79936,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_79992 === (9))){
var inst_79928 = (state_79991[(16)]);
var inst_79926 = (state_79991[(9)]);
var inst_79928__$1 = cljs.core.first.call(null,inst_79926);
var state_79991__$1 = (function (){var statearr_80019 = state_79991;
(statearr_80019[(16)] = inst_79928__$1);

return statearr_80019;
})();
if(cljs.core.truth_(inst_79928__$1)){
var statearr_80020_80061 = state_79991__$1;
(statearr_80020_80061[(1)] = (11));

} else {
var statearr_80021_80062 = state_79991__$1;
(statearr_80021_80062[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (5))){
var state_79991__$1 = state_79991;
var statearr_80022_80063 = state_79991__$1;
(statearr_80022_80063[(2)] = null);

(statearr_80022_80063[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (14))){
var inst_79933 = (state_79991[(17)]);
var inst_79938 = (state_79991[(2)]);
var inst_79939 = cljs.core.nth.call(null,inst_79938,(0),null);
var inst_79940 = cljs.core.nth.call(null,inst_79938,(1),null);
var inst_79941 = cljs.core._EQ_.call(null,inst_79940,inst_79933);
var state_79991__$1 = (function (){var statearr_80023 = state_79991;
(statearr_80023[(18)] = inst_79939);

return statearr_80023;
})();
if(inst_79941){
var statearr_80024_80064 = state_79991__$1;
(statearr_80024_80064[(1)] = (15));

} else {
var statearr_80025_80065 = state_79991__$1;
(statearr_80025_80065[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (16))){
var inst_79939 = (state_79991[(18)]);
var state_79991__$1 = state_79991;
var statearr_80026_80066 = state_79991__$1;
(statearr_80026_80066[(2)] = inst_79939);

(statearr_80026_80066[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (10))){
var inst_79987 = (state_79991[(2)]);
var state_79991__$1 = state_79991;
var statearr_80027_80067 = state_79991__$1;
(statearr_80027_80067[(2)] = inst_79987);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79991__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79992 === (18))){
var inst_79955 = (state_79991[(11)]);
var inst_79955__$1 = superv.async._abort.call(null,S);
var inst_79956 = cljs.core.async.timeout.call(null,(0));
var inst_79957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79958 = [inst_79955__$1,inst_79956];
var inst_79959 = (new cljs.core.PersistentVector(null,2,(5),inst_79957,inst_79958,null));
var state_79991__$1 = (function (){var statearr_80028 = state_79991;
(statearr_80028[(11)] = inst_79955__$1);

return statearr_80028;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79991__$1,(21),inst_79959,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_79992 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_79991,(4),Error,(3),(2));
var inst_79926 = cs;
var state_79991__$1 = (function (){var statearr_80029 = state_79991;
(statearr_80029[(9)] = inst_79926);

return statearr_80029;
})();
var statearr_80030_80068 = state_79991__$1;
(statearr_80030_80068[(2)] = null);

(statearr_80030_80068[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___80043,c__23767__auto___80041,id__23768__auto___80042,out))
;
return ((function (switch__38195__auto__,c__38309__auto___80043,c__23767__auto___80041,id__23768__auto___80042,out){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_80034 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80034[(0)] = superv$async$state_machine__38196__auto__);

(statearr_80034[(1)] = (1));

return statearr_80034;
});
var superv$async$state_machine__38196__auto____1 = (function (state_79991){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_79991);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e80035){if((e80035 instanceof Object)){
var ex__38199__auto__ = e80035;
var statearr_80036_80069 = state_79991;
(statearr_80036_80069[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79991);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80035;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80070 = state_79991;
state_79991 = G__80070;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_79991){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_79991);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___80043,c__23767__auto___80041,id__23768__auto___80042,out))
})();
var state__38311__auto__ = (function (){var statearr_80037 = f__38310__auto__.call(null);
(statearr_80037[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___80043);

return statearr_80037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___80043,c__23767__auto___80041,id__23768__auto___80042,out))
);


return out;
});

superv.async.concat_GT__GT_.cljs$lang$maxFixedArity = (1);

superv.async.concat_GT__GT_.cljs$lang$applyTo = (function (seq79909){
var G__79910 = cljs.core.first.call(null,seq79909);
var seq79909__$1 = cljs.core.next.call(null,seq79909);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__79910,seq79909__$1);
});

superv.async.partition_all_GT__GT_ = (function superv$async$partition_all_GT__GT_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___80288 = arguments.length;
var i__10641__auto___80289 = (0);
while(true){
if((i__10641__auto___80289 < len__10640__auto___80288)){
args__10647__auto__.push((arguments[i__10641__auto___80289]));

var G__80290 = (i__10641__auto___80289 + (1));
i__10641__auto___80289 = G__80290;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((3) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((3)),(0),null)):null);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10648__auto__);
});

superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,n,in_ch,p__80075){
var map__80076 = p__80075;
var map__80076__$1 = ((((!((map__80076 == null)))?((((map__80076.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__80076.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__80076):map__80076);
var out_ch = cljs.core.get.call(null,map__80076__$1,new cljs.core.Keyword(null,"out-ch","out-ch",-189045854));

new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(n > (0))], null)], null);

var out_ch__$1 = (function (){var or__9419__auto__ = out_ch;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})();
var c__23767__auto___80291 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___80292 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"batch","batch",977610327,null),cljs.core.PersistentVector.EMPTY], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null),cljs.core.list(new cljs.core.Symbol(null,"conj","conj",-1127293942,null),new cljs.core.Symbol(null,"batch","batch",977610327,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.PersistentVector.EMPTY)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"not-empty","not-empty",2029453590,null),new cljs.core.Symbol(null,"batch","batch",977610327,null)),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"batch","batch",977610327,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))))));
var c__38309__auto___80293 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___80293,c__23767__auto___80291,id__23768__auto___80292,out_ch__$1,map__80076,map__80076__$1,out_ch){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___80293,c__23767__auto___80291,id__23768__auto___80292,out_ch__$1,map__80076,map__80076__$1,out_ch){
return (function (state_80220){
var state_val_80221 = (state_80220[(1)]);
if((state_val_80221 === (7))){
var inst_80081 = (state_80220[(7)]);
var inst_80089 = (state_80220[(2)]);
var state_80220__$1 = (function (){var statearr_80222 = state_80220;
(statearr_80222[(8)] = inst_80089);

return statearr_80222;
})();
var statearr_80223_80294 = state_80220__$1;
(statearr_80223_80294[(2)] = inst_80081);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80220__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (20))){
var inst_80181 = (state_80220[(2)]);
var state_80220__$1 = state_80220;
var statearr_80224_80295 = state_80220__$1;
(statearr_80224_80295[(2)] = inst_80181);

(statearr_80224_80295[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (27))){
var inst_80146 = (state_80220[(9)]);
var inst_80094 = inst_80146;
var state_80220__$1 = (function (){var statearr_80225 = state_80220;
(statearr_80225[(10)] = inst_80094);

return statearr_80225;
})();
var statearr_80226_80296 = state_80220__$1;
(statearr_80226_80296[(2)] = null);

(statearr_80226_80296[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (1))){
var state_80220__$1 = state_80220;
var statearr_80227_80297 = state_80220__$1;
(statearr_80227_80297[(2)] = null);

(statearr_80227_80297[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (24))){
var inst_80142 = (state_80220[(2)]);
var inst_80143 = superv.async.throw_if_exception.call(null,S,inst_80142);
var inst_80144 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_80220__$1 = (function (){var statearr_80228 = state_80220;
(statearr_80228[(11)] = inst_80143);

return statearr_80228;
})();
var statearr_80229_80298 = state_80220__$1;
(statearr_80229_80298[(2)] = inst_80144);

(statearr_80229_80298[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (39))){
var inst_80094 = (state_80220[(10)]);
var state_80220__$1 = state_80220;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_80220__$1,(41),out_ch__$1,inst_80094);
} else {
if((state_val_80221 === (4))){
var inst_80081 = (state_80220[(7)]);
var inst_80081__$1 = (state_80220[(2)]);
var inst_80082 = cljs.core.ex_data.call(null,inst_80081__$1);
var inst_80083 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_80082);
var inst_80084 = cljs.core._EQ_.call(null,inst_80083,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_80220__$1 = (function (){var statearr_80230 = state_80220;
(statearr_80230[(7)] = inst_80081__$1);

return statearr_80230;
})();
if(inst_80084){
var statearr_80231_80299 = state_80220__$1;
(statearr_80231_80299[(1)] = (5));

} else {
var statearr_80232_80300 = state_80220__$1;
(statearr_80232_80300[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (15))){
var inst_80116 = (state_80220[(12)]);
var inst_80118 = (inst_80116 instanceof Error);
var state_80220__$1 = state_80220;
if(cljs.core.truth_(inst_80118)){
var statearr_80233_80301 = state_80220__$1;
(statearr_80233_80301[(1)] = (18));

} else {
var statearr_80234_80302 = state_80220__$1;
(statearr_80234_80302[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (21))){
var inst_80123 = (state_80220[(13)]);
var inst_80129 = (state_80220[(2)]);
var inst_80130 = cljs.core.nth.call(null,inst_80129,(0),null);
var inst_80131 = cljs.core.nth.call(null,inst_80129,(1),null);
var inst_80132 = cljs.core._EQ_.call(null,inst_80131,inst_80123);
var state_80220__$1 = (function (){var statearr_80235 = state_80220;
(statearr_80235[(14)] = inst_80130);

return statearr_80235;
})();
if(inst_80132){
var statearr_80236_80303 = state_80220__$1;
(statearr_80236_80303[(1)] = (22));

} else {
var statearr_80237_80304 = state_80220__$1;
(statearr_80237_80304[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (31))){
var inst_80146 = (state_80220[(9)]);
var state_80220__$1 = state_80220;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_80220__$1,(33),out_ch__$1,inst_80146);
} else {
if((state_val_80221 === (32))){
var inst_80172 = (state_80220[(2)]);
var inst_80173 = superv.async.throw_if_exception.call(null,S,inst_80172);
var inst_80174 = cljs.core.PersistentVector.EMPTY;
var inst_80094 = inst_80174;
var state_80220__$1 = (function (){var statearr_80238 = state_80220;
(statearr_80238[(15)] = inst_80173);

(statearr_80238[(10)] = inst_80094);

return statearr_80238;
})();
var statearr_80239_80305 = state_80220__$1;
(statearr_80239_80305[(2)] = null);

(statearr_80239_80305[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (40))){
var inst_80207 = (state_80220[(2)]);
var inst_80208 = superv.async.throw_if_exception.call(null,S,inst_80207);
var state_80220__$1 = state_80220;
var statearr_80240_80306 = state_80220__$1;
(statearr_80240_80306[(2)] = inst_80208);

(statearr_80240_80306[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (33))){
var inst_80170 = (state_80220[(2)]);
var state_80220__$1 = state_80220;
var statearr_80241_80307 = state_80220__$1;
(statearr_80241_80307[(2)] = inst_80170);

(statearr_80241_80307[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (13))){
var inst_80105 = (state_80220[(16)]);
var state_80220__$1 = state_80220;
var statearr_80242_80308 = state_80220__$1;
(statearr_80242_80308[(2)] = inst_80105);

(statearr_80242_80308[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (22))){
var inst_80134 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_80135 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_80136 = cljs.core.PersistentHashMap.fromArrays(inst_80134,inst_80135);
var inst_80137 = cljs.core.ex_info.call(null,"Aborted operations",inst_80136);
var state_80220__$1 = state_80220;
var statearr_80243_80309 = state_80220__$1;
(statearr_80243_80309[(2)] = inst_80137);

(statearr_80243_80309[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (36))){
var inst_80211 = (state_80220[(2)]);
var inst_80212 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_80220__$1 = (function (){var statearr_80244 = state_80220;
(statearr_80244[(17)] = inst_80211);

return statearr_80244;
})();
var statearr_80245_80310 = state_80220__$1;
(statearr_80245_80310[(2)] = inst_80212);

(statearr_80245_80310[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (41))){
var inst_80205 = (state_80220[(2)]);
var state_80220__$1 = state_80220;
var statearr_80246_80311 = state_80220__$1;
(statearr_80246_80311[(2)] = inst_80205);

(statearr_80246_80311[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (29))){
var inst_80153 = (state_80220[(18)]);
var inst_80159 = (state_80220[(2)]);
var inst_80160 = cljs.core.nth.call(null,inst_80159,(0),null);
var inst_80161 = cljs.core.nth.call(null,inst_80159,(1),null);
var inst_80162 = cljs.core._EQ_.call(null,inst_80161,inst_80153);
var state_80220__$1 = (function (){var statearr_80247 = state_80220;
(statearr_80247[(19)] = inst_80160);

return statearr_80247;
})();
if(inst_80162){
var statearr_80248_80312 = state_80220__$1;
(statearr_80248_80312[(1)] = (30));

} else {
var statearr_80249_80313 = state_80220__$1;
(statearr_80249_80313[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (6))){
var inst_80081 = (state_80220[(7)]);
var inst_80087 = superv.async._track_exception.call(null,S,inst_80081);
var state_80220__$1 = state_80220;
var statearr_80250_80314 = state_80220__$1;
(statearr_80250_80314[(2)] = inst_80087);

(statearr_80250_80314[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (28))){
var inst_80179 = (state_80220[(2)]);
var state_80220__$1 = state_80220;
var statearr_80251_80315 = state_80220__$1;
(statearr_80251_80315[(2)] = inst_80179);

(statearr_80251_80315[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (25))){
var inst_80140 = (state_80220[(2)]);
var state_80220__$1 = state_80220;
var statearr_80252_80316 = state_80220__$1;
(statearr_80252_80316[(2)] = inst_80140);

(statearr_80252_80316[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (34))){
var inst_80188 = (state_80220[(20)]);
var inst_80188__$1 = superv.async._abort.call(null,S);
var inst_80189 = cljs.core.async.timeout.call(null,(0));
var inst_80190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80191 = [inst_80188__$1,inst_80189];
var inst_80192 = (new cljs.core.PersistentVector(null,2,(5),inst_80190,inst_80191,null));
var state_80220__$1 = (function (){var statearr_80253 = state_80220;
(statearr_80253[(20)] = inst_80188__$1);

return statearr_80253;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_80220__$1,(37),inst_80192,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_80221 === (17))){
var inst_80214 = (state_80220[(2)]);
var state_80220__$1 = state_80220;
var statearr_80254_80317 = state_80220__$1;
(statearr_80254_80317[(2)] = inst_80214);

(statearr_80254_80317[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (3))){
var inst_80078 = (state_80220[(2)]);
var inst_80079 = superv.async._unregister_go.call(null,S,id__23768__auto___80292);
var state_80220__$1 = (function (){var statearr_80255 = state_80220;
(statearr_80255[(21)] = inst_80079);

(statearr_80255[(22)] = inst_80078);

return statearr_80255;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80220__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (12))){
var inst_80109 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_80110 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_80111 = cljs.core.PersistentHashMap.fromArrays(inst_80109,inst_80110);
var inst_80112 = cljs.core.ex_info.call(null,"Aborted operations",inst_80111);
var state_80220__$1 = state_80220;
var statearr_80256_80318 = state_80220__$1;
(statearr_80256_80318[(2)] = inst_80112);

(statearr_80256_80318[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (2))){
var inst_80218 = (state_80220[(2)]);
var state_80220__$1 = state_80220;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80220__$1,inst_80218);
} else {
if((state_val_80221 === (23))){
var inst_80116 = (state_80220[(12)]);
var state_80220__$1 = state_80220;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_80220__$1,(25),out_ch__$1,inst_80116);
} else {
if((state_val_80221 === (35))){
var state_80220__$1 = state_80220;
var statearr_80257_80319 = state_80220__$1;
(statearr_80257_80319[(2)] = null);

(statearr_80257_80319[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (19))){
var inst_80094 = (state_80220[(10)]);
var inst_80116 = (state_80220[(12)]);
var inst_80146 = (state_80220[(9)]);
var inst_80146__$1 = cljs.core.conj.call(null,inst_80094,inst_80116);
var inst_80147 = cljs.core.count.call(null,inst_80146__$1);
var inst_80148 = cljs.core._EQ_.call(null,n,inst_80147);
var state_80220__$1 = (function (){var statearr_80258 = state_80220;
(statearr_80258[(9)] = inst_80146__$1);

return statearr_80258;
})();
if(inst_80148){
var statearr_80259_80320 = state_80220__$1;
(statearr_80259_80320[(1)] = (26));

} else {
var statearr_80260_80321 = state_80220__$1;
(statearr_80260_80321[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (11))){
var inst_80099 = (state_80220[(23)]);
var inst_80104 = (state_80220[(2)]);
var inst_80105 = cljs.core.nth.call(null,inst_80104,(0),null);
var inst_80106 = cljs.core.nth.call(null,inst_80104,(1),null);
var inst_80107 = cljs.core._EQ_.call(null,inst_80106,inst_80099);
var state_80220__$1 = (function (){var statearr_80261 = state_80220;
(statearr_80261[(16)] = inst_80105);

return statearr_80261;
})();
if(inst_80107){
var statearr_80262_80322 = state_80220__$1;
(statearr_80262_80322[(1)] = (12));

} else {
var statearr_80263_80323 = state_80220__$1;
(statearr_80263_80323[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (9))){
var inst_80099 = (state_80220[(23)]);
var inst_80099__$1 = superv.async._abort.call(null,S);
var inst_80100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80101 = [inst_80099__$1,in_ch];
var inst_80102 = (new cljs.core.PersistentVector(null,2,(5),inst_80100,inst_80101,null));
var state_80220__$1 = (function (){var statearr_80264 = state_80220;
(statearr_80264[(23)] = inst_80099__$1);

return statearr_80264;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_80220__$1,(11),inst_80102,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_80221 === (5))){
var state_80220__$1 = state_80220;
var statearr_80265_80324 = state_80220__$1;
(statearr_80265_80324[(2)] = null);

(statearr_80265_80324[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (14))){
var inst_80116 = (state_80220[(12)]);
var inst_80115 = (state_80220[(2)]);
var inst_80116__$1 = superv.async.throw_if_exception.call(null,S,inst_80115);
var state_80220__$1 = (function (){var statearr_80266 = state_80220;
(statearr_80266[(12)] = inst_80116__$1);

return statearr_80266;
})();
if(cljs.core.truth_(inst_80116__$1)){
var statearr_80267_80325 = state_80220__$1;
(statearr_80267_80325[(1)] = (15));

} else {
var statearr_80268_80326 = state_80220__$1;
(statearr_80268_80326[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (26))){
var inst_80153 = (state_80220[(18)]);
var inst_80153__$1 = superv.async._abort.call(null,S);
var inst_80154 = cljs.core.async.timeout.call(null,(0));
var inst_80155 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80156 = [inst_80153__$1,inst_80154];
var inst_80157 = (new cljs.core.PersistentVector(null,2,(5),inst_80155,inst_80156,null));
var state_80220__$1 = (function (){var statearr_80269 = state_80220;
(statearr_80269[(18)] = inst_80153__$1);

return statearr_80269;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_80220__$1,(29),inst_80157,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_80221 === (16))){
var inst_80094 = (state_80220[(10)]);
var inst_80183 = cljs.core.not_empty.call(null,inst_80094);
var state_80220__$1 = state_80220;
if(cljs.core.truth_(inst_80183)){
var statearr_80270_80327 = state_80220__$1;
(statearr_80270_80327[(1)] = (34));

} else {
var statearr_80271_80328 = state_80220__$1;
(statearr_80271_80328[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (38))){
var inst_80199 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_80200 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_80201 = cljs.core.PersistentHashMap.fromArrays(inst_80199,inst_80200);
var inst_80202 = cljs.core.ex_info.call(null,"Aborted operations",inst_80201);
var state_80220__$1 = state_80220;
var statearr_80272_80329 = state_80220__$1;
(statearr_80272_80329[(2)] = inst_80202);

(statearr_80272_80329[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (30))){
var inst_80164 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_80165 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_80166 = cljs.core.PersistentHashMap.fromArrays(inst_80164,inst_80165);
var inst_80167 = cljs.core.ex_info.call(null,"Aborted operations",inst_80166);
var state_80220__$1 = state_80220;
var statearr_80273_80330 = state_80220__$1;
(statearr_80273_80330[(2)] = inst_80167);

(statearr_80273_80330[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (10))){
var inst_80216 = (state_80220[(2)]);
var state_80220__$1 = state_80220;
var statearr_80274_80331 = state_80220__$1;
(statearr_80274_80331[(2)] = inst_80216);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80220__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (18))){
var inst_80123 = (state_80220[(13)]);
var inst_80123__$1 = superv.async._abort.call(null,S);
var inst_80124 = cljs.core.async.timeout.call(null,(0));
var inst_80125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80126 = [inst_80123__$1,inst_80124];
var inst_80127 = (new cljs.core.PersistentVector(null,2,(5),inst_80125,inst_80126,null));
var state_80220__$1 = (function (){var statearr_80275 = state_80220;
(statearr_80275[(13)] = inst_80123__$1);

return statearr_80275;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_80220__$1,(21),inst_80127,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_80221 === (37))){
var inst_80188 = (state_80220[(20)]);
var inst_80194 = (state_80220[(2)]);
var inst_80195 = cljs.core.nth.call(null,inst_80194,(0),null);
var inst_80196 = cljs.core.nth.call(null,inst_80194,(1),null);
var inst_80197 = cljs.core._EQ_.call(null,inst_80196,inst_80188);
var state_80220__$1 = (function (){var statearr_80276 = state_80220;
(statearr_80276[(24)] = inst_80195);

return statearr_80276;
})();
if(inst_80197){
var statearr_80277_80332 = state_80220__$1;
(statearr_80277_80332[(1)] = (38));

} else {
var statearr_80278_80333 = state_80220__$1;
(statearr_80278_80333[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80221 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_80220,(4),Error,(3),(2));
var inst_80093 = cljs.core.PersistentVector.EMPTY;
var inst_80094 = inst_80093;
var state_80220__$1 = (function (){var statearr_80279 = state_80220;
(statearr_80279[(10)] = inst_80094);

return statearr_80279;
})();
var statearr_80280_80334 = state_80220__$1;
(statearr_80280_80334[(2)] = null);

(statearr_80280_80334[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___80293,c__23767__auto___80291,id__23768__auto___80292,out_ch__$1,map__80076,map__80076__$1,out_ch))
;
return ((function (switch__38195__auto__,c__38309__auto___80293,c__23767__auto___80291,id__23768__auto___80292,out_ch__$1,map__80076,map__80076__$1,out_ch){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_80284 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80284[(0)] = superv$async$state_machine__38196__auto__);

(statearr_80284[(1)] = (1));

return statearr_80284;
});
var superv$async$state_machine__38196__auto____1 = (function (state_80220){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_80220);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e80285){if((e80285 instanceof Object)){
var ex__38199__auto__ = e80285;
var statearr_80286_80335 = state_80220;
(statearr_80286_80335[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80220);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80285;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80336 = state_80220;
state_80220 = G__80336;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_80220){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_80220);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___80293,c__23767__auto___80291,id__23768__auto___80292,out_ch__$1,map__80076,map__80076__$1,out_ch))
})();
var state__38311__auto__ = (function (){var statearr_80287 = f__38310__auto__.call(null);
(statearr_80287[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___80293);

return statearr_80287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___80293,c__23767__auto___80291,id__23768__auto___80292,out_ch__$1,map__80076,map__80076__$1,out_ch))
);


return out_ch__$1;
});

superv.async.partition_all_GT__GT_.cljs$lang$maxFixedArity = (3);

superv.async.partition_all_GT__GT_.cljs$lang$applyTo = (function (seq80071){
var G__80072 = cljs.core.first.call(null,seq80071);
var seq80071__$1 = cljs.core.next.call(null,seq80071);
var G__80073 = cljs.core.first.call(null,seq80071__$1);
var seq80071__$2 = cljs.core.next.call(null,seq80071__$1);
var G__80074 = cljs.core.first.call(null,seq80071__$2);
var seq80071__$3 = cljs.core.next.call(null,seq80071__$2);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__80072,G__80073,G__80074,seq80071__$3);
});

/**
 * Counts items in a channel. Returns a channel with the item count.
 */
superv.async.count_GT_ = (function superv$async$count_GT_(S,ch){
return cljs.core.async.reduce.call(null,(function (acc,obj){
if((obj instanceof Error)){
return superv.async.put_QMARK_.call(null,S,superv.async._error.call(null,S),obj);
} else {
return (acc + (1));
}
}),(0),ch);
});
/**
 * Debounces channel. Forwards first item from input channel to output
 *   immediately. After that one item every interval ms (if any). If there are more
 *   items in between, they are dropped.
 */
superv.async.debounce_GT__GT_ = (function superv$async$debounce_GT__GT_(S,ch,interval){
var out = cljs.core.async.chan.call(null);
var c__23767__auto___80655 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___80656 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),null], null),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol("async","timeout","async/timeout",1951904349,null),new cljs.core.Symbol(null,"interval","interval",-945940352,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null)),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-val","new-val",902372928,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null),cljs.core.list(new cljs.core.Symbol(null,"alts?","alts?",1625745590,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null)], null))], null),cljs.core.list(new cljs.core.Symbol(null,"condp","condp",1054325175,null),new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)))))))));
var c__38309__auto___80657 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___80657,c__23767__auto___80655,id__23768__auto___80656,out){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___80657,c__23767__auto___80655,id__23768__auto___80656,out){
return (function (state_80601){
var state_val_80602 = (state_80601[(1)]);
if((state_val_80602 === (7))){
var inst_80499 = (state_80601[(7)]);
var inst_80507 = (state_80601[(2)]);
var state_80601__$1 = (function (){var statearr_80603 = state_80601;
(statearr_80603[(8)] = inst_80507);

return statearr_80603;
})();
var statearr_80604_80658 = state_80601__$1;
(statearr_80604_80658[(2)] = inst_80499);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80601__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (20))){
var inst_80595 = (state_80601[(2)]);
var state_80601__$1 = state_80601;
var statearr_80605_80659 = state_80601__$1;
(statearr_80605_80659[(2)] = inst_80595);

(statearr_80605_80659[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (27))){
var inst_80579 = (state_80601[(2)]);
var inst_80580 = superv.async.throw_if_exception.call(null,S,inst_80579);
var inst_80511 = null;
var state_80601__$1 = (function (){var statearr_80606 = state_80601;
(statearr_80606[(9)] = inst_80511);

(statearr_80606[(10)] = inst_80580);

return statearr_80606;
})();
var statearr_80607_80660 = state_80601__$1;
(statearr_80607_80660[(2)] = null);

(statearr_80607_80660[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (1))){
var state_80601__$1 = state_80601;
var statearr_80608_80661 = state_80601__$1;
(statearr_80608_80661[(2)] = null);

(statearr_80608_80661[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (24))){
var inst_80560 = (state_80601[(11)]);
var inst_80566 = (state_80601[(2)]);
var inst_80567 = cljs.core.nth.call(null,inst_80566,(0),null);
var inst_80568 = cljs.core.nth.call(null,inst_80566,(1),null);
var inst_80569 = cljs.core._EQ_.call(null,inst_80568,inst_80560);
var state_80601__$1 = (function (){var statearr_80609 = state_80601;
(statearr_80609[(12)] = inst_80567);

return statearr_80609;
})();
if(inst_80569){
var statearr_80610_80662 = state_80601__$1;
(statearr_80610_80662[(1)] = (25));

} else {
var statearr_80611_80663 = state_80601__$1;
(statearr_80611_80663[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (4))){
var inst_80499 = (state_80601[(7)]);
var inst_80499__$1 = (state_80601[(2)]);
var inst_80500 = cljs.core.ex_data.call(null,inst_80499__$1);
var inst_80501 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_80500);
var inst_80502 = cljs.core._EQ_.call(null,inst_80501,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_80601__$1 = (function (){var statearr_80612 = state_80601;
(statearr_80612[(7)] = inst_80499__$1);

return statearr_80612;
})();
if(inst_80502){
var statearr_80613_80664 = state_80601__$1;
(statearr_80613_80664[(1)] = (5));

} else {
var statearr_80614_80665 = state_80601__$1;
(statearr_80614_80665[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (15))){
var inst_80528 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_80529 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_80530 = cljs.core.PersistentHashMap.fromArrays(inst_80528,inst_80529);
var inst_80531 = cljs.core.ex_info.call(null,"Aborted operations",inst_80530);
var state_80601__$1 = state_80601;
var statearr_80615_80666 = state_80601__$1;
(statearr_80615_80666[(2)] = inst_80531);

(statearr_80615_80666[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (21))){
var inst_80560 = (state_80601[(11)]);
var inst_80560__$1 = superv.async._abort.call(null,S);
var inst_80561 = cljs.core.async.timeout.call(null,(0));
var inst_80562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80563 = [inst_80560__$1,inst_80561];
var inst_80564 = (new cljs.core.PersistentVector(null,2,(5),inst_80562,inst_80563,null));
var state_80601__$1 = (function (){var statearr_80616 = state_80601;
(statearr_80616[(11)] = inst_80560__$1);

return statearr_80616;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_80601__$1,(24),inst_80564,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_80602 === (31))){
var inst_80591 = (state_80601[(2)]);
var state_80601__$1 = state_80601;
var statearr_80617_80667 = state_80601__$1;
(statearr_80617_80667[(2)] = inst_80591);

(statearr_80617_80667[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (13))){
var inst_80537 = (state_80601[(13)]);
var inst_80537__$1 = (state_80601[(2)]);
var inst_80538 = cljs.core.async.timeout.call(null,interval);
var inst_80539 = (inst_80537__$1 == null);
var state_80601__$1 = (function (){var statearr_80618 = state_80601;
(statearr_80618[(13)] = inst_80537__$1);

(statearr_80618[(14)] = inst_80538);

return statearr_80618;
})();
if(cljs.core.truth_(inst_80539)){
var statearr_80619_80668 = state_80601__$1;
(statearr_80619_80668[(1)] = (18));

} else {
var statearr_80620_80669 = state_80601__$1;
(statearr_80620_80669[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (22))){
var inst_80551 = (state_80601[(15)]);
var inst_80583 = cljs.core._EQ_.call(null,inst_80551,inst_80551);
var state_80601__$1 = state_80601;
if(inst_80583){
var statearr_80621_80670 = state_80601__$1;
(statearr_80621_80670[(1)] = (29));

} else {
var statearr_80622_80671 = state_80601__$1;
(statearr_80622_80671[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (29))){
var inst_80550 = (state_80601[(16)]);
var inst_80511 = inst_80550;
var state_80601__$1 = (function (){var statearr_80623 = state_80601;
(statearr_80623[(9)] = inst_80511);

return statearr_80623;
})();
var statearr_80624_80672 = state_80601__$1;
(statearr_80624_80672[(2)] = null);

(statearr_80624_80672[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (6))){
var inst_80499 = (state_80601[(7)]);
var inst_80505 = superv.async._track_exception.call(null,S,inst_80499);
var state_80601__$1 = state_80601;
var statearr_80625_80673 = state_80601__$1;
(statearr_80625_80673[(2)] = inst_80505);

(statearr_80625_80673[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (28))){
var inst_80577 = (state_80601[(2)]);
var state_80601__$1 = state_80601;
var statearr_80626_80674 = state_80601__$1;
(statearr_80626_80674[(2)] = inst_80577);

(statearr_80626_80674[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (25))){
var inst_80571 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_80572 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_80573 = cljs.core.PersistentHashMap.fromArrays(inst_80571,inst_80572);
var inst_80574 = cljs.core.ex_info.call(null,"Aborted operations",inst_80573);
var state_80601__$1 = state_80601;
var statearr_80627_80675 = state_80601__$1;
(statearr_80627_80675[(2)] = inst_80574);

(statearr_80627_80675[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (17))){
var inst_80534 = (state_80601[(2)]);
var inst_80535 = superv.async.throw_if_exception.call(null,S,inst_80534);
var state_80601__$1 = state_80601;
var statearr_80628_80676 = state_80601__$1;
(statearr_80628_80676[(2)] = inst_80535);

(statearr_80628_80676[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (3))){
var inst_80496 = (state_80601[(2)]);
var inst_80497 = superv.async._unregister_go.call(null,S,id__23768__auto___80656);
var state_80601__$1 = (function (){var statearr_80629 = state_80601;
(statearr_80629[(17)] = inst_80497);

(statearr_80629[(18)] = inst_80496);

return statearr_80629;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80601__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (12))){
var inst_80518 = (state_80601[(19)]);
var inst_80518__$1 = superv.async._abort.call(null,S);
var inst_80519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80520 = [inst_80518__$1,ch];
var inst_80521 = (new cljs.core.PersistentVector(null,2,(5),inst_80519,inst_80520,null));
var state_80601__$1 = (function (){var statearr_80630 = state_80601;
(statearr_80630[(19)] = inst_80518__$1);

return statearr_80630;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_80601__$1,(14),inst_80521,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_80602 === (2))){
var inst_80599 = (state_80601[(2)]);
var state_80601__$1 = state_80601;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80601__$1,inst_80599);
} else {
if((state_val_80602 === (23))){
var inst_80593 = (state_80601[(2)]);
var state_80601__$1 = state_80601;
var statearr_80631_80677 = state_80601__$1;
(statearr_80631_80677[(2)] = inst_80593);

(statearr_80631_80677[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (19))){
var inst_80551 = (state_80601[(15)]);
var inst_80538 = (state_80601[(14)]);
var inst_80546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80547 = [ch,inst_80538];
var inst_80548 = (new cljs.core.PersistentVector(null,2,(5),inst_80546,inst_80547,null));
var inst_80549 = superv.async.alts_QMARK_.call(null,S,inst_80548);
var inst_80550 = cljs.core.nth.call(null,inst_80549,(0),null);
var inst_80551__$1 = cljs.core.nth.call(null,inst_80549,(1),null);
var inst_80555 = cljs.core._EQ_.call(null,inst_80538,inst_80551__$1);
var state_80601__$1 = (function (){var statearr_80632 = state_80601;
(statearr_80632[(16)] = inst_80550);

(statearr_80632[(15)] = inst_80551__$1);

return statearr_80632;
})();
if(inst_80555){
var statearr_80633_80678 = state_80601__$1;
(statearr_80633_80678[(1)] = (21));

} else {
var statearr_80634_80679 = state_80601__$1;
(statearr_80634_80679[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (11))){
var inst_80511 = (state_80601[(9)]);
var state_80601__$1 = state_80601;
var statearr_80635_80680 = state_80601__$1;
(statearr_80635_80680[(2)] = inst_80511);

(statearr_80635_80680[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (9))){
var inst_80511 = (state_80601[(9)]);
var state_80601__$1 = state_80601;
if(cljs.core.truth_(inst_80511)){
var statearr_80636_80681 = state_80601__$1;
(statearr_80636_80681[(1)] = (11));

} else {
var statearr_80637_80682 = state_80601__$1;
(statearr_80637_80682[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (5))){
var state_80601__$1 = state_80601;
var statearr_80638_80683 = state_80601__$1;
(statearr_80638_80683[(2)] = null);

(statearr_80638_80683[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (14))){
var inst_80518 = (state_80601[(19)]);
var inst_80523 = (state_80601[(2)]);
var inst_80524 = cljs.core.nth.call(null,inst_80523,(0),null);
var inst_80525 = cljs.core.nth.call(null,inst_80523,(1),null);
var inst_80526 = cljs.core._EQ_.call(null,inst_80525,inst_80518);
var state_80601__$1 = (function (){var statearr_80639 = state_80601;
(statearr_80639[(20)] = inst_80524);

return statearr_80639;
})();
if(inst_80526){
var statearr_80640_80684 = state_80601__$1;
(statearr_80640_80684[(1)] = (15));

} else {
var statearr_80641_80685 = state_80601__$1;
(statearr_80641_80685[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (26))){
var inst_80537 = (state_80601[(13)]);
var state_80601__$1 = state_80601;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_80601__$1,(28),out,inst_80537);
} else {
if((state_val_80602 === (16))){
var inst_80524 = (state_80601[(20)]);
var state_80601__$1 = state_80601;
var statearr_80642_80686 = state_80601__$1;
(statearr_80642_80686[(2)] = inst_80524);

(statearr_80642_80686[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (30))){
var inst_80551 = (state_80601[(15)]);
var inst_80587 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_80551)].join('');
var inst_80588 = (new Error(inst_80587));
var inst_80589 = (function(){throw inst_80588})();
var state_80601__$1 = state_80601;
var statearr_80643_80687 = state_80601__$1;
(statearr_80643_80687[(2)] = inst_80589);

(statearr_80643_80687[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (10))){
var inst_80597 = (state_80601[(2)]);
var state_80601__$1 = state_80601;
var statearr_80644_80688 = state_80601__$1;
(statearr_80644_80688[(2)] = inst_80597);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80601__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (18))){
var inst_80541 = cljs.core.async.close_BANG_.call(null,out);
var state_80601__$1 = state_80601;
var statearr_80645_80689 = state_80601__$1;
(statearr_80645_80689[(2)] = inst_80541);

(statearr_80645_80689[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80602 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_80601,(4),Error,(3),(2));
var inst_80511 = null;
var state_80601__$1 = (function (){var statearr_80646 = state_80601;
(statearr_80646[(9)] = inst_80511);

return statearr_80646;
})();
var statearr_80647_80690 = state_80601__$1;
(statearr_80647_80690[(2)] = null);

(statearr_80647_80690[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___80657,c__23767__auto___80655,id__23768__auto___80656,out))
;
return ((function (switch__38195__auto__,c__38309__auto___80657,c__23767__auto___80655,id__23768__auto___80656,out){
return (function() {
var superv$async$debounce_GT__GT__$_state_machine__38196__auto__ = null;
var superv$async$debounce_GT__GT__$_state_machine__38196__auto____0 = (function (){
var statearr_80651 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80651[(0)] = superv$async$debounce_GT__GT__$_state_machine__38196__auto__);

(statearr_80651[(1)] = (1));

return statearr_80651;
});
var superv$async$debounce_GT__GT__$_state_machine__38196__auto____1 = (function (state_80601){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_80601);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e80652){if((e80652 instanceof Object)){
var ex__38199__auto__ = e80652;
var statearr_80653_80691 = state_80601;
(statearr_80653_80691[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80601);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80652;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80692 = state_80601;
state_80601 = G__80692;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$debounce_GT__GT__$_state_machine__38196__auto__ = function(state_80601){
switch(arguments.length){
case 0:
return superv$async$debounce_GT__GT__$_state_machine__38196__auto____0.call(this);
case 1:
return superv$async$debounce_GT__GT__$_state_machine__38196__auto____1.call(this,state_80601);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$debounce_GT__GT__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$debounce_GT__GT__$_state_machine__38196__auto____0;
superv$async$debounce_GT__GT__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$debounce_GT__GT__$_state_machine__38196__auto____1;
return superv$async$debounce_GT__GT__$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___80657,c__23767__auto___80655,id__23768__auto___80656,out))
})();
var state__38311__auto__ = (function (){var statearr_80654 = f__38310__auto__.call(null);
(statearr_80654[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___80657);

return statearr_80654;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___80657,c__23767__auto___80655,id__23768__auto___80656,out))
);


return out;
});
/**
 * Safely managed tap. The channel is closed on abortion and all
 *   pending puts are flushed.
 */
superv.async.tap = (function superv$async$tap(var_args){
var args80693 = [];
var len__10640__auto___80831 = arguments.length;
var i__10641__auto___80832 = (0);
while(true){
if((i__10641__auto___80832 < len__10640__auto___80831)){
args80693.push((arguments[i__10641__auto___80832]));

var G__80833 = (i__10641__auto___80832 + (1));
i__10641__auto___80832 = G__80833;
continue;
} else {
}
break;
}

var G__80695 = args80693.length;
switch (G__80695) {
case 3:
return superv.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.tap.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args80693.length)].join('')));

}
});

superv.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (S,mult,ch){
return superv.async.tap.call(null,S,mult,ch,false);
});

superv.async.tap.cljs$core$IFn$_invoke$arity$4 = (function (S,mult,ch,close_QMARK_){
var c__23767__auto___80835 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___80836 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__38309__auto___80837 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___80837,c__23767__auto___80835,id__23768__auto___80836){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___80837,c__23767__auto___80835,id__23768__auto___80836){
return (function (state_80774){
var state_val_80775 = (state_80774[(1)]);
if((state_val_80775 === (7))){
var inst_80699 = (state_80774[(7)]);
var inst_80707 = (state_80774[(2)]);
var state_80774__$1 = (function (){var statearr_80776 = state_80774;
(statearr_80776[(8)] = inst_80707);

return statearr_80776;
})();
var statearr_80777_80838 = state_80774__$1;
(statearr_80777_80838[(2)] = inst_80699);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80774__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80775 === (1))){
var state_80774__$1 = state_80774;
var statearr_80778_80839 = state_80774__$1;
(statearr_80778_80839[(2)] = null);

(statearr_80778_80839[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80775 === (4))){
var inst_80699 = (state_80774[(7)]);
var inst_80699__$1 = (state_80774[(2)]);
var inst_80700 = cljs.core.ex_data.call(null,inst_80699__$1);
var inst_80701 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_80700);
var inst_80702 = cljs.core._EQ_.call(null,inst_80701,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_80774__$1 = (function (){var statearr_80779 = state_80774;
(statearr_80779[(7)] = inst_80699__$1);

return statearr_80779;
})();
if(inst_80702){
var statearr_80780_80840 = state_80774__$1;
(statearr_80780_80840[(1)] = (5));

} else {
var statearr_80781_80841 = state_80774__$1;
(statearr_80781_80841[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80775 === (15))){
var inst_80723 = (state_80774[(2)]);
var state_80774__$1 = state_80774;
var statearr_80782_80842 = state_80774__$1;
(statearr_80782_80842[(2)] = inst_80723);

(statearr_80782_80842[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80775 === (13))){
var state_80774__$1 = state_80774;
var statearr_80783_80843 = state_80774__$1;
(statearr_80783_80843[(2)] = null);

(statearr_80783_80843[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80775 === (6))){
var inst_80699 = (state_80774[(7)]);
var inst_80705 = superv.async._track_exception.call(null,S,inst_80699);
var state_80774__$1 = state_80774;
var statearr_80784_80844 = state_80774__$1;
(statearr_80784_80844[(2)] = inst_80705);

(statearr_80784_80844[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80775 === (3))){
var inst_80696 = (state_80774[(2)]);
var inst_80697 = superv.async._unregister_go.call(null,S,id__23768__auto___80836);
var state_80774__$1 = (function (){var statearr_80785 = state_80774;
(statearr_80785[(9)] = inst_80696);

(statearr_80785[(10)] = inst_80697);

return statearr_80785;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80774__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80775 === (12))){
var inst_80718 = (state_80774[(2)]);
var state_80774__$1 = state_80774;
if(cljs.core.truth_(inst_80718)){
var statearr_80786_80845 = state_80774__$1;
(statearr_80786_80845[(1)] = (13));

} else {
var statearr_80787_80846 = state_80774__$1;
(statearr_80787_80846[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80775 === (2))){
var inst_80772 = (state_80774[(2)]);
var state_80774__$1 = state_80774;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80774__$1,inst_80772);
} else {
if((state_val_80775 === (11))){
var inst_80715 = (state_80774[(11)]);
var inst_80725 = (state_80774[(2)]);
var inst_80726 = null;
var inst_80727 = superv.async._register_go.call(null,inst_80725,inst_80726);
var inst_80768 = cljs.core.async.chan.call(null,(1));
var inst_80769 = (function (){var c__23767__auto____$1 = inst_80715;
var id__23768__auto____$1 = inst_80727;
var c__38309__auto____$1 = inst_80768;
return ((function (c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_80715,inst_80725,inst_80726,inst_80727,inst_80768,state_val_80775,c__38309__auto___80837,c__23767__auto___80835,id__23768__auto___80836){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_80715,inst_80725,inst_80726,inst_80727,inst_80768,state_val_80775,c__38309__auto___80837,c__23767__auto___80835,id__23768__auto___80836){
return (function (state_80766){
var state_val_80767 = (state_80766[(1)]);
if((state_val_80767 === (7))){
var state_80766__$1 = state_80766;
var statearr_80788_80847 = state_80766__$1;
(statearr_80788_80847[(2)] = null);

(statearr_80788_80847[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80767 === (20))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_80766,(10),Error,(3),(2));
var state_80766__$1 = state_80766;
var statearr_80789_80848 = state_80766__$1;
(statearr_80789_80848[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80766__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80767 === (1))){
var state_80766__$1 = state_80766;
var statearr_80790_80849 = state_80766__$1;
(statearr_80790_80849[(2)] = null);

(statearr_80790_80849[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80767 === (4))){
var state_80766__$1 = state_80766;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80766__$1,(6),ch);
} else {
if((state_val_80767 === (15))){
var inst_80741 = (state_80766[(7)]);
var inst_80756 = (state_80766[(2)]);
var inst_80757 = superv.async._track_exception.call(null,inst_80756,inst_80741);
var state_80766__$1 = state_80766;
var statearr_80791_80850 = state_80766__$1;
(statearr_80791_80850[(2)] = inst_80757);

(statearr_80791_80850[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80767 === (13))){
var inst_80741 = (state_80766[(7)]);
var inst_80759 = (state_80766[(2)]);
var state_80766__$1 = (function (){var statearr_80792 = state_80766;
(statearr_80792[(8)] = inst_80759);

return statearr_80792;
})();
var statearr_80793_80851 = state_80766__$1;
(statearr_80793_80851[(2)] = inst_80741);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80766__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80767 === (6))){
var inst_80731 = (state_80766[(2)]);
var state_80766__$1 = state_80766;
if(cljs.core.truth_(inst_80731)){
var statearr_80794_80852 = state_80766__$1;
(statearr_80794_80852[(1)] = (7));

} else {
var statearr_80795_80853 = state_80766__$1;
(statearr_80795_80853[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80767 === (17))){
var state_80766__$1 = state_80766;
var statearr_80796_80854 = state_80766__$1;
(statearr_80796_80854[(2)] = null);

(statearr_80796_80854[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80767 === (3))){
var inst_80728 = (state_80766[(2)]);
var state_80766__$1 = (function (){var statearr_80797 = state_80766;
(statearr_80797[(9)] = inst_80728);

return statearr_80797;
})();
var statearr_80798_80855 = state_80766__$1;
(statearr_80798_80855[(2)] = null);

(statearr_80798_80855[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80767 === (12))){
var state_80766__$1 = state_80766;
var statearr_80799_80856 = state_80766__$1;
(statearr_80799_80856[(2)] = null);

(statearr_80799_80856[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80767 === (2))){
var inst_80764 = (state_80766[(2)]);
var state_80766__$1 = state_80766;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80766__$1,inst_80764);
} else {
if((state_val_80767 === (19))){
var inst_80754 = (state_80766[(2)]);
var state_80766__$1 = state_80766;
var statearr_80800_80857 = state_80766__$1;
(statearr_80800_80857[(2)] = inst_80754);

(statearr_80800_80857[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80767 === (11))){
var state_80766__$1 = state_80766;
var statearr_80801_80858 = state_80766__$1;
(statearr_80801_80858[(2)] = null);

(statearr_80801_80858[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80767 === (9))){
var inst_80736 = (state_80766[(2)]);
var state_80766__$1 = state_80766;
var statearr_80802_80859 = state_80766__$1;
(statearr_80802_80859[(2)] = inst_80736);

(statearr_80802_80859[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80767 === (5))){
var inst_80738 = (state_80766[(2)]);
var inst_80739 = superv.async._unregister_go.call(null,inst_80738,id__23768__auto____$1);
var state_80766__$1 = (function (){var statearr_80803 = state_80766;
(statearr_80803[(10)] = inst_80739);

return statearr_80803;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80766__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80767 === (14))){
var state_80766__$1 = state_80766;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80766__$1,(16),ch);
} else {
if((state_val_80767 === (16))){
var inst_80749 = (state_80766[(2)]);
var state_80766__$1 = state_80766;
if(cljs.core.truth_(inst_80749)){
var statearr_80804_80860 = state_80766__$1;
(statearr_80804_80860[(1)] = (17));

} else {
var statearr_80805_80861 = state_80766__$1;
(statearr_80805_80861[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80767 === (10))){
var inst_80741 = (state_80766[(7)]);
var inst_80741__$1 = (state_80766[(2)]);
var inst_80742 = cljs.core.ex_data.call(null,inst_80741__$1);
var inst_80743 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_80742);
var inst_80744 = cljs.core._EQ_.call(null,inst_80743,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_80766__$1 = (function (){var statearr_80806 = state_80766;
(statearr_80806[(7)] = inst_80741__$1);

return statearr_80806;
})();
if(inst_80744){
var statearr_80807_80862 = state_80766__$1;
(statearr_80807_80862[(1)] = (11));

} else {
var statearr_80808_80863 = state_80766__$1;
(statearr_80808_80863[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80767 === (18))){
var state_80766__$1 = state_80766;
var statearr_80809_80864 = state_80766__$1;
(statearr_80809_80864[(2)] = null);

(statearr_80809_80864[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80767 === (8))){
var state_80766__$1 = state_80766;
var statearr_80810_80865 = state_80766__$1;
(statearr_80810_80865[(2)] = null);

(statearr_80810_80865[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_80715,inst_80725,inst_80726,inst_80727,inst_80768,state_val_80775,c__38309__auto___80837,c__23767__auto___80835,id__23768__auto___80836))
;
return ((function (switch__38195__auto__,c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_80715,inst_80725,inst_80726,inst_80727,inst_80768,state_val_80775,c__38309__auto___80837,c__23767__auto___80835,id__23768__auto___80836){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_80814 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_80814[(0)] = superv$async$state_machine__38196__auto__);

(statearr_80814[(1)] = (1));

return statearr_80814;
});
var superv$async$state_machine__38196__auto____1 = (function (state_80766){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_80766);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e80815){if((e80815 instanceof Object)){
var ex__38199__auto__ = e80815;
var statearr_80816_80866 = state_80766;
(statearr_80816_80866[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80766);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80815;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80867 = state_80766;
state_80766 = G__80867;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_80766){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_80766);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_80715,inst_80725,inst_80726,inst_80727,inst_80768,state_val_80775,c__38309__auto___80837,c__23767__auto___80835,id__23768__auto___80836))
})();
var state__38311__auto__ = (function (){var statearr_80817 = f__38310__auto__.call(null);
(statearr_80817[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto____$1);

return statearr_80817;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});
;})(c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_80715,inst_80725,inst_80726,inst_80727,inst_80768,state_val_80775,c__38309__auto___80837,c__23767__auto___80835,id__23768__auto___80836))
})();
var inst_80770 = cljs.core.async.impl.dispatch.run.call(null,inst_80769);
var state_80774__$1 = (function (){var statearr_80818 = state_80774;
(statearr_80818[(12)] = inst_80770);

return statearr_80818;
})();
var statearr_80819_80868 = state_80774__$1;
(statearr_80819_80868[(2)] = inst_80768);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80774__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80775 === (9))){
var inst_80713 = (state_80774[(2)]);
var inst_80714 = cljs.core.async.close_BANG_.call(null,ch);
var inst_80715 = superv.async.check_supervisor.call(null,superv.async.S);
var state_80774__$1 = (function (){var statearr_80820 = state_80774;
(statearr_80820[(13)] = inst_80713);

(statearr_80820[(14)] = inst_80714);

(statearr_80820[(11)] = inst_80715);

return statearr_80820;
})();
var statearr_80821_80869 = state_80774__$1;
(statearr_80821_80869[(2)] = null);

(statearr_80821_80869[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80775 === (5))){
var state_80774__$1 = state_80774;
var statearr_80822_80870 = state_80774__$1;
(statearr_80822_80870[(2)] = null);

(statearr_80822_80870[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80775 === (14))){
var state_80774__$1 = state_80774;
var statearr_80823_80871 = state_80774__$1;
(statearr_80823_80871[(2)] = null);

(statearr_80823_80871[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80775 === (10))){
var state_80774__$1 = state_80774;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80774__$1,(12),ch);
} else {
if((state_val_80775 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_80774,(4),Error,(3),(2));
var inst_80711 = superv.async._abort.call(null,S);
var state_80774__$1 = state_80774;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80774__$1,(9),inst_80711);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___80837,c__23767__auto___80835,id__23768__auto___80836))
;
return ((function (switch__38195__auto__,c__38309__auto___80837,c__23767__auto___80835,id__23768__auto___80836){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_80827 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80827[(0)] = superv$async$state_machine__38196__auto__);

(statearr_80827[(1)] = (1));

return statearr_80827;
});
var superv$async$state_machine__38196__auto____1 = (function (state_80774){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_80774);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e80828){if((e80828 instanceof Object)){
var ex__38199__auto__ = e80828;
var statearr_80829_80872 = state_80774;
(statearr_80829_80872[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80774);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80828;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80873 = state_80774;
state_80774 = G__80873;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_80774){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_80774);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___80837,c__23767__auto___80835,id__23768__auto___80836))
})();
var state__38311__auto__ = (function (){var statearr_80830 = f__38310__auto__.call(null);
(statearr_80830[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___80837);

return statearr_80830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___80837,c__23767__auto___80835,id__23768__auto___80836))
);


return cljs.core.async.tap.call(null,mult,ch,close_QMARK_);
});

superv.async.tap.cljs$lang$maxFixedArity = 4;

/**
 * Safely managed subscription. The channel is closed on abortion and
 *   all pending puts are flushed.
 */
superv.async.sub = (function superv$async$sub(var_args){
var args80874 = [];
var len__10640__auto___80978 = arguments.length;
var i__10641__auto___80979 = (0);
while(true){
if((i__10641__auto___80979 < len__10640__auto___80978)){
args80874.push((arguments[i__10641__auto___80979]));

var G__80980 = (i__10641__auto___80979 + (1));
i__10641__auto___80979 = G__80980;
continue;
} else {
}
break;
}

var G__80876 = args80874.length;
switch (G__80876) {
case 4:
return superv.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.sub.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args80874.length)].join('')));

}
});

superv.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (S,p,topic,ch){
return superv.async.sub.call(null,S,p,topic,ch,false);
});

superv.async.sub.cljs$core$IFn$_invoke$arity$5 = (function (S,p,topic,ch,close_QMARK_){
var c__23767__auto___80982 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___80983 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__38309__auto___80984 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___80984,c__23767__auto___80982,id__23768__auto___80983){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___80984,c__23767__auto___80982,id__23768__auto___80983){
return (function (state_80935){
var state_val_80936 = (state_80935[(1)]);
if((state_val_80936 === (1))){
var state_80935__$1 = state_80935;
var statearr_80937_80985 = state_80935__$1;
(statearr_80937_80985[(2)] = null);

(statearr_80937_80985[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80936 === (2))){
var inst_80933 = (state_80935[(2)]);
var state_80935__$1 = state_80935;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80935__$1,inst_80933);
} else {
if((state_val_80936 === (3))){
var inst_80877 = (state_80935[(2)]);
var inst_80878 = superv.async._unregister_go.call(null,S,id__23768__auto___80983);
var state_80935__$1 = (function (){var statearr_80938 = state_80935;
(statearr_80938[(7)] = inst_80878);

(statearr_80938[(8)] = inst_80877);

return statearr_80938;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80935__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80936 === (4))){
var inst_80880 = (state_80935[(9)]);
var inst_80880__$1 = (state_80935[(2)]);
var inst_80881 = cljs.core.ex_data.call(null,inst_80880__$1);
var inst_80882 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_80881);
var inst_80883 = cljs.core._EQ_.call(null,inst_80882,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_80935__$1 = (function (){var statearr_80939 = state_80935;
(statearr_80939[(9)] = inst_80880__$1);

return statearr_80939;
})();
if(inst_80883){
var statearr_80940_80986 = state_80935__$1;
(statearr_80940_80986[(1)] = (5));

} else {
var statearr_80941_80987 = state_80935__$1;
(statearr_80941_80987[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80936 === (5))){
var state_80935__$1 = state_80935;
var statearr_80942_80988 = state_80935__$1;
(statearr_80942_80988[(2)] = null);

(statearr_80942_80988[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80936 === (6))){
var inst_80880 = (state_80935[(9)]);
var inst_80886 = superv.async._track_exception.call(null,S,inst_80880);
var state_80935__$1 = state_80935;
var statearr_80943_80989 = state_80935__$1;
(statearr_80943_80989[(2)] = inst_80886);

(statearr_80943_80989[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80936 === (7))){
var inst_80880 = (state_80935[(9)]);
var inst_80888 = (state_80935[(2)]);
var state_80935__$1 = (function (){var statearr_80944 = state_80935;
(statearr_80944[(10)] = inst_80888);

return statearr_80944;
})();
var statearr_80945_80990 = state_80935__$1;
(statearr_80945_80990[(2)] = inst_80880);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80935__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80936 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_80935,(4),Error,(3),(2));
var inst_80892 = superv.async._abort.call(null,S);
var state_80935__$1 = state_80935;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80935__$1,(9),inst_80892);
} else {
if((state_val_80936 === (9))){
var inst_80894 = (state_80935[(2)]);
var inst_80895 = cljs.core.async.close_BANG_.call(null,ch);
var inst_80896 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_80897 = cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))));
var inst_80898 = superv.async._register_go.call(null,S,inst_80897);
var inst_80929 = cljs.core.async.chan.call(null,(1));
var inst_80930 = (function (){var c__23767__auto____$1 = inst_80896;
var id__23768__auto____$1 = inst_80898;
var c__38309__auto____$1 = inst_80929;
return ((function (c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_80894,inst_80895,inst_80896,inst_80897,inst_80898,inst_80929,state_val_80936,c__38309__auto___80984,c__23767__auto___80982,id__23768__auto___80983){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_80894,inst_80895,inst_80896,inst_80897,inst_80898,inst_80929,state_val_80936,c__38309__auto___80984,c__23767__auto___80982,id__23768__auto___80983){
return (function (state_80927){
var state_val_80928 = (state_80927[(1)]);
if((state_val_80928 === (7))){
var inst_80902 = (state_80927[(7)]);
var inst_80910 = (state_80927[(2)]);
var state_80927__$1 = (function (){var statearr_80946 = state_80927;
(statearr_80946[(8)] = inst_80910);

return statearr_80946;
})();
var statearr_80947_80991 = state_80927__$1;
(statearr_80947_80991[(2)] = inst_80902);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80927__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80928 === (1))){
var state_80927__$1 = state_80927;
var statearr_80948_80992 = state_80927__$1;
(statearr_80948_80992[(2)] = null);

(statearr_80948_80992[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80928 === (4))){
var inst_80902 = (state_80927[(7)]);
var inst_80902__$1 = (state_80927[(2)]);
var inst_80903 = cljs.core.ex_data.call(null,inst_80902__$1);
var inst_80904 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_80903);
var inst_80905 = cljs.core._EQ_.call(null,inst_80904,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_80927__$1 = (function (){var statearr_80949 = state_80927;
(statearr_80949[(7)] = inst_80902__$1);

return statearr_80949;
})();
if(inst_80905){
var statearr_80950_80993 = state_80927__$1;
(statearr_80950_80993[(1)] = (5));

} else {
var statearr_80951_80994 = state_80927__$1;
(statearr_80951_80994[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80928 === (13))){
var state_80927__$1 = state_80927;
var statearr_80952_80995 = state_80927__$1;
(statearr_80952_80995[(2)] = null);

(statearr_80952_80995[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80928 === (6))){
var inst_80902 = (state_80927[(7)]);
var inst_80908 = superv.async._track_exception.call(null,S,inst_80902);
var state_80927__$1 = state_80927;
var statearr_80953_80996 = state_80927__$1;
(statearr_80953_80996[(2)] = inst_80908);

(statearr_80953_80996[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80928 === (3))){
var inst_80899 = (state_80927[(2)]);
var inst_80900 = superv.async._unregister_go.call(null,S,id__23768__auto____$1);
var state_80927__$1 = (function (){var statearr_80954 = state_80927;
(statearr_80954[(9)] = inst_80900);

(statearr_80954[(10)] = inst_80899);

return statearr_80954;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80927__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80928 === (12))){
var state_80927__$1 = state_80927;
var statearr_80955_80997 = state_80927__$1;
(statearr_80955_80997[(2)] = null);

(statearr_80955_80997[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80928 === (2))){
var inst_80925 = (state_80927[(2)]);
var state_80927__$1 = state_80927;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80927__$1,inst_80925);
} else {
if((state_val_80928 === (11))){
var inst_80916 = (state_80927[(2)]);
var state_80927__$1 = state_80927;
if(cljs.core.truth_(inst_80916)){
var statearr_80956_80998 = state_80927__$1;
(statearr_80956_80998[(1)] = (12));

} else {
var statearr_80957_80999 = state_80927__$1;
(statearr_80957_80999[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80928 === (9))){
var state_80927__$1 = state_80927;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80927__$1,(11),ch);
} else {
if((state_val_80928 === (5))){
var state_80927__$1 = state_80927;
var statearr_80958_81000 = state_80927__$1;
(statearr_80958_81000[(2)] = null);

(statearr_80958_81000[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80928 === (14))){
var inst_80921 = (state_80927[(2)]);
var state_80927__$1 = state_80927;
var statearr_80959_81001 = state_80927__$1;
(statearr_80959_81001[(2)] = inst_80921);

(statearr_80959_81001[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80928 === (10))){
var inst_80923 = (state_80927[(2)]);
var state_80927__$1 = state_80927;
var statearr_80960_81002 = state_80927__$1;
(statearr_80960_81002[(2)] = inst_80923);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80927__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80928 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_80927,(4),Error,(3),(2));
var state_80927__$1 = state_80927;
var statearr_80961_81003 = state_80927__$1;
(statearr_80961_81003[(2)] = null);

(statearr_80961_81003[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_80894,inst_80895,inst_80896,inst_80897,inst_80898,inst_80929,state_val_80936,c__38309__auto___80984,c__23767__auto___80982,id__23768__auto___80983))
;
return ((function (switch__38195__auto__,c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_80894,inst_80895,inst_80896,inst_80897,inst_80898,inst_80929,state_val_80936,c__38309__auto___80984,c__23767__auto___80982,id__23768__auto___80983){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_80965 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_80965[(0)] = superv$async$state_machine__38196__auto__);

(statearr_80965[(1)] = (1));

return statearr_80965;
});
var superv$async$state_machine__38196__auto____1 = (function (state_80927){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_80927);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e80966){if((e80966 instanceof Object)){
var ex__38199__auto__ = e80966;
var statearr_80967_81004 = state_80927;
(statearr_80967_81004[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80927);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80966;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81005 = state_80927;
state_80927 = G__81005;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_80927){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_80927);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_80894,inst_80895,inst_80896,inst_80897,inst_80898,inst_80929,state_val_80936,c__38309__auto___80984,c__23767__auto___80982,id__23768__auto___80983))
})();
var state__38311__auto__ = (function (){var statearr_80968 = f__38310__auto__.call(null);
(statearr_80968[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto____$1);

return statearr_80968;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});
;})(c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_80894,inst_80895,inst_80896,inst_80897,inst_80898,inst_80929,state_val_80936,c__38309__auto___80984,c__23767__auto___80982,id__23768__auto___80983))
})();
var inst_80931 = cljs.core.async.impl.dispatch.run.call(null,inst_80930);
var state_80935__$1 = (function (){var statearr_80969 = state_80935;
(statearr_80969[(11)] = inst_80931);

(statearr_80969[(12)] = inst_80894);

(statearr_80969[(13)] = inst_80895);

return statearr_80969;
})();
var statearr_80970_81006 = state_80935__$1;
(statearr_80970_81006[(2)] = inst_80929);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80935__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___80984,c__23767__auto___80982,id__23768__auto___80983))
;
return ((function (switch__38195__auto__,c__38309__auto___80984,c__23767__auto___80982,id__23768__auto___80983){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_80974 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80974[(0)] = superv$async$state_machine__38196__auto__);

(statearr_80974[(1)] = (1));

return statearr_80974;
});
var superv$async$state_machine__38196__auto____1 = (function (state_80935){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_80935);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e80975){if((e80975 instanceof Object)){
var ex__38199__auto__ = e80975;
var statearr_80976_81007 = state_80935;
(statearr_80976_81007[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80935);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80975;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81008 = state_80935;
state_80935 = G__81008;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_80935){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_80935);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___80984,c__23767__auto___80982,id__23768__auto___80983))
})();
var state__38311__auto__ = (function (){var statearr_80977 = f__38310__auto__.call(null);
(statearr_80977[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___80984);

return statearr_80977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___80984,c__23767__auto___80982,id__23768__auto___80983))
);


return cljs.core.async.sub.call(null,p,topic,ch,close_QMARK_);
});

superv.async.sub.cljs$lang$maxFixedArity = 5;

/**
 * Creates a supervised channel for transducer xform. Exceptions
 *   immediatly propagate to the supervisor.
 */
superv.async.chan_super = (function superv$async$chan_super(S,buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,(function (e){
return cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(S),e);
}));
});
/**
 * Starts a subsystem with supervised go-routines initialized by start-fn.
 *   Restarts the system on error for retries times with a potential delay in
 *   milliseconds, an optional error-fn predicate determining the retry and a
 *   optional filter by exception type. You can optionally pass a supervisor to
 *   form a supervision tree. Whenever this passed supervisor aborts the context,
 *   this supervisor will close as well. You still need to block on the result of
 *   this supervisor if you want a clean synchronized shutdown. The concept is
 *   similar to http://learnyousomeerlang.com/supervisors
 * 
 *   All blocking channel ops in the subroutines (supervised context) are
 *   aborted with an exception on error to force total termination. The
 *   supervisor waits until all supervised go-routines are finished and
 *   have freed resources before restarting.
 * 
 *   If exceptions are not taken from go-try channels (by error), they become stale
 *   after the stale-timeout and trigger a restart or are propagated to the parent
 *   supervisor (if available) and the return value.
 * 
 *   Note: The signature and behaviour of this function might still change.
 */
superv.async.restarting_supervisor = (function superv$async$restarting_supervisor(var_args){
var args__10647__auto__ = [];
var len__10640__auto___81316 = arguments.length;
var i__10641__auto___81317 = (0);
while(true){
if((i__10641__auto___81317 < len__10640__auto___81316)){
args__10647__auto__.push((arguments[i__10641__auto___81317]));

var G__81318 = (i__10641__auto___81317 + (1));
i__10641__auto___81317 = G__81318;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (start_fn,p__81023){
var map__81024 = p__81023;
var map__81024__$1 = ((((!((map__81024 == null)))?((((map__81024.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__81024.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__81024):map__81024);
var retries = cljs.core.get.call(null,map__81024__$1,new cljs.core.Keyword(null,"retries","retries",1888092808),Infinity);
var delay = cljs.core.get.call(null,map__81024__$1,new cljs.core.Keyword(null,"delay","delay",-574225219),(0));
var error_fn = cljs.core.get.call(null,map__81024__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),null);
var exception = cljs.core.get.call(null,map__81024__$1,new cljs.core.Keyword(null,"exception","exception",-335277064),Error);
var stale_timeout = cljs.core.get.call(null,map__81024__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((60) * (1000)));
var log_fn = cljs.core.get.call(null,map__81024__$1,new cljs.core.Keyword(null,"log-fn","log-fn",-2003241282),((function (map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout){
return (function (level,msg){
return cljs.core.println.call(null,level,msg);
});})(map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout))
);
var supervisor = cljs.core.get.call(null,map__81024__$1,new cljs.core.Keyword(null,"supervisor","supervisor",-134060208));
var retries__$1 = (function (){var or__9419__auto__ = retries;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return Infinity;
}
})();
var out_ch = cljs.core.async.chan.call(null);
var c__38309__auto___81319 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_81215){
var state_val_81216 = (state_81215[(1)]);
if((state_val_81216 === (7))){
var inst_81030 = (state_81215[(7)]);
var inst_81158 = (state_81215[(2)]);
var inst_81159 = cljs.core.nth.call(null,inst_81158,(0),null);
var inst_81160 = cljs.core.nth.call(null,inst_81158,(1),null);
var inst_81161 = cljs.core._EQ_.call(null,inst_81160,inst_81030);
var inst_81162 = !(inst_81161);
var state_81215__$1 = (function (){var statearr_81217 = state_81215;
(statearr_81217[(8)] = inst_81159);

return statearr_81217;
})();
if(inst_81162){
var statearr_81218_81320 = state_81215__$1;
(statearr_81218_81320[(1)] = (8));

} else {
var statearr_81219_81321 = state_81215__$1;
(statearr_81219_81321[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81216 === (20))){
var inst_81159 = (state_81215[(8)]);
var inst_81190 = (state_81215[(2)]);
var inst_81191 = cljs.core.async.put_BANG_.call(null,out_ch,inst_81159);
var inst_81192 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_81215__$1 = (function (){var statearr_81220 = state_81215;
(statearr_81220[(9)] = inst_81190);

(statearr_81220[(10)] = inst_81191);

return statearr_81220;
})();
var statearr_81221_81322 = state_81215__$1;
(statearr_81221_81322[(2)] = inst_81192);

(statearr_81221_81322[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81216 === (1))){
var inst_81026 = retries__$1;
var state_81215__$1 = (function (){var statearr_81222 = state_81215;
(statearr_81222[(11)] = inst_81026);

return statearr_81222;
})();
var statearr_81223_81323 = state_81215__$1;
(statearr_81223_81323[(2)] = null);

(statearr_81223_81323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81216 === (4))){
var inst_81028 = (state_81215[(12)]);
var inst_81038 = (state_81215[(13)]);
var inst_81029 = (state_81215[(14)]);
var inst_81039 = (state_81215[(15)]);
var inst_81030 = (state_81215[(7)]);
var inst_81026 = (state_81215[(11)]);
var inst_81041 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_81042 = cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"supervisor","supervisor",1506471319,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ab-ch","ab-ch",-698106711,null)));
var inst_81043 = superv.async._register_go.call(null,supervisor,inst_81042);
var inst_81068 = cljs.core.async.chan.call(null,(1));
var inst_81069 = (function (){var c__38309__auto____$1 = inst_81068;
var stale_timeout__$1 = (1000);
var c__23767__auto__ = inst_81041;
var id__23768__auto__ = inst_81043;
var err_ch = inst_81028;
var ab_ch = inst_81029;
var res_ch = inst_81039;
var close_ch = inst_81030;
var retries__$2 = inst_81026;
var s = inst_81038;
return ((function (c__38309__auto____$1,stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81041,inst_81042,inst_81043,inst_81068,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto____$1,stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81041,inst_81042,inst_81043,inst_81068,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_81066){
var state_val_81067 = (state_81066[(1)]);
if((state_val_81067 === (1))){
var state_81066__$1 = state_81066;
var statearr_81224_81324 = state_81066__$1;
(statearr_81224_81324[(2)] = null);

(statearr_81224_81324[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81067 === (2))){
var inst_81064 = (state_81066[(2)]);
var state_81066__$1 = state_81066;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81066__$1,inst_81064);
} else {
if((state_val_81067 === (3))){
var inst_81044 = (state_81066[(2)]);
var inst_81045 = superv.async._unregister_go.call(null,supervisor,id__23768__auto__);
var state_81066__$1 = (function (){var statearr_81225 = state_81066;
(statearr_81225[(7)] = inst_81045);

(statearr_81225[(8)] = inst_81044);

return statearr_81225;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81066__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81067 === (4))){
var inst_81047 = (state_81066[(9)]);
var inst_81047__$1 = (state_81066[(2)]);
var inst_81048 = cljs.core.ex_data.call(null,inst_81047__$1);
var inst_81049 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_81048);
var inst_81050 = cljs.core._EQ_.call(null,inst_81049,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_81066__$1 = (function (){var statearr_81226 = state_81066;
(statearr_81226[(9)] = inst_81047__$1);

return statearr_81226;
})();
if(inst_81050){
var statearr_81227_81325 = state_81066__$1;
(statearr_81227_81325[(1)] = (5));

} else {
var statearr_81228_81326 = state_81066__$1;
(statearr_81228_81326[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81067 === (5))){
var state_81066__$1 = state_81066;
var statearr_81229_81327 = state_81066__$1;
(statearr_81229_81327[(2)] = null);

(statearr_81229_81327[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81067 === (6))){
var inst_81047 = (state_81066[(9)]);
var inst_81053 = superv.async._track_exception.call(null,supervisor,inst_81047);
var state_81066__$1 = state_81066;
var statearr_81230_81328 = state_81066__$1;
(statearr_81230_81328[(2)] = inst_81053);

(statearr_81230_81328[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81067 === (7))){
var inst_81047 = (state_81066[(9)]);
var inst_81055 = (state_81066[(2)]);
var state_81066__$1 = (function (){var statearr_81231 = state_81066;
(statearr_81231[(10)] = inst_81055);

return statearr_81231;
})();
var statearr_81232_81329 = state_81066__$1;
(statearr_81232_81329[(2)] = inst_81047);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81066__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81067 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_81066,(4),Error,(3),(2));
var inst_81059 = superv.async._abort.call(null,supervisor);
var state_81066__$1 = state_81066;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81066__$1,(9),inst_81059);
} else {
if((state_val_81067 === (9))){
var inst_81061 = (state_81066[(2)]);
var inst_81062 = cljs.core.async.close_BANG_.call(null,ab_ch);
var state_81066__$1 = (function (){var statearr_81233 = state_81066;
(statearr_81233[(11)] = inst_81061);

return statearr_81233;
})();
var statearr_81234_81330 = state_81066__$1;
(statearr_81234_81330[(2)] = inst_81062);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81066__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__38309__auto____$1,stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81041,inst_81042,inst_81043,inst_81068,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__38195__auto__,c__38309__auto____$1,stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81041,inst_81042,inst_81043,inst_81068,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_81238 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81238[(0)] = superv$async$state_machine__38196__auto__);

(statearr_81238[(1)] = (1));

return statearr_81238;
});
var superv$async$state_machine__38196__auto____1 = (function (state_81066){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_81066);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e81239){if((e81239 instanceof Object)){
var ex__38199__auto__ = e81239;
var statearr_81240_81331 = state_81066;
(statearr_81240_81331[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81066);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81239;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81332 = state_81066;
state_81066 = G__81332;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_81066){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_81066);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto____$1,stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81041,inst_81042,inst_81043,inst_81068,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__38311__auto__ = (function (){var statearr_81241 = f__38310__auto__.call(null);
(statearr_81241[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto____$1);

return statearr_81241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});
;})(c__38309__auto____$1,stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81041,inst_81042,inst_81043,inst_81068,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_81070 = cljs.core.async.impl.dispatch.run.call(null,inst_81069);
var state_81215__$1 = (function (){var statearr_81242 = state_81215;
(statearr_81242[(16)] = inst_81070);

return statearr_81242;
})();
var statearr_81243_81333 = state_81215__$1;
(statearr_81243_81333[(2)] = inst_81068);

(statearr_81243_81333[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81216 === (15))){
var inst_81159 = (state_81215[(8)]);
var inst_81181 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81182 = [new cljs.core.Keyword(null,"passing-error","passing-error",-1357712542),inst_81159];
var inst_81183 = cljs.core.PersistentHashMap.fromArrays(inst_81181,inst_81182);
var inst_81184 = log_fn.call(null,new cljs.core.Keyword(null,"error","error",-978969032),inst_81183);
var state_81215__$1 = (function (){var statearr_81244 = state_81215;
(statearr_81244[(17)] = inst_81184);

return statearr_81244;
})();
if(cljs.core.truth_(supervisor)){
var statearr_81245_81334 = state_81215__$1;
(statearr_81245_81334[(1)] = (18));

} else {
var statearr_81246_81335 = state_81215__$1;
(statearr_81246_81335[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81216 === (21))){
var inst_81159 = (state_81215[(8)]);
var inst_81026 = (state_81215[(11)]);
var inst_81196 = (state_81215[(2)]);
var inst_81197 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"further-retries","further-retries",1297645153)];
var inst_81198 = [new cljs.core.Keyword(null,"retry","retry",-614012896),inst_81159,inst_81026];
var inst_81199 = cljs.core.PersistentHashMap.fromArrays(inst_81197,inst_81198);
var inst_81200 = log_fn.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),inst_81199);
var inst_81201 = (inst_81026 - (1));
var inst_81026__$1 = inst_81201;
var state_81215__$1 = (function (){var statearr_81247 = state_81215;
(statearr_81247[(18)] = inst_81200);

(statearr_81247[(11)] = inst_81026__$1);

(statearr_81247[(19)] = inst_81196);

return statearr_81247;
})();
var statearr_81248_81336 = state_81215__$1;
(statearr_81248_81336[(2)] = null);

(statearr_81248_81336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81216 === (13))){
var inst_81159 = (state_81215[(8)]);
var inst_81173 = error_fn.call(null,inst_81159);
var state_81215__$1 = state_81215;
var statearr_81249_81337 = state_81215__$1;
(statearr_81249_81337[(2)] = inst_81173);

(statearr_81249_81337[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81216 === (22))){
var inst_81207 = (state_81215[(2)]);
var inst_81208 = cljs.core.async.put_BANG_.call(null,out_ch,inst_81207);
var inst_81209 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_81215__$1 = (function (){var statearr_81250 = state_81215;
(statearr_81250[(20)] = inst_81208);

return statearr_81250;
})();
var statearr_81251_81338 = state_81215__$1;
(statearr_81251_81338[(2)] = inst_81209);

(statearr_81251_81338[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81216 === (6))){
var inst_81028 = (state_81215[(12)]);
var inst_81038 = (state_81215[(13)]);
var inst_81029 = (state_81215[(14)]);
var inst_81039 = (state_81215[(15)]);
var inst_81030 = (state_81215[(7)]);
var inst_81026 = (state_81215[(11)]);
var inst_81073 = (state_81215[(2)]);
var inst_81120 = cljs.core.async.chan.call(null,(1));
var inst_81121 = (function (){var retries__$2 = inst_81026;
var err_ch = inst_81028;
var ab_ch = inst_81029;
var close_ch = inst_81030;
var s = inst_81038;
var res_ch = inst_81039;
var stale_timeout__$1 = (1000);
var c__38309__auto____$1 = inst_81120;
return ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81073,inst_81120,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81073,inst_81120,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_81118){
var state_val_81119 = (state_81118[(1)]);
if((state_val_81119 === (7))){
var inst_81093 = (state_81118[(7)]);
var inst_81080 = (state_81118[(2)]);
var inst_81088 = (function (){return ((function (inst_81093,inst_81080,state_val_81119,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81073,inst_81120,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (p__81087){
var vec__81252 = p__81087;
var k = cljs.core.nth.call(null,vec__81252,(0),null);
var v = cljs.core.nth.call(null,vec__81252,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout__$1) > v.getTime());
});
;})(inst_81093,inst_81080,state_val_81119,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81073,inst_81120,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_81089 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_81090 = cljs.core.deref.call(null,inst_81089);
var inst_81091 = cljs.core.filter.call(null,inst_81088,inst_81090);
var inst_81092 = cljs.core.nth.call(null,inst_81091,(0),null);
var inst_81093__$1 = cljs.core.nth.call(null,inst_81092,(0),null);
var inst_81094 = cljs.core.nth.call(null,inst_81092,(1),null);
var state_81118__$1 = (function (){var statearr_81255 = state_81118;
(statearr_81255[(8)] = inst_81080);

(statearr_81255[(7)] = inst_81093__$1);

(statearr_81255[(9)] = inst_81094);

return statearr_81255;
})();
if(cljs.core.truth_(inst_81093__$1)){
var statearr_81256_81339 = state_81118__$1;
(statearr_81256_81339[(1)] = (8));

} else {
var statearr_81257_81340 = state_81118__$1;
(statearr_81257_81340[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81119 === (1))){
var state_81118__$1 = state_81118;
var statearr_81258_81341 = state_81118__$1;
(statearr_81258_81341[(2)] = null);

(statearr_81258_81341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81119 === (4))){
var state_81118__$1 = state_81118;
var statearr_81259_81342 = state_81118__$1;
(statearr_81259_81342[(2)] = null);

(statearr_81259_81342[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81119 === (13))){
var inst_81093 = (state_81118[(7)]);
var inst_81106 = (state_81118[(2)]);
var inst_81107 = superv.async._free_exception.call(null,s,inst_81093);
var inst_81108 = cljs.core.async.put_BANG_.call(null,err_ch,inst_81093);
var state_81118__$1 = (function (){var statearr_81260 = state_81118;
(statearr_81260[(10)] = inst_81107);

(statearr_81260[(11)] = inst_81106);

return statearr_81260;
})();
var statearr_81261_81343 = state_81118__$1;
(statearr_81261_81343[(2)] = inst_81108);

(statearr_81261_81343[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81119 === (6))){
var inst_81114 = (state_81118[(2)]);
var state_81118__$1 = state_81118;
var statearr_81262_81344 = state_81118__$1;
(statearr_81262_81344[(2)] = inst_81114);

(statearr_81262_81344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81119 === (3))){
var inst_81116 = (state_81118[(2)]);
var state_81118__$1 = state_81118;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81118__$1,inst_81116);
} else {
if((state_val_81119 === (12))){
var inst_81093 = (state_81118[(7)]);
var inst_81101 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81102 = [new cljs.core.Keyword(null,"stale-error-in-supervisor","stale-error-in-supervisor",-123257662),inst_81093];
var inst_81103 = cljs.core.PersistentHashMap.fromArrays(inst_81101,inst_81102);
var inst_81104 = log_fn.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_81103);
var state_81118__$1 = state_81118;
var statearr_81263_81345 = state_81118__$1;
(statearr_81263_81345[(2)] = inst_81104);

(statearr_81263_81345[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81119 === (2))){
var inst_81075 = cljs.core.async.poll_BANG_.call(null,ab_ch);
var state_81118__$1 = state_81118;
if(cljs.core.truth_(inst_81075)){
var statearr_81264_81346 = state_81118__$1;
(statearr_81264_81346[(1)] = (4));

} else {
var statearr_81265_81347 = state_81118__$1;
(statearr_81265_81347[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81119 === (11))){
var state_81118__$1 = state_81118;
var statearr_81266_81348 = state_81118__$1;
(statearr_81266_81348[(2)] = null);

(statearr_81266_81348[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81119 === (9))){
var state_81118__$1 = state_81118;
var statearr_81267_81349 = state_81118__$1;
(statearr_81267_81349[(2)] = null);

(statearr_81267_81349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81119 === (5))){
var inst_81078 = cljs.core.async.timeout.call(null,stale_timeout__$1);
var state_81118__$1 = state_81118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81118__$1,(7),inst_81078);
} else {
if((state_val_81119 === (10))){
var inst_81112 = (state_81118[(2)]);
var state_81118__$1 = state_81118;
var statearr_81268_81350 = state_81118__$1;
(statearr_81268_81350[(2)] = inst_81112);

(statearr_81268_81350[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81119 === (8))){
var inst_81093 = (state_81118[(7)]);
var inst_81096 = cljs.core.ex_data.call(null,inst_81093);
var inst_81097 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_81096);
var inst_81098 = cljs.core._EQ_.call(null,inst_81097,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_81118__$1 = state_81118;
if(inst_81098){
var statearr_81269_81351 = state_81118__$1;
(statearr_81269_81351[(1)] = (11));

} else {
var statearr_81270_81352 = state_81118__$1;
(statearr_81270_81352[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81073,inst_81120,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__38195__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81073,inst_81120,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_81274 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81274[(0)] = superv$async$state_machine__38196__auto__);

(statearr_81274[(1)] = (1));

return statearr_81274;
});
var superv$async$state_machine__38196__auto____1 = (function (state_81118){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_81118);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e81275){if((e81275 instanceof Object)){
var ex__38199__auto__ = e81275;
var statearr_81276_81353 = state_81118;
(statearr_81276_81353[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81118);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81275;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81354 = state_81118;
state_81118 = G__81354;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_81118){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_81118);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81073,inst_81120,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__38311__auto__ = (function (){var statearr_81277 = f__38310__auto__.call(null);
(statearr_81277[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto____$1);

return statearr_81277;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});
;})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81073,inst_81120,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_81122 = cljs.core.async.impl.dispatch.run.call(null,inst_81121);
var inst_81148 = cljs.core.async.chan.call(null,(1));
var inst_81149 = (function (){var retries__$2 = inst_81026;
var err_ch = inst_81028;
var ab_ch = inst_81029;
var close_ch = inst_81030;
var s = inst_81038;
var res_ch = inst_81039;
var stale_timeout__$1 = (1000);
var c__38309__auto____$1 = inst_81148;
return ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81073,inst_81120,inst_81121,inst_81122,inst_81148,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81073,inst_81120,inst_81121,inst_81122,inst_81148,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_81146){
var state_val_81147 = (state_81146[(1)]);
if((state_val_81147 === (1))){
var inst_81123 = (0);
var state_81146__$1 = (function (){var statearr_81278 = state_81146;
(statearr_81278[(7)] = inst_81123);

return statearr_81278;
})();
var statearr_81279_81355 = state_81146__$1;
(statearr_81279_81355[(2)] = null);

(statearr_81279_81355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81147 === (2))){
var inst_81125 = new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(s);
var inst_81126 = cljs.core.deref.call(null,inst_81125);
var inst_81127 = cljs.core.empty_QMARK_.call(null,inst_81126);
var inst_81128 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_81129 = cljs.core.deref.call(null,inst_81128);
var inst_81130 = cljs.core.empty_QMARK_.call(null,inst_81129);
var inst_81131 = (inst_81127) && (inst_81130);
var inst_81132 = cljs.core.not.call(null,inst_81131);
var state_81146__$1 = state_81146;
if(inst_81132){
var statearr_81280_81356 = state_81146__$1;
(statearr_81280_81356[(1)] = (4));

} else {
var statearr_81281_81357 = state_81146__$1;
(statearr_81281_81357[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81147 === (3))){
var inst_81144 = (state_81146[(2)]);
var state_81146__$1 = state_81146;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81146__$1,inst_81144);
} else {
if((state_val_81147 === (4))){
var inst_81134 = cljs.core.async.timeout.call(null,(100));
var state_81146__$1 = state_81146;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81146__$1,(7),inst_81134);
} else {
if((state_val_81147 === (5))){
var inst_81140 = cljs.core.async.close_BANG_.call(null,close_ch);
var state_81146__$1 = state_81146;
var statearr_81282_81358 = state_81146__$1;
(statearr_81282_81358[(2)] = inst_81140);

(statearr_81282_81358[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81147 === (6))){
var inst_81142 = (state_81146[(2)]);
var state_81146__$1 = state_81146;
var statearr_81283_81359 = state_81146__$1;
(statearr_81283_81359[(2)] = inst_81142);

(statearr_81283_81359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81147 === (7))){
var inst_81123 = (state_81146[(7)]);
var inst_81136 = (state_81146[(2)]);
var inst_81137 = (inst_81123 + (1));
var inst_81123__$1 = inst_81137;
var state_81146__$1 = (function (){var statearr_81284 = state_81146;
(statearr_81284[(7)] = inst_81123__$1);

(statearr_81284[(8)] = inst_81136);

return statearr_81284;
})();
var statearr_81285_81360 = state_81146__$1;
(statearr_81285_81360[(2)] = null);

(statearr_81285_81360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81073,inst_81120,inst_81121,inst_81122,inst_81148,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__38195__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81073,inst_81120,inst_81121,inst_81122,inst_81148,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_81289 = [null,null,null,null,null,null,null,null,null];
(statearr_81289[(0)] = superv$async$state_machine__38196__auto__);

(statearr_81289[(1)] = (1));

return statearr_81289;
});
var superv$async$state_machine__38196__auto____1 = (function (state_81146){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_81146);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e81290){if((e81290 instanceof Object)){
var ex__38199__auto__ = e81290;
var statearr_81291_81361 = state_81146;
(statearr_81291_81361[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81146);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81290;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81362 = state_81146;
state_81146 = G__81362;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_81146){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_81146);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81073,inst_81120,inst_81121,inst_81122,inst_81148,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__38311__auto__ = (function (){var statearr_81292 = f__38310__auto__.call(null);
(statearr_81292[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto____$1);

return statearr_81292;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});
;})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_81028,inst_81038,inst_81029,inst_81039,inst_81030,inst_81026,inst_81073,inst_81120,inst_81121,inst_81122,inst_81148,state_val_81216,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_81150 = cljs.core.async.impl.dispatch.run.call(null,inst_81149);
var inst_81154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81155 = [inst_81028,inst_81030];
var inst_81156 = (new cljs.core.PersistentVector(null,2,(5),inst_81154,inst_81155,null));
var state_81215__$1 = (function (){var statearr_81293 = state_81215;
(statearr_81293[(21)] = inst_81150);

(statearr_81293[(22)] = inst_81073);

(statearr_81293[(23)] = inst_81122);

return statearr_81293;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_81215__$1,(7),inst_81156,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_81216 === (17))){
var inst_81204 = (state_81215[(2)]);
var state_81215__$1 = state_81215;
var statearr_81294_81363 = state_81215__$1;
(statearr_81294_81363[(2)] = inst_81204);

(statearr_81294_81363[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81216 === (3))){
var inst_81213 = (state_81215[(2)]);
var state_81215__$1 = state_81215;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81215__$1,inst_81213);
} else {
if((state_val_81216 === (12))){
var inst_81170 = (state_81215[(24)]);
var state_81215__$1 = state_81215;
var statearr_81295_81364 = state_81215__$1;
(statearr_81295_81364[(2)] = inst_81170);

(statearr_81295_81364[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81216 === (2))){
var inst_81028 = (state_81215[(12)]);
var inst_81038 = (state_81215[(13)]);
var inst_81029 = (state_81215[(14)]);
var inst_81028__$1 = cljs.core.async.chan.call(null);
var inst_81029__$1 = cljs.core.async.chan.call(null);
var inst_81030 = cljs.core.async.chan.call(null);
var inst_81031 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),new cljs.core.Keyword(null,"restarting","restarting",760677572)];
var inst_81032 = cljs.core.PersistentHashMap.EMPTY;
var inst_81033 = cljs.core.atom.call(null,inst_81032);
var inst_81034 = cljs.core.PersistentHashMap.EMPTY;
var inst_81035 = cljs.core.atom.call(null,inst_81034);
var inst_81036 = [inst_81028__$1,inst_81029__$1,inst_81033,inst_81035,true];
var inst_81037 = cljs.core.PersistentHashMap.fromArrays(inst_81031,inst_81036);
var inst_81038__$1 = superv.async.map__GT_TrackingSupervisor.call(null,inst_81037);
var inst_81039 = start_fn.call(null,inst_81038__$1);
var state_81215__$1 = (function (){var statearr_81296 = state_81215;
(statearr_81296[(12)] = inst_81028__$1);

(statearr_81296[(13)] = inst_81038__$1);

(statearr_81296[(14)] = inst_81029__$1);

(statearr_81296[(15)] = inst_81039);

(statearr_81296[(7)] = inst_81030);

return statearr_81296;
})();
if(cljs.core.truth_(supervisor)){
var statearr_81297_81365 = state_81215__$1;
(statearr_81297_81365[(1)] = (4));

} else {
var statearr_81298_81366 = state_81215__$1;
(statearr_81298_81366[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81216 === (19))){
var state_81215__$1 = state_81215;
var statearr_81299_81367 = state_81215__$1;
(statearr_81299_81367[(2)] = null);

(statearr_81299_81367[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81216 === (11))){
var inst_81159 = (state_81215[(8)]);
var inst_81170 = (state_81215[(24)]);
var inst_81167 = (state_81215[(2)]);
var inst_81168 = (inst_81159 instanceof exception);
var inst_81169 = cljs.core.not.call(null,inst_81168);
var inst_81170__$1 = cljs.core.not.call(null,error_fn);
var state_81215__$1 = (function (){var statearr_81300 = state_81215;
(statearr_81300[(25)] = inst_81169);

(statearr_81300[(26)] = inst_81167);

(statearr_81300[(24)] = inst_81170__$1);

return statearr_81300;
})();
if(inst_81170__$1){
var statearr_81301_81368 = state_81215__$1;
(statearr_81301_81368[(1)] = (12));

} else {
var statearr_81302_81369 = state_81215__$1;
(statearr_81302_81369[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81216 === (9))){
var inst_81039 = (state_81215[(15)]);
var state_81215__$1 = state_81215;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81215__$1,(22),inst_81039);
} else {
if((state_val_81216 === (5))){
var state_81215__$1 = state_81215;
var statearr_81303_81370 = state_81215__$1;
(statearr_81303_81370[(2)] = null);

(statearr_81303_81370[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81216 === (14))){
var inst_81026 = (state_81215[(11)]);
var inst_81169 = (state_81215[(25)]);
var inst_81175 = (state_81215[(2)]);
var inst_81176 = cljs.core.not.call(null,inst_81175);
var inst_81177 = (inst_81026 > (0));
var inst_81178 = cljs.core.not.call(null,inst_81177);
var inst_81179 = (inst_81169) || (inst_81176) || (inst_81178);
var state_81215__$1 = state_81215;
if(cljs.core.truth_(inst_81179)){
var statearr_81304_81371 = state_81215__$1;
(statearr_81304_81371[(1)] = (15));

} else {
var statearr_81305_81372 = state_81215__$1;
(statearr_81305_81372[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81216 === (16))){
var inst_81194 = cljs.core.async.timeout.call(null,delay);
var state_81215__$1 = state_81215;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81215__$1,(21),inst_81194);
} else {
if((state_val_81216 === (10))){
var inst_81211 = (state_81215[(2)]);
var state_81215__$1 = state_81215;
var statearr_81306_81373 = state_81215__$1;
(statearr_81306_81373[(2)] = inst_81211);

(statearr_81306_81373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81216 === (18))){
var inst_81159 = (state_81215[(8)]);
var inst_81186 = superv.async._error.call(null,supervisor);
var inst_81187 = cljs.core.async.put_BANG_.call(null,inst_81186,inst_81159);
var state_81215__$1 = state_81215;
var statearr_81307_81374 = state_81215__$1;
(statearr_81307_81374[(2)] = inst_81187);

(statearr_81307_81374[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81216 === (8))){
var inst_81028 = (state_81215[(12)]);
var inst_81029 = (state_81215[(14)]);
var inst_81030 = (state_81215[(7)]);
var inst_81164 = cljs.core.async.close_BANG_.call(null,inst_81028);
var inst_81165 = cljs.core.async.close_BANG_.call(null,inst_81029);
var state_81215__$1 = (function (){var statearr_81308 = state_81215;
(statearr_81308[(27)] = inst_81164);

(statearr_81308[(28)] = inst_81165);

return statearr_81308;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81215__$1,(11),inst_81030);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__38195__auto__,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_81312 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81312[(0)] = superv$async$state_machine__38196__auto__);

(statearr_81312[(1)] = (1));

return statearr_81312;
});
var superv$async$state_machine__38196__auto____1 = (function (state_81215){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_81215);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e81313){if((e81313 instanceof Object)){
var ex__38199__auto__ = e81313;
var statearr_81314_81375 = state_81215;
(statearr_81314_81375[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81215);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81313;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81376 = state_81215;
state_81215 = G__81376;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_81215){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_81215);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__38311__auto__ = (function (){var statearr_81315 = f__38310__auto__.call(null);
(statearr_81315[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___81319);

return statearr_81315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___81319,retries__$1,out_ch,map__81024,map__81024__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
);


return out_ch;
});

superv.async.restarting_supervisor.cljs$lang$maxFixedArity = (1);

superv.async.restarting_supervisor.cljs$lang$applyTo = (function (seq81021){
var G__81022 = cljs.core.first.call(null,seq81021);
var seq81021__$1 = cljs.core.next.call(null,seq81021);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic(G__81022,seq81021__$1);
});


//# sourceMappingURL=async.js.map