// Compiled by ClojureScript 1.9.521 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args57937 = [];
var len__10640__auto___57943 = arguments.length;
var i__10641__auto___57944 = (0);
while(true){
if((i__10641__auto___57944 < len__10640__auto___57943)){
args57937.push((arguments[i__10641__auto___57944]));

var G__57945 = (i__10641__auto___57944 + (1));
i__10641__auto___57944 = G__57945;
continue;
} else {
}
break;
}

var G__57939 = args57937.length;
switch (G__57939) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57937.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async57940 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async57940 = (function (f,blockable,meta57941){
this.f = f;
this.blockable = blockable;
this.meta57941 = meta57941;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async57940.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57942,meta57941__$1){
var self__ = this;
var _57942__$1 = this;
return (new cljs.core.async.t_cljs$core$async57940(self__.f,self__.blockable,meta57941__$1));
});

cljs.core.async.t_cljs$core$async57940.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57942){
var self__ = this;
var _57942__$1 = this;
return self__.meta57941;
});

cljs.core.async.t_cljs$core$async57940.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async57940.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async57940.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async57940.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async57940.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta57941","meta57941",453368645,null)], null);
});

cljs.core.async.t_cljs$core$async57940.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async57940.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async57940";

cljs.core.async.t_cljs$core$async57940.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async57940");
});

cljs.core.async.__GT_t_cljs$core$async57940 = (function cljs$core$async$__GT_t_cljs$core$async57940(f__$1,blockable__$1,meta57941){
return (new cljs.core.async.t_cljs$core$async57940(f__$1,blockable__$1,meta57941));
});

}

return (new cljs.core.async.t_cljs$core$async57940(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args57949 = [];
var len__10640__auto___57952 = arguments.length;
var i__10641__auto___57953 = (0);
while(true){
if((i__10641__auto___57953 < len__10640__auto___57952)){
args57949.push((arguments[i__10641__auto___57953]));

var G__57954 = (i__10641__auto___57953 + (1));
i__10641__auto___57953 = G__57954;
continue;
} else {
}
break;
}

var G__57951 = args57949.length;
switch (G__57951) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57949.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args57956 = [];
var len__10640__auto___57959 = arguments.length;
var i__10641__auto___57960 = (0);
while(true){
if((i__10641__auto___57960 < len__10640__auto___57959)){
args57956.push((arguments[i__10641__auto___57960]));

var G__57961 = (i__10641__auto___57960 + (1));
i__10641__auto___57960 = G__57961;
continue;
} else {
}
break;
}

var G__57958 = args57956.length;
switch (G__57958) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57956.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args57963 = [];
var len__10640__auto___57966 = arguments.length;
var i__10641__auto___57967 = (0);
while(true){
if((i__10641__auto___57967 < len__10640__auto___57966)){
args57963.push((arguments[i__10641__auto___57967]));

var G__57968 = (i__10641__auto___57967 + (1));
i__10641__auto___57967 = G__57968;
continue;
} else {
}
break;
}

var G__57965 = args57963.length;
switch (G__57965) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57963.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_57970 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_57970);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_57970,ret){
return (function (){
return fn1.call(null,val_57970);
});})(val_57970,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args57971 = [];
var len__10640__auto___57974 = arguments.length;
var i__10641__auto___57975 = (0);
while(true){
if((i__10641__auto___57975 < len__10640__auto___57974)){
args57971.push((arguments[i__10641__auto___57975]));

var G__57976 = (i__10641__auto___57975 + (1));
i__10641__auto___57975 = G__57976;
continue;
} else {
}
break;
}

var G__57973 = args57971.length;
switch (G__57973) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57971.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6736__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6736__auto__)){
var ret = temp__6736__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6736__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6736__auto__)){
var retb = temp__6736__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6736__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6736__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__10440__auto___57978 = n;
var x_57979 = (0);
while(true){
if((x_57979 < n__10440__auto___57978)){
(a[x_57979] = (0));

var G__57980 = (x_57979 + (1));
x_57979 = G__57980;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__57981 = (i + (1));
i = G__57981;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async57985 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async57985 = (function (flag,meta57986){
this.flag = flag;
this.meta57986 = meta57986;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async57985.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_57987,meta57986__$1){
var self__ = this;
var _57987__$1 = this;
return (new cljs.core.async.t_cljs$core$async57985(self__.flag,meta57986__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async57985.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_57987){
var self__ = this;
var _57987__$1 = this;
return self__.meta57986;
});})(flag))
;

cljs.core.async.t_cljs$core$async57985.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async57985.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async57985.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async57985.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async57985.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta57986","meta57986",1444545600,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async57985.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async57985.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async57985";

cljs.core.async.t_cljs$core$async57985.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async57985");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async57985 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async57985(flag__$1,meta57986){
return (new cljs.core.async.t_cljs$core$async57985(flag__$1,meta57986));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async57985(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async57991 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async57991 = (function (flag,cb,meta57992){
this.flag = flag;
this.cb = cb;
this.meta57992 = meta57992;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async57991.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57993,meta57992__$1){
var self__ = this;
var _57993__$1 = this;
return (new cljs.core.async.t_cljs$core$async57991(self__.flag,self__.cb,meta57992__$1));
});

cljs.core.async.t_cljs$core$async57991.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57993){
var self__ = this;
var _57993__$1 = this;
return self__.meta57992;
});

cljs.core.async.t_cljs$core$async57991.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async57991.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async57991.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async57991.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async57991.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta57992","meta57992",-1427426920,null)], null);
});

cljs.core.async.t_cljs$core$async57991.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async57991.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async57991";

cljs.core.async.t_cljs$core$async57991.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async57991");
});

cljs.core.async.__GT_t_cljs$core$async57991 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async57991(flag__$1,cb__$1,meta57992){
return (new cljs.core.async.t_cljs$core$async57991(flag__$1,cb__$1,meta57992));
});

}

return (new cljs.core.async.t_cljs$core$async57991(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__57994_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__57994_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__57995_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__57995_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__9419__auto__ = wport;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return port;
}
})()], null));
} else {
var G__57996 = (i + (1));
i = G__57996;
continue;
}
} else {
return null;
}
break;
}
})();
var or__9419__auto__ = ret;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6738__auto__ = (function (){var and__9407__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__9407__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__9407__auto__;
}
})();
if(cljs.core.truth_(temp__6738__auto__)){
var got = temp__6738__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___58002 = arguments.length;
var i__10641__auto___58003 = (0);
while(true){
if((i__10641__auto___58003 < len__10640__auto___58002)){
args__10647__auto__.push((arguments[i__10641__auto___58003]));

var G__58004 = (i__10641__auto___58003 + (1));
i__10641__auto___58003 = G__58004;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__57999){
var map__58000 = p__57999;
var map__58000__$1 = ((((!((map__58000 == null)))?((((map__58000.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58000.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58000):map__58000);
var opts = map__58000__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq57997){
var G__57998 = cljs.core.first.call(null,seq57997);
var seq57997__$1 = cljs.core.next.call(null,seq57997);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__57998,seq57997__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args58005 = [];
var len__10640__auto___58055 = arguments.length;
var i__10641__auto___58056 = (0);
while(true){
if((i__10641__auto___58056 < len__10640__auto___58055)){
args58005.push((arguments[i__10641__auto___58056]));

var G__58057 = (i__10641__auto___58056 + (1));
i__10641__auto___58056 = G__58057;
continue;
} else {
}
break;
}

var G__58007 = args58005.length;
switch (G__58007) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args58005.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__38309__auto___58059 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___58059){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___58059){
return (function (state_58031){
var state_val_58032 = (state_58031[(1)]);
if((state_val_58032 === (7))){
var inst_58027 = (state_58031[(2)]);
var state_58031__$1 = state_58031;
var statearr_58033_58060 = state_58031__$1;
(statearr_58033_58060[(2)] = inst_58027);

(statearr_58033_58060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58032 === (1))){
var state_58031__$1 = state_58031;
var statearr_58034_58061 = state_58031__$1;
(statearr_58034_58061[(2)] = null);

(statearr_58034_58061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58032 === (4))){
var inst_58010 = (state_58031[(7)]);
var inst_58010__$1 = (state_58031[(2)]);
var inst_58011 = (inst_58010__$1 == null);
var state_58031__$1 = (function (){var statearr_58035 = state_58031;
(statearr_58035[(7)] = inst_58010__$1);

return statearr_58035;
})();
if(cljs.core.truth_(inst_58011)){
var statearr_58036_58062 = state_58031__$1;
(statearr_58036_58062[(1)] = (5));

} else {
var statearr_58037_58063 = state_58031__$1;
(statearr_58037_58063[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58032 === (13))){
var state_58031__$1 = state_58031;
var statearr_58038_58064 = state_58031__$1;
(statearr_58038_58064[(2)] = null);

(statearr_58038_58064[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58032 === (6))){
var inst_58010 = (state_58031[(7)]);
var state_58031__$1 = state_58031;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58031__$1,(11),to,inst_58010);
} else {
if((state_val_58032 === (3))){
var inst_58029 = (state_58031[(2)]);
var state_58031__$1 = state_58031;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58031__$1,inst_58029);
} else {
if((state_val_58032 === (12))){
var state_58031__$1 = state_58031;
var statearr_58039_58065 = state_58031__$1;
(statearr_58039_58065[(2)] = null);

(statearr_58039_58065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58032 === (2))){
var state_58031__$1 = state_58031;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58031__$1,(4),from);
} else {
if((state_val_58032 === (11))){
var inst_58020 = (state_58031[(2)]);
var state_58031__$1 = state_58031;
if(cljs.core.truth_(inst_58020)){
var statearr_58040_58066 = state_58031__$1;
(statearr_58040_58066[(1)] = (12));

} else {
var statearr_58041_58067 = state_58031__$1;
(statearr_58041_58067[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58032 === (9))){
var state_58031__$1 = state_58031;
var statearr_58042_58068 = state_58031__$1;
(statearr_58042_58068[(2)] = null);

(statearr_58042_58068[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58032 === (5))){
var state_58031__$1 = state_58031;
if(cljs.core.truth_(close_QMARK_)){
var statearr_58043_58069 = state_58031__$1;
(statearr_58043_58069[(1)] = (8));

} else {
var statearr_58044_58070 = state_58031__$1;
(statearr_58044_58070[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58032 === (14))){
var inst_58025 = (state_58031[(2)]);
var state_58031__$1 = state_58031;
var statearr_58045_58071 = state_58031__$1;
(statearr_58045_58071[(2)] = inst_58025);

(statearr_58045_58071[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58032 === (10))){
var inst_58017 = (state_58031[(2)]);
var state_58031__$1 = state_58031;
var statearr_58046_58072 = state_58031__$1;
(statearr_58046_58072[(2)] = inst_58017);

(statearr_58046_58072[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58032 === (8))){
var inst_58014 = cljs.core.async.close_BANG_.call(null,to);
var state_58031__$1 = state_58031;
var statearr_58047_58073 = state_58031__$1;
(statearr_58047_58073[(2)] = inst_58014);

(statearr_58047_58073[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___58059))
;
return ((function (switch__38195__auto__,c__38309__auto___58059){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_58051 = [null,null,null,null,null,null,null,null];
(statearr_58051[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_58051[(1)] = (1));

return statearr_58051;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_58031){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_58031);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e58052){if((e58052 instanceof Object)){
var ex__38199__auto__ = e58052;
var statearr_58053_58074 = state_58031;
(statearr_58053_58074[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58031);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58052;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58075 = state_58031;
state_58031 = G__58075;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_58031){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_58031);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___58059))
})();
var state__38311__auto__ = (function (){var statearr_58054 = f__38310__auto__.call(null);
(statearr_58054[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___58059);

return statearr_58054;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___58059))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__58263){
var vec__58264 = p__58263;
var v = cljs.core.nth.call(null,vec__58264,(0),null);
var p = cljs.core.nth.call(null,vec__58264,(1),null);
var job = vec__58264;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__38309__auto___58450 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___58450,res,vec__58264,v,p,job,jobs,results){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___58450,res,vec__58264,v,p,job,jobs,results){
return (function (state_58271){
var state_val_58272 = (state_58271[(1)]);
if((state_val_58272 === (1))){
var state_58271__$1 = state_58271;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58271__$1,(2),res,v);
} else {
if((state_val_58272 === (2))){
var inst_58268 = (state_58271[(2)]);
var inst_58269 = cljs.core.async.close_BANG_.call(null,res);
var state_58271__$1 = (function (){var statearr_58273 = state_58271;
(statearr_58273[(7)] = inst_58268);

return statearr_58273;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58271__$1,inst_58269);
} else {
return null;
}
}
});})(c__38309__auto___58450,res,vec__58264,v,p,job,jobs,results))
;
return ((function (switch__38195__auto__,c__38309__auto___58450,res,vec__58264,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0 = (function (){
var statearr_58277 = [null,null,null,null,null,null,null,null];
(statearr_58277[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__);

(statearr_58277[(1)] = (1));

return statearr_58277;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1 = (function (state_58271){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_58271);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e58278){if((e58278 instanceof Object)){
var ex__38199__auto__ = e58278;
var statearr_58279_58451 = state_58271;
(statearr_58279_58451[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58271);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58278;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58452 = state_58271;
state_58271 = G__58452;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = function(state_58271){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1.call(this,state_58271);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___58450,res,vec__58264,v,p,job,jobs,results))
})();
var state__38311__auto__ = (function (){var statearr_58280 = f__38310__auto__.call(null);
(statearr_58280[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___58450);

return statearr_58280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___58450,res,vec__58264,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__58281){
var vec__58282 = p__58281;
var v = cljs.core.nth.call(null,vec__58282,(0),null);
var p = cljs.core.nth.call(null,vec__58282,(1),null);
var job = vec__58282;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__10440__auto___58453 = n;
var __58454 = (0);
while(true){
if((__58454 < n__10440__auto___58453)){
var G__58285_58455 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__58285_58455) {
case "compute":
var c__38309__auto___58457 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__58454,c__38309__auto___58457,G__58285_58455,n__10440__auto___58453,jobs,results,process,async){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (__58454,c__38309__auto___58457,G__58285_58455,n__10440__auto___58453,jobs,results,process,async){
return (function (state_58298){
var state_val_58299 = (state_58298[(1)]);
if((state_val_58299 === (1))){
var state_58298__$1 = state_58298;
var statearr_58300_58458 = state_58298__$1;
(statearr_58300_58458[(2)] = null);

(statearr_58300_58458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58299 === (2))){
var state_58298__$1 = state_58298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58298__$1,(4),jobs);
} else {
if((state_val_58299 === (3))){
var inst_58296 = (state_58298[(2)]);
var state_58298__$1 = state_58298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58298__$1,inst_58296);
} else {
if((state_val_58299 === (4))){
var inst_58288 = (state_58298[(2)]);
var inst_58289 = process.call(null,inst_58288);
var state_58298__$1 = state_58298;
if(cljs.core.truth_(inst_58289)){
var statearr_58301_58459 = state_58298__$1;
(statearr_58301_58459[(1)] = (5));

} else {
var statearr_58302_58460 = state_58298__$1;
(statearr_58302_58460[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58299 === (5))){
var state_58298__$1 = state_58298;
var statearr_58303_58461 = state_58298__$1;
(statearr_58303_58461[(2)] = null);

(statearr_58303_58461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58299 === (6))){
var state_58298__$1 = state_58298;
var statearr_58304_58462 = state_58298__$1;
(statearr_58304_58462[(2)] = null);

(statearr_58304_58462[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58299 === (7))){
var inst_58294 = (state_58298[(2)]);
var state_58298__$1 = state_58298;
var statearr_58305_58463 = state_58298__$1;
(statearr_58305_58463[(2)] = inst_58294);

(statearr_58305_58463[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__58454,c__38309__auto___58457,G__58285_58455,n__10440__auto___58453,jobs,results,process,async))
;
return ((function (__58454,switch__38195__auto__,c__38309__auto___58457,G__58285_58455,n__10440__auto___58453,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0 = (function (){
var statearr_58309 = [null,null,null,null,null,null,null];
(statearr_58309[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__);

(statearr_58309[(1)] = (1));

return statearr_58309;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1 = (function (state_58298){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_58298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e58310){if((e58310 instanceof Object)){
var ex__38199__auto__ = e58310;
var statearr_58311_58464 = state_58298;
(statearr_58311_58464[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58298);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58310;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58465 = state_58298;
state_58298 = G__58465;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = function(state_58298){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1.call(this,state_58298);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__;
})()
;})(__58454,switch__38195__auto__,c__38309__auto___58457,G__58285_58455,n__10440__auto___58453,jobs,results,process,async))
})();
var state__38311__auto__ = (function (){var statearr_58312 = f__38310__auto__.call(null);
(statearr_58312[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___58457);

return statearr_58312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(__58454,c__38309__auto___58457,G__58285_58455,n__10440__auto___58453,jobs,results,process,async))
);


break;
case "async":
var c__38309__auto___58466 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__58454,c__38309__auto___58466,G__58285_58455,n__10440__auto___58453,jobs,results,process,async){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (__58454,c__38309__auto___58466,G__58285_58455,n__10440__auto___58453,jobs,results,process,async){
return (function (state_58325){
var state_val_58326 = (state_58325[(1)]);
if((state_val_58326 === (1))){
var state_58325__$1 = state_58325;
var statearr_58327_58467 = state_58325__$1;
(statearr_58327_58467[(2)] = null);

(statearr_58327_58467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58326 === (2))){
var state_58325__$1 = state_58325;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58325__$1,(4),jobs);
} else {
if((state_val_58326 === (3))){
var inst_58323 = (state_58325[(2)]);
var state_58325__$1 = state_58325;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58325__$1,inst_58323);
} else {
if((state_val_58326 === (4))){
var inst_58315 = (state_58325[(2)]);
var inst_58316 = async.call(null,inst_58315);
var state_58325__$1 = state_58325;
if(cljs.core.truth_(inst_58316)){
var statearr_58328_58468 = state_58325__$1;
(statearr_58328_58468[(1)] = (5));

} else {
var statearr_58329_58469 = state_58325__$1;
(statearr_58329_58469[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58326 === (5))){
var state_58325__$1 = state_58325;
var statearr_58330_58470 = state_58325__$1;
(statearr_58330_58470[(2)] = null);

(statearr_58330_58470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58326 === (6))){
var state_58325__$1 = state_58325;
var statearr_58331_58471 = state_58325__$1;
(statearr_58331_58471[(2)] = null);

(statearr_58331_58471[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58326 === (7))){
var inst_58321 = (state_58325[(2)]);
var state_58325__$1 = state_58325;
var statearr_58332_58472 = state_58325__$1;
(statearr_58332_58472[(2)] = inst_58321);

(statearr_58332_58472[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__58454,c__38309__auto___58466,G__58285_58455,n__10440__auto___58453,jobs,results,process,async))
;
return ((function (__58454,switch__38195__auto__,c__38309__auto___58466,G__58285_58455,n__10440__auto___58453,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0 = (function (){
var statearr_58336 = [null,null,null,null,null,null,null];
(statearr_58336[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__);

(statearr_58336[(1)] = (1));

return statearr_58336;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1 = (function (state_58325){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_58325);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e58337){if((e58337 instanceof Object)){
var ex__38199__auto__ = e58337;
var statearr_58338_58473 = state_58325;
(statearr_58338_58473[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58325);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58337;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58474 = state_58325;
state_58325 = G__58474;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = function(state_58325){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1.call(this,state_58325);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__;
})()
;})(__58454,switch__38195__auto__,c__38309__auto___58466,G__58285_58455,n__10440__auto___58453,jobs,results,process,async))
})();
var state__38311__auto__ = (function (){var statearr_58339 = f__38310__auto__.call(null);
(statearr_58339[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___58466);

return statearr_58339;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(__58454,c__38309__auto___58466,G__58285_58455,n__10440__auto___58453,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__58475 = (__58454 + (1));
__58454 = G__58475;
continue;
} else {
}
break;
}

var c__38309__auto___58476 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___58476,jobs,results,process,async){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___58476,jobs,results,process,async){
return (function (state_58361){
var state_val_58362 = (state_58361[(1)]);
if((state_val_58362 === (1))){
var state_58361__$1 = state_58361;
var statearr_58363_58477 = state_58361__$1;
(statearr_58363_58477[(2)] = null);

(statearr_58363_58477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58362 === (2))){
var state_58361__$1 = state_58361;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58361__$1,(4),from);
} else {
if((state_val_58362 === (3))){
var inst_58359 = (state_58361[(2)]);
var state_58361__$1 = state_58361;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58361__$1,inst_58359);
} else {
if((state_val_58362 === (4))){
var inst_58342 = (state_58361[(7)]);
var inst_58342__$1 = (state_58361[(2)]);
var inst_58343 = (inst_58342__$1 == null);
var state_58361__$1 = (function (){var statearr_58364 = state_58361;
(statearr_58364[(7)] = inst_58342__$1);

return statearr_58364;
})();
if(cljs.core.truth_(inst_58343)){
var statearr_58365_58478 = state_58361__$1;
(statearr_58365_58478[(1)] = (5));

} else {
var statearr_58366_58479 = state_58361__$1;
(statearr_58366_58479[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58362 === (5))){
var inst_58345 = cljs.core.async.close_BANG_.call(null,jobs);
var state_58361__$1 = state_58361;
var statearr_58367_58480 = state_58361__$1;
(statearr_58367_58480[(2)] = inst_58345);

(statearr_58367_58480[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58362 === (6))){
var inst_58347 = (state_58361[(8)]);
var inst_58342 = (state_58361[(7)]);
var inst_58347__$1 = cljs.core.async.chan.call(null,(1));
var inst_58348 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58349 = [inst_58342,inst_58347__$1];
var inst_58350 = (new cljs.core.PersistentVector(null,2,(5),inst_58348,inst_58349,null));
var state_58361__$1 = (function (){var statearr_58368 = state_58361;
(statearr_58368[(8)] = inst_58347__$1);

return statearr_58368;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58361__$1,(8),jobs,inst_58350);
} else {
if((state_val_58362 === (7))){
var inst_58357 = (state_58361[(2)]);
var state_58361__$1 = state_58361;
var statearr_58369_58481 = state_58361__$1;
(statearr_58369_58481[(2)] = inst_58357);

(statearr_58369_58481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58362 === (8))){
var inst_58347 = (state_58361[(8)]);
var inst_58352 = (state_58361[(2)]);
var state_58361__$1 = (function (){var statearr_58370 = state_58361;
(statearr_58370[(9)] = inst_58352);

return statearr_58370;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58361__$1,(9),results,inst_58347);
} else {
if((state_val_58362 === (9))){
var inst_58354 = (state_58361[(2)]);
var state_58361__$1 = (function (){var statearr_58371 = state_58361;
(statearr_58371[(10)] = inst_58354);

return statearr_58371;
})();
var statearr_58372_58482 = state_58361__$1;
(statearr_58372_58482[(2)] = null);

(statearr_58372_58482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___58476,jobs,results,process,async))
;
return ((function (switch__38195__auto__,c__38309__auto___58476,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0 = (function (){
var statearr_58376 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_58376[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__);

(statearr_58376[(1)] = (1));

return statearr_58376;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1 = (function (state_58361){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_58361);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e58377){if((e58377 instanceof Object)){
var ex__38199__auto__ = e58377;
var statearr_58378_58483 = state_58361;
(statearr_58378_58483[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58361);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58377;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58484 = state_58361;
state_58361 = G__58484;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = function(state_58361){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1.call(this,state_58361);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___58476,jobs,results,process,async))
})();
var state__38311__auto__ = (function (){var statearr_58379 = f__38310__auto__.call(null);
(statearr_58379[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___58476);

return statearr_58379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___58476,jobs,results,process,async))
);


var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__,jobs,results,process,async){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__,jobs,results,process,async){
return (function (state_58417){
var state_val_58418 = (state_58417[(1)]);
if((state_val_58418 === (7))){
var inst_58413 = (state_58417[(2)]);
var state_58417__$1 = state_58417;
var statearr_58419_58485 = state_58417__$1;
(statearr_58419_58485[(2)] = inst_58413);

(statearr_58419_58485[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58418 === (20))){
var state_58417__$1 = state_58417;
var statearr_58420_58486 = state_58417__$1;
(statearr_58420_58486[(2)] = null);

(statearr_58420_58486[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58418 === (1))){
var state_58417__$1 = state_58417;
var statearr_58421_58487 = state_58417__$1;
(statearr_58421_58487[(2)] = null);

(statearr_58421_58487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58418 === (4))){
var inst_58382 = (state_58417[(7)]);
var inst_58382__$1 = (state_58417[(2)]);
var inst_58383 = (inst_58382__$1 == null);
var state_58417__$1 = (function (){var statearr_58422 = state_58417;
(statearr_58422[(7)] = inst_58382__$1);

return statearr_58422;
})();
if(cljs.core.truth_(inst_58383)){
var statearr_58423_58488 = state_58417__$1;
(statearr_58423_58488[(1)] = (5));

} else {
var statearr_58424_58489 = state_58417__$1;
(statearr_58424_58489[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58418 === (15))){
var inst_58395 = (state_58417[(8)]);
var state_58417__$1 = state_58417;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58417__$1,(18),to,inst_58395);
} else {
if((state_val_58418 === (21))){
var inst_58408 = (state_58417[(2)]);
var state_58417__$1 = state_58417;
var statearr_58425_58490 = state_58417__$1;
(statearr_58425_58490[(2)] = inst_58408);

(statearr_58425_58490[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58418 === (13))){
var inst_58410 = (state_58417[(2)]);
var state_58417__$1 = (function (){var statearr_58426 = state_58417;
(statearr_58426[(9)] = inst_58410);

return statearr_58426;
})();
var statearr_58427_58491 = state_58417__$1;
(statearr_58427_58491[(2)] = null);

(statearr_58427_58491[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58418 === (6))){
var inst_58382 = (state_58417[(7)]);
var state_58417__$1 = state_58417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58417__$1,(11),inst_58382);
} else {
if((state_val_58418 === (17))){
var inst_58403 = (state_58417[(2)]);
var state_58417__$1 = state_58417;
if(cljs.core.truth_(inst_58403)){
var statearr_58428_58492 = state_58417__$1;
(statearr_58428_58492[(1)] = (19));

} else {
var statearr_58429_58493 = state_58417__$1;
(statearr_58429_58493[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58418 === (3))){
var inst_58415 = (state_58417[(2)]);
var state_58417__$1 = state_58417;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58417__$1,inst_58415);
} else {
if((state_val_58418 === (12))){
var inst_58392 = (state_58417[(10)]);
var state_58417__$1 = state_58417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58417__$1,(14),inst_58392);
} else {
if((state_val_58418 === (2))){
var state_58417__$1 = state_58417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58417__$1,(4),results);
} else {
if((state_val_58418 === (19))){
var state_58417__$1 = state_58417;
var statearr_58430_58494 = state_58417__$1;
(statearr_58430_58494[(2)] = null);

(statearr_58430_58494[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58418 === (11))){
var inst_58392 = (state_58417[(2)]);
var state_58417__$1 = (function (){var statearr_58431 = state_58417;
(statearr_58431[(10)] = inst_58392);

return statearr_58431;
})();
var statearr_58432_58495 = state_58417__$1;
(statearr_58432_58495[(2)] = null);

(statearr_58432_58495[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58418 === (9))){
var state_58417__$1 = state_58417;
var statearr_58433_58496 = state_58417__$1;
(statearr_58433_58496[(2)] = null);

(statearr_58433_58496[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58418 === (5))){
var state_58417__$1 = state_58417;
if(cljs.core.truth_(close_QMARK_)){
var statearr_58434_58497 = state_58417__$1;
(statearr_58434_58497[(1)] = (8));

} else {
var statearr_58435_58498 = state_58417__$1;
(statearr_58435_58498[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58418 === (14))){
var inst_58397 = (state_58417[(11)]);
var inst_58395 = (state_58417[(8)]);
var inst_58395__$1 = (state_58417[(2)]);
var inst_58396 = (inst_58395__$1 == null);
var inst_58397__$1 = cljs.core.not.call(null,inst_58396);
var state_58417__$1 = (function (){var statearr_58436 = state_58417;
(statearr_58436[(11)] = inst_58397__$1);

(statearr_58436[(8)] = inst_58395__$1);

return statearr_58436;
})();
if(inst_58397__$1){
var statearr_58437_58499 = state_58417__$1;
(statearr_58437_58499[(1)] = (15));

} else {
var statearr_58438_58500 = state_58417__$1;
(statearr_58438_58500[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58418 === (16))){
var inst_58397 = (state_58417[(11)]);
var state_58417__$1 = state_58417;
var statearr_58439_58501 = state_58417__$1;
(statearr_58439_58501[(2)] = inst_58397);

(statearr_58439_58501[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58418 === (10))){
var inst_58389 = (state_58417[(2)]);
var state_58417__$1 = state_58417;
var statearr_58440_58502 = state_58417__$1;
(statearr_58440_58502[(2)] = inst_58389);

(statearr_58440_58502[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58418 === (18))){
var inst_58400 = (state_58417[(2)]);
var state_58417__$1 = state_58417;
var statearr_58441_58503 = state_58417__$1;
(statearr_58441_58503[(2)] = inst_58400);

(statearr_58441_58503[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58418 === (8))){
var inst_58386 = cljs.core.async.close_BANG_.call(null,to);
var state_58417__$1 = state_58417;
var statearr_58442_58504 = state_58417__$1;
(statearr_58442_58504[(2)] = inst_58386);

(statearr_58442_58504[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto__,jobs,results,process,async))
;
return ((function (switch__38195__auto__,c__38309__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0 = (function (){
var statearr_58446 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58446[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__);

(statearr_58446[(1)] = (1));

return statearr_58446;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1 = (function (state_58417){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_58417);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e58447){if((e58447 instanceof Object)){
var ex__38199__auto__ = e58447;
var statearr_58448_58505 = state_58417;
(statearr_58448_58505[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58417);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58447;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58506 = state_58417;
state_58417 = G__58506;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = function(state_58417){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1.call(this,state_58417);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__,jobs,results,process,async))
})();
var state__38311__auto__ = (function (){var statearr_58449 = f__38310__auto__.call(null);
(statearr_58449[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_58449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__,jobs,results,process,async))
);

return c__38309__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args58507 = [];
var len__10640__auto___58510 = arguments.length;
var i__10641__auto___58511 = (0);
while(true){
if((i__10641__auto___58511 < len__10640__auto___58510)){
args58507.push((arguments[i__10641__auto___58511]));

var G__58512 = (i__10641__auto___58511 + (1));
i__10641__auto___58511 = G__58512;
continue;
} else {
}
break;
}

var G__58509 = args58507.length;
switch (G__58509) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args58507.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args58514 = [];
var len__10640__auto___58517 = arguments.length;
var i__10641__auto___58518 = (0);
while(true){
if((i__10641__auto___58518 < len__10640__auto___58517)){
args58514.push((arguments[i__10641__auto___58518]));

var G__58519 = (i__10641__auto___58518 + (1));
i__10641__auto___58518 = G__58519;
continue;
} else {
}
break;
}

var G__58516 = args58514.length;
switch (G__58516) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args58514.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args58521 = [];
var len__10640__auto___58574 = arguments.length;
var i__10641__auto___58575 = (0);
while(true){
if((i__10641__auto___58575 < len__10640__auto___58574)){
args58521.push((arguments[i__10641__auto___58575]));

var G__58576 = (i__10641__auto___58575 + (1));
i__10641__auto___58575 = G__58576;
continue;
} else {
}
break;
}

var G__58523 = args58521.length;
switch (G__58523) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args58521.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__38309__auto___58578 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___58578,tc,fc){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___58578,tc,fc){
return (function (state_58549){
var state_val_58550 = (state_58549[(1)]);
if((state_val_58550 === (7))){
var inst_58545 = (state_58549[(2)]);
var state_58549__$1 = state_58549;
var statearr_58551_58579 = state_58549__$1;
(statearr_58551_58579[(2)] = inst_58545);

(statearr_58551_58579[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58550 === (1))){
var state_58549__$1 = state_58549;
var statearr_58552_58580 = state_58549__$1;
(statearr_58552_58580[(2)] = null);

(statearr_58552_58580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58550 === (4))){
var inst_58526 = (state_58549[(7)]);
var inst_58526__$1 = (state_58549[(2)]);
var inst_58527 = (inst_58526__$1 == null);
var state_58549__$1 = (function (){var statearr_58553 = state_58549;
(statearr_58553[(7)] = inst_58526__$1);

return statearr_58553;
})();
if(cljs.core.truth_(inst_58527)){
var statearr_58554_58581 = state_58549__$1;
(statearr_58554_58581[(1)] = (5));

} else {
var statearr_58555_58582 = state_58549__$1;
(statearr_58555_58582[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58550 === (13))){
var state_58549__$1 = state_58549;
var statearr_58556_58583 = state_58549__$1;
(statearr_58556_58583[(2)] = null);

(statearr_58556_58583[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58550 === (6))){
var inst_58526 = (state_58549[(7)]);
var inst_58532 = p.call(null,inst_58526);
var state_58549__$1 = state_58549;
if(cljs.core.truth_(inst_58532)){
var statearr_58557_58584 = state_58549__$1;
(statearr_58557_58584[(1)] = (9));

} else {
var statearr_58558_58585 = state_58549__$1;
(statearr_58558_58585[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58550 === (3))){
var inst_58547 = (state_58549[(2)]);
var state_58549__$1 = state_58549;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58549__$1,inst_58547);
} else {
if((state_val_58550 === (12))){
var state_58549__$1 = state_58549;
var statearr_58559_58586 = state_58549__$1;
(statearr_58559_58586[(2)] = null);

(statearr_58559_58586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58550 === (2))){
var state_58549__$1 = state_58549;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58549__$1,(4),ch);
} else {
if((state_val_58550 === (11))){
var inst_58526 = (state_58549[(7)]);
var inst_58536 = (state_58549[(2)]);
var state_58549__$1 = state_58549;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58549__$1,(8),inst_58536,inst_58526);
} else {
if((state_val_58550 === (9))){
var state_58549__$1 = state_58549;
var statearr_58560_58587 = state_58549__$1;
(statearr_58560_58587[(2)] = tc);

(statearr_58560_58587[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58550 === (5))){
var inst_58529 = cljs.core.async.close_BANG_.call(null,tc);
var inst_58530 = cljs.core.async.close_BANG_.call(null,fc);
var state_58549__$1 = (function (){var statearr_58561 = state_58549;
(statearr_58561[(8)] = inst_58529);

return statearr_58561;
})();
var statearr_58562_58588 = state_58549__$1;
(statearr_58562_58588[(2)] = inst_58530);

(statearr_58562_58588[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58550 === (14))){
var inst_58543 = (state_58549[(2)]);
var state_58549__$1 = state_58549;
var statearr_58563_58589 = state_58549__$1;
(statearr_58563_58589[(2)] = inst_58543);

(statearr_58563_58589[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58550 === (10))){
var state_58549__$1 = state_58549;
var statearr_58564_58590 = state_58549__$1;
(statearr_58564_58590[(2)] = fc);

(statearr_58564_58590[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58550 === (8))){
var inst_58538 = (state_58549[(2)]);
var state_58549__$1 = state_58549;
if(cljs.core.truth_(inst_58538)){
var statearr_58565_58591 = state_58549__$1;
(statearr_58565_58591[(1)] = (12));

} else {
var statearr_58566_58592 = state_58549__$1;
(statearr_58566_58592[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___58578,tc,fc))
;
return ((function (switch__38195__auto__,c__38309__auto___58578,tc,fc){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_58570 = [null,null,null,null,null,null,null,null,null];
(statearr_58570[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_58570[(1)] = (1));

return statearr_58570;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_58549){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_58549);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e58571){if((e58571 instanceof Object)){
var ex__38199__auto__ = e58571;
var statearr_58572_58593 = state_58549;
(statearr_58572_58593[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58549);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58571;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58594 = state_58549;
state_58549 = G__58594;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_58549){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_58549);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___58578,tc,fc))
})();
var state__38311__auto__ = (function (){var statearr_58573 = f__38310__auto__.call(null);
(statearr_58573[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___58578);

return statearr_58573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___58578,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__){
return (function (state_58658){
var state_val_58659 = (state_58658[(1)]);
if((state_val_58659 === (7))){
var inst_58654 = (state_58658[(2)]);
var state_58658__$1 = state_58658;
var statearr_58660_58681 = state_58658__$1;
(statearr_58660_58681[(2)] = inst_58654);

(statearr_58660_58681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58659 === (1))){
var inst_58638 = init;
var state_58658__$1 = (function (){var statearr_58661 = state_58658;
(statearr_58661[(7)] = inst_58638);

return statearr_58661;
})();
var statearr_58662_58682 = state_58658__$1;
(statearr_58662_58682[(2)] = null);

(statearr_58662_58682[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58659 === (4))){
var inst_58641 = (state_58658[(8)]);
var inst_58641__$1 = (state_58658[(2)]);
var inst_58642 = (inst_58641__$1 == null);
var state_58658__$1 = (function (){var statearr_58663 = state_58658;
(statearr_58663[(8)] = inst_58641__$1);

return statearr_58663;
})();
if(cljs.core.truth_(inst_58642)){
var statearr_58664_58683 = state_58658__$1;
(statearr_58664_58683[(1)] = (5));

} else {
var statearr_58665_58684 = state_58658__$1;
(statearr_58665_58684[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58659 === (6))){
var inst_58638 = (state_58658[(7)]);
var inst_58641 = (state_58658[(8)]);
var inst_58645 = (state_58658[(9)]);
var inst_58645__$1 = f.call(null,inst_58638,inst_58641);
var inst_58646 = cljs.core.reduced_QMARK_.call(null,inst_58645__$1);
var state_58658__$1 = (function (){var statearr_58666 = state_58658;
(statearr_58666[(9)] = inst_58645__$1);

return statearr_58666;
})();
if(inst_58646){
var statearr_58667_58685 = state_58658__$1;
(statearr_58667_58685[(1)] = (8));

} else {
var statearr_58668_58686 = state_58658__$1;
(statearr_58668_58686[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58659 === (3))){
var inst_58656 = (state_58658[(2)]);
var state_58658__$1 = state_58658;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58658__$1,inst_58656);
} else {
if((state_val_58659 === (2))){
var state_58658__$1 = state_58658;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58658__$1,(4),ch);
} else {
if((state_val_58659 === (9))){
var inst_58645 = (state_58658[(9)]);
var inst_58638 = inst_58645;
var state_58658__$1 = (function (){var statearr_58669 = state_58658;
(statearr_58669[(7)] = inst_58638);

return statearr_58669;
})();
var statearr_58670_58687 = state_58658__$1;
(statearr_58670_58687[(2)] = null);

(statearr_58670_58687[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58659 === (5))){
var inst_58638 = (state_58658[(7)]);
var state_58658__$1 = state_58658;
var statearr_58671_58688 = state_58658__$1;
(statearr_58671_58688[(2)] = inst_58638);

(statearr_58671_58688[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58659 === (10))){
var inst_58652 = (state_58658[(2)]);
var state_58658__$1 = state_58658;
var statearr_58672_58689 = state_58658__$1;
(statearr_58672_58689[(2)] = inst_58652);

(statearr_58672_58689[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58659 === (8))){
var inst_58645 = (state_58658[(9)]);
var inst_58648 = cljs.core.deref.call(null,inst_58645);
var state_58658__$1 = state_58658;
var statearr_58673_58690 = state_58658__$1;
(statearr_58673_58690[(2)] = inst_58648);

(statearr_58673_58690[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto__))
;
return ((function (switch__38195__auto__,c__38309__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__38196__auto__ = null;
var cljs$core$async$reduce_$_state_machine__38196__auto____0 = (function (){
var statearr_58677 = [null,null,null,null,null,null,null,null,null,null];
(statearr_58677[(0)] = cljs$core$async$reduce_$_state_machine__38196__auto__);

(statearr_58677[(1)] = (1));

return statearr_58677;
});
var cljs$core$async$reduce_$_state_machine__38196__auto____1 = (function (state_58658){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_58658);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e58678){if((e58678 instanceof Object)){
var ex__38199__auto__ = e58678;
var statearr_58679_58691 = state_58658;
(statearr_58679_58691[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58658);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58678;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58692 = state_58658;
state_58658 = G__58692;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__38196__auto__ = function(state_58658){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__38196__auto____1.call(this,state_58658);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__38196__auto____0;
cljs$core$async$reduce_$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__38196__auto____1;
return cljs$core$async$reduce_$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__))
})();
var state__38311__auto__ = (function (){var statearr_58680 = f__38310__auto__.call(null);
(statearr_58680[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_58680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__))
);

return c__38309__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__,f__$1){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__,f__$1){
return (function (state_58712){
var state_val_58713 = (state_58712[(1)]);
if((state_val_58713 === (1))){
var inst_58707 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_58712__$1 = state_58712;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58712__$1,(2),inst_58707);
} else {
if((state_val_58713 === (2))){
var inst_58709 = (state_58712[(2)]);
var inst_58710 = f__$1.call(null,inst_58709);
var state_58712__$1 = state_58712;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58712__$1,inst_58710);
} else {
return null;
}
}
});})(c__38309__auto__,f__$1))
;
return ((function (switch__38195__auto__,c__38309__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__38196__auto__ = null;
var cljs$core$async$transduce_$_state_machine__38196__auto____0 = (function (){
var statearr_58717 = [null,null,null,null,null,null,null];
(statearr_58717[(0)] = cljs$core$async$transduce_$_state_machine__38196__auto__);

(statearr_58717[(1)] = (1));

return statearr_58717;
});
var cljs$core$async$transduce_$_state_machine__38196__auto____1 = (function (state_58712){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_58712);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e58718){if((e58718 instanceof Object)){
var ex__38199__auto__ = e58718;
var statearr_58719_58721 = state_58712;
(statearr_58719_58721[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58712);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58718;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58722 = state_58712;
state_58712 = G__58722;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__38196__auto__ = function(state_58712){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__38196__auto____1.call(this,state_58712);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__38196__auto____0;
cljs$core$async$transduce_$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__38196__auto____1;
return cljs$core$async$transduce_$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__,f__$1))
})();
var state__38311__auto__ = (function (){var statearr_58720 = f__38310__auto__.call(null);
(statearr_58720[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_58720;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__,f__$1))
);

return c__38309__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args58723 = [];
var len__10640__auto___58775 = arguments.length;
var i__10641__auto___58776 = (0);
while(true){
if((i__10641__auto___58776 < len__10640__auto___58775)){
args58723.push((arguments[i__10641__auto___58776]));

var G__58777 = (i__10641__auto___58776 + (1));
i__10641__auto___58776 = G__58777;
continue;
} else {
}
break;
}

var G__58725 = args58723.length;
switch (G__58725) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args58723.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__){
return (function (state_58750){
var state_val_58751 = (state_58750[(1)]);
if((state_val_58751 === (7))){
var inst_58732 = (state_58750[(2)]);
var state_58750__$1 = state_58750;
var statearr_58752_58779 = state_58750__$1;
(statearr_58752_58779[(2)] = inst_58732);

(statearr_58752_58779[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58751 === (1))){
var inst_58726 = cljs.core.seq.call(null,coll);
var inst_58727 = inst_58726;
var state_58750__$1 = (function (){var statearr_58753 = state_58750;
(statearr_58753[(7)] = inst_58727);

return statearr_58753;
})();
var statearr_58754_58780 = state_58750__$1;
(statearr_58754_58780[(2)] = null);

(statearr_58754_58780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58751 === (4))){
var inst_58727 = (state_58750[(7)]);
var inst_58730 = cljs.core.first.call(null,inst_58727);
var state_58750__$1 = state_58750;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58750__$1,(7),ch,inst_58730);
} else {
if((state_val_58751 === (13))){
var inst_58744 = (state_58750[(2)]);
var state_58750__$1 = state_58750;
var statearr_58755_58781 = state_58750__$1;
(statearr_58755_58781[(2)] = inst_58744);

(statearr_58755_58781[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58751 === (6))){
var inst_58735 = (state_58750[(2)]);
var state_58750__$1 = state_58750;
if(cljs.core.truth_(inst_58735)){
var statearr_58756_58782 = state_58750__$1;
(statearr_58756_58782[(1)] = (8));

} else {
var statearr_58757_58783 = state_58750__$1;
(statearr_58757_58783[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58751 === (3))){
var inst_58748 = (state_58750[(2)]);
var state_58750__$1 = state_58750;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58750__$1,inst_58748);
} else {
if((state_val_58751 === (12))){
var state_58750__$1 = state_58750;
var statearr_58758_58784 = state_58750__$1;
(statearr_58758_58784[(2)] = null);

(statearr_58758_58784[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58751 === (2))){
var inst_58727 = (state_58750[(7)]);
var state_58750__$1 = state_58750;
if(cljs.core.truth_(inst_58727)){
var statearr_58759_58785 = state_58750__$1;
(statearr_58759_58785[(1)] = (4));

} else {
var statearr_58760_58786 = state_58750__$1;
(statearr_58760_58786[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58751 === (11))){
var inst_58741 = cljs.core.async.close_BANG_.call(null,ch);
var state_58750__$1 = state_58750;
var statearr_58761_58787 = state_58750__$1;
(statearr_58761_58787[(2)] = inst_58741);

(statearr_58761_58787[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58751 === (9))){
var state_58750__$1 = state_58750;
if(cljs.core.truth_(close_QMARK_)){
var statearr_58762_58788 = state_58750__$1;
(statearr_58762_58788[(1)] = (11));

} else {
var statearr_58763_58789 = state_58750__$1;
(statearr_58763_58789[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58751 === (5))){
var inst_58727 = (state_58750[(7)]);
var state_58750__$1 = state_58750;
var statearr_58764_58790 = state_58750__$1;
(statearr_58764_58790[(2)] = inst_58727);

(statearr_58764_58790[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58751 === (10))){
var inst_58746 = (state_58750[(2)]);
var state_58750__$1 = state_58750;
var statearr_58765_58791 = state_58750__$1;
(statearr_58765_58791[(2)] = inst_58746);

(statearr_58765_58791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58751 === (8))){
var inst_58727 = (state_58750[(7)]);
var inst_58737 = cljs.core.next.call(null,inst_58727);
var inst_58727__$1 = inst_58737;
var state_58750__$1 = (function (){var statearr_58766 = state_58750;
(statearr_58766[(7)] = inst_58727__$1);

return statearr_58766;
})();
var statearr_58767_58792 = state_58750__$1;
(statearr_58767_58792[(2)] = null);

(statearr_58767_58792[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto__))
;
return ((function (switch__38195__auto__,c__38309__auto__){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_58771 = [null,null,null,null,null,null,null,null];
(statearr_58771[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_58771[(1)] = (1));

return statearr_58771;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_58750){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_58750);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e58772){if((e58772 instanceof Object)){
var ex__38199__auto__ = e58772;
var statearr_58773_58793 = state_58750;
(statearr_58773_58793[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58750);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58772;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58794 = state_58750;
state_58750 = G__58794;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_58750){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_58750);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__))
})();
var state__38311__auto__ = (function (){var statearr_58774 = f__38310__auto__.call(null);
(statearr_58774[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_58774;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__))
);

return c__38309__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__10137__auto__ = (((_ == null))?null:_);
var m__10138__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,_);
} else {
var m__10138__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__10138__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m);
} else {
var m__10138__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async59020 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async59020 = (function (ch,cs,meta59021){
this.ch = ch;
this.cs = cs;
this.meta59021 = meta59021;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async59020.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_59022,meta59021__$1){
var self__ = this;
var _59022__$1 = this;
return (new cljs.core.async.t_cljs$core$async59020(self__.ch,self__.cs,meta59021__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async59020.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_59022){
var self__ = this;
var _59022__$1 = this;
return self__.meta59021;
});})(cs))
;

cljs.core.async.t_cljs$core$async59020.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59020.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async59020.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59020.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async59020.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async59020.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async59020.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta59021","meta59021",-1185340809,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async59020.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async59020.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async59020";

cljs.core.async.t_cljs$core$async59020.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async59020");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async59020 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async59020(ch__$1,cs__$1,meta59021){
return (new cljs.core.async.t_cljs$core$async59020(ch__$1,cs__$1,meta59021));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async59020(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__38309__auto___59245 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___59245,cs,m,dchan,dctr,done){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___59245,cs,m,dchan,dctr,done){
return (function (state_59157){
var state_val_59158 = (state_59157[(1)]);
if((state_val_59158 === (7))){
var inst_59153 = (state_59157[(2)]);
var state_59157__$1 = state_59157;
var statearr_59159_59246 = state_59157__$1;
(statearr_59159_59246[(2)] = inst_59153);

(statearr_59159_59246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (20))){
var inst_59056 = (state_59157[(7)]);
var inst_59068 = cljs.core.first.call(null,inst_59056);
var inst_59069 = cljs.core.nth.call(null,inst_59068,(0),null);
var inst_59070 = cljs.core.nth.call(null,inst_59068,(1),null);
var state_59157__$1 = (function (){var statearr_59160 = state_59157;
(statearr_59160[(8)] = inst_59069);

return statearr_59160;
})();
if(cljs.core.truth_(inst_59070)){
var statearr_59161_59247 = state_59157__$1;
(statearr_59161_59247[(1)] = (22));

} else {
var statearr_59162_59248 = state_59157__$1;
(statearr_59162_59248[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (27))){
var inst_59098 = (state_59157[(9)]);
var inst_59025 = (state_59157[(10)]);
var inst_59105 = (state_59157[(11)]);
var inst_59100 = (state_59157[(12)]);
var inst_59105__$1 = cljs.core._nth.call(null,inst_59098,inst_59100);
var inst_59106 = cljs.core.async.put_BANG_.call(null,inst_59105__$1,inst_59025,done);
var state_59157__$1 = (function (){var statearr_59163 = state_59157;
(statearr_59163[(11)] = inst_59105__$1);

return statearr_59163;
})();
if(cljs.core.truth_(inst_59106)){
var statearr_59164_59249 = state_59157__$1;
(statearr_59164_59249[(1)] = (30));

} else {
var statearr_59165_59250 = state_59157__$1;
(statearr_59165_59250[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (1))){
var state_59157__$1 = state_59157;
var statearr_59166_59251 = state_59157__$1;
(statearr_59166_59251[(2)] = null);

(statearr_59166_59251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (24))){
var inst_59056 = (state_59157[(7)]);
var inst_59075 = (state_59157[(2)]);
var inst_59076 = cljs.core.next.call(null,inst_59056);
var inst_59034 = inst_59076;
var inst_59035 = null;
var inst_59036 = (0);
var inst_59037 = (0);
var state_59157__$1 = (function (){var statearr_59167 = state_59157;
(statearr_59167[(13)] = inst_59034);

(statearr_59167[(14)] = inst_59036);

(statearr_59167[(15)] = inst_59075);

(statearr_59167[(16)] = inst_59037);

(statearr_59167[(17)] = inst_59035);

return statearr_59167;
})();
var statearr_59168_59252 = state_59157__$1;
(statearr_59168_59252[(2)] = null);

(statearr_59168_59252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (39))){
var state_59157__$1 = state_59157;
var statearr_59172_59253 = state_59157__$1;
(statearr_59172_59253[(2)] = null);

(statearr_59172_59253[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (4))){
var inst_59025 = (state_59157[(10)]);
var inst_59025__$1 = (state_59157[(2)]);
var inst_59026 = (inst_59025__$1 == null);
var state_59157__$1 = (function (){var statearr_59173 = state_59157;
(statearr_59173[(10)] = inst_59025__$1);

return statearr_59173;
})();
if(cljs.core.truth_(inst_59026)){
var statearr_59174_59254 = state_59157__$1;
(statearr_59174_59254[(1)] = (5));

} else {
var statearr_59175_59255 = state_59157__$1;
(statearr_59175_59255[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (15))){
var inst_59034 = (state_59157[(13)]);
var inst_59036 = (state_59157[(14)]);
var inst_59037 = (state_59157[(16)]);
var inst_59035 = (state_59157[(17)]);
var inst_59052 = (state_59157[(2)]);
var inst_59053 = (inst_59037 + (1));
var tmp59169 = inst_59034;
var tmp59170 = inst_59036;
var tmp59171 = inst_59035;
var inst_59034__$1 = tmp59169;
var inst_59035__$1 = tmp59171;
var inst_59036__$1 = tmp59170;
var inst_59037__$1 = inst_59053;
var state_59157__$1 = (function (){var statearr_59176 = state_59157;
(statearr_59176[(13)] = inst_59034__$1);

(statearr_59176[(14)] = inst_59036__$1);

(statearr_59176[(18)] = inst_59052);

(statearr_59176[(16)] = inst_59037__$1);

(statearr_59176[(17)] = inst_59035__$1);

return statearr_59176;
})();
var statearr_59177_59256 = state_59157__$1;
(statearr_59177_59256[(2)] = null);

(statearr_59177_59256[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (21))){
var inst_59079 = (state_59157[(2)]);
var state_59157__$1 = state_59157;
var statearr_59181_59257 = state_59157__$1;
(statearr_59181_59257[(2)] = inst_59079);

(statearr_59181_59257[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (31))){
var inst_59105 = (state_59157[(11)]);
var inst_59109 = done.call(null,null);
var inst_59110 = cljs.core.async.untap_STAR_.call(null,m,inst_59105);
var state_59157__$1 = (function (){var statearr_59182 = state_59157;
(statearr_59182[(19)] = inst_59109);

return statearr_59182;
})();
var statearr_59183_59258 = state_59157__$1;
(statearr_59183_59258[(2)] = inst_59110);

(statearr_59183_59258[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (32))){
var inst_59097 = (state_59157[(20)]);
var inst_59098 = (state_59157[(9)]);
var inst_59099 = (state_59157[(21)]);
var inst_59100 = (state_59157[(12)]);
var inst_59112 = (state_59157[(2)]);
var inst_59113 = (inst_59100 + (1));
var tmp59178 = inst_59097;
var tmp59179 = inst_59098;
var tmp59180 = inst_59099;
var inst_59097__$1 = tmp59178;
var inst_59098__$1 = tmp59179;
var inst_59099__$1 = tmp59180;
var inst_59100__$1 = inst_59113;
var state_59157__$1 = (function (){var statearr_59184 = state_59157;
(statearr_59184[(20)] = inst_59097__$1);

(statearr_59184[(9)] = inst_59098__$1);

(statearr_59184[(22)] = inst_59112);

(statearr_59184[(21)] = inst_59099__$1);

(statearr_59184[(12)] = inst_59100__$1);

return statearr_59184;
})();
var statearr_59185_59259 = state_59157__$1;
(statearr_59185_59259[(2)] = null);

(statearr_59185_59259[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (40))){
var inst_59125 = (state_59157[(23)]);
var inst_59129 = done.call(null,null);
var inst_59130 = cljs.core.async.untap_STAR_.call(null,m,inst_59125);
var state_59157__$1 = (function (){var statearr_59186 = state_59157;
(statearr_59186[(24)] = inst_59129);

return statearr_59186;
})();
var statearr_59187_59260 = state_59157__$1;
(statearr_59187_59260[(2)] = inst_59130);

(statearr_59187_59260[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (33))){
var inst_59116 = (state_59157[(25)]);
var inst_59118 = cljs.core.chunked_seq_QMARK_.call(null,inst_59116);
var state_59157__$1 = state_59157;
if(inst_59118){
var statearr_59188_59261 = state_59157__$1;
(statearr_59188_59261[(1)] = (36));

} else {
var statearr_59189_59262 = state_59157__$1;
(statearr_59189_59262[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (13))){
var inst_59046 = (state_59157[(26)]);
var inst_59049 = cljs.core.async.close_BANG_.call(null,inst_59046);
var state_59157__$1 = state_59157;
var statearr_59190_59263 = state_59157__$1;
(statearr_59190_59263[(2)] = inst_59049);

(statearr_59190_59263[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (22))){
var inst_59069 = (state_59157[(8)]);
var inst_59072 = cljs.core.async.close_BANG_.call(null,inst_59069);
var state_59157__$1 = state_59157;
var statearr_59191_59264 = state_59157__$1;
(statearr_59191_59264[(2)] = inst_59072);

(statearr_59191_59264[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (36))){
var inst_59116 = (state_59157[(25)]);
var inst_59120 = cljs.core.chunk_first.call(null,inst_59116);
var inst_59121 = cljs.core.chunk_rest.call(null,inst_59116);
var inst_59122 = cljs.core.count.call(null,inst_59120);
var inst_59097 = inst_59121;
var inst_59098 = inst_59120;
var inst_59099 = inst_59122;
var inst_59100 = (0);
var state_59157__$1 = (function (){var statearr_59192 = state_59157;
(statearr_59192[(20)] = inst_59097);

(statearr_59192[(9)] = inst_59098);

(statearr_59192[(21)] = inst_59099);

(statearr_59192[(12)] = inst_59100);

return statearr_59192;
})();
var statearr_59193_59265 = state_59157__$1;
(statearr_59193_59265[(2)] = null);

(statearr_59193_59265[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (41))){
var inst_59116 = (state_59157[(25)]);
var inst_59132 = (state_59157[(2)]);
var inst_59133 = cljs.core.next.call(null,inst_59116);
var inst_59097 = inst_59133;
var inst_59098 = null;
var inst_59099 = (0);
var inst_59100 = (0);
var state_59157__$1 = (function (){var statearr_59194 = state_59157;
(statearr_59194[(27)] = inst_59132);

(statearr_59194[(20)] = inst_59097);

(statearr_59194[(9)] = inst_59098);

(statearr_59194[(21)] = inst_59099);

(statearr_59194[(12)] = inst_59100);

return statearr_59194;
})();
var statearr_59195_59266 = state_59157__$1;
(statearr_59195_59266[(2)] = null);

(statearr_59195_59266[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (43))){
var state_59157__$1 = state_59157;
var statearr_59196_59267 = state_59157__$1;
(statearr_59196_59267[(2)] = null);

(statearr_59196_59267[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (29))){
var inst_59141 = (state_59157[(2)]);
var state_59157__$1 = state_59157;
var statearr_59197_59268 = state_59157__$1;
(statearr_59197_59268[(2)] = inst_59141);

(statearr_59197_59268[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (44))){
var inst_59150 = (state_59157[(2)]);
var state_59157__$1 = (function (){var statearr_59198 = state_59157;
(statearr_59198[(28)] = inst_59150);

return statearr_59198;
})();
var statearr_59199_59269 = state_59157__$1;
(statearr_59199_59269[(2)] = null);

(statearr_59199_59269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (6))){
var inst_59089 = (state_59157[(29)]);
var inst_59088 = cljs.core.deref.call(null,cs);
var inst_59089__$1 = cljs.core.keys.call(null,inst_59088);
var inst_59090 = cljs.core.count.call(null,inst_59089__$1);
var inst_59091 = cljs.core.reset_BANG_.call(null,dctr,inst_59090);
var inst_59096 = cljs.core.seq.call(null,inst_59089__$1);
var inst_59097 = inst_59096;
var inst_59098 = null;
var inst_59099 = (0);
var inst_59100 = (0);
var state_59157__$1 = (function (){var statearr_59200 = state_59157;
(statearr_59200[(29)] = inst_59089__$1);

(statearr_59200[(20)] = inst_59097);

(statearr_59200[(9)] = inst_59098);

(statearr_59200[(30)] = inst_59091);

(statearr_59200[(21)] = inst_59099);

(statearr_59200[(12)] = inst_59100);

return statearr_59200;
})();
var statearr_59201_59270 = state_59157__$1;
(statearr_59201_59270[(2)] = null);

(statearr_59201_59270[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (28))){
var inst_59097 = (state_59157[(20)]);
var inst_59116 = (state_59157[(25)]);
var inst_59116__$1 = cljs.core.seq.call(null,inst_59097);
var state_59157__$1 = (function (){var statearr_59202 = state_59157;
(statearr_59202[(25)] = inst_59116__$1);

return statearr_59202;
})();
if(inst_59116__$1){
var statearr_59203_59271 = state_59157__$1;
(statearr_59203_59271[(1)] = (33));

} else {
var statearr_59204_59272 = state_59157__$1;
(statearr_59204_59272[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (25))){
var inst_59099 = (state_59157[(21)]);
var inst_59100 = (state_59157[(12)]);
var inst_59102 = (inst_59100 < inst_59099);
var inst_59103 = inst_59102;
var state_59157__$1 = state_59157;
if(cljs.core.truth_(inst_59103)){
var statearr_59205_59273 = state_59157__$1;
(statearr_59205_59273[(1)] = (27));

} else {
var statearr_59206_59274 = state_59157__$1;
(statearr_59206_59274[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (34))){
var state_59157__$1 = state_59157;
var statearr_59207_59275 = state_59157__$1;
(statearr_59207_59275[(2)] = null);

(statearr_59207_59275[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (17))){
var state_59157__$1 = state_59157;
var statearr_59208_59276 = state_59157__$1;
(statearr_59208_59276[(2)] = null);

(statearr_59208_59276[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (3))){
var inst_59155 = (state_59157[(2)]);
var state_59157__$1 = state_59157;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59157__$1,inst_59155);
} else {
if((state_val_59158 === (12))){
var inst_59084 = (state_59157[(2)]);
var state_59157__$1 = state_59157;
var statearr_59209_59277 = state_59157__$1;
(statearr_59209_59277[(2)] = inst_59084);

(statearr_59209_59277[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (2))){
var state_59157__$1 = state_59157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59157__$1,(4),ch);
} else {
if((state_val_59158 === (23))){
var state_59157__$1 = state_59157;
var statearr_59210_59278 = state_59157__$1;
(statearr_59210_59278[(2)] = null);

(statearr_59210_59278[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (35))){
var inst_59139 = (state_59157[(2)]);
var state_59157__$1 = state_59157;
var statearr_59211_59279 = state_59157__$1;
(statearr_59211_59279[(2)] = inst_59139);

(statearr_59211_59279[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (19))){
var inst_59056 = (state_59157[(7)]);
var inst_59060 = cljs.core.chunk_first.call(null,inst_59056);
var inst_59061 = cljs.core.chunk_rest.call(null,inst_59056);
var inst_59062 = cljs.core.count.call(null,inst_59060);
var inst_59034 = inst_59061;
var inst_59035 = inst_59060;
var inst_59036 = inst_59062;
var inst_59037 = (0);
var state_59157__$1 = (function (){var statearr_59212 = state_59157;
(statearr_59212[(13)] = inst_59034);

(statearr_59212[(14)] = inst_59036);

(statearr_59212[(16)] = inst_59037);

(statearr_59212[(17)] = inst_59035);

return statearr_59212;
})();
var statearr_59213_59280 = state_59157__$1;
(statearr_59213_59280[(2)] = null);

(statearr_59213_59280[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (11))){
var inst_59056 = (state_59157[(7)]);
var inst_59034 = (state_59157[(13)]);
var inst_59056__$1 = cljs.core.seq.call(null,inst_59034);
var state_59157__$1 = (function (){var statearr_59214 = state_59157;
(statearr_59214[(7)] = inst_59056__$1);

return statearr_59214;
})();
if(inst_59056__$1){
var statearr_59215_59281 = state_59157__$1;
(statearr_59215_59281[(1)] = (16));

} else {
var statearr_59216_59282 = state_59157__$1;
(statearr_59216_59282[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (9))){
var inst_59086 = (state_59157[(2)]);
var state_59157__$1 = state_59157;
var statearr_59217_59283 = state_59157__$1;
(statearr_59217_59283[(2)] = inst_59086);

(statearr_59217_59283[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (5))){
var inst_59032 = cljs.core.deref.call(null,cs);
var inst_59033 = cljs.core.seq.call(null,inst_59032);
var inst_59034 = inst_59033;
var inst_59035 = null;
var inst_59036 = (0);
var inst_59037 = (0);
var state_59157__$1 = (function (){var statearr_59218 = state_59157;
(statearr_59218[(13)] = inst_59034);

(statearr_59218[(14)] = inst_59036);

(statearr_59218[(16)] = inst_59037);

(statearr_59218[(17)] = inst_59035);

return statearr_59218;
})();
var statearr_59219_59284 = state_59157__$1;
(statearr_59219_59284[(2)] = null);

(statearr_59219_59284[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (14))){
var state_59157__$1 = state_59157;
var statearr_59220_59285 = state_59157__$1;
(statearr_59220_59285[(2)] = null);

(statearr_59220_59285[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (45))){
var inst_59147 = (state_59157[(2)]);
var state_59157__$1 = state_59157;
var statearr_59221_59286 = state_59157__$1;
(statearr_59221_59286[(2)] = inst_59147);

(statearr_59221_59286[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (26))){
var inst_59089 = (state_59157[(29)]);
var inst_59143 = (state_59157[(2)]);
var inst_59144 = cljs.core.seq.call(null,inst_59089);
var state_59157__$1 = (function (){var statearr_59222 = state_59157;
(statearr_59222[(31)] = inst_59143);

return statearr_59222;
})();
if(inst_59144){
var statearr_59223_59287 = state_59157__$1;
(statearr_59223_59287[(1)] = (42));

} else {
var statearr_59224_59288 = state_59157__$1;
(statearr_59224_59288[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (16))){
var inst_59056 = (state_59157[(7)]);
var inst_59058 = cljs.core.chunked_seq_QMARK_.call(null,inst_59056);
var state_59157__$1 = state_59157;
if(inst_59058){
var statearr_59225_59289 = state_59157__$1;
(statearr_59225_59289[(1)] = (19));

} else {
var statearr_59226_59290 = state_59157__$1;
(statearr_59226_59290[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (38))){
var inst_59136 = (state_59157[(2)]);
var state_59157__$1 = state_59157;
var statearr_59227_59291 = state_59157__$1;
(statearr_59227_59291[(2)] = inst_59136);

(statearr_59227_59291[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (30))){
var state_59157__$1 = state_59157;
var statearr_59228_59292 = state_59157__$1;
(statearr_59228_59292[(2)] = null);

(statearr_59228_59292[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (10))){
var inst_59037 = (state_59157[(16)]);
var inst_59035 = (state_59157[(17)]);
var inst_59045 = cljs.core._nth.call(null,inst_59035,inst_59037);
var inst_59046 = cljs.core.nth.call(null,inst_59045,(0),null);
var inst_59047 = cljs.core.nth.call(null,inst_59045,(1),null);
var state_59157__$1 = (function (){var statearr_59229 = state_59157;
(statearr_59229[(26)] = inst_59046);

return statearr_59229;
})();
if(cljs.core.truth_(inst_59047)){
var statearr_59230_59293 = state_59157__$1;
(statearr_59230_59293[(1)] = (13));

} else {
var statearr_59231_59294 = state_59157__$1;
(statearr_59231_59294[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (18))){
var inst_59082 = (state_59157[(2)]);
var state_59157__$1 = state_59157;
var statearr_59232_59295 = state_59157__$1;
(statearr_59232_59295[(2)] = inst_59082);

(statearr_59232_59295[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (42))){
var state_59157__$1 = state_59157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59157__$1,(45),dchan);
} else {
if((state_val_59158 === (37))){
var inst_59125 = (state_59157[(23)]);
var inst_59116 = (state_59157[(25)]);
var inst_59025 = (state_59157[(10)]);
var inst_59125__$1 = cljs.core.first.call(null,inst_59116);
var inst_59126 = cljs.core.async.put_BANG_.call(null,inst_59125__$1,inst_59025,done);
var state_59157__$1 = (function (){var statearr_59233 = state_59157;
(statearr_59233[(23)] = inst_59125__$1);

return statearr_59233;
})();
if(cljs.core.truth_(inst_59126)){
var statearr_59234_59296 = state_59157__$1;
(statearr_59234_59296[(1)] = (39));

} else {
var statearr_59235_59297 = state_59157__$1;
(statearr_59235_59297[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59158 === (8))){
var inst_59036 = (state_59157[(14)]);
var inst_59037 = (state_59157[(16)]);
var inst_59039 = (inst_59037 < inst_59036);
var inst_59040 = inst_59039;
var state_59157__$1 = state_59157;
if(cljs.core.truth_(inst_59040)){
var statearr_59236_59298 = state_59157__$1;
(statearr_59236_59298[(1)] = (10));

} else {
var statearr_59237_59299 = state_59157__$1;
(statearr_59237_59299[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___59245,cs,m,dchan,dctr,done))
;
return ((function (switch__38195__auto__,c__38309__auto___59245,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__38196__auto__ = null;
var cljs$core$async$mult_$_state_machine__38196__auto____0 = (function (){
var statearr_59241 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59241[(0)] = cljs$core$async$mult_$_state_machine__38196__auto__);

(statearr_59241[(1)] = (1));

return statearr_59241;
});
var cljs$core$async$mult_$_state_machine__38196__auto____1 = (function (state_59157){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_59157);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e59242){if((e59242 instanceof Object)){
var ex__38199__auto__ = e59242;
var statearr_59243_59300 = state_59157;
(statearr_59243_59300[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59157);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59242;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59301 = state_59157;
state_59157 = G__59301;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__38196__auto__ = function(state_59157){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__38196__auto____1.call(this,state_59157);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__38196__auto____0;
cljs$core$async$mult_$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__38196__auto____1;
return cljs$core$async$mult_$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___59245,cs,m,dchan,dctr,done))
})();
var state__38311__auto__ = (function (){var statearr_59244 = f__38310__auto__.call(null);
(statearr_59244[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___59245);

return statearr_59244;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___59245,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args59302 = [];
var len__10640__auto___59305 = arguments.length;
var i__10641__auto___59306 = (0);
while(true){
if((i__10641__auto___59306 < len__10640__auto___59305)){
args59302.push((arguments[i__10641__auto___59306]));

var G__59307 = (i__10641__auto___59306 + (1));
i__10641__auto___59306 = G__59307;
continue;
} else {
}
break;
}

var G__59304 = args59302.length;
switch (G__59304) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59302.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m);
} else {
var m__10138__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,state_map);
} else {
var m__10138__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,mode);
} else {
var m__10138__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___59319 = arguments.length;
var i__10641__auto___59320 = (0);
while(true){
if((i__10641__auto___59320 < len__10640__auto___59319)){
args__10647__auto__.push((arguments[i__10641__auto___59320]));

var G__59321 = (i__10641__auto___59320 + (1));
i__10641__auto___59320 = G__59321;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((3) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10648__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__59313){
var map__59314 = p__59313;
var map__59314__$1 = ((((!((map__59314 == null)))?((((map__59314.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__59314.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__59314):map__59314);
var opts = map__59314__$1;
var statearr_59316_59322 = state;
(statearr_59316_59322[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6738__auto__ = cljs.core.async.do_alts.call(null,((function (map__59314,map__59314__$1,opts){
return (function (val){
var statearr_59317_59323 = state;
(statearr_59317_59323[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__59314,map__59314__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6738__auto__)){
var cb = temp__6738__auto__;
var statearr_59318_59324 = state;
(statearr_59318_59324[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq59309){
var G__59310 = cljs.core.first.call(null,seq59309);
var seq59309__$1 = cljs.core.next.call(null,seq59309);
var G__59311 = cljs.core.first.call(null,seq59309__$1);
var seq59309__$2 = cljs.core.next.call(null,seq59309__$1);
var G__59312 = cljs.core.first.call(null,seq59309__$2);
var seq59309__$3 = cljs.core.next.call(null,seq59309__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__59310,G__59311,G__59312,seq59309__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async59492 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async59492 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta59493){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta59493 = meta59493;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async59492.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_59494,meta59493__$1){
var self__ = this;
var _59494__$1 = this;
return (new cljs.core.async.t_cljs$core$async59492(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta59493__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59492.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_59494){
var self__ = this;
var _59494__$1 = this;
return self__.meta59493;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59492.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59492.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59492.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59492.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59492.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59492.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59492.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59492.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59492.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta59493","meta59493",197468475,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59492.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async59492.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async59492";

cljs.core.async.t_cljs$core$async59492.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async59492");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async59492 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async59492(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta59493){
return (new cljs.core.async.t_cljs$core$async59492(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta59493));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async59492(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__38309__auto___59659 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___59659,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___59659,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_59596){
var state_val_59597 = (state_59596[(1)]);
if((state_val_59597 === (7))){
var inst_59511 = (state_59596[(2)]);
var state_59596__$1 = state_59596;
var statearr_59598_59660 = state_59596__$1;
(statearr_59598_59660[(2)] = inst_59511);

(statearr_59598_59660[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (20))){
var inst_59523 = (state_59596[(7)]);
var state_59596__$1 = state_59596;
var statearr_59599_59661 = state_59596__$1;
(statearr_59599_59661[(2)] = inst_59523);

(statearr_59599_59661[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (27))){
var state_59596__$1 = state_59596;
var statearr_59600_59662 = state_59596__$1;
(statearr_59600_59662[(2)] = null);

(statearr_59600_59662[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (1))){
var inst_59498 = (state_59596[(8)]);
var inst_59498__$1 = calc_state.call(null);
var inst_59500 = (inst_59498__$1 == null);
var inst_59501 = cljs.core.not.call(null,inst_59500);
var state_59596__$1 = (function (){var statearr_59601 = state_59596;
(statearr_59601[(8)] = inst_59498__$1);

return statearr_59601;
})();
if(inst_59501){
var statearr_59602_59663 = state_59596__$1;
(statearr_59602_59663[(1)] = (2));

} else {
var statearr_59603_59664 = state_59596__$1;
(statearr_59603_59664[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (24))){
var inst_59556 = (state_59596[(9)]);
var inst_59570 = (state_59596[(10)]);
var inst_59547 = (state_59596[(11)]);
var inst_59570__$1 = inst_59547.call(null,inst_59556);
var state_59596__$1 = (function (){var statearr_59604 = state_59596;
(statearr_59604[(10)] = inst_59570__$1);

return statearr_59604;
})();
if(cljs.core.truth_(inst_59570__$1)){
var statearr_59605_59665 = state_59596__$1;
(statearr_59605_59665[(1)] = (29));

} else {
var statearr_59606_59666 = state_59596__$1;
(statearr_59606_59666[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (4))){
var inst_59514 = (state_59596[(2)]);
var state_59596__$1 = state_59596;
if(cljs.core.truth_(inst_59514)){
var statearr_59607_59667 = state_59596__$1;
(statearr_59607_59667[(1)] = (8));

} else {
var statearr_59608_59668 = state_59596__$1;
(statearr_59608_59668[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (15))){
var inst_59541 = (state_59596[(2)]);
var state_59596__$1 = state_59596;
if(cljs.core.truth_(inst_59541)){
var statearr_59609_59669 = state_59596__$1;
(statearr_59609_59669[(1)] = (19));

} else {
var statearr_59610_59670 = state_59596__$1;
(statearr_59610_59670[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (21))){
var inst_59546 = (state_59596[(12)]);
var inst_59546__$1 = (state_59596[(2)]);
var inst_59547 = cljs.core.get.call(null,inst_59546__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_59548 = cljs.core.get.call(null,inst_59546__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_59549 = cljs.core.get.call(null,inst_59546__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_59596__$1 = (function (){var statearr_59611 = state_59596;
(statearr_59611[(13)] = inst_59548);

(statearr_59611[(12)] = inst_59546__$1);

(statearr_59611[(11)] = inst_59547);

return statearr_59611;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_59596__$1,(22),inst_59549);
} else {
if((state_val_59597 === (31))){
var inst_59578 = (state_59596[(2)]);
var state_59596__$1 = state_59596;
if(cljs.core.truth_(inst_59578)){
var statearr_59612_59671 = state_59596__$1;
(statearr_59612_59671[(1)] = (32));

} else {
var statearr_59613_59672 = state_59596__$1;
(statearr_59613_59672[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (32))){
var inst_59555 = (state_59596[(14)]);
var state_59596__$1 = state_59596;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59596__$1,(35),out,inst_59555);
} else {
if((state_val_59597 === (33))){
var inst_59546 = (state_59596[(12)]);
var inst_59523 = inst_59546;
var state_59596__$1 = (function (){var statearr_59614 = state_59596;
(statearr_59614[(7)] = inst_59523);

return statearr_59614;
})();
var statearr_59615_59673 = state_59596__$1;
(statearr_59615_59673[(2)] = null);

(statearr_59615_59673[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (13))){
var inst_59523 = (state_59596[(7)]);
var inst_59530 = inst_59523.cljs$lang$protocol_mask$partition0$;
var inst_59531 = (inst_59530 & (64));
var inst_59532 = inst_59523.cljs$core$ISeq$;
var inst_59533 = (cljs.core.PROTOCOL_SENTINEL === inst_59532);
var inst_59534 = (inst_59531) || (inst_59533);
var state_59596__$1 = state_59596;
if(cljs.core.truth_(inst_59534)){
var statearr_59616_59674 = state_59596__$1;
(statearr_59616_59674[(1)] = (16));

} else {
var statearr_59617_59675 = state_59596__$1;
(statearr_59617_59675[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (22))){
var inst_59556 = (state_59596[(9)]);
var inst_59555 = (state_59596[(14)]);
var inst_59554 = (state_59596[(2)]);
var inst_59555__$1 = cljs.core.nth.call(null,inst_59554,(0),null);
var inst_59556__$1 = cljs.core.nth.call(null,inst_59554,(1),null);
var inst_59557 = (inst_59555__$1 == null);
var inst_59558 = cljs.core._EQ_.call(null,inst_59556__$1,change);
var inst_59559 = (inst_59557) || (inst_59558);
var state_59596__$1 = (function (){var statearr_59618 = state_59596;
(statearr_59618[(9)] = inst_59556__$1);

(statearr_59618[(14)] = inst_59555__$1);

return statearr_59618;
})();
if(cljs.core.truth_(inst_59559)){
var statearr_59619_59676 = state_59596__$1;
(statearr_59619_59676[(1)] = (23));

} else {
var statearr_59620_59677 = state_59596__$1;
(statearr_59620_59677[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (36))){
var inst_59546 = (state_59596[(12)]);
var inst_59523 = inst_59546;
var state_59596__$1 = (function (){var statearr_59621 = state_59596;
(statearr_59621[(7)] = inst_59523);

return statearr_59621;
})();
var statearr_59622_59678 = state_59596__$1;
(statearr_59622_59678[(2)] = null);

(statearr_59622_59678[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (29))){
var inst_59570 = (state_59596[(10)]);
var state_59596__$1 = state_59596;
var statearr_59623_59679 = state_59596__$1;
(statearr_59623_59679[(2)] = inst_59570);

(statearr_59623_59679[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (6))){
var state_59596__$1 = state_59596;
var statearr_59624_59680 = state_59596__$1;
(statearr_59624_59680[(2)] = false);

(statearr_59624_59680[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (28))){
var inst_59566 = (state_59596[(2)]);
var inst_59567 = calc_state.call(null);
var inst_59523 = inst_59567;
var state_59596__$1 = (function (){var statearr_59625 = state_59596;
(statearr_59625[(15)] = inst_59566);

(statearr_59625[(7)] = inst_59523);

return statearr_59625;
})();
var statearr_59626_59681 = state_59596__$1;
(statearr_59626_59681[(2)] = null);

(statearr_59626_59681[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (25))){
var inst_59592 = (state_59596[(2)]);
var state_59596__$1 = state_59596;
var statearr_59627_59682 = state_59596__$1;
(statearr_59627_59682[(2)] = inst_59592);

(statearr_59627_59682[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (34))){
var inst_59590 = (state_59596[(2)]);
var state_59596__$1 = state_59596;
var statearr_59628_59683 = state_59596__$1;
(statearr_59628_59683[(2)] = inst_59590);

(statearr_59628_59683[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (17))){
var state_59596__$1 = state_59596;
var statearr_59629_59684 = state_59596__$1;
(statearr_59629_59684[(2)] = false);

(statearr_59629_59684[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (3))){
var state_59596__$1 = state_59596;
var statearr_59630_59685 = state_59596__$1;
(statearr_59630_59685[(2)] = false);

(statearr_59630_59685[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (12))){
var inst_59594 = (state_59596[(2)]);
var state_59596__$1 = state_59596;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59596__$1,inst_59594);
} else {
if((state_val_59597 === (2))){
var inst_59498 = (state_59596[(8)]);
var inst_59503 = inst_59498.cljs$lang$protocol_mask$partition0$;
var inst_59504 = (inst_59503 & (64));
var inst_59505 = inst_59498.cljs$core$ISeq$;
var inst_59506 = (cljs.core.PROTOCOL_SENTINEL === inst_59505);
var inst_59507 = (inst_59504) || (inst_59506);
var state_59596__$1 = state_59596;
if(cljs.core.truth_(inst_59507)){
var statearr_59631_59686 = state_59596__$1;
(statearr_59631_59686[(1)] = (5));

} else {
var statearr_59632_59687 = state_59596__$1;
(statearr_59632_59687[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (23))){
var inst_59555 = (state_59596[(14)]);
var inst_59561 = (inst_59555 == null);
var state_59596__$1 = state_59596;
if(cljs.core.truth_(inst_59561)){
var statearr_59633_59688 = state_59596__$1;
(statearr_59633_59688[(1)] = (26));

} else {
var statearr_59634_59689 = state_59596__$1;
(statearr_59634_59689[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (35))){
var inst_59581 = (state_59596[(2)]);
var state_59596__$1 = state_59596;
if(cljs.core.truth_(inst_59581)){
var statearr_59635_59690 = state_59596__$1;
(statearr_59635_59690[(1)] = (36));

} else {
var statearr_59636_59691 = state_59596__$1;
(statearr_59636_59691[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (19))){
var inst_59523 = (state_59596[(7)]);
var inst_59543 = cljs.core.apply.call(null,cljs.core.hash_map,inst_59523);
var state_59596__$1 = state_59596;
var statearr_59637_59692 = state_59596__$1;
(statearr_59637_59692[(2)] = inst_59543);

(statearr_59637_59692[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (11))){
var inst_59523 = (state_59596[(7)]);
var inst_59527 = (inst_59523 == null);
var inst_59528 = cljs.core.not.call(null,inst_59527);
var state_59596__$1 = state_59596;
if(inst_59528){
var statearr_59638_59693 = state_59596__$1;
(statearr_59638_59693[(1)] = (13));

} else {
var statearr_59639_59694 = state_59596__$1;
(statearr_59639_59694[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (9))){
var inst_59498 = (state_59596[(8)]);
var state_59596__$1 = state_59596;
var statearr_59640_59695 = state_59596__$1;
(statearr_59640_59695[(2)] = inst_59498);

(statearr_59640_59695[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (5))){
var state_59596__$1 = state_59596;
var statearr_59641_59696 = state_59596__$1;
(statearr_59641_59696[(2)] = true);

(statearr_59641_59696[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (14))){
var state_59596__$1 = state_59596;
var statearr_59642_59697 = state_59596__$1;
(statearr_59642_59697[(2)] = false);

(statearr_59642_59697[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (26))){
var inst_59556 = (state_59596[(9)]);
var inst_59563 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_59556);
var state_59596__$1 = state_59596;
var statearr_59643_59698 = state_59596__$1;
(statearr_59643_59698[(2)] = inst_59563);

(statearr_59643_59698[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (16))){
var state_59596__$1 = state_59596;
var statearr_59644_59699 = state_59596__$1;
(statearr_59644_59699[(2)] = true);

(statearr_59644_59699[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (38))){
var inst_59586 = (state_59596[(2)]);
var state_59596__$1 = state_59596;
var statearr_59645_59700 = state_59596__$1;
(statearr_59645_59700[(2)] = inst_59586);

(statearr_59645_59700[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (30))){
var inst_59556 = (state_59596[(9)]);
var inst_59548 = (state_59596[(13)]);
var inst_59547 = (state_59596[(11)]);
var inst_59573 = cljs.core.empty_QMARK_.call(null,inst_59547);
var inst_59574 = inst_59548.call(null,inst_59556);
var inst_59575 = cljs.core.not.call(null,inst_59574);
var inst_59576 = (inst_59573) && (inst_59575);
var state_59596__$1 = state_59596;
var statearr_59646_59701 = state_59596__$1;
(statearr_59646_59701[(2)] = inst_59576);

(statearr_59646_59701[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (10))){
var inst_59498 = (state_59596[(8)]);
var inst_59519 = (state_59596[(2)]);
var inst_59520 = cljs.core.get.call(null,inst_59519,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_59521 = cljs.core.get.call(null,inst_59519,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_59522 = cljs.core.get.call(null,inst_59519,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_59523 = inst_59498;
var state_59596__$1 = (function (){var statearr_59647 = state_59596;
(statearr_59647[(7)] = inst_59523);

(statearr_59647[(16)] = inst_59521);

(statearr_59647[(17)] = inst_59522);

(statearr_59647[(18)] = inst_59520);

return statearr_59647;
})();
var statearr_59648_59702 = state_59596__$1;
(statearr_59648_59702[(2)] = null);

(statearr_59648_59702[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (18))){
var inst_59538 = (state_59596[(2)]);
var state_59596__$1 = state_59596;
var statearr_59649_59703 = state_59596__$1;
(statearr_59649_59703[(2)] = inst_59538);

(statearr_59649_59703[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (37))){
var state_59596__$1 = state_59596;
var statearr_59650_59704 = state_59596__$1;
(statearr_59650_59704[(2)] = null);

(statearr_59650_59704[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59597 === (8))){
var inst_59498 = (state_59596[(8)]);
var inst_59516 = cljs.core.apply.call(null,cljs.core.hash_map,inst_59498);
var state_59596__$1 = state_59596;
var statearr_59651_59705 = state_59596__$1;
(statearr_59651_59705[(2)] = inst_59516);

(statearr_59651_59705[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___59659,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__38195__auto__,c__38309__auto___59659,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__38196__auto__ = null;
var cljs$core$async$mix_$_state_machine__38196__auto____0 = (function (){
var statearr_59655 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59655[(0)] = cljs$core$async$mix_$_state_machine__38196__auto__);

(statearr_59655[(1)] = (1));

return statearr_59655;
});
var cljs$core$async$mix_$_state_machine__38196__auto____1 = (function (state_59596){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_59596);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e59656){if((e59656 instanceof Object)){
var ex__38199__auto__ = e59656;
var statearr_59657_59706 = state_59596;
(statearr_59657_59706[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59596);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59656;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59707 = state_59596;
state_59596 = G__59707;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__38196__auto__ = function(state_59596){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__38196__auto____1.call(this,state_59596);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__38196__auto____0;
cljs$core$async$mix_$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__38196__auto____1;
return cljs$core$async$mix_$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___59659,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__38311__auto__ = (function (){var statearr_59658 = f__38310__auto__.call(null);
(statearr_59658[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___59659);

return statearr_59658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___59659,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__10138__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p,v,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args59708 = [];
var len__10640__auto___59711 = arguments.length;
var i__10641__auto___59712 = (0);
while(true){
if((i__10641__auto___59712 < len__10640__auto___59711)){
args59708.push((arguments[i__10641__auto___59712]));

var G__59713 = (i__10641__auto___59712 + (1));
i__10641__auto___59712 = G__59713;
continue;
} else {
}
break;
}

var G__59710 = args59708.length;
switch (G__59710) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59708.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p);
} else {
var m__10138__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p,v);
} else {
var m__10138__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args59716 = [];
var len__10640__auto___59841 = arguments.length;
var i__10641__auto___59842 = (0);
while(true){
if((i__10641__auto___59842 < len__10640__auto___59841)){
args59716.push((arguments[i__10641__auto___59842]));

var G__59843 = (i__10641__auto___59842 + (1));
i__10641__auto___59842 = G__59843;
continue;
} else {
}
break;
}

var G__59718 = args59716.length;
switch (G__59718) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59716.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__9419__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__9419__auto__,mults){
return (function (p1__59715_SHARP_){
if(cljs.core.truth_(p1__59715_SHARP_.call(null,topic))){
return p1__59715_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__59715_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__9419__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async59719 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async59719 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta59720){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta59720 = meta59720;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async59719.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_59721,meta59720__$1){
var self__ = this;
var _59721__$1 = this;
return (new cljs.core.async.t_cljs$core$async59719(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta59720__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59719.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_59721){
var self__ = this;
var _59721__$1 = this;
return self__.meta59720;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59719.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59719.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59719.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59719.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59719.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6738__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6738__auto__)){
var m = temp__6738__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59719.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59719.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59719.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta59720","meta59720",286702335,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59719.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async59719.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async59719";

cljs.core.async.t_cljs$core$async59719.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async59719");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async59719 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async59719(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta59720){
return (new cljs.core.async.t_cljs$core$async59719(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta59720));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async59719(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__38309__auto___59845 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___59845,mults,ensure_mult,p){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___59845,mults,ensure_mult,p){
return (function (state_59793){
var state_val_59794 = (state_59793[(1)]);
if((state_val_59794 === (7))){
var inst_59789 = (state_59793[(2)]);
var state_59793__$1 = state_59793;
var statearr_59795_59846 = state_59793__$1;
(statearr_59795_59846[(2)] = inst_59789);

(statearr_59795_59846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (20))){
var state_59793__$1 = state_59793;
var statearr_59796_59847 = state_59793__$1;
(statearr_59796_59847[(2)] = null);

(statearr_59796_59847[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (1))){
var state_59793__$1 = state_59793;
var statearr_59797_59848 = state_59793__$1;
(statearr_59797_59848[(2)] = null);

(statearr_59797_59848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (24))){
var inst_59772 = (state_59793[(7)]);
var inst_59781 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_59772);
var state_59793__$1 = state_59793;
var statearr_59798_59849 = state_59793__$1;
(statearr_59798_59849[(2)] = inst_59781);

(statearr_59798_59849[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (4))){
var inst_59724 = (state_59793[(8)]);
var inst_59724__$1 = (state_59793[(2)]);
var inst_59725 = (inst_59724__$1 == null);
var state_59793__$1 = (function (){var statearr_59799 = state_59793;
(statearr_59799[(8)] = inst_59724__$1);

return statearr_59799;
})();
if(cljs.core.truth_(inst_59725)){
var statearr_59800_59850 = state_59793__$1;
(statearr_59800_59850[(1)] = (5));

} else {
var statearr_59801_59851 = state_59793__$1;
(statearr_59801_59851[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (15))){
var inst_59766 = (state_59793[(2)]);
var state_59793__$1 = state_59793;
var statearr_59802_59852 = state_59793__$1;
(statearr_59802_59852[(2)] = inst_59766);

(statearr_59802_59852[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (21))){
var inst_59786 = (state_59793[(2)]);
var state_59793__$1 = (function (){var statearr_59803 = state_59793;
(statearr_59803[(9)] = inst_59786);

return statearr_59803;
})();
var statearr_59804_59853 = state_59793__$1;
(statearr_59804_59853[(2)] = null);

(statearr_59804_59853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (13))){
var inst_59748 = (state_59793[(10)]);
var inst_59750 = cljs.core.chunked_seq_QMARK_.call(null,inst_59748);
var state_59793__$1 = state_59793;
if(inst_59750){
var statearr_59805_59854 = state_59793__$1;
(statearr_59805_59854[(1)] = (16));

} else {
var statearr_59806_59855 = state_59793__$1;
(statearr_59806_59855[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (22))){
var inst_59778 = (state_59793[(2)]);
var state_59793__$1 = state_59793;
if(cljs.core.truth_(inst_59778)){
var statearr_59807_59856 = state_59793__$1;
(statearr_59807_59856[(1)] = (23));

} else {
var statearr_59808_59857 = state_59793__$1;
(statearr_59808_59857[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (6))){
var inst_59772 = (state_59793[(7)]);
var inst_59724 = (state_59793[(8)]);
var inst_59774 = (state_59793[(11)]);
var inst_59772__$1 = topic_fn.call(null,inst_59724);
var inst_59773 = cljs.core.deref.call(null,mults);
var inst_59774__$1 = cljs.core.get.call(null,inst_59773,inst_59772__$1);
var state_59793__$1 = (function (){var statearr_59809 = state_59793;
(statearr_59809[(7)] = inst_59772__$1);

(statearr_59809[(11)] = inst_59774__$1);

return statearr_59809;
})();
if(cljs.core.truth_(inst_59774__$1)){
var statearr_59810_59858 = state_59793__$1;
(statearr_59810_59858[(1)] = (19));

} else {
var statearr_59811_59859 = state_59793__$1;
(statearr_59811_59859[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (25))){
var inst_59783 = (state_59793[(2)]);
var state_59793__$1 = state_59793;
var statearr_59812_59860 = state_59793__$1;
(statearr_59812_59860[(2)] = inst_59783);

(statearr_59812_59860[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (17))){
var inst_59748 = (state_59793[(10)]);
var inst_59757 = cljs.core.first.call(null,inst_59748);
var inst_59758 = cljs.core.async.muxch_STAR_.call(null,inst_59757);
var inst_59759 = cljs.core.async.close_BANG_.call(null,inst_59758);
var inst_59760 = cljs.core.next.call(null,inst_59748);
var inst_59734 = inst_59760;
var inst_59735 = null;
var inst_59736 = (0);
var inst_59737 = (0);
var state_59793__$1 = (function (){var statearr_59813 = state_59793;
(statearr_59813[(12)] = inst_59737);

(statearr_59813[(13)] = inst_59736);

(statearr_59813[(14)] = inst_59734);

(statearr_59813[(15)] = inst_59735);

(statearr_59813[(16)] = inst_59759);

return statearr_59813;
})();
var statearr_59814_59861 = state_59793__$1;
(statearr_59814_59861[(2)] = null);

(statearr_59814_59861[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (3))){
var inst_59791 = (state_59793[(2)]);
var state_59793__$1 = state_59793;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59793__$1,inst_59791);
} else {
if((state_val_59794 === (12))){
var inst_59768 = (state_59793[(2)]);
var state_59793__$1 = state_59793;
var statearr_59815_59862 = state_59793__$1;
(statearr_59815_59862[(2)] = inst_59768);

(statearr_59815_59862[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (2))){
var state_59793__$1 = state_59793;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59793__$1,(4),ch);
} else {
if((state_val_59794 === (23))){
var state_59793__$1 = state_59793;
var statearr_59816_59863 = state_59793__$1;
(statearr_59816_59863[(2)] = null);

(statearr_59816_59863[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (19))){
var inst_59724 = (state_59793[(8)]);
var inst_59774 = (state_59793[(11)]);
var inst_59776 = cljs.core.async.muxch_STAR_.call(null,inst_59774);
var state_59793__$1 = state_59793;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59793__$1,(22),inst_59776,inst_59724);
} else {
if((state_val_59794 === (11))){
var inst_59734 = (state_59793[(14)]);
var inst_59748 = (state_59793[(10)]);
var inst_59748__$1 = cljs.core.seq.call(null,inst_59734);
var state_59793__$1 = (function (){var statearr_59817 = state_59793;
(statearr_59817[(10)] = inst_59748__$1);

return statearr_59817;
})();
if(inst_59748__$1){
var statearr_59818_59864 = state_59793__$1;
(statearr_59818_59864[(1)] = (13));

} else {
var statearr_59819_59865 = state_59793__$1;
(statearr_59819_59865[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (9))){
var inst_59770 = (state_59793[(2)]);
var state_59793__$1 = state_59793;
var statearr_59820_59866 = state_59793__$1;
(statearr_59820_59866[(2)] = inst_59770);

(statearr_59820_59866[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (5))){
var inst_59731 = cljs.core.deref.call(null,mults);
var inst_59732 = cljs.core.vals.call(null,inst_59731);
var inst_59733 = cljs.core.seq.call(null,inst_59732);
var inst_59734 = inst_59733;
var inst_59735 = null;
var inst_59736 = (0);
var inst_59737 = (0);
var state_59793__$1 = (function (){var statearr_59821 = state_59793;
(statearr_59821[(12)] = inst_59737);

(statearr_59821[(13)] = inst_59736);

(statearr_59821[(14)] = inst_59734);

(statearr_59821[(15)] = inst_59735);

return statearr_59821;
})();
var statearr_59822_59867 = state_59793__$1;
(statearr_59822_59867[(2)] = null);

(statearr_59822_59867[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (14))){
var state_59793__$1 = state_59793;
var statearr_59826_59868 = state_59793__$1;
(statearr_59826_59868[(2)] = null);

(statearr_59826_59868[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (16))){
var inst_59748 = (state_59793[(10)]);
var inst_59752 = cljs.core.chunk_first.call(null,inst_59748);
var inst_59753 = cljs.core.chunk_rest.call(null,inst_59748);
var inst_59754 = cljs.core.count.call(null,inst_59752);
var inst_59734 = inst_59753;
var inst_59735 = inst_59752;
var inst_59736 = inst_59754;
var inst_59737 = (0);
var state_59793__$1 = (function (){var statearr_59827 = state_59793;
(statearr_59827[(12)] = inst_59737);

(statearr_59827[(13)] = inst_59736);

(statearr_59827[(14)] = inst_59734);

(statearr_59827[(15)] = inst_59735);

return statearr_59827;
})();
var statearr_59828_59869 = state_59793__$1;
(statearr_59828_59869[(2)] = null);

(statearr_59828_59869[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (10))){
var inst_59737 = (state_59793[(12)]);
var inst_59736 = (state_59793[(13)]);
var inst_59734 = (state_59793[(14)]);
var inst_59735 = (state_59793[(15)]);
var inst_59742 = cljs.core._nth.call(null,inst_59735,inst_59737);
var inst_59743 = cljs.core.async.muxch_STAR_.call(null,inst_59742);
var inst_59744 = cljs.core.async.close_BANG_.call(null,inst_59743);
var inst_59745 = (inst_59737 + (1));
var tmp59823 = inst_59736;
var tmp59824 = inst_59734;
var tmp59825 = inst_59735;
var inst_59734__$1 = tmp59824;
var inst_59735__$1 = tmp59825;
var inst_59736__$1 = tmp59823;
var inst_59737__$1 = inst_59745;
var state_59793__$1 = (function (){var statearr_59829 = state_59793;
(statearr_59829[(17)] = inst_59744);

(statearr_59829[(12)] = inst_59737__$1);

(statearr_59829[(13)] = inst_59736__$1);

(statearr_59829[(14)] = inst_59734__$1);

(statearr_59829[(15)] = inst_59735__$1);

return statearr_59829;
})();
var statearr_59830_59870 = state_59793__$1;
(statearr_59830_59870[(2)] = null);

(statearr_59830_59870[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (18))){
var inst_59763 = (state_59793[(2)]);
var state_59793__$1 = state_59793;
var statearr_59831_59871 = state_59793__$1;
(statearr_59831_59871[(2)] = inst_59763);

(statearr_59831_59871[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59794 === (8))){
var inst_59737 = (state_59793[(12)]);
var inst_59736 = (state_59793[(13)]);
var inst_59739 = (inst_59737 < inst_59736);
var inst_59740 = inst_59739;
var state_59793__$1 = state_59793;
if(cljs.core.truth_(inst_59740)){
var statearr_59832_59872 = state_59793__$1;
(statearr_59832_59872[(1)] = (10));

} else {
var statearr_59833_59873 = state_59793__$1;
(statearr_59833_59873[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___59845,mults,ensure_mult,p))
;
return ((function (switch__38195__auto__,c__38309__auto___59845,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_59837 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59837[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_59837[(1)] = (1));

return statearr_59837;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_59793){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_59793);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e59838){if((e59838 instanceof Object)){
var ex__38199__auto__ = e59838;
var statearr_59839_59874 = state_59793;
(statearr_59839_59874[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59793);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59838;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59875 = state_59793;
state_59793 = G__59875;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_59793){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_59793);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___59845,mults,ensure_mult,p))
})();
var state__38311__auto__ = (function (){var statearr_59840 = f__38310__auto__.call(null);
(statearr_59840[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___59845);

return statearr_59840;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___59845,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args59876 = [];
var len__10640__auto___59879 = arguments.length;
var i__10641__auto___59880 = (0);
while(true){
if((i__10641__auto___59880 < len__10640__auto___59879)){
args59876.push((arguments[i__10641__auto___59880]));

var G__59881 = (i__10641__auto___59880 + (1));
i__10641__auto___59880 = G__59881;
continue;
} else {
}
break;
}

var G__59878 = args59876.length;
switch (G__59878) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59876.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args59883 = [];
var len__10640__auto___59886 = arguments.length;
var i__10641__auto___59887 = (0);
while(true){
if((i__10641__auto___59887 < len__10640__auto___59886)){
args59883.push((arguments[i__10641__auto___59887]));

var G__59888 = (i__10641__auto___59887 + (1));
i__10641__auto___59887 = G__59888;
continue;
} else {
}
break;
}

var G__59885 = args59883.length;
switch (G__59885) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59883.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args59890 = [];
var len__10640__auto___59961 = arguments.length;
var i__10641__auto___59962 = (0);
while(true){
if((i__10641__auto___59962 < len__10640__auto___59961)){
args59890.push((arguments[i__10641__auto___59962]));

var G__59963 = (i__10641__auto___59962 + (1));
i__10641__auto___59962 = G__59963;
continue;
} else {
}
break;
}

var G__59892 = args59890.length;
switch (G__59892) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59890.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__38309__auto___59965 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___59965,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___59965,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_59931){
var state_val_59932 = (state_59931[(1)]);
if((state_val_59932 === (7))){
var state_59931__$1 = state_59931;
var statearr_59933_59966 = state_59931__$1;
(statearr_59933_59966[(2)] = null);

(statearr_59933_59966[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59932 === (1))){
var state_59931__$1 = state_59931;
var statearr_59934_59967 = state_59931__$1;
(statearr_59934_59967[(2)] = null);

(statearr_59934_59967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59932 === (4))){
var inst_59895 = (state_59931[(7)]);
var inst_59897 = (inst_59895 < cnt);
var state_59931__$1 = state_59931;
if(cljs.core.truth_(inst_59897)){
var statearr_59935_59968 = state_59931__$1;
(statearr_59935_59968[(1)] = (6));

} else {
var statearr_59936_59969 = state_59931__$1;
(statearr_59936_59969[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59932 === (15))){
var inst_59927 = (state_59931[(2)]);
var state_59931__$1 = state_59931;
var statearr_59937_59970 = state_59931__$1;
(statearr_59937_59970[(2)] = inst_59927);

(statearr_59937_59970[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59932 === (13))){
var inst_59920 = cljs.core.async.close_BANG_.call(null,out);
var state_59931__$1 = state_59931;
var statearr_59938_59971 = state_59931__$1;
(statearr_59938_59971[(2)] = inst_59920);

(statearr_59938_59971[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59932 === (6))){
var state_59931__$1 = state_59931;
var statearr_59939_59972 = state_59931__$1;
(statearr_59939_59972[(2)] = null);

(statearr_59939_59972[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59932 === (3))){
var inst_59929 = (state_59931[(2)]);
var state_59931__$1 = state_59931;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59931__$1,inst_59929);
} else {
if((state_val_59932 === (12))){
var inst_59917 = (state_59931[(8)]);
var inst_59917__$1 = (state_59931[(2)]);
var inst_59918 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_59917__$1);
var state_59931__$1 = (function (){var statearr_59940 = state_59931;
(statearr_59940[(8)] = inst_59917__$1);

return statearr_59940;
})();
if(cljs.core.truth_(inst_59918)){
var statearr_59941_59973 = state_59931__$1;
(statearr_59941_59973[(1)] = (13));

} else {
var statearr_59942_59974 = state_59931__$1;
(statearr_59942_59974[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59932 === (2))){
var inst_59894 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_59895 = (0);
var state_59931__$1 = (function (){var statearr_59943 = state_59931;
(statearr_59943[(7)] = inst_59895);

(statearr_59943[(9)] = inst_59894);

return statearr_59943;
})();
var statearr_59944_59975 = state_59931__$1;
(statearr_59944_59975[(2)] = null);

(statearr_59944_59975[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59932 === (11))){
var inst_59895 = (state_59931[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_59931,(10),Object,null,(9));
var inst_59904 = chs__$1.call(null,inst_59895);
var inst_59905 = done.call(null,inst_59895);
var inst_59906 = cljs.core.async.take_BANG_.call(null,inst_59904,inst_59905);
var state_59931__$1 = state_59931;
var statearr_59945_59976 = state_59931__$1;
(statearr_59945_59976[(2)] = inst_59906);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59931__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59932 === (9))){
var inst_59895 = (state_59931[(7)]);
var inst_59908 = (state_59931[(2)]);
var inst_59909 = (inst_59895 + (1));
var inst_59895__$1 = inst_59909;
var state_59931__$1 = (function (){var statearr_59946 = state_59931;
(statearr_59946[(10)] = inst_59908);

(statearr_59946[(7)] = inst_59895__$1);

return statearr_59946;
})();
var statearr_59947_59977 = state_59931__$1;
(statearr_59947_59977[(2)] = null);

(statearr_59947_59977[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59932 === (5))){
var inst_59915 = (state_59931[(2)]);
var state_59931__$1 = (function (){var statearr_59948 = state_59931;
(statearr_59948[(11)] = inst_59915);

return statearr_59948;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59931__$1,(12),dchan);
} else {
if((state_val_59932 === (14))){
var inst_59917 = (state_59931[(8)]);
var inst_59922 = cljs.core.apply.call(null,f,inst_59917);
var state_59931__$1 = state_59931;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59931__$1,(16),out,inst_59922);
} else {
if((state_val_59932 === (16))){
var inst_59924 = (state_59931[(2)]);
var state_59931__$1 = (function (){var statearr_59949 = state_59931;
(statearr_59949[(12)] = inst_59924);

return statearr_59949;
})();
var statearr_59950_59978 = state_59931__$1;
(statearr_59950_59978[(2)] = null);

(statearr_59950_59978[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59932 === (10))){
var inst_59899 = (state_59931[(2)]);
var inst_59900 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_59931__$1 = (function (){var statearr_59951 = state_59931;
(statearr_59951[(13)] = inst_59899);

return statearr_59951;
})();
var statearr_59952_59979 = state_59931__$1;
(statearr_59952_59979[(2)] = inst_59900);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59931__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59932 === (8))){
var inst_59913 = (state_59931[(2)]);
var state_59931__$1 = state_59931;
var statearr_59953_59980 = state_59931__$1;
(statearr_59953_59980[(2)] = inst_59913);

(statearr_59953_59980[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___59965,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__38195__auto__,c__38309__auto___59965,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_59957 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59957[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_59957[(1)] = (1));

return statearr_59957;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_59931){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_59931);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e59958){if((e59958 instanceof Object)){
var ex__38199__auto__ = e59958;
var statearr_59959_59981 = state_59931;
(statearr_59959_59981[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59931);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59958;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59982 = state_59931;
state_59931 = G__59982;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_59931){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_59931);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___59965,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__38311__auto__ = (function (){var statearr_59960 = f__38310__auto__.call(null);
(statearr_59960[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___59965);

return statearr_59960;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___59965,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args59984 = [];
var len__10640__auto___60042 = arguments.length;
var i__10641__auto___60043 = (0);
while(true){
if((i__10641__auto___60043 < len__10640__auto___60042)){
args59984.push((arguments[i__10641__auto___60043]));

var G__60044 = (i__10641__auto___60043 + (1));
i__10641__auto___60043 = G__60044;
continue;
} else {
}
break;
}

var G__59986 = args59984.length;
switch (G__59986) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59984.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38309__auto___60046 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___60046,out){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___60046,out){
return (function (state_60018){
var state_val_60019 = (state_60018[(1)]);
if((state_val_60019 === (7))){
var inst_59997 = (state_60018[(7)]);
var inst_59998 = (state_60018[(8)]);
var inst_59997__$1 = (state_60018[(2)]);
var inst_59998__$1 = cljs.core.nth.call(null,inst_59997__$1,(0),null);
var inst_59999 = cljs.core.nth.call(null,inst_59997__$1,(1),null);
var inst_60000 = (inst_59998__$1 == null);
var state_60018__$1 = (function (){var statearr_60020 = state_60018;
(statearr_60020[(9)] = inst_59999);

(statearr_60020[(7)] = inst_59997__$1);

(statearr_60020[(8)] = inst_59998__$1);

return statearr_60020;
})();
if(cljs.core.truth_(inst_60000)){
var statearr_60021_60047 = state_60018__$1;
(statearr_60021_60047[(1)] = (8));

} else {
var statearr_60022_60048 = state_60018__$1;
(statearr_60022_60048[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60019 === (1))){
var inst_59987 = cljs.core.vec.call(null,chs);
var inst_59988 = inst_59987;
var state_60018__$1 = (function (){var statearr_60023 = state_60018;
(statearr_60023[(10)] = inst_59988);

return statearr_60023;
})();
var statearr_60024_60049 = state_60018__$1;
(statearr_60024_60049[(2)] = null);

(statearr_60024_60049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60019 === (4))){
var inst_59988 = (state_60018[(10)]);
var state_60018__$1 = state_60018;
return cljs.core.async.ioc_alts_BANG_.call(null,state_60018__$1,(7),inst_59988);
} else {
if((state_val_60019 === (6))){
var inst_60014 = (state_60018[(2)]);
var state_60018__$1 = state_60018;
var statearr_60025_60050 = state_60018__$1;
(statearr_60025_60050[(2)] = inst_60014);

(statearr_60025_60050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60019 === (3))){
var inst_60016 = (state_60018[(2)]);
var state_60018__$1 = state_60018;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60018__$1,inst_60016);
} else {
if((state_val_60019 === (2))){
var inst_59988 = (state_60018[(10)]);
var inst_59990 = cljs.core.count.call(null,inst_59988);
var inst_59991 = (inst_59990 > (0));
var state_60018__$1 = state_60018;
if(cljs.core.truth_(inst_59991)){
var statearr_60027_60051 = state_60018__$1;
(statearr_60027_60051[(1)] = (4));

} else {
var statearr_60028_60052 = state_60018__$1;
(statearr_60028_60052[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60019 === (11))){
var inst_59988 = (state_60018[(10)]);
var inst_60007 = (state_60018[(2)]);
var tmp60026 = inst_59988;
var inst_59988__$1 = tmp60026;
var state_60018__$1 = (function (){var statearr_60029 = state_60018;
(statearr_60029[(10)] = inst_59988__$1);

(statearr_60029[(11)] = inst_60007);

return statearr_60029;
})();
var statearr_60030_60053 = state_60018__$1;
(statearr_60030_60053[(2)] = null);

(statearr_60030_60053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60019 === (9))){
var inst_59998 = (state_60018[(8)]);
var state_60018__$1 = state_60018;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60018__$1,(11),out,inst_59998);
} else {
if((state_val_60019 === (5))){
var inst_60012 = cljs.core.async.close_BANG_.call(null,out);
var state_60018__$1 = state_60018;
var statearr_60031_60054 = state_60018__$1;
(statearr_60031_60054[(2)] = inst_60012);

(statearr_60031_60054[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60019 === (10))){
var inst_60010 = (state_60018[(2)]);
var state_60018__$1 = state_60018;
var statearr_60032_60055 = state_60018__$1;
(statearr_60032_60055[(2)] = inst_60010);

(statearr_60032_60055[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60019 === (8))){
var inst_59999 = (state_60018[(9)]);
var inst_59997 = (state_60018[(7)]);
var inst_59988 = (state_60018[(10)]);
var inst_59998 = (state_60018[(8)]);
var inst_60002 = (function (){var cs = inst_59988;
var vec__59993 = inst_59997;
var v = inst_59998;
var c = inst_59999;
return ((function (cs,vec__59993,v,c,inst_59999,inst_59997,inst_59988,inst_59998,state_val_60019,c__38309__auto___60046,out){
return (function (p1__59983_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__59983_SHARP_);
});
;})(cs,vec__59993,v,c,inst_59999,inst_59997,inst_59988,inst_59998,state_val_60019,c__38309__auto___60046,out))
})();
var inst_60003 = cljs.core.filterv.call(null,inst_60002,inst_59988);
var inst_59988__$1 = inst_60003;
var state_60018__$1 = (function (){var statearr_60033 = state_60018;
(statearr_60033[(10)] = inst_59988__$1);

return statearr_60033;
})();
var statearr_60034_60056 = state_60018__$1;
(statearr_60034_60056[(2)] = null);

(statearr_60034_60056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___60046,out))
;
return ((function (switch__38195__auto__,c__38309__auto___60046,out){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_60038 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60038[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_60038[(1)] = (1));

return statearr_60038;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_60018){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_60018);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e60039){if((e60039 instanceof Object)){
var ex__38199__auto__ = e60039;
var statearr_60040_60057 = state_60018;
(statearr_60040_60057[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60018);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60039;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60058 = state_60018;
state_60018 = G__60058;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_60018){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_60018);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___60046,out))
})();
var state__38311__auto__ = (function (){var statearr_60041 = f__38310__auto__.call(null);
(statearr_60041[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___60046);

return statearr_60041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___60046,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args60059 = [];
var len__10640__auto___60108 = arguments.length;
var i__10641__auto___60109 = (0);
while(true){
if((i__10641__auto___60109 < len__10640__auto___60108)){
args60059.push((arguments[i__10641__auto___60109]));

var G__60110 = (i__10641__auto___60109 + (1));
i__10641__auto___60109 = G__60110;
continue;
} else {
}
break;
}

var G__60061 = args60059.length;
switch (G__60061) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60059.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38309__auto___60112 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___60112,out){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___60112,out){
return (function (state_60085){
var state_val_60086 = (state_60085[(1)]);
if((state_val_60086 === (7))){
var inst_60067 = (state_60085[(7)]);
var inst_60067__$1 = (state_60085[(2)]);
var inst_60068 = (inst_60067__$1 == null);
var inst_60069 = cljs.core.not.call(null,inst_60068);
var state_60085__$1 = (function (){var statearr_60087 = state_60085;
(statearr_60087[(7)] = inst_60067__$1);

return statearr_60087;
})();
if(inst_60069){
var statearr_60088_60113 = state_60085__$1;
(statearr_60088_60113[(1)] = (8));

} else {
var statearr_60089_60114 = state_60085__$1;
(statearr_60089_60114[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60086 === (1))){
var inst_60062 = (0);
var state_60085__$1 = (function (){var statearr_60090 = state_60085;
(statearr_60090[(8)] = inst_60062);

return statearr_60090;
})();
var statearr_60091_60115 = state_60085__$1;
(statearr_60091_60115[(2)] = null);

(statearr_60091_60115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60086 === (4))){
var state_60085__$1 = state_60085;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60085__$1,(7),ch);
} else {
if((state_val_60086 === (6))){
var inst_60080 = (state_60085[(2)]);
var state_60085__$1 = state_60085;
var statearr_60092_60116 = state_60085__$1;
(statearr_60092_60116[(2)] = inst_60080);

(statearr_60092_60116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60086 === (3))){
var inst_60082 = (state_60085[(2)]);
var inst_60083 = cljs.core.async.close_BANG_.call(null,out);
var state_60085__$1 = (function (){var statearr_60093 = state_60085;
(statearr_60093[(9)] = inst_60082);

return statearr_60093;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60085__$1,inst_60083);
} else {
if((state_val_60086 === (2))){
var inst_60062 = (state_60085[(8)]);
var inst_60064 = (inst_60062 < n);
var state_60085__$1 = state_60085;
if(cljs.core.truth_(inst_60064)){
var statearr_60094_60117 = state_60085__$1;
(statearr_60094_60117[(1)] = (4));

} else {
var statearr_60095_60118 = state_60085__$1;
(statearr_60095_60118[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60086 === (11))){
var inst_60062 = (state_60085[(8)]);
var inst_60072 = (state_60085[(2)]);
var inst_60073 = (inst_60062 + (1));
var inst_60062__$1 = inst_60073;
var state_60085__$1 = (function (){var statearr_60096 = state_60085;
(statearr_60096[(10)] = inst_60072);

(statearr_60096[(8)] = inst_60062__$1);

return statearr_60096;
})();
var statearr_60097_60119 = state_60085__$1;
(statearr_60097_60119[(2)] = null);

(statearr_60097_60119[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60086 === (9))){
var state_60085__$1 = state_60085;
var statearr_60098_60120 = state_60085__$1;
(statearr_60098_60120[(2)] = null);

(statearr_60098_60120[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60086 === (5))){
var state_60085__$1 = state_60085;
var statearr_60099_60121 = state_60085__$1;
(statearr_60099_60121[(2)] = null);

(statearr_60099_60121[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60086 === (10))){
var inst_60077 = (state_60085[(2)]);
var state_60085__$1 = state_60085;
var statearr_60100_60122 = state_60085__$1;
(statearr_60100_60122[(2)] = inst_60077);

(statearr_60100_60122[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60086 === (8))){
var inst_60067 = (state_60085[(7)]);
var state_60085__$1 = state_60085;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60085__$1,(11),out,inst_60067);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___60112,out))
;
return ((function (switch__38195__auto__,c__38309__auto___60112,out){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_60104 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_60104[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_60104[(1)] = (1));

return statearr_60104;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_60085){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_60085);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e60105){if((e60105 instanceof Object)){
var ex__38199__auto__ = e60105;
var statearr_60106_60123 = state_60085;
(statearr_60106_60123[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60085);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60105;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60124 = state_60085;
state_60085 = G__60124;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_60085){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_60085);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___60112,out))
})();
var state__38311__auto__ = (function (){var statearr_60107 = f__38310__auto__.call(null);
(statearr_60107[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___60112);

return statearr_60107;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___60112,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async60132 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async60132 = (function (f,ch,meta60133){
this.f = f;
this.ch = ch;
this.meta60133 = meta60133;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async60132.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_60134,meta60133__$1){
var self__ = this;
var _60134__$1 = this;
return (new cljs.core.async.t_cljs$core$async60132(self__.f,self__.ch,meta60133__$1));
});

cljs.core.async.t_cljs$core$async60132.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_60134){
var self__ = this;
var _60134__$1 = this;
return self__.meta60133;
});

cljs.core.async.t_cljs$core$async60132.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60132.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async60132.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async60132.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60132.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async60135 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async60135 = (function (f,ch,meta60133,_,fn1,meta60136){
this.f = f;
this.ch = ch;
this.meta60133 = meta60133;
this._ = _;
this.fn1 = fn1;
this.meta60136 = meta60136;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async60135.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_60137,meta60136__$1){
var self__ = this;
var _60137__$1 = this;
return (new cljs.core.async.t_cljs$core$async60135(self__.f,self__.ch,self__.meta60133,self__._,self__.fn1,meta60136__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async60135.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_60137){
var self__ = this;
var _60137__$1 = this;
return self__.meta60136;
});})(___$1))
;

cljs.core.async.t_cljs$core$async60135.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60135.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async60135.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async60135.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__60125_SHARP_){
return f1.call(null,(((p1__60125_SHARP_ == null))?null:self__.f.call(null,p1__60125_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async60135.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta60133","meta60133",-1815322928,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async60132","cljs.core.async/t_cljs$core$async60132",1500731729,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta60136","meta60136",-922771574,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async60135.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async60135.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async60135";

cljs.core.async.t_cljs$core$async60135.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async60135");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async60135 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async60135(f__$1,ch__$1,meta60133__$1,___$2,fn1__$1,meta60136){
return (new cljs.core.async.t_cljs$core$async60135(f__$1,ch__$1,meta60133__$1,___$2,fn1__$1,meta60136));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async60135(self__.f,self__.ch,self__.meta60133,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__9407__auto__ = ret;
if(cljs.core.truth_(and__9407__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__9407__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async60132.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60132.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async60132.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta60133","meta60133",-1815322928,null)], null);
});

cljs.core.async.t_cljs$core$async60132.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async60132.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async60132";

cljs.core.async.t_cljs$core$async60132.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async60132");
});

cljs.core.async.__GT_t_cljs$core$async60132 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async60132(f__$1,ch__$1,meta60133){
return (new cljs.core.async.t_cljs$core$async60132(f__$1,ch__$1,meta60133));
});

}

return (new cljs.core.async.t_cljs$core$async60132(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async60141 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async60141 = (function (f,ch,meta60142){
this.f = f;
this.ch = ch;
this.meta60142 = meta60142;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async60141.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_60143,meta60142__$1){
var self__ = this;
var _60143__$1 = this;
return (new cljs.core.async.t_cljs$core$async60141(self__.f,self__.ch,meta60142__$1));
});

cljs.core.async.t_cljs$core$async60141.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_60143){
var self__ = this;
var _60143__$1 = this;
return self__.meta60142;
});

cljs.core.async.t_cljs$core$async60141.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60141.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async60141.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60141.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async60141.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60141.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async60141.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta60142","meta60142",421603310,null)], null);
});

cljs.core.async.t_cljs$core$async60141.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async60141.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async60141";

cljs.core.async.t_cljs$core$async60141.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async60141");
});

cljs.core.async.__GT_t_cljs$core$async60141 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async60141(f__$1,ch__$1,meta60142){
return (new cljs.core.async.t_cljs$core$async60141(f__$1,ch__$1,meta60142));
});

}

return (new cljs.core.async.t_cljs$core$async60141(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async60147 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async60147 = (function (p,ch,meta60148){
this.p = p;
this.ch = ch;
this.meta60148 = meta60148;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async60147.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_60149,meta60148__$1){
var self__ = this;
var _60149__$1 = this;
return (new cljs.core.async.t_cljs$core$async60147(self__.p,self__.ch,meta60148__$1));
});

cljs.core.async.t_cljs$core$async60147.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_60149){
var self__ = this;
var _60149__$1 = this;
return self__.meta60148;
});

cljs.core.async.t_cljs$core$async60147.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60147.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async60147.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async60147.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60147.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async60147.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60147.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async60147.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta60148","meta60148",1524290905,null)], null);
});

cljs.core.async.t_cljs$core$async60147.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async60147.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async60147";

cljs.core.async.t_cljs$core$async60147.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async60147");
});

cljs.core.async.__GT_t_cljs$core$async60147 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async60147(p__$1,ch__$1,meta60148){
return (new cljs.core.async.t_cljs$core$async60147(p__$1,ch__$1,meta60148));
});

}

return (new cljs.core.async.t_cljs$core$async60147(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args60150 = [];
var len__10640__auto___60194 = arguments.length;
var i__10641__auto___60195 = (0);
while(true){
if((i__10641__auto___60195 < len__10640__auto___60194)){
args60150.push((arguments[i__10641__auto___60195]));

var G__60196 = (i__10641__auto___60195 + (1));
i__10641__auto___60195 = G__60196;
continue;
} else {
}
break;
}

var G__60152 = args60150.length;
switch (G__60152) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60150.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38309__auto___60198 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___60198,out){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___60198,out){
return (function (state_60173){
var state_val_60174 = (state_60173[(1)]);
if((state_val_60174 === (7))){
var inst_60169 = (state_60173[(2)]);
var state_60173__$1 = state_60173;
var statearr_60175_60199 = state_60173__$1;
(statearr_60175_60199[(2)] = inst_60169);

(statearr_60175_60199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60174 === (1))){
var state_60173__$1 = state_60173;
var statearr_60176_60200 = state_60173__$1;
(statearr_60176_60200[(2)] = null);

(statearr_60176_60200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60174 === (4))){
var inst_60155 = (state_60173[(7)]);
var inst_60155__$1 = (state_60173[(2)]);
var inst_60156 = (inst_60155__$1 == null);
var state_60173__$1 = (function (){var statearr_60177 = state_60173;
(statearr_60177[(7)] = inst_60155__$1);

return statearr_60177;
})();
if(cljs.core.truth_(inst_60156)){
var statearr_60178_60201 = state_60173__$1;
(statearr_60178_60201[(1)] = (5));

} else {
var statearr_60179_60202 = state_60173__$1;
(statearr_60179_60202[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60174 === (6))){
var inst_60155 = (state_60173[(7)]);
var inst_60160 = p.call(null,inst_60155);
var state_60173__$1 = state_60173;
if(cljs.core.truth_(inst_60160)){
var statearr_60180_60203 = state_60173__$1;
(statearr_60180_60203[(1)] = (8));

} else {
var statearr_60181_60204 = state_60173__$1;
(statearr_60181_60204[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60174 === (3))){
var inst_60171 = (state_60173[(2)]);
var state_60173__$1 = state_60173;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60173__$1,inst_60171);
} else {
if((state_val_60174 === (2))){
var state_60173__$1 = state_60173;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60173__$1,(4),ch);
} else {
if((state_val_60174 === (11))){
var inst_60163 = (state_60173[(2)]);
var state_60173__$1 = state_60173;
var statearr_60182_60205 = state_60173__$1;
(statearr_60182_60205[(2)] = inst_60163);

(statearr_60182_60205[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60174 === (9))){
var state_60173__$1 = state_60173;
var statearr_60183_60206 = state_60173__$1;
(statearr_60183_60206[(2)] = null);

(statearr_60183_60206[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60174 === (5))){
var inst_60158 = cljs.core.async.close_BANG_.call(null,out);
var state_60173__$1 = state_60173;
var statearr_60184_60207 = state_60173__$1;
(statearr_60184_60207[(2)] = inst_60158);

(statearr_60184_60207[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60174 === (10))){
var inst_60166 = (state_60173[(2)]);
var state_60173__$1 = (function (){var statearr_60185 = state_60173;
(statearr_60185[(8)] = inst_60166);

return statearr_60185;
})();
var statearr_60186_60208 = state_60173__$1;
(statearr_60186_60208[(2)] = null);

(statearr_60186_60208[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60174 === (8))){
var inst_60155 = (state_60173[(7)]);
var state_60173__$1 = state_60173;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60173__$1,(11),out,inst_60155);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___60198,out))
;
return ((function (switch__38195__auto__,c__38309__auto___60198,out){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_60190 = [null,null,null,null,null,null,null,null,null];
(statearr_60190[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_60190[(1)] = (1));

return statearr_60190;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_60173){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_60173);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e60191){if((e60191 instanceof Object)){
var ex__38199__auto__ = e60191;
var statearr_60192_60209 = state_60173;
(statearr_60192_60209[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60173);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60191;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60210 = state_60173;
state_60173 = G__60210;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_60173){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_60173);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___60198,out))
})();
var state__38311__auto__ = (function (){var statearr_60193 = f__38310__auto__.call(null);
(statearr_60193[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___60198);

return statearr_60193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___60198,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args60211 = [];
var len__10640__auto___60214 = arguments.length;
var i__10641__auto___60215 = (0);
while(true){
if((i__10641__auto___60215 < len__10640__auto___60214)){
args60211.push((arguments[i__10641__auto___60215]));

var G__60216 = (i__10641__auto___60215 + (1));
i__10641__auto___60215 = G__60216;
continue;
} else {
}
break;
}

var G__60213 = args60211.length;
switch (G__60213) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60211.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__){
return (function (state_60383){
var state_val_60384 = (state_60383[(1)]);
if((state_val_60384 === (7))){
var inst_60379 = (state_60383[(2)]);
var state_60383__$1 = state_60383;
var statearr_60385_60426 = state_60383__$1;
(statearr_60385_60426[(2)] = inst_60379);

(statearr_60385_60426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (20))){
var inst_60349 = (state_60383[(7)]);
var inst_60360 = (state_60383[(2)]);
var inst_60361 = cljs.core.next.call(null,inst_60349);
var inst_60335 = inst_60361;
var inst_60336 = null;
var inst_60337 = (0);
var inst_60338 = (0);
var state_60383__$1 = (function (){var statearr_60386 = state_60383;
(statearr_60386[(8)] = inst_60338);

(statearr_60386[(9)] = inst_60360);

(statearr_60386[(10)] = inst_60335);

(statearr_60386[(11)] = inst_60337);

(statearr_60386[(12)] = inst_60336);

return statearr_60386;
})();
var statearr_60387_60427 = state_60383__$1;
(statearr_60387_60427[(2)] = null);

(statearr_60387_60427[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (1))){
var state_60383__$1 = state_60383;
var statearr_60388_60428 = state_60383__$1;
(statearr_60388_60428[(2)] = null);

(statearr_60388_60428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (4))){
var inst_60324 = (state_60383[(13)]);
var inst_60324__$1 = (state_60383[(2)]);
var inst_60325 = (inst_60324__$1 == null);
var state_60383__$1 = (function (){var statearr_60389 = state_60383;
(statearr_60389[(13)] = inst_60324__$1);

return statearr_60389;
})();
if(cljs.core.truth_(inst_60325)){
var statearr_60390_60429 = state_60383__$1;
(statearr_60390_60429[(1)] = (5));

} else {
var statearr_60391_60430 = state_60383__$1;
(statearr_60391_60430[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (15))){
var state_60383__$1 = state_60383;
var statearr_60395_60431 = state_60383__$1;
(statearr_60395_60431[(2)] = null);

(statearr_60395_60431[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (21))){
var state_60383__$1 = state_60383;
var statearr_60396_60432 = state_60383__$1;
(statearr_60396_60432[(2)] = null);

(statearr_60396_60432[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (13))){
var inst_60338 = (state_60383[(8)]);
var inst_60335 = (state_60383[(10)]);
var inst_60337 = (state_60383[(11)]);
var inst_60336 = (state_60383[(12)]);
var inst_60345 = (state_60383[(2)]);
var inst_60346 = (inst_60338 + (1));
var tmp60392 = inst_60335;
var tmp60393 = inst_60337;
var tmp60394 = inst_60336;
var inst_60335__$1 = tmp60392;
var inst_60336__$1 = tmp60394;
var inst_60337__$1 = tmp60393;
var inst_60338__$1 = inst_60346;
var state_60383__$1 = (function (){var statearr_60397 = state_60383;
(statearr_60397[(8)] = inst_60338__$1);

(statearr_60397[(10)] = inst_60335__$1);

(statearr_60397[(14)] = inst_60345);

(statearr_60397[(11)] = inst_60337__$1);

(statearr_60397[(12)] = inst_60336__$1);

return statearr_60397;
})();
var statearr_60398_60433 = state_60383__$1;
(statearr_60398_60433[(2)] = null);

(statearr_60398_60433[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (22))){
var state_60383__$1 = state_60383;
var statearr_60399_60434 = state_60383__$1;
(statearr_60399_60434[(2)] = null);

(statearr_60399_60434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (6))){
var inst_60324 = (state_60383[(13)]);
var inst_60333 = f.call(null,inst_60324);
var inst_60334 = cljs.core.seq.call(null,inst_60333);
var inst_60335 = inst_60334;
var inst_60336 = null;
var inst_60337 = (0);
var inst_60338 = (0);
var state_60383__$1 = (function (){var statearr_60400 = state_60383;
(statearr_60400[(8)] = inst_60338);

(statearr_60400[(10)] = inst_60335);

(statearr_60400[(11)] = inst_60337);

(statearr_60400[(12)] = inst_60336);

return statearr_60400;
})();
var statearr_60401_60435 = state_60383__$1;
(statearr_60401_60435[(2)] = null);

(statearr_60401_60435[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (17))){
var inst_60349 = (state_60383[(7)]);
var inst_60353 = cljs.core.chunk_first.call(null,inst_60349);
var inst_60354 = cljs.core.chunk_rest.call(null,inst_60349);
var inst_60355 = cljs.core.count.call(null,inst_60353);
var inst_60335 = inst_60354;
var inst_60336 = inst_60353;
var inst_60337 = inst_60355;
var inst_60338 = (0);
var state_60383__$1 = (function (){var statearr_60402 = state_60383;
(statearr_60402[(8)] = inst_60338);

(statearr_60402[(10)] = inst_60335);

(statearr_60402[(11)] = inst_60337);

(statearr_60402[(12)] = inst_60336);

return statearr_60402;
})();
var statearr_60403_60436 = state_60383__$1;
(statearr_60403_60436[(2)] = null);

(statearr_60403_60436[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (3))){
var inst_60381 = (state_60383[(2)]);
var state_60383__$1 = state_60383;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60383__$1,inst_60381);
} else {
if((state_val_60384 === (12))){
var inst_60369 = (state_60383[(2)]);
var state_60383__$1 = state_60383;
var statearr_60404_60437 = state_60383__$1;
(statearr_60404_60437[(2)] = inst_60369);

(statearr_60404_60437[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (2))){
var state_60383__$1 = state_60383;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60383__$1,(4),in$);
} else {
if((state_val_60384 === (23))){
var inst_60377 = (state_60383[(2)]);
var state_60383__$1 = state_60383;
var statearr_60405_60438 = state_60383__$1;
(statearr_60405_60438[(2)] = inst_60377);

(statearr_60405_60438[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (19))){
var inst_60364 = (state_60383[(2)]);
var state_60383__$1 = state_60383;
var statearr_60406_60439 = state_60383__$1;
(statearr_60406_60439[(2)] = inst_60364);

(statearr_60406_60439[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (11))){
var inst_60335 = (state_60383[(10)]);
var inst_60349 = (state_60383[(7)]);
var inst_60349__$1 = cljs.core.seq.call(null,inst_60335);
var state_60383__$1 = (function (){var statearr_60407 = state_60383;
(statearr_60407[(7)] = inst_60349__$1);

return statearr_60407;
})();
if(inst_60349__$1){
var statearr_60408_60440 = state_60383__$1;
(statearr_60408_60440[(1)] = (14));

} else {
var statearr_60409_60441 = state_60383__$1;
(statearr_60409_60441[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (9))){
var inst_60371 = (state_60383[(2)]);
var inst_60372 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_60383__$1 = (function (){var statearr_60410 = state_60383;
(statearr_60410[(15)] = inst_60371);

return statearr_60410;
})();
if(cljs.core.truth_(inst_60372)){
var statearr_60411_60442 = state_60383__$1;
(statearr_60411_60442[(1)] = (21));

} else {
var statearr_60412_60443 = state_60383__$1;
(statearr_60412_60443[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (5))){
var inst_60327 = cljs.core.async.close_BANG_.call(null,out);
var state_60383__$1 = state_60383;
var statearr_60413_60444 = state_60383__$1;
(statearr_60413_60444[(2)] = inst_60327);

(statearr_60413_60444[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (14))){
var inst_60349 = (state_60383[(7)]);
var inst_60351 = cljs.core.chunked_seq_QMARK_.call(null,inst_60349);
var state_60383__$1 = state_60383;
if(inst_60351){
var statearr_60414_60445 = state_60383__$1;
(statearr_60414_60445[(1)] = (17));

} else {
var statearr_60415_60446 = state_60383__$1;
(statearr_60415_60446[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (16))){
var inst_60367 = (state_60383[(2)]);
var state_60383__$1 = state_60383;
var statearr_60416_60447 = state_60383__$1;
(statearr_60416_60447[(2)] = inst_60367);

(statearr_60416_60447[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (10))){
var inst_60338 = (state_60383[(8)]);
var inst_60336 = (state_60383[(12)]);
var inst_60343 = cljs.core._nth.call(null,inst_60336,inst_60338);
var state_60383__$1 = state_60383;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60383__$1,(13),out,inst_60343);
} else {
if((state_val_60384 === (18))){
var inst_60349 = (state_60383[(7)]);
var inst_60358 = cljs.core.first.call(null,inst_60349);
var state_60383__$1 = state_60383;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60383__$1,(20),out,inst_60358);
} else {
if((state_val_60384 === (8))){
var inst_60338 = (state_60383[(8)]);
var inst_60337 = (state_60383[(11)]);
var inst_60340 = (inst_60338 < inst_60337);
var inst_60341 = inst_60340;
var state_60383__$1 = state_60383;
if(cljs.core.truth_(inst_60341)){
var statearr_60417_60448 = state_60383__$1;
(statearr_60417_60448[(1)] = (10));

} else {
var statearr_60418_60449 = state_60383__$1;
(statearr_60418_60449[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto__))
;
return ((function (switch__38195__auto__,c__38309__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__38196__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__38196__auto____0 = (function (){
var statearr_60422 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60422[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__38196__auto__);

(statearr_60422[(1)] = (1));

return statearr_60422;
});
var cljs$core$async$mapcat_STAR__$_state_machine__38196__auto____1 = (function (state_60383){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_60383);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e60423){if((e60423 instanceof Object)){
var ex__38199__auto__ = e60423;
var statearr_60424_60450 = state_60383;
(statearr_60424_60450[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60383);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60423;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60451 = state_60383;
state_60383 = G__60451;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__38196__auto__ = function(state_60383){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__38196__auto____1.call(this,state_60383);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__38196__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__38196__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__))
})();
var state__38311__auto__ = (function (){var statearr_60425 = f__38310__auto__.call(null);
(statearr_60425[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_60425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__))
);

return c__38309__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args60452 = [];
var len__10640__auto___60455 = arguments.length;
var i__10641__auto___60456 = (0);
while(true){
if((i__10641__auto___60456 < len__10640__auto___60455)){
args60452.push((arguments[i__10641__auto___60456]));

var G__60457 = (i__10641__auto___60456 + (1));
i__10641__auto___60456 = G__60457;
continue;
} else {
}
break;
}

var G__60454 = args60452.length;
switch (G__60454) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60452.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args60459 = [];
var len__10640__auto___60462 = arguments.length;
var i__10641__auto___60463 = (0);
while(true){
if((i__10641__auto___60463 < len__10640__auto___60462)){
args60459.push((arguments[i__10641__auto___60463]));

var G__60464 = (i__10641__auto___60463 + (1));
i__10641__auto___60463 = G__60464;
continue;
} else {
}
break;
}

var G__60461 = args60459.length;
switch (G__60461) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60459.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args60466 = [];
var len__10640__auto___60517 = arguments.length;
var i__10641__auto___60518 = (0);
while(true){
if((i__10641__auto___60518 < len__10640__auto___60517)){
args60466.push((arguments[i__10641__auto___60518]));

var G__60519 = (i__10641__auto___60518 + (1));
i__10641__auto___60518 = G__60519;
continue;
} else {
}
break;
}

var G__60468 = args60466.length;
switch (G__60468) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60466.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38309__auto___60521 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___60521,out){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___60521,out){
return (function (state_60492){
var state_val_60493 = (state_60492[(1)]);
if((state_val_60493 === (7))){
var inst_60487 = (state_60492[(2)]);
var state_60492__$1 = state_60492;
var statearr_60494_60522 = state_60492__$1;
(statearr_60494_60522[(2)] = inst_60487);

(statearr_60494_60522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60493 === (1))){
var inst_60469 = null;
var state_60492__$1 = (function (){var statearr_60495 = state_60492;
(statearr_60495[(7)] = inst_60469);

return statearr_60495;
})();
var statearr_60496_60523 = state_60492__$1;
(statearr_60496_60523[(2)] = null);

(statearr_60496_60523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60493 === (4))){
var inst_60472 = (state_60492[(8)]);
var inst_60472__$1 = (state_60492[(2)]);
var inst_60473 = (inst_60472__$1 == null);
var inst_60474 = cljs.core.not.call(null,inst_60473);
var state_60492__$1 = (function (){var statearr_60497 = state_60492;
(statearr_60497[(8)] = inst_60472__$1);

return statearr_60497;
})();
if(inst_60474){
var statearr_60498_60524 = state_60492__$1;
(statearr_60498_60524[(1)] = (5));

} else {
var statearr_60499_60525 = state_60492__$1;
(statearr_60499_60525[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60493 === (6))){
var state_60492__$1 = state_60492;
var statearr_60500_60526 = state_60492__$1;
(statearr_60500_60526[(2)] = null);

(statearr_60500_60526[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60493 === (3))){
var inst_60489 = (state_60492[(2)]);
var inst_60490 = cljs.core.async.close_BANG_.call(null,out);
var state_60492__$1 = (function (){var statearr_60501 = state_60492;
(statearr_60501[(9)] = inst_60489);

return statearr_60501;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60492__$1,inst_60490);
} else {
if((state_val_60493 === (2))){
var state_60492__$1 = state_60492;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60492__$1,(4),ch);
} else {
if((state_val_60493 === (11))){
var inst_60472 = (state_60492[(8)]);
var inst_60481 = (state_60492[(2)]);
var inst_60469 = inst_60472;
var state_60492__$1 = (function (){var statearr_60502 = state_60492;
(statearr_60502[(10)] = inst_60481);

(statearr_60502[(7)] = inst_60469);

return statearr_60502;
})();
var statearr_60503_60527 = state_60492__$1;
(statearr_60503_60527[(2)] = null);

(statearr_60503_60527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60493 === (9))){
var inst_60472 = (state_60492[(8)]);
var state_60492__$1 = state_60492;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60492__$1,(11),out,inst_60472);
} else {
if((state_val_60493 === (5))){
var inst_60469 = (state_60492[(7)]);
var inst_60472 = (state_60492[(8)]);
var inst_60476 = cljs.core._EQ_.call(null,inst_60472,inst_60469);
var state_60492__$1 = state_60492;
if(inst_60476){
var statearr_60505_60528 = state_60492__$1;
(statearr_60505_60528[(1)] = (8));

} else {
var statearr_60506_60529 = state_60492__$1;
(statearr_60506_60529[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60493 === (10))){
var inst_60484 = (state_60492[(2)]);
var state_60492__$1 = state_60492;
var statearr_60507_60530 = state_60492__$1;
(statearr_60507_60530[(2)] = inst_60484);

(statearr_60507_60530[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60493 === (8))){
var inst_60469 = (state_60492[(7)]);
var tmp60504 = inst_60469;
var inst_60469__$1 = tmp60504;
var state_60492__$1 = (function (){var statearr_60508 = state_60492;
(statearr_60508[(7)] = inst_60469__$1);

return statearr_60508;
})();
var statearr_60509_60531 = state_60492__$1;
(statearr_60509_60531[(2)] = null);

(statearr_60509_60531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___60521,out))
;
return ((function (switch__38195__auto__,c__38309__auto___60521,out){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_60513 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_60513[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_60513[(1)] = (1));

return statearr_60513;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_60492){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_60492);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e60514){if((e60514 instanceof Object)){
var ex__38199__auto__ = e60514;
var statearr_60515_60532 = state_60492;
(statearr_60515_60532[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60492);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60514;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60533 = state_60492;
state_60492 = G__60533;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_60492){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_60492);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___60521,out))
})();
var state__38311__auto__ = (function (){var statearr_60516 = f__38310__auto__.call(null);
(statearr_60516[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___60521);

return statearr_60516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___60521,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args60534 = [];
var len__10640__auto___60604 = arguments.length;
var i__10641__auto___60605 = (0);
while(true){
if((i__10641__auto___60605 < len__10640__auto___60604)){
args60534.push((arguments[i__10641__auto___60605]));

var G__60606 = (i__10641__auto___60605 + (1));
i__10641__auto___60605 = G__60606;
continue;
} else {
}
break;
}

var G__60536 = args60534.length;
switch (G__60536) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60534.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38309__auto___60608 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___60608,out){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___60608,out){
return (function (state_60574){
var state_val_60575 = (state_60574[(1)]);
if((state_val_60575 === (7))){
var inst_60570 = (state_60574[(2)]);
var state_60574__$1 = state_60574;
var statearr_60576_60609 = state_60574__$1;
(statearr_60576_60609[(2)] = inst_60570);

(statearr_60576_60609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60575 === (1))){
var inst_60537 = (new Array(n));
var inst_60538 = inst_60537;
var inst_60539 = (0);
var state_60574__$1 = (function (){var statearr_60577 = state_60574;
(statearr_60577[(7)] = inst_60539);

(statearr_60577[(8)] = inst_60538);

return statearr_60577;
})();
var statearr_60578_60610 = state_60574__$1;
(statearr_60578_60610[(2)] = null);

(statearr_60578_60610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60575 === (4))){
var inst_60542 = (state_60574[(9)]);
var inst_60542__$1 = (state_60574[(2)]);
var inst_60543 = (inst_60542__$1 == null);
var inst_60544 = cljs.core.not.call(null,inst_60543);
var state_60574__$1 = (function (){var statearr_60579 = state_60574;
(statearr_60579[(9)] = inst_60542__$1);

return statearr_60579;
})();
if(inst_60544){
var statearr_60580_60611 = state_60574__$1;
(statearr_60580_60611[(1)] = (5));

} else {
var statearr_60581_60612 = state_60574__$1;
(statearr_60581_60612[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60575 === (15))){
var inst_60564 = (state_60574[(2)]);
var state_60574__$1 = state_60574;
var statearr_60582_60613 = state_60574__$1;
(statearr_60582_60613[(2)] = inst_60564);

(statearr_60582_60613[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60575 === (13))){
var state_60574__$1 = state_60574;
var statearr_60583_60614 = state_60574__$1;
(statearr_60583_60614[(2)] = null);

(statearr_60583_60614[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60575 === (6))){
var inst_60539 = (state_60574[(7)]);
var inst_60560 = (inst_60539 > (0));
var state_60574__$1 = state_60574;
if(cljs.core.truth_(inst_60560)){
var statearr_60584_60615 = state_60574__$1;
(statearr_60584_60615[(1)] = (12));

} else {
var statearr_60585_60616 = state_60574__$1;
(statearr_60585_60616[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60575 === (3))){
var inst_60572 = (state_60574[(2)]);
var state_60574__$1 = state_60574;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60574__$1,inst_60572);
} else {
if((state_val_60575 === (12))){
var inst_60538 = (state_60574[(8)]);
var inst_60562 = cljs.core.vec.call(null,inst_60538);
var state_60574__$1 = state_60574;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60574__$1,(15),out,inst_60562);
} else {
if((state_val_60575 === (2))){
var state_60574__$1 = state_60574;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60574__$1,(4),ch);
} else {
if((state_val_60575 === (11))){
var inst_60554 = (state_60574[(2)]);
var inst_60555 = (new Array(n));
var inst_60538 = inst_60555;
var inst_60539 = (0);
var state_60574__$1 = (function (){var statearr_60586 = state_60574;
(statearr_60586[(7)] = inst_60539);

(statearr_60586[(10)] = inst_60554);

(statearr_60586[(8)] = inst_60538);

return statearr_60586;
})();
var statearr_60587_60617 = state_60574__$1;
(statearr_60587_60617[(2)] = null);

(statearr_60587_60617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60575 === (9))){
var inst_60538 = (state_60574[(8)]);
var inst_60552 = cljs.core.vec.call(null,inst_60538);
var state_60574__$1 = state_60574;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60574__$1,(11),out,inst_60552);
} else {
if((state_val_60575 === (5))){
var inst_60547 = (state_60574[(11)]);
var inst_60539 = (state_60574[(7)]);
var inst_60542 = (state_60574[(9)]);
var inst_60538 = (state_60574[(8)]);
var inst_60546 = (inst_60538[inst_60539] = inst_60542);
var inst_60547__$1 = (inst_60539 + (1));
var inst_60548 = (inst_60547__$1 < n);
var state_60574__$1 = (function (){var statearr_60588 = state_60574;
(statearr_60588[(11)] = inst_60547__$1);

(statearr_60588[(12)] = inst_60546);

return statearr_60588;
})();
if(cljs.core.truth_(inst_60548)){
var statearr_60589_60618 = state_60574__$1;
(statearr_60589_60618[(1)] = (8));

} else {
var statearr_60590_60619 = state_60574__$1;
(statearr_60590_60619[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60575 === (14))){
var inst_60567 = (state_60574[(2)]);
var inst_60568 = cljs.core.async.close_BANG_.call(null,out);
var state_60574__$1 = (function (){var statearr_60592 = state_60574;
(statearr_60592[(13)] = inst_60567);

return statearr_60592;
})();
var statearr_60593_60620 = state_60574__$1;
(statearr_60593_60620[(2)] = inst_60568);

(statearr_60593_60620[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60575 === (10))){
var inst_60558 = (state_60574[(2)]);
var state_60574__$1 = state_60574;
var statearr_60594_60621 = state_60574__$1;
(statearr_60594_60621[(2)] = inst_60558);

(statearr_60594_60621[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60575 === (8))){
var inst_60547 = (state_60574[(11)]);
var inst_60538 = (state_60574[(8)]);
var tmp60591 = inst_60538;
var inst_60538__$1 = tmp60591;
var inst_60539 = inst_60547;
var state_60574__$1 = (function (){var statearr_60595 = state_60574;
(statearr_60595[(7)] = inst_60539);

(statearr_60595[(8)] = inst_60538__$1);

return statearr_60595;
})();
var statearr_60596_60622 = state_60574__$1;
(statearr_60596_60622[(2)] = null);

(statearr_60596_60622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___60608,out))
;
return ((function (switch__38195__auto__,c__38309__auto___60608,out){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_60600 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60600[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_60600[(1)] = (1));

return statearr_60600;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_60574){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_60574);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e60601){if((e60601 instanceof Object)){
var ex__38199__auto__ = e60601;
var statearr_60602_60623 = state_60574;
(statearr_60602_60623[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60574);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60601;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60624 = state_60574;
state_60574 = G__60624;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_60574){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_60574);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___60608,out))
})();
var state__38311__auto__ = (function (){var statearr_60603 = f__38310__auto__.call(null);
(statearr_60603[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___60608);

return statearr_60603;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___60608,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args60625 = [];
var len__10640__auto___60699 = arguments.length;
var i__10641__auto___60700 = (0);
while(true){
if((i__10641__auto___60700 < len__10640__auto___60699)){
args60625.push((arguments[i__10641__auto___60700]));

var G__60701 = (i__10641__auto___60700 + (1));
i__10641__auto___60700 = G__60701;
continue;
} else {
}
break;
}

var G__60627 = args60625.length;
switch (G__60627) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60625.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38309__auto___60703 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___60703,out){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___60703,out){
return (function (state_60669){
var state_val_60670 = (state_60669[(1)]);
if((state_val_60670 === (7))){
var inst_60665 = (state_60669[(2)]);
var state_60669__$1 = state_60669;
var statearr_60671_60704 = state_60669__$1;
(statearr_60671_60704[(2)] = inst_60665);

(statearr_60671_60704[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60670 === (1))){
var inst_60628 = [];
var inst_60629 = inst_60628;
var inst_60630 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_60669__$1 = (function (){var statearr_60672 = state_60669;
(statearr_60672[(7)] = inst_60630);

(statearr_60672[(8)] = inst_60629);

return statearr_60672;
})();
var statearr_60673_60705 = state_60669__$1;
(statearr_60673_60705[(2)] = null);

(statearr_60673_60705[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60670 === (4))){
var inst_60633 = (state_60669[(9)]);
var inst_60633__$1 = (state_60669[(2)]);
var inst_60634 = (inst_60633__$1 == null);
var inst_60635 = cljs.core.not.call(null,inst_60634);
var state_60669__$1 = (function (){var statearr_60674 = state_60669;
(statearr_60674[(9)] = inst_60633__$1);

return statearr_60674;
})();
if(inst_60635){
var statearr_60675_60706 = state_60669__$1;
(statearr_60675_60706[(1)] = (5));

} else {
var statearr_60676_60707 = state_60669__$1;
(statearr_60676_60707[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60670 === (15))){
var inst_60659 = (state_60669[(2)]);
var state_60669__$1 = state_60669;
var statearr_60677_60708 = state_60669__$1;
(statearr_60677_60708[(2)] = inst_60659);

(statearr_60677_60708[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60670 === (13))){
var state_60669__$1 = state_60669;
var statearr_60678_60709 = state_60669__$1;
(statearr_60678_60709[(2)] = null);

(statearr_60678_60709[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60670 === (6))){
var inst_60629 = (state_60669[(8)]);
var inst_60654 = inst_60629.length;
var inst_60655 = (inst_60654 > (0));
var state_60669__$1 = state_60669;
if(cljs.core.truth_(inst_60655)){
var statearr_60679_60710 = state_60669__$1;
(statearr_60679_60710[(1)] = (12));

} else {
var statearr_60680_60711 = state_60669__$1;
(statearr_60680_60711[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60670 === (3))){
var inst_60667 = (state_60669[(2)]);
var state_60669__$1 = state_60669;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60669__$1,inst_60667);
} else {
if((state_val_60670 === (12))){
var inst_60629 = (state_60669[(8)]);
var inst_60657 = cljs.core.vec.call(null,inst_60629);
var state_60669__$1 = state_60669;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60669__$1,(15),out,inst_60657);
} else {
if((state_val_60670 === (2))){
var state_60669__$1 = state_60669;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60669__$1,(4),ch);
} else {
if((state_val_60670 === (11))){
var inst_60633 = (state_60669[(9)]);
var inst_60637 = (state_60669[(10)]);
var inst_60647 = (state_60669[(2)]);
var inst_60648 = [];
var inst_60649 = inst_60648.push(inst_60633);
var inst_60629 = inst_60648;
var inst_60630 = inst_60637;
var state_60669__$1 = (function (){var statearr_60681 = state_60669;
(statearr_60681[(7)] = inst_60630);

(statearr_60681[(11)] = inst_60647);

(statearr_60681[(8)] = inst_60629);

(statearr_60681[(12)] = inst_60649);

return statearr_60681;
})();
var statearr_60682_60712 = state_60669__$1;
(statearr_60682_60712[(2)] = null);

(statearr_60682_60712[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60670 === (9))){
var inst_60629 = (state_60669[(8)]);
var inst_60645 = cljs.core.vec.call(null,inst_60629);
var state_60669__$1 = state_60669;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60669__$1,(11),out,inst_60645);
} else {
if((state_val_60670 === (5))){
var inst_60630 = (state_60669[(7)]);
var inst_60633 = (state_60669[(9)]);
var inst_60637 = (state_60669[(10)]);
var inst_60637__$1 = f.call(null,inst_60633);
var inst_60638 = cljs.core._EQ_.call(null,inst_60637__$1,inst_60630);
var inst_60639 = cljs.core.keyword_identical_QMARK_.call(null,inst_60630,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_60640 = (inst_60638) || (inst_60639);
var state_60669__$1 = (function (){var statearr_60683 = state_60669;
(statearr_60683[(10)] = inst_60637__$1);

return statearr_60683;
})();
if(cljs.core.truth_(inst_60640)){
var statearr_60684_60713 = state_60669__$1;
(statearr_60684_60713[(1)] = (8));

} else {
var statearr_60685_60714 = state_60669__$1;
(statearr_60685_60714[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60670 === (14))){
var inst_60662 = (state_60669[(2)]);
var inst_60663 = cljs.core.async.close_BANG_.call(null,out);
var state_60669__$1 = (function (){var statearr_60687 = state_60669;
(statearr_60687[(13)] = inst_60662);

return statearr_60687;
})();
var statearr_60688_60715 = state_60669__$1;
(statearr_60688_60715[(2)] = inst_60663);

(statearr_60688_60715[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60670 === (10))){
var inst_60652 = (state_60669[(2)]);
var state_60669__$1 = state_60669;
var statearr_60689_60716 = state_60669__$1;
(statearr_60689_60716[(2)] = inst_60652);

(statearr_60689_60716[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60670 === (8))){
var inst_60633 = (state_60669[(9)]);
var inst_60637 = (state_60669[(10)]);
var inst_60629 = (state_60669[(8)]);
var inst_60642 = inst_60629.push(inst_60633);
var tmp60686 = inst_60629;
var inst_60629__$1 = tmp60686;
var inst_60630 = inst_60637;
var state_60669__$1 = (function (){var statearr_60690 = state_60669;
(statearr_60690[(7)] = inst_60630);

(statearr_60690[(14)] = inst_60642);

(statearr_60690[(8)] = inst_60629__$1);

return statearr_60690;
})();
var statearr_60691_60717 = state_60669__$1;
(statearr_60691_60717[(2)] = null);

(statearr_60691_60717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___60703,out))
;
return ((function (switch__38195__auto__,c__38309__auto___60703,out){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_60695 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60695[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_60695[(1)] = (1));

return statearr_60695;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_60669){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_60669);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e60696){if((e60696 instanceof Object)){
var ex__38199__auto__ = e60696;
var statearr_60697_60718 = state_60669;
(statearr_60697_60718[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60669);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60696;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60719 = state_60669;
state_60669 = G__60719;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_60669){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_60669);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___60703,out))
})();
var state__38311__auto__ = (function (){var statearr_60698 = f__38310__auto__.call(null);
(statearr_60698[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___60703);

return statearr_60698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___60703,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map