// Compiled by ClojureScript 1.9.521 {}
goog.provide('hasch.core');
goog.require('cljs.core');
goog.require('hasch.benc');
goog.require('hasch.platform');
hasch.core.uuid4 = hasch.platform.uuid4;
hasch.core.uuid5 = hasch.platform.uuid5;
hasch.core.hash__GT_str = hasch.platform.hash__GT_str;
/**
 * Hash an edn value with SHA-512 by default or a compatible hash function of choice.
 */
hasch.core.edn_hash = (function hasch$core$edn_hash(var_args){
var args64875 = [];
var len__10640__auto___64878 = arguments.length;
var i__10641__auto___64879 = (0);
while(true){
if((i__10641__auto___64879 < len__10640__auto___64878)){
args64875.push((arguments[i__10641__auto___64879]));

var G__64880 = (i__10641__auto___64879 + (1));
i__10641__auto___64879 = G__64880;
continue;
} else {
}
break;
}

var G__64877 = args64875.length;
switch (G__64877) {
case 1:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args64875.length)].join('')));

}
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1 = (function (val){
return hasch.core.edn_hash.call(null,val,cljs.core.PersistentArrayMap.EMPTY);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2 = (function (val,write_handlers){
return hasch.core.edn_hash.call(null,val,hasch.platform.sha512_message_digest,write_handlers);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3 = (function (val,md_create_fn,write_handlers){
return cljs.core.map.call(null,(function (p1__64874_SHARP_){
if((p1__64874_SHARP_ < (0))){
return (p1__64874_SHARP_ + (256));
} else {
return p1__64874_SHARP_;
}
}),hasch.benc.digest.call(null,hasch.benc._coerce.call(null,val,md_create_fn,(function (){var or__9419__auto__ = write_handlers;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})()),md_create_fn));
});

hasch.core.edn_hash.cljs$lang$maxFixedArity = 3;

/**
 * Creates random UUID-4 without argument or UUID-5 for the argument value.
 * 
 *   Optionally an incognito-style write-handlers map can be supplied,
 *   which describes record serialization in terms of Clojure data
 *   structures.
 */
hasch.core.uuid = (function hasch$core$uuid(var_args){
var args64882 = [];
var len__10640__auto___64890 = arguments.length;
var i__10641__auto___64891 = (0);
while(true){
if((i__10641__auto___64891 < len__10640__auto___64890)){
args64882.push((arguments[i__10641__auto___64891]));

var G__64892 = (i__10641__auto___64891 + (1));
i__10641__auto___64891 = G__64892;
continue;
} else {
}
break;
}

var G__64886 = args64882.length;
switch (G__64886) {
case 0:
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__10663__auto__ = (new cljs.core.IndexedSeq(args64882.slice((1)),(0),null));
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10663__auto__);

}
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$0 = (function (){
return hasch.core.uuid4.call(null);
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic = (function (val,p__64887){
var map__64888 = p__64887;
var map__64888__$1 = ((((!((map__64888 == null)))?((((map__64888.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64888.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64888):map__64888);
var write_handlers = cljs.core.get.call(null,map__64888__$1,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911));
return hasch.core.uuid5.call(null,hasch.core.edn_hash.call(null,val,write_handlers));
});

hasch.core.uuid.cljs$lang$applyTo = (function (seq64883){
var G__64884 = cljs.core.first.call(null,seq64883);
var seq64883__$1 = cljs.core.next.call(null,seq64883);
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic(G__64884,seq64883__$1);
});

hasch.core.uuid.cljs$lang$maxFixedArity = (1);


//# sourceMappingURL=core.js.map