// Compiled by ClojureScript 1.9.521 {}
goog.provide('konserve.memory');
goog.require('cljs.core');
goog.require('konserve.protocols');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {konserve.protocols.PEDNAsyncKeyValueStore}
 * @implements {konserve.protocols.PBinaryAsyncKeyValueStore}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
konserve.memory.MemAsyncKeyValueStore = (function (state,read_handlers,write_handlers,locks,__meta,__extmap,__hash){
this.state = state;
this.read_handlers = read_handlers;
this.write_handlers = write_handlers;
this.locks = locks;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__10094__auto__,k__10095__auto__){
var self__ = this;
var this__10094__auto____$1 = this;
return this__10094__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__10095__auto__,null);
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__10096__auto__,k67382,else__10097__auto__){
var self__ = this;
var this__10096__auto____$1 = this;
var G__67384 = (((k67382 instanceof cljs.core.Keyword))?k67382.fqn:null);
switch (G__67384) {
case "state":
return self__.state;

break;
case "read-handlers":
return self__.read_handlers;

break;
case "write-handlers":
return self__.write_handlers;

break;
case "locks":
return self__.locks;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k67382,else__10097__auto__);

}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__10108__auto__,writer__10109__auto__,opts__10110__auto__){
var self__ = this;
var this__10108__auto____$1 = this;
var pr_pair__10111__auto__ = ((function (this__10108__auto____$1){
return (function (keyval__10112__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,cljs.core.pr_writer,""," ","",opts__10110__auto__,keyval__10112__auto__);
});})(this__10108__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,pr_pair__10111__auto__,"#konserve.memory.MemAsyncKeyValueStore{",", ","}",opts__10110__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),self__.read_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),self__.write_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"locks","locks",1560476518),self__.locks],null))], null),self__.__extmap));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__67381){
var self__ = this;
var G__67381__$1 = this;
return (new cljs.core.RecordIter((0),G__67381__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),new cljs.core.Keyword(null,"locks","locks",1560476518)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__10092__auto__){
var self__ = this;
var this__10092__auto____$1 = this;
return self__.__meta;
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__10088__auto__){
var self__ = this;
var this__10088__auto____$1 = this;
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,self__.__hash));
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$ = cljs.core.PROTOCOL_SENTINEL;

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_exists_QMARK_$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__,this$__$1){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__,this$__$1){
return (function (state_67392){
var state_val_67393 = (state_67392[(1)]);
if((state_val_67393 === (1))){
var inst_67385 = cljs.core.deref.call(null,self__.state);
var inst_67386 = inst_67385.call(null,key);
var state_67392__$1 = state_67392;
if(cljs.core.truth_(inst_67386)){
var statearr_67394_67478 = state_67392__$1;
(statearr_67394_67478[(1)] = (2));

} else {
var statearr_67395_67479 = state_67392__$1;
(statearr_67395_67479[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67393 === (2))){
var state_67392__$1 = state_67392;
var statearr_67396_67480 = state_67392__$1;
(statearr_67396_67480[(2)] = true);

(statearr_67396_67480[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67393 === (3))){
var state_67392__$1 = state_67392;
var statearr_67397_67481 = state_67392__$1;
(statearr_67397_67481[(2)] = false);

(statearr_67397_67481[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67393 === (4))){
var inst_67390 = (state_67392[(2)]);
var state_67392__$1 = state_67392;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67392__$1,inst_67390);
} else {
return null;
}
}
}
}
});})(c__38309__auto__,this$__$1))
;
return ((function (switch__38195__auto__,c__38309__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38196__auto__ = null;
var konserve$memory$state_machine__38196__auto____0 = (function (){
var statearr_67401 = [null,null,null,null,null,null,null];
(statearr_67401[(0)] = konserve$memory$state_machine__38196__auto__);

(statearr_67401[(1)] = (1));

return statearr_67401;
});
var konserve$memory$state_machine__38196__auto____1 = (function (state_67392){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_67392);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e67402){if((e67402 instanceof Object)){
var ex__38199__auto__ = e67402;
var statearr_67403_67482 = state_67392;
(statearr_67403_67482[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_67392);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e67402;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67483 = state_67392;
state_67392 = G__67483;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
konserve$memory$state_machine__38196__auto__ = function(state_67392){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38196__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38196__auto____1.call(this,state_67392);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38196__auto____0;
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38196__auto____1;
return konserve$memory$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__,this$__$1))
})();
var state__38311__auto__ = (function (){var statearr_67404 = f__38310__auto__.call(null);
(statearr_67404[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_67404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__,this$__$1))
);

return c__38309__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_get_in$arity$2 = (function (this$,key_vec){
var self__ = this;
var this$__$1 = this;
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__,this$__$1){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__,this$__$1){
return (function (state_67408){
var state_val_67409 = (state_67408[(1)]);
if((state_val_67409 === (1))){
var inst_67405 = cljs.core.deref.call(null,self__.state);
var inst_67406 = cljs.core.get_in.call(null,inst_67405,key_vec);
var state_67408__$1 = state_67408;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67408__$1,inst_67406);
} else {
return null;
}
});})(c__38309__auto__,this$__$1))
;
return ((function (switch__38195__auto__,c__38309__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38196__auto__ = null;
var konserve$memory$state_machine__38196__auto____0 = (function (){
var statearr_67413 = [null,null,null,null,null,null,null];
(statearr_67413[(0)] = konserve$memory$state_machine__38196__auto__);

(statearr_67413[(1)] = (1));

return statearr_67413;
});
var konserve$memory$state_machine__38196__auto____1 = (function (state_67408){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_67408);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e67414){if((e67414 instanceof Object)){
var ex__38199__auto__ = e67414;
var statearr_67415_67484 = state_67408;
(statearr_67415_67484[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_67408);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e67414;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67485 = state_67408;
state_67408 = G__67485;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
konserve$memory$state_machine__38196__auto__ = function(state_67408){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38196__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38196__auto____1.call(this,state_67408);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38196__auto____0;
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38196__auto____1;
return konserve$memory$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__,this$__$1))
})();
var state__38311__auto__ = (function (){var statearr_67416 = f__38310__auto__.call(null);
(statearr_67416[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_67416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__,this$__$1))
);

return c__38309__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_update_in$arity$3 = (function (this$,key_vec,up_fn){
var self__ = this;
var this$__$1 = this;
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__,this$__$1){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__,this$__$1){
return (function (state_67425){
var state_val_67426 = (state_67425[(1)]);
if((state_val_67426 === (1))){
var inst_67417 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67418 = cljs.core.deref.call(null,self__.state);
var inst_67419 = cljs.core.get_in.call(null,inst_67418,key_vec);
var inst_67420 = cljs.core.swap_BANG_.call(null,self__.state,cljs.core.update_in,key_vec,up_fn);
var inst_67421 = cljs.core.get_in.call(null,inst_67420,key_vec);
var inst_67422 = [inst_67419,inst_67421];
var inst_67423 = (new cljs.core.PersistentVector(null,2,(5),inst_67417,inst_67422,null));
var state_67425__$1 = state_67425;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67425__$1,inst_67423);
} else {
return null;
}
});})(c__38309__auto__,this$__$1))
;
return ((function (switch__38195__auto__,c__38309__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38196__auto__ = null;
var konserve$memory$state_machine__38196__auto____0 = (function (){
var statearr_67430 = [null,null,null,null,null,null,null];
(statearr_67430[(0)] = konserve$memory$state_machine__38196__auto__);

(statearr_67430[(1)] = (1));

return statearr_67430;
});
var konserve$memory$state_machine__38196__auto____1 = (function (state_67425){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_67425);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e67431){if((e67431 instanceof Object)){
var ex__38199__auto__ = e67431;
var statearr_67432_67486 = state_67425;
(statearr_67432_67486[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_67425);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e67431;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67487 = state_67425;
state_67425 = G__67487;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
konserve$memory$state_machine__38196__auto__ = function(state_67425){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38196__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38196__auto____1.call(this,state_67425);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38196__auto____0;
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38196__auto____1;
return konserve$memory$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__,this$__$1))
})();
var state__38311__auto__ = (function (){var statearr_67433 = f__38310__auto__.call(null);
(statearr_67433[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_67433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__,this$__$1))
);

return c__38309__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_assoc_in$arity$3 = (function (this$,key_vec,val){
var self__ = this;
var this$__$1 = this;
return this$__$1.konserve$protocols$PEDNAsyncKeyValueStore$_update_in$arity$3(null,key_vec,((function (this$__$1){
return (function (_){
return val;
});})(this$__$1))
);
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_dissoc$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__,this$__$1){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__,this$__$1){
return (function (state_67436){
var state_val_67437 = (state_67436[(1)]);
if((state_val_67437 === (1))){
var inst_67434 = cljs.core.swap_BANG_.call(null,self__.state,cljs.core.dissoc,key);
var state_67436__$1 = (function (){var statearr_67438 = state_67436;
(statearr_67438[(7)] = inst_67434);

return statearr_67438;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67436__$1,null);
} else {
return null;
}
});})(c__38309__auto__,this$__$1))
;
return ((function (switch__38195__auto__,c__38309__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38196__auto__ = null;
var konserve$memory$state_machine__38196__auto____0 = (function (){
var statearr_67442 = [null,null,null,null,null,null,null,null];
(statearr_67442[(0)] = konserve$memory$state_machine__38196__auto__);

(statearr_67442[(1)] = (1));

return statearr_67442;
});
var konserve$memory$state_machine__38196__auto____1 = (function (state_67436){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_67436);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e67443){if((e67443 instanceof Object)){
var ex__38199__auto__ = e67443;
var statearr_67444_67488 = state_67436;
(statearr_67444_67488[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_67436);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e67443;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67489 = state_67436;
state_67436 = G__67489;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
konserve$memory$state_machine__38196__auto__ = function(state_67436){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38196__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38196__auto____1.call(this,state_67436);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38196__auto____0;
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38196__auto____1;
return konserve$memory$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__,this$__$1))
})();
var state__38311__auto__ = (function (){var statearr_67445 = f__38310__auto__.call(null);
(statearr_67445[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_67445;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__,this$__$1))
);

return c__38309__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__10098__auto__){
var self__ = this;
var this__10098__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PBinaryAsyncKeyValueStore$ = cljs.core.PROTOCOL_SENTINEL;

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PBinaryAsyncKeyValueStore$_bget$arity$3 = (function (this$,key,locked_cb){
var self__ = this;
var this$__$1 = this;
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__,this$__$1){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__,this$__$1){
return (function (state_67450){
var state_val_67451 = (state_67450[(1)]);
if((state_val_67451 === (1))){
var inst_67446 = cljs.core.deref.call(null,self__.state);
var inst_67447 = cljs.core.get.call(null,inst_67446,key);
var inst_67448 = locked_cb.call(null,inst_67447);
var state_67450__$1 = state_67450;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67450__$1,inst_67448);
} else {
return null;
}
});})(c__38309__auto__,this$__$1))
;
return ((function (switch__38195__auto__,c__38309__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38196__auto__ = null;
var konserve$memory$state_machine__38196__auto____0 = (function (){
var statearr_67455 = [null,null,null,null,null,null,null];
(statearr_67455[(0)] = konserve$memory$state_machine__38196__auto__);

(statearr_67455[(1)] = (1));

return statearr_67455;
});
var konserve$memory$state_machine__38196__auto____1 = (function (state_67450){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_67450);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e67456){if((e67456 instanceof Object)){
var ex__38199__auto__ = e67456;
var statearr_67457_67490 = state_67450;
(statearr_67457_67490[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_67450);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e67456;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67491 = state_67450;
state_67450 = G__67491;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
konserve$memory$state_machine__38196__auto__ = function(state_67450){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38196__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38196__auto____1.call(this,state_67450);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38196__auto____0;
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38196__auto____1;
return konserve$memory$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__,this$__$1))
})();
var state__38311__auto__ = (function (){var statearr_67458 = f__38310__auto__.call(null);
(statearr_67458[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_67458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__,this$__$1))
);

return c__38309__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PBinaryAsyncKeyValueStore$_bassoc$arity$3 = (function (this$,key,input){
var self__ = this;
var this$__$1 = this;
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__,this$__$1){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__,this$__$1){
return (function (state_67464){
var state_val_67465 = (state_67464[(1)]);
if((state_val_67465 === (1))){
var inst_67459 = [new cljs.core.Keyword(null,"input-stream","input-stream",-179909472),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_67460 = [input,new cljs.core.Keyword(null,"unknown","unknown",-935977881)];
var inst_67461 = cljs.core.PersistentHashMap.fromArrays(inst_67459,inst_67460);
var inst_67462 = cljs.core.swap_BANG_.call(null,self__.state,cljs.core.assoc,key,inst_67461);
var state_67464__$1 = (function (){var statearr_67466 = state_67464;
(statearr_67466[(7)] = inst_67462);

return statearr_67466;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67464__$1,null);
} else {
return null;
}
});})(c__38309__auto__,this$__$1))
;
return ((function (switch__38195__auto__,c__38309__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38196__auto__ = null;
var konserve$memory$state_machine__38196__auto____0 = (function (){
var statearr_67470 = [null,null,null,null,null,null,null,null];
(statearr_67470[(0)] = konserve$memory$state_machine__38196__auto__);

(statearr_67470[(1)] = (1));

return statearr_67470;
});
var konserve$memory$state_machine__38196__auto____1 = (function (state_67464){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_67464);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e67471){if((e67471 instanceof Object)){
var ex__38199__auto__ = e67471;
var statearr_67472_67492 = state_67464;
(statearr_67472_67492[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_67464);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e67471;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67493 = state_67464;
state_67464 = G__67493;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
konserve$memory$state_machine__38196__auto__ = function(state_67464){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38196__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38196__auto____1.call(this,state_67464);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38196__auto____0;
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38196__auto____1;
return konserve$memory$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__,this$__$1))
})();
var state__38311__auto__ = (function (){var statearr_67473 = f__38310__auto__.call(null);
(statearr_67473[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_67473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__,this$__$1))
);

return c__38309__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__10089__auto__){
var self__ = this;
var this__10089__auto____$1 = this;
var h__9861__auto__ = self__.__hash;
if(!((h__9861__auto__ == null))){
return h__9861__auto__;
} else {
var h__9861__auto____$1 = cljs.core.hash_imap.call(null,this__10089__auto____$1);
self__.__hash = h__9861__auto____$1;

return h__9861__auto____$1;
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__10090__auto__,other__10091__auto__){
var self__ = this;
var this__10090__auto____$1 = this;
if(cljs.core.truth_((function (){var and__9407__auto__ = other__10091__auto__;
if(cljs.core.truth_(and__9407__auto__)){
return ((this__10090__auto____$1.constructor === other__10091__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__10090__auto____$1,other__10091__auto__));
} else {
return and__9407__auto__;
}
})())){
return true;
} else {
return false;
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__10103__auto__,k__10104__auto__){
var self__ = this;
var this__10103__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"locks","locks",1560476518),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),null,new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),null], null), null),k__10104__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__10103__auto____$1),self__.__meta),k__10104__auto__);
} else {
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__10104__auto__)),null));
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__10101__auto__,k__10102__auto__,G__67381){
var self__ = this;
var this__10101__auto____$1 = this;
var pred__67474 = cljs.core.keyword_identical_QMARK_;
var expr__67475 = k__10102__auto__;
if(cljs.core.truth_(pred__67474.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__67475))){
return (new konserve.memory.MemAsyncKeyValueStore(G__67381,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__67474.call(null,new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),expr__67475))){
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,G__67381,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__67474.call(null,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),expr__67475))){
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,G__67381,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__67474.call(null,new cljs.core.Keyword(null,"locks","locks",1560476518),expr__67475))){
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,G__67381,self__.__meta,self__.__extmap,null));
} else {
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__10102__auto__,G__67381),null));
}
}
}
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__10106__auto__){
var self__ = this;
var this__10106__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),self__.read_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),self__.write_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"locks","locks",1560476518),self__.locks],null))], null),self__.__extmap));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__10093__auto__,G__67381){
var self__ = this;
var this__10093__auto____$1 = this;
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,G__67381,self__.__extmap,self__.__hash));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__10099__auto__,entry__10100__auto__){
var self__ = this;
var this__10099__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__10100__auto__)){
return this__10099__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__10100__auto__,(0)),cljs.core._nth.call(null,entry__10100__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__10099__auto____$1,entry__10100__auto__);
}
});

konserve.memory.MemAsyncKeyValueStore.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"read-handlers","read-handlers",-544976454,null),new cljs.core.Symbol(null,"write-handlers","write-handlers",-456757384,null),new cljs.core.Symbol(null,"locks","locks",-1093959251,null)], null);
});

konserve.memory.MemAsyncKeyValueStore.cljs$lang$type = true;

konserve.memory.MemAsyncKeyValueStore.cljs$lang$ctorPrSeq = (function (this__10130__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"konserve.memory/MemAsyncKeyValueStore");
});

konserve.memory.MemAsyncKeyValueStore.cljs$lang$ctorPrWriter = (function (this__10130__auto__,writer__10131__auto__){
return cljs.core._write.call(null,writer__10131__auto__,"konserve.memory/MemAsyncKeyValueStore");
});

konserve.memory.__GT_MemAsyncKeyValueStore = (function konserve$memory$__GT_MemAsyncKeyValueStore(state,read_handlers,write_handlers,locks){
return (new konserve.memory.MemAsyncKeyValueStore(state,read_handlers,write_handlers,locks,null,null,null));
});

konserve.memory.map__GT_MemAsyncKeyValueStore = (function konserve$memory$map__GT_MemAsyncKeyValueStore(G__67383){
return (new konserve.memory.MemAsyncKeyValueStore(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__67383),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315).cljs$core$IFn$_invoke$arity$1(G__67383),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911).cljs$core$IFn$_invoke$arity$1(G__67383),new cljs.core.Keyword(null,"locks","locks",1560476518).cljs$core$IFn$_invoke$arity$1(G__67383),null,cljs.core.dissoc.call(null,G__67383,new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),new cljs.core.Keyword(null,"locks","locks",1560476518)),null));
});

/**
 * Create in memory store. Binaries are not properly locked yet and
 *   the read and write-handlers are dummy ones for compatibility.
 */
konserve.memory.new_mem_store = (function konserve$memory$new_mem_store(var_args){
var args67494 = [];
var len__10640__auto___67517 = arguments.length;
var i__10641__auto___67518 = (0);
while(true){
if((i__10641__auto___67518 < len__10640__auto___67517)){
args67494.push((arguments[i__10641__auto___67518]));

var G__67519 = (i__10641__auto___67518 + (1));
i__10641__auto___67518 = G__67519;
continue;
} else {
}
break;
}

var G__67496 = args67494.length;
switch (G__67496) {
case 0:
return konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args67494.length)].join('')));

}
});

konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$0 = (function (){
return konserve.memory.new_mem_store.call(null,cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
});

konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$1 = (function (init_atom){
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__){
return (function (state_67508){
var state_val_67509 = (state_67508[(1)]);
if((state_val_67509 === (1))){
var inst_67497 = [new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),new cljs.core.Keyword(null,"locks","locks",1560476518)];
var inst_67498 = cljs.core.PersistentHashMap.EMPTY;
var inst_67499 = cljs.core.atom.call(null,inst_67498);
var inst_67500 = cljs.core.PersistentHashMap.EMPTY;
var inst_67501 = cljs.core.atom.call(null,inst_67500);
var inst_67502 = cljs.core.PersistentHashMap.EMPTY;
var inst_67503 = cljs.core.atom.call(null,inst_67502);
var inst_67504 = [init_atom,inst_67499,inst_67501,inst_67503];
var inst_67505 = cljs.core.PersistentHashMap.fromArrays(inst_67497,inst_67504);
var inst_67506 = konserve.memory.map__GT_MemAsyncKeyValueStore.call(null,inst_67505);
var state_67508__$1 = state_67508;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67508__$1,inst_67506);
} else {
return null;
}
});})(c__38309__auto__))
;
return ((function (switch__38195__auto__,c__38309__auto__){
return (function() {
var konserve$memory$state_machine__38196__auto__ = null;
var konserve$memory$state_machine__38196__auto____0 = (function (){
var statearr_67513 = [null,null,null,null,null,null,null];
(statearr_67513[(0)] = konserve$memory$state_machine__38196__auto__);

(statearr_67513[(1)] = (1));

return statearr_67513;
});
var konserve$memory$state_machine__38196__auto____1 = (function (state_67508){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_67508);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e67514){if((e67514 instanceof Object)){
var ex__38199__auto__ = e67514;
var statearr_67515_67521 = state_67508;
(statearr_67515_67521[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_67508);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e67514;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67522 = state_67508;
state_67508 = G__67522;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
konserve$memory$state_machine__38196__auto__ = function(state_67508){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38196__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38196__auto____1.call(this,state_67508);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38196__auto____0;
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38196__auto____1;
return konserve$memory$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__))
})();
var state__38311__auto__ = (function (){var statearr_67516 = f__38310__auto__.call(null);
(statearr_67516[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_67516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__))
);

return c__38309__auto__;
});

konserve.memory.new_mem_store.cljs$lang$maxFixedArity = 1;


//# sourceMappingURL=memory.js.map