// Compiled by ClojureScript 1.9.521 {}
goog.provide('superv.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
superv.async.cljs_env_QMARK_ = (function superv$async$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});

/**
 * @interface
 */
superv.async.PSupervisor = function(){};

superv.async._error = (function superv$async$_error(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_error$arity$1 == null)))){
return this$.superv$async$PSupervisor$_error$arity$1(this$);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._error[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$);
} else {
var m__10138__auto____$1 = (superv.async._error["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-error",this$);
}
}
}
});

superv.async._abort = (function superv$async$_abort(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_abort$arity$1 == null)))){
return this$.superv$async$PSupervisor$_abort$arity$1(this$);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._abort[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$);
} else {
var m__10138__auto____$1 = (superv.async._abort["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-abort",this$);
}
}
}
});

superv.async._register_go = (function superv$async$_register_go(this$,body){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_register_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_register_go$arity$2(this$,body);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._register_go[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,body);
} else {
var m__10138__auto____$1 = (superv.async._register_go["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,body);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-register-go",this$);
}
}
}
});

superv.async._unregister_go = (function superv$async$_unregister_go(this$,id){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_unregister_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_unregister_go$arity$2(this$,id);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._unregister_go[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,id);
} else {
var m__10138__auto____$1 = (superv.async._unregister_go["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-unregister-go",this$);
}
}
}
});

superv.async._track_exception = (function superv$async$_track_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_track_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_track_exception$arity$2(this$,e);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._track_exception[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,e);
} else {
var m__10138__auto____$1 = (superv.async._track_exception["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-track-exception",this$);
}
}
}
});

superv.async._free_exception = (function superv$async$_free_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_free_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_free_exception$arity$2(this$,e);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._free_exception[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,e);
} else {
var m__10138__auto____$1 = (superv.async._free_exception["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-free-exception",this$);
}
}
}
});

superv.async.now = (function superv$async$now(){
return (new Date());
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {superv.async.PSupervisor}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
superv.async.TrackingSupervisor = (function (error,abort,registered,pending_exceptions,__meta,__extmap,__hash){
this.error = error;
this.abort = abort;
this.registered = registered;
this.pending_exceptions = pending_exceptions;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__10094__auto__,k__10095__auto__){
var self__ = this;
var this__10094__auto____$1 = this;
return this__10094__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__10095__auto__,null);
});

superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__10096__auto__,k60723,else__10097__auto__){
var self__ = this;
var this__10096__auto____$1 = this;
var G__60725 = (((k60723 instanceof cljs.core.Keyword))?k60723.fqn:null);
switch (G__60725) {
case "error":
return self__.error;

break;
case "abort":
return self__.abort;

break;
case "registered":
return self__.registered;

break;
case "pending-exceptions":
return self__.pending_exceptions;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k60723,else__10097__auto__);

}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__10108__auto__,writer__10109__auto__,opts__10110__auto__){
var self__ = this;
var this__10108__auto____$1 = this;
var pr_pair__10111__auto__ = ((function (this__10108__auto____$1){
return (function (keyval__10112__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,cljs.core.pr_writer,""," ","",opts__10110__auto__,keyval__10112__auto__);
});})(this__10108__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,pr_pair__10111__auto__,"#superv.async.TrackingSupervisor{",", ","}",opts__10110__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__60722){
var self__ = this;
var G__60722__$1 = this;
return (new cljs.core.RecordIter((0),G__60722__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__10092__auto__){
var self__ = this;
var this__10092__auto____$1 = this;
return self__.__meta;
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__10088__auto__){
var self__ = this;
var this__10088__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__10098__auto__){
var self__ = this;
var this__10098__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__10089__auto__){
var self__ = this;
var this__10089__auto____$1 = this;
var h__9861__auto__ = self__.__hash;
if(!((h__9861__auto__ == null))){
return h__9861__auto__;
} else {
var h__9861__auto____$1 = cljs.core.hash_imap.call(null,this__10089__auto____$1);
self__.__hash = h__9861__auto____$1;

return h__9861__auto____$1;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__10090__auto__,other__10091__auto__){
var self__ = this;
var this__10090__auto____$1 = this;
if(cljs.core.truth_((function (){var and__9407__auto__ = other__10091__auto__;
if(cljs.core.truth_(and__9407__auto__)){
return ((this__10090__auto____$1.constructor === other__10091__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__10090__auto____$1,other__10091__auto__));
} else {
return and__9407__auto__;
}
})())){
return true;
} else {
return false;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__10103__auto__,k__10104__auto__){
var self__ = this;
var this__10103__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),null,new cljs.core.Keyword(null,"abort","abort",521193198),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"registered","registered",-388600037),null], null), null),k__10104__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__10103__auto____$1),self__.__meta),k__10104__auto__);
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__10104__auto__)),null));
}
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_error$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.error;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.abort;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_register_go$arity$2 = (function (this$,body){
var self__ = this;
var this$__$1 = this;
var id = cljs.core.random_uuid.call(null);
cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.assoc,id,body);

return id;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_unregister_go$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.dissoc,id);
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_track_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.assoc,e,superv.async.now.call(null));
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_free_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.dissoc,e);
});

superv.async.TrackingSupervisor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__10101__auto__,k__10102__auto__,G__60722){
var self__ = this;
var this__10101__auto____$1 = this;
var pred__60726 = cljs.core.keyword_identical_QMARK_;
var expr__60727 = k__10102__auto__;
if(cljs.core.truth_(pred__60726.call(null,new cljs.core.Keyword(null,"error","error",-978969032),expr__60727))){
return (new superv.async.TrackingSupervisor(G__60722,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__60726.call(null,new cljs.core.Keyword(null,"abort","abort",521193198),expr__60727))){
return (new superv.async.TrackingSupervisor(self__.error,G__60722,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__60726.call(null,new cljs.core.Keyword(null,"registered","registered",-388600037),expr__60727))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,G__60722,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__60726.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),expr__60727))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,G__60722,self__.__meta,self__.__extmap,null));
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__10102__auto__,G__60722),null));
}
}
}
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__10106__auto__){
var self__ = this;
var this__10106__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__10093__auto__,G__60722){
var self__ = this;
var this__10093__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,G__60722,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__10099__auto__,entry__10100__auto__){
var self__ = this;
var this__10099__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__10100__auto__)){
return this__10099__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__10100__auto__,(0)),cljs.core._nth.call(null,entry__10100__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__10099__auto____$1,entry__10100__auto__);
}
});

superv.async.TrackingSupervisor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.Symbol(null,"abort","abort",-2133242571,null),new cljs.core.Symbol(null,"registered","registered",1251931490,null),new cljs.core.Symbol(null,"pending-exceptions","pending-exceptions",-247748567,null)], null);
});

superv.async.TrackingSupervisor.cljs$lang$type = true;

superv.async.TrackingSupervisor.cljs$lang$ctorPrSeq = (function (this__10130__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"superv.async/TrackingSupervisor");
});

superv.async.TrackingSupervisor.cljs$lang$ctorPrWriter = (function (this__10130__auto__,writer__10131__auto__){
return cljs.core._write.call(null,writer__10131__auto__,"superv.async/TrackingSupervisor");
});

superv.async.__GT_TrackingSupervisor = (function superv$async$__GT_TrackingSupervisor(error,abort,registered,pending_exceptions){
return (new superv.async.TrackingSupervisor(error,abort,registered,pending_exceptions,null,null,null));
});

superv.async.map__GT_TrackingSupervisor = (function superv$async$map__GT_TrackingSupervisor(G__60724){
return (new superv.async.TrackingSupervisor(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(G__60724),new cljs.core.Keyword(null,"abort","abort",521193198).cljs$core$IFn$_invoke$arity$1(G__60724),new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(G__60724),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(G__60724),null,cljs.core.dissoc.call(null,G__60724,new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)),null));
});

cljs.core.enable_console_print_BANG_.call(null);
/**
 * A simple supervisor which deals with errors through callbacks. You need to
 *   close its abort channel manually if you want the context to stop. It is
 *   supposed to be used at a boundary to an unsupervised system. If you want
 *   strong supervision, use the restarting-supervisor instead.
 */
superv.async.simple_supervisor = (function superv$async$simple_supervisor(var_args){
var args__10647__auto__ = [];
var len__10640__auto___60754 = arguments.length;
var i__10641__auto___60755 = (0);
while(true){
if((i__10641__auto___60755 < len__10640__auto___60754)){
args__10647__auto__.push((arguments[i__10641__auto___60755]));

var G__60756 = (i__10641__auto___60755 + (1));
i__10641__auto___60755 = G__60756;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((0) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((0)),(0),null)):null);
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(argseq__10648__auto__);
});

superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (p__60731){
var map__60732 = p__60731;
var map__60732__$1 = ((((!((map__60732 == null)))?((((map__60732.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__60732.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__60732):map__60732);
var stale_timeout = cljs.core.get.call(null,map__60732__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((10) * (1000)));
var error_fn = cljs.core.get.call(null,map__60732__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),((function (map__60732,map__60732__$1,stale_timeout){
return (function (e){
return cljs.core.println.call(null,"Supervisor:",e,e.stack);
});})(map__60732,map__60732__$1,stale_timeout))
);
var pending_fn = cljs.core.get.call(null,map__60732__$1,new cljs.core.Keyword(null,"pending-fn","pending-fn",1734381755));
var s = superv.async.map__GT_TrackingSupervisor.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"abort","abort",521193198),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"registered","registered",-388600037),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null));
var err_ch = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(s);
cljs.core.async.take_BANG_.call(null,err_ch,((function (s,err_ch,map__60732,map__60732__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$loop_fn(e){
error_fn.call(null,e);

return cljs.core.async.take_BANG_.call(null,err_ch,superv$async$loop_fn);
});})(s,err_ch,map__60732,map__60732__$1,stale_timeout,error_fn,pending_fn))
);

((function (s,err_ch,map__60732,map__60732__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$pending(_){
var vec__60744 = cljs.core.filter.call(null,((function (s,err_ch,map__60732,map__60732__$1,stale_timeout,error_fn,pending_fn){
return (function (p__60750){
var vec__60751 = p__60750;
var k = cljs.core.nth.call(null,vec__60751,(0),null);
var v = cljs.core.nth.call(null,vec__60751,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout) > v.getTime());
});})(s,err_ch,map__60732,map__60732__$1,stale_timeout,error_fn,pending_fn))
,cljs.core.deref.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s)));
var vec__60747 = cljs.core.nth.call(null,vec__60744,(0),null);
var e = cljs.core.nth.call(null,vec__60747,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__60747,(1),null);
if(cljs.core.truth_(e)){
error_fn.call(null,e);

superv.async._free_exception.call(null,s,e);
} else {
}

return cljs.core.async.take_BANG_.call(null,cljs.core.async.timeout.call(null,stale_timeout),superv$async$pending);
});})(s,err_ch,map__60732,map__60732__$1,stale_timeout,error_fn,pending_fn))
.call(null,null);

return s;
});

superv.async.simple_supervisor.cljs$lang$maxFixedArity = (0);

superv.async.simple_supervisor.cljs$lang$applyTo = (function (seq60730){
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq60730));
});

superv.async.S = superv.async.simple_supervisor.call(null);
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
superv.async.throw_if_exception = (function superv$async$throw_if_exception(S,x){
if((x instanceof Error)){
superv.async._free_exception.call(null,S,x);

throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),(function (){var or__9419__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
superv.async.superv_init = (function superv$async$superv_init(){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [superv.async._error,superv.async._abort,superv.async._register_go,superv.async._unregister_go,superv.async._track_exception,superv.async._free_exception,superv.async.throw_if_exception], null);
});
goog.exportSymbol('superv.async.superv_init', superv.async.superv_init);
superv.async.superv_init.call(null);
superv.async.supervisor_QMARK_ = (function superv$async$supervisor_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.superv$async$PSupervisor$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
}
});
superv.async.check_supervisor = (function superv$async$check_supervisor(x){
if(cljs.core.truth_(superv.async.supervisor_QMARK_.call(null,x))){
return null;
} else {
throw cljs.core.ex_info.call(null,"First argument is not a supervisor.",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"argument","argument",1183001841),x], null));
}
});
/**
 * Here until http://dev.clojure.org/jira/browse/ASYNC-74 is resolved.
 */
superv.async.chan_QMARK_ = (function superv$async$chan_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$ReadPort$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
}
});
/**
 * Same as core.async/take!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.take_QMARK_ = (function superv$async$take_QMARK_(var_args){
var args60774 = [];
var len__10640__auto___60777 = arguments.length;
var i__10641__auto___60778 = (0);
while(true){
if((i__10641__auto___60778 < len__10640__auto___60777)){
args60774.push((arguments[i__10641__auto___60778]));

var G__60779 = (i__10641__auto___60778 + (1));
i__10641__auto___60778 = G__60779;
continue;
} else {
}
break;
}

var G__60776 = args60774.length;
switch (G__60776) {
case 3:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60774.length)].join('')));

}
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,fn1){
return superv.async.take_QMARK_.call(null,S,port,fn1,true);
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,fn1,on_caller_QMARK_){
return cljs.core.async.take_BANG_.call(null,port,(function (v){
if((v instanceof Error)){
superv.async._free_exception.call(null,S,v);
} else {
}

return fn1.call(null,v);
}),on_caller_QMARK_);
});

superv.async.take_QMARK_.cljs$lang$maxFixedArity = 4;

/**
 * Same as core.async/put!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.put_QMARK_ = (function superv$async$put_QMARK_(var_args){
var args60781 = [];
var len__10640__auto___60784 = arguments.length;
var i__10641__auto___60785 = (0);
while(true){
if((i__10641__auto___60785 < len__10640__auto___60784)){
args60781.push((arguments[i__10641__auto___60785]));

var G__60786 = (i__10641__auto___60785 + (1));
i__10641__auto___60785 = G__60786;
continue;
} else {
}
break;
}

var G__60783 = args60781.length;
switch (G__60783) {
case 3:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60781.length)].join('')));

}
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,val){
return superv.async.put_QMARK_.call(null,S,port,val,(function superv$async$noop(_){
return null;
}));
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,val,fn1){
return superv.async.put_QMARK_.call(null,S,port,val,fn1,true);
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5 = (function (S,port,val,fn1,on_caller_QMARK_){
return cljs.core.async.put_BANG_.call(null,port,val,(function (ret){
if(((val instanceof Error)) && (!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,val)),new cljs.core.Keyword(null,"aborted","aborted",1775972619))))){
superv.async._track_exception.call(null,S,val);
} else {
}

return fn1.call(null,ret);
}),on_caller_QMARK_);
});

superv.async.put_QMARK_.cljs$lang$maxFixedArity = 5;

/**
 * Takes objects from in-ch, asynchrously applies function f> (function should
 *   return a channel), takes the result from the returned channel and if it's
 *   truthy, puts it in the out-ch. Returns the closed out-ch. Closes the
 *   returned channel when the input channel has been completely consumed and all
 *   objects have been processed.
 *   If out-ch is not provided, an unbuffered one will be used.
 */
superv.async.pmap_GT__GT_ = (function superv$async$pmap_GT__GT_(var_args){
var args60799 = [];
var len__10640__auto___61002 = arguments.length;
var i__10641__auto___61003 = (0);
while(true){
if((i__10641__auto___61003 < len__10640__auto___61002)){
args60799.push((arguments[i__10641__auto___61003]));

var G__61004 = (i__10641__auto___61003 + (1));
i__10641__auto___61003 = G__61004;
continue;
} else {
}
break;
}

var G__60801 = args60799.length;
switch (G__60801) {
case 4:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60799.length)].join('')));

}
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4 = (function (S,f_GT_,parallelism,in_ch){
return superv.async.pmap_GT__GT_.call(null,S,f_GT_,parallelism,cljs.core.async.chan.call(null),in_ch);
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5 = (function (S,f_GT_,parallelism,out_ch,in_ch){
if(cljs.core.fn_QMARK_.call(null,f_GT_)){
} else {
throw (new Error("Assert failed: (fn? f>)"));
}

if((cljs.core.integer_QMARK_.call(null,parallelism)) && ((parallelism > (0)))){
} else {
throw (new Error("Assert failed: (and (integer? parallelism) (pos? parallelism))"));
}

if((in_ch instanceof cljs.core.async.impl.protocols.ReadPort)){
} else {
throw (new Error("Assert failed: (instance? ReadPort in-ch)"));
}

var threads = cljs.core.atom.call(null,parallelism);
var n__10440__auto___61006 = parallelism;
var __61007 = (0);
while(true){
if((__61007 < n__10440__auto___61006)){
var c__23767__auto___61008 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___61009 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"result","result",-1239343558,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)))], null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null)))))),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"zero?","zero?",325758897,null),cljs.core.list(new cljs.core.Symbol(null,"swap!","swap!",-655677516,null),new cljs.core.Symbol(null,"threads","threads",-77267207,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))));
var c__38309__auto___61010 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__61007,c__38309__auto___61010,c__23767__auto___61008,id__23768__auto___61009,n__10440__auto___61006,threads){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (__61007,c__38309__auto___61010,c__23767__auto___61008,id__23768__auto___61009,n__10440__auto___61006,threads){
return (function (state_60936){
var state_val_60937 = (state_60936[(1)]);
if((state_val_60937 === (7))){
var inst_60805 = (state_60936[(7)]);
var inst_60813 = (state_60936[(2)]);
var state_60936__$1 = (function (){var statearr_60938 = state_60936;
(statearr_60938[(8)] = inst_60813);

return statearr_60938;
})();
var statearr_60939_61011 = state_60936__$1;
(statearr_60939_61011[(2)] = inst_60805);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60936__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (20))){
var inst_60920 = (state_60936[(2)]);
var state_60936__$1 = state_60936;
var statearr_60940_61012 = state_60936__$1;
(statearr_60940_61012[(2)] = inst_60920);

(statearr_60940_61012[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (27))){
var inst_60882 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_60883 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_60884 = cljs.core.PersistentHashMap.fromArrays(inst_60882,inst_60883);
var inst_60885 = cljs.core.ex_info.call(null,"Aborted operations",inst_60884);
var state_60936__$1 = state_60936;
var statearr_60941_61013 = state_60936__$1;
(statearr_60941_61013[(2)] = inst_60885);

(statearr_60941_61013[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (1))){
var state_60936__$1 = state_60936;
var statearr_60942_61014 = state_60936__$1;
(statearr_60942_61014[(2)] = null);

(statearr_60942_61014[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (24))){
var inst_60864 = (state_60936[(2)]);
var inst_60865 = superv.async.throw_if_exception.call(null,S,inst_60864);
var inst_60866 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_60936__$1 = (function (){var statearr_60943 = state_60936;
(statearr_60943[(9)] = inst_60865);

return statearr_60943;
})();
var statearr_60944_61015 = state_60936__$1;
(statearr_60944_61015[(2)] = inst_60866);

(statearr_60944_61015[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (39))){
var state_60936__$1 = state_60936;
var statearr_60945_61016 = state_60936__$1;
(statearr_60945_61016[(2)] = null);

(statearr_60945_61016[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (4))){
var inst_60805 = (state_60936[(7)]);
var inst_60805__$1 = (state_60936[(2)]);
var inst_60806 = cljs.core.ex_data.call(null,inst_60805__$1);
var inst_60807 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_60806);
var inst_60808 = cljs.core._EQ_.call(null,inst_60807,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_60936__$1 = (function (){var statearr_60946 = state_60936;
(statearr_60946[(7)] = inst_60805__$1);

return statearr_60946;
})();
if(inst_60808){
var statearr_60947_61017 = state_60936__$1;
(statearr_60947_61017[(1)] = (5));

} else {
var statearr_60948_61018 = state_60936__$1;
(statearr_60948_61018[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (15))){
var inst_60838 = (state_60936[(10)]);
var inst_60840 = (inst_60838 instanceof Error);
var state_60936__$1 = state_60936;
if(cljs.core.truth_(inst_60840)){
var statearr_60949_61019 = state_60936__$1;
(statearr_60949_61019[(1)] = (18));

} else {
var statearr_60950_61020 = state_60936__$1;
(statearr_60950_61020[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (21))){
var inst_60845 = (state_60936[(11)]);
var inst_60851 = (state_60936[(2)]);
var inst_60852 = cljs.core.nth.call(null,inst_60851,(0),null);
var inst_60853 = cljs.core.nth.call(null,inst_60851,(1),null);
var inst_60854 = cljs.core._EQ_.call(null,inst_60853,inst_60845);
var state_60936__$1 = (function (){var statearr_60951 = state_60936;
(statearr_60951[(12)] = inst_60852);

return statearr_60951;
})();
if(inst_60854){
var statearr_60952_61021 = state_60936__$1;
(statearr_60952_61021[(1)] = (22));

} else {
var statearr_60953_61022 = state_60936__$1;
(statearr_60953_61022[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (31))){
var state_60936__$1 = state_60936;
var statearr_60954_61023 = state_60936__$1;
(statearr_60954_61023[(2)] = null);

(statearr_60954_61023[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (32))){
var inst_60917 = (state_60936[(2)]);
var state_60936__$1 = (function (){var statearr_60955 = state_60936;
(statearr_60955[(13)] = inst_60917);

return statearr_60955;
})();
var statearr_60956_61024 = state_60936__$1;
(statearr_60956_61024[(2)] = null);

(statearr_60956_61024[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (40))){
var inst_60932 = (state_60936[(2)]);
var state_60936__$1 = state_60936;
var statearr_60957_61025 = state_60936__$1;
(statearr_60957_61025[(2)] = inst_60932);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60936__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (33))){
var inst_60894 = (state_60936[(14)]);
var inst_60900 = (state_60936[(2)]);
var inst_60901 = cljs.core.nth.call(null,inst_60900,(0),null);
var inst_60902 = cljs.core.nth.call(null,inst_60900,(1),null);
var inst_60903 = cljs.core._EQ_.call(null,inst_60902,inst_60894);
var state_60936__$1 = (function (){var statearr_60958 = state_60936;
(statearr_60958[(15)] = inst_60901);

return statearr_60958;
})();
if(inst_60903){
var statearr_60959_61026 = state_60936__$1;
(statearr_60959_61026[(1)] = (34));

} else {
var statearr_60960_61027 = state_60936__$1;
(statearr_60960_61027[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (13))){
var inst_60827 = (state_60936[(16)]);
var state_60936__$1 = state_60936;
var statearr_60961_61028 = state_60936__$1;
(statearr_60961_61028[(2)] = inst_60827);

(statearr_60961_61028[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (22))){
var inst_60856 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_60857 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_60858 = cljs.core.PersistentHashMap.fromArrays(inst_60856,inst_60857);
var inst_60859 = cljs.core.ex_info.call(null,"Aborted operations",inst_60858);
var state_60936__$1 = state_60936;
var statearr_60962_61029 = state_60936__$1;
(statearr_60962_61029[(2)] = inst_60859);

(statearr_60962_61029[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (36))){
var inst_60913 = (state_60936[(2)]);
var inst_60914 = superv.async.throw_if_exception.call(null,S,inst_60913);
var state_60936__$1 = state_60936;
var statearr_60963_61030 = state_60936__$1;
(statearr_60963_61030[(2)] = inst_60914);

(statearr_60963_61030[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (29))){
var inst_60889 = (state_60936[(17)]);
var inst_60888 = (state_60936[(2)]);
var inst_60889__$1 = superv.async.throw_if_exception.call(null,S,inst_60888);
var state_60936__$1 = (function (){var statearr_60964 = state_60936;
(statearr_60964[(17)] = inst_60889__$1);

return statearr_60964;
})();
if(cljs.core.truth_(inst_60889__$1)){
var statearr_60965_61031 = state_60936__$1;
(statearr_60965_61031[(1)] = (30));

} else {
var statearr_60966_61032 = state_60936__$1;
(statearr_60966_61032[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (6))){
var inst_60805 = (state_60936[(7)]);
var inst_60811 = superv.async._track_exception.call(null,S,inst_60805);
var state_60936__$1 = state_60936;
var statearr_60967_61033 = state_60936__$1;
(statearr_60967_61033[(2)] = inst_60811);

(statearr_60967_61033[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (28))){
var inst_60878 = (state_60936[(18)]);
var state_60936__$1 = state_60936;
var statearr_60968_61034 = state_60936__$1;
(statearr_60968_61034[(2)] = inst_60878);

(statearr_60968_61034[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (25))){
var inst_60862 = (state_60936[(2)]);
var state_60936__$1 = state_60936;
var statearr_60969_61035 = state_60936__$1;
(statearr_60969_61035[(2)] = inst_60862);

(statearr_60969_61035[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (34))){
var inst_60905 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_60906 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_60907 = cljs.core.PersistentHashMap.fromArrays(inst_60905,inst_60906);
var inst_60908 = cljs.core.ex_info.call(null,"Aborted operations",inst_60907);
var state_60936__$1 = state_60936;
var statearr_60970_61036 = state_60936__$1;
(statearr_60970_61036[(2)] = inst_60908);

(statearr_60970_61036[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (17))){
var inst_60923 = (state_60936[(2)]);
var state_60936__$1 = state_60936;
var statearr_60971_61037 = state_60936__$1;
(statearr_60971_61037[(2)] = inst_60923);

(statearr_60971_61037[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (3))){
var inst_60802 = (state_60936[(2)]);
var inst_60803 = superv.async._unregister_go.call(null,S,id__23768__auto___61009);
var state_60936__$1 = (function (){var statearr_60972 = state_60936;
(statearr_60972[(19)] = inst_60803);

(statearr_60972[(20)] = inst_60802);

return statearr_60972;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60936__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (12))){
var inst_60831 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_60832 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_60833 = cljs.core.PersistentHashMap.fromArrays(inst_60831,inst_60832);
var inst_60834 = cljs.core.ex_info.call(null,"Aborted operations",inst_60833);
var state_60936__$1 = state_60936;
var statearr_60973_61038 = state_60936__$1;
(statearr_60973_61038[(2)] = inst_60834);

(statearr_60973_61038[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (2))){
var inst_60934 = (state_60936[(2)]);
var state_60936__$1 = state_60936;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60936__$1,inst_60934);
} else {
if((state_val_60937 === (23))){
var inst_60838 = (state_60936[(10)]);
var state_60936__$1 = state_60936;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60936__$1,(25),out_ch,inst_60838);
} else {
if((state_val_60937 === (35))){
var inst_60889 = (state_60936[(17)]);
var state_60936__$1 = state_60936;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60936__$1,(37),out_ch,inst_60889);
} else {
if((state_val_60937 === (19))){
var inst_60838 = (state_60936[(10)]);
var inst_60871 = (state_60936[(21)]);
var inst_60871__$1 = superv.async._abort.call(null,S);
var inst_60872 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60873 = f_GT_.call(null,inst_60838);
var inst_60874 = [inst_60871__$1,inst_60873];
var inst_60875 = (new cljs.core.PersistentVector(null,2,(5),inst_60872,inst_60874,null));
var state_60936__$1 = (function (){var statearr_60974 = state_60936;
(statearr_60974[(21)] = inst_60871__$1);

return statearr_60974;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_60936__$1,(26),inst_60875,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_60937 === (11))){
var inst_60821 = (state_60936[(22)]);
var inst_60826 = (state_60936[(2)]);
var inst_60827 = cljs.core.nth.call(null,inst_60826,(0),null);
var inst_60828 = cljs.core.nth.call(null,inst_60826,(1),null);
var inst_60829 = cljs.core._EQ_.call(null,inst_60828,inst_60821);
var state_60936__$1 = (function (){var statearr_60975 = state_60936;
(statearr_60975[(16)] = inst_60827);

return statearr_60975;
})();
if(inst_60829){
var statearr_60976_61039 = state_60936__$1;
(statearr_60976_61039[(1)] = (12));

} else {
var statearr_60977_61040 = state_60936__$1;
(statearr_60977_61040[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (9))){
var inst_60821 = (state_60936[(22)]);
var inst_60821__$1 = superv.async._abort.call(null,S);
var inst_60822 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60823 = [inst_60821__$1,in_ch];
var inst_60824 = (new cljs.core.PersistentVector(null,2,(5),inst_60822,inst_60823,null));
var state_60936__$1 = (function (){var statearr_60978 = state_60936;
(statearr_60978[(22)] = inst_60821__$1);

return statearr_60978;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_60936__$1,(11),inst_60824,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_60937 === (5))){
var state_60936__$1 = state_60936;
var statearr_60979_61041 = state_60936__$1;
(statearr_60979_61041[(2)] = null);

(statearr_60979_61041[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (14))){
var inst_60838 = (state_60936[(10)]);
var inst_60837 = (state_60936[(2)]);
var inst_60838__$1 = superv.async.throw_if_exception.call(null,S,inst_60837);
var state_60936__$1 = (function (){var statearr_60980 = state_60936;
(statearr_60980[(10)] = inst_60838__$1);

return statearr_60980;
})();
if(cljs.core.truth_(inst_60838__$1)){
var statearr_60981_61042 = state_60936__$1;
(statearr_60981_61042[(1)] = (15));

} else {
var statearr_60982_61043 = state_60936__$1;
(statearr_60982_61043[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (26))){
var inst_60871 = (state_60936[(21)]);
var inst_60877 = (state_60936[(2)]);
var inst_60878 = cljs.core.nth.call(null,inst_60877,(0),null);
var inst_60879 = cljs.core.nth.call(null,inst_60877,(1),null);
var inst_60880 = cljs.core._EQ_.call(null,inst_60879,inst_60871);
var state_60936__$1 = (function (){var statearr_60983 = state_60936;
(statearr_60983[(18)] = inst_60878);

return statearr_60983;
})();
if(inst_60880){
var statearr_60984_61044 = state_60936__$1;
(statearr_60984_61044[(1)] = (27));

} else {
var statearr_60985_61045 = state_60936__$1;
(statearr_60985_61045[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (16))){
var state_60936__$1 = state_60936;
var statearr_60986_61046 = state_60936__$1;
(statearr_60986_61046[(2)] = null);

(statearr_60986_61046[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (38))){
var inst_60929 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_60936__$1 = state_60936;
var statearr_60987_61047 = state_60936__$1;
(statearr_60987_61047[(2)] = inst_60929);

(statearr_60987_61047[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (30))){
var inst_60894 = (state_60936[(14)]);
var inst_60894__$1 = superv.async._abort.call(null,S);
var inst_60895 = cljs.core.async.timeout.call(null,(0));
var inst_60896 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60897 = [inst_60894__$1,inst_60895];
var inst_60898 = (new cljs.core.PersistentVector(null,2,(5),inst_60896,inst_60897,null));
var state_60936__$1 = (function (){var statearr_60988 = state_60936;
(statearr_60988[(14)] = inst_60894__$1);

return statearr_60988;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_60936__$1,(33),inst_60898,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_60937 === (10))){
var inst_60925 = (state_60936[(2)]);
var inst_60926 = cljs.core.swap_BANG_.call(null,threads,cljs.core.dec);
var inst_60927 = (inst_60926 === (0));
var state_60936__$1 = (function (){var statearr_60989 = state_60936;
(statearr_60989[(23)] = inst_60925);

return statearr_60989;
})();
if(cljs.core.truth_(inst_60927)){
var statearr_60990_61048 = state_60936__$1;
(statearr_60990_61048[(1)] = (38));

} else {
var statearr_60991_61049 = state_60936__$1;
(statearr_60991_61049[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (18))){
var inst_60845 = (state_60936[(11)]);
var inst_60845__$1 = superv.async._abort.call(null,S);
var inst_60846 = cljs.core.async.timeout.call(null,(0));
var inst_60847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60848 = [inst_60845__$1,inst_60846];
var inst_60849 = (new cljs.core.PersistentVector(null,2,(5),inst_60847,inst_60848,null));
var state_60936__$1 = (function (){var statearr_60992 = state_60936;
(statearr_60992[(11)] = inst_60845__$1);

return statearr_60992;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_60936__$1,(21),inst_60849,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_60937 === (37))){
var inst_60911 = (state_60936[(2)]);
var state_60936__$1 = state_60936;
var statearr_60993_61050 = state_60936__$1;
(statearr_60993_61050[(2)] = inst_60911);

(statearr_60993_61050[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60937 === (8))){
var ___$1 = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_60936,(4),Error,(3),(2));
var state_60936__$1 = state_60936;
var statearr_60994_61051 = state_60936__$1;
(statearr_60994_61051[(2)] = null);

(statearr_60994_61051[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(__61007,c__38309__auto___61010,c__23767__auto___61008,id__23768__auto___61009,n__10440__auto___61006,threads))
;
return ((function (__61007,switch__38195__auto__,c__38309__auto___61010,c__23767__auto___61008,id__23768__auto___61009,n__10440__auto___61006,threads){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_60998 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60998[(0)] = superv$async$state_machine__38196__auto__);

(statearr_60998[(1)] = (1));

return statearr_60998;
});
var superv$async$state_machine__38196__auto____1 = (function (state_60936){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_60936);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e60999){if((e60999 instanceof Object)){
var ex__38199__auto__ = e60999;
var statearr_61000_61052 = state_60936;
(statearr_61000_61052[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60936);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60999;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61053 = state_60936;
state_60936 = G__61053;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_60936){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_60936);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(__61007,switch__38195__auto__,c__38309__auto___61010,c__23767__auto___61008,id__23768__auto___61009,n__10440__auto___61006,threads))
})();
var state__38311__auto__ = (function (){var statearr_61001 = f__38310__auto__.call(null);
(statearr_61001[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___61010);

return statearr_61001;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(__61007,c__38309__auto___61010,c__23767__auto___61008,id__23768__auto___61009,n__10440__auto___61006,threads))
);


var G__61054 = (__61007 + (1));
__61007 = G__61054;
continue;
} else {
}
break;
}

return out_ch;
});

superv.async.pmap_GT__GT_.cljs$lang$maxFixedArity = 5;

/**
 * Similiar to dorun. Simply takes messages from channels but does nothing with
 *   them. Returns channel that will close when all messages have been consumed.
 */
superv.async.engulf = (function superv$async$engulf(var_args){
var args__10647__auto__ = [];
var len__10640__auto___61135 = arguments.length;
var i__10641__auto___61136 = (0);
while(true){
if((i__10641__auto___61136 < len__10640__auto___61135)){
args__10647__auto__.push((arguments[i__10641__auto___61136]));

var G__61137 = (i__10641__auto___61136 + (1));
i__10641__auto___61136 = G__61137;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var ch = cljs.core.async.merge.call(null,cs);
var c__23767__auto__ = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto__ = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null))))));
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__,c__23767__auto__,id__23768__auto__,ch){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__,c__23767__auto__,id__23768__auto__,ch){
return (function (state_61104){
var state_val_61105 = (state_61104[(1)]);
if((state_val_61105 === (7))){
var inst_61060 = (state_61104[(7)]);
var inst_61068 = (state_61104[(2)]);
var state_61104__$1 = (function (){var statearr_61106 = state_61104;
(statearr_61106[(8)] = inst_61068);

return statearr_61106;
})();
var statearr_61107_61138 = state_61104__$1;
(statearr_61107_61138[(2)] = inst_61060);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61104__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (1))){
var state_61104__$1 = state_61104;
var statearr_61108_61139 = state_61104__$1;
(statearr_61108_61139[(2)] = null);

(statearr_61108_61139[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (4))){
var inst_61060 = (state_61104[(7)]);
var inst_61060__$1 = (state_61104[(2)]);
var inst_61061 = cljs.core.ex_data.call(null,inst_61060__$1);
var inst_61062 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_61061);
var inst_61063 = cljs.core._EQ_.call(null,inst_61062,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_61104__$1 = (function (){var statearr_61109 = state_61104;
(statearr_61109[(7)] = inst_61060__$1);

return statearr_61109;
})();
if(inst_61063){
var statearr_61110_61140 = state_61104__$1;
(statearr_61110_61140[(1)] = (5));

} else {
var statearr_61111_61141 = state_61104__$1;
(statearr_61111_61141[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (15))){
var state_61104__$1 = state_61104;
var statearr_61112_61142 = state_61104__$1;
(statearr_61112_61142[(2)] = null);

(statearr_61112_61142[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (13))){
var inst_61082 = (state_61104[(9)]);
var state_61104__$1 = state_61104;
var statearr_61113_61143 = state_61104__$1;
(statearr_61113_61143[(2)] = inst_61082);

(statearr_61113_61143[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (6))){
var inst_61060 = (state_61104[(7)]);
var inst_61066 = superv.async._track_exception.call(null,S,inst_61060);
var state_61104__$1 = state_61104;
var statearr_61114_61144 = state_61104__$1;
(statearr_61114_61144[(2)] = inst_61066);

(statearr_61114_61144[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (17))){
var inst_61098 = (state_61104[(2)]);
var state_61104__$1 = state_61104;
var statearr_61115_61145 = state_61104__$1;
(statearr_61115_61145[(2)] = inst_61098);

(statearr_61115_61145[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (3))){
var inst_61057 = (state_61104[(2)]);
var inst_61058 = superv.async._unregister_go.call(null,S,id__23768__auto__);
var state_61104__$1 = (function (){var statearr_61116 = state_61104;
(statearr_61116[(10)] = inst_61057);

(statearr_61116[(11)] = inst_61058);

return statearr_61116;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61104__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (12))){
var inst_61086 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61087 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61088 = cljs.core.PersistentHashMap.fromArrays(inst_61086,inst_61087);
var inst_61089 = cljs.core.ex_info.call(null,"Aborted operations",inst_61088);
var state_61104__$1 = state_61104;
var statearr_61117_61146 = state_61104__$1;
(statearr_61117_61146[(2)] = inst_61089);

(statearr_61117_61146[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (2))){
var inst_61102 = (state_61104[(2)]);
var state_61104__$1 = state_61104;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61104__$1,inst_61102);
} else {
if((state_val_61105 === (11))){
var inst_61076 = (state_61104[(12)]);
var inst_61081 = (state_61104[(2)]);
var inst_61082 = cljs.core.nth.call(null,inst_61081,(0),null);
var inst_61083 = cljs.core.nth.call(null,inst_61081,(1),null);
var inst_61084 = cljs.core._EQ_.call(null,inst_61083,inst_61076);
var state_61104__$1 = (function (){var statearr_61118 = state_61104;
(statearr_61118[(9)] = inst_61082);

return statearr_61118;
})();
if(inst_61084){
var statearr_61119_61147 = state_61104__$1;
(statearr_61119_61147[(1)] = (12));

} else {
var statearr_61120_61148 = state_61104__$1;
(statearr_61120_61148[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (9))){
var inst_61076 = (state_61104[(12)]);
var inst_61076__$1 = superv.async._abort.call(null,S);
var inst_61077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61078 = [inst_61076__$1,ch];
var inst_61079 = (new cljs.core.PersistentVector(null,2,(5),inst_61077,inst_61078,null));
var state_61104__$1 = (function (){var statearr_61121 = state_61104;
(statearr_61121[(12)] = inst_61076__$1);

return statearr_61121;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61104__$1,(11),inst_61079,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_61105 === (5))){
var state_61104__$1 = state_61104;
var statearr_61122_61149 = state_61104__$1;
(statearr_61122_61149[(2)] = null);

(statearr_61122_61149[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (14))){
var inst_61092 = (state_61104[(2)]);
var inst_61093 = superv.async.throw_if_exception.call(null,S,inst_61092);
var state_61104__$1 = state_61104;
if(cljs.core.truth_(inst_61093)){
var statearr_61123_61150 = state_61104__$1;
(statearr_61123_61150[(1)] = (15));

} else {
var statearr_61124_61151 = state_61104__$1;
(statearr_61124_61151[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (16))){
var state_61104__$1 = state_61104;
var statearr_61125_61152 = state_61104__$1;
(statearr_61125_61152[(2)] = null);

(statearr_61125_61152[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (10))){
var inst_61100 = (state_61104[(2)]);
var state_61104__$1 = state_61104;
var statearr_61126_61153 = state_61104__$1;
(statearr_61126_61153[(2)] = inst_61100);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61104__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61105 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_61104,(4),Error,(3),(2));
var state_61104__$1 = state_61104;
var statearr_61127_61154 = state_61104__$1;
(statearr_61127_61154[(2)] = null);

(statearr_61127_61154[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto__,c__23767__auto__,id__23768__auto__,ch))
;
return ((function (switch__38195__auto__,c__38309__auto__,c__23767__auto__,id__23768__auto__,ch){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_61131 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61131[(0)] = superv$async$state_machine__38196__auto__);

(statearr_61131[(1)] = (1));

return statearr_61131;
});
var superv$async$state_machine__38196__auto____1 = (function (state_61104){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_61104);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e61132){if((e61132 instanceof Object)){
var ex__38199__auto__ = e61132;
var statearr_61133_61155 = state_61104;
(statearr_61133_61155[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61104);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e61132;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61156 = state_61104;
state_61104 = G__61156;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_61104){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_61104);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__,c__23767__auto__,id__23768__auto__,ch))
})();
var state__38311__auto__ = (function (){var statearr_61134 = f__38310__auto__.call(null);
(statearr_61134[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_61134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__,c__23767__auto__,id__23768__auto__,ch))
);

return c__38309__auto__;
});

superv.async.engulf.cljs$lang$maxFixedArity = (1);

superv.async.engulf.cljs$lang$applyTo = (function (seq61055){
var G__61056 = cljs.core.first.call(null,seq61055);
var seq61055__$1 = cljs.core.next.call(null,seq61055);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic(G__61056,seq61055__$1);
});

/**
 * Performs a reduce on objects from ch with the function f> (which
 *   should return a channel). Returns a channel with the resulting
 *   value.
 */
superv.async.reduce_GT_ = (function superv$async$reduce_GT_(S,f_GT_,acc,ch){
var result = cljs.core.async.chan.call(null);
var c__23767__auto___61523 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___61524 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"->>","->>",-1874332161,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null)),new cljs.core.Symbol(null,"recur","recur",1202958259,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null)))))));
var c__38309__auto___61525 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___61525,c__23767__auto___61523,id__23768__auto___61524,result){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___61525,c__23767__auto___61523,id__23768__auto___61524,result){
return (function (state_61465){
var state_val_61466 = (state_61465[(1)]);
if((state_val_61466 === (7))){
var inst_61343 = (state_61465[(7)]);
var inst_61351 = (state_61465[(2)]);
var state_61465__$1 = (function (){var statearr_61467 = state_61465;
(statearr_61467[(8)] = inst_61351);

return statearr_61467;
})();
var statearr_61468_61526 = state_61465__$1;
(statearr_61468_61526[(2)] = inst_61343);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61465__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (20))){
var inst_61431 = (state_61465[(2)]);
var state_61465__$1 = state_61465;
var statearr_61469_61527 = state_61465__$1;
(statearr_61469_61527[(2)] = inst_61431);

(statearr_61469_61527[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (27))){
var inst_61421 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61422 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61423 = cljs.core.PersistentHashMap.fromArrays(inst_61421,inst_61422);
var inst_61424 = cljs.core.ex_info.call(null,"Aborted operations",inst_61423);
var state_61465__$1 = state_61465;
var statearr_61470_61528 = state_61465__$1;
(statearr_61470_61528[(2)] = inst_61424);

(statearr_61470_61528[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (1))){
var state_61465__$1 = state_61465;
var statearr_61471_61529 = state_61465__$1;
(statearr_61471_61529[(2)] = null);

(statearr_61471_61529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (24))){
var inst_61403 = (state_61465[(2)]);
var inst_61404 = superv.async.throw_if_exception.call(null,S,inst_61403);
var inst_61405 = cljs.core.async.close_BANG_.call(null,result);
var state_61465__$1 = (function (){var statearr_61472 = state_61465;
(statearr_61472[(9)] = inst_61404);

return statearr_61472;
})();
var statearr_61473_61530 = state_61465__$1;
(statearr_61473_61530[(2)] = inst_61405);

(statearr_61473_61530[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (4))){
var inst_61343 = (state_61465[(7)]);
var inst_61343__$1 = (state_61465[(2)]);
var inst_61344 = cljs.core.ex_data.call(null,inst_61343__$1);
var inst_61345 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_61344);
var inst_61346 = cljs.core._EQ_.call(null,inst_61345,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_61465__$1 = (function (){var statearr_61474 = state_61465;
(statearr_61474[(7)] = inst_61343__$1);

return statearr_61474;
})();
if(inst_61346){
var statearr_61475_61531 = state_61465__$1;
(statearr_61475_61531[(1)] = (5));

} else {
var statearr_61476_61532 = state_61465__$1;
(statearr_61476_61532[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (15))){
var inst_61377 = (state_61465[(10)]);
var inst_61379 = (inst_61377 instanceof Error);
var state_61465__$1 = state_61465;
if(cljs.core.truth_(inst_61379)){
var statearr_61477_61533 = state_61465__$1;
(statearr_61477_61533[(1)] = (18));

} else {
var statearr_61478_61534 = state_61465__$1;
(statearr_61478_61534[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (21))){
var inst_61384 = (state_61465[(11)]);
var inst_61390 = (state_61465[(2)]);
var inst_61391 = cljs.core.nth.call(null,inst_61390,(0),null);
var inst_61392 = cljs.core.nth.call(null,inst_61390,(1),null);
var inst_61393 = cljs.core._EQ_.call(null,inst_61392,inst_61384);
var state_61465__$1 = (function (){var statearr_61479 = state_61465;
(statearr_61479[(12)] = inst_61391);

return statearr_61479;
})();
if(inst_61393){
var statearr_61480_61535 = state_61465__$1;
(statearr_61480_61535[(1)] = (22));

} else {
var statearr_61481_61536 = state_61465__$1;
(statearr_61481_61536[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (31))){
var inst_61447 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61448 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61449 = cljs.core.PersistentHashMap.fromArrays(inst_61447,inst_61448);
var inst_61450 = cljs.core.ex_info.call(null,"Aborted operations",inst_61449);
var state_61465__$1 = state_61465;
var statearr_61482_61537 = state_61465__$1;
(statearr_61482_61537[(2)] = inst_61450);

(statearr_61482_61537[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (32))){
var inst_61355 = (state_61465[(13)]);
var state_61465__$1 = state_61465;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_61465__$1,(34),result,inst_61355);
} else {
if((state_val_61466 === (33))){
var inst_61455 = (state_61465[(2)]);
var inst_61456 = superv.async.throw_if_exception.call(null,S,inst_61455);
var inst_61457 = cljs.core.async.close_BANG_.call(null,result);
var state_61465__$1 = (function (){var statearr_61483 = state_61465;
(statearr_61483[(14)] = inst_61456);

return statearr_61483;
})();
var statearr_61484_61538 = state_61465__$1;
(statearr_61484_61538[(2)] = inst_61457);

(statearr_61484_61538[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (13))){
var inst_61366 = (state_61465[(15)]);
var state_61465__$1 = state_61465;
var statearr_61485_61539 = state_61465__$1;
(statearr_61485_61539[(2)] = inst_61366);

(statearr_61485_61539[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (22))){
var inst_61395 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61396 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61397 = cljs.core.PersistentHashMap.fromArrays(inst_61395,inst_61396);
var inst_61398 = cljs.core.ex_info.call(null,"Aborted operations",inst_61397);
var state_61465__$1 = state_61465;
var statearr_61486_61540 = state_61465__$1;
(statearr_61486_61540[(2)] = inst_61398);

(statearr_61486_61540[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (29))){
var inst_61427 = (state_61465[(2)]);
var inst_61428 = superv.async.throw_if_exception.call(null,S,inst_61427);
var inst_61355 = inst_61428;
var state_61465__$1 = (function (){var statearr_61487 = state_61465;
(statearr_61487[(13)] = inst_61355);

return statearr_61487;
})();
var statearr_61488_61541 = state_61465__$1;
(statearr_61488_61541[(2)] = null);

(statearr_61488_61541[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (6))){
var inst_61343 = (state_61465[(7)]);
var inst_61349 = superv.async._track_exception.call(null,S,inst_61343);
var state_61465__$1 = state_61465;
var statearr_61489_61542 = state_61465__$1;
(statearr_61489_61542[(2)] = inst_61349);

(statearr_61489_61542[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (28))){
var inst_61417 = (state_61465[(16)]);
var state_61465__$1 = state_61465;
var statearr_61490_61543 = state_61465__$1;
(statearr_61490_61543[(2)] = inst_61417);

(statearr_61490_61543[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (25))){
var inst_61401 = (state_61465[(2)]);
var state_61465__$1 = state_61465;
var statearr_61491_61544 = state_61465__$1;
(statearr_61491_61544[(2)] = inst_61401);

(statearr_61491_61544[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (34))){
var inst_61453 = (state_61465[(2)]);
var state_61465__$1 = state_61465;
var statearr_61492_61545 = state_61465__$1;
(statearr_61492_61545[(2)] = inst_61453);

(statearr_61492_61545[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (17))){
var inst_61459 = (state_61465[(2)]);
var state_61465__$1 = state_61465;
var statearr_61493_61546 = state_61465__$1;
(statearr_61493_61546[(2)] = inst_61459);

(statearr_61493_61546[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (3))){
var inst_61340 = (state_61465[(2)]);
var inst_61341 = superv.async._unregister_go.call(null,S,id__23768__auto___61524);
var state_61465__$1 = (function (){var statearr_61494 = state_61465;
(statearr_61494[(17)] = inst_61341);

(statearr_61494[(18)] = inst_61340);

return statearr_61494;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61465__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (12))){
var inst_61370 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61371 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61372 = cljs.core.PersistentHashMap.fromArrays(inst_61370,inst_61371);
var inst_61373 = cljs.core.ex_info.call(null,"Aborted operations",inst_61372);
var state_61465__$1 = state_61465;
var statearr_61495_61547 = state_61465__$1;
(statearr_61495_61547[(2)] = inst_61373);

(statearr_61495_61547[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (2))){
var inst_61463 = (state_61465[(2)]);
var state_61465__$1 = state_61465;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61465__$1,inst_61463);
} else {
if((state_val_61466 === (23))){
var inst_61377 = (state_61465[(10)]);
var state_61465__$1 = state_61465;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_61465__$1,(25),result,inst_61377);
} else {
if((state_val_61466 === (19))){
var inst_61377 = (state_61465[(10)]);
var inst_61355 = (state_61465[(13)]);
var inst_61410 = (state_61465[(19)]);
var inst_61410__$1 = superv.async._abort.call(null,S);
var inst_61411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61412 = f_GT_.call(null,inst_61355,inst_61377);
var inst_61413 = [inst_61410__$1,inst_61412];
var inst_61414 = (new cljs.core.PersistentVector(null,2,(5),inst_61411,inst_61413,null));
var state_61465__$1 = (function (){var statearr_61496 = state_61465;
(statearr_61496[(19)] = inst_61410__$1);

return statearr_61496;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61465__$1,(26),inst_61414,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_61466 === (11))){
var inst_61360 = (state_61465[(20)]);
var inst_61365 = (state_61465[(2)]);
var inst_61366 = cljs.core.nth.call(null,inst_61365,(0),null);
var inst_61367 = cljs.core.nth.call(null,inst_61365,(1),null);
var inst_61368 = cljs.core._EQ_.call(null,inst_61367,inst_61360);
var state_61465__$1 = (function (){var statearr_61497 = state_61465;
(statearr_61497[(15)] = inst_61366);

return statearr_61497;
})();
if(inst_61368){
var statearr_61498_61548 = state_61465__$1;
(statearr_61498_61548[(1)] = (12));

} else {
var statearr_61499_61549 = state_61465__$1;
(statearr_61499_61549[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (9))){
var inst_61360 = (state_61465[(20)]);
var inst_61360__$1 = superv.async._abort.call(null,S);
var inst_61361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61362 = [inst_61360__$1,ch];
var inst_61363 = (new cljs.core.PersistentVector(null,2,(5),inst_61361,inst_61362,null));
var state_61465__$1 = (function (){var statearr_61500 = state_61465;
(statearr_61500[(20)] = inst_61360__$1);

return statearr_61500;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61465__$1,(11),inst_61363,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_61466 === (5))){
var state_61465__$1 = state_61465;
var statearr_61501_61550 = state_61465__$1;
(statearr_61501_61550[(2)] = null);

(statearr_61501_61550[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (14))){
var inst_61377 = (state_61465[(10)]);
var inst_61376 = (state_61465[(2)]);
var inst_61377__$1 = superv.async.throw_if_exception.call(null,S,inst_61376);
var state_61465__$1 = (function (){var statearr_61502 = state_61465;
(statearr_61502[(10)] = inst_61377__$1);

return statearr_61502;
})();
if(cljs.core.truth_(inst_61377__$1)){
var statearr_61503_61551 = state_61465__$1;
(statearr_61503_61551[(1)] = (15));

} else {
var statearr_61504_61552 = state_61465__$1;
(statearr_61504_61552[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (26))){
var inst_61410 = (state_61465[(19)]);
var inst_61416 = (state_61465[(2)]);
var inst_61417 = cljs.core.nth.call(null,inst_61416,(0),null);
var inst_61418 = cljs.core.nth.call(null,inst_61416,(1),null);
var inst_61419 = cljs.core._EQ_.call(null,inst_61418,inst_61410);
var state_61465__$1 = (function (){var statearr_61505 = state_61465;
(statearr_61505[(16)] = inst_61417);

return statearr_61505;
})();
if(inst_61419){
var statearr_61506_61553 = state_61465__$1;
(statearr_61506_61553[(1)] = (27));

} else {
var statearr_61507_61554 = state_61465__$1;
(statearr_61507_61554[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (16))){
var inst_61436 = (state_61465[(21)]);
var inst_61436__$1 = superv.async._abort.call(null,S);
var inst_61437 = cljs.core.async.timeout.call(null,(0));
var inst_61438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61439 = [inst_61436__$1,inst_61437];
var inst_61440 = (new cljs.core.PersistentVector(null,2,(5),inst_61438,inst_61439,null));
var state_61465__$1 = (function (){var statearr_61508 = state_61465;
(statearr_61508[(21)] = inst_61436__$1);

return statearr_61508;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61465__$1,(30),inst_61440,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_61466 === (30))){
var inst_61436 = (state_61465[(21)]);
var inst_61442 = (state_61465[(2)]);
var inst_61443 = cljs.core.nth.call(null,inst_61442,(0),null);
var inst_61444 = cljs.core.nth.call(null,inst_61442,(1),null);
var inst_61445 = cljs.core._EQ_.call(null,inst_61444,inst_61436);
var state_61465__$1 = (function (){var statearr_61509 = state_61465;
(statearr_61509[(22)] = inst_61443);

return statearr_61509;
})();
if(inst_61445){
var statearr_61510_61555 = state_61465__$1;
(statearr_61510_61555[(1)] = (31));

} else {
var statearr_61511_61556 = state_61465__$1;
(statearr_61511_61556[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (10))){
var inst_61461 = (state_61465[(2)]);
var state_61465__$1 = state_61465;
var statearr_61512_61557 = state_61465__$1;
(statearr_61512_61557[(2)] = inst_61461);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61465__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61466 === (18))){
var inst_61384 = (state_61465[(11)]);
var inst_61384__$1 = superv.async._abort.call(null,S);
var inst_61385 = cljs.core.async.timeout.call(null,(0));
var inst_61386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61387 = [inst_61384__$1,inst_61385];
var inst_61388 = (new cljs.core.PersistentVector(null,2,(5),inst_61386,inst_61387,null));
var state_61465__$1 = (function (){var statearr_61513 = state_61465;
(statearr_61513[(11)] = inst_61384__$1);

return statearr_61513;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61465__$1,(21),inst_61388,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_61466 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_61465,(4),Error,(3),(2));
var inst_61355 = acc;
var state_61465__$1 = (function (){var statearr_61514 = state_61465;
(statearr_61514[(13)] = inst_61355);

return statearr_61514;
})();
var statearr_61515_61558 = state_61465__$1;
(statearr_61515_61558[(2)] = null);

(statearr_61515_61558[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___61525,c__23767__auto___61523,id__23768__auto___61524,result))
;
return ((function (switch__38195__auto__,c__38309__auto___61525,c__23767__auto___61523,id__23768__auto___61524,result){
return (function() {
var superv$async$reduce_GT__$_state_machine__38196__auto__ = null;
var superv$async$reduce_GT__$_state_machine__38196__auto____0 = (function (){
var statearr_61519 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61519[(0)] = superv$async$reduce_GT__$_state_machine__38196__auto__);

(statearr_61519[(1)] = (1));

return statearr_61519;
});
var superv$async$reduce_GT__$_state_machine__38196__auto____1 = (function (state_61465){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_61465);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e61520){if((e61520 instanceof Object)){
var ex__38199__auto__ = e61520;
var statearr_61521_61559 = state_61465;
(statearr_61521_61559[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61465);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e61520;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61560 = state_61465;
state_61465 = G__61560;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$reduce_GT__$_state_machine__38196__auto__ = function(state_61465){
switch(arguments.length){
case 0:
return superv$async$reduce_GT__$_state_machine__38196__auto____0.call(this);
case 1:
return superv$async$reduce_GT__$_state_machine__38196__auto____1.call(this,state_61465);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$reduce_GT__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$reduce_GT__$_state_machine__38196__auto____0;
superv$async$reduce_GT__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$reduce_GT__$_state_machine__38196__auto____1;
return superv$async$reduce_GT__$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___61525,c__23767__auto___61523,id__23768__auto___61524,result))
})();
var state__38311__auto__ = (function (){var statearr_61522 = f__38310__auto__.call(null);
(statearr_61522[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___61525);

return statearr_61522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___61525,c__23767__auto___61523,id__23768__auto___61524,result))
);


return result;
});
/**
 * Concatenates two or more channels. First takes all values from first channel
 *   and supplies to output channel, then takes all values from second channel and
 *   so on. Similiar to core.async/merge but maintains the order of values.
 */
superv.async.concat_GT__GT_ = (function superv$async$concat_GT__GT_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___61690 = arguments.length;
var i__10641__auto___61691 = (0);
while(true){
if((i__10641__auto___61691 < len__10640__auto___61690)){
args__10647__auto__.push((arguments[i__10641__auto___61691]));

var G__61692 = (i__10641__auto___61691 + (1));
i__10641__auto___61691 = G__61692;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var out = cljs.core.async.chan.call(null);
var c__23767__auto___61693 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___61694 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"c","c",-122660552,null),cljs.core.list(new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"c","c",-122660552,null))], null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"v","v",1661996586,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.list(new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null))))));
var c__38309__auto___61695 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___61695,c__23767__auto___61693,id__23768__auto___61694,out){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___61695,c__23767__auto___61693,id__23768__auto___61694,out){
return (function (state_61643){
var state_val_61644 = (state_61643[(1)]);
if((state_val_61644 === (7))){
var inst_61566 = (state_61643[(7)]);
var inst_61574 = (state_61643[(2)]);
var state_61643__$1 = (function (){var statearr_61646 = state_61643;
(statearr_61646[(8)] = inst_61574);

return statearr_61646;
})();
var statearr_61647_61696 = state_61643__$1;
(statearr_61647_61696[(2)] = inst_61566);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61643__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (20))){
var inst_61633 = (state_61643[(2)]);
var state_61643__$1 = state_61643;
var statearr_61648_61697 = state_61643__$1;
(statearr_61648_61697[(2)] = inst_61633);

(statearr_61648_61697[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (1))){
var state_61643__$1 = state_61643;
var statearr_61649_61698 = state_61643__$1;
(statearr_61649_61698[(2)] = null);

(statearr_61649_61698[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (24))){
var inst_61578 = (state_61643[(9)]);
var inst_61626 = (state_61643[(2)]);
var inst_61627 = superv.async.throw_if_exception.call(null,S,inst_61626);
var tmp61645 = inst_61578;
var inst_61578__$1 = tmp61645;
var state_61643__$1 = (function (){var statearr_61650 = state_61643;
(statearr_61650[(9)] = inst_61578__$1);

(statearr_61650[(10)] = inst_61627);

return statearr_61650;
})();
var statearr_61651_61699 = state_61643__$1;
(statearr_61651_61699[(2)] = null);

(statearr_61651_61699[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (4))){
var inst_61566 = (state_61643[(7)]);
var inst_61566__$1 = (state_61643[(2)]);
var inst_61567 = cljs.core.ex_data.call(null,inst_61566__$1);
var inst_61568 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_61567);
var inst_61569 = cljs.core._EQ_.call(null,inst_61568,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_61643__$1 = (function (){var statearr_61652 = state_61643;
(statearr_61652[(7)] = inst_61566__$1);

return statearr_61652;
})();
if(inst_61569){
var statearr_61653_61700 = state_61643__$1;
(statearr_61653_61700[(1)] = (5));

} else {
var statearr_61654_61701 = state_61643__$1;
(statearr_61654_61701[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (15))){
var inst_61595 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61596 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61597 = cljs.core.PersistentHashMap.fromArrays(inst_61595,inst_61596);
var inst_61598 = cljs.core.ex_info.call(null,"Aborted operations",inst_61597);
var state_61643__$1 = state_61643;
var statearr_61655_61702 = state_61643__$1;
(statearr_61655_61702[(2)] = inst_61598);

(statearr_61655_61702[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (21))){
var inst_61607 = (state_61643[(11)]);
var inst_61613 = (state_61643[(2)]);
var inst_61614 = cljs.core.nth.call(null,inst_61613,(0),null);
var inst_61615 = cljs.core.nth.call(null,inst_61613,(1),null);
var inst_61616 = cljs.core._EQ_.call(null,inst_61615,inst_61607);
var state_61643__$1 = (function (){var statearr_61656 = state_61643;
(statearr_61656[(12)] = inst_61614);

return statearr_61656;
})();
if(inst_61616){
var statearr_61657_61703 = state_61643__$1;
(statearr_61657_61703[(1)] = (22));

} else {
var statearr_61658_61704 = state_61643__$1;
(statearr_61658_61704[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (13))){
var inst_61637 = (state_61643[(2)]);
var state_61643__$1 = state_61643;
var statearr_61659_61705 = state_61643__$1;
(statearr_61659_61705[(2)] = inst_61637);

(statearr_61659_61705[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (22))){
var inst_61618 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61619 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61620 = cljs.core.PersistentHashMap.fromArrays(inst_61618,inst_61619);
var inst_61621 = cljs.core.ex_info.call(null,"Aborted operations",inst_61620);
var state_61643__$1 = state_61643;
var statearr_61660_61706 = state_61643__$1;
(statearr_61660_61706[(2)] = inst_61621);

(statearr_61660_61706[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (6))){
var inst_61566 = (state_61643[(7)]);
var inst_61572 = superv.async._track_exception.call(null,S,inst_61566);
var state_61643__$1 = state_61643;
var statearr_61661_61707 = state_61643__$1;
(statearr_61661_61707[(2)] = inst_61572);

(statearr_61661_61707[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (25))){
var inst_61624 = (state_61643[(2)]);
var state_61643__$1 = state_61643;
var statearr_61662_61708 = state_61643__$1;
(statearr_61662_61708[(2)] = inst_61624);

(statearr_61662_61708[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (17))){
var inst_61602 = (state_61643[(13)]);
var inst_61601 = (state_61643[(2)]);
var inst_61602__$1 = superv.async.throw_if_exception.call(null,S,inst_61601);
var state_61643__$1 = (function (){var statearr_61663 = state_61643;
(statearr_61663[(13)] = inst_61602__$1);

return statearr_61663;
})();
if(cljs.core.truth_(inst_61602__$1)){
var statearr_61664_61709 = state_61643__$1;
(statearr_61664_61709[(1)] = (18));

} else {
var statearr_61665_61710 = state_61643__$1;
(statearr_61665_61710[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (3))){
var inst_61563 = (state_61643[(2)]);
var inst_61564 = superv.async._unregister_go.call(null,S,id__23768__auto___61694);
var state_61643__$1 = (function (){var statearr_61666 = state_61643;
(statearr_61666[(14)] = inst_61563);

(statearr_61666[(15)] = inst_61564);

return statearr_61666;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61643__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (12))){
var inst_61635 = cljs.core.async.close_BANG_.call(null,out);
var state_61643__$1 = state_61643;
var statearr_61667_61711 = state_61643__$1;
(statearr_61667_61711[(2)] = inst_61635);

(statearr_61667_61711[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (2))){
var inst_61641 = (state_61643[(2)]);
var state_61643__$1 = state_61643;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61643__$1,inst_61641);
} else {
if((state_val_61644 === (23))){
var inst_61602 = (state_61643[(13)]);
var state_61643__$1 = state_61643;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_61643__$1,(25),out,inst_61602);
} else {
if((state_val_61644 === (19))){
var inst_61578 = (state_61643[(9)]);
var inst_61630 = cljs.core.rest.call(null,inst_61578);
var inst_61578__$1 = inst_61630;
var state_61643__$1 = (function (){var statearr_61668 = state_61643;
(statearr_61668[(9)] = inst_61578__$1);

return statearr_61668;
})();
var statearr_61669_61712 = state_61643__$1;
(statearr_61669_61712[(2)] = null);

(statearr_61669_61712[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (11))){
var inst_61580 = (state_61643[(16)]);
var inst_61585 = (state_61643[(17)]);
var inst_61585__$1 = superv.async._abort.call(null,S);
var inst_61586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61587 = [inst_61585__$1,inst_61580];
var inst_61588 = (new cljs.core.PersistentVector(null,2,(5),inst_61586,inst_61587,null));
var state_61643__$1 = (function (){var statearr_61670 = state_61643;
(statearr_61670[(17)] = inst_61585__$1);

return statearr_61670;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61643__$1,(14),inst_61588,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_61644 === (9))){
var inst_61580 = (state_61643[(16)]);
var inst_61578 = (state_61643[(9)]);
var inst_61580__$1 = cljs.core.first.call(null,inst_61578);
var state_61643__$1 = (function (){var statearr_61671 = state_61643;
(statearr_61671[(16)] = inst_61580__$1);

return statearr_61671;
})();
if(cljs.core.truth_(inst_61580__$1)){
var statearr_61672_61713 = state_61643__$1;
(statearr_61672_61713[(1)] = (11));

} else {
var statearr_61673_61714 = state_61643__$1;
(statearr_61673_61714[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (5))){
var state_61643__$1 = state_61643;
var statearr_61674_61715 = state_61643__$1;
(statearr_61674_61715[(2)] = null);

(statearr_61674_61715[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (14))){
var inst_61585 = (state_61643[(17)]);
var inst_61590 = (state_61643[(2)]);
var inst_61591 = cljs.core.nth.call(null,inst_61590,(0),null);
var inst_61592 = cljs.core.nth.call(null,inst_61590,(1),null);
var inst_61593 = cljs.core._EQ_.call(null,inst_61592,inst_61585);
var state_61643__$1 = (function (){var statearr_61675 = state_61643;
(statearr_61675[(18)] = inst_61591);

return statearr_61675;
})();
if(inst_61593){
var statearr_61676_61716 = state_61643__$1;
(statearr_61676_61716[(1)] = (15));

} else {
var statearr_61677_61717 = state_61643__$1;
(statearr_61677_61717[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (16))){
var inst_61591 = (state_61643[(18)]);
var state_61643__$1 = state_61643;
var statearr_61678_61718 = state_61643__$1;
(statearr_61678_61718[(2)] = inst_61591);

(statearr_61678_61718[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (10))){
var inst_61639 = (state_61643[(2)]);
var state_61643__$1 = state_61643;
var statearr_61679_61719 = state_61643__$1;
(statearr_61679_61719[(2)] = inst_61639);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61643__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61644 === (18))){
var inst_61607 = (state_61643[(11)]);
var inst_61607__$1 = superv.async._abort.call(null,S);
var inst_61608 = cljs.core.async.timeout.call(null,(0));
var inst_61609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61610 = [inst_61607__$1,inst_61608];
var inst_61611 = (new cljs.core.PersistentVector(null,2,(5),inst_61609,inst_61610,null));
var state_61643__$1 = (function (){var statearr_61680 = state_61643;
(statearr_61680[(11)] = inst_61607__$1);

return statearr_61680;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61643__$1,(21),inst_61611,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_61644 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_61643,(4),Error,(3),(2));
var inst_61578 = cs;
var state_61643__$1 = (function (){var statearr_61681 = state_61643;
(statearr_61681[(9)] = inst_61578);

return statearr_61681;
})();
var statearr_61682_61720 = state_61643__$1;
(statearr_61682_61720[(2)] = null);

(statearr_61682_61720[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___61695,c__23767__auto___61693,id__23768__auto___61694,out))
;
return ((function (switch__38195__auto__,c__38309__auto___61695,c__23767__auto___61693,id__23768__auto___61694,out){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_61686 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61686[(0)] = superv$async$state_machine__38196__auto__);

(statearr_61686[(1)] = (1));

return statearr_61686;
});
var superv$async$state_machine__38196__auto____1 = (function (state_61643){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_61643);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e61687){if((e61687 instanceof Object)){
var ex__38199__auto__ = e61687;
var statearr_61688_61721 = state_61643;
(statearr_61688_61721[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61643);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e61687;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61722 = state_61643;
state_61643 = G__61722;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_61643){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_61643);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___61695,c__23767__auto___61693,id__23768__auto___61694,out))
})();
var state__38311__auto__ = (function (){var statearr_61689 = f__38310__auto__.call(null);
(statearr_61689[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___61695);

return statearr_61689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___61695,c__23767__auto___61693,id__23768__auto___61694,out))
);


return out;
});

superv.async.concat_GT__GT_.cljs$lang$maxFixedArity = (1);

superv.async.concat_GT__GT_.cljs$lang$applyTo = (function (seq61561){
var G__61562 = cljs.core.first.call(null,seq61561);
var seq61561__$1 = cljs.core.next.call(null,seq61561);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__61562,seq61561__$1);
});

superv.async.partition_all_GT__GT_ = (function superv$async$partition_all_GT__GT_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___61940 = arguments.length;
var i__10641__auto___61941 = (0);
while(true){
if((i__10641__auto___61941 < len__10640__auto___61940)){
args__10647__auto__.push((arguments[i__10641__auto___61941]));

var G__61942 = (i__10641__auto___61941 + (1));
i__10641__auto___61941 = G__61942;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((3) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((3)),(0),null)):null);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10648__auto__);
});

superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,n,in_ch,p__61727){
var map__61728 = p__61727;
var map__61728__$1 = ((((!((map__61728 == null)))?((((map__61728.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__61728.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__61728):map__61728);
var out_ch = cljs.core.get.call(null,map__61728__$1,new cljs.core.Keyword(null,"out-ch","out-ch",-189045854));

new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(n > (0))], null)], null);

var out_ch__$1 = (function (){var or__9419__auto__ = out_ch;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})();
var c__23767__auto___61943 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___61944 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"batch","batch",977610327,null),cljs.core.PersistentVector.EMPTY], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null),cljs.core.list(new cljs.core.Symbol(null,"conj","conj",-1127293942,null),new cljs.core.Symbol(null,"batch","batch",977610327,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.PersistentVector.EMPTY)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"not-empty","not-empty",2029453590,null),new cljs.core.Symbol(null,"batch","batch",977610327,null)),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"batch","batch",977610327,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))))));
var c__38309__auto___61945 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___61945,c__23767__auto___61943,id__23768__auto___61944,out_ch__$1,map__61728,map__61728__$1,out_ch){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___61945,c__23767__auto___61943,id__23768__auto___61944,out_ch__$1,map__61728,map__61728__$1,out_ch){
return (function (state_61872){
var state_val_61873 = (state_61872[(1)]);
if((state_val_61873 === (7))){
var inst_61733 = (state_61872[(7)]);
var inst_61741 = (state_61872[(2)]);
var state_61872__$1 = (function (){var statearr_61874 = state_61872;
(statearr_61874[(8)] = inst_61741);

return statearr_61874;
})();
var statearr_61875_61946 = state_61872__$1;
(statearr_61875_61946[(2)] = inst_61733);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61872__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (20))){
var inst_61833 = (state_61872[(2)]);
var state_61872__$1 = state_61872;
var statearr_61876_61947 = state_61872__$1;
(statearr_61876_61947[(2)] = inst_61833);

(statearr_61876_61947[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (27))){
var inst_61798 = (state_61872[(9)]);
var inst_61746 = inst_61798;
var state_61872__$1 = (function (){var statearr_61877 = state_61872;
(statearr_61877[(10)] = inst_61746);

return statearr_61877;
})();
var statearr_61878_61948 = state_61872__$1;
(statearr_61878_61948[(2)] = null);

(statearr_61878_61948[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (1))){
var state_61872__$1 = state_61872;
var statearr_61879_61949 = state_61872__$1;
(statearr_61879_61949[(2)] = null);

(statearr_61879_61949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (24))){
var inst_61794 = (state_61872[(2)]);
var inst_61795 = superv.async.throw_if_exception.call(null,S,inst_61794);
var inst_61796 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_61872__$1 = (function (){var statearr_61880 = state_61872;
(statearr_61880[(11)] = inst_61795);

return statearr_61880;
})();
var statearr_61881_61950 = state_61872__$1;
(statearr_61881_61950[(2)] = inst_61796);

(statearr_61881_61950[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (39))){
var inst_61746 = (state_61872[(10)]);
var state_61872__$1 = state_61872;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_61872__$1,(41),out_ch__$1,inst_61746);
} else {
if((state_val_61873 === (4))){
var inst_61733 = (state_61872[(7)]);
var inst_61733__$1 = (state_61872[(2)]);
var inst_61734 = cljs.core.ex_data.call(null,inst_61733__$1);
var inst_61735 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_61734);
var inst_61736 = cljs.core._EQ_.call(null,inst_61735,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_61872__$1 = (function (){var statearr_61882 = state_61872;
(statearr_61882[(7)] = inst_61733__$1);

return statearr_61882;
})();
if(inst_61736){
var statearr_61883_61951 = state_61872__$1;
(statearr_61883_61951[(1)] = (5));

} else {
var statearr_61884_61952 = state_61872__$1;
(statearr_61884_61952[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (15))){
var inst_61768 = (state_61872[(12)]);
var inst_61770 = (inst_61768 instanceof Error);
var state_61872__$1 = state_61872;
if(cljs.core.truth_(inst_61770)){
var statearr_61885_61953 = state_61872__$1;
(statearr_61885_61953[(1)] = (18));

} else {
var statearr_61886_61954 = state_61872__$1;
(statearr_61886_61954[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (21))){
var inst_61775 = (state_61872[(13)]);
var inst_61781 = (state_61872[(2)]);
var inst_61782 = cljs.core.nth.call(null,inst_61781,(0),null);
var inst_61783 = cljs.core.nth.call(null,inst_61781,(1),null);
var inst_61784 = cljs.core._EQ_.call(null,inst_61783,inst_61775);
var state_61872__$1 = (function (){var statearr_61887 = state_61872;
(statearr_61887[(14)] = inst_61782);

return statearr_61887;
})();
if(inst_61784){
var statearr_61888_61955 = state_61872__$1;
(statearr_61888_61955[(1)] = (22));

} else {
var statearr_61889_61956 = state_61872__$1;
(statearr_61889_61956[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (31))){
var inst_61798 = (state_61872[(9)]);
var state_61872__$1 = state_61872;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_61872__$1,(33),out_ch__$1,inst_61798);
} else {
if((state_val_61873 === (32))){
var inst_61824 = (state_61872[(2)]);
var inst_61825 = superv.async.throw_if_exception.call(null,S,inst_61824);
var inst_61826 = cljs.core.PersistentVector.EMPTY;
var inst_61746 = inst_61826;
var state_61872__$1 = (function (){var statearr_61890 = state_61872;
(statearr_61890[(10)] = inst_61746);

(statearr_61890[(15)] = inst_61825);

return statearr_61890;
})();
var statearr_61891_61957 = state_61872__$1;
(statearr_61891_61957[(2)] = null);

(statearr_61891_61957[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (40))){
var inst_61859 = (state_61872[(2)]);
var inst_61860 = superv.async.throw_if_exception.call(null,S,inst_61859);
var state_61872__$1 = state_61872;
var statearr_61892_61958 = state_61872__$1;
(statearr_61892_61958[(2)] = inst_61860);

(statearr_61892_61958[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (33))){
var inst_61822 = (state_61872[(2)]);
var state_61872__$1 = state_61872;
var statearr_61893_61959 = state_61872__$1;
(statearr_61893_61959[(2)] = inst_61822);

(statearr_61893_61959[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (13))){
var inst_61757 = (state_61872[(16)]);
var state_61872__$1 = state_61872;
var statearr_61894_61960 = state_61872__$1;
(statearr_61894_61960[(2)] = inst_61757);

(statearr_61894_61960[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (22))){
var inst_61786 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61787 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61788 = cljs.core.PersistentHashMap.fromArrays(inst_61786,inst_61787);
var inst_61789 = cljs.core.ex_info.call(null,"Aborted operations",inst_61788);
var state_61872__$1 = state_61872;
var statearr_61895_61961 = state_61872__$1;
(statearr_61895_61961[(2)] = inst_61789);

(statearr_61895_61961[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (36))){
var inst_61863 = (state_61872[(2)]);
var inst_61864 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_61872__$1 = (function (){var statearr_61896 = state_61872;
(statearr_61896[(17)] = inst_61863);

return statearr_61896;
})();
var statearr_61897_61962 = state_61872__$1;
(statearr_61897_61962[(2)] = inst_61864);

(statearr_61897_61962[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (41))){
var inst_61857 = (state_61872[(2)]);
var state_61872__$1 = state_61872;
var statearr_61898_61963 = state_61872__$1;
(statearr_61898_61963[(2)] = inst_61857);

(statearr_61898_61963[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (29))){
var inst_61805 = (state_61872[(18)]);
var inst_61811 = (state_61872[(2)]);
var inst_61812 = cljs.core.nth.call(null,inst_61811,(0),null);
var inst_61813 = cljs.core.nth.call(null,inst_61811,(1),null);
var inst_61814 = cljs.core._EQ_.call(null,inst_61813,inst_61805);
var state_61872__$1 = (function (){var statearr_61899 = state_61872;
(statearr_61899[(19)] = inst_61812);

return statearr_61899;
})();
if(inst_61814){
var statearr_61900_61964 = state_61872__$1;
(statearr_61900_61964[(1)] = (30));

} else {
var statearr_61901_61965 = state_61872__$1;
(statearr_61901_61965[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (6))){
var inst_61733 = (state_61872[(7)]);
var inst_61739 = superv.async._track_exception.call(null,S,inst_61733);
var state_61872__$1 = state_61872;
var statearr_61902_61966 = state_61872__$1;
(statearr_61902_61966[(2)] = inst_61739);

(statearr_61902_61966[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (28))){
var inst_61831 = (state_61872[(2)]);
var state_61872__$1 = state_61872;
var statearr_61903_61967 = state_61872__$1;
(statearr_61903_61967[(2)] = inst_61831);

(statearr_61903_61967[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (25))){
var inst_61792 = (state_61872[(2)]);
var state_61872__$1 = state_61872;
var statearr_61904_61968 = state_61872__$1;
(statearr_61904_61968[(2)] = inst_61792);

(statearr_61904_61968[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (34))){
var inst_61840 = (state_61872[(20)]);
var inst_61840__$1 = superv.async._abort.call(null,S);
var inst_61841 = cljs.core.async.timeout.call(null,(0));
var inst_61842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61843 = [inst_61840__$1,inst_61841];
var inst_61844 = (new cljs.core.PersistentVector(null,2,(5),inst_61842,inst_61843,null));
var state_61872__$1 = (function (){var statearr_61905 = state_61872;
(statearr_61905[(20)] = inst_61840__$1);

return statearr_61905;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61872__$1,(37),inst_61844,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_61873 === (17))){
var inst_61866 = (state_61872[(2)]);
var state_61872__$1 = state_61872;
var statearr_61906_61969 = state_61872__$1;
(statearr_61906_61969[(2)] = inst_61866);

(statearr_61906_61969[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (3))){
var inst_61730 = (state_61872[(2)]);
var inst_61731 = superv.async._unregister_go.call(null,S,id__23768__auto___61944);
var state_61872__$1 = (function (){var statearr_61907 = state_61872;
(statearr_61907[(21)] = inst_61731);

(statearr_61907[(22)] = inst_61730);

return statearr_61907;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61872__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (12))){
var inst_61761 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61762 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61763 = cljs.core.PersistentHashMap.fromArrays(inst_61761,inst_61762);
var inst_61764 = cljs.core.ex_info.call(null,"Aborted operations",inst_61763);
var state_61872__$1 = state_61872;
var statearr_61908_61970 = state_61872__$1;
(statearr_61908_61970[(2)] = inst_61764);

(statearr_61908_61970[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (2))){
var inst_61870 = (state_61872[(2)]);
var state_61872__$1 = state_61872;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61872__$1,inst_61870);
} else {
if((state_val_61873 === (23))){
var inst_61768 = (state_61872[(12)]);
var state_61872__$1 = state_61872;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_61872__$1,(25),out_ch__$1,inst_61768);
} else {
if((state_val_61873 === (35))){
var state_61872__$1 = state_61872;
var statearr_61909_61971 = state_61872__$1;
(statearr_61909_61971[(2)] = null);

(statearr_61909_61971[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (19))){
var inst_61746 = (state_61872[(10)]);
var inst_61768 = (state_61872[(12)]);
var inst_61798 = (state_61872[(9)]);
var inst_61798__$1 = cljs.core.conj.call(null,inst_61746,inst_61768);
var inst_61799 = cljs.core.count.call(null,inst_61798__$1);
var inst_61800 = cljs.core._EQ_.call(null,n,inst_61799);
var state_61872__$1 = (function (){var statearr_61910 = state_61872;
(statearr_61910[(9)] = inst_61798__$1);

return statearr_61910;
})();
if(inst_61800){
var statearr_61911_61972 = state_61872__$1;
(statearr_61911_61972[(1)] = (26));

} else {
var statearr_61912_61973 = state_61872__$1;
(statearr_61912_61973[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (11))){
var inst_61751 = (state_61872[(23)]);
var inst_61756 = (state_61872[(2)]);
var inst_61757 = cljs.core.nth.call(null,inst_61756,(0),null);
var inst_61758 = cljs.core.nth.call(null,inst_61756,(1),null);
var inst_61759 = cljs.core._EQ_.call(null,inst_61758,inst_61751);
var state_61872__$1 = (function (){var statearr_61913 = state_61872;
(statearr_61913[(16)] = inst_61757);

return statearr_61913;
})();
if(inst_61759){
var statearr_61914_61974 = state_61872__$1;
(statearr_61914_61974[(1)] = (12));

} else {
var statearr_61915_61975 = state_61872__$1;
(statearr_61915_61975[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (9))){
var inst_61751 = (state_61872[(23)]);
var inst_61751__$1 = superv.async._abort.call(null,S);
var inst_61752 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61753 = [inst_61751__$1,in_ch];
var inst_61754 = (new cljs.core.PersistentVector(null,2,(5),inst_61752,inst_61753,null));
var state_61872__$1 = (function (){var statearr_61916 = state_61872;
(statearr_61916[(23)] = inst_61751__$1);

return statearr_61916;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61872__$1,(11),inst_61754,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_61873 === (5))){
var state_61872__$1 = state_61872;
var statearr_61917_61976 = state_61872__$1;
(statearr_61917_61976[(2)] = null);

(statearr_61917_61976[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (14))){
var inst_61768 = (state_61872[(12)]);
var inst_61767 = (state_61872[(2)]);
var inst_61768__$1 = superv.async.throw_if_exception.call(null,S,inst_61767);
var state_61872__$1 = (function (){var statearr_61918 = state_61872;
(statearr_61918[(12)] = inst_61768__$1);

return statearr_61918;
})();
if(cljs.core.truth_(inst_61768__$1)){
var statearr_61919_61977 = state_61872__$1;
(statearr_61919_61977[(1)] = (15));

} else {
var statearr_61920_61978 = state_61872__$1;
(statearr_61920_61978[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (26))){
var inst_61805 = (state_61872[(18)]);
var inst_61805__$1 = superv.async._abort.call(null,S);
var inst_61806 = cljs.core.async.timeout.call(null,(0));
var inst_61807 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61808 = [inst_61805__$1,inst_61806];
var inst_61809 = (new cljs.core.PersistentVector(null,2,(5),inst_61807,inst_61808,null));
var state_61872__$1 = (function (){var statearr_61921 = state_61872;
(statearr_61921[(18)] = inst_61805__$1);

return statearr_61921;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61872__$1,(29),inst_61809,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_61873 === (16))){
var inst_61746 = (state_61872[(10)]);
var inst_61835 = cljs.core.not_empty.call(null,inst_61746);
var state_61872__$1 = state_61872;
if(cljs.core.truth_(inst_61835)){
var statearr_61922_61979 = state_61872__$1;
(statearr_61922_61979[(1)] = (34));

} else {
var statearr_61923_61980 = state_61872__$1;
(statearr_61923_61980[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (38))){
var inst_61851 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61852 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61853 = cljs.core.PersistentHashMap.fromArrays(inst_61851,inst_61852);
var inst_61854 = cljs.core.ex_info.call(null,"Aborted operations",inst_61853);
var state_61872__$1 = state_61872;
var statearr_61924_61981 = state_61872__$1;
(statearr_61924_61981[(2)] = inst_61854);

(statearr_61924_61981[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (30))){
var inst_61816 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_61817 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_61818 = cljs.core.PersistentHashMap.fromArrays(inst_61816,inst_61817);
var inst_61819 = cljs.core.ex_info.call(null,"Aborted operations",inst_61818);
var state_61872__$1 = state_61872;
var statearr_61925_61982 = state_61872__$1;
(statearr_61925_61982[(2)] = inst_61819);

(statearr_61925_61982[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (10))){
var inst_61868 = (state_61872[(2)]);
var state_61872__$1 = state_61872;
var statearr_61926_61983 = state_61872__$1;
(statearr_61926_61983[(2)] = inst_61868);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61872__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (18))){
var inst_61775 = (state_61872[(13)]);
var inst_61775__$1 = superv.async._abort.call(null,S);
var inst_61776 = cljs.core.async.timeout.call(null,(0));
var inst_61777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61778 = [inst_61775__$1,inst_61776];
var inst_61779 = (new cljs.core.PersistentVector(null,2,(5),inst_61777,inst_61778,null));
var state_61872__$1 = (function (){var statearr_61927 = state_61872;
(statearr_61927[(13)] = inst_61775__$1);

return statearr_61927;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61872__$1,(21),inst_61779,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_61873 === (37))){
var inst_61840 = (state_61872[(20)]);
var inst_61846 = (state_61872[(2)]);
var inst_61847 = cljs.core.nth.call(null,inst_61846,(0),null);
var inst_61848 = cljs.core.nth.call(null,inst_61846,(1),null);
var inst_61849 = cljs.core._EQ_.call(null,inst_61848,inst_61840);
var state_61872__$1 = (function (){var statearr_61928 = state_61872;
(statearr_61928[(24)] = inst_61847);

return statearr_61928;
})();
if(inst_61849){
var statearr_61929_61984 = state_61872__$1;
(statearr_61929_61984[(1)] = (38));

} else {
var statearr_61930_61985 = state_61872__$1;
(statearr_61930_61985[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61873 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_61872,(4),Error,(3),(2));
var inst_61745 = cljs.core.PersistentVector.EMPTY;
var inst_61746 = inst_61745;
var state_61872__$1 = (function (){var statearr_61931 = state_61872;
(statearr_61931[(10)] = inst_61746);

return statearr_61931;
})();
var statearr_61932_61986 = state_61872__$1;
(statearr_61932_61986[(2)] = null);

(statearr_61932_61986[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___61945,c__23767__auto___61943,id__23768__auto___61944,out_ch__$1,map__61728,map__61728__$1,out_ch))
;
return ((function (switch__38195__auto__,c__38309__auto___61945,c__23767__auto___61943,id__23768__auto___61944,out_ch__$1,map__61728,map__61728__$1,out_ch){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_61936 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61936[(0)] = superv$async$state_machine__38196__auto__);

(statearr_61936[(1)] = (1));

return statearr_61936;
});
var superv$async$state_machine__38196__auto____1 = (function (state_61872){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_61872);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e61937){if((e61937 instanceof Object)){
var ex__38199__auto__ = e61937;
var statearr_61938_61987 = state_61872;
(statearr_61938_61987[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61872);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e61937;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61988 = state_61872;
state_61872 = G__61988;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_61872){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_61872);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___61945,c__23767__auto___61943,id__23768__auto___61944,out_ch__$1,map__61728,map__61728__$1,out_ch))
})();
var state__38311__auto__ = (function (){var statearr_61939 = f__38310__auto__.call(null);
(statearr_61939[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___61945);

return statearr_61939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___61945,c__23767__auto___61943,id__23768__auto___61944,out_ch__$1,map__61728,map__61728__$1,out_ch))
);


return out_ch__$1;
});

superv.async.partition_all_GT__GT_.cljs$lang$maxFixedArity = (3);

superv.async.partition_all_GT__GT_.cljs$lang$applyTo = (function (seq61723){
var G__61724 = cljs.core.first.call(null,seq61723);
var seq61723__$1 = cljs.core.next.call(null,seq61723);
var G__61725 = cljs.core.first.call(null,seq61723__$1);
var seq61723__$2 = cljs.core.next.call(null,seq61723__$1);
var G__61726 = cljs.core.first.call(null,seq61723__$2);
var seq61723__$3 = cljs.core.next.call(null,seq61723__$2);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__61724,G__61725,G__61726,seq61723__$3);
});

/**
 * Counts items in a channel. Returns a channel with the item count.
 */
superv.async.count_GT_ = (function superv$async$count_GT_(S,ch){
return cljs.core.async.reduce.call(null,(function (acc,obj){
if((obj instanceof Error)){
return superv.async.put_QMARK_.call(null,S,superv.async._error.call(null,S),obj);
} else {
return (acc + (1));
}
}),(0),ch);
});
/**
 * Debounces channel. Forwards first item from input channel to output
 *   immediately. After that one item every interval ms (if any). If there are more
 *   items in between, they are dropped.
 */
superv.async.debounce_GT__GT_ = (function superv$async$debounce_GT__GT_(S,ch,interval){
var out = cljs.core.async.chan.call(null);
var c__23767__auto___62307 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___62308 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),null], null),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol("async","timeout","async/timeout",1951904349,null),new cljs.core.Symbol(null,"interval","interval",-945940352,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null)),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-val","new-val",902372928,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null),cljs.core.list(new cljs.core.Symbol(null,"alts?","alts?",1625745590,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null)], null))], null),cljs.core.list(new cljs.core.Symbol(null,"condp","condp",1054325175,null),new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)))))))));
var c__38309__auto___62309 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___62309,c__23767__auto___62307,id__23768__auto___62308,out){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___62309,c__23767__auto___62307,id__23768__auto___62308,out){
return (function (state_62253){
var state_val_62254 = (state_62253[(1)]);
if((state_val_62254 === (7))){
var inst_62151 = (state_62253[(7)]);
var inst_62159 = (state_62253[(2)]);
var state_62253__$1 = (function (){var statearr_62255 = state_62253;
(statearr_62255[(8)] = inst_62159);

return statearr_62255;
})();
var statearr_62256_62310 = state_62253__$1;
(statearr_62256_62310[(2)] = inst_62151);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62253__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (20))){
var inst_62247 = (state_62253[(2)]);
var state_62253__$1 = state_62253;
var statearr_62257_62311 = state_62253__$1;
(statearr_62257_62311[(2)] = inst_62247);

(statearr_62257_62311[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (27))){
var inst_62231 = (state_62253[(2)]);
var inst_62232 = superv.async.throw_if_exception.call(null,S,inst_62231);
var inst_62163 = null;
var state_62253__$1 = (function (){var statearr_62258 = state_62253;
(statearr_62258[(9)] = inst_62232);

(statearr_62258[(10)] = inst_62163);

return statearr_62258;
})();
var statearr_62259_62312 = state_62253__$1;
(statearr_62259_62312[(2)] = null);

(statearr_62259_62312[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (1))){
var state_62253__$1 = state_62253;
var statearr_62260_62313 = state_62253__$1;
(statearr_62260_62313[(2)] = null);

(statearr_62260_62313[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (24))){
var inst_62212 = (state_62253[(11)]);
var inst_62218 = (state_62253[(2)]);
var inst_62219 = cljs.core.nth.call(null,inst_62218,(0),null);
var inst_62220 = cljs.core.nth.call(null,inst_62218,(1),null);
var inst_62221 = cljs.core._EQ_.call(null,inst_62220,inst_62212);
var state_62253__$1 = (function (){var statearr_62261 = state_62253;
(statearr_62261[(12)] = inst_62219);

return statearr_62261;
})();
if(inst_62221){
var statearr_62262_62314 = state_62253__$1;
(statearr_62262_62314[(1)] = (25));

} else {
var statearr_62263_62315 = state_62253__$1;
(statearr_62263_62315[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (4))){
var inst_62151 = (state_62253[(7)]);
var inst_62151__$1 = (state_62253[(2)]);
var inst_62152 = cljs.core.ex_data.call(null,inst_62151__$1);
var inst_62153 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_62152);
var inst_62154 = cljs.core._EQ_.call(null,inst_62153,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_62253__$1 = (function (){var statearr_62264 = state_62253;
(statearr_62264[(7)] = inst_62151__$1);

return statearr_62264;
})();
if(inst_62154){
var statearr_62265_62316 = state_62253__$1;
(statearr_62265_62316[(1)] = (5));

} else {
var statearr_62266_62317 = state_62253__$1;
(statearr_62266_62317[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (15))){
var inst_62180 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_62181 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_62182 = cljs.core.PersistentHashMap.fromArrays(inst_62180,inst_62181);
var inst_62183 = cljs.core.ex_info.call(null,"Aborted operations",inst_62182);
var state_62253__$1 = state_62253;
var statearr_62267_62318 = state_62253__$1;
(statearr_62267_62318[(2)] = inst_62183);

(statearr_62267_62318[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (21))){
var inst_62212 = (state_62253[(11)]);
var inst_62212__$1 = superv.async._abort.call(null,S);
var inst_62213 = cljs.core.async.timeout.call(null,(0));
var inst_62214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62215 = [inst_62212__$1,inst_62213];
var inst_62216 = (new cljs.core.PersistentVector(null,2,(5),inst_62214,inst_62215,null));
var state_62253__$1 = (function (){var statearr_62268 = state_62253;
(statearr_62268[(11)] = inst_62212__$1);

return statearr_62268;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_62253__$1,(24),inst_62216,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_62254 === (31))){
var inst_62243 = (state_62253[(2)]);
var state_62253__$1 = state_62253;
var statearr_62269_62319 = state_62253__$1;
(statearr_62269_62319[(2)] = inst_62243);

(statearr_62269_62319[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (13))){
var inst_62189 = (state_62253[(13)]);
var inst_62189__$1 = (state_62253[(2)]);
var inst_62190 = cljs.core.async.timeout.call(null,interval);
var inst_62191 = (inst_62189__$1 == null);
var state_62253__$1 = (function (){var statearr_62270 = state_62253;
(statearr_62270[(14)] = inst_62190);

(statearr_62270[(13)] = inst_62189__$1);

return statearr_62270;
})();
if(cljs.core.truth_(inst_62191)){
var statearr_62271_62320 = state_62253__$1;
(statearr_62271_62320[(1)] = (18));

} else {
var statearr_62272_62321 = state_62253__$1;
(statearr_62272_62321[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (22))){
var inst_62203 = (state_62253[(15)]);
var inst_62235 = cljs.core._EQ_.call(null,inst_62203,inst_62203);
var state_62253__$1 = state_62253;
if(inst_62235){
var statearr_62273_62322 = state_62253__$1;
(statearr_62273_62322[(1)] = (29));

} else {
var statearr_62274_62323 = state_62253__$1;
(statearr_62274_62323[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (29))){
var inst_62202 = (state_62253[(16)]);
var inst_62163 = inst_62202;
var state_62253__$1 = (function (){var statearr_62275 = state_62253;
(statearr_62275[(10)] = inst_62163);

return statearr_62275;
})();
var statearr_62276_62324 = state_62253__$1;
(statearr_62276_62324[(2)] = null);

(statearr_62276_62324[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (6))){
var inst_62151 = (state_62253[(7)]);
var inst_62157 = superv.async._track_exception.call(null,S,inst_62151);
var state_62253__$1 = state_62253;
var statearr_62277_62325 = state_62253__$1;
(statearr_62277_62325[(2)] = inst_62157);

(statearr_62277_62325[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (28))){
var inst_62229 = (state_62253[(2)]);
var state_62253__$1 = state_62253;
var statearr_62278_62326 = state_62253__$1;
(statearr_62278_62326[(2)] = inst_62229);

(statearr_62278_62326[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (25))){
var inst_62223 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_62224 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_62225 = cljs.core.PersistentHashMap.fromArrays(inst_62223,inst_62224);
var inst_62226 = cljs.core.ex_info.call(null,"Aborted operations",inst_62225);
var state_62253__$1 = state_62253;
var statearr_62279_62327 = state_62253__$1;
(statearr_62279_62327[(2)] = inst_62226);

(statearr_62279_62327[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (17))){
var inst_62186 = (state_62253[(2)]);
var inst_62187 = superv.async.throw_if_exception.call(null,S,inst_62186);
var state_62253__$1 = state_62253;
var statearr_62280_62328 = state_62253__$1;
(statearr_62280_62328[(2)] = inst_62187);

(statearr_62280_62328[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (3))){
var inst_62148 = (state_62253[(2)]);
var inst_62149 = superv.async._unregister_go.call(null,S,id__23768__auto___62308);
var state_62253__$1 = (function (){var statearr_62281 = state_62253;
(statearr_62281[(17)] = inst_62148);

(statearr_62281[(18)] = inst_62149);

return statearr_62281;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62253__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (12))){
var inst_62170 = (state_62253[(19)]);
var inst_62170__$1 = superv.async._abort.call(null,S);
var inst_62171 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62172 = [inst_62170__$1,ch];
var inst_62173 = (new cljs.core.PersistentVector(null,2,(5),inst_62171,inst_62172,null));
var state_62253__$1 = (function (){var statearr_62282 = state_62253;
(statearr_62282[(19)] = inst_62170__$1);

return statearr_62282;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_62253__$1,(14),inst_62173,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_62254 === (2))){
var inst_62251 = (state_62253[(2)]);
var state_62253__$1 = state_62253;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62253__$1,inst_62251);
} else {
if((state_val_62254 === (23))){
var inst_62245 = (state_62253[(2)]);
var state_62253__$1 = state_62253;
var statearr_62283_62329 = state_62253__$1;
(statearr_62283_62329[(2)] = inst_62245);

(statearr_62283_62329[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (19))){
var inst_62190 = (state_62253[(14)]);
var inst_62203 = (state_62253[(15)]);
var inst_62198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62199 = [ch,inst_62190];
var inst_62200 = (new cljs.core.PersistentVector(null,2,(5),inst_62198,inst_62199,null));
var inst_62201 = superv.async.alts_QMARK_.call(null,S,inst_62200);
var inst_62202 = cljs.core.nth.call(null,inst_62201,(0),null);
var inst_62203__$1 = cljs.core.nth.call(null,inst_62201,(1),null);
var inst_62207 = cljs.core._EQ_.call(null,inst_62190,inst_62203__$1);
var state_62253__$1 = (function (){var statearr_62284 = state_62253;
(statearr_62284[(15)] = inst_62203__$1);

(statearr_62284[(16)] = inst_62202);

return statearr_62284;
})();
if(inst_62207){
var statearr_62285_62330 = state_62253__$1;
(statearr_62285_62330[(1)] = (21));

} else {
var statearr_62286_62331 = state_62253__$1;
(statearr_62286_62331[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (11))){
var inst_62163 = (state_62253[(10)]);
var state_62253__$1 = state_62253;
var statearr_62287_62332 = state_62253__$1;
(statearr_62287_62332[(2)] = inst_62163);

(statearr_62287_62332[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (9))){
var inst_62163 = (state_62253[(10)]);
var state_62253__$1 = state_62253;
if(cljs.core.truth_(inst_62163)){
var statearr_62288_62333 = state_62253__$1;
(statearr_62288_62333[(1)] = (11));

} else {
var statearr_62289_62334 = state_62253__$1;
(statearr_62289_62334[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (5))){
var state_62253__$1 = state_62253;
var statearr_62290_62335 = state_62253__$1;
(statearr_62290_62335[(2)] = null);

(statearr_62290_62335[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (14))){
var inst_62170 = (state_62253[(19)]);
var inst_62175 = (state_62253[(2)]);
var inst_62176 = cljs.core.nth.call(null,inst_62175,(0),null);
var inst_62177 = cljs.core.nth.call(null,inst_62175,(1),null);
var inst_62178 = cljs.core._EQ_.call(null,inst_62177,inst_62170);
var state_62253__$1 = (function (){var statearr_62291 = state_62253;
(statearr_62291[(20)] = inst_62176);

return statearr_62291;
})();
if(inst_62178){
var statearr_62292_62336 = state_62253__$1;
(statearr_62292_62336[(1)] = (15));

} else {
var statearr_62293_62337 = state_62253__$1;
(statearr_62293_62337[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (26))){
var inst_62189 = (state_62253[(13)]);
var state_62253__$1 = state_62253;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_62253__$1,(28),out,inst_62189);
} else {
if((state_val_62254 === (16))){
var inst_62176 = (state_62253[(20)]);
var state_62253__$1 = state_62253;
var statearr_62294_62338 = state_62253__$1;
(statearr_62294_62338[(2)] = inst_62176);

(statearr_62294_62338[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (30))){
var inst_62203 = (state_62253[(15)]);
var inst_62239 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62203)].join('');
var inst_62240 = (new Error(inst_62239));
var inst_62241 = (function(){throw inst_62240})();
var state_62253__$1 = state_62253;
var statearr_62295_62339 = state_62253__$1;
(statearr_62295_62339[(2)] = inst_62241);

(statearr_62295_62339[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (10))){
var inst_62249 = (state_62253[(2)]);
var state_62253__$1 = state_62253;
var statearr_62296_62340 = state_62253__$1;
(statearr_62296_62340[(2)] = inst_62249);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62253__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (18))){
var inst_62193 = cljs.core.async.close_BANG_.call(null,out);
var state_62253__$1 = state_62253;
var statearr_62297_62341 = state_62253__$1;
(statearr_62297_62341[(2)] = inst_62193);

(statearr_62297_62341[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_62253,(4),Error,(3),(2));
var inst_62163 = null;
var state_62253__$1 = (function (){var statearr_62298 = state_62253;
(statearr_62298[(10)] = inst_62163);

return statearr_62298;
})();
var statearr_62299_62342 = state_62253__$1;
(statearr_62299_62342[(2)] = null);

(statearr_62299_62342[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___62309,c__23767__auto___62307,id__23768__auto___62308,out))
;
return ((function (switch__38195__auto__,c__38309__auto___62309,c__23767__auto___62307,id__23768__auto___62308,out){
return (function() {
var superv$async$debounce_GT__GT__$_state_machine__38196__auto__ = null;
var superv$async$debounce_GT__GT__$_state_machine__38196__auto____0 = (function (){
var statearr_62303 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62303[(0)] = superv$async$debounce_GT__GT__$_state_machine__38196__auto__);

(statearr_62303[(1)] = (1));

return statearr_62303;
});
var superv$async$debounce_GT__GT__$_state_machine__38196__auto____1 = (function (state_62253){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_62253);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e62304){if((e62304 instanceof Object)){
var ex__38199__auto__ = e62304;
var statearr_62305_62343 = state_62253;
(statearr_62305_62343[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62253);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62304;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62344 = state_62253;
state_62253 = G__62344;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$debounce_GT__GT__$_state_machine__38196__auto__ = function(state_62253){
switch(arguments.length){
case 0:
return superv$async$debounce_GT__GT__$_state_machine__38196__auto____0.call(this);
case 1:
return superv$async$debounce_GT__GT__$_state_machine__38196__auto____1.call(this,state_62253);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$debounce_GT__GT__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$debounce_GT__GT__$_state_machine__38196__auto____0;
superv$async$debounce_GT__GT__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$debounce_GT__GT__$_state_machine__38196__auto____1;
return superv$async$debounce_GT__GT__$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___62309,c__23767__auto___62307,id__23768__auto___62308,out))
})();
var state__38311__auto__ = (function (){var statearr_62306 = f__38310__auto__.call(null);
(statearr_62306[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___62309);

return statearr_62306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___62309,c__23767__auto___62307,id__23768__auto___62308,out))
);


return out;
});
/**
 * Safely managed tap. The channel is closed on abortion and all
 *   pending puts are flushed.
 */
superv.async.tap = (function superv$async$tap(var_args){
var args62345 = [];
var len__10640__auto___62483 = arguments.length;
var i__10641__auto___62484 = (0);
while(true){
if((i__10641__auto___62484 < len__10640__auto___62483)){
args62345.push((arguments[i__10641__auto___62484]));

var G__62485 = (i__10641__auto___62484 + (1));
i__10641__auto___62484 = G__62485;
continue;
} else {
}
break;
}

var G__62347 = args62345.length;
switch (G__62347) {
case 3:
return superv.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.tap.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args62345.length)].join('')));

}
});

superv.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (S,mult,ch){
return superv.async.tap.call(null,S,mult,ch,false);
});

superv.async.tap.cljs$core$IFn$_invoke$arity$4 = (function (S,mult,ch,close_QMARK_){
var c__23767__auto___62487 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___62488 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__38309__auto___62489 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___62489,c__23767__auto___62487,id__23768__auto___62488){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___62489,c__23767__auto___62487,id__23768__auto___62488){
return (function (state_62426){
var state_val_62427 = (state_62426[(1)]);
if((state_val_62427 === (7))){
var inst_62351 = (state_62426[(7)]);
var inst_62359 = (state_62426[(2)]);
var state_62426__$1 = (function (){var statearr_62428 = state_62426;
(statearr_62428[(8)] = inst_62359);

return statearr_62428;
})();
var statearr_62429_62490 = state_62426__$1;
(statearr_62429_62490[(2)] = inst_62351);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62426__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62427 === (1))){
var state_62426__$1 = state_62426;
var statearr_62430_62491 = state_62426__$1;
(statearr_62430_62491[(2)] = null);

(statearr_62430_62491[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62427 === (4))){
var inst_62351 = (state_62426[(7)]);
var inst_62351__$1 = (state_62426[(2)]);
var inst_62352 = cljs.core.ex_data.call(null,inst_62351__$1);
var inst_62353 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_62352);
var inst_62354 = cljs.core._EQ_.call(null,inst_62353,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_62426__$1 = (function (){var statearr_62431 = state_62426;
(statearr_62431[(7)] = inst_62351__$1);

return statearr_62431;
})();
if(inst_62354){
var statearr_62432_62492 = state_62426__$1;
(statearr_62432_62492[(1)] = (5));

} else {
var statearr_62433_62493 = state_62426__$1;
(statearr_62433_62493[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62427 === (15))){
var inst_62375 = (state_62426[(2)]);
var state_62426__$1 = state_62426;
var statearr_62434_62494 = state_62426__$1;
(statearr_62434_62494[(2)] = inst_62375);

(statearr_62434_62494[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62427 === (13))){
var state_62426__$1 = state_62426;
var statearr_62435_62495 = state_62426__$1;
(statearr_62435_62495[(2)] = null);

(statearr_62435_62495[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62427 === (6))){
var inst_62351 = (state_62426[(7)]);
var inst_62357 = superv.async._track_exception.call(null,S,inst_62351);
var state_62426__$1 = state_62426;
var statearr_62436_62496 = state_62426__$1;
(statearr_62436_62496[(2)] = inst_62357);

(statearr_62436_62496[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62427 === (3))){
var inst_62348 = (state_62426[(2)]);
var inst_62349 = superv.async._unregister_go.call(null,S,id__23768__auto___62488);
var state_62426__$1 = (function (){var statearr_62437 = state_62426;
(statearr_62437[(9)] = inst_62348);

(statearr_62437[(10)] = inst_62349);

return statearr_62437;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62426__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62427 === (12))){
var inst_62370 = (state_62426[(2)]);
var state_62426__$1 = state_62426;
if(cljs.core.truth_(inst_62370)){
var statearr_62438_62497 = state_62426__$1;
(statearr_62438_62497[(1)] = (13));

} else {
var statearr_62439_62498 = state_62426__$1;
(statearr_62439_62498[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62427 === (2))){
var inst_62424 = (state_62426[(2)]);
var state_62426__$1 = state_62426;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62426__$1,inst_62424);
} else {
if((state_val_62427 === (11))){
var inst_62367 = (state_62426[(11)]);
var inst_62377 = (state_62426[(2)]);
var inst_62378 = null;
var inst_62379 = superv.async._register_go.call(null,inst_62377,inst_62378);
var inst_62420 = cljs.core.async.chan.call(null,(1));
var inst_62421 = (function (){var c__23767__auto____$1 = inst_62367;
var id__23768__auto____$1 = inst_62379;
var c__38309__auto____$1 = inst_62420;
return ((function (c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_62367,inst_62377,inst_62378,inst_62379,inst_62420,state_val_62427,c__38309__auto___62489,c__23767__auto___62487,id__23768__auto___62488){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_62367,inst_62377,inst_62378,inst_62379,inst_62420,state_val_62427,c__38309__auto___62489,c__23767__auto___62487,id__23768__auto___62488){
return (function (state_62418){
var state_val_62419 = (state_62418[(1)]);
if((state_val_62419 === (7))){
var state_62418__$1 = state_62418;
var statearr_62440_62499 = state_62418__$1;
(statearr_62440_62499[(2)] = null);

(statearr_62440_62499[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62419 === (20))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_62418,(10),Error,(3),(2));
var state_62418__$1 = state_62418;
var statearr_62441_62500 = state_62418__$1;
(statearr_62441_62500[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62418__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62419 === (1))){
var state_62418__$1 = state_62418;
var statearr_62442_62501 = state_62418__$1;
(statearr_62442_62501[(2)] = null);

(statearr_62442_62501[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62419 === (4))){
var state_62418__$1 = state_62418;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62418__$1,(6),ch);
} else {
if((state_val_62419 === (15))){
var inst_62393 = (state_62418[(7)]);
var inst_62408 = (state_62418[(2)]);
var inst_62409 = superv.async._track_exception.call(null,inst_62408,inst_62393);
var state_62418__$1 = state_62418;
var statearr_62443_62502 = state_62418__$1;
(statearr_62443_62502[(2)] = inst_62409);

(statearr_62443_62502[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62419 === (13))){
var inst_62393 = (state_62418[(7)]);
var inst_62411 = (state_62418[(2)]);
var state_62418__$1 = (function (){var statearr_62444 = state_62418;
(statearr_62444[(8)] = inst_62411);

return statearr_62444;
})();
var statearr_62445_62503 = state_62418__$1;
(statearr_62445_62503[(2)] = inst_62393);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62418__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62419 === (6))){
var inst_62383 = (state_62418[(2)]);
var state_62418__$1 = state_62418;
if(cljs.core.truth_(inst_62383)){
var statearr_62446_62504 = state_62418__$1;
(statearr_62446_62504[(1)] = (7));

} else {
var statearr_62447_62505 = state_62418__$1;
(statearr_62447_62505[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62419 === (17))){
var state_62418__$1 = state_62418;
var statearr_62448_62506 = state_62418__$1;
(statearr_62448_62506[(2)] = null);

(statearr_62448_62506[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62419 === (3))){
var inst_62380 = (state_62418[(2)]);
var state_62418__$1 = (function (){var statearr_62449 = state_62418;
(statearr_62449[(9)] = inst_62380);

return statearr_62449;
})();
var statearr_62450_62507 = state_62418__$1;
(statearr_62450_62507[(2)] = null);

(statearr_62450_62507[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62419 === (12))){
var state_62418__$1 = state_62418;
var statearr_62451_62508 = state_62418__$1;
(statearr_62451_62508[(2)] = null);

(statearr_62451_62508[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62419 === (2))){
var inst_62416 = (state_62418[(2)]);
var state_62418__$1 = state_62418;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62418__$1,inst_62416);
} else {
if((state_val_62419 === (19))){
var inst_62406 = (state_62418[(2)]);
var state_62418__$1 = state_62418;
var statearr_62452_62509 = state_62418__$1;
(statearr_62452_62509[(2)] = inst_62406);

(statearr_62452_62509[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62419 === (11))){
var state_62418__$1 = state_62418;
var statearr_62453_62510 = state_62418__$1;
(statearr_62453_62510[(2)] = null);

(statearr_62453_62510[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62419 === (9))){
var inst_62388 = (state_62418[(2)]);
var state_62418__$1 = state_62418;
var statearr_62454_62511 = state_62418__$1;
(statearr_62454_62511[(2)] = inst_62388);

(statearr_62454_62511[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62419 === (5))){
var inst_62390 = (state_62418[(2)]);
var inst_62391 = superv.async._unregister_go.call(null,inst_62390,id__23768__auto____$1);
var state_62418__$1 = (function (){var statearr_62455 = state_62418;
(statearr_62455[(10)] = inst_62391);

return statearr_62455;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62418__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62419 === (14))){
var state_62418__$1 = state_62418;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62418__$1,(16),ch);
} else {
if((state_val_62419 === (16))){
var inst_62401 = (state_62418[(2)]);
var state_62418__$1 = state_62418;
if(cljs.core.truth_(inst_62401)){
var statearr_62456_62512 = state_62418__$1;
(statearr_62456_62512[(1)] = (17));

} else {
var statearr_62457_62513 = state_62418__$1;
(statearr_62457_62513[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62419 === (10))){
var inst_62393 = (state_62418[(7)]);
var inst_62393__$1 = (state_62418[(2)]);
var inst_62394 = cljs.core.ex_data.call(null,inst_62393__$1);
var inst_62395 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_62394);
var inst_62396 = cljs.core._EQ_.call(null,inst_62395,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_62418__$1 = (function (){var statearr_62458 = state_62418;
(statearr_62458[(7)] = inst_62393__$1);

return statearr_62458;
})();
if(inst_62396){
var statearr_62459_62514 = state_62418__$1;
(statearr_62459_62514[(1)] = (11));

} else {
var statearr_62460_62515 = state_62418__$1;
(statearr_62460_62515[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62419 === (18))){
var state_62418__$1 = state_62418;
var statearr_62461_62516 = state_62418__$1;
(statearr_62461_62516[(2)] = null);

(statearr_62461_62516[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62419 === (8))){
var state_62418__$1 = state_62418;
var statearr_62462_62517 = state_62418__$1;
(statearr_62462_62517[(2)] = null);

(statearr_62462_62517[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_62367,inst_62377,inst_62378,inst_62379,inst_62420,state_val_62427,c__38309__auto___62489,c__23767__auto___62487,id__23768__auto___62488))
;
return ((function (switch__38195__auto__,c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_62367,inst_62377,inst_62378,inst_62379,inst_62420,state_val_62427,c__38309__auto___62489,c__23767__auto___62487,id__23768__auto___62488){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_62466 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_62466[(0)] = superv$async$state_machine__38196__auto__);

(statearr_62466[(1)] = (1));

return statearr_62466;
});
var superv$async$state_machine__38196__auto____1 = (function (state_62418){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_62418);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e62467){if((e62467 instanceof Object)){
var ex__38199__auto__ = e62467;
var statearr_62468_62518 = state_62418;
(statearr_62468_62518[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62418);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62467;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62519 = state_62418;
state_62418 = G__62519;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_62418){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_62418);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_62367,inst_62377,inst_62378,inst_62379,inst_62420,state_val_62427,c__38309__auto___62489,c__23767__auto___62487,id__23768__auto___62488))
})();
var state__38311__auto__ = (function (){var statearr_62469 = f__38310__auto__.call(null);
(statearr_62469[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto____$1);

return statearr_62469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});
;})(c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_62367,inst_62377,inst_62378,inst_62379,inst_62420,state_val_62427,c__38309__auto___62489,c__23767__auto___62487,id__23768__auto___62488))
})();
var inst_62422 = cljs.core.async.impl.dispatch.run.call(null,inst_62421);
var state_62426__$1 = (function (){var statearr_62470 = state_62426;
(statearr_62470[(12)] = inst_62422);

return statearr_62470;
})();
var statearr_62471_62520 = state_62426__$1;
(statearr_62471_62520[(2)] = inst_62420);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62426__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62427 === (9))){
var inst_62365 = (state_62426[(2)]);
var inst_62366 = cljs.core.async.close_BANG_.call(null,ch);
var inst_62367 = superv.async.check_supervisor.call(null,superv.async.S);
var state_62426__$1 = (function (){var statearr_62472 = state_62426;
(statearr_62472[(11)] = inst_62367);

(statearr_62472[(13)] = inst_62366);

(statearr_62472[(14)] = inst_62365);

return statearr_62472;
})();
var statearr_62473_62521 = state_62426__$1;
(statearr_62473_62521[(2)] = null);

(statearr_62473_62521[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62427 === (5))){
var state_62426__$1 = state_62426;
var statearr_62474_62522 = state_62426__$1;
(statearr_62474_62522[(2)] = null);

(statearr_62474_62522[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62427 === (14))){
var state_62426__$1 = state_62426;
var statearr_62475_62523 = state_62426__$1;
(statearr_62475_62523[(2)] = null);

(statearr_62475_62523[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62427 === (10))){
var state_62426__$1 = state_62426;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62426__$1,(12),ch);
} else {
if((state_val_62427 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_62426,(4),Error,(3),(2));
var inst_62363 = superv.async._abort.call(null,S);
var state_62426__$1 = state_62426;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62426__$1,(9),inst_62363);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___62489,c__23767__auto___62487,id__23768__auto___62488))
;
return ((function (switch__38195__auto__,c__38309__auto___62489,c__23767__auto___62487,id__23768__auto___62488){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_62479 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62479[(0)] = superv$async$state_machine__38196__auto__);

(statearr_62479[(1)] = (1));

return statearr_62479;
});
var superv$async$state_machine__38196__auto____1 = (function (state_62426){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_62426);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e62480){if((e62480 instanceof Object)){
var ex__38199__auto__ = e62480;
var statearr_62481_62524 = state_62426;
(statearr_62481_62524[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62426);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62480;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62525 = state_62426;
state_62426 = G__62525;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_62426){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_62426);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___62489,c__23767__auto___62487,id__23768__auto___62488))
})();
var state__38311__auto__ = (function (){var statearr_62482 = f__38310__auto__.call(null);
(statearr_62482[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___62489);

return statearr_62482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___62489,c__23767__auto___62487,id__23768__auto___62488))
);


return cljs.core.async.tap.call(null,mult,ch,close_QMARK_);
});

superv.async.tap.cljs$lang$maxFixedArity = 4;

/**
 * Safely managed subscription. The channel is closed on abortion and
 *   all pending puts are flushed.
 */
superv.async.sub = (function superv$async$sub(var_args){
var args62526 = [];
var len__10640__auto___62630 = arguments.length;
var i__10641__auto___62631 = (0);
while(true){
if((i__10641__auto___62631 < len__10640__auto___62630)){
args62526.push((arguments[i__10641__auto___62631]));

var G__62632 = (i__10641__auto___62631 + (1));
i__10641__auto___62631 = G__62632;
continue;
} else {
}
break;
}

var G__62528 = args62526.length;
switch (G__62528) {
case 4:
return superv.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.sub.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args62526.length)].join('')));

}
});

superv.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (S,p,topic,ch){
return superv.async.sub.call(null,S,p,topic,ch,false);
});

superv.async.sub.cljs$core$IFn$_invoke$arity$5 = (function (S,p,topic,ch,close_QMARK_){
var c__23767__auto___62634 = superv.async.check_supervisor.call(null,superv.async.S);
var id__23768__auto___62635 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__38309__auto___62636 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___62636,c__23767__auto___62634,id__23768__auto___62635){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___62636,c__23767__auto___62634,id__23768__auto___62635){
return (function (state_62587){
var state_val_62588 = (state_62587[(1)]);
if((state_val_62588 === (1))){
var state_62587__$1 = state_62587;
var statearr_62589_62637 = state_62587__$1;
(statearr_62589_62637[(2)] = null);

(statearr_62589_62637[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62588 === (2))){
var inst_62585 = (state_62587[(2)]);
var state_62587__$1 = state_62587;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62587__$1,inst_62585);
} else {
if((state_val_62588 === (3))){
var inst_62529 = (state_62587[(2)]);
var inst_62530 = superv.async._unregister_go.call(null,S,id__23768__auto___62635);
var state_62587__$1 = (function (){var statearr_62590 = state_62587;
(statearr_62590[(7)] = inst_62529);

(statearr_62590[(8)] = inst_62530);

return statearr_62590;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62587__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62588 === (4))){
var inst_62532 = (state_62587[(9)]);
var inst_62532__$1 = (state_62587[(2)]);
var inst_62533 = cljs.core.ex_data.call(null,inst_62532__$1);
var inst_62534 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_62533);
var inst_62535 = cljs.core._EQ_.call(null,inst_62534,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_62587__$1 = (function (){var statearr_62591 = state_62587;
(statearr_62591[(9)] = inst_62532__$1);

return statearr_62591;
})();
if(inst_62535){
var statearr_62592_62638 = state_62587__$1;
(statearr_62592_62638[(1)] = (5));

} else {
var statearr_62593_62639 = state_62587__$1;
(statearr_62593_62639[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62588 === (5))){
var state_62587__$1 = state_62587;
var statearr_62594_62640 = state_62587__$1;
(statearr_62594_62640[(2)] = null);

(statearr_62594_62640[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62588 === (6))){
var inst_62532 = (state_62587[(9)]);
var inst_62538 = superv.async._track_exception.call(null,S,inst_62532);
var state_62587__$1 = state_62587;
var statearr_62595_62641 = state_62587__$1;
(statearr_62595_62641[(2)] = inst_62538);

(statearr_62595_62641[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62588 === (7))){
var inst_62532 = (state_62587[(9)]);
var inst_62540 = (state_62587[(2)]);
var state_62587__$1 = (function (){var statearr_62596 = state_62587;
(statearr_62596[(10)] = inst_62540);

return statearr_62596;
})();
var statearr_62597_62642 = state_62587__$1;
(statearr_62597_62642[(2)] = inst_62532);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62587__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62588 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_62587,(4),Error,(3),(2));
var inst_62544 = superv.async._abort.call(null,S);
var state_62587__$1 = state_62587;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62587__$1,(9),inst_62544);
} else {
if((state_val_62588 === (9))){
var inst_62546 = (state_62587[(2)]);
var inst_62547 = cljs.core.async.close_BANG_.call(null,ch);
var inst_62548 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_62549 = cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))));
var inst_62550 = superv.async._register_go.call(null,S,inst_62549);
var inst_62581 = cljs.core.async.chan.call(null,(1));
var inst_62582 = (function (){var c__23767__auto____$1 = inst_62548;
var id__23768__auto____$1 = inst_62550;
var c__38309__auto____$1 = inst_62581;
return ((function (c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_62546,inst_62547,inst_62548,inst_62549,inst_62550,inst_62581,state_val_62588,c__38309__auto___62636,c__23767__auto___62634,id__23768__auto___62635){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_62546,inst_62547,inst_62548,inst_62549,inst_62550,inst_62581,state_val_62588,c__38309__auto___62636,c__23767__auto___62634,id__23768__auto___62635){
return (function (state_62579){
var state_val_62580 = (state_62579[(1)]);
if((state_val_62580 === (7))){
var inst_62554 = (state_62579[(7)]);
var inst_62562 = (state_62579[(2)]);
var state_62579__$1 = (function (){var statearr_62598 = state_62579;
(statearr_62598[(8)] = inst_62562);

return statearr_62598;
})();
var statearr_62599_62643 = state_62579__$1;
(statearr_62599_62643[(2)] = inst_62554);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62579__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62580 === (1))){
var state_62579__$1 = state_62579;
var statearr_62600_62644 = state_62579__$1;
(statearr_62600_62644[(2)] = null);

(statearr_62600_62644[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62580 === (4))){
var inst_62554 = (state_62579[(7)]);
var inst_62554__$1 = (state_62579[(2)]);
var inst_62555 = cljs.core.ex_data.call(null,inst_62554__$1);
var inst_62556 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_62555);
var inst_62557 = cljs.core._EQ_.call(null,inst_62556,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_62579__$1 = (function (){var statearr_62601 = state_62579;
(statearr_62601[(7)] = inst_62554__$1);

return statearr_62601;
})();
if(inst_62557){
var statearr_62602_62645 = state_62579__$1;
(statearr_62602_62645[(1)] = (5));

} else {
var statearr_62603_62646 = state_62579__$1;
(statearr_62603_62646[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62580 === (13))){
var state_62579__$1 = state_62579;
var statearr_62604_62647 = state_62579__$1;
(statearr_62604_62647[(2)] = null);

(statearr_62604_62647[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62580 === (6))){
var inst_62554 = (state_62579[(7)]);
var inst_62560 = superv.async._track_exception.call(null,S,inst_62554);
var state_62579__$1 = state_62579;
var statearr_62605_62648 = state_62579__$1;
(statearr_62605_62648[(2)] = inst_62560);

(statearr_62605_62648[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62580 === (3))){
var inst_62551 = (state_62579[(2)]);
var inst_62552 = superv.async._unregister_go.call(null,S,id__23768__auto____$1);
var state_62579__$1 = (function (){var statearr_62606 = state_62579;
(statearr_62606[(9)] = inst_62551);

(statearr_62606[(10)] = inst_62552);

return statearr_62606;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62579__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62580 === (12))){
var state_62579__$1 = state_62579;
var statearr_62607_62649 = state_62579__$1;
(statearr_62607_62649[(2)] = null);

(statearr_62607_62649[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62580 === (2))){
var inst_62577 = (state_62579[(2)]);
var state_62579__$1 = state_62579;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62579__$1,inst_62577);
} else {
if((state_val_62580 === (11))){
var inst_62568 = (state_62579[(2)]);
var state_62579__$1 = state_62579;
if(cljs.core.truth_(inst_62568)){
var statearr_62608_62650 = state_62579__$1;
(statearr_62608_62650[(1)] = (12));

} else {
var statearr_62609_62651 = state_62579__$1;
(statearr_62609_62651[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62580 === (9))){
var state_62579__$1 = state_62579;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62579__$1,(11),ch);
} else {
if((state_val_62580 === (5))){
var state_62579__$1 = state_62579;
var statearr_62610_62652 = state_62579__$1;
(statearr_62610_62652[(2)] = null);

(statearr_62610_62652[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62580 === (14))){
var inst_62573 = (state_62579[(2)]);
var state_62579__$1 = state_62579;
var statearr_62611_62653 = state_62579__$1;
(statearr_62611_62653[(2)] = inst_62573);

(statearr_62611_62653[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62580 === (10))){
var inst_62575 = (state_62579[(2)]);
var state_62579__$1 = state_62579;
var statearr_62612_62654 = state_62579__$1;
(statearr_62612_62654[(2)] = inst_62575);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62579__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62580 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_62579,(4),Error,(3),(2));
var state_62579__$1 = state_62579;
var statearr_62613_62655 = state_62579__$1;
(statearr_62613_62655[(2)] = null);

(statearr_62613_62655[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_62546,inst_62547,inst_62548,inst_62549,inst_62550,inst_62581,state_val_62588,c__38309__auto___62636,c__23767__auto___62634,id__23768__auto___62635))
;
return ((function (switch__38195__auto__,c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_62546,inst_62547,inst_62548,inst_62549,inst_62550,inst_62581,state_val_62588,c__38309__auto___62636,c__23767__auto___62634,id__23768__auto___62635){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_62617 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_62617[(0)] = superv$async$state_machine__38196__auto__);

(statearr_62617[(1)] = (1));

return statearr_62617;
});
var superv$async$state_machine__38196__auto____1 = (function (state_62579){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_62579);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e62618){if((e62618 instanceof Object)){
var ex__38199__auto__ = e62618;
var statearr_62619_62656 = state_62579;
(statearr_62619_62656[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62579);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62618;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62657 = state_62579;
state_62579 = G__62657;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_62579){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_62579);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_62546,inst_62547,inst_62548,inst_62549,inst_62550,inst_62581,state_val_62588,c__38309__auto___62636,c__23767__auto___62634,id__23768__auto___62635))
})();
var state__38311__auto__ = (function (){var statearr_62620 = f__38310__auto__.call(null);
(statearr_62620[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto____$1);

return statearr_62620;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});
;})(c__23767__auto____$1,id__23768__auto____$1,c__38309__auto____$1,inst_62546,inst_62547,inst_62548,inst_62549,inst_62550,inst_62581,state_val_62588,c__38309__auto___62636,c__23767__auto___62634,id__23768__auto___62635))
})();
var inst_62583 = cljs.core.async.impl.dispatch.run.call(null,inst_62582);
var state_62587__$1 = (function (){var statearr_62621 = state_62587;
(statearr_62621[(11)] = inst_62546);

(statearr_62621[(12)] = inst_62583);

(statearr_62621[(13)] = inst_62547);

return statearr_62621;
})();
var statearr_62622_62658 = state_62587__$1;
(statearr_62622_62658[(2)] = inst_62581);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62587__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___62636,c__23767__auto___62634,id__23768__auto___62635))
;
return ((function (switch__38195__auto__,c__38309__auto___62636,c__23767__auto___62634,id__23768__auto___62635){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_62626 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62626[(0)] = superv$async$state_machine__38196__auto__);

(statearr_62626[(1)] = (1));

return statearr_62626;
});
var superv$async$state_machine__38196__auto____1 = (function (state_62587){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_62587);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e62627){if((e62627 instanceof Object)){
var ex__38199__auto__ = e62627;
var statearr_62628_62659 = state_62587;
(statearr_62628_62659[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62587);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62627;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62660 = state_62587;
state_62587 = G__62660;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_62587){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_62587);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___62636,c__23767__auto___62634,id__23768__auto___62635))
})();
var state__38311__auto__ = (function (){var statearr_62629 = f__38310__auto__.call(null);
(statearr_62629[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___62636);

return statearr_62629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___62636,c__23767__auto___62634,id__23768__auto___62635))
);


return cljs.core.async.sub.call(null,p,topic,ch,close_QMARK_);
});

superv.async.sub.cljs$lang$maxFixedArity = 5;

/**
 * Creates a supervised channel for transducer xform. Exceptions
 *   immediatly propagate to the supervisor.
 */
superv.async.chan_super = (function superv$async$chan_super(S,buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,(function (e){
return cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(S),e);
}));
});
/**
 * Starts a subsystem with supervised go-routines initialized by start-fn.
 *   Restarts the system on error for retries times with a potential delay in
 *   milliseconds, an optional error-fn predicate determining the retry and a
 *   optional filter by exception type. You can optionally pass a supervisor to
 *   form a supervision tree. Whenever this passed supervisor aborts the context,
 *   this supervisor will close as well. You still need to block on the result of
 *   this supervisor if you want a clean synchronized shutdown. The concept is
 *   similar to http://learnyousomeerlang.com/supervisors
 * 
 *   All blocking channel ops in the subroutines (supervised context) are
 *   aborted with an exception on error to force total termination. The
 *   supervisor waits until all supervised go-routines are finished and
 *   have freed resources before restarting.
 * 
 *   If exceptions are not taken from go-try channels (by error), they become stale
 *   after the stale-timeout and trigger a restart or are propagated to the parent
 *   supervisor (if available) and the return value.
 * 
 *   Note: The signature and behaviour of this function might still change.
 */
superv.async.restarting_supervisor = (function superv$async$restarting_supervisor(var_args){
var args__10647__auto__ = [];
var len__10640__auto___62968 = arguments.length;
var i__10641__auto___62969 = (0);
while(true){
if((i__10641__auto___62969 < len__10640__auto___62968)){
args__10647__auto__.push((arguments[i__10641__auto___62969]));

var G__62970 = (i__10641__auto___62969 + (1));
i__10641__auto___62969 = G__62970;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (start_fn,p__62675){
var map__62676 = p__62675;
var map__62676__$1 = ((((!((map__62676 == null)))?((((map__62676.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62676.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62676):map__62676);
var retries = cljs.core.get.call(null,map__62676__$1,new cljs.core.Keyword(null,"retries","retries",1888092808),Infinity);
var delay = cljs.core.get.call(null,map__62676__$1,new cljs.core.Keyword(null,"delay","delay",-574225219),(0));
var error_fn = cljs.core.get.call(null,map__62676__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),null);
var exception = cljs.core.get.call(null,map__62676__$1,new cljs.core.Keyword(null,"exception","exception",-335277064),Error);
var stale_timeout = cljs.core.get.call(null,map__62676__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((60) * (1000)));
var log_fn = cljs.core.get.call(null,map__62676__$1,new cljs.core.Keyword(null,"log-fn","log-fn",-2003241282),((function (map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout){
return (function (level,msg){
return cljs.core.println.call(null,level,msg);
});})(map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout))
);
var supervisor = cljs.core.get.call(null,map__62676__$1,new cljs.core.Keyword(null,"supervisor","supervisor",-134060208));
var retries__$1 = (function (){var or__9419__auto__ = retries;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return Infinity;
}
})();
var out_ch = cljs.core.async.chan.call(null);
var c__38309__auto___62971 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_62867){
var state_val_62868 = (state_62867[(1)]);
if((state_val_62868 === (7))){
var inst_62682 = (state_62867[(7)]);
var inst_62810 = (state_62867[(2)]);
var inst_62811 = cljs.core.nth.call(null,inst_62810,(0),null);
var inst_62812 = cljs.core.nth.call(null,inst_62810,(1),null);
var inst_62813 = cljs.core._EQ_.call(null,inst_62812,inst_62682);
var inst_62814 = !(inst_62813);
var state_62867__$1 = (function (){var statearr_62869 = state_62867;
(statearr_62869[(8)] = inst_62811);

return statearr_62869;
})();
if(inst_62814){
var statearr_62870_62972 = state_62867__$1;
(statearr_62870_62972[(1)] = (8));

} else {
var statearr_62871_62973 = state_62867__$1;
(statearr_62871_62973[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62868 === (20))){
var inst_62811 = (state_62867[(8)]);
var inst_62842 = (state_62867[(2)]);
var inst_62843 = cljs.core.async.put_BANG_.call(null,out_ch,inst_62811);
var inst_62844 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_62867__$1 = (function (){var statearr_62872 = state_62867;
(statearr_62872[(9)] = inst_62843);

(statearr_62872[(10)] = inst_62842);

return statearr_62872;
})();
var statearr_62873_62974 = state_62867__$1;
(statearr_62873_62974[(2)] = inst_62844);

(statearr_62873_62974[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62868 === (1))){
var inst_62678 = retries__$1;
var state_62867__$1 = (function (){var statearr_62874 = state_62867;
(statearr_62874[(11)] = inst_62678);

return statearr_62874;
})();
var statearr_62875_62975 = state_62867__$1;
(statearr_62875_62975[(2)] = null);

(statearr_62875_62975[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62868 === (4))){
var inst_62681 = (state_62867[(12)]);
var inst_62691 = (state_62867[(13)]);
var inst_62690 = (state_62867[(14)]);
var inst_62680 = (state_62867[(15)]);
var inst_62682 = (state_62867[(7)]);
var inst_62678 = (state_62867[(11)]);
var inst_62693 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_62694 = cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"supervisor","supervisor",1506471319,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ab-ch","ab-ch",-698106711,null)));
var inst_62695 = superv.async._register_go.call(null,supervisor,inst_62694);
var inst_62720 = cljs.core.async.chan.call(null,(1));
var inst_62721 = (function (){var c__38309__auto____$1 = inst_62720;
var stale_timeout__$1 = (1000);
var c__23767__auto__ = inst_62693;
var id__23768__auto__ = inst_62695;
var err_ch = inst_62680;
var ab_ch = inst_62681;
var res_ch = inst_62691;
var close_ch = inst_62682;
var retries__$2 = inst_62678;
var s = inst_62690;
return ((function (c__38309__auto____$1,stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62693,inst_62694,inst_62695,inst_62720,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto____$1,stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62693,inst_62694,inst_62695,inst_62720,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_62718){
var state_val_62719 = (state_62718[(1)]);
if((state_val_62719 === (1))){
var state_62718__$1 = state_62718;
var statearr_62876_62976 = state_62718__$1;
(statearr_62876_62976[(2)] = null);

(statearr_62876_62976[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62719 === (2))){
var inst_62716 = (state_62718[(2)]);
var state_62718__$1 = state_62718;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62718__$1,inst_62716);
} else {
if((state_val_62719 === (3))){
var inst_62696 = (state_62718[(2)]);
var inst_62697 = superv.async._unregister_go.call(null,supervisor,id__23768__auto__);
var state_62718__$1 = (function (){var statearr_62877 = state_62718;
(statearr_62877[(7)] = inst_62696);

(statearr_62877[(8)] = inst_62697);

return statearr_62877;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62718__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62719 === (4))){
var inst_62699 = (state_62718[(9)]);
var inst_62699__$1 = (state_62718[(2)]);
var inst_62700 = cljs.core.ex_data.call(null,inst_62699__$1);
var inst_62701 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_62700);
var inst_62702 = cljs.core._EQ_.call(null,inst_62701,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_62718__$1 = (function (){var statearr_62878 = state_62718;
(statearr_62878[(9)] = inst_62699__$1);

return statearr_62878;
})();
if(inst_62702){
var statearr_62879_62977 = state_62718__$1;
(statearr_62879_62977[(1)] = (5));

} else {
var statearr_62880_62978 = state_62718__$1;
(statearr_62880_62978[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62719 === (5))){
var state_62718__$1 = state_62718;
var statearr_62881_62979 = state_62718__$1;
(statearr_62881_62979[(2)] = null);

(statearr_62881_62979[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62719 === (6))){
var inst_62699 = (state_62718[(9)]);
var inst_62705 = superv.async._track_exception.call(null,supervisor,inst_62699);
var state_62718__$1 = state_62718;
var statearr_62882_62980 = state_62718__$1;
(statearr_62882_62980[(2)] = inst_62705);

(statearr_62882_62980[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62719 === (7))){
var inst_62699 = (state_62718[(9)]);
var inst_62707 = (state_62718[(2)]);
var state_62718__$1 = (function (){var statearr_62883 = state_62718;
(statearr_62883[(10)] = inst_62707);

return statearr_62883;
})();
var statearr_62884_62981 = state_62718__$1;
(statearr_62884_62981[(2)] = inst_62699);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62718__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62719 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_62718,(4),Error,(3),(2));
var inst_62711 = superv.async._abort.call(null,supervisor);
var state_62718__$1 = state_62718;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62718__$1,(9),inst_62711);
} else {
if((state_val_62719 === (9))){
var inst_62713 = (state_62718[(2)]);
var inst_62714 = cljs.core.async.close_BANG_.call(null,ab_ch);
var state_62718__$1 = (function (){var statearr_62885 = state_62718;
(statearr_62885[(11)] = inst_62713);

return statearr_62885;
})();
var statearr_62886_62982 = state_62718__$1;
(statearr_62886_62982[(2)] = inst_62714);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62718__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__38309__auto____$1,stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62693,inst_62694,inst_62695,inst_62720,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__38195__auto__,c__38309__auto____$1,stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62693,inst_62694,inst_62695,inst_62720,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_62890 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62890[(0)] = superv$async$state_machine__38196__auto__);

(statearr_62890[(1)] = (1));

return statearr_62890;
});
var superv$async$state_machine__38196__auto____1 = (function (state_62718){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_62718);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e62891){if((e62891 instanceof Object)){
var ex__38199__auto__ = e62891;
var statearr_62892_62983 = state_62718;
(statearr_62892_62983[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62718);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62891;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62984 = state_62718;
state_62718 = G__62984;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_62718){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_62718);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto____$1,stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62693,inst_62694,inst_62695,inst_62720,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__38311__auto__ = (function (){var statearr_62893 = f__38310__auto__.call(null);
(statearr_62893[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto____$1);

return statearr_62893;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});
;})(c__38309__auto____$1,stale_timeout__$1,c__23767__auto__,id__23768__auto__,err_ch,ab_ch,res_ch,close_ch,retries__$2,s,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62693,inst_62694,inst_62695,inst_62720,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_62722 = cljs.core.async.impl.dispatch.run.call(null,inst_62721);
var state_62867__$1 = (function (){var statearr_62894 = state_62867;
(statearr_62894[(16)] = inst_62722);

return statearr_62894;
})();
var statearr_62895_62985 = state_62867__$1;
(statearr_62895_62985[(2)] = inst_62720);

(statearr_62895_62985[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62868 === (15))){
var inst_62811 = (state_62867[(8)]);
var inst_62833 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62834 = [new cljs.core.Keyword(null,"passing-error","passing-error",-1357712542),inst_62811];
var inst_62835 = cljs.core.PersistentHashMap.fromArrays(inst_62833,inst_62834);
var inst_62836 = log_fn.call(null,new cljs.core.Keyword(null,"error","error",-978969032),inst_62835);
var state_62867__$1 = (function (){var statearr_62896 = state_62867;
(statearr_62896[(17)] = inst_62836);

return statearr_62896;
})();
if(cljs.core.truth_(supervisor)){
var statearr_62897_62986 = state_62867__$1;
(statearr_62897_62986[(1)] = (18));

} else {
var statearr_62898_62987 = state_62867__$1;
(statearr_62898_62987[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62868 === (21))){
var inst_62678 = (state_62867[(11)]);
var inst_62811 = (state_62867[(8)]);
var inst_62848 = (state_62867[(2)]);
var inst_62849 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"further-retries","further-retries",1297645153)];
var inst_62850 = [new cljs.core.Keyword(null,"retry","retry",-614012896),inst_62811,inst_62678];
var inst_62851 = cljs.core.PersistentHashMap.fromArrays(inst_62849,inst_62850);
var inst_62852 = log_fn.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),inst_62851);
var inst_62853 = (inst_62678 - (1));
var inst_62678__$1 = inst_62853;
var state_62867__$1 = (function (){var statearr_62899 = state_62867;
(statearr_62899[(18)] = inst_62848);

(statearr_62899[(11)] = inst_62678__$1);

(statearr_62899[(19)] = inst_62852);

return statearr_62899;
})();
var statearr_62900_62988 = state_62867__$1;
(statearr_62900_62988[(2)] = null);

(statearr_62900_62988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62868 === (13))){
var inst_62811 = (state_62867[(8)]);
var inst_62825 = error_fn.call(null,inst_62811);
var state_62867__$1 = state_62867;
var statearr_62901_62989 = state_62867__$1;
(statearr_62901_62989[(2)] = inst_62825);

(statearr_62901_62989[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62868 === (22))){
var inst_62859 = (state_62867[(2)]);
var inst_62860 = cljs.core.async.put_BANG_.call(null,out_ch,inst_62859);
var inst_62861 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_62867__$1 = (function (){var statearr_62902 = state_62867;
(statearr_62902[(20)] = inst_62860);

return statearr_62902;
})();
var statearr_62903_62990 = state_62867__$1;
(statearr_62903_62990[(2)] = inst_62861);

(statearr_62903_62990[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62868 === (6))){
var inst_62681 = (state_62867[(12)]);
var inst_62691 = (state_62867[(13)]);
var inst_62690 = (state_62867[(14)]);
var inst_62680 = (state_62867[(15)]);
var inst_62682 = (state_62867[(7)]);
var inst_62678 = (state_62867[(11)]);
var inst_62725 = (state_62867[(2)]);
var inst_62772 = cljs.core.async.chan.call(null,(1));
var inst_62773 = (function (){var retries__$2 = inst_62678;
var err_ch = inst_62680;
var ab_ch = inst_62681;
var close_ch = inst_62682;
var s = inst_62690;
var res_ch = inst_62691;
var stale_timeout__$1 = (1000);
var c__38309__auto____$1 = inst_62772;
return ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62725,inst_62772,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62725,inst_62772,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_62770){
var state_val_62771 = (state_62770[(1)]);
if((state_val_62771 === (7))){
var inst_62745 = (state_62770[(7)]);
var inst_62732 = (state_62770[(2)]);
var inst_62740 = (function (){return ((function (inst_62745,inst_62732,state_val_62771,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62725,inst_62772,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (p__62739){
var vec__62904 = p__62739;
var k = cljs.core.nth.call(null,vec__62904,(0),null);
var v = cljs.core.nth.call(null,vec__62904,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout__$1) > v.getTime());
});
;})(inst_62745,inst_62732,state_val_62771,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62725,inst_62772,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_62741 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_62742 = cljs.core.deref.call(null,inst_62741);
var inst_62743 = cljs.core.filter.call(null,inst_62740,inst_62742);
var inst_62744 = cljs.core.nth.call(null,inst_62743,(0),null);
var inst_62745__$1 = cljs.core.nth.call(null,inst_62744,(0),null);
var inst_62746 = cljs.core.nth.call(null,inst_62744,(1),null);
var state_62770__$1 = (function (){var statearr_62907 = state_62770;
(statearr_62907[(7)] = inst_62745__$1);

(statearr_62907[(8)] = inst_62732);

(statearr_62907[(9)] = inst_62746);

return statearr_62907;
})();
if(cljs.core.truth_(inst_62745__$1)){
var statearr_62908_62991 = state_62770__$1;
(statearr_62908_62991[(1)] = (8));

} else {
var statearr_62909_62992 = state_62770__$1;
(statearr_62909_62992[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62771 === (1))){
var state_62770__$1 = state_62770;
var statearr_62910_62993 = state_62770__$1;
(statearr_62910_62993[(2)] = null);

(statearr_62910_62993[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62771 === (4))){
var state_62770__$1 = state_62770;
var statearr_62911_62994 = state_62770__$1;
(statearr_62911_62994[(2)] = null);

(statearr_62911_62994[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62771 === (13))){
var inst_62745 = (state_62770[(7)]);
var inst_62758 = (state_62770[(2)]);
var inst_62759 = superv.async._free_exception.call(null,s,inst_62745);
var inst_62760 = cljs.core.async.put_BANG_.call(null,err_ch,inst_62745);
var state_62770__$1 = (function (){var statearr_62912 = state_62770;
(statearr_62912[(10)] = inst_62759);

(statearr_62912[(11)] = inst_62758);

return statearr_62912;
})();
var statearr_62913_62995 = state_62770__$1;
(statearr_62913_62995[(2)] = inst_62760);

(statearr_62913_62995[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62771 === (6))){
var inst_62766 = (state_62770[(2)]);
var state_62770__$1 = state_62770;
var statearr_62914_62996 = state_62770__$1;
(statearr_62914_62996[(2)] = inst_62766);

(statearr_62914_62996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62771 === (3))){
var inst_62768 = (state_62770[(2)]);
var state_62770__$1 = state_62770;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62770__$1,inst_62768);
} else {
if((state_val_62771 === (12))){
var inst_62745 = (state_62770[(7)]);
var inst_62753 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62754 = [new cljs.core.Keyword(null,"stale-error-in-supervisor","stale-error-in-supervisor",-123257662),inst_62745];
var inst_62755 = cljs.core.PersistentHashMap.fromArrays(inst_62753,inst_62754);
var inst_62756 = log_fn.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_62755);
var state_62770__$1 = state_62770;
var statearr_62915_62997 = state_62770__$1;
(statearr_62915_62997[(2)] = inst_62756);

(statearr_62915_62997[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62771 === (2))){
var inst_62727 = cljs.core.async.poll_BANG_.call(null,ab_ch);
var state_62770__$1 = state_62770;
if(cljs.core.truth_(inst_62727)){
var statearr_62916_62998 = state_62770__$1;
(statearr_62916_62998[(1)] = (4));

} else {
var statearr_62917_62999 = state_62770__$1;
(statearr_62917_62999[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62771 === (11))){
var state_62770__$1 = state_62770;
var statearr_62918_63000 = state_62770__$1;
(statearr_62918_63000[(2)] = null);

(statearr_62918_63000[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62771 === (9))){
var state_62770__$1 = state_62770;
var statearr_62919_63001 = state_62770__$1;
(statearr_62919_63001[(2)] = null);

(statearr_62919_63001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62771 === (5))){
var inst_62730 = cljs.core.async.timeout.call(null,stale_timeout__$1);
var state_62770__$1 = state_62770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62770__$1,(7),inst_62730);
} else {
if((state_val_62771 === (10))){
var inst_62764 = (state_62770[(2)]);
var state_62770__$1 = state_62770;
var statearr_62920_63002 = state_62770__$1;
(statearr_62920_63002[(2)] = inst_62764);

(statearr_62920_63002[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62771 === (8))){
var inst_62745 = (state_62770[(7)]);
var inst_62748 = cljs.core.ex_data.call(null,inst_62745);
var inst_62749 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_62748);
var inst_62750 = cljs.core._EQ_.call(null,inst_62749,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_62770__$1 = state_62770;
if(inst_62750){
var statearr_62921_63003 = state_62770__$1;
(statearr_62921_63003[(1)] = (11));

} else {
var statearr_62922_63004 = state_62770__$1;
(statearr_62922_63004[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62725,inst_62772,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__38195__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62725,inst_62772,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_62926 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62926[(0)] = superv$async$state_machine__38196__auto__);

(statearr_62926[(1)] = (1));

return statearr_62926;
});
var superv$async$state_machine__38196__auto____1 = (function (state_62770){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_62770);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e62927){if((e62927 instanceof Object)){
var ex__38199__auto__ = e62927;
var statearr_62928_63005 = state_62770;
(statearr_62928_63005[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62770);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62927;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63006 = state_62770;
state_62770 = G__63006;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_62770){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_62770);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62725,inst_62772,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__38311__auto__ = (function (){var statearr_62929 = f__38310__auto__.call(null);
(statearr_62929[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto____$1);

return statearr_62929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});
;})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62725,inst_62772,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_62774 = cljs.core.async.impl.dispatch.run.call(null,inst_62773);
var inst_62800 = cljs.core.async.chan.call(null,(1));
var inst_62801 = (function (){var retries__$2 = inst_62678;
var err_ch = inst_62680;
var ab_ch = inst_62681;
var close_ch = inst_62682;
var s = inst_62690;
var res_ch = inst_62691;
var stale_timeout__$1 = (1000);
var c__38309__auto____$1 = inst_62800;
return ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62725,inst_62772,inst_62773,inst_62774,inst_62800,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62725,inst_62772,inst_62773,inst_62774,inst_62800,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_62798){
var state_val_62799 = (state_62798[(1)]);
if((state_val_62799 === (1))){
var inst_62775 = (0);
var state_62798__$1 = (function (){var statearr_62930 = state_62798;
(statearr_62930[(7)] = inst_62775);

return statearr_62930;
})();
var statearr_62931_63007 = state_62798__$1;
(statearr_62931_63007[(2)] = null);

(statearr_62931_63007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62799 === (2))){
var inst_62777 = new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(s);
var inst_62778 = cljs.core.deref.call(null,inst_62777);
var inst_62779 = cljs.core.empty_QMARK_.call(null,inst_62778);
var inst_62780 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_62781 = cljs.core.deref.call(null,inst_62780);
var inst_62782 = cljs.core.empty_QMARK_.call(null,inst_62781);
var inst_62783 = (inst_62779) && (inst_62782);
var inst_62784 = cljs.core.not.call(null,inst_62783);
var state_62798__$1 = state_62798;
if(inst_62784){
var statearr_62932_63008 = state_62798__$1;
(statearr_62932_63008[(1)] = (4));

} else {
var statearr_62933_63009 = state_62798__$1;
(statearr_62933_63009[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62799 === (3))){
var inst_62796 = (state_62798[(2)]);
var state_62798__$1 = state_62798;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62798__$1,inst_62796);
} else {
if((state_val_62799 === (4))){
var inst_62786 = cljs.core.async.timeout.call(null,(100));
var state_62798__$1 = state_62798;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62798__$1,(7),inst_62786);
} else {
if((state_val_62799 === (5))){
var inst_62792 = cljs.core.async.close_BANG_.call(null,close_ch);
var state_62798__$1 = state_62798;
var statearr_62934_63010 = state_62798__$1;
(statearr_62934_63010[(2)] = inst_62792);

(statearr_62934_63010[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62799 === (6))){
var inst_62794 = (state_62798[(2)]);
var state_62798__$1 = state_62798;
var statearr_62935_63011 = state_62798__$1;
(statearr_62935_63011[(2)] = inst_62794);

(statearr_62935_63011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62799 === (7))){
var inst_62775 = (state_62798[(7)]);
var inst_62788 = (state_62798[(2)]);
var inst_62789 = (inst_62775 + (1));
var inst_62775__$1 = inst_62789;
var state_62798__$1 = (function (){var statearr_62936 = state_62798;
(statearr_62936[(8)] = inst_62788);

(statearr_62936[(7)] = inst_62775__$1);

return statearr_62936;
})();
var statearr_62937_63012 = state_62798__$1;
(statearr_62937_63012[(2)] = null);

(statearr_62937_63012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62725,inst_62772,inst_62773,inst_62774,inst_62800,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__38195__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62725,inst_62772,inst_62773,inst_62774,inst_62800,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_62941 = [null,null,null,null,null,null,null,null,null];
(statearr_62941[(0)] = superv$async$state_machine__38196__auto__);

(statearr_62941[(1)] = (1));

return statearr_62941;
});
var superv$async$state_machine__38196__auto____1 = (function (state_62798){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_62798);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e62942){if((e62942 instanceof Object)){
var ex__38199__auto__ = e62942;
var statearr_62943_63013 = state_62798;
(statearr_62943_63013[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62798);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62942;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63014 = state_62798;
state_62798 = G__63014;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_62798){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_62798);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62725,inst_62772,inst_62773,inst_62774,inst_62800,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__38311__auto__ = (function (){var statearr_62944 = f__38310__auto__.call(null);
(statearr_62944[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto____$1);

return statearr_62944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});
;})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__38309__auto____$1,inst_62681,inst_62691,inst_62690,inst_62680,inst_62682,inst_62678,inst_62725,inst_62772,inst_62773,inst_62774,inst_62800,state_val_62868,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_62802 = cljs.core.async.impl.dispatch.run.call(null,inst_62801);
var inst_62806 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62807 = [inst_62680,inst_62682];
var inst_62808 = (new cljs.core.PersistentVector(null,2,(5),inst_62806,inst_62807,null));
var state_62867__$1 = (function (){var statearr_62945 = state_62867;
(statearr_62945[(21)] = inst_62802);

(statearr_62945[(22)] = inst_62774);

(statearr_62945[(23)] = inst_62725);

return statearr_62945;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_62867__$1,(7),inst_62808,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_62868 === (17))){
var inst_62856 = (state_62867[(2)]);
var state_62867__$1 = state_62867;
var statearr_62946_63015 = state_62867__$1;
(statearr_62946_63015[(2)] = inst_62856);

(statearr_62946_63015[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62868 === (3))){
var inst_62865 = (state_62867[(2)]);
var state_62867__$1 = state_62867;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62867__$1,inst_62865);
} else {
if((state_val_62868 === (12))){
var inst_62822 = (state_62867[(24)]);
var state_62867__$1 = state_62867;
var statearr_62947_63016 = state_62867__$1;
(statearr_62947_63016[(2)] = inst_62822);

(statearr_62947_63016[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62868 === (2))){
var inst_62681 = (state_62867[(12)]);
var inst_62690 = (state_62867[(14)]);
var inst_62680 = (state_62867[(15)]);
var inst_62680__$1 = cljs.core.async.chan.call(null);
var inst_62681__$1 = cljs.core.async.chan.call(null);
var inst_62682 = cljs.core.async.chan.call(null);
var inst_62683 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),new cljs.core.Keyword(null,"restarting","restarting",760677572)];
var inst_62684 = cljs.core.PersistentHashMap.EMPTY;
var inst_62685 = cljs.core.atom.call(null,inst_62684);
var inst_62686 = cljs.core.PersistentHashMap.EMPTY;
var inst_62687 = cljs.core.atom.call(null,inst_62686);
var inst_62688 = [inst_62680__$1,inst_62681__$1,inst_62685,inst_62687,true];
var inst_62689 = cljs.core.PersistentHashMap.fromArrays(inst_62683,inst_62688);
var inst_62690__$1 = superv.async.map__GT_TrackingSupervisor.call(null,inst_62689);
var inst_62691 = start_fn.call(null,inst_62690__$1);
var state_62867__$1 = (function (){var statearr_62948 = state_62867;
(statearr_62948[(12)] = inst_62681__$1);

(statearr_62948[(13)] = inst_62691);

(statearr_62948[(14)] = inst_62690__$1);

(statearr_62948[(15)] = inst_62680__$1);

(statearr_62948[(7)] = inst_62682);

return statearr_62948;
})();
if(cljs.core.truth_(supervisor)){
var statearr_62949_63017 = state_62867__$1;
(statearr_62949_63017[(1)] = (4));

} else {
var statearr_62950_63018 = state_62867__$1;
(statearr_62950_63018[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62868 === (19))){
var state_62867__$1 = state_62867;
var statearr_62951_63019 = state_62867__$1;
(statearr_62951_63019[(2)] = null);

(statearr_62951_63019[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62868 === (11))){
var inst_62822 = (state_62867[(24)]);
var inst_62811 = (state_62867[(8)]);
var inst_62819 = (state_62867[(2)]);
var inst_62820 = (inst_62811 instanceof exception);
var inst_62821 = cljs.core.not.call(null,inst_62820);
var inst_62822__$1 = cljs.core.not.call(null,error_fn);
var state_62867__$1 = (function (){var statearr_62952 = state_62867;
(statearr_62952[(25)] = inst_62819);

(statearr_62952[(24)] = inst_62822__$1);

(statearr_62952[(26)] = inst_62821);

return statearr_62952;
})();
if(inst_62822__$1){
var statearr_62953_63020 = state_62867__$1;
(statearr_62953_63020[(1)] = (12));

} else {
var statearr_62954_63021 = state_62867__$1;
(statearr_62954_63021[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62868 === (9))){
var inst_62691 = (state_62867[(13)]);
var state_62867__$1 = state_62867;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62867__$1,(22),inst_62691);
} else {
if((state_val_62868 === (5))){
var state_62867__$1 = state_62867;
var statearr_62955_63022 = state_62867__$1;
(statearr_62955_63022[(2)] = null);

(statearr_62955_63022[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62868 === (14))){
var inst_62821 = (state_62867[(26)]);
var inst_62678 = (state_62867[(11)]);
var inst_62827 = (state_62867[(2)]);
var inst_62828 = cljs.core.not.call(null,inst_62827);
var inst_62829 = (inst_62678 > (0));
var inst_62830 = cljs.core.not.call(null,inst_62829);
var inst_62831 = (inst_62821) || (inst_62828) || (inst_62830);
var state_62867__$1 = state_62867;
if(cljs.core.truth_(inst_62831)){
var statearr_62956_63023 = state_62867__$1;
(statearr_62956_63023[(1)] = (15));

} else {
var statearr_62957_63024 = state_62867__$1;
(statearr_62957_63024[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62868 === (16))){
var inst_62846 = cljs.core.async.timeout.call(null,delay);
var state_62867__$1 = state_62867;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62867__$1,(21),inst_62846);
} else {
if((state_val_62868 === (10))){
var inst_62863 = (state_62867[(2)]);
var state_62867__$1 = state_62867;
var statearr_62958_63025 = state_62867__$1;
(statearr_62958_63025[(2)] = inst_62863);

(statearr_62958_63025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62868 === (18))){
var inst_62811 = (state_62867[(8)]);
var inst_62838 = superv.async._error.call(null,supervisor);
var inst_62839 = cljs.core.async.put_BANG_.call(null,inst_62838,inst_62811);
var state_62867__$1 = state_62867;
var statearr_62959_63026 = state_62867__$1;
(statearr_62959_63026[(2)] = inst_62839);

(statearr_62959_63026[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62868 === (8))){
var inst_62681 = (state_62867[(12)]);
var inst_62680 = (state_62867[(15)]);
var inst_62682 = (state_62867[(7)]);
var inst_62816 = cljs.core.async.close_BANG_.call(null,inst_62680);
var inst_62817 = cljs.core.async.close_BANG_.call(null,inst_62681);
var state_62867__$1 = (function (){var statearr_62960 = state_62867;
(statearr_62960[(27)] = inst_62817);

(statearr_62960[(28)] = inst_62816);

return statearr_62960;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62867__$1,(11),inst_62682);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__38195__auto__,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__38196__auto__ = null;
var superv$async$state_machine__38196__auto____0 = (function (){
var statearr_62964 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62964[(0)] = superv$async$state_machine__38196__auto__);

(statearr_62964[(1)] = (1));

return statearr_62964;
});
var superv$async$state_machine__38196__auto____1 = (function (state_62867){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_62867);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e62965){if((e62965 instanceof Object)){
var ex__38199__auto__ = e62965;
var statearr_62966_63027 = state_62867;
(statearr_62966_63027[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62867);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62965;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63028 = state_62867;
state_62867 = G__63028;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
superv$async$state_machine__38196__auto__ = function(state_62867){
switch(arguments.length){
case 0:
return superv$async$state_machine__38196__auto____0.call(this);
case 1:
return superv$async$state_machine__38196__auto____1.call(this,state_62867);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__38196__auto____0;
superv$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__38196__auto____1;
return superv$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__38311__auto__ = (function (){var statearr_62967 = f__38310__auto__.call(null);
(statearr_62967[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___62971);

return statearr_62967;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___62971,retries__$1,out_ch,map__62676,map__62676__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
);


return out_ch;
});

superv.async.restarting_supervisor.cljs$lang$maxFixedArity = (1);

superv.async.restarting_supervisor.cljs$lang$applyTo = (function (seq62673){
var G__62674 = cljs.core.first.call(null,seq62673);
var seq62673__$1 = cljs.core.next.call(null,seq62673);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic(G__62674,seq62673__$1);
});


//# sourceMappingURL=async.js.map