// Compiled by ClojureScript 1.9.521 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args33537 = [];
var len__10640__auto___33543 = arguments.length;
var i__10641__auto___33544 = (0);
while(true){
if((i__10641__auto___33544 < len__10640__auto___33543)){
args33537.push((arguments[i__10641__auto___33544]));

var G__33545 = (i__10641__auto___33544 + (1));
i__10641__auto___33544 = G__33545;
continue;
} else {
}
break;
}

var G__33539 = args33537.length;
switch (G__33539) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args33537.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async33540 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33540 = (function (f,blockable,meta33541){
this.f = f;
this.blockable = blockable;
this.meta33541 = meta33541;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33540.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33542,meta33541__$1){
var self__ = this;
var _33542__$1 = this;
return (new cljs.core.async.t_cljs$core$async33540(self__.f,self__.blockable,meta33541__$1));
});

cljs.core.async.t_cljs$core$async33540.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33542){
var self__ = this;
var _33542__$1 = this;
return self__.meta33541;
});

cljs.core.async.t_cljs$core$async33540.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33540.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async33540.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async33540.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async33540.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta33541","meta33541",-1478113748,null)], null);
});

cljs.core.async.t_cljs$core$async33540.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33540.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33540";

cljs.core.async.t_cljs$core$async33540.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async33540");
});

cljs.core.async.__GT_t_cljs$core$async33540 = (function cljs$core$async$__GT_t_cljs$core$async33540(f__$1,blockable__$1,meta33541){
return (new cljs.core.async.t_cljs$core$async33540(f__$1,blockable__$1,meta33541));
});

}

return (new cljs.core.async.t_cljs$core$async33540(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args33549 = [];
var len__10640__auto___33552 = arguments.length;
var i__10641__auto___33553 = (0);
while(true){
if((i__10641__auto___33553 < len__10640__auto___33552)){
args33549.push((arguments[i__10641__auto___33553]));

var G__33554 = (i__10641__auto___33553 + (1));
i__10641__auto___33553 = G__33554;
continue;
} else {
}
break;
}

var G__33551 = args33549.length;
switch (G__33551) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args33549.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args33556 = [];
var len__10640__auto___33559 = arguments.length;
var i__10641__auto___33560 = (0);
while(true){
if((i__10641__auto___33560 < len__10640__auto___33559)){
args33556.push((arguments[i__10641__auto___33560]));

var G__33561 = (i__10641__auto___33560 + (1));
i__10641__auto___33560 = G__33561;
continue;
} else {
}
break;
}

var G__33558 = args33556.length;
switch (G__33558) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args33556.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args33563 = [];
var len__10640__auto___33566 = arguments.length;
var i__10641__auto___33567 = (0);
while(true){
if((i__10641__auto___33567 < len__10640__auto___33566)){
args33563.push((arguments[i__10641__auto___33567]));

var G__33568 = (i__10641__auto___33567 + (1));
i__10641__auto___33567 = G__33568;
continue;
} else {
}
break;
}

var G__33565 = args33563.length;
switch (G__33565) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args33563.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_33570 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_33570);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_33570,ret){
return (function (){
return fn1.call(null,val_33570);
});})(val_33570,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args33571 = [];
var len__10640__auto___33574 = arguments.length;
var i__10641__auto___33575 = (0);
while(true){
if((i__10641__auto___33575 < len__10640__auto___33574)){
args33571.push((arguments[i__10641__auto___33575]));

var G__33576 = (i__10641__auto___33575 + (1));
i__10641__auto___33575 = G__33576;
continue;
} else {
}
break;
}

var G__33573 = args33571.length;
switch (G__33573) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args33571.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6736__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6736__auto__)){
var ret = temp__6736__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6736__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6736__auto__)){
var retb = temp__6736__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6736__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6736__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__10440__auto___33578 = n;
var x_33579 = (0);
while(true){
if((x_33579 < n__10440__auto___33578)){
(a[x_33579] = (0));

var G__33580 = (x_33579 + (1));
x_33579 = G__33580;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__33581 = (i + (1));
i = G__33581;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async33585 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33585 = (function (flag,meta33586){
this.flag = flag;
this.meta33586 = meta33586;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33585.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_33587,meta33586__$1){
var self__ = this;
var _33587__$1 = this;
return (new cljs.core.async.t_cljs$core$async33585(self__.flag,meta33586__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async33585.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_33587){
var self__ = this;
var _33587__$1 = this;
return self__.meta33586;
});})(flag))
;

cljs.core.async.t_cljs$core$async33585.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33585.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async33585.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async33585.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async33585.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta33586","meta33586",476975768,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async33585.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33585.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33585";

cljs.core.async.t_cljs$core$async33585.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async33585");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async33585 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async33585(flag__$1,meta33586){
return (new cljs.core.async.t_cljs$core$async33585(flag__$1,meta33586));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async33585(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async33591 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33591 = (function (flag,cb,meta33592){
this.flag = flag;
this.cb = cb;
this.meta33592 = meta33592;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33591.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33593,meta33592__$1){
var self__ = this;
var _33593__$1 = this;
return (new cljs.core.async.t_cljs$core$async33591(self__.flag,self__.cb,meta33592__$1));
});

cljs.core.async.t_cljs$core$async33591.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33593){
var self__ = this;
var _33593__$1 = this;
return self__.meta33592;
});

cljs.core.async.t_cljs$core$async33591.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33591.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async33591.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async33591.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async33591.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta33592","meta33592",-173014433,null)], null);
});

cljs.core.async.t_cljs$core$async33591.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33591.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33591";

cljs.core.async.t_cljs$core$async33591.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async33591");
});

cljs.core.async.__GT_t_cljs$core$async33591 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async33591(flag__$1,cb__$1,meta33592){
return (new cljs.core.async.t_cljs$core$async33591(flag__$1,cb__$1,meta33592));
});

}

return (new cljs.core.async.t_cljs$core$async33591(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__33594_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__33594_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__33595_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__33595_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__9419__auto__ = wport;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return port;
}
})()], null));
} else {
var G__33596 = (i + (1));
i = G__33596;
continue;
}
} else {
return null;
}
break;
}
})();
var or__9419__auto__ = ret;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6738__auto__ = (function (){var and__9407__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__9407__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__9407__auto__;
}
})();
if(cljs.core.truth_(temp__6738__auto__)){
var got = temp__6738__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___33602 = arguments.length;
var i__10641__auto___33603 = (0);
while(true){
if((i__10641__auto___33603 < len__10640__auto___33602)){
args__10647__auto__.push((arguments[i__10641__auto___33603]));

var G__33604 = (i__10641__auto___33603 + (1));
i__10641__auto___33603 = G__33604;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__33599){
var map__33600 = p__33599;
var map__33600__$1 = ((((!((map__33600 == null)))?((((map__33600.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33600.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33600):map__33600);
var opts = map__33600__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq33597){
var G__33598 = cljs.core.first.call(null,seq33597);
var seq33597__$1 = cljs.core.next.call(null,seq33597);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33598,seq33597__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args33605 = [];
var len__10640__auto___33655 = arguments.length;
var i__10641__auto___33656 = (0);
while(true){
if((i__10641__auto___33656 < len__10640__auto___33655)){
args33605.push((arguments[i__10641__auto___33656]));

var G__33657 = (i__10641__auto___33656 + (1));
i__10641__auto___33656 = G__33657;
continue;
} else {
}
break;
}

var G__33607 = args33605.length;
switch (G__33607) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args33605.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__33478__auto___33659 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___33659){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___33659){
return (function (state_33631){
var state_val_33632 = (state_33631[(1)]);
if((state_val_33632 === (7))){
var inst_33627 = (state_33631[(2)]);
var state_33631__$1 = state_33631;
var statearr_33633_33660 = state_33631__$1;
(statearr_33633_33660[(2)] = inst_33627);

(statearr_33633_33660[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33632 === (1))){
var state_33631__$1 = state_33631;
var statearr_33634_33661 = state_33631__$1;
(statearr_33634_33661[(2)] = null);

(statearr_33634_33661[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33632 === (4))){
var inst_33610 = (state_33631[(7)]);
var inst_33610__$1 = (state_33631[(2)]);
var inst_33611 = (inst_33610__$1 == null);
var state_33631__$1 = (function (){var statearr_33635 = state_33631;
(statearr_33635[(7)] = inst_33610__$1);

return statearr_33635;
})();
if(cljs.core.truth_(inst_33611)){
var statearr_33636_33662 = state_33631__$1;
(statearr_33636_33662[(1)] = (5));

} else {
var statearr_33637_33663 = state_33631__$1;
(statearr_33637_33663[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33632 === (13))){
var state_33631__$1 = state_33631;
var statearr_33638_33664 = state_33631__$1;
(statearr_33638_33664[(2)] = null);

(statearr_33638_33664[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33632 === (6))){
var inst_33610 = (state_33631[(7)]);
var state_33631__$1 = state_33631;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33631__$1,(11),to,inst_33610);
} else {
if((state_val_33632 === (3))){
var inst_33629 = (state_33631[(2)]);
var state_33631__$1 = state_33631;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33631__$1,inst_33629);
} else {
if((state_val_33632 === (12))){
var state_33631__$1 = state_33631;
var statearr_33639_33665 = state_33631__$1;
(statearr_33639_33665[(2)] = null);

(statearr_33639_33665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33632 === (2))){
var state_33631__$1 = state_33631;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33631__$1,(4),from);
} else {
if((state_val_33632 === (11))){
var inst_33620 = (state_33631[(2)]);
var state_33631__$1 = state_33631;
if(cljs.core.truth_(inst_33620)){
var statearr_33640_33666 = state_33631__$1;
(statearr_33640_33666[(1)] = (12));

} else {
var statearr_33641_33667 = state_33631__$1;
(statearr_33641_33667[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33632 === (9))){
var state_33631__$1 = state_33631;
var statearr_33642_33668 = state_33631__$1;
(statearr_33642_33668[(2)] = null);

(statearr_33642_33668[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33632 === (5))){
var state_33631__$1 = state_33631;
if(cljs.core.truth_(close_QMARK_)){
var statearr_33643_33669 = state_33631__$1;
(statearr_33643_33669[(1)] = (8));

} else {
var statearr_33644_33670 = state_33631__$1;
(statearr_33644_33670[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33632 === (14))){
var inst_33625 = (state_33631[(2)]);
var state_33631__$1 = state_33631;
var statearr_33645_33671 = state_33631__$1;
(statearr_33645_33671[(2)] = inst_33625);

(statearr_33645_33671[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33632 === (10))){
var inst_33617 = (state_33631[(2)]);
var state_33631__$1 = state_33631;
var statearr_33646_33672 = state_33631__$1;
(statearr_33646_33672[(2)] = inst_33617);

(statearr_33646_33672[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33632 === (8))){
var inst_33614 = cljs.core.async.close_BANG_.call(null,to);
var state_33631__$1 = state_33631;
var statearr_33647_33673 = state_33631__$1;
(statearr_33647_33673[(2)] = inst_33614);

(statearr_33647_33673[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___33659))
;
return ((function (switch__33364__auto__,c__33478__auto___33659){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_33651 = [null,null,null,null,null,null,null,null];
(statearr_33651[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_33651[(1)] = (1));

return statearr_33651;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_33631){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_33631);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e33652){if((e33652 instanceof Object)){
var ex__33368__auto__ = e33652;
var statearr_33653_33674 = state_33631;
(statearr_33653_33674[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33631);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33652;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33675 = state_33631;
state_33631 = G__33675;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_33631){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_33631);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___33659))
})();
var state__33480__auto__ = (function (){var statearr_33654 = f__33479__auto__.call(null);
(statearr_33654[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___33659);

return statearr_33654;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___33659))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__33863){
var vec__33864 = p__33863;
var v = cljs.core.nth.call(null,vec__33864,(0),null);
var p = cljs.core.nth.call(null,vec__33864,(1),null);
var job = vec__33864;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__33478__auto___34050 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___34050,res,vec__33864,v,p,job,jobs,results){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___34050,res,vec__33864,v,p,job,jobs,results){
return (function (state_33871){
var state_val_33872 = (state_33871[(1)]);
if((state_val_33872 === (1))){
var state_33871__$1 = state_33871;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33871__$1,(2),res,v);
} else {
if((state_val_33872 === (2))){
var inst_33868 = (state_33871[(2)]);
var inst_33869 = cljs.core.async.close_BANG_.call(null,res);
var state_33871__$1 = (function (){var statearr_33873 = state_33871;
(statearr_33873[(7)] = inst_33868);

return statearr_33873;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33871__$1,inst_33869);
} else {
return null;
}
}
});})(c__33478__auto___34050,res,vec__33864,v,p,job,jobs,results))
;
return ((function (switch__33364__auto__,c__33478__auto___34050,res,vec__33864,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0 = (function (){
var statearr_33877 = [null,null,null,null,null,null,null,null];
(statearr_33877[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__);

(statearr_33877[(1)] = (1));

return statearr_33877;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1 = (function (state_33871){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_33871);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e33878){if((e33878 instanceof Object)){
var ex__33368__auto__ = e33878;
var statearr_33879_34051 = state_33871;
(statearr_33879_34051[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33871);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33878;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34052 = state_33871;
state_33871 = G__34052;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = function(state_33871){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1.call(this,state_33871);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___34050,res,vec__33864,v,p,job,jobs,results))
})();
var state__33480__auto__ = (function (){var statearr_33880 = f__33479__auto__.call(null);
(statearr_33880[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___34050);

return statearr_33880;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___34050,res,vec__33864,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__33881){
var vec__33882 = p__33881;
var v = cljs.core.nth.call(null,vec__33882,(0),null);
var p = cljs.core.nth.call(null,vec__33882,(1),null);
var job = vec__33882;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__10440__auto___34053 = n;
var __34054 = (0);
while(true){
if((__34054 < n__10440__auto___34053)){
var G__33885_34055 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__33885_34055) {
case "compute":
var c__33478__auto___34057 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__34054,c__33478__auto___34057,G__33885_34055,n__10440__auto___34053,jobs,results,process,async){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (__34054,c__33478__auto___34057,G__33885_34055,n__10440__auto___34053,jobs,results,process,async){
return (function (state_33898){
var state_val_33899 = (state_33898[(1)]);
if((state_val_33899 === (1))){
var state_33898__$1 = state_33898;
var statearr_33900_34058 = state_33898__$1;
(statearr_33900_34058[(2)] = null);

(statearr_33900_34058[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33899 === (2))){
var state_33898__$1 = state_33898;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33898__$1,(4),jobs);
} else {
if((state_val_33899 === (3))){
var inst_33896 = (state_33898[(2)]);
var state_33898__$1 = state_33898;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33898__$1,inst_33896);
} else {
if((state_val_33899 === (4))){
var inst_33888 = (state_33898[(2)]);
var inst_33889 = process.call(null,inst_33888);
var state_33898__$1 = state_33898;
if(cljs.core.truth_(inst_33889)){
var statearr_33901_34059 = state_33898__$1;
(statearr_33901_34059[(1)] = (5));

} else {
var statearr_33902_34060 = state_33898__$1;
(statearr_33902_34060[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33899 === (5))){
var state_33898__$1 = state_33898;
var statearr_33903_34061 = state_33898__$1;
(statearr_33903_34061[(2)] = null);

(statearr_33903_34061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33899 === (6))){
var state_33898__$1 = state_33898;
var statearr_33904_34062 = state_33898__$1;
(statearr_33904_34062[(2)] = null);

(statearr_33904_34062[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33899 === (7))){
var inst_33894 = (state_33898[(2)]);
var state_33898__$1 = state_33898;
var statearr_33905_34063 = state_33898__$1;
(statearr_33905_34063[(2)] = inst_33894);

(statearr_33905_34063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__34054,c__33478__auto___34057,G__33885_34055,n__10440__auto___34053,jobs,results,process,async))
;
return ((function (__34054,switch__33364__auto__,c__33478__auto___34057,G__33885_34055,n__10440__auto___34053,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0 = (function (){
var statearr_33909 = [null,null,null,null,null,null,null];
(statearr_33909[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__);

(statearr_33909[(1)] = (1));

return statearr_33909;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1 = (function (state_33898){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_33898);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e33910){if((e33910 instanceof Object)){
var ex__33368__auto__ = e33910;
var statearr_33911_34064 = state_33898;
(statearr_33911_34064[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33898);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33910;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34065 = state_33898;
state_33898 = G__34065;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = function(state_33898){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1.call(this,state_33898);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__;
})()
;})(__34054,switch__33364__auto__,c__33478__auto___34057,G__33885_34055,n__10440__auto___34053,jobs,results,process,async))
})();
var state__33480__auto__ = (function (){var statearr_33912 = f__33479__auto__.call(null);
(statearr_33912[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___34057);

return statearr_33912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(__34054,c__33478__auto___34057,G__33885_34055,n__10440__auto___34053,jobs,results,process,async))
);


break;
case "async":
var c__33478__auto___34066 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__34054,c__33478__auto___34066,G__33885_34055,n__10440__auto___34053,jobs,results,process,async){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (__34054,c__33478__auto___34066,G__33885_34055,n__10440__auto___34053,jobs,results,process,async){
return (function (state_33925){
var state_val_33926 = (state_33925[(1)]);
if((state_val_33926 === (1))){
var state_33925__$1 = state_33925;
var statearr_33927_34067 = state_33925__$1;
(statearr_33927_34067[(2)] = null);

(statearr_33927_34067[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33926 === (2))){
var state_33925__$1 = state_33925;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33925__$1,(4),jobs);
} else {
if((state_val_33926 === (3))){
var inst_33923 = (state_33925[(2)]);
var state_33925__$1 = state_33925;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33925__$1,inst_33923);
} else {
if((state_val_33926 === (4))){
var inst_33915 = (state_33925[(2)]);
var inst_33916 = async.call(null,inst_33915);
var state_33925__$1 = state_33925;
if(cljs.core.truth_(inst_33916)){
var statearr_33928_34068 = state_33925__$1;
(statearr_33928_34068[(1)] = (5));

} else {
var statearr_33929_34069 = state_33925__$1;
(statearr_33929_34069[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33926 === (5))){
var state_33925__$1 = state_33925;
var statearr_33930_34070 = state_33925__$1;
(statearr_33930_34070[(2)] = null);

(statearr_33930_34070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33926 === (6))){
var state_33925__$1 = state_33925;
var statearr_33931_34071 = state_33925__$1;
(statearr_33931_34071[(2)] = null);

(statearr_33931_34071[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33926 === (7))){
var inst_33921 = (state_33925[(2)]);
var state_33925__$1 = state_33925;
var statearr_33932_34072 = state_33925__$1;
(statearr_33932_34072[(2)] = inst_33921);

(statearr_33932_34072[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__34054,c__33478__auto___34066,G__33885_34055,n__10440__auto___34053,jobs,results,process,async))
;
return ((function (__34054,switch__33364__auto__,c__33478__auto___34066,G__33885_34055,n__10440__auto___34053,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0 = (function (){
var statearr_33936 = [null,null,null,null,null,null,null];
(statearr_33936[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__);

(statearr_33936[(1)] = (1));

return statearr_33936;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1 = (function (state_33925){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_33925);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e33937){if((e33937 instanceof Object)){
var ex__33368__auto__ = e33937;
var statearr_33938_34073 = state_33925;
(statearr_33938_34073[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33925);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33937;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34074 = state_33925;
state_33925 = G__34074;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = function(state_33925){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1.call(this,state_33925);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__;
})()
;})(__34054,switch__33364__auto__,c__33478__auto___34066,G__33885_34055,n__10440__auto___34053,jobs,results,process,async))
})();
var state__33480__auto__ = (function (){var statearr_33939 = f__33479__auto__.call(null);
(statearr_33939[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___34066);

return statearr_33939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(__34054,c__33478__auto___34066,G__33885_34055,n__10440__auto___34053,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__34075 = (__34054 + (1));
__34054 = G__34075;
continue;
} else {
}
break;
}

var c__33478__auto___34076 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___34076,jobs,results,process,async){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___34076,jobs,results,process,async){
return (function (state_33961){
var state_val_33962 = (state_33961[(1)]);
if((state_val_33962 === (1))){
var state_33961__$1 = state_33961;
var statearr_33963_34077 = state_33961__$1;
(statearr_33963_34077[(2)] = null);

(statearr_33963_34077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33962 === (2))){
var state_33961__$1 = state_33961;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33961__$1,(4),from);
} else {
if((state_val_33962 === (3))){
var inst_33959 = (state_33961[(2)]);
var state_33961__$1 = state_33961;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33961__$1,inst_33959);
} else {
if((state_val_33962 === (4))){
var inst_33942 = (state_33961[(7)]);
var inst_33942__$1 = (state_33961[(2)]);
var inst_33943 = (inst_33942__$1 == null);
var state_33961__$1 = (function (){var statearr_33964 = state_33961;
(statearr_33964[(7)] = inst_33942__$1);

return statearr_33964;
})();
if(cljs.core.truth_(inst_33943)){
var statearr_33965_34078 = state_33961__$1;
(statearr_33965_34078[(1)] = (5));

} else {
var statearr_33966_34079 = state_33961__$1;
(statearr_33966_34079[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33962 === (5))){
var inst_33945 = cljs.core.async.close_BANG_.call(null,jobs);
var state_33961__$1 = state_33961;
var statearr_33967_34080 = state_33961__$1;
(statearr_33967_34080[(2)] = inst_33945);

(statearr_33967_34080[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33962 === (6))){
var inst_33942 = (state_33961[(7)]);
var inst_33947 = (state_33961[(8)]);
var inst_33947__$1 = cljs.core.async.chan.call(null,(1));
var inst_33948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33949 = [inst_33942,inst_33947__$1];
var inst_33950 = (new cljs.core.PersistentVector(null,2,(5),inst_33948,inst_33949,null));
var state_33961__$1 = (function (){var statearr_33968 = state_33961;
(statearr_33968[(8)] = inst_33947__$1);

return statearr_33968;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33961__$1,(8),jobs,inst_33950);
} else {
if((state_val_33962 === (7))){
var inst_33957 = (state_33961[(2)]);
var state_33961__$1 = state_33961;
var statearr_33969_34081 = state_33961__$1;
(statearr_33969_34081[(2)] = inst_33957);

(statearr_33969_34081[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33962 === (8))){
var inst_33947 = (state_33961[(8)]);
var inst_33952 = (state_33961[(2)]);
var state_33961__$1 = (function (){var statearr_33970 = state_33961;
(statearr_33970[(9)] = inst_33952);

return statearr_33970;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33961__$1,(9),results,inst_33947);
} else {
if((state_val_33962 === (9))){
var inst_33954 = (state_33961[(2)]);
var state_33961__$1 = (function (){var statearr_33971 = state_33961;
(statearr_33971[(10)] = inst_33954);

return statearr_33971;
})();
var statearr_33972_34082 = state_33961__$1;
(statearr_33972_34082[(2)] = null);

(statearr_33972_34082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___34076,jobs,results,process,async))
;
return ((function (switch__33364__auto__,c__33478__auto___34076,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0 = (function (){
var statearr_33976 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33976[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__);

(statearr_33976[(1)] = (1));

return statearr_33976;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1 = (function (state_33961){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_33961);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e33977){if((e33977 instanceof Object)){
var ex__33368__auto__ = e33977;
var statearr_33978_34083 = state_33961;
(statearr_33978_34083[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33961);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33977;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34084 = state_33961;
state_33961 = G__34084;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = function(state_33961){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1.call(this,state_33961);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___34076,jobs,results,process,async))
})();
var state__33480__auto__ = (function (){var statearr_33979 = f__33479__auto__.call(null);
(statearr_33979[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___34076);

return statearr_33979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___34076,jobs,results,process,async))
);


var c__33478__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto__,jobs,results,process,async){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto__,jobs,results,process,async){
return (function (state_34017){
var state_val_34018 = (state_34017[(1)]);
if((state_val_34018 === (7))){
var inst_34013 = (state_34017[(2)]);
var state_34017__$1 = state_34017;
var statearr_34019_34085 = state_34017__$1;
(statearr_34019_34085[(2)] = inst_34013);

(statearr_34019_34085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34018 === (20))){
var state_34017__$1 = state_34017;
var statearr_34020_34086 = state_34017__$1;
(statearr_34020_34086[(2)] = null);

(statearr_34020_34086[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34018 === (1))){
var state_34017__$1 = state_34017;
var statearr_34021_34087 = state_34017__$1;
(statearr_34021_34087[(2)] = null);

(statearr_34021_34087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34018 === (4))){
var inst_33982 = (state_34017[(7)]);
var inst_33982__$1 = (state_34017[(2)]);
var inst_33983 = (inst_33982__$1 == null);
var state_34017__$1 = (function (){var statearr_34022 = state_34017;
(statearr_34022[(7)] = inst_33982__$1);

return statearr_34022;
})();
if(cljs.core.truth_(inst_33983)){
var statearr_34023_34088 = state_34017__$1;
(statearr_34023_34088[(1)] = (5));

} else {
var statearr_34024_34089 = state_34017__$1;
(statearr_34024_34089[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34018 === (15))){
var inst_33995 = (state_34017[(8)]);
var state_34017__$1 = state_34017;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34017__$1,(18),to,inst_33995);
} else {
if((state_val_34018 === (21))){
var inst_34008 = (state_34017[(2)]);
var state_34017__$1 = state_34017;
var statearr_34025_34090 = state_34017__$1;
(statearr_34025_34090[(2)] = inst_34008);

(statearr_34025_34090[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34018 === (13))){
var inst_34010 = (state_34017[(2)]);
var state_34017__$1 = (function (){var statearr_34026 = state_34017;
(statearr_34026[(9)] = inst_34010);

return statearr_34026;
})();
var statearr_34027_34091 = state_34017__$1;
(statearr_34027_34091[(2)] = null);

(statearr_34027_34091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34018 === (6))){
var inst_33982 = (state_34017[(7)]);
var state_34017__$1 = state_34017;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34017__$1,(11),inst_33982);
} else {
if((state_val_34018 === (17))){
var inst_34003 = (state_34017[(2)]);
var state_34017__$1 = state_34017;
if(cljs.core.truth_(inst_34003)){
var statearr_34028_34092 = state_34017__$1;
(statearr_34028_34092[(1)] = (19));

} else {
var statearr_34029_34093 = state_34017__$1;
(statearr_34029_34093[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34018 === (3))){
var inst_34015 = (state_34017[(2)]);
var state_34017__$1 = state_34017;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34017__$1,inst_34015);
} else {
if((state_val_34018 === (12))){
var inst_33992 = (state_34017[(10)]);
var state_34017__$1 = state_34017;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34017__$1,(14),inst_33992);
} else {
if((state_val_34018 === (2))){
var state_34017__$1 = state_34017;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34017__$1,(4),results);
} else {
if((state_val_34018 === (19))){
var state_34017__$1 = state_34017;
var statearr_34030_34094 = state_34017__$1;
(statearr_34030_34094[(2)] = null);

(statearr_34030_34094[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34018 === (11))){
var inst_33992 = (state_34017[(2)]);
var state_34017__$1 = (function (){var statearr_34031 = state_34017;
(statearr_34031[(10)] = inst_33992);

return statearr_34031;
})();
var statearr_34032_34095 = state_34017__$1;
(statearr_34032_34095[(2)] = null);

(statearr_34032_34095[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34018 === (9))){
var state_34017__$1 = state_34017;
var statearr_34033_34096 = state_34017__$1;
(statearr_34033_34096[(2)] = null);

(statearr_34033_34096[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34018 === (5))){
var state_34017__$1 = state_34017;
if(cljs.core.truth_(close_QMARK_)){
var statearr_34034_34097 = state_34017__$1;
(statearr_34034_34097[(1)] = (8));

} else {
var statearr_34035_34098 = state_34017__$1;
(statearr_34035_34098[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34018 === (14))){
var inst_33997 = (state_34017[(11)]);
var inst_33995 = (state_34017[(8)]);
var inst_33995__$1 = (state_34017[(2)]);
var inst_33996 = (inst_33995__$1 == null);
var inst_33997__$1 = cljs.core.not.call(null,inst_33996);
var state_34017__$1 = (function (){var statearr_34036 = state_34017;
(statearr_34036[(11)] = inst_33997__$1);

(statearr_34036[(8)] = inst_33995__$1);

return statearr_34036;
})();
if(inst_33997__$1){
var statearr_34037_34099 = state_34017__$1;
(statearr_34037_34099[(1)] = (15));

} else {
var statearr_34038_34100 = state_34017__$1;
(statearr_34038_34100[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34018 === (16))){
var inst_33997 = (state_34017[(11)]);
var state_34017__$1 = state_34017;
var statearr_34039_34101 = state_34017__$1;
(statearr_34039_34101[(2)] = inst_33997);

(statearr_34039_34101[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34018 === (10))){
var inst_33989 = (state_34017[(2)]);
var state_34017__$1 = state_34017;
var statearr_34040_34102 = state_34017__$1;
(statearr_34040_34102[(2)] = inst_33989);

(statearr_34040_34102[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34018 === (18))){
var inst_34000 = (state_34017[(2)]);
var state_34017__$1 = state_34017;
var statearr_34041_34103 = state_34017__$1;
(statearr_34041_34103[(2)] = inst_34000);

(statearr_34041_34103[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34018 === (8))){
var inst_33986 = cljs.core.async.close_BANG_.call(null,to);
var state_34017__$1 = state_34017;
var statearr_34042_34104 = state_34017__$1;
(statearr_34042_34104[(2)] = inst_33986);

(statearr_34042_34104[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto__,jobs,results,process,async))
;
return ((function (switch__33364__auto__,c__33478__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0 = (function (){
var statearr_34046 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34046[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__);

(statearr_34046[(1)] = (1));

return statearr_34046;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1 = (function (state_34017){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_34017);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e34047){if((e34047 instanceof Object)){
var ex__33368__auto__ = e34047;
var statearr_34048_34105 = state_34017;
(statearr_34048_34105[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34017);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34047;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34106 = state_34017;
state_34017 = G__34106;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = function(state_34017){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1.call(this,state_34017);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto__,jobs,results,process,async))
})();
var state__33480__auto__ = (function (){var statearr_34049 = f__33479__auto__.call(null);
(statearr_34049[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto__);

return statearr_34049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto__,jobs,results,process,async))
);

return c__33478__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args34107 = [];
var len__10640__auto___34110 = arguments.length;
var i__10641__auto___34111 = (0);
while(true){
if((i__10641__auto___34111 < len__10640__auto___34110)){
args34107.push((arguments[i__10641__auto___34111]));

var G__34112 = (i__10641__auto___34111 + (1));
i__10641__auto___34111 = G__34112;
continue;
} else {
}
break;
}

var G__34109 = args34107.length;
switch (G__34109) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args34107.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args34114 = [];
var len__10640__auto___34117 = arguments.length;
var i__10641__auto___34118 = (0);
while(true){
if((i__10641__auto___34118 < len__10640__auto___34117)){
args34114.push((arguments[i__10641__auto___34118]));

var G__34119 = (i__10641__auto___34118 + (1));
i__10641__auto___34118 = G__34119;
continue;
} else {
}
break;
}

var G__34116 = args34114.length;
switch (G__34116) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args34114.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args34121 = [];
var len__10640__auto___34174 = arguments.length;
var i__10641__auto___34175 = (0);
while(true){
if((i__10641__auto___34175 < len__10640__auto___34174)){
args34121.push((arguments[i__10641__auto___34175]));

var G__34176 = (i__10641__auto___34175 + (1));
i__10641__auto___34175 = G__34176;
continue;
} else {
}
break;
}

var G__34123 = args34121.length;
switch (G__34123) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args34121.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__33478__auto___34178 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___34178,tc,fc){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___34178,tc,fc){
return (function (state_34149){
var state_val_34150 = (state_34149[(1)]);
if((state_val_34150 === (7))){
var inst_34145 = (state_34149[(2)]);
var state_34149__$1 = state_34149;
var statearr_34151_34179 = state_34149__$1;
(statearr_34151_34179[(2)] = inst_34145);

(statearr_34151_34179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34150 === (1))){
var state_34149__$1 = state_34149;
var statearr_34152_34180 = state_34149__$1;
(statearr_34152_34180[(2)] = null);

(statearr_34152_34180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34150 === (4))){
var inst_34126 = (state_34149[(7)]);
var inst_34126__$1 = (state_34149[(2)]);
var inst_34127 = (inst_34126__$1 == null);
var state_34149__$1 = (function (){var statearr_34153 = state_34149;
(statearr_34153[(7)] = inst_34126__$1);

return statearr_34153;
})();
if(cljs.core.truth_(inst_34127)){
var statearr_34154_34181 = state_34149__$1;
(statearr_34154_34181[(1)] = (5));

} else {
var statearr_34155_34182 = state_34149__$1;
(statearr_34155_34182[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34150 === (13))){
var state_34149__$1 = state_34149;
var statearr_34156_34183 = state_34149__$1;
(statearr_34156_34183[(2)] = null);

(statearr_34156_34183[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34150 === (6))){
var inst_34126 = (state_34149[(7)]);
var inst_34132 = p.call(null,inst_34126);
var state_34149__$1 = state_34149;
if(cljs.core.truth_(inst_34132)){
var statearr_34157_34184 = state_34149__$1;
(statearr_34157_34184[(1)] = (9));

} else {
var statearr_34158_34185 = state_34149__$1;
(statearr_34158_34185[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34150 === (3))){
var inst_34147 = (state_34149[(2)]);
var state_34149__$1 = state_34149;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34149__$1,inst_34147);
} else {
if((state_val_34150 === (12))){
var state_34149__$1 = state_34149;
var statearr_34159_34186 = state_34149__$1;
(statearr_34159_34186[(2)] = null);

(statearr_34159_34186[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34150 === (2))){
var state_34149__$1 = state_34149;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34149__$1,(4),ch);
} else {
if((state_val_34150 === (11))){
var inst_34126 = (state_34149[(7)]);
var inst_34136 = (state_34149[(2)]);
var state_34149__$1 = state_34149;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34149__$1,(8),inst_34136,inst_34126);
} else {
if((state_val_34150 === (9))){
var state_34149__$1 = state_34149;
var statearr_34160_34187 = state_34149__$1;
(statearr_34160_34187[(2)] = tc);

(statearr_34160_34187[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34150 === (5))){
var inst_34129 = cljs.core.async.close_BANG_.call(null,tc);
var inst_34130 = cljs.core.async.close_BANG_.call(null,fc);
var state_34149__$1 = (function (){var statearr_34161 = state_34149;
(statearr_34161[(8)] = inst_34129);

return statearr_34161;
})();
var statearr_34162_34188 = state_34149__$1;
(statearr_34162_34188[(2)] = inst_34130);

(statearr_34162_34188[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34150 === (14))){
var inst_34143 = (state_34149[(2)]);
var state_34149__$1 = state_34149;
var statearr_34163_34189 = state_34149__$1;
(statearr_34163_34189[(2)] = inst_34143);

(statearr_34163_34189[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34150 === (10))){
var state_34149__$1 = state_34149;
var statearr_34164_34190 = state_34149__$1;
(statearr_34164_34190[(2)] = fc);

(statearr_34164_34190[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34150 === (8))){
var inst_34138 = (state_34149[(2)]);
var state_34149__$1 = state_34149;
if(cljs.core.truth_(inst_34138)){
var statearr_34165_34191 = state_34149__$1;
(statearr_34165_34191[(1)] = (12));

} else {
var statearr_34166_34192 = state_34149__$1;
(statearr_34166_34192[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___34178,tc,fc))
;
return ((function (switch__33364__auto__,c__33478__auto___34178,tc,fc){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_34170 = [null,null,null,null,null,null,null,null,null];
(statearr_34170[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_34170[(1)] = (1));

return statearr_34170;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_34149){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_34149);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e34171){if((e34171 instanceof Object)){
var ex__33368__auto__ = e34171;
var statearr_34172_34193 = state_34149;
(statearr_34172_34193[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34149);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34171;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34194 = state_34149;
state_34149 = G__34194;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_34149){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_34149);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___34178,tc,fc))
})();
var state__33480__auto__ = (function (){var statearr_34173 = f__33479__auto__.call(null);
(statearr_34173[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___34178);

return statearr_34173;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___34178,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__33478__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto__){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto__){
return (function (state_34258){
var state_val_34259 = (state_34258[(1)]);
if((state_val_34259 === (7))){
var inst_34254 = (state_34258[(2)]);
var state_34258__$1 = state_34258;
var statearr_34260_34281 = state_34258__$1;
(statearr_34260_34281[(2)] = inst_34254);

(statearr_34260_34281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34259 === (1))){
var inst_34238 = init;
var state_34258__$1 = (function (){var statearr_34261 = state_34258;
(statearr_34261[(7)] = inst_34238);

return statearr_34261;
})();
var statearr_34262_34282 = state_34258__$1;
(statearr_34262_34282[(2)] = null);

(statearr_34262_34282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34259 === (4))){
var inst_34241 = (state_34258[(8)]);
var inst_34241__$1 = (state_34258[(2)]);
var inst_34242 = (inst_34241__$1 == null);
var state_34258__$1 = (function (){var statearr_34263 = state_34258;
(statearr_34263[(8)] = inst_34241__$1);

return statearr_34263;
})();
if(cljs.core.truth_(inst_34242)){
var statearr_34264_34283 = state_34258__$1;
(statearr_34264_34283[(1)] = (5));

} else {
var statearr_34265_34284 = state_34258__$1;
(statearr_34265_34284[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34259 === (6))){
var inst_34241 = (state_34258[(8)]);
var inst_34238 = (state_34258[(7)]);
var inst_34245 = (state_34258[(9)]);
var inst_34245__$1 = f.call(null,inst_34238,inst_34241);
var inst_34246 = cljs.core.reduced_QMARK_.call(null,inst_34245__$1);
var state_34258__$1 = (function (){var statearr_34266 = state_34258;
(statearr_34266[(9)] = inst_34245__$1);

return statearr_34266;
})();
if(inst_34246){
var statearr_34267_34285 = state_34258__$1;
(statearr_34267_34285[(1)] = (8));

} else {
var statearr_34268_34286 = state_34258__$1;
(statearr_34268_34286[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34259 === (3))){
var inst_34256 = (state_34258[(2)]);
var state_34258__$1 = state_34258;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34258__$1,inst_34256);
} else {
if((state_val_34259 === (2))){
var state_34258__$1 = state_34258;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34258__$1,(4),ch);
} else {
if((state_val_34259 === (9))){
var inst_34245 = (state_34258[(9)]);
var inst_34238 = inst_34245;
var state_34258__$1 = (function (){var statearr_34269 = state_34258;
(statearr_34269[(7)] = inst_34238);

return statearr_34269;
})();
var statearr_34270_34287 = state_34258__$1;
(statearr_34270_34287[(2)] = null);

(statearr_34270_34287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34259 === (5))){
var inst_34238 = (state_34258[(7)]);
var state_34258__$1 = state_34258;
var statearr_34271_34288 = state_34258__$1;
(statearr_34271_34288[(2)] = inst_34238);

(statearr_34271_34288[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34259 === (10))){
var inst_34252 = (state_34258[(2)]);
var state_34258__$1 = state_34258;
var statearr_34272_34289 = state_34258__$1;
(statearr_34272_34289[(2)] = inst_34252);

(statearr_34272_34289[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34259 === (8))){
var inst_34245 = (state_34258[(9)]);
var inst_34248 = cljs.core.deref.call(null,inst_34245);
var state_34258__$1 = state_34258;
var statearr_34273_34290 = state_34258__$1;
(statearr_34273_34290[(2)] = inst_34248);

(statearr_34273_34290[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto__))
;
return ((function (switch__33364__auto__,c__33478__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__33365__auto__ = null;
var cljs$core$async$reduce_$_state_machine__33365__auto____0 = (function (){
var statearr_34277 = [null,null,null,null,null,null,null,null,null,null];
(statearr_34277[(0)] = cljs$core$async$reduce_$_state_machine__33365__auto__);

(statearr_34277[(1)] = (1));

return statearr_34277;
});
var cljs$core$async$reduce_$_state_machine__33365__auto____1 = (function (state_34258){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_34258);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e34278){if((e34278 instanceof Object)){
var ex__33368__auto__ = e34278;
var statearr_34279_34291 = state_34258;
(statearr_34279_34291[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34258);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34278;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34292 = state_34258;
state_34258 = G__34292;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__33365__auto__ = function(state_34258){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__33365__auto____1.call(this,state_34258);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__33365__auto____0;
cljs$core$async$reduce_$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__33365__auto____1;
return cljs$core$async$reduce_$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto__))
})();
var state__33480__auto__ = (function (){var statearr_34280 = f__33479__auto__.call(null);
(statearr_34280[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto__);

return statearr_34280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto__))
);

return c__33478__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__33478__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto__,f__$1){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto__,f__$1){
return (function (state_34312){
var state_val_34313 = (state_34312[(1)]);
if((state_val_34313 === (1))){
var inst_34307 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_34312__$1 = state_34312;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34312__$1,(2),inst_34307);
} else {
if((state_val_34313 === (2))){
var inst_34309 = (state_34312[(2)]);
var inst_34310 = f__$1.call(null,inst_34309);
var state_34312__$1 = state_34312;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34312__$1,inst_34310);
} else {
return null;
}
}
});})(c__33478__auto__,f__$1))
;
return ((function (switch__33364__auto__,c__33478__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__33365__auto__ = null;
var cljs$core$async$transduce_$_state_machine__33365__auto____0 = (function (){
var statearr_34317 = [null,null,null,null,null,null,null];
(statearr_34317[(0)] = cljs$core$async$transduce_$_state_machine__33365__auto__);

(statearr_34317[(1)] = (1));

return statearr_34317;
});
var cljs$core$async$transduce_$_state_machine__33365__auto____1 = (function (state_34312){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_34312);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e34318){if((e34318 instanceof Object)){
var ex__33368__auto__ = e34318;
var statearr_34319_34321 = state_34312;
(statearr_34319_34321[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34312);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34318;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34322 = state_34312;
state_34312 = G__34322;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__33365__auto__ = function(state_34312){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__33365__auto____1.call(this,state_34312);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__33365__auto____0;
cljs$core$async$transduce_$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__33365__auto____1;
return cljs$core$async$transduce_$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto__,f__$1))
})();
var state__33480__auto__ = (function (){var statearr_34320 = f__33479__auto__.call(null);
(statearr_34320[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto__);

return statearr_34320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto__,f__$1))
);

return c__33478__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args34323 = [];
var len__10640__auto___34375 = arguments.length;
var i__10641__auto___34376 = (0);
while(true){
if((i__10641__auto___34376 < len__10640__auto___34375)){
args34323.push((arguments[i__10641__auto___34376]));

var G__34377 = (i__10641__auto___34376 + (1));
i__10641__auto___34376 = G__34377;
continue;
} else {
}
break;
}

var G__34325 = args34323.length;
switch (G__34325) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args34323.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__33478__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto__){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto__){
return (function (state_34350){
var state_val_34351 = (state_34350[(1)]);
if((state_val_34351 === (7))){
var inst_34332 = (state_34350[(2)]);
var state_34350__$1 = state_34350;
var statearr_34352_34379 = state_34350__$1;
(statearr_34352_34379[(2)] = inst_34332);

(statearr_34352_34379[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34351 === (1))){
var inst_34326 = cljs.core.seq.call(null,coll);
var inst_34327 = inst_34326;
var state_34350__$1 = (function (){var statearr_34353 = state_34350;
(statearr_34353[(7)] = inst_34327);

return statearr_34353;
})();
var statearr_34354_34380 = state_34350__$1;
(statearr_34354_34380[(2)] = null);

(statearr_34354_34380[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34351 === (4))){
var inst_34327 = (state_34350[(7)]);
var inst_34330 = cljs.core.first.call(null,inst_34327);
var state_34350__$1 = state_34350;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34350__$1,(7),ch,inst_34330);
} else {
if((state_val_34351 === (13))){
var inst_34344 = (state_34350[(2)]);
var state_34350__$1 = state_34350;
var statearr_34355_34381 = state_34350__$1;
(statearr_34355_34381[(2)] = inst_34344);

(statearr_34355_34381[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34351 === (6))){
var inst_34335 = (state_34350[(2)]);
var state_34350__$1 = state_34350;
if(cljs.core.truth_(inst_34335)){
var statearr_34356_34382 = state_34350__$1;
(statearr_34356_34382[(1)] = (8));

} else {
var statearr_34357_34383 = state_34350__$1;
(statearr_34357_34383[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34351 === (3))){
var inst_34348 = (state_34350[(2)]);
var state_34350__$1 = state_34350;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34350__$1,inst_34348);
} else {
if((state_val_34351 === (12))){
var state_34350__$1 = state_34350;
var statearr_34358_34384 = state_34350__$1;
(statearr_34358_34384[(2)] = null);

(statearr_34358_34384[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34351 === (2))){
var inst_34327 = (state_34350[(7)]);
var state_34350__$1 = state_34350;
if(cljs.core.truth_(inst_34327)){
var statearr_34359_34385 = state_34350__$1;
(statearr_34359_34385[(1)] = (4));

} else {
var statearr_34360_34386 = state_34350__$1;
(statearr_34360_34386[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34351 === (11))){
var inst_34341 = cljs.core.async.close_BANG_.call(null,ch);
var state_34350__$1 = state_34350;
var statearr_34361_34387 = state_34350__$1;
(statearr_34361_34387[(2)] = inst_34341);

(statearr_34361_34387[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34351 === (9))){
var state_34350__$1 = state_34350;
if(cljs.core.truth_(close_QMARK_)){
var statearr_34362_34388 = state_34350__$1;
(statearr_34362_34388[(1)] = (11));

} else {
var statearr_34363_34389 = state_34350__$1;
(statearr_34363_34389[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34351 === (5))){
var inst_34327 = (state_34350[(7)]);
var state_34350__$1 = state_34350;
var statearr_34364_34390 = state_34350__$1;
(statearr_34364_34390[(2)] = inst_34327);

(statearr_34364_34390[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34351 === (10))){
var inst_34346 = (state_34350[(2)]);
var state_34350__$1 = state_34350;
var statearr_34365_34391 = state_34350__$1;
(statearr_34365_34391[(2)] = inst_34346);

(statearr_34365_34391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34351 === (8))){
var inst_34327 = (state_34350[(7)]);
var inst_34337 = cljs.core.next.call(null,inst_34327);
var inst_34327__$1 = inst_34337;
var state_34350__$1 = (function (){var statearr_34366 = state_34350;
(statearr_34366[(7)] = inst_34327__$1);

return statearr_34366;
})();
var statearr_34367_34392 = state_34350__$1;
(statearr_34367_34392[(2)] = null);

(statearr_34367_34392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto__))
;
return ((function (switch__33364__auto__,c__33478__auto__){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_34371 = [null,null,null,null,null,null,null,null];
(statearr_34371[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_34371[(1)] = (1));

return statearr_34371;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_34350){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_34350);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e34372){if((e34372 instanceof Object)){
var ex__33368__auto__ = e34372;
var statearr_34373_34393 = state_34350;
(statearr_34373_34393[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34350);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34372;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34394 = state_34350;
state_34350 = G__34394;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_34350){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_34350);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto__))
})();
var state__33480__auto__ = (function (){var statearr_34374 = f__33479__auto__.call(null);
(statearr_34374[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto__);

return statearr_34374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto__))
);

return c__33478__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__10137__auto__ = (((_ == null))?null:_);
var m__10138__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,_);
} else {
var m__10138__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__10138__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m);
} else {
var m__10138__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async34620 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34620 = (function (ch,cs,meta34621){
this.ch = ch;
this.cs = cs;
this.meta34621 = meta34621;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34620.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_34622,meta34621__$1){
var self__ = this;
var _34622__$1 = this;
return (new cljs.core.async.t_cljs$core$async34620(self__.ch,self__.cs,meta34621__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async34620.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_34622){
var self__ = this;
var _34622__$1 = this;
return self__.meta34621;
});})(cs))
;

cljs.core.async.t_cljs$core$async34620.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34620.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async34620.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34620.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async34620.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async34620.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async34620.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta34621","meta34621",-560904023,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async34620.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34620.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34620";

cljs.core.async.t_cljs$core$async34620.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async34620");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async34620 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async34620(ch__$1,cs__$1,meta34621){
return (new cljs.core.async.t_cljs$core$async34620(ch__$1,cs__$1,meta34621));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async34620(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__33478__auto___34845 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___34845,cs,m,dchan,dctr,done){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___34845,cs,m,dchan,dctr,done){
return (function (state_34757){
var state_val_34758 = (state_34757[(1)]);
if((state_val_34758 === (7))){
var inst_34753 = (state_34757[(2)]);
var state_34757__$1 = state_34757;
var statearr_34759_34846 = state_34757__$1;
(statearr_34759_34846[(2)] = inst_34753);

(statearr_34759_34846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (20))){
var inst_34656 = (state_34757[(7)]);
var inst_34668 = cljs.core.first.call(null,inst_34656);
var inst_34669 = cljs.core.nth.call(null,inst_34668,(0),null);
var inst_34670 = cljs.core.nth.call(null,inst_34668,(1),null);
var state_34757__$1 = (function (){var statearr_34760 = state_34757;
(statearr_34760[(8)] = inst_34669);

return statearr_34760;
})();
if(cljs.core.truth_(inst_34670)){
var statearr_34761_34847 = state_34757__$1;
(statearr_34761_34847[(1)] = (22));

} else {
var statearr_34762_34848 = state_34757__$1;
(statearr_34762_34848[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (27))){
var inst_34698 = (state_34757[(9)]);
var inst_34700 = (state_34757[(10)]);
var inst_34625 = (state_34757[(11)]);
var inst_34705 = (state_34757[(12)]);
var inst_34705__$1 = cljs.core._nth.call(null,inst_34698,inst_34700);
var inst_34706 = cljs.core.async.put_BANG_.call(null,inst_34705__$1,inst_34625,done);
var state_34757__$1 = (function (){var statearr_34763 = state_34757;
(statearr_34763[(12)] = inst_34705__$1);

return statearr_34763;
})();
if(cljs.core.truth_(inst_34706)){
var statearr_34764_34849 = state_34757__$1;
(statearr_34764_34849[(1)] = (30));

} else {
var statearr_34765_34850 = state_34757__$1;
(statearr_34765_34850[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (1))){
var state_34757__$1 = state_34757;
var statearr_34766_34851 = state_34757__$1;
(statearr_34766_34851[(2)] = null);

(statearr_34766_34851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (24))){
var inst_34656 = (state_34757[(7)]);
var inst_34675 = (state_34757[(2)]);
var inst_34676 = cljs.core.next.call(null,inst_34656);
var inst_34634 = inst_34676;
var inst_34635 = null;
var inst_34636 = (0);
var inst_34637 = (0);
var state_34757__$1 = (function (){var statearr_34767 = state_34757;
(statearr_34767[(13)] = inst_34635);

(statearr_34767[(14)] = inst_34636);

(statearr_34767[(15)] = inst_34675);

(statearr_34767[(16)] = inst_34637);

(statearr_34767[(17)] = inst_34634);

return statearr_34767;
})();
var statearr_34768_34852 = state_34757__$1;
(statearr_34768_34852[(2)] = null);

(statearr_34768_34852[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (39))){
var state_34757__$1 = state_34757;
var statearr_34772_34853 = state_34757__$1;
(statearr_34772_34853[(2)] = null);

(statearr_34772_34853[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (4))){
var inst_34625 = (state_34757[(11)]);
var inst_34625__$1 = (state_34757[(2)]);
var inst_34626 = (inst_34625__$1 == null);
var state_34757__$1 = (function (){var statearr_34773 = state_34757;
(statearr_34773[(11)] = inst_34625__$1);

return statearr_34773;
})();
if(cljs.core.truth_(inst_34626)){
var statearr_34774_34854 = state_34757__$1;
(statearr_34774_34854[(1)] = (5));

} else {
var statearr_34775_34855 = state_34757__$1;
(statearr_34775_34855[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (15))){
var inst_34635 = (state_34757[(13)]);
var inst_34636 = (state_34757[(14)]);
var inst_34637 = (state_34757[(16)]);
var inst_34634 = (state_34757[(17)]);
var inst_34652 = (state_34757[(2)]);
var inst_34653 = (inst_34637 + (1));
var tmp34769 = inst_34635;
var tmp34770 = inst_34636;
var tmp34771 = inst_34634;
var inst_34634__$1 = tmp34771;
var inst_34635__$1 = tmp34769;
var inst_34636__$1 = tmp34770;
var inst_34637__$1 = inst_34653;
var state_34757__$1 = (function (){var statearr_34776 = state_34757;
(statearr_34776[(13)] = inst_34635__$1);

(statearr_34776[(14)] = inst_34636__$1);

(statearr_34776[(18)] = inst_34652);

(statearr_34776[(16)] = inst_34637__$1);

(statearr_34776[(17)] = inst_34634__$1);

return statearr_34776;
})();
var statearr_34777_34856 = state_34757__$1;
(statearr_34777_34856[(2)] = null);

(statearr_34777_34856[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (21))){
var inst_34679 = (state_34757[(2)]);
var state_34757__$1 = state_34757;
var statearr_34781_34857 = state_34757__$1;
(statearr_34781_34857[(2)] = inst_34679);

(statearr_34781_34857[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (31))){
var inst_34705 = (state_34757[(12)]);
var inst_34709 = done.call(null,null);
var inst_34710 = cljs.core.async.untap_STAR_.call(null,m,inst_34705);
var state_34757__$1 = (function (){var statearr_34782 = state_34757;
(statearr_34782[(19)] = inst_34709);

return statearr_34782;
})();
var statearr_34783_34858 = state_34757__$1;
(statearr_34783_34858[(2)] = inst_34710);

(statearr_34783_34858[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (32))){
var inst_34698 = (state_34757[(9)]);
var inst_34700 = (state_34757[(10)]);
var inst_34699 = (state_34757[(20)]);
var inst_34697 = (state_34757[(21)]);
var inst_34712 = (state_34757[(2)]);
var inst_34713 = (inst_34700 + (1));
var tmp34778 = inst_34698;
var tmp34779 = inst_34699;
var tmp34780 = inst_34697;
var inst_34697__$1 = tmp34780;
var inst_34698__$1 = tmp34778;
var inst_34699__$1 = tmp34779;
var inst_34700__$1 = inst_34713;
var state_34757__$1 = (function (){var statearr_34784 = state_34757;
(statearr_34784[(9)] = inst_34698__$1);

(statearr_34784[(10)] = inst_34700__$1);

(statearr_34784[(22)] = inst_34712);

(statearr_34784[(20)] = inst_34699__$1);

(statearr_34784[(21)] = inst_34697__$1);

return statearr_34784;
})();
var statearr_34785_34859 = state_34757__$1;
(statearr_34785_34859[(2)] = null);

(statearr_34785_34859[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (40))){
var inst_34725 = (state_34757[(23)]);
var inst_34729 = done.call(null,null);
var inst_34730 = cljs.core.async.untap_STAR_.call(null,m,inst_34725);
var state_34757__$1 = (function (){var statearr_34786 = state_34757;
(statearr_34786[(24)] = inst_34729);

return statearr_34786;
})();
var statearr_34787_34860 = state_34757__$1;
(statearr_34787_34860[(2)] = inst_34730);

(statearr_34787_34860[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (33))){
var inst_34716 = (state_34757[(25)]);
var inst_34718 = cljs.core.chunked_seq_QMARK_.call(null,inst_34716);
var state_34757__$1 = state_34757;
if(inst_34718){
var statearr_34788_34861 = state_34757__$1;
(statearr_34788_34861[(1)] = (36));

} else {
var statearr_34789_34862 = state_34757__$1;
(statearr_34789_34862[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (13))){
var inst_34646 = (state_34757[(26)]);
var inst_34649 = cljs.core.async.close_BANG_.call(null,inst_34646);
var state_34757__$1 = state_34757;
var statearr_34790_34863 = state_34757__$1;
(statearr_34790_34863[(2)] = inst_34649);

(statearr_34790_34863[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (22))){
var inst_34669 = (state_34757[(8)]);
var inst_34672 = cljs.core.async.close_BANG_.call(null,inst_34669);
var state_34757__$1 = state_34757;
var statearr_34791_34864 = state_34757__$1;
(statearr_34791_34864[(2)] = inst_34672);

(statearr_34791_34864[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (36))){
var inst_34716 = (state_34757[(25)]);
var inst_34720 = cljs.core.chunk_first.call(null,inst_34716);
var inst_34721 = cljs.core.chunk_rest.call(null,inst_34716);
var inst_34722 = cljs.core.count.call(null,inst_34720);
var inst_34697 = inst_34721;
var inst_34698 = inst_34720;
var inst_34699 = inst_34722;
var inst_34700 = (0);
var state_34757__$1 = (function (){var statearr_34792 = state_34757;
(statearr_34792[(9)] = inst_34698);

(statearr_34792[(10)] = inst_34700);

(statearr_34792[(20)] = inst_34699);

(statearr_34792[(21)] = inst_34697);

return statearr_34792;
})();
var statearr_34793_34865 = state_34757__$1;
(statearr_34793_34865[(2)] = null);

(statearr_34793_34865[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (41))){
var inst_34716 = (state_34757[(25)]);
var inst_34732 = (state_34757[(2)]);
var inst_34733 = cljs.core.next.call(null,inst_34716);
var inst_34697 = inst_34733;
var inst_34698 = null;
var inst_34699 = (0);
var inst_34700 = (0);
var state_34757__$1 = (function (){var statearr_34794 = state_34757;
(statearr_34794[(9)] = inst_34698);

(statearr_34794[(10)] = inst_34700);

(statearr_34794[(20)] = inst_34699);

(statearr_34794[(21)] = inst_34697);

(statearr_34794[(27)] = inst_34732);

return statearr_34794;
})();
var statearr_34795_34866 = state_34757__$1;
(statearr_34795_34866[(2)] = null);

(statearr_34795_34866[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (43))){
var state_34757__$1 = state_34757;
var statearr_34796_34867 = state_34757__$1;
(statearr_34796_34867[(2)] = null);

(statearr_34796_34867[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (29))){
var inst_34741 = (state_34757[(2)]);
var state_34757__$1 = state_34757;
var statearr_34797_34868 = state_34757__$1;
(statearr_34797_34868[(2)] = inst_34741);

(statearr_34797_34868[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (44))){
var inst_34750 = (state_34757[(2)]);
var state_34757__$1 = (function (){var statearr_34798 = state_34757;
(statearr_34798[(28)] = inst_34750);

return statearr_34798;
})();
var statearr_34799_34869 = state_34757__$1;
(statearr_34799_34869[(2)] = null);

(statearr_34799_34869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (6))){
var inst_34689 = (state_34757[(29)]);
var inst_34688 = cljs.core.deref.call(null,cs);
var inst_34689__$1 = cljs.core.keys.call(null,inst_34688);
var inst_34690 = cljs.core.count.call(null,inst_34689__$1);
var inst_34691 = cljs.core.reset_BANG_.call(null,dctr,inst_34690);
var inst_34696 = cljs.core.seq.call(null,inst_34689__$1);
var inst_34697 = inst_34696;
var inst_34698 = null;
var inst_34699 = (0);
var inst_34700 = (0);
var state_34757__$1 = (function (){var statearr_34800 = state_34757;
(statearr_34800[(9)] = inst_34698);

(statearr_34800[(10)] = inst_34700);

(statearr_34800[(29)] = inst_34689__$1);

(statearr_34800[(20)] = inst_34699);

(statearr_34800[(21)] = inst_34697);

(statearr_34800[(30)] = inst_34691);

return statearr_34800;
})();
var statearr_34801_34870 = state_34757__$1;
(statearr_34801_34870[(2)] = null);

(statearr_34801_34870[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (28))){
var inst_34716 = (state_34757[(25)]);
var inst_34697 = (state_34757[(21)]);
var inst_34716__$1 = cljs.core.seq.call(null,inst_34697);
var state_34757__$1 = (function (){var statearr_34802 = state_34757;
(statearr_34802[(25)] = inst_34716__$1);

return statearr_34802;
})();
if(inst_34716__$1){
var statearr_34803_34871 = state_34757__$1;
(statearr_34803_34871[(1)] = (33));

} else {
var statearr_34804_34872 = state_34757__$1;
(statearr_34804_34872[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (25))){
var inst_34700 = (state_34757[(10)]);
var inst_34699 = (state_34757[(20)]);
var inst_34702 = (inst_34700 < inst_34699);
var inst_34703 = inst_34702;
var state_34757__$1 = state_34757;
if(cljs.core.truth_(inst_34703)){
var statearr_34805_34873 = state_34757__$1;
(statearr_34805_34873[(1)] = (27));

} else {
var statearr_34806_34874 = state_34757__$1;
(statearr_34806_34874[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (34))){
var state_34757__$1 = state_34757;
var statearr_34807_34875 = state_34757__$1;
(statearr_34807_34875[(2)] = null);

(statearr_34807_34875[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (17))){
var state_34757__$1 = state_34757;
var statearr_34808_34876 = state_34757__$1;
(statearr_34808_34876[(2)] = null);

(statearr_34808_34876[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (3))){
var inst_34755 = (state_34757[(2)]);
var state_34757__$1 = state_34757;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34757__$1,inst_34755);
} else {
if((state_val_34758 === (12))){
var inst_34684 = (state_34757[(2)]);
var state_34757__$1 = state_34757;
var statearr_34809_34877 = state_34757__$1;
(statearr_34809_34877[(2)] = inst_34684);

(statearr_34809_34877[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (2))){
var state_34757__$1 = state_34757;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34757__$1,(4),ch);
} else {
if((state_val_34758 === (23))){
var state_34757__$1 = state_34757;
var statearr_34810_34878 = state_34757__$1;
(statearr_34810_34878[(2)] = null);

(statearr_34810_34878[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (35))){
var inst_34739 = (state_34757[(2)]);
var state_34757__$1 = state_34757;
var statearr_34811_34879 = state_34757__$1;
(statearr_34811_34879[(2)] = inst_34739);

(statearr_34811_34879[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (19))){
var inst_34656 = (state_34757[(7)]);
var inst_34660 = cljs.core.chunk_first.call(null,inst_34656);
var inst_34661 = cljs.core.chunk_rest.call(null,inst_34656);
var inst_34662 = cljs.core.count.call(null,inst_34660);
var inst_34634 = inst_34661;
var inst_34635 = inst_34660;
var inst_34636 = inst_34662;
var inst_34637 = (0);
var state_34757__$1 = (function (){var statearr_34812 = state_34757;
(statearr_34812[(13)] = inst_34635);

(statearr_34812[(14)] = inst_34636);

(statearr_34812[(16)] = inst_34637);

(statearr_34812[(17)] = inst_34634);

return statearr_34812;
})();
var statearr_34813_34880 = state_34757__$1;
(statearr_34813_34880[(2)] = null);

(statearr_34813_34880[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (11))){
var inst_34656 = (state_34757[(7)]);
var inst_34634 = (state_34757[(17)]);
var inst_34656__$1 = cljs.core.seq.call(null,inst_34634);
var state_34757__$1 = (function (){var statearr_34814 = state_34757;
(statearr_34814[(7)] = inst_34656__$1);

return statearr_34814;
})();
if(inst_34656__$1){
var statearr_34815_34881 = state_34757__$1;
(statearr_34815_34881[(1)] = (16));

} else {
var statearr_34816_34882 = state_34757__$1;
(statearr_34816_34882[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (9))){
var inst_34686 = (state_34757[(2)]);
var state_34757__$1 = state_34757;
var statearr_34817_34883 = state_34757__$1;
(statearr_34817_34883[(2)] = inst_34686);

(statearr_34817_34883[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (5))){
var inst_34632 = cljs.core.deref.call(null,cs);
var inst_34633 = cljs.core.seq.call(null,inst_34632);
var inst_34634 = inst_34633;
var inst_34635 = null;
var inst_34636 = (0);
var inst_34637 = (0);
var state_34757__$1 = (function (){var statearr_34818 = state_34757;
(statearr_34818[(13)] = inst_34635);

(statearr_34818[(14)] = inst_34636);

(statearr_34818[(16)] = inst_34637);

(statearr_34818[(17)] = inst_34634);

return statearr_34818;
})();
var statearr_34819_34884 = state_34757__$1;
(statearr_34819_34884[(2)] = null);

(statearr_34819_34884[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (14))){
var state_34757__$1 = state_34757;
var statearr_34820_34885 = state_34757__$1;
(statearr_34820_34885[(2)] = null);

(statearr_34820_34885[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (45))){
var inst_34747 = (state_34757[(2)]);
var state_34757__$1 = state_34757;
var statearr_34821_34886 = state_34757__$1;
(statearr_34821_34886[(2)] = inst_34747);

(statearr_34821_34886[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (26))){
var inst_34689 = (state_34757[(29)]);
var inst_34743 = (state_34757[(2)]);
var inst_34744 = cljs.core.seq.call(null,inst_34689);
var state_34757__$1 = (function (){var statearr_34822 = state_34757;
(statearr_34822[(31)] = inst_34743);

return statearr_34822;
})();
if(inst_34744){
var statearr_34823_34887 = state_34757__$1;
(statearr_34823_34887[(1)] = (42));

} else {
var statearr_34824_34888 = state_34757__$1;
(statearr_34824_34888[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (16))){
var inst_34656 = (state_34757[(7)]);
var inst_34658 = cljs.core.chunked_seq_QMARK_.call(null,inst_34656);
var state_34757__$1 = state_34757;
if(inst_34658){
var statearr_34825_34889 = state_34757__$1;
(statearr_34825_34889[(1)] = (19));

} else {
var statearr_34826_34890 = state_34757__$1;
(statearr_34826_34890[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (38))){
var inst_34736 = (state_34757[(2)]);
var state_34757__$1 = state_34757;
var statearr_34827_34891 = state_34757__$1;
(statearr_34827_34891[(2)] = inst_34736);

(statearr_34827_34891[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (30))){
var state_34757__$1 = state_34757;
var statearr_34828_34892 = state_34757__$1;
(statearr_34828_34892[(2)] = null);

(statearr_34828_34892[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (10))){
var inst_34635 = (state_34757[(13)]);
var inst_34637 = (state_34757[(16)]);
var inst_34645 = cljs.core._nth.call(null,inst_34635,inst_34637);
var inst_34646 = cljs.core.nth.call(null,inst_34645,(0),null);
var inst_34647 = cljs.core.nth.call(null,inst_34645,(1),null);
var state_34757__$1 = (function (){var statearr_34829 = state_34757;
(statearr_34829[(26)] = inst_34646);

return statearr_34829;
})();
if(cljs.core.truth_(inst_34647)){
var statearr_34830_34893 = state_34757__$1;
(statearr_34830_34893[(1)] = (13));

} else {
var statearr_34831_34894 = state_34757__$1;
(statearr_34831_34894[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (18))){
var inst_34682 = (state_34757[(2)]);
var state_34757__$1 = state_34757;
var statearr_34832_34895 = state_34757__$1;
(statearr_34832_34895[(2)] = inst_34682);

(statearr_34832_34895[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (42))){
var state_34757__$1 = state_34757;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34757__$1,(45),dchan);
} else {
if((state_val_34758 === (37))){
var inst_34725 = (state_34757[(23)]);
var inst_34625 = (state_34757[(11)]);
var inst_34716 = (state_34757[(25)]);
var inst_34725__$1 = cljs.core.first.call(null,inst_34716);
var inst_34726 = cljs.core.async.put_BANG_.call(null,inst_34725__$1,inst_34625,done);
var state_34757__$1 = (function (){var statearr_34833 = state_34757;
(statearr_34833[(23)] = inst_34725__$1);

return statearr_34833;
})();
if(cljs.core.truth_(inst_34726)){
var statearr_34834_34896 = state_34757__$1;
(statearr_34834_34896[(1)] = (39));

} else {
var statearr_34835_34897 = state_34757__$1;
(statearr_34835_34897[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34758 === (8))){
var inst_34636 = (state_34757[(14)]);
var inst_34637 = (state_34757[(16)]);
var inst_34639 = (inst_34637 < inst_34636);
var inst_34640 = inst_34639;
var state_34757__$1 = state_34757;
if(cljs.core.truth_(inst_34640)){
var statearr_34836_34898 = state_34757__$1;
(statearr_34836_34898[(1)] = (10));

} else {
var statearr_34837_34899 = state_34757__$1;
(statearr_34837_34899[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___34845,cs,m,dchan,dctr,done))
;
return ((function (switch__33364__auto__,c__33478__auto___34845,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__33365__auto__ = null;
var cljs$core$async$mult_$_state_machine__33365__auto____0 = (function (){
var statearr_34841 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34841[(0)] = cljs$core$async$mult_$_state_machine__33365__auto__);

(statearr_34841[(1)] = (1));

return statearr_34841;
});
var cljs$core$async$mult_$_state_machine__33365__auto____1 = (function (state_34757){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_34757);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e34842){if((e34842 instanceof Object)){
var ex__33368__auto__ = e34842;
var statearr_34843_34900 = state_34757;
(statearr_34843_34900[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34757);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34842;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34901 = state_34757;
state_34757 = G__34901;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__33365__auto__ = function(state_34757){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__33365__auto____1.call(this,state_34757);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__33365__auto____0;
cljs$core$async$mult_$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__33365__auto____1;
return cljs$core$async$mult_$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___34845,cs,m,dchan,dctr,done))
})();
var state__33480__auto__ = (function (){var statearr_34844 = f__33479__auto__.call(null);
(statearr_34844[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___34845);

return statearr_34844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___34845,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args34902 = [];
var len__10640__auto___34905 = arguments.length;
var i__10641__auto___34906 = (0);
while(true){
if((i__10641__auto___34906 < len__10640__auto___34905)){
args34902.push((arguments[i__10641__auto___34906]));

var G__34907 = (i__10641__auto___34906 + (1));
i__10641__auto___34906 = G__34907;
continue;
} else {
}
break;
}

var G__34904 = args34902.length;
switch (G__34904) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args34902.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m);
} else {
var m__10138__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,state_map);
} else {
var m__10138__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,mode);
} else {
var m__10138__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___34919 = arguments.length;
var i__10641__auto___34920 = (0);
while(true){
if((i__10641__auto___34920 < len__10640__auto___34919)){
args__10647__auto__.push((arguments[i__10641__auto___34920]));

var G__34921 = (i__10641__auto___34920 + (1));
i__10641__auto___34920 = G__34921;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((3) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10648__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__34913){
var map__34914 = p__34913;
var map__34914__$1 = ((((!((map__34914 == null)))?((((map__34914.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34914.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34914):map__34914);
var opts = map__34914__$1;
var statearr_34916_34922 = state;
(statearr_34916_34922[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6738__auto__ = cljs.core.async.do_alts.call(null,((function (map__34914,map__34914__$1,opts){
return (function (val){
var statearr_34917_34923 = state;
(statearr_34917_34923[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__34914,map__34914__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6738__auto__)){
var cb = temp__6738__auto__;
var statearr_34918_34924 = state;
(statearr_34918_34924[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq34909){
var G__34910 = cljs.core.first.call(null,seq34909);
var seq34909__$1 = cljs.core.next.call(null,seq34909);
var G__34911 = cljs.core.first.call(null,seq34909__$1);
var seq34909__$2 = cljs.core.next.call(null,seq34909__$1);
var G__34912 = cljs.core.first.call(null,seq34909__$2);
var seq34909__$3 = cljs.core.next.call(null,seq34909__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__34910,G__34911,G__34912,seq34909__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async35092 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35092 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta35093){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta35093 = meta35093;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async35092.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_35094,meta35093__$1){
var self__ = this;
var _35094__$1 = this;
return (new cljs.core.async.t_cljs$core$async35092(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta35093__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async35092.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_35094){
var self__ = this;
var _35094__$1 = this;
return self__.meta35093;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async35092.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35092.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async35092.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35092.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async35092.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async35092.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async35092.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async35092.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async35092.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta35093","meta35093",-724599107,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async35092.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35092.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35092";

cljs.core.async.t_cljs$core$async35092.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async35092");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async35092 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async35092(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta35093){
return (new cljs.core.async.t_cljs$core$async35092(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta35093));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async35092(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__33478__auto___35259 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___35259,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___35259,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_35196){
var state_val_35197 = (state_35196[(1)]);
if((state_val_35197 === (7))){
var inst_35111 = (state_35196[(2)]);
var state_35196__$1 = state_35196;
var statearr_35198_35260 = state_35196__$1;
(statearr_35198_35260[(2)] = inst_35111);

(statearr_35198_35260[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (20))){
var inst_35123 = (state_35196[(7)]);
var state_35196__$1 = state_35196;
var statearr_35199_35261 = state_35196__$1;
(statearr_35199_35261[(2)] = inst_35123);

(statearr_35199_35261[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (27))){
var state_35196__$1 = state_35196;
var statearr_35200_35262 = state_35196__$1;
(statearr_35200_35262[(2)] = null);

(statearr_35200_35262[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (1))){
var inst_35098 = (state_35196[(8)]);
var inst_35098__$1 = calc_state.call(null);
var inst_35100 = (inst_35098__$1 == null);
var inst_35101 = cljs.core.not.call(null,inst_35100);
var state_35196__$1 = (function (){var statearr_35201 = state_35196;
(statearr_35201[(8)] = inst_35098__$1);

return statearr_35201;
})();
if(inst_35101){
var statearr_35202_35263 = state_35196__$1;
(statearr_35202_35263[(1)] = (2));

} else {
var statearr_35203_35264 = state_35196__$1;
(statearr_35203_35264[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (24))){
var inst_35170 = (state_35196[(9)]);
var inst_35156 = (state_35196[(10)]);
var inst_35147 = (state_35196[(11)]);
var inst_35170__$1 = inst_35147.call(null,inst_35156);
var state_35196__$1 = (function (){var statearr_35204 = state_35196;
(statearr_35204[(9)] = inst_35170__$1);

return statearr_35204;
})();
if(cljs.core.truth_(inst_35170__$1)){
var statearr_35205_35265 = state_35196__$1;
(statearr_35205_35265[(1)] = (29));

} else {
var statearr_35206_35266 = state_35196__$1;
(statearr_35206_35266[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (4))){
var inst_35114 = (state_35196[(2)]);
var state_35196__$1 = state_35196;
if(cljs.core.truth_(inst_35114)){
var statearr_35207_35267 = state_35196__$1;
(statearr_35207_35267[(1)] = (8));

} else {
var statearr_35208_35268 = state_35196__$1;
(statearr_35208_35268[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (15))){
var inst_35141 = (state_35196[(2)]);
var state_35196__$1 = state_35196;
if(cljs.core.truth_(inst_35141)){
var statearr_35209_35269 = state_35196__$1;
(statearr_35209_35269[(1)] = (19));

} else {
var statearr_35210_35270 = state_35196__$1;
(statearr_35210_35270[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (21))){
var inst_35146 = (state_35196[(12)]);
var inst_35146__$1 = (state_35196[(2)]);
var inst_35147 = cljs.core.get.call(null,inst_35146__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_35148 = cljs.core.get.call(null,inst_35146__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_35149 = cljs.core.get.call(null,inst_35146__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_35196__$1 = (function (){var statearr_35211 = state_35196;
(statearr_35211[(13)] = inst_35148);

(statearr_35211[(12)] = inst_35146__$1);

(statearr_35211[(11)] = inst_35147);

return statearr_35211;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_35196__$1,(22),inst_35149);
} else {
if((state_val_35197 === (31))){
var inst_35178 = (state_35196[(2)]);
var state_35196__$1 = state_35196;
if(cljs.core.truth_(inst_35178)){
var statearr_35212_35271 = state_35196__$1;
(statearr_35212_35271[(1)] = (32));

} else {
var statearr_35213_35272 = state_35196__$1;
(statearr_35213_35272[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (32))){
var inst_35155 = (state_35196[(14)]);
var state_35196__$1 = state_35196;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35196__$1,(35),out,inst_35155);
} else {
if((state_val_35197 === (33))){
var inst_35146 = (state_35196[(12)]);
var inst_35123 = inst_35146;
var state_35196__$1 = (function (){var statearr_35214 = state_35196;
(statearr_35214[(7)] = inst_35123);

return statearr_35214;
})();
var statearr_35215_35273 = state_35196__$1;
(statearr_35215_35273[(2)] = null);

(statearr_35215_35273[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (13))){
var inst_35123 = (state_35196[(7)]);
var inst_35130 = inst_35123.cljs$lang$protocol_mask$partition0$;
var inst_35131 = (inst_35130 & (64));
var inst_35132 = inst_35123.cljs$core$ISeq$;
var inst_35133 = (cljs.core.PROTOCOL_SENTINEL === inst_35132);
var inst_35134 = (inst_35131) || (inst_35133);
var state_35196__$1 = state_35196;
if(cljs.core.truth_(inst_35134)){
var statearr_35216_35274 = state_35196__$1;
(statearr_35216_35274[(1)] = (16));

} else {
var statearr_35217_35275 = state_35196__$1;
(statearr_35217_35275[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (22))){
var inst_35155 = (state_35196[(14)]);
var inst_35156 = (state_35196[(10)]);
var inst_35154 = (state_35196[(2)]);
var inst_35155__$1 = cljs.core.nth.call(null,inst_35154,(0),null);
var inst_35156__$1 = cljs.core.nth.call(null,inst_35154,(1),null);
var inst_35157 = (inst_35155__$1 == null);
var inst_35158 = cljs.core._EQ_.call(null,inst_35156__$1,change);
var inst_35159 = (inst_35157) || (inst_35158);
var state_35196__$1 = (function (){var statearr_35218 = state_35196;
(statearr_35218[(14)] = inst_35155__$1);

(statearr_35218[(10)] = inst_35156__$1);

return statearr_35218;
})();
if(cljs.core.truth_(inst_35159)){
var statearr_35219_35276 = state_35196__$1;
(statearr_35219_35276[(1)] = (23));

} else {
var statearr_35220_35277 = state_35196__$1;
(statearr_35220_35277[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (36))){
var inst_35146 = (state_35196[(12)]);
var inst_35123 = inst_35146;
var state_35196__$1 = (function (){var statearr_35221 = state_35196;
(statearr_35221[(7)] = inst_35123);

return statearr_35221;
})();
var statearr_35222_35278 = state_35196__$1;
(statearr_35222_35278[(2)] = null);

(statearr_35222_35278[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (29))){
var inst_35170 = (state_35196[(9)]);
var state_35196__$1 = state_35196;
var statearr_35223_35279 = state_35196__$1;
(statearr_35223_35279[(2)] = inst_35170);

(statearr_35223_35279[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (6))){
var state_35196__$1 = state_35196;
var statearr_35224_35280 = state_35196__$1;
(statearr_35224_35280[(2)] = false);

(statearr_35224_35280[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (28))){
var inst_35166 = (state_35196[(2)]);
var inst_35167 = calc_state.call(null);
var inst_35123 = inst_35167;
var state_35196__$1 = (function (){var statearr_35225 = state_35196;
(statearr_35225[(7)] = inst_35123);

(statearr_35225[(15)] = inst_35166);

return statearr_35225;
})();
var statearr_35226_35281 = state_35196__$1;
(statearr_35226_35281[(2)] = null);

(statearr_35226_35281[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (25))){
var inst_35192 = (state_35196[(2)]);
var state_35196__$1 = state_35196;
var statearr_35227_35282 = state_35196__$1;
(statearr_35227_35282[(2)] = inst_35192);

(statearr_35227_35282[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (34))){
var inst_35190 = (state_35196[(2)]);
var state_35196__$1 = state_35196;
var statearr_35228_35283 = state_35196__$1;
(statearr_35228_35283[(2)] = inst_35190);

(statearr_35228_35283[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (17))){
var state_35196__$1 = state_35196;
var statearr_35229_35284 = state_35196__$1;
(statearr_35229_35284[(2)] = false);

(statearr_35229_35284[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (3))){
var state_35196__$1 = state_35196;
var statearr_35230_35285 = state_35196__$1;
(statearr_35230_35285[(2)] = false);

(statearr_35230_35285[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (12))){
var inst_35194 = (state_35196[(2)]);
var state_35196__$1 = state_35196;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35196__$1,inst_35194);
} else {
if((state_val_35197 === (2))){
var inst_35098 = (state_35196[(8)]);
var inst_35103 = inst_35098.cljs$lang$protocol_mask$partition0$;
var inst_35104 = (inst_35103 & (64));
var inst_35105 = inst_35098.cljs$core$ISeq$;
var inst_35106 = (cljs.core.PROTOCOL_SENTINEL === inst_35105);
var inst_35107 = (inst_35104) || (inst_35106);
var state_35196__$1 = state_35196;
if(cljs.core.truth_(inst_35107)){
var statearr_35231_35286 = state_35196__$1;
(statearr_35231_35286[(1)] = (5));

} else {
var statearr_35232_35287 = state_35196__$1;
(statearr_35232_35287[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (23))){
var inst_35155 = (state_35196[(14)]);
var inst_35161 = (inst_35155 == null);
var state_35196__$1 = state_35196;
if(cljs.core.truth_(inst_35161)){
var statearr_35233_35288 = state_35196__$1;
(statearr_35233_35288[(1)] = (26));

} else {
var statearr_35234_35289 = state_35196__$1;
(statearr_35234_35289[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (35))){
var inst_35181 = (state_35196[(2)]);
var state_35196__$1 = state_35196;
if(cljs.core.truth_(inst_35181)){
var statearr_35235_35290 = state_35196__$1;
(statearr_35235_35290[(1)] = (36));

} else {
var statearr_35236_35291 = state_35196__$1;
(statearr_35236_35291[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (19))){
var inst_35123 = (state_35196[(7)]);
var inst_35143 = cljs.core.apply.call(null,cljs.core.hash_map,inst_35123);
var state_35196__$1 = state_35196;
var statearr_35237_35292 = state_35196__$1;
(statearr_35237_35292[(2)] = inst_35143);

(statearr_35237_35292[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (11))){
var inst_35123 = (state_35196[(7)]);
var inst_35127 = (inst_35123 == null);
var inst_35128 = cljs.core.not.call(null,inst_35127);
var state_35196__$1 = state_35196;
if(inst_35128){
var statearr_35238_35293 = state_35196__$1;
(statearr_35238_35293[(1)] = (13));

} else {
var statearr_35239_35294 = state_35196__$1;
(statearr_35239_35294[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (9))){
var inst_35098 = (state_35196[(8)]);
var state_35196__$1 = state_35196;
var statearr_35240_35295 = state_35196__$1;
(statearr_35240_35295[(2)] = inst_35098);

(statearr_35240_35295[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (5))){
var state_35196__$1 = state_35196;
var statearr_35241_35296 = state_35196__$1;
(statearr_35241_35296[(2)] = true);

(statearr_35241_35296[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (14))){
var state_35196__$1 = state_35196;
var statearr_35242_35297 = state_35196__$1;
(statearr_35242_35297[(2)] = false);

(statearr_35242_35297[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (26))){
var inst_35156 = (state_35196[(10)]);
var inst_35163 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_35156);
var state_35196__$1 = state_35196;
var statearr_35243_35298 = state_35196__$1;
(statearr_35243_35298[(2)] = inst_35163);

(statearr_35243_35298[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (16))){
var state_35196__$1 = state_35196;
var statearr_35244_35299 = state_35196__$1;
(statearr_35244_35299[(2)] = true);

(statearr_35244_35299[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (38))){
var inst_35186 = (state_35196[(2)]);
var state_35196__$1 = state_35196;
var statearr_35245_35300 = state_35196__$1;
(statearr_35245_35300[(2)] = inst_35186);

(statearr_35245_35300[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (30))){
var inst_35148 = (state_35196[(13)]);
var inst_35156 = (state_35196[(10)]);
var inst_35147 = (state_35196[(11)]);
var inst_35173 = cljs.core.empty_QMARK_.call(null,inst_35147);
var inst_35174 = inst_35148.call(null,inst_35156);
var inst_35175 = cljs.core.not.call(null,inst_35174);
var inst_35176 = (inst_35173) && (inst_35175);
var state_35196__$1 = state_35196;
var statearr_35246_35301 = state_35196__$1;
(statearr_35246_35301[(2)] = inst_35176);

(statearr_35246_35301[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (10))){
var inst_35098 = (state_35196[(8)]);
var inst_35119 = (state_35196[(2)]);
var inst_35120 = cljs.core.get.call(null,inst_35119,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_35121 = cljs.core.get.call(null,inst_35119,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_35122 = cljs.core.get.call(null,inst_35119,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_35123 = inst_35098;
var state_35196__$1 = (function (){var statearr_35247 = state_35196;
(statearr_35247[(16)] = inst_35122);

(statearr_35247[(7)] = inst_35123);

(statearr_35247[(17)] = inst_35120);

(statearr_35247[(18)] = inst_35121);

return statearr_35247;
})();
var statearr_35248_35302 = state_35196__$1;
(statearr_35248_35302[(2)] = null);

(statearr_35248_35302[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (18))){
var inst_35138 = (state_35196[(2)]);
var state_35196__$1 = state_35196;
var statearr_35249_35303 = state_35196__$1;
(statearr_35249_35303[(2)] = inst_35138);

(statearr_35249_35303[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (37))){
var state_35196__$1 = state_35196;
var statearr_35250_35304 = state_35196__$1;
(statearr_35250_35304[(2)] = null);

(statearr_35250_35304[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35197 === (8))){
var inst_35098 = (state_35196[(8)]);
var inst_35116 = cljs.core.apply.call(null,cljs.core.hash_map,inst_35098);
var state_35196__$1 = state_35196;
var statearr_35251_35305 = state_35196__$1;
(statearr_35251_35305[(2)] = inst_35116);

(statearr_35251_35305[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___35259,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__33364__auto__,c__33478__auto___35259,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__33365__auto__ = null;
var cljs$core$async$mix_$_state_machine__33365__auto____0 = (function (){
var statearr_35255 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35255[(0)] = cljs$core$async$mix_$_state_machine__33365__auto__);

(statearr_35255[(1)] = (1));

return statearr_35255;
});
var cljs$core$async$mix_$_state_machine__33365__auto____1 = (function (state_35196){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_35196);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e35256){if((e35256 instanceof Object)){
var ex__33368__auto__ = e35256;
var statearr_35257_35306 = state_35196;
(statearr_35257_35306[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35196);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35256;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35307 = state_35196;
state_35196 = G__35307;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__33365__auto__ = function(state_35196){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__33365__auto____1.call(this,state_35196);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__33365__auto____0;
cljs$core$async$mix_$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__33365__auto____1;
return cljs$core$async$mix_$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___35259,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__33480__auto__ = (function (){var statearr_35258 = f__33479__auto__.call(null);
(statearr_35258[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___35259);

return statearr_35258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___35259,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__10138__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p,v,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args35308 = [];
var len__10640__auto___35311 = arguments.length;
var i__10641__auto___35312 = (0);
while(true){
if((i__10641__auto___35312 < len__10640__auto___35311)){
args35308.push((arguments[i__10641__auto___35312]));

var G__35313 = (i__10641__auto___35312 + (1));
i__10641__auto___35312 = G__35313;
continue;
} else {
}
break;
}

var G__35310 = args35308.length;
switch (G__35310) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args35308.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p);
} else {
var m__10138__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p,v);
} else {
var m__10138__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args35316 = [];
var len__10640__auto___35441 = arguments.length;
var i__10641__auto___35442 = (0);
while(true){
if((i__10641__auto___35442 < len__10640__auto___35441)){
args35316.push((arguments[i__10641__auto___35442]));

var G__35443 = (i__10641__auto___35442 + (1));
i__10641__auto___35442 = G__35443;
continue;
} else {
}
break;
}

var G__35318 = args35316.length;
switch (G__35318) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args35316.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__9419__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__9419__auto__,mults){
return (function (p1__35315_SHARP_){
if(cljs.core.truth_(p1__35315_SHARP_.call(null,topic))){
return p1__35315_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__35315_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__9419__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async35319 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35319 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta35320){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta35320 = meta35320;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async35319.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_35321,meta35320__$1){
var self__ = this;
var _35321__$1 = this;
return (new cljs.core.async.t_cljs$core$async35319(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta35320__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async35319.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_35321){
var self__ = this;
var _35321__$1 = this;
return self__.meta35320;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async35319.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35319.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async35319.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35319.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async35319.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6738__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6738__auto__)){
var m = temp__6738__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async35319.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async35319.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async35319.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta35320","meta35320",813841774,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async35319.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35319.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35319";

cljs.core.async.t_cljs$core$async35319.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async35319");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async35319 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async35319(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta35320){
return (new cljs.core.async.t_cljs$core$async35319(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta35320));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async35319(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__33478__auto___35445 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___35445,mults,ensure_mult,p){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___35445,mults,ensure_mult,p){
return (function (state_35393){
var state_val_35394 = (state_35393[(1)]);
if((state_val_35394 === (7))){
var inst_35389 = (state_35393[(2)]);
var state_35393__$1 = state_35393;
var statearr_35395_35446 = state_35393__$1;
(statearr_35395_35446[(2)] = inst_35389);

(statearr_35395_35446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (20))){
var state_35393__$1 = state_35393;
var statearr_35396_35447 = state_35393__$1;
(statearr_35396_35447[(2)] = null);

(statearr_35396_35447[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (1))){
var state_35393__$1 = state_35393;
var statearr_35397_35448 = state_35393__$1;
(statearr_35397_35448[(2)] = null);

(statearr_35397_35448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (24))){
var inst_35372 = (state_35393[(7)]);
var inst_35381 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_35372);
var state_35393__$1 = state_35393;
var statearr_35398_35449 = state_35393__$1;
(statearr_35398_35449[(2)] = inst_35381);

(statearr_35398_35449[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (4))){
var inst_35324 = (state_35393[(8)]);
var inst_35324__$1 = (state_35393[(2)]);
var inst_35325 = (inst_35324__$1 == null);
var state_35393__$1 = (function (){var statearr_35399 = state_35393;
(statearr_35399[(8)] = inst_35324__$1);

return statearr_35399;
})();
if(cljs.core.truth_(inst_35325)){
var statearr_35400_35450 = state_35393__$1;
(statearr_35400_35450[(1)] = (5));

} else {
var statearr_35401_35451 = state_35393__$1;
(statearr_35401_35451[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (15))){
var inst_35366 = (state_35393[(2)]);
var state_35393__$1 = state_35393;
var statearr_35402_35452 = state_35393__$1;
(statearr_35402_35452[(2)] = inst_35366);

(statearr_35402_35452[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (21))){
var inst_35386 = (state_35393[(2)]);
var state_35393__$1 = (function (){var statearr_35403 = state_35393;
(statearr_35403[(9)] = inst_35386);

return statearr_35403;
})();
var statearr_35404_35453 = state_35393__$1;
(statearr_35404_35453[(2)] = null);

(statearr_35404_35453[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (13))){
var inst_35348 = (state_35393[(10)]);
var inst_35350 = cljs.core.chunked_seq_QMARK_.call(null,inst_35348);
var state_35393__$1 = state_35393;
if(inst_35350){
var statearr_35405_35454 = state_35393__$1;
(statearr_35405_35454[(1)] = (16));

} else {
var statearr_35406_35455 = state_35393__$1;
(statearr_35406_35455[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (22))){
var inst_35378 = (state_35393[(2)]);
var state_35393__$1 = state_35393;
if(cljs.core.truth_(inst_35378)){
var statearr_35407_35456 = state_35393__$1;
(statearr_35407_35456[(1)] = (23));

} else {
var statearr_35408_35457 = state_35393__$1;
(statearr_35408_35457[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (6))){
var inst_35324 = (state_35393[(8)]);
var inst_35374 = (state_35393[(11)]);
var inst_35372 = (state_35393[(7)]);
var inst_35372__$1 = topic_fn.call(null,inst_35324);
var inst_35373 = cljs.core.deref.call(null,mults);
var inst_35374__$1 = cljs.core.get.call(null,inst_35373,inst_35372__$1);
var state_35393__$1 = (function (){var statearr_35409 = state_35393;
(statearr_35409[(11)] = inst_35374__$1);

(statearr_35409[(7)] = inst_35372__$1);

return statearr_35409;
})();
if(cljs.core.truth_(inst_35374__$1)){
var statearr_35410_35458 = state_35393__$1;
(statearr_35410_35458[(1)] = (19));

} else {
var statearr_35411_35459 = state_35393__$1;
(statearr_35411_35459[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (25))){
var inst_35383 = (state_35393[(2)]);
var state_35393__$1 = state_35393;
var statearr_35412_35460 = state_35393__$1;
(statearr_35412_35460[(2)] = inst_35383);

(statearr_35412_35460[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (17))){
var inst_35348 = (state_35393[(10)]);
var inst_35357 = cljs.core.first.call(null,inst_35348);
var inst_35358 = cljs.core.async.muxch_STAR_.call(null,inst_35357);
var inst_35359 = cljs.core.async.close_BANG_.call(null,inst_35358);
var inst_35360 = cljs.core.next.call(null,inst_35348);
var inst_35334 = inst_35360;
var inst_35335 = null;
var inst_35336 = (0);
var inst_35337 = (0);
var state_35393__$1 = (function (){var statearr_35413 = state_35393;
(statearr_35413[(12)] = inst_35335);

(statearr_35413[(13)] = inst_35334);

(statearr_35413[(14)] = inst_35337);

(statearr_35413[(15)] = inst_35359);

(statearr_35413[(16)] = inst_35336);

return statearr_35413;
})();
var statearr_35414_35461 = state_35393__$1;
(statearr_35414_35461[(2)] = null);

(statearr_35414_35461[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (3))){
var inst_35391 = (state_35393[(2)]);
var state_35393__$1 = state_35393;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35393__$1,inst_35391);
} else {
if((state_val_35394 === (12))){
var inst_35368 = (state_35393[(2)]);
var state_35393__$1 = state_35393;
var statearr_35415_35462 = state_35393__$1;
(statearr_35415_35462[(2)] = inst_35368);

(statearr_35415_35462[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (2))){
var state_35393__$1 = state_35393;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35393__$1,(4),ch);
} else {
if((state_val_35394 === (23))){
var state_35393__$1 = state_35393;
var statearr_35416_35463 = state_35393__$1;
(statearr_35416_35463[(2)] = null);

(statearr_35416_35463[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (19))){
var inst_35324 = (state_35393[(8)]);
var inst_35374 = (state_35393[(11)]);
var inst_35376 = cljs.core.async.muxch_STAR_.call(null,inst_35374);
var state_35393__$1 = state_35393;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35393__$1,(22),inst_35376,inst_35324);
} else {
if((state_val_35394 === (11))){
var inst_35334 = (state_35393[(13)]);
var inst_35348 = (state_35393[(10)]);
var inst_35348__$1 = cljs.core.seq.call(null,inst_35334);
var state_35393__$1 = (function (){var statearr_35417 = state_35393;
(statearr_35417[(10)] = inst_35348__$1);

return statearr_35417;
})();
if(inst_35348__$1){
var statearr_35418_35464 = state_35393__$1;
(statearr_35418_35464[(1)] = (13));

} else {
var statearr_35419_35465 = state_35393__$1;
(statearr_35419_35465[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (9))){
var inst_35370 = (state_35393[(2)]);
var state_35393__$1 = state_35393;
var statearr_35420_35466 = state_35393__$1;
(statearr_35420_35466[(2)] = inst_35370);

(statearr_35420_35466[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (5))){
var inst_35331 = cljs.core.deref.call(null,mults);
var inst_35332 = cljs.core.vals.call(null,inst_35331);
var inst_35333 = cljs.core.seq.call(null,inst_35332);
var inst_35334 = inst_35333;
var inst_35335 = null;
var inst_35336 = (0);
var inst_35337 = (0);
var state_35393__$1 = (function (){var statearr_35421 = state_35393;
(statearr_35421[(12)] = inst_35335);

(statearr_35421[(13)] = inst_35334);

(statearr_35421[(14)] = inst_35337);

(statearr_35421[(16)] = inst_35336);

return statearr_35421;
})();
var statearr_35422_35467 = state_35393__$1;
(statearr_35422_35467[(2)] = null);

(statearr_35422_35467[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (14))){
var state_35393__$1 = state_35393;
var statearr_35426_35468 = state_35393__$1;
(statearr_35426_35468[(2)] = null);

(statearr_35426_35468[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (16))){
var inst_35348 = (state_35393[(10)]);
var inst_35352 = cljs.core.chunk_first.call(null,inst_35348);
var inst_35353 = cljs.core.chunk_rest.call(null,inst_35348);
var inst_35354 = cljs.core.count.call(null,inst_35352);
var inst_35334 = inst_35353;
var inst_35335 = inst_35352;
var inst_35336 = inst_35354;
var inst_35337 = (0);
var state_35393__$1 = (function (){var statearr_35427 = state_35393;
(statearr_35427[(12)] = inst_35335);

(statearr_35427[(13)] = inst_35334);

(statearr_35427[(14)] = inst_35337);

(statearr_35427[(16)] = inst_35336);

return statearr_35427;
})();
var statearr_35428_35469 = state_35393__$1;
(statearr_35428_35469[(2)] = null);

(statearr_35428_35469[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (10))){
var inst_35335 = (state_35393[(12)]);
var inst_35334 = (state_35393[(13)]);
var inst_35337 = (state_35393[(14)]);
var inst_35336 = (state_35393[(16)]);
var inst_35342 = cljs.core._nth.call(null,inst_35335,inst_35337);
var inst_35343 = cljs.core.async.muxch_STAR_.call(null,inst_35342);
var inst_35344 = cljs.core.async.close_BANG_.call(null,inst_35343);
var inst_35345 = (inst_35337 + (1));
var tmp35423 = inst_35335;
var tmp35424 = inst_35334;
var tmp35425 = inst_35336;
var inst_35334__$1 = tmp35424;
var inst_35335__$1 = tmp35423;
var inst_35336__$1 = tmp35425;
var inst_35337__$1 = inst_35345;
var state_35393__$1 = (function (){var statearr_35429 = state_35393;
(statearr_35429[(12)] = inst_35335__$1);

(statearr_35429[(17)] = inst_35344);

(statearr_35429[(13)] = inst_35334__$1);

(statearr_35429[(14)] = inst_35337__$1);

(statearr_35429[(16)] = inst_35336__$1);

return statearr_35429;
})();
var statearr_35430_35470 = state_35393__$1;
(statearr_35430_35470[(2)] = null);

(statearr_35430_35470[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (18))){
var inst_35363 = (state_35393[(2)]);
var state_35393__$1 = state_35393;
var statearr_35431_35471 = state_35393__$1;
(statearr_35431_35471[(2)] = inst_35363);

(statearr_35431_35471[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (8))){
var inst_35337 = (state_35393[(14)]);
var inst_35336 = (state_35393[(16)]);
var inst_35339 = (inst_35337 < inst_35336);
var inst_35340 = inst_35339;
var state_35393__$1 = state_35393;
if(cljs.core.truth_(inst_35340)){
var statearr_35432_35472 = state_35393__$1;
(statearr_35432_35472[(1)] = (10));

} else {
var statearr_35433_35473 = state_35393__$1;
(statearr_35433_35473[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___35445,mults,ensure_mult,p))
;
return ((function (switch__33364__auto__,c__33478__auto___35445,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_35437 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35437[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_35437[(1)] = (1));

return statearr_35437;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_35393){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_35393);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e35438){if((e35438 instanceof Object)){
var ex__33368__auto__ = e35438;
var statearr_35439_35474 = state_35393;
(statearr_35439_35474[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35393);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35438;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35475 = state_35393;
state_35393 = G__35475;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_35393){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_35393);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___35445,mults,ensure_mult,p))
})();
var state__33480__auto__ = (function (){var statearr_35440 = f__33479__auto__.call(null);
(statearr_35440[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___35445);

return statearr_35440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___35445,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args35476 = [];
var len__10640__auto___35479 = arguments.length;
var i__10641__auto___35480 = (0);
while(true){
if((i__10641__auto___35480 < len__10640__auto___35479)){
args35476.push((arguments[i__10641__auto___35480]));

var G__35481 = (i__10641__auto___35480 + (1));
i__10641__auto___35480 = G__35481;
continue;
} else {
}
break;
}

var G__35478 = args35476.length;
switch (G__35478) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args35476.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args35483 = [];
var len__10640__auto___35486 = arguments.length;
var i__10641__auto___35487 = (0);
while(true){
if((i__10641__auto___35487 < len__10640__auto___35486)){
args35483.push((arguments[i__10641__auto___35487]));

var G__35488 = (i__10641__auto___35487 + (1));
i__10641__auto___35487 = G__35488;
continue;
} else {
}
break;
}

var G__35485 = args35483.length;
switch (G__35485) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args35483.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args35490 = [];
var len__10640__auto___35561 = arguments.length;
var i__10641__auto___35562 = (0);
while(true){
if((i__10641__auto___35562 < len__10640__auto___35561)){
args35490.push((arguments[i__10641__auto___35562]));

var G__35563 = (i__10641__auto___35562 + (1));
i__10641__auto___35562 = G__35563;
continue;
} else {
}
break;
}

var G__35492 = args35490.length;
switch (G__35492) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args35490.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__33478__auto___35565 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___35565,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___35565,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_35531){
var state_val_35532 = (state_35531[(1)]);
if((state_val_35532 === (7))){
var state_35531__$1 = state_35531;
var statearr_35533_35566 = state_35531__$1;
(statearr_35533_35566[(2)] = null);

(statearr_35533_35566[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35532 === (1))){
var state_35531__$1 = state_35531;
var statearr_35534_35567 = state_35531__$1;
(statearr_35534_35567[(2)] = null);

(statearr_35534_35567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35532 === (4))){
var inst_35495 = (state_35531[(7)]);
var inst_35497 = (inst_35495 < cnt);
var state_35531__$1 = state_35531;
if(cljs.core.truth_(inst_35497)){
var statearr_35535_35568 = state_35531__$1;
(statearr_35535_35568[(1)] = (6));

} else {
var statearr_35536_35569 = state_35531__$1;
(statearr_35536_35569[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35532 === (15))){
var inst_35527 = (state_35531[(2)]);
var state_35531__$1 = state_35531;
var statearr_35537_35570 = state_35531__$1;
(statearr_35537_35570[(2)] = inst_35527);

(statearr_35537_35570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35532 === (13))){
var inst_35520 = cljs.core.async.close_BANG_.call(null,out);
var state_35531__$1 = state_35531;
var statearr_35538_35571 = state_35531__$1;
(statearr_35538_35571[(2)] = inst_35520);

(statearr_35538_35571[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35532 === (6))){
var state_35531__$1 = state_35531;
var statearr_35539_35572 = state_35531__$1;
(statearr_35539_35572[(2)] = null);

(statearr_35539_35572[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35532 === (3))){
var inst_35529 = (state_35531[(2)]);
var state_35531__$1 = state_35531;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35531__$1,inst_35529);
} else {
if((state_val_35532 === (12))){
var inst_35517 = (state_35531[(8)]);
var inst_35517__$1 = (state_35531[(2)]);
var inst_35518 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_35517__$1);
var state_35531__$1 = (function (){var statearr_35540 = state_35531;
(statearr_35540[(8)] = inst_35517__$1);

return statearr_35540;
})();
if(cljs.core.truth_(inst_35518)){
var statearr_35541_35573 = state_35531__$1;
(statearr_35541_35573[(1)] = (13));

} else {
var statearr_35542_35574 = state_35531__$1;
(statearr_35542_35574[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35532 === (2))){
var inst_35494 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_35495 = (0);
var state_35531__$1 = (function (){var statearr_35543 = state_35531;
(statearr_35543[(7)] = inst_35495);

(statearr_35543[(9)] = inst_35494);

return statearr_35543;
})();
var statearr_35544_35575 = state_35531__$1;
(statearr_35544_35575[(2)] = null);

(statearr_35544_35575[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35532 === (11))){
var inst_35495 = (state_35531[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_35531,(10),Object,null,(9));
var inst_35504 = chs__$1.call(null,inst_35495);
var inst_35505 = done.call(null,inst_35495);
var inst_35506 = cljs.core.async.take_BANG_.call(null,inst_35504,inst_35505);
var state_35531__$1 = state_35531;
var statearr_35545_35576 = state_35531__$1;
(statearr_35545_35576[(2)] = inst_35506);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35531__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35532 === (9))){
var inst_35495 = (state_35531[(7)]);
var inst_35508 = (state_35531[(2)]);
var inst_35509 = (inst_35495 + (1));
var inst_35495__$1 = inst_35509;
var state_35531__$1 = (function (){var statearr_35546 = state_35531;
(statearr_35546[(7)] = inst_35495__$1);

(statearr_35546[(10)] = inst_35508);

return statearr_35546;
})();
var statearr_35547_35577 = state_35531__$1;
(statearr_35547_35577[(2)] = null);

(statearr_35547_35577[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35532 === (5))){
var inst_35515 = (state_35531[(2)]);
var state_35531__$1 = (function (){var statearr_35548 = state_35531;
(statearr_35548[(11)] = inst_35515);

return statearr_35548;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35531__$1,(12),dchan);
} else {
if((state_val_35532 === (14))){
var inst_35517 = (state_35531[(8)]);
var inst_35522 = cljs.core.apply.call(null,f,inst_35517);
var state_35531__$1 = state_35531;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35531__$1,(16),out,inst_35522);
} else {
if((state_val_35532 === (16))){
var inst_35524 = (state_35531[(2)]);
var state_35531__$1 = (function (){var statearr_35549 = state_35531;
(statearr_35549[(12)] = inst_35524);

return statearr_35549;
})();
var statearr_35550_35578 = state_35531__$1;
(statearr_35550_35578[(2)] = null);

(statearr_35550_35578[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35532 === (10))){
var inst_35499 = (state_35531[(2)]);
var inst_35500 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_35531__$1 = (function (){var statearr_35551 = state_35531;
(statearr_35551[(13)] = inst_35499);

return statearr_35551;
})();
var statearr_35552_35579 = state_35531__$1;
(statearr_35552_35579[(2)] = inst_35500);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35531__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35532 === (8))){
var inst_35513 = (state_35531[(2)]);
var state_35531__$1 = state_35531;
var statearr_35553_35580 = state_35531__$1;
(statearr_35553_35580[(2)] = inst_35513);

(statearr_35553_35580[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___35565,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__33364__auto__,c__33478__auto___35565,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_35557 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35557[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_35557[(1)] = (1));

return statearr_35557;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_35531){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_35531);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e35558){if((e35558 instanceof Object)){
var ex__33368__auto__ = e35558;
var statearr_35559_35581 = state_35531;
(statearr_35559_35581[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35531);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35558;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35582 = state_35531;
state_35531 = G__35582;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_35531){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_35531);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___35565,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__33480__auto__ = (function (){var statearr_35560 = f__33479__auto__.call(null);
(statearr_35560[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___35565);

return statearr_35560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___35565,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args35584 = [];
var len__10640__auto___35642 = arguments.length;
var i__10641__auto___35643 = (0);
while(true){
if((i__10641__auto___35643 < len__10640__auto___35642)){
args35584.push((arguments[i__10641__auto___35643]));

var G__35644 = (i__10641__auto___35643 + (1));
i__10641__auto___35643 = G__35644;
continue;
} else {
}
break;
}

var G__35586 = args35584.length;
switch (G__35586) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args35584.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33478__auto___35646 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___35646,out){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___35646,out){
return (function (state_35618){
var state_val_35619 = (state_35618[(1)]);
if((state_val_35619 === (7))){
var inst_35598 = (state_35618[(7)]);
var inst_35597 = (state_35618[(8)]);
var inst_35597__$1 = (state_35618[(2)]);
var inst_35598__$1 = cljs.core.nth.call(null,inst_35597__$1,(0),null);
var inst_35599 = cljs.core.nth.call(null,inst_35597__$1,(1),null);
var inst_35600 = (inst_35598__$1 == null);
var state_35618__$1 = (function (){var statearr_35620 = state_35618;
(statearr_35620[(7)] = inst_35598__$1);

(statearr_35620[(8)] = inst_35597__$1);

(statearr_35620[(9)] = inst_35599);

return statearr_35620;
})();
if(cljs.core.truth_(inst_35600)){
var statearr_35621_35647 = state_35618__$1;
(statearr_35621_35647[(1)] = (8));

} else {
var statearr_35622_35648 = state_35618__$1;
(statearr_35622_35648[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35619 === (1))){
var inst_35587 = cljs.core.vec.call(null,chs);
var inst_35588 = inst_35587;
var state_35618__$1 = (function (){var statearr_35623 = state_35618;
(statearr_35623[(10)] = inst_35588);

return statearr_35623;
})();
var statearr_35624_35649 = state_35618__$1;
(statearr_35624_35649[(2)] = null);

(statearr_35624_35649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35619 === (4))){
var inst_35588 = (state_35618[(10)]);
var state_35618__$1 = state_35618;
return cljs.core.async.ioc_alts_BANG_.call(null,state_35618__$1,(7),inst_35588);
} else {
if((state_val_35619 === (6))){
var inst_35614 = (state_35618[(2)]);
var state_35618__$1 = state_35618;
var statearr_35625_35650 = state_35618__$1;
(statearr_35625_35650[(2)] = inst_35614);

(statearr_35625_35650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35619 === (3))){
var inst_35616 = (state_35618[(2)]);
var state_35618__$1 = state_35618;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35618__$1,inst_35616);
} else {
if((state_val_35619 === (2))){
var inst_35588 = (state_35618[(10)]);
var inst_35590 = cljs.core.count.call(null,inst_35588);
var inst_35591 = (inst_35590 > (0));
var state_35618__$1 = state_35618;
if(cljs.core.truth_(inst_35591)){
var statearr_35627_35651 = state_35618__$1;
(statearr_35627_35651[(1)] = (4));

} else {
var statearr_35628_35652 = state_35618__$1;
(statearr_35628_35652[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35619 === (11))){
var inst_35588 = (state_35618[(10)]);
var inst_35607 = (state_35618[(2)]);
var tmp35626 = inst_35588;
var inst_35588__$1 = tmp35626;
var state_35618__$1 = (function (){var statearr_35629 = state_35618;
(statearr_35629[(10)] = inst_35588__$1);

(statearr_35629[(11)] = inst_35607);

return statearr_35629;
})();
var statearr_35630_35653 = state_35618__$1;
(statearr_35630_35653[(2)] = null);

(statearr_35630_35653[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35619 === (9))){
var inst_35598 = (state_35618[(7)]);
var state_35618__$1 = state_35618;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35618__$1,(11),out,inst_35598);
} else {
if((state_val_35619 === (5))){
var inst_35612 = cljs.core.async.close_BANG_.call(null,out);
var state_35618__$1 = state_35618;
var statearr_35631_35654 = state_35618__$1;
(statearr_35631_35654[(2)] = inst_35612);

(statearr_35631_35654[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35619 === (10))){
var inst_35610 = (state_35618[(2)]);
var state_35618__$1 = state_35618;
var statearr_35632_35655 = state_35618__$1;
(statearr_35632_35655[(2)] = inst_35610);

(statearr_35632_35655[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35619 === (8))){
var inst_35598 = (state_35618[(7)]);
var inst_35597 = (state_35618[(8)]);
var inst_35599 = (state_35618[(9)]);
var inst_35588 = (state_35618[(10)]);
var inst_35602 = (function (){var cs = inst_35588;
var vec__35593 = inst_35597;
var v = inst_35598;
var c = inst_35599;
return ((function (cs,vec__35593,v,c,inst_35598,inst_35597,inst_35599,inst_35588,state_val_35619,c__33478__auto___35646,out){
return (function (p1__35583_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__35583_SHARP_);
});
;})(cs,vec__35593,v,c,inst_35598,inst_35597,inst_35599,inst_35588,state_val_35619,c__33478__auto___35646,out))
})();
var inst_35603 = cljs.core.filterv.call(null,inst_35602,inst_35588);
var inst_35588__$1 = inst_35603;
var state_35618__$1 = (function (){var statearr_35633 = state_35618;
(statearr_35633[(10)] = inst_35588__$1);

return statearr_35633;
})();
var statearr_35634_35656 = state_35618__$1;
(statearr_35634_35656[(2)] = null);

(statearr_35634_35656[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___35646,out))
;
return ((function (switch__33364__auto__,c__33478__auto___35646,out){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_35638 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35638[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_35638[(1)] = (1));

return statearr_35638;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_35618){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_35618);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e35639){if((e35639 instanceof Object)){
var ex__33368__auto__ = e35639;
var statearr_35640_35657 = state_35618;
(statearr_35640_35657[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35618);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35639;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35658 = state_35618;
state_35618 = G__35658;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_35618){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_35618);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___35646,out))
})();
var state__33480__auto__ = (function (){var statearr_35641 = f__33479__auto__.call(null);
(statearr_35641[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___35646);

return statearr_35641;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___35646,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args35659 = [];
var len__10640__auto___35708 = arguments.length;
var i__10641__auto___35709 = (0);
while(true){
if((i__10641__auto___35709 < len__10640__auto___35708)){
args35659.push((arguments[i__10641__auto___35709]));

var G__35710 = (i__10641__auto___35709 + (1));
i__10641__auto___35709 = G__35710;
continue;
} else {
}
break;
}

var G__35661 = args35659.length;
switch (G__35661) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args35659.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33478__auto___35712 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___35712,out){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___35712,out){
return (function (state_35685){
var state_val_35686 = (state_35685[(1)]);
if((state_val_35686 === (7))){
var inst_35667 = (state_35685[(7)]);
var inst_35667__$1 = (state_35685[(2)]);
var inst_35668 = (inst_35667__$1 == null);
var inst_35669 = cljs.core.not.call(null,inst_35668);
var state_35685__$1 = (function (){var statearr_35687 = state_35685;
(statearr_35687[(7)] = inst_35667__$1);

return statearr_35687;
})();
if(inst_35669){
var statearr_35688_35713 = state_35685__$1;
(statearr_35688_35713[(1)] = (8));

} else {
var statearr_35689_35714 = state_35685__$1;
(statearr_35689_35714[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (1))){
var inst_35662 = (0);
var state_35685__$1 = (function (){var statearr_35690 = state_35685;
(statearr_35690[(8)] = inst_35662);

return statearr_35690;
})();
var statearr_35691_35715 = state_35685__$1;
(statearr_35691_35715[(2)] = null);

(statearr_35691_35715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (4))){
var state_35685__$1 = state_35685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35685__$1,(7),ch);
} else {
if((state_val_35686 === (6))){
var inst_35680 = (state_35685[(2)]);
var state_35685__$1 = state_35685;
var statearr_35692_35716 = state_35685__$1;
(statearr_35692_35716[(2)] = inst_35680);

(statearr_35692_35716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (3))){
var inst_35682 = (state_35685[(2)]);
var inst_35683 = cljs.core.async.close_BANG_.call(null,out);
var state_35685__$1 = (function (){var statearr_35693 = state_35685;
(statearr_35693[(9)] = inst_35682);

return statearr_35693;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35685__$1,inst_35683);
} else {
if((state_val_35686 === (2))){
var inst_35662 = (state_35685[(8)]);
var inst_35664 = (inst_35662 < n);
var state_35685__$1 = state_35685;
if(cljs.core.truth_(inst_35664)){
var statearr_35694_35717 = state_35685__$1;
(statearr_35694_35717[(1)] = (4));

} else {
var statearr_35695_35718 = state_35685__$1;
(statearr_35695_35718[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (11))){
var inst_35662 = (state_35685[(8)]);
var inst_35672 = (state_35685[(2)]);
var inst_35673 = (inst_35662 + (1));
var inst_35662__$1 = inst_35673;
var state_35685__$1 = (function (){var statearr_35696 = state_35685;
(statearr_35696[(8)] = inst_35662__$1);

(statearr_35696[(10)] = inst_35672);

return statearr_35696;
})();
var statearr_35697_35719 = state_35685__$1;
(statearr_35697_35719[(2)] = null);

(statearr_35697_35719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (9))){
var state_35685__$1 = state_35685;
var statearr_35698_35720 = state_35685__$1;
(statearr_35698_35720[(2)] = null);

(statearr_35698_35720[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (5))){
var state_35685__$1 = state_35685;
var statearr_35699_35721 = state_35685__$1;
(statearr_35699_35721[(2)] = null);

(statearr_35699_35721[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (10))){
var inst_35677 = (state_35685[(2)]);
var state_35685__$1 = state_35685;
var statearr_35700_35722 = state_35685__$1;
(statearr_35700_35722[(2)] = inst_35677);

(statearr_35700_35722[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (8))){
var inst_35667 = (state_35685[(7)]);
var state_35685__$1 = state_35685;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35685__$1,(11),out,inst_35667);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___35712,out))
;
return ((function (switch__33364__auto__,c__33478__auto___35712,out){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_35704 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35704[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_35704[(1)] = (1));

return statearr_35704;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_35685){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_35685);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e35705){if((e35705 instanceof Object)){
var ex__33368__auto__ = e35705;
var statearr_35706_35723 = state_35685;
(statearr_35706_35723[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35685);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35705;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35724 = state_35685;
state_35685 = G__35724;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_35685){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_35685);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___35712,out))
})();
var state__33480__auto__ = (function (){var statearr_35707 = f__33479__auto__.call(null);
(statearr_35707[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___35712);

return statearr_35707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___35712,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async35732 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35732 = (function (f,ch,meta35733){
this.f = f;
this.ch = ch;
this.meta35733 = meta35733;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async35732.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35734,meta35733__$1){
var self__ = this;
var _35734__$1 = this;
return (new cljs.core.async.t_cljs$core$async35732(self__.f,self__.ch,meta35733__$1));
});

cljs.core.async.t_cljs$core$async35732.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35734){
var self__ = this;
var _35734__$1 = this;
return self__.meta35733;
});

cljs.core.async.t_cljs$core$async35732.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35732.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async35732.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async35732.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35732.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async35735 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35735 = (function (f,ch,meta35733,_,fn1,meta35736){
this.f = f;
this.ch = ch;
this.meta35733 = meta35733;
this._ = _;
this.fn1 = fn1;
this.meta35736 = meta35736;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async35735.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_35737,meta35736__$1){
var self__ = this;
var _35737__$1 = this;
return (new cljs.core.async.t_cljs$core$async35735(self__.f,self__.ch,self__.meta35733,self__._,self__.fn1,meta35736__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async35735.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_35737){
var self__ = this;
var _35737__$1 = this;
return self__.meta35736;
});})(___$1))
;

cljs.core.async.t_cljs$core$async35735.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35735.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async35735.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async35735.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__35725_SHARP_){
return f1.call(null,(((p1__35725_SHARP_ == null))?null:self__.f.call(null,p1__35725_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async35735.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta35733","meta35733",1064626685,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async35732","cljs.core.async/t_cljs$core$async35732",-1077950054,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta35736","meta35736",1774458966,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async35735.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35735.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35735";

cljs.core.async.t_cljs$core$async35735.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async35735");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async35735 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async35735(f__$1,ch__$1,meta35733__$1,___$2,fn1__$1,meta35736){
return (new cljs.core.async.t_cljs$core$async35735(f__$1,ch__$1,meta35733__$1,___$2,fn1__$1,meta35736));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async35735(self__.f,self__.ch,self__.meta35733,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__9407__auto__ = ret;
if(cljs.core.truth_(and__9407__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__9407__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async35732.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35732.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async35732.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta35733","meta35733",1064626685,null)], null);
});

cljs.core.async.t_cljs$core$async35732.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35732.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35732";

cljs.core.async.t_cljs$core$async35732.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async35732");
});

cljs.core.async.__GT_t_cljs$core$async35732 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async35732(f__$1,ch__$1,meta35733){
return (new cljs.core.async.t_cljs$core$async35732(f__$1,ch__$1,meta35733));
});

}

return (new cljs.core.async.t_cljs$core$async35732(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async35741 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35741 = (function (f,ch,meta35742){
this.f = f;
this.ch = ch;
this.meta35742 = meta35742;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async35741.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35743,meta35742__$1){
var self__ = this;
var _35743__$1 = this;
return (new cljs.core.async.t_cljs$core$async35741(self__.f,self__.ch,meta35742__$1));
});

cljs.core.async.t_cljs$core$async35741.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35743){
var self__ = this;
var _35743__$1 = this;
return self__.meta35742;
});

cljs.core.async.t_cljs$core$async35741.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35741.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async35741.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35741.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async35741.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35741.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async35741.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta35742","meta35742",-929981694,null)], null);
});

cljs.core.async.t_cljs$core$async35741.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35741.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35741";

cljs.core.async.t_cljs$core$async35741.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async35741");
});

cljs.core.async.__GT_t_cljs$core$async35741 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async35741(f__$1,ch__$1,meta35742){
return (new cljs.core.async.t_cljs$core$async35741(f__$1,ch__$1,meta35742));
});

}

return (new cljs.core.async.t_cljs$core$async35741(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async35747 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35747 = (function (p,ch,meta35748){
this.p = p;
this.ch = ch;
this.meta35748 = meta35748;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async35747.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35749,meta35748__$1){
var self__ = this;
var _35749__$1 = this;
return (new cljs.core.async.t_cljs$core$async35747(self__.p,self__.ch,meta35748__$1));
});

cljs.core.async.t_cljs$core$async35747.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35749){
var self__ = this;
var _35749__$1 = this;
return self__.meta35748;
});

cljs.core.async.t_cljs$core$async35747.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35747.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async35747.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async35747.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35747.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async35747.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35747.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async35747.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta35748","meta35748",782963944,null)], null);
});

cljs.core.async.t_cljs$core$async35747.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35747.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35747";

cljs.core.async.t_cljs$core$async35747.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async35747");
});

cljs.core.async.__GT_t_cljs$core$async35747 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async35747(p__$1,ch__$1,meta35748){
return (new cljs.core.async.t_cljs$core$async35747(p__$1,ch__$1,meta35748));
});

}

return (new cljs.core.async.t_cljs$core$async35747(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args35750 = [];
var len__10640__auto___35794 = arguments.length;
var i__10641__auto___35795 = (0);
while(true){
if((i__10641__auto___35795 < len__10640__auto___35794)){
args35750.push((arguments[i__10641__auto___35795]));

var G__35796 = (i__10641__auto___35795 + (1));
i__10641__auto___35795 = G__35796;
continue;
} else {
}
break;
}

var G__35752 = args35750.length;
switch (G__35752) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args35750.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33478__auto___35798 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___35798,out){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___35798,out){
return (function (state_35773){
var state_val_35774 = (state_35773[(1)]);
if((state_val_35774 === (7))){
var inst_35769 = (state_35773[(2)]);
var state_35773__$1 = state_35773;
var statearr_35775_35799 = state_35773__$1;
(statearr_35775_35799[(2)] = inst_35769);

(statearr_35775_35799[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35774 === (1))){
var state_35773__$1 = state_35773;
var statearr_35776_35800 = state_35773__$1;
(statearr_35776_35800[(2)] = null);

(statearr_35776_35800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35774 === (4))){
var inst_35755 = (state_35773[(7)]);
var inst_35755__$1 = (state_35773[(2)]);
var inst_35756 = (inst_35755__$1 == null);
var state_35773__$1 = (function (){var statearr_35777 = state_35773;
(statearr_35777[(7)] = inst_35755__$1);

return statearr_35777;
})();
if(cljs.core.truth_(inst_35756)){
var statearr_35778_35801 = state_35773__$1;
(statearr_35778_35801[(1)] = (5));

} else {
var statearr_35779_35802 = state_35773__$1;
(statearr_35779_35802[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35774 === (6))){
var inst_35755 = (state_35773[(7)]);
var inst_35760 = p.call(null,inst_35755);
var state_35773__$1 = state_35773;
if(cljs.core.truth_(inst_35760)){
var statearr_35780_35803 = state_35773__$1;
(statearr_35780_35803[(1)] = (8));

} else {
var statearr_35781_35804 = state_35773__$1;
(statearr_35781_35804[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35774 === (3))){
var inst_35771 = (state_35773[(2)]);
var state_35773__$1 = state_35773;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35773__$1,inst_35771);
} else {
if((state_val_35774 === (2))){
var state_35773__$1 = state_35773;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35773__$1,(4),ch);
} else {
if((state_val_35774 === (11))){
var inst_35763 = (state_35773[(2)]);
var state_35773__$1 = state_35773;
var statearr_35782_35805 = state_35773__$1;
(statearr_35782_35805[(2)] = inst_35763);

(statearr_35782_35805[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35774 === (9))){
var state_35773__$1 = state_35773;
var statearr_35783_35806 = state_35773__$1;
(statearr_35783_35806[(2)] = null);

(statearr_35783_35806[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35774 === (5))){
var inst_35758 = cljs.core.async.close_BANG_.call(null,out);
var state_35773__$1 = state_35773;
var statearr_35784_35807 = state_35773__$1;
(statearr_35784_35807[(2)] = inst_35758);

(statearr_35784_35807[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35774 === (10))){
var inst_35766 = (state_35773[(2)]);
var state_35773__$1 = (function (){var statearr_35785 = state_35773;
(statearr_35785[(8)] = inst_35766);

return statearr_35785;
})();
var statearr_35786_35808 = state_35773__$1;
(statearr_35786_35808[(2)] = null);

(statearr_35786_35808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35774 === (8))){
var inst_35755 = (state_35773[(7)]);
var state_35773__$1 = state_35773;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35773__$1,(11),out,inst_35755);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___35798,out))
;
return ((function (switch__33364__auto__,c__33478__auto___35798,out){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_35790 = [null,null,null,null,null,null,null,null,null];
(statearr_35790[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_35790[(1)] = (1));

return statearr_35790;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_35773){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_35773);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e35791){if((e35791 instanceof Object)){
var ex__33368__auto__ = e35791;
var statearr_35792_35809 = state_35773;
(statearr_35792_35809[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35773);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35791;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35810 = state_35773;
state_35773 = G__35810;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_35773){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_35773);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___35798,out))
})();
var state__33480__auto__ = (function (){var statearr_35793 = f__33479__auto__.call(null);
(statearr_35793[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___35798);

return statearr_35793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___35798,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args35811 = [];
var len__10640__auto___35814 = arguments.length;
var i__10641__auto___35815 = (0);
while(true){
if((i__10641__auto___35815 < len__10640__auto___35814)){
args35811.push((arguments[i__10641__auto___35815]));

var G__35816 = (i__10641__auto___35815 + (1));
i__10641__auto___35815 = G__35816;
continue;
} else {
}
break;
}

var G__35813 = args35811.length;
switch (G__35813) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args35811.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__33478__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto__){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto__){
return (function (state_35983){
var state_val_35984 = (state_35983[(1)]);
if((state_val_35984 === (7))){
var inst_35979 = (state_35983[(2)]);
var state_35983__$1 = state_35983;
var statearr_35985_36026 = state_35983__$1;
(statearr_35985_36026[(2)] = inst_35979);

(statearr_35985_36026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35984 === (20))){
var inst_35949 = (state_35983[(7)]);
var inst_35960 = (state_35983[(2)]);
var inst_35961 = cljs.core.next.call(null,inst_35949);
var inst_35935 = inst_35961;
var inst_35936 = null;
var inst_35937 = (0);
var inst_35938 = (0);
var state_35983__$1 = (function (){var statearr_35986 = state_35983;
(statearr_35986[(8)] = inst_35938);

(statearr_35986[(9)] = inst_35960);

(statearr_35986[(10)] = inst_35937);

(statearr_35986[(11)] = inst_35936);

(statearr_35986[(12)] = inst_35935);

return statearr_35986;
})();
var statearr_35987_36027 = state_35983__$1;
(statearr_35987_36027[(2)] = null);

(statearr_35987_36027[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35984 === (1))){
var state_35983__$1 = state_35983;
var statearr_35988_36028 = state_35983__$1;
(statearr_35988_36028[(2)] = null);

(statearr_35988_36028[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35984 === (4))){
var inst_35924 = (state_35983[(13)]);
var inst_35924__$1 = (state_35983[(2)]);
var inst_35925 = (inst_35924__$1 == null);
var state_35983__$1 = (function (){var statearr_35989 = state_35983;
(statearr_35989[(13)] = inst_35924__$1);

return statearr_35989;
})();
if(cljs.core.truth_(inst_35925)){
var statearr_35990_36029 = state_35983__$1;
(statearr_35990_36029[(1)] = (5));

} else {
var statearr_35991_36030 = state_35983__$1;
(statearr_35991_36030[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35984 === (15))){
var state_35983__$1 = state_35983;
var statearr_35995_36031 = state_35983__$1;
(statearr_35995_36031[(2)] = null);

(statearr_35995_36031[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35984 === (21))){
var state_35983__$1 = state_35983;
var statearr_35996_36032 = state_35983__$1;
(statearr_35996_36032[(2)] = null);

(statearr_35996_36032[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35984 === (13))){
var inst_35938 = (state_35983[(8)]);
var inst_35937 = (state_35983[(10)]);
var inst_35936 = (state_35983[(11)]);
var inst_35935 = (state_35983[(12)]);
var inst_35945 = (state_35983[(2)]);
var inst_35946 = (inst_35938 + (1));
var tmp35992 = inst_35937;
var tmp35993 = inst_35936;
var tmp35994 = inst_35935;
var inst_35935__$1 = tmp35994;
var inst_35936__$1 = tmp35993;
var inst_35937__$1 = tmp35992;
var inst_35938__$1 = inst_35946;
var state_35983__$1 = (function (){var statearr_35997 = state_35983;
(statearr_35997[(8)] = inst_35938__$1);

(statearr_35997[(10)] = inst_35937__$1);

(statearr_35997[(11)] = inst_35936__$1);

(statearr_35997[(14)] = inst_35945);

(statearr_35997[(12)] = inst_35935__$1);

return statearr_35997;
})();
var statearr_35998_36033 = state_35983__$1;
(statearr_35998_36033[(2)] = null);

(statearr_35998_36033[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35984 === (22))){
var state_35983__$1 = state_35983;
var statearr_35999_36034 = state_35983__$1;
(statearr_35999_36034[(2)] = null);

(statearr_35999_36034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35984 === (6))){
var inst_35924 = (state_35983[(13)]);
var inst_35933 = f.call(null,inst_35924);
var inst_35934 = cljs.core.seq.call(null,inst_35933);
var inst_35935 = inst_35934;
var inst_35936 = null;
var inst_35937 = (0);
var inst_35938 = (0);
var state_35983__$1 = (function (){var statearr_36000 = state_35983;
(statearr_36000[(8)] = inst_35938);

(statearr_36000[(10)] = inst_35937);

(statearr_36000[(11)] = inst_35936);

(statearr_36000[(12)] = inst_35935);

return statearr_36000;
})();
var statearr_36001_36035 = state_35983__$1;
(statearr_36001_36035[(2)] = null);

(statearr_36001_36035[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35984 === (17))){
var inst_35949 = (state_35983[(7)]);
var inst_35953 = cljs.core.chunk_first.call(null,inst_35949);
var inst_35954 = cljs.core.chunk_rest.call(null,inst_35949);
var inst_35955 = cljs.core.count.call(null,inst_35953);
var inst_35935 = inst_35954;
var inst_35936 = inst_35953;
var inst_35937 = inst_35955;
var inst_35938 = (0);
var state_35983__$1 = (function (){var statearr_36002 = state_35983;
(statearr_36002[(8)] = inst_35938);

(statearr_36002[(10)] = inst_35937);

(statearr_36002[(11)] = inst_35936);

(statearr_36002[(12)] = inst_35935);

return statearr_36002;
})();
var statearr_36003_36036 = state_35983__$1;
(statearr_36003_36036[(2)] = null);

(statearr_36003_36036[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35984 === (3))){
var inst_35981 = (state_35983[(2)]);
var state_35983__$1 = state_35983;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35983__$1,inst_35981);
} else {
if((state_val_35984 === (12))){
var inst_35969 = (state_35983[(2)]);
var state_35983__$1 = state_35983;
var statearr_36004_36037 = state_35983__$1;
(statearr_36004_36037[(2)] = inst_35969);

(statearr_36004_36037[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35984 === (2))){
var state_35983__$1 = state_35983;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35983__$1,(4),in$);
} else {
if((state_val_35984 === (23))){
var inst_35977 = (state_35983[(2)]);
var state_35983__$1 = state_35983;
var statearr_36005_36038 = state_35983__$1;
(statearr_36005_36038[(2)] = inst_35977);

(statearr_36005_36038[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35984 === (19))){
var inst_35964 = (state_35983[(2)]);
var state_35983__$1 = state_35983;
var statearr_36006_36039 = state_35983__$1;
(statearr_36006_36039[(2)] = inst_35964);

(statearr_36006_36039[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35984 === (11))){
var inst_35935 = (state_35983[(12)]);
var inst_35949 = (state_35983[(7)]);
var inst_35949__$1 = cljs.core.seq.call(null,inst_35935);
var state_35983__$1 = (function (){var statearr_36007 = state_35983;
(statearr_36007[(7)] = inst_35949__$1);

return statearr_36007;
})();
if(inst_35949__$1){
var statearr_36008_36040 = state_35983__$1;
(statearr_36008_36040[(1)] = (14));

} else {
var statearr_36009_36041 = state_35983__$1;
(statearr_36009_36041[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35984 === (9))){
var inst_35971 = (state_35983[(2)]);
var inst_35972 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_35983__$1 = (function (){var statearr_36010 = state_35983;
(statearr_36010[(15)] = inst_35971);

return statearr_36010;
})();
if(cljs.core.truth_(inst_35972)){
var statearr_36011_36042 = state_35983__$1;
(statearr_36011_36042[(1)] = (21));

} else {
var statearr_36012_36043 = state_35983__$1;
(statearr_36012_36043[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35984 === (5))){
var inst_35927 = cljs.core.async.close_BANG_.call(null,out);
var state_35983__$1 = state_35983;
var statearr_36013_36044 = state_35983__$1;
(statearr_36013_36044[(2)] = inst_35927);

(statearr_36013_36044[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35984 === (14))){
var inst_35949 = (state_35983[(7)]);
var inst_35951 = cljs.core.chunked_seq_QMARK_.call(null,inst_35949);
var state_35983__$1 = state_35983;
if(inst_35951){
var statearr_36014_36045 = state_35983__$1;
(statearr_36014_36045[(1)] = (17));

} else {
var statearr_36015_36046 = state_35983__$1;
(statearr_36015_36046[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35984 === (16))){
var inst_35967 = (state_35983[(2)]);
var state_35983__$1 = state_35983;
var statearr_36016_36047 = state_35983__$1;
(statearr_36016_36047[(2)] = inst_35967);

(statearr_36016_36047[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35984 === (10))){
var inst_35938 = (state_35983[(8)]);
var inst_35936 = (state_35983[(11)]);
var inst_35943 = cljs.core._nth.call(null,inst_35936,inst_35938);
var state_35983__$1 = state_35983;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35983__$1,(13),out,inst_35943);
} else {
if((state_val_35984 === (18))){
var inst_35949 = (state_35983[(7)]);
var inst_35958 = cljs.core.first.call(null,inst_35949);
var state_35983__$1 = state_35983;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35983__$1,(20),out,inst_35958);
} else {
if((state_val_35984 === (8))){
var inst_35938 = (state_35983[(8)]);
var inst_35937 = (state_35983[(10)]);
var inst_35940 = (inst_35938 < inst_35937);
var inst_35941 = inst_35940;
var state_35983__$1 = state_35983;
if(cljs.core.truth_(inst_35941)){
var statearr_36017_36048 = state_35983__$1;
(statearr_36017_36048[(1)] = (10));

} else {
var statearr_36018_36049 = state_35983__$1;
(statearr_36018_36049[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto__))
;
return ((function (switch__33364__auto__,c__33478__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__33365__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__33365__auto____0 = (function (){
var statearr_36022 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36022[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__33365__auto__);

(statearr_36022[(1)] = (1));

return statearr_36022;
});
var cljs$core$async$mapcat_STAR__$_state_machine__33365__auto____1 = (function (state_35983){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_35983);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e36023){if((e36023 instanceof Object)){
var ex__33368__auto__ = e36023;
var statearr_36024_36050 = state_35983;
(statearr_36024_36050[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35983);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36023;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36051 = state_35983;
state_35983 = G__36051;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__33365__auto__ = function(state_35983){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__33365__auto____1.call(this,state_35983);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__33365__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__33365__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto__))
})();
var state__33480__auto__ = (function (){var statearr_36025 = f__33479__auto__.call(null);
(statearr_36025[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto__);

return statearr_36025;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto__))
);

return c__33478__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args36052 = [];
var len__10640__auto___36055 = arguments.length;
var i__10641__auto___36056 = (0);
while(true){
if((i__10641__auto___36056 < len__10640__auto___36055)){
args36052.push((arguments[i__10641__auto___36056]));

var G__36057 = (i__10641__auto___36056 + (1));
i__10641__auto___36056 = G__36057;
continue;
} else {
}
break;
}

var G__36054 = args36052.length;
switch (G__36054) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args36052.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args36059 = [];
var len__10640__auto___36062 = arguments.length;
var i__10641__auto___36063 = (0);
while(true){
if((i__10641__auto___36063 < len__10640__auto___36062)){
args36059.push((arguments[i__10641__auto___36063]));

var G__36064 = (i__10641__auto___36063 + (1));
i__10641__auto___36063 = G__36064;
continue;
} else {
}
break;
}

var G__36061 = args36059.length;
switch (G__36061) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args36059.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args36066 = [];
var len__10640__auto___36117 = arguments.length;
var i__10641__auto___36118 = (0);
while(true){
if((i__10641__auto___36118 < len__10640__auto___36117)){
args36066.push((arguments[i__10641__auto___36118]));

var G__36119 = (i__10641__auto___36118 + (1));
i__10641__auto___36118 = G__36119;
continue;
} else {
}
break;
}

var G__36068 = args36066.length;
switch (G__36068) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args36066.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33478__auto___36121 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___36121,out){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___36121,out){
return (function (state_36092){
var state_val_36093 = (state_36092[(1)]);
if((state_val_36093 === (7))){
var inst_36087 = (state_36092[(2)]);
var state_36092__$1 = state_36092;
var statearr_36094_36122 = state_36092__$1;
(statearr_36094_36122[(2)] = inst_36087);

(statearr_36094_36122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36093 === (1))){
var inst_36069 = null;
var state_36092__$1 = (function (){var statearr_36095 = state_36092;
(statearr_36095[(7)] = inst_36069);

return statearr_36095;
})();
var statearr_36096_36123 = state_36092__$1;
(statearr_36096_36123[(2)] = null);

(statearr_36096_36123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36093 === (4))){
var inst_36072 = (state_36092[(8)]);
var inst_36072__$1 = (state_36092[(2)]);
var inst_36073 = (inst_36072__$1 == null);
var inst_36074 = cljs.core.not.call(null,inst_36073);
var state_36092__$1 = (function (){var statearr_36097 = state_36092;
(statearr_36097[(8)] = inst_36072__$1);

return statearr_36097;
})();
if(inst_36074){
var statearr_36098_36124 = state_36092__$1;
(statearr_36098_36124[(1)] = (5));

} else {
var statearr_36099_36125 = state_36092__$1;
(statearr_36099_36125[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36093 === (6))){
var state_36092__$1 = state_36092;
var statearr_36100_36126 = state_36092__$1;
(statearr_36100_36126[(2)] = null);

(statearr_36100_36126[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36093 === (3))){
var inst_36089 = (state_36092[(2)]);
var inst_36090 = cljs.core.async.close_BANG_.call(null,out);
var state_36092__$1 = (function (){var statearr_36101 = state_36092;
(statearr_36101[(9)] = inst_36089);

return statearr_36101;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36092__$1,inst_36090);
} else {
if((state_val_36093 === (2))){
var state_36092__$1 = state_36092;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36092__$1,(4),ch);
} else {
if((state_val_36093 === (11))){
var inst_36072 = (state_36092[(8)]);
var inst_36081 = (state_36092[(2)]);
var inst_36069 = inst_36072;
var state_36092__$1 = (function (){var statearr_36102 = state_36092;
(statearr_36102[(7)] = inst_36069);

(statearr_36102[(10)] = inst_36081);

return statearr_36102;
})();
var statearr_36103_36127 = state_36092__$1;
(statearr_36103_36127[(2)] = null);

(statearr_36103_36127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36093 === (9))){
var inst_36072 = (state_36092[(8)]);
var state_36092__$1 = state_36092;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_36092__$1,(11),out,inst_36072);
} else {
if((state_val_36093 === (5))){
var inst_36069 = (state_36092[(7)]);
var inst_36072 = (state_36092[(8)]);
var inst_36076 = cljs.core._EQ_.call(null,inst_36072,inst_36069);
var state_36092__$1 = state_36092;
if(inst_36076){
var statearr_36105_36128 = state_36092__$1;
(statearr_36105_36128[(1)] = (8));

} else {
var statearr_36106_36129 = state_36092__$1;
(statearr_36106_36129[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36093 === (10))){
var inst_36084 = (state_36092[(2)]);
var state_36092__$1 = state_36092;
var statearr_36107_36130 = state_36092__$1;
(statearr_36107_36130[(2)] = inst_36084);

(statearr_36107_36130[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36093 === (8))){
var inst_36069 = (state_36092[(7)]);
var tmp36104 = inst_36069;
var inst_36069__$1 = tmp36104;
var state_36092__$1 = (function (){var statearr_36108 = state_36092;
(statearr_36108[(7)] = inst_36069__$1);

return statearr_36108;
})();
var statearr_36109_36131 = state_36092__$1;
(statearr_36109_36131[(2)] = null);

(statearr_36109_36131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___36121,out))
;
return ((function (switch__33364__auto__,c__33478__auto___36121,out){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_36113 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36113[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_36113[(1)] = (1));

return statearr_36113;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_36092){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_36092);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e36114){if((e36114 instanceof Object)){
var ex__33368__auto__ = e36114;
var statearr_36115_36132 = state_36092;
(statearr_36115_36132[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36092);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36114;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36133 = state_36092;
state_36092 = G__36133;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_36092){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_36092);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___36121,out))
})();
var state__33480__auto__ = (function (){var statearr_36116 = f__33479__auto__.call(null);
(statearr_36116[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___36121);

return statearr_36116;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___36121,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args36134 = [];
var len__10640__auto___36204 = arguments.length;
var i__10641__auto___36205 = (0);
while(true){
if((i__10641__auto___36205 < len__10640__auto___36204)){
args36134.push((arguments[i__10641__auto___36205]));

var G__36206 = (i__10641__auto___36205 + (1));
i__10641__auto___36205 = G__36206;
continue;
} else {
}
break;
}

var G__36136 = args36134.length;
switch (G__36136) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args36134.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33478__auto___36208 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___36208,out){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___36208,out){
return (function (state_36174){
var state_val_36175 = (state_36174[(1)]);
if((state_val_36175 === (7))){
var inst_36170 = (state_36174[(2)]);
var state_36174__$1 = state_36174;
var statearr_36176_36209 = state_36174__$1;
(statearr_36176_36209[(2)] = inst_36170);

(statearr_36176_36209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36175 === (1))){
var inst_36137 = (new Array(n));
var inst_36138 = inst_36137;
var inst_36139 = (0);
var state_36174__$1 = (function (){var statearr_36177 = state_36174;
(statearr_36177[(7)] = inst_36138);

(statearr_36177[(8)] = inst_36139);

return statearr_36177;
})();
var statearr_36178_36210 = state_36174__$1;
(statearr_36178_36210[(2)] = null);

(statearr_36178_36210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36175 === (4))){
var inst_36142 = (state_36174[(9)]);
var inst_36142__$1 = (state_36174[(2)]);
var inst_36143 = (inst_36142__$1 == null);
var inst_36144 = cljs.core.not.call(null,inst_36143);
var state_36174__$1 = (function (){var statearr_36179 = state_36174;
(statearr_36179[(9)] = inst_36142__$1);

return statearr_36179;
})();
if(inst_36144){
var statearr_36180_36211 = state_36174__$1;
(statearr_36180_36211[(1)] = (5));

} else {
var statearr_36181_36212 = state_36174__$1;
(statearr_36181_36212[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36175 === (15))){
var inst_36164 = (state_36174[(2)]);
var state_36174__$1 = state_36174;
var statearr_36182_36213 = state_36174__$1;
(statearr_36182_36213[(2)] = inst_36164);

(statearr_36182_36213[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36175 === (13))){
var state_36174__$1 = state_36174;
var statearr_36183_36214 = state_36174__$1;
(statearr_36183_36214[(2)] = null);

(statearr_36183_36214[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36175 === (6))){
var inst_36139 = (state_36174[(8)]);
var inst_36160 = (inst_36139 > (0));
var state_36174__$1 = state_36174;
if(cljs.core.truth_(inst_36160)){
var statearr_36184_36215 = state_36174__$1;
(statearr_36184_36215[(1)] = (12));

} else {
var statearr_36185_36216 = state_36174__$1;
(statearr_36185_36216[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36175 === (3))){
var inst_36172 = (state_36174[(2)]);
var state_36174__$1 = state_36174;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36174__$1,inst_36172);
} else {
if((state_val_36175 === (12))){
var inst_36138 = (state_36174[(7)]);
var inst_36162 = cljs.core.vec.call(null,inst_36138);
var state_36174__$1 = state_36174;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_36174__$1,(15),out,inst_36162);
} else {
if((state_val_36175 === (2))){
var state_36174__$1 = state_36174;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36174__$1,(4),ch);
} else {
if((state_val_36175 === (11))){
var inst_36154 = (state_36174[(2)]);
var inst_36155 = (new Array(n));
var inst_36138 = inst_36155;
var inst_36139 = (0);
var state_36174__$1 = (function (){var statearr_36186 = state_36174;
(statearr_36186[(7)] = inst_36138);

(statearr_36186[(8)] = inst_36139);

(statearr_36186[(10)] = inst_36154);

return statearr_36186;
})();
var statearr_36187_36217 = state_36174__$1;
(statearr_36187_36217[(2)] = null);

(statearr_36187_36217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36175 === (9))){
var inst_36138 = (state_36174[(7)]);
var inst_36152 = cljs.core.vec.call(null,inst_36138);
var state_36174__$1 = state_36174;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_36174__$1,(11),out,inst_36152);
} else {
if((state_val_36175 === (5))){
var inst_36138 = (state_36174[(7)]);
var inst_36147 = (state_36174[(11)]);
var inst_36139 = (state_36174[(8)]);
var inst_36142 = (state_36174[(9)]);
var inst_36146 = (inst_36138[inst_36139] = inst_36142);
var inst_36147__$1 = (inst_36139 + (1));
var inst_36148 = (inst_36147__$1 < n);
var state_36174__$1 = (function (){var statearr_36188 = state_36174;
(statearr_36188[(11)] = inst_36147__$1);

(statearr_36188[(12)] = inst_36146);

return statearr_36188;
})();
if(cljs.core.truth_(inst_36148)){
var statearr_36189_36218 = state_36174__$1;
(statearr_36189_36218[(1)] = (8));

} else {
var statearr_36190_36219 = state_36174__$1;
(statearr_36190_36219[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36175 === (14))){
var inst_36167 = (state_36174[(2)]);
var inst_36168 = cljs.core.async.close_BANG_.call(null,out);
var state_36174__$1 = (function (){var statearr_36192 = state_36174;
(statearr_36192[(13)] = inst_36167);

return statearr_36192;
})();
var statearr_36193_36220 = state_36174__$1;
(statearr_36193_36220[(2)] = inst_36168);

(statearr_36193_36220[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36175 === (10))){
var inst_36158 = (state_36174[(2)]);
var state_36174__$1 = state_36174;
var statearr_36194_36221 = state_36174__$1;
(statearr_36194_36221[(2)] = inst_36158);

(statearr_36194_36221[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36175 === (8))){
var inst_36138 = (state_36174[(7)]);
var inst_36147 = (state_36174[(11)]);
var tmp36191 = inst_36138;
var inst_36138__$1 = tmp36191;
var inst_36139 = inst_36147;
var state_36174__$1 = (function (){var statearr_36195 = state_36174;
(statearr_36195[(7)] = inst_36138__$1);

(statearr_36195[(8)] = inst_36139);

return statearr_36195;
})();
var statearr_36196_36222 = state_36174__$1;
(statearr_36196_36222[(2)] = null);

(statearr_36196_36222[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___36208,out))
;
return ((function (switch__33364__auto__,c__33478__auto___36208,out){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_36200 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36200[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_36200[(1)] = (1));

return statearr_36200;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_36174){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_36174);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e36201){if((e36201 instanceof Object)){
var ex__33368__auto__ = e36201;
var statearr_36202_36223 = state_36174;
(statearr_36202_36223[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36174);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36201;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36224 = state_36174;
state_36174 = G__36224;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_36174){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_36174);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___36208,out))
})();
var state__33480__auto__ = (function (){var statearr_36203 = f__33479__auto__.call(null);
(statearr_36203[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___36208);

return statearr_36203;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___36208,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args36225 = [];
var len__10640__auto___36299 = arguments.length;
var i__10641__auto___36300 = (0);
while(true){
if((i__10641__auto___36300 < len__10640__auto___36299)){
args36225.push((arguments[i__10641__auto___36300]));

var G__36301 = (i__10641__auto___36300 + (1));
i__10641__auto___36300 = G__36301;
continue;
} else {
}
break;
}

var G__36227 = args36225.length;
switch (G__36227) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args36225.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33478__auto___36303 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___36303,out){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___36303,out){
return (function (state_36269){
var state_val_36270 = (state_36269[(1)]);
if((state_val_36270 === (7))){
var inst_36265 = (state_36269[(2)]);
var state_36269__$1 = state_36269;
var statearr_36271_36304 = state_36269__$1;
(statearr_36271_36304[(2)] = inst_36265);

(statearr_36271_36304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36270 === (1))){
var inst_36228 = [];
var inst_36229 = inst_36228;
var inst_36230 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_36269__$1 = (function (){var statearr_36272 = state_36269;
(statearr_36272[(7)] = inst_36229);

(statearr_36272[(8)] = inst_36230);

return statearr_36272;
})();
var statearr_36273_36305 = state_36269__$1;
(statearr_36273_36305[(2)] = null);

(statearr_36273_36305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36270 === (4))){
var inst_36233 = (state_36269[(9)]);
var inst_36233__$1 = (state_36269[(2)]);
var inst_36234 = (inst_36233__$1 == null);
var inst_36235 = cljs.core.not.call(null,inst_36234);
var state_36269__$1 = (function (){var statearr_36274 = state_36269;
(statearr_36274[(9)] = inst_36233__$1);

return statearr_36274;
})();
if(inst_36235){
var statearr_36275_36306 = state_36269__$1;
(statearr_36275_36306[(1)] = (5));

} else {
var statearr_36276_36307 = state_36269__$1;
(statearr_36276_36307[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36270 === (15))){
var inst_36259 = (state_36269[(2)]);
var state_36269__$1 = state_36269;
var statearr_36277_36308 = state_36269__$1;
(statearr_36277_36308[(2)] = inst_36259);

(statearr_36277_36308[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36270 === (13))){
var state_36269__$1 = state_36269;
var statearr_36278_36309 = state_36269__$1;
(statearr_36278_36309[(2)] = null);

(statearr_36278_36309[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36270 === (6))){
var inst_36229 = (state_36269[(7)]);
var inst_36254 = inst_36229.length;
var inst_36255 = (inst_36254 > (0));
var state_36269__$1 = state_36269;
if(cljs.core.truth_(inst_36255)){
var statearr_36279_36310 = state_36269__$1;
(statearr_36279_36310[(1)] = (12));

} else {
var statearr_36280_36311 = state_36269__$1;
(statearr_36280_36311[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36270 === (3))){
var inst_36267 = (state_36269[(2)]);
var state_36269__$1 = state_36269;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36269__$1,inst_36267);
} else {
if((state_val_36270 === (12))){
var inst_36229 = (state_36269[(7)]);
var inst_36257 = cljs.core.vec.call(null,inst_36229);
var state_36269__$1 = state_36269;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_36269__$1,(15),out,inst_36257);
} else {
if((state_val_36270 === (2))){
var state_36269__$1 = state_36269;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36269__$1,(4),ch);
} else {
if((state_val_36270 === (11))){
var inst_36237 = (state_36269[(10)]);
var inst_36233 = (state_36269[(9)]);
var inst_36247 = (state_36269[(2)]);
var inst_36248 = [];
var inst_36249 = inst_36248.push(inst_36233);
var inst_36229 = inst_36248;
var inst_36230 = inst_36237;
var state_36269__$1 = (function (){var statearr_36281 = state_36269;
(statearr_36281[(11)] = inst_36249);

(statearr_36281[(12)] = inst_36247);

(statearr_36281[(7)] = inst_36229);

(statearr_36281[(8)] = inst_36230);

return statearr_36281;
})();
var statearr_36282_36312 = state_36269__$1;
(statearr_36282_36312[(2)] = null);

(statearr_36282_36312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36270 === (9))){
var inst_36229 = (state_36269[(7)]);
var inst_36245 = cljs.core.vec.call(null,inst_36229);
var state_36269__$1 = state_36269;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_36269__$1,(11),out,inst_36245);
} else {
if((state_val_36270 === (5))){
var inst_36237 = (state_36269[(10)]);
var inst_36233 = (state_36269[(9)]);
var inst_36230 = (state_36269[(8)]);
var inst_36237__$1 = f.call(null,inst_36233);
var inst_36238 = cljs.core._EQ_.call(null,inst_36237__$1,inst_36230);
var inst_36239 = cljs.core.keyword_identical_QMARK_.call(null,inst_36230,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_36240 = (inst_36238) || (inst_36239);
var state_36269__$1 = (function (){var statearr_36283 = state_36269;
(statearr_36283[(10)] = inst_36237__$1);

return statearr_36283;
})();
if(cljs.core.truth_(inst_36240)){
var statearr_36284_36313 = state_36269__$1;
(statearr_36284_36313[(1)] = (8));

} else {
var statearr_36285_36314 = state_36269__$1;
(statearr_36285_36314[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36270 === (14))){
var inst_36262 = (state_36269[(2)]);
var inst_36263 = cljs.core.async.close_BANG_.call(null,out);
var state_36269__$1 = (function (){var statearr_36287 = state_36269;
(statearr_36287[(13)] = inst_36262);

return statearr_36287;
})();
var statearr_36288_36315 = state_36269__$1;
(statearr_36288_36315[(2)] = inst_36263);

(statearr_36288_36315[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36270 === (10))){
var inst_36252 = (state_36269[(2)]);
var state_36269__$1 = state_36269;
var statearr_36289_36316 = state_36269__$1;
(statearr_36289_36316[(2)] = inst_36252);

(statearr_36289_36316[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36270 === (8))){
var inst_36237 = (state_36269[(10)]);
var inst_36229 = (state_36269[(7)]);
var inst_36233 = (state_36269[(9)]);
var inst_36242 = inst_36229.push(inst_36233);
var tmp36286 = inst_36229;
var inst_36229__$1 = tmp36286;
var inst_36230 = inst_36237;
var state_36269__$1 = (function (){var statearr_36290 = state_36269;
(statearr_36290[(7)] = inst_36229__$1);

(statearr_36290[(8)] = inst_36230);

(statearr_36290[(14)] = inst_36242);

return statearr_36290;
})();
var statearr_36291_36317 = state_36269__$1;
(statearr_36291_36317[(2)] = null);

(statearr_36291_36317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___36303,out))
;
return ((function (switch__33364__auto__,c__33478__auto___36303,out){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_36295 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36295[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_36295[(1)] = (1));

return statearr_36295;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_36269){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_36269);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e36296){if((e36296 instanceof Object)){
var ex__33368__auto__ = e36296;
var statearr_36297_36318 = state_36269;
(statearr_36297_36318[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36269);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36296;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36319 = state_36269;
state_36269 = G__36319;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_36269){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_36269);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___36303,out))
})();
var state__33480__auto__ = (function (){var statearr_36298 = f__33479__auto__.call(null);
(statearr_36298[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___36303);

return statearr_36298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___36303,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map