// Compiled by ClojureScript 1.9.521 {}
goog.provide('superv.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
superv.async.cljs_env_QMARK_ = (function superv$async$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});

/**
 * @interface
 */
superv.async.PSupervisor = function(){};

superv.async._error = (function superv$async$_error(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_error$arity$1 == null)))){
return this$.superv$async$PSupervisor$_error$arity$1(this$);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._error[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$);
} else {
var m__10138__auto____$1 = (superv.async._error["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-error",this$);
}
}
}
});

superv.async._abort = (function superv$async$_abort(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_abort$arity$1 == null)))){
return this$.superv$async$PSupervisor$_abort$arity$1(this$);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._abort[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$);
} else {
var m__10138__auto____$1 = (superv.async._abort["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-abort",this$);
}
}
}
});

superv.async._register_go = (function superv$async$_register_go(this$,body){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_register_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_register_go$arity$2(this$,body);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._register_go[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,body);
} else {
var m__10138__auto____$1 = (superv.async._register_go["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,body);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-register-go",this$);
}
}
}
});

superv.async._unregister_go = (function superv$async$_unregister_go(this$,id){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_unregister_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_unregister_go$arity$2(this$,id);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._unregister_go[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,id);
} else {
var m__10138__auto____$1 = (superv.async._unregister_go["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-unregister-go",this$);
}
}
}
});

superv.async._track_exception = (function superv$async$_track_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_track_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_track_exception$arity$2(this$,e);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._track_exception[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,e);
} else {
var m__10138__auto____$1 = (superv.async._track_exception["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-track-exception",this$);
}
}
}
});

superv.async._free_exception = (function superv$async$_free_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_free_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_free_exception$arity$2(this$,e);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._free_exception[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,e);
} else {
var m__10138__auto____$1 = (superv.async._free_exception["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-free-exception",this$);
}
}
}
});

superv.async.now = (function superv$async$now(){
return (new Date());
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {superv.async.PSupervisor}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
superv.async.TrackingSupervisor = (function (error,abort,registered,pending_exceptions,__meta,__extmap,__hash){
this.error = error;
this.abort = abort;
this.registered = registered;
this.pending_exceptions = pending_exceptions;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__10094__auto__,k__10095__auto__){
var self__ = this;
var this__10094__auto____$1 = this;
return this__10094__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__10095__auto__,null);
});

superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__10096__auto__,k36323,else__10097__auto__){
var self__ = this;
var this__10096__auto____$1 = this;
var G__36325 = (((k36323 instanceof cljs.core.Keyword))?k36323.fqn:null);
switch (G__36325) {
case "error":
return self__.error;

break;
case "abort":
return self__.abort;

break;
case "registered":
return self__.registered;

break;
case "pending-exceptions":
return self__.pending_exceptions;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k36323,else__10097__auto__);

}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__10108__auto__,writer__10109__auto__,opts__10110__auto__){
var self__ = this;
var this__10108__auto____$1 = this;
var pr_pair__10111__auto__ = ((function (this__10108__auto____$1){
return (function (keyval__10112__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,cljs.core.pr_writer,""," ","",opts__10110__auto__,keyval__10112__auto__);
});})(this__10108__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,pr_pair__10111__auto__,"#superv.async.TrackingSupervisor{",", ","}",opts__10110__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__36322){
var self__ = this;
var G__36322__$1 = this;
return (new cljs.core.RecordIter((0),G__36322__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__10092__auto__){
var self__ = this;
var this__10092__auto____$1 = this;
return self__.__meta;
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__10088__auto__){
var self__ = this;
var this__10088__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__10098__auto__){
var self__ = this;
var this__10098__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__10089__auto__){
var self__ = this;
var this__10089__auto____$1 = this;
var h__9861__auto__ = self__.__hash;
if(!((h__9861__auto__ == null))){
return h__9861__auto__;
} else {
var h__9861__auto____$1 = cljs.core.hash_imap.call(null,this__10089__auto____$1);
self__.__hash = h__9861__auto____$1;

return h__9861__auto____$1;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__10090__auto__,other__10091__auto__){
var self__ = this;
var this__10090__auto____$1 = this;
if(cljs.core.truth_((function (){var and__9407__auto__ = other__10091__auto__;
if(cljs.core.truth_(and__9407__auto__)){
return ((this__10090__auto____$1.constructor === other__10091__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__10090__auto____$1,other__10091__auto__));
} else {
return and__9407__auto__;
}
})())){
return true;
} else {
return false;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__10103__auto__,k__10104__auto__){
var self__ = this;
var this__10103__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),null,new cljs.core.Keyword(null,"abort","abort",521193198),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"registered","registered",-388600037),null], null), null),k__10104__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__10103__auto____$1),self__.__meta),k__10104__auto__);
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__10104__auto__)),null));
}
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_error$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.error;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.abort;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_register_go$arity$2 = (function (this$,body){
var self__ = this;
var this$__$1 = this;
var id = cljs.core.random_uuid.call(null);
cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.assoc,id,body);

return id;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_unregister_go$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.dissoc,id);
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_track_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.assoc,e,superv.async.now.call(null));
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_free_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.dissoc,e);
});

superv.async.TrackingSupervisor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__10101__auto__,k__10102__auto__,G__36322){
var self__ = this;
var this__10101__auto____$1 = this;
var pred__36326 = cljs.core.keyword_identical_QMARK_;
var expr__36327 = k__10102__auto__;
if(cljs.core.truth_(pred__36326.call(null,new cljs.core.Keyword(null,"error","error",-978969032),expr__36327))){
return (new superv.async.TrackingSupervisor(G__36322,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__36326.call(null,new cljs.core.Keyword(null,"abort","abort",521193198),expr__36327))){
return (new superv.async.TrackingSupervisor(self__.error,G__36322,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__36326.call(null,new cljs.core.Keyword(null,"registered","registered",-388600037),expr__36327))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,G__36322,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__36326.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),expr__36327))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,G__36322,self__.__meta,self__.__extmap,null));
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__10102__auto__,G__36322),null));
}
}
}
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__10106__auto__){
var self__ = this;
var this__10106__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__10093__auto__,G__36322){
var self__ = this;
var this__10093__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,G__36322,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__10099__auto__,entry__10100__auto__){
var self__ = this;
var this__10099__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__10100__auto__)){
return this__10099__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__10100__auto__,(0)),cljs.core._nth.call(null,entry__10100__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__10099__auto____$1,entry__10100__auto__);
}
});

superv.async.TrackingSupervisor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.Symbol(null,"abort","abort",-2133242571,null),new cljs.core.Symbol(null,"registered","registered",1251931490,null),new cljs.core.Symbol(null,"pending-exceptions","pending-exceptions",-247748567,null)], null);
});

superv.async.TrackingSupervisor.cljs$lang$type = true;

superv.async.TrackingSupervisor.cljs$lang$ctorPrSeq = (function (this__10130__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"superv.async/TrackingSupervisor");
});

superv.async.TrackingSupervisor.cljs$lang$ctorPrWriter = (function (this__10130__auto__,writer__10131__auto__){
return cljs.core._write.call(null,writer__10131__auto__,"superv.async/TrackingSupervisor");
});

superv.async.__GT_TrackingSupervisor = (function superv$async$__GT_TrackingSupervisor(error,abort,registered,pending_exceptions){
return (new superv.async.TrackingSupervisor(error,abort,registered,pending_exceptions,null,null,null));
});

superv.async.map__GT_TrackingSupervisor = (function superv$async$map__GT_TrackingSupervisor(G__36324){
return (new superv.async.TrackingSupervisor(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(G__36324),new cljs.core.Keyword(null,"abort","abort",521193198).cljs$core$IFn$_invoke$arity$1(G__36324),new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(G__36324),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(G__36324),null,cljs.core.dissoc.call(null,G__36324,new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)),null));
});

cljs.core.enable_console_print_BANG_.call(null);
/**
 * A simple supervisor which deals with errors through callbacks. You need to
 *   close its abort channel manually if you want the context to stop. It is
 *   supposed to be used at a boundary to an unsupervised system. If you want
 *   strong supervision, use the restarting-supervisor instead.
 */
superv.async.simple_supervisor = (function superv$async$simple_supervisor(var_args){
var args__10647__auto__ = [];
var len__10640__auto___36354 = arguments.length;
var i__10641__auto___36355 = (0);
while(true){
if((i__10641__auto___36355 < len__10640__auto___36354)){
args__10647__auto__.push((arguments[i__10641__auto___36355]));

var G__36356 = (i__10641__auto___36355 + (1));
i__10641__auto___36355 = G__36356;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((0) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((0)),(0),null)):null);
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(argseq__10648__auto__);
});

superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (p__36331){
var map__36332 = p__36331;
var map__36332__$1 = ((((!((map__36332 == null)))?((((map__36332.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36332.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36332):map__36332);
var stale_timeout = cljs.core.get.call(null,map__36332__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((10) * (1000)));
var error_fn = cljs.core.get.call(null,map__36332__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),((function (map__36332,map__36332__$1,stale_timeout){
return (function (e){
return cljs.core.println.call(null,"Supervisor:",e,e.stack);
});})(map__36332,map__36332__$1,stale_timeout))
);
var pending_fn = cljs.core.get.call(null,map__36332__$1,new cljs.core.Keyword(null,"pending-fn","pending-fn",1734381755));
var s = superv.async.map__GT_TrackingSupervisor.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"abort","abort",521193198),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"registered","registered",-388600037),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null));
var err_ch = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(s);
cljs.core.async.take_BANG_.call(null,err_ch,((function (s,err_ch,map__36332,map__36332__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$loop_fn(e){
error_fn.call(null,e);

return cljs.core.async.take_BANG_.call(null,err_ch,superv$async$loop_fn);
});})(s,err_ch,map__36332,map__36332__$1,stale_timeout,error_fn,pending_fn))
);

((function (s,err_ch,map__36332,map__36332__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$pending(_){
var vec__36344 = cljs.core.filter.call(null,((function (s,err_ch,map__36332,map__36332__$1,stale_timeout,error_fn,pending_fn){
return (function (p__36350){
var vec__36351 = p__36350;
var k = cljs.core.nth.call(null,vec__36351,(0),null);
var v = cljs.core.nth.call(null,vec__36351,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout) > v.getTime());
});})(s,err_ch,map__36332,map__36332__$1,stale_timeout,error_fn,pending_fn))
,cljs.core.deref.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s)));
var vec__36347 = cljs.core.nth.call(null,vec__36344,(0),null);
var e = cljs.core.nth.call(null,vec__36347,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__36347,(1),null);
if(cljs.core.truth_(e)){
error_fn.call(null,e);

superv.async._free_exception.call(null,s,e);
} else {
}

return cljs.core.async.take_BANG_.call(null,cljs.core.async.timeout.call(null,stale_timeout),superv$async$pending);
});})(s,err_ch,map__36332,map__36332__$1,stale_timeout,error_fn,pending_fn))
.call(null,null);

return s;
});

superv.async.simple_supervisor.cljs$lang$maxFixedArity = (0);

superv.async.simple_supervisor.cljs$lang$applyTo = (function (seq36330){
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36330));
});

superv.async.S = superv.async.simple_supervisor.call(null);
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
superv.async.throw_if_exception = (function superv$async$throw_if_exception(S,x){
if((x instanceof Error)){
superv.async._free_exception.call(null,S,x);

throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),(function (){var or__9419__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
superv.async.superv_init = (function superv$async$superv_init(){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [superv.async._error,superv.async._abort,superv.async._register_go,superv.async._unregister_go,superv.async._track_exception,superv.async._free_exception,superv.async.throw_if_exception], null);
});
goog.exportSymbol('superv.async.superv_init', superv.async.superv_init);
superv.async.superv_init.call(null);
superv.async.supervisor_QMARK_ = (function superv$async$supervisor_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.superv$async$PSupervisor$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
}
});
superv.async.check_supervisor = (function superv$async$check_supervisor(x){
if(cljs.core.truth_(superv.async.supervisor_QMARK_.call(null,x))){
return null;
} else {
throw cljs.core.ex_info.call(null,"First argument is not a supervisor.",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"argument","argument",1183001841),x], null));
}
});
/**
 * Here until http://dev.clojure.org/jira/browse/ASYNC-74 is resolved.
 */
superv.async.chan_QMARK_ = (function superv$async$chan_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$ReadPort$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
}
});
/**
 * Same as core.async/take!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.take_QMARK_ = (function superv$async$take_QMARK_(var_args){
var args36374 = [];
var len__10640__auto___36377 = arguments.length;
var i__10641__auto___36378 = (0);
while(true){
if((i__10641__auto___36378 < len__10640__auto___36377)){
args36374.push((arguments[i__10641__auto___36378]));

var G__36379 = (i__10641__auto___36378 + (1));
i__10641__auto___36378 = G__36379;
continue;
} else {
}
break;
}

var G__36376 = args36374.length;
switch (G__36376) {
case 3:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args36374.length)].join('')));

}
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,fn1){
return superv.async.take_QMARK_.call(null,S,port,fn1,true);
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,fn1,on_caller_QMARK_){
return cljs.core.async.take_BANG_.call(null,port,(function (v){
if((v instanceof Error)){
superv.async._free_exception.call(null,S,v);
} else {
}

return fn1.call(null,v);
}),on_caller_QMARK_);
});

superv.async.take_QMARK_.cljs$lang$maxFixedArity = 4;

/**
 * Same as core.async/put!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.put_QMARK_ = (function superv$async$put_QMARK_(var_args){
var args36381 = [];
var len__10640__auto___36384 = arguments.length;
var i__10641__auto___36385 = (0);
while(true){
if((i__10641__auto___36385 < len__10640__auto___36384)){
args36381.push((arguments[i__10641__auto___36385]));

var G__36386 = (i__10641__auto___36385 + (1));
i__10641__auto___36385 = G__36386;
continue;
} else {
}
break;
}

var G__36383 = args36381.length;
switch (G__36383) {
case 3:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args36381.length)].join('')));

}
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,val){
return superv.async.put_QMARK_.call(null,S,port,val,(function superv$async$noop(_){
return null;
}));
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,val,fn1){
return superv.async.put_QMARK_.call(null,S,port,val,fn1,true);
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5 = (function (S,port,val,fn1,on_caller_QMARK_){
return cljs.core.async.put_BANG_.call(null,port,val,(function (ret){
if(((val instanceof Error)) && (!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,val)),new cljs.core.Keyword(null,"aborted","aborted",1775972619))))){
superv.async._track_exception.call(null,S,val);
} else {
}

return fn1.call(null,ret);
}),on_caller_QMARK_);
});

superv.async.put_QMARK_.cljs$lang$maxFixedArity = 5;

/**
 * Takes objects from in-ch, asynchrously applies function f> (function should
 *   return a channel), takes the result from the returned channel and if it's
 *   truthy, puts it in the out-ch. Returns the closed out-ch. Closes the
 *   returned channel when the input channel has been completely consumed and all
 *   objects have been processed.
 *   If out-ch is not provided, an unbuffered one will be used.
 */
superv.async.pmap_GT__GT_ = (function superv$async$pmap_GT__GT_(var_args){
var args36399 = [];
var len__10640__auto___36602 = arguments.length;
var i__10641__auto___36603 = (0);
while(true){
if((i__10641__auto___36603 < len__10640__auto___36602)){
args36399.push((arguments[i__10641__auto___36603]));

var G__36604 = (i__10641__auto___36603 + (1));
i__10641__auto___36603 = G__36604;
continue;
} else {
}
break;
}

var G__36401 = args36399.length;
switch (G__36401) {
case 4:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args36399.length)].join('')));

}
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4 = (function (S,f_GT_,parallelism,in_ch){
return superv.async.pmap_GT__GT_.call(null,S,f_GT_,parallelism,cljs.core.async.chan.call(null),in_ch);
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5 = (function (S,f_GT_,parallelism,out_ch,in_ch){
if(cljs.core.fn_QMARK_.call(null,f_GT_)){
} else {
throw (new Error("Assert failed: (fn? f>)"));
}

if((cljs.core.integer_QMARK_.call(null,parallelism)) && ((parallelism > (0)))){
} else {
throw (new Error("Assert failed: (and (integer? parallelism) (pos? parallelism))"));
}

if((in_ch instanceof cljs.core.async.impl.protocols.ReadPort)){
} else {
throw (new Error("Assert failed: (instance? ReadPort in-ch)"));
}

var threads = cljs.core.atom.call(null,parallelism);
var n__10440__auto___36606 = parallelism;
var __36607 = (0);
while(true){
if((__36607 < n__10440__auto___36606)){
var c__19190__auto___36608 = superv.async.check_supervisor.call(null,superv.async.S);
var id__19191__auto___36609 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"result","result",-1239343558,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)))], null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null)))))),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"zero?","zero?",325758897,null),cljs.core.list(new cljs.core.Symbol(null,"swap!","swap!",-655677516,null),new cljs.core.Symbol(null,"threads","threads",-77267207,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))));
var c__33478__auto___36610 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__36607,c__33478__auto___36610,c__19190__auto___36608,id__19191__auto___36609,n__10440__auto___36606,threads){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (__36607,c__33478__auto___36610,c__19190__auto___36608,id__19191__auto___36609,n__10440__auto___36606,threads){
return (function (state_36536){
var state_val_36537 = (state_36536[(1)]);
if((state_val_36537 === (7))){
var inst_36405 = (state_36536[(7)]);
var inst_36413 = (state_36536[(2)]);
var state_36536__$1 = (function (){var statearr_36538 = state_36536;
(statearr_36538[(8)] = inst_36413);

return statearr_36538;
})();
var statearr_36539_36611 = state_36536__$1;
(statearr_36539_36611[(2)] = inst_36405);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36536__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (20))){
var inst_36520 = (state_36536[(2)]);
var state_36536__$1 = state_36536;
var statearr_36540_36612 = state_36536__$1;
(statearr_36540_36612[(2)] = inst_36520);

(statearr_36540_36612[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (27))){
var inst_36482 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_36483 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_36484 = cljs.core.PersistentHashMap.fromArrays(inst_36482,inst_36483);
var inst_36485 = cljs.core.ex_info.call(null,"Aborted operations",inst_36484);
var state_36536__$1 = state_36536;
var statearr_36541_36613 = state_36536__$1;
(statearr_36541_36613[(2)] = inst_36485);

(statearr_36541_36613[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (1))){
var state_36536__$1 = state_36536;
var statearr_36542_36614 = state_36536__$1;
(statearr_36542_36614[(2)] = null);

(statearr_36542_36614[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (24))){
var inst_36464 = (state_36536[(2)]);
var inst_36465 = superv.async.throw_if_exception.call(null,S,inst_36464);
var inst_36466 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_36536__$1 = (function (){var statearr_36543 = state_36536;
(statearr_36543[(9)] = inst_36465);

return statearr_36543;
})();
var statearr_36544_36615 = state_36536__$1;
(statearr_36544_36615[(2)] = inst_36466);

(statearr_36544_36615[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (39))){
var state_36536__$1 = state_36536;
var statearr_36545_36616 = state_36536__$1;
(statearr_36545_36616[(2)] = null);

(statearr_36545_36616[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (4))){
var inst_36405 = (state_36536[(7)]);
var inst_36405__$1 = (state_36536[(2)]);
var inst_36406 = cljs.core.ex_data.call(null,inst_36405__$1);
var inst_36407 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_36406);
var inst_36408 = cljs.core._EQ_.call(null,inst_36407,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_36536__$1 = (function (){var statearr_36546 = state_36536;
(statearr_36546[(7)] = inst_36405__$1);

return statearr_36546;
})();
if(inst_36408){
var statearr_36547_36617 = state_36536__$1;
(statearr_36547_36617[(1)] = (5));

} else {
var statearr_36548_36618 = state_36536__$1;
(statearr_36548_36618[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (15))){
var inst_36438 = (state_36536[(10)]);
var inst_36440 = (inst_36438 instanceof Error);
var state_36536__$1 = state_36536;
if(cljs.core.truth_(inst_36440)){
var statearr_36549_36619 = state_36536__$1;
(statearr_36549_36619[(1)] = (18));

} else {
var statearr_36550_36620 = state_36536__$1;
(statearr_36550_36620[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (21))){
var inst_36445 = (state_36536[(11)]);
var inst_36451 = (state_36536[(2)]);
var inst_36452 = cljs.core.nth.call(null,inst_36451,(0),null);
var inst_36453 = cljs.core.nth.call(null,inst_36451,(1),null);
var inst_36454 = cljs.core._EQ_.call(null,inst_36453,inst_36445);
var state_36536__$1 = (function (){var statearr_36551 = state_36536;
(statearr_36551[(12)] = inst_36452);

return statearr_36551;
})();
if(inst_36454){
var statearr_36552_36621 = state_36536__$1;
(statearr_36552_36621[(1)] = (22));

} else {
var statearr_36553_36622 = state_36536__$1;
(statearr_36553_36622[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (31))){
var state_36536__$1 = state_36536;
var statearr_36554_36623 = state_36536__$1;
(statearr_36554_36623[(2)] = null);

(statearr_36554_36623[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (32))){
var inst_36517 = (state_36536[(2)]);
var state_36536__$1 = (function (){var statearr_36555 = state_36536;
(statearr_36555[(13)] = inst_36517);

return statearr_36555;
})();
var statearr_36556_36624 = state_36536__$1;
(statearr_36556_36624[(2)] = null);

(statearr_36556_36624[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (40))){
var inst_36532 = (state_36536[(2)]);
var state_36536__$1 = state_36536;
var statearr_36557_36625 = state_36536__$1;
(statearr_36557_36625[(2)] = inst_36532);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36536__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (33))){
var inst_36494 = (state_36536[(14)]);
var inst_36500 = (state_36536[(2)]);
var inst_36501 = cljs.core.nth.call(null,inst_36500,(0),null);
var inst_36502 = cljs.core.nth.call(null,inst_36500,(1),null);
var inst_36503 = cljs.core._EQ_.call(null,inst_36502,inst_36494);
var state_36536__$1 = (function (){var statearr_36558 = state_36536;
(statearr_36558[(15)] = inst_36501);

return statearr_36558;
})();
if(inst_36503){
var statearr_36559_36626 = state_36536__$1;
(statearr_36559_36626[(1)] = (34));

} else {
var statearr_36560_36627 = state_36536__$1;
(statearr_36560_36627[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (13))){
var inst_36427 = (state_36536[(16)]);
var state_36536__$1 = state_36536;
var statearr_36561_36628 = state_36536__$1;
(statearr_36561_36628[(2)] = inst_36427);

(statearr_36561_36628[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (22))){
var inst_36456 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_36457 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_36458 = cljs.core.PersistentHashMap.fromArrays(inst_36456,inst_36457);
var inst_36459 = cljs.core.ex_info.call(null,"Aborted operations",inst_36458);
var state_36536__$1 = state_36536;
var statearr_36562_36629 = state_36536__$1;
(statearr_36562_36629[(2)] = inst_36459);

(statearr_36562_36629[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (36))){
var inst_36513 = (state_36536[(2)]);
var inst_36514 = superv.async.throw_if_exception.call(null,S,inst_36513);
var state_36536__$1 = state_36536;
var statearr_36563_36630 = state_36536__$1;
(statearr_36563_36630[(2)] = inst_36514);

(statearr_36563_36630[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (29))){
var inst_36489 = (state_36536[(17)]);
var inst_36488 = (state_36536[(2)]);
var inst_36489__$1 = superv.async.throw_if_exception.call(null,S,inst_36488);
var state_36536__$1 = (function (){var statearr_36564 = state_36536;
(statearr_36564[(17)] = inst_36489__$1);

return statearr_36564;
})();
if(cljs.core.truth_(inst_36489__$1)){
var statearr_36565_36631 = state_36536__$1;
(statearr_36565_36631[(1)] = (30));

} else {
var statearr_36566_36632 = state_36536__$1;
(statearr_36566_36632[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (6))){
var inst_36405 = (state_36536[(7)]);
var inst_36411 = superv.async._track_exception.call(null,S,inst_36405);
var state_36536__$1 = state_36536;
var statearr_36567_36633 = state_36536__$1;
(statearr_36567_36633[(2)] = inst_36411);

(statearr_36567_36633[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (28))){
var inst_36478 = (state_36536[(18)]);
var state_36536__$1 = state_36536;
var statearr_36568_36634 = state_36536__$1;
(statearr_36568_36634[(2)] = inst_36478);

(statearr_36568_36634[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (25))){
var inst_36462 = (state_36536[(2)]);
var state_36536__$1 = state_36536;
var statearr_36569_36635 = state_36536__$1;
(statearr_36569_36635[(2)] = inst_36462);

(statearr_36569_36635[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (34))){
var inst_36505 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_36506 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_36507 = cljs.core.PersistentHashMap.fromArrays(inst_36505,inst_36506);
var inst_36508 = cljs.core.ex_info.call(null,"Aborted operations",inst_36507);
var state_36536__$1 = state_36536;
var statearr_36570_36636 = state_36536__$1;
(statearr_36570_36636[(2)] = inst_36508);

(statearr_36570_36636[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (17))){
var inst_36523 = (state_36536[(2)]);
var state_36536__$1 = state_36536;
var statearr_36571_36637 = state_36536__$1;
(statearr_36571_36637[(2)] = inst_36523);

(statearr_36571_36637[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (3))){
var inst_36402 = (state_36536[(2)]);
var inst_36403 = superv.async._unregister_go.call(null,S,id__19191__auto___36609);
var state_36536__$1 = (function (){var statearr_36572 = state_36536;
(statearr_36572[(19)] = inst_36403);

(statearr_36572[(20)] = inst_36402);

return statearr_36572;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36536__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (12))){
var inst_36431 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_36432 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_36433 = cljs.core.PersistentHashMap.fromArrays(inst_36431,inst_36432);
var inst_36434 = cljs.core.ex_info.call(null,"Aborted operations",inst_36433);
var state_36536__$1 = state_36536;
var statearr_36573_36638 = state_36536__$1;
(statearr_36573_36638[(2)] = inst_36434);

(statearr_36573_36638[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (2))){
var inst_36534 = (state_36536[(2)]);
var state_36536__$1 = state_36536;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36536__$1,inst_36534);
} else {
if((state_val_36537 === (23))){
var inst_36438 = (state_36536[(10)]);
var state_36536__$1 = state_36536;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_36536__$1,(25),out_ch,inst_36438);
} else {
if((state_val_36537 === (35))){
var inst_36489 = (state_36536[(17)]);
var state_36536__$1 = state_36536;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_36536__$1,(37),out_ch,inst_36489);
} else {
if((state_val_36537 === (19))){
var inst_36471 = (state_36536[(21)]);
var inst_36438 = (state_36536[(10)]);
var inst_36471__$1 = superv.async._abort.call(null,S);
var inst_36472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36473 = f_GT_.call(null,inst_36438);
var inst_36474 = [inst_36471__$1,inst_36473];
var inst_36475 = (new cljs.core.PersistentVector(null,2,(5),inst_36472,inst_36474,null));
var state_36536__$1 = (function (){var statearr_36574 = state_36536;
(statearr_36574[(21)] = inst_36471__$1);

return statearr_36574;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_36536__$1,(26),inst_36475,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_36537 === (11))){
var inst_36421 = (state_36536[(22)]);
var inst_36426 = (state_36536[(2)]);
var inst_36427 = cljs.core.nth.call(null,inst_36426,(0),null);
var inst_36428 = cljs.core.nth.call(null,inst_36426,(1),null);
var inst_36429 = cljs.core._EQ_.call(null,inst_36428,inst_36421);
var state_36536__$1 = (function (){var statearr_36575 = state_36536;
(statearr_36575[(16)] = inst_36427);

return statearr_36575;
})();
if(inst_36429){
var statearr_36576_36639 = state_36536__$1;
(statearr_36576_36639[(1)] = (12));

} else {
var statearr_36577_36640 = state_36536__$1;
(statearr_36577_36640[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (9))){
var inst_36421 = (state_36536[(22)]);
var inst_36421__$1 = superv.async._abort.call(null,S);
var inst_36422 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36423 = [inst_36421__$1,in_ch];
var inst_36424 = (new cljs.core.PersistentVector(null,2,(5),inst_36422,inst_36423,null));
var state_36536__$1 = (function (){var statearr_36578 = state_36536;
(statearr_36578[(22)] = inst_36421__$1);

return statearr_36578;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_36536__$1,(11),inst_36424,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_36537 === (5))){
var state_36536__$1 = state_36536;
var statearr_36579_36641 = state_36536__$1;
(statearr_36579_36641[(2)] = null);

(statearr_36579_36641[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (14))){
var inst_36438 = (state_36536[(10)]);
var inst_36437 = (state_36536[(2)]);
var inst_36438__$1 = superv.async.throw_if_exception.call(null,S,inst_36437);
var state_36536__$1 = (function (){var statearr_36580 = state_36536;
(statearr_36580[(10)] = inst_36438__$1);

return statearr_36580;
})();
if(cljs.core.truth_(inst_36438__$1)){
var statearr_36581_36642 = state_36536__$1;
(statearr_36581_36642[(1)] = (15));

} else {
var statearr_36582_36643 = state_36536__$1;
(statearr_36582_36643[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (26))){
var inst_36471 = (state_36536[(21)]);
var inst_36477 = (state_36536[(2)]);
var inst_36478 = cljs.core.nth.call(null,inst_36477,(0),null);
var inst_36479 = cljs.core.nth.call(null,inst_36477,(1),null);
var inst_36480 = cljs.core._EQ_.call(null,inst_36479,inst_36471);
var state_36536__$1 = (function (){var statearr_36583 = state_36536;
(statearr_36583[(18)] = inst_36478);

return statearr_36583;
})();
if(inst_36480){
var statearr_36584_36644 = state_36536__$1;
(statearr_36584_36644[(1)] = (27));

} else {
var statearr_36585_36645 = state_36536__$1;
(statearr_36585_36645[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (16))){
var state_36536__$1 = state_36536;
var statearr_36586_36646 = state_36536__$1;
(statearr_36586_36646[(2)] = null);

(statearr_36586_36646[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (38))){
var inst_36529 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_36536__$1 = state_36536;
var statearr_36587_36647 = state_36536__$1;
(statearr_36587_36647[(2)] = inst_36529);

(statearr_36587_36647[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (30))){
var inst_36494 = (state_36536[(14)]);
var inst_36494__$1 = superv.async._abort.call(null,S);
var inst_36495 = cljs.core.async.timeout.call(null,(0));
var inst_36496 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36497 = [inst_36494__$1,inst_36495];
var inst_36498 = (new cljs.core.PersistentVector(null,2,(5),inst_36496,inst_36497,null));
var state_36536__$1 = (function (){var statearr_36588 = state_36536;
(statearr_36588[(14)] = inst_36494__$1);

return statearr_36588;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_36536__$1,(33),inst_36498,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_36537 === (10))){
var inst_36525 = (state_36536[(2)]);
var inst_36526 = cljs.core.swap_BANG_.call(null,threads,cljs.core.dec);
var inst_36527 = (inst_36526 === (0));
var state_36536__$1 = (function (){var statearr_36589 = state_36536;
(statearr_36589[(23)] = inst_36525);

return statearr_36589;
})();
if(cljs.core.truth_(inst_36527)){
var statearr_36590_36648 = state_36536__$1;
(statearr_36590_36648[(1)] = (38));

} else {
var statearr_36591_36649 = state_36536__$1;
(statearr_36591_36649[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (18))){
var inst_36445 = (state_36536[(11)]);
var inst_36445__$1 = superv.async._abort.call(null,S);
var inst_36446 = cljs.core.async.timeout.call(null,(0));
var inst_36447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36448 = [inst_36445__$1,inst_36446];
var inst_36449 = (new cljs.core.PersistentVector(null,2,(5),inst_36447,inst_36448,null));
var state_36536__$1 = (function (){var statearr_36592 = state_36536;
(statearr_36592[(11)] = inst_36445__$1);

return statearr_36592;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_36536__$1,(21),inst_36449,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_36537 === (37))){
var inst_36511 = (state_36536[(2)]);
var state_36536__$1 = state_36536;
var statearr_36593_36650 = state_36536__$1;
(statearr_36593_36650[(2)] = inst_36511);

(statearr_36593_36650[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36537 === (8))){
var ___$1 = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_36536,(4),Error,(3),(2));
var state_36536__$1 = state_36536;
var statearr_36594_36651 = state_36536__$1;
(statearr_36594_36651[(2)] = null);

(statearr_36594_36651[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(__36607,c__33478__auto___36610,c__19190__auto___36608,id__19191__auto___36609,n__10440__auto___36606,threads))
;
return ((function (__36607,switch__33364__auto__,c__33478__auto___36610,c__19190__auto___36608,id__19191__auto___36609,n__10440__auto___36606,threads){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_36598 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36598[(0)] = superv$async$state_machine__33365__auto__);

(statearr_36598[(1)] = (1));

return statearr_36598;
});
var superv$async$state_machine__33365__auto____1 = (function (state_36536){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_36536);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e36599){if((e36599 instanceof Object)){
var ex__33368__auto__ = e36599;
var statearr_36600_36652 = state_36536;
(statearr_36600_36652[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36536);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36599;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36653 = state_36536;
state_36536 = G__36653;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_36536){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_36536);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(__36607,switch__33364__auto__,c__33478__auto___36610,c__19190__auto___36608,id__19191__auto___36609,n__10440__auto___36606,threads))
})();
var state__33480__auto__ = (function (){var statearr_36601 = f__33479__auto__.call(null);
(statearr_36601[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___36610);

return statearr_36601;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(__36607,c__33478__auto___36610,c__19190__auto___36608,id__19191__auto___36609,n__10440__auto___36606,threads))
);


var G__36654 = (__36607 + (1));
__36607 = G__36654;
continue;
} else {
}
break;
}

return out_ch;
});

superv.async.pmap_GT__GT_.cljs$lang$maxFixedArity = 5;

/**
 * Similiar to dorun. Simply takes messages from channels but does nothing with
 *   them. Returns channel that will close when all messages have been consumed.
 */
superv.async.engulf = (function superv$async$engulf(var_args){
var args__10647__auto__ = [];
var len__10640__auto___36735 = arguments.length;
var i__10641__auto___36736 = (0);
while(true){
if((i__10641__auto___36736 < len__10640__auto___36735)){
args__10647__auto__.push((arguments[i__10641__auto___36736]));

var G__36737 = (i__10641__auto___36736 + (1));
i__10641__auto___36736 = G__36737;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var ch = cljs.core.async.merge.call(null,cs);
var c__19190__auto__ = superv.async.check_supervisor.call(null,superv.async.S);
var id__19191__auto__ = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null))))));
var c__33478__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto__,c__19190__auto__,id__19191__auto__,ch){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto__,c__19190__auto__,id__19191__auto__,ch){
return (function (state_36704){
var state_val_36705 = (state_36704[(1)]);
if((state_val_36705 === (7))){
var inst_36660 = (state_36704[(7)]);
var inst_36668 = (state_36704[(2)]);
var state_36704__$1 = (function (){var statearr_36706 = state_36704;
(statearr_36706[(8)] = inst_36668);

return statearr_36706;
})();
var statearr_36707_36738 = state_36704__$1;
(statearr_36707_36738[(2)] = inst_36660);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36704__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36705 === (1))){
var state_36704__$1 = state_36704;
var statearr_36708_36739 = state_36704__$1;
(statearr_36708_36739[(2)] = null);

(statearr_36708_36739[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36705 === (4))){
var inst_36660 = (state_36704[(7)]);
var inst_36660__$1 = (state_36704[(2)]);
var inst_36661 = cljs.core.ex_data.call(null,inst_36660__$1);
var inst_36662 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_36661);
var inst_36663 = cljs.core._EQ_.call(null,inst_36662,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_36704__$1 = (function (){var statearr_36709 = state_36704;
(statearr_36709[(7)] = inst_36660__$1);

return statearr_36709;
})();
if(inst_36663){
var statearr_36710_36740 = state_36704__$1;
(statearr_36710_36740[(1)] = (5));

} else {
var statearr_36711_36741 = state_36704__$1;
(statearr_36711_36741[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36705 === (15))){
var state_36704__$1 = state_36704;
var statearr_36712_36742 = state_36704__$1;
(statearr_36712_36742[(2)] = null);

(statearr_36712_36742[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36705 === (13))){
var inst_36682 = (state_36704[(9)]);
var state_36704__$1 = state_36704;
var statearr_36713_36743 = state_36704__$1;
(statearr_36713_36743[(2)] = inst_36682);

(statearr_36713_36743[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36705 === (6))){
var inst_36660 = (state_36704[(7)]);
var inst_36666 = superv.async._track_exception.call(null,S,inst_36660);
var state_36704__$1 = state_36704;
var statearr_36714_36744 = state_36704__$1;
(statearr_36714_36744[(2)] = inst_36666);

(statearr_36714_36744[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36705 === (17))){
var inst_36698 = (state_36704[(2)]);
var state_36704__$1 = state_36704;
var statearr_36715_36745 = state_36704__$1;
(statearr_36715_36745[(2)] = inst_36698);

(statearr_36715_36745[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36705 === (3))){
var inst_36657 = (state_36704[(2)]);
var inst_36658 = superv.async._unregister_go.call(null,S,id__19191__auto__);
var state_36704__$1 = (function (){var statearr_36716 = state_36704;
(statearr_36716[(10)] = inst_36657);

(statearr_36716[(11)] = inst_36658);

return statearr_36716;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36704__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36705 === (12))){
var inst_36686 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_36687 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_36688 = cljs.core.PersistentHashMap.fromArrays(inst_36686,inst_36687);
var inst_36689 = cljs.core.ex_info.call(null,"Aborted operations",inst_36688);
var state_36704__$1 = state_36704;
var statearr_36717_36746 = state_36704__$1;
(statearr_36717_36746[(2)] = inst_36689);

(statearr_36717_36746[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36705 === (2))){
var inst_36702 = (state_36704[(2)]);
var state_36704__$1 = state_36704;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36704__$1,inst_36702);
} else {
if((state_val_36705 === (11))){
var inst_36676 = (state_36704[(12)]);
var inst_36681 = (state_36704[(2)]);
var inst_36682 = cljs.core.nth.call(null,inst_36681,(0),null);
var inst_36683 = cljs.core.nth.call(null,inst_36681,(1),null);
var inst_36684 = cljs.core._EQ_.call(null,inst_36683,inst_36676);
var state_36704__$1 = (function (){var statearr_36718 = state_36704;
(statearr_36718[(9)] = inst_36682);

return statearr_36718;
})();
if(inst_36684){
var statearr_36719_36747 = state_36704__$1;
(statearr_36719_36747[(1)] = (12));

} else {
var statearr_36720_36748 = state_36704__$1;
(statearr_36720_36748[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36705 === (9))){
var inst_36676 = (state_36704[(12)]);
var inst_36676__$1 = superv.async._abort.call(null,S);
var inst_36677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36678 = [inst_36676__$1,ch];
var inst_36679 = (new cljs.core.PersistentVector(null,2,(5),inst_36677,inst_36678,null));
var state_36704__$1 = (function (){var statearr_36721 = state_36704;
(statearr_36721[(12)] = inst_36676__$1);

return statearr_36721;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_36704__$1,(11),inst_36679,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_36705 === (5))){
var state_36704__$1 = state_36704;
var statearr_36722_36749 = state_36704__$1;
(statearr_36722_36749[(2)] = null);

(statearr_36722_36749[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36705 === (14))){
var inst_36692 = (state_36704[(2)]);
var inst_36693 = superv.async.throw_if_exception.call(null,S,inst_36692);
var state_36704__$1 = state_36704;
if(cljs.core.truth_(inst_36693)){
var statearr_36723_36750 = state_36704__$1;
(statearr_36723_36750[(1)] = (15));

} else {
var statearr_36724_36751 = state_36704__$1;
(statearr_36724_36751[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36705 === (16))){
var state_36704__$1 = state_36704;
var statearr_36725_36752 = state_36704__$1;
(statearr_36725_36752[(2)] = null);

(statearr_36725_36752[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36705 === (10))){
var inst_36700 = (state_36704[(2)]);
var state_36704__$1 = state_36704;
var statearr_36726_36753 = state_36704__$1;
(statearr_36726_36753[(2)] = inst_36700);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36704__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36705 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_36704,(4),Error,(3),(2));
var state_36704__$1 = state_36704;
var statearr_36727_36754 = state_36704__$1;
(statearr_36727_36754[(2)] = null);

(statearr_36727_36754[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto__,c__19190__auto__,id__19191__auto__,ch))
;
return ((function (switch__33364__auto__,c__33478__auto__,c__19190__auto__,id__19191__auto__,ch){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_36731 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36731[(0)] = superv$async$state_machine__33365__auto__);

(statearr_36731[(1)] = (1));

return statearr_36731;
});
var superv$async$state_machine__33365__auto____1 = (function (state_36704){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_36704);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e36732){if((e36732 instanceof Object)){
var ex__33368__auto__ = e36732;
var statearr_36733_36755 = state_36704;
(statearr_36733_36755[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36704);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36732;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36756 = state_36704;
state_36704 = G__36756;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_36704){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_36704);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto__,c__19190__auto__,id__19191__auto__,ch))
})();
var state__33480__auto__ = (function (){var statearr_36734 = f__33479__auto__.call(null);
(statearr_36734[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto__);

return statearr_36734;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto__,c__19190__auto__,id__19191__auto__,ch))
);

return c__33478__auto__;
});

superv.async.engulf.cljs$lang$maxFixedArity = (1);

superv.async.engulf.cljs$lang$applyTo = (function (seq36655){
var G__36656 = cljs.core.first.call(null,seq36655);
var seq36655__$1 = cljs.core.next.call(null,seq36655);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic(G__36656,seq36655__$1);
});

/**
 * Performs a reduce on objects from ch with the function f> (which
 *   should return a channel). Returns a channel with the resulting
 *   value.
 */
superv.async.reduce_GT_ = (function superv$async$reduce_GT_(S,f_GT_,acc,ch){
var result = cljs.core.async.chan.call(null);
var c__19190__auto___37123 = superv.async.check_supervisor.call(null,superv.async.S);
var id__19191__auto___37124 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"->>","->>",-1874332161,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null)),new cljs.core.Symbol(null,"recur","recur",1202958259,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null)))))));
var c__33478__auto___37125 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___37125,c__19190__auto___37123,id__19191__auto___37124,result){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___37125,c__19190__auto___37123,id__19191__auto___37124,result){
return (function (state_37065){
var state_val_37066 = (state_37065[(1)]);
if((state_val_37066 === (7))){
var inst_36943 = (state_37065[(7)]);
var inst_36951 = (state_37065[(2)]);
var state_37065__$1 = (function (){var statearr_37067 = state_37065;
(statearr_37067[(8)] = inst_36951);

return statearr_37067;
})();
var statearr_37068_37126 = state_37065__$1;
(statearr_37068_37126[(2)] = inst_36943);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37065__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (20))){
var inst_37031 = (state_37065[(2)]);
var state_37065__$1 = state_37065;
var statearr_37069_37127 = state_37065__$1;
(statearr_37069_37127[(2)] = inst_37031);

(statearr_37069_37127[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (27))){
var inst_37021 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_37022 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_37023 = cljs.core.PersistentHashMap.fromArrays(inst_37021,inst_37022);
var inst_37024 = cljs.core.ex_info.call(null,"Aborted operations",inst_37023);
var state_37065__$1 = state_37065;
var statearr_37070_37128 = state_37065__$1;
(statearr_37070_37128[(2)] = inst_37024);

(statearr_37070_37128[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (1))){
var state_37065__$1 = state_37065;
var statearr_37071_37129 = state_37065__$1;
(statearr_37071_37129[(2)] = null);

(statearr_37071_37129[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (24))){
var inst_37003 = (state_37065[(2)]);
var inst_37004 = superv.async.throw_if_exception.call(null,S,inst_37003);
var inst_37005 = cljs.core.async.close_BANG_.call(null,result);
var state_37065__$1 = (function (){var statearr_37072 = state_37065;
(statearr_37072[(9)] = inst_37004);

return statearr_37072;
})();
var statearr_37073_37130 = state_37065__$1;
(statearr_37073_37130[(2)] = inst_37005);

(statearr_37073_37130[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (4))){
var inst_36943 = (state_37065[(7)]);
var inst_36943__$1 = (state_37065[(2)]);
var inst_36944 = cljs.core.ex_data.call(null,inst_36943__$1);
var inst_36945 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_36944);
var inst_36946 = cljs.core._EQ_.call(null,inst_36945,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_37065__$1 = (function (){var statearr_37074 = state_37065;
(statearr_37074[(7)] = inst_36943__$1);

return statearr_37074;
})();
if(inst_36946){
var statearr_37075_37131 = state_37065__$1;
(statearr_37075_37131[(1)] = (5));

} else {
var statearr_37076_37132 = state_37065__$1;
(statearr_37076_37132[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (15))){
var inst_36977 = (state_37065[(10)]);
var inst_36979 = (inst_36977 instanceof Error);
var state_37065__$1 = state_37065;
if(cljs.core.truth_(inst_36979)){
var statearr_37077_37133 = state_37065__$1;
(statearr_37077_37133[(1)] = (18));

} else {
var statearr_37078_37134 = state_37065__$1;
(statearr_37078_37134[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (21))){
var inst_36984 = (state_37065[(11)]);
var inst_36990 = (state_37065[(2)]);
var inst_36991 = cljs.core.nth.call(null,inst_36990,(0),null);
var inst_36992 = cljs.core.nth.call(null,inst_36990,(1),null);
var inst_36993 = cljs.core._EQ_.call(null,inst_36992,inst_36984);
var state_37065__$1 = (function (){var statearr_37079 = state_37065;
(statearr_37079[(12)] = inst_36991);

return statearr_37079;
})();
if(inst_36993){
var statearr_37080_37135 = state_37065__$1;
(statearr_37080_37135[(1)] = (22));

} else {
var statearr_37081_37136 = state_37065__$1;
(statearr_37081_37136[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (31))){
var inst_37047 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_37048 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_37049 = cljs.core.PersistentHashMap.fromArrays(inst_37047,inst_37048);
var inst_37050 = cljs.core.ex_info.call(null,"Aborted operations",inst_37049);
var state_37065__$1 = state_37065;
var statearr_37082_37137 = state_37065__$1;
(statearr_37082_37137[(2)] = inst_37050);

(statearr_37082_37137[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (32))){
var inst_36955 = (state_37065[(13)]);
var state_37065__$1 = state_37065;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_37065__$1,(34),result,inst_36955);
} else {
if((state_val_37066 === (33))){
var inst_37055 = (state_37065[(2)]);
var inst_37056 = superv.async.throw_if_exception.call(null,S,inst_37055);
var inst_37057 = cljs.core.async.close_BANG_.call(null,result);
var state_37065__$1 = (function (){var statearr_37083 = state_37065;
(statearr_37083[(14)] = inst_37056);

return statearr_37083;
})();
var statearr_37084_37138 = state_37065__$1;
(statearr_37084_37138[(2)] = inst_37057);

(statearr_37084_37138[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (13))){
var inst_36966 = (state_37065[(15)]);
var state_37065__$1 = state_37065;
var statearr_37085_37139 = state_37065__$1;
(statearr_37085_37139[(2)] = inst_36966);

(statearr_37085_37139[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (22))){
var inst_36995 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_36996 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_36997 = cljs.core.PersistentHashMap.fromArrays(inst_36995,inst_36996);
var inst_36998 = cljs.core.ex_info.call(null,"Aborted operations",inst_36997);
var state_37065__$1 = state_37065;
var statearr_37086_37140 = state_37065__$1;
(statearr_37086_37140[(2)] = inst_36998);

(statearr_37086_37140[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (29))){
var inst_37027 = (state_37065[(2)]);
var inst_37028 = superv.async.throw_if_exception.call(null,S,inst_37027);
var inst_36955 = inst_37028;
var state_37065__$1 = (function (){var statearr_37087 = state_37065;
(statearr_37087[(13)] = inst_36955);

return statearr_37087;
})();
var statearr_37088_37141 = state_37065__$1;
(statearr_37088_37141[(2)] = null);

(statearr_37088_37141[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (6))){
var inst_36943 = (state_37065[(7)]);
var inst_36949 = superv.async._track_exception.call(null,S,inst_36943);
var state_37065__$1 = state_37065;
var statearr_37089_37142 = state_37065__$1;
(statearr_37089_37142[(2)] = inst_36949);

(statearr_37089_37142[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (28))){
var inst_37017 = (state_37065[(16)]);
var state_37065__$1 = state_37065;
var statearr_37090_37143 = state_37065__$1;
(statearr_37090_37143[(2)] = inst_37017);

(statearr_37090_37143[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (25))){
var inst_37001 = (state_37065[(2)]);
var state_37065__$1 = state_37065;
var statearr_37091_37144 = state_37065__$1;
(statearr_37091_37144[(2)] = inst_37001);

(statearr_37091_37144[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (34))){
var inst_37053 = (state_37065[(2)]);
var state_37065__$1 = state_37065;
var statearr_37092_37145 = state_37065__$1;
(statearr_37092_37145[(2)] = inst_37053);

(statearr_37092_37145[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (17))){
var inst_37059 = (state_37065[(2)]);
var state_37065__$1 = state_37065;
var statearr_37093_37146 = state_37065__$1;
(statearr_37093_37146[(2)] = inst_37059);

(statearr_37093_37146[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (3))){
var inst_36940 = (state_37065[(2)]);
var inst_36941 = superv.async._unregister_go.call(null,S,id__19191__auto___37124);
var state_37065__$1 = (function (){var statearr_37094 = state_37065;
(statearr_37094[(17)] = inst_36940);

(statearr_37094[(18)] = inst_36941);

return statearr_37094;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37065__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (12))){
var inst_36970 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_36971 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_36972 = cljs.core.PersistentHashMap.fromArrays(inst_36970,inst_36971);
var inst_36973 = cljs.core.ex_info.call(null,"Aborted operations",inst_36972);
var state_37065__$1 = state_37065;
var statearr_37095_37147 = state_37065__$1;
(statearr_37095_37147[(2)] = inst_36973);

(statearr_37095_37147[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (2))){
var inst_37063 = (state_37065[(2)]);
var state_37065__$1 = state_37065;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37065__$1,inst_37063);
} else {
if((state_val_37066 === (23))){
var inst_36977 = (state_37065[(10)]);
var state_37065__$1 = state_37065;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_37065__$1,(25),result,inst_36977);
} else {
if((state_val_37066 === (19))){
var inst_37010 = (state_37065[(19)]);
var inst_36977 = (state_37065[(10)]);
var inst_36955 = (state_37065[(13)]);
var inst_37010__$1 = superv.async._abort.call(null,S);
var inst_37011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37012 = f_GT_.call(null,inst_36955,inst_36977);
var inst_37013 = [inst_37010__$1,inst_37012];
var inst_37014 = (new cljs.core.PersistentVector(null,2,(5),inst_37011,inst_37013,null));
var state_37065__$1 = (function (){var statearr_37096 = state_37065;
(statearr_37096[(19)] = inst_37010__$1);

return statearr_37096;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_37065__$1,(26),inst_37014,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_37066 === (11))){
var inst_36960 = (state_37065[(20)]);
var inst_36965 = (state_37065[(2)]);
var inst_36966 = cljs.core.nth.call(null,inst_36965,(0),null);
var inst_36967 = cljs.core.nth.call(null,inst_36965,(1),null);
var inst_36968 = cljs.core._EQ_.call(null,inst_36967,inst_36960);
var state_37065__$1 = (function (){var statearr_37097 = state_37065;
(statearr_37097[(15)] = inst_36966);

return statearr_37097;
})();
if(inst_36968){
var statearr_37098_37148 = state_37065__$1;
(statearr_37098_37148[(1)] = (12));

} else {
var statearr_37099_37149 = state_37065__$1;
(statearr_37099_37149[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (9))){
var inst_36960 = (state_37065[(20)]);
var inst_36960__$1 = superv.async._abort.call(null,S);
var inst_36961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36962 = [inst_36960__$1,ch];
var inst_36963 = (new cljs.core.PersistentVector(null,2,(5),inst_36961,inst_36962,null));
var state_37065__$1 = (function (){var statearr_37100 = state_37065;
(statearr_37100[(20)] = inst_36960__$1);

return statearr_37100;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_37065__$1,(11),inst_36963,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_37066 === (5))){
var state_37065__$1 = state_37065;
var statearr_37101_37150 = state_37065__$1;
(statearr_37101_37150[(2)] = null);

(statearr_37101_37150[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (14))){
var inst_36977 = (state_37065[(10)]);
var inst_36976 = (state_37065[(2)]);
var inst_36977__$1 = superv.async.throw_if_exception.call(null,S,inst_36976);
var state_37065__$1 = (function (){var statearr_37102 = state_37065;
(statearr_37102[(10)] = inst_36977__$1);

return statearr_37102;
})();
if(cljs.core.truth_(inst_36977__$1)){
var statearr_37103_37151 = state_37065__$1;
(statearr_37103_37151[(1)] = (15));

} else {
var statearr_37104_37152 = state_37065__$1;
(statearr_37104_37152[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (26))){
var inst_37010 = (state_37065[(19)]);
var inst_37016 = (state_37065[(2)]);
var inst_37017 = cljs.core.nth.call(null,inst_37016,(0),null);
var inst_37018 = cljs.core.nth.call(null,inst_37016,(1),null);
var inst_37019 = cljs.core._EQ_.call(null,inst_37018,inst_37010);
var state_37065__$1 = (function (){var statearr_37105 = state_37065;
(statearr_37105[(16)] = inst_37017);

return statearr_37105;
})();
if(inst_37019){
var statearr_37106_37153 = state_37065__$1;
(statearr_37106_37153[(1)] = (27));

} else {
var statearr_37107_37154 = state_37065__$1;
(statearr_37107_37154[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (16))){
var inst_37036 = (state_37065[(21)]);
var inst_37036__$1 = superv.async._abort.call(null,S);
var inst_37037 = cljs.core.async.timeout.call(null,(0));
var inst_37038 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37039 = [inst_37036__$1,inst_37037];
var inst_37040 = (new cljs.core.PersistentVector(null,2,(5),inst_37038,inst_37039,null));
var state_37065__$1 = (function (){var statearr_37108 = state_37065;
(statearr_37108[(21)] = inst_37036__$1);

return statearr_37108;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_37065__$1,(30),inst_37040,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_37066 === (30))){
var inst_37036 = (state_37065[(21)]);
var inst_37042 = (state_37065[(2)]);
var inst_37043 = cljs.core.nth.call(null,inst_37042,(0),null);
var inst_37044 = cljs.core.nth.call(null,inst_37042,(1),null);
var inst_37045 = cljs.core._EQ_.call(null,inst_37044,inst_37036);
var state_37065__$1 = (function (){var statearr_37109 = state_37065;
(statearr_37109[(22)] = inst_37043);

return statearr_37109;
})();
if(inst_37045){
var statearr_37110_37155 = state_37065__$1;
(statearr_37110_37155[(1)] = (31));

} else {
var statearr_37111_37156 = state_37065__$1;
(statearr_37111_37156[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (10))){
var inst_37061 = (state_37065[(2)]);
var state_37065__$1 = state_37065;
var statearr_37112_37157 = state_37065__$1;
(statearr_37112_37157[(2)] = inst_37061);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37065__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37066 === (18))){
var inst_36984 = (state_37065[(11)]);
var inst_36984__$1 = superv.async._abort.call(null,S);
var inst_36985 = cljs.core.async.timeout.call(null,(0));
var inst_36986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36987 = [inst_36984__$1,inst_36985];
var inst_36988 = (new cljs.core.PersistentVector(null,2,(5),inst_36986,inst_36987,null));
var state_37065__$1 = (function (){var statearr_37113 = state_37065;
(statearr_37113[(11)] = inst_36984__$1);

return statearr_37113;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_37065__$1,(21),inst_36988,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_37066 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_37065,(4),Error,(3),(2));
var inst_36955 = acc;
var state_37065__$1 = (function (){var statearr_37114 = state_37065;
(statearr_37114[(13)] = inst_36955);

return statearr_37114;
})();
var statearr_37115_37158 = state_37065__$1;
(statearr_37115_37158[(2)] = null);

(statearr_37115_37158[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___37125,c__19190__auto___37123,id__19191__auto___37124,result))
;
return ((function (switch__33364__auto__,c__33478__auto___37125,c__19190__auto___37123,id__19191__auto___37124,result){
return (function() {
var superv$async$reduce_GT__$_state_machine__33365__auto__ = null;
var superv$async$reduce_GT__$_state_machine__33365__auto____0 = (function (){
var statearr_37119 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37119[(0)] = superv$async$reduce_GT__$_state_machine__33365__auto__);

(statearr_37119[(1)] = (1));

return statearr_37119;
});
var superv$async$reduce_GT__$_state_machine__33365__auto____1 = (function (state_37065){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_37065);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e37120){if((e37120 instanceof Object)){
var ex__33368__auto__ = e37120;
var statearr_37121_37159 = state_37065;
(statearr_37121_37159[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37065);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37120;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37160 = state_37065;
state_37065 = G__37160;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$reduce_GT__$_state_machine__33365__auto__ = function(state_37065){
switch(arguments.length){
case 0:
return superv$async$reduce_GT__$_state_machine__33365__auto____0.call(this);
case 1:
return superv$async$reduce_GT__$_state_machine__33365__auto____1.call(this,state_37065);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$reduce_GT__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$reduce_GT__$_state_machine__33365__auto____0;
superv$async$reduce_GT__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$reduce_GT__$_state_machine__33365__auto____1;
return superv$async$reduce_GT__$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___37125,c__19190__auto___37123,id__19191__auto___37124,result))
})();
var state__33480__auto__ = (function (){var statearr_37122 = f__33479__auto__.call(null);
(statearr_37122[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___37125);

return statearr_37122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___37125,c__19190__auto___37123,id__19191__auto___37124,result))
);


return result;
});
/**
 * Concatenates two or more channels. First takes all values from first channel
 *   and supplies to output channel, then takes all values from second channel and
 *   so on. Similiar to core.async/merge but maintains the order of values.
 */
superv.async.concat_GT__GT_ = (function superv$async$concat_GT__GT_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___37290 = arguments.length;
var i__10641__auto___37291 = (0);
while(true){
if((i__10641__auto___37291 < len__10640__auto___37290)){
args__10647__auto__.push((arguments[i__10641__auto___37291]));

var G__37292 = (i__10641__auto___37291 + (1));
i__10641__auto___37291 = G__37292;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var out = cljs.core.async.chan.call(null);
var c__19190__auto___37293 = superv.async.check_supervisor.call(null,superv.async.S);
var id__19191__auto___37294 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"c","c",-122660552,null),cljs.core.list(new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"c","c",-122660552,null))], null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"v","v",1661996586,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.list(new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null))))));
var c__33478__auto___37295 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___37295,c__19190__auto___37293,id__19191__auto___37294,out){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___37295,c__19190__auto___37293,id__19191__auto___37294,out){
return (function (state_37243){
var state_val_37244 = (state_37243[(1)]);
if((state_val_37244 === (7))){
var inst_37166 = (state_37243[(7)]);
var inst_37174 = (state_37243[(2)]);
var state_37243__$1 = (function (){var statearr_37246 = state_37243;
(statearr_37246[(8)] = inst_37174);

return statearr_37246;
})();
var statearr_37247_37296 = state_37243__$1;
(statearr_37247_37296[(2)] = inst_37166);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37243__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (20))){
var inst_37233 = (state_37243[(2)]);
var state_37243__$1 = state_37243;
var statearr_37248_37297 = state_37243__$1;
(statearr_37248_37297[(2)] = inst_37233);

(statearr_37248_37297[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (1))){
var state_37243__$1 = state_37243;
var statearr_37249_37298 = state_37243__$1;
(statearr_37249_37298[(2)] = null);

(statearr_37249_37298[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (24))){
var inst_37178 = (state_37243[(9)]);
var inst_37226 = (state_37243[(2)]);
var inst_37227 = superv.async.throw_if_exception.call(null,S,inst_37226);
var tmp37245 = inst_37178;
var inst_37178__$1 = tmp37245;
var state_37243__$1 = (function (){var statearr_37250 = state_37243;
(statearr_37250[(9)] = inst_37178__$1);

(statearr_37250[(10)] = inst_37227);

return statearr_37250;
})();
var statearr_37251_37299 = state_37243__$1;
(statearr_37251_37299[(2)] = null);

(statearr_37251_37299[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (4))){
var inst_37166 = (state_37243[(7)]);
var inst_37166__$1 = (state_37243[(2)]);
var inst_37167 = cljs.core.ex_data.call(null,inst_37166__$1);
var inst_37168 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_37167);
var inst_37169 = cljs.core._EQ_.call(null,inst_37168,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_37243__$1 = (function (){var statearr_37252 = state_37243;
(statearr_37252[(7)] = inst_37166__$1);

return statearr_37252;
})();
if(inst_37169){
var statearr_37253_37300 = state_37243__$1;
(statearr_37253_37300[(1)] = (5));

} else {
var statearr_37254_37301 = state_37243__$1;
(statearr_37254_37301[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (15))){
var inst_37195 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_37196 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_37197 = cljs.core.PersistentHashMap.fromArrays(inst_37195,inst_37196);
var inst_37198 = cljs.core.ex_info.call(null,"Aborted operations",inst_37197);
var state_37243__$1 = state_37243;
var statearr_37255_37302 = state_37243__$1;
(statearr_37255_37302[(2)] = inst_37198);

(statearr_37255_37302[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (21))){
var inst_37207 = (state_37243[(11)]);
var inst_37213 = (state_37243[(2)]);
var inst_37214 = cljs.core.nth.call(null,inst_37213,(0),null);
var inst_37215 = cljs.core.nth.call(null,inst_37213,(1),null);
var inst_37216 = cljs.core._EQ_.call(null,inst_37215,inst_37207);
var state_37243__$1 = (function (){var statearr_37256 = state_37243;
(statearr_37256[(12)] = inst_37214);

return statearr_37256;
})();
if(inst_37216){
var statearr_37257_37303 = state_37243__$1;
(statearr_37257_37303[(1)] = (22));

} else {
var statearr_37258_37304 = state_37243__$1;
(statearr_37258_37304[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (13))){
var inst_37237 = (state_37243[(2)]);
var state_37243__$1 = state_37243;
var statearr_37259_37305 = state_37243__$1;
(statearr_37259_37305[(2)] = inst_37237);

(statearr_37259_37305[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (22))){
var inst_37218 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_37219 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_37220 = cljs.core.PersistentHashMap.fromArrays(inst_37218,inst_37219);
var inst_37221 = cljs.core.ex_info.call(null,"Aborted operations",inst_37220);
var state_37243__$1 = state_37243;
var statearr_37260_37306 = state_37243__$1;
(statearr_37260_37306[(2)] = inst_37221);

(statearr_37260_37306[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (6))){
var inst_37166 = (state_37243[(7)]);
var inst_37172 = superv.async._track_exception.call(null,S,inst_37166);
var state_37243__$1 = state_37243;
var statearr_37261_37307 = state_37243__$1;
(statearr_37261_37307[(2)] = inst_37172);

(statearr_37261_37307[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (25))){
var inst_37224 = (state_37243[(2)]);
var state_37243__$1 = state_37243;
var statearr_37262_37308 = state_37243__$1;
(statearr_37262_37308[(2)] = inst_37224);

(statearr_37262_37308[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (17))){
var inst_37202 = (state_37243[(13)]);
var inst_37201 = (state_37243[(2)]);
var inst_37202__$1 = superv.async.throw_if_exception.call(null,S,inst_37201);
var state_37243__$1 = (function (){var statearr_37263 = state_37243;
(statearr_37263[(13)] = inst_37202__$1);

return statearr_37263;
})();
if(cljs.core.truth_(inst_37202__$1)){
var statearr_37264_37309 = state_37243__$1;
(statearr_37264_37309[(1)] = (18));

} else {
var statearr_37265_37310 = state_37243__$1;
(statearr_37265_37310[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (3))){
var inst_37163 = (state_37243[(2)]);
var inst_37164 = superv.async._unregister_go.call(null,S,id__19191__auto___37294);
var state_37243__$1 = (function (){var statearr_37266 = state_37243;
(statearr_37266[(14)] = inst_37163);

(statearr_37266[(15)] = inst_37164);

return statearr_37266;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37243__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (12))){
var inst_37235 = cljs.core.async.close_BANG_.call(null,out);
var state_37243__$1 = state_37243;
var statearr_37267_37311 = state_37243__$1;
(statearr_37267_37311[(2)] = inst_37235);

(statearr_37267_37311[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (2))){
var inst_37241 = (state_37243[(2)]);
var state_37243__$1 = state_37243;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37243__$1,inst_37241);
} else {
if((state_val_37244 === (23))){
var inst_37202 = (state_37243[(13)]);
var state_37243__$1 = state_37243;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_37243__$1,(25),out,inst_37202);
} else {
if((state_val_37244 === (19))){
var inst_37178 = (state_37243[(9)]);
var inst_37230 = cljs.core.rest.call(null,inst_37178);
var inst_37178__$1 = inst_37230;
var state_37243__$1 = (function (){var statearr_37268 = state_37243;
(statearr_37268[(9)] = inst_37178__$1);

return statearr_37268;
})();
var statearr_37269_37312 = state_37243__$1;
(statearr_37269_37312[(2)] = null);

(statearr_37269_37312[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (11))){
var inst_37180 = (state_37243[(16)]);
var inst_37185 = (state_37243[(17)]);
var inst_37185__$1 = superv.async._abort.call(null,S);
var inst_37186 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37187 = [inst_37185__$1,inst_37180];
var inst_37188 = (new cljs.core.PersistentVector(null,2,(5),inst_37186,inst_37187,null));
var state_37243__$1 = (function (){var statearr_37270 = state_37243;
(statearr_37270[(17)] = inst_37185__$1);

return statearr_37270;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_37243__$1,(14),inst_37188,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_37244 === (9))){
var inst_37180 = (state_37243[(16)]);
var inst_37178 = (state_37243[(9)]);
var inst_37180__$1 = cljs.core.first.call(null,inst_37178);
var state_37243__$1 = (function (){var statearr_37271 = state_37243;
(statearr_37271[(16)] = inst_37180__$1);

return statearr_37271;
})();
if(cljs.core.truth_(inst_37180__$1)){
var statearr_37272_37313 = state_37243__$1;
(statearr_37272_37313[(1)] = (11));

} else {
var statearr_37273_37314 = state_37243__$1;
(statearr_37273_37314[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (5))){
var state_37243__$1 = state_37243;
var statearr_37274_37315 = state_37243__$1;
(statearr_37274_37315[(2)] = null);

(statearr_37274_37315[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (14))){
var inst_37185 = (state_37243[(17)]);
var inst_37190 = (state_37243[(2)]);
var inst_37191 = cljs.core.nth.call(null,inst_37190,(0),null);
var inst_37192 = cljs.core.nth.call(null,inst_37190,(1),null);
var inst_37193 = cljs.core._EQ_.call(null,inst_37192,inst_37185);
var state_37243__$1 = (function (){var statearr_37275 = state_37243;
(statearr_37275[(18)] = inst_37191);

return statearr_37275;
})();
if(inst_37193){
var statearr_37276_37316 = state_37243__$1;
(statearr_37276_37316[(1)] = (15));

} else {
var statearr_37277_37317 = state_37243__$1;
(statearr_37277_37317[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (16))){
var inst_37191 = (state_37243[(18)]);
var state_37243__$1 = state_37243;
var statearr_37278_37318 = state_37243__$1;
(statearr_37278_37318[(2)] = inst_37191);

(statearr_37278_37318[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (10))){
var inst_37239 = (state_37243[(2)]);
var state_37243__$1 = state_37243;
var statearr_37279_37319 = state_37243__$1;
(statearr_37279_37319[(2)] = inst_37239);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37243__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37244 === (18))){
var inst_37207 = (state_37243[(11)]);
var inst_37207__$1 = superv.async._abort.call(null,S);
var inst_37208 = cljs.core.async.timeout.call(null,(0));
var inst_37209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37210 = [inst_37207__$1,inst_37208];
var inst_37211 = (new cljs.core.PersistentVector(null,2,(5),inst_37209,inst_37210,null));
var state_37243__$1 = (function (){var statearr_37280 = state_37243;
(statearr_37280[(11)] = inst_37207__$1);

return statearr_37280;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_37243__$1,(21),inst_37211,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_37244 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_37243,(4),Error,(3),(2));
var inst_37178 = cs;
var state_37243__$1 = (function (){var statearr_37281 = state_37243;
(statearr_37281[(9)] = inst_37178);

return statearr_37281;
})();
var statearr_37282_37320 = state_37243__$1;
(statearr_37282_37320[(2)] = null);

(statearr_37282_37320[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___37295,c__19190__auto___37293,id__19191__auto___37294,out))
;
return ((function (switch__33364__auto__,c__33478__auto___37295,c__19190__auto___37293,id__19191__auto___37294,out){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_37286 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37286[(0)] = superv$async$state_machine__33365__auto__);

(statearr_37286[(1)] = (1));

return statearr_37286;
});
var superv$async$state_machine__33365__auto____1 = (function (state_37243){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_37243);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e37287){if((e37287 instanceof Object)){
var ex__33368__auto__ = e37287;
var statearr_37288_37321 = state_37243;
(statearr_37288_37321[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37243);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37287;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37322 = state_37243;
state_37243 = G__37322;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_37243){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_37243);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___37295,c__19190__auto___37293,id__19191__auto___37294,out))
})();
var state__33480__auto__ = (function (){var statearr_37289 = f__33479__auto__.call(null);
(statearr_37289[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___37295);

return statearr_37289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___37295,c__19190__auto___37293,id__19191__auto___37294,out))
);


return out;
});

superv.async.concat_GT__GT_.cljs$lang$maxFixedArity = (1);

superv.async.concat_GT__GT_.cljs$lang$applyTo = (function (seq37161){
var G__37162 = cljs.core.first.call(null,seq37161);
var seq37161__$1 = cljs.core.next.call(null,seq37161);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__37162,seq37161__$1);
});

superv.async.partition_all_GT__GT_ = (function superv$async$partition_all_GT__GT_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___37540 = arguments.length;
var i__10641__auto___37541 = (0);
while(true){
if((i__10641__auto___37541 < len__10640__auto___37540)){
args__10647__auto__.push((arguments[i__10641__auto___37541]));

var G__37542 = (i__10641__auto___37541 + (1));
i__10641__auto___37541 = G__37542;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((3) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((3)),(0),null)):null);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10648__auto__);
});

superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,n,in_ch,p__37327){
var map__37328 = p__37327;
var map__37328__$1 = ((((!((map__37328 == null)))?((((map__37328.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37328.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37328):map__37328);
var out_ch = cljs.core.get.call(null,map__37328__$1,new cljs.core.Keyword(null,"out-ch","out-ch",-189045854));

new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(n > (0))], null)], null);

var out_ch__$1 = (function (){var or__9419__auto__ = out_ch;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})();
var c__19190__auto___37543 = superv.async.check_supervisor.call(null,superv.async.S);
var id__19191__auto___37544 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"batch","batch",977610327,null),cljs.core.PersistentVector.EMPTY], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null),cljs.core.list(new cljs.core.Symbol(null,"conj","conj",-1127293942,null),new cljs.core.Symbol(null,"batch","batch",977610327,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.PersistentVector.EMPTY)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"not-empty","not-empty",2029453590,null),new cljs.core.Symbol(null,"batch","batch",977610327,null)),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"batch","batch",977610327,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))))));
var c__33478__auto___37545 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___37545,c__19190__auto___37543,id__19191__auto___37544,out_ch__$1,map__37328,map__37328__$1,out_ch){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___37545,c__19190__auto___37543,id__19191__auto___37544,out_ch__$1,map__37328,map__37328__$1,out_ch){
return (function (state_37472){
var state_val_37473 = (state_37472[(1)]);
if((state_val_37473 === (7))){
var inst_37333 = (state_37472[(7)]);
var inst_37341 = (state_37472[(2)]);
var state_37472__$1 = (function (){var statearr_37474 = state_37472;
(statearr_37474[(8)] = inst_37341);

return statearr_37474;
})();
var statearr_37475_37546 = state_37472__$1;
(statearr_37475_37546[(2)] = inst_37333);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37472__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (20))){
var inst_37433 = (state_37472[(2)]);
var state_37472__$1 = state_37472;
var statearr_37476_37547 = state_37472__$1;
(statearr_37476_37547[(2)] = inst_37433);

(statearr_37476_37547[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (27))){
var inst_37398 = (state_37472[(9)]);
var inst_37346 = inst_37398;
var state_37472__$1 = (function (){var statearr_37477 = state_37472;
(statearr_37477[(10)] = inst_37346);

return statearr_37477;
})();
var statearr_37478_37548 = state_37472__$1;
(statearr_37478_37548[(2)] = null);

(statearr_37478_37548[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (1))){
var state_37472__$1 = state_37472;
var statearr_37479_37549 = state_37472__$1;
(statearr_37479_37549[(2)] = null);

(statearr_37479_37549[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (24))){
var inst_37394 = (state_37472[(2)]);
var inst_37395 = superv.async.throw_if_exception.call(null,S,inst_37394);
var inst_37396 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_37472__$1 = (function (){var statearr_37480 = state_37472;
(statearr_37480[(11)] = inst_37395);

return statearr_37480;
})();
var statearr_37481_37550 = state_37472__$1;
(statearr_37481_37550[(2)] = inst_37396);

(statearr_37481_37550[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (39))){
var inst_37346 = (state_37472[(10)]);
var state_37472__$1 = state_37472;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_37472__$1,(41),out_ch__$1,inst_37346);
} else {
if((state_val_37473 === (4))){
var inst_37333 = (state_37472[(7)]);
var inst_37333__$1 = (state_37472[(2)]);
var inst_37334 = cljs.core.ex_data.call(null,inst_37333__$1);
var inst_37335 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_37334);
var inst_37336 = cljs.core._EQ_.call(null,inst_37335,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_37472__$1 = (function (){var statearr_37482 = state_37472;
(statearr_37482[(7)] = inst_37333__$1);

return statearr_37482;
})();
if(inst_37336){
var statearr_37483_37551 = state_37472__$1;
(statearr_37483_37551[(1)] = (5));

} else {
var statearr_37484_37552 = state_37472__$1;
(statearr_37484_37552[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (15))){
var inst_37368 = (state_37472[(12)]);
var inst_37370 = (inst_37368 instanceof Error);
var state_37472__$1 = state_37472;
if(cljs.core.truth_(inst_37370)){
var statearr_37485_37553 = state_37472__$1;
(statearr_37485_37553[(1)] = (18));

} else {
var statearr_37486_37554 = state_37472__$1;
(statearr_37486_37554[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (21))){
var inst_37375 = (state_37472[(13)]);
var inst_37381 = (state_37472[(2)]);
var inst_37382 = cljs.core.nth.call(null,inst_37381,(0),null);
var inst_37383 = cljs.core.nth.call(null,inst_37381,(1),null);
var inst_37384 = cljs.core._EQ_.call(null,inst_37383,inst_37375);
var state_37472__$1 = (function (){var statearr_37487 = state_37472;
(statearr_37487[(14)] = inst_37382);

return statearr_37487;
})();
if(inst_37384){
var statearr_37488_37555 = state_37472__$1;
(statearr_37488_37555[(1)] = (22));

} else {
var statearr_37489_37556 = state_37472__$1;
(statearr_37489_37556[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (31))){
var inst_37398 = (state_37472[(9)]);
var state_37472__$1 = state_37472;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_37472__$1,(33),out_ch__$1,inst_37398);
} else {
if((state_val_37473 === (32))){
var inst_37424 = (state_37472[(2)]);
var inst_37425 = superv.async.throw_if_exception.call(null,S,inst_37424);
var inst_37426 = cljs.core.PersistentVector.EMPTY;
var inst_37346 = inst_37426;
var state_37472__$1 = (function (){var statearr_37490 = state_37472;
(statearr_37490[(10)] = inst_37346);

(statearr_37490[(15)] = inst_37425);

return statearr_37490;
})();
var statearr_37491_37557 = state_37472__$1;
(statearr_37491_37557[(2)] = null);

(statearr_37491_37557[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (40))){
var inst_37459 = (state_37472[(2)]);
var inst_37460 = superv.async.throw_if_exception.call(null,S,inst_37459);
var state_37472__$1 = state_37472;
var statearr_37492_37558 = state_37472__$1;
(statearr_37492_37558[(2)] = inst_37460);

(statearr_37492_37558[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (33))){
var inst_37422 = (state_37472[(2)]);
var state_37472__$1 = state_37472;
var statearr_37493_37559 = state_37472__$1;
(statearr_37493_37559[(2)] = inst_37422);

(statearr_37493_37559[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (13))){
var inst_37357 = (state_37472[(16)]);
var state_37472__$1 = state_37472;
var statearr_37494_37560 = state_37472__$1;
(statearr_37494_37560[(2)] = inst_37357);

(statearr_37494_37560[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (22))){
var inst_37386 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_37387 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_37388 = cljs.core.PersistentHashMap.fromArrays(inst_37386,inst_37387);
var inst_37389 = cljs.core.ex_info.call(null,"Aborted operations",inst_37388);
var state_37472__$1 = state_37472;
var statearr_37495_37561 = state_37472__$1;
(statearr_37495_37561[(2)] = inst_37389);

(statearr_37495_37561[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (36))){
var inst_37463 = (state_37472[(2)]);
var inst_37464 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_37472__$1 = (function (){var statearr_37496 = state_37472;
(statearr_37496[(17)] = inst_37463);

return statearr_37496;
})();
var statearr_37497_37562 = state_37472__$1;
(statearr_37497_37562[(2)] = inst_37464);

(statearr_37497_37562[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (41))){
var inst_37457 = (state_37472[(2)]);
var state_37472__$1 = state_37472;
var statearr_37498_37563 = state_37472__$1;
(statearr_37498_37563[(2)] = inst_37457);

(statearr_37498_37563[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (29))){
var inst_37405 = (state_37472[(18)]);
var inst_37411 = (state_37472[(2)]);
var inst_37412 = cljs.core.nth.call(null,inst_37411,(0),null);
var inst_37413 = cljs.core.nth.call(null,inst_37411,(1),null);
var inst_37414 = cljs.core._EQ_.call(null,inst_37413,inst_37405);
var state_37472__$1 = (function (){var statearr_37499 = state_37472;
(statearr_37499[(19)] = inst_37412);

return statearr_37499;
})();
if(inst_37414){
var statearr_37500_37564 = state_37472__$1;
(statearr_37500_37564[(1)] = (30));

} else {
var statearr_37501_37565 = state_37472__$1;
(statearr_37501_37565[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (6))){
var inst_37333 = (state_37472[(7)]);
var inst_37339 = superv.async._track_exception.call(null,S,inst_37333);
var state_37472__$1 = state_37472;
var statearr_37502_37566 = state_37472__$1;
(statearr_37502_37566[(2)] = inst_37339);

(statearr_37502_37566[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (28))){
var inst_37431 = (state_37472[(2)]);
var state_37472__$1 = state_37472;
var statearr_37503_37567 = state_37472__$1;
(statearr_37503_37567[(2)] = inst_37431);

(statearr_37503_37567[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (25))){
var inst_37392 = (state_37472[(2)]);
var state_37472__$1 = state_37472;
var statearr_37504_37568 = state_37472__$1;
(statearr_37504_37568[(2)] = inst_37392);

(statearr_37504_37568[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (34))){
var inst_37440 = (state_37472[(20)]);
var inst_37440__$1 = superv.async._abort.call(null,S);
var inst_37441 = cljs.core.async.timeout.call(null,(0));
var inst_37442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37443 = [inst_37440__$1,inst_37441];
var inst_37444 = (new cljs.core.PersistentVector(null,2,(5),inst_37442,inst_37443,null));
var state_37472__$1 = (function (){var statearr_37505 = state_37472;
(statearr_37505[(20)] = inst_37440__$1);

return statearr_37505;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_37472__$1,(37),inst_37444,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_37473 === (17))){
var inst_37466 = (state_37472[(2)]);
var state_37472__$1 = state_37472;
var statearr_37506_37569 = state_37472__$1;
(statearr_37506_37569[(2)] = inst_37466);

(statearr_37506_37569[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (3))){
var inst_37330 = (state_37472[(2)]);
var inst_37331 = superv.async._unregister_go.call(null,S,id__19191__auto___37544);
var state_37472__$1 = (function (){var statearr_37507 = state_37472;
(statearr_37507[(21)] = inst_37331);

(statearr_37507[(22)] = inst_37330);

return statearr_37507;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37472__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (12))){
var inst_37361 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_37362 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_37363 = cljs.core.PersistentHashMap.fromArrays(inst_37361,inst_37362);
var inst_37364 = cljs.core.ex_info.call(null,"Aborted operations",inst_37363);
var state_37472__$1 = state_37472;
var statearr_37508_37570 = state_37472__$1;
(statearr_37508_37570[(2)] = inst_37364);

(statearr_37508_37570[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (2))){
var inst_37470 = (state_37472[(2)]);
var state_37472__$1 = state_37472;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37472__$1,inst_37470);
} else {
if((state_val_37473 === (23))){
var inst_37368 = (state_37472[(12)]);
var state_37472__$1 = state_37472;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_37472__$1,(25),out_ch__$1,inst_37368);
} else {
if((state_val_37473 === (35))){
var state_37472__$1 = state_37472;
var statearr_37509_37571 = state_37472__$1;
(statearr_37509_37571[(2)] = null);

(statearr_37509_37571[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (19))){
var inst_37368 = (state_37472[(12)]);
var inst_37398 = (state_37472[(9)]);
var inst_37346 = (state_37472[(10)]);
var inst_37398__$1 = cljs.core.conj.call(null,inst_37346,inst_37368);
var inst_37399 = cljs.core.count.call(null,inst_37398__$1);
var inst_37400 = cljs.core._EQ_.call(null,n,inst_37399);
var state_37472__$1 = (function (){var statearr_37510 = state_37472;
(statearr_37510[(9)] = inst_37398__$1);

return statearr_37510;
})();
if(inst_37400){
var statearr_37511_37572 = state_37472__$1;
(statearr_37511_37572[(1)] = (26));

} else {
var statearr_37512_37573 = state_37472__$1;
(statearr_37512_37573[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (11))){
var inst_37351 = (state_37472[(23)]);
var inst_37356 = (state_37472[(2)]);
var inst_37357 = cljs.core.nth.call(null,inst_37356,(0),null);
var inst_37358 = cljs.core.nth.call(null,inst_37356,(1),null);
var inst_37359 = cljs.core._EQ_.call(null,inst_37358,inst_37351);
var state_37472__$1 = (function (){var statearr_37513 = state_37472;
(statearr_37513[(16)] = inst_37357);

return statearr_37513;
})();
if(inst_37359){
var statearr_37514_37574 = state_37472__$1;
(statearr_37514_37574[(1)] = (12));

} else {
var statearr_37515_37575 = state_37472__$1;
(statearr_37515_37575[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (9))){
var inst_37351 = (state_37472[(23)]);
var inst_37351__$1 = superv.async._abort.call(null,S);
var inst_37352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37353 = [inst_37351__$1,in_ch];
var inst_37354 = (new cljs.core.PersistentVector(null,2,(5),inst_37352,inst_37353,null));
var state_37472__$1 = (function (){var statearr_37516 = state_37472;
(statearr_37516[(23)] = inst_37351__$1);

return statearr_37516;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_37472__$1,(11),inst_37354,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_37473 === (5))){
var state_37472__$1 = state_37472;
var statearr_37517_37576 = state_37472__$1;
(statearr_37517_37576[(2)] = null);

(statearr_37517_37576[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (14))){
var inst_37368 = (state_37472[(12)]);
var inst_37367 = (state_37472[(2)]);
var inst_37368__$1 = superv.async.throw_if_exception.call(null,S,inst_37367);
var state_37472__$1 = (function (){var statearr_37518 = state_37472;
(statearr_37518[(12)] = inst_37368__$1);

return statearr_37518;
})();
if(cljs.core.truth_(inst_37368__$1)){
var statearr_37519_37577 = state_37472__$1;
(statearr_37519_37577[(1)] = (15));

} else {
var statearr_37520_37578 = state_37472__$1;
(statearr_37520_37578[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (26))){
var inst_37405 = (state_37472[(18)]);
var inst_37405__$1 = superv.async._abort.call(null,S);
var inst_37406 = cljs.core.async.timeout.call(null,(0));
var inst_37407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37408 = [inst_37405__$1,inst_37406];
var inst_37409 = (new cljs.core.PersistentVector(null,2,(5),inst_37407,inst_37408,null));
var state_37472__$1 = (function (){var statearr_37521 = state_37472;
(statearr_37521[(18)] = inst_37405__$1);

return statearr_37521;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_37472__$1,(29),inst_37409,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_37473 === (16))){
var inst_37346 = (state_37472[(10)]);
var inst_37435 = cljs.core.not_empty.call(null,inst_37346);
var state_37472__$1 = state_37472;
if(cljs.core.truth_(inst_37435)){
var statearr_37522_37579 = state_37472__$1;
(statearr_37522_37579[(1)] = (34));

} else {
var statearr_37523_37580 = state_37472__$1;
(statearr_37523_37580[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (38))){
var inst_37451 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_37452 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_37453 = cljs.core.PersistentHashMap.fromArrays(inst_37451,inst_37452);
var inst_37454 = cljs.core.ex_info.call(null,"Aborted operations",inst_37453);
var state_37472__$1 = state_37472;
var statearr_37524_37581 = state_37472__$1;
(statearr_37524_37581[(2)] = inst_37454);

(statearr_37524_37581[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (30))){
var inst_37416 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_37417 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_37418 = cljs.core.PersistentHashMap.fromArrays(inst_37416,inst_37417);
var inst_37419 = cljs.core.ex_info.call(null,"Aborted operations",inst_37418);
var state_37472__$1 = state_37472;
var statearr_37525_37582 = state_37472__$1;
(statearr_37525_37582[(2)] = inst_37419);

(statearr_37525_37582[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (10))){
var inst_37468 = (state_37472[(2)]);
var state_37472__$1 = state_37472;
var statearr_37526_37583 = state_37472__$1;
(statearr_37526_37583[(2)] = inst_37468);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37472__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (18))){
var inst_37375 = (state_37472[(13)]);
var inst_37375__$1 = superv.async._abort.call(null,S);
var inst_37376 = cljs.core.async.timeout.call(null,(0));
var inst_37377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37378 = [inst_37375__$1,inst_37376];
var inst_37379 = (new cljs.core.PersistentVector(null,2,(5),inst_37377,inst_37378,null));
var state_37472__$1 = (function (){var statearr_37527 = state_37472;
(statearr_37527[(13)] = inst_37375__$1);

return statearr_37527;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_37472__$1,(21),inst_37379,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_37473 === (37))){
var inst_37440 = (state_37472[(20)]);
var inst_37446 = (state_37472[(2)]);
var inst_37447 = cljs.core.nth.call(null,inst_37446,(0),null);
var inst_37448 = cljs.core.nth.call(null,inst_37446,(1),null);
var inst_37449 = cljs.core._EQ_.call(null,inst_37448,inst_37440);
var state_37472__$1 = (function (){var statearr_37528 = state_37472;
(statearr_37528[(24)] = inst_37447);

return statearr_37528;
})();
if(inst_37449){
var statearr_37529_37584 = state_37472__$1;
(statearr_37529_37584[(1)] = (38));

} else {
var statearr_37530_37585 = state_37472__$1;
(statearr_37530_37585[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37473 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_37472,(4),Error,(3),(2));
var inst_37345 = cljs.core.PersistentVector.EMPTY;
var inst_37346 = inst_37345;
var state_37472__$1 = (function (){var statearr_37531 = state_37472;
(statearr_37531[(10)] = inst_37346);

return statearr_37531;
})();
var statearr_37532_37586 = state_37472__$1;
(statearr_37532_37586[(2)] = null);

(statearr_37532_37586[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___37545,c__19190__auto___37543,id__19191__auto___37544,out_ch__$1,map__37328,map__37328__$1,out_ch))
;
return ((function (switch__33364__auto__,c__33478__auto___37545,c__19190__auto___37543,id__19191__auto___37544,out_ch__$1,map__37328,map__37328__$1,out_ch){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_37536 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37536[(0)] = superv$async$state_machine__33365__auto__);

(statearr_37536[(1)] = (1));

return statearr_37536;
});
var superv$async$state_machine__33365__auto____1 = (function (state_37472){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_37472);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e37537){if((e37537 instanceof Object)){
var ex__33368__auto__ = e37537;
var statearr_37538_37587 = state_37472;
(statearr_37538_37587[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37472);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37537;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37588 = state_37472;
state_37472 = G__37588;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_37472){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_37472);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___37545,c__19190__auto___37543,id__19191__auto___37544,out_ch__$1,map__37328,map__37328__$1,out_ch))
})();
var state__33480__auto__ = (function (){var statearr_37539 = f__33479__auto__.call(null);
(statearr_37539[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___37545);

return statearr_37539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___37545,c__19190__auto___37543,id__19191__auto___37544,out_ch__$1,map__37328,map__37328__$1,out_ch))
);


return out_ch__$1;
});

superv.async.partition_all_GT__GT_.cljs$lang$maxFixedArity = (3);

superv.async.partition_all_GT__GT_.cljs$lang$applyTo = (function (seq37323){
var G__37324 = cljs.core.first.call(null,seq37323);
var seq37323__$1 = cljs.core.next.call(null,seq37323);
var G__37325 = cljs.core.first.call(null,seq37323__$1);
var seq37323__$2 = cljs.core.next.call(null,seq37323__$1);
var G__37326 = cljs.core.first.call(null,seq37323__$2);
var seq37323__$3 = cljs.core.next.call(null,seq37323__$2);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__37324,G__37325,G__37326,seq37323__$3);
});

/**
 * Counts items in a channel. Returns a channel with the item count.
 */
superv.async.count_GT_ = (function superv$async$count_GT_(S,ch){
return cljs.core.async.reduce.call(null,(function (acc,obj){
if((obj instanceof Error)){
return superv.async.put_QMARK_.call(null,S,superv.async._error.call(null,S),obj);
} else {
return (acc + (1));
}
}),(0),ch);
});
/**
 * Debounces channel. Forwards first item from input channel to output
 *   immediately. After that one item every interval ms (if any). If there are more
 *   items in between, they are dropped.
 */
superv.async.debounce_GT__GT_ = (function superv$async$debounce_GT__GT_(S,ch,interval){
var out = cljs.core.async.chan.call(null);
var c__19190__auto___37907 = superv.async.check_supervisor.call(null,superv.async.S);
var id__19191__auto___37908 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),null], null),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol("async","timeout","async/timeout",1951904349,null),new cljs.core.Symbol(null,"interval","interval",-945940352,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null)),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-val","new-val",902372928,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null),cljs.core.list(new cljs.core.Symbol(null,"alts?","alts?",1625745590,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null)], null))], null),cljs.core.list(new cljs.core.Symbol(null,"condp","condp",1054325175,null),new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)))))))));
var c__33478__auto___37909 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___37909,c__19190__auto___37907,id__19191__auto___37908,out){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___37909,c__19190__auto___37907,id__19191__auto___37908,out){
return (function (state_37853){
var state_val_37854 = (state_37853[(1)]);
if((state_val_37854 === (7))){
var inst_37751 = (state_37853[(7)]);
var inst_37759 = (state_37853[(2)]);
var state_37853__$1 = (function (){var statearr_37855 = state_37853;
(statearr_37855[(8)] = inst_37759);

return statearr_37855;
})();
var statearr_37856_37910 = state_37853__$1;
(statearr_37856_37910[(2)] = inst_37751);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37853__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (20))){
var inst_37847 = (state_37853[(2)]);
var state_37853__$1 = state_37853;
var statearr_37857_37911 = state_37853__$1;
(statearr_37857_37911[(2)] = inst_37847);

(statearr_37857_37911[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (27))){
var inst_37831 = (state_37853[(2)]);
var inst_37832 = superv.async.throw_if_exception.call(null,S,inst_37831);
var inst_37763 = null;
var state_37853__$1 = (function (){var statearr_37858 = state_37853;
(statearr_37858[(9)] = inst_37763);

(statearr_37858[(10)] = inst_37832);

return statearr_37858;
})();
var statearr_37859_37912 = state_37853__$1;
(statearr_37859_37912[(2)] = null);

(statearr_37859_37912[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (1))){
var state_37853__$1 = state_37853;
var statearr_37860_37913 = state_37853__$1;
(statearr_37860_37913[(2)] = null);

(statearr_37860_37913[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (24))){
var inst_37812 = (state_37853[(11)]);
var inst_37818 = (state_37853[(2)]);
var inst_37819 = cljs.core.nth.call(null,inst_37818,(0),null);
var inst_37820 = cljs.core.nth.call(null,inst_37818,(1),null);
var inst_37821 = cljs.core._EQ_.call(null,inst_37820,inst_37812);
var state_37853__$1 = (function (){var statearr_37861 = state_37853;
(statearr_37861[(12)] = inst_37819);

return statearr_37861;
})();
if(inst_37821){
var statearr_37862_37914 = state_37853__$1;
(statearr_37862_37914[(1)] = (25));

} else {
var statearr_37863_37915 = state_37853__$1;
(statearr_37863_37915[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (4))){
var inst_37751 = (state_37853[(7)]);
var inst_37751__$1 = (state_37853[(2)]);
var inst_37752 = cljs.core.ex_data.call(null,inst_37751__$1);
var inst_37753 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_37752);
var inst_37754 = cljs.core._EQ_.call(null,inst_37753,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_37853__$1 = (function (){var statearr_37864 = state_37853;
(statearr_37864[(7)] = inst_37751__$1);

return statearr_37864;
})();
if(inst_37754){
var statearr_37865_37916 = state_37853__$1;
(statearr_37865_37916[(1)] = (5));

} else {
var statearr_37866_37917 = state_37853__$1;
(statearr_37866_37917[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (15))){
var inst_37780 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_37781 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_37782 = cljs.core.PersistentHashMap.fromArrays(inst_37780,inst_37781);
var inst_37783 = cljs.core.ex_info.call(null,"Aborted operations",inst_37782);
var state_37853__$1 = state_37853;
var statearr_37867_37918 = state_37853__$1;
(statearr_37867_37918[(2)] = inst_37783);

(statearr_37867_37918[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (21))){
var inst_37812 = (state_37853[(11)]);
var inst_37812__$1 = superv.async._abort.call(null,S);
var inst_37813 = cljs.core.async.timeout.call(null,(0));
var inst_37814 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37815 = [inst_37812__$1,inst_37813];
var inst_37816 = (new cljs.core.PersistentVector(null,2,(5),inst_37814,inst_37815,null));
var state_37853__$1 = (function (){var statearr_37868 = state_37853;
(statearr_37868[(11)] = inst_37812__$1);

return statearr_37868;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_37853__$1,(24),inst_37816,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_37854 === (31))){
var inst_37843 = (state_37853[(2)]);
var state_37853__$1 = state_37853;
var statearr_37869_37919 = state_37853__$1;
(statearr_37869_37919[(2)] = inst_37843);

(statearr_37869_37919[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (13))){
var inst_37789 = (state_37853[(13)]);
var inst_37789__$1 = (state_37853[(2)]);
var inst_37790 = cljs.core.async.timeout.call(null,interval);
var inst_37791 = (inst_37789__$1 == null);
var state_37853__$1 = (function (){var statearr_37870 = state_37853;
(statearr_37870[(14)] = inst_37790);

(statearr_37870[(13)] = inst_37789__$1);

return statearr_37870;
})();
if(cljs.core.truth_(inst_37791)){
var statearr_37871_37920 = state_37853__$1;
(statearr_37871_37920[(1)] = (18));

} else {
var statearr_37872_37921 = state_37853__$1;
(statearr_37872_37921[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (22))){
var inst_37803 = (state_37853[(15)]);
var inst_37835 = cljs.core._EQ_.call(null,inst_37803,inst_37803);
var state_37853__$1 = state_37853;
if(inst_37835){
var statearr_37873_37922 = state_37853__$1;
(statearr_37873_37922[(1)] = (29));

} else {
var statearr_37874_37923 = state_37853__$1;
(statearr_37874_37923[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (29))){
var inst_37802 = (state_37853[(16)]);
var inst_37763 = inst_37802;
var state_37853__$1 = (function (){var statearr_37875 = state_37853;
(statearr_37875[(9)] = inst_37763);

return statearr_37875;
})();
var statearr_37876_37924 = state_37853__$1;
(statearr_37876_37924[(2)] = null);

(statearr_37876_37924[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (6))){
var inst_37751 = (state_37853[(7)]);
var inst_37757 = superv.async._track_exception.call(null,S,inst_37751);
var state_37853__$1 = state_37853;
var statearr_37877_37925 = state_37853__$1;
(statearr_37877_37925[(2)] = inst_37757);

(statearr_37877_37925[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (28))){
var inst_37829 = (state_37853[(2)]);
var state_37853__$1 = state_37853;
var statearr_37878_37926 = state_37853__$1;
(statearr_37878_37926[(2)] = inst_37829);

(statearr_37878_37926[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (25))){
var inst_37823 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_37824 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_37825 = cljs.core.PersistentHashMap.fromArrays(inst_37823,inst_37824);
var inst_37826 = cljs.core.ex_info.call(null,"Aborted operations",inst_37825);
var state_37853__$1 = state_37853;
var statearr_37879_37927 = state_37853__$1;
(statearr_37879_37927[(2)] = inst_37826);

(statearr_37879_37927[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (17))){
var inst_37786 = (state_37853[(2)]);
var inst_37787 = superv.async.throw_if_exception.call(null,S,inst_37786);
var state_37853__$1 = state_37853;
var statearr_37880_37928 = state_37853__$1;
(statearr_37880_37928[(2)] = inst_37787);

(statearr_37880_37928[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (3))){
var inst_37748 = (state_37853[(2)]);
var inst_37749 = superv.async._unregister_go.call(null,S,id__19191__auto___37908);
var state_37853__$1 = (function (){var statearr_37881 = state_37853;
(statearr_37881[(17)] = inst_37748);

(statearr_37881[(18)] = inst_37749);

return statearr_37881;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37853__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (12))){
var inst_37770 = (state_37853[(19)]);
var inst_37770__$1 = superv.async._abort.call(null,S);
var inst_37771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37772 = [inst_37770__$1,ch];
var inst_37773 = (new cljs.core.PersistentVector(null,2,(5),inst_37771,inst_37772,null));
var state_37853__$1 = (function (){var statearr_37882 = state_37853;
(statearr_37882[(19)] = inst_37770__$1);

return statearr_37882;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_37853__$1,(14),inst_37773,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_37854 === (2))){
var inst_37851 = (state_37853[(2)]);
var state_37853__$1 = state_37853;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37853__$1,inst_37851);
} else {
if((state_val_37854 === (23))){
var inst_37845 = (state_37853[(2)]);
var state_37853__$1 = state_37853;
var statearr_37883_37929 = state_37853__$1;
(statearr_37883_37929[(2)] = inst_37845);

(statearr_37883_37929[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (19))){
var inst_37790 = (state_37853[(14)]);
var inst_37803 = (state_37853[(15)]);
var inst_37798 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37799 = [ch,inst_37790];
var inst_37800 = (new cljs.core.PersistentVector(null,2,(5),inst_37798,inst_37799,null));
var inst_37801 = superv.async.alts_QMARK_.call(null,S,inst_37800);
var inst_37802 = cljs.core.nth.call(null,inst_37801,(0),null);
var inst_37803__$1 = cljs.core.nth.call(null,inst_37801,(1),null);
var inst_37807 = cljs.core._EQ_.call(null,inst_37790,inst_37803__$1);
var state_37853__$1 = (function (){var statearr_37884 = state_37853;
(statearr_37884[(16)] = inst_37802);

(statearr_37884[(15)] = inst_37803__$1);

return statearr_37884;
})();
if(inst_37807){
var statearr_37885_37930 = state_37853__$1;
(statearr_37885_37930[(1)] = (21));

} else {
var statearr_37886_37931 = state_37853__$1;
(statearr_37886_37931[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (11))){
var inst_37763 = (state_37853[(9)]);
var state_37853__$1 = state_37853;
var statearr_37887_37932 = state_37853__$1;
(statearr_37887_37932[(2)] = inst_37763);

(statearr_37887_37932[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (9))){
var inst_37763 = (state_37853[(9)]);
var state_37853__$1 = state_37853;
if(cljs.core.truth_(inst_37763)){
var statearr_37888_37933 = state_37853__$1;
(statearr_37888_37933[(1)] = (11));

} else {
var statearr_37889_37934 = state_37853__$1;
(statearr_37889_37934[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (5))){
var state_37853__$1 = state_37853;
var statearr_37890_37935 = state_37853__$1;
(statearr_37890_37935[(2)] = null);

(statearr_37890_37935[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (14))){
var inst_37770 = (state_37853[(19)]);
var inst_37775 = (state_37853[(2)]);
var inst_37776 = cljs.core.nth.call(null,inst_37775,(0),null);
var inst_37777 = cljs.core.nth.call(null,inst_37775,(1),null);
var inst_37778 = cljs.core._EQ_.call(null,inst_37777,inst_37770);
var state_37853__$1 = (function (){var statearr_37891 = state_37853;
(statearr_37891[(20)] = inst_37776);

return statearr_37891;
})();
if(inst_37778){
var statearr_37892_37936 = state_37853__$1;
(statearr_37892_37936[(1)] = (15));

} else {
var statearr_37893_37937 = state_37853__$1;
(statearr_37893_37937[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (26))){
var inst_37789 = (state_37853[(13)]);
var state_37853__$1 = state_37853;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_37853__$1,(28),out,inst_37789);
} else {
if((state_val_37854 === (16))){
var inst_37776 = (state_37853[(20)]);
var state_37853__$1 = state_37853;
var statearr_37894_37938 = state_37853__$1;
(statearr_37894_37938[(2)] = inst_37776);

(statearr_37894_37938[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (30))){
var inst_37803 = (state_37853[(15)]);
var inst_37839 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37803)].join('');
var inst_37840 = (new Error(inst_37839));
var inst_37841 = (function(){throw inst_37840})();
var state_37853__$1 = state_37853;
var statearr_37895_37939 = state_37853__$1;
(statearr_37895_37939[(2)] = inst_37841);

(statearr_37895_37939[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (10))){
var inst_37849 = (state_37853[(2)]);
var state_37853__$1 = state_37853;
var statearr_37896_37940 = state_37853__$1;
(statearr_37896_37940[(2)] = inst_37849);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37853__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (18))){
var inst_37793 = cljs.core.async.close_BANG_.call(null,out);
var state_37853__$1 = state_37853;
var statearr_37897_37941 = state_37853__$1;
(statearr_37897_37941[(2)] = inst_37793);

(statearr_37897_37941[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37854 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_37853,(4),Error,(3),(2));
var inst_37763 = null;
var state_37853__$1 = (function (){var statearr_37898 = state_37853;
(statearr_37898[(9)] = inst_37763);

return statearr_37898;
})();
var statearr_37899_37942 = state_37853__$1;
(statearr_37899_37942[(2)] = null);

(statearr_37899_37942[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___37909,c__19190__auto___37907,id__19191__auto___37908,out))
;
return ((function (switch__33364__auto__,c__33478__auto___37909,c__19190__auto___37907,id__19191__auto___37908,out){
return (function() {
var superv$async$debounce_GT__GT__$_state_machine__33365__auto__ = null;
var superv$async$debounce_GT__GT__$_state_machine__33365__auto____0 = (function (){
var statearr_37903 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37903[(0)] = superv$async$debounce_GT__GT__$_state_machine__33365__auto__);

(statearr_37903[(1)] = (1));

return statearr_37903;
});
var superv$async$debounce_GT__GT__$_state_machine__33365__auto____1 = (function (state_37853){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_37853);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e37904){if((e37904 instanceof Object)){
var ex__33368__auto__ = e37904;
var statearr_37905_37943 = state_37853;
(statearr_37905_37943[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37853);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37904;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37944 = state_37853;
state_37853 = G__37944;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$debounce_GT__GT__$_state_machine__33365__auto__ = function(state_37853){
switch(arguments.length){
case 0:
return superv$async$debounce_GT__GT__$_state_machine__33365__auto____0.call(this);
case 1:
return superv$async$debounce_GT__GT__$_state_machine__33365__auto____1.call(this,state_37853);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$debounce_GT__GT__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$debounce_GT__GT__$_state_machine__33365__auto____0;
superv$async$debounce_GT__GT__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$debounce_GT__GT__$_state_machine__33365__auto____1;
return superv$async$debounce_GT__GT__$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___37909,c__19190__auto___37907,id__19191__auto___37908,out))
})();
var state__33480__auto__ = (function (){var statearr_37906 = f__33479__auto__.call(null);
(statearr_37906[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___37909);

return statearr_37906;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___37909,c__19190__auto___37907,id__19191__auto___37908,out))
);


return out;
});
/**
 * Safely managed tap. The channel is closed on abortion and all
 *   pending puts are flushed.
 */
superv.async.tap = (function superv$async$tap(var_args){
var args37945 = [];
var len__10640__auto___38083 = arguments.length;
var i__10641__auto___38084 = (0);
while(true){
if((i__10641__auto___38084 < len__10640__auto___38083)){
args37945.push((arguments[i__10641__auto___38084]));

var G__38085 = (i__10641__auto___38084 + (1));
i__10641__auto___38084 = G__38085;
continue;
} else {
}
break;
}

var G__37947 = args37945.length;
switch (G__37947) {
case 3:
return superv.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.tap.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args37945.length)].join('')));

}
});

superv.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (S,mult,ch){
return superv.async.tap.call(null,S,mult,ch,false);
});

superv.async.tap.cljs$core$IFn$_invoke$arity$4 = (function (S,mult,ch,close_QMARK_){
var c__19190__auto___38087 = superv.async.check_supervisor.call(null,superv.async.S);
var id__19191__auto___38088 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__33478__auto___38089 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___38089,c__19190__auto___38087,id__19191__auto___38088){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___38089,c__19190__auto___38087,id__19191__auto___38088){
return (function (state_38026){
var state_val_38027 = (state_38026[(1)]);
if((state_val_38027 === (7))){
var inst_37951 = (state_38026[(7)]);
var inst_37959 = (state_38026[(2)]);
var state_38026__$1 = (function (){var statearr_38028 = state_38026;
(statearr_38028[(8)] = inst_37959);

return statearr_38028;
})();
var statearr_38029_38090 = state_38026__$1;
(statearr_38029_38090[(2)] = inst_37951);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38026__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38027 === (1))){
var state_38026__$1 = state_38026;
var statearr_38030_38091 = state_38026__$1;
(statearr_38030_38091[(2)] = null);

(statearr_38030_38091[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38027 === (4))){
var inst_37951 = (state_38026[(7)]);
var inst_37951__$1 = (state_38026[(2)]);
var inst_37952 = cljs.core.ex_data.call(null,inst_37951__$1);
var inst_37953 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_37952);
var inst_37954 = cljs.core._EQ_.call(null,inst_37953,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_38026__$1 = (function (){var statearr_38031 = state_38026;
(statearr_38031[(7)] = inst_37951__$1);

return statearr_38031;
})();
if(inst_37954){
var statearr_38032_38092 = state_38026__$1;
(statearr_38032_38092[(1)] = (5));

} else {
var statearr_38033_38093 = state_38026__$1;
(statearr_38033_38093[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38027 === (15))){
var inst_37975 = (state_38026[(2)]);
var state_38026__$1 = state_38026;
var statearr_38034_38094 = state_38026__$1;
(statearr_38034_38094[(2)] = inst_37975);

(statearr_38034_38094[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38027 === (13))){
var state_38026__$1 = state_38026;
var statearr_38035_38095 = state_38026__$1;
(statearr_38035_38095[(2)] = null);

(statearr_38035_38095[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38027 === (6))){
var inst_37951 = (state_38026[(7)]);
var inst_37957 = superv.async._track_exception.call(null,S,inst_37951);
var state_38026__$1 = state_38026;
var statearr_38036_38096 = state_38026__$1;
(statearr_38036_38096[(2)] = inst_37957);

(statearr_38036_38096[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38027 === (3))){
var inst_37948 = (state_38026[(2)]);
var inst_37949 = superv.async._unregister_go.call(null,S,id__19191__auto___38088);
var state_38026__$1 = (function (){var statearr_38037 = state_38026;
(statearr_38037[(9)] = inst_37949);

(statearr_38037[(10)] = inst_37948);

return statearr_38037;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38026__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38027 === (12))){
var inst_37970 = (state_38026[(2)]);
var state_38026__$1 = state_38026;
if(cljs.core.truth_(inst_37970)){
var statearr_38038_38097 = state_38026__$1;
(statearr_38038_38097[(1)] = (13));

} else {
var statearr_38039_38098 = state_38026__$1;
(statearr_38039_38098[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38027 === (2))){
var inst_38024 = (state_38026[(2)]);
var state_38026__$1 = state_38026;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38026__$1,inst_38024);
} else {
if((state_val_38027 === (11))){
var inst_37967 = (state_38026[(11)]);
var inst_37977 = (state_38026[(2)]);
var inst_37978 = null;
var inst_37979 = superv.async._register_go.call(null,inst_37977,inst_37978);
var inst_38020 = cljs.core.async.chan.call(null,(1));
var inst_38021 = (function (){var c__19190__auto____$1 = inst_37967;
var id__19191__auto____$1 = inst_37979;
var c__33478__auto____$1 = inst_38020;
return ((function (c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_37967,inst_37977,inst_37978,inst_37979,inst_38020,state_val_38027,c__33478__auto___38089,c__19190__auto___38087,id__19191__auto___38088){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_37967,inst_37977,inst_37978,inst_37979,inst_38020,state_val_38027,c__33478__auto___38089,c__19190__auto___38087,id__19191__auto___38088){
return (function (state_38018){
var state_val_38019 = (state_38018[(1)]);
if((state_val_38019 === (7))){
var state_38018__$1 = state_38018;
var statearr_38040_38099 = state_38018__$1;
(statearr_38040_38099[(2)] = null);

(statearr_38040_38099[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38019 === (20))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_38018,(10),Error,(3),(2));
var state_38018__$1 = state_38018;
var statearr_38041_38100 = state_38018__$1;
(statearr_38041_38100[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38018__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38019 === (1))){
var state_38018__$1 = state_38018;
var statearr_38042_38101 = state_38018__$1;
(statearr_38042_38101[(2)] = null);

(statearr_38042_38101[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38019 === (4))){
var state_38018__$1 = state_38018;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38018__$1,(6),ch);
} else {
if((state_val_38019 === (15))){
var inst_37993 = (state_38018[(7)]);
var inst_38008 = (state_38018[(2)]);
var inst_38009 = superv.async._track_exception.call(null,inst_38008,inst_37993);
var state_38018__$1 = state_38018;
var statearr_38043_38102 = state_38018__$1;
(statearr_38043_38102[(2)] = inst_38009);

(statearr_38043_38102[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38019 === (13))){
var inst_37993 = (state_38018[(7)]);
var inst_38011 = (state_38018[(2)]);
var state_38018__$1 = (function (){var statearr_38044 = state_38018;
(statearr_38044[(8)] = inst_38011);

return statearr_38044;
})();
var statearr_38045_38103 = state_38018__$1;
(statearr_38045_38103[(2)] = inst_37993);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38018__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38019 === (6))){
var inst_37983 = (state_38018[(2)]);
var state_38018__$1 = state_38018;
if(cljs.core.truth_(inst_37983)){
var statearr_38046_38104 = state_38018__$1;
(statearr_38046_38104[(1)] = (7));

} else {
var statearr_38047_38105 = state_38018__$1;
(statearr_38047_38105[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38019 === (17))){
var state_38018__$1 = state_38018;
var statearr_38048_38106 = state_38018__$1;
(statearr_38048_38106[(2)] = null);

(statearr_38048_38106[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38019 === (3))){
var inst_37980 = (state_38018[(2)]);
var state_38018__$1 = (function (){var statearr_38049 = state_38018;
(statearr_38049[(9)] = inst_37980);

return statearr_38049;
})();
var statearr_38050_38107 = state_38018__$1;
(statearr_38050_38107[(2)] = null);

(statearr_38050_38107[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38019 === (12))){
var state_38018__$1 = state_38018;
var statearr_38051_38108 = state_38018__$1;
(statearr_38051_38108[(2)] = null);

(statearr_38051_38108[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38019 === (2))){
var inst_38016 = (state_38018[(2)]);
var state_38018__$1 = state_38018;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38018__$1,inst_38016);
} else {
if((state_val_38019 === (19))){
var inst_38006 = (state_38018[(2)]);
var state_38018__$1 = state_38018;
var statearr_38052_38109 = state_38018__$1;
(statearr_38052_38109[(2)] = inst_38006);

(statearr_38052_38109[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38019 === (11))){
var state_38018__$1 = state_38018;
var statearr_38053_38110 = state_38018__$1;
(statearr_38053_38110[(2)] = null);

(statearr_38053_38110[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38019 === (9))){
var inst_37988 = (state_38018[(2)]);
var state_38018__$1 = state_38018;
var statearr_38054_38111 = state_38018__$1;
(statearr_38054_38111[(2)] = inst_37988);

(statearr_38054_38111[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38019 === (5))){
var inst_37990 = (state_38018[(2)]);
var inst_37991 = superv.async._unregister_go.call(null,inst_37990,id__19191__auto____$1);
var state_38018__$1 = (function (){var statearr_38055 = state_38018;
(statearr_38055[(10)] = inst_37991);

return statearr_38055;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38018__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38019 === (14))){
var state_38018__$1 = state_38018;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38018__$1,(16),ch);
} else {
if((state_val_38019 === (16))){
var inst_38001 = (state_38018[(2)]);
var state_38018__$1 = state_38018;
if(cljs.core.truth_(inst_38001)){
var statearr_38056_38112 = state_38018__$1;
(statearr_38056_38112[(1)] = (17));

} else {
var statearr_38057_38113 = state_38018__$1;
(statearr_38057_38113[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38019 === (10))){
var inst_37993 = (state_38018[(7)]);
var inst_37993__$1 = (state_38018[(2)]);
var inst_37994 = cljs.core.ex_data.call(null,inst_37993__$1);
var inst_37995 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_37994);
var inst_37996 = cljs.core._EQ_.call(null,inst_37995,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_38018__$1 = (function (){var statearr_38058 = state_38018;
(statearr_38058[(7)] = inst_37993__$1);

return statearr_38058;
})();
if(inst_37996){
var statearr_38059_38114 = state_38018__$1;
(statearr_38059_38114[(1)] = (11));

} else {
var statearr_38060_38115 = state_38018__$1;
(statearr_38060_38115[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38019 === (18))){
var state_38018__$1 = state_38018;
var statearr_38061_38116 = state_38018__$1;
(statearr_38061_38116[(2)] = null);

(statearr_38061_38116[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38019 === (8))){
var state_38018__$1 = state_38018;
var statearr_38062_38117 = state_38018__$1;
(statearr_38062_38117[(2)] = null);

(statearr_38062_38117[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_37967,inst_37977,inst_37978,inst_37979,inst_38020,state_val_38027,c__33478__auto___38089,c__19190__auto___38087,id__19191__auto___38088))
;
return ((function (switch__33364__auto__,c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_37967,inst_37977,inst_37978,inst_37979,inst_38020,state_val_38027,c__33478__auto___38089,c__19190__auto___38087,id__19191__auto___38088){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_38066 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38066[(0)] = superv$async$state_machine__33365__auto__);

(statearr_38066[(1)] = (1));

return statearr_38066;
});
var superv$async$state_machine__33365__auto____1 = (function (state_38018){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_38018);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e38067){if((e38067 instanceof Object)){
var ex__33368__auto__ = e38067;
var statearr_38068_38118 = state_38018;
(statearr_38068_38118[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38018);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38067;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38119 = state_38018;
state_38018 = G__38119;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_38018){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_38018);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_37967,inst_37977,inst_37978,inst_37979,inst_38020,state_val_38027,c__33478__auto___38089,c__19190__auto___38087,id__19191__auto___38088))
})();
var state__33480__auto__ = (function (){var statearr_38069 = f__33479__auto__.call(null);
(statearr_38069[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto____$1);

return statearr_38069;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});
;})(c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_37967,inst_37977,inst_37978,inst_37979,inst_38020,state_val_38027,c__33478__auto___38089,c__19190__auto___38087,id__19191__auto___38088))
})();
var inst_38022 = cljs.core.async.impl.dispatch.run.call(null,inst_38021);
var state_38026__$1 = (function (){var statearr_38070 = state_38026;
(statearr_38070[(12)] = inst_38022);

return statearr_38070;
})();
var statearr_38071_38120 = state_38026__$1;
(statearr_38071_38120[(2)] = inst_38020);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38026__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38027 === (9))){
var inst_37965 = (state_38026[(2)]);
var inst_37966 = cljs.core.async.close_BANG_.call(null,ch);
var inst_37967 = superv.async.check_supervisor.call(null,superv.async.S);
var state_38026__$1 = (function (){var statearr_38072 = state_38026;
(statearr_38072[(13)] = inst_37965);

(statearr_38072[(11)] = inst_37967);

(statearr_38072[(14)] = inst_37966);

return statearr_38072;
})();
var statearr_38073_38121 = state_38026__$1;
(statearr_38073_38121[(2)] = null);

(statearr_38073_38121[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38027 === (5))){
var state_38026__$1 = state_38026;
var statearr_38074_38122 = state_38026__$1;
(statearr_38074_38122[(2)] = null);

(statearr_38074_38122[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38027 === (14))){
var state_38026__$1 = state_38026;
var statearr_38075_38123 = state_38026__$1;
(statearr_38075_38123[(2)] = null);

(statearr_38075_38123[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38027 === (10))){
var state_38026__$1 = state_38026;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38026__$1,(12),ch);
} else {
if((state_val_38027 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_38026,(4),Error,(3),(2));
var inst_37963 = superv.async._abort.call(null,S);
var state_38026__$1 = state_38026;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38026__$1,(9),inst_37963);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___38089,c__19190__auto___38087,id__19191__auto___38088))
;
return ((function (switch__33364__auto__,c__33478__auto___38089,c__19190__auto___38087,id__19191__auto___38088){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_38079 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38079[(0)] = superv$async$state_machine__33365__auto__);

(statearr_38079[(1)] = (1));

return statearr_38079;
});
var superv$async$state_machine__33365__auto____1 = (function (state_38026){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_38026);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e38080){if((e38080 instanceof Object)){
var ex__33368__auto__ = e38080;
var statearr_38081_38124 = state_38026;
(statearr_38081_38124[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38026);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38080;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38125 = state_38026;
state_38026 = G__38125;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_38026){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_38026);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___38089,c__19190__auto___38087,id__19191__auto___38088))
})();
var state__33480__auto__ = (function (){var statearr_38082 = f__33479__auto__.call(null);
(statearr_38082[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___38089);

return statearr_38082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___38089,c__19190__auto___38087,id__19191__auto___38088))
);


return cljs.core.async.tap.call(null,mult,ch,close_QMARK_);
});

superv.async.tap.cljs$lang$maxFixedArity = 4;

/**
 * Safely managed subscription. The channel is closed on abortion and
 *   all pending puts are flushed.
 */
superv.async.sub = (function superv$async$sub(var_args){
var args38126 = [];
var len__10640__auto___38230 = arguments.length;
var i__10641__auto___38231 = (0);
while(true){
if((i__10641__auto___38231 < len__10640__auto___38230)){
args38126.push((arguments[i__10641__auto___38231]));

var G__38232 = (i__10641__auto___38231 + (1));
i__10641__auto___38231 = G__38232;
continue;
} else {
}
break;
}

var G__38128 = args38126.length;
switch (G__38128) {
case 4:
return superv.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.sub.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args38126.length)].join('')));

}
});

superv.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (S,p,topic,ch){
return superv.async.sub.call(null,S,p,topic,ch,false);
});

superv.async.sub.cljs$core$IFn$_invoke$arity$5 = (function (S,p,topic,ch,close_QMARK_){
var c__19190__auto___38234 = superv.async.check_supervisor.call(null,superv.async.S);
var id__19191__auto___38235 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__33478__auto___38236 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___38236,c__19190__auto___38234,id__19191__auto___38235){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___38236,c__19190__auto___38234,id__19191__auto___38235){
return (function (state_38187){
var state_val_38188 = (state_38187[(1)]);
if((state_val_38188 === (1))){
var state_38187__$1 = state_38187;
var statearr_38189_38237 = state_38187__$1;
(statearr_38189_38237[(2)] = null);

(statearr_38189_38237[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38188 === (2))){
var inst_38185 = (state_38187[(2)]);
var state_38187__$1 = state_38187;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38187__$1,inst_38185);
} else {
if((state_val_38188 === (3))){
var inst_38129 = (state_38187[(2)]);
var inst_38130 = superv.async._unregister_go.call(null,S,id__19191__auto___38235);
var state_38187__$1 = (function (){var statearr_38190 = state_38187;
(statearr_38190[(7)] = inst_38130);

(statearr_38190[(8)] = inst_38129);

return statearr_38190;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38187__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38188 === (4))){
var inst_38132 = (state_38187[(9)]);
var inst_38132__$1 = (state_38187[(2)]);
var inst_38133 = cljs.core.ex_data.call(null,inst_38132__$1);
var inst_38134 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_38133);
var inst_38135 = cljs.core._EQ_.call(null,inst_38134,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_38187__$1 = (function (){var statearr_38191 = state_38187;
(statearr_38191[(9)] = inst_38132__$1);

return statearr_38191;
})();
if(inst_38135){
var statearr_38192_38238 = state_38187__$1;
(statearr_38192_38238[(1)] = (5));

} else {
var statearr_38193_38239 = state_38187__$1;
(statearr_38193_38239[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38188 === (5))){
var state_38187__$1 = state_38187;
var statearr_38194_38240 = state_38187__$1;
(statearr_38194_38240[(2)] = null);

(statearr_38194_38240[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38188 === (6))){
var inst_38132 = (state_38187[(9)]);
var inst_38138 = superv.async._track_exception.call(null,S,inst_38132);
var state_38187__$1 = state_38187;
var statearr_38195_38241 = state_38187__$1;
(statearr_38195_38241[(2)] = inst_38138);

(statearr_38195_38241[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38188 === (7))){
var inst_38132 = (state_38187[(9)]);
var inst_38140 = (state_38187[(2)]);
var state_38187__$1 = (function (){var statearr_38196 = state_38187;
(statearr_38196[(10)] = inst_38140);

return statearr_38196;
})();
var statearr_38197_38242 = state_38187__$1;
(statearr_38197_38242[(2)] = inst_38132);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38187__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38188 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_38187,(4),Error,(3),(2));
var inst_38144 = superv.async._abort.call(null,S);
var state_38187__$1 = state_38187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38187__$1,(9),inst_38144);
} else {
if((state_val_38188 === (9))){
var inst_38146 = (state_38187[(2)]);
var inst_38147 = cljs.core.async.close_BANG_.call(null,ch);
var inst_38148 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_38149 = cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))));
var inst_38150 = superv.async._register_go.call(null,S,inst_38149);
var inst_38181 = cljs.core.async.chan.call(null,(1));
var inst_38182 = (function (){var c__19190__auto____$1 = inst_38148;
var id__19191__auto____$1 = inst_38150;
var c__33478__auto____$1 = inst_38181;
return ((function (c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_38146,inst_38147,inst_38148,inst_38149,inst_38150,inst_38181,state_val_38188,c__33478__auto___38236,c__19190__auto___38234,id__19191__auto___38235){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_38146,inst_38147,inst_38148,inst_38149,inst_38150,inst_38181,state_val_38188,c__33478__auto___38236,c__19190__auto___38234,id__19191__auto___38235){
return (function (state_38179){
var state_val_38180 = (state_38179[(1)]);
if((state_val_38180 === (7))){
var inst_38154 = (state_38179[(7)]);
var inst_38162 = (state_38179[(2)]);
var state_38179__$1 = (function (){var statearr_38198 = state_38179;
(statearr_38198[(8)] = inst_38162);

return statearr_38198;
})();
var statearr_38199_38243 = state_38179__$1;
(statearr_38199_38243[(2)] = inst_38154);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38179__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (1))){
var state_38179__$1 = state_38179;
var statearr_38200_38244 = state_38179__$1;
(statearr_38200_38244[(2)] = null);

(statearr_38200_38244[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (4))){
var inst_38154 = (state_38179[(7)]);
var inst_38154__$1 = (state_38179[(2)]);
var inst_38155 = cljs.core.ex_data.call(null,inst_38154__$1);
var inst_38156 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_38155);
var inst_38157 = cljs.core._EQ_.call(null,inst_38156,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_38179__$1 = (function (){var statearr_38201 = state_38179;
(statearr_38201[(7)] = inst_38154__$1);

return statearr_38201;
})();
if(inst_38157){
var statearr_38202_38245 = state_38179__$1;
(statearr_38202_38245[(1)] = (5));

} else {
var statearr_38203_38246 = state_38179__$1;
(statearr_38203_38246[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (13))){
var state_38179__$1 = state_38179;
var statearr_38204_38247 = state_38179__$1;
(statearr_38204_38247[(2)] = null);

(statearr_38204_38247[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (6))){
var inst_38154 = (state_38179[(7)]);
var inst_38160 = superv.async._track_exception.call(null,S,inst_38154);
var state_38179__$1 = state_38179;
var statearr_38205_38248 = state_38179__$1;
(statearr_38205_38248[(2)] = inst_38160);

(statearr_38205_38248[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (3))){
var inst_38151 = (state_38179[(2)]);
var inst_38152 = superv.async._unregister_go.call(null,S,id__19191__auto____$1);
var state_38179__$1 = (function (){var statearr_38206 = state_38179;
(statearr_38206[(9)] = inst_38152);

(statearr_38206[(10)] = inst_38151);

return statearr_38206;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38179__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (12))){
var state_38179__$1 = state_38179;
var statearr_38207_38249 = state_38179__$1;
(statearr_38207_38249[(2)] = null);

(statearr_38207_38249[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (2))){
var inst_38177 = (state_38179[(2)]);
var state_38179__$1 = state_38179;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38179__$1,inst_38177);
} else {
if((state_val_38180 === (11))){
var inst_38168 = (state_38179[(2)]);
var state_38179__$1 = state_38179;
if(cljs.core.truth_(inst_38168)){
var statearr_38208_38250 = state_38179__$1;
(statearr_38208_38250[(1)] = (12));

} else {
var statearr_38209_38251 = state_38179__$1;
(statearr_38209_38251[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (9))){
var state_38179__$1 = state_38179;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38179__$1,(11),ch);
} else {
if((state_val_38180 === (5))){
var state_38179__$1 = state_38179;
var statearr_38210_38252 = state_38179__$1;
(statearr_38210_38252[(2)] = null);

(statearr_38210_38252[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (14))){
var inst_38173 = (state_38179[(2)]);
var state_38179__$1 = state_38179;
var statearr_38211_38253 = state_38179__$1;
(statearr_38211_38253[(2)] = inst_38173);

(statearr_38211_38253[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (10))){
var inst_38175 = (state_38179[(2)]);
var state_38179__$1 = state_38179;
var statearr_38212_38254 = state_38179__$1;
(statearr_38212_38254[(2)] = inst_38175);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38179__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_38179,(4),Error,(3),(2));
var state_38179__$1 = state_38179;
var statearr_38213_38255 = state_38179__$1;
(statearr_38213_38255[(2)] = null);

(statearr_38213_38255[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_38146,inst_38147,inst_38148,inst_38149,inst_38150,inst_38181,state_val_38188,c__33478__auto___38236,c__19190__auto___38234,id__19191__auto___38235))
;
return ((function (switch__33364__auto__,c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_38146,inst_38147,inst_38148,inst_38149,inst_38150,inst_38181,state_val_38188,c__33478__auto___38236,c__19190__auto___38234,id__19191__auto___38235){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_38217 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38217[(0)] = superv$async$state_machine__33365__auto__);

(statearr_38217[(1)] = (1));

return statearr_38217;
});
var superv$async$state_machine__33365__auto____1 = (function (state_38179){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_38179);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e38218){if((e38218 instanceof Object)){
var ex__33368__auto__ = e38218;
var statearr_38219_38256 = state_38179;
(statearr_38219_38256[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38179);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38218;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38257 = state_38179;
state_38179 = G__38257;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_38179){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_38179);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_38146,inst_38147,inst_38148,inst_38149,inst_38150,inst_38181,state_val_38188,c__33478__auto___38236,c__19190__auto___38234,id__19191__auto___38235))
})();
var state__33480__auto__ = (function (){var statearr_38220 = f__33479__auto__.call(null);
(statearr_38220[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto____$1);

return statearr_38220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});
;})(c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_38146,inst_38147,inst_38148,inst_38149,inst_38150,inst_38181,state_val_38188,c__33478__auto___38236,c__19190__auto___38234,id__19191__auto___38235))
})();
var inst_38183 = cljs.core.async.impl.dispatch.run.call(null,inst_38182);
var state_38187__$1 = (function (){var statearr_38221 = state_38187;
(statearr_38221[(11)] = inst_38146);

(statearr_38221[(12)] = inst_38147);

(statearr_38221[(13)] = inst_38183);

return statearr_38221;
})();
var statearr_38222_38258 = state_38187__$1;
(statearr_38222_38258[(2)] = inst_38181);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38187__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___38236,c__19190__auto___38234,id__19191__auto___38235))
;
return ((function (switch__33364__auto__,c__33478__auto___38236,c__19190__auto___38234,id__19191__auto___38235){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_38226 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38226[(0)] = superv$async$state_machine__33365__auto__);

(statearr_38226[(1)] = (1));

return statearr_38226;
});
var superv$async$state_machine__33365__auto____1 = (function (state_38187){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_38187);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e38227){if((e38227 instanceof Object)){
var ex__33368__auto__ = e38227;
var statearr_38228_38259 = state_38187;
(statearr_38228_38259[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38187);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38227;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38260 = state_38187;
state_38187 = G__38260;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_38187){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_38187);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___38236,c__19190__auto___38234,id__19191__auto___38235))
})();
var state__33480__auto__ = (function (){var statearr_38229 = f__33479__auto__.call(null);
(statearr_38229[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___38236);

return statearr_38229;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___38236,c__19190__auto___38234,id__19191__auto___38235))
);


return cljs.core.async.sub.call(null,p,topic,ch,close_QMARK_);
});

superv.async.sub.cljs$lang$maxFixedArity = 5;

/**
 * Creates a supervised channel for transducer xform. Exceptions
 *   immediatly propagate to the supervisor.
 */
superv.async.chan_super = (function superv$async$chan_super(S,buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,(function (e){
return cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(S),e);
}));
});
/**
 * Starts a subsystem with supervised go-routines initialized by start-fn.
 *   Restarts the system on error for retries times with a potential delay in
 *   milliseconds, an optional error-fn predicate determining the retry and a
 *   optional filter by exception type. You can optionally pass a supervisor to
 *   form a supervision tree. Whenever this passed supervisor aborts the context,
 *   this supervisor will close as well. You still need to block on the result of
 *   this supervisor if you want a clean synchronized shutdown. The concept is
 *   similar to http://learnyousomeerlang.com/supervisors
 * 
 *   All blocking channel ops in the subroutines (supervised context) are
 *   aborted with an exception on error to force total termination. The
 *   supervisor waits until all supervised go-routines are finished and
 *   have freed resources before restarting.
 * 
 *   If exceptions are not taken from go-try channels (by error), they become stale
 *   after the stale-timeout and trigger a restart or are propagated to the parent
 *   supervisor (if available) and the return value.
 * 
 *   Note: The signature and behaviour of this function might still change.
 */
superv.async.restarting_supervisor = (function superv$async$restarting_supervisor(var_args){
var args__10647__auto__ = [];
var len__10640__auto___38568 = arguments.length;
var i__10641__auto___38569 = (0);
while(true){
if((i__10641__auto___38569 < len__10640__auto___38568)){
args__10647__auto__.push((arguments[i__10641__auto___38569]));

var G__38570 = (i__10641__auto___38569 + (1));
i__10641__auto___38569 = G__38570;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (start_fn,p__38275){
var map__38276 = p__38275;
var map__38276__$1 = ((((!((map__38276 == null)))?((((map__38276.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38276.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38276):map__38276);
var retries = cljs.core.get.call(null,map__38276__$1,new cljs.core.Keyword(null,"retries","retries",1888092808),Infinity);
var delay = cljs.core.get.call(null,map__38276__$1,new cljs.core.Keyword(null,"delay","delay",-574225219),(0));
var error_fn = cljs.core.get.call(null,map__38276__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),null);
var exception = cljs.core.get.call(null,map__38276__$1,new cljs.core.Keyword(null,"exception","exception",-335277064),Error);
var stale_timeout = cljs.core.get.call(null,map__38276__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((60) * (1000)));
var log_fn = cljs.core.get.call(null,map__38276__$1,new cljs.core.Keyword(null,"log-fn","log-fn",-2003241282),((function (map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout){
return (function (level,msg){
return cljs.core.println.call(null,level,msg);
});})(map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout))
);
var supervisor = cljs.core.get.call(null,map__38276__$1,new cljs.core.Keyword(null,"supervisor","supervisor",-134060208));
var retries__$1 = (function (){var or__9419__auto__ = retries;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return Infinity;
}
})();
var out_ch = cljs.core.async.chan.call(null);
var c__33478__auto___38571 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_38467){
var state_val_38468 = (state_38467[(1)]);
if((state_val_38468 === (7))){
var inst_38282 = (state_38467[(7)]);
var inst_38410 = (state_38467[(2)]);
var inst_38411 = cljs.core.nth.call(null,inst_38410,(0),null);
var inst_38412 = cljs.core.nth.call(null,inst_38410,(1),null);
var inst_38413 = cljs.core._EQ_.call(null,inst_38412,inst_38282);
var inst_38414 = !(inst_38413);
var state_38467__$1 = (function (){var statearr_38469 = state_38467;
(statearr_38469[(8)] = inst_38411);

return statearr_38469;
})();
if(inst_38414){
var statearr_38470_38572 = state_38467__$1;
(statearr_38470_38572[(1)] = (8));

} else {
var statearr_38471_38573 = state_38467__$1;
(statearr_38471_38573[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38468 === (20))){
var inst_38411 = (state_38467[(8)]);
var inst_38442 = (state_38467[(2)]);
var inst_38443 = cljs.core.async.put_BANG_.call(null,out_ch,inst_38411);
var inst_38444 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_38467__$1 = (function (){var statearr_38472 = state_38467;
(statearr_38472[(9)] = inst_38443);

(statearr_38472[(10)] = inst_38442);

return statearr_38472;
})();
var statearr_38473_38574 = state_38467__$1;
(statearr_38473_38574[(2)] = inst_38444);

(statearr_38473_38574[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38468 === (1))){
var inst_38278 = retries__$1;
var state_38467__$1 = (function (){var statearr_38474 = state_38467;
(statearr_38474[(11)] = inst_38278);

return statearr_38474;
})();
var statearr_38475_38575 = state_38467__$1;
(statearr_38475_38575[(2)] = null);

(statearr_38475_38575[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38468 === (4))){
var inst_38291 = (state_38467[(12)]);
var inst_38280 = (state_38467[(13)]);
var inst_38282 = (state_38467[(7)]);
var inst_38281 = (state_38467[(14)]);
var inst_38290 = (state_38467[(15)]);
var inst_38278 = (state_38467[(11)]);
var inst_38293 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_38294 = cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"supervisor","supervisor",1506471319,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ab-ch","ab-ch",-698106711,null)));
var inst_38295 = superv.async._register_go.call(null,supervisor,inst_38294);
var inst_38320 = cljs.core.async.chan.call(null,(1));
var inst_38321 = (function (){var stale_timeout__$1 = (1000);
var c__33478__auto____$1 = inst_38320;
var err_ch = inst_38280;
var ab_ch = inst_38281;
var res_ch = inst_38291;
var close_ch = inst_38282;
var retries__$2 = inst_38278;
var c__19190__auto__ = inst_38293;
var s = inst_38290;
var id__19191__auto__ = inst_38295;
return ((function (stale_timeout__$1,c__33478__auto____$1,err_ch,ab_ch,res_ch,close_ch,retries__$2,c__19190__auto__,s,id__19191__auto__,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38293,inst_38294,inst_38295,inst_38320,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (stale_timeout__$1,c__33478__auto____$1,err_ch,ab_ch,res_ch,close_ch,retries__$2,c__19190__auto__,s,id__19191__auto__,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38293,inst_38294,inst_38295,inst_38320,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_38318){
var state_val_38319 = (state_38318[(1)]);
if((state_val_38319 === (1))){
var state_38318__$1 = state_38318;
var statearr_38476_38576 = state_38318__$1;
(statearr_38476_38576[(2)] = null);

(statearr_38476_38576[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38319 === (2))){
var inst_38316 = (state_38318[(2)]);
var state_38318__$1 = state_38318;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38318__$1,inst_38316);
} else {
if((state_val_38319 === (3))){
var inst_38296 = (state_38318[(2)]);
var inst_38297 = superv.async._unregister_go.call(null,supervisor,id__19191__auto__);
var state_38318__$1 = (function (){var statearr_38477 = state_38318;
(statearr_38477[(7)] = inst_38297);

(statearr_38477[(8)] = inst_38296);

return statearr_38477;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38318__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38319 === (4))){
var inst_38299 = (state_38318[(9)]);
var inst_38299__$1 = (state_38318[(2)]);
var inst_38300 = cljs.core.ex_data.call(null,inst_38299__$1);
var inst_38301 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_38300);
var inst_38302 = cljs.core._EQ_.call(null,inst_38301,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_38318__$1 = (function (){var statearr_38478 = state_38318;
(statearr_38478[(9)] = inst_38299__$1);

return statearr_38478;
})();
if(inst_38302){
var statearr_38479_38577 = state_38318__$1;
(statearr_38479_38577[(1)] = (5));

} else {
var statearr_38480_38578 = state_38318__$1;
(statearr_38480_38578[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38319 === (5))){
var state_38318__$1 = state_38318;
var statearr_38481_38579 = state_38318__$1;
(statearr_38481_38579[(2)] = null);

(statearr_38481_38579[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38319 === (6))){
var inst_38299 = (state_38318[(9)]);
var inst_38305 = superv.async._track_exception.call(null,supervisor,inst_38299);
var state_38318__$1 = state_38318;
var statearr_38482_38580 = state_38318__$1;
(statearr_38482_38580[(2)] = inst_38305);

(statearr_38482_38580[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38319 === (7))){
var inst_38299 = (state_38318[(9)]);
var inst_38307 = (state_38318[(2)]);
var state_38318__$1 = (function (){var statearr_38483 = state_38318;
(statearr_38483[(10)] = inst_38307);

return statearr_38483;
})();
var statearr_38484_38581 = state_38318__$1;
(statearr_38484_38581[(2)] = inst_38299);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38318__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38319 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_38318,(4),Error,(3),(2));
var inst_38311 = superv.async._abort.call(null,supervisor);
var state_38318__$1 = state_38318;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38318__$1,(9),inst_38311);
} else {
if((state_val_38319 === (9))){
var inst_38313 = (state_38318[(2)]);
var inst_38314 = cljs.core.async.close_BANG_.call(null,ab_ch);
var state_38318__$1 = (function (){var statearr_38485 = state_38318;
(statearr_38485[(11)] = inst_38313);

return statearr_38485;
})();
var statearr_38486_38582 = state_38318__$1;
(statearr_38486_38582[(2)] = inst_38314);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38318__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(stale_timeout__$1,c__33478__auto____$1,err_ch,ab_ch,res_ch,close_ch,retries__$2,c__19190__auto__,s,id__19191__auto__,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38293,inst_38294,inst_38295,inst_38320,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__33364__auto__,stale_timeout__$1,c__33478__auto____$1,err_ch,ab_ch,res_ch,close_ch,retries__$2,c__19190__auto__,s,id__19191__auto__,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38293,inst_38294,inst_38295,inst_38320,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_38490 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38490[(0)] = superv$async$state_machine__33365__auto__);

(statearr_38490[(1)] = (1));

return statearr_38490;
});
var superv$async$state_machine__33365__auto____1 = (function (state_38318){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_38318);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e38491){if((e38491 instanceof Object)){
var ex__33368__auto__ = e38491;
var statearr_38492_38583 = state_38318;
(statearr_38492_38583[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38318);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38491;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38584 = state_38318;
state_38318 = G__38584;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_38318){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_38318);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,stale_timeout__$1,c__33478__auto____$1,err_ch,ab_ch,res_ch,close_ch,retries__$2,c__19190__auto__,s,id__19191__auto__,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38293,inst_38294,inst_38295,inst_38320,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__33480__auto__ = (function (){var statearr_38493 = f__33479__auto__.call(null);
(statearr_38493[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto____$1);

return statearr_38493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});
;})(stale_timeout__$1,c__33478__auto____$1,err_ch,ab_ch,res_ch,close_ch,retries__$2,c__19190__auto__,s,id__19191__auto__,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38293,inst_38294,inst_38295,inst_38320,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_38322 = cljs.core.async.impl.dispatch.run.call(null,inst_38321);
var state_38467__$1 = (function (){var statearr_38494 = state_38467;
(statearr_38494[(16)] = inst_38322);

return statearr_38494;
})();
var statearr_38495_38585 = state_38467__$1;
(statearr_38495_38585[(2)] = inst_38320);

(statearr_38495_38585[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38468 === (15))){
var inst_38411 = (state_38467[(8)]);
var inst_38433 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38434 = [new cljs.core.Keyword(null,"passing-error","passing-error",-1357712542),inst_38411];
var inst_38435 = cljs.core.PersistentHashMap.fromArrays(inst_38433,inst_38434);
var inst_38436 = log_fn.call(null,new cljs.core.Keyword(null,"error","error",-978969032),inst_38435);
var state_38467__$1 = (function (){var statearr_38496 = state_38467;
(statearr_38496[(17)] = inst_38436);

return statearr_38496;
})();
if(cljs.core.truth_(supervisor)){
var statearr_38497_38586 = state_38467__$1;
(statearr_38497_38586[(1)] = (18));

} else {
var statearr_38498_38587 = state_38467__$1;
(statearr_38498_38587[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38468 === (21))){
var inst_38411 = (state_38467[(8)]);
var inst_38278 = (state_38467[(11)]);
var inst_38448 = (state_38467[(2)]);
var inst_38449 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"further-retries","further-retries",1297645153)];
var inst_38450 = [new cljs.core.Keyword(null,"retry","retry",-614012896),inst_38411,inst_38278];
var inst_38451 = cljs.core.PersistentHashMap.fromArrays(inst_38449,inst_38450);
var inst_38452 = log_fn.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),inst_38451);
var inst_38453 = (inst_38278 - (1));
var inst_38278__$1 = inst_38453;
var state_38467__$1 = (function (){var statearr_38499 = state_38467;
(statearr_38499[(18)] = inst_38452);

(statearr_38499[(19)] = inst_38448);

(statearr_38499[(11)] = inst_38278__$1);

return statearr_38499;
})();
var statearr_38500_38588 = state_38467__$1;
(statearr_38500_38588[(2)] = null);

(statearr_38500_38588[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38468 === (13))){
var inst_38411 = (state_38467[(8)]);
var inst_38425 = error_fn.call(null,inst_38411);
var state_38467__$1 = state_38467;
var statearr_38501_38589 = state_38467__$1;
(statearr_38501_38589[(2)] = inst_38425);

(statearr_38501_38589[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38468 === (22))){
var inst_38459 = (state_38467[(2)]);
var inst_38460 = cljs.core.async.put_BANG_.call(null,out_ch,inst_38459);
var inst_38461 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_38467__$1 = (function (){var statearr_38502 = state_38467;
(statearr_38502[(20)] = inst_38460);

return statearr_38502;
})();
var statearr_38503_38590 = state_38467__$1;
(statearr_38503_38590[(2)] = inst_38461);

(statearr_38503_38590[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38468 === (6))){
var inst_38291 = (state_38467[(12)]);
var inst_38280 = (state_38467[(13)]);
var inst_38282 = (state_38467[(7)]);
var inst_38281 = (state_38467[(14)]);
var inst_38290 = (state_38467[(15)]);
var inst_38278 = (state_38467[(11)]);
var inst_38325 = (state_38467[(2)]);
var inst_38372 = cljs.core.async.chan.call(null,(1));
var inst_38373 = (function (){var retries__$2 = inst_38278;
var err_ch = inst_38280;
var ab_ch = inst_38281;
var close_ch = inst_38282;
var s = inst_38290;
var res_ch = inst_38291;
var stale_timeout__$1 = (1000);
var c__33478__auto____$1 = inst_38372;
return ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38325,inst_38372,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38325,inst_38372,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_38370){
var state_val_38371 = (state_38370[(1)]);
if((state_val_38371 === (7))){
var inst_38345 = (state_38370[(7)]);
var inst_38332 = (state_38370[(2)]);
var inst_38340 = (function (){return ((function (inst_38345,inst_38332,state_val_38371,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38325,inst_38372,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (p__38339){
var vec__38504 = p__38339;
var k = cljs.core.nth.call(null,vec__38504,(0),null);
var v = cljs.core.nth.call(null,vec__38504,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout__$1) > v.getTime());
});
;})(inst_38345,inst_38332,state_val_38371,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38325,inst_38372,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_38341 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_38342 = cljs.core.deref.call(null,inst_38341);
var inst_38343 = cljs.core.filter.call(null,inst_38340,inst_38342);
var inst_38344 = cljs.core.nth.call(null,inst_38343,(0),null);
var inst_38345__$1 = cljs.core.nth.call(null,inst_38344,(0),null);
var inst_38346 = cljs.core.nth.call(null,inst_38344,(1),null);
var state_38370__$1 = (function (){var statearr_38507 = state_38370;
(statearr_38507[(8)] = inst_38332);

(statearr_38507[(9)] = inst_38346);

(statearr_38507[(7)] = inst_38345__$1);

return statearr_38507;
})();
if(cljs.core.truth_(inst_38345__$1)){
var statearr_38508_38591 = state_38370__$1;
(statearr_38508_38591[(1)] = (8));

} else {
var statearr_38509_38592 = state_38370__$1;
(statearr_38509_38592[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38371 === (1))){
var state_38370__$1 = state_38370;
var statearr_38510_38593 = state_38370__$1;
(statearr_38510_38593[(2)] = null);

(statearr_38510_38593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38371 === (4))){
var state_38370__$1 = state_38370;
var statearr_38511_38594 = state_38370__$1;
(statearr_38511_38594[(2)] = null);

(statearr_38511_38594[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38371 === (13))){
var inst_38345 = (state_38370[(7)]);
var inst_38358 = (state_38370[(2)]);
var inst_38359 = superv.async._free_exception.call(null,s,inst_38345);
var inst_38360 = cljs.core.async.put_BANG_.call(null,err_ch,inst_38345);
var state_38370__$1 = (function (){var statearr_38512 = state_38370;
(statearr_38512[(10)] = inst_38358);

(statearr_38512[(11)] = inst_38359);

return statearr_38512;
})();
var statearr_38513_38595 = state_38370__$1;
(statearr_38513_38595[(2)] = inst_38360);

(statearr_38513_38595[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38371 === (6))){
var inst_38366 = (state_38370[(2)]);
var state_38370__$1 = state_38370;
var statearr_38514_38596 = state_38370__$1;
(statearr_38514_38596[(2)] = inst_38366);

(statearr_38514_38596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38371 === (3))){
var inst_38368 = (state_38370[(2)]);
var state_38370__$1 = state_38370;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38370__$1,inst_38368);
} else {
if((state_val_38371 === (12))){
var inst_38345 = (state_38370[(7)]);
var inst_38353 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38354 = [new cljs.core.Keyword(null,"stale-error-in-supervisor","stale-error-in-supervisor",-123257662),inst_38345];
var inst_38355 = cljs.core.PersistentHashMap.fromArrays(inst_38353,inst_38354);
var inst_38356 = log_fn.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_38355);
var state_38370__$1 = state_38370;
var statearr_38515_38597 = state_38370__$1;
(statearr_38515_38597[(2)] = inst_38356);

(statearr_38515_38597[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38371 === (2))){
var inst_38327 = cljs.core.async.poll_BANG_.call(null,ab_ch);
var state_38370__$1 = state_38370;
if(cljs.core.truth_(inst_38327)){
var statearr_38516_38598 = state_38370__$1;
(statearr_38516_38598[(1)] = (4));

} else {
var statearr_38517_38599 = state_38370__$1;
(statearr_38517_38599[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38371 === (11))){
var state_38370__$1 = state_38370;
var statearr_38518_38600 = state_38370__$1;
(statearr_38518_38600[(2)] = null);

(statearr_38518_38600[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38371 === (9))){
var state_38370__$1 = state_38370;
var statearr_38519_38601 = state_38370__$1;
(statearr_38519_38601[(2)] = null);

(statearr_38519_38601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38371 === (5))){
var inst_38330 = cljs.core.async.timeout.call(null,stale_timeout__$1);
var state_38370__$1 = state_38370;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38370__$1,(7),inst_38330);
} else {
if((state_val_38371 === (10))){
var inst_38364 = (state_38370[(2)]);
var state_38370__$1 = state_38370;
var statearr_38520_38602 = state_38370__$1;
(statearr_38520_38602[(2)] = inst_38364);

(statearr_38520_38602[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38371 === (8))){
var inst_38345 = (state_38370[(7)]);
var inst_38348 = cljs.core.ex_data.call(null,inst_38345);
var inst_38349 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_38348);
var inst_38350 = cljs.core._EQ_.call(null,inst_38349,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_38370__$1 = state_38370;
if(inst_38350){
var statearr_38521_38603 = state_38370__$1;
(statearr_38521_38603[(1)] = (11));

} else {
var statearr_38522_38604 = state_38370__$1;
(statearr_38522_38604[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38325,inst_38372,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__33364__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38325,inst_38372,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_38526 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38526[(0)] = superv$async$state_machine__33365__auto__);

(statearr_38526[(1)] = (1));

return statearr_38526;
});
var superv$async$state_machine__33365__auto____1 = (function (state_38370){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_38370);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e38527){if((e38527 instanceof Object)){
var ex__33368__auto__ = e38527;
var statearr_38528_38605 = state_38370;
(statearr_38528_38605[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38370);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38527;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38606 = state_38370;
state_38370 = G__38606;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_38370){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_38370);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38325,inst_38372,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__33480__auto__ = (function (){var statearr_38529 = f__33479__auto__.call(null);
(statearr_38529[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto____$1);

return statearr_38529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});
;})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38325,inst_38372,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_38374 = cljs.core.async.impl.dispatch.run.call(null,inst_38373);
var inst_38400 = cljs.core.async.chan.call(null,(1));
var inst_38401 = (function (){var retries__$2 = inst_38278;
var err_ch = inst_38280;
var ab_ch = inst_38281;
var close_ch = inst_38282;
var s = inst_38290;
var res_ch = inst_38291;
var stale_timeout__$1 = (1000);
var c__33478__auto____$1 = inst_38400;
return ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38325,inst_38372,inst_38373,inst_38374,inst_38400,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38325,inst_38372,inst_38373,inst_38374,inst_38400,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_38398){
var state_val_38399 = (state_38398[(1)]);
if((state_val_38399 === (1))){
var inst_38375 = (0);
var state_38398__$1 = (function (){var statearr_38530 = state_38398;
(statearr_38530[(7)] = inst_38375);

return statearr_38530;
})();
var statearr_38531_38607 = state_38398__$1;
(statearr_38531_38607[(2)] = null);

(statearr_38531_38607[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38399 === (2))){
var inst_38377 = new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(s);
var inst_38378 = cljs.core.deref.call(null,inst_38377);
var inst_38379 = cljs.core.empty_QMARK_.call(null,inst_38378);
var inst_38380 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_38381 = cljs.core.deref.call(null,inst_38380);
var inst_38382 = cljs.core.empty_QMARK_.call(null,inst_38381);
var inst_38383 = (inst_38379) && (inst_38382);
var inst_38384 = cljs.core.not.call(null,inst_38383);
var state_38398__$1 = state_38398;
if(inst_38384){
var statearr_38532_38608 = state_38398__$1;
(statearr_38532_38608[(1)] = (4));

} else {
var statearr_38533_38609 = state_38398__$1;
(statearr_38533_38609[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38399 === (3))){
var inst_38396 = (state_38398[(2)]);
var state_38398__$1 = state_38398;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38398__$1,inst_38396);
} else {
if((state_val_38399 === (4))){
var inst_38386 = cljs.core.async.timeout.call(null,(100));
var state_38398__$1 = state_38398;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38398__$1,(7),inst_38386);
} else {
if((state_val_38399 === (5))){
var inst_38392 = cljs.core.async.close_BANG_.call(null,close_ch);
var state_38398__$1 = state_38398;
var statearr_38534_38610 = state_38398__$1;
(statearr_38534_38610[(2)] = inst_38392);

(statearr_38534_38610[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38399 === (6))){
var inst_38394 = (state_38398[(2)]);
var state_38398__$1 = state_38398;
var statearr_38535_38611 = state_38398__$1;
(statearr_38535_38611[(2)] = inst_38394);

(statearr_38535_38611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38399 === (7))){
var inst_38375 = (state_38398[(7)]);
var inst_38388 = (state_38398[(2)]);
var inst_38389 = (inst_38375 + (1));
var inst_38375__$1 = inst_38389;
var state_38398__$1 = (function (){var statearr_38536 = state_38398;
(statearr_38536[(7)] = inst_38375__$1);

(statearr_38536[(8)] = inst_38388);

return statearr_38536;
})();
var statearr_38537_38612 = state_38398__$1;
(statearr_38537_38612[(2)] = null);

(statearr_38537_38612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38325,inst_38372,inst_38373,inst_38374,inst_38400,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__33364__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38325,inst_38372,inst_38373,inst_38374,inst_38400,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_38541 = [null,null,null,null,null,null,null,null,null];
(statearr_38541[(0)] = superv$async$state_machine__33365__auto__);

(statearr_38541[(1)] = (1));

return statearr_38541;
});
var superv$async$state_machine__33365__auto____1 = (function (state_38398){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_38398);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e38542){if((e38542 instanceof Object)){
var ex__33368__auto__ = e38542;
var statearr_38543_38613 = state_38398;
(statearr_38543_38613[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38398);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38542;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38614 = state_38398;
state_38398 = G__38614;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_38398){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_38398);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38325,inst_38372,inst_38373,inst_38374,inst_38400,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__33480__auto__ = (function (){var statearr_38544 = f__33479__auto__.call(null);
(statearr_38544[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto____$1);

return statearr_38544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});
;})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_38291,inst_38280,inst_38282,inst_38281,inst_38290,inst_38278,inst_38325,inst_38372,inst_38373,inst_38374,inst_38400,state_val_38468,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_38402 = cljs.core.async.impl.dispatch.run.call(null,inst_38401);
var inst_38406 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38407 = [inst_38280,inst_38282];
var inst_38408 = (new cljs.core.PersistentVector(null,2,(5),inst_38406,inst_38407,null));
var state_38467__$1 = (function (){var statearr_38545 = state_38467;
(statearr_38545[(21)] = inst_38402);

(statearr_38545[(22)] = inst_38374);

(statearr_38545[(23)] = inst_38325);

return statearr_38545;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_38467__$1,(7),inst_38408,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_38468 === (17))){
var inst_38456 = (state_38467[(2)]);
var state_38467__$1 = state_38467;
var statearr_38546_38615 = state_38467__$1;
(statearr_38546_38615[(2)] = inst_38456);

(statearr_38546_38615[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38468 === (3))){
var inst_38465 = (state_38467[(2)]);
var state_38467__$1 = state_38467;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38467__$1,inst_38465);
} else {
if((state_val_38468 === (12))){
var inst_38422 = (state_38467[(24)]);
var state_38467__$1 = state_38467;
var statearr_38547_38616 = state_38467__$1;
(statearr_38547_38616[(2)] = inst_38422);

(statearr_38547_38616[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38468 === (2))){
var inst_38280 = (state_38467[(13)]);
var inst_38281 = (state_38467[(14)]);
var inst_38290 = (state_38467[(15)]);
var inst_38280__$1 = cljs.core.async.chan.call(null);
var inst_38281__$1 = cljs.core.async.chan.call(null);
var inst_38282 = cljs.core.async.chan.call(null);
var inst_38283 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),new cljs.core.Keyword(null,"restarting","restarting",760677572)];
var inst_38284 = cljs.core.PersistentHashMap.EMPTY;
var inst_38285 = cljs.core.atom.call(null,inst_38284);
var inst_38286 = cljs.core.PersistentHashMap.EMPTY;
var inst_38287 = cljs.core.atom.call(null,inst_38286);
var inst_38288 = [inst_38280__$1,inst_38281__$1,inst_38285,inst_38287,true];
var inst_38289 = cljs.core.PersistentHashMap.fromArrays(inst_38283,inst_38288);
var inst_38290__$1 = superv.async.map__GT_TrackingSupervisor.call(null,inst_38289);
var inst_38291 = start_fn.call(null,inst_38290__$1);
var state_38467__$1 = (function (){var statearr_38548 = state_38467;
(statearr_38548[(12)] = inst_38291);

(statearr_38548[(13)] = inst_38280__$1);

(statearr_38548[(7)] = inst_38282);

(statearr_38548[(14)] = inst_38281__$1);

(statearr_38548[(15)] = inst_38290__$1);

return statearr_38548;
})();
if(cljs.core.truth_(supervisor)){
var statearr_38549_38617 = state_38467__$1;
(statearr_38549_38617[(1)] = (4));

} else {
var statearr_38550_38618 = state_38467__$1;
(statearr_38550_38618[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38468 === (19))){
var state_38467__$1 = state_38467;
var statearr_38551_38619 = state_38467__$1;
(statearr_38551_38619[(2)] = null);

(statearr_38551_38619[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38468 === (11))){
var inst_38422 = (state_38467[(24)]);
var inst_38411 = (state_38467[(8)]);
var inst_38419 = (state_38467[(2)]);
var inst_38420 = (inst_38411 instanceof exception);
var inst_38421 = cljs.core.not.call(null,inst_38420);
var inst_38422__$1 = cljs.core.not.call(null,error_fn);
var state_38467__$1 = (function (){var statearr_38552 = state_38467;
(statearr_38552[(25)] = inst_38421);

(statearr_38552[(24)] = inst_38422__$1);

(statearr_38552[(26)] = inst_38419);

return statearr_38552;
})();
if(inst_38422__$1){
var statearr_38553_38620 = state_38467__$1;
(statearr_38553_38620[(1)] = (12));

} else {
var statearr_38554_38621 = state_38467__$1;
(statearr_38554_38621[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38468 === (9))){
var inst_38291 = (state_38467[(12)]);
var state_38467__$1 = state_38467;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38467__$1,(22),inst_38291);
} else {
if((state_val_38468 === (5))){
var state_38467__$1 = state_38467;
var statearr_38555_38622 = state_38467__$1;
(statearr_38555_38622[(2)] = null);

(statearr_38555_38622[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38468 === (14))){
var inst_38421 = (state_38467[(25)]);
var inst_38278 = (state_38467[(11)]);
var inst_38427 = (state_38467[(2)]);
var inst_38428 = cljs.core.not.call(null,inst_38427);
var inst_38429 = (inst_38278 > (0));
var inst_38430 = cljs.core.not.call(null,inst_38429);
var inst_38431 = (inst_38421) || (inst_38428) || (inst_38430);
var state_38467__$1 = state_38467;
if(cljs.core.truth_(inst_38431)){
var statearr_38556_38623 = state_38467__$1;
(statearr_38556_38623[(1)] = (15));

} else {
var statearr_38557_38624 = state_38467__$1;
(statearr_38557_38624[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38468 === (16))){
var inst_38446 = cljs.core.async.timeout.call(null,delay);
var state_38467__$1 = state_38467;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38467__$1,(21),inst_38446);
} else {
if((state_val_38468 === (10))){
var inst_38463 = (state_38467[(2)]);
var state_38467__$1 = state_38467;
var statearr_38558_38625 = state_38467__$1;
(statearr_38558_38625[(2)] = inst_38463);

(statearr_38558_38625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38468 === (18))){
var inst_38411 = (state_38467[(8)]);
var inst_38438 = superv.async._error.call(null,supervisor);
var inst_38439 = cljs.core.async.put_BANG_.call(null,inst_38438,inst_38411);
var state_38467__$1 = state_38467;
var statearr_38559_38626 = state_38467__$1;
(statearr_38559_38626[(2)] = inst_38439);

(statearr_38559_38626[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38468 === (8))){
var inst_38280 = (state_38467[(13)]);
var inst_38282 = (state_38467[(7)]);
var inst_38281 = (state_38467[(14)]);
var inst_38416 = cljs.core.async.close_BANG_.call(null,inst_38280);
var inst_38417 = cljs.core.async.close_BANG_.call(null,inst_38281);
var state_38467__$1 = (function (){var statearr_38560 = state_38467;
(statearr_38560[(27)] = inst_38417);

(statearr_38560[(28)] = inst_38416);

return statearr_38560;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38467__$1,(11),inst_38282);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__33364__auto__,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_38564 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38564[(0)] = superv$async$state_machine__33365__auto__);

(statearr_38564[(1)] = (1));

return statearr_38564;
});
var superv$async$state_machine__33365__auto____1 = (function (state_38467){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_38467);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e38565){if((e38565 instanceof Object)){
var ex__33368__auto__ = e38565;
var statearr_38566_38627 = state_38467;
(statearr_38566_38627[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38467);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38565;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38628 = state_38467;
state_38467 = G__38628;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_38467){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_38467);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__33480__auto__ = (function (){var statearr_38567 = f__33479__auto__.call(null);
(statearr_38567[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___38571);

return statearr_38567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___38571,retries__$1,out_ch,map__38276,map__38276__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
);


return out_ch;
});

superv.async.restarting_supervisor.cljs$lang$maxFixedArity = (1);

superv.async.restarting_supervisor.cljs$lang$applyTo = (function (seq38273){
var G__38274 = cljs.core.first.call(null,seq38273);
var seq38273__$1 = cljs.core.next.call(null,seq38273);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic(G__38274,seq38273__$1);
});


//# sourceMappingURL=async.js.map