// Compiled by ClojureScript 1.9.521 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args50486 = [];
var len__10640__auto___50492 = arguments.length;
var i__10641__auto___50493 = (0);
while(true){
if((i__10641__auto___50493 < len__10640__auto___50492)){
args50486.push((arguments[i__10641__auto___50493]));

var G__50494 = (i__10641__auto___50493 + (1));
i__10641__auto___50493 = G__50494;
continue;
} else {
}
break;
}

var G__50488 = args50486.length;
switch (G__50488) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50486.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async50489 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async50489 = (function (f,blockable,meta50490){
this.f = f;
this.blockable = blockable;
this.meta50490 = meta50490;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async50489.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_50491,meta50490__$1){
var self__ = this;
var _50491__$1 = this;
return (new cljs.core.async.t_cljs$core$async50489(self__.f,self__.blockable,meta50490__$1));
});

cljs.core.async.t_cljs$core$async50489.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_50491){
var self__ = this;
var _50491__$1 = this;
return self__.meta50490;
});

cljs.core.async.t_cljs$core$async50489.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async50489.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async50489.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async50489.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async50489.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta50490","meta50490",-1569651673,null)], null);
});

cljs.core.async.t_cljs$core$async50489.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async50489.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async50489";

cljs.core.async.t_cljs$core$async50489.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async50489");
});

cljs.core.async.__GT_t_cljs$core$async50489 = (function cljs$core$async$__GT_t_cljs$core$async50489(f__$1,blockable__$1,meta50490){
return (new cljs.core.async.t_cljs$core$async50489(f__$1,blockable__$1,meta50490));
});

}

return (new cljs.core.async.t_cljs$core$async50489(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args50498 = [];
var len__10640__auto___50501 = arguments.length;
var i__10641__auto___50502 = (0);
while(true){
if((i__10641__auto___50502 < len__10640__auto___50501)){
args50498.push((arguments[i__10641__auto___50502]));

var G__50503 = (i__10641__auto___50502 + (1));
i__10641__auto___50502 = G__50503;
continue;
} else {
}
break;
}

var G__50500 = args50498.length;
switch (G__50500) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50498.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args50505 = [];
var len__10640__auto___50508 = arguments.length;
var i__10641__auto___50509 = (0);
while(true){
if((i__10641__auto___50509 < len__10640__auto___50508)){
args50505.push((arguments[i__10641__auto___50509]));

var G__50510 = (i__10641__auto___50509 + (1));
i__10641__auto___50509 = G__50510;
continue;
} else {
}
break;
}

var G__50507 = args50505.length;
switch (G__50507) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50505.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args50512 = [];
var len__10640__auto___50515 = arguments.length;
var i__10641__auto___50516 = (0);
while(true){
if((i__10641__auto___50516 < len__10640__auto___50515)){
args50512.push((arguments[i__10641__auto___50516]));

var G__50517 = (i__10641__auto___50516 + (1));
i__10641__auto___50516 = G__50517;
continue;
} else {
}
break;
}

var G__50514 = args50512.length;
switch (G__50514) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50512.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_50519 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_50519);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_50519,ret){
return (function (){
return fn1.call(null,val_50519);
});})(val_50519,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args50520 = [];
var len__10640__auto___50523 = arguments.length;
var i__10641__auto___50524 = (0);
while(true){
if((i__10641__auto___50524 < len__10640__auto___50523)){
args50520.push((arguments[i__10641__auto___50524]));

var G__50525 = (i__10641__auto___50524 + (1));
i__10641__auto___50524 = G__50525;
continue;
} else {
}
break;
}

var G__50522 = args50520.length;
switch (G__50522) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50520.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6736__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6736__auto__)){
var ret = temp__6736__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6736__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6736__auto__)){
var retb = temp__6736__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6736__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6736__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__10440__auto___50527 = n;
var x_50528 = (0);
while(true){
if((x_50528 < n__10440__auto___50527)){
(a[x_50528] = (0));

var G__50529 = (x_50528 + (1));
x_50528 = G__50529;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__50530 = (i + (1));
i = G__50530;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async50534 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async50534 = (function (flag,meta50535){
this.flag = flag;
this.meta50535 = meta50535;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async50534.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_50536,meta50535__$1){
var self__ = this;
var _50536__$1 = this;
return (new cljs.core.async.t_cljs$core$async50534(self__.flag,meta50535__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async50534.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_50536){
var self__ = this;
var _50536__$1 = this;
return self__.meta50535;
});})(flag))
;

cljs.core.async.t_cljs$core$async50534.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async50534.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async50534.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async50534.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async50534.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta50535","meta50535",-6729919,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async50534.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async50534.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async50534";

cljs.core.async.t_cljs$core$async50534.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async50534");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async50534 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async50534(flag__$1,meta50535){
return (new cljs.core.async.t_cljs$core$async50534(flag__$1,meta50535));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async50534(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async50540 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async50540 = (function (flag,cb,meta50541){
this.flag = flag;
this.cb = cb;
this.meta50541 = meta50541;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async50540.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_50542,meta50541__$1){
var self__ = this;
var _50542__$1 = this;
return (new cljs.core.async.t_cljs$core$async50540(self__.flag,self__.cb,meta50541__$1));
});

cljs.core.async.t_cljs$core$async50540.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_50542){
var self__ = this;
var _50542__$1 = this;
return self__.meta50541;
});

cljs.core.async.t_cljs$core$async50540.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async50540.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async50540.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async50540.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async50540.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta50541","meta50541",-234897206,null)], null);
});

cljs.core.async.t_cljs$core$async50540.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async50540.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async50540";

cljs.core.async.t_cljs$core$async50540.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async50540");
});

cljs.core.async.__GT_t_cljs$core$async50540 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async50540(flag__$1,cb__$1,meta50541){
return (new cljs.core.async.t_cljs$core$async50540(flag__$1,cb__$1,meta50541));
});

}

return (new cljs.core.async.t_cljs$core$async50540(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__50543_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__50543_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__50544_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__50544_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__9419__auto__ = wport;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return port;
}
})()], null));
} else {
var G__50545 = (i + (1));
i = G__50545;
continue;
}
} else {
return null;
}
break;
}
})();
var or__9419__auto__ = ret;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6738__auto__ = (function (){var and__9407__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__9407__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__9407__auto__;
}
})();
if(cljs.core.truth_(temp__6738__auto__)){
var got = temp__6738__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___50551 = arguments.length;
var i__10641__auto___50552 = (0);
while(true){
if((i__10641__auto___50552 < len__10640__auto___50551)){
args__10647__auto__.push((arguments[i__10641__auto___50552]));

var G__50553 = (i__10641__auto___50552 + (1));
i__10641__auto___50552 = G__50553;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__50548){
var map__50549 = p__50548;
var map__50549__$1 = ((((!((map__50549 == null)))?((((map__50549.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50549.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50549):map__50549);
var opts = map__50549__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq50546){
var G__50547 = cljs.core.first.call(null,seq50546);
var seq50546__$1 = cljs.core.next.call(null,seq50546);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__50547,seq50546__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args50554 = [];
var len__10640__auto___50604 = arguments.length;
var i__10641__auto___50605 = (0);
while(true){
if((i__10641__auto___50605 < len__10640__auto___50604)){
args50554.push((arguments[i__10641__auto___50605]));

var G__50606 = (i__10641__auto___50605 + (1));
i__10641__auto___50605 = G__50606;
continue;
} else {
}
break;
}

var G__50556 = args50554.length;
switch (G__50556) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50554.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__33478__auto___50608 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___50608){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___50608){
return (function (state_50580){
var state_val_50581 = (state_50580[(1)]);
if((state_val_50581 === (7))){
var inst_50576 = (state_50580[(2)]);
var state_50580__$1 = state_50580;
var statearr_50582_50609 = state_50580__$1;
(statearr_50582_50609[(2)] = inst_50576);

(statearr_50582_50609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50581 === (1))){
var state_50580__$1 = state_50580;
var statearr_50583_50610 = state_50580__$1;
(statearr_50583_50610[(2)] = null);

(statearr_50583_50610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50581 === (4))){
var inst_50559 = (state_50580[(7)]);
var inst_50559__$1 = (state_50580[(2)]);
var inst_50560 = (inst_50559__$1 == null);
var state_50580__$1 = (function (){var statearr_50584 = state_50580;
(statearr_50584[(7)] = inst_50559__$1);

return statearr_50584;
})();
if(cljs.core.truth_(inst_50560)){
var statearr_50585_50611 = state_50580__$1;
(statearr_50585_50611[(1)] = (5));

} else {
var statearr_50586_50612 = state_50580__$1;
(statearr_50586_50612[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50581 === (13))){
var state_50580__$1 = state_50580;
var statearr_50587_50613 = state_50580__$1;
(statearr_50587_50613[(2)] = null);

(statearr_50587_50613[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50581 === (6))){
var inst_50559 = (state_50580[(7)]);
var state_50580__$1 = state_50580;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50580__$1,(11),to,inst_50559);
} else {
if((state_val_50581 === (3))){
var inst_50578 = (state_50580[(2)]);
var state_50580__$1 = state_50580;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50580__$1,inst_50578);
} else {
if((state_val_50581 === (12))){
var state_50580__$1 = state_50580;
var statearr_50588_50614 = state_50580__$1;
(statearr_50588_50614[(2)] = null);

(statearr_50588_50614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50581 === (2))){
var state_50580__$1 = state_50580;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50580__$1,(4),from);
} else {
if((state_val_50581 === (11))){
var inst_50569 = (state_50580[(2)]);
var state_50580__$1 = state_50580;
if(cljs.core.truth_(inst_50569)){
var statearr_50589_50615 = state_50580__$1;
(statearr_50589_50615[(1)] = (12));

} else {
var statearr_50590_50616 = state_50580__$1;
(statearr_50590_50616[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50581 === (9))){
var state_50580__$1 = state_50580;
var statearr_50591_50617 = state_50580__$1;
(statearr_50591_50617[(2)] = null);

(statearr_50591_50617[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50581 === (5))){
var state_50580__$1 = state_50580;
if(cljs.core.truth_(close_QMARK_)){
var statearr_50592_50618 = state_50580__$1;
(statearr_50592_50618[(1)] = (8));

} else {
var statearr_50593_50619 = state_50580__$1;
(statearr_50593_50619[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50581 === (14))){
var inst_50574 = (state_50580[(2)]);
var state_50580__$1 = state_50580;
var statearr_50594_50620 = state_50580__$1;
(statearr_50594_50620[(2)] = inst_50574);

(statearr_50594_50620[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50581 === (10))){
var inst_50566 = (state_50580[(2)]);
var state_50580__$1 = state_50580;
var statearr_50595_50621 = state_50580__$1;
(statearr_50595_50621[(2)] = inst_50566);

(statearr_50595_50621[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50581 === (8))){
var inst_50563 = cljs.core.async.close_BANG_.call(null,to);
var state_50580__$1 = state_50580;
var statearr_50596_50622 = state_50580__$1;
(statearr_50596_50622[(2)] = inst_50563);

(statearr_50596_50622[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___50608))
;
return ((function (switch__33364__auto__,c__33478__auto___50608){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_50600 = [null,null,null,null,null,null,null,null];
(statearr_50600[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_50600[(1)] = (1));

return statearr_50600;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_50580){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_50580);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e50601){if((e50601 instanceof Object)){
var ex__33368__auto__ = e50601;
var statearr_50602_50623 = state_50580;
(statearr_50602_50623[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50580);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50601;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50624 = state_50580;
state_50580 = G__50624;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_50580){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_50580);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___50608))
})();
var state__33480__auto__ = (function (){var statearr_50603 = f__33479__auto__.call(null);
(statearr_50603[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___50608);

return statearr_50603;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___50608))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__50812){
var vec__50813 = p__50812;
var v = cljs.core.nth.call(null,vec__50813,(0),null);
var p = cljs.core.nth.call(null,vec__50813,(1),null);
var job = vec__50813;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__33478__auto___50999 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___50999,res,vec__50813,v,p,job,jobs,results){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___50999,res,vec__50813,v,p,job,jobs,results){
return (function (state_50820){
var state_val_50821 = (state_50820[(1)]);
if((state_val_50821 === (1))){
var state_50820__$1 = state_50820;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50820__$1,(2),res,v);
} else {
if((state_val_50821 === (2))){
var inst_50817 = (state_50820[(2)]);
var inst_50818 = cljs.core.async.close_BANG_.call(null,res);
var state_50820__$1 = (function (){var statearr_50822 = state_50820;
(statearr_50822[(7)] = inst_50817);

return statearr_50822;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50820__$1,inst_50818);
} else {
return null;
}
}
});})(c__33478__auto___50999,res,vec__50813,v,p,job,jobs,results))
;
return ((function (switch__33364__auto__,c__33478__auto___50999,res,vec__50813,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0 = (function (){
var statearr_50826 = [null,null,null,null,null,null,null,null];
(statearr_50826[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__);

(statearr_50826[(1)] = (1));

return statearr_50826;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1 = (function (state_50820){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_50820);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e50827){if((e50827 instanceof Object)){
var ex__33368__auto__ = e50827;
var statearr_50828_51000 = state_50820;
(statearr_50828_51000[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50820);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50827;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51001 = state_50820;
state_50820 = G__51001;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = function(state_50820){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1.call(this,state_50820);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___50999,res,vec__50813,v,p,job,jobs,results))
})();
var state__33480__auto__ = (function (){var statearr_50829 = f__33479__auto__.call(null);
(statearr_50829[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___50999);

return statearr_50829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___50999,res,vec__50813,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__50830){
var vec__50831 = p__50830;
var v = cljs.core.nth.call(null,vec__50831,(0),null);
var p = cljs.core.nth.call(null,vec__50831,(1),null);
var job = vec__50831;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__10440__auto___51002 = n;
var __51003 = (0);
while(true){
if((__51003 < n__10440__auto___51002)){
var G__50834_51004 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__50834_51004) {
case "compute":
var c__33478__auto___51006 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__51003,c__33478__auto___51006,G__50834_51004,n__10440__auto___51002,jobs,results,process,async){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (__51003,c__33478__auto___51006,G__50834_51004,n__10440__auto___51002,jobs,results,process,async){
return (function (state_50847){
var state_val_50848 = (state_50847[(1)]);
if((state_val_50848 === (1))){
var state_50847__$1 = state_50847;
var statearr_50849_51007 = state_50847__$1;
(statearr_50849_51007[(2)] = null);

(statearr_50849_51007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50848 === (2))){
var state_50847__$1 = state_50847;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50847__$1,(4),jobs);
} else {
if((state_val_50848 === (3))){
var inst_50845 = (state_50847[(2)]);
var state_50847__$1 = state_50847;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50847__$1,inst_50845);
} else {
if((state_val_50848 === (4))){
var inst_50837 = (state_50847[(2)]);
var inst_50838 = process.call(null,inst_50837);
var state_50847__$1 = state_50847;
if(cljs.core.truth_(inst_50838)){
var statearr_50850_51008 = state_50847__$1;
(statearr_50850_51008[(1)] = (5));

} else {
var statearr_50851_51009 = state_50847__$1;
(statearr_50851_51009[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50848 === (5))){
var state_50847__$1 = state_50847;
var statearr_50852_51010 = state_50847__$1;
(statearr_50852_51010[(2)] = null);

(statearr_50852_51010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50848 === (6))){
var state_50847__$1 = state_50847;
var statearr_50853_51011 = state_50847__$1;
(statearr_50853_51011[(2)] = null);

(statearr_50853_51011[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50848 === (7))){
var inst_50843 = (state_50847[(2)]);
var state_50847__$1 = state_50847;
var statearr_50854_51012 = state_50847__$1;
(statearr_50854_51012[(2)] = inst_50843);

(statearr_50854_51012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__51003,c__33478__auto___51006,G__50834_51004,n__10440__auto___51002,jobs,results,process,async))
;
return ((function (__51003,switch__33364__auto__,c__33478__auto___51006,G__50834_51004,n__10440__auto___51002,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0 = (function (){
var statearr_50858 = [null,null,null,null,null,null,null];
(statearr_50858[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__);

(statearr_50858[(1)] = (1));

return statearr_50858;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1 = (function (state_50847){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_50847);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e50859){if((e50859 instanceof Object)){
var ex__33368__auto__ = e50859;
var statearr_50860_51013 = state_50847;
(statearr_50860_51013[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50847);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50859;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51014 = state_50847;
state_50847 = G__51014;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = function(state_50847){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1.call(this,state_50847);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__;
})()
;})(__51003,switch__33364__auto__,c__33478__auto___51006,G__50834_51004,n__10440__auto___51002,jobs,results,process,async))
})();
var state__33480__auto__ = (function (){var statearr_50861 = f__33479__auto__.call(null);
(statearr_50861[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___51006);

return statearr_50861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(__51003,c__33478__auto___51006,G__50834_51004,n__10440__auto___51002,jobs,results,process,async))
);


break;
case "async":
var c__33478__auto___51015 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__51003,c__33478__auto___51015,G__50834_51004,n__10440__auto___51002,jobs,results,process,async){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (__51003,c__33478__auto___51015,G__50834_51004,n__10440__auto___51002,jobs,results,process,async){
return (function (state_50874){
var state_val_50875 = (state_50874[(1)]);
if((state_val_50875 === (1))){
var state_50874__$1 = state_50874;
var statearr_50876_51016 = state_50874__$1;
(statearr_50876_51016[(2)] = null);

(statearr_50876_51016[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50875 === (2))){
var state_50874__$1 = state_50874;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50874__$1,(4),jobs);
} else {
if((state_val_50875 === (3))){
var inst_50872 = (state_50874[(2)]);
var state_50874__$1 = state_50874;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50874__$1,inst_50872);
} else {
if((state_val_50875 === (4))){
var inst_50864 = (state_50874[(2)]);
var inst_50865 = async.call(null,inst_50864);
var state_50874__$1 = state_50874;
if(cljs.core.truth_(inst_50865)){
var statearr_50877_51017 = state_50874__$1;
(statearr_50877_51017[(1)] = (5));

} else {
var statearr_50878_51018 = state_50874__$1;
(statearr_50878_51018[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50875 === (5))){
var state_50874__$1 = state_50874;
var statearr_50879_51019 = state_50874__$1;
(statearr_50879_51019[(2)] = null);

(statearr_50879_51019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50875 === (6))){
var state_50874__$1 = state_50874;
var statearr_50880_51020 = state_50874__$1;
(statearr_50880_51020[(2)] = null);

(statearr_50880_51020[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50875 === (7))){
var inst_50870 = (state_50874[(2)]);
var state_50874__$1 = state_50874;
var statearr_50881_51021 = state_50874__$1;
(statearr_50881_51021[(2)] = inst_50870);

(statearr_50881_51021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__51003,c__33478__auto___51015,G__50834_51004,n__10440__auto___51002,jobs,results,process,async))
;
return ((function (__51003,switch__33364__auto__,c__33478__auto___51015,G__50834_51004,n__10440__auto___51002,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0 = (function (){
var statearr_50885 = [null,null,null,null,null,null,null];
(statearr_50885[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__);

(statearr_50885[(1)] = (1));

return statearr_50885;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1 = (function (state_50874){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_50874);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e50886){if((e50886 instanceof Object)){
var ex__33368__auto__ = e50886;
var statearr_50887_51022 = state_50874;
(statearr_50887_51022[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50874);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50886;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51023 = state_50874;
state_50874 = G__51023;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = function(state_50874){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1.call(this,state_50874);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__;
})()
;})(__51003,switch__33364__auto__,c__33478__auto___51015,G__50834_51004,n__10440__auto___51002,jobs,results,process,async))
})();
var state__33480__auto__ = (function (){var statearr_50888 = f__33479__auto__.call(null);
(statearr_50888[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___51015);

return statearr_50888;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(__51003,c__33478__auto___51015,G__50834_51004,n__10440__auto___51002,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__51024 = (__51003 + (1));
__51003 = G__51024;
continue;
} else {
}
break;
}

var c__33478__auto___51025 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___51025,jobs,results,process,async){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___51025,jobs,results,process,async){
return (function (state_50910){
var state_val_50911 = (state_50910[(1)]);
if((state_val_50911 === (1))){
var state_50910__$1 = state_50910;
var statearr_50912_51026 = state_50910__$1;
(statearr_50912_51026[(2)] = null);

(statearr_50912_51026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50911 === (2))){
var state_50910__$1 = state_50910;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50910__$1,(4),from);
} else {
if((state_val_50911 === (3))){
var inst_50908 = (state_50910[(2)]);
var state_50910__$1 = state_50910;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50910__$1,inst_50908);
} else {
if((state_val_50911 === (4))){
var inst_50891 = (state_50910[(7)]);
var inst_50891__$1 = (state_50910[(2)]);
var inst_50892 = (inst_50891__$1 == null);
var state_50910__$1 = (function (){var statearr_50913 = state_50910;
(statearr_50913[(7)] = inst_50891__$1);

return statearr_50913;
})();
if(cljs.core.truth_(inst_50892)){
var statearr_50914_51027 = state_50910__$1;
(statearr_50914_51027[(1)] = (5));

} else {
var statearr_50915_51028 = state_50910__$1;
(statearr_50915_51028[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50911 === (5))){
var inst_50894 = cljs.core.async.close_BANG_.call(null,jobs);
var state_50910__$1 = state_50910;
var statearr_50916_51029 = state_50910__$1;
(statearr_50916_51029[(2)] = inst_50894);

(statearr_50916_51029[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50911 === (6))){
var inst_50891 = (state_50910[(7)]);
var inst_50896 = (state_50910[(8)]);
var inst_50896__$1 = cljs.core.async.chan.call(null,(1));
var inst_50897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_50898 = [inst_50891,inst_50896__$1];
var inst_50899 = (new cljs.core.PersistentVector(null,2,(5),inst_50897,inst_50898,null));
var state_50910__$1 = (function (){var statearr_50917 = state_50910;
(statearr_50917[(8)] = inst_50896__$1);

return statearr_50917;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50910__$1,(8),jobs,inst_50899);
} else {
if((state_val_50911 === (7))){
var inst_50906 = (state_50910[(2)]);
var state_50910__$1 = state_50910;
var statearr_50918_51030 = state_50910__$1;
(statearr_50918_51030[(2)] = inst_50906);

(statearr_50918_51030[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50911 === (8))){
var inst_50896 = (state_50910[(8)]);
var inst_50901 = (state_50910[(2)]);
var state_50910__$1 = (function (){var statearr_50919 = state_50910;
(statearr_50919[(9)] = inst_50901);

return statearr_50919;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50910__$1,(9),results,inst_50896);
} else {
if((state_val_50911 === (9))){
var inst_50903 = (state_50910[(2)]);
var state_50910__$1 = (function (){var statearr_50920 = state_50910;
(statearr_50920[(10)] = inst_50903);

return statearr_50920;
})();
var statearr_50921_51031 = state_50910__$1;
(statearr_50921_51031[(2)] = null);

(statearr_50921_51031[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___51025,jobs,results,process,async))
;
return ((function (switch__33364__auto__,c__33478__auto___51025,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0 = (function (){
var statearr_50925 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_50925[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__);

(statearr_50925[(1)] = (1));

return statearr_50925;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1 = (function (state_50910){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_50910);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e50926){if((e50926 instanceof Object)){
var ex__33368__auto__ = e50926;
var statearr_50927_51032 = state_50910;
(statearr_50927_51032[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50910);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50926;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51033 = state_50910;
state_50910 = G__51033;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = function(state_50910){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1.call(this,state_50910);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___51025,jobs,results,process,async))
})();
var state__33480__auto__ = (function (){var statearr_50928 = f__33479__auto__.call(null);
(statearr_50928[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___51025);

return statearr_50928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___51025,jobs,results,process,async))
);


var c__33478__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto__,jobs,results,process,async){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto__,jobs,results,process,async){
return (function (state_50966){
var state_val_50967 = (state_50966[(1)]);
if((state_val_50967 === (7))){
var inst_50962 = (state_50966[(2)]);
var state_50966__$1 = state_50966;
var statearr_50968_51034 = state_50966__$1;
(statearr_50968_51034[(2)] = inst_50962);

(statearr_50968_51034[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50967 === (20))){
var state_50966__$1 = state_50966;
var statearr_50969_51035 = state_50966__$1;
(statearr_50969_51035[(2)] = null);

(statearr_50969_51035[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50967 === (1))){
var state_50966__$1 = state_50966;
var statearr_50970_51036 = state_50966__$1;
(statearr_50970_51036[(2)] = null);

(statearr_50970_51036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50967 === (4))){
var inst_50931 = (state_50966[(7)]);
var inst_50931__$1 = (state_50966[(2)]);
var inst_50932 = (inst_50931__$1 == null);
var state_50966__$1 = (function (){var statearr_50971 = state_50966;
(statearr_50971[(7)] = inst_50931__$1);

return statearr_50971;
})();
if(cljs.core.truth_(inst_50932)){
var statearr_50972_51037 = state_50966__$1;
(statearr_50972_51037[(1)] = (5));

} else {
var statearr_50973_51038 = state_50966__$1;
(statearr_50973_51038[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50967 === (15))){
var inst_50944 = (state_50966[(8)]);
var state_50966__$1 = state_50966;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50966__$1,(18),to,inst_50944);
} else {
if((state_val_50967 === (21))){
var inst_50957 = (state_50966[(2)]);
var state_50966__$1 = state_50966;
var statearr_50974_51039 = state_50966__$1;
(statearr_50974_51039[(2)] = inst_50957);

(statearr_50974_51039[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50967 === (13))){
var inst_50959 = (state_50966[(2)]);
var state_50966__$1 = (function (){var statearr_50975 = state_50966;
(statearr_50975[(9)] = inst_50959);

return statearr_50975;
})();
var statearr_50976_51040 = state_50966__$1;
(statearr_50976_51040[(2)] = null);

(statearr_50976_51040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50967 === (6))){
var inst_50931 = (state_50966[(7)]);
var state_50966__$1 = state_50966;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50966__$1,(11),inst_50931);
} else {
if((state_val_50967 === (17))){
var inst_50952 = (state_50966[(2)]);
var state_50966__$1 = state_50966;
if(cljs.core.truth_(inst_50952)){
var statearr_50977_51041 = state_50966__$1;
(statearr_50977_51041[(1)] = (19));

} else {
var statearr_50978_51042 = state_50966__$1;
(statearr_50978_51042[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50967 === (3))){
var inst_50964 = (state_50966[(2)]);
var state_50966__$1 = state_50966;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50966__$1,inst_50964);
} else {
if((state_val_50967 === (12))){
var inst_50941 = (state_50966[(10)]);
var state_50966__$1 = state_50966;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50966__$1,(14),inst_50941);
} else {
if((state_val_50967 === (2))){
var state_50966__$1 = state_50966;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50966__$1,(4),results);
} else {
if((state_val_50967 === (19))){
var state_50966__$1 = state_50966;
var statearr_50979_51043 = state_50966__$1;
(statearr_50979_51043[(2)] = null);

(statearr_50979_51043[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50967 === (11))){
var inst_50941 = (state_50966[(2)]);
var state_50966__$1 = (function (){var statearr_50980 = state_50966;
(statearr_50980[(10)] = inst_50941);

return statearr_50980;
})();
var statearr_50981_51044 = state_50966__$1;
(statearr_50981_51044[(2)] = null);

(statearr_50981_51044[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50967 === (9))){
var state_50966__$1 = state_50966;
var statearr_50982_51045 = state_50966__$1;
(statearr_50982_51045[(2)] = null);

(statearr_50982_51045[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50967 === (5))){
var state_50966__$1 = state_50966;
if(cljs.core.truth_(close_QMARK_)){
var statearr_50983_51046 = state_50966__$1;
(statearr_50983_51046[(1)] = (8));

} else {
var statearr_50984_51047 = state_50966__$1;
(statearr_50984_51047[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50967 === (14))){
var inst_50944 = (state_50966[(8)]);
var inst_50946 = (state_50966[(11)]);
var inst_50944__$1 = (state_50966[(2)]);
var inst_50945 = (inst_50944__$1 == null);
var inst_50946__$1 = cljs.core.not.call(null,inst_50945);
var state_50966__$1 = (function (){var statearr_50985 = state_50966;
(statearr_50985[(8)] = inst_50944__$1);

(statearr_50985[(11)] = inst_50946__$1);

return statearr_50985;
})();
if(inst_50946__$1){
var statearr_50986_51048 = state_50966__$1;
(statearr_50986_51048[(1)] = (15));

} else {
var statearr_50987_51049 = state_50966__$1;
(statearr_50987_51049[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50967 === (16))){
var inst_50946 = (state_50966[(11)]);
var state_50966__$1 = state_50966;
var statearr_50988_51050 = state_50966__$1;
(statearr_50988_51050[(2)] = inst_50946);

(statearr_50988_51050[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50967 === (10))){
var inst_50938 = (state_50966[(2)]);
var state_50966__$1 = state_50966;
var statearr_50989_51051 = state_50966__$1;
(statearr_50989_51051[(2)] = inst_50938);

(statearr_50989_51051[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50967 === (18))){
var inst_50949 = (state_50966[(2)]);
var state_50966__$1 = state_50966;
var statearr_50990_51052 = state_50966__$1;
(statearr_50990_51052[(2)] = inst_50949);

(statearr_50990_51052[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50967 === (8))){
var inst_50935 = cljs.core.async.close_BANG_.call(null,to);
var state_50966__$1 = state_50966;
var statearr_50991_51053 = state_50966__$1;
(statearr_50991_51053[(2)] = inst_50935);

(statearr_50991_51053[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto__,jobs,results,process,async))
;
return ((function (switch__33364__auto__,c__33478__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0 = (function (){
var statearr_50995 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50995[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__);

(statearr_50995[(1)] = (1));

return statearr_50995;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1 = (function (state_50966){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_50966);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e50996){if((e50996 instanceof Object)){
var ex__33368__auto__ = e50996;
var statearr_50997_51054 = state_50966;
(statearr_50997_51054[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50966);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50996;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51055 = state_50966;
state_50966 = G__51055;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__ = function(state_50966){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1.call(this,state_50966);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto__,jobs,results,process,async))
})();
var state__33480__auto__ = (function (){var statearr_50998 = f__33479__auto__.call(null);
(statearr_50998[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto__);

return statearr_50998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto__,jobs,results,process,async))
);

return c__33478__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args51056 = [];
var len__10640__auto___51059 = arguments.length;
var i__10641__auto___51060 = (0);
while(true){
if((i__10641__auto___51060 < len__10640__auto___51059)){
args51056.push((arguments[i__10641__auto___51060]));

var G__51061 = (i__10641__auto___51060 + (1));
i__10641__auto___51060 = G__51061;
continue;
} else {
}
break;
}

var G__51058 = args51056.length;
switch (G__51058) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args51056.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args51063 = [];
var len__10640__auto___51066 = arguments.length;
var i__10641__auto___51067 = (0);
while(true){
if((i__10641__auto___51067 < len__10640__auto___51066)){
args51063.push((arguments[i__10641__auto___51067]));

var G__51068 = (i__10641__auto___51067 + (1));
i__10641__auto___51067 = G__51068;
continue;
} else {
}
break;
}

var G__51065 = args51063.length;
switch (G__51065) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args51063.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args51070 = [];
var len__10640__auto___51123 = arguments.length;
var i__10641__auto___51124 = (0);
while(true){
if((i__10641__auto___51124 < len__10640__auto___51123)){
args51070.push((arguments[i__10641__auto___51124]));

var G__51125 = (i__10641__auto___51124 + (1));
i__10641__auto___51124 = G__51125;
continue;
} else {
}
break;
}

var G__51072 = args51070.length;
switch (G__51072) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args51070.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__33478__auto___51127 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___51127,tc,fc){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___51127,tc,fc){
return (function (state_51098){
var state_val_51099 = (state_51098[(1)]);
if((state_val_51099 === (7))){
var inst_51094 = (state_51098[(2)]);
var state_51098__$1 = state_51098;
var statearr_51100_51128 = state_51098__$1;
(statearr_51100_51128[(2)] = inst_51094);

(statearr_51100_51128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51099 === (1))){
var state_51098__$1 = state_51098;
var statearr_51101_51129 = state_51098__$1;
(statearr_51101_51129[(2)] = null);

(statearr_51101_51129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51099 === (4))){
var inst_51075 = (state_51098[(7)]);
var inst_51075__$1 = (state_51098[(2)]);
var inst_51076 = (inst_51075__$1 == null);
var state_51098__$1 = (function (){var statearr_51102 = state_51098;
(statearr_51102[(7)] = inst_51075__$1);

return statearr_51102;
})();
if(cljs.core.truth_(inst_51076)){
var statearr_51103_51130 = state_51098__$1;
(statearr_51103_51130[(1)] = (5));

} else {
var statearr_51104_51131 = state_51098__$1;
(statearr_51104_51131[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51099 === (13))){
var state_51098__$1 = state_51098;
var statearr_51105_51132 = state_51098__$1;
(statearr_51105_51132[(2)] = null);

(statearr_51105_51132[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51099 === (6))){
var inst_51075 = (state_51098[(7)]);
var inst_51081 = p.call(null,inst_51075);
var state_51098__$1 = state_51098;
if(cljs.core.truth_(inst_51081)){
var statearr_51106_51133 = state_51098__$1;
(statearr_51106_51133[(1)] = (9));

} else {
var statearr_51107_51134 = state_51098__$1;
(statearr_51107_51134[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51099 === (3))){
var inst_51096 = (state_51098[(2)]);
var state_51098__$1 = state_51098;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51098__$1,inst_51096);
} else {
if((state_val_51099 === (12))){
var state_51098__$1 = state_51098;
var statearr_51108_51135 = state_51098__$1;
(statearr_51108_51135[(2)] = null);

(statearr_51108_51135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51099 === (2))){
var state_51098__$1 = state_51098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51098__$1,(4),ch);
} else {
if((state_val_51099 === (11))){
var inst_51075 = (state_51098[(7)]);
var inst_51085 = (state_51098[(2)]);
var state_51098__$1 = state_51098;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_51098__$1,(8),inst_51085,inst_51075);
} else {
if((state_val_51099 === (9))){
var state_51098__$1 = state_51098;
var statearr_51109_51136 = state_51098__$1;
(statearr_51109_51136[(2)] = tc);

(statearr_51109_51136[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51099 === (5))){
var inst_51078 = cljs.core.async.close_BANG_.call(null,tc);
var inst_51079 = cljs.core.async.close_BANG_.call(null,fc);
var state_51098__$1 = (function (){var statearr_51110 = state_51098;
(statearr_51110[(8)] = inst_51078);

return statearr_51110;
})();
var statearr_51111_51137 = state_51098__$1;
(statearr_51111_51137[(2)] = inst_51079);

(statearr_51111_51137[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51099 === (14))){
var inst_51092 = (state_51098[(2)]);
var state_51098__$1 = state_51098;
var statearr_51112_51138 = state_51098__$1;
(statearr_51112_51138[(2)] = inst_51092);

(statearr_51112_51138[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51099 === (10))){
var state_51098__$1 = state_51098;
var statearr_51113_51139 = state_51098__$1;
(statearr_51113_51139[(2)] = fc);

(statearr_51113_51139[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51099 === (8))){
var inst_51087 = (state_51098[(2)]);
var state_51098__$1 = state_51098;
if(cljs.core.truth_(inst_51087)){
var statearr_51114_51140 = state_51098__$1;
(statearr_51114_51140[(1)] = (12));

} else {
var statearr_51115_51141 = state_51098__$1;
(statearr_51115_51141[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___51127,tc,fc))
;
return ((function (switch__33364__auto__,c__33478__auto___51127,tc,fc){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_51119 = [null,null,null,null,null,null,null,null,null];
(statearr_51119[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_51119[(1)] = (1));

return statearr_51119;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_51098){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_51098);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e51120){if((e51120 instanceof Object)){
var ex__33368__auto__ = e51120;
var statearr_51121_51142 = state_51098;
(statearr_51121_51142[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51098);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51120;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51143 = state_51098;
state_51098 = G__51143;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_51098){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_51098);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___51127,tc,fc))
})();
var state__33480__auto__ = (function (){var statearr_51122 = f__33479__auto__.call(null);
(statearr_51122[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___51127);

return statearr_51122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___51127,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__33478__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto__){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto__){
return (function (state_51207){
var state_val_51208 = (state_51207[(1)]);
if((state_val_51208 === (7))){
var inst_51203 = (state_51207[(2)]);
var state_51207__$1 = state_51207;
var statearr_51209_51230 = state_51207__$1;
(statearr_51209_51230[(2)] = inst_51203);

(statearr_51209_51230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51208 === (1))){
var inst_51187 = init;
var state_51207__$1 = (function (){var statearr_51210 = state_51207;
(statearr_51210[(7)] = inst_51187);

return statearr_51210;
})();
var statearr_51211_51231 = state_51207__$1;
(statearr_51211_51231[(2)] = null);

(statearr_51211_51231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51208 === (4))){
var inst_51190 = (state_51207[(8)]);
var inst_51190__$1 = (state_51207[(2)]);
var inst_51191 = (inst_51190__$1 == null);
var state_51207__$1 = (function (){var statearr_51212 = state_51207;
(statearr_51212[(8)] = inst_51190__$1);

return statearr_51212;
})();
if(cljs.core.truth_(inst_51191)){
var statearr_51213_51232 = state_51207__$1;
(statearr_51213_51232[(1)] = (5));

} else {
var statearr_51214_51233 = state_51207__$1;
(statearr_51214_51233[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51208 === (6))){
var inst_51194 = (state_51207[(9)]);
var inst_51190 = (state_51207[(8)]);
var inst_51187 = (state_51207[(7)]);
var inst_51194__$1 = f.call(null,inst_51187,inst_51190);
var inst_51195 = cljs.core.reduced_QMARK_.call(null,inst_51194__$1);
var state_51207__$1 = (function (){var statearr_51215 = state_51207;
(statearr_51215[(9)] = inst_51194__$1);

return statearr_51215;
})();
if(inst_51195){
var statearr_51216_51234 = state_51207__$1;
(statearr_51216_51234[(1)] = (8));

} else {
var statearr_51217_51235 = state_51207__$1;
(statearr_51217_51235[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51208 === (3))){
var inst_51205 = (state_51207[(2)]);
var state_51207__$1 = state_51207;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51207__$1,inst_51205);
} else {
if((state_val_51208 === (2))){
var state_51207__$1 = state_51207;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51207__$1,(4),ch);
} else {
if((state_val_51208 === (9))){
var inst_51194 = (state_51207[(9)]);
var inst_51187 = inst_51194;
var state_51207__$1 = (function (){var statearr_51218 = state_51207;
(statearr_51218[(7)] = inst_51187);

return statearr_51218;
})();
var statearr_51219_51236 = state_51207__$1;
(statearr_51219_51236[(2)] = null);

(statearr_51219_51236[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51208 === (5))){
var inst_51187 = (state_51207[(7)]);
var state_51207__$1 = state_51207;
var statearr_51220_51237 = state_51207__$1;
(statearr_51220_51237[(2)] = inst_51187);

(statearr_51220_51237[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51208 === (10))){
var inst_51201 = (state_51207[(2)]);
var state_51207__$1 = state_51207;
var statearr_51221_51238 = state_51207__$1;
(statearr_51221_51238[(2)] = inst_51201);

(statearr_51221_51238[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51208 === (8))){
var inst_51194 = (state_51207[(9)]);
var inst_51197 = cljs.core.deref.call(null,inst_51194);
var state_51207__$1 = state_51207;
var statearr_51222_51239 = state_51207__$1;
(statearr_51222_51239[(2)] = inst_51197);

(statearr_51222_51239[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto__))
;
return ((function (switch__33364__auto__,c__33478__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__33365__auto__ = null;
var cljs$core$async$reduce_$_state_machine__33365__auto____0 = (function (){
var statearr_51226 = [null,null,null,null,null,null,null,null,null,null];
(statearr_51226[(0)] = cljs$core$async$reduce_$_state_machine__33365__auto__);

(statearr_51226[(1)] = (1));

return statearr_51226;
});
var cljs$core$async$reduce_$_state_machine__33365__auto____1 = (function (state_51207){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_51207);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e51227){if((e51227 instanceof Object)){
var ex__33368__auto__ = e51227;
var statearr_51228_51240 = state_51207;
(statearr_51228_51240[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51207);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51227;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51241 = state_51207;
state_51207 = G__51241;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__33365__auto__ = function(state_51207){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__33365__auto____1.call(this,state_51207);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__33365__auto____0;
cljs$core$async$reduce_$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__33365__auto____1;
return cljs$core$async$reduce_$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto__))
})();
var state__33480__auto__ = (function (){var statearr_51229 = f__33479__auto__.call(null);
(statearr_51229[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto__);

return statearr_51229;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto__))
);

return c__33478__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__33478__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto__,f__$1){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto__,f__$1){
return (function (state_51261){
var state_val_51262 = (state_51261[(1)]);
if((state_val_51262 === (1))){
var inst_51256 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_51261__$1 = state_51261;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51261__$1,(2),inst_51256);
} else {
if((state_val_51262 === (2))){
var inst_51258 = (state_51261[(2)]);
var inst_51259 = f__$1.call(null,inst_51258);
var state_51261__$1 = state_51261;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51261__$1,inst_51259);
} else {
return null;
}
}
});})(c__33478__auto__,f__$1))
;
return ((function (switch__33364__auto__,c__33478__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__33365__auto__ = null;
var cljs$core$async$transduce_$_state_machine__33365__auto____0 = (function (){
var statearr_51266 = [null,null,null,null,null,null,null];
(statearr_51266[(0)] = cljs$core$async$transduce_$_state_machine__33365__auto__);

(statearr_51266[(1)] = (1));

return statearr_51266;
});
var cljs$core$async$transduce_$_state_machine__33365__auto____1 = (function (state_51261){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_51261);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e51267){if((e51267 instanceof Object)){
var ex__33368__auto__ = e51267;
var statearr_51268_51270 = state_51261;
(statearr_51268_51270[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51261);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51267;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51271 = state_51261;
state_51261 = G__51271;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__33365__auto__ = function(state_51261){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__33365__auto____1.call(this,state_51261);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__33365__auto____0;
cljs$core$async$transduce_$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__33365__auto____1;
return cljs$core$async$transduce_$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto__,f__$1))
})();
var state__33480__auto__ = (function (){var statearr_51269 = f__33479__auto__.call(null);
(statearr_51269[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto__);

return statearr_51269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto__,f__$1))
);

return c__33478__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args51272 = [];
var len__10640__auto___51324 = arguments.length;
var i__10641__auto___51325 = (0);
while(true){
if((i__10641__auto___51325 < len__10640__auto___51324)){
args51272.push((arguments[i__10641__auto___51325]));

var G__51326 = (i__10641__auto___51325 + (1));
i__10641__auto___51325 = G__51326;
continue;
} else {
}
break;
}

var G__51274 = args51272.length;
switch (G__51274) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args51272.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__33478__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto__){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto__){
return (function (state_51299){
var state_val_51300 = (state_51299[(1)]);
if((state_val_51300 === (7))){
var inst_51281 = (state_51299[(2)]);
var state_51299__$1 = state_51299;
var statearr_51301_51328 = state_51299__$1;
(statearr_51301_51328[(2)] = inst_51281);

(statearr_51301_51328[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51300 === (1))){
var inst_51275 = cljs.core.seq.call(null,coll);
var inst_51276 = inst_51275;
var state_51299__$1 = (function (){var statearr_51302 = state_51299;
(statearr_51302[(7)] = inst_51276);

return statearr_51302;
})();
var statearr_51303_51329 = state_51299__$1;
(statearr_51303_51329[(2)] = null);

(statearr_51303_51329[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51300 === (4))){
var inst_51276 = (state_51299[(7)]);
var inst_51279 = cljs.core.first.call(null,inst_51276);
var state_51299__$1 = state_51299;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_51299__$1,(7),ch,inst_51279);
} else {
if((state_val_51300 === (13))){
var inst_51293 = (state_51299[(2)]);
var state_51299__$1 = state_51299;
var statearr_51304_51330 = state_51299__$1;
(statearr_51304_51330[(2)] = inst_51293);

(statearr_51304_51330[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51300 === (6))){
var inst_51284 = (state_51299[(2)]);
var state_51299__$1 = state_51299;
if(cljs.core.truth_(inst_51284)){
var statearr_51305_51331 = state_51299__$1;
(statearr_51305_51331[(1)] = (8));

} else {
var statearr_51306_51332 = state_51299__$1;
(statearr_51306_51332[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51300 === (3))){
var inst_51297 = (state_51299[(2)]);
var state_51299__$1 = state_51299;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51299__$1,inst_51297);
} else {
if((state_val_51300 === (12))){
var state_51299__$1 = state_51299;
var statearr_51307_51333 = state_51299__$1;
(statearr_51307_51333[(2)] = null);

(statearr_51307_51333[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51300 === (2))){
var inst_51276 = (state_51299[(7)]);
var state_51299__$1 = state_51299;
if(cljs.core.truth_(inst_51276)){
var statearr_51308_51334 = state_51299__$1;
(statearr_51308_51334[(1)] = (4));

} else {
var statearr_51309_51335 = state_51299__$1;
(statearr_51309_51335[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51300 === (11))){
var inst_51290 = cljs.core.async.close_BANG_.call(null,ch);
var state_51299__$1 = state_51299;
var statearr_51310_51336 = state_51299__$1;
(statearr_51310_51336[(2)] = inst_51290);

(statearr_51310_51336[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51300 === (9))){
var state_51299__$1 = state_51299;
if(cljs.core.truth_(close_QMARK_)){
var statearr_51311_51337 = state_51299__$1;
(statearr_51311_51337[(1)] = (11));

} else {
var statearr_51312_51338 = state_51299__$1;
(statearr_51312_51338[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51300 === (5))){
var inst_51276 = (state_51299[(7)]);
var state_51299__$1 = state_51299;
var statearr_51313_51339 = state_51299__$1;
(statearr_51313_51339[(2)] = inst_51276);

(statearr_51313_51339[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51300 === (10))){
var inst_51295 = (state_51299[(2)]);
var state_51299__$1 = state_51299;
var statearr_51314_51340 = state_51299__$1;
(statearr_51314_51340[(2)] = inst_51295);

(statearr_51314_51340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51300 === (8))){
var inst_51276 = (state_51299[(7)]);
var inst_51286 = cljs.core.next.call(null,inst_51276);
var inst_51276__$1 = inst_51286;
var state_51299__$1 = (function (){var statearr_51315 = state_51299;
(statearr_51315[(7)] = inst_51276__$1);

return statearr_51315;
})();
var statearr_51316_51341 = state_51299__$1;
(statearr_51316_51341[(2)] = null);

(statearr_51316_51341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto__))
;
return ((function (switch__33364__auto__,c__33478__auto__){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_51320 = [null,null,null,null,null,null,null,null];
(statearr_51320[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_51320[(1)] = (1));

return statearr_51320;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_51299){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_51299);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e51321){if((e51321 instanceof Object)){
var ex__33368__auto__ = e51321;
var statearr_51322_51342 = state_51299;
(statearr_51322_51342[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51299);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51321;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51343 = state_51299;
state_51299 = G__51343;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_51299){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_51299);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto__))
})();
var state__33480__auto__ = (function (){var statearr_51323 = f__33479__auto__.call(null);
(statearr_51323[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto__);

return statearr_51323;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto__))
);

return c__33478__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__10137__auto__ = (((_ == null))?null:_);
var m__10138__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,_);
} else {
var m__10138__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__10138__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m);
} else {
var m__10138__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async51569 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async51569 = (function (ch,cs,meta51570){
this.ch = ch;
this.cs = cs;
this.meta51570 = meta51570;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async51569.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_51571,meta51570__$1){
var self__ = this;
var _51571__$1 = this;
return (new cljs.core.async.t_cljs$core$async51569(self__.ch,self__.cs,meta51570__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async51569.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_51571){
var self__ = this;
var _51571__$1 = this;
return self__.meta51570;
});})(cs))
;

cljs.core.async.t_cljs$core$async51569.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async51569.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async51569.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async51569.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async51569.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async51569.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async51569.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta51570","meta51570",389059217,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async51569.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async51569.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async51569";

cljs.core.async.t_cljs$core$async51569.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async51569");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async51569 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async51569(ch__$1,cs__$1,meta51570){
return (new cljs.core.async.t_cljs$core$async51569(ch__$1,cs__$1,meta51570));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async51569(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__33478__auto___51794 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___51794,cs,m,dchan,dctr,done){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___51794,cs,m,dchan,dctr,done){
return (function (state_51706){
var state_val_51707 = (state_51706[(1)]);
if((state_val_51707 === (7))){
var inst_51702 = (state_51706[(2)]);
var state_51706__$1 = state_51706;
var statearr_51708_51795 = state_51706__$1;
(statearr_51708_51795[(2)] = inst_51702);

(statearr_51708_51795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (20))){
var inst_51605 = (state_51706[(7)]);
var inst_51617 = cljs.core.first.call(null,inst_51605);
var inst_51618 = cljs.core.nth.call(null,inst_51617,(0),null);
var inst_51619 = cljs.core.nth.call(null,inst_51617,(1),null);
var state_51706__$1 = (function (){var statearr_51709 = state_51706;
(statearr_51709[(8)] = inst_51618);

return statearr_51709;
})();
if(cljs.core.truth_(inst_51619)){
var statearr_51710_51796 = state_51706__$1;
(statearr_51710_51796[(1)] = (22));

} else {
var statearr_51711_51797 = state_51706__$1;
(statearr_51711_51797[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (27))){
var inst_51574 = (state_51706[(9)]);
var inst_51654 = (state_51706[(10)]);
var inst_51647 = (state_51706[(11)]);
var inst_51649 = (state_51706[(12)]);
var inst_51654__$1 = cljs.core._nth.call(null,inst_51647,inst_51649);
var inst_51655 = cljs.core.async.put_BANG_.call(null,inst_51654__$1,inst_51574,done);
var state_51706__$1 = (function (){var statearr_51712 = state_51706;
(statearr_51712[(10)] = inst_51654__$1);

return statearr_51712;
})();
if(cljs.core.truth_(inst_51655)){
var statearr_51713_51798 = state_51706__$1;
(statearr_51713_51798[(1)] = (30));

} else {
var statearr_51714_51799 = state_51706__$1;
(statearr_51714_51799[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (1))){
var state_51706__$1 = state_51706;
var statearr_51715_51800 = state_51706__$1;
(statearr_51715_51800[(2)] = null);

(statearr_51715_51800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (24))){
var inst_51605 = (state_51706[(7)]);
var inst_51624 = (state_51706[(2)]);
var inst_51625 = cljs.core.next.call(null,inst_51605);
var inst_51583 = inst_51625;
var inst_51584 = null;
var inst_51585 = (0);
var inst_51586 = (0);
var state_51706__$1 = (function (){var statearr_51716 = state_51706;
(statearr_51716[(13)] = inst_51585);

(statearr_51716[(14)] = inst_51586);

(statearr_51716[(15)] = inst_51583);

(statearr_51716[(16)] = inst_51624);

(statearr_51716[(17)] = inst_51584);

return statearr_51716;
})();
var statearr_51717_51801 = state_51706__$1;
(statearr_51717_51801[(2)] = null);

(statearr_51717_51801[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (39))){
var state_51706__$1 = state_51706;
var statearr_51721_51802 = state_51706__$1;
(statearr_51721_51802[(2)] = null);

(statearr_51721_51802[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (4))){
var inst_51574 = (state_51706[(9)]);
var inst_51574__$1 = (state_51706[(2)]);
var inst_51575 = (inst_51574__$1 == null);
var state_51706__$1 = (function (){var statearr_51722 = state_51706;
(statearr_51722[(9)] = inst_51574__$1);

return statearr_51722;
})();
if(cljs.core.truth_(inst_51575)){
var statearr_51723_51803 = state_51706__$1;
(statearr_51723_51803[(1)] = (5));

} else {
var statearr_51724_51804 = state_51706__$1;
(statearr_51724_51804[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (15))){
var inst_51585 = (state_51706[(13)]);
var inst_51586 = (state_51706[(14)]);
var inst_51583 = (state_51706[(15)]);
var inst_51584 = (state_51706[(17)]);
var inst_51601 = (state_51706[(2)]);
var inst_51602 = (inst_51586 + (1));
var tmp51718 = inst_51585;
var tmp51719 = inst_51583;
var tmp51720 = inst_51584;
var inst_51583__$1 = tmp51719;
var inst_51584__$1 = tmp51720;
var inst_51585__$1 = tmp51718;
var inst_51586__$1 = inst_51602;
var state_51706__$1 = (function (){var statearr_51725 = state_51706;
(statearr_51725[(13)] = inst_51585__$1);

(statearr_51725[(14)] = inst_51586__$1);

(statearr_51725[(18)] = inst_51601);

(statearr_51725[(15)] = inst_51583__$1);

(statearr_51725[(17)] = inst_51584__$1);

return statearr_51725;
})();
var statearr_51726_51805 = state_51706__$1;
(statearr_51726_51805[(2)] = null);

(statearr_51726_51805[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (21))){
var inst_51628 = (state_51706[(2)]);
var state_51706__$1 = state_51706;
var statearr_51730_51806 = state_51706__$1;
(statearr_51730_51806[(2)] = inst_51628);

(statearr_51730_51806[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (31))){
var inst_51654 = (state_51706[(10)]);
var inst_51658 = done.call(null,null);
var inst_51659 = cljs.core.async.untap_STAR_.call(null,m,inst_51654);
var state_51706__$1 = (function (){var statearr_51731 = state_51706;
(statearr_51731[(19)] = inst_51658);

return statearr_51731;
})();
var statearr_51732_51807 = state_51706__$1;
(statearr_51732_51807[(2)] = inst_51659);

(statearr_51732_51807[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (32))){
var inst_51648 = (state_51706[(20)]);
var inst_51646 = (state_51706[(21)]);
var inst_51647 = (state_51706[(11)]);
var inst_51649 = (state_51706[(12)]);
var inst_51661 = (state_51706[(2)]);
var inst_51662 = (inst_51649 + (1));
var tmp51727 = inst_51648;
var tmp51728 = inst_51646;
var tmp51729 = inst_51647;
var inst_51646__$1 = tmp51728;
var inst_51647__$1 = tmp51729;
var inst_51648__$1 = tmp51727;
var inst_51649__$1 = inst_51662;
var state_51706__$1 = (function (){var statearr_51733 = state_51706;
(statearr_51733[(20)] = inst_51648__$1);

(statearr_51733[(21)] = inst_51646__$1);

(statearr_51733[(11)] = inst_51647__$1);

(statearr_51733[(12)] = inst_51649__$1);

(statearr_51733[(22)] = inst_51661);

return statearr_51733;
})();
var statearr_51734_51808 = state_51706__$1;
(statearr_51734_51808[(2)] = null);

(statearr_51734_51808[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (40))){
var inst_51674 = (state_51706[(23)]);
var inst_51678 = done.call(null,null);
var inst_51679 = cljs.core.async.untap_STAR_.call(null,m,inst_51674);
var state_51706__$1 = (function (){var statearr_51735 = state_51706;
(statearr_51735[(24)] = inst_51678);

return statearr_51735;
})();
var statearr_51736_51809 = state_51706__$1;
(statearr_51736_51809[(2)] = inst_51679);

(statearr_51736_51809[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (33))){
var inst_51665 = (state_51706[(25)]);
var inst_51667 = cljs.core.chunked_seq_QMARK_.call(null,inst_51665);
var state_51706__$1 = state_51706;
if(inst_51667){
var statearr_51737_51810 = state_51706__$1;
(statearr_51737_51810[(1)] = (36));

} else {
var statearr_51738_51811 = state_51706__$1;
(statearr_51738_51811[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (13))){
var inst_51595 = (state_51706[(26)]);
var inst_51598 = cljs.core.async.close_BANG_.call(null,inst_51595);
var state_51706__$1 = state_51706;
var statearr_51739_51812 = state_51706__$1;
(statearr_51739_51812[(2)] = inst_51598);

(statearr_51739_51812[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (22))){
var inst_51618 = (state_51706[(8)]);
var inst_51621 = cljs.core.async.close_BANG_.call(null,inst_51618);
var state_51706__$1 = state_51706;
var statearr_51740_51813 = state_51706__$1;
(statearr_51740_51813[(2)] = inst_51621);

(statearr_51740_51813[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (36))){
var inst_51665 = (state_51706[(25)]);
var inst_51669 = cljs.core.chunk_first.call(null,inst_51665);
var inst_51670 = cljs.core.chunk_rest.call(null,inst_51665);
var inst_51671 = cljs.core.count.call(null,inst_51669);
var inst_51646 = inst_51670;
var inst_51647 = inst_51669;
var inst_51648 = inst_51671;
var inst_51649 = (0);
var state_51706__$1 = (function (){var statearr_51741 = state_51706;
(statearr_51741[(20)] = inst_51648);

(statearr_51741[(21)] = inst_51646);

(statearr_51741[(11)] = inst_51647);

(statearr_51741[(12)] = inst_51649);

return statearr_51741;
})();
var statearr_51742_51814 = state_51706__$1;
(statearr_51742_51814[(2)] = null);

(statearr_51742_51814[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (41))){
var inst_51665 = (state_51706[(25)]);
var inst_51681 = (state_51706[(2)]);
var inst_51682 = cljs.core.next.call(null,inst_51665);
var inst_51646 = inst_51682;
var inst_51647 = null;
var inst_51648 = (0);
var inst_51649 = (0);
var state_51706__$1 = (function (){var statearr_51743 = state_51706;
(statearr_51743[(20)] = inst_51648);

(statearr_51743[(21)] = inst_51646);

(statearr_51743[(27)] = inst_51681);

(statearr_51743[(11)] = inst_51647);

(statearr_51743[(12)] = inst_51649);

return statearr_51743;
})();
var statearr_51744_51815 = state_51706__$1;
(statearr_51744_51815[(2)] = null);

(statearr_51744_51815[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (43))){
var state_51706__$1 = state_51706;
var statearr_51745_51816 = state_51706__$1;
(statearr_51745_51816[(2)] = null);

(statearr_51745_51816[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (29))){
var inst_51690 = (state_51706[(2)]);
var state_51706__$1 = state_51706;
var statearr_51746_51817 = state_51706__$1;
(statearr_51746_51817[(2)] = inst_51690);

(statearr_51746_51817[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (44))){
var inst_51699 = (state_51706[(2)]);
var state_51706__$1 = (function (){var statearr_51747 = state_51706;
(statearr_51747[(28)] = inst_51699);

return statearr_51747;
})();
var statearr_51748_51818 = state_51706__$1;
(statearr_51748_51818[(2)] = null);

(statearr_51748_51818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (6))){
var inst_51638 = (state_51706[(29)]);
var inst_51637 = cljs.core.deref.call(null,cs);
var inst_51638__$1 = cljs.core.keys.call(null,inst_51637);
var inst_51639 = cljs.core.count.call(null,inst_51638__$1);
var inst_51640 = cljs.core.reset_BANG_.call(null,dctr,inst_51639);
var inst_51645 = cljs.core.seq.call(null,inst_51638__$1);
var inst_51646 = inst_51645;
var inst_51647 = null;
var inst_51648 = (0);
var inst_51649 = (0);
var state_51706__$1 = (function (){var statearr_51749 = state_51706;
(statearr_51749[(20)] = inst_51648);

(statearr_51749[(21)] = inst_51646);

(statearr_51749[(29)] = inst_51638__$1);

(statearr_51749[(11)] = inst_51647);

(statearr_51749[(12)] = inst_51649);

(statearr_51749[(30)] = inst_51640);

return statearr_51749;
})();
var statearr_51750_51819 = state_51706__$1;
(statearr_51750_51819[(2)] = null);

(statearr_51750_51819[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (28))){
var inst_51665 = (state_51706[(25)]);
var inst_51646 = (state_51706[(21)]);
var inst_51665__$1 = cljs.core.seq.call(null,inst_51646);
var state_51706__$1 = (function (){var statearr_51751 = state_51706;
(statearr_51751[(25)] = inst_51665__$1);

return statearr_51751;
})();
if(inst_51665__$1){
var statearr_51752_51820 = state_51706__$1;
(statearr_51752_51820[(1)] = (33));

} else {
var statearr_51753_51821 = state_51706__$1;
(statearr_51753_51821[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (25))){
var inst_51648 = (state_51706[(20)]);
var inst_51649 = (state_51706[(12)]);
var inst_51651 = (inst_51649 < inst_51648);
var inst_51652 = inst_51651;
var state_51706__$1 = state_51706;
if(cljs.core.truth_(inst_51652)){
var statearr_51754_51822 = state_51706__$1;
(statearr_51754_51822[(1)] = (27));

} else {
var statearr_51755_51823 = state_51706__$1;
(statearr_51755_51823[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (34))){
var state_51706__$1 = state_51706;
var statearr_51756_51824 = state_51706__$1;
(statearr_51756_51824[(2)] = null);

(statearr_51756_51824[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (17))){
var state_51706__$1 = state_51706;
var statearr_51757_51825 = state_51706__$1;
(statearr_51757_51825[(2)] = null);

(statearr_51757_51825[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (3))){
var inst_51704 = (state_51706[(2)]);
var state_51706__$1 = state_51706;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51706__$1,inst_51704);
} else {
if((state_val_51707 === (12))){
var inst_51633 = (state_51706[(2)]);
var state_51706__$1 = state_51706;
var statearr_51758_51826 = state_51706__$1;
(statearr_51758_51826[(2)] = inst_51633);

(statearr_51758_51826[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (2))){
var state_51706__$1 = state_51706;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51706__$1,(4),ch);
} else {
if((state_val_51707 === (23))){
var state_51706__$1 = state_51706;
var statearr_51759_51827 = state_51706__$1;
(statearr_51759_51827[(2)] = null);

(statearr_51759_51827[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (35))){
var inst_51688 = (state_51706[(2)]);
var state_51706__$1 = state_51706;
var statearr_51760_51828 = state_51706__$1;
(statearr_51760_51828[(2)] = inst_51688);

(statearr_51760_51828[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (19))){
var inst_51605 = (state_51706[(7)]);
var inst_51609 = cljs.core.chunk_first.call(null,inst_51605);
var inst_51610 = cljs.core.chunk_rest.call(null,inst_51605);
var inst_51611 = cljs.core.count.call(null,inst_51609);
var inst_51583 = inst_51610;
var inst_51584 = inst_51609;
var inst_51585 = inst_51611;
var inst_51586 = (0);
var state_51706__$1 = (function (){var statearr_51761 = state_51706;
(statearr_51761[(13)] = inst_51585);

(statearr_51761[(14)] = inst_51586);

(statearr_51761[(15)] = inst_51583);

(statearr_51761[(17)] = inst_51584);

return statearr_51761;
})();
var statearr_51762_51829 = state_51706__$1;
(statearr_51762_51829[(2)] = null);

(statearr_51762_51829[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (11))){
var inst_51605 = (state_51706[(7)]);
var inst_51583 = (state_51706[(15)]);
var inst_51605__$1 = cljs.core.seq.call(null,inst_51583);
var state_51706__$1 = (function (){var statearr_51763 = state_51706;
(statearr_51763[(7)] = inst_51605__$1);

return statearr_51763;
})();
if(inst_51605__$1){
var statearr_51764_51830 = state_51706__$1;
(statearr_51764_51830[(1)] = (16));

} else {
var statearr_51765_51831 = state_51706__$1;
(statearr_51765_51831[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (9))){
var inst_51635 = (state_51706[(2)]);
var state_51706__$1 = state_51706;
var statearr_51766_51832 = state_51706__$1;
(statearr_51766_51832[(2)] = inst_51635);

(statearr_51766_51832[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (5))){
var inst_51581 = cljs.core.deref.call(null,cs);
var inst_51582 = cljs.core.seq.call(null,inst_51581);
var inst_51583 = inst_51582;
var inst_51584 = null;
var inst_51585 = (0);
var inst_51586 = (0);
var state_51706__$1 = (function (){var statearr_51767 = state_51706;
(statearr_51767[(13)] = inst_51585);

(statearr_51767[(14)] = inst_51586);

(statearr_51767[(15)] = inst_51583);

(statearr_51767[(17)] = inst_51584);

return statearr_51767;
})();
var statearr_51768_51833 = state_51706__$1;
(statearr_51768_51833[(2)] = null);

(statearr_51768_51833[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (14))){
var state_51706__$1 = state_51706;
var statearr_51769_51834 = state_51706__$1;
(statearr_51769_51834[(2)] = null);

(statearr_51769_51834[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (45))){
var inst_51696 = (state_51706[(2)]);
var state_51706__$1 = state_51706;
var statearr_51770_51835 = state_51706__$1;
(statearr_51770_51835[(2)] = inst_51696);

(statearr_51770_51835[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (26))){
var inst_51638 = (state_51706[(29)]);
var inst_51692 = (state_51706[(2)]);
var inst_51693 = cljs.core.seq.call(null,inst_51638);
var state_51706__$1 = (function (){var statearr_51771 = state_51706;
(statearr_51771[(31)] = inst_51692);

return statearr_51771;
})();
if(inst_51693){
var statearr_51772_51836 = state_51706__$1;
(statearr_51772_51836[(1)] = (42));

} else {
var statearr_51773_51837 = state_51706__$1;
(statearr_51773_51837[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (16))){
var inst_51605 = (state_51706[(7)]);
var inst_51607 = cljs.core.chunked_seq_QMARK_.call(null,inst_51605);
var state_51706__$1 = state_51706;
if(inst_51607){
var statearr_51774_51838 = state_51706__$1;
(statearr_51774_51838[(1)] = (19));

} else {
var statearr_51775_51839 = state_51706__$1;
(statearr_51775_51839[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (38))){
var inst_51685 = (state_51706[(2)]);
var state_51706__$1 = state_51706;
var statearr_51776_51840 = state_51706__$1;
(statearr_51776_51840[(2)] = inst_51685);

(statearr_51776_51840[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (30))){
var state_51706__$1 = state_51706;
var statearr_51777_51841 = state_51706__$1;
(statearr_51777_51841[(2)] = null);

(statearr_51777_51841[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (10))){
var inst_51586 = (state_51706[(14)]);
var inst_51584 = (state_51706[(17)]);
var inst_51594 = cljs.core._nth.call(null,inst_51584,inst_51586);
var inst_51595 = cljs.core.nth.call(null,inst_51594,(0),null);
var inst_51596 = cljs.core.nth.call(null,inst_51594,(1),null);
var state_51706__$1 = (function (){var statearr_51778 = state_51706;
(statearr_51778[(26)] = inst_51595);

return statearr_51778;
})();
if(cljs.core.truth_(inst_51596)){
var statearr_51779_51842 = state_51706__$1;
(statearr_51779_51842[(1)] = (13));

} else {
var statearr_51780_51843 = state_51706__$1;
(statearr_51780_51843[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (18))){
var inst_51631 = (state_51706[(2)]);
var state_51706__$1 = state_51706;
var statearr_51781_51844 = state_51706__$1;
(statearr_51781_51844[(2)] = inst_51631);

(statearr_51781_51844[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (42))){
var state_51706__$1 = state_51706;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51706__$1,(45),dchan);
} else {
if((state_val_51707 === (37))){
var inst_51665 = (state_51706[(25)]);
var inst_51574 = (state_51706[(9)]);
var inst_51674 = (state_51706[(23)]);
var inst_51674__$1 = cljs.core.first.call(null,inst_51665);
var inst_51675 = cljs.core.async.put_BANG_.call(null,inst_51674__$1,inst_51574,done);
var state_51706__$1 = (function (){var statearr_51782 = state_51706;
(statearr_51782[(23)] = inst_51674__$1);

return statearr_51782;
})();
if(cljs.core.truth_(inst_51675)){
var statearr_51783_51845 = state_51706__$1;
(statearr_51783_51845[(1)] = (39));

} else {
var statearr_51784_51846 = state_51706__$1;
(statearr_51784_51846[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51707 === (8))){
var inst_51585 = (state_51706[(13)]);
var inst_51586 = (state_51706[(14)]);
var inst_51588 = (inst_51586 < inst_51585);
var inst_51589 = inst_51588;
var state_51706__$1 = state_51706;
if(cljs.core.truth_(inst_51589)){
var statearr_51785_51847 = state_51706__$1;
(statearr_51785_51847[(1)] = (10));

} else {
var statearr_51786_51848 = state_51706__$1;
(statearr_51786_51848[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___51794,cs,m,dchan,dctr,done))
;
return ((function (switch__33364__auto__,c__33478__auto___51794,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__33365__auto__ = null;
var cljs$core$async$mult_$_state_machine__33365__auto____0 = (function (){
var statearr_51790 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51790[(0)] = cljs$core$async$mult_$_state_machine__33365__auto__);

(statearr_51790[(1)] = (1));

return statearr_51790;
});
var cljs$core$async$mult_$_state_machine__33365__auto____1 = (function (state_51706){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_51706);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e51791){if((e51791 instanceof Object)){
var ex__33368__auto__ = e51791;
var statearr_51792_51849 = state_51706;
(statearr_51792_51849[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51706);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51791;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51850 = state_51706;
state_51706 = G__51850;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__33365__auto__ = function(state_51706){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__33365__auto____1.call(this,state_51706);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__33365__auto____0;
cljs$core$async$mult_$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__33365__auto____1;
return cljs$core$async$mult_$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___51794,cs,m,dchan,dctr,done))
})();
var state__33480__auto__ = (function (){var statearr_51793 = f__33479__auto__.call(null);
(statearr_51793[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___51794);

return statearr_51793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___51794,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args51851 = [];
var len__10640__auto___51854 = arguments.length;
var i__10641__auto___51855 = (0);
while(true){
if((i__10641__auto___51855 < len__10640__auto___51854)){
args51851.push((arguments[i__10641__auto___51855]));

var G__51856 = (i__10641__auto___51855 + (1));
i__10641__auto___51855 = G__51856;
continue;
} else {
}
break;
}

var G__51853 = args51851.length;
switch (G__51853) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args51851.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m);
} else {
var m__10138__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,state_map);
} else {
var m__10138__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,mode);
} else {
var m__10138__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___51868 = arguments.length;
var i__10641__auto___51869 = (0);
while(true){
if((i__10641__auto___51869 < len__10640__auto___51868)){
args__10647__auto__.push((arguments[i__10641__auto___51869]));

var G__51870 = (i__10641__auto___51869 + (1));
i__10641__auto___51869 = G__51870;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((3) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10648__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__51862){
var map__51863 = p__51862;
var map__51863__$1 = ((((!((map__51863 == null)))?((((map__51863.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51863.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51863):map__51863);
var opts = map__51863__$1;
var statearr_51865_51871 = state;
(statearr_51865_51871[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6738__auto__ = cljs.core.async.do_alts.call(null,((function (map__51863,map__51863__$1,opts){
return (function (val){
var statearr_51866_51872 = state;
(statearr_51866_51872[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__51863,map__51863__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6738__auto__)){
var cb = temp__6738__auto__;
var statearr_51867_51873 = state;
(statearr_51867_51873[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq51858){
var G__51859 = cljs.core.first.call(null,seq51858);
var seq51858__$1 = cljs.core.next.call(null,seq51858);
var G__51860 = cljs.core.first.call(null,seq51858__$1);
var seq51858__$2 = cljs.core.next.call(null,seq51858__$1);
var G__51861 = cljs.core.first.call(null,seq51858__$2);
var seq51858__$3 = cljs.core.next.call(null,seq51858__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__51859,G__51860,G__51861,seq51858__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async52041 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async52041 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta52042){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta52042 = meta52042;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async52041.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_52043,meta52042__$1){
var self__ = this;
var _52043__$1 = this;
return (new cljs.core.async.t_cljs$core$async52041(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta52042__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async52041.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_52043){
var self__ = this;
var _52043__$1 = this;
return self__.meta52042;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async52041.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async52041.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async52041.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async52041.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async52041.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async52041.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async52041.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async52041.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async52041.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta52042","meta52042",532051124,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async52041.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async52041.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async52041";

cljs.core.async.t_cljs$core$async52041.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async52041");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async52041 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async52041(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta52042){
return (new cljs.core.async.t_cljs$core$async52041(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta52042));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async52041(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__33478__auto___52208 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___52208,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___52208,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_52145){
var state_val_52146 = (state_52145[(1)]);
if((state_val_52146 === (7))){
var inst_52060 = (state_52145[(2)]);
var state_52145__$1 = state_52145;
var statearr_52147_52209 = state_52145__$1;
(statearr_52147_52209[(2)] = inst_52060);

(statearr_52147_52209[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (20))){
var inst_52072 = (state_52145[(7)]);
var state_52145__$1 = state_52145;
var statearr_52148_52210 = state_52145__$1;
(statearr_52148_52210[(2)] = inst_52072);

(statearr_52148_52210[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (27))){
var state_52145__$1 = state_52145;
var statearr_52149_52211 = state_52145__$1;
(statearr_52149_52211[(2)] = null);

(statearr_52149_52211[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (1))){
var inst_52047 = (state_52145[(8)]);
var inst_52047__$1 = calc_state.call(null);
var inst_52049 = (inst_52047__$1 == null);
var inst_52050 = cljs.core.not.call(null,inst_52049);
var state_52145__$1 = (function (){var statearr_52150 = state_52145;
(statearr_52150[(8)] = inst_52047__$1);

return statearr_52150;
})();
if(inst_52050){
var statearr_52151_52212 = state_52145__$1;
(statearr_52151_52212[(1)] = (2));

} else {
var statearr_52152_52213 = state_52145__$1;
(statearr_52152_52213[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (24))){
var inst_52119 = (state_52145[(9)]);
var inst_52105 = (state_52145[(10)]);
var inst_52096 = (state_52145[(11)]);
var inst_52119__$1 = inst_52096.call(null,inst_52105);
var state_52145__$1 = (function (){var statearr_52153 = state_52145;
(statearr_52153[(9)] = inst_52119__$1);

return statearr_52153;
})();
if(cljs.core.truth_(inst_52119__$1)){
var statearr_52154_52214 = state_52145__$1;
(statearr_52154_52214[(1)] = (29));

} else {
var statearr_52155_52215 = state_52145__$1;
(statearr_52155_52215[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (4))){
var inst_52063 = (state_52145[(2)]);
var state_52145__$1 = state_52145;
if(cljs.core.truth_(inst_52063)){
var statearr_52156_52216 = state_52145__$1;
(statearr_52156_52216[(1)] = (8));

} else {
var statearr_52157_52217 = state_52145__$1;
(statearr_52157_52217[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (15))){
var inst_52090 = (state_52145[(2)]);
var state_52145__$1 = state_52145;
if(cljs.core.truth_(inst_52090)){
var statearr_52158_52218 = state_52145__$1;
(statearr_52158_52218[(1)] = (19));

} else {
var statearr_52159_52219 = state_52145__$1;
(statearr_52159_52219[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (21))){
var inst_52095 = (state_52145[(12)]);
var inst_52095__$1 = (state_52145[(2)]);
var inst_52096 = cljs.core.get.call(null,inst_52095__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_52097 = cljs.core.get.call(null,inst_52095__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_52098 = cljs.core.get.call(null,inst_52095__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_52145__$1 = (function (){var statearr_52160 = state_52145;
(statearr_52160[(12)] = inst_52095__$1);

(statearr_52160[(13)] = inst_52097);

(statearr_52160[(11)] = inst_52096);

return statearr_52160;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_52145__$1,(22),inst_52098);
} else {
if((state_val_52146 === (31))){
var inst_52127 = (state_52145[(2)]);
var state_52145__$1 = state_52145;
if(cljs.core.truth_(inst_52127)){
var statearr_52161_52220 = state_52145__$1;
(statearr_52161_52220[(1)] = (32));

} else {
var statearr_52162_52221 = state_52145__$1;
(statearr_52162_52221[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (32))){
var inst_52104 = (state_52145[(14)]);
var state_52145__$1 = state_52145;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_52145__$1,(35),out,inst_52104);
} else {
if((state_val_52146 === (33))){
var inst_52095 = (state_52145[(12)]);
var inst_52072 = inst_52095;
var state_52145__$1 = (function (){var statearr_52163 = state_52145;
(statearr_52163[(7)] = inst_52072);

return statearr_52163;
})();
var statearr_52164_52222 = state_52145__$1;
(statearr_52164_52222[(2)] = null);

(statearr_52164_52222[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (13))){
var inst_52072 = (state_52145[(7)]);
var inst_52079 = inst_52072.cljs$lang$protocol_mask$partition0$;
var inst_52080 = (inst_52079 & (64));
var inst_52081 = inst_52072.cljs$core$ISeq$;
var inst_52082 = (cljs.core.PROTOCOL_SENTINEL === inst_52081);
var inst_52083 = (inst_52080) || (inst_52082);
var state_52145__$1 = state_52145;
if(cljs.core.truth_(inst_52083)){
var statearr_52165_52223 = state_52145__$1;
(statearr_52165_52223[(1)] = (16));

} else {
var statearr_52166_52224 = state_52145__$1;
(statearr_52166_52224[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (22))){
var inst_52104 = (state_52145[(14)]);
var inst_52105 = (state_52145[(10)]);
var inst_52103 = (state_52145[(2)]);
var inst_52104__$1 = cljs.core.nth.call(null,inst_52103,(0),null);
var inst_52105__$1 = cljs.core.nth.call(null,inst_52103,(1),null);
var inst_52106 = (inst_52104__$1 == null);
var inst_52107 = cljs.core._EQ_.call(null,inst_52105__$1,change);
var inst_52108 = (inst_52106) || (inst_52107);
var state_52145__$1 = (function (){var statearr_52167 = state_52145;
(statearr_52167[(14)] = inst_52104__$1);

(statearr_52167[(10)] = inst_52105__$1);

return statearr_52167;
})();
if(cljs.core.truth_(inst_52108)){
var statearr_52168_52225 = state_52145__$1;
(statearr_52168_52225[(1)] = (23));

} else {
var statearr_52169_52226 = state_52145__$1;
(statearr_52169_52226[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (36))){
var inst_52095 = (state_52145[(12)]);
var inst_52072 = inst_52095;
var state_52145__$1 = (function (){var statearr_52170 = state_52145;
(statearr_52170[(7)] = inst_52072);

return statearr_52170;
})();
var statearr_52171_52227 = state_52145__$1;
(statearr_52171_52227[(2)] = null);

(statearr_52171_52227[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (29))){
var inst_52119 = (state_52145[(9)]);
var state_52145__$1 = state_52145;
var statearr_52172_52228 = state_52145__$1;
(statearr_52172_52228[(2)] = inst_52119);

(statearr_52172_52228[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (6))){
var state_52145__$1 = state_52145;
var statearr_52173_52229 = state_52145__$1;
(statearr_52173_52229[(2)] = false);

(statearr_52173_52229[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (28))){
var inst_52115 = (state_52145[(2)]);
var inst_52116 = calc_state.call(null);
var inst_52072 = inst_52116;
var state_52145__$1 = (function (){var statearr_52174 = state_52145;
(statearr_52174[(15)] = inst_52115);

(statearr_52174[(7)] = inst_52072);

return statearr_52174;
})();
var statearr_52175_52230 = state_52145__$1;
(statearr_52175_52230[(2)] = null);

(statearr_52175_52230[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (25))){
var inst_52141 = (state_52145[(2)]);
var state_52145__$1 = state_52145;
var statearr_52176_52231 = state_52145__$1;
(statearr_52176_52231[(2)] = inst_52141);

(statearr_52176_52231[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (34))){
var inst_52139 = (state_52145[(2)]);
var state_52145__$1 = state_52145;
var statearr_52177_52232 = state_52145__$1;
(statearr_52177_52232[(2)] = inst_52139);

(statearr_52177_52232[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (17))){
var state_52145__$1 = state_52145;
var statearr_52178_52233 = state_52145__$1;
(statearr_52178_52233[(2)] = false);

(statearr_52178_52233[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (3))){
var state_52145__$1 = state_52145;
var statearr_52179_52234 = state_52145__$1;
(statearr_52179_52234[(2)] = false);

(statearr_52179_52234[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (12))){
var inst_52143 = (state_52145[(2)]);
var state_52145__$1 = state_52145;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52145__$1,inst_52143);
} else {
if((state_val_52146 === (2))){
var inst_52047 = (state_52145[(8)]);
var inst_52052 = inst_52047.cljs$lang$protocol_mask$partition0$;
var inst_52053 = (inst_52052 & (64));
var inst_52054 = inst_52047.cljs$core$ISeq$;
var inst_52055 = (cljs.core.PROTOCOL_SENTINEL === inst_52054);
var inst_52056 = (inst_52053) || (inst_52055);
var state_52145__$1 = state_52145;
if(cljs.core.truth_(inst_52056)){
var statearr_52180_52235 = state_52145__$1;
(statearr_52180_52235[(1)] = (5));

} else {
var statearr_52181_52236 = state_52145__$1;
(statearr_52181_52236[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (23))){
var inst_52104 = (state_52145[(14)]);
var inst_52110 = (inst_52104 == null);
var state_52145__$1 = state_52145;
if(cljs.core.truth_(inst_52110)){
var statearr_52182_52237 = state_52145__$1;
(statearr_52182_52237[(1)] = (26));

} else {
var statearr_52183_52238 = state_52145__$1;
(statearr_52183_52238[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (35))){
var inst_52130 = (state_52145[(2)]);
var state_52145__$1 = state_52145;
if(cljs.core.truth_(inst_52130)){
var statearr_52184_52239 = state_52145__$1;
(statearr_52184_52239[(1)] = (36));

} else {
var statearr_52185_52240 = state_52145__$1;
(statearr_52185_52240[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (19))){
var inst_52072 = (state_52145[(7)]);
var inst_52092 = cljs.core.apply.call(null,cljs.core.hash_map,inst_52072);
var state_52145__$1 = state_52145;
var statearr_52186_52241 = state_52145__$1;
(statearr_52186_52241[(2)] = inst_52092);

(statearr_52186_52241[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (11))){
var inst_52072 = (state_52145[(7)]);
var inst_52076 = (inst_52072 == null);
var inst_52077 = cljs.core.not.call(null,inst_52076);
var state_52145__$1 = state_52145;
if(inst_52077){
var statearr_52187_52242 = state_52145__$1;
(statearr_52187_52242[(1)] = (13));

} else {
var statearr_52188_52243 = state_52145__$1;
(statearr_52188_52243[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (9))){
var inst_52047 = (state_52145[(8)]);
var state_52145__$1 = state_52145;
var statearr_52189_52244 = state_52145__$1;
(statearr_52189_52244[(2)] = inst_52047);

(statearr_52189_52244[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (5))){
var state_52145__$1 = state_52145;
var statearr_52190_52245 = state_52145__$1;
(statearr_52190_52245[(2)] = true);

(statearr_52190_52245[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (14))){
var state_52145__$1 = state_52145;
var statearr_52191_52246 = state_52145__$1;
(statearr_52191_52246[(2)] = false);

(statearr_52191_52246[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (26))){
var inst_52105 = (state_52145[(10)]);
var inst_52112 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_52105);
var state_52145__$1 = state_52145;
var statearr_52192_52247 = state_52145__$1;
(statearr_52192_52247[(2)] = inst_52112);

(statearr_52192_52247[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (16))){
var state_52145__$1 = state_52145;
var statearr_52193_52248 = state_52145__$1;
(statearr_52193_52248[(2)] = true);

(statearr_52193_52248[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (38))){
var inst_52135 = (state_52145[(2)]);
var state_52145__$1 = state_52145;
var statearr_52194_52249 = state_52145__$1;
(statearr_52194_52249[(2)] = inst_52135);

(statearr_52194_52249[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (30))){
var inst_52105 = (state_52145[(10)]);
var inst_52097 = (state_52145[(13)]);
var inst_52096 = (state_52145[(11)]);
var inst_52122 = cljs.core.empty_QMARK_.call(null,inst_52096);
var inst_52123 = inst_52097.call(null,inst_52105);
var inst_52124 = cljs.core.not.call(null,inst_52123);
var inst_52125 = (inst_52122) && (inst_52124);
var state_52145__$1 = state_52145;
var statearr_52195_52250 = state_52145__$1;
(statearr_52195_52250[(2)] = inst_52125);

(statearr_52195_52250[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (10))){
var inst_52047 = (state_52145[(8)]);
var inst_52068 = (state_52145[(2)]);
var inst_52069 = cljs.core.get.call(null,inst_52068,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_52070 = cljs.core.get.call(null,inst_52068,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_52071 = cljs.core.get.call(null,inst_52068,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_52072 = inst_52047;
var state_52145__$1 = (function (){var statearr_52196 = state_52145;
(statearr_52196[(16)] = inst_52070);

(statearr_52196[(17)] = inst_52069);

(statearr_52196[(7)] = inst_52072);

(statearr_52196[(18)] = inst_52071);

return statearr_52196;
})();
var statearr_52197_52251 = state_52145__$1;
(statearr_52197_52251[(2)] = null);

(statearr_52197_52251[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (18))){
var inst_52087 = (state_52145[(2)]);
var state_52145__$1 = state_52145;
var statearr_52198_52252 = state_52145__$1;
(statearr_52198_52252[(2)] = inst_52087);

(statearr_52198_52252[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (37))){
var state_52145__$1 = state_52145;
var statearr_52199_52253 = state_52145__$1;
(statearr_52199_52253[(2)] = null);

(statearr_52199_52253[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52146 === (8))){
var inst_52047 = (state_52145[(8)]);
var inst_52065 = cljs.core.apply.call(null,cljs.core.hash_map,inst_52047);
var state_52145__$1 = state_52145;
var statearr_52200_52254 = state_52145__$1;
(statearr_52200_52254[(2)] = inst_52065);

(statearr_52200_52254[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___52208,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__33364__auto__,c__33478__auto___52208,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__33365__auto__ = null;
var cljs$core$async$mix_$_state_machine__33365__auto____0 = (function (){
var statearr_52204 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52204[(0)] = cljs$core$async$mix_$_state_machine__33365__auto__);

(statearr_52204[(1)] = (1));

return statearr_52204;
});
var cljs$core$async$mix_$_state_machine__33365__auto____1 = (function (state_52145){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_52145);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e52205){if((e52205 instanceof Object)){
var ex__33368__auto__ = e52205;
var statearr_52206_52255 = state_52145;
(statearr_52206_52255[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52145);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52205;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52256 = state_52145;
state_52145 = G__52256;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__33365__auto__ = function(state_52145){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__33365__auto____1.call(this,state_52145);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__33365__auto____0;
cljs$core$async$mix_$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__33365__auto____1;
return cljs$core$async$mix_$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___52208,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__33480__auto__ = (function (){var statearr_52207 = f__33479__auto__.call(null);
(statearr_52207[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___52208);

return statearr_52207;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___52208,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__10138__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p,v,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args52257 = [];
var len__10640__auto___52260 = arguments.length;
var i__10641__auto___52261 = (0);
while(true){
if((i__10641__auto___52261 < len__10640__auto___52260)){
args52257.push((arguments[i__10641__auto___52261]));

var G__52262 = (i__10641__auto___52261 + (1));
i__10641__auto___52261 = G__52262;
continue;
} else {
}
break;
}

var G__52259 = args52257.length;
switch (G__52259) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52257.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p);
} else {
var m__10138__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p,v);
} else {
var m__10138__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args52265 = [];
var len__10640__auto___52390 = arguments.length;
var i__10641__auto___52391 = (0);
while(true){
if((i__10641__auto___52391 < len__10640__auto___52390)){
args52265.push((arguments[i__10641__auto___52391]));

var G__52392 = (i__10641__auto___52391 + (1));
i__10641__auto___52391 = G__52392;
continue;
} else {
}
break;
}

var G__52267 = args52265.length;
switch (G__52267) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52265.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__9419__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__9419__auto__,mults){
return (function (p1__52264_SHARP_){
if(cljs.core.truth_(p1__52264_SHARP_.call(null,topic))){
return p1__52264_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__52264_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__9419__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async52268 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async52268 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta52269){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta52269 = meta52269;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async52268.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_52270,meta52269__$1){
var self__ = this;
var _52270__$1 = this;
return (new cljs.core.async.t_cljs$core$async52268(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta52269__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async52268.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_52270){
var self__ = this;
var _52270__$1 = this;
return self__.meta52269;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async52268.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async52268.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async52268.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async52268.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async52268.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6738__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6738__auto__)){
var m = temp__6738__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async52268.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async52268.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async52268.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta52269","meta52269",1756594917,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async52268.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async52268.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async52268";

cljs.core.async.t_cljs$core$async52268.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async52268");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async52268 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async52268(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta52269){
return (new cljs.core.async.t_cljs$core$async52268(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta52269));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async52268(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__33478__auto___52394 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___52394,mults,ensure_mult,p){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___52394,mults,ensure_mult,p){
return (function (state_52342){
var state_val_52343 = (state_52342[(1)]);
if((state_val_52343 === (7))){
var inst_52338 = (state_52342[(2)]);
var state_52342__$1 = state_52342;
var statearr_52344_52395 = state_52342__$1;
(statearr_52344_52395[(2)] = inst_52338);

(statearr_52344_52395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (20))){
var state_52342__$1 = state_52342;
var statearr_52345_52396 = state_52342__$1;
(statearr_52345_52396[(2)] = null);

(statearr_52345_52396[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (1))){
var state_52342__$1 = state_52342;
var statearr_52346_52397 = state_52342__$1;
(statearr_52346_52397[(2)] = null);

(statearr_52346_52397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (24))){
var inst_52321 = (state_52342[(7)]);
var inst_52330 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_52321);
var state_52342__$1 = state_52342;
var statearr_52347_52398 = state_52342__$1;
(statearr_52347_52398[(2)] = inst_52330);

(statearr_52347_52398[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (4))){
var inst_52273 = (state_52342[(8)]);
var inst_52273__$1 = (state_52342[(2)]);
var inst_52274 = (inst_52273__$1 == null);
var state_52342__$1 = (function (){var statearr_52348 = state_52342;
(statearr_52348[(8)] = inst_52273__$1);

return statearr_52348;
})();
if(cljs.core.truth_(inst_52274)){
var statearr_52349_52399 = state_52342__$1;
(statearr_52349_52399[(1)] = (5));

} else {
var statearr_52350_52400 = state_52342__$1;
(statearr_52350_52400[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (15))){
var inst_52315 = (state_52342[(2)]);
var state_52342__$1 = state_52342;
var statearr_52351_52401 = state_52342__$1;
(statearr_52351_52401[(2)] = inst_52315);

(statearr_52351_52401[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (21))){
var inst_52335 = (state_52342[(2)]);
var state_52342__$1 = (function (){var statearr_52352 = state_52342;
(statearr_52352[(9)] = inst_52335);

return statearr_52352;
})();
var statearr_52353_52402 = state_52342__$1;
(statearr_52353_52402[(2)] = null);

(statearr_52353_52402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (13))){
var inst_52297 = (state_52342[(10)]);
var inst_52299 = cljs.core.chunked_seq_QMARK_.call(null,inst_52297);
var state_52342__$1 = state_52342;
if(inst_52299){
var statearr_52354_52403 = state_52342__$1;
(statearr_52354_52403[(1)] = (16));

} else {
var statearr_52355_52404 = state_52342__$1;
(statearr_52355_52404[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (22))){
var inst_52327 = (state_52342[(2)]);
var state_52342__$1 = state_52342;
if(cljs.core.truth_(inst_52327)){
var statearr_52356_52405 = state_52342__$1;
(statearr_52356_52405[(1)] = (23));

} else {
var statearr_52357_52406 = state_52342__$1;
(statearr_52357_52406[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (6))){
var inst_52273 = (state_52342[(8)]);
var inst_52323 = (state_52342[(11)]);
var inst_52321 = (state_52342[(7)]);
var inst_52321__$1 = topic_fn.call(null,inst_52273);
var inst_52322 = cljs.core.deref.call(null,mults);
var inst_52323__$1 = cljs.core.get.call(null,inst_52322,inst_52321__$1);
var state_52342__$1 = (function (){var statearr_52358 = state_52342;
(statearr_52358[(11)] = inst_52323__$1);

(statearr_52358[(7)] = inst_52321__$1);

return statearr_52358;
})();
if(cljs.core.truth_(inst_52323__$1)){
var statearr_52359_52407 = state_52342__$1;
(statearr_52359_52407[(1)] = (19));

} else {
var statearr_52360_52408 = state_52342__$1;
(statearr_52360_52408[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (25))){
var inst_52332 = (state_52342[(2)]);
var state_52342__$1 = state_52342;
var statearr_52361_52409 = state_52342__$1;
(statearr_52361_52409[(2)] = inst_52332);

(statearr_52361_52409[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (17))){
var inst_52297 = (state_52342[(10)]);
var inst_52306 = cljs.core.first.call(null,inst_52297);
var inst_52307 = cljs.core.async.muxch_STAR_.call(null,inst_52306);
var inst_52308 = cljs.core.async.close_BANG_.call(null,inst_52307);
var inst_52309 = cljs.core.next.call(null,inst_52297);
var inst_52283 = inst_52309;
var inst_52284 = null;
var inst_52285 = (0);
var inst_52286 = (0);
var state_52342__$1 = (function (){var statearr_52362 = state_52342;
(statearr_52362[(12)] = inst_52285);

(statearr_52362[(13)] = inst_52283);

(statearr_52362[(14)] = inst_52286);

(statearr_52362[(15)] = inst_52308);

(statearr_52362[(16)] = inst_52284);

return statearr_52362;
})();
var statearr_52363_52410 = state_52342__$1;
(statearr_52363_52410[(2)] = null);

(statearr_52363_52410[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (3))){
var inst_52340 = (state_52342[(2)]);
var state_52342__$1 = state_52342;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52342__$1,inst_52340);
} else {
if((state_val_52343 === (12))){
var inst_52317 = (state_52342[(2)]);
var state_52342__$1 = state_52342;
var statearr_52364_52411 = state_52342__$1;
(statearr_52364_52411[(2)] = inst_52317);

(statearr_52364_52411[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (2))){
var state_52342__$1 = state_52342;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52342__$1,(4),ch);
} else {
if((state_val_52343 === (23))){
var state_52342__$1 = state_52342;
var statearr_52365_52412 = state_52342__$1;
(statearr_52365_52412[(2)] = null);

(statearr_52365_52412[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (19))){
var inst_52273 = (state_52342[(8)]);
var inst_52323 = (state_52342[(11)]);
var inst_52325 = cljs.core.async.muxch_STAR_.call(null,inst_52323);
var state_52342__$1 = state_52342;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_52342__$1,(22),inst_52325,inst_52273);
} else {
if((state_val_52343 === (11))){
var inst_52283 = (state_52342[(13)]);
var inst_52297 = (state_52342[(10)]);
var inst_52297__$1 = cljs.core.seq.call(null,inst_52283);
var state_52342__$1 = (function (){var statearr_52366 = state_52342;
(statearr_52366[(10)] = inst_52297__$1);

return statearr_52366;
})();
if(inst_52297__$1){
var statearr_52367_52413 = state_52342__$1;
(statearr_52367_52413[(1)] = (13));

} else {
var statearr_52368_52414 = state_52342__$1;
(statearr_52368_52414[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (9))){
var inst_52319 = (state_52342[(2)]);
var state_52342__$1 = state_52342;
var statearr_52369_52415 = state_52342__$1;
(statearr_52369_52415[(2)] = inst_52319);

(statearr_52369_52415[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (5))){
var inst_52280 = cljs.core.deref.call(null,mults);
var inst_52281 = cljs.core.vals.call(null,inst_52280);
var inst_52282 = cljs.core.seq.call(null,inst_52281);
var inst_52283 = inst_52282;
var inst_52284 = null;
var inst_52285 = (0);
var inst_52286 = (0);
var state_52342__$1 = (function (){var statearr_52370 = state_52342;
(statearr_52370[(12)] = inst_52285);

(statearr_52370[(13)] = inst_52283);

(statearr_52370[(14)] = inst_52286);

(statearr_52370[(16)] = inst_52284);

return statearr_52370;
})();
var statearr_52371_52416 = state_52342__$1;
(statearr_52371_52416[(2)] = null);

(statearr_52371_52416[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (14))){
var state_52342__$1 = state_52342;
var statearr_52375_52417 = state_52342__$1;
(statearr_52375_52417[(2)] = null);

(statearr_52375_52417[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (16))){
var inst_52297 = (state_52342[(10)]);
var inst_52301 = cljs.core.chunk_first.call(null,inst_52297);
var inst_52302 = cljs.core.chunk_rest.call(null,inst_52297);
var inst_52303 = cljs.core.count.call(null,inst_52301);
var inst_52283 = inst_52302;
var inst_52284 = inst_52301;
var inst_52285 = inst_52303;
var inst_52286 = (0);
var state_52342__$1 = (function (){var statearr_52376 = state_52342;
(statearr_52376[(12)] = inst_52285);

(statearr_52376[(13)] = inst_52283);

(statearr_52376[(14)] = inst_52286);

(statearr_52376[(16)] = inst_52284);

return statearr_52376;
})();
var statearr_52377_52418 = state_52342__$1;
(statearr_52377_52418[(2)] = null);

(statearr_52377_52418[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (10))){
var inst_52285 = (state_52342[(12)]);
var inst_52283 = (state_52342[(13)]);
var inst_52286 = (state_52342[(14)]);
var inst_52284 = (state_52342[(16)]);
var inst_52291 = cljs.core._nth.call(null,inst_52284,inst_52286);
var inst_52292 = cljs.core.async.muxch_STAR_.call(null,inst_52291);
var inst_52293 = cljs.core.async.close_BANG_.call(null,inst_52292);
var inst_52294 = (inst_52286 + (1));
var tmp52372 = inst_52285;
var tmp52373 = inst_52283;
var tmp52374 = inst_52284;
var inst_52283__$1 = tmp52373;
var inst_52284__$1 = tmp52374;
var inst_52285__$1 = tmp52372;
var inst_52286__$1 = inst_52294;
var state_52342__$1 = (function (){var statearr_52378 = state_52342;
(statearr_52378[(12)] = inst_52285__$1);

(statearr_52378[(17)] = inst_52293);

(statearr_52378[(13)] = inst_52283__$1);

(statearr_52378[(14)] = inst_52286__$1);

(statearr_52378[(16)] = inst_52284__$1);

return statearr_52378;
})();
var statearr_52379_52419 = state_52342__$1;
(statearr_52379_52419[(2)] = null);

(statearr_52379_52419[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (18))){
var inst_52312 = (state_52342[(2)]);
var state_52342__$1 = state_52342;
var statearr_52380_52420 = state_52342__$1;
(statearr_52380_52420[(2)] = inst_52312);

(statearr_52380_52420[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52343 === (8))){
var inst_52285 = (state_52342[(12)]);
var inst_52286 = (state_52342[(14)]);
var inst_52288 = (inst_52286 < inst_52285);
var inst_52289 = inst_52288;
var state_52342__$1 = state_52342;
if(cljs.core.truth_(inst_52289)){
var statearr_52381_52421 = state_52342__$1;
(statearr_52381_52421[(1)] = (10));

} else {
var statearr_52382_52422 = state_52342__$1;
(statearr_52382_52422[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___52394,mults,ensure_mult,p))
;
return ((function (switch__33364__auto__,c__33478__auto___52394,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_52386 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52386[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_52386[(1)] = (1));

return statearr_52386;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_52342){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_52342);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e52387){if((e52387 instanceof Object)){
var ex__33368__auto__ = e52387;
var statearr_52388_52423 = state_52342;
(statearr_52388_52423[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52342);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52387;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52424 = state_52342;
state_52342 = G__52424;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_52342){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_52342);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___52394,mults,ensure_mult,p))
})();
var state__33480__auto__ = (function (){var statearr_52389 = f__33479__auto__.call(null);
(statearr_52389[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___52394);

return statearr_52389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___52394,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args52425 = [];
var len__10640__auto___52428 = arguments.length;
var i__10641__auto___52429 = (0);
while(true){
if((i__10641__auto___52429 < len__10640__auto___52428)){
args52425.push((arguments[i__10641__auto___52429]));

var G__52430 = (i__10641__auto___52429 + (1));
i__10641__auto___52429 = G__52430;
continue;
} else {
}
break;
}

var G__52427 = args52425.length;
switch (G__52427) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52425.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args52432 = [];
var len__10640__auto___52435 = arguments.length;
var i__10641__auto___52436 = (0);
while(true){
if((i__10641__auto___52436 < len__10640__auto___52435)){
args52432.push((arguments[i__10641__auto___52436]));

var G__52437 = (i__10641__auto___52436 + (1));
i__10641__auto___52436 = G__52437;
continue;
} else {
}
break;
}

var G__52434 = args52432.length;
switch (G__52434) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52432.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args52439 = [];
var len__10640__auto___52510 = arguments.length;
var i__10641__auto___52511 = (0);
while(true){
if((i__10641__auto___52511 < len__10640__auto___52510)){
args52439.push((arguments[i__10641__auto___52511]));

var G__52512 = (i__10641__auto___52511 + (1));
i__10641__auto___52511 = G__52512;
continue;
} else {
}
break;
}

var G__52441 = args52439.length;
switch (G__52441) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52439.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__33478__auto___52514 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___52514,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___52514,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_52480){
var state_val_52481 = (state_52480[(1)]);
if((state_val_52481 === (7))){
var state_52480__$1 = state_52480;
var statearr_52482_52515 = state_52480__$1;
(statearr_52482_52515[(2)] = null);

(statearr_52482_52515[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52481 === (1))){
var state_52480__$1 = state_52480;
var statearr_52483_52516 = state_52480__$1;
(statearr_52483_52516[(2)] = null);

(statearr_52483_52516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52481 === (4))){
var inst_52444 = (state_52480[(7)]);
var inst_52446 = (inst_52444 < cnt);
var state_52480__$1 = state_52480;
if(cljs.core.truth_(inst_52446)){
var statearr_52484_52517 = state_52480__$1;
(statearr_52484_52517[(1)] = (6));

} else {
var statearr_52485_52518 = state_52480__$1;
(statearr_52485_52518[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52481 === (15))){
var inst_52476 = (state_52480[(2)]);
var state_52480__$1 = state_52480;
var statearr_52486_52519 = state_52480__$1;
(statearr_52486_52519[(2)] = inst_52476);

(statearr_52486_52519[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52481 === (13))){
var inst_52469 = cljs.core.async.close_BANG_.call(null,out);
var state_52480__$1 = state_52480;
var statearr_52487_52520 = state_52480__$1;
(statearr_52487_52520[(2)] = inst_52469);

(statearr_52487_52520[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52481 === (6))){
var state_52480__$1 = state_52480;
var statearr_52488_52521 = state_52480__$1;
(statearr_52488_52521[(2)] = null);

(statearr_52488_52521[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52481 === (3))){
var inst_52478 = (state_52480[(2)]);
var state_52480__$1 = state_52480;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52480__$1,inst_52478);
} else {
if((state_val_52481 === (12))){
var inst_52466 = (state_52480[(8)]);
var inst_52466__$1 = (state_52480[(2)]);
var inst_52467 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_52466__$1);
var state_52480__$1 = (function (){var statearr_52489 = state_52480;
(statearr_52489[(8)] = inst_52466__$1);

return statearr_52489;
})();
if(cljs.core.truth_(inst_52467)){
var statearr_52490_52522 = state_52480__$1;
(statearr_52490_52522[(1)] = (13));

} else {
var statearr_52491_52523 = state_52480__$1;
(statearr_52491_52523[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52481 === (2))){
var inst_52443 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_52444 = (0);
var state_52480__$1 = (function (){var statearr_52492 = state_52480;
(statearr_52492[(9)] = inst_52443);

(statearr_52492[(7)] = inst_52444);

return statearr_52492;
})();
var statearr_52493_52524 = state_52480__$1;
(statearr_52493_52524[(2)] = null);

(statearr_52493_52524[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52481 === (11))){
var inst_52444 = (state_52480[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_52480,(10),Object,null,(9));
var inst_52453 = chs__$1.call(null,inst_52444);
var inst_52454 = done.call(null,inst_52444);
var inst_52455 = cljs.core.async.take_BANG_.call(null,inst_52453,inst_52454);
var state_52480__$1 = state_52480;
var statearr_52494_52525 = state_52480__$1;
(statearr_52494_52525[(2)] = inst_52455);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52480__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52481 === (9))){
var inst_52444 = (state_52480[(7)]);
var inst_52457 = (state_52480[(2)]);
var inst_52458 = (inst_52444 + (1));
var inst_52444__$1 = inst_52458;
var state_52480__$1 = (function (){var statearr_52495 = state_52480;
(statearr_52495[(7)] = inst_52444__$1);

(statearr_52495[(10)] = inst_52457);

return statearr_52495;
})();
var statearr_52496_52526 = state_52480__$1;
(statearr_52496_52526[(2)] = null);

(statearr_52496_52526[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52481 === (5))){
var inst_52464 = (state_52480[(2)]);
var state_52480__$1 = (function (){var statearr_52497 = state_52480;
(statearr_52497[(11)] = inst_52464);

return statearr_52497;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52480__$1,(12),dchan);
} else {
if((state_val_52481 === (14))){
var inst_52466 = (state_52480[(8)]);
var inst_52471 = cljs.core.apply.call(null,f,inst_52466);
var state_52480__$1 = state_52480;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_52480__$1,(16),out,inst_52471);
} else {
if((state_val_52481 === (16))){
var inst_52473 = (state_52480[(2)]);
var state_52480__$1 = (function (){var statearr_52498 = state_52480;
(statearr_52498[(12)] = inst_52473);

return statearr_52498;
})();
var statearr_52499_52527 = state_52480__$1;
(statearr_52499_52527[(2)] = null);

(statearr_52499_52527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52481 === (10))){
var inst_52448 = (state_52480[(2)]);
var inst_52449 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_52480__$1 = (function (){var statearr_52500 = state_52480;
(statearr_52500[(13)] = inst_52448);

return statearr_52500;
})();
var statearr_52501_52528 = state_52480__$1;
(statearr_52501_52528[(2)] = inst_52449);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52480__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52481 === (8))){
var inst_52462 = (state_52480[(2)]);
var state_52480__$1 = state_52480;
var statearr_52502_52529 = state_52480__$1;
(statearr_52502_52529[(2)] = inst_52462);

(statearr_52502_52529[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___52514,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__33364__auto__,c__33478__auto___52514,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_52506 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52506[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_52506[(1)] = (1));

return statearr_52506;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_52480){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_52480);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e52507){if((e52507 instanceof Object)){
var ex__33368__auto__ = e52507;
var statearr_52508_52530 = state_52480;
(statearr_52508_52530[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52480);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52507;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52531 = state_52480;
state_52480 = G__52531;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_52480){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_52480);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___52514,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__33480__auto__ = (function (){var statearr_52509 = f__33479__auto__.call(null);
(statearr_52509[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___52514);

return statearr_52509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___52514,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args52533 = [];
var len__10640__auto___52591 = arguments.length;
var i__10641__auto___52592 = (0);
while(true){
if((i__10641__auto___52592 < len__10640__auto___52591)){
args52533.push((arguments[i__10641__auto___52592]));

var G__52593 = (i__10641__auto___52592 + (1));
i__10641__auto___52592 = G__52593;
continue;
} else {
}
break;
}

var G__52535 = args52533.length;
switch (G__52535) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52533.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33478__auto___52595 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___52595,out){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___52595,out){
return (function (state_52567){
var state_val_52568 = (state_52567[(1)]);
if((state_val_52568 === (7))){
var inst_52547 = (state_52567[(7)]);
var inst_52546 = (state_52567[(8)]);
var inst_52546__$1 = (state_52567[(2)]);
var inst_52547__$1 = cljs.core.nth.call(null,inst_52546__$1,(0),null);
var inst_52548 = cljs.core.nth.call(null,inst_52546__$1,(1),null);
var inst_52549 = (inst_52547__$1 == null);
var state_52567__$1 = (function (){var statearr_52569 = state_52567;
(statearr_52569[(9)] = inst_52548);

(statearr_52569[(7)] = inst_52547__$1);

(statearr_52569[(8)] = inst_52546__$1);

return statearr_52569;
})();
if(cljs.core.truth_(inst_52549)){
var statearr_52570_52596 = state_52567__$1;
(statearr_52570_52596[(1)] = (8));

} else {
var statearr_52571_52597 = state_52567__$1;
(statearr_52571_52597[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52568 === (1))){
var inst_52536 = cljs.core.vec.call(null,chs);
var inst_52537 = inst_52536;
var state_52567__$1 = (function (){var statearr_52572 = state_52567;
(statearr_52572[(10)] = inst_52537);

return statearr_52572;
})();
var statearr_52573_52598 = state_52567__$1;
(statearr_52573_52598[(2)] = null);

(statearr_52573_52598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52568 === (4))){
var inst_52537 = (state_52567[(10)]);
var state_52567__$1 = state_52567;
return cljs.core.async.ioc_alts_BANG_.call(null,state_52567__$1,(7),inst_52537);
} else {
if((state_val_52568 === (6))){
var inst_52563 = (state_52567[(2)]);
var state_52567__$1 = state_52567;
var statearr_52574_52599 = state_52567__$1;
(statearr_52574_52599[(2)] = inst_52563);

(statearr_52574_52599[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52568 === (3))){
var inst_52565 = (state_52567[(2)]);
var state_52567__$1 = state_52567;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52567__$1,inst_52565);
} else {
if((state_val_52568 === (2))){
var inst_52537 = (state_52567[(10)]);
var inst_52539 = cljs.core.count.call(null,inst_52537);
var inst_52540 = (inst_52539 > (0));
var state_52567__$1 = state_52567;
if(cljs.core.truth_(inst_52540)){
var statearr_52576_52600 = state_52567__$1;
(statearr_52576_52600[(1)] = (4));

} else {
var statearr_52577_52601 = state_52567__$1;
(statearr_52577_52601[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52568 === (11))){
var inst_52537 = (state_52567[(10)]);
var inst_52556 = (state_52567[(2)]);
var tmp52575 = inst_52537;
var inst_52537__$1 = tmp52575;
var state_52567__$1 = (function (){var statearr_52578 = state_52567;
(statearr_52578[(10)] = inst_52537__$1);

(statearr_52578[(11)] = inst_52556);

return statearr_52578;
})();
var statearr_52579_52602 = state_52567__$1;
(statearr_52579_52602[(2)] = null);

(statearr_52579_52602[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52568 === (9))){
var inst_52547 = (state_52567[(7)]);
var state_52567__$1 = state_52567;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_52567__$1,(11),out,inst_52547);
} else {
if((state_val_52568 === (5))){
var inst_52561 = cljs.core.async.close_BANG_.call(null,out);
var state_52567__$1 = state_52567;
var statearr_52580_52603 = state_52567__$1;
(statearr_52580_52603[(2)] = inst_52561);

(statearr_52580_52603[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52568 === (10))){
var inst_52559 = (state_52567[(2)]);
var state_52567__$1 = state_52567;
var statearr_52581_52604 = state_52567__$1;
(statearr_52581_52604[(2)] = inst_52559);

(statearr_52581_52604[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52568 === (8))){
var inst_52537 = (state_52567[(10)]);
var inst_52548 = (state_52567[(9)]);
var inst_52547 = (state_52567[(7)]);
var inst_52546 = (state_52567[(8)]);
var inst_52551 = (function (){var cs = inst_52537;
var vec__52542 = inst_52546;
var v = inst_52547;
var c = inst_52548;
return ((function (cs,vec__52542,v,c,inst_52537,inst_52548,inst_52547,inst_52546,state_val_52568,c__33478__auto___52595,out){
return (function (p1__52532_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__52532_SHARP_);
});
;})(cs,vec__52542,v,c,inst_52537,inst_52548,inst_52547,inst_52546,state_val_52568,c__33478__auto___52595,out))
})();
var inst_52552 = cljs.core.filterv.call(null,inst_52551,inst_52537);
var inst_52537__$1 = inst_52552;
var state_52567__$1 = (function (){var statearr_52582 = state_52567;
(statearr_52582[(10)] = inst_52537__$1);

return statearr_52582;
})();
var statearr_52583_52605 = state_52567__$1;
(statearr_52583_52605[(2)] = null);

(statearr_52583_52605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___52595,out))
;
return ((function (switch__33364__auto__,c__33478__auto___52595,out){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_52587 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52587[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_52587[(1)] = (1));

return statearr_52587;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_52567){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_52567);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e52588){if((e52588 instanceof Object)){
var ex__33368__auto__ = e52588;
var statearr_52589_52606 = state_52567;
(statearr_52589_52606[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52567);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52588;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52607 = state_52567;
state_52567 = G__52607;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_52567){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_52567);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___52595,out))
})();
var state__33480__auto__ = (function (){var statearr_52590 = f__33479__auto__.call(null);
(statearr_52590[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___52595);

return statearr_52590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___52595,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args52608 = [];
var len__10640__auto___52657 = arguments.length;
var i__10641__auto___52658 = (0);
while(true){
if((i__10641__auto___52658 < len__10640__auto___52657)){
args52608.push((arguments[i__10641__auto___52658]));

var G__52659 = (i__10641__auto___52658 + (1));
i__10641__auto___52658 = G__52659;
continue;
} else {
}
break;
}

var G__52610 = args52608.length;
switch (G__52610) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52608.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33478__auto___52661 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___52661,out){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___52661,out){
return (function (state_52634){
var state_val_52635 = (state_52634[(1)]);
if((state_val_52635 === (7))){
var inst_52616 = (state_52634[(7)]);
var inst_52616__$1 = (state_52634[(2)]);
var inst_52617 = (inst_52616__$1 == null);
var inst_52618 = cljs.core.not.call(null,inst_52617);
var state_52634__$1 = (function (){var statearr_52636 = state_52634;
(statearr_52636[(7)] = inst_52616__$1);

return statearr_52636;
})();
if(inst_52618){
var statearr_52637_52662 = state_52634__$1;
(statearr_52637_52662[(1)] = (8));

} else {
var statearr_52638_52663 = state_52634__$1;
(statearr_52638_52663[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52635 === (1))){
var inst_52611 = (0);
var state_52634__$1 = (function (){var statearr_52639 = state_52634;
(statearr_52639[(8)] = inst_52611);

return statearr_52639;
})();
var statearr_52640_52664 = state_52634__$1;
(statearr_52640_52664[(2)] = null);

(statearr_52640_52664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52635 === (4))){
var state_52634__$1 = state_52634;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52634__$1,(7),ch);
} else {
if((state_val_52635 === (6))){
var inst_52629 = (state_52634[(2)]);
var state_52634__$1 = state_52634;
var statearr_52641_52665 = state_52634__$1;
(statearr_52641_52665[(2)] = inst_52629);

(statearr_52641_52665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52635 === (3))){
var inst_52631 = (state_52634[(2)]);
var inst_52632 = cljs.core.async.close_BANG_.call(null,out);
var state_52634__$1 = (function (){var statearr_52642 = state_52634;
(statearr_52642[(9)] = inst_52631);

return statearr_52642;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52634__$1,inst_52632);
} else {
if((state_val_52635 === (2))){
var inst_52611 = (state_52634[(8)]);
var inst_52613 = (inst_52611 < n);
var state_52634__$1 = state_52634;
if(cljs.core.truth_(inst_52613)){
var statearr_52643_52666 = state_52634__$1;
(statearr_52643_52666[(1)] = (4));

} else {
var statearr_52644_52667 = state_52634__$1;
(statearr_52644_52667[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52635 === (11))){
var inst_52611 = (state_52634[(8)]);
var inst_52621 = (state_52634[(2)]);
var inst_52622 = (inst_52611 + (1));
var inst_52611__$1 = inst_52622;
var state_52634__$1 = (function (){var statearr_52645 = state_52634;
(statearr_52645[(8)] = inst_52611__$1);

(statearr_52645[(10)] = inst_52621);

return statearr_52645;
})();
var statearr_52646_52668 = state_52634__$1;
(statearr_52646_52668[(2)] = null);

(statearr_52646_52668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52635 === (9))){
var state_52634__$1 = state_52634;
var statearr_52647_52669 = state_52634__$1;
(statearr_52647_52669[(2)] = null);

(statearr_52647_52669[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52635 === (5))){
var state_52634__$1 = state_52634;
var statearr_52648_52670 = state_52634__$1;
(statearr_52648_52670[(2)] = null);

(statearr_52648_52670[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52635 === (10))){
var inst_52626 = (state_52634[(2)]);
var state_52634__$1 = state_52634;
var statearr_52649_52671 = state_52634__$1;
(statearr_52649_52671[(2)] = inst_52626);

(statearr_52649_52671[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52635 === (8))){
var inst_52616 = (state_52634[(7)]);
var state_52634__$1 = state_52634;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_52634__$1,(11),out,inst_52616);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___52661,out))
;
return ((function (switch__33364__auto__,c__33478__auto___52661,out){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_52653 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_52653[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_52653[(1)] = (1));

return statearr_52653;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_52634){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_52634);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e52654){if((e52654 instanceof Object)){
var ex__33368__auto__ = e52654;
var statearr_52655_52672 = state_52634;
(statearr_52655_52672[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52634);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52654;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52673 = state_52634;
state_52634 = G__52673;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_52634){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_52634);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___52661,out))
})();
var state__33480__auto__ = (function (){var statearr_52656 = f__33479__auto__.call(null);
(statearr_52656[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___52661);

return statearr_52656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___52661,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async52681 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async52681 = (function (f,ch,meta52682){
this.f = f;
this.ch = ch;
this.meta52682 = meta52682;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async52681.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_52683,meta52682__$1){
var self__ = this;
var _52683__$1 = this;
return (new cljs.core.async.t_cljs$core$async52681(self__.f,self__.ch,meta52682__$1));
});

cljs.core.async.t_cljs$core$async52681.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_52683){
var self__ = this;
var _52683__$1 = this;
return self__.meta52682;
});

cljs.core.async.t_cljs$core$async52681.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async52681.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async52681.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async52681.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async52681.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async52684 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async52684 = (function (f,ch,meta52682,_,fn1,meta52685){
this.f = f;
this.ch = ch;
this.meta52682 = meta52682;
this._ = _;
this.fn1 = fn1;
this.meta52685 = meta52685;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async52684.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_52686,meta52685__$1){
var self__ = this;
var _52686__$1 = this;
return (new cljs.core.async.t_cljs$core$async52684(self__.f,self__.ch,self__.meta52682,self__._,self__.fn1,meta52685__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async52684.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_52686){
var self__ = this;
var _52686__$1 = this;
return self__.meta52685;
});})(___$1))
;

cljs.core.async.t_cljs$core$async52684.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async52684.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async52684.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async52684.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__52674_SHARP_){
return f1.call(null,(((p1__52674_SHARP_ == null))?null:self__.f.call(null,p1__52674_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async52684.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta52682","meta52682",-1775014879,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async52681","cljs.core.async/t_cljs$core$async52681",344553595,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta52685","meta52685",-896723048,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async52684.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async52684.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async52684";

cljs.core.async.t_cljs$core$async52684.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async52684");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async52684 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async52684(f__$1,ch__$1,meta52682__$1,___$2,fn1__$1,meta52685){
return (new cljs.core.async.t_cljs$core$async52684(f__$1,ch__$1,meta52682__$1,___$2,fn1__$1,meta52685));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async52684(self__.f,self__.ch,self__.meta52682,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__9407__auto__ = ret;
if(cljs.core.truth_(and__9407__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__9407__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async52681.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async52681.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async52681.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta52682","meta52682",-1775014879,null)], null);
});

cljs.core.async.t_cljs$core$async52681.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async52681.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async52681";

cljs.core.async.t_cljs$core$async52681.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async52681");
});

cljs.core.async.__GT_t_cljs$core$async52681 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async52681(f__$1,ch__$1,meta52682){
return (new cljs.core.async.t_cljs$core$async52681(f__$1,ch__$1,meta52682));
});

}

return (new cljs.core.async.t_cljs$core$async52681(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async52690 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async52690 = (function (f,ch,meta52691){
this.f = f;
this.ch = ch;
this.meta52691 = meta52691;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async52690.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_52692,meta52691__$1){
var self__ = this;
var _52692__$1 = this;
return (new cljs.core.async.t_cljs$core$async52690(self__.f,self__.ch,meta52691__$1));
});

cljs.core.async.t_cljs$core$async52690.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_52692){
var self__ = this;
var _52692__$1 = this;
return self__.meta52691;
});

cljs.core.async.t_cljs$core$async52690.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async52690.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async52690.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async52690.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async52690.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async52690.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async52690.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta52691","meta52691",-1541707030,null)], null);
});

cljs.core.async.t_cljs$core$async52690.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async52690.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async52690";

cljs.core.async.t_cljs$core$async52690.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async52690");
});

cljs.core.async.__GT_t_cljs$core$async52690 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async52690(f__$1,ch__$1,meta52691){
return (new cljs.core.async.t_cljs$core$async52690(f__$1,ch__$1,meta52691));
});

}

return (new cljs.core.async.t_cljs$core$async52690(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async52696 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async52696 = (function (p,ch,meta52697){
this.p = p;
this.ch = ch;
this.meta52697 = meta52697;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async52696.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_52698,meta52697__$1){
var self__ = this;
var _52698__$1 = this;
return (new cljs.core.async.t_cljs$core$async52696(self__.p,self__.ch,meta52697__$1));
});

cljs.core.async.t_cljs$core$async52696.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_52698){
var self__ = this;
var _52698__$1 = this;
return self__.meta52697;
});

cljs.core.async.t_cljs$core$async52696.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async52696.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async52696.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async52696.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async52696.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async52696.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async52696.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async52696.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta52697","meta52697",-104350327,null)], null);
});

cljs.core.async.t_cljs$core$async52696.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async52696.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async52696";

cljs.core.async.t_cljs$core$async52696.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async52696");
});

cljs.core.async.__GT_t_cljs$core$async52696 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async52696(p__$1,ch__$1,meta52697){
return (new cljs.core.async.t_cljs$core$async52696(p__$1,ch__$1,meta52697));
});

}

return (new cljs.core.async.t_cljs$core$async52696(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args52699 = [];
var len__10640__auto___52743 = arguments.length;
var i__10641__auto___52744 = (0);
while(true){
if((i__10641__auto___52744 < len__10640__auto___52743)){
args52699.push((arguments[i__10641__auto___52744]));

var G__52745 = (i__10641__auto___52744 + (1));
i__10641__auto___52744 = G__52745;
continue;
} else {
}
break;
}

var G__52701 = args52699.length;
switch (G__52701) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52699.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33478__auto___52747 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___52747,out){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___52747,out){
return (function (state_52722){
var state_val_52723 = (state_52722[(1)]);
if((state_val_52723 === (7))){
var inst_52718 = (state_52722[(2)]);
var state_52722__$1 = state_52722;
var statearr_52724_52748 = state_52722__$1;
(statearr_52724_52748[(2)] = inst_52718);

(statearr_52724_52748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52723 === (1))){
var state_52722__$1 = state_52722;
var statearr_52725_52749 = state_52722__$1;
(statearr_52725_52749[(2)] = null);

(statearr_52725_52749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52723 === (4))){
var inst_52704 = (state_52722[(7)]);
var inst_52704__$1 = (state_52722[(2)]);
var inst_52705 = (inst_52704__$1 == null);
var state_52722__$1 = (function (){var statearr_52726 = state_52722;
(statearr_52726[(7)] = inst_52704__$1);

return statearr_52726;
})();
if(cljs.core.truth_(inst_52705)){
var statearr_52727_52750 = state_52722__$1;
(statearr_52727_52750[(1)] = (5));

} else {
var statearr_52728_52751 = state_52722__$1;
(statearr_52728_52751[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52723 === (6))){
var inst_52704 = (state_52722[(7)]);
var inst_52709 = p.call(null,inst_52704);
var state_52722__$1 = state_52722;
if(cljs.core.truth_(inst_52709)){
var statearr_52729_52752 = state_52722__$1;
(statearr_52729_52752[(1)] = (8));

} else {
var statearr_52730_52753 = state_52722__$1;
(statearr_52730_52753[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52723 === (3))){
var inst_52720 = (state_52722[(2)]);
var state_52722__$1 = state_52722;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52722__$1,inst_52720);
} else {
if((state_val_52723 === (2))){
var state_52722__$1 = state_52722;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52722__$1,(4),ch);
} else {
if((state_val_52723 === (11))){
var inst_52712 = (state_52722[(2)]);
var state_52722__$1 = state_52722;
var statearr_52731_52754 = state_52722__$1;
(statearr_52731_52754[(2)] = inst_52712);

(statearr_52731_52754[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52723 === (9))){
var state_52722__$1 = state_52722;
var statearr_52732_52755 = state_52722__$1;
(statearr_52732_52755[(2)] = null);

(statearr_52732_52755[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52723 === (5))){
var inst_52707 = cljs.core.async.close_BANG_.call(null,out);
var state_52722__$1 = state_52722;
var statearr_52733_52756 = state_52722__$1;
(statearr_52733_52756[(2)] = inst_52707);

(statearr_52733_52756[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52723 === (10))){
var inst_52715 = (state_52722[(2)]);
var state_52722__$1 = (function (){var statearr_52734 = state_52722;
(statearr_52734[(8)] = inst_52715);

return statearr_52734;
})();
var statearr_52735_52757 = state_52722__$1;
(statearr_52735_52757[(2)] = null);

(statearr_52735_52757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52723 === (8))){
var inst_52704 = (state_52722[(7)]);
var state_52722__$1 = state_52722;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_52722__$1,(11),out,inst_52704);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___52747,out))
;
return ((function (switch__33364__auto__,c__33478__auto___52747,out){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_52739 = [null,null,null,null,null,null,null,null,null];
(statearr_52739[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_52739[(1)] = (1));

return statearr_52739;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_52722){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_52722);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e52740){if((e52740 instanceof Object)){
var ex__33368__auto__ = e52740;
var statearr_52741_52758 = state_52722;
(statearr_52741_52758[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52722);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52740;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52759 = state_52722;
state_52722 = G__52759;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_52722){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_52722);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___52747,out))
})();
var state__33480__auto__ = (function (){var statearr_52742 = f__33479__auto__.call(null);
(statearr_52742[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___52747);

return statearr_52742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___52747,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args52760 = [];
var len__10640__auto___52763 = arguments.length;
var i__10641__auto___52764 = (0);
while(true){
if((i__10641__auto___52764 < len__10640__auto___52763)){
args52760.push((arguments[i__10641__auto___52764]));

var G__52765 = (i__10641__auto___52764 + (1));
i__10641__auto___52764 = G__52765;
continue;
} else {
}
break;
}

var G__52762 = args52760.length;
switch (G__52762) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52760.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__33478__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto__){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto__){
return (function (state_52932){
var state_val_52933 = (state_52932[(1)]);
if((state_val_52933 === (7))){
var inst_52928 = (state_52932[(2)]);
var state_52932__$1 = state_52932;
var statearr_52934_52975 = state_52932__$1;
(statearr_52934_52975[(2)] = inst_52928);

(statearr_52934_52975[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52933 === (20))){
var inst_52898 = (state_52932[(7)]);
var inst_52909 = (state_52932[(2)]);
var inst_52910 = cljs.core.next.call(null,inst_52898);
var inst_52884 = inst_52910;
var inst_52885 = null;
var inst_52886 = (0);
var inst_52887 = (0);
var state_52932__$1 = (function (){var statearr_52935 = state_52932;
(statearr_52935[(8)] = inst_52885);

(statearr_52935[(9)] = inst_52884);

(statearr_52935[(10)] = inst_52909);

(statearr_52935[(11)] = inst_52886);

(statearr_52935[(12)] = inst_52887);

return statearr_52935;
})();
var statearr_52936_52976 = state_52932__$1;
(statearr_52936_52976[(2)] = null);

(statearr_52936_52976[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52933 === (1))){
var state_52932__$1 = state_52932;
var statearr_52937_52977 = state_52932__$1;
(statearr_52937_52977[(2)] = null);

(statearr_52937_52977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52933 === (4))){
var inst_52873 = (state_52932[(13)]);
var inst_52873__$1 = (state_52932[(2)]);
var inst_52874 = (inst_52873__$1 == null);
var state_52932__$1 = (function (){var statearr_52938 = state_52932;
(statearr_52938[(13)] = inst_52873__$1);

return statearr_52938;
})();
if(cljs.core.truth_(inst_52874)){
var statearr_52939_52978 = state_52932__$1;
(statearr_52939_52978[(1)] = (5));

} else {
var statearr_52940_52979 = state_52932__$1;
(statearr_52940_52979[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52933 === (15))){
var state_52932__$1 = state_52932;
var statearr_52944_52980 = state_52932__$1;
(statearr_52944_52980[(2)] = null);

(statearr_52944_52980[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52933 === (21))){
var state_52932__$1 = state_52932;
var statearr_52945_52981 = state_52932__$1;
(statearr_52945_52981[(2)] = null);

(statearr_52945_52981[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52933 === (13))){
var inst_52885 = (state_52932[(8)]);
var inst_52884 = (state_52932[(9)]);
var inst_52886 = (state_52932[(11)]);
var inst_52887 = (state_52932[(12)]);
var inst_52894 = (state_52932[(2)]);
var inst_52895 = (inst_52887 + (1));
var tmp52941 = inst_52885;
var tmp52942 = inst_52884;
var tmp52943 = inst_52886;
var inst_52884__$1 = tmp52942;
var inst_52885__$1 = tmp52941;
var inst_52886__$1 = tmp52943;
var inst_52887__$1 = inst_52895;
var state_52932__$1 = (function (){var statearr_52946 = state_52932;
(statearr_52946[(8)] = inst_52885__$1);

(statearr_52946[(9)] = inst_52884__$1);

(statearr_52946[(14)] = inst_52894);

(statearr_52946[(11)] = inst_52886__$1);

(statearr_52946[(12)] = inst_52887__$1);

return statearr_52946;
})();
var statearr_52947_52982 = state_52932__$1;
(statearr_52947_52982[(2)] = null);

(statearr_52947_52982[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52933 === (22))){
var state_52932__$1 = state_52932;
var statearr_52948_52983 = state_52932__$1;
(statearr_52948_52983[(2)] = null);

(statearr_52948_52983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52933 === (6))){
var inst_52873 = (state_52932[(13)]);
var inst_52882 = f.call(null,inst_52873);
var inst_52883 = cljs.core.seq.call(null,inst_52882);
var inst_52884 = inst_52883;
var inst_52885 = null;
var inst_52886 = (0);
var inst_52887 = (0);
var state_52932__$1 = (function (){var statearr_52949 = state_52932;
(statearr_52949[(8)] = inst_52885);

(statearr_52949[(9)] = inst_52884);

(statearr_52949[(11)] = inst_52886);

(statearr_52949[(12)] = inst_52887);

return statearr_52949;
})();
var statearr_52950_52984 = state_52932__$1;
(statearr_52950_52984[(2)] = null);

(statearr_52950_52984[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52933 === (17))){
var inst_52898 = (state_52932[(7)]);
var inst_52902 = cljs.core.chunk_first.call(null,inst_52898);
var inst_52903 = cljs.core.chunk_rest.call(null,inst_52898);
var inst_52904 = cljs.core.count.call(null,inst_52902);
var inst_52884 = inst_52903;
var inst_52885 = inst_52902;
var inst_52886 = inst_52904;
var inst_52887 = (0);
var state_52932__$1 = (function (){var statearr_52951 = state_52932;
(statearr_52951[(8)] = inst_52885);

(statearr_52951[(9)] = inst_52884);

(statearr_52951[(11)] = inst_52886);

(statearr_52951[(12)] = inst_52887);

return statearr_52951;
})();
var statearr_52952_52985 = state_52932__$1;
(statearr_52952_52985[(2)] = null);

(statearr_52952_52985[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52933 === (3))){
var inst_52930 = (state_52932[(2)]);
var state_52932__$1 = state_52932;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52932__$1,inst_52930);
} else {
if((state_val_52933 === (12))){
var inst_52918 = (state_52932[(2)]);
var state_52932__$1 = state_52932;
var statearr_52953_52986 = state_52932__$1;
(statearr_52953_52986[(2)] = inst_52918);

(statearr_52953_52986[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52933 === (2))){
var state_52932__$1 = state_52932;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52932__$1,(4),in$);
} else {
if((state_val_52933 === (23))){
var inst_52926 = (state_52932[(2)]);
var state_52932__$1 = state_52932;
var statearr_52954_52987 = state_52932__$1;
(statearr_52954_52987[(2)] = inst_52926);

(statearr_52954_52987[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52933 === (19))){
var inst_52913 = (state_52932[(2)]);
var state_52932__$1 = state_52932;
var statearr_52955_52988 = state_52932__$1;
(statearr_52955_52988[(2)] = inst_52913);

(statearr_52955_52988[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52933 === (11))){
var inst_52884 = (state_52932[(9)]);
var inst_52898 = (state_52932[(7)]);
var inst_52898__$1 = cljs.core.seq.call(null,inst_52884);
var state_52932__$1 = (function (){var statearr_52956 = state_52932;
(statearr_52956[(7)] = inst_52898__$1);

return statearr_52956;
})();
if(inst_52898__$1){
var statearr_52957_52989 = state_52932__$1;
(statearr_52957_52989[(1)] = (14));

} else {
var statearr_52958_52990 = state_52932__$1;
(statearr_52958_52990[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52933 === (9))){
var inst_52920 = (state_52932[(2)]);
var inst_52921 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_52932__$1 = (function (){var statearr_52959 = state_52932;
(statearr_52959[(15)] = inst_52920);

return statearr_52959;
})();
if(cljs.core.truth_(inst_52921)){
var statearr_52960_52991 = state_52932__$1;
(statearr_52960_52991[(1)] = (21));

} else {
var statearr_52961_52992 = state_52932__$1;
(statearr_52961_52992[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52933 === (5))){
var inst_52876 = cljs.core.async.close_BANG_.call(null,out);
var state_52932__$1 = state_52932;
var statearr_52962_52993 = state_52932__$1;
(statearr_52962_52993[(2)] = inst_52876);

(statearr_52962_52993[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52933 === (14))){
var inst_52898 = (state_52932[(7)]);
var inst_52900 = cljs.core.chunked_seq_QMARK_.call(null,inst_52898);
var state_52932__$1 = state_52932;
if(inst_52900){
var statearr_52963_52994 = state_52932__$1;
(statearr_52963_52994[(1)] = (17));

} else {
var statearr_52964_52995 = state_52932__$1;
(statearr_52964_52995[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52933 === (16))){
var inst_52916 = (state_52932[(2)]);
var state_52932__$1 = state_52932;
var statearr_52965_52996 = state_52932__$1;
(statearr_52965_52996[(2)] = inst_52916);

(statearr_52965_52996[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52933 === (10))){
var inst_52885 = (state_52932[(8)]);
var inst_52887 = (state_52932[(12)]);
var inst_52892 = cljs.core._nth.call(null,inst_52885,inst_52887);
var state_52932__$1 = state_52932;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_52932__$1,(13),out,inst_52892);
} else {
if((state_val_52933 === (18))){
var inst_52898 = (state_52932[(7)]);
var inst_52907 = cljs.core.first.call(null,inst_52898);
var state_52932__$1 = state_52932;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_52932__$1,(20),out,inst_52907);
} else {
if((state_val_52933 === (8))){
var inst_52886 = (state_52932[(11)]);
var inst_52887 = (state_52932[(12)]);
var inst_52889 = (inst_52887 < inst_52886);
var inst_52890 = inst_52889;
var state_52932__$1 = state_52932;
if(cljs.core.truth_(inst_52890)){
var statearr_52966_52997 = state_52932__$1;
(statearr_52966_52997[(1)] = (10));

} else {
var statearr_52967_52998 = state_52932__$1;
(statearr_52967_52998[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto__))
;
return ((function (switch__33364__auto__,c__33478__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__33365__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__33365__auto____0 = (function (){
var statearr_52971 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52971[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__33365__auto__);

(statearr_52971[(1)] = (1));

return statearr_52971;
});
var cljs$core$async$mapcat_STAR__$_state_machine__33365__auto____1 = (function (state_52932){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_52932);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e52972){if((e52972 instanceof Object)){
var ex__33368__auto__ = e52972;
var statearr_52973_52999 = state_52932;
(statearr_52973_52999[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52932);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52972;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53000 = state_52932;
state_52932 = G__53000;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__33365__auto__ = function(state_52932){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__33365__auto____1.call(this,state_52932);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__33365__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__33365__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto__))
})();
var state__33480__auto__ = (function (){var statearr_52974 = f__33479__auto__.call(null);
(statearr_52974[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto__);

return statearr_52974;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto__))
);

return c__33478__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args53001 = [];
var len__10640__auto___53004 = arguments.length;
var i__10641__auto___53005 = (0);
while(true){
if((i__10641__auto___53005 < len__10640__auto___53004)){
args53001.push((arguments[i__10641__auto___53005]));

var G__53006 = (i__10641__auto___53005 + (1));
i__10641__auto___53005 = G__53006;
continue;
} else {
}
break;
}

var G__53003 = args53001.length;
switch (G__53003) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args53001.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args53008 = [];
var len__10640__auto___53011 = arguments.length;
var i__10641__auto___53012 = (0);
while(true){
if((i__10641__auto___53012 < len__10640__auto___53011)){
args53008.push((arguments[i__10641__auto___53012]));

var G__53013 = (i__10641__auto___53012 + (1));
i__10641__auto___53012 = G__53013;
continue;
} else {
}
break;
}

var G__53010 = args53008.length;
switch (G__53010) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args53008.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args53015 = [];
var len__10640__auto___53066 = arguments.length;
var i__10641__auto___53067 = (0);
while(true){
if((i__10641__auto___53067 < len__10640__auto___53066)){
args53015.push((arguments[i__10641__auto___53067]));

var G__53068 = (i__10641__auto___53067 + (1));
i__10641__auto___53067 = G__53068;
continue;
} else {
}
break;
}

var G__53017 = args53015.length;
switch (G__53017) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args53015.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33478__auto___53070 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___53070,out){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___53070,out){
return (function (state_53041){
var state_val_53042 = (state_53041[(1)]);
if((state_val_53042 === (7))){
var inst_53036 = (state_53041[(2)]);
var state_53041__$1 = state_53041;
var statearr_53043_53071 = state_53041__$1;
(statearr_53043_53071[(2)] = inst_53036);

(statearr_53043_53071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53042 === (1))){
var inst_53018 = null;
var state_53041__$1 = (function (){var statearr_53044 = state_53041;
(statearr_53044[(7)] = inst_53018);

return statearr_53044;
})();
var statearr_53045_53072 = state_53041__$1;
(statearr_53045_53072[(2)] = null);

(statearr_53045_53072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53042 === (4))){
var inst_53021 = (state_53041[(8)]);
var inst_53021__$1 = (state_53041[(2)]);
var inst_53022 = (inst_53021__$1 == null);
var inst_53023 = cljs.core.not.call(null,inst_53022);
var state_53041__$1 = (function (){var statearr_53046 = state_53041;
(statearr_53046[(8)] = inst_53021__$1);

return statearr_53046;
})();
if(inst_53023){
var statearr_53047_53073 = state_53041__$1;
(statearr_53047_53073[(1)] = (5));

} else {
var statearr_53048_53074 = state_53041__$1;
(statearr_53048_53074[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53042 === (6))){
var state_53041__$1 = state_53041;
var statearr_53049_53075 = state_53041__$1;
(statearr_53049_53075[(2)] = null);

(statearr_53049_53075[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53042 === (3))){
var inst_53038 = (state_53041[(2)]);
var inst_53039 = cljs.core.async.close_BANG_.call(null,out);
var state_53041__$1 = (function (){var statearr_53050 = state_53041;
(statearr_53050[(9)] = inst_53038);

return statearr_53050;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53041__$1,inst_53039);
} else {
if((state_val_53042 === (2))){
var state_53041__$1 = state_53041;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53041__$1,(4),ch);
} else {
if((state_val_53042 === (11))){
var inst_53021 = (state_53041[(8)]);
var inst_53030 = (state_53041[(2)]);
var inst_53018 = inst_53021;
var state_53041__$1 = (function (){var statearr_53051 = state_53041;
(statearr_53051[(10)] = inst_53030);

(statearr_53051[(7)] = inst_53018);

return statearr_53051;
})();
var statearr_53052_53076 = state_53041__$1;
(statearr_53052_53076[(2)] = null);

(statearr_53052_53076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53042 === (9))){
var inst_53021 = (state_53041[(8)]);
var state_53041__$1 = state_53041;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53041__$1,(11),out,inst_53021);
} else {
if((state_val_53042 === (5))){
var inst_53018 = (state_53041[(7)]);
var inst_53021 = (state_53041[(8)]);
var inst_53025 = cljs.core._EQ_.call(null,inst_53021,inst_53018);
var state_53041__$1 = state_53041;
if(inst_53025){
var statearr_53054_53077 = state_53041__$1;
(statearr_53054_53077[(1)] = (8));

} else {
var statearr_53055_53078 = state_53041__$1;
(statearr_53055_53078[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53042 === (10))){
var inst_53033 = (state_53041[(2)]);
var state_53041__$1 = state_53041;
var statearr_53056_53079 = state_53041__$1;
(statearr_53056_53079[(2)] = inst_53033);

(statearr_53056_53079[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53042 === (8))){
var inst_53018 = (state_53041[(7)]);
var tmp53053 = inst_53018;
var inst_53018__$1 = tmp53053;
var state_53041__$1 = (function (){var statearr_53057 = state_53041;
(statearr_53057[(7)] = inst_53018__$1);

return statearr_53057;
})();
var statearr_53058_53080 = state_53041__$1;
(statearr_53058_53080[(2)] = null);

(statearr_53058_53080[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___53070,out))
;
return ((function (switch__33364__auto__,c__33478__auto___53070,out){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_53062 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_53062[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_53062[(1)] = (1));

return statearr_53062;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_53041){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_53041);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e53063){if((e53063 instanceof Object)){
var ex__33368__auto__ = e53063;
var statearr_53064_53081 = state_53041;
(statearr_53064_53081[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53041);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53063;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53082 = state_53041;
state_53041 = G__53082;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_53041){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_53041);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___53070,out))
})();
var state__33480__auto__ = (function (){var statearr_53065 = f__33479__auto__.call(null);
(statearr_53065[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___53070);

return statearr_53065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___53070,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args53083 = [];
var len__10640__auto___53153 = arguments.length;
var i__10641__auto___53154 = (0);
while(true){
if((i__10641__auto___53154 < len__10640__auto___53153)){
args53083.push((arguments[i__10641__auto___53154]));

var G__53155 = (i__10641__auto___53154 + (1));
i__10641__auto___53154 = G__53155;
continue;
} else {
}
break;
}

var G__53085 = args53083.length;
switch (G__53085) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args53083.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33478__auto___53157 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___53157,out){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___53157,out){
return (function (state_53123){
var state_val_53124 = (state_53123[(1)]);
if((state_val_53124 === (7))){
var inst_53119 = (state_53123[(2)]);
var state_53123__$1 = state_53123;
var statearr_53125_53158 = state_53123__$1;
(statearr_53125_53158[(2)] = inst_53119);

(statearr_53125_53158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53124 === (1))){
var inst_53086 = (new Array(n));
var inst_53087 = inst_53086;
var inst_53088 = (0);
var state_53123__$1 = (function (){var statearr_53126 = state_53123;
(statearr_53126[(7)] = inst_53087);

(statearr_53126[(8)] = inst_53088);

return statearr_53126;
})();
var statearr_53127_53159 = state_53123__$1;
(statearr_53127_53159[(2)] = null);

(statearr_53127_53159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53124 === (4))){
var inst_53091 = (state_53123[(9)]);
var inst_53091__$1 = (state_53123[(2)]);
var inst_53092 = (inst_53091__$1 == null);
var inst_53093 = cljs.core.not.call(null,inst_53092);
var state_53123__$1 = (function (){var statearr_53128 = state_53123;
(statearr_53128[(9)] = inst_53091__$1);

return statearr_53128;
})();
if(inst_53093){
var statearr_53129_53160 = state_53123__$1;
(statearr_53129_53160[(1)] = (5));

} else {
var statearr_53130_53161 = state_53123__$1;
(statearr_53130_53161[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53124 === (15))){
var inst_53113 = (state_53123[(2)]);
var state_53123__$1 = state_53123;
var statearr_53131_53162 = state_53123__$1;
(statearr_53131_53162[(2)] = inst_53113);

(statearr_53131_53162[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53124 === (13))){
var state_53123__$1 = state_53123;
var statearr_53132_53163 = state_53123__$1;
(statearr_53132_53163[(2)] = null);

(statearr_53132_53163[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53124 === (6))){
var inst_53088 = (state_53123[(8)]);
var inst_53109 = (inst_53088 > (0));
var state_53123__$1 = state_53123;
if(cljs.core.truth_(inst_53109)){
var statearr_53133_53164 = state_53123__$1;
(statearr_53133_53164[(1)] = (12));

} else {
var statearr_53134_53165 = state_53123__$1;
(statearr_53134_53165[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53124 === (3))){
var inst_53121 = (state_53123[(2)]);
var state_53123__$1 = state_53123;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53123__$1,inst_53121);
} else {
if((state_val_53124 === (12))){
var inst_53087 = (state_53123[(7)]);
var inst_53111 = cljs.core.vec.call(null,inst_53087);
var state_53123__$1 = state_53123;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53123__$1,(15),out,inst_53111);
} else {
if((state_val_53124 === (2))){
var state_53123__$1 = state_53123;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53123__$1,(4),ch);
} else {
if((state_val_53124 === (11))){
var inst_53103 = (state_53123[(2)]);
var inst_53104 = (new Array(n));
var inst_53087 = inst_53104;
var inst_53088 = (0);
var state_53123__$1 = (function (){var statearr_53135 = state_53123;
(statearr_53135[(10)] = inst_53103);

(statearr_53135[(7)] = inst_53087);

(statearr_53135[(8)] = inst_53088);

return statearr_53135;
})();
var statearr_53136_53166 = state_53123__$1;
(statearr_53136_53166[(2)] = null);

(statearr_53136_53166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53124 === (9))){
var inst_53087 = (state_53123[(7)]);
var inst_53101 = cljs.core.vec.call(null,inst_53087);
var state_53123__$1 = state_53123;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53123__$1,(11),out,inst_53101);
} else {
if((state_val_53124 === (5))){
var inst_53087 = (state_53123[(7)]);
var inst_53096 = (state_53123[(11)]);
var inst_53088 = (state_53123[(8)]);
var inst_53091 = (state_53123[(9)]);
var inst_53095 = (inst_53087[inst_53088] = inst_53091);
var inst_53096__$1 = (inst_53088 + (1));
var inst_53097 = (inst_53096__$1 < n);
var state_53123__$1 = (function (){var statearr_53137 = state_53123;
(statearr_53137[(11)] = inst_53096__$1);

(statearr_53137[(12)] = inst_53095);

return statearr_53137;
})();
if(cljs.core.truth_(inst_53097)){
var statearr_53138_53167 = state_53123__$1;
(statearr_53138_53167[(1)] = (8));

} else {
var statearr_53139_53168 = state_53123__$1;
(statearr_53139_53168[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53124 === (14))){
var inst_53116 = (state_53123[(2)]);
var inst_53117 = cljs.core.async.close_BANG_.call(null,out);
var state_53123__$1 = (function (){var statearr_53141 = state_53123;
(statearr_53141[(13)] = inst_53116);

return statearr_53141;
})();
var statearr_53142_53169 = state_53123__$1;
(statearr_53142_53169[(2)] = inst_53117);

(statearr_53142_53169[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53124 === (10))){
var inst_53107 = (state_53123[(2)]);
var state_53123__$1 = state_53123;
var statearr_53143_53170 = state_53123__$1;
(statearr_53143_53170[(2)] = inst_53107);

(statearr_53143_53170[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53124 === (8))){
var inst_53087 = (state_53123[(7)]);
var inst_53096 = (state_53123[(11)]);
var tmp53140 = inst_53087;
var inst_53087__$1 = tmp53140;
var inst_53088 = inst_53096;
var state_53123__$1 = (function (){var statearr_53144 = state_53123;
(statearr_53144[(7)] = inst_53087__$1);

(statearr_53144[(8)] = inst_53088);

return statearr_53144;
})();
var statearr_53145_53171 = state_53123__$1;
(statearr_53145_53171[(2)] = null);

(statearr_53145_53171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___53157,out))
;
return ((function (switch__33364__auto__,c__33478__auto___53157,out){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_53149 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53149[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_53149[(1)] = (1));

return statearr_53149;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_53123){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_53123);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e53150){if((e53150 instanceof Object)){
var ex__33368__auto__ = e53150;
var statearr_53151_53172 = state_53123;
(statearr_53151_53172[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53123);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53150;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53173 = state_53123;
state_53123 = G__53173;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_53123){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_53123);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___53157,out))
})();
var state__33480__auto__ = (function (){var statearr_53152 = f__33479__auto__.call(null);
(statearr_53152[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___53157);

return statearr_53152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___53157,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args53174 = [];
var len__10640__auto___53248 = arguments.length;
var i__10641__auto___53249 = (0);
while(true){
if((i__10641__auto___53249 < len__10640__auto___53248)){
args53174.push((arguments[i__10641__auto___53249]));

var G__53250 = (i__10641__auto___53249 + (1));
i__10641__auto___53249 = G__53250;
continue;
} else {
}
break;
}

var G__53176 = args53174.length;
switch (G__53176) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args53174.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33478__auto___53252 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___53252,out){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___53252,out){
return (function (state_53218){
var state_val_53219 = (state_53218[(1)]);
if((state_val_53219 === (7))){
var inst_53214 = (state_53218[(2)]);
var state_53218__$1 = state_53218;
var statearr_53220_53253 = state_53218__$1;
(statearr_53220_53253[(2)] = inst_53214);

(statearr_53220_53253[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53219 === (1))){
var inst_53177 = [];
var inst_53178 = inst_53177;
var inst_53179 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_53218__$1 = (function (){var statearr_53221 = state_53218;
(statearr_53221[(7)] = inst_53178);

(statearr_53221[(8)] = inst_53179);

return statearr_53221;
})();
var statearr_53222_53254 = state_53218__$1;
(statearr_53222_53254[(2)] = null);

(statearr_53222_53254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53219 === (4))){
var inst_53182 = (state_53218[(9)]);
var inst_53182__$1 = (state_53218[(2)]);
var inst_53183 = (inst_53182__$1 == null);
var inst_53184 = cljs.core.not.call(null,inst_53183);
var state_53218__$1 = (function (){var statearr_53223 = state_53218;
(statearr_53223[(9)] = inst_53182__$1);

return statearr_53223;
})();
if(inst_53184){
var statearr_53224_53255 = state_53218__$1;
(statearr_53224_53255[(1)] = (5));

} else {
var statearr_53225_53256 = state_53218__$1;
(statearr_53225_53256[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53219 === (15))){
var inst_53208 = (state_53218[(2)]);
var state_53218__$1 = state_53218;
var statearr_53226_53257 = state_53218__$1;
(statearr_53226_53257[(2)] = inst_53208);

(statearr_53226_53257[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53219 === (13))){
var state_53218__$1 = state_53218;
var statearr_53227_53258 = state_53218__$1;
(statearr_53227_53258[(2)] = null);

(statearr_53227_53258[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53219 === (6))){
var inst_53178 = (state_53218[(7)]);
var inst_53203 = inst_53178.length;
var inst_53204 = (inst_53203 > (0));
var state_53218__$1 = state_53218;
if(cljs.core.truth_(inst_53204)){
var statearr_53228_53259 = state_53218__$1;
(statearr_53228_53259[(1)] = (12));

} else {
var statearr_53229_53260 = state_53218__$1;
(statearr_53229_53260[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53219 === (3))){
var inst_53216 = (state_53218[(2)]);
var state_53218__$1 = state_53218;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53218__$1,inst_53216);
} else {
if((state_val_53219 === (12))){
var inst_53178 = (state_53218[(7)]);
var inst_53206 = cljs.core.vec.call(null,inst_53178);
var state_53218__$1 = state_53218;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53218__$1,(15),out,inst_53206);
} else {
if((state_val_53219 === (2))){
var state_53218__$1 = state_53218;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53218__$1,(4),ch);
} else {
if((state_val_53219 === (11))){
var inst_53186 = (state_53218[(10)]);
var inst_53182 = (state_53218[(9)]);
var inst_53196 = (state_53218[(2)]);
var inst_53197 = [];
var inst_53198 = inst_53197.push(inst_53182);
var inst_53178 = inst_53197;
var inst_53179 = inst_53186;
var state_53218__$1 = (function (){var statearr_53230 = state_53218;
(statearr_53230[(11)] = inst_53198);

(statearr_53230[(12)] = inst_53196);

(statearr_53230[(7)] = inst_53178);

(statearr_53230[(8)] = inst_53179);

return statearr_53230;
})();
var statearr_53231_53261 = state_53218__$1;
(statearr_53231_53261[(2)] = null);

(statearr_53231_53261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53219 === (9))){
var inst_53178 = (state_53218[(7)]);
var inst_53194 = cljs.core.vec.call(null,inst_53178);
var state_53218__$1 = state_53218;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53218__$1,(11),out,inst_53194);
} else {
if((state_val_53219 === (5))){
var inst_53186 = (state_53218[(10)]);
var inst_53182 = (state_53218[(9)]);
var inst_53179 = (state_53218[(8)]);
var inst_53186__$1 = f.call(null,inst_53182);
var inst_53187 = cljs.core._EQ_.call(null,inst_53186__$1,inst_53179);
var inst_53188 = cljs.core.keyword_identical_QMARK_.call(null,inst_53179,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_53189 = (inst_53187) || (inst_53188);
var state_53218__$1 = (function (){var statearr_53232 = state_53218;
(statearr_53232[(10)] = inst_53186__$1);

return statearr_53232;
})();
if(cljs.core.truth_(inst_53189)){
var statearr_53233_53262 = state_53218__$1;
(statearr_53233_53262[(1)] = (8));

} else {
var statearr_53234_53263 = state_53218__$1;
(statearr_53234_53263[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53219 === (14))){
var inst_53211 = (state_53218[(2)]);
var inst_53212 = cljs.core.async.close_BANG_.call(null,out);
var state_53218__$1 = (function (){var statearr_53236 = state_53218;
(statearr_53236[(13)] = inst_53211);

return statearr_53236;
})();
var statearr_53237_53264 = state_53218__$1;
(statearr_53237_53264[(2)] = inst_53212);

(statearr_53237_53264[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53219 === (10))){
var inst_53201 = (state_53218[(2)]);
var state_53218__$1 = state_53218;
var statearr_53238_53265 = state_53218__$1;
(statearr_53238_53265[(2)] = inst_53201);

(statearr_53238_53265[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53219 === (8))){
var inst_53186 = (state_53218[(10)]);
var inst_53182 = (state_53218[(9)]);
var inst_53178 = (state_53218[(7)]);
var inst_53191 = inst_53178.push(inst_53182);
var tmp53235 = inst_53178;
var inst_53178__$1 = tmp53235;
var inst_53179 = inst_53186;
var state_53218__$1 = (function (){var statearr_53239 = state_53218;
(statearr_53239[(7)] = inst_53178__$1);

(statearr_53239[(14)] = inst_53191);

(statearr_53239[(8)] = inst_53179);

return statearr_53239;
})();
var statearr_53240_53266 = state_53218__$1;
(statearr_53240_53266[(2)] = null);

(statearr_53240_53266[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___53252,out))
;
return ((function (switch__33364__auto__,c__33478__auto___53252,out){
return (function() {
var cljs$core$async$state_machine__33365__auto__ = null;
var cljs$core$async$state_machine__33365__auto____0 = (function (){
var statearr_53244 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53244[(0)] = cljs$core$async$state_machine__33365__auto__);

(statearr_53244[(1)] = (1));

return statearr_53244;
});
var cljs$core$async$state_machine__33365__auto____1 = (function (state_53218){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_53218);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e53245){if((e53245 instanceof Object)){
var ex__33368__auto__ = e53245;
var statearr_53246_53267 = state_53218;
(statearr_53246_53267[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53218);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53245;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53268 = state_53218;
state_53218 = G__53268;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
cljs$core$async$state_machine__33365__auto__ = function(state_53218){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33365__auto____1.call(this,state_53218);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33365__auto____0;
cljs$core$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33365__auto____1;
return cljs$core$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___53252,out))
})();
var state__33480__auto__ = (function (){var statearr_53247 = f__33479__auto__.call(null);
(statearr_53247[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___53252);

return statearr_53247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___53252,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map