// Compiled by ClojureScript 1.9.521 {}
goog.provide('hasch.core');
goog.require('cljs.core');
goog.require('hasch.benc');
goog.require('hasch.platform');
hasch.core.uuid4 = hasch.platform.uuid4;
hasch.core.uuid5 = hasch.platform.uuid5;
hasch.core.hash__GT_str = hasch.platform.hash__GT_str;
/**
 * Hash an edn value with SHA-512 by default or a compatible hash function of choice.
 */
hasch.core.edn_hash = (function hasch$core$edn_hash(var_args){
var args56370 = [];
var len__10640__auto___56373 = arguments.length;
var i__10641__auto___56374 = (0);
while(true){
if((i__10641__auto___56374 < len__10640__auto___56373)){
args56370.push((arguments[i__10641__auto___56374]));

var G__56375 = (i__10641__auto___56374 + (1));
i__10641__auto___56374 = G__56375;
continue;
} else {
}
break;
}

var G__56372 = args56370.length;
switch (G__56372) {
case 1:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args56370.length)].join('')));

}
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1 = (function (val){
return hasch.core.edn_hash.call(null,val,cljs.core.PersistentArrayMap.EMPTY);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2 = (function (val,write_handlers){
return hasch.core.edn_hash.call(null,val,hasch.platform.sha512_message_digest,write_handlers);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3 = (function (val,md_create_fn,write_handlers){
return cljs.core.map.call(null,(function (p1__56369_SHARP_){
if((p1__56369_SHARP_ < (0))){
return (p1__56369_SHARP_ + (256));
} else {
return p1__56369_SHARP_;
}
}),hasch.benc.digest.call(null,hasch.benc._coerce.call(null,val,md_create_fn,(function (){var or__9419__auto__ = write_handlers;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})()),md_create_fn));
});

hasch.core.edn_hash.cljs$lang$maxFixedArity = 3;

/**
 * Creates random UUID-4 without argument or UUID-5 for the argument value.
 * 
 *   Optionally an incognito-style write-handlers map can be supplied,
 *   which describes record serialization in terms of Clojure data
 *   structures.
 */
hasch.core.uuid = (function hasch$core$uuid(var_args){
var args56377 = [];
var len__10640__auto___56385 = arguments.length;
var i__10641__auto___56386 = (0);
while(true){
if((i__10641__auto___56386 < len__10640__auto___56385)){
args56377.push((arguments[i__10641__auto___56386]));

var G__56387 = (i__10641__auto___56386 + (1));
i__10641__auto___56386 = G__56387;
continue;
} else {
}
break;
}

var G__56381 = args56377.length;
switch (G__56381) {
case 0:
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__10663__auto__ = (new cljs.core.IndexedSeq(args56377.slice((1)),(0),null));
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10663__auto__);

}
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$0 = (function (){
return hasch.core.uuid4.call(null);
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic = (function (val,p__56382){
var map__56383 = p__56382;
var map__56383__$1 = ((((!((map__56383 == null)))?((((map__56383.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56383.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56383):map__56383);
var write_handlers = cljs.core.get.call(null,map__56383__$1,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911));
return hasch.core.uuid5.call(null,hasch.core.edn_hash.call(null,val,write_handlers));
});

hasch.core.uuid.cljs$lang$applyTo = (function (seq56378){
var G__56379 = cljs.core.first.call(null,seq56378);
var seq56378__$1 = cljs.core.next.call(null,seq56378);
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic(G__56379,seq56378__$1);
});

hasch.core.uuid.cljs$lang$maxFixedArity = (1);


//# sourceMappingURL=core.js.map