// Compiled by ClojureScript 1.9.521 {}
goog.provide('superv.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
superv.async.cljs_env_QMARK_ = (function superv$async$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});

/**
 * @interface
 */
superv.async.PSupervisor = function(){};

superv.async._error = (function superv$async$_error(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_error$arity$1 == null)))){
return this$.superv$async$PSupervisor$_error$arity$1(this$);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._error[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$);
} else {
var m__10138__auto____$1 = (superv.async._error["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-error",this$);
}
}
}
});

superv.async._abort = (function superv$async$_abort(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_abort$arity$1 == null)))){
return this$.superv$async$PSupervisor$_abort$arity$1(this$);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._abort[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$);
} else {
var m__10138__auto____$1 = (superv.async._abort["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-abort",this$);
}
}
}
});

superv.async._register_go = (function superv$async$_register_go(this$,body){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_register_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_register_go$arity$2(this$,body);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._register_go[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,body);
} else {
var m__10138__auto____$1 = (superv.async._register_go["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,body);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-register-go",this$);
}
}
}
});

superv.async._unregister_go = (function superv$async$_unregister_go(this$,id){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_unregister_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_unregister_go$arity$2(this$,id);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._unregister_go[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,id);
} else {
var m__10138__auto____$1 = (superv.async._unregister_go["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-unregister-go",this$);
}
}
}
});

superv.async._track_exception = (function superv$async$_track_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_track_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_track_exception$arity$2(this$,e);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._track_exception[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,e);
} else {
var m__10138__auto____$1 = (superv.async._track_exception["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-track-exception",this$);
}
}
}
});

superv.async._free_exception = (function superv$async$_free_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_free_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_free_exception$arity$2(this$,e);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (superv.async._free_exception[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,e);
} else {
var m__10138__auto____$1 = (superv.async._free_exception["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-free-exception",this$);
}
}
}
});

superv.async.now = (function superv$async$now(){
return (new Date());
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {superv.async.PSupervisor}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
superv.async.TrackingSupervisor = (function (error,abort,registered,pending_exceptions,__meta,__extmap,__hash){
this.error = error;
this.abort = abort;
this.registered = registered;
this.pending_exceptions = pending_exceptions;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__10094__auto__,k__10095__auto__){
var self__ = this;
var this__10094__auto____$1 = this;
return this__10094__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__10095__auto__,null);
});

superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__10096__auto__,k53272,else__10097__auto__){
var self__ = this;
var this__10096__auto____$1 = this;
var G__53274 = (((k53272 instanceof cljs.core.Keyword))?k53272.fqn:null);
switch (G__53274) {
case "error":
return self__.error;

break;
case "abort":
return self__.abort;

break;
case "registered":
return self__.registered;

break;
case "pending-exceptions":
return self__.pending_exceptions;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k53272,else__10097__auto__);

}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__10108__auto__,writer__10109__auto__,opts__10110__auto__){
var self__ = this;
var this__10108__auto____$1 = this;
var pr_pair__10111__auto__ = ((function (this__10108__auto____$1){
return (function (keyval__10112__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,cljs.core.pr_writer,""," ","",opts__10110__auto__,keyval__10112__auto__);
});})(this__10108__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,pr_pair__10111__auto__,"#superv.async.TrackingSupervisor{",", ","}",opts__10110__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__53271){
var self__ = this;
var G__53271__$1 = this;
return (new cljs.core.RecordIter((0),G__53271__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__10092__auto__){
var self__ = this;
var this__10092__auto____$1 = this;
return self__.__meta;
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__10088__auto__){
var self__ = this;
var this__10088__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__10098__auto__){
var self__ = this;
var this__10098__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__10089__auto__){
var self__ = this;
var this__10089__auto____$1 = this;
var h__9861__auto__ = self__.__hash;
if(!((h__9861__auto__ == null))){
return h__9861__auto__;
} else {
var h__9861__auto____$1 = cljs.core.hash_imap.call(null,this__10089__auto____$1);
self__.__hash = h__9861__auto____$1;

return h__9861__auto____$1;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__10090__auto__,other__10091__auto__){
var self__ = this;
var this__10090__auto____$1 = this;
if(cljs.core.truth_((function (){var and__9407__auto__ = other__10091__auto__;
if(cljs.core.truth_(and__9407__auto__)){
return ((this__10090__auto____$1.constructor === other__10091__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__10090__auto____$1,other__10091__auto__));
} else {
return and__9407__auto__;
}
})())){
return true;
} else {
return false;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__10103__auto__,k__10104__auto__){
var self__ = this;
var this__10103__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),null,new cljs.core.Keyword(null,"abort","abort",521193198),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"registered","registered",-388600037),null], null), null),k__10104__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__10103__auto____$1),self__.__meta),k__10104__auto__);
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__10104__auto__)),null));
}
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_error$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.error;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.abort;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_register_go$arity$2 = (function (this$,body){
var self__ = this;
var this$__$1 = this;
var id = cljs.core.random_uuid.call(null);
cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.assoc,id,body);

return id;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_unregister_go$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.dissoc,id);
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_track_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.assoc,e,superv.async.now.call(null));
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_free_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.dissoc,e);
});

superv.async.TrackingSupervisor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__10101__auto__,k__10102__auto__,G__53271){
var self__ = this;
var this__10101__auto____$1 = this;
var pred__53275 = cljs.core.keyword_identical_QMARK_;
var expr__53276 = k__10102__auto__;
if(cljs.core.truth_(pred__53275.call(null,new cljs.core.Keyword(null,"error","error",-978969032),expr__53276))){
return (new superv.async.TrackingSupervisor(G__53271,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__53275.call(null,new cljs.core.Keyword(null,"abort","abort",521193198),expr__53276))){
return (new superv.async.TrackingSupervisor(self__.error,G__53271,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__53275.call(null,new cljs.core.Keyword(null,"registered","registered",-388600037),expr__53276))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,G__53271,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__53275.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),expr__53276))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,G__53271,self__.__meta,self__.__extmap,null));
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__10102__auto__,G__53271),null));
}
}
}
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__10106__auto__){
var self__ = this;
var this__10106__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__10093__auto__,G__53271){
var self__ = this;
var this__10093__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,G__53271,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__10099__auto__,entry__10100__auto__){
var self__ = this;
var this__10099__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__10100__auto__)){
return this__10099__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__10100__auto__,(0)),cljs.core._nth.call(null,entry__10100__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__10099__auto____$1,entry__10100__auto__);
}
});

superv.async.TrackingSupervisor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.Symbol(null,"abort","abort",-2133242571,null),new cljs.core.Symbol(null,"registered","registered",1251931490,null),new cljs.core.Symbol(null,"pending-exceptions","pending-exceptions",-247748567,null)], null);
});

superv.async.TrackingSupervisor.cljs$lang$type = true;

superv.async.TrackingSupervisor.cljs$lang$ctorPrSeq = (function (this__10130__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"superv.async/TrackingSupervisor");
});

superv.async.TrackingSupervisor.cljs$lang$ctorPrWriter = (function (this__10130__auto__,writer__10131__auto__){
return cljs.core._write.call(null,writer__10131__auto__,"superv.async/TrackingSupervisor");
});

superv.async.__GT_TrackingSupervisor = (function superv$async$__GT_TrackingSupervisor(error,abort,registered,pending_exceptions){
return (new superv.async.TrackingSupervisor(error,abort,registered,pending_exceptions,null,null,null));
});

superv.async.map__GT_TrackingSupervisor = (function superv$async$map__GT_TrackingSupervisor(G__53273){
return (new superv.async.TrackingSupervisor(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(G__53273),new cljs.core.Keyword(null,"abort","abort",521193198).cljs$core$IFn$_invoke$arity$1(G__53273),new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(G__53273),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(G__53273),null,cljs.core.dissoc.call(null,G__53273,new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)),null));
});

cljs.core.enable_console_print_BANG_.call(null);
/**
 * A simple supervisor which deals with errors through callbacks. You need to
 *   close its abort channel manually if you want the context to stop. It is
 *   supposed to be used at a boundary to an unsupervised system. If you want
 *   strong supervision, use the restarting-supervisor instead.
 */
superv.async.simple_supervisor = (function superv$async$simple_supervisor(var_args){
var args__10647__auto__ = [];
var len__10640__auto___53303 = arguments.length;
var i__10641__auto___53304 = (0);
while(true){
if((i__10641__auto___53304 < len__10640__auto___53303)){
args__10647__auto__.push((arguments[i__10641__auto___53304]));

var G__53305 = (i__10641__auto___53304 + (1));
i__10641__auto___53304 = G__53305;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((0) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((0)),(0),null)):null);
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(argseq__10648__auto__);
});

superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (p__53280){
var map__53281 = p__53280;
var map__53281__$1 = ((((!((map__53281 == null)))?((((map__53281.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53281.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53281):map__53281);
var stale_timeout = cljs.core.get.call(null,map__53281__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((10) * (1000)));
var error_fn = cljs.core.get.call(null,map__53281__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),((function (map__53281,map__53281__$1,stale_timeout){
return (function (e){
return cljs.core.println.call(null,"Supervisor:",e,e.stack);
});})(map__53281,map__53281__$1,stale_timeout))
);
var pending_fn = cljs.core.get.call(null,map__53281__$1,new cljs.core.Keyword(null,"pending-fn","pending-fn",1734381755));
var s = superv.async.map__GT_TrackingSupervisor.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"abort","abort",521193198),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"registered","registered",-388600037),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null));
var err_ch = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(s);
cljs.core.async.take_BANG_.call(null,err_ch,((function (s,err_ch,map__53281,map__53281__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$loop_fn(e){
error_fn.call(null,e);

return cljs.core.async.take_BANG_.call(null,err_ch,superv$async$loop_fn);
});})(s,err_ch,map__53281,map__53281__$1,stale_timeout,error_fn,pending_fn))
);

((function (s,err_ch,map__53281,map__53281__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$pending(_){
var vec__53293 = cljs.core.filter.call(null,((function (s,err_ch,map__53281,map__53281__$1,stale_timeout,error_fn,pending_fn){
return (function (p__53299){
var vec__53300 = p__53299;
var k = cljs.core.nth.call(null,vec__53300,(0),null);
var v = cljs.core.nth.call(null,vec__53300,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout) > v.getTime());
});})(s,err_ch,map__53281,map__53281__$1,stale_timeout,error_fn,pending_fn))
,cljs.core.deref.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s)));
var vec__53296 = cljs.core.nth.call(null,vec__53293,(0),null);
var e = cljs.core.nth.call(null,vec__53296,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__53296,(1),null);
if(cljs.core.truth_(e)){
error_fn.call(null,e);

superv.async._free_exception.call(null,s,e);
} else {
}

return cljs.core.async.take_BANG_.call(null,cljs.core.async.timeout.call(null,stale_timeout),superv$async$pending);
});})(s,err_ch,map__53281,map__53281__$1,stale_timeout,error_fn,pending_fn))
.call(null,null);

return s;
});

superv.async.simple_supervisor.cljs$lang$maxFixedArity = (0);

superv.async.simple_supervisor.cljs$lang$applyTo = (function (seq53279){
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq53279));
});

superv.async.S = superv.async.simple_supervisor.call(null);
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
superv.async.throw_if_exception = (function superv$async$throw_if_exception(S,x){
if((x instanceof Error)){
superv.async._free_exception.call(null,S,x);

throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),(function (){var or__9419__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
superv.async.superv_init = (function superv$async$superv_init(){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [superv.async._error,superv.async._abort,superv.async._register_go,superv.async._unregister_go,superv.async._track_exception,superv.async._free_exception,superv.async.throw_if_exception], null);
});
goog.exportSymbol('superv.async.superv_init', superv.async.superv_init);
superv.async.superv_init.call(null);
superv.async.supervisor_QMARK_ = (function superv$async$supervisor_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.superv$async$PSupervisor$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
}
});
superv.async.check_supervisor = (function superv$async$check_supervisor(x){
if(cljs.core.truth_(superv.async.supervisor_QMARK_.call(null,x))){
return null;
} else {
throw cljs.core.ex_info.call(null,"First argument is not a supervisor.",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"argument","argument",1183001841),x], null));
}
});
/**
 * Here until http://dev.clojure.org/jira/browse/ASYNC-74 is resolved.
 */
superv.async.chan_QMARK_ = (function superv$async$chan_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$ReadPort$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
}
});
/**
 * Same as core.async/take!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.take_QMARK_ = (function superv$async$take_QMARK_(var_args){
var args53323 = [];
var len__10640__auto___53326 = arguments.length;
var i__10641__auto___53327 = (0);
while(true){
if((i__10641__auto___53327 < len__10640__auto___53326)){
args53323.push((arguments[i__10641__auto___53327]));

var G__53328 = (i__10641__auto___53327 + (1));
i__10641__auto___53327 = G__53328;
continue;
} else {
}
break;
}

var G__53325 = args53323.length;
switch (G__53325) {
case 3:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args53323.length)].join('')));

}
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,fn1){
return superv.async.take_QMARK_.call(null,S,port,fn1,true);
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,fn1,on_caller_QMARK_){
return cljs.core.async.take_BANG_.call(null,port,(function (v){
if((v instanceof Error)){
superv.async._free_exception.call(null,S,v);
} else {
}

return fn1.call(null,v);
}),on_caller_QMARK_);
});

superv.async.take_QMARK_.cljs$lang$maxFixedArity = 4;

/**
 * Same as core.async/put!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.put_QMARK_ = (function superv$async$put_QMARK_(var_args){
var args53330 = [];
var len__10640__auto___53333 = arguments.length;
var i__10641__auto___53334 = (0);
while(true){
if((i__10641__auto___53334 < len__10640__auto___53333)){
args53330.push((arguments[i__10641__auto___53334]));

var G__53335 = (i__10641__auto___53334 + (1));
i__10641__auto___53334 = G__53335;
continue;
} else {
}
break;
}

var G__53332 = args53330.length;
switch (G__53332) {
case 3:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args53330.length)].join('')));

}
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,val){
return superv.async.put_QMARK_.call(null,S,port,val,(function superv$async$noop(_){
return null;
}));
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,val,fn1){
return superv.async.put_QMARK_.call(null,S,port,val,fn1,true);
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5 = (function (S,port,val,fn1,on_caller_QMARK_){
return cljs.core.async.put_BANG_.call(null,port,val,(function (ret){
if(((val instanceof Error)) && (!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,val)),new cljs.core.Keyword(null,"aborted","aborted",1775972619))))){
superv.async._track_exception.call(null,S,val);
} else {
}

return fn1.call(null,ret);
}),on_caller_QMARK_);
});

superv.async.put_QMARK_.cljs$lang$maxFixedArity = 5;

/**
 * Takes objects from in-ch, asynchrously applies function f> (function should
 *   return a channel), takes the result from the returned channel and if it's
 *   truthy, puts it in the out-ch. Returns the closed out-ch. Closes the
 *   returned channel when the input channel has been completely consumed and all
 *   objects have been processed.
 *   If out-ch is not provided, an unbuffered one will be used.
 */
superv.async.pmap_GT__GT_ = (function superv$async$pmap_GT__GT_(var_args){
var args53348 = [];
var len__10640__auto___53551 = arguments.length;
var i__10641__auto___53552 = (0);
while(true){
if((i__10641__auto___53552 < len__10640__auto___53551)){
args53348.push((arguments[i__10641__auto___53552]));

var G__53553 = (i__10641__auto___53552 + (1));
i__10641__auto___53552 = G__53553;
continue;
} else {
}
break;
}

var G__53350 = args53348.length;
switch (G__53350) {
case 4:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args53348.length)].join('')));

}
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4 = (function (S,f_GT_,parallelism,in_ch){
return superv.async.pmap_GT__GT_.call(null,S,f_GT_,parallelism,cljs.core.async.chan.call(null),in_ch);
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5 = (function (S,f_GT_,parallelism,out_ch,in_ch){
if(cljs.core.fn_QMARK_.call(null,f_GT_)){
} else {
throw (new Error("Assert failed: (fn? f>)"));
}

if((cljs.core.integer_QMARK_.call(null,parallelism)) && ((parallelism > (0)))){
} else {
throw (new Error("Assert failed: (and (integer? parallelism) (pos? parallelism))"));
}

if((in_ch instanceof cljs.core.async.impl.protocols.ReadPort)){
} else {
throw (new Error("Assert failed: (instance? ReadPort in-ch)"));
}

var threads = cljs.core.atom.call(null,parallelism);
var n__10440__auto___53555 = parallelism;
var __53556 = (0);
while(true){
if((__53556 < n__10440__auto___53555)){
var c__19190__auto___53557 = superv.async.check_supervisor.call(null,superv.async.S);
var id__19191__auto___53558 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"result","result",-1239343558,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)))], null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null)))))),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"zero?","zero?",325758897,null),cljs.core.list(new cljs.core.Symbol(null,"swap!","swap!",-655677516,null),new cljs.core.Symbol(null,"threads","threads",-77267207,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))));
var c__33478__auto___53559 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__53556,c__33478__auto___53559,c__19190__auto___53557,id__19191__auto___53558,n__10440__auto___53555,threads){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (__53556,c__33478__auto___53559,c__19190__auto___53557,id__19191__auto___53558,n__10440__auto___53555,threads){
return (function (state_53485){
var state_val_53486 = (state_53485[(1)]);
if((state_val_53486 === (7))){
var inst_53354 = (state_53485[(7)]);
var inst_53362 = (state_53485[(2)]);
var state_53485__$1 = (function (){var statearr_53487 = state_53485;
(statearr_53487[(8)] = inst_53362);

return statearr_53487;
})();
var statearr_53488_53560 = state_53485__$1;
(statearr_53488_53560[(2)] = inst_53354);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53485__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (20))){
var inst_53469 = (state_53485[(2)]);
var state_53485__$1 = state_53485;
var statearr_53489_53561 = state_53485__$1;
(statearr_53489_53561[(2)] = inst_53469);

(statearr_53489_53561[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (27))){
var inst_53431 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_53432 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_53433 = cljs.core.PersistentHashMap.fromArrays(inst_53431,inst_53432);
var inst_53434 = cljs.core.ex_info.call(null,"Aborted operations",inst_53433);
var state_53485__$1 = state_53485;
var statearr_53490_53562 = state_53485__$1;
(statearr_53490_53562[(2)] = inst_53434);

(statearr_53490_53562[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (1))){
var state_53485__$1 = state_53485;
var statearr_53491_53563 = state_53485__$1;
(statearr_53491_53563[(2)] = null);

(statearr_53491_53563[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (24))){
var inst_53413 = (state_53485[(2)]);
var inst_53414 = superv.async.throw_if_exception.call(null,S,inst_53413);
var inst_53415 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_53485__$1 = (function (){var statearr_53492 = state_53485;
(statearr_53492[(9)] = inst_53414);

return statearr_53492;
})();
var statearr_53493_53564 = state_53485__$1;
(statearr_53493_53564[(2)] = inst_53415);

(statearr_53493_53564[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (39))){
var state_53485__$1 = state_53485;
var statearr_53494_53565 = state_53485__$1;
(statearr_53494_53565[(2)] = null);

(statearr_53494_53565[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (4))){
var inst_53354 = (state_53485[(7)]);
var inst_53354__$1 = (state_53485[(2)]);
var inst_53355 = cljs.core.ex_data.call(null,inst_53354__$1);
var inst_53356 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_53355);
var inst_53357 = cljs.core._EQ_.call(null,inst_53356,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_53485__$1 = (function (){var statearr_53495 = state_53485;
(statearr_53495[(7)] = inst_53354__$1);

return statearr_53495;
})();
if(inst_53357){
var statearr_53496_53566 = state_53485__$1;
(statearr_53496_53566[(1)] = (5));

} else {
var statearr_53497_53567 = state_53485__$1;
(statearr_53497_53567[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (15))){
var inst_53387 = (state_53485[(10)]);
var inst_53389 = (inst_53387 instanceof Error);
var state_53485__$1 = state_53485;
if(cljs.core.truth_(inst_53389)){
var statearr_53498_53568 = state_53485__$1;
(statearr_53498_53568[(1)] = (18));

} else {
var statearr_53499_53569 = state_53485__$1;
(statearr_53499_53569[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (21))){
var inst_53394 = (state_53485[(11)]);
var inst_53400 = (state_53485[(2)]);
var inst_53401 = cljs.core.nth.call(null,inst_53400,(0),null);
var inst_53402 = cljs.core.nth.call(null,inst_53400,(1),null);
var inst_53403 = cljs.core._EQ_.call(null,inst_53402,inst_53394);
var state_53485__$1 = (function (){var statearr_53500 = state_53485;
(statearr_53500[(12)] = inst_53401);

return statearr_53500;
})();
if(inst_53403){
var statearr_53501_53570 = state_53485__$1;
(statearr_53501_53570[(1)] = (22));

} else {
var statearr_53502_53571 = state_53485__$1;
(statearr_53502_53571[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (31))){
var state_53485__$1 = state_53485;
var statearr_53503_53572 = state_53485__$1;
(statearr_53503_53572[(2)] = null);

(statearr_53503_53572[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (32))){
var inst_53466 = (state_53485[(2)]);
var state_53485__$1 = (function (){var statearr_53504 = state_53485;
(statearr_53504[(13)] = inst_53466);

return statearr_53504;
})();
var statearr_53505_53573 = state_53485__$1;
(statearr_53505_53573[(2)] = null);

(statearr_53505_53573[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (40))){
var inst_53481 = (state_53485[(2)]);
var state_53485__$1 = state_53485;
var statearr_53506_53574 = state_53485__$1;
(statearr_53506_53574[(2)] = inst_53481);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53485__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (33))){
var inst_53443 = (state_53485[(14)]);
var inst_53449 = (state_53485[(2)]);
var inst_53450 = cljs.core.nth.call(null,inst_53449,(0),null);
var inst_53451 = cljs.core.nth.call(null,inst_53449,(1),null);
var inst_53452 = cljs.core._EQ_.call(null,inst_53451,inst_53443);
var state_53485__$1 = (function (){var statearr_53507 = state_53485;
(statearr_53507[(15)] = inst_53450);

return statearr_53507;
})();
if(inst_53452){
var statearr_53508_53575 = state_53485__$1;
(statearr_53508_53575[(1)] = (34));

} else {
var statearr_53509_53576 = state_53485__$1;
(statearr_53509_53576[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (13))){
var inst_53376 = (state_53485[(16)]);
var state_53485__$1 = state_53485;
var statearr_53510_53577 = state_53485__$1;
(statearr_53510_53577[(2)] = inst_53376);

(statearr_53510_53577[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (22))){
var inst_53405 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_53406 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_53407 = cljs.core.PersistentHashMap.fromArrays(inst_53405,inst_53406);
var inst_53408 = cljs.core.ex_info.call(null,"Aborted operations",inst_53407);
var state_53485__$1 = state_53485;
var statearr_53511_53578 = state_53485__$1;
(statearr_53511_53578[(2)] = inst_53408);

(statearr_53511_53578[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (36))){
var inst_53462 = (state_53485[(2)]);
var inst_53463 = superv.async.throw_if_exception.call(null,S,inst_53462);
var state_53485__$1 = state_53485;
var statearr_53512_53579 = state_53485__$1;
(statearr_53512_53579[(2)] = inst_53463);

(statearr_53512_53579[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (29))){
var inst_53438 = (state_53485[(17)]);
var inst_53437 = (state_53485[(2)]);
var inst_53438__$1 = superv.async.throw_if_exception.call(null,S,inst_53437);
var state_53485__$1 = (function (){var statearr_53513 = state_53485;
(statearr_53513[(17)] = inst_53438__$1);

return statearr_53513;
})();
if(cljs.core.truth_(inst_53438__$1)){
var statearr_53514_53580 = state_53485__$1;
(statearr_53514_53580[(1)] = (30));

} else {
var statearr_53515_53581 = state_53485__$1;
(statearr_53515_53581[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (6))){
var inst_53354 = (state_53485[(7)]);
var inst_53360 = superv.async._track_exception.call(null,S,inst_53354);
var state_53485__$1 = state_53485;
var statearr_53516_53582 = state_53485__$1;
(statearr_53516_53582[(2)] = inst_53360);

(statearr_53516_53582[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (28))){
var inst_53427 = (state_53485[(18)]);
var state_53485__$1 = state_53485;
var statearr_53517_53583 = state_53485__$1;
(statearr_53517_53583[(2)] = inst_53427);

(statearr_53517_53583[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (25))){
var inst_53411 = (state_53485[(2)]);
var state_53485__$1 = state_53485;
var statearr_53518_53584 = state_53485__$1;
(statearr_53518_53584[(2)] = inst_53411);

(statearr_53518_53584[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (34))){
var inst_53454 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_53455 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_53456 = cljs.core.PersistentHashMap.fromArrays(inst_53454,inst_53455);
var inst_53457 = cljs.core.ex_info.call(null,"Aborted operations",inst_53456);
var state_53485__$1 = state_53485;
var statearr_53519_53585 = state_53485__$1;
(statearr_53519_53585[(2)] = inst_53457);

(statearr_53519_53585[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (17))){
var inst_53472 = (state_53485[(2)]);
var state_53485__$1 = state_53485;
var statearr_53520_53586 = state_53485__$1;
(statearr_53520_53586[(2)] = inst_53472);

(statearr_53520_53586[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (3))){
var inst_53351 = (state_53485[(2)]);
var inst_53352 = superv.async._unregister_go.call(null,S,id__19191__auto___53558);
var state_53485__$1 = (function (){var statearr_53521 = state_53485;
(statearr_53521[(19)] = inst_53351);

(statearr_53521[(20)] = inst_53352);

return statearr_53521;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53485__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (12))){
var inst_53380 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_53381 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_53382 = cljs.core.PersistentHashMap.fromArrays(inst_53380,inst_53381);
var inst_53383 = cljs.core.ex_info.call(null,"Aborted operations",inst_53382);
var state_53485__$1 = state_53485;
var statearr_53522_53587 = state_53485__$1;
(statearr_53522_53587[(2)] = inst_53383);

(statearr_53522_53587[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (2))){
var inst_53483 = (state_53485[(2)]);
var state_53485__$1 = state_53485;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53485__$1,inst_53483);
} else {
if((state_val_53486 === (23))){
var inst_53387 = (state_53485[(10)]);
var state_53485__$1 = state_53485;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53485__$1,(25),out_ch,inst_53387);
} else {
if((state_val_53486 === (35))){
var inst_53438 = (state_53485[(17)]);
var state_53485__$1 = state_53485;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53485__$1,(37),out_ch,inst_53438);
} else {
if((state_val_53486 === (19))){
var inst_53420 = (state_53485[(21)]);
var inst_53387 = (state_53485[(10)]);
var inst_53420__$1 = superv.async._abort.call(null,S);
var inst_53421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53422 = f_GT_.call(null,inst_53387);
var inst_53423 = [inst_53420__$1,inst_53422];
var inst_53424 = (new cljs.core.PersistentVector(null,2,(5),inst_53421,inst_53423,null));
var state_53485__$1 = (function (){var statearr_53523 = state_53485;
(statearr_53523[(21)] = inst_53420__$1);

return statearr_53523;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_53485__$1,(26),inst_53424,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_53486 === (11))){
var inst_53370 = (state_53485[(22)]);
var inst_53375 = (state_53485[(2)]);
var inst_53376 = cljs.core.nth.call(null,inst_53375,(0),null);
var inst_53377 = cljs.core.nth.call(null,inst_53375,(1),null);
var inst_53378 = cljs.core._EQ_.call(null,inst_53377,inst_53370);
var state_53485__$1 = (function (){var statearr_53524 = state_53485;
(statearr_53524[(16)] = inst_53376);

return statearr_53524;
})();
if(inst_53378){
var statearr_53525_53588 = state_53485__$1;
(statearr_53525_53588[(1)] = (12));

} else {
var statearr_53526_53589 = state_53485__$1;
(statearr_53526_53589[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (9))){
var inst_53370 = (state_53485[(22)]);
var inst_53370__$1 = superv.async._abort.call(null,S);
var inst_53371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53372 = [inst_53370__$1,in_ch];
var inst_53373 = (new cljs.core.PersistentVector(null,2,(5),inst_53371,inst_53372,null));
var state_53485__$1 = (function (){var statearr_53527 = state_53485;
(statearr_53527[(22)] = inst_53370__$1);

return statearr_53527;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_53485__$1,(11),inst_53373,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_53486 === (5))){
var state_53485__$1 = state_53485;
var statearr_53528_53590 = state_53485__$1;
(statearr_53528_53590[(2)] = null);

(statearr_53528_53590[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (14))){
var inst_53387 = (state_53485[(10)]);
var inst_53386 = (state_53485[(2)]);
var inst_53387__$1 = superv.async.throw_if_exception.call(null,S,inst_53386);
var state_53485__$1 = (function (){var statearr_53529 = state_53485;
(statearr_53529[(10)] = inst_53387__$1);

return statearr_53529;
})();
if(cljs.core.truth_(inst_53387__$1)){
var statearr_53530_53591 = state_53485__$1;
(statearr_53530_53591[(1)] = (15));

} else {
var statearr_53531_53592 = state_53485__$1;
(statearr_53531_53592[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (26))){
var inst_53420 = (state_53485[(21)]);
var inst_53426 = (state_53485[(2)]);
var inst_53427 = cljs.core.nth.call(null,inst_53426,(0),null);
var inst_53428 = cljs.core.nth.call(null,inst_53426,(1),null);
var inst_53429 = cljs.core._EQ_.call(null,inst_53428,inst_53420);
var state_53485__$1 = (function (){var statearr_53532 = state_53485;
(statearr_53532[(18)] = inst_53427);

return statearr_53532;
})();
if(inst_53429){
var statearr_53533_53593 = state_53485__$1;
(statearr_53533_53593[(1)] = (27));

} else {
var statearr_53534_53594 = state_53485__$1;
(statearr_53534_53594[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (16))){
var state_53485__$1 = state_53485;
var statearr_53535_53595 = state_53485__$1;
(statearr_53535_53595[(2)] = null);

(statearr_53535_53595[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (38))){
var inst_53478 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_53485__$1 = state_53485;
var statearr_53536_53596 = state_53485__$1;
(statearr_53536_53596[(2)] = inst_53478);

(statearr_53536_53596[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (30))){
var inst_53443 = (state_53485[(14)]);
var inst_53443__$1 = superv.async._abort.call(null,S);
var inst_53444 = cljs.core.async.timeout.call(null,(0));
var inst_53445 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53446 = [inst_53443__$1,inst_53444];
var inst_53447 = (new cljs.core.PersistentVector(null,2,(5),inst_53445,inst_53446,null));
var state_53485__$1 = (function (){var statearr_53537 = state_53485;
(statearr_53537[(14)] = inst_53443__$1);

return statearr_53537;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_53485__$1,(33),inst_53447,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_53486 === (10))){
var inst_53474 = (state_53485[(2)]);
var inst_53475 = cljs.core.swap_BANG_.call(null,threads,cljs.core.dec);
var inst_53476 = (inst_53475 === (0));
var state_53485__$1 = (function (){var statearr_53538 = state_53485;
(statearr_53538[(23)] = inst_53474);

return statearr_53538;
})();
if(cljs.core.truth_(inst_53476)){
var statearr_53539_53597 = state_53485__$1;
(statearr_53539_53597[(1)] = (38));

} else {
var statearr_53540_53598 = state_53485__$1;
(statearr_53540_53598[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (18))){
var inst_53394 = (state_53485[(11)]);
var inst_53394__$1 = superv.async._abort.call(null,S);
var inst_53395 = cljs.core.async.timeout.call(null,(0));
var inst_53396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53397 = [inst_53394__$1,inst_53395];
var inst_53398 = (new cljs.core.PersistentVector(null,2,(5),inst_53396,inst_53397,null));
var state_53485__$1 = (function (){var statearr_53541 = state_53485;
(statearr_53541[(11)] = inst_53394__$1);

return statearr_53541;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_53485__$1,(21),inst_53398,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_53486 === (37))){
var inst_53460 = (state_53485[(2)]);
var state_53485__$1 = state_53485;
var statearr_53542_53599 = state_53485__$1;
(statearr_53542_53599[(2)] = inst_53460);

(statearr_53542_53599[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (8))){
var ___$1 = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_53485,(4),Error,(3),(2));
var state_53485__$1 = state_53485;
var statearr_53543_53600 = state_53485__$1;
(statearr_53543_53600[(2)] = null);

(statearr_53543_53600[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(__53556,c__33478__auto___53559,c__19190__auto___53557,id__19191__auto___53558,n__10440__auto___53555,threads))
;
return ((function (__53556,switch__33364__auto__,c__33478__auto___53559,c__19190__auto___53557,id__19191__auto___53558,n__10440__auto___53555,threads){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_53547 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53547[(0)] = superv$async$state_machine__33365__auto__);

(statearr_53547[(1)] = (1));

return statearr_53547;
});
var superv$async$state_machine__33365__auto____1 = (function (state_53485){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_53485);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e53548){if((e53548 instanceof Object)){
var ex__33368__auto__ = e53548;
var statearr_53549_53601 = state_53485;
(statearr_53549_53601[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53485);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53548;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53602 = state_53485;
state_53485 = G__53602;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_53485){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_53485);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(__53556,switch__33364__auto__,c__33478__auto___53559,c__19190__auto___53557,id__19191__auto___53558,n__10440__auto___53555,threads))
})();
var state__33480__auto__ = (function (){var statearr_53550 = f__33479__auto__.call(null);
(statearr_53550[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___53559);

return statearr_53550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(__53556,c__33478__auto___53559,c__19190__auto___53557,id__19191__auto___53558,n__10440__auto___53555,threads))
);


var G__53603 = (__53556 + (1));
__53556 = G__53603;
continue;
} else {
}
break;
}

return out_ch;
});

superv.async.pmap_GT__GT_.cljs$lang$maxFixedArity = 5;

/**
 * Similiar to dorun. Simply takes messages from channels but does nothing with
 *   them. Returns channel that will close when all messages have been consumed.
 */
superv.async.engulf = (function superv$async$engulf(var_args){
var args__10647__auto__ = [];
var len__10640__auto___53684 = arguments.length;
var i__10641__auto___53685 = (0);
while(true){
if((i__10641__auto___53685 < len__10640__auto___53684)){
args__10647__auto__.push((arguments[i__10641__auto___53685]));

var G__53686 = (i__10641__auto___53685 + (1));
i__10641__auto___53685 = G__53686;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var ch = cljs.core.async.merge.call(null,cs);
var c__19190__auto__ = superv.async.check_supervisor.call(null,superv.async.S);
var id__19191__auto__ = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null))))));
var c__33478__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto__,c__19190__auto__,id__19191__auto__,ch){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto__,c__19190__auto__,id__19191__auto__,ch){
return (function (state_53653){
var state_val_53654 = (state_53653[(1)]);
if((state_val_53654 === (7))){
var inst_53609 = (state_53653[(7)]);
var inst_53617 = (state_53653[(2)]);
var state_53653__$1 = (function (){var statearr_53655 = state_53653;
(statearr_53655[(8)] = inst_53617);

return statearr_53655;
})();
var statearr_53656_53687 = state_53653__$1;
(statearr_53656_53687[(2)] = inst_53609);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53653__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53654 === (1))){
var state_53653__$1 = state_53653;
var statearr_53657_53688 = state_53653__$1;
(statearr_53657_53688[(2)] = null);

(statearr_53657_53688[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53654 === (4))){
var inst_53609 = (state_53653[(7)]);
var inst_53609__$1 = (state_53653[(2)]);
var inst_53610 = cljs.core.ex_data.call(null,inst_53609__$1);
var inst_53611 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_53610);
var inst_53612 = cljs.core._EQ_.call(null,inst_53611,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_53653__$1 = (function (){var statearr_53658 = state_53653;
(statearr_53658[(7)] = inst_53609__$1);

return statearr_53658;
})();
if(inst_53612){
var statearr_53659_53689 = state_53653__$1;
(statearr_53659_53689[(1)] = (5));

} else {
var statearr_53660_53690 = state_53653__$1;
(statearr_53660_53690[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53654 === (15))){
var state_53653__$1 = state_53653;
var statearr_53661_53691 = state_53653__$1;
(statearr_53661_53691[(2)] = null);

(statearr_53661_53691[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53654 === (13))){
var inst_53631 = (state_53653[(9)]);
var state_53653__$1 = state_53653;
var statearr_53662_53692 = state_53653__$1;
(statearr_53662_53692[(2)] = inst_53631);

(statearr_53662_53692[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53654 === (6))){
var inst_53609 = (state_53653[(7)]);
var inst_53615 = superv.async._track_exception.call(null,S,inst_53609);
var state_53653__$1 = state_53653;
var statearr_53663_53693 = state_53653__$1;
(statearr_53663_53693[(2)] = inst_53615);

(statearr_53663_53693[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53654 === (17))){
var inst_53647 = (state_53653[(2)]);
var state_53653__$1 = state_53653;
var statearr_53664_53694 = state_53653__$1;
(statearr_53664_53694[(2)] = inst_53647);

(statearr_53664_53694[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53654 === (3))){
var inst_53606 = (state_53653[(2)]);
var inst_53607 = superv.async._unregister_go.call(null,S,id__19191__auto__);
var state_53653__$1 = (function (){var statearr_53665 = state_53653;
(statearr_53665[(10)] = inst_53607);

(statearr_53665[(11)] = inst_53606);

return statearr_53665;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53653__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53654 === (12))){
var inst_53635 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_53636 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_53637 = cljs.core.PersistentHashMap.fromArrays(inst_53635,inst_53636);
var inst_53638 = cljs.core.ex_info.call(null,"Aborted operations",inst_53637);
var state_53653__$1 = state_53653;
var statearr_53666_53695 = state_53653__$1;
(statearr_53666_53695[(2)] = inst_53638);

(statearr_53666_53695[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53654 === (2))){
var inst_53651 = (state_53653[(2)]);
var state_53653__$1 = state_53653;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53653__$1,inst_53651);
} else {
if((state_val_53654 === (11))){
var inst_53625 = (state_53653[(12)]);
var inst_53630 = (state_53653[(2)]);
var inst_53631 = cljs.core.nth.call(null,inst_53630,(0),null);
var inst_53632 = cljs.core.nth.call(null,inst_53630,(1),null);
var inst_53633 = cljs.core._EQ_.call(null,inst_53632,inst_53625);
var state_53653__$1 = (function (){var statearr_53667 = state_53653;
(statearr_53667[(9)] = inst_53631);

return statearr_53667;
})();
if(inst_53633){
var statearr_53668_53696 = state_53653__$1;
(statearr_53668_53696[(1)] = (12));

} else {
var statearr_53669_53697 = state_53653__$1;
(statearr_53669_53697[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53654 === (9))){
var inst_53625 = (state_53653[(12)]);
var inst_53625__$1 = superv.async._abort.call(null,S);
var inst_53626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53627 = [inst_53625__$1,ch];
var inst_53628 = (new cljs.core.PersistentVector(null,2,(5),inst_53626,inst_53627,null));
var state_53653__$1 = (function (){var statearr_53670 = state_53653;
(statearr_53670[(12)] = inst_53625__$1);

return statearr_53670;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_53653__$1,(11),inst_53628,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_53654 === (5))){
var state_53653__$1 = state_53653;
var statearr_53671_53698 = state_53653__$1;
(statearr_53671_53698[(2)] = null);

(statearr_53671_53698[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53654 === (14))){
var inst_53641 = (state_53653[(2)]);
var inst_53642 = superv.async.throw_if_exception.call(null,S,inst_53641);
var state_53653__$1 = state_53653;
if(cljs.core.truth_(inst_53642)){
var statearr_53672_53699 = state_53653__$1;
(statearr_53672_53699[(1)] = (15));

} else {
var statearr_53673_53700 = state_53653__$1;
(statearr_53673_53700[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53654 === (16))){
var state_53653__$1 = state_53653;
var statearr_53674_53701 = state_53653__$1;
(statearr_53674_53701[(2)] = null);

(statearr_53674_53701[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53654 === (10))){
var inst_53649 = (state_53653[(2)]);
var state_53653__$1 = state_53653;
var statearr_53675_53702 = state_53653__$1;
(statearr_53675_53702[(2)] = inst_53649);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53653__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53654 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_53653,(4),Error,(3),(2));
var state_53653__$1 = state_53653;
var statearr_53676_53703 = state_53653__$1;
(statearr_53676_53703[(2)] = null);

(statearr_53676_53703[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto__,c__19190__auto__,id__19191__auto__,ch))
;
return ((function (switch__33364__auto__,c__33478__auto__,c__19190__auto__,id__19191__auto__,ch){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_53680 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53680[(0)] = superv$async$state_machine__33365__auto__);

(statearr_53680[(1)] = (1));

return statearr_53680;
});
var superv$async$state_machine__33365__auto____1 = (function (state_53653){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_53653);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e53681){if((e53681 instanceof Object)){
var ex__33368__auto__ = e53681;
var statearr_53682_53704 = state_53653;
(statearr_53682_53704[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53653);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53681;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53705 = state_53653;
state_53653 = G__53705;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_53653){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_53653);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto__,c__19190__auto__,id__19191__auto__,ch))
})();
var state__33480__auto__ = (function (){var statearr_53683 = f__33479__auto__.call(null);
(statearr_53683[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto__);

return statearr_53683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto__,c__19190__auto__,id__19191__auto__,ch))
);

return c__33478__auto__;
});

superv.async.engulf.cljs$lang$maxFixedArity = (1);

superv.async.engulf.cljs$lang$applyTo = (function (seq53604){
var G__53605 = cljs.core.first.call(null,seq53604);
var seq53604__$1 = cljs.core.next.call(null,seq53604);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic(G__53605,seq53604__$1);
});

/**
 * Performs a reduce on objects from ch with the function f> (which
 *   should return a channel). Returns a channel with the resulting
 *   value.
 */
superv.async.reduce_GT_ = (function superv$async$reduce_GT_(S,f_GT_,acc,ch){
var result = cljs.core.async.chan.call(null);
var c__19190__auto___54072 = superv.async.check_supervisor.call(null,superv.async.S);
var id__19191__auto___54073 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"->>","->>",-1874332161,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null)),new cljs.core.Symbol(null,"recur","recur",1202958259,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null)))))));
var c__33478__auto___54074 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___54074,c__19190__auto___54072,id__19191__auto___54073,result){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___54074,c__19190__auto___54072,id__19191__auto___54073,result){
return (function (state_54014){
var state_val_54015 = (state_54014[(1)]);
if((state_val_54015 === (7))){
var inst_53892 = (state_54014[(7)]);
var inst_53900 = (state_54014[(2)]);
var state_54014__$1 = (function (){var statearr_54016 = state_54014;
(statearr_54016[(8)] = inst_53900);

return statearr_54016;
})();
var statearr_54017_54075 = state_54014__$1;
(statearr_54017_54075[(2)] = inst_53892);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54014__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (20))){
var inst_53980 = (state_54014[(2)]);
var state_54014__$1 = state_54014;
var statearr_54018_54076 = state_54014__$1;
(statearr_54018_54076[(2)] = inst_53980);

(statearr_54018_54076[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (27))){
var inst_53970 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_53971 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_53972 = cljs.core.PersistentHashMap.fromArrays(inst_53970,inst_53971);
var inst_53973 = cljs.core.ex_info.call(null,"Aborted operations",inst_53972);
var state_54014__$1 = state_54014;
var statearr_54019_54077 = state_54014__$1;
(statearr_54019_54077[(2)] = inst_53973);

(statearr_54019_54077[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (1))){
var state_54014__$1 = state_54014;
var statearr_54020_54078 = state_54014__$1;
(statearr_54020_54078[(2)] = null);

(statearr_54020_54078[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (24))){
var inst_53952 = (state_54014[(2)]);
var inst_53953 = superv.async.throw_if_exception.call(null,S,inst_53952);
var inst_53954 = cljs.core.async.close_BANG_.call(null,result);
var state_54014__$1 = (function (){var statearr_54021 = state_54014;
(statearr_54021[(9)] = inst_53953);

return statearr_54021;
})();
var statearr_54022_54079 = state_54014__$1;
(statearr_54022_54079[(2)] = inst_53954);

(statearr_54022_54079[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (4))){
var inst_53892 = (state_54014[(7)]);
var inst_53892__$1 = (state_54014[(2)]);
var inst_53893 = cljs.core.ex_data.call(null,inst_53892__$1);
var inst_53894 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_53893);
var inst_53895 = cljs.core._EQ_.call(null,inst_53894,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_54014__$1 = (function (){var statearr_54023 = state_54014;
(statearr_54023[(7)] = inst_53892__$1);

return statearr_54023;
})();
if(inst_53895){
var statearr_54024_54080 = state_54014__$1;
(statearr_54024_54080[(1)] = (5));

} else {
var statearr_54025_54081 = state_54014__$1;
(statearr_54025_54081[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (15))){
var inst_53926 = (state_54014[(10)]);
var inst_53928 = (inst_53926 instanceof Error);
var state_54014__$1 = state_54014;
if(cljs.core.truth_(inst_53928)){
var statearr_54026_54082 = state_54014__$1;
(statearr_54026_54082[(1)] = (18));

} else {
var statearr_54027_54083 = state_54014__$1;
(statearr_54027_54083[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (21))){
var inst_53933 = (state_54014[(11)]);
var inst_53939 = (state_54014[(2)]);
var inst_53940 = cljs.core.nth.call(null,inst_53939,(0),null);
var inst_53941 = cljs.core.nth.call(null,inst_53939,(1),null);
var inst_53942 = cljs.core._EQ_.call(null,inst_53941,inst_53933);
var state_54014__$1 = (function (){var statearr_54028 = state_54014;
(statearr_54028[(12)] = inst_53940);

return statearr_54028;
})();
if(inst_53942){
var statearr_54029_54084 = state_54014__$1;
(statearr_54029_54084[(1)] = (22));

} else {
var statearr_54030_54085 = state_54014__$1;
(statearr_54030_54085[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (31))){
var inst_53996 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_53997 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_53998 = cljs.core.PersistentHashMap.fromArrays(inst_53996,inst_53997);
var inst_53999 = cljs.core.ex_info.call(null,"Aborted operations",inst_53998);
var state_54014__$1 = state_54014;
var statearr_54031_54086 = state_54014__$1;
(statearr_54031_54086[(2)] = inst_53999);

(statearr_54031_54086[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (32))){
var inst_53904 = (state_54014[(13)]);
var state_54014__$1 = state_54014;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54014__$1,(34),result,inst_53904);
} else {
if((state_val_54015 === (33))){
var inst_54004 = (state_54014[(2)]);
var inst_54005 = superv.async.throw_if_exception.call(null,S,inst_54004);
var inst_54006 = cljs.core.async.close_BANG_.call(null,result);
var state_54014__$1 = (function (){var statearr_54032 = state_54014;
(statearr_54032[(14)] = inst_54005);

return statearr_54032;
})();
var statearr_54033_54087 = state_54014__$1;
(statearr_54033_54087[(2)] = inst_54006);

(statearr_54033_54087[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (13))){
var inst_53915 = (state_54014[(15)]);
var state_54014__$1 = state_54014;
var statearr_54034_54088 = state_54014__$1;
(statearr_54034_54088[(2)] = inst_53915);

(statearr_54034_54088[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (22))){
var inst_53944 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_53945 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_53946 = cljs.core.PersistentHashMap.fromArrays(inst_53944,inst_53945);
var inst_53947 = cljs.core.ex_info.call(null,"Aborted operations",inst_53946);
var state_54014__$1 = state_54014;
var statearr_54035_54089 = state_54014__$1;
(statearr_54035_54089[(2)] = inst_53947);

(statearr_54035_54089[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (29))){
var inst_53976 = (state_54014[(2)]);
var inst_53977 = superv.async.throw_if_exception.call(null,S,inst_53976);
var inst_53904 = inst_53977;
var state_54014__$1 = (function (){var statearr_54036 = state_54014;
(statearr_54036[(13)] = inst_53904);

return statearr_54036;
})();
var statearr_54037_54090 = state_54014__$1;
(statearr_54037_54090[(2)] = null);

(statearr_54037_54090[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (6))){
var inst_53892 = (state_54014[(7)]);
var inst_53898 = superv.async._track_exception.call(null,S,inst_53892);
var state_54014__$1 = state_54014;
var statearr_54038_54091 = state_54014__$1;
(statearr_54038_54091[(2)] = inst_53898);

(statearr_54038_54091[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (28))){
var inst_53966 = (state_54014[(16)]);
var state_54014__$1 = state_54014;
var statearr_54039_54092 = state_54014__$1;
(statearr_54039_54092[(2)] = inst_53966);

(statearr_54039_54092[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (25))){
var inst_53950 = (state_54014[(2)]);
var state_54014__$1 = state_54014;
var statearr_54040_54093 = state_54014__$1;
(statearr_54040_54093[(2)] = inst_53950);

(statearr_54040_54093[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (34))){
var inst_54002 = (state_54014[(2)]);
var state_54014__$1 = state_54014;
var statearr_54041_54094 = state_54014__$1;
(statearr_54041_54094[(2)] = inst_54002);

(statearr_54041_54094[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (17))){
var inst_54008 = (state_54014[(2)]);
var state_54014__$1 = state_54014;
var statearr_54042_54095 = state_54014__$1;
(statearr_54042_54095[(2)] = inst_54008);

(statearr_54042_54095[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (3))){
var inst_53889 = (state_54014[(2)]);
var inst_53890 = superv.async._unregister_go.call(null,S,id__19191__auto___54073);
var state_54014__$1 = (function (){var statearr_54043 = state_54014;
(statearr_54043[(17)] = inst_53890);

(statearr_54043[(18)] = inst_53889);

return statearr_54043;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54014__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (12))){
var inst_53919 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_53920 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_53921 = cljs.core.PersistentHashMap.fromArrays(inst_53919,inst_53920);
var inst_53922 = cljs.core.ex_info.call(null,"Aborted operations",inst_53921);
var state_54014__$1 = state_54014;
var statearr_54044_54096 = state_54014__$1;
(statearr_54044_54096[(2)] = inst_53922);

(statearr_54044_54096[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (2))){
var inst_54012 = (state_54014[(2)]);
var state_54014__$1 = state_54014;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54014__$1,inst_54012);
} else {
if((state_val_54015 === (23))){
var inst_53926 = (state_54014[(10)]);
var state_54014__$1 = state_54014;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54014__$1,(25),result,inst_53926);
} else {
if((state_val_54015 === (19))){
var inst_53959 = (state_54014[(19)]);
var inst_53926 = (state_54014[(10)]);
var inst_53904 = (state_54014[(13)]);
var inst_53959__$1 = superv.async._abort.call(null,S);
var inst_53960 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53961 = f_GT_.call(null,inst_53904,inst_53926);
var inst_53962 = [inst_53959__$1,inst_53961];
var inst_53963 = (new cljs.core.PersistentVector(null,2,(5),inst_53960,inst_53962,null));
var state_54014__$1 = (function (){var statearr_54045 = state_54014;
(statearr_54045[(19)] = inst_53959__$1);

return statearr_54045;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_54014__$1,(26),inst_53963,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_54015 === (11))){
var inst_53909 = (state_54014[(20)]);
var inst_53914 = (state_54014[(2)]);
var inst_53915 = cljs.core.nth.call(null,inst_53914,(0),null);
var inst_53916 = cljs.core.nth.call(null,inst_53914,(1),null);
var inst_53917 = cljs.core._EQ_.call(null,inst_53916,inst_53909);
var state_54014__$1 = (function (){var statearr_54046 = state_54014;
(statearr_54046[(15)] = inst_53915);

return statearr_54046;
})();
if(inst_53917){
var statearr_54047_54097 = state_54014__$1;
(statearr_54047_54097[(1)] = (12));

} else {
var statearr_54048_54098 = state_54014__$1;
(statearr_54048_54098[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (9))){
var inst_53909 = (state_54014[(20)]);
var inst_53909__$1 = superv.async._abort.call(null,S);
var inst_53910 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53911 = [inst_53909__$1,ch];
var inst_53912 = (new cljs.core.PersistentVector(null,2,(5),inst_53910,inst_53911,null));
var state_54014__$1 = (function (){var statearr_54049 = state_54014;
(statearr_54049[(20)] = inst_53909__$1);

return statearr_54049;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_54014__$1,(11),inst_53912,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_54015 === (5))){
var state_54014__$1 = state_54014;
var statearr_54050_54099 = state_54014__$1;
(statearr_54050_54099[(2)] = null);

(statearr_54050_54099[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (14))){
var inst_53926 = (state_54014[(10)]);
var inst_53925 = (state_54014[(2)]);
var inst_53926__$1 = superv.async.throw_if_exception.call(null,S,inst_53925);
var state_54014__$1 = (function (){var statearr_54051 = state_54014;
(statearr_54051[(10)] = inst_53926__$1);

return statearr_54051;
})();
if(cljs.core.truth_(inst_53926__$1)){
var statearr_54052_54100 = state_54014__$1;
(statearr_54052_54100[(1)] = (15));

} else {
var statearr_54053_54101 = state_54014__$1;
(statearr_54053_54101[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (26))){
var inst_53959 = (state_54014[(19)]);
var inst_53965 = (state_54014[(2)]);
var inst_53966 = cljs.core.nth.call(null,inst_53965,(0),null);
var inst_53967 = cljs.core.nth.call(null,inst_53965,(1),null);
var inst_53968 = cljs.core._EQ_.call(null,inst_53967,inst_53959);
var state_54014__$1 = (function (){var statearr_54054 = state_54014;
(statearr_54054[(16)] = inst_53966);

return statearr_54054;
})();
if(inst_53968){
var statearr_54055_54102 = state_54014__$1;
(statearr_54055_54102[(1)] = (27));

} else {
var statearr_54056_54103 = state_54014__$1;
(statearr_54056_54103[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (16))){
var inst_53985 = (state_54014[(21)]);
var inst_53985__$1 = superv.async._abort.call(null,S);
var inst_53986 = cljs.core.async.timeout.call(null,(0));
var inst_53987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53988 = [inst_53985__$1,inst_53986];
var inst_53989 = (new cljs.core.PersistentVector(null,2,(5),inst_53987,inst_53988,null));
var state_54014__$1 = (function (){var statearr_54057 = state_54014;
(statearr_54057[(21)] = inst_53985__$1);

return statearr_54057;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_54014__$1,(30),inst_53989,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_54015 === (30))){
var inst_53985 = (state_54014[(21)]);
var inst_53991 = (state_54014[(2)]);
var inst_53992 = cljs.core.nth.call(null,inst_53991,(0),null);
var inst_53993 = cljs.core.nth.call(null,inst_53991,(1),null);
var inst_53994 = cljs.core._EQ_.call(null,inst_53993,inst_53985);
var state_54014__$1 = (function (){var statearr_54058 = state_54014;
(statearr_54058[(22)] = inst_53992);

return statearr_54058;
})();
if(inst_53994){
var statearr_54059_54104 = state_54014__$1;
(statearr_54059_54104[(1)] = (31));

} else {
var statearr_54060_54105 = state_54014__$1;
(statearr_54060_54105[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (10))){
var inst_54010 = (state_54014[(2)]);
var state_54014__$1 = state_54014;
var statearr_54061_54106 = state_54014__$1;
(statearr_54061_54106[(2)] = inst_54010);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54014__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54015 === (18))){
var inst_53933 = (state_54014[(11)]);
var inst_53933__$1 = superv.async._abort.call(null,S);
var inst_53934 = cljs.core.async.timeout.call(null,(0));
var inst_53935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53936 = [inst_53933__$1,inst_53934];
var inst_53937 = (new cljs.core.PersistentVector(null,2,(5),inst_53935,inst_53936,null));
var state_54014__$1 = (function (){var statearr_54062 = state_54014;
(statearr_54062[(11)] = inst_53933__$1);

return statearr_54062;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_54014__$1,(21),inst_53937,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_54015 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_54014,(4),Error,(3),(2));
var inst_53904 = acc;
var state_54014__$1 = (function (){var statearr_54063 = state_54014;
(statearr_54063[(13)] = inst_53904);

return statearr_54063;
})();
var statearr_54064_54107 = state_54014__$1;
(statearr_54064_54107[(2)] = null);

(statearr_54064_54107[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___54074,c__19190__auto___54072,id__19191__auto___54073,result))
;
return ((function (switch__33364__auto__,c__33478__auto___54074,c__19190__auto___54072,id__19191__auto___54073,result){
return (function() {
var superv$async$reduce_GT__$_state_machine__33365__auto__ = null;
var superv$async$reduce_GT__$_state_machine__33365__auto____0 = (function (){
var statearr_54068 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54068[(0)] = superv$async$reduce_GT__$_state_machine__33365__auto__);

(statearr_54068[(1)] = (1));

return statearr_54068;
});
var superv$async$reduce_GT__$_state_machine__33365__auto____1 = (function (state_54014){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_54014);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e54069){if((e54069 instanceof Object)){
var ex__33368__auto__ = e54069;
var statearr_54070_54108 = state_54014;
(statearr_54070_54108[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54014);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54069;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54109 = state_54014;
state_54014 = G__54109;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$reduce_GT__$_state_machine__33365__auto__ = function(state_54014){
switch(arguments.length){
case 0:
return superv$async$reduce_GT__$_state_machine__33365__auto____0.call(this);
case 1:
return superv$async$reduce_GT__$_state_machine__33365__auto____1.call(this,state_54014);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$reduce_GT__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$reduce_GT__$_state_machine__33365__auto____0;
superv$async$reduce_GT__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$reduce_GT__$_state_machine__33365__auto____1;
return superv$async$reduce_GT__$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___54074,c__19190__auto___54072,id__19191__auto___54073,result))
})();
var state__33480__auto__ = (function (){var statearr_54071 = f__33479__auto__.call(null);
(statearr_54071[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___54074);

return statearr_54071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___54074,c__19190__auto___54072,id__19191__auto___54073,result))
);


return result;
});
/**
 * Concatenates two or more channels. First takes all values from first channel
 *   and supplies to output channel, then takes all values from second channel and
 *   so on. Similiar to core.async/merge but maintains the order of values.
 */
superv.async.concat_GT__GT_ = (function superv$async$concat_GT__GT_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___54239 = arguments.length;
var i__10641__auto___54240 = (0);
while(true){
if((i__10641__auto___54240 < len__10640__auto___54239)){
args__10647__auto__.push((arguments[i__10641__auto___54240]));

var G__54241 = (i__10641__auto___54240 + (1));
i__10641__auto___54240 = G__54241;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var out = cljs.core.async.chan.call(null);
var c__19190__auto___54242 = superv.async.check_supervisor.call(null,superv.async.S);
var id__19191__auto___54243 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"c","c",-122660552,null),cljs.core.list(new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"c","c",-122660552,null))], null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"v","v",1661996586,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.list(new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null))))));
var c__33478__auto___54244 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___54244,c__19190__auto___54242,id__19191__auto___54243,out){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___54244,c__19190__auto___54242,id__19191__auto___54243,out){
return (function (state_54192){
var state_val_54193 = (state_54192[(1)]);
if((state_val_54193 === (7))){
var inst_54115 = (state_54192[(7)]);
var inst_54123 = (state_54192[(2)]);
var state_54192__$1 = (function (){var statearr_54195 = state_54192;
(statearr_54195[(8)] = inst_54123);

return statearr_54195;
})();
var statearr_54196_54245 = state_54192__$1;
(statearr_54196_54245[(2)] = inst_54115);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54192__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (20))){
var inst_54182 = (state_54192[(2)]);
var state_54192__$1 = state_54192;
var statearr_54197_54246 = state_54192__$1;
(statearr_54197_54246[(2)] = inst_54182);

(statearr_54197_54246[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (1))){
var state_54192__$1 = state_54192;
var statearr_54198_54247 = state_54192__$1;
(statearr_54198_54247[(2)] = null);

(statearr_54198_54247[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (24))){
var inst_54127 = (state_54192[(9)]);
var inst_54175 = (state_54192[(2)]);
var inst_54176 = superv.async.throw_if_exception.call(null,S,inst_54175);
var tmp54194 = inst_54127;
var inst_54127__$1 = tmp54194;
var state_54192__$1 = (function (){var statearr_54199 = state_54192;
(statearr_54199[(10)] = inst_54176);

(statearr_54199[(9)] = inst_54127__$1);

return statearr_54199;
})();
var statearr_54200_54248 = state_54192__$1;
(statearr_54200_54248[(2)] = null);

(statearr_54200_54248[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (4))){
var inst_54115 = (state_54192[(7)]);
var inst_54115__$1 = (state_54192[(2)]);
var inst_54116 = cljs.core.ex_data.call(null,inst_54115__$1);
var inst_54117 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_54116);
var inst_54118 = cljs.core._EQ_.call(null,inst_54117,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_54192__$1 = (function (){var statearr_54201 = state_54192;
(statearr_54201[(7)] = inst_54115__$1);

return statearr_54201;
})();
if(inst_54118){
var statearr_54202_54249 = state_54192__$1;
(statearr_54202_54249[(1)] = (5));

} else {
var statearr_54203_54250 = state_54192__$1;
(statearr_54203_54250[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (15))){
var inst_54144 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_54145 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_54146 = cljs.core.PersistentHashMap.fromArrays(inst_54144,inst_54145);
var inst_54147 = cljs.core.ex_info.call(null,"Aborted operations",inst_54146);
var state_54192__$1 = state_54192;
var statearr_54204_54251 = state_54192__$1;
(statearr_54204_54251[(2)] = inst_54147);

(statearr_54204_54251[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (21))){
var inst_54156 = (state_54192[(11)]);
var inst_54162 = (state_54192[(2)]);
var inst_54163 = cljs.core.nth.call(null,inst_54162,(0),null);
var inst_54164 = cljs.core.nth.call(null,inst_54162,(1),null);
var inst_54165 = cljs.core._EQ_.call(null,inst_54164,inst_54156);
var state_54192__$1 = (function (){var statearr_54205 = state_54192;
(statearr_54205[(12)] = inst_54163);

return statearr_54205;
})();
if(inst_54165){
var statearr_54206_54252 = state_54192__$1;
(statearr_54206_54252[(1)] = (22));

} else {
var statearr_54207_54253 = state_54192__$1;
(statearr_54207_54253[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (13))){
var inst_54186 = (state_54192[(2)]);
var state_54192__$1 = state_54192;
var statearr_54208_54254 = state_54192__$1;
(statearr_54208_54254[(2)] = inst_54186);

(statearr_54208_54254[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (22))){
var inst_54167 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_54168 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_54169 = cljs.core.PersistentHashMap.fromArrays(inst_54167,inst_54168);
var inst_54170 = cljs.core.ex_info.call(null,"Aborted operations",inst_54169);
var state_54192__$1 = state_54192;
var statearr_54209_54255 = state_54192__$1;
(statearr_54209_54255[(2)] = inst_54170);

(statearr_54209_54255[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (6))){
var inst_54115 = (state_54192[(7)]);
var inst_54121 = superv.async._track_exception.call(null,S,inst_54115);
var state_54192__$1 = state_54192;
var statearr_54210_54256 = state_54192__$1;
(statearr_54210_54256[(2)] = inst_54121);

(statearr_54210_54256[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (25))){
var inst_54173 = (state_54192[(2)]);
var state_54192__$1 = state_54192;
var statearr_54211_54257 = state_54192__$1;
(statearr_54211_54257[(2)] = inst_54173);

(statearr_54211_54257[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (17))){
var inst_54151 = (state_54192[(13)]);
var inst_54150 = (state_54192[(2)]);
var inst_54151__$1 = superv.async.throw_if_exception.call(null,S,inst_54150);
var state_54192__$1 = (function (){var statearr_54212 = state_54192;
(statearr_54212[(13)] = inst_54151__$1);

return statearr_54212;
})();
if(cljs.core.truth_(inst_54151__$1)){
var statearr_54213_54258 = state_54192__$1;
(statearr_54213_54258[(1)] = (18));

} else {
var statearr_54214_54259 = state_54192__$1;
(statearr_54214_54259[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (3))){
var inst_54112 = (state_54192[(2)]);
var inst_54113 = superv.async._unregister_go.call(null,S,id__19191__auto___54243);
var state_54192__$1 = (function (){var statearr_54215 = state_54192;
(statearr_54215[(14)] = inst_54113);

(statearr_54215[(15)] = inst_54112);

return statearr_54215;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54192__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (12))){
var inst_54184 = cljs.core.async.close_BANG_.call(null,out);
var state_54192__$1 = state_54192;
var statearr_54216_54260 = state_54192__$1;
(statearr_54216_54260[(2)] = inst_54184);

(statearr_54216_54260[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (2))){
var inst_54190 = (state_54192[(2)]);
var state_54192__$1 = state_54192;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54192__$1,inst_54190);
} else {
if((state_val_54193 === (23))){
var inst_54151 = (state_54192[(13)]);
var state_54192__$1 = state_54192;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54192__$1,(25),out,inst_54151);
} else {
if((state_val_54193 === (19))){
var inst_54127 = (state_54192[(9)]);
var inst_54179 = cljs.core.rest.call(null,inst_54127);
var inst_54127__$1 = inst_54179;
var state_54192__$1 = (function (){var statearr_54217 = state_54192;
(statearr_54217[(9)] = inst_54127__$1);

return statearr_54217;
})();
var statearr_54218_54261 = state_54192__$1;
(statearr_54218_54261[(2)] = null);

(statearr_54218_54261[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (11))){
var inst_54134 = (state_54192[(16)]);
var inst_54129 = (state_54192[(17)]);
var inst_54134__$1 = superv.async._abort.call(null,S);
var inst_54135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54136 = [inst_54134__$1,inst_54129];
var inst_54137 = (new cljs.core.PersistentVector(null,2,(5),inst_54135,inst_54136,null));
var state_54192__$1 = (function (){var statearr_54219 = state_54192;
(statearr_54219[(16)] = inst_54134__$1);

return statearr_54219;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_54192__$1,(14),inst_54137,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_54193 === (9))){
var inst_54127 = (state_54192[(9)]);
var inst_54129 = (state_54192[(17)]);
var inst_54129__$1 = cljs.core.first.call(null,inst_54127);
var state_54192__$1 = (function (){var statearr_54220 = state_54192;
(statearr_54220[(17)] = inst_54129__$1);

return statearr_54220;
})();
if(cljs.core.truth_(inst_54129__$1)){
var statearr_54221_54262 = state_54192__$1;
(statearr_54221_54262[(1)] = (11));

} else {
var statearr_54222_54263 = state_54192__$1;
(statearr_54222_54263[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (5))){
var state_54192__$1 = state_54192;
var statearr_54223_54264 = state_54192__$1;
(statearr_54223_54264[(2)] = null);

(statearr_54223_54264[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (14))){
var inst_54134 = (state_54192[(16)]);
var inst_54139 = (state_54192[(2)]);
var inst_54140 = cljs.core.nth.call(null,inst_54139,(0),null);
var inst_54141 = cljs.core.nth.call(null,inst_54139,(1),null);
var inst_54142 = cljs.core._EQ_.call(null,inst_54141,inst_54134);
var state_54192__$1 = (function (){var statearr_54224 = state_54192;
(statearr_54224[(18)] = inst_54140);

return statearr_54224;
})();
if(inst_54142){
var statearr_54225_54265 = state_54192__$1;
(statearr_54225_54265[(1)] = (15));

} else {
var statearr_54226_54266 = state_54192__$1;
(statearr_54226_54266[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (16))){
var inst_54140 = (state_54192[(18)]);
var state_54192__$1 = state_54192;
var statearr_54227_54267 = state_54192__$1;
(statearr_54227_54267[(2)] = inst_54140);

(statearr_54227_54267[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (10))){
var inst_54188 = (state_54192[(2)]);
var state_54192__$1 = state_54192;
var statearr_54228_54268 = state_54192__$1;
(statearr_54228_54268[(2)] = inst_54188);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54192__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54193 === (18))){
var inst_54156 = (state_54192[(11)]);
var inst_54156__$1 = superv.async._abort.call(null,S);
var inst_54157 = cljs.core.async.timeout.call(null,(0));
var inst_54158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54159 = [inst_54156__$1,inst_54157];
var inst_54160 = (new cljs.core.PersistentVector(null,2,(5),inst_54158,inst_54159,null));
var state_54192__$1 = (function (){var statearr_54229 = state_54192;
(statearr_54229[(11)] = inst_54156__$1);

return statearr_54229;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_54192__$1,(21),inst_54160,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_54193 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_54192,(4),Error,(3),(2));
var inst_54127 = cs;
var state_54192__$1 = (function (){var statearr_54230 = state_54192;
(statearr_54230[(9)] = inst_54127);

return statearr_54230;
})();
var statearr_54231_54269 = state_54192__$1;
(statearr_54231_54269[(2)] = null);

(statearr_54231_54269[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___54244,c__19190__auto___54242,id__19191__auto___54243,out))
;
return ((function (switch__33364__auto__,c__33478__auto___54244,c__19190__auto___54242,id__19191__auto___54243,out){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_54235 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54235[(0)] = superv$async$state_machine__33365__auto__);

(statearr_54235[(1)] = (1));

return statearr_54235;
});
var superv$async$state_machine__33365__auto____1 = (function (state_54192){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_54192);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e54236){if((e54236 instanceof Object)){
var ex__33368__auto__ = e54236;
var statearr_54237_54270 = state_54192;
(statearr_54237_54270[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54192);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54236;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54271 = state_54192;
state_54192 = G__54271;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_54192){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_54192);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___54244,c__19190__auto___54242,id__19191__auto___54243,out))
})();
var state__33480__auto__ = (function (){var statearr_54238 = f__33479__auto__.call(null);
(statearr_54238[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___54244);

return statearr_54238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___54244,c__19190__auto___54242,id__19191__auto___54243,out))
);


return out;
});

superv.async.concat_GT__GT_.cljs$lang$maxFixedArity = (1);

superv.async.concat_GT__GT_.cljs$lang$applyTo = (function (seq54110){
var G__54111 = cljs.core.first.call(null,seq54110);
var seq54110__$1 = cljs.core.next.call(null,seq54110);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__54111,seq54110__$1);
});

superv.async.partition_all_GT__GT_ = (function superv$async$partition_all_GT__GT_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___54489 = arguments.length;
var i__10641__auto___54490 = (0);
while(true){
if((i__10641__auto___54490 < len__10640__auto___54489)){
args__10647__auto__.push((arguments[i__10641__auto___54490]));

var G__54491 = (i__10641__auto___54490 + (1));
i__10641__auto___54490 = G__54491;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((3) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((3)),(0),null)):null);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10648__auto__);
});

superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,n,in_ch,p__54276){
var map__54277 = p__54276;
var map__54277__$1 = ((((!((map__54277 == null)))?((((map__54277.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54277.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54277):map__54277);
var out_ch = cljs.core.get.call(null,map__54277__$1,new cljs.core.Keyword(null,"out-ch","out-ch",-189045854));

new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(n > (0))], null)], null);

var out_ch__$1 = (function (){var or__9419__auto__ = out_ch;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})();
var c__19190__auto___54492 = superv.async.check_supervisor.call(null,superv.async.S);
var id__19191__auto___54493 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"batch","batch",977610327,null),cljs.core.PersistentVector.EMPTY], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null),cljs.core.list(new cljs.core.Symbol(null,"conj","conj",-1127293942,null),new cljs.core.Symbol(null,"batch","batch",977610327,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.PersistentVector.EMPTY)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"not-empty","not-empty",2029453590,null),new cljs.core.Symbol(null,"batch","batch",977610327,null)),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"batch","batch",977610327,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))))));
var c__33478__auto___54494 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___54494,c__19190__auto___54492,id__19191__auto___54493,out_ch__$1,map__54277,map__54277__$1,out_ch){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___54494,c__19190__auto___54492,id__19191__auto___54493,out_ch__$1,map__54277,map__54277__$1,out_ch){
return (function (state_54421){
var state_val_54422 = (state_54421[(1)]);
if((state_val_54422 === (7))){
var inst_54282 = (state_54421[(7)]);
var inst_54290 = (state_54421[(2)]);
var state_54421__$1 = (function (){var statearr_54423 = state_54421;
(statearr_54423[(8)] = inst_54290);

return statearr_54423;
})();
var statearr_54424_54495 = state_54421__$1;
(statearr_54424_54495[(2)] = inst_54282);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54421__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (20))){
var inst_54382 = (state_54421[(2)]);
var state_54421__$1 = state_54421;
var statearr_54425_54496 = state_54421__$1;
(statearr_54425_54496[(2)] = inst_54382);

(statearr_54425_54496[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (27))){
var inst_54347 = (state_54421[(9)]);
var inst_54295 = inst_54347;
var state_54421__$1 = (function (){var statearr_54426 = state_54421;
(statearr_54426[(10)] = inst_54295);

return statearr_54426;
})();
var statearr_54427_54497 = state_54421__$1;
(statearr_54427_54497[(2)] = null);

(statearr_54427_54497[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (1))){
var state_54421__$1 = state_54421;
var statearr_54428_54498 = state_54421__$1;
(statearr_54428_54498[(2)] = null);

(statearr_54428_54498[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (24))){
var inst_54343 = (state_54421[(2)]);
var inst_54344 = superv.async.throw_if_exception.call(null,S,inst_54343);
var inst_54345 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_54421__$1 = (function (){var statearr_54429 = state_54421;
(statearr_54429[(11)] = inst_54344);

return statearr_54429;
})();
var statearr_54430_54499 = state_54421__$1;
(statearr_54430_54499[(2)] = inst_54345);

(statearr_54430_54499[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (39))){
var inst_54295 = (state_54421[(10)]);
var state_54421__$1 = state_54421;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54421__$1,(41),out_ch__$1,inst_54295);
} else {
if((state_val_54422 === (4))){
var inst_54282 = (state_54421[(7)]);
var inst_54282__$1 = (state_54421[(2)]);
var inst_54283 = cljs.core.ex_data.call(null,inst_54282__$1);
var inst_54284 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_54283);
var inst_54285 = cljs.core._EQ_.call(null,inst_54284,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_54421__$1 = (function (){var statearr_54431 = state_54421;
(statearr_54431[(7)] = inst_54282__$1);

return statearr_54431;
})();
if(inst_54285){
var statearr_54432_54500 = state_54421__$1;
(statearr_54432_54500[(1)] = (5));

} else {
var statearr_54433_54501 = state_54421__$1;
(statearr_54433_54501[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (15))){
var inst_54317 = (state_54421[(12)]);
var inst_54319 = (inst_54317 instanceof Error);
var state_54421__$1 = state_54421;
if(cljs.core.truth_(inst_54319)){
var statearr_54434_54502 = state_54421__$1;
(statearr_54434_54502[(1)] = (18));

} else {
var statearr_54435_54503 = state_54421__$1;
(statearr_54435_54503[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (21))){
var inst_54324 = (state_54421[(13)]);
var inst_54330 = (state_54421[(2)]);
var inst_54331 = cljs.core.nth.call(null,inst_54330,(0),null);
var inst_54332 = cljs.core.nth.call(null,inst_54330,(1),null);
var inst_54333 = cljs.core._EQ_.call(null,inst_54332,inst_54324);
var state_54421__$1 = (function (){var statearr_54436 = state_54421;
(statearr_54436[(14)] = inst_54331);

return statearr_54436;
})();
if(inst_54333){
var statearr_54437_54504 = state_54421__$1;
(statearr_54437_54504[(1)] = (22));

} else {
var statearr_54438_54505 = state_54421__$1;
(statearr_54438_54505[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (31))){
var inst_54347 = (state_54421[(9)]);
var state_54421__$1 = state_54421;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54421__$1,(33),out_ch__$1,inst_54347);
} else {
if((state_val_54422 === (32))){
var inst_54373 = (state_54421[(2)]);
var inst_54374 = superv.async.throw_if_exception.call(null,S,inst_54373);
var inst_54375 = cljs.core.PersistentVector.EMPTY;
var inst_54295 = inst_54375;
var state_54421__$1 = (function (){var statearr_54439 = state_54421;
(statearr_54439[(15)] = inst_54374);

(statearr_54439[(10)] = inst_54295);

return statearr_54439;
})();
var statearr_54440_54506 = state_54421__$1;
(statearr_54440_54506[(2)] = null);

(statearr_54440_54506[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (40))){
var inst_54408 = (state_54421[(2)]);
var inst_54409 = superv.async.throw_if_exception.call(null,S,inst_54408);
var state_54421__$1 = state_54421;
var statearr_54441_54507 = state_54421__$1;
(statearr_54441_54507[(2)] = inst_54409);

(statearr_54441_54507[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (33))){
var inst_54371 = (state_54421[(2)]);
var state_54421__$1 = state_54421;
var statearr_54442_54508 = state_54421__$1;
(statearr_54442_54508[(2)] = inst_54371);

(statearr_54442_54508[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (13))){
var inst_54306 = (state_54421[(16)]);
var state_54421__$1 = state_54421;
var statearr_54443_54509 = state_54421__$1;
(statearr_54443_54509[(2)] = inst_54306);

(statearr_54443_54509[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (22))){
var inst_54335 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_54336 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_54337 = cljs.core.PersistentHashMap.fromArrays(inst_54335,inst_54336);
var inst_54338 = cljs.core.ex_info.call(null,"Aborted operations",inst_54337);
var state_54421__$1 = state_54421;
var statearr_54444_54510 = state_54421__$1;
(statearr_54444_54510[(2)] = inst_54338);

(statearr_54444_54510[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (36))){
var inst_54412 = (state_54421[(2)]);
var inst_54413 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_54421__$1 = (function (){var statearr_54445 = state_54421;
(statearr_54445[(17)] = inst_54412);

return statearr_54445;
})();
var statearr_54446_54511 = state_54421__$1;
(statearr_54446_54511[(2)] = inst_54413);

(statearr_54446_54511[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (41))){
var inst_54406 = (state_54421[(2)]);
var state_54421__$1 = state_54421;
var statearr_54447_54512 = state_54421__$1;
(statearr_54447_54512[(2)] = inst_54406);

(statearr_54447_54512[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (29))){
var inst_54354 = (state_54421[(18)]);
var inst_54360 = (state_54421[(2)]);
var inst_54361 = cljs.core.nth.call(null,inst_54360,(0),null);
var inst_54362 = cljs.core.nth.call(null,inst_54360,(1),null);
var inst_54363 = cljs.core._EQ_.call(null,inst_54362,inst_54354);
var state_54421__$1 = (function (){var statearr_54448 = state_54421;
(statearr_54448[(19)] = inst_54361);

return statearr_54448;
})();
if(inst_54363){
var statearr_54449_54513 = state_54421__$1;
(statearr_54449_54513[(1)] = (30));

} else {
var statearr_54450_54514 = state_54421__$1;
(statearr_54450_54514[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (6))){
var inst_54282 = (state_54421[(7)]);
var inst_54288 = superv.async._track_exception.call(null,S,inst_54282);
var state_54421__$1 = state_54421;
var statearr_54451_54515 = state_54421__$1;
(statearr_54451_54515[(2)] = inst_54288);

(statearr_54451_54515[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (28))){
var inst_54380 = (state_54421[(2)]);
var state_54421__$1 = state_54421;
var statearr_54452_54516 = state_54421__$1;
(statearr_54452_54516[(2)] = inst_54380);

(statearr_54452_54516[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (25))){
var inst_54341 = (state_54421[(2)]);
var state_54421__$1 = state_54421;
var statearr_54453_54517 = state_54421__$1;
(statearr_54453_54517[(2)] = inst_54341);

(statearr_54453_54517[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (34))){
var inst_54389 = (state_54421[(20)]);
var inst_54389__$1 = superv.async._abort.call(null,S);
var inst_54390 = cljs.core.async.timeout.call(null,(0));
var inst_54391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54392 = [inst_54389__$1,inst_54390];
var inst_54393 = (new cljs.core.PersistentVector(null,2,(5),inst_54391,inst_54392,null));
var state_54421__$1 = (function (){var statearr_54454 = state_54421;
(statearr_54454[(20)] = inst_54389__$1);

return statearr_54454;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_54421__$1,(37),inst_54393,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_54422 === (17))){
var inst_54415 = (state_54421[(2)]);
var state_54421__$1 = state_54421;
var statearr_54455_54518 = state_54421__$1;
(statearr_54455_54518[(2)] = inst_54415);

(statearr_54455_54518[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (3))){
var inst_54279 = (state_54421[(2)]);
var inst_54280 = superv.async._unregister_go.call(null,S,id__19191__auto___54493);
var state_54421__$1 = (function (){var statearr_54456 = state_54421;
(statearr_54456[(21)] = inst_54279);

(statearr_54456[(22)] = inst_54280);

return statearr_54456;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54421__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (12))){
var inst_54310 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_54311 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_54312 = cljs.core.PersistentHashMap.fromArrays(inst_54310,inst_54311);
var inst_54313 = cljs.core.ex_info.call(null,"Aborted operations",inst_54312);
var state_54421__$1 = state_54421;
var statearr_54457_54519 = state_54421__$1;
(statearr_54457_54519[(2)] = inst_54313);

(statearr_54457_54519[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (2))){
var inst_54419 = (state_54421[(2)]);
var state_54421__$1 = state_54421;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54421__$1,inst_54419);
} else {
if((state_val_54422 === (23))){
var inst_54317 = (state_54421[(12)]);
var state_54421__$1 = state_54421;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54421__$1,(25),out_ch__$1,inst_54317);
} else {
if((state_val_54422 === (35))){
var state_54421__$1 = state_54421;
var statearr_54458_54520 = state_54421__$1;
(statearr_54458_54520[(2)] = null);

(statearr_54458_54520[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (19))){
var inst_54347 = (state_54421[(9)]);
var inst_54317 = (state_54421[(12)]);
var inst_54295 = (state_54421[(10)]);
var inst_54347__$1 = cljs.core.conj.call(null,inst_54295,inst_54317);
var inst_54348 = cljs.core.count.call(null,inst_54347__$1);
var inst_54349 = cljs.core._EQ_.call(null,n,inst_54348);
var state_54421__$1 = (function (){var statearr_54459 = state_54421;
(statearr_54459[(9)] = inst_54347__$1);

return statearr_54459;
})();
if(inst_54349){
var statearr_54460_54521 = state_54421__$1;
(statearr_54460_54521[(1)] = (26));

} else {
var statearr_54461_54522 = state_54421__$1;
(statearr_54461_54522[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (11))){
var inst_54300 = (state_54421[(23)]);
var inst_54305 = (state_54421[(2)]);
var inst_54306 = cljs.core.nth.call(null,inst_54305,(0),null);
var inst_54307 = cljs.core.nth.call(null,inst_54305,(1),null);
var inst_54308 = cljs.core._EQ_.call(null,inst_54307,inst_54300);
var state_54421__$1 = (function (){var statearr_54462 = state_54421;
(statearr_54462[(16)] = inst_54306);

return statearr_54462;
})();
if(inst_54308){
var statearr_54463_54523 = state_54421__$1;
(statearr_54463_54523[(1)] = (12));

} else {
var statearr_54464_54524 = state_54421__$1;
(statearr_54464_54524[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (9))){
var inst_54300 = (state_54421[(23)]);
var inst_54300__$1 = superv.async._abort.call(null,S);
var inst_54301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54302 = [inst_54300__$1,in_ch];
var inst_54303 = (new cljs.core.PersistentVector(null,2,(5),inst_54301,inst_54302,null));
var state_54421__$1 = (function (){var statearr_54465 = state_54421;
(statearr_54465[(23)] = inst_54300__$1);

return statearr_54465;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_54421__$1,(11),inst_54303,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_54422 === (5))){
var state_54421__$1 = state_54421;
var statearr_54466_54525 = state_54421__$1;
(statearr_54466_54525[(2)] = null);

(statearr_54466_54525[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (14))){
var inst_54317 = (state_54421[(12)]);
var inst_54316 = (state_54421[(2)]);
var inst_54317__$1 = superv.async.throw_if_exception.call(null,S,inst_54316);
var state_54421__$1 = (function (){var statearr_54467 = state_54421;
(statearr_54467[(12)] = inst_54317__$1);

return statearr_54467;
})();
if(cljs.core.truth_(inst_54317__$1)){
var statearr_54468_54526 = state_54421__$1;
(statearr_54468_54526[(1)] = (15));

} else {
var statearr_54469_54527 = state_54421__$1;
(statearr_54469_54527[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (26))){
var inst_54354 = (state_54421[(18)]);
var inst_54354__$1 = superv.async._abort.call(null,S);
var inst_54355 = cljs.core.async.timeout.call(null,(0));
var inst_54356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54357 = [inst_54354__$1,inst_54355];
var inst_54358 = (new cljs.core.PersistentVector(null,2,(5),inst_54356,inst_54357,null));
var state_54421__$1 = (function (){var statearr_54470 = state_54421;
(statearr_54470[(18)] = inst_54354__$1);

return statearr_54470;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_54421__$1,(29),inst_54358,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_54422 === (16))){
var inst_54295 = (state_54421[(10)]);
var inst_54384 = cljs.core.not_empty.call(null,inst_54295);
var state_54421__$1 = state_54421;
if(cljs.core.truth_(inst_54384)){
var statearr_54471_54528 = state_54421__$1;
(statearr_54471_54528[(1)] = (34));

} else {
var statearr_54472_54529 = state_54421__$1;
(statearr_54472_54529[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (38))){
var inst_54400 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_54401 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_54402 = cljs.core.PersistentHashMap.fromArrays(inst_54400,inst_54401);
var inst_54403 = cljs.core.ex_info.call(null,"Aborted operations",inst_54402);
var state_54421__$1 = state_54421;
var statearr_54473_54530 = state_54421__$1;
(statearr_54473_54530[(2)] = inst_54403);

(statearr_54473_54530[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (30))){
var inst_54365 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_54366 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_54367 = cljs.core.PersistentHashMap.fromArrays(inst_54365,inst_54366);
var inst_54368 = cljs.core.ex_info.call(null,"Aborted operations",inst_54367);
var state_54421__$1 = state_54421;
var statearr_54474_54531 = state_54421__$1;
(statearr_54474_54531[(2)] = inst_54368);

(statearr_54474_54531[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (10))){
var inst_54417 = (state_54421[(2)]);
var state_54421__$1 = state_54421;
var statearr_54475_54532 = state_54421__$1;
(statearr_54475_54532[(2)] = inst_54417);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54421__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (18))){
var inst_54324 = (state_54421[(13)]);
var inst_54324__$1 = superv.async._abort.call(null,S);
var inst_54325 = cljs.core.async.timeout.call(null,(0));
var inst_54326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54327 = [inst_54324__$1,inst_54325];
var inst_54328 = (new cljs.core.PersistentVector(null,2,(5),inst_54326,inst_54327,null));
var state_54421__$1 = (function (){var statearr_54476 = state_54421;
(statearr_54476[(13)] = inst_54324__$1);

return statearr_54476;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_54421__$1,(21),inst_54328,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_54422 === (37))){
var inst_54389 = (state_54421[(20)]);
var inst_54395 = (state_54421[(2)]);
var inst_54396 = cljs.core.nth.call(null,inst_54395,(0),null);
var inst_54397 = cljs.core.nth.call(null,inst_54395,(1),null);
var inst_54398 = cljs.core._EQ_.call(null,inst_54397,inst_54389);
var state_54421__$1 = (function (){var statearr_54477 = state_54421;
(statearr_54477[(24)] = inst_54396);

return statearr_54477;
})();
if(inst_54398){
var statearr_54478_54533 = state_54421__$1;
(statearr_54478_54533[(1)] = (38));

} else {
var statearr_54479_54534 = state_54421__$1;
(statearr_54479_54534[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54422 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_54421,(4),Error,(3),(2));
var inst_54294 = cljs.core.PersistentVector.EMPTY;
var inst_54295 = inst_54294;
var state_54421__$1 = (function (){var statearr_54480 = state_54421;
(statearr_54480[(10)] = inst_54295);

return statearr_54480;
})();
var statearr_54481_54535 = state_54421__$1;
(statearr_54481_54535[(2)] = null);

(statearr_54481_54535[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___54494,c__19190__auto___54492,id__19191__auto___54493,out_ch__$1,map__54277,map__54277__$1,out_ch))
;
return ((function (switch__33364__auto__,c__33478__auto___54494,c__19190__auto___54492,id__19191__auto___54493,out_ch__$1,map__54277,map__54277__$1,out_ch){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_54485 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54485[(0)] = superv$async$state_machine__33365__auto__);

(statearr_54485[(1)] = (1));

return statearr_54485;
});
var superv$async$state_machine__33365__auto____1 = (function (state_54421){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_54421);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e54486){if((e54486 instanceof Object)){
var ex__33368__auto__ = e54486;
var statearr_54487_54536 = state_54421;
(statearr_54487_54536[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54421);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54486;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54537 = state_54421;
state_54421 = G__54537;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_54421){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_54421);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___54494,c__19190__auto___54492,id__19191__auto___54493,out_ch__$1,map__54277,map__54277__$1,out_ch))
})();
var state__33480__auto__ = (function (){var statearr_54488 = f__33479__auto__.call(null);
(statearr_54488[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___54494);

return statearr_54488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___54494,c__19190__auto___54492,id__19191__auto___54493,out_ch__$1,map__54277,map__54277__$1,out_ch))
);


return out_ch__$1;
});

superv.async.partition_all_GT__GT_.cljs$lang$maxFixedArity = (3);

superv.async.partition_all_GT__GT_.cljs$lang$applyTo = (function (seq54272){
var G__54273 = cljs.core.first.call(null,seq54272);
var seq54272__$1 = cljs.core.next.call(null,seq54272);
var G__54274 = cljs.core.first.call(null,seq54272__$1);
var seq54272__$2 = cljs.core.next.call(null,seq54272__$1);
var G__54275 = cljs.core.first.call(null,seq54272__$2);
var seq54272__$3 = cljs.core.next.call(null,seq54272__$2);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__54273,G__54274,G__54275,seq54272__$3);
});

/**
 * Counts items in a channel. Returns a channel with the item count.
 */
superv.async.count_GT_ = (function superv$async$count_GT_(S,ch){
return cljs.core.async.reduce.call(null,(function (acc,obj){
if((obj instanceof Error)){
return superv.async.put_QMARK_.call(null,S,superv.async._error.call(null,S),obj);
} else {
return (acc + (1));
}
}),(0),ch);
});
/**
 * Debounces channel. Forwards first item from input channel to output
 *   immediately. After that one item every interval ms (if any). If there are more
 *   items in between, they are dropped.
 */
superv.async.debounce_GT__GT_ = (function superv$async$debounce_GT__GT_(S,ch,interval){
var out = cljs.core.async.chan.call(null);
var c__19190__auto___54856 = superv.async.check_supervisor.call(null,superv.async.S);
var id__19191__auto___54857 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),null], null),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol("async","timeout","async/timeout",1951904349,null),new cljs.core.Symbol(null,"interval","interval",-945940352,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null)),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-val","new-val",902372928,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null),cljs.core.list(new cljs.core.Symbol(null,"alts?","alts?",1625745590,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null)], null))], null),cljs.core.list(new cljs.core.Symbol(null,"condp","condp",1054325175,null),new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)))))))));
var c__33478__auto___54858 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___54858,c__19190__auto___54856,id__19191__auto___54857,out){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___54858,c__19190__auto___54856,id__19191__auto___54857,out){
return (function (state_54802){
var state_val_54803 = (state_54802[(1)]);
if((state_val_54803 === (7))){
var inst_54700 = (state_54802[(7)]);
var inst_54708 = (state_54802[(2)]);
var state_54802__$1 = (function (){var statearr_54804 = state_54802;
(statearr_54804[(8)] = inst_54708);

return statearr_54804;
})();
var statearr_54805_54859 = state_54802__$1;
(statearr_54805_54859[(2)] = inst_54700);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54802__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (20))){
var inst_54796 = (state_54802[(2)]);
var state_54802__$1 = state_54802;
var statearr_54806_54860 = state_54802__$1;
(statearr_54806_54860[(2)] = inst_54796);

(statearr_54806_54860[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (27))){
var inst_54780 = (state_54802[(2)]);
var inst_54781 = superv.async.throw_if_exception.call(null,S,inst_54780);
var inst_54712 = null;
var state_54802__$1 = (function (){var statearr_54807 = state_54802;
(statearr_54807[(9)] = inst_54712);

(statearr_54807[(10)] = inst_54781);

return statearr_54807;
})();
var statearr_54808_54861 = state_54802__$1;
(statearr_54808_54861[(2)] = null);

(statearr_54808_54861[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (1))){
var state_54802__$1 = state_54802;
var statearr_54809_54862 = state_54802__$1;
(statearr_54809_54862[(2)] = null);

(statearr_54809_54862[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (24))){
var inst_54761 = (state_54802[(11)]);
var inst_54767 = (state_54802[(2)]);
var inst_54768 = cljs.core.nth.call(null,inst_54767,(0),null);
var inst_54769 = cljs.core.nth.call(null,inst_54767,(1),null);
var inst_54770 = cljs.core._EQ_.call(null,inst_54769,inst_54761);
var state_54802__$1 = (function (){var statearr_54810 = state_54802;
(statearr_54810[(12)] = inst_54768);

return statearr_54810;
})();
if(inst_54770){
var statearr_54811_54863 = state_54802__$1;
(statearr_54811_54863[(1)] = (25));

} else {
var statearr_54812_54864 = state_54802__$1;
(statearr_54812_54864[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (4))){
var inst_54700 = (state_54802[(7)]);
var inst_54700__$1 = (state_54802[(2)]);
var inst_54701 = cljs.core.ex_data.call(null,inst_54700__$1);
var inst_54702 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_54701);
var inst_54703 = cljs.core._EQ_.call(null,inst_54702,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_54802__$1 = (function (){var statearr_54813 = state_54802;
(statearr_54813[(7)] = inst_54700__$1);

return statearr_54813;
})();
if(inst_54703){
var statearr_54814_54865 = state_54802__$1;
(statearr_54814_54865[(1)] = (5));

} else {
var statearr_54815_54866 = state_54802__$1;
(statearr_54815_54866[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (15))){
var inst_54729 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_54730 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_54731 = cljs.core.PersistentHashMap.fromArrays(inst_54729,inst_54730);
var inst_54732 = cljs.core.ex_info.call(null,"Aborted operations",inst_54731);
var state_54802__$1 = state_54802;
var statearr_54816_54867 = state_54802__$1;
(statearr_54816_54867[(2)] = inst_54732);

(statearr_54816_54867[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (21))){
var inst_54761 = (state_54802[(11)]);
var inst_54761__$1 = superv.async._abort.call(null,S);
var inst_54762 = cljs.core.async.timeout.call(null,(0));
var inst_54763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54764 = [inst_54761__$1,inst_54762];
var inst_54765 = (new cljs.core.PersistentVector(null,2,(5),inst_54763,inst_54764,null));
var state_54802__$1 = (function (){var statearr_54817 = state_54802;
(statearr_54817[(11)] = inst_54761__$1);

return statearr_54817;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_54802__$1,(24),inst_54765,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_54803 === (31))){
var inst_54792 = (state_54802[(2)]);
var state_54802__$1 = state_54802;
var statearr_54818_54868 = state_54802__$1;
(statearr_54818_54868[(2)] = inst_54792);

(statearr_54818_54868[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (13))){
var inst_54738 = (state_54802[(13)]);
var inst_54738__$1 = (state_54802[(2)]);
var inst_54739 = cljs.core.async.timeout.call(null,interval);
var inst_54740 = (inst_54738__$1 == null);
var state_54802__$1 = (function (){var statearr_54819 = state_54802;
(statearr_54819[(13)] = inst_54738__$1);

(statearr_54819[(14)] = inst_54739);

return statearr_54819;
})();
if(cljs.core.truth_(inst_54740)){
var statearr_54820_54869 = state_54802__$1;
(statearr_54820_54869[(1)] = (18));

} else {
var statearr_54821_54870 = state_54802__$1;
(statearr_54821_54870[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (22))){
var inst_54752 = (state_54802[(15)]);
var inst_54784 = cljs.core._EQ_.call(null,inst_54752,inst_54752);
var state_54802__$1 = state_54802;
if(inst_54784){
var statearr_54822_54871 = state_54802__$1;
(statearr_54822_54871[(1)] = (29));

} else {
var statearr_54823_54872 = state_54802__$1;
(statearr_54823_54872[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (29))){
var inst_54751 = (state_54802[(16)]);
var inst_54712 = inst_54751;
var state_54802__$1 = (function (){var statearr_54824 = state_54802;
(statearr_54824[(9)] = inst_54712);

return statearr_54824;
})();
var statearr_54825_54873 = state_54802__$1;
(statearr_54825_54873[(2)] = null);

(statearr_54825_54873[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (6))){
var inst_54700 = (state_54802[(7)]);
var inst_54706 = superv.async._track_exception.call(null,S,inst_54700);
var state_54802__$1 = state_54802;
var statearr_54826_54874 = state_54802__$1;
(statearr_54826_54874[(2)] = inst_54706);

(statearr_54826_54874[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (28))){
var inst_54778 = (state_54802[(2)]);
var state_54802__$1 = state_54802;
var statearr_54827_54875 = state_54802__$1;
(statearr_54827_54875[(2)] = inst_54778);

(statearr_54827_54875[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (25))){
var inst_54772 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_54773 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_54774 = cljs.core.PersistentHashMap.fromArrays(inst_54772,inst_54773);
var inst_54775 = cljs.core.ex_info.call(null,"Aborted operations",inst_54774);
var state_54802__$1 = state_54802;
var statearr_54828_54876 = state_54802__$1;
(statearr_54828_54876[(2)] = inst_54775);

(statearr_54828_54876[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (17))){
var inst_54735 = (state_54802[(2)]);
var inst_54736 = superv.async.throw_if_exception.call(null,S,inst_54735);
var state_54802__$1 = state_54802;
var statearr_54829_54877 = state_54802__$1;
(statearr_54829_54877[(2)] = inst_54736);

(statearr_54829_54877[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (3))){
var inst_54697 = (state_54802[(2)]);
var inst_54698 = superv.async._unregister_go.call(null,S,id__19191__auto___54857);
var state_54802__$1 = (function (){var statearr_54830 = state_54802;
(statearr_54830[(17)] = inst_54697);

(statearr_54830[(18)] = inst_54698);

return statearr_54830;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54802__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (12))){
var inst_54719 = (state_54802[(19)]);
var inst_54719__$1 = superv.async._abort.call(null,S);
var inst_54720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54721 = [inst_54719__$1,ch];
var inst_54722 = (new cljs.core.PersistentVector(null,2,(5),inst_54720,inst_54721,null));
var state_54802__$1 = (function (){var statearr_54831 = state_54802;
(statearr_54831[(19)] = inst_54719__$1);

return statearr_54831;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_54802__$1,(14),inst_54722,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_54803 === (2))){
var inst_54800 = (state_54802[(2)]);
var state_54802__$1 = state_54802;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54802__$1,inst_54800);
} else {
if((state_val_54803 === (23))){
var inst_54794 = (state_54802[(2)]);
var state_54802__$1 = state_54802;
var statearr_54832_54878 = state_54802__$1;
(statearr_54832_54878[(2)] = inst_54794);

(statearr_54832_54878[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (19))){
var inst_54752 = (state_54802[(15)]);
var inst_54739 = (state_54802[(14)]);
var inst_54747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54748 = [ch,inst_54739];
var inst_54749 = (new cljs.core.PersistentVector(null,2,(5),inst_54747,inst_54748,null));
var inst_54750 = superv.async.alts_QMARK_.call(null,S,inst_54749);
var inst_54751 = cljs.core.nth.call(null,inst_54750,(0),null);
var inst_54752__$1 = cljs.core.nth.call(null,inst_54750,(1),null);
var inst_54756 = cljs.core._EQ_.call(null,inst_54739,inst_54752__$1);
var state_54802__$1 = (function (){var statearr_54833 = state_54802;
(statearr_54833[(15)] = inst_54752__$1);

(statearr_54833[(16)] = inst_54751);

return statearr_54833;
})();
if(inst_54756){
var statearr_54834_54879 = state_54802__$1;
(statearr_54834_54879[(1)] = (21));

} else {
var statearr_54835_54880 = state_54802__$1;
(statearr_54835_54880[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (11))){
var inst_54712 = (state_54802[(9)]);
var state_54802__$1 = state_54802;
var statearr_54836_54881 = state_54802__$1;
(statearr_54836_54881[(2)] = inst_54712);

(statearr_54836_54881[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (9))){
var inst_54712 = (state_54802[(9)]);
var state_54802__$1 = state_54802;
if(cljs.core.truth_(inst_54712)){
var statearr_54837_54882 = state_54802__$1;
(statearr_54837_54882[(1)] = (11));

} else {
var statearr_54838_54883 = state_54802__$1;
(statearr_54838_54883[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (5))){
var state_54802__$1 = state_54802;
var statearr_54839_54884 = state_54802__$1;
(statearr_54839_54884[(2)] = null);

(statearr_54839_54884[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (14))){
var inst_54719 = (state_54802[(19)]);
var inst_54724 = (state_54802[(2)]);
var inst_54725 = cljs.core.nth.call(null,inst_54724,(0),null);
var inst_54726 = cljs.core.nth.call(null,inst_54724,(1),null);
var inst_54727 = cljs.core._EQ_.call(null,inst_54726,inst_54719);
var state_54802__$1 = (function (){var statearr_54840 = state_54802;
(statearr_54840[(20)] = inst_54725);

return statearr_54840;
})();
if(inst_54727){
var statearr_54841_54885 = state_54802__$1;
(statearr_54841_54885[(1)] = (15));

} else {
var statearr_54842_54886 = state_54802__$1;
(statearr_54842_54886[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (26))){
var inst_54738 = (state_54802[(13)]);
var state_54802__$1 = state_54802;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54802__$1,(28),out,inst_54738);
} else {
if((state_val_54803 === (16))){
var inst_54725 = (state_54802[(20)]);
var state_54802__$1 = state_54802;
var statearr_54843_54887 = state_54802__$1;
(statearr_54843_54887[(2)] = inst_54725);

(statearr_54843_54887[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (30))){
var inst_54752 = (state_54802[(15)]);
var inst_54788 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_54752)].join('');
var inst_54789 = (new Error(inst_54788));
var inst_54790 = (function(){throw inst_54789})();
var state_54802__$1 = state_54802;
var statearr_54844_54888 = state_54802__$1;
(statearr_54844_54888[(2)] = inst_54790);

(statearr_54844_54888[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (10))){
var inst_54798 = (state_54802[(2)]);
var state_54802__$1 = state_54802;
var statearr_54845_54889 = state_54802__$1;
(statearr_54845_54889[(2)] = inst_54798);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54802__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (18))){
var inst_54742 = cljs.core.async.close_BANG_.call(null,out);
var state_54802__$1 = state_54802;
var statearr_54846_54890 = state_54802__$1;
(statearr_54846_54890[(2)] = inst_54742);

(statearr_54846_54890[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54803 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_54802,(4),Error,(3),(2));
var inst_54712 = null;
var state_54802__$1 = (function (){var statearr_54847 = state_54802;
(statearr_54847[(9)] = inst_54712);

return statearr_54847;
})();
var statearr_54848_54891 = state_54802__$1;
(statearr_54848_54891[(2)] = null);

(statearr_54848_54891[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___54858,c__19190__auto___54856,id__19191__auto___54857,out))
;
return ((function (switch__33364__auto__,c__33478__auto___54858,c__19190__auto___54856,id__19191__auto___54857,out){
return (function() {
var superv$async$debounce_GT__GT__$_state_machine__33365__auto__ = null;
var superv$async$debounce_GT__GT__$_state_machine__33365__auto____0 = (function (){
var statearr_54852 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54852[(0)] = superv$async$debounce_GT__GT__$_state_machine__33365__auto__);

(statearr_54852[(1)] = (1));

return statearr_54852;
});
var superv$async$debounce_GT__GT__$_state_machine__33365__auto____1 = (function (state_54802){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_54802);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e54853){if((e54853 instanceof Object)){
var ex__33368__auto__ = e54853;
var statearr_54854_54892 = state_54802;
(statearr_54854_54892[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54802);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54853;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54893 = state_54802;
state_54802 = G__54893;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$debounce_GT__GT__$_state_machine__33365__auto__ = function(state_54802){
switch(arguments.length){
case 0:
return superv$async$debounce_GT__GT__$_state_machine__33365__auto____0.call(this);
case 1:
return superv$async$debounce_GT__GT__$_state_machine__33365__auto____1.call(this,state_54802);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$debounce_GT__GT__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$debounce_GT__GT__$_state_machine__33365__auto____0;
superv$async$debounce_GT__GT__$_state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$debounce_GT__GT__$_state_machine__33365__auto____1;
return superv$async$debounce_GT__GT__$_state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___54858,c__19190__auto___54856,id__19191__auto___54857,out))
})();
var state__33480__auto__ = (function (){var statearr_54855 = f__33479__auto__.call(null);
(statearr_54855[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___54858);

return statearr_54855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___54858,c__19190__auto___54856,id__19191__auto___54857,out))
);


return out;
});
/**
 * Safely managed tap. The channel is closed on abortion and all
 *   pending puts are flushed.
 */
superv.async.tap = (function superv$async$tap(var_args){
var args54894 = [];
var len__10640__auto___55032 = arguments.length;
var i__10641__auto___55033 = (0);
while(true){
if((i__10641__auto___55033 < len__10640__auto___55032)){
args54894.push((arguments[i__10641__auto___55033]));

var G__55034 = (i__10641__auto___55033 + (1));
i__10641__auto___55033 = G__55034;
continue;
} else {
}
break;
}

var G__54896 = args54894.length;
switch (G__54896) {
case 3:
return superv.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.tap.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args54894.length)].join('')));

}
});

superv.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (S,mult,ch){
return superv.async.tap.call(null,S,mult,ch,false);
});

superv.async.tap.cljs$core$IFn$_invoke$arity$4 = (function (S,mult,ch,close_QMARK_){
var c__19190__auto___55036 = superv.async.check_supervisor.call(null,superv.async.S);
var id__19191__auto___55037 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__33478__auto___55038 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___55038,c__19190__auto___55036,id__19191__auto___55037){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___55038,c__19190__auto___55036,id__19191__auto___55037){
return (function (state_54975){
var state_val_54976 = (state_54975[(1)]);
if((state_val_54976 === (7))){
var inst_54900 = (state_54975[(7)]);
var inst_54908 = (state_54975[(2)]);
var state_54975__$1 = (function (){var statearr_54977 = state_54975;
(statearr_54977[(8)] = inst_54908);

return statearr_54977;
})();
var statearr_54978_55039 = state_54975__$1;
(statearr_54978_55039[(2)] = inst_54900);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54975__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54976 === (1))){
var state_54975__$1 = state_54975;
var statearr_54979_55040 = state_54975__$1;
(statearr_54979_55040[(2)] = null);

(statearr_54979_55040[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54976 === (4))){
var inst_54900 = (state_54975[(7)]);
var inst_54900__$1 = (state_54975[(2)]);
var inst_54901 = cljs.core.ex_data.call(null,inst_54900__$1);
var inst_54902 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_54901);
var inst_54903 = cljs.core._EQ_.call(null,inst_54902,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_54975__$1 = (function (){var statearr_54980 = state_54975;
(statearr_54980[(7)] = inst_54900__$1);

return statearr_54980;
})();
if(inst_54903){
var statearr_54981_55041 = state_54975__$1;
(statearr_54981_55041[(1)] = (5));

} else {
var statearr_54982_55042 = state_54975__$1;
(statearr_54982_55042[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54976 === (15))){
var inst_54924 = (state_54975[(2)]);
var state_54975__$1 = state_54975;
var statearr_54983_55043 = state_54975__$1;
(statearr_54983_55043[(2)] = inst_54924);

(statearr_54983_55043[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54976 === (13))){
var state_54975__$1 = state_54975;
var statearr_54984_55044 = state_54975__$1;
(statearr_54984_55044[(2)] = null);

(statearr_54984_55044[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54976 === (6))){
var inst_54900 = (state_54975[(7)]);
var inst_54906 = superv.async._track_exception.call(null,S,inst_54900);
var state_54975__$1 = state_54975;
var statearr_54985_55045 = state_54975__$1;
(statearr_54985_55045[(2)] = inst_54906);

(statearr_54985_55045[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54976 === (3))){
var inst_54897 = (state_54975[(2)]);
var inst_54898 = superv.async._unregister_go.call(null,S,id__19191__auto___55037);
var state_54975__$1 = (function (){var statearr_54986 = state_54975;
(statearr_54986[(9)] = inst_54897);

(statearr_54986[(10)] = inst_54898);

return statearr_54986;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54975__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54976 === (12))){
var inst_54919 = (state_54975[(2)]);
var state_54975__$1 = state_54975;
if(cljs.core.truth_(inst_54919)){
var statearr_54987_55046 = state_54975__$1;
(statearr_54987_55046[(1)] = (13));

} else {
var statearr_54988_55047 = state_54975__$1;
(statearr_54988_55047[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54976 === (2))){
var inst_54973 = (state_54975[(2)]);
var state_54975__$1 = state_54975;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54975__$1,inst_54973);
} else {
if((state_val_54976 === (11))){
var inst_54916 = (state_54975[(11)]);
var inst_54926 = (state_54975[(2)]);
var inst_54927 = null;
var inst_54928 = superv.async._register_go.call(null,inst_54926,inst_54927);
var inst_54969 = cljs.core.async.chan.call(null,(1));
var inst_54970 = (function (){var c__19190__auto____$1 = inst_54916;
var id__19191__auto____$1 = inst_54928;
var c__33478__auto____$1 = inst_54969;
return ((function (c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_54916,inst_54926,inst_54927,inst_54928,inst_54969,state_val_54976,c__33478__auto___55038,c__19190__auto___55036,id__19191__auto___55037){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_54916,inst_54926,inst_54927,inst_54928,inst_54969,state_val_54976,c__33478__auto___55038,c__19190__auto___55036,id__19191__auto___55037){
return (function (state_54967){
var state_val_54968 = (state_54967[(1)]);
if((state_val_54968 === (7))){
var state_54967__$1 = state_54967;
var statearr_54989_55048 = state_54967__$1;
(statearr_54989_55048[(2)] = null);

(statearr_54989_55048[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54968 === (20))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_54967,(10),Error,(3),(2));
var state_54967__$1 = state_54967;
var statearr_54990_55049 = state_54967__$1;
(statearr_54990_55049[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54967__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54968 === (1))){
var state_54967__$1 = state_54967;
var statearr_54991_55050 = state_54967__$1;
(statearr_54991_55050[(2)] = null);

(statearr_54991_55050[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54968 === (4))){
var state_54967__$1 = state_54967;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54967__$1,(6),ch);
} else {
if((state_val_54968 === (15))){
var inst_54942 = (state_54967[(7)]);
var inst_54957 = (state_54967[(2)]);
var inst_54958 = superv.async._track_exception.call(null,inst_54957,inst_54942);
var state_54967__$1 = state_54967;
var statearr_54992_55051 = state_54967__$1;
(statearr_54992_55051[(2)] = inst_54958);

(statearr_54992_55051[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54968 === (13))){
var inst_54942 = (state_54967[(7)]);
var inst_54960 = (state_54967[(2)]);
var state_54967__$1 = (function (){var statearr_54993 = state_54967;
(statearr_54993[(8)] = inst_54960);

return statearr_54993;
})();
var statearr_54994_55052 = state_54967__$1;
(statearr_54994_55052[(2)] = inst_54942);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54967__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54968 === (6))){
var inst_54932 = (state_54967[(2)]);
var state_54967__$1 = state_54967;
if(cljs.core.truth_(inst_54932)){
var statearr_54995_55053 = state_54967__$1;
(statearr_54995_55053[(1)] = (7));

} else {
var statearr_54996_55054 = state_54967__$1;
(statearr_54996_55054[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54968 === (17))){
var state_54967__$1 = state_54967;
var statearr_54997_55055 = state_54967__$1;
(statearr_54997_55055[(2)] = null);

(statearr_54997_55055[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54968 === (3))){
var inst_54929 = (state_54967[(2)]);
var state_54967__$1 = (function (){var statearr_54998 = state_54967;
(statearr_54998[(9)] = inst_54929);

return statearr_54998;
})();
var statearr_54999_55056 = state_54967__$1;
(statearr_54999_55056[(2)] = null);

(statearr_54999_55056[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54968 === (12))){
var state_54967__$1 = state_54967;
var statearr_55000_55057 = state_54967__$1;
(statearr_55000_55057[(2)] = null);

(statearr_55000_55057[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54968 === (2))){
var inst_54965 = (state_54967[(2)]);
var state_54967__$1 = state_54967;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54967__$1,inst_54965);
} else {
if((state_val_54968 === (19))){
var inst_54955 = (state_54967[(2)]);
var state_54967__$1 = state_54967;
var statearr_55001_55058 = state_54967__$1;
(statearr_55001_55058[(2)] = inst_54955);

(statearr_55001_55058[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54968 === (11))){
var state_54967__$1 = state_54967;
var statearr_55002_55059 = state_54967__$1;
(statearr_55002_55059[(2)] = null);

(statearr_55002_55059[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54968 === (9))){
var inst_54937 = (state_54967[(2)]);
var state_54967__$1 = state_54967;
var statearr_55003_55060 = state_54967__$1;
(statearr_55003_55060[(2)] = inst_54937);

(statearr_55003_55060[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54968 === (5))){
var inst_54939 = (state_54967[(2)]);
var inst_54940 = superv.async._unregister_go.call(null,inst_54939,id__19191__auto____$1);
var state_54967__$1 = (function (){var statearr_55004 = state_54967;
(statearr_55004[(10)] = inst_54940);

return statearr_55004;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54967__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54968 === (14))){
var state_54967__$1 = state_54967;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54967__$1,(16),ch);
} else {
if((state_val_54968 === (16))){
var inst_54950 = (state_54967[(2)]);
var state_54967__$1 = state_54967;
if(cljs.core.truth_(inst_54950)){
var statearr_55005_55061 = state_54967__$1;
(statearr_55005_55061[(1)] = (17));

} else {
var statearr_55006_55062 = state_54967__$1;
(statearr_55006_55062[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54968 === (10))){
var inst_54942 = (state_54967[(7)]);
var inst_54942__$1 = (state_54967[(2)]);
var inst_54943 = cljs.core.ex_data.call(null,inst_54942__$1);
var inst_54944 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_54943);
var inst_54945 = cljs.core._EQ_.call(null,inst_54944,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_54967__$1 = (function (){var statearr_55007 = state_54967;
(statearr_55007[(7)] = inst_54942__$1);

return statearr_55007;
})();
if(inst_54945){
var statearr_55008_55063 = state_54967__$1;
(statearr_55008_55063[(1)] = (11));

} else {
var statearr_55009_55064 = state_54967__$1;
(statearr_55009_55064[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54968 === (18))){
var state_54967__$1 = state_54967;
var statearr_55010_55065 = state_54967__$1;
(statearr_55010_55065[(2)] = null);

(statearr_55010_55065[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54968 === (8))){
var state_54967__$1 = state_54967;
var statearr_55011_55066 = state_54967__$1;
(statearr_55011_55066[(2)] = null);

(statearr_55011_55066[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_54916,inst_54926,inst_54927,inst_54928,inst_54969,state_val_54976,c__33478__auto___55038,c__19190__auto___55036,id__19191__auto___55037))
;
return ((function (switch__33364__auto__,c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_54916,inst_54926,inst_54927,inst_54928,inst_54969,state_val_54976,c__33478__auto___55038,c__19190__auto___55036,id__19191__auto___55037){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_55015 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_55015[(0)] = superv$async$state_machine__33365__auto__);

(statearr_55015[(1)] = (1));

return statearr_55015;
});
var superv$async$state_machine__33365__auto____1 = (function (state_54967){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_54967);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e55016){if((e55016 instanceof Object)){
var ex__33368__auto__ = e55016;
var statearr_55017_55067 = state_54967;
(statearr_55017_55067[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54967);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55016;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55068 = state_54967;
state_54967 = G__55068;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_54967){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_54967);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_54916,inst_54926,inst_54927,inst_54928,inst_54969,state_val_54976,c__33478__auto___55038,c__19190__auto___55036,id__19191__auto___55037))
})();
var state__33480__auto__ = (function (){var statearr_55018 = f__33479__auto__.call(null);
(statearr_55018[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto____$1);

return statearr_55018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});
;})(c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_54916,inst_54926,inst_54927,inst_54928,inst_54969,state_val_54976,c__33478__auto___55038,c__19190__auto___55036,id__19191__auto___55037))
})();
var inst_54971 = cljs.core.async.impl.dispatch.run.call(null,inst_54970);
var state_54975__$1 = (function (){var statearr_55019 = state_54975;
(statearr_55019[(12)] = inst_54971);

return statearr_55019;
})();
var statearr_55020_55069 = state_54975__$1;
(statearr_55020_55069[(2)] = inst_54969);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54975__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54976 === (9))){
var inst_54914 = (state_54975[(2)]);
var inst_54915 = cljs.core.async.close_BANG_.call(null,ch);
var inst_54916 = superv.async.check_supervisor.call(null,superv.async.S);
var state_54975__$1 = (function (){var statearr_55021 = state_54975;
(statearr_55021[(13)] = inst_54914);

(statearr_55021[(11)] = inst_54916);

(statearr_55021[(14)] = inst_54915);

return statearr_55021;
})();
var statearr_55022_55070 = state_54975__$1;
(statearr_55022_55070[(2)] = null);

(statearr_55022_55070[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54976 === (5))){
var state_54975__$1 = state_54975;
var statearr_55023_55071 = state_54975__$1;
(statearr_55023_55071[(2)] = null);

(statearr_55023_55071[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54976 === (14))){
var state_54975__$1 = state_54975;
var statearr_55024_55072 = state_54975__$1;
(statearr_55024_55072[(2)] = null);

(statearr_55024_55072[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54976 === (10))){
var state_54975__$1 = state_54975;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54975__$1,(12),ch);
} else {
if((state_val_54976 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_54975,(4),Error,(3),(2));
var inst_54912 = superv.async._abort.call(null,S);
var state_54975__$1 = state_54975;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54975__$1,(9),inst_54912);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___55038,c__19190__auto___55036,id__19191__auto___55037))
;
return ((function (switch__33364__auto__,c__33478__auto___55038,c__19190__auto___55036,id__19191__auto___55037){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_55028 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55028[(0)] = superv$async$state_machine__33365__auto__);

(statearr_55028[(1)] = (1));

return statearr_55028;
});
var superv$async$state_machine__33365__auto____1 = (function (state_54975){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_54975);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e55029){if((e55029 instanceof Object)){
var ex__33368__auto__ = e55029;
var statearr_55030_55073 = state_54975;
(statearr_55030_55073[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54975);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55029;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55074 = state_54975;
state_54975 = G__55074;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_54975){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_54975);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___55038,c__19190__auto___55036,id__19191__auto___55037))
})();
var state__33480__auto__ = (function (){var statearr_55031 = f__33479__auto__.call(null);
(statearr_55031[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___55038);

return statearr_55031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___55038,c__19190__auto___55036,id__19191__auto___55037))
);


return cljs.core.async.tap.call(null,mult,ch,close_QMARK_);
});

superv.async.tap.cljs$lang$maxFixedArity = 4;

/**
 * Safely managed subscription. The channel is closed on abortion and
 *   all pending puts are flushed.
 */
superv.async.sub = (function superv$async$sub(var_args){
var args55075 = [];
var len__10640__auto___55179 = arguments.length;
var i__10641__auto___55180 = (0);
while(true){
if((i__10641__auto___55180 < len__10640__auto___55179)){
args55075.push((arguments[i__10641__auto___55180]));

var G__55181 = (i__10641__auto___55180 + (1));
i__10641__auto___55180 = G__55181;
continue;
} else {
}
break;
}

var G__55077 = args55075.length;
switch (G__55077) {
case 4:
return superv.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.sub.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args55075.length)].join('')));

}
});

superv.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (S,p,topic,ch){
return superv.async.sub.call(null,S,p,topic,ch,false);
});

superv.async.sub.cljs$core$IFn$_invoke$arity$5 = (function (S,p,topic,ch,close_QMARK_){
var c__19190__auto___55183 = superv.async.check_supervisor.call(null,superv.async.S);
var id__19191__auto___55184 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__33478__auto___55185 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___55185,c__19190__auto___55183,id__19191__auto___55184){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___55185,c__19190__auto___55183,id__19191__auto___55184){
return (function (state_55136){
var state_val_55137 = (state_55136[(1)]);
if((state_val_55137 === (1))){
var state_55136__$1 = state_55136;
var statearr_55138_55186 = state_55136__$1;
(statearr_55138_55186[(2)] = null);

(statearr_55138_55186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55137 === (2))){
var inst_55134 = (state_55136[(2)]);
var state_55136__$1 = state_55136;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55136__$1,inst_55134);
} else {
if((state_val_55137 === (3))){
var inst_55078 = (state_55136[(2)]);
var inst_55079 = superv.async._unregister_go.call(null,S,id__19191__auto___55184);
var state_55136__$1 = (function (){var statearr_55139 = state_55136;
(statearr_55139[(7)] = inst_55079);

(statearr_55139[(8)] = inst_55078);

return statearr_55139;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55136__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55137 === (4))){
var inst_55081 = (state_55136[(9)]);
var inst_55081__$1 = (state_55136[(2)]);
var inst_55082 = cljs.core.ex_data.call(null,inst_55081__$1);
var inst_55083 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_55082);
var inst_55084 = cljs.core._EQ_.call(null,inst_55083,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_55136__$1 = (function (){var statearr_55140 = state_55136;
(statearr_55140[(9)] = inst_55081__$1);

return statearr_55140;
})();
if(inst_55084){
var statearr_55141_55187 = state_55136__$1;
(statearr_55141_55187[(1)] = (5));

} else {
var statearr_55142_55188 = state_55136__$1;
(statearr_55142_55188[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55137 === (5))){
var state_55136__$1 = state_55136;
var statearr_55143_55189 = state_55136__$1;
(statearr_55143_55189[(2)] = null);

(statearr_55143_55189[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55137 === (6))){
var inst_55081 = (state_55136[(9)]);
var inst_55087 = superv.async._track_exception.call(null,S,inst_55081);
var state_55136__$1 = state_55136;
var statearr_55144_55190 = state_55136__$1;
(statearr_55144_55190[(2)] = inst_55087);

(statearr_55144_55190[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55137 === (7))){
var inst_55081 = (state_55136[(9)]);
var inst_55089 = (state_55136[(2)]);
var state_55136__$1 = (function (){var statearr_55145 = state_55136;
(statearr_55145[(10)] = inst_55089);

return statearr_55145;
})();
var statearr_55146_55191 = state_55136__$1;
(statearr_55146_55191[(2)] = inst_55081);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55136__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55137 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_55136,(4),Error,(3),(2));
var inst_55093 = superv.async._abort.call(null,S);
var state_55136__$1 = state_55136;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55136__$1,(9),inst_55093);
} else {
if((state_val_55137 === (9))){
var inst_55095 = (state_55136[(2)]);
var inst_55096 = cljs.core.async.close_BANG_.call(null,ch);
var inst_55097 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_55098 = cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))));
var inst_55099 = superv.async._register_go.call(null,S,inst_55098);
var inst_55130 = cljs.core.async.chan.call(null,(1));
var inst_55131 = (function (){var c__19190__auto____$1 = inst_55097;
var id__19191__auto____$1 = inst_55099;
var c__33478__auto____$1 = inst_55130;
return ((function (c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_55095,inst_55096,inst_55097,inst_55098,inst_55099,inst_55130,state_val_55137,c__33478__auto___55185,c__19190__auto___55183,id__19191__auto___55184){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_55095,inst_55096,inst_55097,inst_55098,inst_55099,inst_55130,state_val_55137,c__33478__auto___55185,c__19190__auto___55183,id__19191__auto___55184){
return (function (state_55128){
var state_val_55129 = (state_55128[(1)]);
if((state_val_55129 === (7))){
var inst_55103 = (state_55128[(7)]);
var inst_55111 = (state_55128[(2)]);
var state_55128__$1 = (function (){var statearr_55147 = state_55128;
(statearr_55147[(8)] = inst_55111);

return statearr_55147;
})();
var statearr_55148_55192 = state_55128__$1;
(statearr_55148_55192[(2)] = inst_55103);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55128__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55129 === (1))){
var state_55128__$1 = state_55128;
var statearr_55149_55193 = state_55128__$1;
(statearr_55149_55193[(2)] = null);

(statearr_55149_55193[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55129 === (4))){
var inst_55103 = (state_55128[(7)]);
var inst_55103__$1 = (state_55128[(2)]);
var inst_55104 = cljs.core.ex_data.call(null,inst_55103__$1);
var inst_55105 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_55104);
var inst_55106 = cljs.core._EQ_.call(null,inst_55105,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_55128__$1 = (function (){var statearr_55150 = state_55128;
(statearr_55150[(7)] = inst_55103__$1);

return statearr_55150;
})();
if(inst_55106){
var statearr_55151_55194 = state_55128__$1;
(statearr_55151_55194[(1)] = (5));

} else {
var statearr_55152_55195 = state_55128__$1;
(statearr_55152_55195[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55129 === (13))){
var state_55128__$1 = state_55128;
var statearr_55153_55196 = state_55128__$1;
(statearr_55153_55196[(2)] = null);

(statearr_55153_55196[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55129 === (6))){
var inst_55103 = (state_55128[(7)]);
var inst_55109 = superv.async._track_exception.call(null,S,inst_55103);
var state_55128__$1 = state_55128;
var statearr_55154_55197 = state_55128__$1;
(statearr_55154_55197[(2)] = inst_55109);

(statearr_55154_55197[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55129 === (3))){
var inst_55100 = (state_55128[(2)]);
var inst_55101 = superv.async._unregister_go.call(null,S,id__19191__auto____$1);
var state_55128__$1 = (function (){var statearr_55155 = state_55128;
(statearr_55155[(9)] = inst_55101);

(statearr_55155[(10)] = inst_55100);

return statearr_55155;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55128__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55129 === (12))){
var state_55128__$1 = state_55128;
var statearr_55156_55198 = state_55128__$1;
(statearr_55156_55198[(2)] = null);

(statearr_55156_55198[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55129 === (2))){
var inst_55126 = (state_55128[(2)]);
var state_55128__$1 = state_55128;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55128__$1,inst_55126);
} else {
if((state_val_55129 === (11))){
var inst_55117 = (state_55128[(2)]);
var state_55128__$1 = state_55128;
if(cljs.core.truth_(inst_55117)){
var statearr_55157_55199 = state_55128__$1;
(statearr_55157_55199[(1)] = (12));

} else {
var statearr_55158_55200 = state_55128__$1;
(statearr_55158_55200[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55129 === (9))){
var state_55128__$1 = state_55128;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55128__$1,(11),ch);
} else {
if((state_val_55129 === (5))){
var state_55128__$1 = state_55128;
var statearr_55159_55201 = state_55128__$1;
(statearr_55159_55201[(2)] = null);

(statearr_55159_55201[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55129 === (14))){
var inst_55122 = (state_55128[(2)]);
var state_55128__$1 = state_55128;
var statearr_55160_55202 = state_55128__$1;
(statearr_55160_55202[(2)] = inst_55122);

(statearr_55160_55202[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55129 === (10))){
var inst_55124 = (state_55128[(2)]);
var state_55128__$1 = state_55128;
var statearr_55161_55203 = state_55128__$1;
(statearr_55161_55203[(2)] = inst_55124);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55128__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55129 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_55128,(4),Error,(3),(2));
var state_55128__$1 = state_55128;
var statearr_55162_55204 = state_55128__$1;
(statearr_55162_55204[(2)] = null);

(statearr_55162_55204[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_55095,inst_55096,inst_55097,inst_55098,inst_55099,inst_55130,state_val_55137,c__33478__auto___55185,c__19190__auto___55183,id__19191__auto___55184))
;
return ((function (switch__33364__auto__,c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_55095,inst_55096,inst_55097,inst_55098,inst_55099,inst_55130,state_val_55137,c__33478__auto___55185,c__19190__auto___55183,id__19191__auto___55184){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_55166 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_55166[(0)] = superv$async$state_machine__33365__auto__);

(statearr_55166[(1)] = (1));

return statearr_55166;
});
var superv$async$state_machine__33365__auto____1 = (function (state_55128){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_55128);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e55167){if((e55167 instanceof Object)){
var ex__33368__auto__ = e55167;
var statearr_55168_55205 = state_55128;
(statearr_55168_55205[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55128);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55167;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55206 = state_55128;
state_55128 = G__55206;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_55128){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_55128);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_55095,inst_55096,inst_55097,inst_55098,inst_55099,inst_55130,state_val_55137,c__33478__auto___55185,c__19190__auto___55183,id__19191__auto___55184))
})();
var state__33480__auto__ = (function (){var statearr_55169 = f__33479__auto__.call(null);
(statearr_55169[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto____$1);

return statearr_55169;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});
;})(c__19190__auto____$1,id__19191__auto____$1,c__33478__auto____$1,inst_55095,inst_55096,inst_55097,inst_55098,inst_55099,inst_55130,state_val_55137,c__33478__auto___55185,c__19190__auto___55183,id__19191__auto___55184))
})();
var inst_55132 = cljs.core.async.impl.dispatch.run.call(null,inst_55131);
var state_55136__$1 = (function (){var statearr_55170 = state_55136;
(statearr_55170[(11)] = inst_55096);

(statearr_55170[(12)] = inst_55132);

(statearr_55170[(13)] = inst_55095);

return statearr_55170;
})();
var statearr_55171_55207 = state_55136__$1;
(statearr_55171_55207[(2)] = inst_55130);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55136__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___55185,c__19190__auto___55183,id__19191__auto___55184))
;
return ((function (switch__33364__auto__,c__33478__auto___55185,c__19190__auto___55183,id__19191__auto___55184){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_55175 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55175[(0)] = superv$async$state_machine__33365__auto__);

(statearr_55175[(1)] = (1));

return statearr_55175;
});
var superv$async$state_machine__33365__auto____1 = (function (state_55136){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_55136);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e55176){if((e55176 instanceof Object)){
var ex__33368__auto__ = e55176;
var statearr_55177_55208 = state_55136;
(statearr_55177_55208[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55136);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55176;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55209 = state_55136;
state_55136 = G__55209;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_55136){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_55136);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___55185,c__19190__auto___55183,id__19191__auto___55184))
})();
var state__33480__auto__ = (function (){var statearr_55178 = f__33479__auto__.call(null);
(statearr_55178[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___55185);

return statearr_55178;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___55185,c__19190__auto___55183,id__19191__auto___55184))
);


return cljs.core.async.sub.call(null,p,topic,ch,close_QMARK_);
});

superv.async.sub.cljs$lang$maxFixedArity = 5;

/**
 * Creates a supervised channel for transducer xform. Exceptions
 *   immediatly propagate to the supervisor.
 */
superv.async.chan_super = (function superv$async$chan_super(S,buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,(function (e){
return cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(S),e);
}));
});
/**
 * Starts a subsystem with supervised go-routines initialized by start-fn.
 *   Restarts the system on error for retries times with a potential delay in
 *   milliseconds, an optional error-fn predicate determining the retry and a
 *   optional filter by exception type. You can optionally pass a supervisor to
 *   form a supervision tree. Whenever this passed supervisor aborts the context,
 *   this supervisor will close as well. You still need to block on the result of
 *   this supervisor if you want a clean synchronized shutdown. The concept is
 *   similar to http://learnyousomeerlang.com/supervisors
 * 
 *   All blocking channel ops in the subroutines (supervised context) are
 *   aborted with an exception on error to force total termination. The
 *   supervisor waits until all supervised go-routines are finished and
 *   have freed resources before restarting.
 * 
 *   If exceptions are not taken from go-try channels (by error), they become stale
 *   after the stale-timeout and trigger a restart or are propagated to the parent
 *   supervisor (if available) and the return value.
 * 
 *   Note: The signature and behaviour of this function might still change.
 */
superv.async.restarting_supervisor = (function superv$async$restarting_supervisor(var_args){
var args__10647__auto__ = [];
var len__10640__auto___55517 = arguments.length;
var i__10641__auto___55518 = (0);
while(true){
if((i__10641__auto___55518 < len__10640__auto___55517)){
args__10647__auto__.push((arguments[i__10641__auto___55518]));

var G__55519 = (i__10641__auto___55518 + (1));
i__10641__auto___55518 = G__55519;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (start_fn,p__55224){
var map__55225 = p__55224;
var map__55225__$1 = ((((!((map__55225 == null)))?((((map__55225.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55225.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55225):map__55225);
var retries = cljs.core.get.call(null,map__55225__$1,new cljs.core.Keyword(null,"retries","retries",1888092808),Infinity);
var delay = cljs.core.get.call(null,map__55225__$1,new cljs.core.Keyword(null,"delay","delay",-574225219),(0));
var error_fn = cljs.core.get.call(null,map__55225__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),null);
var exception = cljs.core.get.call(null,map__55225__$1,new cljs.core.Keyword(null,"exception","exception",-335277064),Error);
var stale_timeout = cljs.core.get.call(null,map__55225__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((60) * (1000)));
var log_fn = cljs.core.get.call(null,map__55225__$1,new cljs.core.Keyword(null,"log-fn","log-fn",-2003241282),((function (map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout){
return (function (level,msg){
return cljs.core.println.call(null,level,msg);
});})(map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout))
);
var supervisor = cljs.core.get.call(null,map__55225__$1,new cljs.core.Keyword(null,"supervisor","supervisor",-134060208));
var retries__$1 = (function (){var or__9419__auto__ = retries;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return Infinity;
}
})();
var out_ch = cljs.core.async.chan.call(null);
var c__33478__auto___55520 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_55416){
var state_val_55417 = (state_55416[(1)]);
if((state_val_55417 === (7))){
var inst_55231 = (state_55416[(7)]);
var inst_55359 = (state_55416[(2)]);
var inst_55360 = cljs.core.nth.call(null,inst_55359,(0),null);
var inst_55361 = cljs.core.nth.call(null,inst_55359,(1),null);
var inst_55362 = cljs.core._EQ_.call(null,inst_55361,inst_55231);
var inst_55363 = !(inst_55362);
var state_55416__$1 = (function (){var statearr_55418 = state_55416;
(statearr_55418[(8)] = inst_55360);

return statearr_55418;
})();
if(inst_55363){
var statearr_55419_55521 = state_55416__$1;
(statearr_55419_55521[(1)] = (8));

} else {
var statearr_55420_55522 = state_55416__$1;
(statearr_55420_55522[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55417 === (20))){
var inst_55360 = (state_55416[(8)]);
var inst_55391 = (state_55416[(2)]);
var inst_55392 = cljs.core.async.put_BANG_.call(null,out_ch,inst_55360);
var inst_55393 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_55416__$1 = (function (){var statearr_55421 = state_55416;
(statearr_55421[(9)] = inst_55392);

(statearr_55421[(10)] = inst_55391);

return statearr_55421;
})();
var statearr_55422_55523 = state_55416__$1;
(statearr_55422_55523[(2)] = inst_55393);

(statearr_55422_55523[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55417 === (1))){
var inst_55227 = retries__$1;
var state_55416__$1 = (function (){var statearr_55423 = state_55416;
(statearr_55423[(11)] = inst_55227);

return statearr_55423;
})();
var statearr_55424_55524 = state_55416__$1;
(statearr_55424_55524[(2)] = null);

(statearr_55424_55524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55417 === (4))){
var inst_55229 = (state_55416[(12)]);
var inst_55240 = (state_55416[(13)]);
var inst_55230 = (state_55416[(14)]);
var inst_55239 = (state_55416[(15)]);
var inst_55231 = (state_55416[(7)]);
var inst_55227 = (state_55416[(11)]);
var inst_55242 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_55243 = cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"supervisor","supervisor",1506471319,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ab-ch","ab-ch",-698106711,null)));
var inst_55244 = superv.async._register_go.call(null,supervisor,inst_55243);
var inst_55269 = cljs.core.async.chan.call(null,(1));
var inst_55270 = (function (){var stale_timeout__$1 = (1000);
var c__33478__auto____$1 = inst_55269;
var err_ch = inst_55229;
var ab_ch = inst_55230;
var res_ch = inst_55240;
var close_ch = inst_55231;
var retries__$2 = inst_55227;
var c__19190__auto__ = inst_55242;
var s = inst_55239;
var id__19191__auto__ = inst_55244;
return ((function (stale_timeout__$1,c__33478__auto____$1,err_ch,ab_ch,res_ch,close_ch,retries__$2,c__19190__auto__,s,id__19191__auto__,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55242,inst_55243,inst_55244,inst_55269,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (stale_timeout__$1,c__33478__auto____$1,err_ch,ab_ch,res_ch,close_ch,retries__$2,c__19190__auto__,s,id__19191__auto__,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55242,inst_55243,inst_55244,inst_55269,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_55267){
var state_val_55268 = (state_55267[(1)]);
if((state_val_55268 === (1))){
var state_55267__$1 = state_55267;
var statearr_55425_55525 = state_55267__$1;
(statearr_55425_55525[(2)] = null);

(statearr_55425_55525[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55268 === (2))){
var inst_55265 = (state_55267[(2)]);
var state_55267__$1 = state_55267;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55267__$1,inst_55265);
} else {
if((state_val_55268 === (3))){
var inst_55245 = (state_55267[(2)]);
var inst_55246 = superv.async._unregister_go.call(null,supervisor,id__19191__auto__);
var state_55267__$1 = (function (){var statearr_55426 = state_55267;
(statearr_55426[(7)] = inst_55246);

(statearr_55426[(8)] = inst_55245);

return statearr_55426;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55267__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55268 === (4))){
var inst_55248 = (state_55267[(9)]);
var inst_55248__$1 = (state_55267[(2)]);
var inst_55249 = cljs.core.ex_data.call(null,inst_55248__$1);
var inst_55250 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_55249);
var inst_55251 = cljs.core._EQ_.call(null,inst_55250,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_55267__$1 = (function (){var statearr_55427 = state_55267;
(statearr_55427[(9)] = inst_55248__$1);

return statearr_55427;
})();
if(inst_55251){
var statearr_55428_55526 = state_55267__$1;
(statearr_55428_55526[(1)] = (5));

} else {
var statearr_55429_55527 = state_55267__$1;
(statearr_55429_55527[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55268 === (5))){
var state_55267__$1 = state_55267;
var statearr_55430_55528 = state_55267__$1;
(statearr_55430_55528[(2)] = null);

(statearr_55430_55528[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55268 === (6))){
var inst_55248 = (state_55267[(9)]);
var inst_55254 = superv.async._track_exception.call(null,supervisor,inst_55248);
var state_55267__$1 = state_55267;
var statearr_55431_55529 = state_55267__$1;
(statearr_55431_55529[(2)] = inst_55254);

(statearr_55431_55529[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55268 === (7))){
var inst_55248 = (state_55267[(9)]);
var inst_55256 = (state_55267[(2)]);
var state_55267__$1 = (function (){var statearr_55432 = state_55267;
(statearr_55432[(10)] = inst_55256);

return statearr_55432;
})();
var statearr_55433_55530 = state_55267__$1;
(statearr_55433_55530[(2)] = inst_55248);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55267__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55268 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_55267,(4),Error,(3),(2));
var inst_55260 = superv.async._abort.call(null,supervisor);
var state_55267__$1 = state_55267;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55267__$1,(9),inst_55260);
} else {
if((state_val_55268 === (9))){
var inst_55262 = (state_55267[(2)]);
var inst_55263 = cljs.core.async.close_BANG_.call(null,ab_ch);
var state_55267__$1 = (function (){var statearr_55434 = state_55267;
(statearr_55434[(11)] = inst_55262);

return statearr_55434;
})();
var statearr_55435_55531 = state_55267__$1;
(statearr_55435_55531[(2)] = inst_55263);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55267__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(stale_timeout__$1,c__33478__auto____$1,err_ch,ab_ch,res_ch,close_ch,retries__$2,c__19190__auto__,s,id__19191__auto__,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55242,inst_55243,inst_55244,inst_55269,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__33364__auto__,stale_timeout__$1,c__33478__auto____$1,err_ch,ab_ch,res_ch,close_ch,retries__$2,c__19190__auto__,s,id__19191__auto__,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55242,inst_55243,inst_55244,inst_55269,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_55439 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55439[(0)] = superv$async$state_machine__33365__auto__);

(statearr_55439[(1)] = (1));

return statearr_55439;
});
var superv$async$state_machine__33365__auto____1 = (function (state_55267){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_55267);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e55440){if((e55440 instanceof Object)){
var ex__33368__auto__ = e55440;
var statearr_55441_55532 = state_55267;
(statearr_55441_55532[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55267);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55440;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55533 = state_55267;
state_55267 = G__55533;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_55267){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_55267);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,stale_timeout__$1,c__33478__auto____$1,err_ch,ab_ch,res_ch,close_ch,retries__$2,c__19190__auto__,s,id__19191__auto__,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55242,inst_55243,inst_55244,inst_55269,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__33480__auto__ = (function (){var statearr_55442 = f__33479__auto__.call(null);
(statearr_55442[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto____$1);

return statearr_55442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});
;})(stale_timeout__$1,c__33478__auto____$1,err_ch,ab_ch,res_ch,close_ch,retries__$2,c__19190__auto__,s,id__19191__auto__,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55242,inst_55243,inst_55244,inst_55269,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_55271 = cljs.core.async.impl.dispatch.run.call(null,inst_55270);
var state_55416__$1 = (function (){var statearr_55443 = state_55416;
(statearr_55443[(16)] = inst_55271);

return statearr_55443;
})();
var statearr_55444_55534 = state_55416__$1;
(statearr_55444_55534[(2)] = inst_55269);

(statearr_55444_55534[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55417 === (15))){
var inst_55360 = (state_55416[(8)]);
var inst_55382 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_55383 = [new cljs.core.Keyword(null,"passing-error","passing-error",-1357712542),inst_55360];
var inst_55384 = cljs.core.PersistentHashMap.fromArrays(inst_55382,inst_55383);
var inst_55385 = log_fn.call(null,new cljs.core.Keyword(null,"error","error",-978969032),inst_55384);
var state_55416__$1 = (function (){var statearr_55445 = state_55416;
(statearr_55445[(17)] = inst_55385);

return statearr_55445;
})();
if(cljs.core.truth_(supervisor)){
var statearr_55446_55535 = state_55416__$1;
(statearr_55446_55535[(1)] = (18));

} else {
var statearr_55447_55536 = state_55416__$1;
(statearr_55447_55536[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55417 === (21))){
var inst_55360 = (state_55416[(8)]);
var inst_55227 = (state_55416[(11)]);
var inst_55397 = (state_55416[(2)]);
var inst_55398 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"further-retries","further-retries",1297645153)];
var inst_55399 = [new cljs.core.Keyword(null,"retry","retry",-614012896),inst_55360,inst_55227];
var inst_55400 = cljs.core.PersistentHashMap.fromArrays(inst_55398,inst_55399);
var inst_55401 = log_fn.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),inst_55400);
var inst_55402 = (inst_55227 - (1));
var inst_55227__$1 = inst_55402;
var state_55416__$1 = (function (){var statearr_55448 = state_55416;
(statearr_55448[(18)] = inst_55401);

(statearr_55448[(19)] = inst_55397);

(statearr_55448[(11)] = inst_55227__$1);

return statearr_55448;
})();
var statearr_55449_55537 = state_55416__$1;
(statearr_55449_55537[(2)] = null);

(statearr_55449_55537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55417 === (13))){
var inst_55360 = (state_55416[(8)]);
var inst_55374 = error_fn.call(null,inst_55360);
var state_55416__$1 = state_55416;
var statearr_55450_55538 = state_55416__$1;
(statearr_55450_55538[(2)] = inst_55374);

(statearr_55450_55538[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55417 === (22))){
var inst_55408 = (state_55416[(2)]);
var inst_55409 = cljs.core.async.put_BANG_.call(null,out_ch,inst_55408);
var inst_55410 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_55416__$1 = (function (){var statearr_55451 = state_55416;
(statearr_55451[(20)] = inst_55409);

return statearr_55451;
})();
var statearr_55452_55539 = state_55416__$1;
(statearr_55452_55539[(2)] = inst_55410);

(statearr_55452_55539[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55417 === (6))){
var inst_55229 = (state_55416[(12)]);
var inst_55240 = (state_55416[(13)]);
var inst_55230 = (state_55416[(14)]);
var inst_55239 = (state_55416[(15)]);
var inst_55231 = (state_55416[(7)]);
var inst_55227 = (state_55416[(11)]);
var inst_55274 = (state_55416[(2)]);
var inst_55321 = cljs.core.async.chan.call(null,(1));
var inst_55322 = (function (){var retries__$2 = inst_55227;
var err_ch = inst_55229;
var ab_ch = inst_55230;
var close_ch = inst_55231;
var s = inst_55239;
var res_ch = inst_55240;
var stale_timeout__$1 = (1000);
var c__33478__auto____$1 = inst_55321;
return ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55274,inst_55321,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55274,inst_55321,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_55319){
var state_val_55320 = (state_55319[(1)]);
if((state_val_55320 === (7))){
var inst_55294 = (state_55319[(7)]);
var inst_55281 = (state_55319[(2)]);
var inst_55289 = (function (){return ((function (inst_55294,inst_55281,state_val_55320,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55274,inst_55321,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (p__55288){
var vec__55453 = p__55288;
var k = cljs.core.nth.call(null,vec__55453,(0),null);
var v = cljs.core.nth.call(null,vec__55453,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout__$1) > v.getTime());
});
;})(inst_55294,inst_55281,state_val_55320,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55274,inst_55321,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_55290 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_55291 = cljs.core.deref.call(null,inst_55290);
var inst_55292 = cljs.core.filter.call(null,inst_55289,inst_55291);
var inst_55293 = cljs.core.nth.call(null,inst_55292,(0),null);
var inst_55294__$1 = cljs.core.nth.call(null,inst_55293,(0),null);
var inst_55295 = cljs.core.nth.call(null,inst_55293,(1),null);
var state_55319__$1 = (function (){var statearr_55456 = state_55319;
(statearr_55456[(7)] = inst_55294__$1);

(statearr_55456[(8)] = inst_55295);

(statearr_55456[(9)] = inst_55281);

return statearr_55456;
})();
if(cljs.core.truth_(inst_55294__$1)){
var statearr_55457_55540 = state_55319__$1;
(statearr_55457_55540[(1)] = (8));

} else {
var statearr_55458_55541 = state_55319__$1;
(statearr_55458_55541[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55320 === (1))){
var state_55319__$1 = state_55319;
var statearr_55459_55542 = state_55319__$1;
(statearr_55459_55542[(2)] = null);

(statearr_55459_55542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55320 === (4))){
var state_55319__$1 = state_55319;
var statearr_55460_55543 = state_55319__$1;
(statearr_55460_55543[(2)] = null);

(statearr_55460_55543[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55320 === (13))){
var inst_55294 = (state_55319[(7)]);
var inst_55307 = (state_55319[(2)]);
var inst_55308 = superv.async._free_exception.call(null,s,inst_55294);
var inst_55309 = cljs.core.async.put_BANG_.call(null,err_ch,inst_55294);
var state_55319__$1 = (function (){var statearr_55461 = state_55319;
(statearr_55461[(10)] = inst_55307);

(statearr_55461[(11)] = inst_55308);

return statearr_55461;
})();
var statearr_55462_55544 = state_55319__$1;
(statearr_55462_55544[(2)] = inst_55309);

(statearr_55462_55544[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55320 === (6))){
var inst_55315 = (state_55319[(2)]);
var state_55319__$1 = state_55319;
var statearr_55463_55545 = state_55319__$1;
(statearr_55463_55545[(2)] = inst_55315);

(statearr_55463_55545[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55320 === (3))){
var inst_55317 = (state_55319[(2)]);
var state_55319__$1 = state_55319;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55319__$1,inst_55317);
} else {
if((state_val_55320 === (12))){
var inst_55294 = (state_55319[(7)]);
var inst_55302 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_55303 = [new cljs.core.Keyword(null,"stale-error-in-supervisor","stale-error-in-supervisor",-123257662),inst_55294];
var inst_55304 = cljs.core.PersistentHashMap.fromArrays(inst_55302,inst_55303);
var inst_55305 = log_fn.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_55304);
var state_55319__$1 = state_55319;
var statearr_55464_55546 = state_55319__$1;
(statearr_55464_55546[(2)] = inst_55305);

(statearr_55464_55546[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55320 === (2))){
var inst_55276 = cljs.core.async.poll_BANG_.call(null,ab_ch);
var state_55319__$1 = state_55319;
if(cljs.core.truth_(inst_55276)){
var statearr_55465_55547 = state_55319__$1;
(statearr_55465_55547[(1)] = (4));

} else {
var statearr_55466_55548 = state_55319__$1;
(statearr_55466_55548[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55320 === (11))){
var state_55319__$1 = state_55319;
var statearr_55467_55549 = state_55319__$1;
(statearr_55467_55549[(2)] = null);

(statearr_55467_55549[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55320 === (9))){
var state_55319__$1 = state_55319;
var statearr_55468_55550 = state_55319__$1;
(statearr_55468_55550[(2)] = null);

(statearr_55468_55550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55320 === (5))){
var inst_55279 = cljs.core.async.timeout.call(null,stale_timeout__$1);
var state_55319__$1 = state_55319;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55319__$1,(7),inst_55279);
} else {
if((state_val_55320 === (10))){
var inst_55313 = (state_55319[(2)]);
var state_55319__$1 = state_55319;
var statearr_55469_55551 = state_55319__$1;
(statearr_55469_55551[(2)] = inst_55313);

(statearr_55469_55551[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55320 === (8))){
var inst_55294 = (state_55319[(7)]);
var inst_55297 = cljs.core.ex_data.call(null,inst_55294);
var inst_55298 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_55297);
var inst_55299 = cljs.core._EQ_.call(null,inst_55298,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_55319__$1 = state_55319;
if(inst_55299){
var statearr_55470_55552 = state_55319__$1;
(statearr_55470_55552[(1)] = (11));

} else {
var statearr_55471_55553 = state_55319__$1;
(statearr_55471_55553[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55274,inst_55321,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__33364__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55274,inst_55321,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_55475 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55475[(0)] = superv$async$state_machine__33365__auto__);

(statearr_55475[(1)] = (1));

return statearr_55475;
});
var superv$async$state_machine__33365__auto____1 = (function (state_55319){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_55319);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e55476){if((e55476 instanceof Object)){
var ex__33368__auto__ = e55476;
var statearr_55477_55554 = state_55319;
(statearr_55477_55554[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55319);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55476;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55555 = state_55319;
state_55319 = G__55555;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_55319){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_55319);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55274,inst_55321,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__33480__auto__ = (function (){var statearr_55478 = f__33479__auto__.call(null);
(statearr_55478[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto____$1);

return statearr_55478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});
;})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55274,inst_55321,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_55323 = cljs.core.async.impl.dispatch.run.call(null,inst_55322);
var inst_55349 = cljs.core.async.chan.call(null,(1));
var inst_55350 = (function (){var retries__$2 = inst_55227;
var err_ch = inst_55229;
var ab_ch = inst_55230;
var close_ch = inst_55231;
var s = inst_55239;
var res_ch = inst_55240;
var stale_timeout__$1 = (1000);
var c__33478__auto____$1 = inst_55349;
return ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55274,inst_55321,inst_55322,inst_55323,inst_55349,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__33479__auto__ = (function (){var switch__33364__auto__ = ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55274,inst_55321,inst_55322,inst_55323,inst_55349,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_55347){
var state_val_55348 = (state_55347[(1)]);
if((state_val_55348 === (1))){
var inst_55324 = (0);
var state_55347__$1 = (function (){var statearr_55479 = state_55347;
(statearr_55479[(7)] = inst_55324);

return statearr_55479;
})();
var statearr_55480_55556 = state_55347__$1;
(statearr_55480_55556[(2)] = null);

(statearr_55480_55556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55348 === (2))){
var inst_55326 = new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(s);
var inst_55327 = cljs.core.deref.call(null,inst_55326);
var inst_55328 = cljs.core.empty_QMARK_.call(null,inst_55327);
var inst_55329 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_55330 = cljs.core.deref.call(null,inst_55329);
var inst_55331 = cljs.core.empty_QMARK_.call(null,inst_55330);
var inst_55332 = (inst_55328) && (inst_55331);
var inst_55333 = cljs.core.not.call(null,inst_55332);
var state_55347__$1 = state_55347;
if(inst_55333){
var statearr_55481_55557 = state_55347__$1;
(statearr_55481_55557[(1)] = (4));

} else {
var statearr_55482_55558 = state_55347__$1;
(statearr_55482_55558[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55348 === (3))){
var inst_55345 = (state_55347[(2)]);
var state_55347__$1 = state_55347;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55347__$1,inst_55345);
} else {
if((state_val_55348 === (4))){
var inst_55335 = cljs.core.async.timeout.call(null,(100));
var state_55347__$1 = state_55347;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55347__$1,(7),inst_55335);
} else {
if((state_val_55348 === (5))){
var inst_55341 = cljs.core.async.close_BANG_.call(null,close_ch);
var state_55347__$1 = state_55347;
var statearr_55483_55559 = state_55347__$1;
(statearr_55483_55559[(2)] = inst_55341);

(statearr_55483_55559[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55348 === (6))){
var inst_55343 = (state_55347[(2)]);
var state_55347__$1 = state_55347;
var statearr_55484_55560 = state_55347__$1;
(statearr_55484_55560[(2)] = inst_55343);

(statearr_55484_55560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55348 === (7))){
var inst_55324 = (state_55347[(7)]);
var inst_55337 = (state_55347[(2)]);
var inst_55338 = (inst_55324 + (1));
var inst_55324__$1 = inst_55338;
var state_55347__$1 = (function (){var statearr_55485 = state_55347;
(statearr_55485[(7)] = inst_55324__$1);

(statearr_55485[(8)] = inst_55337);

return statearr_55485;
})();
var statearr_55486_55561 = state_55347__$1;
(statearr_55486_55561[(2)] = null);

(statearr_55486_55561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55274,inst_55321,inst_55322,inst_55323,inst_55349,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__33364__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55274,inst_55321,inst_55322,inst_55323,inst_55349,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_55490 = [null,null,null,null,null,null,null,null,null];
(statearr_55490[(0)] = superv$async$state_machine__33365__auto__);

(statearr_55490[(1)] = (1));

return statearr_55490;
});
var superv$async$state_machine__33365__auto____1 = (function (state_55347){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_55347);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e55491){if((e55491 instanceof Object)){
var ex__33368__auto__ = e55491;
var statearr_55492_55562 = state_55347;
(statearr_55492_55562[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55347);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55491;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55563 = state_55347;
state_55347 = G__55563;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_55347){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_55347);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55274,inst_55321,inst_55322,inst_55323,inst_55349,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__33480__auto__ = (function (){var statearr_55493 = f__33479__auto__.call(null);
(statearr_55493[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto____$1);

return statearr_55493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});
;})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33478__auto____$1,inst_55229,inst_55240,inst_55230,inst_55239,inst_55231,inst_55227,inst_55274,inst_55321,inst_55322,inst_55323,inst_55349,state_val_55417,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_55351 = cljs.core.async.impl.dispatch.run.call(null,inst_55350);
var inst_55355 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55356 = [inst_55229,inst_55231];
var inst_55357 = (new cljs.core.PersistentVector(null,2,(5),inst_55355,inst_55356,null));
var state_55416__$1 = (function (){var statearr_55494 = state_55416;
(statearr_55494[(21)] = inst_55323);

(statearr_55494[(22)] = inst_55351);

(statearr_55494[(23)] = inst_55274);

return statearr_55494;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_55416__$1,(7),inst_55357,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_55417 === (17))){
var inst_55405 = (state_55416[(2)]);
var state_55416__$1 = state_55416;
var statearr_55495_55564 = state_55416__$1;
(statearr_55495_55564[(2)] = inst_55405);

(statearr_55495_55564[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55417 === (3))){
var inst_55414 = (state_55416[(2)]);
var state_55416__$1 = state_55416;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55416__$1,inst_55414);
} else {
if((state_val_55417 === (12))){
var inst_55371 = (state_55416[(24)]);
var state_55416__$1 = state_55416;
var statearr_55496_55565 = state_55416__$1;
(statearr_55496_55565[(2)] = inst_55371);

(statearr_55496_55565[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55417 === (2))){
var inst_55229 = (state_55416[(12)]);
var inst_55230 = (state_55416[(14)]);
var inst_55239 = (state_55416[(15)]);
var inst_55229__$1 = cljs.core.async.chan.call(null);
var inst_55230__$1 = cljs.core.async.chan.call(null);
var inst_55231 = cljs.core.async.chan.call(null);
var inst_55232 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),new cljs.core.Keyword(null,"restarting","restarting",760677572)];
var inst_55233 = cljs.core.PersistentHashMap.EMPTY;
var inst_55234 = cljs.core.atom.call(null,inst_55233);
var inst_55235 = cljs.core.PersistentHashMap.EMPTY;
var inst_55236 = cljs.core.atom.call(null,inst_55235);
var inst_55237 = [inst_55229__$1,inst_55230__$1,inst_55234,inst_55236,true];
var inst_55238 = cljs.core.PersistentHashMap.fromArrays(inst_55232,inst_55237);
var inst_55239__$1 = superv.async.map__GT_TrackingSupervisor.call(null,inst_55238);
var inst_55240 = start_fn.call(null,inst_55239__$1);
var state_55416__$1 = (function (){var statearr_55497 = state_55416;
(statearr_55497[(12)] = inst_55229__$1);

(statearr_55497[(13)] = inst_55240);

(statearr_55497[(14)] = inst_55230__$1);

(statearr_55497[(15)] = inst_55239__$1);

(statearr_55497[(7)] = inst_55231);

return statearr_55497;
})();
if(cljs.core.truth_(supervisor)){
var statearr_55498_55566 = state_55416__$1;
(statearr_55498_55566[(1)] = (4));

} else {
var statearr_55499_55567 = state_55416__$1;
(statearr_55499_55567[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55417 === (19))){
var state_55416__$1 = state_55416;
var statearr_55500_55568 = state_55416__$1;
(statearr_55500_55568[(2)] = null);

(statearr_55500_55568[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55417 === (11))){
var inst_55360 = (state_55416[(8)]);
var inst_55371 = (state_55416[(24)]);
var inst_55368 = (state_55416[(2)]);
var inst_55369 = (inst_55360 instanceof exception);
var inst_55370 = cljs.core.not.call(null,inst_55369);
var inst_55371__$1 = cljs.core.not.call(null,error_fn);
var state_55416__$1 = (function (){var statearr_55501 = state_55416;
(statearr_55501[(24)] = inst_55371__$1);

(statearr_55501[(25)] = inst_55368);

(statearr_55501[(26)] = inst_55370);

return statearr_55501;
})();
if(inst_55371__$1){
var statearr_55502_55569 = state_55416__$1;
(statearr_55502_55569[(1)] = (12));

} else {
var statearr_55503_55570 = state_55416__$1;
(statearr_55503_55570[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55417 === (9))){
var inst_55240 = (state_55416[(13)]);
var state_55416__$1 = state_55416;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55416__$1,(22),inst_55240);
} else {
if((state_val_55417 === (5))){
var state_55416__$1 = state_55416;
var statearr_55504_55571 = state_55416__$1;
(statearr_55504_55571[(2)] = null);

(statearr_55504_55571[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55417 === (14))){
var inst_55370 = (state_55416[(26)]);
var inst_55227 = (state_55416[(11)]);
var inst_55376 = (state_55416[(2)]);
var inst_55377 = cljs.core.not.call(null,inst_55376);
var inst_55378 = (inst_55227 > (0));
var inst_55379 = cljs.core.not.call(null,inst_55378);
var inst_55380 = (inst_55370) || (inst_55377) || (inst_55379);
var state_55416__$1 = state_55416;
if(cljs.core.truth_(inst_55380)){
var statearr_55505_55572 = state_55416__$1;
(statearr_55505_55572[(1)] = (15));

} else {
var statearr_55506_55573 = state_55416__$1;
(statearr_55506_55573[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55417 === (16))){
var inst_55395 = cljs.core.async.timeout.call(null,delay);
var state_55416__$1 = state_55416;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55416__$1,(21),inst_55395);
} else {
if((state_val_55417 === (10))){
var inst_55412 = (state_55416[(2)]);
var state_55416__$1 = state_55416;
var statearr_55507_55574 = state_55416__$1;
(statearr_55507_55574[(2)] = inst_55412);

(statearr_55507_55574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55417 === (18))){
var inst_55360 = (state_55416[(8)]);
var inst_55387 = superv.async._error.call(null,supervisor);
var inst_55388 = cljs.core.async.put_BANG_.call(null,inst_55387,inst_55360);
var state_55416__$1 = state_55416;
var statearr_55508_55575 = state_55416__$1;
(statearr_55508_55575[(2)] = inst_55388);

(statearr_55508_55575[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55417 === (8))){
var inst_55229 = (state_55416[(12)]);
var inst_55230 = (state_55416[(14)]);
var inst_55231 = (state_55416[(7)]);
var inst_55365 = cljs.core.async.close_BANG_.call(null,inst_55229);
var inst_55366 = cljs.core.async.close_BANG_.call(null,inst_55230);
var state_55416__$1 = (function (){var statearr_55509 = state_55416;
(statearr_55509[(27)] = inst_55366);

(statearr_55509[(28)] = inst_55365);

return statearr_55509;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55416__$1,(11),inst_55231);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__33364__auto__,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__33365__auto__ = null;
var superv$async$state_machine__33365__auto____0 = (function (){
var statearr_55513 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55513[(0)] = superv$async$state_machine__33365__auto__);

(statearr_55513[(1)] = (1));

return statearr_55513;
});
var superv$async$state_machine__33365__auto____1 = (function (state_55416){
while(true){
var ret_value__33366__auto__ = (function (){try{while(true){
var result__33367__auto__ = switch__33364__auto__.call(null,state_55416);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33367__auto__;
}
break;
}
}catch (e55514){if((e55514 instanceof Object)){
var ex__33368__auto__ = e55514;
var statearr_55515_55576 = state_55416;
(statearr_55515_55576[(5)] = ex__33368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55416);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55514;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55577 = state_55416;
state_55416 = G__55577;
continue;
} else {
return ret_value__33366__auto__;
}
break;
}
});
superv$async$state_machine__33365__auto__ = function(state_55416){
switch(arguments.length){
case 0:
return superv$async$state_machine__33365__auto____0.call(this);
case 1:
return superv$async$state_machine__33365__auto____1.call(this,state_55416);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33365__auto____0;
superv$async$state_machine__33365__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33365__auto____1;
return superv$async$state_machine__33365__auto__;
})()
;})(switch__33364__auto__,c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__33480__auto__ = (function (){var statearr_55516 = f__33479__auto__.call(null);
(statearr_55516[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33478__auto___55520);

return statearr_55516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33480__auto__);
});})(c__33478__auto___55520,retries__$1,out_ch,map__55225,map__55225__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
);


return out_ch;
});

superv.async.restarting_supervisor.cljs$lang$maxFixedArity = (1);

superv.async.restarting_supervisor.cljs$lang$applyTo = (function (seq55222){
var G__55223 = cljs.core.first.call(null,seq55222);
var seq55222__$1 = cljs.core.next.call(null,seq55222);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic(G__55223,seq55222__$1);
});


//# sourceMappingURL=async.js.map