// Compiled by ClojureScript 1.9.521 {}
goog.provide('hasch.benc');
goog.require('cljs.core');

/**
 * @interface
 */
hasch.benc.PHashCoercion = function(){};

hasch.benc._coerce = (function hasch$benc$_coerce(this$,md_create_fn,write_handlers){
if((!((this$ == null))) && (!((this$.hasch$benc$PHashCoercion$_coerce$arity$3 == null)))){
return this$.hasch$benc$PHashCoercion$_coerce$arity$3(this$,md_create_fn,write_handlers);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (hasch.benc._coerce[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,md_create_fn,write_handlers);
} else {
var m__10138__auto____$1 = (hasch.benc._coerce["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,md_create_fn,write_handlers);
} else {
throw cljs.core.missing_protocol.call(null,"PHashCoercion.-coerce",this$);
}
}
}
});

hasch.benc.magics = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"binary","binary",-1802232288),new cljs.core.Keyword(null,"inst","inst",645962501),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Keyword(null,"symbol","symbol",-1038572696),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"vector","vector",1902966158),new cljs.core.Keyword(null,"keyword","keyword",811389747),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"literal","literal",1664775605),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"seq","seq",-1817803783),new cljs.core.Keyword(null,"set","set",304602554),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"map","map",1371690461)],[(13),(6),(2),(4),(3),(9),(5),(0),(12),(7),(8),(11),(1),(10)]);
hasch.benc.split_size = (1024);
hasch.benc.max_entropy_byte_count = (32);
hasch.benc.byte_array = (function hasch$benc$byte_array(len){
return cljs.core.into_array.call(null,cljs.core.repeat.call(null,len,(0)));
});
hasch.benc.digest = (function hasch$benc$digest(bytes_or_seq_of_bytes,md_create_fn){
var md = md_create_fn.call(null);
if(cljs.core.seq_QMARK_.call(null,bytes_or_seq_of_bytes)){
var seq__38883_38887 = cljs.core.seq.call(null,bytes_or_seq_of_bytes);
var chunk__38884_38888 = null;
var count__38885_38889 = (0);
var i__38886_38890 = (0);
while(true){
if((i__38886_38890 < count__38885_38889)){
var bs_38891 = cljs.core._nth.call(null,chunk__38884_38888,i__38886_38890);
md.update(bs_38891);

var G__38892 = seq__38883_38887;
var G__38893 = chunk__38884_38888;
var G__38894 = count__38885_38889;
var G__38895 = (i__38886_38890 + (1));
seq__38883_38887 = G__38892;
chunk__38884_38888 = G__38893;
count__38885_38889 = G__38894;
i__38886_38890 = G__38895;
continue;
} else {
var temp__6738__auto___38896 = cljs.core.seq.call(null,seq__38883_38887);
if(temp__6738__auto___38896){
var seq__38883_38897__$1 = temp__6738__auto___38896;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38883_38897__$1)){
var c__10330__auto___38898 = cljs.core.chunk_first.call(null,seq__38883_38897__$1);
var G__38899 = cljs.core.chunk_rest.call(null,seq__38883_38897__$1);
var G__38900 = c__10330__auto___38898;
var G__38901 = cljs.core.count.call(null,c__10330__auto___38898);
var G__38902 = (0);
seq__38883_38887 = G__38899;
chunk__38884_38888 = G__38900;
count__38885_38889 = G__38901;
i__38886_38890 = G__38902;
continue;
} else {
var bs_38903 = cljs.core.first.call(null,seq__38883_38897__$1);
md.update(bs_38903);

var G__38904 = cljs.core.next.call(null,seq__38883_38897__$1);
var G__38905 = null;
var G__38906 = (0);
var G__38907 = (0);
seq__38883_38887 = G__38904;
chunk__38884_38888 = G__38905;
count__38885_38889 = G__38906;
i__38886_38890 = G__38907;
continue;
}
} else {
}
}
break;
}
} else {
md.update(bytes_or_seq_of_bytes);
}

return md.digest();
});
hasch.benc.coerce_seq = (function hasch$benc$coerce_seq(seq,md_create_fn,write_handlers){
var seq_md = md_create_fn.call(null);
var s_38914 = seq;
while(true){
var vec__38911_38915 = s_38914;
var seq__38912_38916 = cljs.core.seq.call(null,vec__38911_38915);
var first__38913_38917 = cljs.core.first.call(null,seq__38912_38916);
var seq__38912_38918__$1 = cljs.core.next.call(null,seq__38912_38916);
var f_38919 = first__38913_38917;
var r_38920 = seq__38912_38918__$1;
seq_md.update(hasch.benc._coerce.call(null,f_38919,md_create_fn,write_handlers));

if(cljs.core.empty_QMARK_.call(null,r_38920)){
} else {
var G__38921 = cljs.core.rest.call(null,s_38914);
s_38914 = G__38921;
continue;
}
break;
}

return seq_md.digest();
});
/**
 * Commutatively coerces elements of collection, seq entries must already be crypto hashes
 *   to avoid collisions in XOR. Takes at maximum 32 bytes into account.
 */
hasch.benc.xor_hashes = (function hasch$benc$xor_hashes(seq){
var len = (function (){var x__9764__auto__ = cljs.core.count.call(null,cljs.core.first.call(null,seq));
var y__9765__auto__ = hasch.benc.max_entropy_byte_count;
return ((x__9764__auto__ < y__9765__auto__) ? x__9764__auto__ : y__9765__auto__);
})();
return cljs.core.reduce.call(null,((function (len){
return (function (acc,elem){
var i_38922 = (0);
while(true){
if((i_38922 < len)){
(acc[i_38922] = ((acc[i_38922]) ^ (elem[i_38922])));

var G__38923 = (i_38922 + (1));
i_38922 = G__38923;
continue;
} else {
}
break;
}

return acc;
});})(len))
,hasch.benc.byte_array.call(null,len),seq);
});
hasch.benc.encode_safe = (function hasch$benc$encode_safe(a,md_create_fn){
if((cljs.core.count.call(null,a) < hasch.benc.split_size)){
var len = cljs.core.long$.call(null,a.length);
var ea = hasch.benc.byte_array.call(null,len);
var i_38924 = (0);
while(true){
if(cljs.core._EQ_.call(null,i_38924,len)){
} else {
var e_38925 = (a[i_38924]);
if(((e_38925 > (0))) && ((e_38925 < (30)))){
(ea[i_38924] = (1));
} else {
}

var G__38926 = (i_38924 + (1));
i_38924 = G__38926;
continue;
}
break;
}

return a.concat(ea);
} else {
return hasch.benc.digest.call(null,a,md_create_fn);
}
});

//# sourceMappingURL=benc.js.map