// Compiled by ClojureScript 1.9.521 {}
goog.provide('hasch.core');
goog.require('cljs.core');
goog.require('hasch.benc');
goog.require('hasch.platform');
hasch.core.uuid4 = hasch.platform.uuid4;
hasch.core.uuid5 = hasch.platform.uuid5;
hasch.core.hash__GT_str = hasch.platform.hash__GT_str;
/**
 * Hash an edn value with SHA-512 by default or a compatible hash function of choice.
 */
hasch.core.edn_hash = (function hasch$core$edn_hash(var_args){
var args39441 = [];
var len__10640__auto___39444 = arguments.length;
var i__10641__auto___39445 = (0);
while(true){
if((i__10641__auto___39445 < len__10640__auto___39444)){
args39441.push((arguments[i__10641__auto___39445]));

var G__39446 = (i__10641__auto___39445 + (1));
i__10641__auto___39445 = G__39446;
continue;
} else {
}
break;
}

var G__39443 = args39441.length;
switch (G__39443) {
case 1:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args39441.length)].join('')));

}
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1 = (function (val){
return hasch.core.edn_hash.call(null,val,cljs.core.PersistentArrayMap.EMPTY);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2 = (function (val,write_handlers){
return hasch.core.edn_hash.call(null,val,hasch.platform.sha512_message_digest,write_handlers);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3 = (function (val,md_create_fn,write_handlers){
return cljs.core.map.call(null,(function (p1__39440_SHARP_){
if((p1__39440_SHARP_ < (0))){
return (p1__39440_SHARP_ + (256));
} else {
return p1__39440_SHARP_;
}
}),hasch.benc.digest.call(null,hasch.benc._coerce.call(null,val,md_create_fn,(function (){var or__9419__auto__ = write_handlers;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})()),md_create_fn));
});

hasch.core.edn_hash.cljs$lang$maxFixedArity = 3;

/**
 * Creates random UUID-4 without argument or UUID-5 for the argument value.
 * 
 *   Optionally an incognito-style write-handlers map can be supplied,
 *   which describes record serialization in terms of Clojure data
 *   structures.
 */
hasch.core.uuid = (function hasch$core$uuid(var_args){
var args39448 = [];
var len__10640__auto___39456 = arguments.length;
var i__10641__auto___39457 = (0);
while(true){
if((i__10641__auto___39457 < len__10640__auto___39456)){
args39448.push((arguments[i__10641__auto___39457]));

var G__39458 = (i__10641__auto___39457 + (1));
i__10641__auto___39457 = G__39458;
continue;
} else {
}
break;
}

var G__39452 = args39448.length;
switch (G__39452) {
case 0:
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__10663__auto__ = (new cljs.core.IndexedSeq(args39448.slice((1)),(0),null));
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10663__auto__);

}
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$0 = (function (){
return hasch.core.uuid4.call(null);
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic = (function (val,p__39453){
var map__39454 = p__39453;
var map__39454__$1 = ((((!((map__39454 == null)))?((((map__39454.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39454.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__39454):map__39454);
var write_handlers = cljs.core.get.call(null,map__39454__$1,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911));
return hasch.core.uuid5.call(null,hasch.core.edn_hash.call(null,val,write_handlers));
});

hasch.core.uuid.cljs$lang$applyTo = (function (seq39449){
var G__39450 = cljs.core.first.call(null,seq39449);
var seq39449__$1 = cljs.core.next.call(null,seq39449);
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic(G__39450,seq39449__$1);
});

hasch.core.uuid.cljs$lang$maxFixedArity = (1);


//# sourceMappingURL=core.js.map