# rails-session-clojure

With this library you can read and write sessions generated by Ruby on Rails
applications in version 4.x.

## Notes about this fork:

- compatiblity with Clojure >= 1.9
- fewer dependencies (target goal is 0 dependencies)
- CI setup via GH actions
- no reflection warnings

## Installation

To install, add the following to your project `:dependencies`:

    [rails-session-clojure "0.2.0"]

## Usage

Secret key base can usually be found in `config/secrets.yml` file
in the Rails app.

```clojure
(def secret-key-base "abcd")
```

Pass in the secret to `create-session-decryptor` and that will return
a function that can be used for decrypting.

```clojure
(def decrypt-session
  (create-session-decryptor secret-key-base))
```

Pull the right cookie value from HTTP headers and pass that to the decryptor.
That will return a map structure corresponding a Ruby Hash that was saved
in the Rails session.

```clojure
(decrypt-session cookie-value)
;; => {"session_id" "cddf4f5a44da3f627fd186d3fc47a7ef",
;;     "foo" "bar",
;;     "_csrf_token" "6qbIbpxXn8sZnGSCV7SgvX+0lhzUXS0J51goFX6mJxY="}
```

If non-standard signature/encryption salts were used, you can pass them in
as additional arguments to `create-session-decryptor`.
In a Rails app you will find those values in
`config.action_dispatch.encrypted_signed_cookie_salt` and
`config.action_dispatch.encrypted_cookie_salt` variables.

```clojure
(def decrypt-session
  (create-session-decryptor secret-key-base custom-signature-salt custom-encryption-salt))
```



## License

Copyright © 2015 Michał Kwiatkowski
Copyright © 2020 Łukasz Korecki


Distributed under the Eclipse Public License either version 1.0 or (at your option) any later version.
